/*------------------------------------------------------------------------------*
 *	File Name: 	OCHttpUtils.h							 						*
 *	Purpose:																   	*
 *  Creation:	06/12/05, AW													*
 *				AW 06/12/05 QA80-7797 ADD_OC_HTTP_UTIL							*
 *  	Copyright Originlab Corp. 2004, 2005,									*
 *	Modification log	                                                        *
 *	EJP 2008-01-09 v8.0782 QA70-10839 OC_CHECK_FOR_UPDATES						*
 *	EJP 2008-07-07 v8.0897 QA80-11788 IMPROVE_CHECK_FOR_UPDATES					*
 *	EJP 2008-07-21 v8.0906 QA80-11788 PREVENT_MULTIPLE_CHECK_FOR_UPDATES		*
 *	EJP 2008-10-27 v8.0962 QA80-6470 ADD_FTP_TO_OC								*
 *	EJP 2008-10-28 v8.0963 QA80-12393 CHK_FOR_UPDATES_NEED_MORE_INFO			*
 *  Sen 09/16/2011 ORG-3816-P1 MAKE_FILE_TRANSFER_SUPPORT_PROGRESS_BOX			*
 *------------------------------------------------------------------------------*/      

#ifndef _OCHTTPUTILS_H
#define _OCHTTPUTILS_H

#ifdef __AFX_H__
	#include "MOCASCRIPT.H"
	#include "oXMLWrapper.h" /// EJP 2008-07-07 v8.0897 QA80-11788 IMPROVE_CHECK_FOR_UPDATES
	#ifdef OCHTTP_UTILS_DLL
		#define OCHTTPUT_API __declspec(dllexport)
	#else
		#define OCHTTPUT_API __declspec(dllimport)
	#endif
	#define TreeNode		OCXmlWrapperBase
	#define string			CString
	#define StringArray		CScriptMocaObject

	extern "C" {
#else
	#define OCHTTPUT_API
	#pragma dll(ohttp)	// Associate all functions below to OCHTTP_Utils.dll which must be in the Origin EXE folder
#endif	//__AFX_H__


enum
{
    HTTP_JOB_CHECK_UPDATE = 1,
    HTTP_JOB_DOWNLOAD_FILE,
	HTTP_JOB_UPLOAD_FILE,
};

enum
{
	HTTP_NO_ERROR=0, 	// operation completed successully.
	HTTP_POST_ERROR,  	// Post operation failed
	HTTP_URL_ERROR, 	// Unmatched URL, like in demo version. Demo version can only make post to graph export page.
	HTTP_ABORT,	 		// User aborted the post process  
};

#define CHECK_FOR_UPDATE_REQ		"UpdateReq8.xml"
#define CHECK_FOR_UPDATE_RET		"UpdateRet8.xml"

/**  
		Start http work, must init pHttpArgu first.
	Arguments:
		dwJobType    = HTTP_JOB_CHECK_UPDATE, start work which sends check ofr updating request and gets result
     				 = HTTP_JOB_DOWNLOAD, start work which download required information from server
		pstrRequest =   request string send to server;
		psaServerFiles = used for download files, address of file on server
		psaLocalFiles =  used for download files, address of file on client
		pnErr = error message, must initialized
		
    Return:
    	Index value(used in httpManager to get the thread), which used in http_stop_job, http_check_job
*/
OCHTTPUT_API int http_start(DWORD dwJobType,  string *pstrRequest, StringArray* psaServerFiles,	
							  StringArray* psaLocalFiles, int* pnErr, LPCSTR lpcszWebUrl = NULL);  /// AW 10/13/05 ADD_SUPPORT_FOR_DIFF_WEBSITE_ADDRESS
/**
		Check if http job status
	Arguments:
		nIndex: Thread index( used in httpManager), got from http_start_job
		lpnKBytes = to received number of kbytes finished
	Return:
		true: http job is down.
		false: http job is still alive
*/
OCHTTPUT_API BOOL http_is_finished(int nIndex, int* pnJobPos, string* pstrMsg);

/**
		Force to abort http work		
	Arguments:
		nIndex: Thread index( used in httpManager), got from http_start_job
*/
OCHTTPUT_API BOOL http_abort(int nIndex);

/**
		Release space used by the job information
	Arguments:
		nIndex: Thread index( used in httpManager), got from http_start_job
	Return:
		TRUE: success, FALSE, wrong job index
*/
OCHTTPUT_API BOOL http_release_info(int nIndex);
/**
		Get result string, this is used in the job like HTTP_JOB_CHECK_UPDATE
	Arguments:
		nIndex: Thread index( used in httpManager), got from http_start_job
*/
OCHTTPUT_API LPCSTR http_get_str_result(int nIndex);

/**
		Get message string
	Arguments:
		nIndex: Thread index( used in httpManager), got from http_start_job
*/
OCHTTPUT_API LPCSTR http_get_str_msg(int nIndex);

/**
		Clean work at the end of http job
	Arguments:
     	dwJobType  	= HTTP_JOB_CHECK_UPDATE, start work which sends check ofr updating request and gets result
     				= HTTP_JOB_DOWNLOAD, start work which download required information from server
    	nErrorCode  = Get from  http_start_job, or set as HTTP_ABORT when call http_abort_job.
	Return: 0 when it is OK, otherwise error codes for displaying error (maybe directly return error string?)
*/
//OCHTTPUT_API int http_cleanup(DWORD dwJobType, int nErrorCode = 0);

/**
		call check for update job.
	Arguments:
		lpcszRequest:	request string;
		pstrResult:		result get from server;
		pstrMsg:		Megssage to show if the job is done successfully.
		hWnd:			Current Origin window used as parent of progress bar
	Return:
		OHTTP_SUCCESS done well, otherwise has error check strMsg.
*/
OCHTTPUT_API int http_check_update(LPCSTR lpcszRequest, string* pstrResult, string* pstrMsg, HWND hWnd);

/**
		Download required objects
	Arguments:
		psaDownload:	string array which list download files
		pstrMsg:		Megssage to show if the job is done successfully.
		hWnd:			Current Origin window used as parent of progress bar
	Return:
		OHTTP_SUCCESS done well, otherwise has error check strMsg.
*/
OCHTTPUT_API int http_Download_files(StringArray* psaServerFiles, StringArray* psaLocalFiles, string* pstrMsg, DWORD nFilesSize, HWND hWnd);
 
/// EJP 2008-01-09 v8.0782 QA70-10839 OC_CHECK_FOR_UPDATES
#define HTTP_SHOW_PROGRESS_BAR		0x0001 // http_get_str, http_get_file, http_get_files
#define HTTP_STOP_ON_ERROR			0x0002 // http_get_files 
#define HTTP_GETTING_PATCH			0x0004 // http_get_file, http_get_files (set lParam	to patch file index)
#define HTTP_DO_IN_THREAD			0x1000 // http_get_file, http_get_files

OCHTTPUT_API int http_post(LPCSTR lpcszURL, LPCSTR lpcszMsg, string* pstrResult, BOOL bGetResult);
OCHTTPUT_API int http_get_str(LPCSTR lpcszURL, string* pstrResult, HWND hwndParent = NULL, WORD wCtrl = 0, DWORD dwMaxTime = 0);
//---- CPY 8/30/10 ORG-763-S1 RESPONSE_TIMEOUT_NEEDED_FOR_DYNAMIC_URL
//OCHTTPUT_API int http_get_file(LPCSTR lpcszURL, LPCSTR lpcszFileName, HWND hwndParent = NULL, WORD wCtrl = 0, DWORD dwMaxTime = 0);
OCHTTPUT_API int http_get_file(LPCSTR lpcszURL, LPCSTR lpcszFileName, HWND hwndParent = NULL, WORD wCtrl = 0, int nMaxTime = 0, int nResponseTimeout = 30);
//----
OCHTTPUT_API int http_get_files(StringArray* psaURLs, StringArray* psaFileNames, HWND hwndParent = NULL, WORD wCtrl = 0, DWORD dwMaxTime = 0, DWORD lParam = 0);
/// end OC_CHECK_FOR_UPDATES

/// EJP 2008-07-07 v8.0897 QA80-11788 IMPROVE_CHECK_FOR_UPDATES
/**
	Parameters:
		tnUpdates = [input] tree containing the updates to be downloaded.
		hwndParent = [input] window handle to be used as the parent of the progress windows.
		wCtrl = [input] optional controls, see HTTP_* defines.
		dwMaxTime = [input] the maximum time to allow for the download to complete, default of zero indicates no time limit
	Return:
		zero for success, non-zero for error.
*/
OCHTTPUT_API int http_get_updates(TreeNode* tnUpdates, HWND hwndParent = NULL, WORD wCtrl = 0, DWORD dwMaxTime = 0);
/// end IMPROVE_CHECK_FOR_UPDATES

/// EJP 2008-07-21 v8.0906 QA80-11788 PREVENT_MULTIPLE_CHECK_FOR_UPDATES
/**
	Parameters:
	Return:
		non-zero if getting updates is already running else zero
*/
OCHTTPUT_API BOOL http_is_getting_updates();
/// end PREVENT_MULTIPLE_CHECK_FOR_UPDATES


/// EJP 2008-10-27 v8.0962 QA80-6470 ADD_FTP_TO_OC
typedef struct {
	char szHost[MAXFULLPATH];	// FTP server/host name, example: ftp.domain.com
	int nPort;					// FTP port, 21 is the common FTP port
	char szLoginName[MAXLINE];	// Account user name
	char szPassword[MAXLINE];	// Account password
	char szAccount[MAXLINE];
	char szPath[MAXFULLPATH];	// Path to enter on server after a successful login
} OFTPLOGIN;

/**
		Get a list of files from an FTP server.
	Parameters:
		ftpLogin = [input] an OFTPLOGIN structure.
		psaRemoteFiles = [output] string array of the files found
	Return:
		zero for success, non-zero for error.
*/
OCHTTPUT_API int ftp_dir(OFTPLOGIN* ftpLogin, StringArray* psaRemoteFiles);

/**
		Delete a file on an FTP server.
	Parameters:
		ftpLogin = [input] an OFTPLOGIN structure.
		pcszRemoteFile = [input] name of file to be deleted
	Return:
		zero for success, non-zero for error.
*/
OCHTTPUT_API int ftp_del(OFTPLOGIN* ftpLogin, LPCSTR pcszRemoteFile);

/**
		Delete multiple files on an FTP server.
	Parameters:
		ftpLogin = [input] an OFTPLOGIN structure.
		psaRemoteFiles = [input] array containing names of files to be deleted
	Return:
		zero for success, non-zero for error.
*/
OCHTTPUT_API int ftp_del_multi(OFTPLOGIN* ftpLogin, StringArray* psaRemoteFiles);

/**
		Download a file from an FTP server.
	Parameters:
		ftpLogin = [input] an OFTPLOGIN structure.
		pcszRemoteFile = [input] name of file to be downloaded
		pcszLocalFile = [input] path and name of target file
		bBinary = [input] upload using binary mode or ASCII mode
	Return:
		zero for success, non-zero for error.
*/
/// Sen 09/16/2011 ORG-3816-P1 MAKE_FILE_TRANSFER_SUPPORT_PROGRESS_BOX
//OCHTTPUT_API int ftp_get(OFTPLOGIN* ftpLogin, LPCSTR pcszRemoteFile, LPCSTR pcszLocalFile, bool bBinary = true);
OCHTTPUT_API int ftp_get(OFTPLOGIN* ftpLogin, LPCSTR pcszRemoteFile, LPCSTR pcszLocalFile, bool bBinary, int nMinSizeToShowProgressBox = 0);
/// End MAKE_FILE_TRANSFER_SUPPORT_PROGRESS_BOX

/**
		Upload a file to an FTP server.
	Parameters:
		ftpLogin = [input] an OFTPLOGIN structure.
		pcszLocalFile = [input] path and name of file to be uploaded
		bBinary = [input] upload using binary mode or ASCII mode
	Return:
		zero for success, non-zero for error.
*/
/// Sen 09/16/2011 ORG-3816-P1 MAKE_FILE_TRANSFER_SUPPORT_PROGRESS_BOX
//OCHTTPUT_API int ftp_put(OFTPLOGIN* ftpLogin, LPCSTR pcszLocalFile, bool bBinary = true);
OCHTTPUT_API int ftp_put(OFTPLOGIN* ftpLogin, LPCSTR pcszLocalFile, bool bBinary, int nMinSizeToShowProgressBox = 0);
/// End MAKE_FILE_TRANSFER_SUPPORT_PROGRESS_BOX

/**
		Upload multiple files to an FTP server.
	Parameters:
		ftpLogin = [input] an OFTPLOGIN structure.
		psaLocalFiles = [input] array containing paths and names of files to be uploaded
		bBinary = [input] upload using binary mode or ASCII mode
	Return:
		zero for success, non-zero for error.
*/
OCHTTPUT_API int ftp_put_multi(OFTPLOGIN* ftpLogin, StringArray* psaLocalFiles, bool bBinary = true);
/// end ADD_FTP_TO_OC

/// EJP 2008-10-28 v8.0963 QA80-12393 CHK_FOR_UPDATES_NEED_MORE_INFO
OCHTTPUT_API BOOL http_get_updates_url(string* pstrURL, int nCtrl);
/// end CHK_FOR_UPDATES_NEED_MORE_INFO


#ifdef __AFX_H__
	}
#endif	//__AFX_H__

#endif //_OCHTTPUTILS_H
