/*------------------------------------------------------------------------------*
 * File Name:Normality.cpp	 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file to implementing Normality Test operation		*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Echo 8/24/05 ERROR_ALGORITHM_USED											*
 * Jim 11/17/05 P_VALUE_NAME_CONVENTION                                         * 
 * Jim 01/17/06 CREATE_PLOTS_BRANCH_IN_MAIN_NODES								*
 * Max 04/25/06 QA70-7031-P6&P7 REMOVE_GET_MISSING_DATA_OPTION					*
 * Alex 06/14/06 SET_NORMALITYTEST_BRANCH_ALL_OPEN                              *
 * Jasmine 09/07/06 ADD_FOOTNOTE												*
 * Jasmine 09/15/06 SETTING_CHANGE_AND_ADD_FOOTNOTE								*
 *	CPY 10/14/06 SEPARATE_OUT_OPERATION_BASE_INTO_SEPARATE_HEADER				*
 *	Echo 2/12/07 ADD_ERROR_REPORT												*
 *  Iris 04/12/2007 FIX_BOX_CHART_IS_EMPTY_IF_CHECKED_PLOT_ALL_PLOTS_IN_ONE_GRAPH
 *	Cheney 2007-6-7 SHOULD_CHECK_EVENT_ID_IN_EVENT_FUNC							*
 *	Max 6/8/07 CORRECT_RULE_FOR_CONCLUSION_IN_FOOTNOTE							*
 *	Echo 8/7/07 QA-7031-P4 V8.0676 VAR_NOT_LS_0									*
 *	Arvin 11/10/07 XOP_NEED_SUPPORT_CHANGE_FUNCTION								*
 *	Folger 12/10/07 CLEAN_NEGATIVE_ERROR_MESSAGES								*
 *	Sophy 12/17/2008 v8.0987d  QA80-12784 ADD_BINNING_CONTROL_FOR_HISTOGRAM_PLOT_IN_STATS_TOOLS
 *  Iris 4/09/2009 QA80-12784-P2 IMPROVE_HISTOGRAM_CONFIG_BRANCH				*
 *  Iris 5/18/2009 FIX_SHOW_NO_DATA_ERR_WHEN_CHOOSE_TWO_INCONTINUITY_COL		*
 *  Iris 8/05/2009 QA80-14808 HUGE_FOOTNOTE_IN_REPORT_SHEET_CAUSE_ORIGIN_NOT_ENERGETIC
 *  Iris 10/28/2009 QA81-14546 CHANGE_GUI_REPORT_TABLE_LABEL					*
 *  Iris 1/19/2010 QA81-14988-P2 FIX_EMPTY_NORMALITY_TABLE_WHEN_UNCHECK_ALL		*
 *  Iris 6/17/2010 ORG-289-P2 FIX_NORMALITY_TEST_GRAPH_ARRANGMENT_AUTO_CHECKBOX_NOT_WORK
 *	Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL						*
 *	Kyle 12/10/2010 ORG-1720-P1 TABLE_BITS_USE_UINT_INSTEAD_OF_STRING_TO_PREVENT_DIGITS_LOST	
 *	Zeck 7/21/2011 ORG-3228-S1 SUPPORT_GROUPING									*
 *	Zeck 7/21/2011 ORG-3228-S3 REPLACE_FOOTNOTE_WITH_DECISION_COLUMN			*
 *	Zeck 8/02/2011 ORG-3228-S2 SHOW_N_MISSING_IN_DESCRIPTIVE_TABLE				*
 *	Zeck 08/03/2011 ORG-3228-S4 NORMALITY_TEST_ADD_THREE_MORE_TESTS				*
 * 	Zech 08/10/2011 NO_NEED_TO_SHOW_DUPLICATED_COLUMNS							*
 *	Zech 08/12/2011 ORG-3228-P2 UNITE_THE_NAME_OF_PROBABILITY_VALUE_TO_P_VALUE	*
 *	Zech 08/12/2011 ORG-3228-P3 DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST*
 *	Zech 08/15/2011 ORG-3228-P1 SUPPORT_MULTIPLE_GROUPING						*
 *	Zech 11/04/2011 ORG-3228-P6 NO_NEED_TO_DISPLAY_PROB_VALUE_HINT_INFO			*
 *	Zech 11/04/2011 ORG-3228-P6 USING_PROPER_LABEL_FOR_DAgostino_K_squared_TEST	*
 *	Zech 11/07/2011 ORG-3228-P11 PUT_NORMALITY_TEST_DATA_WORKSHEET_INTO_THE_SAME_PAGE
 *	Zech 11/09/2011 ORG-3228-P12 DISPLAY_LABEL_AND_FOOTNOTE_CORRECTLY_WHEN_CANNOT_DRAW_CONCLUSION
 *  Iris 11/16/2011 ORG-4374-P1 FIX_OLD_DATA_PLOT_NOT_BE_REMOVED_WHEN_CHANGED_DATA_IN_CHANGE_PARAMETER
 *	Sophy 11/17/2011 ORG-4402-P1 BRING_BACK_FOOTNOTE_FOR_NORMALITYTEST			*
 *	Zech 12/09/2011 ORG-4559-P1 FIX_FOOTNOTE_CONCLUSION							*
 *	Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE					*
 *	Zech 12/23/2011 ORG-4669-P2 IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
 *	Sophy 11/17/2011 ORG-4402-P1 BRING_BACK_FOOTNOTE_FOR_NORMALITYTEST			*
 *	Folger 05/16/2012 ORG-5592-S3 ADD_DATA_IDENTIFIER_FOR_STATS_TOOLS			*
 *	Folger 06/01/2012 ORG-5592-S1 SHOW_DATA_IDENTIFIER_FOR_FLAT_SHEET			*
 *	Folger 06/06/2012 ORG-5906-P1 NORMALITY_TEST_TOO_SLOW_FOR_LARGE_DATA		*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h> 
////////////////////////////////////////////////////////////////////////////////////

#include <event_utils.h>
#include <report_utils.h>
#include <o8dlg.h>

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#ifdef _FOR_SMART_LOADING_ONLY
#include "wksOperation.h" //---- CPY 10/14/06 SEPARATE_OUT_OPERATION_BASE_INTO_SEPARATE_HEADER
#include <analysis_utils.h>
#include <stats_utils.h>
#include "stats_guis.h"
#include "stats_operations.h"
#include "nlsf_utils.h" /// Iris 7/08/2008 CLEAN_DUP_CALC_AVE_DATA_CODE_IN_NLSF_PREVIEW_AND_OP
#include "graph_utils.h" //---- Iris 11/19/2008 v8.0975 QA80-12591-P2 FIX_APPARENT_FIT_ON_GRAPH_CUSTOM_RANGE_GET_INCORRECT_X
#endif

#include <xfutils.h>
#include "StatsOpCommon.h" 
#include "StatsOpBase.h"
#define FOOTNOTE_STOP_ATTRIB	"FootNoteStop" /// Iris 8/05/2009 QA80-14808 HUGE_FOOTNOTE_IN_REPORT_SHEET_CAUSE_ORIGIN_NOT_ENERGETIC

/// Zech 12/23/2011 ORG-4669-P2 IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
#define CONCLUSION_NUM_ATTRIB			"ConclusionNum"
#define CONCLUSION_TEXT_ATTRIB			"ConclusionText"

#define CONCLUSION_FOOTNOTE_LIMIT		10
/// END IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY

#define STR_STATS_LABEL					_L("Statistic")
#define STR_P_VALUE_LABEL				_L("p-value")

#define STR_REJECT_NORMALITY			_L("Reject normality")			
#define STR_NOT_REJECT_NORMALITY		_L("Can't reject normality")
////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

///Echo 2/12/07 ADD_ERROR_REPORT
static int normalitytest_event1(TreeNode& tr, int nRow, int nEvent, DWORD& dwEnables, LPCSTR lpcszNodeName, WndContainer& getNCountainer, string& strAux, string& strErrMsg)
{
	DECLARE_BUTTON_ENABLES   //support more buttons enable/disable
		
	/// Iris 4/09/2009 QA80-12784-P2 IMPROVE_HISTOGRAM_CONFIG_BRANCH
	/*
	///Sophy 12/19/2008 v8.0987d  QA80-12784 ADD_BINNING_CONTROL_FOR_HISTOGRAM_PLOT_IN_STATS_TOOLS fix bin config not updated when change input data
	string strNodeName(lpcszNodeName);
	if ( strNodeName.CompareNoCase("X") == 0 )
	{
		TreeNode trHistogramConfig = tr.Output.GetNode(STR_HISTOGRAM_CONFIG_TAGNAME);
		_update_histogram_plot_bin_configuration_by_input(tr, trHistogramConfig);
	}
	///end ADD_BINNING_CONTROL_FOR_HISTOGRAM_PLOT_IN_STATS_TOOLS
	*/
	_update_histogram_bin_info_in_event1(tr, lpcszNodeName, nEvent);
	///end IMPROVE_HISTOGRAM_CONFIG_BRANCH	
	
	/// Iris 11/16/2011 ORG-4374-P1 FIX_OLD_DATA_PLOT_NOT_BE_REMOVED_WHEN_CHANGED_DATA_IN_CHANGE_PARAMETER
	if( is_change_parameter(tr) && nRow > 0 )
	{
		TreeNode trNodeUpdate = tree_get_node(tr, nRow);
		if ( trNodeUpdate && (trNodeUpdate.tagName == "X" || trNodeUpdate.tagName == "F" ) )
		{
			foreach(TreeNode trGraph in tr.Plots.Children)
			{			
				trGraph.SetAttribute(STR_RESET_GRAPH_ATTRIB, 1);
			}
		}
	}
	///End FIX_OLD_DATA_PLOT_NOT_BE_REMOVED_WHEN_CHANGED_DATA_IN_CHANGE_PARAMETER
	
	///Cheney 2007-6-7 SHOULD_CHECK_EVENT_ID_IN_EVENT_FUNC	
	///Cheney 2007-7-6 SHOULD_CHECK_ERR_WHEN_THEME_CHANGE_ALSO
	//if(GETNE_ON_VALUE_CHANGE == nEvent  || GETNE_ON_INIT == nEvent)
	if(GETNE_ON_VALUE_CHANGE == nEvent  || GETNE_ON_INIT == nEvent || GETNE_ON_THEME == nEvent)
	///end SHOULD_CHECK_ERR_WHEN_THEME_CHANGE_ALSO
	///end SHOULD_CHECK_EVENT_ID_IN_EVENT_FUNC
	{
		///------ Folger 05/03/2012 ORG-5592-S3 ADD_DATA_IDENTIFIER_FOR_STATS_TOOLS
		TreeNode trRow;
		if ( nRow >= 0 )
			trRow = tree_get_node(tr, nRow);
		
		bool bInputDataChange = is_input_data_change(trRow, tr);
		///------ End ADD_DATA_IDENTIFIER_FOR_STATS_TOOLS
		
		int nErr = check_1_data(tr.InputData.Range1.X, true);
		
		int nNumData = 0; /// Iris 6/17/2010 ORG-289-P2 FIX_NORMALITY_TEST_GRAPH_ARRANGMENT_AUTO_CHECKBOX_NOT_WORK
		
		/// Iris 5/18/2009 FIX_SHOW_NO_DATA_ERR_WHEN_CHOOSE_TWO_INCONTINUITY_COL
		// check_1_data cannot correctly check with unknown reason, so add this check.
		DataRange rData;
		rData.Create();
		rData.SetTree(tr.InputData.Range1, DRTREE_ONE_DATA);
		if( rData )
		{
			int nDataRules;
			if( tr.InputData.GetAttribute(STR_DATA_RULES_ATTRIB, nDataRules) )
			{
				/// Iris 6/17/2010 ORG-289-P2 FIX_NORMALITY_TEST_GRAPH_ARRANGMENT_AUTO_CHECKBOX_NOT_WORK
				//nErr = rData.GetNumData(nDataRules) > 0 ? CER_NO_ERROR : CER_COL_NUM_TOO_FEW_EX;
				nNumData = rData.GetNumData(nDataRules);
				nErr = nNumData > 0 ? CER_NO_ERROR : CER_COL_NUM_TOO_FEW_EX;
				///End FIX_NORMALITY_TEST_GRAPH_ARRANGMENT_AUTO_CHECKBOX_NOT_WORK
			}
		} 
		///end FIX_SHOW_NO_DATA_ERR_WHEN_CHOOSE_TWO_INCONTINUITY_COL
		
		/// Iris 6/17/2010 ORG-289-P2 FIX_NORMALITY_TEST_GRAPH_ARRANGMENT_AUTO_CHECKBOX_NOT_WORK
		TreeNode trGraphNumCols = OP_GUI_GRAPH_ARRANGEMENT_NODE(tr).GraphNumCols;
		if( trGraphNumCols )
		{
			if( 1 == octree_get_auto_support( &trGraphNumCols ) )
			{
				TreeNode trPlotInOne = OP_GUI_GRAPH_ARRANGEMENT_NODE(tr).PlotInOneGraph;
				bool bPlotInOne = trPlotInOne && trPlotInOne.Show && trPlotInOne.nVal;
				trGraphNumCols.nVal = get_report_graph_num_cols( nNumData, 0, bPlotInOne );
			}
		}
		///End FIX_NORMALITY_TEST_GRAPH_ARRANGMENT_AUTO_CHECKBOX_NOT_WORK
		
		if ( CER_NO_ERROR == nErr ) ///------ Folger 05/16/2012 ORG-5592-S3 ADD_DATA_IDENTIFIER_FOR_STATS_TOOLS
		{
			///------ Folger 05/03/2012 ORG-5592-S3 ADD_DATA_IDENTIFIER_FOR_STATS_TOOLS
			if ( bInputDataChange || GETNE_ON_INIT == nEvent || GETNE_ON_THEME == nEvent )
			{
				op_update_data_identifiers(tr, tr.InputData);
			}
			///------ End ADD_DATA_IDENTIFIER_FOR_STATS_TOOLS

			/// Zeck 08/03/2011 ORG-3228-S4 NORMALITY_TEST_ADD_THREE_MORE_TESTS
			/*
			/// Iris 1/19/2010 QA81-14988-P2 FIX_EMPTY_NORMALITY_TABLE_WHEN_UNCHECK_ALL
			if( tree_is_true(tr.OptionBranch.GetNode("shap-wilk")) + 
			tree_is_true(tr.OptionBranch.kolm) + 
			tree_is_true(tr.OptionBranch.lilliefors) == 0 )		
			nErr = NORMALITY_TEST_NO_OUTPUT;
			///End FIX_EMPTY_NORMALITY_TABLE_WHEN_UNCHECK_ALL
			*/
			if( tree_is_true(tr.OptionBranch.GetNode("shap-wilk")) + 
				tree_is_true(tr.OptionBranch.kolm) + 
				tree_is_true(tr.OptionBranch.lilliefors) +
				tree_is_true(tr.OptionBranch.Anderson) +
				tree_is_true(tr.OptionBranch.DKsquared) +
				tree_is_true(tr.OptionBranch.Chen) == 0 )		
				nErr = NORMALITY_TEST_NO_OUTPUT;
			/// END NORMALITY_TEST_ADD_THREE_MORE_TESTS
		}
		
		///Echo 8/7/07 QA-7031-P4 V8.0676 VAR_NOT_LS_0
		TreeNode trKolm = tr.OptionBranch.kolm;
		if (nErr == CER_NO_ERROR && trKolm.Paras.nVal == 1 && trKolm.Variance.dVal <= 0)
		{
			nErr = CER_VAR_LS_0;
		}
		///END VAR_NOT_LS_0
		///Sophy 4/11/2008 CHECK_REPORT_DATA_BOOK_NAME_DIFFERENT
		string strRet = "";
		if( CER_NO_ERROR == nErr )
		{
			nErr = check_report_book_curve_book( tr, strRet );
		}
		///end CHECK_REPORT_DATA_BOOK_NAME_DIFFERENT
		
		//--- Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL
		if(!check_sig_level(tr.OptionBranch.alpha.dVal))
		{
			nErr = CER_INVALID_SIG_LEV;
		}
		//--- end USER_CAN_SET_SIGNIFICANCE_LEVEL
		
		///Sophy 12/17/2008 v8.0987d  QA80-12784 ADD_BINNING_CONTROL_FOR_HISTOGRAM_PLOT_IN_STATS_TOOLS
		if ( CER_NO_ERROR == nErr )
		{
			//if ( !check_histogram_config_bin_min_max(tr) )
				//nErr = CER_MIN_MAX;
			nErr = _check_histogram_plot_bin_configuration(tr, strRet);
		}
		///end ADD_BINNING_CONTROL_FOR_HISTOGRAM_PLOT_IN_STATS_TOOLS
		
		if (nErr != CER_NO_ERROR)
		{
			bOKEnable = false;
			strErrMsg = nErr;
			if (nErr == CER_COL_NUM_TOO_FEW_EX)
				strErrMsg += ":" + 1;
			///Sophy 4/14/2008 ADD_OUTPUT_ERR_STRING
			else if( !strRet.IsEmpty() )
			{
				strErrMsg = nErr;
				strErrMsg += ":" + strRet;  
			}
			///end ADD_OUTPUT_ERR_STRING
		}
	}
	return true;

}
///end ADD_ERROR_REPORT

/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
struct NormalityTestInfoMore
{
	vector<string> *pvsFactors;
};
/// END ADD_GROUPING_INFO_TO_FOOTNOTE

class OC_REGISTERED NormalityTest : public StatsOpBase
{
///Arvin 11/10/07 XOP_NEED_SUPPORT_CHANGE_FUNCTION	
public:
	//Need call this method from oc code, so move it to public session
	void    ClearOutputTables(TreeNode& trOperation)
	{
		StatsOpBase::ClearOutputTables(trOperation);
		
		TreeNode 	trNormality, trTable;
		trNormality = trOperation.Calculation.NormalityTest;
		if(trNormality)
		{
			trTable = trNormality.SW;
			if(trTable)
				trTable.Reset(true);
			
			trTable = trNormality.LF;
			if(trTable)
				trTable.Reset(true);
			
			trTable = trNormality.KS;
			if(trTable)
				trTable.Reset(true);
		}
	}
///end XOP_NEED_SUPPORT_CHANGE_FUNCTION

protected:
	BOOL Construct(TreeNode& trOperation, int nOption = 0)
	{
		if( WksReportOperation::Construct(trOperation, nOption) )
		{
		
			constructAddNormalityTestReport(trOperation);
			
			TreeNode	trGUI = ConstructAddGUI(trOperation);
			
			ConstructNormalityGUITree(trGUI, nOption);
			
			DWORD dwOptions = REPORT_ARRANGE_GRAPHS_TO_COLS | REPORT_PLOT_ALL_PLOTS_IN_ONE_GRAPH;
			ConstructAddReportCommon(trOperation, dwOptions, IDST_OUTPUT_RESULTS_OPTIONS, true);
			
			FilterStatsGUI(trOperation);    ///Jim 01/17/06 v8.0358 CREATE_PLOTS_BRANCH_IN_MAIN_NODES
			
			///Sophy 12/17/2008 v8.0987d  QA80-12784 ADD_BINNING_CONTROL_FOR_HISTOGRAM_PLOT_IN_STATS_TOOLS add for stats tool(stats column, normality test
			AddHistogramPlotConfigBranch(trOperation, trOperation.GUI.Output);
			///end ADD_BINNING_CONTROL_FOR_HISTOGRAM_PLOT_IN_STATS_TOOLS

			return TRUE;
		
		}
		return FALSE;
	}
	
	// virtual 
	// fisher 11/16/2007 ADD_MAP_ID_TO_CHM
	int GetHelpID()
	{
		return IDD_XF_NormalityTest;
	}
	
	//virtual 
	string 	GetResultBookName(TreeNode& trGUI) { return E_STR_NORMALITY_TEST_REPORT_TABLE_BOOK_SHORT_NAME; } /// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME

	/// Iris 06/07/2007 v8.0635 FIX_APPEND_MORE_ONE_FOOTNOTE_AFTER_DO_CHANGE_PARAMETERS
	//virtual
	///Arvin 11/10/07 XOP_NEED_SUPPORT_CHANGE_FUNCTION	
	//Need call this method from oc code, so move it to public session
	//void    ClearOutputTables(TreeNode& trOperation)
	//{
		//StatsOpBase::ClearOutputTables(trOperation);
		//
		//TreeNode 	trNormality, trTable;
		//trNormality = trOperation.Calculation.NormalityTest;
		//if(trNormality)
		//{
			//trTable = trNormality.SW;
			//if(trTable)
				//trTable.Reset(true);
			//
			//trTable = trNormality.LF;
			//if(trTable)
				//trTable.Reset(true);
			//
			//trTable = trNormality.KS;
			//if(trTable)
				//trTable.Reset(true);
		//}
	//}
	///end XOP_NEED_SUPPORT_CHANGE_FUNCTION
	///end FIX_APPEND_MORE_ONE_FOOTNOTE_AFTER_DO_CHANGE_PARAMETERS
	
	//virtual 
	int ConstructGraphNumber()
	{
		return 2;
	}
	
	//virtual 
	string GetClassName() {return "NormalityTest";}
	
	///Cheney 2007-9-28 MODIFY_TITLE_AS_MAX_SAID
	//virtual
	string GetAnalysisName(int nOption)
	{
		return _L("Normality Test");
	}
	///end MODIFY_TITLE_AS_MAX_SAID
	//----- CPY 9/30/07 FIX_CHENEY_MODIFY_TITLE_AS_MAX_SAID
	//virtual 
	string GetDlgDescription(int nOption)
	{
		return _L("Perform Normality Test");
	}
	//-----
	
	/// Iris 10/28/2009 QA81-14546 CHANGE_GUI_REPORT_TABLE_LABEL
	/*
	/// Iris 4/17/2008 SPECIAL_REPORT_TABLE_NAME_FOR_DIFF_TOOLS
	//virtual	
	string	GetReportTableGUIName(TreeNode& trGUI)
	{
		return STR_OUTPUT_NORMALITY_TEST_REPORT_TABLE;
	}
	///end SPECIAL_REPORT_TABLE_NAME_FOR_DIFF_TOOLS
	*/
	///end CHANGE_GUI_REPORT_TABLE_LABEL
	
	//virtual
	/// Zech 08/15/2011 ORG-3228-P1 SUPPORT_MULTIPLE_GROUPING
	void UpdateDataSourceInReportingHeader(TreeNode& trOp, vector<string>&vstrFactors, Worksheet& wksInputData, int nIndex, int numSubRanges = 0, DWORD dwRules = 0) ///Arvin 07/19/07 v8.0662 WRONG_INPUT_DATA_TABLE_FOR_ROCCURVE
	{
		if(nIndex != 0)
			return;
		
		///Sophy 7/10/2008 FIX_WRONG_INPUT_INFORMATION_WHEN_COMBINE_AS_SINGLE_DATASET_WHILE_STATS_ON_COLUMN
		//reset dwRules to care the combine bit. 
		dwRules = GetDataRules( trOp );
		///end FIX_WRONG_INPUT_INFORMATION_WHEN_COMBINE_AS_SINGLE_DATASET_WHILE_STATS_ON_COLUMN
		string strDataLabel= _L("Data"), strFactorLabel = _L("Group");
		AddMultiInputDataWithFactorSourceTable(trOp, strDataLabel, strFactorLabel, dwRules); 
	}
	/// END SUPPORT_MULTIPLE_GROUPING

	//virtual 
	DWORD	GetDataRules(const TreeNode& trOp, bool bIgnoreCombineInfo = false ) 
	{
		/// Max 04/25/06 QA70-7031-P6&P7 REMOVE_GET_MISSING_DATA_OPTION		
		//DWORD dwRet =  DRR_GET_MISSING|DRR_NO_WEIGHTS;
		///Jasmine 09/15/06 SETTING_CHANGE_AND_ADD_FOOTNOTE
		//Max said Normality Test not support grouping now
		//DWORD dwRet = DRR_NO_WEIGHTS;	
		
		///Zeck 7/21/2011 ORG-3228-S1 SUPPORT_GROUPING
		//DWORD dwRet = DRR_NO_WEIGHTS | DRR_NO_FACTORS;	
		DWORD dwRet = DRR_NO_WEIGHTS;
		///END SUPPORT_GROUPING
		
		/// Zeck 8/02/2011 ORG-3228-S2 SHOW_N_MISSING_IN_DESCRIPTIVE_TABLE
		dwRet |= DRR_GET_MISSING ;
		/// END SHOW_N_MISSING_IN_DESCRIPTIVE_TABLE
		
		///End SETTING_CHANGE_AND_ADD_FOOTNOTE
		/// END QA70-7031-P6&P7 REMOVE_GET_MISSING_DATA_OPTION		
		
		return CheckDataRules(trOp, dwRet, bIgnoreCombineInfo);
	}
	
	//virtual 
	int	ReportGetPicureIndexFromDataIndex(int nGraphIndex, int nDataIndex)
	{
		switch( ReportGetPlotTypeFromGraphIndex(nGraphIndex) )
		{
		case IDM_PLOT_BOX:
			return nDataIndex;
			
		case IDM_PLOT_HISTOGRAM_TYPE:
			return nDataIndex; 
		}
		
		return -1;
	}
	
	//virtual 
	int	ReportGetPlotTypeFromGraphIndex(int nGraphIndex)
	{
		switch( nGraphIndex )
		{
		/// Iris 04/12/2007 FIX_BOX_CHART_IS_EMPTY_IF_CHECKED_PLOT_ALL_PLOTS_IN_ONE_GRAPH
		/*
		case 0:
			return IDM_PLOT_BOX;
			
		case 1:
			return IDM_PLOT_HISTOGRAM_TYPE;
		*/
		case GRAPH_STATS_HISTOGRAM:
			return IDM_PLOT_HISTOGRAM_TYPE;
			
		case GRAPH_STATS_BOX:
			return IDM_PLOT_BOX;
		///end FIX_BOX_CHART_IS_EMPTY_IF_CHECKED_PLOT_ALL_PLOTS_IN_ONE_GRAPH
		}
		
		return -1;
	}
	
	/// Iris 11/22/2011 ORG-4373-P1 KEEP_MISSING_VALUE_FACTOR
	//virtual
	bool	CalcMultiData(TreeNode& trOp, DataRange& dr, int &nTotalNumData, int nExeMode, DWORD dwExecCntrl = 0)
	{
		///Sophy 12/26/2011 ORG-4710-P1 PROPER_ACCESS_TREENODE_WHEN_RECALC_OLD_PROJECT
		//if( (OEXEM_ON_AUTOUPDATE_MANUAL == nExeMode || OEXEM_ON_AUTOUPDATE_TASK == nExeMode) && !trOp.GUI.InputData.Range1.F.IsEmpty() )
		TreeNode trFF = trOp.GUI.InputData.Range1.F;
		BOOL bHasFactor = trFF && !trFF.IsEmpty();
		if( (OEXEM_ON_AUTOUPDATE_MANUAL == nExeMode || OEXEM_ON_AUTOUPDATE_TASK == nExeMode) && bHasFactor )
		///end PROPER_ACCESS_TREENODE_WHEN_RECALC_OLD_PROJECT
		{
			trOp.GUI.Output.SetAttribute(STR_RESET_GRAPH_ATTRIB, 1);
		}
			
		return StatsOpBase::CalcMultiData(trOp, dr, nTotalNumData, nExeMode, dwExecCntrl);
	}
	///End KEEP_MISSING_VALUE_FACTOR
	
	//virtual
	BOOL	CalcOneData(TreeNode &trOp, int index, int nTotalNumData, const vector<int> &vFactorSizes,
						const vector<string> &vstrFactors, vector &vData, vector &vDummy, matrix &mDummy, vector &vWeights, DWORD dwPlotObjUID, int nRowColIndex, const vector<int>& vintRowsInSource = NULL)
	{
		int nDataIndex = index; /// Iris 10/18/2011 ORG-4125-P1 FIX_PLOT_SAME_GRAPH_IN_ONE_GRAPH_FAILED_FOR_MULTI_FACTORS_DATA		
		/// Iris 9/22/2011 ORG-3208-S1 FIX_REPORT_GRAPH_ISSUE_FOR_MISSED_FACTOR_IN_MULTI_GROUPS_DATA
		/// Iris 11/22/2011 ORG-4373-P1 KEEP_MISSING_VALUE_FACTOR
		//if( !CheckCorrectDataIndexFromTrimEmptyGroupPair(index, vData) )
		if( vFactorSizes.GetSize() > 1 && !CheckCorrectDataIndexFromTrimEmptyGroupPair(index, vData) )
		///End KEEP_MISSING_VALUE_FACTOR
			return true;
		///End FIX_REPORT_GRAPH_ISSUE_FOR_MISSED_FACTOR_IN_MULTI_GROUPS_DATA
		
		NormTestResults SWRes,LFRes,KSRes;
		NormTestResults2 ADRes, Chi2Res, SkewRes, KrutRes;
		ChenShapiroTestResults CSRes;
		
		/// Zech 08/15/2011 ORG-3228-P1 SUPPORT_MULTIPLE_GROUPING
		m_vstrFactors = vstrFactors;
		/// END SUPPORT_MULTIPLE_GROUPING
		string			strDataLabel;
		/// Iris 10/18/2011 ORG-4125-P1 FIX_PLOT_SAME_GRAPH_IN_ONE_GRAPH_FAILED_FOR_MULTI_FACTORS_DATA		
		//GetOneDataLabel(trOp, index, nRowColIndex, strDataLabel);
		GetOneDataLabel(trOp, nDataIndex, nRowColIndex, strDataLabel);
		///End FIX_PLOT_SAME_GRAPH_IN_ONE_GRAPH_FAILED_FOR_MULTI_FACTORS_DATA
		
		/// Zech 08/16/2011 ORG-3228-P1 SUPPORT_MULTIPLE_GROUPING
		//if(NULL != vstrFactors && vstrFactors.GetSize()>0 )
			//strDataLabel = vstrFactors[0];
		/// END SUPPORT_MULTIPLE_GROUPING
		
		/// Zech 08/16/2011 ORG-3228-P1 SUPPORT_MULTIPLE_GROUPING
		//if(!AddDescStatsTable(trOp, index, vData, strDataLabel, vWeights, vstrFactors))
		if(vData.GetSize() && !AddDescStatsTable(trOp, index, vData, strDataLabel, vWeights, vstrFactors))
		/// END SUPPORT_MULTIPLE_GROUPING
			return false;		
			
		/// Zeck 08/02/2011 ORG-3228-S2 SHOW_N_MISSING_IN_DESCRIPTIVE_TABLE
		vWeights.Trim();
		vDummy.Trim();
		vData.Trim();
		/// END SHOW_N_MISSING_IN_DESCRIPTIVE_TABLE
			
		/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
		//if(!updateOutputNormTest(trOp, index, vData, strDataLabel, SWRes, LFRes, KSRes, ADRes, Chi2Res, SkewRes, KrutRes, CSRes))
		NormalityTestInfoMore stNTInfo;
		stNTInfo.pvsFactors = &vstrFactors;
		if(!updateOutputNormTest(trOp, index, vData, strDataLabel, SWRes, LFRes, KSRes, ADRes, Chi2Res, SkewRes, KrutRes, CSRes, &stNTInfo))
		/// END ADD_GROUPING_INFO_TO_FOOTNOTE
			return false;
		
		///------ Folger 06/01/2012 ORG-5592-S1 SHOW_DATA_IDENTIFIER_FOR_FLAT_SHEET
		GetOneDataLabel(trOp, nDataIndex, nRowColIndex, strDataLabel, NULL, false);
		///------ End SHOW_DATA_IDENTIFIER_FOR_FLAT_SHEET
		AddBinDataTableAndGraphNodes(trOp, index, vData, vstrFactors, strDataLabel);
	
		return true;
	}	
	
	/// Zech 08/16/2011 ORG-3228-P1 SUPPORT_MULTIPLE_GROUPING
	bool IsOutputSeparateResultCurveSheet(const TreeNode& trOp) 
	{
		if(HasFactor(trOp))
			return true;
		return false;
	}
	
	TreeNode GetResultCuveOutputBranch(const TreeNode& trOp)
	{
		TreeNode 	trCurveBranch = trOp.GUI.Output.Report;
		return 		trCurveBranch;
	}
	/// END SUPPORT_MULTIPLE_GROUPING
	
	//virtual
	void 	UpdateReportingTables(TreeNode &trOperation, int nTotalNumData, int nExeMode)
	{
		WksReportOperation::UpdateReportingTables(trOperation, nTotalNumData, nExeMode);
		
		TreeNode trTable = trOperation.Calculation.GetNode(TABLE_DESC_STATS);
		if(trTable)
			trTable.SetAttribute(TREE_Table, GetTableStringSupport(false)); 
			
		trTable = trOperation.Calculation.NormalityTest;
		if(trTable)
		{
			//trTable.SetAttribute(TREE_Table, GetTableStringSupport(false));///Alex 06/14/06 SET_NORMALITYTEST_BRANCH_ALL_OPEN
			///Kyle 12/10/2010 ORG-1720-P1 TABLE_BITS_USE_UINT_INSTEAD_OF_STRING_TO_PREVENT_DIGITS_LOST
			//trTable.SetAttribute(TREE_Table, atof(GetTableStringMain(false)));
			trTable.SetAttribute(TREE_Table, GetTableStringMain(false));
			///End TABLE_BITS_USE_UINT_INSTEAD_OF_STRING_TO_PREVENT_DIGITS_LOST
			trTable.SetAttribute(STR_LABEL_ATTRIB, _L("NormalityTest"));///Jasmine 09/15/06 SETTING_CHANGE_AND_ADD_FOOTNOTE
		}
	}

///Echo 2/12/07 ADD_ERROR_REPORT
	//virtual 
	PEVENT_GETN GetNewEventFunction()
	{
		return normalitytest_event1;
	}
///end ADD_ERROR_REPORT

	///------ Folger 06/06/2012 ORG-5906-P1 NORMALITY_TEST_TOO_SLOW_FOR_LARGE_DATA
	virtual void GetCalcMoment(TreeNode& trOp, DescStatOptions& opMoments)
	{
		opMoments.N =
		opMoments.Missing =
		opMoments.Mean =
		opMoments.SD =
		opMoments.SEM = 1;

		opMoments.VarDivisor = DS_NAG;
	}
	///------ End NORMALITY_TEST_TOO_SLOW_FOR_LARGE_DATA
	
private:
	
	/// Zech 11/07/2011 ORG-3228-P11 PUT_NORMALITY_TEST_DATA_WORKSHEET_INTO_THE_SAME_PAGE
	//virtual
	string GetCurveOutputBookName(const TreeNode& trGUI, int nOutputIndex, int* pnSpecialType = NULL, Worksheet* pwksReport = NULL)
	{
		string	strBook;
		if(NULL != pwksReport)
		{
			if( pwksReport->IsValid() )
				strBook = pwksReport->GetPage().GetName();
		}
		return strBook;
	}
	
	//virtual 
	void 	GetResultCurveBookSheetName(TreeNode& trOperation, string& strBookName, string& strSheetName, int nIndex = 0, int nOption = OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET, bool bSeparateSheetForDataset = false, int nSheetNameIndex = 0)
	{
		strSheetName = _LE(E_STR_NORMALITY_TEST_DATA_SHEET_NAME);
	}
	/// END PUT_NORMALITY_TEST_DATA_WORKSHEET_INTO_THE_SAME_PAGE	
	
	void 	constructAddNormalityTestReport(TreeNode& trOperation)
	{	
		TreeNode 	trOut = trOperation.Calculation; 
		
		trOut.Statistics.ID = IDST_DESC_STATS_RESULTS;
		trOut.NormalityTest.ID = IDST_NORM_TEST_RESULTS;				
	}
	
	/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
	/*
	bool updateOutputNormTest(TreeNode& trOp, int index, const vector& vData, string& strDataLabel, 
	NormTestResults& SWRes,NormTestResults& LFRes, NormTestResults& KSRes, NormTestResults2& ADRes,
	NormTestResults2& Chi2Res, NormTestResults2& SkewRes, NormTestResults2& KrutRes, ChenShapiroTestResults& CSRes)
	*/
	bool updateOutputNormTest(TreeNode& trOp, int index, const vector& vData, string& strDataLabel, 
		NormTestResults& SWRes,NormTestResults& LFRes, NormTestResults& KSRes, NormTestResults2& ADRes,
	NormTestResults2& Chi2Res, NormTestResults2& SkewRes, NormTestResults2& KrutRes, ChenShapiroTestResults& CSRes, NormalityTestInfoMore *pstNTInfo = NULL)
	/// END ADD_GROUPING_INFO_TO_FOOTNOTE
	 {	 	
	 	int nSWRet, nLFRet, nKSRet = 1;//set nKSRet not 0
	 	
	 	/// Zech 08/16/2011 ORG-3228-P1 SUPPORT_MULTIPLE_GROUPING
	 	if (!vData.GetSize())
	 		return true;
	 	/// END SUPPORT_MULTIPLE_GROUPING
	 	
	 	TreeNode tnSW = trOp.GUI.OptionBranch.GetNode("shap-wilk");
	 	if(tnSW.nVal)
	 	{
	 		///Echo 8/24/05 ERROR_ALGORITHM_USED
	 		//nSWRet = stats_shapiro_wilk_test(vData, SWRes, 1);
	 		nSWRet = stats_shapiro_wilk_test(vData, SWRes, 0);
	 		///END ERROR_ALGORITHM_USED

			/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
			/*
	 		/// Zeck 08/04/2011 ORG-3228-S4 NORMALITY_TEST_ADD_THREE_MORE_TESTS
	 		//updateNormTest(trOp, index, strDataLabel, nSWRet, SWRes, _LE("SW"), IDST_NORM_TEST_SW_RESULT, _LE("Shapiro-Wilk"));
	 		updateNormalityTestResultOutput(trOp, index, strDataLabel, nSWRet, SWRes, "SW", IDST_NORM_TEST_SW_RESULT, _LE("Shapiro-Wilk"));
	 		/// END NORMALITY_TEST_ADD_THREE_MORE_TESTS
			*/
			updateNormalityTestResultOutput(trOp, index, strDataLabel, nSWRet, SWRes, "SW", IDST_NORM_TEST_SW_RESULT, _LE("Shapiro-Wilk"), pstNTInfo);
			/// END ADD_GROUPING_INFO_TO_FOOTNOTE
			//trOp.Calculation.NormalityTest.SW.SetAttribute(STR_LABEL_ATTRIB, "Shapiro-Wilk");
	 	}
	 	
	 	if(trOp.GUI.OptionBranch.lilliefors.nVal)
	 	{
	 		nLFRet = stats_lilliefors_test(vData, LFRes);
			/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
			/*
	 		/// Zeck 08/04/2011 ORG-3228-S4 NORMALITY_TEST_ADD_THREE_MORE_TESTS
	 		//updateNormTest(trOp, index, strDataLabel, nLFRet, LFRes, _LE("LF"), IDST_NORM_TEST_LF_RESULT, _LE("Lilliefors"));
	 		updateNormalityTestResultOutput(trOp, index, strDataLabel, nLFRet, LFRes, "LF", IDST_NORM_TEST_LF_RESULT, _LE("Lilliefors"));
	 		/// END NORMALITY_TEST_ADD_THREE_MORE_TESTS
			*/
			updateNormalityTestResultOutput(trOp, index, strDataLabel, nLFRet, LFRes, "LF", IDST_NORM_TEST_LF_RESULT, _LE("Lilliefors"), pstNTInfo);
			/// END ADD_GROUPING_INFO_TO_FOOTNOTE
	 		//trOp.Calculation.NormalityTest.LF.SetAttribute(STR_LABEL_ATTRIB, "Lilliefors");
	 	}
	 	
	 	vector vPara(2);
	 	int nParatype = trOp.GUI.OptionBranch.kolm.Paras.nVal;
	 	int nUse;
	 	if(trOp.GUI.OptionBranch.kolm.GetAttribute(STR_USE_ATTRIB, nUse))
	 		if(nUse)
	 		{ 
		 		if( nParatype == PARA_SUPPLIED)
		 		{
		 			vPara[0]= trOp.GUI.OptionBranch.Kolm.mean.dVal;
		 			vPara[1]= trOp.GUI.OptionBranch.Kolm.variance.dVal;	
		 		}
		 		nKSRet =stats_kolmogorov_smirnov_test(vData, nParatype, vPara, KSRes);
				/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
				/*
		 		/// Zeck 08/04/2011 ORG-3228-S4 NORMALITY_TEST_ADD_THREE_MORE_TESTS
		 		//updateNormTest(trOp, index, strDataLabel, nKSRet, KSRes, _LE("KS"), IDST_NORM_TEST_KS_RESULT, _LE("Kolmogorov_Smirnov"));
		 		updateNormalityTestResultOutput(trOp, index, strDataLabel, nKSRet, KSRes, _LE("KS"), IDST_NORM_TEST_KS_RESULT, _LE("Kolmogorov_Smirnov"));
		 		/// END NORMALITY_TEST_ADD_THREE_MORE_TESTS
				*/
				updateNormalityTestResultOutput(trOp, index, strDataLabel, nKSRet, KSRes, _LE("KS"), IDST_NORM_TEST_KS_RESULT, _LE("Kolmogorov_Smirnov"), pstNTInfo);
				/// END ADD_GROUPING_INFO_TO_FOOTNOTE
		 		//trOp.Calculation.NormalityTest.KS.SetAttribute(STR_LABEL_ATTRIB, "Kolmogorov_Smirnov");
	 		}	
	 		
	 	/// Zeck 08/03/2011 ORG-3228-S4 NORMALITY_TEST_ADD_THREE_MORE_TESTS

	 	if (trOp.GUI.OptionBranch.Anderson.nVal)
	 	{
	 		int nADRet = stats_anderson_darling_test(vData, ADRes);
			/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
	 		//updateAndersonTestResultOutput(trOp, index, strDataLabel, nADRet, ADRes, _LE("AD"), IDST_NORM_TEST_AD_RESULT, _LE("Anderson-Darling test"));
			updateAndersonTestResultOutput(trOp, index, strDataLabel, nADRet, ADRes, _LE("AD"), IDST_NORM_TEST_AD_RESULT, _LE("Anderson-Darling test"), pstNTInfo);
			/// END ADD_GROUPING_INFO_TO_FOOTNOTE
	 	}
	 	
	 	if (trOp.GUI.OptionBranch.DKsquared.nVal)
	 	{
	 		int nDKRet = stats_k_squared_test(vData, Chi2Res, SkewRes, KrutRes);
			/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
	 		//updateKSquaredTestResultOutput(trOp, index, strDataLabel, nDKRet, Chi2Res, SkewRes, KrutRes, _LE("DK"), IDST_NORM_TEST_DK_RESULT, _LE("D'Agostino-K squared test"));
			updateKSquaredTestResultOutput(trOp, index, strDataLabel, nDKRet, Chi2Res, SkewRes, KrutRes, _LE("DK"), IDST_NORM_TEST_DK_RESULT, _LE("D'Agostino-K squared test"), pstNTInfo);
			/// END ADD_GROUPING_INFO_TO_FOOTNOTE
	 		
	 	}
	 	
	 	if (trOp.GUI.OptionBranch.Chen.nVal)
	 	{
	 		double dAlpha=GetAlpha(trOp);
	 		int nCSRet = stats_chen_shapiro_test(vData, dAlpha, CSRes);
			/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
	 		//updateChenShapiroTestResultOutput(trOp, index, strDataLabel, nCSRet, CSRes, _LE("CS"), IDST_NORM_TEST_CS_RESULT, _LE("Chen-Shapiro test"));
			updateChenShapiroTestResultOutput(trOp, index, strDataLabel, nCSRet, CSRes, _LE("CS"), IDST_NORM_TEST_CS_RESULT, _LE("Chen-Shapiro test"), pstNTInfo);
			/// END ADD_GROUPING_INFO_TO_FOOTNOTE
	 	}
	 	
	 	/// END NORMALITY_TEST_ADD_THREE_MORE_TESTS
	 		

	 	/// Iris 1/19/2010 QA81-14988-P2 FIX_EMPTY_NORMALITY_TABLE_WHEN_UNCHECK_ALL
	 	TreeNode trTable = trOp.Calculation.NormalityTest;
	 	tree_check_set_hidden(trTable, trTable.GetNodeCount()>0 ? false : true);
	 	///End FIX_EMPTY_NORMALITY_TABLE_WHEN_UNCHECK_ALL
	 	return true;
	 }
	
	///Arvin 09/19/07 UPDATE_ERROR_MASSAGE_FOR_FOOTNOTE as echo said
	string getErrMsgForTables(LPCSTR lpsczDataLabel, LPCSTR lpsczTableLabel, int nErr)
	{
		string strDataLabel(lpsczDataLabel), strTableLabel(lpsczTableLabel);
		strTableLabel.TrimLeft();
		strTableLabel.TrimRight();
		if(strTableLabel.IsEmpty())
			return "";
		
		string strError;
		strError.Empty();
		int nPoints = 0;
		int nErrMsg; ///Arvin 10/27/07 LOCALIZED_FOOTNOTES_STRINGS
		switch(nErr)
		{
		case STATS_ERROR_TOO_FEW_DATA_PTS:
			/// Zech 08/05/2011 ORG-3228-S4 NORMALITY_TEST_ADD_THREE_MORE_TESTS
			/*
			if(strTableLabel.Compare("Shapiro-Wilk") == 0 || strTableLabel.Compare("Kolmogorov_Smirnov") == 0)	
				nPoints = 3;
			else if(strTableLabel.Compare("Lilliefors") == 0)
				nPoints = 4;
			*/
			if(strTableLabel.Compare("Shapiro-Wilk") == 0 || strTableLabel.Compare("Kolmogorov_Smirnov") == 0)	
				nPoints = 3;
			else if(strTableLabel.Compare("Lilliefors") == 0 || strTableLabel.Compare("D'Agostino-K squared test") == 0 )
				nPoints = 4;			
			if(strTableLabel.Compare("Anderson-Darling test") == 0)
				nPoints = 8;
			if(strTableLabel.Compare("Chen-Shapiro test") == 0)
				nPoints = 10;
			/// END NORMALITY_TEST_ADD_THREE_MORE_TESTS
			
			if(nPoints > 0)
				///Arvin 10/27/07 LOCALIZED_FOOTNOTES_STRINGS
				//strError.Format("%s: Too few data points, data points number should not less than %d for %s.", strDataLabel, nPoints, strTableLabel);
				nErrMsg = FOOTNOTE_SHAPIRO_WILLK_1;
				///end LOCALIZED_FOOTNOTES_STRINGS
			break;
		case STATS_ERROR_TOO_MANY_DATA_PTS:
			if(strTableLabel.Compare("Shapiro-Wilk") == 0)
				nPoints = 5000;
			
			/// Zech 08/05/2011 ORG-3228-S4 NORMALITY_TEST_ADD_THREE_MORE_TESTS
			if(strTableLabel.Compare("Chen-Shapiro test") == 0)
				nPoints = 2000;
			/// END NORMALITY_TEST_ADD_THREE_MORE_TESTS
			
			if(nPoints > 0)
				///Arvin 10/27/07 LOCALIZED_FOOTNOTES_STRINGS
				//strError.Format("%s: Too many data points, data points number should not be greater than %d for %s.", strDataLabel, nPoints, strTableLabel);
				nErrMsg = FOOTNOTE_SHAPIRO_WILLK_2;
				///end LOCALIZED_FOOTNOTES_STRINGS
			break;
		default:
			break;
		}
		
		///Arvin 10/27/07 LOCALIZED_FOOTNOTES_STRINGS
		ocu_load_err_msg_str(nErrMsg, &strError);
		/// Zech 08/12/2011 ORG-3228-P3 DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
		if (STATS_ERROR_TOO_FEW_DATA_PTS == nErr)
		{
			strError.Format(strError, _L("a*"), nPoints, GetLocalized(strTableLabel));
			strError = GetBlueFontedText(strError);
		}
		if (STATS_ERROR_TOO_MANY_DATA_PTS == nErr)
		{
			strError.Format(strError, _L("b*"), nPoints, GetLocalized(strTableLabel));
			strError = GetBlueFontedText(strError);
		}
		/// END DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
		strError.Format(strError, GetLocalized(strDataLabel), nPoints, GetLocalized(strTableLabel));
		///end LOCALIZED_FOOTNOTES_STRINGS
		return strError;
	}
	///end UPDATE_ERROR_MASSAGE_FOR_FOOTNOTE
	
	/// Zeck 08/03/2011 NORMALITY_TEST_ADD_THREE_MORE_TESTS	
	
	double GetAlpha(TreeNode trOp)
	{
		return trOp.GUI.OptionBranch.alpha.dVal;
	}
	
	/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
	//void updateAndersonTestResultOutput (TreeNode& trOp, int index, const string strDataLabel, int nCalcResult, const NormTestResults2& ADRes, LPCSTR lpcsztagName, int nId, LPCSTR lpsczTableLabel)
	void updateAndersonTestResultOutput (TreeNode& trOp, int index, const string strDataLabel, int nCalcResult, const NormTestResults2& ADRes, LPCSTR lpcsztagName, int nId, LPCSTR lpsczTableLabel, NormalityTestInfoMore *pstNTInfo = NULL)
	/// END ADD_GROUPING_INFO_TO_FOOTNOTE
	{
		Tree trRet;
		trRet += ADRes;
		trRet.TestStat.SetAttribute(STR_LABEL_ATTRIB, STR_STATS_LABEL);
		/// Zech 08/12/2011 ORG-3228-P2 UNITE_THE_NAME_OF_PROBABILITY_VALUE_TO_P_VALUE
		//trRet.Prob.SetAttribute(STR_LABEL_ATTRIB, _L("p value"));
		trRet.Prob.SetAttribute(STR_LABEL_ATTRIB, STR_P_VALUE_LABEL);
		/// END UNITE_THE_NAME_OF_PROBABILITY_VALUE_TO_P_VALUE
		double dAlpha=GetAlpha(trOp);
		/// Zech 08/12/2011 ORG-3228-P3 DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
		//addDecisionColumnForNormalityTest(trRet, ADRes.Prob, dAlpha, dAlpha);
		addDecisionColumnForNormalityTest(trRet, ADRes.Prob, dAlpha, dAlpha, nCalcResult);
		if (STATS_ERROR_TOO_FEW_DATA_PTS == nCalcResult)
			trRet.TestStat.dVal = trRet.Prob.dVal = NANUM;
		///END DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST

		/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
		//updateNormTest(trOp, index, strDataLabel, nCalcResult, trRet, lpcsztagName, nId, lpsczTableLabel);
		updateNormTest(trOp, index, strDataLabel, nCalcResult, trRet, lpcsztagName, nId, lpsczTableLabel, pstNTInfo);
		/// END ADD_GROUPING_INFO_TO_FOOTNOTE
		return;
	}

	enum
	{
		NORM_DK_TEST_OMNIBUS = 0,
		NORM_DK_TEST_SKEWNESS,
		NORM_DK_TEST_KURTOSIS,

		NORM_DK_TEST_TOTAL	/// Zech 12/23/2011 ORG-4669-P2 IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
	};
	

	/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
	//void updateKSquaredTestResultOutput (TreeNode& trOp, int index, const string strDataLabel, int nCalcResult, const NormTestResults2& Chi2Res, const NormTestResults2& SkewRes, const NormTestResults2& KrutRes, LPCSTR lpcsztagName, int nId, LPCSTR lpsczTableLabel)
	void updateKSquaredTestResultOutput (TreeNode& trOp, int index, const string strDataLabel, int nCalcResult, const NormTestResults2& Chi2Res, const NormTestResults2& SkewRes, const NormTestResults2& KrutRes, LPCSTR lpcsztagName, int nId, LPCSTR lpsczTableLabel, NormalityTestInfoMore *pstNTInfo = NULL)
	/// END ADD_GROUPING_INFO_TO_FOOTNOTE
	{
		vector<string> vsTypes;
		
		/// Zech 11/04/2011 ORG-3228-P6 USING_PROPER_LABEL_FOR_DAgostino_K_squared_TEST
		/*
		vsTypes.Add(_L("D Agostino's Chi2 Test"));
		vsTypes.Add(_L("Skewness Test"));
		vsTypes.Add(_L("Krutosis Test"));
		*/
		vsTypes.Add(_L("D'Agostino Omnibus"));
		vsTypes.Add(_L("D'Agostino Skewness"));
		vsTypes.Add(_L("D'Agostino Kurtosis"));
		/// END USING_PROPER_LABEL_FOR_DAgostino_K_squared_TEST
		
		double dAlpha=GetAlpha(trOp);
		
		for (int ii = 0; ii < vsTypes.GetSize(); ii++)
		{
			Tree trRet;
			TreeNode trType = trRet.AddNode("Name");
			trType.SetAttribute(STR_LABEL_ATTRIB, "");
			trType.SetAttribute(STR_DATAID_ATTRIB, IDE_NORM_TYPE);
			trType.strVal = vsTypes[ii];
			
			NormTestResults2 resTmp;
			switch (ii)
			{
			case NORM_DK_TEST_OMNIBUS:
				resTmp = Chi2Res;
				break;
				
			case NORM_DK_TEST_SKEWNESS:
				resTmp = SkewRes;
				break;				
			
			case NORM_DK_TEST_KURTOSIS:
				resTmp = KrutRes;
				break;
				
			default:
				ASSERT(false);
				break;
			}
			
			trRet += resTmp;
			trRet.TestStat.SetAttribute(STR_LABEL_ATTRIB, STR_STATS_LABEL);	
			/// Zech 08/12/2011 ORG-3228-P2 UNITE_THE_NAME_OF_PROBABILITY_VALUE_TO_P_VALUE
			//trRet.Prob.SetAttribute(STR_LABEL_ATTRIB, _L("p value"));
			trRet.Prob.SetAttribute(STR_LABEL_ATTRIB, STR_P_VALUE_LABEL);
			/// END UNITE_THE_NAME_OF_PROBABILITY_VALUE_TO_P_VALUE
			
			/// Zech 08/12/2011 ORG-3228-P3 DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
			//addDecisionColumnForNormalityTest(trRet, resTmp.Prob, dAlpha, dAlpha);
			addDecisionColumnForNormalityTest(trRet, resTmp.Prob, dAlpha, dAlpha, nCalcResult);
			if (STATS_ERROR_TOO_FEW_DATA_PTS == nCalcResult)
				trRet.TestStat.dVal = trRet.Prob.dVal = NANUM;
			/// END DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
			
			/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
			//updateNormTest(trOp, index*3+ii, strDataLabel, nCalcResult, trRet, lpcsztagName, nId, lpsczTableLabel);
			/// Zech 12/23/2011 ORG-4669-P2 IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
			//updateNormTest(trOp, index*3+ii, strDataLabel, nCalcResult, trRet, lpcsztagName, nId, lpsczTableLabel, pstNTInfo);
			updateNormTest(trOp, index*NORM_DK_TEST_TOTAL+ii, strDataLabel, nCalcResult, trRet, lpcsztagName, nId, lpsczTableLabel, pstNTInfo);
			/// END IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
			/// END ADD_GROUPING_INFO_TO_FOOTNOTE
		}
		return;
	}
	
	/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
	//void updateChenShapiroTestResultOutput (TreeNode& trOp, int index, const string strDataLabel, int nCalcResult, const ChenShapiroTestResults& CSRes, LPCSTR lpcsztagName, int nId, LPCSTR lpsczTableLabel)
	void updateChenShapiroTestResultOutput (TreeNode& trOp, int index, const string strDataLabel, int nCalcResult, const ChenShapiroTestResults& CSRes, LPCSTR lpcsztagName, int nId, LPCSTR lpsczTableLabel, NormalityTestInfoMore *pstNTInfo = NULL)
	/// END ADD_GROUPING_INFO_TO_FOOTNOTE
	{
		Tree trRet;
		double dAlpha=GetAlpha(trOp);
		trRet += CSRes;
		trRet.TestStat.SetAttribute(STR_LABEL_ATTRIB, STR_STATS_LABEL);
		string strCriticalSuffix = _L("critical value");
		trRet.CriStat10.SetAttribute(STR_LABEL_ATTRIB, "10% " + strCriticalSuffix);
		trRet.CriStat5.SetAttribute(STR_LABEL_ATTRIB, "5% " + strCriticalSuffix);
		string strCriticalValue = ftoa(dAlpha*100) + "% " + strCriticalSuffix;
		trRet.CriStat.SetAttribute(STR_LABEL_ATTRIB, strCriticalValue);
		
		vector <double> vdAvailableAlpha = {0.001, 0.005, 0.010, 0.015, 0.020, 0.025, 0.030, 0.035, 0.040, 0.045, 0.050, 0.060, 0.070, 0.080, 0.090, 0.100};
		vector <uint> vnMatchingPosition;
		if (!vdAvailableAlpha.Find(MATREPL_TEST_EQUAL, dAlpha, vnMatchingPosition))
		{
			/// Zech 12/23/2011 ORG-4669-P2 IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
			// When Alpha could not be found, compare the result with the one of Alpha = 0.05 and draw conclusion
			//addDecisionColumnForNormalityTest(trRet, 0.05);
			addDecisionColumnForNormalityTest(trRet, CSRes.CriStat5, CSRes.TestStat, 0.05, nCalcResult);
			/// END IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
			trRet.CriStat.dVal = NANUM;
		}
		else
		/// Zech 08/12/2011 ORG-3228-P3 DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
			//addDecisionColumnForNormalityTest(trRet, CSRes.CriStat, CSRes.TestStat, dAlpha);
			addDecisionColumnForNormalityTest(trRet, CSRes.CriStat, CSRes.TestStat, dAlpha, nCalcResult);
		/// END DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
		
		/// Zech 08/15/2011 ORG-3228-P3 DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
		if (STATS_ERROR_TOO_FEW_DATA_PTS == nCalcResult || STATS_ERROR_TOO_MANY_DATA_PTS == nCalcResult)
			trRet.TestStat.dVal = trRet.CriStat10.dVal = trRet.CriStat5.dVal = trRet.CriStat.dVal = NANUM;
		/// END DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
		
		/// Zech 08/10/2011 NO_NEED_TO_SHOW_DUPLICATED_COLUMNS
		if (is_equal(dAlpha, 0.05) || is_equal(dAlpha, 0.1))
			trRet.CriStat.Remove();
		/// END NO_NEED_TO_SHOW_DUPLICATED_COLUMNS
		
		/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
		//updateNormTest(trOp, index, strDataLabel, nCalcResult, trRet, lpcsztagName, nId, lpsczTableLabel);
		updateNormTest(trOp, index, strDataLabel, nCalcResult, trRet, lpcsztagName, nId, lpsczTableLabel, pstNTInfo);
		/// END ADD_GROUPING_INFO_TO_FOOTNOTE
		return;
	}
	
	/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
	//void updateNormalityTestResultOutput (TreeNode& trOp, int index, const string strDataLabel, int nCalcResult, const NormTestResults& NormTestRes, LPCSTR lpcsztagName, int nId, LPCSTR lpsczTableLabel)
	void updateNormalityTestResultOutput (TreeNode& trOp, int index, const string strDataLabel, int nCalcResult, const NormTestResults& NormTestRes, LPCSTR lpcsztagName, int nId, LPCSTR lpsczTableLabel, NormalityTestInfoMore *pstNTInfo = NULL)
	/// END ADD_GROUPING_INFO_TO_FOOTNOTE
	{
		Tree trRet;
		trRet += NormTestRes;
		if( trRet.DOF )
			trRet.DOF.SetAttribute(STR_LABEL_ATTRIB, _L("DF"));	
		trRet.TestStat.SetAttribute(STR_LABEL_ATTRIB, STR_STATS_LABEL);
		if( IDST_NORM_TEST_SW_RESULT == nId ) 
			/// Zech 08/12/2011 ORG-3228-P2 UNITE_THE_NAME_OF_PROBABILITY_VALUE_TO_P_VALUE
			//trRet.Prob.SetAttribute(STR_LABEL_ATTRIB, _L("Prob<W"));
			trRet.Prob.SetAttribute(STR_LABEL_ATTRIB, STR_P_VALUE_LABEL);
			/// END UNITE_THE_NAME_OF_PROBABILITY_VALUE_TO_P_VALUE
		else
			/// Zech 08/12/2011 ORG-3228-P2 UNITE_THE_NAME_OF_PROBABILITY_VALUE_TO_P_VALUE
			//trRet.Prob.SetAttribute(STR_LABEL_ATTRIB, _L("Prob>D"));
			trRet.Prob.SetAttribute(STR_LABEL_ATTRIB, STR_P_VALUE_LABEL);
			/// END UNITE_THE_NAME_OF_PROBABILITY_VALUE_TO_P_VALUE
		double dAlpha=GetAlpha(trOp);
		/// Zech 08/12/2011 ORG-3228-P3 DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
		//addDecisionColumnForNormalityTest(trRet, NormTestRes.Prob, dAlpha, dAlpha);
		addDecisionColumnForNormalityTest(trRet, NormTestRes.Prob, dAlpha, dAlpha, nCalcResult);
		if (STATS_ERROR_TOO_FEW_DATA_PTS == nCalcResult)
			trRet.DOF.dVal = trRet.Prob.dVal = NANUM;
		/// END DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST

		/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
		//updateNormTest(trOp, index, strDataLabel, nCalcResult, trRet, lpcsztagName, nId, lpsczTableLabel);
		updateNormTest(trOp, index, strDataLabel, nCalcResult, trRet, lpcsztagName, nId, lpsczTableLabel, pstNTInfo);
		/// END ADD_GROUPING_INFO_TO_FOOTNOTE
		return;
	}
	/// END NORMALITY_TEST_ADD_THREE_MORE_TESTS
	
	///Zeck 7/21/2011 ORG-3228-S3 REPLACE_FOOTNOTE_WITH_DECISION_COLUMN
	string		GetFormattedDecisionAtLevel(double dAlpha)
	{
		string			str;
		str.Format(_L("Decision at level(%s%%)"), ftoa(dAlpha*100));
		return str;
	}

	void addDecisionColumnForNormalityTest(TreeNode& trRet, double dDefaultAlpha)
	{
		TreeNode trDecision = trRet.AddNode("Decision", false);
		trDecision.SetAttribute(STR_LABEL_ATTRIB, GetFormattedDecisionAtLevel(dDefaultAlpha));
		trDecision.SetAttribute(STR_DATAID_ATTRIB, IDE_NORM_DECISION);
		trDecision.strVal = STR_NOT_REJECT_NORMALITY;
		return;
	}
	
	/// Zech 08/12/2011 ORG-3228-P3 DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
	//void addDecisionColumnForNormalityTest(TreeNode& trRet, double d1, double d2, double dAlpha)
	void addDecisionColumnForNormalityTest(TreeNode& trRet, double d1, double d2, double dAlpha, int nCalcResult)
	/// END DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
	{
		TreeNode trDecision = trRet.AddNode("Decision", false);
		trDecision.SetAttribute(STR_LABEL_ATTRIB, GetFormattedDecisionAtLevel(dAlpha));
		trDecision.SetAttribute(STR_DATAID_ATTRIB, IDE_NORM_DECISION);
		//trDecision.strVal = trRow.Prob.dVal > dAlpha ? "can't reject normality":"Reject normality";
		/// Zech 08/12/2011 ORG-3228-P3 DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
		//trDecision.strVal = d1 > d2 ? "Can't reject normality":"Reject normality";
		if (STATS_ERROR_TOO_FEW_DATA_PTS == nCalcResult)
			trDecision.strVal = _L("a*");
		else if (STATS_ERROR_TOO_MANY_DATA_PTS == nCalcResult)
			trDecision.strVal = _L("b*");
		else
		/// Zech 11/09/2011 ORG-3228-P12 DISPLAY_LABEL_AND_FOOTNOTE_CORRECTLY_WHEN_CANNOT_DRAW_CONCLUSION
		//	trDecision.strVal = d1 > d2 ? _L("Can't reject normality"):_L("Reject normality");
		{
			if (NANUM == d1)
				trDecision.strVal = _L("c*");
			else
				trDecision.strVal = d1 > d2 ? STR_NOT_REJECT_NORMALITY:STR_REJECT_NORMALITY;
		}
		/// END DISPLAY_LABEL_AND_FOOTNOTE_CORRECTLY_WHEN_CANNOT_DRAW_CONCLUSION
		/// END DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
		return;
	}
	///END REPLACE_FOOTNOTE_WITH_DECISION_COLUMN

	/// Zech 12/23/2011 ORG-4669-P2 IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
	string GetBlueFontedText(LPCSTR  lpczText)
	{
		string strText = lpczText;
		return "\\p120(\\c4(" + strText + "))";
	}
	/// END IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY

	
	/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
	/*
	/// Zeck 08/04/2011 ORG-3228-S4 NORMALITY_TEST_ADD_THREE_MORE_TESTS
	//void updateNormTest(TreeNode& trOp, int index, const string strDataLabel, int nCalcResult, const NormTestResults& NormTestRes, LPCSTR lpcsztagName, int nId, LPCSTR lpsczTableLabel)
	void updateNormTest(TreeNode& trOp, int index, const string strDataLabel, int nCalcResult, const TreeNode& trResult, LPCSTR lpcsztagName, int nId, LPCSTR lpsczTableLabel)
	/// END NORMALITY_TEST_ADD_THREE_MORE_TESTS
	*/
	void updateNormTest(TreeNode& trOp, int index, const string strDataLabel, int nCalcResult, const TreeNode& trResult, LPCSTR lpcsztagName, int nId, LPCSTR lpsczTableLabel, NormalityTestInfoMore *pstNTInfo = NULL)
	/// END ADD_GROUPING_INFO_TO_FOOTNOTE
	 {
	 	//--- Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL
	 	double dAlpha=GetAlpha(trOp);
	 	//--- end USER_CAN_SET_SIGNIFICANCE_LEVEL
		string 	strLabel(strDataLabel);
		///Arvin 02/15/08 QA70-11097 KEEP_ESCAPED_STRINGS	
		//ConvertEscapedString(strLabel);
		string strTempLabel = strLabel;
		ConvertEscapedString(strTempLabel);
		///end KEEP_ESCAPED_STRINGS
	 	TreeNode trTable;
	 	
	 	trTable = tree_check_get_node(trOp.Calculation.NormalityTest, lpcsztagName, nId, STR_LABEL_ATTRIB, GetLocalized(lpsczTableLabel));
		//trTable.SetAttribute(TREE_Table, GetTableStringSupport(false));///Alex 06/14/06 SET_NORMALITYTEST_BRANCH_ALL_OPEN
		trTable.SetAttribute(TREE_Table, GetTableStringSupport(false) | GETNBRANCH_OPEN);
		
		///Arvin 09/19/07 UPDATE_ERROR_MASSAGE_FOR_FOOTNOTE as echo said
		TreeNode trRow;
		trRow = check_add_enumerated_node(trTable, CALCULATION_REPORT_TABLE_ROW_PREFIX, index+1, IDST_TEMP_ONE_SET, STR_LABEL_ATTRIB, GetLocalized(strDataLabel));
		/// Zeck 08/04/2011 ORG-3228-S4 NORMALITY_TEST_ADD_THREE_MORE_TESTS
		/*
		trRow += NormTestRes;
		trRow.DOF.SetAttribute(STR_LABEL_ATTRIB, _L("DF"));		
		trRow.TestStat.SetAttribute(STR_LABEL_ATTRIB, STR_STATS_LABEL);
		///Jim 11/17/05 P_VALUE_NAME_CONVENTION  For the names' convention of p-value
		if( IDST_NORM_TEST_SW_RESULT == nId ) 
			trRow.Prob.SetAttribute(STR_LABEL_ATTRIB, _L("Prob<W"));
		// END P_VALUE_NAME_CONVENTION	
		else
			trRow.Prob.SetAttribute(STR_LABEL_ATTRIB, _L("Prob>D"));
		*/
		trRow.Replace(trResult.Clone(), true, true, true);			
		/// END NORMALITY_TEST_ADD_THREE_MORE_TESTS
		
		/// Zech 08/15/2011 ORG-3228-P1 SUPPORT_MULTIPLE_GROUPING
		tree_add_more_labels(trRow, m_vstrFactors);
		/// END SUPPORT_MULTIPLE_GROUPING
		
 		trRow.ID = make_one_set_ID(nId, index+1);
		///end UPDATE_ERROR_MASSAGE_FOR_FOOTNOTE
		
		/// Zech 12/23/2011 ORG-4669-P2 IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
		// Only number of conclusion footnote should be limited to less than 5
		///// Iris 8/05/2009 QA80-14808 HUGE_FOOTNOTE_IN_REPORT_SHEET_CAUSE_ORIGIN_NOT_ENERGETIC
		//{
			//TreeNode 	trFooter = tree_check_get_node(trTable, "Footnote", IDE_FOOTNOTE_BEGIN, TREE_Footnote, "1");
			//if( 0 == index )
				//trFooter.SetAttribute(FOOTNOTE_STOP_ATTRIB, 0);		
			//if( index >= 5 )
			//{
				//// stop to add foonote when dataset index >= 5
				//int nStop = 0;
				///// Zech 08/15/2011 ORG-3228-P3 DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
				////if( trFooter.GetAttribute(FOOTNOTE_STOP_ATTRIB, nStop) && 1== nStop )
				//if( trFooter.GetAttribute(FOOTNOTE_STOP_ATTRIB, nStop) && 1== nStop && STATS_ERROR_TOO_FEW_DATA_PTS != nCalcResult && STATS_ERROR_TOO_MANY_DATA_PTS != nCalcResult)
				///// END DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
					//return;				
				//trFooter.SetAttribute(FOOTNOTE_STOP_ATTRIB, 1);
				//
				//if( STATS_NO_ERROR ==  nCalcResult )
				//{
					///// Zech 11/04/2011 ORG-3228-P6 NO_NEED_TO_DISPLAY_PROB_VALUE_HINT_INFO
					///*
					//string strProbValueInfo;
					//ocu_load_err_msg_str(FOOTNOTE_PROB_VALUE_INFO, &strProbValueInfo);
					////--- Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL
					//strProbValueInfo.Format(strProbValueInfo,dAlpha,dAlpha);
					////--- end USER_CAN_SET_SIGNIFICANCE_LEVEL
					//if( !trFooter.IsEmpty() )
						//strProbValueInfo = trFooter.strVal + "\n" + strProbValueInfo;
					//trFooter.strVal = strProbValueInfo;
					//*/
					///// END NO_NEED_TO_DISPLAY_PROB_VALUE_HINT_INFO
					//return;
				//}
			//}
		//}
		/////end HUGE_FOOTNOTE_IN_REPORT_SHEET_CAUSE_ORIGIN_NOT_ENERGETIC
		/// END IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
		
		/// Zech 08/05/2011 ORG-3228-S4 NORMALITY_TEST_ADD_THREE_MORE_TESTS
		// if( STATS_NO_ERROR !=  nCalcResult)
		///Sophy 3/20/2012 ORG-5313-P1 IMPROVE_FOOTNOTE_FOR_NORMALITYTEST
		//if( STATS_NO_ERROR !=  nCalcResult && STATS_WARNING_CANNOT_FIND_ALPHA != nCalcResult)
		if ( STATS_NO_ERROR !=  nCalcResult && STATS_WARNING_CANNOT_FIND_ALPHA != nCalcResult
			&& ( (!trRow.Prob || !is_missing_value(trRow.Prob.dVal)) || (STATS_ERROR_TOO_MANY_DATA_PTS == nCalcResult || STATS_ERROR_TOO_FEW_DATA_PTS == nCalcResult))
			&& ( STATS_ERROR_NE_G08CB_SAMPLE != nCalcResult )
			)
		///end IMPROVE_FOOTNOTE_FOR_NORMALITYTEST
		/// END NORMALITY_TEST_ADD_THREE_MORE_TESTS
		{
			//------ Iris 02/26/2007 NEW_DESIGN_ON_FOOTNOTE_TO_INCLUDE_ERRORINFO From Echo's suggestion, put error message into footnote
			/*
			TreeNode    trRow = tree_check_get_node(trTable, "Error", nId, STR_LABEL_ATTRIB, "Attention!");
			trRow.strVal = "error in NormalityTest";
			return;
			*/
			TreeNode 	trFooter = tree_check_get_node(trTable, "Footnote", IDE_FOOTNOTE_BEGIN, TREE_Footnote, "1"); 
			string		strError;
			///Arvin 09/19/07 UPDATE_ERROR_MASSAGE_FOR_FOOTNOTE as echo said
			//if( !trFooter.IsEmpty() )
			//	strError = trFooter.strVal + "\n";
			///end UPDATE_ERROR_MASSAGE_FOR_FOOTNOTE
			
			///Arvin 09/19/07 UPDATE_ERROR_MASSAGE_FOR_FOOTNOTE as echo said
			//switch(nCalcResult)
			//{
			//case STATS_ERROR_TOO_FEW_DATA_PTS:
			//	strError += strLabel + ": Too few data points, N must be > 2\n";
			//	break;
			//default:
			//	break;
			//}
			//strError.TrimRight("\n");
			///Arvin 02/15/08 QA70-11097 KEEP_ESCAPED_STRINGS
			//strError = getErrMsgForTables(strLabel, lpsczTableLabel, nCalcResult);
			strError = getErrMsgForTables(strTempLabel, lpsczTableLabel, nCalcResult);
			///end KEEP_ESCAPED_STRINGS
			
			/// Zech 08/12/2011 ORG-3228-P3 DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
			/*
			if(!trFooter.IsEmpty())
				strError = trFooter.strVal + "\n" + strError;
			///end UPDATE_ERROR_MASSAGE_FOR_FOOTNOTE
			trFooter.strVal = strError;
			*/
			if (!((STATS_ERROR_TOO_FEW_DATA_PTS == nCalcResult || STATS_ERROR_TOO_MANY_DATA_PTS == nCalcResult) && trFooter.strVal.Find(strError) != -1))
			{
				if(!trFooter.IsEmpty())
					strError = trFooter.strVal + "\n" + strError;
				trFooter.strVal = strError;
			}
			/// END DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
	
			//------ NEW_DESIGN_ON_FOOTNOTE_TO_INCLUDE_ERRORINFO 
		}
		///Arvin 09/19/07 UPDATE_ERROR_MASSAGE_FOR_FOOTNOTE as echo said
		/*
		TreeNode trRow;
		trRow = check_add_enumerated_node(trTable, CALCULATION_REPORT_TABLE_ROW_PREFIX, index+1, IDST_TEMP_ONE_SET, STR_LABEL_ATTRIB, strDataLabel);
		trRow += NormTestRes;
		trRow.DOF.SetAttribute(STR_LABEL_ATTRIB, "DF");		
		trRow.TestStat.SetAttribute(STR_LABEL_ATTRIB, "Statistic");
		///Jim 11/17/05 P_VALUE_NAME_CONVENTION  For the names' convention of p-value
		if( IDST_NORM_TEST_SW_RESULT == nId ) 
			trRow.Prob.SetAttribute(STR_LABEL_ATTRIB, "Prob<W");
		else
			trRow.Prob.SetAttribute(STR_LABEL_ATTRIB, "Prob>D");
		//END P_VALUE_NAME_CONVENTION
		trRow.ID = make_one_set_ID(nId, index+1);
		*/
		///end UPDATE_ERROR_MASSAGE_FOR_FOOTNOTE
		//----- Iris 02/26/2007 v8.0570 according to Echo's requirement, cannot set DOF to Missing data since type of DOF varaible is INT in NormTestResults struct
		///Arvin 09/19/07 UPDATE_ERROR_MASSAGE_FOR_FOOTNOTE as echo said
		//if( STATS_NO_ERROR !=  nCalcResult)
		//	trRow.DOF.dVal = NANUM;
		///end UPDATE_ERROR_MASSAGE_FOR_FOOTNOTE
		//----- 
		
		/// Iris 02/26/2007 v8.0570 NEW_DESIGN_ON_FOOTNOTE_TO_INCLUDE_ERRORINFO
		///Jasmine 09/07/06 ADD_FOOTNOTE
		/*
		trTable = trOp.Calculation.NormalityTest.GetNode(lpcsztagName);
		if(trTable)
		{	
			TreeNode 	trFooter = tree_check_get_node(trTable, "Footnote", IDE_FOOTNOTE_BEGIN, TREE_Footnote, "1"); // just need the TREE_Footnote attribute, value does not matter, so 1 is good
			string strMessage, strPV = IDST_NORM_TEST_SW_RESULT == nId? "" : " not";
			
			strMessage.Format("At the 0.05 level, the data was%s significantly drawn from a normally distributed population", strPV);
			trFooter.strVal = strMessage;
			///Jasmine 09/15/06 SETTING_CHANGE_AND_ADD_FOOTNOTE
			//add a footnote when Kolmogorov-Smirnov test is selected and Parameters box is set as "Specified"
			string strTagName = "ks";
			TreeNode trKolm = trOp.GUI.OptionBranch.Kolm;
			if(!strTagName.CompareNoCase(lpcsztagName) &&  PARA_SUPPLIED == trKolm.Paras.nVal)
			{				
				strMessage.Format("\nParameters for Normal Distribution was specified. Mean = %f, Variance = %f.", trKolm.mean.dVal, trKolm.variance.dVal);
				trFooter.strVal += strMessage;
			}
			///End SETTING_CHANGE_AND_ADD_FOOTNOTE
		}
		*/
		///End ADD_FOOTNOTE
			
		TreeNode 	trFooter = tree_check_get_node(trTable, "Footnote", IDE_FOOTNOTE_BEGIN, TREE_Footnote, "1"); // just need the TREE_Footnote attribute, value does not matter, so 1 is good
		string 		strMessage;
		if(0 == index)
		{
			string 		strTagName = "ks";
			TreeNode 	trKolm = trOp.GUI.OptionBranch.Kolm;
			if(!strTagName.CompareNoCase(lpcsztagName) &&  (PARA_SUPPLIED == trKolm.Paras.nVal) )
			{				
				///Arvin 10/27/07 LOCALIZED_FOOTNOTES_STRINGS
				//strMessage.Format("Parameters for Normal Distribution was specified. Mean = %f, Variance = %f.", trKolm.mean.dVal, trKolm.variance.dVal);
				string strMean, strVariance;
				strMean = ftoa(trKolm.mean.dVal);
				strVariance = ftoa(trKolm.variance.dVal);
				ocu_load_msg_str(FOOTNOTE_NORM_KOLM, &strMessage, strMean, NULL, strVariance);
				///end LOCALIZED_FOOTNOTES_STRINGS
				trFooter.strVal += strMessage;
			}
		}
		
		///Zeck 7/20/2011 ORG-3228-S3 REPLACE_FOOTNOTE_WITH_DECISION_COLUMN
		///Sophy 11/17/2011 ORG-4402-P1 BRING_BACK_FOOTNOTE_FOR_NORMALITYTEST
		///*
		///end BRING_BACK_FOOTNOTE_FOR_NORMALITYTEST
		/// Zech 12/23/2011 ORG-4669-P2 IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
		//if( STATS_NO_ERROR ==  nCalcResult )
		///Sophy 3/20/2012 ORG-5313-P1 IMPROVE_FOOTNOTE_FOR_NORMALITYTEST
		//if( STATS_NO_ERROR ==  nCalcResult && !(0 == strcmp(lpcsztagName, "DK") && index % NORM_DK_TEST_TOTAL != NORM_DK_TEST_OMNIBUS))
		if ( (STATS_NO_ERROR ==  nCalcResult || STATS_ERROR_NE_G08CB_SAMPLE == nCalcResult)
			&& !(0 == strcmp(lpcsztagName, "DK")
			&& index % NORM_DK_TEST_TOTAL != NORM_DK_TEST_OMNIBUS)
			&& (!trRow.Prob || !is_missing_value(trRow.Prob.dVal))
			)
		///end IMPROVE_FOOTNOTE_FOR_NORMALITYTEST
		/// END IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
		{
			/// Zech 12/23/2011 ORG-4669-P2 IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
			int nConclusionNum = 0;
			trFooter.GetAttribute(CONCLUSION_NUM_ATTRIB, nConclusionNum);
			if (nConclusionNum <= CONCLUSION_FOOTNOTE_LIMIT)
			{
				nConclusionNum++;
				trFooter.SetAttribute(CONCLUSION_NUM_ATTRIB, nConclusionNum);
				if (CONCLUSION_FOOTNOTE_LIMIT < nConclusionNum )
				{
					// Remove all the conclusions
					for (int nEnum = 1; nEnum < nConclusionNum; nEnum++)
					{
						string strEnumConclusion;
						trFooter.GetAttribute(CONCLUSION_TEXT_ATTRIB + (string)nEnum, strEnumConclusion);
						trFooter.strVal.Replace(strEnumConclusion, "");
					}
					
					string strNote;
					ocu_load_msg_str(FOOTNOTE_REFER_DECISION, strNote);
					strNote = GetBlueFontedText(strNote);

					if(!trFooter.IsEmpty())
						strMessage = "\n" + strNote;
					
					trFooter.strVal += strNote;
				}
				else
				{
			/// END IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
					/// END IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
					/// Zech 12/09/2011 ORG-4559-P1 FIX_FOOTNOTE_CONCLUSION
					/*
					/// Max 6/8/07 CORRECT_RULE_FOR_CONCLUSION_IN_FOOTNOTE
					// string		strPV = trRow.Prob.dVal > 0.05? " not" : "";
					//--- Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL
					//string		strPV = trRow.Prob.dVal > 0.05? "" : "" + _L("not");
					double dAlpha=trOp.GUI.OptionBranch.alpha.dVal;
					string		strPV = trRow.Prob.dVal > dAlpha? "" : "" + _L("not");
					//--- end USER_CAN_SET_SIGNIFICANCE_LEVEL
					/// END CORRECT_RULE_FOR_CONCLUSION_IN_FOOTNOTE
					///Arvin 10/27/07 LOCALIZED_FOOTNOTES_STRINGS
					//strMessage.Format("%s: At the 0.05 level, the data was%s significantly drawn from a normally distributed population", strLabel, strPV);
					//------ Folger 12/10/07 CLEAN_NEGATIVE_ERROR_MESSAGES
					//ocu_load_msg_str(FOOTNOTE_NORM_PROB, &strMessage, _L(strLabel), NULL, strPV);
					///Arvin 02/15/08 QA70-11097 KEEP_ESCAPED_STRINGS
					//ocu_load_msg_str(trRow.Prob.dVal > 0.05 ? FOOTNOTE_NORM_PROB : FOOTNOTE_NORM_PROB_NEGATIVE, &strMessage, _L(strLabel));
					//--- Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL
					//ocu_load_msg_str(trRow.Prob.dVal > 0.05 ? FOOTNOTE_NORM_PROB : FOOTNOTE_NORM_PROB_NEGATIVE, &strMessage, _L(strTempLabel));
					ocu_load_err_msg_str(trRow.Prob.dVal > dAlpha ? FOOTNOTE_NORM_PROB : FOOTNOTE_NORM_PROB_NEGATIVE, &strMessage);
					strMessage.Format(strMessage, _L(strTempLabel),dAlpha);
					//--- end USER_CAN_SET_SIGNIFICANCE_LEVEL
					///end KEEP_ESCAPED_STRINGS
					//------
					///end LOCALIZED_FOOTNOTES_STRINGS
					*/
					double dAlpha=trOp.GUI.OptionBranch.alpha.dVal;
					
					// Get footnote string according to the result shown in the Decision column in the table.
					ocu_load_err_msg_str(strcmp(STR_NOT_REJECT_NORMALITY, trRow.Decision.strVal) == 0 ? FOOTNOTE_NORM_PROB : FOOTNOTE_NORM_PROB_NEGATIVE, &strMessage);
					/// Zech 12/21/2011 ORG-4669-P1 ADD_GROUPING_INFO_TO_FOOTNOTE
					//strMessage.Format(strMessage, _L(strTempLabel),dAlpha);
					string strFactors = "";
					if (pstNTInfo)
					{
						vector<string> *pvsRowFactors = pstNTInfo->pvsFactors;
						
						if (pvsRowFactors && pvsRowFactors->GetSize() > 0)
						{					
							strFactors.SetTokens(*pvsRowFactors, ',');
							strFactors = "(" + strFactors + ")";
						}
					}			
					strMessage.Format(strMessage, strTempLabel + strFactors,dAlpha);
					/// END ADD_GROUPING_INFO_TO_FOOTNOTE
					
					/// END FIX_FOOTNOTE_CONCLUSION

					/// Zech 12/23/2011 ORG-4669-P2 IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
					/*
					if(!trFooter.IsEmpty())
						strMessage = trFooter.strVal + "\n" + strMessage;
					
					trFooter.strVal = strMessage;
					*/
					if(!trFooter.IsEmpty())
						strMessage = "\n" + strMessage;
					
					trFooter.strVal += strMessage;
					trFooter.SetAttribute(CONCLUSION_TEXT_ATTRIB + (string)nConclusionNum, strMessage);
					/// END IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
			/// Zech 12/23/2011 ORG-4669-P2 IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
				}
			}
			/// END IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
		}
		///Sophy 11/17/2011 ORG-4402-P1 BRING_BACK_FOOTNOTE_FOR_NORMALITYTEST
		//*/
		///end BRING_BACK_FOOTNOTE_FOR_NORMALITYTEST
		///END REPLACE_FOOTNOTE_WITH_DECISION_COLUMN
		
		/// Zech 08/15/2011 ORG-3228-P3 DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
		/*
		/// Zeck 08/04/2011 ORG-3228-S4 NORMALITY_TEST_ADD_THREE_MORE_TESTS
		//if(is_missing_value(trRow.Prob.dVal))
		if(trRow.Prob && is_missing_value(trRow.Prob.dVal))
		/// END NORMALITY_TEST_ADD_THREE_MORE_TESTS
		*/
		if(trRow.Prob && is_missing_value(trRow.Prob.dVal) && STATS_ERROR_TOO_FEW_DATA_PTS != nCalcResult && STATS_ERROR_TOO_MANY_DATA_PTS != nCalcResult)
		/// END DISPLAY_DECISION_ACCORDING_TO_THE_RETURN_OF_TEST
		{
			/// Zech 11/09/2011 ORG-3228-P12 DISPLAY_LABEL_AND_FOOTNOTE_CORRECTLY_WHEN_CANNOT_DRAW_CONCLUSION
			// Use a unite format for "no conclusion" footnote display, without any duplication
			/*
			if(0 != lstrlen(trFooter.strVal))
				trFooter.strVal += "\n";
			///Arvin 10/27/07 LOCALIZED_FOOTNOTES_STRINGS
			//trFooter.strVal += strLabel + ": " + STATS_NO_CONCLUSION;
			string strConclusion;
			ocu_load_msg_str(FOOTNOTE_NO_CONCLUSION, &strConclusion);
			///Arvin 02/15/08 QA70-11097 KEEP_ESCAPED_STRINGS
			//trFooter.strVal += strLabel + ": " + strConclusion;
			trFooter.strVal += strTempLabel + ": " + strConclusion;
			///end KEEP_ESCAPED_STRINGS
			///end LOCALIZED_FOOTNOTES_STRINGS
			*/
			string strConclusion;
			ocu_load_msg_str(FOOTNOTE_NO_CONCLUSION, &strConclusion);
			strConclusion = GetBlueFontedText("c*: " + strConclusion);
			
			if (trFooter.strVal.Find (strConclusion) == -1)
			{
				if(0 != lstrlen(trFooter.strVal))
					trFooter.strVal += "\n";
				trFooter.strVal += strConclusion;
			}
			/// END DISPLAY_LABEL_AND_FOOTNOTE_CORRECTLY_WHEN_CANNOT_DRAW_CONCLUSION
		}
		
		/// Zech 08/05/2011 ORG-3228-S4 NORMALITY_TEST_ADD_THREE_MORE_TESTS			
		if (STATS_WARNING_CANNOT_FIND_ALPHA == nCalcResult)
		{
			/// Zech 12/23/2011 ORG-4669-P2 IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
			// Should not display duplicated footnote when alpha cannot be found
			/*
			if(0 != lstrlen(trFooter.strVal))
				trFooter.strVal += "\n";
			string strConclusion;
			ocu_load_msg_str(CER_NO_DEC_GIVEN_ALPHA, &strConclusion);
			/// Zech 12/09/2011 ORG-4559-P1 FIX_FOOTNOTE_CONCLUSION
			// Color the footnote with blue
			//trFooter.strVal += strTempLabel + ": " + strConclusion;
			trFooter.strVal += "\\p120(\\c4(" + strTempLabel + ": " + strConclusion + "))";
			/// END FIX_FOOTNOTE_CONCLUSION
			*/
			string strConclusion;
			ocu_load_msg_str(CER_NO_DEC_GIVEN_ALPHA, &strConclusion);
			strConclusion = GetBlueFontedText(strConclusion);

			if (trFooter.strVal.Find (strConclusion) == -1)
			{
				if(0 != lstrlen(trFooter.strVal))
					trFooter.strVal += "\n";
				trFooter.strVal += strConclusion;
			}
			/// END IMPROVE_DAgostino_K_squared_TEST_CODING_AND_FOOTNOTE_DISPLAY
		}		
		// END NORMALITY_TEST_ADD_THREE_MORE_TESTS
		
		///end NEW_DESIGN_ON_FOOTNOTE_TO_INCLUDE_ERRORINFO
	 }
	
private:
	 /// Zech 08/15/2011 ORG-3228-P1 SUPPORT_MULTIPLE_GROUPING
	 vector <string> m_vstrFactors;
	 ///END SUPPORT_MULTIPLE_GROUPING
};
