/*------------------------------------------------------------------------------*
 * File Name: NewWorkBookDlg													*
 * Creation : 																	*
 * Purpose: OriginC Source H file												*
 * Copyright (c) Originlab Corp.	2006										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Sen 08/01/2011 ORG-2629-P5 NO_LAST_USED_THEME_CREATED_AFTER_USING			*
 * Sen 08/01/2011 ORG-2629-P6 FAIL_TO_SAVE_AS_DEFAULT							*
 * Sen 08/05/2011 ORG-2629-S6 REDESIGN_WORKSHEET_DIALOG_COLUMN_MODE_INTERFACE   *
 * Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME				*
 * Bill 08/08/2011 ORG-3396 BETTER_LOOKING_FOR_WORKSHEET_WHEN_CHOOSING_REPLICATE*
 * Bill 08/23/2011 ORG-3606-S1 PROVIDE_OPTION_TO_CREATE_PLOT					*
 * Sen 08/024/2011 ORG-3450-S3 ONLY_SHOW_COLUMN_DESIGNATION						*
 *------------------------------------------------------------------------------*/
 
#ifndef NEW_WORKBOOK_DLG_H
#define NEW_WORKBOOK_DLG_H

class NewWorkBookDlg;

///Sophy 7/22/2011 ORG-2629 FILE_NEW_WORKBOOK_DLG
enum {
	ID_COLUMNS_MODE	= 1,
	ID_COLUMN_DESIG,
	ID_GROUPS,
	ID_REPLICA,
	/// Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
	ID_ADD_TO_ACTIVE,
	/// End FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
};

typedef	struct tagWorkbookCreateOptions
{
	int		_id(ID_COLUMNS_MODE)	nColumnsMode;
	string	_id(ID_COLUMN_DESIG)	strColDesig;
	int		_id(ID_GROUPS)			nGroups;
	int		_id(ID_REPLICA)			nReplica;
	/// Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
	int 	_id(ID_ADD_TO_ACTIVE)	nAddToActive;
	/// End FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
}WorkbookCreateOptions;
///end FILE_NEW_WORKBOOK_DLG

class NewWorkBookDlg : public ResizeDialog
{
public:
	NewWorkBookDlg() : ResizeDialog(IDD_NEW_BOOK_DLG, "ODlg8")
	{
	}
	~NewWorkBookDlg()
	{		
	}

	int DoModalEx(HWND hWndParent = NULL)
	{		
		InitMsgMap();
		int nRet = ResizeDialog::DoModal(hWndParent);		
		return nRet;
	}
	
	
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_READY(OnReady)
	
	ON_BN_CLICKED(IDC_SHEET_THEME_SAVE_AS, OnThemeSaveButtonClick)
	
	ON_BN_CLICKED(IDC_RADIO_NEW_WBOOK_WITH_SINGLE_COLUMNS, OnColumnTypeRadioButtonClicked)
	ON_BN_CLICKED(IDC_RADIO_NEW_WBOOK_WITH_GROUPED_COLUMNS, OnColumnTypeRadioButtonClicked)	
	ON_BN_CLICKED(IDC_CHECK_ADD_TO_ACTIVE_WINDOW, OnAddToActiveButtonClicked)
	
	ON_CBN_SELCHANGE(IDC_COMBO_COLUMN_DESIGATION, OnColDesigSelectChanged)
	ON_CBN_EDITCHANGE(IDC_COMBO_COLUMN_DESIGATION, OnColDesigEditChanged)	
	
	ON_CBN_SELCHANGE(IDC_COMBO_NUMBER_OF_GROUPS, OnGroupSelectChanged)
	ON_CBN_EDITCHANGE(IDC_COMBO_NUMBER_OF_GROUPS, OnGroupEditChanged)
	
	ON_CBN_SELCHANGE(IDC_COMBO_NUMBER_OF_REPLICATE, OnReplicaSelectChanged)
	ON_CBN_EDITCHANGE(IDC_COMBO_NUMBER_OF_REPLICATE, OnReplicaEditChanged)	
	
	ON_BN_CLICKED(IDC_CHECK_CREATE_RANDOM_SAMPLE_PLOT, OnCreateSamplePlot) /// Bill 08/23/2011 ORG-3606-S1 PROVIDE_OPTION_TO_CREATE_PLOT
	
	ON_BN_CLICKED(IDOK, OnOK)	
EVENTS_END

	BOOL OnInitDialog();
	BOOL OnReady();
	
	BOOL OnThemeSaveButtonClick(Control ctrl);
	BOOL OnColumnTypeRadioButtonClicked(Control cntrl);
	
	BOOL OnColDesigSelectChanged(Control ctrl);
	BOOL OnColDesigEditChanged(Control ctrl);
	BOOL OnGroupSelectChanged(Control ctrl);
	BOOL OnGroupEditChanged(Control ctrl);
	BOOL OnReplicaSelectChanged(Control ctrl);
	BOOL OnReplicaEditChanged(Control ctrl);
	
	BOOL OnAddToActiveButtonClicked(Control cntrl);
	
	BOOL OnCreateSamplePlot(Control cntrl); /// Bill 08/23/2011 ORG-3606-S1 PROVIDE_OPTION_TO_CREATE_PLOT
	
	BOOL OnOK(Control cntrl);		
	
private:
	void initControls();
	bool initColorTextControl(int nID, ColorText& ctrlColor);
	void moveGroupedColumnsControls();
	BOOL onGroupOrReplicaSelectChange(ComboBox &cbSel, string &strSel, ComboBox &cbAnother, string &strAnother);
	BOOL onGroupOrReplicaEditChange(ComboBox &cbSel, string &strSel, ComboBox &cbAnother, string &strAnother);
	
	void getControlIDsByColumnsMode(vector<uint>& vnIDs, int nColumnsMode);
	void onColumnsModeChange();		
	void updateNumberColumnControl();
	void updateColDesigControl();
	/// Sen 08/05/2011 ORG-2629-S6 REDESIGN_WORKSHEET_DIALOG_COLUMN_MODE_INTERFACE
	void reSizeColumnModeBlank();
	/// End REDESIGN_WORKSHEET_DIALOG_COLUMN_MODE_INTERFACE
	
	/// Bill 08/08/2011 ORG-3396 BETTER_LOOKING_FOR_WORKSHEET_WHEN_CHOOSING_REPLICATE*
	void setNewWksFormat(Worksheet & wks, Grid & grid);	
	void setGroupIdRowColor(Grid & grid, int nReplicateRow);
	void setColumnsShortName(Worksheet & wks, vector<int> & vnXCols);
	void mergerGroupIdRow(Grid & grid, vector<int> & vnXCols, int nReplicateRow);
	void fillGroupId(Worksheet & wks, vector<int> & vnXCols, int nReplicateRow);
	void addLeftBorder(Worksheet & wks, vector<int> & vnXCols);
	/// End BETTER_LOOKING_FOR_WORKSHEET_WHEN_CHOOSING_REPLICATE
	
	// click OK button on dialog
	bool doNewWorkbook();
	bool createPage();
	/// Sen 08/01/2011 ORG-2629-P5 NO_LAST_USED_THEME_CREATED_AFTER_USING
	BOOL OnAfterApply();
	/// End NO_LAST_USED_THEME_CREATED_AFTER_USING
	
	int		getColumnConstructType();
	int		getTargetColDesig(); //may return error code, 0 for success.
	int		getTargetColDesigForIndividualColumns();
	int		getTargetColDesigForGroupColumns(int nLengthLimit = -1); //-1 means no limit
	bool	saveSettings(TreeNode& trSettings);
	bool	loadSettings(const TreeNode& trSettings);
	
	void 	showHidePlotTypeDropdown(); /// Bill 08/23/2011 ORG-3606-S1 PROVIDE_OPTION_TO_CREATE_PLOT
	
	///	Sen 08/01/2011 ORG-2629-P6 FAIL_TO_SAVE_AS_DEFAULT
	BOOL 	ColDesigEditChanged();
	///	End FAIL_TO_SAVE_AS_DEFAULT
	
	///	Sen 08/024/2011 ORG-3450-S3 ONLY_SHOW_COLUMN_DESIGNATION
	void 	onlyShowSingleColumnsControls();
	void 	resizeDlg();
	///	End ONLY_SHOW_COLUMN_DESIGNATION

private:	
	Button			m_rdNewWithSingleCols;
	Button			m_rdNewWithGroupedCols;	
	
	/// Sen 08/08/2011 ORG-2629-P8 FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
	Button			m_chkAddToActive;
	/// End FIX_ADD_TO_ACTIVE_NOT_SVAE_IN_THEME
	
	ThemeControlHelper	m_themeHelper;
	ColorText		m_ctHint;
	ColorText		m_ctNumCols;
	ColorText		m_ctColDesig;
	ComboBox		m_cbColDesig;
	ComboBox		m_cbGroups;
	ComboBox		m_cbReplica;
	ComboBox		m_cbPlotType; /// Bill 08/23/2011 ORG-3606-S1 PROVIDE_OPTION_TO_CREATE_PLOT
	string			m_strTargetColDesig;	
	string			m_strRawColDesig;
	string			m_strNumGroups;
	string			m_strNumReplica;
};
	
#endif NEW_WORKBOOK_DLG_H
