/*------------------------------------------------------------------------------*
 * File Name: NewFunctionPlotHelper.h											*
 * Creation : 																	*
 * Purpose: OriginC Source H file												*
 * Copyright (c) Originlab Corp.	2006										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 07/29/2011 ORG-3350-P2 LAST_USED_IN_FUNCTION_PLOT_DIALOG				*
 *	Folger 07/29/2011 ORG-3366-P1 SMART_RESCALE_WHEN_ADD_TO_GRAPH				*
 *	Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE	*
 *	Folger 08/03/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT	*
 *	Folger 10/18/2011 ORG-3276-P4 AUTO_RANGE_SHOULD_NOT_SHOW_ON_LABEL_TAB		*
 *	Folger 05/30/2012 ORG-5813-P1 ADD_TO_GRAPH_SHOULD_NOT_BE_SHOWN_WHEN_SWITCH_TO_EMPTY_FOLDER
 *	Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
 *	Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
 *	Folger 06/07/2012 ORG-5923 NEW_THEME_TYPE_FOR_FUNCTION_PLOT					*
 *	Folger 06/08/2012 ORG-5925-P1 NOT_SET_ADD_TO_GRAPH_WHEN_APPLY_THEME			*
 *------------------------------------------------------------------------------*/

#ifndef NEW_FUNCTION_PLOT_HELPER_H
#define NEW_FUNCTION_PLOT_HELPER_H


#include "FunctionsMenu.h"
class PreScriptGrid;

///------ Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
enum
{
	ADDTOGRAPH_NO = 0,
	ADDTOGRAPH_YES,
	ADDTOGRAPH_YES_RESCALE,
};
///------ End IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG

class FunctionPlotDlgBase : public ResizeDialog
{
public:
	FunctionPlotDlgBase(int nID, BOOL bParametric);
	~FunctionPlotDlgBase();

	int		DoModalEx(HWND hWndParent = NULL);

	virtual	BOOL	InitMsgMap()	{ O_A_FAIL; return FALSE; }	

	///------ Folger 08/03/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
	virtual	BOOL	CopyTheme(FunctionPlotContext& context);
	///------ End SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
	///------ Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
	virtual BOOL PasteTheme(FunctionPlotContext& context);
	BOOL CanPasteTheme();
	///------ End SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD

	BOOL			SaveSettings(TreeNode& trSettings, int nOption);

protected:
	BOOL		IsParametric()			{ return m_bParametric; }
	TabControl&	Tab()					{ return m_tab; }
	virtual	int	Gap()					{ return GetControlGap(); }
	void		SetShowLT(BOOL bOn);
	BOOL		IsShowLT();
	///------ Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	//void		SetAddToGraph(BOOL bOn);
	//BOOL		IsAddToGraph();
	void		SetAddToGraph(int nn);
	int			IsAddToGraph(BOOL* pbRescale = NULL);
	///------ End IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	void		SetAutoRange(BOOL bOn);
	BOOL		IsAutoRange();
	void		SetAutoRange2(BOOL bOn);
	BOOL		IsAutoRange2();
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE

	BOOL	OnInitDialog(int nRefID, LPCSTR lpcszDlgName);
	BOOL	OnBeforeEditGrid(int nRow, int nCol, BOOL *pCancel);
	void	OnAfterEditGrid(int nRow, int nCol);
	void	OnDlgSettingChange();
	BOOL	ShowGridMenu(int nx, int ny);
	BOOL	OnUpdateFittingFunc(CmdUI cmd);
	BOOL	ConstructMenu();
	void	OnInsertButton(int nIDButton, int nIDEdit);
	BOOL	UpdatePrescriptDisplay(BOOL bShowCntrlsOnly);
	BOOL	UpdatePreScriptFromGrid();
	BOOL	UpdateGridFromPreScript();
	BOOL	OnThemeMenu();
	void	OnShowTab(int nTab);
	BOOL	OnCheckShowLT(Control cntrl);
	BOOL	OnAfterControlEdit(Control cntrl);
	BOOL	OnThemeSaveButtonClick(Control ctrl);
	BOOL	OnUIUpdateFittingFunc(CmdUI cmd);
	BOOL	OnBeforeEditPreScriptGrid(Control ctrl, int nRow, int nCol, BOOL *pCancel);
	void	OnAfterEditPreScriptGrid(Control flxControl, int nRow, int nCol);
	BOOL	OnShowMenu(UINT nResIDCtrl, int nx, int ny);
	BOOL	OnDestroy(); ///------ Folger 06/08/2012 ORG-5925-P1 NOT_SET_ADD_TO_GRAPH_WHEN_APPLY_THEME

	BOOL		SetIntValue(int nID, int nVal);
	int			GetIntValue(int nID);
	BOOL		SetStrValue(int nID, LPCSTR lpcszVal);
	string		GetStrValue(int nID);
	BOOL		SetdoubleValue(int nID, double rVal);

	virtual	void	GetDefaultSettings()			{ O_A_FAIL; }
	virtual	void	LoadThemeSettings();
	virtual	BOOL	SaveThemeSettings();
	virtual	void	LoadSettingsTree(TreeNode& trSettings);
	virtual	void	SaveSettingsTree(TreeNode& trSettings);
	void			LoadSettings(TreeNode& trSettings);

	///------ Folger 07/29/2011 ORG-3350-P2 LAST_USED_IN_FUNCTION_PLOT_DIALOG
	BOOL			OnAfterApply();
	///------ End LAST_USED_IN_FUNCTION_PLOT_DIALOG

	///------ Folger 07/29/2011 ORG-3366-P1 SMART_RESCALE_WHEN_ADD_TO_GRAPH
	BOOL			Rescale(DWORD dwCntrl = 0);
	///------ End SMART_RESCALE_WHEN_ADD_TO_GRAPH
	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	Button&			AutoRange();
	Button&			AutoRange2();
	BOOL			OnCheckAuto(Control cntrl);
	BOOL			OnCheckAddToGraph(Control cntrl);
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE

	///------ Folger 10/18/2011 ORG-3276-P4 AUTO_RANGE_SHOULD_NOT_SHOW_ON_LABEL_TAB
	BOOL		IsShowAutoRange();
	///------ End AUTO_RANGE_SHOULD_NOT_SHOW_ON_LABEL_TAB

	Layer		GetActiveLayer(); ///------ Folger 05/30/2012 ORG-5813-P1 ADD_TO_GRAPH_SHOULD_NOT_BE_SHOWN_WHEN_SWITCH_TO_EMPTY_FOLDER

private:
	virtual	string		DialogTitle()								{ O_A_FAIL; return ""; }
	virtual	string		ClassOption()								{ O_A_FAIL; return ""; }
	virtual	void		UpdateLabelCntrlsText()						{ O_A_FAIL; }
	string				PopupFunctionMenu(int x, int y);
	void				InsertFunction(Edit & ed, string & strText);
	void				SetCntrlFixedFont();
	virtual	void		GetCntrlFixedFont(vector<int>& vnIDs)		{ O_A_FAIL; }

	virtual	void		InitControls();
	virtual	void		ResizeDlg()									{ O_A_FAIL; }
	virtual	void		GetCntrlIDs(int nTab, vector<uint>& vnIDstoShow, vector<uint>& vnIDstoHide)		{ O_A_FAIL; }
	virtual	BOOL		IsShowAddToGraph()							{ O_A_FAIL; return FALSE; }
	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	virtual	void		CheckUpdateRangeFromTo()					{ O_A_FAIL; }
	virtual	void		CheckShowAutoRange();
	virtual	void		CheckSetAutoRange(BOOL bOn);
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE


	void	InitThemeCtrl();
	void	InitTab();
	void	InitTheme(int nComboID, int nButtonID, TreeNode& trSettings, LPCSTR lpcszFile = NULL, LPCSTR lpcszFunc = NULL);
	BOOL	ThemeShowPopupMenu(TreeNode& trToSave, TreeNode& trToLoad, bool& bIsLoading);
	void	SetChangeEventReady(BOOL bReady);

	Button&		ShowLT();
	///------ Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	//Button&		AddToGraph();
	ComboBox&		AddToGraph();
	///------ End IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG

	///------ Folger 06/07/2012 ORG-5923 NEW_THEME_TYPE_FOR_FUNCTION_PLOT
	void	CheckConvertThemeFiles();
	///------ End NEW_THEME_TYPE_FOR_FUNCTION_PLOT

	///------ Folger 06/08/2012 ORG-5925-P1 NOT_SET_ADD_TO_GRAPH_WHEN_APPLY_THEME
	string GetDlgSettingsName() { return ClassOption() + "Dlg"; }
	///------ End NOT_SET_ADD_TO_GRAPH_WHEN_APPLY_THEME

private:
	NewFunctionPlotMenu*		m_pMenu;
	Menu						m_menu;
	BOOL						m_bParametric;
	BOOL						m_b3D;

	TabControl					m_tab;
	
	PreScriptGrid*				m_pGrid;
	Button						m_checkShowLT;
	///------ Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	//Button						m_checkAddToGraph;
	ComboBox						m_comboAddToGraph;
	///------ End IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	Button						m_checkAuto;
	Button						m_checkAuto2;
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	
	ThemeControlHelper			m_themeHelper;
};
#endif // NEW_FUNCTION_PLOT_HELPER_H
