/*------------------------------------------------------------------------------*
 * File Name: NewFunctionPlotHelper.h											*
 * Creation : 																	*
 * Purpose: OriginC Source H file												*
 * Copyright (c) Originlab Corp.	2006										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 07/29/2011 ORG-3352-P1 FAILED_TO_TYPE_CELL_AFTER_ERROR_MSG_SHOWN		*
 *	Folger 07/29/2011 ORG-3350-P2 LAST_USED_IN_FUNCTION_PLOT_DIALOG				*
 *	Folger 07/29/2011 ORG-3366-P1 SMART_RESCALE_WHEN_ADD_TO_GRAPH				*
 *	Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE	*
 *	Folger 08/03/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT	*
 *	Folger 10/17/2011 ORG-4130-P1 FAILED_TO_OPEN_FUNCTION_LIST_MENU_IN_NEW_FUNCTION_PLOT_DIALOG
 *	Folger 10/18/2011 ORG-3276-P4 AUTO_RANGE_SHOULD_NOT_SHOW_ON_LABEL_TAB		*
 *	Folger 12/20/2011 ORG-4647-P1 SYS_VAR_TO_CONTROL_OC_FORMULA_EDIT_FONT		*
 *	Folger 05/09/2012 ORG-5651-P1 FUNCTION_PLOT_BEFORE_SCRIPT_FAILED_TO_BE_SAVED*
 *	Folger 05/30/2012 ORG-5813-P1 ADD_TO_GRAPH_SHOULD_NOT_BE_SHOWN_WHEN_SWITCH_TO_EMPTY_FOLDER
 *	Folger 06/01/2012 ORG-5813-S2 IMPROVE_ERROR_MSG_WHEN_CONVERT_DOUBLE_DECLARATION_IN_NEW_FUNCTION_PLOT_DIALOG
 *	Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
 *	Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
 *	Folger 06/07/2012 ORG-5923 NEW_THEME_TYPE_FOR_FUNCTION_PLOT					*
 *	Folger 06/08/2012 ORG-5925-P1 NOT_SET_ADD_TO_GRAPH_WHEN_APPLY_THEME			*
 *	Folger 07/03/2012 ORG-6128-P1 RUNTIME_ERROR_WHEN_MAKE_FUNCTION_PLOT_ON_EMBEDED_GRAPH
 *	Folger 07/16/2012 ORG-6225-P1 SHOULD_NOT_SHOW_VARIABLE_ERROR_WHEN_POPUP_THEME_MENU_OF_FUNCTION_PLOT_DIALOG
 * EJP 2012-10-03 ORG-7041 NEW_TRIG_FUNC_CATEGORY								*
 *------------------------------------------------------------------------------*/

#include <origin.h>
#include "DialogEx.h"
#include <ocu.h>
#include "NewFunctionPlotHelper.h"

enum
{
	PRESCRIPTGRID_COL_NAME		= 1,	
	PRESCRIPTGRID_COL_VALUE,
};

#define		STR_COL_HEADING		_L("|Name|Value")

class PreScriptGrid : public GridListControl
{
public:
	PreScriptGrid()
	{
	}

	void	Init(int nID, Dialog& dlg)
	{
		GridListControl::Init(nID, dlg);
		
		SetupRowsCols(0, 1, 2, 3);
		
		SetEditable(flexEDKbdMouse);
		
		SetColHeader(STR_COL_HEADING);
		SetColAlignment(-1, flexAlignCenterCenter);
		
		SetColWidth(0, 200);
	}

	BOOL	OnBeforeEdit(int nRow, int nCol, BOOL* pCancel)
	{
		switch ( nCol )
		{
		case PRESCRIPTGRID_COL_NAME:
			m_strTemp = GetCell(nRow, nCol);
			break;
			
		case PRESCRIPTGRID_COL_VALUE:
			break;
			
		default:
			O_A_FAIL;
			break;
		}
		
		return TRUE;
	}
	
	void	OnAfterEdit(int nRow, int nCol)
	{
		BOOL	bEnterDown = ENTER_DOWN;
		switch ( nCol )
		{
		case PRESCRIPTGRID_COL_NAME:
			{
				string		strName = GetCell(nRow, nCol);
				string		strErr;
				if ( !IsValidCName(strName, &strErr) )
				{
					HWND	hWnd = GetFocus();
					warning_msg_box(strErr, true);
					SetFocus(hWnd);
					SetCell(nRow, nCol, m_strTemp);
					///------ Folger 07/29/2011 ORG-3352-P1 FAILED_TO_TYPE_CELL_AFTER_ERROR_MSG_SHOWN
					EditCell();
					///------ End FAILED_TO_TYPE_CELL_AFTER_ERROR_MSG_SHOWN
					return;
				}
				if ( bEnterDown )
				{
					SelCell(nRow, PRESCRIPTGRID_COL_VALUE);
				}
			}
			break;
			
		case PRESCRIPTGRID_COL_VALUE:
			if ( bEnterDown )
			{
				if ( nRow == GetRows() - 1 )
					AddOneRow();
				SelCell(nRow + 1, PRESCRIPTGRID_COL_NAME);
			}
			break;
			
		default:
			O_A_FAIL;
			break;
		}
	}

	#define		STR_VARIABLE_NAME_EMTPY				_L("Variable Name cannot be empty")
	#define		STR_VARIABLE_VALUE_EMTPY			_L("Variable Value cannot be empty")
	BOOL	UpdateToLTScript(Control& ctrl)
	{
		int		nRowOffset = GetRowOffset();
		int		nRows = GetRows();
		
		StringArray		arrExps;
		for ( int row = nRowOffset; row<nRows; ++row )
		{
			string		strName = GetCell(row, PRESCRIPTGRID_COL_NAME);
			string		strValue = GetCell(row, PRESCRIPTGRID_COL_VALUE);
			strName.TrimLeft(), strName.TrimRight();
			strValue.TrimLeft(), strValue.TrimRight();
			
			BOOL		bNameEmpty = strName.IsEmpty();
			BOOL		bValueEmpty = strValue.IsEmpty();
			if ( bNameEmpty && bValueEmpty )
				continue;
			
			if ( bNameEmpty )
			{
				warning_msg_box(STR_VARIABLE_NAME_EMTPY, true, 'W', MB_TASKMODAL | MB_OK);
				return FALSE;
			}
			if ( bValueEmpty )
			{
				warning_msg_box(STR_VARIABLE_VALUE_EMTPY, true, 'W', MB_TASKMODAL | MB_OK);
				return FALSE;
			}

			string		strErr;
			if ( !IsValidCName(strName, &strErr) )
			{
				warning_msg_box(strErr, true);
				return FALSE;
			}
			
			string		str;
			str.Format("double %s = %s;", strName, strValue);
			arrExps.Add(str);
		}
		
		string		strLT;
		ocu_set_tokens_by_str(&strLT, &arrExps, "\r\n");
		ctrl.Text = strLT;
		return TRUE;
	}

	BOOL	UpdateFromLTScript(Control& ctrl)
	{
		StringArray		arrExps;
		string			strLT = ctrl.Text;
		strLT.GetTokens(arrExps, ';');
		
		string		strInvalidExp;
		StringArray	arrNames, arrValues;
		for ( int ii=0; ii<arrExps.GetSize(); ++ii )
		{
			arrExps[ii].TrimLeft(), arrExps[ii].TrimRight();
			if ( arrExps[ii].IsEmpty() )
				continue;
			
			int			nEqual = arrExps[ii].Find('=');
			if ( nEqual <= 0 )
				///------ Folger 06/05/2012 ORG-5813-S2 IMPROVE_ERROR_MSG_WHEN_CONVERT_DOUBLE_DECLARATION_IN_NEW_FUNCTION_PLOT_DIALOG
				//return UpdateFromLTScriptErrorReport(arrExps[ii]);
				return UpdateFromLTScriptErrorReport();
				///------ End IMPROVE_ERROR_MSG_WHEN_CONVERT_DOUBLE_DECLARATION_IN_NEW_FUNCTION_PLOT_DIALOG
			
			string		strVar = arrExps[ii].Mid(0, nEqual);
			string		strVal = arrExps[ii].Mid(nEqual + 1);
			strVar.TrimLeft(), strVar.TrimRight();
			strVal.TrimLeft(), strVal.TrimRight();
			
			StringArray		arr;
			if ( strVar.GetTokens(arr) != 2
				|| arr[0].CompareNoCase("double") != 0
				)
				///------ Folger 06/05/2012 ORG-5813-S2 IMPROVE_ERROR_MSG_WHEN_CONVERT_DOUBLE_DECLARATION_IN_NEW_FUNCTION_PLOT_DIALOG
				//return UpdateFromLTScriptErrorReport(arrExps[ii]);
				return UpdateFromLTScriptErrorReport();
				///------ End IMPROVE_ERROR_MSG_WHEN_CONVERT_DOUBLE_DECLARATION_IN_NEW_FUNCTION_PLOT_DIALOG

			string		strErr;
			if ( !IsValidCName(arr[1], &strErr) )
				///------ Folger 06/05/2012 ORG-5813-S2 IMPROVE_ERROR_MSG_WHEN_CONVERT_DOUBLE_DECLARATION_IN_NEW_FUNCTION_PLOT_DIALOG
				//return UpdateFromLTScriptErrorReport(arrExps[ii], strErr);
				return UpdateFromLTScriptErrorReport(NULL, strErr);
				///------ End IMPROVE_ERROR_MSG_WHEN_CONVERT_DOUBLE_DECLARATION_IN_NEW_FUNCTION_PLOT_DIALOG
			
			arrNames.Add(arr[1]);
			arrValues.Add(strVal);
		}
		
		return Update(arrNames, arrValues);
	}

	#define			ID_PRESCRIPT_MENU_NEW_ROW			0x0001
	#define			ID_PRESCRIPT_MENU_DELETE_ROW		0x0002
	
	BOOL	ShowMenu(int nx, int ny, HWND hWnd)
	{
		int		nRow, nCol;
		GetMouseCell(nRow, nCol);
		int		nRowOffset = GetRowOffset();	
		if ( nRow < 0 )
			return FALSE;
		
		Menu	myMenu;
		myMenu.Add(_L("New"), ID_PRESCRIPT_MENU_NEW_ROW);
		myMenu.Add(_L("Delete"), ID_PRESCRIPT_MENU_DELETE_ROW, GetRows() == nRowOffset + 1 ? MF_GRAYED : MF_STRING);
		
		int		nCmd = 0;
		myMenu.TrackPopupMenu(0, nx, ny, hWnd, &nCmd);
		switch ( nCmd )
		{
		case ID_PRESCRIPT_MENU_NEW_ROW:
			AddOneRow();
			break;

		case ID_PRESCRIPT_MENU_DELETE_ROW:
			DeleteRow(nRow);
			break;
			
		default:
			break;
		}
		
		return TRUE;
	}
	
private:
	BOOL	Update(StringArray& arrNames, StringArray& arrValues)
	{
		O_A(arrNames.GetSize() == arrValues.GetSize());
		
		int		nRowOffset = GetRowOffset();
		int		nRows = nRowOffset + arrNames.GetSize();
		SetRows(nRows, false);
		
		for ( int row=nRowOffset; row<nRows; ++row )
		{
			SetCell(row, PRESCRIPTGRID_COL_NAME, arrNames[row-nRowOffset]);
			SetCell(row, PRESCRIPTGRID_COL_VALUE, arrValues[row-nRowOffset]);
		}
		
		if ( nRows == nRowOffset )
			SetRows(nRows + 1, false);
		return TRUE;
	}
	
	///------ Folger 06/05/2012 ORG-5813-S2 IMPROVE_ERROR_MSG_WHEN_CONVERT_DOUBLE_DECLARATION_IN_NEW_FUNCTION_PLOT_DIALOG
	//BOOL	UpdateFromLTScriptErrorReport(LPCSTR lpcszExp, LPCSTR lpcszErr = NULL)
	BOOL	UpdateFromLTScriptErrorReport(LPCSTR lpcszExp = NULL, LPCSTR lpcszErr = NULL)
	///------ End IMPROVE_ERROR_MSG_WHEN_CONVERT_DOUBLE_DECLARATION_IN_NEW_FUNCTION_PLOT_DIALOG
	{
		string		strErr;
		///------ Folger 06/01/2012 ORG-5813-S2 IMPROVE_ERROR_MSG_WHEN_CONVERT_DOUBLE_DECLARATION_IN_NEW_FUNCTION_PLOT_DIALOG
		//strErr.Format(_L("Invalid expression found : %s"), lpcszExp);
		string strMainErr = _L("Only declared double variables can be converted");
		if ( lpcszExp )
		{
			strErr.Format(_L("%s\r\n\r\n%s : %s"), strMainErr, _L("Invalid expression found"), lpcszExp);
		}
		else
		{
			strErr = strMainErr;
		}
		///------ End IMPROVE_ERROR_MSG_WHEN_CONVERT_DOUBLE_DECLARATION_IN_NEW_FUNCTION_PLOT_DIALOG
		if ( lpcszErr )
			strErr += (string)"\r\n" + lpcszErr;

		warning_msg_box(strErr, true);
		return FALSE;
	}

	BOOL	IsValidCName(LPCSTR lpcszName, string* pstrErr = NULL)
	{
		string		strName(lpcszName);
		strName.MakeValidCName();
		BOOL		bIsValid = strName.Compare(lpcszName) == 0;
		if ( !bIsValid && pstrErr )
		{
			pstrErr->Format(_L("%s is not a valid variable name"), lpcszName);
		}
		return bIsValid;
	}
	
private:
	string		m_strTemp;
};





#define STR_FUNC_PLOT_FAVORITES "FuncPlot User Favorites"
#define STR_ADDTOGRAPH_SETTING_NAME "AddToGraph" ///------ Folger 06/08/2012 ORG-5925-P1 NOT_SET_ADD_TO_GRAPH_WHEN_APPLY_THEME

enum
{
	DLG_TYPE_FUNC_NORMAL,
	DLG_TYPE_FUNC_PARAMETERIC,
};

enum
{
	TAB_FUNCTION,
	TAB_LABEL,
};


FunctionPlotDlgBase::FunctionPlotDlgBase(int nID, BOOL bParametric) : ResizeDialog(nID, "ODlg8")
{
	m_bParametric = bParametric;
	m_pGrid = new PreScriptGrid;
}

FunctionPlotDlgBase::~FunctionPlotDlgBase()
{
	NICE_SAFE_REMOVAL(m_pGrid);
}

int		FunctionPlotDlgBase::DoModalEx(HWND hWndParent/* = NULL*/)
{
	InitMsgMap();
	return ResizeDialog::DoModal(hWndParent);		
}

BOOL	FunctionPlotDlgBase::OnInitDialog(int nRefID, LPCSTR lpcszDlgName)
{
	ResizeDialog::OnInitDialog(nRefID, lpcszDlgName);

	///------ Folger 06/07/2012 ORG-5923 NEW_THEME_TYPE_FOR_FUNCTION_PLOT
	CheckConvertThemeFiles();
	///------ End NEW_THEME_TYPE_FOR_FUNCTION_PLOT

	Text = DialogTitle();

	m_pGrid->Init(IDC_PLOTDTLS_FUNC_PRESCRIPT_GRID, *this);

	UpdateLabelCntrlsText();	

	SetCntrlFixedFont();

	InitTab();

	InitControls();

	InitThemeCtrl();

	OnShowTab(TAB_FUNCTION);

	ResizeDlg();
	
	return TRUE;
}

string	FunctionPlotDlgBase::PopupFunctionMenu(int x, int y)
{
	if (m_pMenu == NULL)
		return "";
	
	int		nCmd;
	m_pMenu->TrackPopupMenu(TPM_NOTIFY, x, y, GetSafeHwnd(), &nCmd);
	return m_pMenu->GetFunctionString(nCmd);
}

void	FunctionPlotDlgBase::InsertFunction(Edit & ed, string & strText)
{
	string strSel = ed.GetSelText();
	bool bStrRet = (strText.GetLength() > 0 && strText[strText.GetLength() - 1] == '$');
	
	int nLeftBracketPos = strText.Find('(');
	int nRightBracketPos = strText.Find(')');
	
	bool bFunctionStr = true;
	bool bParentheses = bFunctionStr && nLeftBracketPos >= 0 && nRightBracketPos > nLeftBracketPos;
	if(bParentheses)
	{
		string strTmp = strText.Mid(nLeftBracketPos + 1, nRightBracketPos - nLeftBracketPos - 1);
		strTmp.Remove(',');				// only
		strTmp.TrimLeft();
		strTmp.TrimRight();
		bParentheses = strTmp.IsEmpty();
	}
	
	if(bParentheses)
	{
		int nSpaceIndex = strText.Find(' ');
		int nParenIndex = strText.Find('(');
		if(nSpaceIndex > 0 && nSpaceIndex < nParenIndex)	// space before (
		{
			int nLength = strText.GetLength() - nSpaceIndex - 1;		// length after the space
			strText = strText.Right(nLength);
			strText.TrimLeft();
		}
		
		nParenIndex = strText.ReverseFind(')');		// the last ')'
		if(nParenIndex > 0)
			strText.Insert(nParenIndex, strSel);
	}
	
	ed.ReplaceSel(strText, true);
	
	if(bParentheses && strSel.IsEmpty())
	{
		long nBegin, nEnd;
		ed.GetSel(nBegin, nEnd);
		nBegin -= bStrRet ? 2 : 1;
		ed.SetSel(nBegin, nBegin);
	}
	
	SetFocus(ed.GetSafeHwnd());
	
	m_pMenu->UpdateFuncHistoryList(strText);
}

void	FunctionPlotDlgBase::InitThemeCtrl()
{
	InitRadioBitmapButton(IDC_THEME_BN, IDB_DROP_DOWN_UP);

	Tree trSettings;
	SaveSettings(trSettings, SEETING_TREE_WITH_DEFAULT);
	InitTheme(IDC_COMBO_THEME, IDC_THEME_BN, trSettings);

	LoadSettings(trSettings);
}

BOOL	FunctionPlotDlgBase::OnUpdateFittingFunc(CmdUI cmd)
{
	if (m_pMenu == NULL)
		return false;
	
	return m_pMenu ? m_pMenu->OnUpdateFittingFunc(cmd) : FALSE;
}

BOOL	FunctionPlotDlgBase::ConstructMenu()
{
	vector<uint> vnCategoryIDs = {
		IDC_FUNCTION_MENU_MATH, 
		IDC_FUNCTION_MENU_TRIG, /// EJP 2012-10-03 ORG-7041 NEW_TRIG_FUNC_CATEGORY
		IDC_FUNCTION_MENU_DATE_TIME,
		IDC_FUNCTION_MENU_STATS, 
		
		IDC_FUNCTION_MENU_CDF,
		IDC_FUNCTION_MENU_PDF,
		IDC_FUNCTION_MENU_INV,
		
		IDC_FUNCTION_MENU_DATA_GENERATION,
		IDC_FUNCTION_MENU_DATA_MANIPULATION,
		IDC_FUNCTION_MENU_NAG,
		IDC_FUNCTION_MENU_FIT_FUNC,
		IDC_FUNCTION_MENU_MISCELLANEOUS,
		IDC_FUNCTION_MENU_USER_DEFINED,
		IDC_FUNCTION_MENU_FAVORITE
	}
	
	///------ Folger 10/17/2011 ORG-4130-P1 FAILED_TO_OPEN_FUNCTION_LIST_MENU_IN_NEW_FUNCTION_PLOT_DIALOG
	//HINSTANCE hInst = (HINSTANCE) okutil_load_dll(GetFilePath(__FILE__) + "ODlg8.dll");	
	HINSTANCE hInst = (HINSTANCE) okutil_load_dll(ORIGINC_SOURCE_PATH_ORIGINLAB + "ODlg8.dll");	
	///------ End FAILED_TO_OPEN_FUNCTION_LIST_MENU_IN_NEW_FUNCTION_PLOT_DIALOG
	if ( NULL == hInst )
		return FALSE;

	BOOL	bOK = m_menu.Load(hInst, IDR_NEW_FUNCTION_PLOT, 0);
	FreeLibrary(hInst);
	if ( !bOK )
		return FALSE;

	HMENU hMenu = m_menu.GetSafeHmenu();
	
	m_pMenu = new NewFunctionPlotMenu(hMenu, STR_FUNC_PLOT_FAVORITES, vnCategoryIDs);
	m_pMenu->Construct();
	return TRUE;
}

void	FunctionPlotDlgBase::SetCntrlFixedFont()
{
	vector<int>		vnIDs;
	GetCntrlFixedFont(vnIDs);
	for ( int ii=0; ii<vnIDs.GetSize(); ++ii )
	{
		///------ Folger 12/20/2011 ORG-4647-P1 SYS_VAR_TO_CONTROL_OC_FORMULA_EDIT_FONT
		//GetItem(vnIDs[ii]).UseSysFont(GSFI_SYSTEM_MENU, TRUE);
		UseSysFont(vnIDs[ii]);
		///------ End SYS_VAR_TO_CONTROL_OC_FORMULA_EDIT_FONT
	}
}

/// virtual
void	FunctionPlotDlgBase::InitControls()
{
	InitRadioBitmapButton(IDC_PLOTDTLS_FUNC_PRESCRIPT_INSERT, IDB_DROP_DOWN_UP);
	ShowLT();
	AddToGraph().Visible = IsShowAddToGraph();
	///------ Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	AddToGraph().ResetContent();
	AddToGraph().AddString(_L("Create New Graph"));
	AddToGraph().AddString(_L("Add to Active Graph"));
	AddToGraph().AddString(_L("Add to Active Graph and Rescale"));
	///------ Folger 06/08/2012 ORG-5925-P1 NOT_SET_ADD_TO_GRAPH_WHEN_APPLY_THEME
	AddToGraph().SetCurSel(LoadSetting(STR_ADDTOGRAPH_SETTING_NAME, 0, GetDlgSettingsName()));
	///------ End NOT_SET_ADD_TO_GRAPH_WHEN_APPLY_THEME
	AddToGraph().AdjustDroppedWidth();
	///------ End IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	CheckShowAutoRange();
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
}

#define		VALID_BUTTON(_btn, _nID) \
			if ( !_btn ) \
				_btn = GetItem(_nID); \
			return _btn;

Button&		FunctionPlotDlgBase::ShowLT()
{
	VALID_BUTTON(m_checkShowLT, IDC_PLOTDTLS_FUNC_SHOW_LT_SCRIPT);
}

///------ Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
//Button&		FunctionPlotDlgBase::AddToGraph()
//{
//	VALID_BUTTON(m_checkAddToGraph, IDC_PLOTDTLS_FUNC_ADD_TO_GRAPH);
//}
ComboBox&		FunctionPlotDlgBase::AddToGraph()
{
	VALID_BUTTON(m_comboAddToGraph, IDC_PLOTDTLS_FUNC_ADD_TO_GRAPH);
}
///------ End IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG

///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
Button&		FunctionPlotDlgBase::AutoRange()
{
	VALID_BUTTON(m_checkAuto, IDC_PLOTDTLS_FUNC_AUTO_RANGE);
}

Button&		FunctionPlotDlgBase::AutoRange2()
{
	VALID_BUTTON(m_checkAuto2, IDC_PLOTDTLS_FUNC_AUTO_RANGE2);
}

BOOL	FunctionPlotDlgBase::OnCheckAuto(Control cntrl)
{
	OnDlgSettingChange();
	CheckUpdateRangeFromTo();
	return TRUE;
}

BOOL	FunctionPlotDlgBase::OnCheckAddToGraph(Control cntrl)
{
	CheckShowAutoRange();
	if ( IsAddToGraph() )
		CheckSetAutoRange(TRUE);
	CheckUpdateRangeFromTo();
	return TRUE;
}

/// virtual
void	FunctionPlotDlgBase::CheckShowAutoRange()
{
	///------ Folger 10/18/2011 ORG-3276-P4 AUTO_RANGE_SHOULD_NOT_SHOW_ON_LABEL_TAB
	//AutoRange().Visible = IsAddToGraph();
	AutoRange().Visible = IsShowAutoRange();
	///------ End AUTO_RANGE_SHOULD_NOT_SHOW_ON_LABEL_TAB
}

/// virtual
void	FunctionPlotDlgBase::CheckSetAutoRange(BOOL bOn)
{
	SetAutoRange(bOn);
}
///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE

void	FunctionPlotDlgBase::SetShowLT(BOOL bOn)
{
	ShowLT().Check = bOn;
}

BOOL	FunctionPlotDlgBase::IsShowLT()
{
	return ShowLT().Check;
}

///------ Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
//void	FunctionPlotDlgBase::SetAddToGraph(BOOL bOn)
//{
//	AddToGraph().Check = bOn;
//}
void	FunctionPlotDlgBase::SetAddToGraph(int nn)
{
	AddToGraph().SetCurSel(nn);
}
///------ End IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG

///------ Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
//BOOL	FunctionPlotDlgBase::IsAddToGraph()
//{
//	return AddToGraph().Visible && AddToGraph().Check;
//}
int	FunctionPlotDlgBase::IsAddToGraph(BOOL* pbRescale/* = NULL*/)
{
	if ( !AddToGraph().Visible )
		return 0;

	int nn = AddToGraph().GetCurSel();
	if ( pbRescale )
		*pbRescale = ADDTOGRAPH_YES_RESCALE == nn;

	return nn;
}
///------ End IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG

///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
void	FunctionPlotDlgBase::SetAutoRange(BOOL bOn)
{
	AutoRange().Check = bOn;
}

BOOL	FunctionPlotDlgBase::IsAutoRange()
{
	return !IsParametric() && IsAddToGraph() && AutoRange().Check;
}

void	FunctionPlotDlgBase::SetAutoRange2(BOOL bOn)
{
	AutoRange2().Check = bOn;
}

BOOL	FunctionPlotDlgBase::IsAutoRange2()
{
	return !IsParametric() && IsAddToGraph() && AutoRange2().Check;
}
///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE





BOOL	FunctionPlotDlgBase::OnBeforeEditGrid(int nRow, int nCol, BOOL *pCancel)
{
	return m_pGrid->OnBeforeEdit(nRow, nCol, pCancel);
}

void	FunctionPlotDlgBase::OnAfterEditGrid(int nRow, int nCol)
{
	OnDlgSettingChange();
	m_pGrid->OnAfterEdit(nRow, nCol);
}

BOOL	FunctionPlotDlgBase::ShowGridMenu(int nx, int ny)
{
	return m_pGrid->ShowMenu(nx, ny, GetSafeHwnd());
}

void	FunctionPlotDlgBase::InitTab()
{
	m_tab = GetItem(IDC_TAB);
	m_tab.InsertItem(TAB_FUNCTION, _L("Function"));
	m_tab.InsertItem(TAB_LABEL, _L("Label"));
	m_tab.SetCurSel(0);
}

void	FunctionPlotDlgBase::InitTheme(int nComboID, int nButtonID, TreeNode& trSettings, LPCSTR lpcszFile/* = NULL*/, LPCSTR lpcszFunc/* = NULL*/)
{
	m_themeHelper.Init(this, nComboID, nButtonID, trSettings, lpcszFile, lpcszFunc);
}

///------ Folger 07/16/2012 ORG-6225-P1 SHOULD_NOT_SHOW_VARIABLE_ERROR_WHEN_POPUP_THEME_MENU_OF_FUNCTION_PLOT_DIALOG
static FunctionPlotDlgBase* g_pFunctionPlotDlg = NULL;
static BOOL _theme_menu_callback(int nCmd, TreeNode& trToSave, TreeNode& trToLoading)
{
	switch ( nCmd )
	{
	case THEME_MENU_SAVE_AS_DEFAULT:
	case THEME_MENU_SAVE:
	case THEME_MENU_SAVE_AS:
	case THEME_MENU_COPY:
		if ( !g_pFunctionPlotDlg->SaveSettings(trToSave, SEETING_TREE_WITH_VALUE) )
			return FALSE;

	default:
		break;
	}
	return TRUE;
}
///------ End SHOULD_NOT_SHOW_VARIABLE_ERROR_WHEN_POPUP_THEME_MENU_OF_FUNCTION_PLOT_DIALOG

BOOL	FunctionPlotDlgBase::ThemeShowPopupMenu(TreeNode& trToSave, TreeNode& trToLoad, bool& bIsLoading)
{
	///------ Folger 07/16/2012 ORG-6225-P1 SHOULD_NOT_SHOW_VARIABLE_ERROR_WHEN_POPUP_THEME_MENU_OF_FUNCTION_PLOT_DIALOG
	//return m_themeHelper.ShowPopupMenu(GetSafeHwnd(), trToSave, trToLoad, bIsLoading);
	g_pFunctionPlotDlg = this;
	BOOL bReutrn = m_themeHelper.ShowPopupMenu(GetSafeHwnd(), trToSave, trToLoad, bIsLoading, _theme_menu_callback);
	g_pFunctionPlotDlg = NULL;
	return bReutrn;
	///------ End SHOULD_NOT_SHOW_VARIABLE_ERROR_WHEN_POPUP_THEME_MENU_OF_FUNCTION_PLOT_DIALOG
}

void	FunctionPlotDlgBase::SetChangeEventReady(BOOL bReady)
{
	m_themeHelper.SetChangeEventReady(bReady);
}

void	FunctionPlotDlgBase::OnDlgSettingChange()
{
	m_themeHelper.OnDlgSettingChange();
}

void	FunctionPlotDlgBase::OnInsertButton(int nIDButton, int nIDEdit)
{
	RECT rrButton;
	GetControlClientRect(nIDButton, rrButton);
	m_wndDlg.ClientToScreen(&rrButton);
	
	string strText = PopupFunctionMenu(rrButton.right, rrButton.top);
	if (strText.IsEmpty())
		return;
	
	Edit ed = GetItem(nIDEdit);
	InsertFunction(ed, strText);
}

BOOL	FunctionPlotDlgBase::UpdatePrescriptDisplay(BOOL bShowCntrlsOnly)
{
	if ( Tab().GetCurSel() != TAB_FUNCTION )
		return FALSE;
	
	BOOL	bShowLT = IsShowLT();
	BOOL	bReturn = TRUE;
	if ( !bShowCntrlsOnly )
	{
		if ( bShowLT )
		{
			if ( !UpdatePreScriptFromGrid() )
			{
				SetShowLT((bShowLT = FALSE));
				bReturn = FALSE;
			}
		}
		else
		{
			if ( !UpdateGridFromPreScript() )
			{
				SetShowLT((bShowLT = TRUE));
				bReturn = TRUE;
			}
		}
	}
	
	GetItem(IDC_PLOTDTLS_FUNC_PRESCRIPT_LABEL).Text = bShowLT ? _L("Before Formula Script") : _L("Definition");
	GetItem(IDC_PLOTDTLS_FUNC_PRESCRIPT_INSERT).Visible = GetItem(IDC_PLOTDTLS_FUNC_PRESCRIPT).Visible = bShowLT;
	GetItem(IDC_PLOTDTLS_FUNC_PRESCRIPT_GRID).Visible = !bShowLT;
	
	return bReturn;
}

BOOL	FunctionPlotDlgBase::UpdatePreScriptFromGrid()
{
	return m_pGrid->UpdateToLTScript(GetItem(IDC_PLOTDTLS_FUNC_PRESCRIPT));
}

BOOL	FunctionPlotDlgBase::UpdateGridFromPreScript()
{
	return m_pGrid->UpdateFromLTScript(GetItem(IDC_PLOTDTLS_FUNC_PRESCRIPT));
}

/// virtual
void	FunctionPlotDlgBase::LoadThemeSettings()
{
	CheckShowAutoRange();
	CheckUpdateRangeFromTo();
	///------ Folger 05/09/2012 ORG-5651-P1 FUNCTION_PLOT_BEFORE_SCRIPT_FAILED_TO_BE_SAVED
	//UpdatePrescriptDisplay(FALSE);
	UpdatePrescriptDisplay(IsShowLT());
	///------ End FUNCTION_PLOT_BEFORE_SCRIPT_FAILED_TO_BE_SAVED
}

/// virtual
BOOL	FunctionPlotDlgBase::SaveThemeSettings()
{
	if ( !IsShowLT() )
	{
		if ( !UpdatePreScriptFromGrid() )
			return FALSE;
	}

	return TRUE;
}

/// virtual
void	FunctionPlotDlgBase::LoadSettingsTree(TreeNode& trSettings)
{	
}

/// virtual
void	FunctionPlotDlgBase::SaveSettingsTree(TreeNode& trSettings)
{
	trSettings.SetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, ClassOption());	
	/// Sen 7/25/2011 ORG-3273-S1 SAVE_THEME_WITH_CORRECT_FOLDER
	//trSettings.SetAttribute(STR_THEME_TYPE_ATTRIB, THTYPE_ANALYSIS);
	///------ Folger 06/07/2012 ORG-5923 NEW_THEME_TYPE_FOR_FUNCTION_PLOT
	//trSettings.SetAttribute(STR_THEME_TYPE_ATTRIB, THTYPE_DIALOG);
	trSettings.SetAttribute(STR_THEME_TYPE_ATTRIB, THTYPE_FUNCTION);
	///------ End NEW_THEME_TYPE_FOR_FUNCTION_PLOT
	/// END SAVE_THEME_WITH_CORRECT_FOLDER
}

void	FunctionPlotDlgBase::LoadSettings(TreeNode& trSettings)
{
	LoadSettingsTree(trSettings);
	LoadThemeSettings();
}

BOOL	FunctionPlotDlgBase::SaveSettings(TreeNode& trSettings, int nOption)
{
	if( nOption == SEETING_TREE_WITH_DEFAULT )
	{
		GetDefaultSettings();
	}
	else if( nOption == SEETING_TREE_WITH_VALUE )
	{
		if ( !SaveThemeSettings() )
			return FALSE;
	}

	SaveSettingsTree(trSettings);
	return TRUE;
}


BOOL	FunctionPlotDlgBase::SetIntValue(int nID, int nVal)
{
	return SetStrValue(nID, (string)nVal);
}

int		FunctionPlotDlgBase::GetIntValue(int nID)
{
	string		str = GetStrValue(nID);
	return is_numeric(str) ? atoi(str) : -1;
}

BOOL	FunctionPlotDlgBase::SetStrValue(int nID, LPCSTR lpcszVal)
{
	Control		cntrl = GetItem(nID);
	if ( !cntrl )
		return FALSE;
	
	cntrl.Text = lpcszVal;
	return TRUE;
}

string	FunctionPlotDlgBase::GetStrValue(int nID)
{
	Control		cntrl = GetItem(nID);
	return cntrl ? cntrl.Text : "";
}

BOOL	FunctionPlotDlgBase::SetdoubleValue(int nID, double rVal)
{
	return SetStrValue(nID, ftoa(rVal, "*"));
}

BOOL	FunctionPlotDlgBase::OnThemeMenu()
{
	Tree trSettings;
	///------ Folger 07/16/2012 ORG-6225-P1 SHOULD_NOT_SHOW_VARIABLE_ERROR_WHEN_POPUP_THEME_MENU_OF_FUNCTION_PLOT_DIALOG
	//SaveSettings(trSettings, SEETING_TREE_WITH_VALUE);
	SaveSettingsTree(trSettings);
	///------ End SHOULD_NOT_SHOW_VARIABLE_ERROR_WHEN_POPUP_THEME_MENU_OF_FUNCTION_PLOT_DIALOG
	
	bool	bIsLoading;
	if( ThemeShowPopupMenu(trSettings, trSettings, bIsLoading) )
	{
		if( bIsLoading )
		{
			SetChangeEventReady(false);
			LoadSettings(trSettings);
			SetChangeEventReady(true);
		}
	}
	return TRUE;
}

void	FunctionPlotDlgBase::OnShowTab(int nTab)
{
	vector<uint>	vnIDstoShow, vnIDstoHide;
	GetCntrlIDs(nTab, vnIDstoShow, vnIDstoHide);

	ShowControls(vnIDstoHide, FALSE);
	ShowControls(vnIDstoShow, TRUE);
	
	UpdatePrescriptDisplay(TRUE);
}

BOOL	FunctionPlotDlgBase::OnCheckShowLT(Control cntrl)
{
	OnDlgSettingChange();
	return UpdatePrescriptDisplay(FALSE);
}

BOOL	FunctionPlotDlgBase::OnAfterControlEdit(Control cntrl)
{
	OnDlgSettingChange();
	return TRUE;
}

BOOL	FunctionPlotDlgBase::OnThemeSaveButtonClick(Control ctrl)
{
	return OnThemeMenu();
}

BOOL	FunctionPlotDlgBase::OnUIUpdateFittingFunc(CmdUI cmd)
{
	return OnUpdateFittingFunc(cmd);
}

BOOL	FunctionPlotDlgBase::OnBeforeEditPreScriptGrid(Control ctrl, int nRow, int nCol, BOOL *pCancel)
{
	return OnBeforeEditGrid(nRow, nCol, pCancel);
}

void	FunctionPlotDlgBase::OnAfterEditPreScriptGrid(Control flxControl, int nRow, int nCol)
{
	OnAfterEditGrid(nRow, nCol);
}

BOOL	FunctionPlotDlgBase::OnShowMenu(UINT nResIDCtrl, int nx, int ny)
{
	return ShowGridMenu(nx, ny);
}

///------ Folger 07/29/2011 ORG-3350-P2 LAST_USED_IN_FUNCTION_PLOT_DIALOG
BOOL	FunctionPlotDlgBase::OnAfterApply()
{
	Tree trSettings;
	SaveSettings(trSettings, SEETING_TREE_WITH_VALUE);

	theme_update_last_used(ClassOption(), trSettings);
	return TRUE;
}
///------ End LAST_USED_IN_FUNCTION_PLOT_DIALOG

///------ Folger 07/29/2011 ORG-3366-P1 SMART_RESCALE_WHEN_ADD_TO_GRAPH
BOOL	FunctionPlotDlgBase::Rescale(DWORD dwCntrl/* = 0*/)
{
	///------ Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	//DWORD		dwCntrl = IsAddToGraph() ? ANL_CHK_DATA_OUTSIDE : 0;
	BOOL bRescale = FALSE;
	int nAddToGraph = IsAddToGraph(&bRescale);
	if ( nAddToGraph && !bRescale )
		return TRUE;
	
	///------ End IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	GraphLayer	gl = Project.ActiveLayer();
	if ( !gl )
	{
		O_A_FAIL;
		return FALSE;
	}

	return gl.Rescale(dwCntrl);
}
///------ End SMART_RESCALE_WHEN_ADD_TO_GRAPH

///------ Folger 10/18/2011 ORG-3276-P4 AUTO_RANGE_SHOULD_NOT_SHOW_ON_LABEL_TAB
BOOL	FunctionPlotDlgBase::IsShowAutoRange()
{
	return TAB_FUNCTION == m_tab.GetCurSel() && IsAddToGraph();
}
///------ End AUTO_RANGE_SHOULD_NOT_SHOW_ON_LABEL_TAB

///------ Folger 08/03/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
/// virtual
BOOL	FunctionPlotDlgBase::CopyTheme(FunctionPlotContext& context)
{
	Tree trSettings;
	SaveSettingsTree(trSettings);
	return theme_copy_settings(trSettings);
}

///------ Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
/// virtual
BOOL FunctionPlotDlgBase::PasteTheme(FunctionPlotContext& context)
{
	Tree trSettings;
	SaveSettings(trSettings, SEETING_TREE_WITH_DEFAULT);
	if ( !theme_paste_settings(trSettings) )
		return FALSE;

	LoadSettingsTree(trSettings);
	return TRUE;
}

BOOL FunctionPlotDlgBase::CanPasteTheme()
{
	Tree trSettings;
	SaveSettingsTree(trSettings);
	return theme_can_paste_settings(trSettings);
}
///------ End SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD

///------ Folger 05/30/2012 ORG-5813-P1 ADD_TO_GRAPH_SHOULD_NOT_BE_SHOWN_WHEN_SWITCH_TO_EMPTY_FOLDER
Layer	FunctionPlotDlgBase::GetActiveLayer()
{
	Layer lay = Project.ActiveLayer();
	if ( lay )
	{
		Page pg;
		lay.GetParent(pg);
		///------ Folger 07/03/2012 ORG-6128-P1 RUNTIME_ERROR_WHEN_MAKE_FUNCTION_PLOT_ON_EMBEDED_GRAPH
		//if ( pg.GetFolder().GetPath() == Project.ActiveFolder().GetPath() )
			//return lay;
		Window wnd = pg.GetWindow();
		if ( wnd )
			return lay;
		///------ End RUNTIME_ERROR_WHEN_MAKE_FUNCTION_PLOT_ON_EMBEDED_GRAPH
	}

	Layer junk;
	return junk;
}
///------ End ADD_TO_GRAPH_SHOULD_NOT_BE_SHOWN_WHEN_SWITCH_TO_EMPTY_FOLDER

///------ Folger 06/07/2012 ORG-5923 NEW_THEME_TYPE_FOR_FUNCTION_PLOT
void	FunctionPlotDlgBase::CheckConvertThemeFiles()
{
	vector<int> vnPath = { ORIGIN_PATH_USER
		, ORIGIN_PATH_GROUP
	};

	for ( int ii=0; ii<vnPath.GetSize(); ++ii )
	{
		string strPathOFT = okutil_theme_get_path(vnPath[ii], THTYPE_FUNCTION);
		string strPathODT = okutil_theme_get_path(vnPath[ii], THTYPE_DIALOG);

		if ( strPathOFT.IsEmpty() || strPathODT.IsEmpty() )
			continue;

		string strPattern = GetFileName(okutil_theme_construct_filename("*", THTYPE_DIALOG, ORIGIN_PATH_USER, 0, ClassOption()));

		StringArray arrFiles;
		GetFileNames(arrFiles, strPathODT, strPattern, GFIF_FILE_NO_PATH | GFIF_FILE_NO_EXT);
		
		int nFilesSize = arrFiles.GetSize();
		if ( nFilesSize > 0 )
			CheckMakePath(strPathOFT);
		
		for ( int nFile=0; nFile<nFilesSize; ++nFile )
		{
			string strSrc = strPathODT + arrFiles[ii] + "." DIALOG_THEME_FILE_EXT;
			string strDes = strPathOFT + arrFiles[ii] + "." FUNCTION_THEME_FILE_EXT;

			if ( !strDes.IsFile() )
			{
				if ( CopyFile(strSrc, strDes) && strDes.IsFile() )
				{
					DeleteFile(strSrc);
				}
			}
		}
	}
}
///------ End NEW_THEME_TYPE_FOR_FUNCTION_PLOT

///------ Folger 06/08/2012 ORG-5925-P1 NOT_SET_ADD_TO_GRAPH_WHEN_APPLY_THEME
BOOL	FunctionPlotDlgBase::OnDestroy()
{
	SaveSetting(STR_ADDTOGRAPH_SETTING_NAME, IsAddToGraph(), GetDlgSettingsName());
	return TRUE;
}
///------ End NOT_SET_ADD_TO_GRAPH_WHEN_APPLY_THEME

typedef FunctionPlotDlgBase* (*FUNC_CREATE_DLG)(BOOL bParametric); 

class NewFunctionPlotHandler
{
public:
	NewFunctionPlotHandler(UINT nPlotUID)
	{
		m_uidPlotUID = nPlotUID; ///------ Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
		DataPlot		dp;
		///------ Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
		//dp = (DataPlot)Project.GetObject(nPlotUID);
		dp = Plot();
		///------ End SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
		if ( dp )
		{
			BOOL	bOK = dp.GetFunctionContext(m_context);
			O_A(bOK);

			FUNC_CREATE_DLG		pfn = NULL;

			switch ( m_context.nType )
			{
			case FUNCTIONPLOTTYPE_2D:
			case FUNCTIONPLOTTYPE_2D_PARAMETRIC:
				pfn = Project.FindFunction("create_New2DFunctionPlotDlg", "Originlab\\New2DFunctionPlotDlg", TRUE);
				break;

			case FUNCTIONPLOTTYPE_3D:
			case FUNCTIONPLOTTYPE_3D_PARAMETRIC:
				pfn = Project.FindFunction("create_New3DFunctionPlotDlg", "Originlab\\New3DFunctionPlotDlg", TRUE);
				break;

			case FUNCTIONPLOTTYPE_INVALID:
			default:
				O_A_FAIL;
				return;
			}

			if ( pfn )
			{
				m_pDlg = pfn(FUNCTIONPLOTTYPE_2D_PARAMETRIC == m_context.nType || FUNCTIONPLOTTYPE_3D_PARAMETRIC == m_context.nType);
			}
			else
			{
				m_pDlg = NULL;
			}
		}
	}
	~NewFunctionPlotHandler()
	{
		NICE_SAFE_REMOVAL(m_pDlg);
	}

	int			Do(int nMsg)
	{
		if ( NULL == m_pDlg )
			return 1;

		switch ( nMsg )
		{
		case FUNCTIONPLOTMSG_THEME_COPY:
			return m_pDlg->CopyTheme(m_context);

		///------ Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
		case FUNCTIONPLOTMSG_THEME_CAN_PASTE:
			return m_pDlg->CanPasteTheme();

		case FUNCTIONPLOTMSG_THEME_PASTE:
			if ( m_pDlg->PasteTheme(m_context) )
			{
				ApplyPlotContext();
				return TRUE;
			}
			return FALSE;
		///------ End SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
		}

		return 1;
	}

private:
	///------ Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
	void ApplyPlotContext()
	{
		DataPlot dp;
		dp = Plot();
		if ( dp )
			dp.SetFunctionContext(m_context);
	}

	DataPlot Plot()
	{
		return (DataPlot)Project.GetObject(m_uidPlotUID);
	}
	///------ End SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD

private:
	FunctionPlotContext		m_context;
	FunctionPlotDlgBase*	m_pDlg;
	OUID m_uidPlotUID; ///------ Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
};

int		NewFunctionPlotHelper(int nMsg, ODWP dwCntrl = 0, LPVOID lpData = NULL)
{
	NewFunctionPlotHandler		handler(dwCntrl);
	return handler.Do(nMsg);
}
///------ End SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT