/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 07/29/2011 ORG-3350-P2 LAST_USED_IN_FUNCTION_PLOT_DIALOG				*
 *	Folger 07/29/2011 ORG-3366-P1 SMART_RESCALE_WHEN_ADD_TO_GRAPH				*
 *	Folger 08/01/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE	*
 *	Folger 08/03/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT	*
 *  Sen 08/18/2011 ORG-3342-P2 CHECK_VALID_PARAMETER_NAME						*
 *	Folger 09/19/2011 ORG-3276-S3 UPDATE_RANGE_FROM_TO_WHEN_SET_AUTO_RANGE		*
 *	Folger 10/18/2011 ORG-3276-P4 AUTO_RANGE_SHOULD_NOT_SHOW_ON_LABEL_TAB		*
 *	Folger 02/14/2012 ORG-5043-P1 FILAED_TO_DRAW_3D_FUNCTION_PLOT				*
 *	Folger 05/09/2012 ORG-5651-P2 FUNCTION_PLOT_BEFORE_SCRIPT_FAILED_TO_BE_PASTED
 *	Folger 05/10/2012 ORG-5657-S1 ADD_TO_GRAPH_SHOULD_SHOW_ON_3DGL_GRAPH		*
 *	Folger 05/30/2012 ORG-5813-P1 ADD_TO_GRAPH_SHOULD_NOT_BE_SHOWN_WHEN_SWITCH_TO_EMPTY_FOLDER
 *	Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
 *	Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
 *	Folger 06/08/2012 ORG-5925-P1 NOT_SET_ADD_TO_GRAPH_WHEN_APPLY_THEME			*
 *	Folger 08/28/2012 ORG-6423-P2 INDIVIDUAL_TEMPLATE_FOR_3D_AND_3D_PARAMETRIC	*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <..\OriginLab\DialogEx.h>
#include <Array.h>
#include "MenuBase.h"
#include "NewFunctionPlotHelper.h"
#include "New3DFunctionPlotDlg.h"

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

enum
{
	TABCTRL_LABEL,
	TABCTRL_3D_FUNC,
	TABCTRL_3D_FUNC_PARAM,
	TABCTRL_ALL,
};

enum
{
	TAB_FUNCTION,
	TAB_LABEL,
};

#define RIGHTMOST_CONTROL_IN_TAB		IDC_PLOTDTLS_FUNC_PRESCRIPT_INSERT
#define BOTTOMMOST_CONTROL_IN_TAB		IDC_PLOTDTLS_FUNC_PRESCRIPT

#define PARAM_MAX_LENGTH 8

// error message
#define ERR_PARAMETER_TOO_LONG	_L("Parameter too long")
#define ERR_PARAMETER_INVALID_NAME _L("Invalid parameter name.")/// Sen 08/18/2011 ORG-3342-P2 CHECK_VALID_PARAMETER_NAME

static const vector<uint> s_vnTabXGapFactor = {2, 5};
static const vector<uint> s_vnTabYGapFactor = {2, 5};

////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////

New3DFunctionPlotDlg::New3DFunctionPlotDlg(BOOL bParametric) : FunctionPlotDlgBase(IDD_3D_FUNCTION_PLOT_NEW_DLG, bParametric)
{
}

New3DFunctionPlotDlg::~New3DFunctionPlotDlg()
{
}

BEGIN_MESSAGE_MAP(New3DFunctionPlotDlg)

	ON_INIT(OnInitDialog) 
	ON_READY(OnReady)

	ON_TAB_SEL_CHANGE(IDC_TAB, OnTabChange)

	ON_EN_CHANGE(IDC_COLUMNS, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_ROWS, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_1ST_PARAM, OnParamChange)
	ON_EN_CHANGE(IDC_1ST_FROM, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_1ST_TO, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_2ND_PARAM, OnParamChange)
	ON_EN_CHANGE(IDC_2ND_FROM, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_2ND_TO, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_1ST_FORMULA, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_2ND_FORMULA, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_3RD_FORMULA, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_PRESCRIPT, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_X_LN, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_X_UNITS, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_X_COMMENTS, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_Y_LN, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_Y_UNITS, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_Y_COMMENTS, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_Z_LN, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_Z_UNITS, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_Z_COMMENTS, OnAfterControlEdit)

	ON_BN_CLICKED(IDC_PLOTDTLS_FUNC_1ST_FORMULA_INSERT, On1stInsert);
	ON_BN_CLICKED(IDC_PLOTDTLS_FUNC_2ND_FORMULA_INSERT, On2ndInsert);
	ON_BN_CLICKED(IDC_PLOTDTLS_FUNC_3RD_FORMULA_INSERT, On3rdInsert);
	ON_BN_CLICKED(IDC_PLOTDTLS_FUNC_PRESCRIPT_INSERT,   OnPreInsert);
	ON_BN_CLICKED(IDC_THEME_BN, OnThemeSaveButtonClick);
	///------ Sen 7/27/11 ORG-3342-P1 ADD_ERR_MSG_FOR_FORMULA_EMPTY
//	ON_BN_CLICKED(IDOK, OnOKButtonClick);
	ON_OK(OnOKButtonClick);
	///------ End ADD_ERR_MSG_FOR_FORMULA_EMP
	ON_BN_CLICKED(IDC_PLOTDTLS_FUNC_SHOW_LT_SCRIPT, OnCheckShowLT);

	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	ON_BN_CLICKED(IDC_PLOTDTLS_FUNC_AUTO_RANGE, OnCheckAuto)
	ON_BN_CLICKED(IDC_PLOTDTLS_FUNC_AUTO_RANGE2, OnCheckAuto)
	///------ Folger 06/04/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	//ON_BN_CLICKED(IDC_PLOTDTLS_FUNC_ADD_TO_GRAPH, OnCheckAddToGraph)
	ON_CBN_SELCHANGE(IDC_PLOTDTLS_FUNC_ADD_TO_GRAPH, OnCheckAddToGraph)
	///------ End IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE

	ON_GRID_BEFORE_EDIT(IDC_PLOTDTLS_FUNC_PRESCRIPT_GRID, OnBeforeEditPreScriptGrid)
	ON_GRID_AFTER_EDIT(IDC_PLOTDTLS_FUNC_PRESCRIPT_GRID, OnAfterEditPreScriptGrid)

	ON_CONTEXTMENU(OnShowMenu)

	ON_CMD_UI_UPDATE_RANGE(IDC_FITTING_FUNC_CATEGORY_BEGIN, IDC_FITTING_FUNC_CATEGORY_BEGIN + FITTING_FUNC_CATEGORY_NUM, OnUIUpdateFittingFunc)

	ON_HELPINFO(OnHelp)

	ON_DESTROY(OnDestroy) ///------ Folger 06/08/2012 ORG-5925-P1 NOT_SET_ADD_TO_GRAPH_WHEN_APPLY_THEME

EVENTS_END

BOOL	New3DFunctionPlotDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
{
	nHelpID = IsParametric() ? IDD_3D_PARAM_FUNCTION_PLOT_NEW_DLG : IDD_3D_FUNCTION_PLOT_NEW_DLG;
	return TRUE;
}

///------ Folger 08/03/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
/// virtual
BOOL	New3DFunctionPlotDlg::CopyTheme(FunctionPlotContext& context)
{
	GetDefaultSettings();

	m_settings.bShowLT = context.strPrescript[0] != '\0'; ///------ Folger 05/09/2012 ORG-5651-P2 FUNCTION_PLOT_BEFORE_SCRIPT_FAILED_TO_BE_PASTED
	
	m_settings.nCols = context.nPoints1;
	m_settings.nRows = context.nPoints2;
	m_settings.str1stParam = context.strParam1;
	m_settings.str2ndParam = context.strParam2;
	m_settings.str1stFrom = context.strFrom1;
	m_settings.str2ndFrom = context.strFrom2;
	m_settings.str1stTo = context.strTo1;
	m_settings.str2ndTo = context.strTo2;
	m_settings.strPrescript = context.strPrescript;
	
	m_settings.str1stFormula = context.strFormula1;
	if ( IsParametric() )
	{
		m_settings.str2ndFormula = context.strFormula2;
		m_settings.str3rdFormula = context.strFormula3;
	}
		
	return FunctionPlotDlgBase::CopyTheme(context);
}
///------ End SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT

///------ Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
/// virtual
BOOL New3DFunctionPlotDlg::PasteTheme(FunctionPlotContext& context)
{
	if ( !FunctionPlotDlgBase::PasteTheme(context) )
		return FALSE;

	context.nPoints1 = m_settings.nCols;
	context.nPoints2 = m_settings.nRows;
	lstrcpyn(context.strParam1, m_settings.str1stParam, MAXLINE);
	lstrcpyn(context.strParam2, m_settings.str2ndParam, MAXLINE);
	lstrcpyn(context.strFrom1, m_settings.str1stFrom, MAXLINE);
	lstrcpyn(context.strFrom2, m_settings.str2ndFrom, MAXLINE);
	lstrcpyn(context.strTo1, m_settings.str1stTo, MAXLINE);
	lstrcpyn(context.strTo2, m_settings.str2ndTo, MAXLINE);
	m_settings.strPrescript.Replace("\n", "\r\n");
	lstrcpyn(context.strPrescript, m_settings.strPrescript, MAX_BUFFER_SIZE);

	lstrcpyn(context.strFormula1, m_settings.str1stFormula, MAX_FORMULA_SIZE);
	if ( IsParametric() )
	{
		lstrcpyn(context.strFormula2, m_settings.str2ndFormula, MAX_FORMULA_SIZE);
		lstrcpyn(context.strFormula3, m_settings.str3rdFormula, MAX_FORMULA_SIZE);
	}

	return TRUE;
}
///------ End SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD

BOOL New3DFunctionPlotDlg::OnInitDialog()
{
	return FunctionPlotDlgBase::OnInitDialog(IDC_PLOTDTLS_FUNC_PRESCRIPT, IsParametric() ? "3D Parameteric Dialog" : "3D Function Dialog");
}

BOOL New3DFunctionPlotDlg::OnReady()
{
	return ConstructMenu();
}

BOOL New3DFunctionPlotDlg::OnTabChange(Control ctrl)
{
	OnShowTab(Tab().GetCurSel());

	return TRUE;
}

BOOL New3DFunctionPlotDlg::On1stInsert(Control ctrl)
{
	OnInsertButton(IDC_PLOTDTLS_FUNC_1ST_FORMULA_INSERT, IDC_PLOTDTLS_FUNC_1ST_FORMULA);
	
	return TRUE;
}

BOOL New3DFunctionPlotDlg::On2ndInsert(Control ctrl)
{
	OnInsertButton(IDC_PLOTDTLS_FUNC_2ND_FORMULA_INSERT, IDC_PLOTDTLS_FUNC_2ND_FORMULA);

	return TRUE;
}

BOOL New3DFunctionPlotDlg::On3rdInsert(Control ctrl)
{
	OnInsertButton(IDC_PLOTDTLS_FUNC_3RD_FORMULA_INSERT, IDC_PLOTDTLS_FUNC_3RD_FORMULA);

	return TRUE;
}

BOOL New3DFunctionPlotDlg::OnPreInsert(Control ctrl)
{
	OnInsertButton(IDC_PLOTDTLS_FUNC_PRESCRIPT_INSERT, IDC_PLOTDTLS_FUNC_PRESCRIPT);

	return TRUE;
}

void New3DFunctionPlotDlg::setCtrlTitle()
{
	if ( IsParametric() )
	{
		GetItem(IDC_SCALE_1ST_LABEL).Text = "";
		GetItem(IDC_SCALE_2ND_LABEL).Text = "";
		
		GetItem(IDC_1ST_PARAM).Text = "u";
		GetItem(IDC_2ND_PARAM).Text = "v";
		return;
	}

	GetItem(IDC_SCALE_1ST_LABEL).Text = "x";
	GetItem(IDC_SCALE_2ND_LABEL).Text = "y";
	GetItem(IDC_PLOTDTLS_FUNC_1ST_FORMULA_LABEL).Text = "Z(x,y)=";
}

void New3DFunctionPlotDlg::getShowControls(int nTabType, vector<uint> & vnCtrlIDs)
{
	vnCtrlIDs.RemoveAll();
	
	vector<uint> vnFuncCtrlID = {
		IDC_STATIC_GRID,
		IDC_STATIC_COLUMNS,
		IDC_COLUMNS,
		IDC_STATIC_ROWS,
		IDC_ROWS,

		IDC_STATIC_SCALE,
		IDC_STATIC_FROM,
		IDC_STATIC_TO,
		IDC_SCALE_1ST_LABEL,
		IDC_SCALE_2ND_LABEL, 
		IDC_1ST_FROM,
		IDC_1ST_TO,
		IDC_2ND_FROM,
		IDC_2ND_TO,
		
		IDC_PLOTDTLS_FUNC_1ST_FORMULA_LABEL,
		IDC_PLOTDTLS_FUNC_1ST_FORMULA,
		IDC_PLOTDTLS_FUNC_1ST_FORMULA_INSERT,

		IDC_PLOTDTLS_FUNC_PRESCRIPT_LABEL,
		IDC_PLOTDTLS_FUNC_PRESCRIPT,		
		IDC_PLOTDTLS_FUNC_PRESCRIPT_INSERT,
		IDC_PLOTDTLS_FUNC_SHOW_LT_SCRIPT,
		IDC_PLOTDTLS_FUNC_PRESCRIPT_GRID
	};
	
	vector<uint> vnLabelCtrlID = {
		IDC_PLOTDTLS_FUNC_LN_LABEL,
		IDC_PLOTDTLS_FUNC_UNITS_LABEL,
		IDC_PLOTDTLS_FUNC_COMMENTS_LABEL,

		IDC_PLOTDTLS_FUNC_X_LABELS,
		IDC_PLOTDTLS_FUNC_Y_LABELS,
		IDC_PLOTDTLS_FUNC_Z_LABELS,

		IDC_PLOTDTLS_FUNC_Y_LN,
		IDC_PLOTDTLS_FUNC_Y_UNITS,
		IDC_PLOTDTLS_FUNC_Y_COMMENTS,

		IDC_PLOTDTLS_FUNC_X_LN,
		IDC_PLOTDTLS_FUNC_X_UNITS,
		IDC_PLOTDTLS_FUNC_X_COMMENTS,

		IDC_PLOTDTLS_FUNC_Z_LN,
		IDC_PLOTDTLS_FUNC_Z_UNITS,
		IDC_PLOTDTLS_FUNC_Z_COMMENTS
	};

	vector<uint> vnFuncParamCtrlID = {
		IDC_PLOTDTLS_FUNC_2ND_FORMULA_LABEL,
		IDC_PLOTDTLS_FUNC_2ND_FORMULA,
		IDC_PLOTDTLS_FUNC_2ND_FORMULA_INSERT,

		IDC_PLOTDTLS_FUNC_3RD_FORMULA_LABEL,
		IDC_PLOTDTLS_FUNC_3RD_FORMULA,
		IDC_PLOTDTLS_FUNC_3RD_FORMULA_INSERT,

		IDC_STATIC_PARAM,
		IDC_1ST_PARAM,
		IDC_2ND_PARAM,
		0
	}; 

	if (vnCtrlIDs == NULL)
		return;

	switch (nTabType)
	{
		case TABCTRL_LABEL:
			vnCtrlIDs.Append(vnLabelCtrlID);
			break;

		case TABCTRL_3D_FUNC:
			vnCtrlIDs.Append(vnFuncCtrlID);
			break;

		case TABCTRL_3D_FUNC_PARAM:
			vnCtrlIDs.Append(vnFuncCtrlID);
			vnCtrlIDs.Append(vnFuncParamCtrlID);
			break;

		case TABCTRL_ALL:
			vnCtrlIDs.Append(vnLabelCtrlID);
			vnCtrlIDs.Append(vnFuncCtrlID);
			vnCtrlIDs.Append(vnFuncParamCtrlID);
			break;

		default:
			O_A_FAIL;
	}
	vnCtrlIDs.Add(0);
}

/// Iris 7/19/2011 MEASURE_CONTROL_POSITION
int  New3DFunctionPlotDlg::getGap(bool bIsX)
{
	int	nGap = Gap();
	int nTab = Tab().GetCurSel();
	if( nTab >= 0 && nTab < s_vnTabYGapFactor.GetSize() )
		return bIsX ? s_vnTabXGapFactor[nTab] * nGap : s_vnTabYGapFactor[nTab] * nGap;
	return nGap;
}

int	 New3DFunctionPlotDlg::getXGap()
{
	return getGap(true);
}

int	 New3DFunctionPlotDlg::getYGap()
{
	return getGap(false);
}
///End MEASURE_CONTROL_POSITION

void New3DFunctionPlotDlg::moveControl()
{
	/// Iris 7/19/2011 MEASURE_CONTROL_POSITION
	if ( !IsParametric() )
	{
		RECT rtFormula;
		RECT rtDefinition;
		
		GetControlClientRect(IDC_PLOTDTLS_FUNC_PRESCRIPT_LABEL, rtDefinition);
		GetControlClientRect(IDC_PLOTDTLS_FUNC_1ST_FORMULA, rtFormula);
		int nY = rtFormula.bottom - rtDefinition.top + getYGap();
		
		vector<uint> vnCtrlToMove = {
			IDC_PLOTDTLS_FUNC_PRESCRIPT_LABEL,
			IDC_PLOTDTLS_FUNC_SHOW_LT_SCRIPT,
			IDC_PLOTDTLS_FUNC_PRESCRIPT,
			IDC_PLOTDTLS_FUNC_PRESCRIPT_GRID,
			IDC_PLOTDTLS_FUNC_PRESCRIPT_INSERT,
			0
		};
		MoveControls(vnCtrlToMove, 0, nY);
	}
	///End MEASURE_CONTROL_POSITION

	int	nGap = Gap();
	
	// size tab ctrl
	int nTab = Tab().GetCurSel();
	RECT rtTab;
	RECT rtBottomItem, rtRightItem;
	RECT rtThemeBn;
	GetControlClientRect(IDC_TAB, rtTab);
	GetControlClientRect(RIGHTMOST_CONTROL_IN_TAB, rtRightItem);
	GetControlClientRect(BOTTOMMOST_CONTROL_IN_TAB, rtBottomItem);
	GetControlClientRect(IDC_THEME_BN, rtThemeBn);
	int nTabWidth = rtRightItem.right + nGap;
	rtTab.top = rtThemeBn.bottom + nGap;
	rtTab.right = rtTab.left + nTabWidth;
	/// Iris 7/19/2011 MEASURE_CONTROL_POSITION
	//rtTab.bottom = rtBottomItem.bottom + s_vnTabYGapFactor[nTab] * m_nGap;
	rtTab.bottom = rtBottomItem.bottom + getYGap();
	///End MEASURE_CONTROL_POSITION
	MoveControl(Tab(), rtTab);
	
	Control ctrlBackground = GetItem(IDC_STATIC_BACK);
	if( ctrlBackground )
	{
		ctrlBackground.Text = "";
		Tab().AdjustRect(false, &rtTab);
		--rtTab.left; // move to left more to remove the left white line
		MoveControl(ctrlBackground, rtTab);
	}
	
	GetControlClientRect(IDC_TAB, rtTab);
	
	/// Iris 7/19/2011 MEASURE_CONTROL_POSITION
	/*
	// resize group control
	RECT rtScale;
	GetControlClientRect(IDC_STATIC_SCALE, rtScale);
	rtScale.right = rtTab.right - m_nGap;
	GetItem(IDC_STATIC_SCALE).MoveWindow(&rtScale);
	*/
	///End MEASURE_CONTROL_POSITION	
	
	// position ok and cancel button
	RECT rtCancel;
	GetControlClientRect(IDCANCEL, rtCancel);	
	int nButtonBottom = rtTab.bottom + nGap + RECT_HEIGHT(rtCancel);
	MoveControl(IDCANCEL, rtTab.right, nButtonBottom, false);
	MoveControl(IDOK, rtTab.right - RECT_WIDTH(rtCancel) - nGap, nButtonBottom, false);	
	MoveControl(IDC_PLOTDTLS_FUNC_ADD_TO_GRAPH, rtTab.left, rtTab.bottom + nGap, true);	
	GetControlClientRect(IDCANCEL, rtCancel);
	
	// resize dlg
	RECT rtDlg;
	m_wndDlg.GetWindowRect(&rtDlg);
	m_wndDlg.ScreenToClient(&rtDlg);

	RECT rtOK, rtPreScript;
	GetControlClientRect(IDOK, rtOK);
	GetControlClientRect(IDC_PLOTDTLS_FUNC_PRESCRIPT, rtPreScript);

	RECT	rrPreScriptGrid;
	rrPreScriptGrid = rtPreScript;
	rrPreScriptGrid.right = rtRightItem.right;
	MoveControl(GetItem(IDC_PLOTDTLS_FUNC_PRESCRIPT_GRID), rrPreScriptGrid);

	rtDlg.right = rtTab.right + nGap;
	rtDlg.bottom = rtCancel.bottom + nGap;
	m_wndDlg.ClientToScreen(&rtDlg);		
	m_wndDlg.MoveWindow(&rtDlg, true);

	// position label controls
	vector<uint> vnIDsLabel = { 
		IDC_PLOTDTLS_FUNC_X_LABELS,
		IDC_PLOTDTLS_FUNC_Y_LABELS,
		IDC_PLOTDTLS_FUNC_Z_LABELS,
		
		IDC_PLOTDTLS_FUNC_LN_LABEL,
		IDC_PLOTDTLS_FUNC_X_LN,
		IDC_PLOTDTLS_FUNC_Y_LN,
		IDC_PLOTDTLS_FUNC_Z_LN,
		
		IDC_PLOTDTLS_FUNC_UNITS_LABEL,
		IDC_PLOTDTLS_FUNC_X_UNITS,
		IDC_PLOTDTLS_FUNC_Y_UNITS,
		IDC_PLOTDTLS_FUNC_Z_UNITS,
		
		IDC_PLOTDTLS_FUNC_COMMENTS_LABEL,
		IDC_PLOTDTLS_FUNC_X_COMMENTS,
		IDC_PLOTDTLS_FUNC_Y_COMMENTS,
		IDC_PLOTDTLS_FUNC_Z_COMMENTS,
		0
	};
	RECT rtLN;
	RECT rtGrid;
	GetControlClientRect(IDC_STATIC_GRID, rtGrid);
	GetControlClientRect(IDC_PLOTDTLS_FUNC_LN_LABEL, rtLN);
	/// Iris 7/19/2011 MEASURE_CONTROL_POSITION
	//MoveControls(vnIDsLabel, 0, rtGrid.top - rtLN.top + m_nGap);
	MoveControls(vnIDsLabel, getXGap(), rtGrid.top - rtLN.top + getYGap());
	///End MEASURE_CONTROL_POSITION
		
	/// Iris 7/19/2011 MEASURE_CONTROL_POSITION
	/*
	if (m_nDlgType == DLG_TYPE_3D_FUNC)
	{
		RECT rtFormula;
		RECT rtDefinition;
		
		GetControlClientRect(IDC_PLOTDTLS_FUNC_PRESCRIPT_LABEL, rtDefinition);
		GetControlClientRect(IDC_PLOTDTLS_FUNC_1ST_FORMULA, rtFormula);
		rtFormula.bottom = rtDefinition.top - m_nGap;
		GetItem(IDC_PLOTDTLS_FUNC_1ST_FORMULA).MoveWindow(&rtFormula);
	}
	*/
	///End MEASURE_CONTROL_POSITION

	moveControlsInScaleGroup();
}

void New3DFunctionPlotDlg::moveControlsInScaleGroup()
{
	int		nGap = Gap();

	///------ Folger 08/01/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	RECT	rrRight;
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE

	if ( IsParametric() )
	{
		/// Iris 7/19/2011 MEASURE_CONTROL_POSITION
		/*
		vector<uint> vnParam = { IDC_STATIC_PARAM, IDC_1ST_PARAM, IDC_2ND_PARAM, 0 };
		vector<uint> vnFrom = { IDC_STATIC_FROM, IDC_1ST_FROM, IDC_2ND_FROM, 0 };
		vector<uint> vnTo = { IDC_STATIC_TO, IDC_1ST_TO, IDC_2ND_TO, 0 };

		RECT rtParam;
		RECT rtScale;
		GetControlClientRect(IDC_1ST_PARAM, rtParam);		
		GetControlClientRect(IDC_STATIC_SCALE, rtScale);
		MoveControls(vnParam, rtScale.left - rtParam.left + m_nGap, 0);

		RECT rtFrom;
		GetControlClientRect(IDC_1ST_PARAM, rtParam);		
		GetControlClientRect(IDC_1ST_FROM, rtFrom);
		MoveControls(vnFrom, rtParam.right - rtFrom.left + m_nGap , 0);
		
		RECT rtTo;
		GetControlClientRect(IDC_1ST_FROM, rtFrom);		
		GetControlClientRect(IDC_1ST_TO, rtTo);
		MoveControls(vnTo, rtFrom.right - rtTo.left + m_nGap , 0);
		*/
		vector<uint> vnCtrls = {
			IDC_STATIC_PARAM, IDC_1ST_PARAM, IDC_2ND_PARAM,
			IDC_STATIC_FROM, IDC_1ST_FROM, IDC_2ND_FROM,
			IDC_STATIC_TO, IDC_1ST_TO, IDC_2ND_TO,
			0
		};
		
		RECT rtParam;
		RECT rtLabel;
		GetControlClientRect(IDC_STATIC_PARAM, rtParam);		
		GetControlClientRect(IDC_SCALE_1ST_LABEL, rtLabel);
		int nX = rtLabel.left - rtParam.left + nGap;
		MoveControls(vnCtrls, nX, 0);
		///End MEASURE_CONTROL_POSITION

		///------ Folger 08/01/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
		GetControlClientRect(IDC_1ST_TO, rrRight);
		///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	}
	/// Iris 7/19/2011 MEASURE_CONTROL_POSITION
	else
	{
		RECT	rrTo1, rrTo2;
		GetControlClientRect(IDC_1ST_TO, rrTo1);
		GetControlClientRect(IDC_2ND_TO, rrTo2);
		///------ Folger 08/01/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
		MoveControl(AutoRange(), rrTo1);
		MoveControl(AutoRange2(), rrTo2);
		///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE

		vector<uint> vnCtrls = {
			IDC_STATIC_FROM, IDC_1ST_FROM, IDC_2ND_FROM,
			IDC_STATIC_TO, IDC_1ST_TO, IDC_2ND_TO,
			0
		};
		
		RECT rtParam;
		RECT rtFrom;
		GetControlClientRect(IDC_1ST_PARAM, rtParam);		
		GetControlClientRect(IDC_1ST_FROM, rtFrom);
		int nX = rtParam.left - rtFrom.left;
		MoveControls(vnCtrls, nX, 0);	
		
		///------ Folger 08/01/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
		GetClientRect(AutoRange2(), rrRight);
		///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	}

	RECT rtScaleGroup;
	GetControlClientRect(IDC_STATIC_SCALE, rtScaleGroup);
	rtScaleGroup.right = rrRight.right + nGap;
	Control ctrl = GetItem(IDC_STATIC_SCALE);
	MoveControl(ctrl, rtScaleGroup);
	///End MEASURE_CONTROL_POSITION
}

void New3DFunctionPlotDlg::init3DFuncDlgControlPosition()
{
}

void New3DFunctionPlotDlg::init3DParamDlgControlPosition()
{
}

/// virtual
void	New3DFunctionPlotDlg::GetDefaultSettings()
{
	m_settings.nCols = 50;
	m_settings.nRows = 50;
	m_settings.str1stParam = "u";
	m_settings.str1stFrom = "0";
	m_settings.str1stTo = "2*pi";
	m_settings.str2ndParam = "v";
	m_settings.str2ndFrom = "0";
	m_settings.str2ndTo = "2*pi";
	
	m_settings.str1stFormula = "";
	m_settings.str2ndFormula = "";
	m_settings.str3rdFormula = "";

	m_settings.bShowLT = FALSE;
	
	m_settings.strPrescript = "";
	
	m_settings.strXLN = "";
	m_settings.strXUnit = "";
	m_settings.strXComment = "";
	m_settings.strYLN = "";
	m_settings.strYUnit = "";
	m_settings.strYComment = "";
	m_settings.strZLN = "";
	m_settings.strZUnit = "";
	m_settings.strZComment = "";

	///------ Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	//m_settings.nAddToGraph = FALSE;
	m_settings.nAddToGraph = ADDTOGRAPH_NO;
	///------ End IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	///------ Folger 08/01/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	m_settings.bAutoRange = m_settings.bAutoRange2 = FALSE;
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
}	

/// virtual
void	New3DFunctionPlotDlg::LoadThemeSettings()
{
	SetIntValue(IDC_COLUMNS, m_settings.nCols);
	SetIntValue(IDC_ROWS, m_settings.nRows);
	SetStrValue(IDC_1ST_PARAM, m_settings.str1stParam);
	SetStrValue(IDC_1ST_FROM, m_settings.str1stFrom);
	SetStrValue(IDC_1ST_TO, m_settings.str1stTo);
	SetStrValue(IDC_2ND_PARAM, m_settings.str2ndParam);
	SetStrValue(IDC_2ND_FROM, m_settings.str2ndFrom);
	SetStrValue(IDC_2ND_TO, m_settings.str2ndTo);
	
	SetStrValue(IDC_PLOTDTLS_FUNC_1ST_FORMULA, m_settings.str1stFormula);
	SetStrValue(IDC_PLOTDTLS_FUNC_2ND_FORMULA, m_settings.str2ndFormula);
	SetStrValue(IDC_PLOTDTLS_FUNC_3RD_FORMULA, m_settings.str3rdFormula);
	
	SetShowLT(m_settings.bShowLT);
	m_settings.strPrescript.Replace("\n", "\r\n"); ///------ Folger 05/10/2012 ORG-5651-P2 FUNCTION_PLOT_BEFORE_SCRIPT_FAILED_TO_BE_PASTED
	SetStrValue(IDC_PLOTDTLS_FUNC_PRESCRIPT, m_settings.strPrescript);
	
	SetStrValue(IDC_PLOTDTLS_FUNC_X_LN, m_settings.strXLN);
	SetStrValue(IDC_PLOTDTLS_FUNC_X_UNITS, m_settings.strXUnit);
	SetStrValue(IDC_PLOTDTLS_FUNC_X_COMMENTS, m_settings.strXComment);
	SetStrValue(IDC_PLOTDTLS_FUNC_Y_LN, m_settings.strYLN);
	SetStrValue(IDC_PLOTDTLS_FUNC_Y_UNITS, m_settings.strYUnit);
	SetStrValue(IDC_PLOTDTLS_FUNC_Y_COMMENTS, m_settings.strYComment);
	SetStrValue(IDC_PLOTDTLS_FUNC_Z_LN, m_settings.strZLN);
	SetStrValue(IDC_PLOTDTLS_FUNC_Z_UNITS, m_settings.strZUnit);
	SetStrValue(IDC_PLOTDTLS_FUNC_Z_COMMENTS, m_settings.strZComment);

	//SetAddToGraph(m_settings.nAddToGraph); ///------ Folger 06/08/2012 ORG-5925-P1 NOT_SET_ADD_TO_GRAPH_WHEN_APPLY_THEME
	///------ Folger 08/01/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	SetAutoRange(m_settings.bAutoRange);
	SetAutoRange2(m_settings.bAutoRange2);
	
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	FunctionPlotDlgBase::LoadThemeSettings();
}

/// virtual
BOOL	New3DFunctionPlotDlg::SaveThemeSettings()
{
	if ( !FunctionPlotDlgBase::SaveThemeSettings() )
		return FALSE;

	m_settings.nCols = GetIntValue(IDC_COLUMNS);
	m_settings.nRows = GetIntValue(IDC_ROWS);
	m_settings.str1stParam = GetStrValue(IDC_1ST_PARAM);
	m_settings.str1stFrom = GetStrValue(IDC_1ST_FROM);
	m_settings.str1stTo = GetStrValue(IDC_1ST_TO);
	m_settings.str2ndParam = GetStrValue(IDC_2ND_PARAM);
	m_settings.str2ndFrom = GetStrValue(IDC_2ND_FROM);
	m_settings.str2ndTo = GetStrValue(IDC_2ND_TO);
	
	m_settings.str1stFormula = GetStrValue(IDC_PLOTDTLS_FUNC_1ST_FORMULA);
	m_settings.str2ndFormula = GetStrValue(IDC_PLOTDTLS_FUNC_2ND_FORMULA);
	m_settings.str3rdFormula = GetStrValue(IDC_PLOTDTLS_FUNC_3RD_FORMULA);
	
	m_settings.bShowLT = IsShowLT();
	m_settings.strPrescript = GetStrValue(IDC_PLOTDTLS_FUNC_PRESCRIPT);
	m_settings.strPrescript.TrimLeft(), m_settings.strPrescript.TrimRight();
	
	m_settings.strXLN = GetStrValue(IDC_PLOTDTLS_FUNC_X_LN);
	m_settings.strXUnit = GetStrValue(IDC_PLOTDTLS_FUNC_X_UNITS);
	m_settings.strXComment = GetStrValue(IDC_PLOTDTLS_FUNC_X_COMMENTS);
	m_settings.strYLN = GetStrValue(IDC_PLOTDTLS_FUNC_Y_LN);
	m_settings.strYUnit = GetStrValue(IDC_PLOTDTLS_FUNC_Y_UNITS);
	m_settings.strYComment = GetStrValue(IDC_PLOTDTLS_FUNC_Y_COMMENTS);
	m_settings.strZLN = GetStrValue(IDC_PLOTDTLS_FUNC_Z_LN);
	m_settings.strZUnit = GetStrValue(IDC_PLOTDTLS_FUNC_Z_UNITS);
	m_settings.strZComment = GetStrValue(IDC_PLOTDTLS_FUNC_Z_COMMENTS);

	m_settings.nAddToGraph = IsAddToGraph();
	///------ Folger 08/01/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	m_settings.bAutoRange = IsAutoRange();
	m_settings.bAutoRange2 = IsAutoRange2();
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	
	return TRUE;
}

// virtual
void	New3DFunctionPlotDlg::LoadSettingsTree(TreeNode& trSettings)
{
	FunctionPlotDlgBase::LoadSettingsTree(trSettings);
	m_settings = trSettings;
}

/// virtual
void	New3DFunctionPlotDlg::SaveSettingsTree(TreeNode& trSettings)
{
	trSettings += m_settings;
	FunctionPlotDlgBase::SaveSettingsTree(trSettings);
}

//
BOOL 	New3DFunctionPlotDlg::IsFormulaEmpty()
{
	if(IsParametric())
		return ( GetStrValue(IDC_PLOTDTLS_FUNC_1ST_FORMULA).IsEmpty() ||  GetStrValue(IDC_PLOTDTLS_FUNC_2ND_FORMULA).IsEmpty() || GetStrValue(IDC_PLOTDTLS_FUNC_3RD_FORMULA).IsEmpty());			
	else
		return GetStrValue(IDC_PLOTDTLS_FUNC_1ST_FORMULA).IsEmpty();	
}

///------ Sen 7/27/11 ORG-3342-P1 ADD_ERR_MSG_FOR_FORMULA_EMPTY
//BOOL New3DFunctionPlotDlg::OnOKButtonClick(Control ctrl)
BOOL New3DFunctionPlotDlg::OnOKButtonClick()
{
	if( IsFormulaEmpty() )
	{
		warning_msg_box(MSG_FUNCTION_NOT_BE_EMPTY, true);
		return FALSE;	
	}
///------ End ADD_ERR_MSG_FOR_FORMULA_EMP
	GraphLayer	gl = Project.ActiveLayer();
	MatrixLayer ml = CreateData();
	if ( !ml )
		return FALSE;
	
	if ( !UpdateLabels(ml) )
		return FALSE;

	return MakePlot(ml, gl)
		///------ Folger 07/29/2011 ORG-3350-P2 LAST_USED_IN_FUNCTION_PLOT_DIALOG
		&& OnAfterApply();
		///------ End LAST_USED_IN_FUNCTION_PLOT_DIALOG
}

BOOL New3DFunctionPlotDlg::OnParamChange(Control cntrl)
{
	if (!checkParameterLength())
		return TRUE;
	/// Sen 08/18/2011 ORG-3342-P2 CHECK_VALID_PARAMETER_NAME
	if(!checkParameterName())
		return TRUE;
	/// End CHECK_VALID_PARAMETER_NAME
	changeLabel();	

	resizeLabelControl();

	OnAfterControlEdit(cntrl);

	return TRUE;
}

/// Sen 08/18/2011 ORG-3342-P2 CHECK_VALID_PARAMETER_NAME
bool New3DFunctionPlotDlg::checkParameterName()
{
	string str1STParam = GetItem(IDC_1ST_PARAM).Text;
	string str2NDParam = GetItem(IDC_2ND_PARAM).Text;

	bool bSucc = true;
	
	str1STParam.MakeValidCName();
	str2NDParam.MakeValidCName();
	
	if(str1STParam != GetItem(IDC_1ST_PARAM).Text)
	{
		GetItem(IDC_1ST_PARAM).Text = "";
		bSucc = false;
	}
	if(str2NDParam != GetItem(IDC_2ND_PARAM).Text)
	{
		GetItem(IDC_2ND_PARAM).Text = "";
		bSucc = false;
	}

	HWND hwnd = GetFocus();
	if (!bSucc)
	{
		MessageBox(GetSafeHwnd(), ERR_PARAMETER_INVALID_NAME);
		SetFocus(hwnd);
	}

	return bSucc;
}
/// End CHECK_VALID_PARAMETER_NAME

bool New3DFunctionPlotDlg::checkParameterLength()
{
	string str1STParam = GetItem(IDC_1ST_PARAM).Text;
	string str2NDParam = GetItem(IDC_2ND_PARAM).Text;

	bool bSucc = true;

	if (str1STParam.GetLength() > PARAM_MAX_LENGTH)
	{
		str1STParam = str1STParam.Left(PARAM_MAX_LENGTH);
		GetItem(IDC_1ST_PARAM).Text = str1STParam;
		bSucc = false;
	}

	if (str2NDParam.GetLength() > PARAM_MAX_LENGTH)
	{
		str2NDParam = str2NDParam.Left(PARAM_MAX_LENGTH);
		GetItem(IDC_2ND_PARAM).Text = str2NDParam;
		bSucc = false;
	}

	if (!bSucc)
	{
		MessageBox(GetSafeHwnd(), ERR_PARAMETER_TOO_LONG);
	}

	return bSucc;
}

void New3DFunctionPlotDlg::changeLabel()
{
	string strX;
	string strY;
	string strZ;

	string strParameter;
	getParameterString(strParameter);

	if (strParameter.IsEmpty())
		return;

	strX.Format("X(%s)=", strParameter);
	strY.Format("Y(%s)=", strParameter);
	strZ.Format("Z(%s)=", strParameter);

	GetItem(IDC_PLOTDTLS_FUNC_1ST_FORMULA_LABEL).Text = strX;
	GetItem(IDC_PLOTDTLS_FUNC_2ND_FORMULA_LABEL).Text = strY;
	GetItem(IDC_PLOTDTLS_FUNC_3RD_FORMULA_LABEL).Text = strZ;
}

void New3DFunctionPlotDlg::resizeLabelControl()
{
	Control ctrlLabel = GetItem(IDC_PLOTDTLS_FUNC_1ST_FORMULA_LABEL);
	string strX = ctrlLabel.Text;

	int nWidth;
	ctrlLabel.Measure(strX, &nWidth, true);

	vector<uint> vnLabels = { IDC_PLOTDTLS_FUNC_1ST_FORMULA_LABEL, IDC_PLOTDTLS_FUNC_2ND_FORMULA_LABEL, IDC_PLOTDTLS_FUNC_3RD_FORMULA_LABEL };
	vector<uint> vnFormulas = { IDC_PLOTDTLS_FUNC_1ST_FORMULA, IDC_PLOTDTLS_FUNC_2ND_FORMULA, IDC_PLOTDTLS_FUNC_3RD_FORMULA };

	for (int i = 0 ; i < vnLabels.GetSize() ; ++i)
	{
		RECT rtLabel, rtFormula;

		GetControlClientRect(vnLabels[i], rtLabel);
		GetControlClientRect(vnFormulas[i], rtFormula);

		rtLabel.right = rtLabel.left + nWidth;
		rtFormula.left = rtLabel.right + Gap();

		MoveControl(GetItem(vnLabels[i]), rtLabel);
		MoveControl(GetItem(vnFormulas[i]), rtFormula);
	}
}

void New3DFunctionPlotDlg::getParameterString(string & str)
{
	string str1STParam = GetItem(IDC_1ST_PARAM).Text;
	string str2NDParam = GetItem(IDC_2ND_PARAM).Text;

	if (str1STParam.IsEmpty() || str2NDParam.IsEmpty())
		return;

	str.Format("%s,%s", str1STParam, str2NDParam);
}

/// virtual
string	New3DFunctionPlotDlg::DialogTitle()
{
	return IsParametric() ? _L("Create 3D Parametric Function Plot") : _L("Create 3D Function Plot");
}

/// virtual
string	New3DFunctionPlotDlg::ClassOption()
{
	return IsParametric() ? "ParamFunc3D" : "Func3D";
}

/// virtual
void	New3DFunctionPlotDlg::UpdateLabelCntrlsText()
{
	GetItem(IDC_PLOTDTLS_FUNC_X_LABELS).Text = IsParametric() ? "X" : "x";
	GetItem(IDC_PLOTDTLS_FUNC_Y_LABELS).Text = IsParametric() ? "Y" : "y";
	GetItem(IDC_PLOTDTLS_FUNC_Z_LABELS).Text = "Z";
}

/// virtual
void	New3DFunctionPlotDlg::GetCntrlFixedFont(vector<int>& vnIDs)
{
	vnIDs.SetSize(0);
	vnIDs.Add(IDC_PLOTDTLS_FUNC_1ST_FORMULA);
	vnIDs.Add(IDC_PLOTDTLS_FUNC_2ND_FORMULA);
	vnIDs.Add(IDC_PLOTDTLS_FUNC_3RD_FORMULA);
	vnIDs.Add(IDC_PLOTDTLS_FUNC_PRESCRIPT);
}

/// virtual
void	New3DFunctionPlotDlg::InitControls()
{
	InitRadioBitmapButton(IDC_PLOTDTLS_FUNC_1ST_FORMULA_INSERT, IDB_DROP_DOWN_UP);
	InitRadioBitmapButton(IDC_PLOTDTLS_FUNC_2ND_FORMULA_INSERT, IDB_DROP_DOWN_UP);
	InitRadioBitmapButton(IDC_PLOTDTLS_FUNC_3RD_FORMULA_INSERT, IDB_DROP_DOWN_UP);

	setCtrlTitle();
	
	m_edtNumCols.SetContentFilter(CF_INTEGER);
	m_edtNumCols = GetItem(IDC_COLUMNS);
	m_edtNumRows.SetContentFilter(CF_INTEGER);
	m_edtNumRows = GetItem(IDC_ROWS);
	
	if ( IsParametric() )
		init3DParamDlgControlPosition();
	else
		init3DFuncDlgControlPosition();

	FunctionPlotDlgBase::InitControls();
}

/// virtual
void	New3DFunctionPlotDlg::ResizeDlg()
{
	moveControl();
	resizeLabelControl();
}

/// virtual
void	New3DFunctionPlotDlg::GetCntrlIDs(int nTab, vector<uint>& vnIDstoShow, vector<uint>& vnIDstoHide)
{
	getShowControls(TABCTRL_ALL, vnIDstoHide);
	getShowControls(nTab == TAB_LABEL ? TABCTRL_LABEL : (IsParametric() ? TABCTRL_3D_FUNC_PARAM : TABCTRL_3D_FUNC), vnIDstoShow);
}

/// virtual
BOOL	New3DFunctionPlotDlg::IsShowAddToGraph()
{
	///------ Folger 05/30/2012 ORG-5813-P1 ADD_TO_GRAPH_SHOULD_NOT_BE_SHOWN_WHEN_SWITCH_TO_EMPTY_FOLDER
	//GraphLayer	gl = Project.ActiveLayer();
	GraphLayer	gl = GetActiveLayer();
	///------ End ADD_TO_GRAPH_SHOULD_NOT_BE_SHOWN_WHEN_SWITCH_TO_EMPTY_FOLDER
	if ( !is_3D_graph(gl) )
		return FALSE;

	///------ Folger 05/10/2012 ORG-5657-S1 ADD_TO_GRAPH_SHOULD_SHOW_ON_3DGL_GRAPH
	//BOOL	b3DGL = is_3DGL_graph(gl);
	//return IsParametric() ? b3DGL : !b3DGL;	
	if ( is_3DGL_graph(gl) )
		return Is3DGLOn();

	return !Is3DGLOn();
	///------ End ADD_TO_GRAPH_SHOULD_SHOW_ON_3DGL_GRAPH
}


string				New3DFunctionPlotDlg::MakeOneData(LPCSTR lpcszData, LPCSTR lpcszFormula)
{
	string		str;
	///------ Folger 08/01/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	BOOL		bAutoX = IsAutoRange();
	BOOL		bAutoY = IsAutoRange2();
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	str.Format("create %s -%s %d \"%s\" \"%s\" \"%s\" %d \"%s\" \"%s\";", lpcszData, IsParametric() ? "fp2" : "ff2", \
		m_settings.nCols, lpcszFormula, bAutoX ? "" : m_settings.str1stFrom, bAutoX ? "" : m_settings.str1stTo, \
		m_settings.nRows, bAutoY ? "" : m_settings.str2ndFrom, bAutoY ? "" : m_settings.str2ndTo);
	if ( !m_settings.strPrescript.IsEmpty() )
	{
		string	strTemp;
		strTemp.Format("set %s -fbs \"%s\";", lpcszData, m_settings.strPrescript);
		str += strTemp;
	}
	return str;
}

MatrixLayer			New3DFunctionPlotDlg::CreateData()
{
	if ( SaveThemeSettings() )
	{
		int			nIndex = Project.MatrixPages.Count();

		LPCSTR		lpcszDataX = "myxxx";
		LPCSTR		lpcszDataY = "myyyy";
		LPCSTR		lpcszDataZ = "myzzz";

		string strCmd = "";
		if ( IsParametric() )
		{
			strCmd += MakeOneData(lpcszDataX, m_settings.str1stFormula);
			strCmd += MakeOneData(lpcszDataY, m_settings.str2ndFormula);
			strCmd += MakeOneData(lpcszDataZ, m_settings.str3rdFormula);

			string		strCreate;
			strCreate.Format("create Func -mfp %s %s %s \"%s,%s\";", lpcszDataZ, lpcszDataX, lpcszDataY, m_settings.str1stParam, m_settings.str2ndParam);
			strCmd += strCreate;
		}
		else
		{
			strCmd += MakeOneData(lpcszDataZ, m_settings.str1stFormula);

			string		strCreate;
			strCreate.Format("create Func -mf %s;", lpcszDataZ);
			strCmd += strCreate;
		}
		LT_execute(strCmd);

		MatrixPage	mp = Project.MatrixPages(nIndex);
		if ( mp )
			return mp.Layers();
	}

	MatrixLayer		junk;
	return junk;
}

BOOL				New3DFunctionPlotDlg::UpdateLabels(MatrixLayer& ml)
{
	if ( !ml )
		return FALSE;

	string strXLongName = GetStrValue(IDC_PLOTDTLS_FUNC_X_LN);
	string strXUnits = GetStrValue(IDC_PLOTDTLS_FUNC_X_UNITS);
	string strXComments = GetStrValue(IDC_PLOTDTLS_FUNC_X_COMMENTS);	
	
	string strYLongName = GetStrValue(IDC_PLOTDTLS_FUNC_Y_LN);
	string strYUnits = GetStrValue(IDC_PLOTDTLS_FUNC_Y_UNITS);
	string strYComments = GetStrValue(IDC_PLOTDTLS_FUNC_Y_COMMENTS);		
	
	string strZLongName = GetStrValue(IDC_PLOTDTLS_FUNC_Z_LN);
	string strZUnits = GetStrValue(IDC_PLOTDTLS_FUNC_Z_UNITS);
	string strZComments = GetStrValue(IDC_PLOTDTLS_FUNC_Z_COMMENTS);
	
	//set z labels
	MatrixObject mo = ml.MatrixObjects(0);
	mo.SetLongName(strZLongName);
	mo.SetComments(strZComments);
	mo.SetUnits(strZUnits);
	
	if ( !IsParametric() )
	{
		ASSERT(ml.MatrixObjects.Count() == 1);
		
		//set x labels
		ml.SetAxesLongName(strXLongName, false);
		ml.SetAxesComments(strXComments, false);
		ml.SetAxesUnits(strXUnits, false);
		
		//set y labels		
		ml.SetAxesLongName(strYLongName, true);
		ml.SetAxesComments(strYComments, true);
		ml.SetAxesUnits(strYUnits, true);
	}
	else
	{
		ASSERT(ml.MatrixObjects.Count() == 3);
		
		//set x labels
		MatrixObject moX = ml.MatrixObjects(1);
		moX.SetLongName(strXLongName);
		moX.SetComments(strXComments);
		moX.SetUnits(strXUnits);
		
		//set Y labels
		MatrixObject moY = ml.MatrixObjects(2);
		moY.SetLongName(strYLongName);
		moY.SetComments(strYComments);
		moY.SetUnits(strYUnits);
	}
	return TRUE;
}

#define		STR_3D_PLOTTING_TEMPLATE		"[<new template:=%s>]<new>"
BOOL				New3DFunctionPlotDlg::MakePlot(MatrixLayer& ml, GraphLayer& gl)
{
	if ( !ml )
		return FALSE;
	
	///------ Folger 05/10/2012 ORG-5657-S1 ADD_TO_GRAPH_SHOULD_SHOW_ON_3DGL_GRAPH
	//double		ogl = 1;
	//LT_get_var("@ogl", &ogl);
	//BOOL		bGL = ogl > 0;	
	BOOL bGL = Is3DGLOn();
	///------ End ADD_TO_GRAPH_SHOULD_SHOW_ON_3DGL_GRAPH	
	string		strLayer;
	if ( IsAddToGraph() && gl )
	{
		strLayer = "<active>";
		gl.CheckShowActivate();
	}
	else
	{
		///------ Folger 08/28/2012 ORG-6423-P2 INDIVIDUAL_TEMPLATE_FOR_3D_AND_3D_PARAMETRIC
		//strLayer.Format(STR_3D_PLOTTING_TEMPLATE, bGL ? STR_OK3DGLSURFACE_TEMPLATE_PREFIX "Func" : "Mesh");
		string strTemplate;
		if ( bGL )
		{
			strTemplate = STR_OK3DGLSURFACE_TEMPLATE_PREFIX;
			strTemplate += IsParametric() ?  "parafunc" : "func";
		}
		else
		{
			strTemplate = "Mesh";
		}
		strLayer.Format(STR_3D_PLOTTING_TEMPLATE, strTemplate);
		///------ End INDIVIDUAL_TEMPLATE_FOR_3D_AND_3D_PARAMETRIC
	}
	
	string		strInput;
	ml.MatrixObjects().GetRangeString(strInput);
	
	string		strCmd;
	///------ Folger 02/14/2012 ORG-5043-P1 FILAED_TO_DRAW_3D_FUNCTION_PLOT
	//if ( IsParametric() )
	//{
	//	strCmd.Format("plotm %s plot:=%d x:=2 y:=3 ogl:=%s rescale:=0;", strInput, IDM_PLOT_3D_SURFACE_NEW, strLayer);
	//}
	//else
	//{
	//	strCmd.Format("plotm %s plot:=%d ogl:=%s rescale:=0;", strInput, IDM_PLOT_3D_MESH, strLayer);
	//}
	strCmd.Format(IsParametric() ? "plotm %s plot:=%d x:=2 y:=3 ogl:=%s rescale:=0;" : "plotm %s plot:=%d ogl:=%s rescale:=0;",
		strInput, bGL ? IDM_PLOT_3D_SURFACE_NEW : IDM_PLOT_3D_MESH, strLayer);
	///------ End FILAED_TO_DRAW_3D_FUNCTION_PLOT

	return LT_execute(strCmd)
		///------ Folger 07/29/2011 ORG-3366-P1 SMART_RESCALE_WHEN_ADD_TO_GRAPH
		&& Rescale();
		///------ End SMART_RESCALE_WHEN_ADD_TO_GRAPH
}

///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
/// virtual
void				New3DFunctionPlotDlg::CheckUpdateRangeFromTo()
{
	GetItem(IDC_1ST_FROM).Enable = GetItem(IDC_1ST_TO).Enable = !IsAutoRange();
	GetItem(IDC_2ND_FROM).Enable = GetItem(IDC_2ND_TO).Enable = !IsAutoRange2();
	///------ Folger 09/19/2011 ORG-3276-S3 UPDATE_RANGE_FROM_TO_WHEN_SET_AUTO_RANGE
	GraphLayer		gl = Project.ActiveLayer();
	if ( gl )
	{
		if ( IsAutoRange() )
		{
			SetdoubleValue(IDC_1ST_FROM, gl.X.From);
			SetdoubleValue(IDC_1ST_TO, gl.X.To);
		}
		if ( IsAutoRange2() )
		{
			SetdoubleValue(IDC_2ND_FROM, gl.Y.From);
			SetdoubleValue(IDC_2ND_TO, gl.Y.To);
		}
	}
	///------ End UPDATE_RANGE_FROM_TO_WHEN_SET_AUTO_RANGE
}

/// virtual
void				New3DFunctionPlotDlg::CheckShowAutoRange()
{
	///------ Folger 10/18/2011 ORG-3276-P4 AUTO_RANGE_SHOULD_NOT_SHOW_ON_LABEL_TAB
	//AutoRange2().Visible = IsAddToGraph();
	AutoRange2().Visible = IsShowAutoRange();
	///------ End AUTO_RANGE_SHOULD_NOT_SHOW_ON_LABEL_TAB
	FunctionPlotDlgBase::CheckShowAutoRange();
}

/// virtual
void				New3DFunctionPlotDlg::CheckSetAutoRange(BOOL bOn)
{
	SetAutoRange2(bOn);
	FunctionPlotDlgBase::CheckSetAutoRange(bOn);
}
///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE

///------ Folger 05/10/2012 ORG-5657-S1 ADD_TO_GRAPH_SHOULD_SHOW_ON_3DGL_GRAPH
BOOL New3DFunctionPlotDlg::Is3DGLOn()
{
	double		ogl = 1;
	LT_get_var("@ogl", &ogl);
	return ogl > 0;
}
///------ End ADD_TO_GRAPH_SHOULD_SHOW_ON_3DGL_GRAPH




void openNew3DFunctionPlotDlg()
{
	New3DFunctionPlotDlg myDlg(FALSE);
	myDlg.DoModalEx();
}

void openNew3DParamFunctionPlotDlg()
{
	New3DFunctionPlotDlg myDlg(TRUE);
	myDlg.DoModalEx();
}


///------ Folger 08/03/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
FunctionPlotDlgBase*	create_New3DFunctionPlotDlg(BOOL bParametric)
{
	return new New3DFunctionPlotDlg(bParametric);
}
///------ End SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT