/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 07/29/2011 ORG-3350-P2 LAST_USED_IN_FUNCTION_PLOT_DIALOG				*
 *	Folger 07/29/2011 ORG-3366-P1 SMART_RESCALE_WHEN_ADD_TO_GRAPH				*
 *	Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE	*
 *	Folger 08/02/2011 ORG-3386-P1 USER_DEFINED_PARAM_NAME_NOT_WORK_IN_2D_PARAM_FUNCTION
 *	Folger 08/03/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT	*
 *  Sen 08/18/2011 ORG-3342-P2 CHECK_VALID_PARAMETER_NAME						*
 *	Folger 08/26/2011 ORG-3647-P1 ORIGIN_CRASH_IF_CREATE_NEW_2D_FUNCTION_PLOT_AFTER_OLD_FUNCTION_PLOT
 *	Folger 09/19/2011 ORG-3276-P3 AUTO_RANGE_CHECKBOX_SHOW_WHEN_ADD_TO_ACTIVE_GRAPH
 *	Folger 09/19/2011 ORG-3276-S3 UPDATE_RANGE_FROM_TO_WHEN_SET_AUTO_RANGE		*
 *	Folger 05/09/2012 ORG-5651-P2 FUNCTION_PLOT_BEFORE_SCRIPT_FAILED_TO_BE_PASTED
 *	Folger 05/30/2012 ORG-5813-P1 ADD_TO_GRAPH_SHOULD_NOT_BE_SHOWN_WHEN_SWITCH_TO_EMPTY_FOLDER
 *	Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
 *	Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
 *	Folger 06/08/2012 ORG-5925-P1 NOT_SET_ADD_TO_GRAPH_WHEN_APPLY_THEME			*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for mos2t Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <..\OriginLab\DialogEx.h>
#include "NewFunctionPlotHelper.h"
#include "New2DFunctionPlotDlg.h"

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
#define TAB_ITEM_COUNT		2

enum
{
	TAB_FUNCTION,
	TAB_LABEL,
};

#define RIGHTMOST_CONTROL_IN_TAB		IDC_PLOTDTLS_FUNC_PRESCRIPT_INSERT
#define BOTTOMMOST_CONTROL_IN_TAB		IDC_PLOTDTLS_FUNC_PRESCRIPT

#define ERR_PARAMETER_INVALID_NAME _L("Invalid parameter name.")/// Sen 08/18/2011 ORG-3342-P2 CHECK_VALID_PARAMETER_NAME

static const vector<uint> s_vnTabXGapFactor = {2, 4};
static const vector<uint> s_vnTabYGapFactor = {3, 4};

New2DFunctionPlotDlg::New2DFunctionPlotDlg(BOOL bParametric) : FunctionPlotDlgBase(IDD_2D_FUNCTION_PLOT_NEW_DLG, bParametric)
{
}
New2DFunctionPlotDlg::~New2DFunctionPlotDlg()
{
}

BEGIN_MESSAGE_MAP(New2DFunctionPlotDlg)

	ON_INIT(OnInitDialog) 
	ON_READY(OnReady)
	ON_TAB_SEL_CHANGE(IDC_TAB, OnTabChange)
	ON_BN_CLICKED(IDC_PLOTDTLS_FUNC_1ST_FORMULA_INSERT, On1stFormulaClick)
	ON_BN_CLICKED(IDC_PLOTDTLS_FUNC_2ND_FORMULA_INSERT, On2ndFormulaClick)
	ON_BN_CLICKED(IDC_PLOTDTLS_FUNC_PRESCRIPT_INSERT, OnPrescriptClick)
	ON_BN_CLICKED(IDC_THEME_BN, OnThemeSaveButtonClick)

	ON_EN_CHANGE(IDC_EDIT_PARAMETER_NAME, OnAfterParamNameEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_1ST_PARAM_POINTS, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_1ST_PARAM_FROM, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_1ST_PARAM_TO, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_1ST_FORMULA, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_2ND_FORMULA, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_PRESCRIPT, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_Y_LN, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_Y_UNITS, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_Y_COMMENTS, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_X_LN, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_X_UNITS, OnAfterControlEdit)
	ON_EN_CHANGE(IDC_PLOTDTLS_FUNC_X_COMMENTS, OnAfterControlEdit)
///------ Sen 7/27/11 ORG-3342-P1 ADD_ERR_MSG_FOR_FORMULA_EMPTY
//	ON_BN_CLICKED(IDOK, OnOK)
	ON_OK(OnOK)
///------ End ADD_ERR_MSG_FOR_FORMULA_EMP
	ON_CMD_UI_UPDATE_RANGE(IDC_FITTING_FUNC_CATEGORY_BEGIN, IDC_FITTING_FUNC_CATEGORY_BEGIN + FITTING_FUNC_CATEGORY_NUM, OnUIUpdateFittingFunc)

	ON_BN_CLICKED(IDC_PLOTDTLS_FUNC_SHOW_LT_SCRIPT, OnCheckShowLT)
	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	ON_BN_CLICKED(IDC_PLOTDTLS_FUNC_AUTO_RANGE, OnCheckAuto)
	///------ Folger 06/04/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	//ON_BN_CLICKED(IDC_PLOTDTLS_FUNC_ADD_TO_GRAPH, OnCheckAddToGraph)
	ON_CBN_SELCHANGE(IDC_PLOTDTLS_FUNC_ADD_TO_GRAPH, OnCheckAddToGraph)
	///------ End IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE

	ON_GRID_BEFORE_EDIT(IDC_PLOTDTLS_FUNC_PRESCRIPT_GRID, OnBeforeEditPreScriptGrid)
	ON_GRID_AFTER_EDIT(IDC_PLOTDTLS_FUNC_PRESCRIPT_GRID, OnAfterEditPreScriptGrid)

	ON_CONTEXTMENU(OnShowMenu)

	ON_HELPINFO(OnHelp)

	ON_DESTROY(OnDestroy) ///------ Folger 06/08/2012 ORG-5925-P1 NOT_SET_ADD_TO_GRAPH_WHEN_APPLY_THEME

END_MESSAGE_MAP

BOOL	New2DFunctionPlotDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
{
	nHelpID = IsParametric() ? IDD_2D_PARAM_FUNCTION_PLOT_NEW_DLG : IDD_2D_FUNCTION_PLOT_NEW_DLG;
	return TRUE;
}

///------ Folger 08/03/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
/// virtual
BOOL	New2DFunctionPlotDlg::CopyTheme(FunctionPlotContext& context)
{
	GetDefaultSettings();

	m_settings.bShowLT = context.strPrescript[0] != '\0'; ///------ Folger 05/09/2012 ORG-5651-P2 FUNCTION_PLOT_BEFORE_SCRIPT_FAILED_TO_BE_PASTED

	m_settings.strParamName = context.strParam1;
	m_settings.nPoints = context.nPoints1;
	m_settings.strFrom = context.strFrom1;
	m_settings.strTo = context.strTo1;
	m_settings.strDefinitions = context.strPrescript;

	m_settings.strFormular = context.strFormula1;
	if ( IsParametric() )
	{
		m_settings.strYFormular = context.strFormula2;
	}

	return FunctionPlotDlgBase::CopyTheme(context);
}
///------ End SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT

///------ Folger 06/04/2012 ORG-5813-S1 SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD
/// virtual
BOOL New2DFunctionPlotDlg::PasteTheme(FunctionPlotContext& context)
{
	if ( !FunctionPlotDlgBase::PasteTheme(context) )
		return FALSE;

	lstrcpyn(context.strParam1, m_settings.strParamName, MAXLINE);
	context.nPoints1 = m_settings.nPoints;
	lstrcpyn(context.strFrom1, m_settings.strFrom, MAXLINE);
	lstrcpyn(context.strTo1, m_settings.strTo, MAXLINE);
	m_settings.strDefinitions.Replace("\n", "\r\n");
	lstrcpyn(context.strPrescript, m_settings.strDefinitions, MAX_BUFFER_SIZE);

	lstrcpyn(context.strFormula1, m_settings.strFormular, MAX_FORMULA_SIZE);
	if ( IsParametric() )
	{
		lstrcpyn(context.strFormula2, m_settings.strYFormular, MAX_FORMULA_SIZE);
	}

	return TRUE;
}
///------ End SUPPORT_FUNCTION_PLOT_PASTE_THEME_FROM_CLIPBOARD

BOOL New2DFunctionPlotDlg::OnInitDialog()
{
	return FunctionPlotDlgBase::OnInitDialog(IDC_TAB, IsParametric() ? "2D Parameteric Dialog" : "2D Function Dialog");
}

BOOL New2DFunctionPlotDlg::OnReady()
{
	return ConstructMenu();
}

void New2DFunctionPlotDlg::init2DFuncDlgControlPosition()
{	
	RECT rr1, rr2;		
	GetControlClientRect(IDC_PLOTDTLS_FUNC_1ST_FORMULA, rr1);
	GetControlClientRect(IDC_PLOTDTLS_FUNC_PRESCRIPT_LABEL, rr2);
	int nYOffset = rr1.bottom - rr2.top + GetControlGap();
	const vector<uint> vnIDsToMove = {
		IDC_PLOTDTLS_FUNC_PRESCRIPT_LABEL,
		IDC_PLOTDTLS_FUNC_PRESCRIPT,
		IDC_PLOTDTLS_FUNC_PRESCRIPT_INSERT,
		IDC_PLOTDTLS_FUNC_SHOW_LT_SCRIPT,
		IDOK,
		IDCANCEL,
		0
	};
	MoveControls(vnIDsToMove, 0, nYOffset);	

	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	RECT	rrAuto;
	GetControlClientRect(IDC_EDIT_PARAMETER_NAME, rrAuto);
	MoveControl(AutoRange(), rrAuto);
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	
	moveControls();
}

void New2DFunctionPlotDlg::init2DParamDlgControlPosition()
{
	/// Iris 7/14/2011 ORG-2629 ADD_PARAMETER_LABEL_FOR_2D_PARAM_DLG
	RECT rrParam, rrPoints, rrFrom;
	GetControlClientRect(IDC_EDIT_PARAMETER_NAME, rrParam);
	GetControlClientRect(IDC_PLOTDTLS_FUNC_1ST_PARAM_POINTS, rrPoints);
	GetControlClientRect(IDC_PLOTDTLS_FUNC_1ST_PARAM_FROM, rrFrom);
	
	// move parameter label and editbox to correct position
	int nXOffset = rrPoints.left - rrParam.left;
	const vector<uint> vnParamIDs = {
		IDC_PLOTDTLS_FUNC_PARAM_LABEL,
		IDC_EDIT_PARAMETER_NAME,
		0
	};
	MoveControls(vnParamIDs, nXOffset, 0);	
	
	// move other controls to the right side
	nXOffset = rrFrom.left - rrPoints.left;
	const vector<uint> vnMoveRightWithOffset = {
		IDC_POINTS_LABEL,
		IDC_PLOTDTLS_FUNC_1ST_PARAM_POINTS,
		IDC_FROM_LABEL,
		IDC_PLOTDTLS_FUNC_1ST_PARAM_FROM,
		IDC_TO_LABEL,
		IDC_PLOTDTLS_FUNC_1ST_PARAM_TO,
		0
	};
	MoveControls(vnMoveRightWithOffset, nXOffset, 0);	
	///End ADD_PARAMETER_LABEL_FOR_2D_PARAM_DLG
	
	moveControls();
}

/// virtual
void	New2DFunctionPlotDlg::GetDefaultSettings()
{
	m_settings.strParamName = IsParametric() ? "t" : "x";
	m_settings.nPoints = 100;
	m_settings.strFrom = "0";
	m_settings.strTo = "2*pi";
	m_settings.strFormular = "";
	m_settings.strYFormular = "";
	m_settings.bShowLT = FALSE;
	m_settings.strDefinitions = "";
	m_settings.strYLN = "";
	m_settings.strYUnits = "";
	m_settings.strYComments = "";
	m_settings.strXLN = "";
	m_settings.strXUnits = "";
	m_settings.strXComments = "";
	///------ Folger 06/01/2012 ORG-5813-S3 IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	//m_settings.nAddToGraph = FALSE;
	m_settings.nAddToGraph = ADDTOGRAPH_NO;
	///------ End IMPROVE_ADD_TO_CURRENT_GRAPH_OPTION_IN_NEW_FUNCTION_PLOT_DIALOG
	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	m_settings.bAutoRange = FALSE;
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
}	

/// virtual
void	New2DFunctionPlotDlg::LoadThemeSettings()
{
	SetStrValue(IDC_EDIT_PARAMETER_NAME, m_settings.strParamName);
	SetIntValue(IDC_PLOTDTLS_FUNC_1ST_PARAM_POINTS, m_settings.nPoints);
	SetStrValue(IDC_PLOTDTLS_FUNC_1ST_PARAM_FROM, m_settings.strFrom);
	SetStrValue(IDC_PLOTDTLS_FUNC_1ST_PARAM_TO, m_settings.strTo);
	SetStrValue(IDC_PLOTDTLS_FUNC_1ST_FORMULA, m_settings.strFormular);
	SetStrValue(IDC_PLOTDTLS_FUNC_2ND_FORMULA, m_settings.strYFormular);
	m_settings.strDefinitions.Replace("\n", "\r\n"); ///------ Folger 05/10/2012 ORG-5651-P2 FUNCTION_PLOT_BEFORE_SCRIPT_FAILED_TO_BE_PASTED
	SetStrValue(IDC_PLOTDTLS_FUNC_PRESCRIPT, m_settings.strDefinitions);
	SetStrValue(IDC_PLOTDTLS_FUNC_Y_LN, m_settings.strYLN);
	SetStrValue(IDC_PLOTDTLS_FUNC_Y_UNITS, m_settings.strYUnits);
	SetStrValue(IDC_PLOTDTLS_FUNC_Y_COMMENTS, m_settings.strYComments);
	SetStrValue(IDC_PLOTDTLS_FUNC_X_LN, m_settings.strXLN);
	SetStrValue(IDC_PLOTDTLS_FUNC_X_UNITS, m_settings.strXUnits);
	SetStrValue(IDC_PLOTDTLS_FUNC_X_COMMENTS, m_settings.strXComments);
	
	SetShowLT(m_settings.bShowLT);
	//SetAddToGraph(m_settings.nAddToGraph); ///------ Folger 06/08/2012 ORG-5925-P1 NOT_SET_ADD_TO_GRAPH_WHEN_APPLY_THEME
	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	SetAutoRange(m_settings.bAutoRange);

	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	FunctionPlotDlgBase::LoadThemeSettings();
}

/// virtual
BOOL	New2DFunctionPlotDlg::SaveThemeSettings()
{
	if ( !FunctionPlotDlgBase::SaveThemeSettings() )
		return FALSE;

	m_settings.strParamName = GetStrValue(IDC_EDIT_PARAMETER_NAME);
	m_settings.nPoints = GetIntValue(IDC_PLOTDTLS_FUNC_1ST_PARAM_POINTS);
	m_settings.strFrom = GetStrValue(IDC_PLOTDTLS_FUNC_1ST_PARAM_FROM);
	m_settings.strTo = GetStrValue(IDC_PLOTDTLS_FUNC_1ST_PARAM_TO);
	m_settings.strFormular = GetStrValue(IDC_PLOTDTLS_FUNC_1ST_FORMULA);
	m_settings.strYFormular = GetStrValue(IDC_PLOTDTLS_FUNC_2ND_FORMULA);
	m_settings.strDefinitions = GetStrValue(IDC_PLOTDTLS_FUNC_PRESCRIPT);
	m_settings.strDefinitions.TrimLeft(), m_settings.strDefinitions.TrimRight();
	m_settings.strYLN = GetStrValue(IDC_PLOTDTLS_FUNC_Y_LN);
	m_settings.strYUnits = GetStrValue(IDC_PLOTDTLS_FUNC_Y_UNITS);
	m_settings.strYComments = GetStrValue(IDC_PLOTDTLS_FUNC_Y_COMMENTS);
	m_settings.strXLN = GetStrValue(IDC_PLOTDTLS_FUNC_X_LN);
	m_settings.strXUnits = GetStrValue(IDC_PLOTDTLS_FUNC_X_UNITS);
	m_settings.strXComments = GetStrValue(IDC_PLOTDTLS_FUNC_X_COMMENTS);

	m_settings.bShowLT = IsShowLT();
	m_settings.nAddToGraph = IsAddToGraph();
	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	m_settings.bAutoRange = IsAutoRange();
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE

	return TRUE;
}

// virtual
void	New2DFunctionPlotDlg::LoadSettingsTree(TreeNode& trSettings)
{
	FunctionPlotDlgBase::LoadSettingsTree(trSettings);
	m_settings = trSettings;
}

/// virtual
void	New2DFunctionPlotDlg::SaveSettingsTree(TreeNode& trSettings)
{
	trSettings += m_settings;
	FunctionPlotDlgBase::SaveSettingsTree(trSettings);
}

bool New2DFunctionPlotDlg::getControlIDs(int nTab, vector<uint>& vnIDsToShow, vector<uint>* pvnIDsToHide, int* pTopMostCtrl, int* pLeftMostCtrl)
{
	vector<uint> vn1stTabControls = 
	{
		IDC_POINTS_LABEL,
		IDC_FROM_LABEL,
		IDC_TO_LABEL,
		IDC_PLOTDTLS_FUNC_1ST_PARAM_POINTS,	
		IDC_PLOTDTLS_FUNC_1ST_PARAM_FROM,
		IDC_PLOTDTLS_FUNC_1ST_PARAM_TO,
		IDC_PLOTDTLS_FUNC_1ST_FORMULA_LABEL,
		IDC_PLOTDTLS_FUNC_1ST_FORMULA,
		IDC_PLOTDTLS_FUNC_1ST_FORMULA_INSERT,
		IDC_PLOTDTLS_FUNC_PRESCRIPT_LABEL,
		IDC_PLOTDTLS_FUNC_PRESCRIPT,	
		IDC_PLOTDTLS_FUNC_PRESCRIPT_INSERT,
		IDC_PLOTDTLS_FUNC_SHOW_LT_SCRIPT,
		IDC_PLOTDTLS_FUNC_PRESCRIPT_GRID
	};
	
	const vector<uint> vn1stTabFuncDlgControls = 
	{
		IDC_PLOTDTLS_FUNC_1ST_PARAM_LABEL
	};

	///------ Folger 09/19/2011 ORG-3276-P3 AUTO_RANGE_CHECKBOX_SHOW_WHEN_ADD_TO_ACTIVE_GRAPH
	//if ( NULL == pvnIDsToHide )
	if ( NULL == pvnIDsToHide || IsAddToGraph() )
	///------ End AUTO_RANGE_CHECKBOX_SHOW_WHEN_ADD_TO_ACTIVE_GRAPH
	{
		///------ Folger 08/01/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
		vn1stTabFuncDlgControls.Add(IDC_PLOTDTLS_FUNC_AUTO_RANGE);
		///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	}
	
	const vector<uint> vn1stTabParamDlgControls = 
	{
		IDC_PLOTDTLS_FUNC_PARAM_LABEL,
		IDC_EDIT_PARAMETER_NAME,
		IDC_PLOTDTLS_FUNC_2ND_FORMULA_LABEL,
		IDC_PLOTDTLS_FUNC_2ND_FORMULA,
		IDC_PLOTDTLS_FUNC_2ND_FORMULA_INSERT
	};
	if( !IsParametric() )
	{
		vn1stTabControls.Append(vn1stTabFuncDlgControls);
	}
	else
	{
		vn1stTabControls.Append(vn1stTabParamDlgControls);
	}
	
	const vector<uint> vn2ndTabControls = 
	{
		IDC_PLOTDTLS_FUNC_LN_LABEL,    
		IDC_PLOTDTLS_FUNC_UNITS_LABEL, 
		IDC_PLOTDTLS_FUNC_COMMENTS_LABEL,
		IDC_PLOTDTLS_FUNC_Y_LABELS, 
		IDC_PLOTDTLS_FUNC_Y_LN,
		IDC_PLOTDTLS_FUNC_Y_UNITS,
		IDC_PLOTDTLS_FUNC_Y_COMMENTS,
		IDC_PLOTDTLS_FUNC_X_LABELS,     	      	  
		IDC_PLOTDTLS_FUNC_X_LN,       
		IDC_PLOTDTLS_FUNC_X_UNITS,   
		IDC_PLOTDTLS_FUNC_X_COMMENTS   
	};
	
	
	vnIDsToShow.RemoveAll();
	vector<uint> vnIDsToHideTemp;
	uint nLastControl;
	switch(nTab)
	{
	case TAB_FUNCTION:
		vnIDsToShow.Append(vn1stTabControls);
		vnIDsToHideTemp.Append(vn2ndTabControls);
		if( !IsParametric() )
		{
			vnIDsToHideTemp.Append(vn1stTabParamDlgControls);
		}
		else
		{
			vnIDsToHideTemp.Append(vn1stTabFuncDlgControls);
		}
		if( pTopMostCtrl )
			*pTopMostCtrl = IDC_POINTS_LABEL;
		if( pLeftMostCtrl )
			*pLeftMostCtrl = IDC_PLOTDTLS_FUNC_1ST_FORMULA_LABEL;		
		break;
		
	case TAB_LABEL:
		vnIDsToShow.Append(vn2ndTabControls);
		vnIDsToHideTemp.Append(vn1stTabControls);
		if( pTopMostCtrl )
			*pTopMostCtrl = IDC_PLOTDTLS_FUNC_LN_LABEL;
		if( pLeftMostCtrl )
			*pLeftMostCtrl = IDC_PLOTDTLS_FUNC_Y_LABELS;		
		break;	
	default:
		ASSERT(false);
		return false;	
	}	
	if( pvnIDsToHide != NULL )
		*pvnIDsToHide = vnIDsToHideTemp;	
	return true;
}

void New2DFunctionPlotDlg::moveControls()
{
	RECT rTab, rThemeButton;
	GetControlClientRect(IDC_TAB, rTab);
	GetControlClientRect(IDC_THEME_BN, rThemeButton);
	
	int			nGap = Gap();
	rTab.left = nGap;
	rTab.top = 2 * s_vnTabXGapFactor[0] * nGap + RECT_HEIGHT(rThemeButton);
	MoveControl(Tab(), rTab);
	
	// get all control IDs and first control and the last control.
	for(int nTab = 0; nTab < TAB_ITEM_COUNT; nTab++)
	{
		vector<uint> vnIDs;
		int nLeftMostCtrl, nTopMostCtrl;
		getControlIDs(nTab, vnIDs, NULL, &nTopMostCtrl, &nLeftMostCtrl);	
		if( vnIDs.GetSize() == 0 )
		{
			error_report("Error, no control need to move and resize, pls check code.");
			return;
		}	
	
		// move all controls
		RECT rctrlLeft, rctrlTop;
		GetControlClientRect(nLeftMostCtrl, rctrlLeft);
		GetControlClientRect(nTopMostCtrl, rctrlTop);
		
		RECT rTabItem;
		Tab().GetItemRect(nTab, &rTabItem);
		int nX = rTab.left - rctrlLeft.left + s_vnTabXGapFactor[nTab] * nGap;
		int nY = rTab.top - rctrlTop.top + s_vnTabYGapFactor[nTab] * nGap + RECT_HEIGHT(rTabItem);
		vnIDs.Add(0); // 0 means end
		MoveControls(vnIDs, nX, nY);
	}
}

void New2DFunctionPlotDlg::resizeTab()
{
	if( !Tab() )
	{
		error_report("Error, invalid TabControl object - m_tab. ");
		return;
	}	
	
	RECT rTab;
	GetClientRect(Tab(), rTab);
	//m_tab.AdjustRect(false, &rTab);
	int nTab = Tab().GetCurSel();

	int			nGap = Gap();
	
	RECT rBottomItem, rRightItem;
	GetControlClientRect(RIGHTMOST_CONTROL_IN_TAB, rRightItem);
	GetControlClientRect(BOTTOMMOST_CONTROL_IN_TAB, rBottomItem);
	int nTabWidth = rRightItem.right + nGap;
	rTab.right = rTab.left + nTabWidth;	
	rTab.bottom = rBottomItem.bottom + s_vnTabYGapFactor[nTab] * nGap;
	MoveControl(Tab(), rTab); // resize and move tab
	
	RECT	rectPreScriptGrid;
	GetControlClientRect(IDC_PLOTDTLS_FUNC_PRESCRIPT, rectPreScriptGrid);
	rectPreScriptGrid.right = rRightItem.right;
	MoveControl(GetItem(IDC_PLOTDTLS_FUNC_PRESCRIPT_GRID), rectPreScriptGrid);
	
	// resize and move background control
	Control ctrlBackground = GetItem(IDC_STATIC_BACK);
	if( ctrlBackground )
	{
		ctrlBackground.Text = "";
		Tab().AdjustRect(false, &rTab);
		rTab.left--; // move to left more to remove the left white line
		MoveControl(ctrlBackground, rTab);
	}
}

void New2DFunctionPlotDlg::resizeDlg()
{	
	RECT rTab;
	GetClientRect(Tab(), rTab);
	
	// move OK and Cancle button
	RECT rCancel;
	GetControlClientRect(IDCANCEL, rCancel);

	int			nGap = Gap();
	
	int nButtonBottom = rTab.bottom + nGap + RECT_HEIGHT(rCancel);
	MoveControl(IDCANCEL, rTab.right, nButtonBottom, false );
	MoveControl(IDOK, rTab.right - RECT_WIDTH(rCancel) - nGap, nButtonBottom, false );	
	MoveControl(IDC_PLOTDTLS_FUNC_ADD_TO_GRAPH, rTab.left, rTab.bottom + nGap, true);	
	GetControlClientRect(IDCANCEL, rCancel);
	
	RECT rDlg;	
	m_wndDlg.GetWindowRect(&rDlg);
	m_wndDlg.ScreenToClient(&rDlg);
	Tab().AdjustRect(true, &rTab);
	rDlg.right = rTab.right + nGap;
	rDlg.bottom = rCancel.bottom + nGap;
	m_wndDlg.ClientToScreen(&rDlg);		
	m_wndDlg.MoveWindow(&rDlg, true);
}

void New2DFunctionPlotDlg::updateFormularControlLabel()
{
	Control ctrlParamName = GetItem(IDC_EDIT_PARAMETER_NAME);
	string strParamName = ctrlParamName.Text;
	
	string strLabel;
	strLabel.Format("%s(%s)=", IsParametric() ? "X" : "Y", strParamName);
	Control ctrlLabel1 = GetItem(IDC_PLOTDTLS_FUNC_1ST_FORMULA_LABEL);
	ctrlLabel1.Text = strLabel;
	changeControlWidthByTextLength(ctrlLabel1, IDC_PLOTDTLS_FUNC_1ST_FORMULA);
	
	if( IsParametric() )
	{
		strLabel.Format("Y(%s)=", strParamName);
		Control ctrlLabel2 = GetItem(IDC_PLOTDTLS_FUNC_2ND_FORMULA_LABEL);
		ctrlLabel2.Text = strLabel;	
		changeControlWidthByTextLength(ctrlLabel2, IDC_PLOTDTLS_FUNC_2ND_FORMULA);
	}
}

void New2DFunctionPlotDlg::changeControlWidthByTextLength(Control& ctrl, int nRightSideControlID)
{
	RECT rr;
	GetClientRect(ctrl, rr);
	int nWidth = RECT_WIDTH(rr);
	
	ctrl.Measure(ctrl.Text, &nWidth, true);
	rr.right = rr.left + nWidth;
	MoveControl(ctrl, rr);
	
	Control ctrlRight = GetItem(nRightSideControlID);
	if( ctrlRight )
	{
		RECT rrRight;
		GetClientRect(ctrlRight, rrRight);
		
		int nLeftOfRightControl = rr.right + Gap();
		if( rrRight.left != nLeftOfRightControl )
		{
			rrRight.left = nLeftOfRightControl;
			MoveControl(ctrlRight, rrRight);
		}
	}
}

BOOL New2DFunctionPlotDlg::OnTabChange(Control ctrl)
{
	OnShowTab(Tab().GetCurSel());
	
	return TRUE;
}

BOOL New2DFunctionPlotDlg::On1stFormulaClick(Control ctrl)
{
	OnInsertButton(IDC_PLOTDTLS_FUNC_1ST_FORMULA_INSERT, IDC_PLOTDTLS_FUNC_1ST_FORMULA);

	return TRUE;
}

BOOL New2DFunctionPlotDlg::On2ndFormulaClick(Control ctrl)
{
	OnInsertButton(IDC_PLOTDTLS_FUNC_2ND_FORMULA_INSERT, IDC_PLOTDTLS_FUNC_2ND_FORMULA);

	return TRUE;
}

BOOL New2DFunctionPlotDlg::OnPrescriptClick(Control ctrl)
{
	OnInsertButton(IDC_PLOTDTLS_FUNC_PRESCRIPT_INSERT, IDC_PLOTDTLS_FUNC_PRESCRIPT);

	return TRUE;
}

BOOL New2DFunctionPlotDlg::OnAfterParamNameEdit(Control cntrl)
{
	/// Sen 08/18/2011 ORG-3342-P2 CHECK_VALID_PARAMETER_NAME
	if(!checkParameterName())
		return TRUE;
	/// End CHECK_VALID_PARAMETER_NAME
	
	updateFormularControlLabel();
	OnDlgSettingChange();
	return TRUE;
}

/// Sen 08/18/2011 ORG-3342-P2 CHECK_VALID_PARAMETER_NAME
bool New2DFunctionPlotDlg::checkParameterName()
{
	string strParam = GetItem(IDC_EDIT_PARAMETER_NAME).Text;

	bool bSucc = true;
	
	strParam.MakeValidCName();
	
	if(strParam != GetItem(IDC_EDIT_PARAMETER_NAME).Text)
	{
		GetItem(IDC_EDIT_PARAMETER_NAME).Text = "";
		bSucc = false;
	}

	HWND hwnd = GetFocus();
	if (!bSucc)
	{
		MessageBox(GetSafeHwnd(), ERR_PARAMETER_INVALID_NAME);
		SetFocus(hwnd);
	}

	return bSucc;
}
/// End CHECK_VALID_PARAMETER_NAME

///Sen 7/19/2011 ORG-3247-P1 SET_METADATA_FOR_LOOSE_DATASET	
string New2DFunctionPlotDlg::EnumName(LPCSTR lpcszName)
{
	char	szBuffer[MAXLINE];
	string	strDataName	= lpcszName;
	int		nn = string_to_prefix_end_number(szBuffer, strDataName);
	if ( nn == 0 )
	{
		strDataName += "1";
	}
	else
	{
		strDataName.Format("%s%d", szBuffer, nn + 1);		
	}
	return strDataName;
}
///END SET_METADATA_FOR_LOOSE_DATASET	

bool New2DFunctionPlotDlg::newFuncPlot(int nPoints, LPCSTR lpcszFrom, LPCSTR lpcszTo, LPCSTR lpcszFormular, LPCSTR lpcszDsName, LPCSTR lpcszPreScript)
{
	string strYData;
	strYData.Format("create %s -ff %d \"%s\" \"%s\" \"%s\";", lpcszDsName, nPoints, lpcszFormular, lpcszFrom, lpcszTo);
	
	if ( *lpcszPreScript != '\0' )
	{
		string		strPreScript;
		strPreScript.Format("set %s -fbs \"%s\";", lpcszDsName, lpcszPreScript);
		strYData += strPreScript;
	}
	
	string strDoPlot;
	strDoPlot.Format("plotxy (, %s) ogl:=<new template:=function>;);", lpcszDsName);
	
	string strCmd = strYData + strDoPlot;
	return LT_execute(strCmd);	
}

bool New2DFunctionPlotDlg::newParamFuncPlot(int nPoints, LPCSTR lpcszFrom, LPCSTR lpcszTo, LPCSTR lpcszXFormular, LPCSTR lpcszYFormular, LPCSTR lpcszParamName, LPCSTR lpcszDsXName, LPCSTR lpcszDsYName, LPCSTR lpcszPreScript)
{
	string strXData;
	strXData.Format("create %s -fp %d \"%s\" \"%s\" \"%s\";", lpcszDsXName, nPoints, lpcszXFormular, lpcszFrom, lpcszTo);
	
	string strYData;
	strYData.Format("create %s -fp %d \"%s\" \"%s\" \"%s\";", lpcszDsYName, nPoints, lpcszYFormular, lpcszFrom, lpcszTo);
	
	if ( *lpcszPreScript != '\0' )
	{
		string		strPreScript;
		strPreScript.Format("set %s -fbs \"%s\";set %s -fbs \"%s\";", lpcszDsXName, lpcszPreScript, lpcszDsYName, lpcszPreScript);
		strYData += strPreScript;
	}
	
	string strDoPlot;
	strDoPlot.Format("plotxy (%s, %s) ogl:=<new template:=function>;", lpcszDsXName, lpcszDsYName);

	string strCmd = strXData + strYData + strDoPlot;
	return LT_execute(strCmd);		
}

BOOL New2DFunctionPlotDlg::IsFormulaEmpty()
{
	if(IsParametric())
		return ( GetStrValue(IDC_PLOTDTLS_FUNC_1ST_FORMULA).IsEmpty() ||  GetStrValue(IDC_PLOTDTLS_FUNC_2ND_FORMULA).IsEmpty());			
	else
		return GetStrValue(IDC_PLOTDTLS_FUNC_1ST_FORMULA).IsEmpty();	
}

///------ Sen 7/27/11 ORG-3342-P1 ADD_ERR_MSG_FOR_FORMULA_EMPTY
//BOOL New2DFunctionPlotDlg::OnOK(Control cntrl)
BOOL New2DFunctionPlotDlg::OnOK()
{
	if( IsFormulaEmpty() )
	{
		warning_msg_box(MSG_FUNCTION_NOT_BE_EMPTY, true);
		return FALSE;	
	}
///------ End ADD_ERR_MSG_FOR_FORMULA_EMP	

	GraphLayer	gl = Project.ActiveLayer();
	Dataset		dsY;
	Worksheet	wks = CreateData(dsY);
	if ( !wks && !dsY )
		return FALSE;
	
	if ( !UpdateLabels(wks, dsY) )
		return FALSE;
	
	return MakePlot(wks, dsY, gl) && OnAfterApply();
}

///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
/// virtual
void	New2DFunctionPlotDlg::CheckUpdateRangeFromTo()
{
	GetItem(IDC_PLOTDTLS_FUNC_1ST_PARAM_FROM).Enable = GetItem(IDC_PLOTDTLS_FUNC_1ST_PARAM_TO).Enable = !IsAutoRange();
	///------ Folger 09/19/2011 ORG-3276-S3 UPDATE_RANGE_FROM_TO_WHEN_SET_AUTO_RANGE
	GraphLayer		gl = Project.ActiveLayer();
	if ( gl )
	{
		if ( IsAutoRange() )
		{
			SetdoubleValue(IDC_PLOTDTLS_FUNC_1ST_PARAM_FROM, gl.X.From);
			SetdoubleValue(IDC_PLOTDTLS_FUNC_1ST_PARAM_TO, gl.X.To);
		}
	}
	///------ End UPDATE_RANGE_FROM_TO_WHEN_SET_AUTO_RANGE
}
///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE

/// virtual
string	New2DFunctionPlotDlg::DialogTitle()
{
	return IsParametric() ? _L("Create 2D Parametric Function Plot") : _L("Create 2D Function Plot");
}

/// virtual
string	New2DFunctionPlotDlg::ClassOption()
{
	return IsParametric() ? "ParamFunc2D" : "Func2D";
}

/// virtual
void	New2DFunctionPlotDlg::UpdateLabelCntrlsText()
{
	GetItem(IDC_PLOTDTLS_FUNC_Y_LABELS).Text = "Y";
	GetItem(IDC_PLOTDTLS_FUNC_X_LABELS).Text = IsParametric() ? "X" : "x";
}

/// virtual
void	New2DFunctionPlotDlg::GetCntrlFixedFont(vector<int>& vnIDs)
{
	vnIDs.SetSize(0);
	vnIDs.Add(IDC_PLOTDTLS_FUNC_1ST_FORMULA);
	vnIDs.Add(IDC_PLOTDTLS_FUNC_2ND_FORMULA);
	vnIDs.Add(IDC_PLOTDTLS_FUNC_PRESCRIPT);
}

/// virtual
void	New2DFunctionPlotDlg::InitControls()
{
	InitRadioBitmapButton(IDC_PLOTDTLS_FUNC_1ST_FORMULA_INSERT, IDB_DROP_DOWN_UP);
	InitRadioBitmapButton(IDC_PLOTDTLS_FUNC_2ND_FORMULA_INSERT, IDB_DROP_DOWN_UP);

	m_edtPoints.SetContentFilter(CF_INTEGER);
	m_edtPoints = GetItem(IDC_PLOTDTLS_FUNC_1ST_PARAM_POINTS);
	GetItem(IDC_EDIT_PARAMETER_NAME).Text = IsParametric() ? "t" : "x";
	updateFormularControlLabel();

	if ( IsParametric() )
	{
		init2DParamDlgControlPosition();
	}	
	else
	{
		GetItem(IDC_PLOTDTLS_FUNC_1ST_PARAM_LABEL).Text = "x";
		init2DFuncDlgControlPosition();
	}

	FunctionPlotDlgBase::InitControls();
}

/// virtual
void	New2DFunctionPlotDlg::ResizeDlg()
{
	resizeTab();
	resizeDlg();
}

/// virtual
void	New2DFunctionPlotDlg::GetCntrlIDs(int nTab, vector<uint>& vnIDstoShow, vector<uint>& vnIDstoHide)
{
	getControlIDs(nTab, vnIDstoShow, &vnIDstoHide);
}

/// virtual
BOOL	New2DFunctionPlotDlg::IsShowAddToGraph()
{
	///------ Folger 05/30/2012 ORG-5813-P1 ADD_TO_GRAPH_SHOULD_NOT_BE_SHOWN_WHEN_SWITCH_TO_EMPTY_FOLDER
	//GraphLayer	gl = Project.ActiveLayer();
	GraphLayer	gl = GetActiveLayer();
	///------ End ADD_TO_GRAPH_SHOULD_NOT_BE_SHOWN_WHEN_SWITCH_TO_EMPTY_FOLDER
	return gl && !is_3D_graph(gl);
}




string	New2DFunctionPlotDlg::ValidDataName(LPCSTR lpcszData)
{
	string		strData(lpcszData);
	///------ Folger 08/26/2011 ORG-3647-P1 ORIGIN_CRASH_IF_CREATE_NEW_2D_FUNCTION_PLOT_AFTER_OLD_FUNCTION_PLOT
	//Dataset		ds(strData);
	//while ( ds )
	//{
		//strData = EnumName(strData);
		//ds.Attach(strData);
	//}
	while ( 1 )
	{
		DatasetObject		dsObj(strData);
		if ( !dsObj )
			break;

		strData = EnumName(strData);
	}
	///------ End ORIGIN_CRASH_IF_CREATE_NEW_2D_FUNCTION_PLOT_AFTER_OLD_FUNCTION_PLOT
	return strData;
}

string	New2DFunctionPlotDlg::MakeOneData(LPCSTR lpcszData, LPCSTR lpcszFormula)
{
	string		str;
	///------ Folger 07/29/2011 ORG-3366-S1 AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
	if ( IsAutoRange() )
		str.Format("create %s -%s %d \"%s\";", lpcszData, IsParametric() ? "fp" : "ff", m_settings.nPoints, lpcszFormula);
	else
	///------ End AUTO_RANGE_FOR_FUNCTION_PLOT_NON_PARAM_TYPE
		str.Format("create %s -%s %d \"%s\" \"%s\" \"%s\";", lpcszData, IsParametric() ? "fp" : "ff", m_settings.nPoints, lpcszFormula, m_settings.strFrom, m_settings.strTo);
	
	if ( !m_settings.strDefinitions.IsEmpty() )
	{
		string		strTemp;
		strTemp.Format("set %s -fbs \"%s\";", lpcszData, m_settings.strDefinitions);
		str += strTemp;
	}
	return str;
}

#define		PARAMETRIC_X_COL			0
#define		PARAMETRIC_Y_COL			1

Worksheet	New2DFunctionPlotDlg::CreateData(Dataset& dsY)
{
	if ( SaveThemeSettings() )
	{
		int			nIndex = Project.WorksheetPages.Count();

		string		strCmd;
		string		strDataX, strDataY;
		if ( IsParametric() )
		{
			strDataX = ValidDataName("FX1");
			strDataY = ValidDataName("FY1");
			strCmd += MakeOneData(strDataX, m_settings.strFormular);
			strCmd += MakeOneData(strDataY, m_settings.strYFormular);

			string		strCreate;
			strCreate.Format("create Func -wfp %s %s \"%s\";", strDataX, strDataY, m_settings.strParamName);
			strCmd += strCreate;
		}
		else
		{
			strDataY = ValidDataName("F1");
			strCmd += MakeOneData(strDataY, m_settings.strFormular);
		}
		LT_execute(strCmd);

		if ( IsParametric() )
		{
			WorksheetPage	wp = Project.WorksheetPages(nIndex);
			if ( wp )
			{
				Worksheet	wks = wp.Layers();
				dsY.Attach(wks, PARAMETRIC_Y_COL);
				return wks;
			}

			O_A_FAIL;
		}
		else
		{
			dsY.Attach(strDataY);
			O_A(dsY);
		}
	}

	Worksheet	wksJunk;
	return wksJunk;
}

BOOL	New2DFunctionPlotDlg::UpdateLabels(Worksheet& wks, Dataset& dsY)
{	
	string strXLongName = GetStrValue(IDC_PLOTDTLS_FUNC_X_LN);
	string strXUnits = GetStrValue(IDC_PLOTDTLS_FUNC_X_UNITS);
	string strXComments = GetStrValue(IDC_PLOTDTLS_FUNC_X_COMMENTS);	
	
	string strYLongName = GetStrValue(IDC_PLOTDTLS_FUNC_Y_LN);
	string strYUnits = GetStrValue(IDC_PLOTDTLS_FUNC_Y_UNITS);
	string strYComments = GetStrValue(IDC_PLOTDTLS_FUNC_Y_COMMENTS);

	DatasetObject		dsObjY(dsY.GetName());
	dsObjY.SetLabel(strYLongName, RCLT_LONG_NAME, FALSE);
	dsObjY.SetLabel(strYComments, RCLT_COMMENT, FALSE);
	dsObjY.SetLabel(strYUnits, RCLT_UNIT, FALSE);

	if ( IsParametric() )
	{
		Column		colX(wks, PARAMETRIC_X_COL);
		colX.SetLongName(strXLongName);
		colX.SetComments(strXComments);
		colX.SetUnits(strXUnits);
	}
	else
	{
		dsObjY.SetLabel(strXLongName, RCLT_LONG_NAME, TRUE);
		dsObjY.SetLabel(strXComments, RCLT_COMMENT, TRUE);
		dsObjY.SetLabel(strXUnits, RCLT_UNIT, TRUE);
	}
	return TRUE;
}

BOOL	New2DFunctionPlotDlg::MakePlot(Worksheet& wks, Dataset& dsY, GraphLayer& gl)
{
	string		strLayer = "[<new template:=Line>]<new>";
	if ( IsAddToGraph() && gl )
	{
		strLayer = "<active>";
		gl.CheckShowActivate();
	}
	
	string		strX, strY;
	
	if ( IsParametric() )
	{
		Column		colX(wks, PARAMETRIC_X_COL);
		Column		colY(wks, PARAMETRIC_Y_COL);
		colX.GetRangeString(strX);
		colY.GetRangeString(strY);
	}
	else
	{
		dsY.GetName(strY);
	}

	string	strPlot;	
	strPlot.Format("plotxy (%s, %s) plot:=%d ogl:=%s rescale:=0;", strX, strY, IDM_PLOT_LINE, strLayer);
	return LT_execute(strPlot)
		///------ Folger 07/29/2011 ORG-3366-P1 SMART_RESCALE_WHEN_ADD_TO_GRAPH
		&& Rescale(IsParametric() ? 0 : ANL_CHK_DATA_OUTSIDE);
		///------ End SMART_RESCALE_WHEN_ADD_TO_GRAPH
}







void openNew2DFunctionPlotDlg()
{
	New2DFunctionPlotDlg myDlg(FALSE);
	myDlg.DoModalEx();
}

void openNew2DParamFunctionPlotDlg()
{
	New2DFunctionPlotDlg myDlg(TRUE);
	myDlg.DoModalEx();
}


///------ Folger 08/03/2011 ORG-3350-P1 SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT
FunctionPlotDlgBase*	create_New2DFunctionPlotDlg(BOOL bParametric)
{
	return new New2DFunctionPlotDlg(bParametric);
}
///------ End SUPPORT_COPY_THEME_IN_PD_FOR_FUNCTION_PLOT