/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <..\OriginLab\DialogEx.h>
#include "NamedRangeOrganizerDlg.h"

#define LIST_COL_HEADING		_L("Name|Range|Plot Designation|Dimension")
////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
bool NamedRangeList::Init(UINT uID, WndContainer &Dlg)
{
	SetDlgName(STR_DLG_NAME);
	GridListControl::Init( uID, Dlg );
	
	string strHeading = LIST_COL_HEADING;
	int nNumCols = strHeading.GetNumTokens('|');
	SetCols(nNumCols);
	
	for(int nCol = 0; nCol < nNumCols; nCol++)
	{
		SetColHeading(nCol, strHeading.GetToken(nCol, '|'));
	}
	
	return true;
}

BOOL NamedRangeOrganizerDlg::OnInitDialog()
{
	ResizeDialog::OnInitDialog(IDC_LIST, STR_DLG_NAME);
	m_list.Init(IDC_LIST, *this);
	return true;
}

BOOL NamedRangeOrganizerDlg::OnReady()
{
	SetInitReady(true);
	return true;
}

BOOL NamedRangeOrganizerDlg::OnDlgResize(int nType, int cx, int cy)
{	
	if(!IsInitReady())
		return true;
	
	MoveControlsHelper	_temp(this);
	int nGap = GetControlGap();
	
	RECT rrOK;
	Button btnOK = GetItem(IDOK);
	GetControlClientRect(IDOK, rrOK);
	int nButtonHeight = RECT_HEIGHT(rrOK);
	int nButtonWidth = RECT_WIDTH(rrOK);	
	
	RECT rList;
	rList.left = nGap;
	rList.top = nGap;
	rList.right = cx - nGap;
	rList.bottom = cy - 2 * nGap - nButtonHeight;
	
	Control ctrlList = GetItem(IDC_LIST);
	MoveControl(ctrlList, rList);
	
	RECT rrCancel;
	rrCancel.right = cx - nGap;
	rrCancel.left = rrCancel.right - nButtonWidth;
	rrCancel.bottom = cy - nGap;
	rrCancel.top = rrCancel.bottom - nButtonHeight;
	MoveControl(GetItem(IDCANCEL), rrCancel);
	
	rrOK = rrCancel;
	rrOK.right = rrCancel.left - nGap;
	rrOK.left = rrOK.right - nButtonWidth;
	MoveControl(GetItem(IDOK), rrOK);	
	return true;
}

void openNamedRangeOrgDlg()
{
	NamedRangeOrganizerDlg mydlg();
	mydlg.DoModalEx();
}