/*------------------------------------------------------------------------------*
 * File Name: NLParameterDlg.h					 								*
 * Creation: 																	*
 * Purpose: OriginC Source h file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 01/29/08 QA80-10929 LT_NL_ALLOW_UPDATE_PARAMS_BY_DIALOG				*
 *	Hong 01/30/08 QA80-10929 SHOULD_ONLY_ENABLE_WHEN_CONTAIN_ADVANCE_TREE		*
 *	Hong 01/30/08 QA80-10929 MOVE_TO_SEPARATE_FILE_FOR_DERIVED_USE				*
 *	Hong 01/30/08 QA80-10929 IMPLEMENT_NLFIT_BUTTONS							*
 *	Hong 02/01/08 v8.0798 FIX_SHARE_COL_NOT_SHOW_WHEN_GLOBAL_FIT				*
 *	Hong 02/01/08 v8.0798 FIX_REPLICA_FAIL_DISPLAY_IN_LT_NLFIT_PARA_DIALOG		*
 *	Hong 04/01/08 QA80-11357 FIX_CLICK_ITER_BTN_NOT_UPDATE_LT_TREE_REALTIME		*
 *	Jasmine 05/22/08 RESIZING_CODE_NEED_ZERO_TO_DETECT_THE_END					*
 *  Iris 10/24/2008 V8.0960 SET_QUICK_SET_BUTTON_PROPER_POSITION				*
 *	Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
 *	Sophy 12/4/2008 v8.0982b NOT_ALLOW_EDIT_PEAK_TYPE_COLUMN_AS_PARAM_NAME_COLUMN
 *	Folger 12/11/08 v8.0985 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL			*
 *	Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE		*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include <operation.h> /// Hong 01/29/08 QA80-10929 LT_NL_ALLOW_UPDATE_PARAMS_BY_DIALOG
#include "DialogEx.h"
///Kyle 09/05/08 
//#include "NLFitSession.h"
//#include "NLFitParaControl.h"
//#include "NLFitParaColControl.h" /// Hong 01/30/08 QA80-10929 MOVE_TO_SEPARATE_FILE_FOR_DERIVED_USE
#include "NLFitSession.h"
#include "GridTableControl.h"
#include "NLFitParaControl.h"
///End 
#include "ParameterDlg.h"

class NLFitParaDlg : public FitParaDlg
{
public:
	NLFitParaDlg():FitParaDlg()
	{
		m_strDlgName = "NLFit Parameter";
	}
	bool Update(bool bNewGrid = false);
	bool SetOperation(Operation* pOp); /// Hong 01/29/08 QA80-10929 LT_NL_ALLOW_UPDATE_PARAMS_BY_DIALOG
protected :	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	//ON_DESTROY(OnDestroy) /// Hong 01/29/08 QA80-10929 LT_NL_ALLOW_UPDATE_PARAMS_BY_DIALOG
	ON_READY(OnReady)
	ON_SIZE(OnDlgResize)
	ON_INIT_SIZE(OnInitSize)
	ON_RESTORESIZE(OnRestoreSize)
	
	ON_CHANGE_PAGE(OnActivePageChange)
	
	ON_BN_CLICKED(IDOK, OnClickOK)
	ON_BN_CLICKED(IDC_PF_AVANCED, OnAdvanced)
	ON_BN_CLICKED(IDC_PF_INIT, OnInitParamValue)
	ON_BN_CLICKED(IDC_PF_CHI_SQ, OnClickChiSQ)
	ON_BN_CLICKED(IDC_PF_SIMPLX, OnClickSimplex)
	ON_BN_CLICKED(IDC_PF_ONE_LTER, OnClickOneIter)
	ON_BN_CLICKED(IDC_PF_FIT, OnClickFit)	
	ON_BN_CLICKED(IDC_PF_QUICK_SET, OnQuickSetParam) 	///Jasmine 10/17/08 QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL
	ON_BN_CLICKED(IDC_PF_SORT_PEAKS, OnSortPeaks)		//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_MULTIPLE_PEAKS_IN_PA
	
	//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	ON_BN_CLICKED(IDC_PF_REORDER_PEAKS, OnReorderPeaks)
	//------
	
	ON_USER_MSG(WM_USER_SELECT_TOP_TAB, SelTopTab) ///Sophy 10/30/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	
	ON_TAB_SEL_CHANGE(IDC_PF_SETTING_TAB, OnTopTabChange)
	
	ON_BN_CLICKED(IDC_SHOW_BOTTOM, OnShowBottomPane)
	
	//------ Folger 12/11/08 v8.0985 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL
	//ON_GRID_BUTTON_CLICK(IDC_PF_PARA_GRID, OnGridButtonClick) 		///Kyle 09/08/08
	//------
	
	ON_GRID_BEFORE_EDIT(IDC_PF_PARA_GRID, OnBeforeEditParaControl)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_PF_PARA_GRID, OnBeforeMouseDownParaControl)
	ON_GRID_MOUSE_MOVE(IDC_PF_PARA_GRID, OnMouseMoveParaControl)
	ON_GRID_COMBO_CLOSEUP(IDC_PF_PARA_GRID, OnGridComboCloseUp)
	ON_GRID_AFTER_EDIT(IDC_PF_PARA_GRID, OnAfterEditParaControl) /// Hong 01/29/08 QA80-10929 LT_NL_ALLOW_UPDATE_PARAMS_BY_DIALOG
EVENTS_END

	//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	/// virtual
	BOOL	OnReady();
	//------
	
	// virtual
	BOOL OnClickSimplex(Control ctrl);	
	//virtual
	//BOOL OnDestroy(); /// Hong 01/29/08 QA80-10929 LT_NL_ALLOW_UPDATE_PARAMS_BY_DIALOG
	BOOL OnAdvanced(Control ctrl);
	BOOL OnInitParamValue(Control ctrl);
	void EnableFitButton(bool bEnable);
	///Sophy 12/4/2008 v8.0982b NOT_ALLOW_EDIT_PEAK_TYPE_COLUMN_AS_PARAM_NAME_COLUMN
	//virtual
	void OnBeforeEditParaControl(Control flxControl, long nRow, long nCol, BOOL* pCancel);
	///end NOT_ALLOW_EDIT_PEAK_TYPE_COLUMN_AS_PARAM_NAME_COLUMN
	void OnAfterEditParaControl(Control flxControl, int nRow, int nCol); /// Hong 01/29/08 QA80-10929 LT_NL_ALLOW_UPDATE_PARAMS_BY_DIALOG	
	// virtual
	bool IsShowPeakTypeCol(); /// Hong 02/01/08 8.0798 LT_NLFIT_PARA_NO_NEED_PEAK_TYPE_COLUMN
	// virtual
	BOOL	OnSortPeaks(Control ctrl);				//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_MULTIPLE_PEAKS_IN_PA
	
	//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	/// virtual
	BOOL	OnReorderPeaks(Control ctrl);
	//------

	// virtual
	bool updateParameters(bool bNewGrid = false, int* pnSetting = NULL); /// Hong 02/01/08 v8.0798 FIX_SHARE_COL_NOT_SHOW_WHEN_GLOBAL_FIT	///Jasmine 05/05/08 UPDATE_PEAK_LABEL_PLOT_AFTER_PEAK_CENTER_PARAM_CHANGE
private:	
	//virtual
	bool initParaGrid(int nID, Dialog& dlg, LPCSTR lpcszDlgName);
	void initButtons();
	int getButtonIDs(vector<uint>& vnButtonIDs);
	int getParameterGroups();
	/// Hong 02/01/08 v8.0798 FIX_REPLICA_FAIL_DISPLAY_IN_LT_NLFIT_PARA_DIALOG
	//virtual 	
	int getToltalNumParams();
	/// end FIX_REPLICA_FAIL_DISPLAY_IN_LT_NLFIT_PARA_DIALOG
	/// Hong 04/01/08 QA80-11357 FIX_CLICK_ITER_BTN_NOT_UPDATE_LT_TREE_REALTIME
	bool	updateFitWorkArea();	
	/// end FIX_CLICK_ITER_BTN_NOT_UPDATE_LT_TREE_REALTIME	
	
	//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	bool		IsReplicaFit()		{ return m_pNLFitSession->GetNumPeaks() > 1 ? true : false; }
	//------
	
private:
	Operation*			m_pOp; /// Hong 01/29/08 QA80-10929 LT_NL_ALLOW_UPDATE_PARAMS_BY_DIALOG	
};

/// Hong 01/29/08 QA80-10929 LT_NL_ALLOW_UPDATE_PARAMS_BY_DIALOG
// LT NL do NOT need this static pointer here, it contains such pointer itself
//static NLFitParaDlg* s_pNLParaDlg = NULL; 
/// end LT_NL_ALLOW_UPDATE_PARAMS_BY_DIALOG
	
//virtual
bool NLFitParaDlg::initParaGrid(int nID, Dialog& dlg, LPCSTR lpcszDlgName)
{
	if(NULL == m_pGridParas)
	{
		/// Hong 01/30/08 QA80-10929 MOVE_TO_SEPARATE_FILE_FOR_DERIVED_USE
		//m_pGridParas = new NLFitParamsControl;
		///Kyle 09/05/08
		//m_pGridParas = new NLFitParamsColControl;
		m_pGridParas = new NLFParamsControl;
		///End 
		/// end MOVE_TO_SEPARATE_FILE_FOR_DERIVED_USE
	}
	return FitParaDlg::initParaGrid(nID, dlg, lpcszDlgName);	
}
//virtual
void NLFitParaDlg::initButtons()
{
	vector<string> vsTips(8);
	vsTips[0] = _L("Apply to all parameters");	///Jasmine 10/17/08 QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL
	vsTips[1] = _L("Advanced Settings");
	vsTips[2] = _L("Initialize Parameters");
	vsTips[3] = _L("Calculate Chi-Square");
	vsTips[4] = _L("Simplex");
	vsTips[5] = _L("1 Iteration");
	vsTips[6] = _L("Fit");
	vsTips.Add( STR_SORT_PEAKS );
	vsTips.Add( STR_REORDER_PEAKS );
	vector<uint> vnBmpBtn = {IDC_PF_QUICK_SET, 	IDC_PF_AVANCED,	IDC_PF_INIT, 	IDC_PF_CHI_SQ, 	IDC_PF_SIMPLX, 		IDC_PF_ONE_LTER, 	IDC_PF_FIT,		IDC_PF_SORT_PEAKS,	IDC_PF_REORDER_PEAKS, 0};
	vector<uint> vnBmpIDs = {IDB_QUICK_SET, 	IDB_PF_ADV, 	IDB_NLF_INIT, 	IDB_NLF_CHISQ, 	IDB_NLF_SIMPLEX, 	IDB_NLF_ITER, 		IDB_NLF_FIT,	IDB_SORT_PEAKS, IDB_REORDER_PEAKS };

	for(int ii = 0; vnBmpBtn[ii]; ii++)
	{
		vector<string> vsTip;
		vsTip.Add(_L(vsTips[ii]));
		BitmapRadioButton btn = GetItem(vnBmpBtn[ii]);
		btn.Init(1, vnBmpIDs[ii], 16, vsTip);
	}
	GetItem(IDC_PF_AVANCED).Visible = m_bShowAdvBtn; /// Hong 01/30/08 QA80-10929 SHOULD_ONLY_ENABLE_WHEN_CONTAIN_ADVANCE_TREE
	GetItem(IDC_PF_QUICK_SET).Visible = FALSE;
}

//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
/// virtual
BOOL	NLFitParaDlg::OnReady()
{
	BOOL bRet = FitParaDlg::OnReady();
	EnablePeakSortingButton(IsReplicaFit());
	return bRet;
}
//------ End SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING

BOOL NLFitParaDlg::OnClickSimplex(Control ctrl)
{
	/// Hong 01/30/08 QA80-10929 IMPLEMENT_NLFIT_BUTTONS
	bool bEnable = fit(-1, FITMETH_SIMPLEX);
	EnableFitButton(bEnable);
	updateParameters();
	return TRUE;
	/// end IMPLEMENT_NLFIT_BUTTONS
}
/// Hong 01/29/08 QA80-10929 LT_NL_ALLOW_UPDATE_PARAMS_BY_DIALOG
/*
//virtual
BOOL NLFitParaDlg::OnDestroy()
{
	if(FitParaDlg::OnDestroy())
	{
		delete this;
		s_pNLParaDlg = NULL;
		return TRUE;
	}
	return FALSE;
}
*/
/// end LT_NL_ALLOW_UPDATE_PARAMS_BY_DIALOG
//virtual
int NLFitParaDlg::getButtonIDs(vector<uint>& vnButtonIDs)
{
	vector<uint> vnBottomGroup = { 	IDOK, IDC_GROUP_GAP, IDC_GROUP_GAP, IDC_GROUP_GAP, 
									IDC_PF_FIT, IDC_PF_ONE_LTER, IDC_PF_SIMPLX, IDC_PF_CHI_SQ, IDC_PF_INIT, 
									///Iris 10/24/2008 V8.0960 SET_QUICK_SET_BUTTON_PROPER_POSITION
									//IDC_GROUP_GAP, IDC_PF_AVANCED, IDC_PF_QUICK_SET
									IDC_PF_QUICK_SET, IDC_PF_SORT_PEAKS, IDC_PF_REORDER_PEAKS,
									///END SET_QUICK_SET_BUTTON_PROPER_POSITION
									0};///Jasmine 05/22/08 RESIZING_CODE_NEED_ZERO_TO_DETECT_THE_END
	vnButtonIDs = vnBottomGroup;
	///Jasmine 05/22/08 RESIZING_CODE_NEED_ZERO_TO_DETECT_THE_END
	int nSize = vnButtonIDs.GetSize();
	if(0 == vnButtonIDs[nSize-1])
		nSize--;
	return nSize;
	///End RESIZING_CODE_NEED_ZERO_TO_DETECT_THE_END
}
//virtual, show getn box of fit settings 
BOOL NLFitParaDlg::OnAdvanced(Control ctrl)
{
	if(!m_trAdvanced || !m_trAdvanced.FirstNode)
		return error_report("Fail to get advanced settings");
	//codes here
	return TRUE;
}
//virtual
BOOL NLFitParaDlg::OnInitParamValue(Control ctrl)
{
	bool bRet;
	
	/// Hong 01/30/08 QA80-10929 IMPLEMENT_NLFIT_BUTTONS
	if(NULL == m_pNLFitSession)
		return false;
	bRet = m_pNLFitSession->ParamsInitValues();	
	/// end IMPLEMENT_NLFIT_BUTTONS
	if(bRet)
	{
		updateParameters();
		bool bEnable = true;
		EnableFitButton(bEnable);
		return TRUE;
	}
	return FALSE;
}
//virtual 
bool NLFitParaDlg::Update(bool bNewGrid)// = false	
{	
	if(IsInitReady())
		Visible = true;
	//m_trAdvanced.Replace(trAdvanced.Clone()); 
	UpdateFitSession();	
	
	updateParameters(bNewGrid);
		
	return true;
}

/// Hong 02/01/08 v8.0798 FIX_SHARE_COL_NOT_SHOW_WHEN_GLOBAL_FIT
//virtual 
bool NLFitParaDlg::updateParameters(bool bNewGrid, int* pnSetting)// = false, NULL
{
	if ( FitParaDlg::updateParameters(bNewGrid) )
	{
		updateFitWorkArea(); /// Hong 04/01/08 QA80-11357 FIX_CLICK_ITER_BTN_NOT_UPDATE_LT_TREE_REALTIME
		return true;
	}
	return false;
}
/// end FIX_SHARE_COL_NOT_SHOW_WHEN_GLOBAL_FIT

/// Hong 02/01/08 v8.0798 FIX_REPLICA_FAIL_DISPLAY_IN_LT_NLFIT_PARA_DIALOG
// virtual
int NLFitParaDlg::getToltalNumParams()
{
	if ( !m_pNLFitSession )
		return 0;
	
	return m_pNLFitSession->GetNumTotalParams();
}
/// end FIX_REPLICA_FAIL_DISPLAY_IN_LT_NLFIT_PARA_DIALOG

/// Hong 04/01/08 QA80-11357 FIX_CLICK_ITER_BTN_NOT_UPDATE_LT_TREE_REALTIME
bool	NLFitParaDlg::updateFitWorkArea()
{
	if ( m_pOp && m_pNLFitSession )
	{ // update FitWorkArea realtime
		Tree trOp;
		m_pOp->GetTree(trOp);
		if ( m_pNLFitSession->ParamsToOperation(trOp) )
		{
			m_pOp->SetTree(trOp);
			return true;
		}
	}
	return false;
}
/// end FIX_CLICK_ITER_BTN_NOT_UPDATE_LT_TREE_REALTIME

/// Hong 01/29/08 QA80-10929 LT_NL_ALLOW_UPDATE_PARAMS_BY_DIALOG
bool NLFitParaDlg::SetOperation(Operation* pOp)
{
	if ( m_pOp )
		return true;
	
	if ( !pOp )
		return error_report("pOp is NULL");
	
	m_pOp = pOp;
	return true;
}

// virtual
void NLFitParaDlg::OnAfterEditParaControl(Control flxControl, int nRow, int nCol)
{
	FitParaDlg::OnAfterEditParaControl(flxControl, nRow, nCol);
	/// Hong 04/01/08 QA80-11357 FIX_CLICK_ITER_BTN_NOT_UPDATE_LT_TREE_REALTIME
	/*
	if ( m_pOp && m_pNLFitSession )
	{ // update FitWorkArea realtime
		Tree trOp;
		m_pOp->GetTree(trOp);
		if ( m_pNLFitSession->ParamsToOperation(trOp) )
			m_pOp->SetTree(trOp);
	}
	*/	
	updateFitWorkArea();
	/// end FIX_CLICK_ITER_BTN_NOT_UPDATE_LT_TREE_REALTIME
}
/// end LT_NL_ALLOW_UPDATE_PARAMS_BY_DIALOG

//virtual
int NLFitParaDlg::getParameterGroups()
{
	return m_pNLFitSession->GetNumDataset();
}
//virtual
void NLFitParaDlg::EnableFitButton(bool bEnable)
{
	GetItem(IDC_PF_ONE_LTER).Enable = bEnable;
	GetItem(IDC_PF_FIT).Enable = bEnable;
}

///Sophy 12/4/2008 v8.0982b NOT_ALLOW_EDIT_PEAK_TYPE_COLUMN_AS_PARAM_NAME_COLUMN
//virtual
void NLFitParaDlg::OnBeforeEditParaControl(Control flxControl, long nRow, long nCol, BOOL* pCancel)
{
	/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	int nColType = m_pGridParas->GetColType(nCol);
#else // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	int nColType = nCol;
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE

	if( NLPARAMGRIDCOLTYPE_FUNC_NAME == nColType && NULL != pCancel )
	{
		*pCancel = true;
		return;
	}
	FitParaDlg::OnBeforeEditParaControl(flxControl, nRow, nCol, pCancel);
}
///end NOT_ALLOW_EDIT_PEAK_TYPE_COLUMN_AS_PARAM_NAME_COLUMN

/// Hong 02/01/08 8.0798 LT_NLFIT_PARA_NO_NEED_PEAK_TYPE_COLUMN
// virtual
bool NLFitParaDlg::IsShowPeakTypeCol()
{
	return false;
}
/// end LT_NLFIT_PARA_NO_NEED_PEAK_TYPE_COLUMN
//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_MULTIPLE_PEAKS_IN_PA
BOOL	NLFitParaDlg::OnSortPeaks(Control ctrl)
{
	int		nUpdateParts = m_pGridParas->OnSortPeaks();
	
	if ( nUpdateParts > 0 )
	{
		//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
		//if ( nUpdateParts & NLDLGPART_FIT_CONTROL_BTNS )
			//EnableFitButton(true);
		EnablePeakReorderingButton(true);
		//------ End SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	}
	
	return true;
}
//------ End SUPPORT_SORT_MULTIPLE_PEAKS_IN_PA

//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
/// virtual
BOOL	NLFitParaDlg::OnReorderPeaks(Control ctrl)
{
	vector<uint>	vnIndices;
	int		nUpdateParts = m_pGridParas->OnReorderPeaks(&vnIndices);
	
	if ( nUpdateParts > 0 )
	{
		if ( nUpdateParts & NLDLGPART_FIT_CONTROL_BTNS )
			EnableFitButton(true);
				
		EnablePeakReorderingButton(false);
	}
	
	return TRUE;
}
//------ End SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING

/// Hong 01/29/08 QA80-10929 LT_NL_ALLOW_UPDATE_PARAMS_BY_DIALOG
/*
bool NLParameterDlg(int nMsg, TreeNode& trSetting = NULL, NLFitSession* pFitSession = NULL)
{	
	bool bClose = OMSG_CLOSE==nMsg? true:false;
	bool bUpdate = OMSG_UPDATE==nMsg? true:false;

	if(bClose)
	{
		if(s_pNLParaDlg)
		{
			Window winDlg = s_pNLParaDlg->GetWindow();
			if(winDlg)
				winDlg.SendMessage(WM_CLOSE);
			delete s_pNLParaDlg;
			s_pNLParaDlg = NULL;
		}
		return true;
	}
	// open or update
	if(!s_pNLParaDlg)
	{
		if(bUpdate)
			return false;// not possible to update, since dialog not opened

		s_pNLParaDlg = new NLFitParaDlg;
		s_pNLParaDlg->Create(GetWindow());
		s_pNLParaDlg->SetFitSession(pFitSession);
		s_pNLParaDlg->SetAdvTree(trSetting);
	}
	if(bUpdate)
		s_pNLParaDlg->Update();
	
	return true;
}
*/
/// end LT_NL_ALLOW_UPDATE_PARAMS_BY_DIALOG
