/*------------------------------------------------------------------------------*
 * File Name: NLFit_utils.h	 													*
 * Creation: Sim 01-10-2007														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
// no added
/*
#define STR_NLFOPT_KEYNAME_X					"x"
#define STR_NLFOPT_KEYNAME_Y					"y"
#define STR_NLFOPT_KEYNAME_W					"w"
*/
static bool _set_nlsf_LT_tree_value(const TreeNode &trCalculation, TreeNode &trLT, LPCSTR lpcszVarName, int nIndex)
{
	string strVarName = lpcszVarName;
	if ( nIndex > 0 )
		strVarName += nIndex;
	
	string strVal;
	if ( 0 == okutil_operation_tree_access_string(&trCalculation, strVarName, &strVal) )
	{
		TreeNode tr = trLT.AddTextNode(strVal, strVarName);
		if ( tr )
			return true;
	}
	return false;
}

static void _set_nlsf_LT_tree_params_value(const TreeNode &trCalculation, TreeNode &trLT, int nIndex)
{
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_VALUE, 			nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_SHARED,	 		nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_FIX,		 		nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_ERROR,			nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_T_VALUE,			nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_PROB,			nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_LCL, 			nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_UCL,				nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_DEPENDENCY,		nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_CONF_INTERVAL,	nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_LB,	 			nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_UB,				nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_NAME1,			nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_NAME2,			nIndex);
}
static void _set_nlsf_LT_tree_stats_value(const TreeNode &trCalculation, TreeNode &trLT, int nIndex)
{
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_NPOINTS,			nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_DOF,				nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_REDUCED_CHI_SQ,	nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_SSR,				nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_R_VALUE1,		nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_R_VALUE2,		nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_R_SQ_COD,		nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_ADJ_R_SQ,		nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_RMSE,			nIndex);
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_NUM_ITER,		nIndex);
}
static void _set_nlsf_LT_tree_notes_value(const TreeNode &trCalculation, TreeNode &trLT, int nIndex)
{
	_set_nlsf_LT_tree_value(trCalculation, trLT, STR_NLFOPT_KEYNAME_MODEL,			nIndex);
}
bool nlsf_report_sheet_to_LT_tree(const TreeNode &trReport, TreeNode &trLT)
{
	if(!trReport)
		return false;
	
	//TreeNode trCalculation = trReport.Calculation;
	TreeNode trCalculation = trReport;
	if(!trCalculation )
		return false;
	
	int nIndex;
	string strVal;
	string strVarName;
	
	int nNumParams = okutil_get_operation_tree_number(&trCalculation, NLFIT_RT_PARAMS);
	int nNumDatasets = okutil_get_operation_tree_number(&trCalculation, NLFIT_RT_DATASETS);
	
	for ( nIndex = 1; nIndex <= nNumParams*nNumDatasets; nIndex++ )
	{
		//if ( 1 == nIndex )
			//_set_nlsf_LT_tree_params_value(trCalculation, trLT, -1); // variable name without name at the end
		_set_nlsf_LT_tree_params_value(trCalculation, trLT, nIndex);
	}
		
	int nNumStats = okutil_get_operation_tree_number(&trCalculation, NLFIT_RT_STATS);
	for ( nIndex = 1; nIndex <= nNumStats; nIndex++ )
	{
		//if ( 1 == nIndex )
			//_set_nlsf_LT_tree_stats_value(trCalculation, trLT, -1); // variable name without name at the end
		_set_nlsf_LT_tree_stats_value(trCalculation, trLT, nIndex);
	}
	
	int nNumNotes = 1; // not by index, only has one.
	for ( nIndex = 1; nIndex <= nNumNotes; nIndex++ )
	{
		//if ( 1 == nIndex )
			//_set_nlsf_LT_tree_notes_value(trCalculation, trLT, -1); // variable name without name at the end
		_set_nlsf_LT_tree_notes_value(trCalculation, trLT, nIndex);
	}
	
	return true;
}
