/*------------------------------------------------------------------------------*
 * File Name: NLFitSelFunction.h												*
 * Creation: CPY 08/13/2004													    *
 * Purpose: NLFit Function Selections				 							*
 * Copyright (c) OriginLab Corp.2004, 2005										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 10/12/04 QA70-4387 NLF_FUNC_CATEGORY_CENTRALIZED_CODES, creation		*
 *  DG 12/27/04 v8.0179 ACCESS_FUNCTION_BY_NFO									*
 *  DG 3/24/05 v8.0210 EMPTY_CATEGORY_EMPTY_SHOWN								*
 *	ML 11/7/2005 QA70-8135 SURFACE_FITTING_VIA_XFUNC_NEW_WAY					*
 *	Frank 11/11/05 REMOVE_XF_FROM_FO_TREE										*
 *	Jasmine 03/13/06 v8.0374 REPLACE_VECTOR_POINTER_WITH_VECTOR					*
 *	Cheney 2006-10-19 FIX_PFM_BUG												*
 *	Cheney 2006-10-23 CATEGORY_SHOULD_BE_DISABLE_WHEN_SURFACE_FITTING			*
 *	Jasmine 01/27/07 SHOW_FUNC_DESCRIPTION_INSTEAD_OF_FDF_PATH					*
 *	DEV80OP_COMPILE_CRASH_WITH_FOParamSetting									*
 *	Cheney 2007-4-24 CLEAN_UP_FDF_TREE_LOAD										*
 *	Cheney 2007-5-5 FUNC_DESCRIPTION_NOT_WORK									*
 *	Jasmine 05/18/07 ADD_NEW_AT_LIST_BOTTOM_TO_OPEN_FO							*
 *	Jasmine 05/29/07 ONLY_SHOW_SPECIFIED_CATEGORY_FOR_SPECIAL_FIT				*
 *	Jasmine 08/22/07 CATEGORY_FOR_SPFM_FIT										*
 *	Arvin 09/18/07 QA70-10356 PFM_SHOULD_USE_NLFIT_FDF_AND_ORIGINAL_LOGIC_WRONG	*
 *	Folger 11/09/07 COMBO_TEXT_NO_NEEDED_LOCALIZE								*
 *	Folger 12/12/07 REMOVE_PFW_FROM_NLFIT_CATEGORY_LIST							*
 *	Folger 12/14/07 NEED_TO_JUDGE_CALL_FROM_NLFIT_OR_SIMCURVE					*
 *	Folger 12/14/07 CENTRALIZED_CODE_OF_HIDING_RESERVE_CATEGORIES				*
 *	Hong 10/24/08 v8.0960b FIX_NEW_NLFIT_FUNCTION_LIST_LOST_ITEM_NEW_DOT_DOT_DOT*
 *	Folger 01/21/09 FUNCTION_NAME_COMES_FROM_NLFLT_FAILS_TO_MATCH_COMBO_STRINGS	*
 *	Folger 11/05/09 QA81-14595-P1 NLFIT_SHOULD_NOT_LOAD_GAUSS_WHEN_DO_ANALYSIS_WITH_THEME_WHICH_HAS_NO_FUNCTION
 *	Hong 01/25/10 QA80-15026 NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY			*
 *	Hong 03/03/10 QA80-15156 FIX_NLFIT_FROM_QUICK_FIT_FAIL_LOAD_GAUSS_IF_REMOVE_IT_FROM_QUICKFIT_CATEGORY
 *	Kit 01/28/2011 ORG-2120-S2 USE_CHANGE_PARAM_OPEN_NLFIT_SHOULD_ACTIVE_SETTING_TAB
 *	Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
 *	Zech 09/27/2011 ORG-3577-S1 ADD_BACK_ITEM_FOR_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION_TO_NLFIT_DROPDOWN_LIST
 *	Philip 08/22/2012 ORG-6527-S3 DISABLE_CATEGORY_DROPDOWN_WHEN_USE_NL_IMPLICIT_CURVE_FIT
 *	Philip 08/22/2012 ORG-6527-S2 HIDE_IMPLICIT_CATEGORY_WHEN_USE_NL_CURVE_FIT	*
 *	Philip 08/22/2012 ORG-6527-S1 TEMPORARILY_DISABLE_ODR_ALGORITHM_IN_NLFIT_DIALOG
 *	Philip 09/07/2012 ORG-6527-P1 FITMETHOD_BOX_APPEAR_IN_SIMCURVE_DLG			*
 *------------------------------------------------------------------------------*/

#ifndef _NLFIT_SEL_FUNCTION_H
#define _NLFIT_SEL_FUNCTION_H

//#include "FunctionOrganizer.h" ///DG ACCESS_FUNCTION_BY_NFO
//----- CPY 3/1/2007 DEV80OP_COMPILE_CRASH_WITH_FOParamSetting
//should not add basic include in other header
//#include "DialogEx.h"	///Joseph 01/29/07	ADD_OPERATION_ERRMSG_LINE
#include <GetNBox.h>
//----- end DEV80OP_COMPILE_CRASH_WITH_FOParamSetting
//#define		STR_CATE_NAME_PFM				"PFM"
#define		STR_CATE_NAME_PFM				"PFW"   ///Sandy 2007-11-9 rename
#define		STR_CATE_NAME_SPFM				"Nanosizer"//"SPFM"	///Jasmine 08/22/07 CATEGORY_FOR_SPFM_FIT
///Arvin 09/18/07 QA70-10356 PFM_SHOULD_USE_NLFIT_FDF_AND_ORIGINAL_LOGIC_WRONG
#define STR_OFFSET_PARAM_NAME_PFM				"y0"
#define	STR_OFFSET_PARAM_NAME_SPFM				"z0"
///END 	PFM_SHOULD_USE_NLFIT_FDF_AND_ORIGINAL_LOGIC_WRONG

#define		STR_FUNC_NAME_MIXED_TYPE		"Mixed Type"
///Cheney 2006-10-23 CATEGORY_SHOULD_BE_DISABLE_WHEN_SURFACE_FITTING
#define		STR_CATE_NAME_SURFACE_FITTING	"Surface Fitting"

//------ Folger 12/14/07 CENTRALIZED_CODE_OF_HIDING_RESERVE_CATEGORIES
#define		STR_CATE_NAME_BASELINE			"Baseline"

#define		STR_CATE_RESERVE				((string)STR_CATE_NAME_SURFACE_FITTING + '|' + STR_CATE_NAME_PFM + '|' + STR_CATE_NAME_SPFM + '|' + STR_CATE_NAME_BASELINE)
/// Iris 7/03/2012 ORG-6109-S1 TO_REMOVE_IMPLICIT_CATE_FROM_FO_FOR_REGULAR_VER
#define     STR_CATE_NAME_IMPLICIT			"Implicit"
///End TO_REMOVE_IMPLICIT_CATE_FROM_FO_FOR_REGULAR_VER

enum
{
	FO_SHOW_ALL_CATEGORIES,
	FO_SHOW_ONE_CATEGORY,
	FO_REMOVE_RESERVE_CATEGORIES,	
};

//------

/// Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
// The enumeration below is moved from FitFuncWiz.h
enum{
	FFW_MODE_AUTO			= 0x0000, //should be detecteed by input trFDF tree.
	FFW_CREATE_FUNC 		= 0x0001,
	FFW_EDIT_BUILTIN_FUNC	= 0x0002,
	FFW_EDIT_USER_FUNC		= 0x0003,
	FFW_CREATE_OR_EDIT		= 0x0004,
	FFW_MODE_MASK			= 0x00FF,
	FFW_OPTION_MASK			= 0xFF00,
	FFW_OPT_CREATE_NEW		= 0x0100,
};
/// END OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION

///end CATEGORY_SHOULD_BE_DISABLE_WHEN_SURFACE_FITTING
#define		STR_FILTER_ATTRIB				"Filter"	///Jasmine 05/29/07 ONLY_SHOW_SPECIFIED_CATEGORY_FOR_SPECIAL_FIT,  save filte in attribute

class NLFitSelFunction : public NLFunctionList
{
public:
	///------ Folger 11/05/09 QA81-14595-P1 NLFIT_SHOULD_NOT_LOAD_GAUSS_WHEN_DO_ANALYSIS_WITH_THEME_WHICH_HAS_NO_FUNCTION
	//NLFitSelFunction() {}
	NLFitSelFunction()
	{
		onInitMembers();
	}
	///------ End NLFIT_SHOULD_NOT_LOAD_GAUSS_WHEN_DO_ANALYSIS_WITH_THEME_WHICH_HAS_NO_FUNCTION
	
	NLFitSelFunction(TreeNode& trFuncSel)
	{
		m_trFuncSel = trFuncSel;
		///------ Folger 11/05/09 QA81-14595-P1 NLFIT_SHOULD_NOT_LOAD_GAUSS_WHEN_DO_ANALYSIS_WITH_THEME_WHICH_HAS_NO_FUNCTION
		onInitMembers();
		///------ End NLFIT_SHOULD_NOT_LOAD_GAUSS_WHEN_DO_ANALYSIS_WITH_THEME_WHICH_HAS_NO_FUNCTION
		///------ Folger 08/29/2012 ORG-5772-P1 SIMULATE_CURVES_FOR_IMPLICIT_FUNCTION
		// ///Philip 08/22/2012 ORG-6527-S3 DISABLE_CATEGORY_DROPDOWN_WHEN_USE_NL_IMPLICIT_CURVE_FIT
		// m_bIsODRFit = isODRFit(trFuncSel);
		// ///end DISABLE_CATEGORY_DROPDOWN_WHEN_USE_NL_IMPLICIT_CURVE_FIT
		///------ End SIMULATE_CURVES_FOR_IMPLICIT_FUNCTION
	}
	bool IsValid()
	{
		if(m_trFuncSel)
			return true;
		else
			return false;
	}

	///------ Folger 11/05/09 QA81-14595-P1 NLFIT_SHOULD_NOT_LOAD_GAUSS_WHEN_DO_ANALYSIS_WITH_THEME_WHICH_HAS_NO_FUNCTION
	void	SetInitFromNLFit(BOOL bOn)
	{
		m_bInitFromNLFit = bOn;
	}
	BOOL	IsInitFromNLFit()
	{
		return m_bInitFromNLFit;
	}
	///------ End NLFIT_SHOULD_NOT_LOAD_GAUSS_WHEN_DO_ANALYSIS_WITH_THEME_WHICH_HAS_NO_FUNCTION
	// CPY 10/19/04, this is not good, it promotes double-storage
	/*
	//use in class
	bool SetTree(TreeNode& trFuncSel, bool bUpdateComboList = true)
	{
		m_trFuncSel = trFuncSel;
		if(bUpdateComboList)
		{
			string strCate;
			return Init(strCate);
		}
		return true;
	}
	*/
	// strDefaultCategory = empty to allow internal default
	/// Iris 6/24/05 SEPARATE_NLSF_MENU_FOR_2D_3D_FUNC
	//bool Init(string strDefaultCategory, LPCSTR lpcszFunc = NULL, vector<string>* pFilterList = NULL)
	//bool Init(string strDefaultCategory, LPCSTR lpcszFunc = NULL, vector<string>* pFilterList = NULL, vector<string>* pCateFilterList = NULL)///Jasmine 03/13/06 REPLACE_VECTOR_POINTER_WITH_VECTOR, the pointer leads to strange crash
	//bool Init(string strDefaultCategory, LPCSTR lpcszFunc = NULL, vector<string>& vsFilterList = NULL, vector<string>& vsCateFilterList = NULL) /// Iris 9/19/06 v8.0483 CLEANUP_SEPARATE_PFM_CODES
	//------ Folger 12/14/07 NEED_TO_JUDGE_CALL_FROM_NLFIT_OR_SIMCURVE
	//bool Init(string strDefaultCategory, LPCSTR lpcszFunc = NULL, vector<string>& vsFilterList = NULL, vector<string>& vsCateFilterList = NULL, bool bCheckDefaultCategroy = true, bool bAddNew = true)	///Jasmine 05/18/07 ADD_NEW_AT_LIST_BOTTOM_TO_OPEN_FO
	///Sophy 6/2/2010 ORG-2 NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	//bool Init(string strDefaultCategory, LPCSTR lpcszFunc = NULL, vector<string>& vsFilterList = NULL, vector<string>& vsCateFilterList = NULL, bool bCheckDefaultCategroy = true, bool bAddNew = true, bool bFromNLFit = true)
	/// Zech 09/27/2011 ORG-3577-S1 ADD_BACK_ITEM_FOR_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION_TO_NLFIT_DROPDOWN_LIST
	//bool Init(string strDefaultCategory, LPCSTR lpcszFunc = NULL, vector<string>& vsFilterList = NULL, vector<string>& vsCateFilterList = NULL, bool bCheckDefaultCategroy = true, bool bAddNew = false, bool bFromNLFit = true)
	bool Init(string strDefaultCategory, LPCSTR lpcszFunc = NULL, vector<string>& vsFilterList = NULL, vector<string>& vsCateFilterList = NULL, bool bCheckDefaultCategroy = true, bool bAddNew = true, bool bFromNLFit = true)
	/// END ADD_BACK_ITEM_FOR_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION_TO_NLFIT_DROPDOWN_LIST
	///end NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	//------
	{
		string strCateList;
		Tree tr;
		vector<string> vsCategorys;
		//if(GetCategoryList(tr, false))
		GetCategoryList(tr, false);
		
		///------Frank 11/11/05 REMOVE_XF_FROM_FO_TREE
		///Temp, current just remove the top level node.
		//TreeNode trCategorys=tr.GetNode(STR_FIT_FUNCTION_NODE);	///DG 4/4/05 base class changed
		TreeNode trCategorys=tr;
		///------End REMOVE_XF_FROM_FO_TREE
		if(trCategorys)
		{
			tree_get_attributes(trCategorys, vsCategorys, STR_LABEL_ATTRIB, true);			
			/// ML 11/7/2005 QA70-8135 SURFACE_FITTING_VIA_XFUNC_NEW_WAY
			///// Iris 6/24/05 SEPARATE_NLSF_MENU_FOR_2D_3D_FUNC
			//if(pCateFilterList && pCateFilterList->GetSize() > 0)
			//	remove_if_in_list(vsCategorys, *pCateFilterList);
			/////end SEPARATE_NLSF_MENU_FOR_2D_3D_FUNC
			//
			// I don't understand why in the filter above Iris calls remove_if_in_list() for
			// categories. The function updateFuncSelection() for function filtering calls (called below)
			// calls remove_if_not_in_list(), so it seems logical that the categories filter
			// should behave the same, i.e. pCateFilterList contains those that
			// should be INcluded, not excluded.
			///Jasmine 03/13/06 REPLACE_VECTOR_POINTER_WITH_VECTOR
			//if(pCateFilterList && pCateFilterList->GetSize() > 0)
				//remove_if_not_in_list(vsCategorys, *pCateFilterList);
				
			///Jasmine 05/29/07 ONLY_SHOW_SPECIFIED_CATEGORY_FOR_SPECIAL_FIT,  save filte in attribute
			string strFilter;
			if(vsCateFilterList && vsCateFilterList.GetSize() > 0)
			{
				strFilter.Empty();
				strFilter.SetTokens(vsCateFilterList, '|');
				m_trFuncSel.CategoryList.SetAttribute(STR_FILTER_ATTRIB, strFilter);
			}
			if(vsFilterList && vsFilterList.GetSize() > 0)
			{
				strFilter.Empty();
				strFilter.SetTokens(vsFilterList, '|');
				m_trFuncSel.FunctionList.SetAttribute(STR_FILTER_ATTRIB, strFilter);
			}			
			vector<string> vsFilter, vsCateFilter;
			strFilter.Empty();
			m_trFuncSel.CategoryList.GetAttribute(STR_FILTER_ATTRIB, strFilter);
			strFilter.GetTokens(vsCateFilter, '|');
			strFilter.Empty();
			m_trFuncSel.FunctionList.GetAttribute(STR_FILTER_ATTRIB, strFilter);
			strFilter.GetTokens(vsFilter, '|');			
			
			//if(NULL != vsCateFilter && vsCateFilter.GetSize() > 0)
			if(vsCateFilter.GetSize() > 0)
				remove_if_not_in_list(vsCategorys, vsCateFilter);
			///End ONLY_SHOW_SPECIFIED_CATEGORY_FOR_SPECIAL_FIT 
			///End REPLACE_VECTOR_POINTER_WITH_VECTOR
			else
			{
				vector<string>	vsCatsRemove;
				// By default this category should be removed (like for general Curve Fitting):
				//------ Folger 12/14/07 CENTRALIZED_CODE_OF_HIDING_RESERVE_CATEGORIES
				//vsCatsRemove.Add("Surface Fitting");
				//if (bFromNLFit)		//------ Folger 12/14/07 NEED_TO_JUDGE_CALL_FROM_NLFIT_OR_SIMCURVE
					//vsCatsRemove.Add(STR_CATE_NAME_PFM);	//------ Folger 12/12/07 REMOVE_PFW_FROM_NLFIT_CATEGORY_LIST
				if (bFromNLFit || !is_pro_version())
				{
					string strCateReserve = STR_CATE_RESERVE;
					strCateReserve.GetTokens(vsCatsRemove, '|');
					
					/// Iris 7/03/2012 ORG-6109-S1 TO_REMOVE_IMPLICIT_CATE_FROM_FO_FOR_REGULAR_VER
					///------ Folger 08/29/2012 ORG-5772-P1 SIMULATE_CURVES_FOR_IMPLICIT_FUNCTION
					//if( !is_pro_version() ) /// see ORG-6527-S2
					///------ End SIMULATE_CURVES_FOR_IMPLICIT_FUNCTION
					{
						vsCatsRemove.Add(STR_CATE_NAME_IMPLICIT);
					}
					///End TO_REMOVE_IMPLICIT_CATE_FROM_FO_FOR_REGULAR_VER
				}
				else
					vsCatsRemove.Add(STR_CATE_NAME_SURFACE_FITTING);
				//------
				remove_if_in_list(vsCategorys, vsCatsRemove);
			}
			/// end SURFACE_FITTING_VIA_XFUNC_NEW_WAY
			
			///Philip 08/22/2012 ORG-6527-S3 DISABLE_CATEGORY_DROPDOWN_WHEN_USE_NL_IMPLICIT_CURVE_FIT
			///// Iris 12/02/06 QA70-8757-P1 v8.0518 CORRECT_CATE_FUNC_OPTIONS
			////m_trFuncSel.CategoryList.Enable = (0 == strDefaultCategory.Compare(STR_CATE_NAME_PFM)
			////		|| 0 == strDefaultCategory.Compare(STR_CATE_NAME_SURFACE_FITTING) ) ? false : true;
			//m_trFuncSel.CategoryList.Enable = vsCategorys.GetSize() > 1 ? true : false;
			/////end CORRECT_CATE_FUNC_OPTIONS
			///------ Folger 08/29/2012 ORG-5772-P1 SIMULATE_CURVES_FOR_IMPLICIT_FUNCTION
			// m_trFuncSel.CategoryList.Enable = (vsCategorys.GetSize() > 1
			// 								   && !(m_bIsODRFit && 0 == strDefaultCategory.CompareNoCase(STR_CATE_NAME_IMPLICIT))
			// 								  );
			m_trFuncSel.CategoryList.Enable = vsCategorys.GetSize() > 1;
			///------ End SIMULATE_CURVES_FOR_IMPLICIT_FUNCTION
			///end DISABLE_CATEGORY_DROPDOWN_WHEN_USE_NL_IMPLICIT_CURVE_FIT
			
			///------ Folger 08/29/2012 ORG-5772-P1 SIMULATE_CURVES_FOR_IMPLICIT_FUNCTION
			// ///Philip 08/22/2012 ORG-6527-S2 HIDE_IMPLICIT_CATEGORY_WHEN_USE_NL_CURVE_FIT
			// if(!m_bIsODRFit)
			// {
			// 	int index = vsCategorys.Find(STR_CATE_NAME_IMPLICIT);
			// 	if(-1 != index)
			// 		vsCategorys.RemoveAt(index);
			// }
			// ///end HIDE_IMPLICIT_CATEGORY_WHEN_USE_NL_CURVE_FIT
			///------ End SIMULATE_CURVES_FOR_IMPLICIT_FUNCTION
			
			///Philip 08/22/2012 ORG-6527-S1 TEMPORARILY_DISABLE_ODR_ALGORITHM_IN_NLFIT_DIALOG
			if(m_trFuncSel.FitMethod) ///Philip 09/07/2012 ORG-6527-P1 FITMETHOD_BOX_APPEAR_IN_SIMCURVE_DLG
				m_trFuncSel.FitMethod.Enable = false;
			///end TEMPORARILY_DISABLE_ODR_ALGORITHM_IN_NLFIT_DIALOG
			
			///Jasmine 05/18/07 ADD_NEW_AT_LIST_BOTTOM_TO_OPEN_FO
			/// Hong 10/24/08 v8.0960b FIX_NEW_NLFIT_FUNCTION_LIST_LOST_ITEM_NEW_DOT_DOT_DOT
			//if(bAddNew && true == m_trFuncSel.CategoryList.Enable && 0 > vsCategorys.Find(STR_NEW_DOT_DOT_DOT))
			if(bAddNew && tree_is_editable(m_trFuncSel.CategoryList) && 0 > vsCategorys.Find(STR_NEW_DOT_DOT_DOT))
			/// end FIX_NEW_NLFIT_FUNCTION_LIST_LOST_ITEM_NEW_DOT_DOT_DOT
				vsCategorys.Add(STR_NEW_DOT_DOT_DOT);
			///End ADD_NEW_AT_LIST_BOTTOM_TO_OPEN_FO
			
			strCateList.SetTokens(vsCategorys, '|');	//..
			if( strDefaultCategory.IsEmpty() || ( !is_in_list(strDefaultCategory, vsCategorys) && bCheckDefaultCategroy) || 0 == strDefaultCategory.CompareNoCase(STR_NEW_DOT_DOT_DOT))	///Jasmine 10/08/07 UPDATE_NLFIT_DB_FUNCTION_LIST
				strDefaultCategory=vsCategorys[0];

			m_trFuncSel.CategoryList.SetAttribute(STR_COMBO_ATTRIB, strCateList);
			m_trFuncSel.CategoryList.strVal = strDefaultCategory;
			m_trFuncSel.CategoryList.SetAttribute(STR_OCNTRL_OPTNS, OCNTRLPARAM1_NOT_LOCALIZED);		//------ Folger 11/09/07 COMBO_TEXT_NO_NEEDED_LOCALIZE
			
			//updateFuncSelection(strDefaultCategory, lpcszFunc, pFilterList);///Jasmine 03/13/06 REPLACE_VECTOR_POINTER_WITH_VECTOR
			/// Hong 03/03/10 QA80-15156 FIX_NLFIT_FROM_QUICK_FIT_FAIL_LOAD_GAUSS_IF_REMOVE_IT_FROM_QUICKFIT_CATEGORY
			//updateFuncSelection(strDefaultCategory, lpcszFunc, vsFilter, bAddNew);
			if ( updateFuncSelection(strDefaultCategory, lpcszFunc, vsFilter, bAddNew, true, vsCategorys) )
				m_trFuncSel.CategoryList.strVal = strDefaultCategory;;
			/// end FIX_NLFIT_FROM_QUICK_FIT_FAIL_LOAD_GAUSS_IF_REMOVE_IT_FROM_QUICKFIT_CATEGORY
			///Cheney 2006-10-19 FIX_PFM_BUG, if PFM, user should not be able to change function in dlg
			m_trFuncSel.FunctionList.Enable = 0 == strDefaultCategory.Compare(STR_CATE_NAME_PFM) ? false : true;
			///end FIX_PFM_BUG
			return true;
		}
		return false;
	}
	bool GetCategoryAndFunction(string& strCategory, string& strFunction)
	{
		strCategory.Empty();
		strFunction.Empty();
		if(!IsValid())
			return false;

		if(m_trFuncSel.FunctionList)
			strFunction = m_trFuncSel.FunctionList.strVal;
		if(strFunction.IsEmpty())
			return false;
		if(m_trFuncSel.CategoryList)
			strCategory = m_trFuncSel.CategoryList.strVal;
		
		return true;
	}
	/// Zech 09/27/2011 ORG-3577-S1 ADD_BACK_ITEM_FOR_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION_TO_NLFIT_DROPDOWN_LIST
	/*
	///Sophy 6/2/2010 ORG-2 NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	//void OnChangeCategoryUpdateFunctionList(bool bAddNew = true)///Jasmine 05/18/07 ADD_NEW_AT_LIST_BOTTOM_TO_OPEN_FO
	void OnChangeCategoryUpdateFunctionList(bool bAddNew = false)///Jasmine 05/18/07 ADD_NEW_AT_LIST_BOTTOM_TO_OPEN_FO
	///end NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	*/
	void OnChangeCategoryUpdateFunctionList(bool bAddNew = true)
	/// END ADD_BACK_ITEM_FOR_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION_TO_NLFIT_DROPDOWN_LIST
	
	{
		if(!IsValid())
			return;
		string strCate = m_trFuncSel.CategoryList.strVal;
		string strFunc = m_trFuncSel.FunctionList.strVal;
		updateFuncSelection(strCate, strFunc, NULL, bAddNew);///Jasmine 05/18/07 ADD_NEW_AT_LIST_BOTTOM_TO_OPEN_FO
	}
	///Jasmine 01/27/07 SHOW_FUNC_DESCRIPTION_INSTEAD_OF_FDF_PATH
	/*
	void UpdateShowFDFfilename(const string& strFDF)
	{
		if(m_trFuncSel.SelFuncFile)
		{
			m_trFuncSel.SelFuncFile.strVal = strFDF;
		}
	}
	*/
	/// Hong 01/25/10 QA80-15026 NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY
	//void UpdateShowFuncDescription(const string& strDesc)
	void UpdateShowFuncDescription(LPCSTR strDesc)
	/// end NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY
	{
		if(m_trFuncSel.SelFuncDesc)
		{
			m_trFuncSel.SelFuncDesc.strVal = strDesc;
		}
	}
	///End SHOW_FUNC_DESCRIPTION_INSTEAD_OF_FDF_PATH
	
	///Cheney 2007-5-5 FUNC_DESCRIPTION_NOT_WORK
	/// Hong 01/25/10 QA80-15026 NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY
	//void UpdateShowFuncPath(const string& strFilePath)
	void UpdateShowFuncPath(LPCSTR strFilePath)
	/// end NLFIT_USE_EMPTY_FUNC_WHEN_SWITCH_CATEGORY
	{
		if(m_trFuncSel.SelFuncPath)
		{
			m_trFuncSel.SelFuncPath.strVal = strFilePath;
		}
	}
	///end FUNC_DESCRIPTION_NOT_WORK
	
private:	
	/// Hong 03/03/10 QA80-15156 FIX_NLFIT_FROM_QUICK_FIT_FAIL_LOAD_GAUSS_IF_REMOVE_IT_FROM_QUICKFIT_CATEGORY
	string		getFunctionCategory(LPCSTR lpcszFunc, vector<string>& vsCategory)
	{
		vector<string> 		vsFuncs, vsFullFileNames;
		vector<bool> 		vbSharedFunction;
		for ( int ii = 0; ii < vsCategory.GetSize(); ii++ )
		{
			GetFunctionList(vsFuncs, vsFullFileNames, vbSharedFunction, vsCategory[ii]);
			if ( is_in_list(lpcszFunc, vsFuncs) )
				return vsCategory[ii];
		}
		return "";
	}
	/// end FIX_NLFIT_FROM_QUICK_FIT_FAIL_LOAD_GAUSS_IF_REMOVE_IT_FROM_QUICKFIT_CATEGORY

	//void updateFuncSelection(const string& strCategory, LPCSTR lpcszDefaultFunc = NULL, vector<string>* pFilterList = NULL)///Jasmine 03/13/06 REPLACE_VECTOR_POINTER_WITH_VECTOR
	/// Hong 03/03/10 QA80-15156 FIX_NLFIT_FROM_QUICK_FIT_FAIL_LOAD_GAUSS_IF_REMOVE_IT_FROM_QUICKFIT_CATEGORY
	//void updateFuncSelection(const string& strCategory, LPCSTR lpcszDefaultFunc = NULL, vector<string>& vsFilterList = NULL, bool bAddNew = true)	///Jasmine 05/18/07 ADD_NEW_AT_LIST_BOTTOM_TO_OPEN_FO
	bool updateFuncSelection(string& strCategory, LPCSTR lpcszDefaultFunc = NULL, vector<string>& vsFilterList = NULL, bool bAddNew = true, bool bSearchOtherCategory = false, vector<string>& vsCategory = NULL)
	/// end FIX_NLFIT_FROM_QUICK_FIT_FAIL_LOAD_GAUSS_IF_REMOVE_IT_FROM_QUICKFIT_CATEGORY
	{
		string strFuncList, strDefaultFunc = lpcszDefaultFunc;
		Tree tr;
		vector<string> vsFunctions;
		tr.SetAttribute(STR_LABEL_ATTRIB, strCategory);
		if(GetFunctionList(tr))
		{
			tree_get_attributes(tr, vsFunctions, STR_LABEL_ATTRIB, true);			
			/// Iris 3/02/06 SUPPORT_PFM_IN_NLFIT_DLG
			if( 0 == strCategory.Compare(STR_CATE_NAME_PFM) )
			{
				vsFunctions.InsertAt(0, STR_FUNC_NAME_MIXED_TYPE);
			}
			///End SUPPORT_PFM_IN_NLFIT_DLG	
			
			/// Hong 03/03/10 QA80-15156 FIX_NLFIT_FROM_QUICK_FIT_FAIL_LOAD_GAUSS_IF_REMOVE_IT_FROM_QUICKFIT_CATEGORY
			/////------ Folger 11/05/09 QA81-14595-P1 NLFIT_SHOULD_NOT_LOAD_GAUSS_WHEN_DO_ANALYSIS_WITH_THEME_WHICH_HAS_NO_FUNCTION
			////if(strDefaultFunc.IsEmpty() || !is_in_list(strDefaultFunc, vsFunctions))
			//if ( isResetDefaultFunctionNeeded(vsFunctions, strDefaultFunc) )
			/////------ End NLFIT_SHOULD_NOT_LOAD_GAUSS_WHEN_DO_ANALYSIS_WITH_THEME_WHICH_HAS_NO_FUNCTION
				//tr.GetAttribute(STR_DEFAULT_FUNCTION_ATTRIB, strDefaultFunc);
			bool		bNeedResetDefaultFunc = false;
			if ( isResetDefaultFunctionNeeded(vsFunctions, strDefaultFunc) )
			{
				bNeedResetDefaultFunc = true;
				if ( bSearchOtherCategory && NULL != vsCategory )
				{
					string			strNewCategory = getFunctionCategory(strDefaultFunc, vsCategory);
					if ( !strNewCategory.IsEmpty() )
					{
						strCategory = strNewCategory;
						updateFuncSelection(strNewCategory, lpcszDefaultFunc, vsFilterList, bAddNew);
						return true;
					}
				}
			}
			if ( bNeedResetDefaultFunc )
				tr.GetAttribute(STR_DEFAULT_FUNCTION_ATTRIB, strDefaultFunc);
			/// end FIX_NLFIT_FROM_QUICK_FIT_FAIL_LOAD_GAUSS_IF_REMOVE_IT_FROM_QUICKFIT_CATEGORY
			
			///Jasmine 03/13/06 REPLACE_VECTOR_POINTER_WITH_VECTOR
			//if(pFilterList!=NULL && pFilterList->GetSize() > 0)
			//{
				//remove_if_not_in_list(vsFunctions, *pFilterList);
			if(vsFilterList!=NULL && vsFilterList.GetSize() > 0)
			{
				remove_if_not_in_list(vsFunctions, vsFilterList);
			///End REPLACE_VECTOR_POINTER_WITH_VECTOR
				//strFuncList.SetTokens(vsFunctions, '|');	//shoud reset list /// Iris 3/02/06 SUPPORT_PFM_IN_NLFIT_DLG
			}
			
			///Jasmine 05/18/07 ADD_NEW_AT_LIST_BOTTOM_TO_OPEN_FO
			/// Hong 10/24/08 v8.0960b FIX_NEW_NLFIT_FUNCTION_LIST_LOST_ITEM_NEW_DOT_DOT_DOT
			//if(bAddNew && true == m_trFuncSel.FunctionList.Enable && 0 > vsFunctions.Find(STR_NEW_DOT_DOT_DOT))
			if(bAddNew && tree_is_editable(m_trFuncSel.FunctionList) && 0 > vsFunctions.Find(STR_NEW_DOT_DOT_DOT))
			/// end FIX_NEW_NLFIT_FUNCTION_LIST_LOST_ITEM_NEW_DOT_DOT_DOT
				vsFunctions.Add(STR_NEW_DOT_DOT_DOT);
			///End ADD_NEW_AT_LIST_BOTTOM_TO_OPEN_FO
			
			strFuncList.SetTokens(vsFunctions, '|');
			///Sophy 6/2/2010 ORG-2 NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
			if ( vsFunctions.GetSize() < 2 && tree_is_editable(m_trFuncSel.FunctionList) )
				strFuncList = "|" + strFuncList;
			///end NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
			
			///DG EMPTY_CATEGORY_EMPTY_SHOWN
			/*
			m_trFuncSel.FunctionList.SetAttribute(STR_COMBO_ATTRIB, strFuncList);
			m_trFuncSel.FunctionList.strVal = strDefaultFunc;
		}
		*/
		}
		else	//It's a empty category without any function
		{
			strDefaultFunc.Empty();
			if(bAddNew)
				strFuncList = " |" + STR_NEW_DOT_DOT_DOT;	///Jasmine 05/18/07 ADD_NEW_AT_LIST_BOTTOM_TO_OPEN_FO
		}
		
		m_trFuncSel.FunctionList.SetAttribute(STR_COMBO_ATTRIB, strFuncList);
		///------ Folger 01/21/09 FUNCTION_NAME_COMES_FROM_NLFLT_FAILS_TO_MATCH_COMBO_STRINGS
		if ( !strDefaultFunc.IsEmpty() )
		{
			strFuncList.GetTokens(vsFunctions, '|');
			int	nPos = vsFunctions.Find(strDefaultFunc);
			if ( nPos >= 0 )
				strDefaultFunc = vsFunctions[nPos];
		}
		///------ End FUNCTION_NAME_COMES_FROM_NLFLT_FAILS_TO_MATCH_COMBO_STRINGS
		m_trFuncSel.FunctionList.strVal = strDefaultFunc;
		m_trFuncSel.FunctionList.SetAttribute(STR_OCNTRL_OPTNS, OCNTRLPARAM1_NOT_LOCALIZED);		//------ Folger 11/09/07 COMBO_TEXT_NO_NEEDED_LOCALIZE
		///DG EMPTY_CATEGORY_EMPTY_SHOWN
		
		return false; /// Hong 03/03/10 QA80-15156 FIX_NLFIT_FROM_QUICK_FIT_FAIL_LOAD_GAUSS_IF_REMOVE_IT_FROM_QUICKFIT_CATEGORY
	}
	/*
	bool getFunctionSelectionList(const string &strSelCate, string &strFuncList, string &strDefaultFunc, vector<string>* pFilterList = NULL, char chDelimiter = '|')
	{
		vector<string> 	vsNLSFFunction;
		int nDefaultFunc;
		if(!nlf_get_section_keys(strSelCate, vsNLSFFunction, &nDefaultFunc))
		{
			strFuncList.Empty();
			return false;
		}
		if(pFilterList!=NULL && pFilterList->GetSize() > 0)
			remove_if_not_in_list(vsNLSFFunction, *pFilterList);
		
		strFuncList.SetTokens(vsNLSFFunction, chDelimiter);
		if(strDefaultFunc.IsEmpty() || !is_in_list(strDefaultFunc, vsNLSFFunction))			
			strDefaultFunc=vsNLSFFunction[nDefaultFunc];
		return true;
	}
	bool getCategoryList(string &strCateList, string& strSelCate, LPCSTR lpcszDefaultCate = NULL, char chDelimiter = '|')
	{
		vector<string>	vsNLSFCategory;
		
		if(!nlf_get_section_keys("Category", vsNLSFCategory))
		{
			strCateList.Empty();
			return false;
		}
		if(is_in_list(lpcszDefaultCate, vsNLSFCategory))
			strSelCate = lpcszDefaultCate;
		else
			strSelCate = vsNLSFCategory[0]; // default to 1st for now
		
		strCateList.SetTokens(vsNLSFCategory, chDelimiter);
		return true;
	}
	*/

	///------ Folger 11/05/09 QA81-14595-P1 NLFIT_SHOULD_NOT_LOAD_GAUSS_WHEN_DO_ANALYSIS_WITH_THEME_WHICH_HAS_NO_FUNCTION
	void	onInitMembers()
	{
		m_bInitFromNLFit = FALSE;
	}

	BOOL	isResetDefaultFunctionNeeded(const vector<string>& vsFunctions, const string& strDefaultFunc)
	{
		return (IsInitFromNLFit() && !strDefaultFunc.IsEmpty() && !is_in_list(strDefaultFunc, vsFunctions))
				|| (!IsInitFromNLFit() && (strDefaultFunc.IsEmpty() || !is_in_list(strDefaultFunc, vsFunctions)))
	}
	///------ End NLFIT_SHOULD_NOT_LOAD_GAUSS_WHEN_DO_ANALYSIS_WITH_THEME_WHICH_HAS_NO_FUNCTION

	///------ Folger 08/29/2012 ORG-5772-P1 SIMULATE_CURVES_FOR_IMPLICIT_FUNCTION
	// ///Philip 08/22/2012 ORG-6527-S3 DISABLE_CATEGORY_DROPDOWN_WHEN_USE_NL_IMPLICIT_CURVE_FIT
	// bool isODRFit(const TreeNode& tn)
	// {
	// 	TreeNode trOp = tn;
	// 	while(trOp.Parent())
	// 		trOp = trOp.Parent();
	// 	return (trOp.SpecInfo.ClassName && (0 == lstrcmpi(trOp.SpecInfo.ClassName.strVal, "FitODR")));
	// }
	// ///end DISABLE_CATEGORY_DROPDOWN_WHEN_USE_NL_IMPLICIT_CURVE_FIT
	///------ End SIMULATE_CURVES_FOR_IMPLICIT_FUNCTION
private:
	//NumFunctionOrganizer		m_NFO;			///DG ACCESS_FUNCTION_BY_NFO
	TreeNode 					m_trFuncSel;
	///------ Folger 11/05/09 QA81-14595-P1 NLFIT_SHOULD_NOT_LOAD_GAUSS_WHEN_DO_ANALYSIS_WITH_THEME_WHICH_HAS_NO_FUNCTION
	BOOL						m_bInitFromNLFit;
	///------ End NLFIT_SHOULD_NOT_LOAD_GAUSS_WHEN_DO_ANALYSIS_WITH_THEME_WHICH_HAS_NO_FUNCTION
	
	///------ Folger 08/29/2012 ORG-5772-P1 SIMULATE_CURVES_FOR_IMPLICIT_FUNCTION
	// bool m_bIsODRFit;///Philip 08/22/2012 ORG-6527-S3 DISABLE_CATEGORY_DROPDOWN_WHEN_USE_NL_IMPLICIT_CURVE_FIT
	///------ End SIMULATE_CURVES_FOR_IMPLICIT_FUNCTION
};

//------Joseph 01/30/06	ADD_OPERATION_ERRMSG_LINE
/*
///CPY 10/18/04
/// YuI 11/09/06 SOME_REDESIGN_OF_NLFIT_FOR_MODAL
//	bool NLFitBox(TreeNode& trNode, HWND hWndParent = NULL, LPCSTR lpcszTitle=NULL);
//	typedef bool (* NLFDLG_FUNC)(TreeNode& trNode, HWND hWndParent, LPCSTR lpcszTitle);
class	NLFitSession;
bool NLFitBox(TreeNode& trNode, NLFitSession* pFitSession, HWND hWndParent = NULL, LPCSTR lpcszTitle=NULL);
typedef bool (* NLFDLG_FUNC)(TreeNode& trNode, NLFitSession* pFitSession, HWND hWndParent, LPCSTR lpcszTitle);
/// SOME_REDESIGN_OF_NLFIT_FOR_MODAL
*/
///Cheney 2007-4-24 CLEAN_UP_FDF_TREE_LOAD
//class	NLFitSession;
//bool NLFitBox(TreeNode& trNode, NLFitSession* pFitSession, HWND hWndParent = NULL, LPCSTR lpcszTitle=NULL, PEVENT_GETN pfn = NULL);
//typedef bool (* NLFDLG_FUNC)(TreeNode& trNode, NLFitSession* pFitSession, HWND hWndParent, LPCSTR lpcszTitle, PEVENT_GETN pfn);
//should pass trFDF to NLFitSplitter
class	NLFitSession;

///-----Kit 01/28/2011 ORG-2120-S2 USE_CHANGE_PARAM_OPEN_NLFIT_SHOULD_ACTIVE_SETTING_TAB
//bool NLFitBox(TreeNode& trNode, TreeNode& trFDF, NLFitSession* pFitSession, HWND hWndParent = NULL, LPCSTR lpcszTitle=NULL, PEVENT_GETN pfn = NULL);
//typedef bool (* NLFDLG_FUNC)(TreeNode& trNode, TreeNode& trFDF, NLFitSession* pFitSession, HWND hWndParent, LPCSTR lpcszTitle, PEVENT_GETN pfn);
enum
{
	NLFIT_DLG_OPEN_FROM_CHANGE_PARAMETER = 0x00000001,
};
bool NLFitBox(TreeNode& trNode, TreeNode& trFDF, NLFitSession* pFitSession
			  , HWND hWndParent = NULL, LPCSTR lpcszTitle = NULL, PEVENT_GETN pfn = NULL
			  , DWORD dwOption = 0);
typedef bool (* NLFDLG_FUNC)(TreeNode& trNode, TreeNode& trFDF, NLFitSession* pFitSession, HWND hWndParent, LPCSTR lpcszTitle, PEVENT_GETN pfn, DWORD dwOption);
///-----End USE_CHANGE_PARAM_OPEN_NLFIT_SHOULD_ACTIVE_SETTING_TAB


///end CLEAN_UP_FDF_TREE_LOAD
//------End ADD_OPERATION_ERRMSG_LINE
#endif // _NLFIT_SEL_FUNCTION_H
