/*------------------------------------------------------------------------------*
 * File Name:	NLFData.h														*
 * Creation: 	Iris															*
 * Purpose: OriginC Source H file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:  															*
 *	Hong 07/14/08 v8.0901 DATA_OBJ_SUPPORT_SURFACE_DATA							*
 *	Hong 07/23/08 QA80-11816 AUTO_PARAMS_INIT_SUPPORT_MULTI_DEPS_MULTI_INDEPS	*
 *	Hong 08/14/08 v8.0922 FIX_MATRIX_FIT_FAIL_DO_REDUCE							*
 *	Hong 09/03/08 QA80-12130 NLFIT_SESSION_SUPPORT_SEPARATE_FIT					*
 *	Hong 10/17/08 QA80-10624 NLFIT_SUPPORT_FIT_SWAPPED_POLAR_PLOT				*
 *  Iris 11/01/2008 v8.0964 NEW_PA_SUPPORT_CREATE_REPORT_GRAPH_ON_SOURCE		*
 *	Hong 11/04/08 v8.0965b ADD_BACKWARD_COMPATIABLE								*
 *	Hong 12/22/08 v8.0989c FIX_MUL_DEPS_INDEPS_FAIL_CORRECT_FIT					*
 *	Sophy 1/12/2009 v8.0995c QA80-12613-P3 FIX_NLFIT_SHOW_WRONG_CUSTOMIZED_Y_MIN_MAX_ON_SURFACEFIT
 *	Hong 02/26/09 FIX_PREVIEW_GRAPH_BECOME_EMPTY_WHEN_CHANGE_PARAMETER_WITH_SRC_GRAPH_REMOVED
 *	Sophy 7/1/2009 MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION					*
 *	Folger 07/02/09 QA80-13870 MULTIPLE_SETS_GLOBAL_FITTING_WITH_WEIGHT_FAILS_SINCE_SR5
 *	Folger 07/28/09 QA80-14021 PREIVEW_UPDATE_IN_MATRIX_FIT_AND_SURFACE_FIT_MUCH_SLOWER_THAN_SR5
 *	Folger 08/17/10 ORG-824-P1 WEIGHTING_BROKEN_FOR_MULTIPLE_DEPS_FITTING		*
 *	Folger 09/15/2010 ORG-1055-P1 MATRIX_FITTED_CURVE_OPPOSITE_DIMENSION_WHEN_SAME_AS_INPUT_DATA
 *	Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT						*
 *	Sim 2011-11-29 ORG-4454 ODR_NLFIT_SUPPORT_MULTI_VAR_FOR_IMPLICIT_FUNC		*
 *	Folger 12/31/2011 ORG-4454 REFACTOR_NLFITSESSION							*
 *  Iris 2/13/2012 ORG-3911-P1 FIX_FIT_CURVE_DATA_NOT_FOLLOW_SOURCE_GRAPH_SCALE_TYPE_FOR_CONCATENATE_MODE
 *	Sim 2012-03-09 ORG-5227 FIX_CRASH_WHEN_SWITCH_FIT_FUNCTION
 *  Iris 4/25/2012 ORG-5473-P1 NO_NEED_CHECK_XYZ_REGULAR_FOR_SAME_AS_INPUT_DATA_FOR_MATRIX_FIT
 *------------------------------------------------------------------------------*/

#ifndef	_NLF_DATA_H_
#define	_NLF_DATA_H_

#include 	<ONLSF.h>

#define _NLF_81(_NAME) 

#define			MAX_INTERATE_NUM_TRY_CONVERGE		100
#define 		MAX_DATASET_NUMBER					100
#define 		MAX_INDEP_DATASET_NUMBER			MAX_DATASET_NUMBER * 2
#define			DATA_SINGLE_SET						1


class NLFDataBase
{
protected:
	NLFDataBase();
	
public:
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	//bool			IsExceedLimitation(int nDataIndex, int nDepIndex = 0, int nIndepIndex = 0);
	bool			IsExceedLimitation(int nDataIndex, int nDepIndex = -1, int nIndepIndex = -1);
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	int				GetNumDataset() { return m_nNumDataset; }
	BOOL			IsDataValid(int nDataset);				///------ Folger 01/05/2012 ORG-4454 REFACTOR_NLFITSESSION
	/// Hong 10/17/08 QA80-10624 NLFIT_SUPPORT_FIT_SWAPPED_POLAR_PLOT
	//void			Reset() { m_nNumDataset = 0; resetSourcePlotUIDs(); }
	///------ Folger 07/28/09 QA80-14021 PREIVEW_UPDATE_IN_MATRIX_FIT_AND_SURFACE_FIT_MUCH_SLOWER_THAN_SR5
	//void			Reset();
	virtual	void	Reset();
	///------ End PREIVEW_UPDATE_IN_MATRIX_FIT_AND_SURFACE_FIT_MUCH_SLOWER_THAN_SR5
	bool			IsSwappedPolarPlot();
	/// end NLFIT_SUPPORT_FIT_SWAPPED_POLAR_PLOT
	/// Hong 06/17/08 v8.0886 REFACTORING_ORTHOGONALITY
	//int				SetData(const DataRange& drInput, DWORD dwRules, int nIndex, DWORD* pdwPlotGUI, int nNumDeps, int nNumInDeps, int nDepIndex = 0, int nIndepIndex = 0, Worksheet* pwksData = NULL);
	/**$
		This function will do dataset number counting, so should not set one dataset twice
	*/
	int				SetData(const DataRange& drInput, DWORD dwRules, int nIndex, DWORD* pdwPlotGUI, int nNumDeps, int nNumInDeps, int nDataIndex = 0, Worksheet* pwksData = NULL);
	/// end REFACTORING_ORTHOGONALITY
	/// Hong 11/04/08 v8.0965b ADD_BACKWARD_COMPATIABLE
	///Sophy 7/1/2009 MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
	//int				SetData(const vector& vX, const vector& vY, const vector& vZ = NULL, int nIndex = 0, int nNumDeps = 1, int nNumIndeps = 1, int nNumTotalDataset = 1);
#ifndef	EXTEND_INTERFACES_OF_NLFITSESSION
	int				SetData(const vector& vX, const vector& vY, const vector& vZ = NULL, int nIndex = 0, int nNumDeps = 1, int nNumIndeps = 1, int nNumTotalDataset = 1);
#else
	int				SetData(const vector& vX, const vector& vY, const vector& vZ = NULL, int nIndex = 0, int nNumDeps = 1, int nNumIndeps = 1, int nNumTotalDataset = 1, const vector& vW = NULL);
#endif	//EXTEND_INTERFACES_OF_NLFITSESSION
	///end MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
	/// end ADD_BACKWARD_COMPATIABLE
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	int				SetData(const vector *pvDependentData, const vector *pvIndependentData, const vector *pvDependentWeightData, const vector *pvIndependentWeightData
							, int nNumDeps, int nNumIndeps
							, int nIndex = 0, int nNumTotalDataset = 1);
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	///------ Folger 08/17/10 ORG-824-P1 WEIGHTING_BROKEN_FOR_MULTIPLE_DEPS_FITTING
	//bool			SetWeightData(int nWTMethod, double dWTa, double dWTb, double vdWTc, int nDataIndex = 0);
	bool			SetWeightData(int nWTMethod, double dWTa, double dWTb, double dWTc, int nDataIndex = 0, int nDep = 0);
	///------ End WEIGHTING_BROKEN_FOR_MULTIPLE_DEPS_FITTING
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	bool			SetWeightIndepData(int nWTMethod, double dWTa, double dWTb, double vdWTc, int nDataIndex = 0, int nIndep = 0);
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
		
	/// Hong 09/03/08 QA80-12130 NLFIT_SESSION_SUPPORT_SEPARATE_FIT
	//PNLSFONEDATA	GetDependData();
	//PNLSFONEDATA	GetIndependData();
	//PONEDATAWEIGHT	GetWeightData();
	PNLSFONEDATA	GetDependDatas(int nDataIndex = 0);
	PNLSFONEDATA	GetIndependDatas(int nDataIndex = 0);
	PONEDATAWEIGHT	GetWeightDatas(int nDataIndex = 0);
	/// end NLFIT_SESSION_SUPPORT_SEPARATE_FIT
	PONEDATAWEIGHT	GetWeightIndepDatas(int nDataIndex = 0); ///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	/// Hong 07/23/08 QA80-11816 AUTO_PARAMS_INIT_SUPPORT_MULTI_DEPS_MULTI_INDEPS
	vector*			GetDependData(int nDataIndex = 0, int nDepIndex = 0);
	vector*			GetIndependData(int nDataIndex = 0, int nIndepIndex = 0);
	/// end AUTO_PARAMS_INIT_SUPPORT_MULTI_DEPS_MULTI_INDEPS
	/// Hong 06/17/08 v8.0886 REFACTORING_ORTHOGONALITY
	//bool			GetDependData(vector& vDependentData, int nDataIndex = 0);
	//bool			GetIndependData(vector& vIndependentData, int nDataIndex = 0);	
	bool			GetDependData(vector& vDependentData, int nDataIndex = 0, int nDepIndex = 0);
	bool			GetIndependData(vector& vIndependentData, int nDataIndex = 0, int nIndepIndex = 0);
	/// end REFACTORING_ORTHOGONALITY
	bool			GetWeightData(vector& vWeightData, int nDataIndex = 0);
	bool			GetWeightIndepData(vector& vWeightData, int nDataIndex = 0); ///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	
	///Sophy 1/12/2009 v8.0995c QA80-12613-P3 FIX_NLFIT_SHOW_WRONG_CUSTOMIZED_Y_MIN_MAX_ON_SURFACEFIT
	//virtual bool	GetXMinMax(double& dMin, double& dMax);
	//virtual bool	GetYMinMax(double& dMin, double& dMax);
	virtual bool	GetIndepMinMax(double& dMin, double& dMax, int nDataIndex = 0, int nIndepIndex = 0);
	virtual bool	GetDepMinMax(double& dMin, double& dMax, int nDataIndex = 0, int nDepIndex = 0);
	///end FIX_NLFIT_SHOW_WRONG_CUSTOMIZED_Y_MIN_MAX_ON_SURFACEFIT
	/// Hong 08/14/08 v8.0922 FIX_MATRIX_FIT_FAIL_DO_REDUCE
	//virtual bool	SetData(const matrix& matData, int nDataIndex = 0) { return false; }
	//virtual bool	GetData(matrix& matData = NULL, int* pnCols = NULL, int* pnRows = NULL, int nDataIndex = 0) { return false; }
	/// end FIX_MATRIX_FIT_FAIL_DO_REDUCE

	/// Iris NLF_81  added interface, need Hong support
	bool			IsAllSrcDataFromGraph();
	DWORD			GetSourcePlotUID(int nDatasetIndex = 0);
	bool			GetSourceGraphLayer(GraphLayer& glSource, int nDatasetIndex = 0);
	void			SetSourcePlotUID(int nDatasetIndex, DWORD dwPlotUID); /// Iris 11/01/2008 v8.0964 NEW_PA_SUPPORT_CREATE_REPORT_GRAPH_ON_SOURCE
	
	/// Hong 08/14/08 v8.0922 FIX_MATRIX_FIT_FAIL_DO_REDUCE
	virtual bool	GetDimention(int nDatasetIndex, int& nNumRows, int& nNumCols) { ASSERT(FALSE); return false; }
	/// end FIX_MATRIX_FIT_FAIL_DO_REDUCE

	///------ Folger 07/28/09 QA80-14021 PREIVEW_UPDATE_IN_MATRIX_FIT_AND_SURFACE_FIT_MUCH_SLOWER_THAN_SR5
	virtual	bool	CheckXYZRegularData( int& nRows = NULL, int& nCols = NULL)		{ return false; }
	///------ End PREIVEW_UPDATE_IN_MATRIX_FIT_AND_SURFACE_FIT_MUCH_SLOWER_THAN_SR5
	
	
//#ifdef	NLF_DEBUG ///---Sim 2012-03-09 ORG-5227 FIX_CRASH_WHEN_SWITCH_FIT_FUNCTION
	void			GetNumVars(int& nNumDeps, int& nNumIndeps);
//#endif	//NLF_DEBUG ///---Sim 2012-03-09 ORG-5227 FIX_CRASH_WHEN_SWITCH_FIT_FUNCTION

protected:
	virtual bool	isIndexExceedLimitation(int nIndex) { return true; }
	virtual	int		setData(const DataRange& drInput, DWORD dwRules, int nIndex, DWORD& dwPlotUID, int nDepIndex, int nIndepIndex, Worksheet* pwksData);
	/// Hong 11/04/08 v8.0965b ADD_BACKWARD_COMPATIABLE
	///Sophy 7/1/2009 MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
	//virtual	int		setData(const vector& vX, const vector& vY, const vector& vZ, int nIndex, int nDepIndex, int nIndepIndex);
#ifndef	EXTEND_INTERFACES_OF_NLFITSESSION
	virtual	int		setData(const vector& vX, const vector& vY, const vector& vZ, int nIndex, int nDepIndex, int nIndepIndex);
#else
	virtual	int		setData(const vector& vX, const vector& vY, const vector& vZ, int nIndex, int nDepIndex, int nIndepIndex, const vector& vW = NULL);
#endif	//EXTEND_INTERFACES_OF_NLFITSESSION
	///end MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
	/// end ADD_BACKWARD_COMPATIABLE
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	virtual int		setData(const vector *pvDependentData, const vector *pvIndependentData, const vector *pvDependentWeightData, const vector *pvIndependentWeightData, int nIndex);
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	
	void			resetSourcePlotUIDs();

	///------ Folger 07/02/09 QA80-13870 MULTIPLE_SETS_GLOBAL_FITTING_WITH_WEIGHT_FAILS_SINCE_SR5
	void			setOneWeightDesc(int nIndex);
	///------ End MULTIPLE_SETS_GLOBAL_FITTING_WITH_WEIGHT_FAILS_SINCE_SR5
	void			setOneWeightIndepDesc(int nIndex); ///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	int				updateDataWrapper(int nIndex); ///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT

	
protected:
	vector*					m_pvDependentData;	
	vector*					m_pvIndependentData;
	vector*					m_pvWeightData;
	vector*					m_pvWeightIndepData; ///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	
	PNLSFONEDATA 			m_pstDependentData;
	PNLSFONEDATA 			m_pstIndependentData;
	PONEDATAWEIGHT 			m_pstWeightDesc;
	PONEDATAWEIGHT 			m_pstWeightIndepDesc; ///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	
	/// Hong 06/17/08 v8.0886 REFACTORING_ORTHOGONALITY
	int						m_nNumDeps;
	int						m_nNumIndeps;
	/// end REFACTORING_ORTHOGONALITY
	int						m_nNumDataset;
	bool					m_bCheckNumDataset;
	
	int						m_nNumSwappedPolarPlot; /// Hong 10/17/08 QA80-10624 NLFIT_SUPPORT_FIT_SWAPPED_POLAR_PLOT
	
	vector<int>				m_vnSourcePlotUIDs; /// Iris NLF_81, MOVE_GET_SET_SOURCE_PLOT_UIDS_FROM_SESSION_TO_NLFDATA
};


class NLFDataSingleIndep : public NLFDataBase
{
public:
	NLFDataSingleIndep();
	
protected:
	//virtual
	bool	isIndexExceedLimitation(int nIndex);
	
private:
	vector					m_vDependentData[DATA_SINGLE_SET];	
	vector					m_vIndependentData[DATA_SINGLE_SET];
	vector					m_vWeightData[DATA_SINGLE_SET];
	vector					m_vWeightIndepData[DATA_SINGLE_SET]; ///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	
	NLSFONEDATA 			m_stDependentData[DATA_SINGLE_SET];
	NLSFONEDATA 			m_stIndependentData[DATA_SINGLE_SET];
	ONEDATAWEIGHT 			m_stWeightDesc[DATA_SINGLE_SET];
	ONEDATAWEIGHT 			m_stWeightIndepDesc[DATA_SINGLE_SET]; ///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
};


class NLFDataMultiIndeps : public NLFDataBase
{
public:
	NLFDataMultiIndeps();
	
protected:
	// virtual
	bool	isIndexExceedLimitation(int nIndex);
	
private:
	vector					m_vDependentData[MAX_DATASET_NUMBER];	
	vector					m_vIndependentData[MAX_DATASET_NUMBER];
	vector					m_vWeightData[MAX_DATASET_NUMBER];
	vector					m_vWeightIndepData[MAX_DATASET_NUMBER]; ///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	
	NLSFONEDATA 			m_stDependentData[MAX_DATASET_NUMBER];
	NLSFONEDATA 			m_stIndependentData[MAX_DATASET_NUMBER];
	ONEDATAWEIGHT 			m_stWeightDesc[MAX_DATASET_NUMBER];
	ONEDATAWEIGHT 			m_stWeightIndepDesc[MAX_DATASET_NUMBER]; ///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
};


class NLFDataSurface : public NLFDataMultiIndeps
{
	///------ Folger 07/28/09 QA80-14021 PREIVEW_UPDATE_IN_MATRIX_FIT_AND_SURFACE_FIT_MUCH_SLOWER_THAN_SR5
public:
	NLFDataSurface();

	/// virtual
	void		Reset();

	/// virtual
	bool		CheckXYZRegularData( int& nRows = NULL, int& nCols = NULL);
	///------ End PREIVEW_UPDATE_IN_MATRIX_FIT_AND_SURFACE_FIT_MUCH_SLOWER_THAN_SR5

private:
	//virtual
	int			setData(const DataRange& drInput, DWORD dwRules, int nIndex, DWORD& dwPlotUID, int nDepIndex, int nIndepIndex, Worksheet* pwksData);
	/// Hong 11/04/08 v8.0965b ADD_BACKWARD_COMPATIABLE
	//virtual
	///Sophy 7/1/2009 MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
	//int		setData(const vector& vX, const vector& vY, const vector& vZ, int nIndex, int nDepIndex, int nIndepIndex);
#ifndef	EXTEND_INTERFACES_OF_NLFITSESSION
	int		setData(const vector& vX, const vector& vY, const vector& vZ, int nIndex, int nDepIndex, int nIndepIndex);
#else
	int		setData(const vector& vX, const vector& vY, const vector& vZ, int nIndex, int nDepIndex, int nIndepIndex, const vector& vW = NULL);
#endif	//EXTEND_INTERFACES_OF_NLFITSESSION
	///end MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
	/// end ADD_BACKWARD_COMPATIABLE
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	//virtual 
	int		setData(const vector *pvDependentData, const vector *pvIndependentData, const vector *pvDependentWeightData, const vector *pvIndependentWeightData, int nIndex) { ASSERT(FALSE); return -1; }
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	///------ Folger 07/28/09 QA80-14021 PREIVEW_UPDATE_IN_MATRIX_FIT_AND_SURFACE_FIT_MUCH_SLOWER_THAN_SR5
private:

	void	resetXYZRegularStatus()		{ m_nXYZRegularStatus = XYZ_DATA_REGULAR_UNKNOWN; }

private:

	enum
	{
		XYZ_DATA_REGULAR_UNKNOWN		= 0,
		XYZ_DATA_REGULAR_YES,
		XYZ_DATA_REGULAR_NO,
	};
	int		m_nXYZRegularStatus;

	int		m_nFitMatRows;
	int		m_nFitMatCols;
	///------ End PREIVEW_UPDATE_IN_MATRIX_FIT_AND_SURFACE_FIT_MUCH_SLOWER_THAN_SR5
};

/// Hong 08/14/08 v8.0922 FIX_MATRIX_FIT_FAIL_DO_REDUCE
class NLFDataMatrix : public NLFDataSurface
{
public:
	// virtual
	bool		GetDimention(int nDatasetIndex, int& nNumRows, int& nNumCols);

protected:
	//virtual
	int			setData(const DataRange& drInput, DWORD dwRules, int nIndex, DWORD& dwPlotUID, int nDepIndex, int nIndepIndex, Worksheet* pwksData);
	/// Hong 11/04/08 v8.0965b ADD_BACKWARD_COMPATIABLE
	//virtual
	///Sophy 7/1/2009 MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
	//int		setData(const vector& vX, const vector& vY, const vector& vZ, int nIndex, int nDepIndex, int nIndepIndex) { ASSERT(FALSE); return -1; }
#ifndef	EXTEND_INTERFACES_OF_NLFITSESSION
	int		setData(const vector& vX, const vector& vY, const vector& vZ, int nIndex, int nDepIndex, int nIndepIndex) { ASSERT(FALSE); return -1; }
#else
	int		setData(const vector& vX, const vector& vY, const vector& vZ, int nIndex, int nDepIndex, int nIndepIndex, const vector& vW = NULL) { ASSERT(FALSE); return -1; }
#endif	//EXTEND_INTERFACES_OF_NLFITSESSION
	///end MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
	/// end ADD_BACKWARD_COMPATIABLE
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	//virtual 
	int		setData(const vector *pvDependentData, const vector *pvIndependentData, const vector *pvDependentWeightData, const vector *pvIndependentWeightData, int nIndex) { ASSERT(FALSE); return -1; }
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	
	/// Iris 4/25/2012 ORG-5473-P1 NO_NEED_CHECK_XYZ_REGULAR_FOR_SAME_AS_INPUT_DATA_FOR_MATRIX_FIT
	// virtual 
	bool	CheckXYZRegularData( int& nRows = NULL, int& nCols = NULL);
	///End NO_NEED_CHECK_XYZ_REGULAR_FOR_SAME_AS_INPUT_DATA_FOR_MATRIX_FIT
	
private:
	IntArray				m_vnRows;
	IntArray				m_vnCols;
};
/// end FIX_MATRIX_FIT_FAIL_DO_REDUCE

//////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////NLFDataBase Implementation//////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
NLFDataBase::NLFDataBase()
{
	m_nNumDeps = m_nNumIndeps = m_nNumDataset = 0;
	m_bCheckNumDataset = true;
}

///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
/*
bool		NLFDataBase::IsExceedLimitation(int nDataIndex, int nDepIndex, int nIndepIndex) // = 0, 0
{	
	if ( m_bCheckNumDataset && nDataIndex >= m_nNumDataset )
		return true;

	if ( nDepIndex >= m_nNumDeps || nIndepIndex >= m_nNumIndeps || 
		isIndexExceedLimitation(nDataIndex * m_nNumDeps + nDepIndex) || isIndexExceedLimitation(nDataIndex * m_nNumIndeps + nIndepIndex) )
		return true;
	
	return false;
}
*/
bool		NLFDataBase::IsExceedLimitation(int nDataIndex, int nDepIndex, int nIndepIndex) // = -1, -1
{	
	if ( m_bCheckNumDataset && nDataIndex >= m_nNumDataset )
		return true;

	if ( nDepIndex >= 0 )
	{
		if ( nDepIndex >= m_nNumDeps )
			return true;
		if ( m_nNumDeps > 0 && isIndexExceedLimitation(nDataIndex * m_nNumDeps + nDepIndex) )
			return true;
	}
	
	if ( nIndepIndex >= 0 )
	{
		if ( nIndepIndex >= m_nNumIndeps )
			return true;
		if ( m_nNumIndeps > 0 && isIndexExceedLimitation(nDataIndex * m_nNumIndeps + nIndepIndex) )
			return true;
	}
	
	return false;
}
///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT

///------ Folger 01/05/2012 ORG-4454 REFACTOR_NLFITSESSION
BOOL	NLFDataBase::IsDataValid(int nDataset)
{
	return !IsExceedLimitation(nDataset, m_nNumDeps - 1, m_nNumIndeps - 1);
}
///------ End REFACTOR_NLFITSESSION

/// Hong 10/17/08 QA80-10624 NLFIT_SUPPORT_FIT_SWAPPED_POLAR_PLOT	
/// virtual		///------ Folger 07/28/09 QA80-14021 PREIVEW_UPDATE_IN_MATRIX_FIT_AND_SURFACE_FIT_MUCH_SLOWER_THAN_SR5
void		NLFDataBase::Reset()
{ 
	m_nNumDataset = 0;
	m_nNumSwappedPolarPlot = 0;
	resetSourcePlotUIDs();
}

bool		NLFDataBase::IsSwappedPolarPlot()
{
	if ( m_nNumSwappedPolarPlot > 0 )
	{
		ASSERT( m_nNumSwappedPolarPlot == GetNumDataset() );
	#ifdef	NLF_DEBUG
		int		nDep, nIndep;
		GetNumVars(nDep, nIndep);
		ASSERT( 1 == nDep && 1 == nIndep );
	#endif	//NLF_DEBUG
		return true;
	}
	
	return false;
}
/// end NLFIT_SUPPORT_FIT_SWAPPED_POLAR_PLOT

/// Hong 06/17/08 v8.0886 REFACTORING_ORTHOGONALITY
//int			NLFDataBase::SetData(const DataRange& drInput, DWORD dwRules, int nIndex, DWORD* pdwPlotGUI, int nNumDeps, int nNumInDeps, int nDepIndex, int nIndepIndex, Worksheet* pwksData) // = 0, 0, NULL
int			NLFDataBase::SetData(const DataRange& drInput, DWORD dwRules, int nIndex, DWORD* pdwPlotUID, int nNumDeps, int nNumInDeps, int nDataIndex, Worksheet* pwksData) // = 0, NULL
/// end REFACTORING_ORTHOGONALITY
{
	if ( !drInput )
		return -1;
	
	/// Hong 06/17/08 v8.0886 REFACTORING_ORTHOGONALITY
	if ( nDataIndex != 0 )
	{	// right now,  no NOT support variable dimension datas
		ASSERT(m_nNumDeps == nNumDeps);
		ASSERT(m_nNumIndeps == nNumInDeps);
	}	
	m_nNumDeps = 	nNumDeps;
	m_nNumIndeps = 	nNumInDeps;
	
	m_bCheckNumDataset = false;	
	bool	bExceedLimitaion = IsExceedLimitation(nDataIndex, nNumDeps -1, nNumInDeps - 1);
	m_bCheckNumDataset = true;
	if ( bExceedLimitaion )
		return -1;
	
	int		nDepIndex, nIndepIndex;
	nDepIndex = 	nDataIndex * m_nNumDeps;
	nIndepIndex = 	nDataIndex * m_nNumIndeps;
	/// end REFACTORING_ORTHOGONALITY
	
	DWORD	dwPlotUID;
	/// Hong 07/14/08 v8.0901 DATA_OBJ_SUPPORT_SURFACE_DATA
	//int 	nn = drInput.GetNLFitData(dwRules, nIndex, &dwPlotUID, nNumDeps, m_pvDependentData + nDepIndex, nNumInDeps, m_pvIndependentData + nIndepIndex, m_pvWeightData + nDepIndex, pwksData);		
	//int		nn = drInput.GetData(dwRules, nIndex, &dwPlotUID, NULL, m_pvDependentData + nDepIndex, m_pvIndependentData + nIndepIndex, NULL, NULL, NULL, NULL, NULL, NULL, m_pvIndependentData + nIndepIndex + 1);
	int		nn = setData(drInput, dwRules, nIndex, dwPlotUID, nDepIndex, nIndepIndex, pwksData);
	/// end DATA_OBJ_SUPPORT_SURFACE_DATA
	if ( nn < 0 )
		return nn;	
	/// Hong 02/26/09 FIX_PREVIEW_GRAPH_BECOME_EMPTY_WHEN_CHANGE_PARAMETER_WITH_SRC_GRAPH_REMOVED
	DataPlot		dp;
	dp = (DataPlot)Project.GetObject(dwPlotUID);
	if ( !dp )
		dwPlotUID = 0;
	/// end FIX_PREVIEW_GRAPH_BECOME_EMPTY_WHEN_CHANGE_PARAMETER_WITH_SRC_GRAPH_REMOVED
	
	if( pdwPlotUID )
		*pdwPlotUID = dwPlotUID;

	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	/*
	for ( int ii = nDepIndex; ii < nDepIndex + nNumDeps; ii++ )
	{		
		m_pstDependentData[ii].pdData = m_pvDependentData[ii];
		m_pstDependentData[ii].nSize = m_pvDependentData[ii].GetSize();
	
		if ( 0 == m_pvWeightData[ii].GetSize() )
		{
			m_pvWeightData[ii].SetSize(m_pvDependentData[ii].GetSize());
			m_pvWeightData[ii] = 1;
		}
		///------ Folger 07/02/09 QA80-13870 MULTIPLE_SETS_GLOBAL_FITTING_WITH_WEIGHT_FAILS_SINCE_SR5
		//m_pstWeightDesc[ii].stWeightData.pdData	= m_pvWeightData[ii];
		//m_pstWeightDesc[ii].stWeightData.nSize		= m_pvWeightData[ii].GetSize();
		setOneWeightDesc(ii);
		///------ End MULTIPLE_SETS_GLOBAL_FITTING_WITH_WEIGHT_FAILS_SINCE_SR5
	}
	for ( int jj = nIndepIndex; jj < nIndepIndex + nNumInDeps; jj++ )
	{
		m_pstIndependentData[jj].pdData = m_pvIndependentData[jj];
		m_pstIndependentData[jj].nSize = m_pvIndependentData[jj].GetSize();
		///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
		if ( 0 == m_pvWeightIndepData[jj].GetSize() )
		{
			m_pvWeightIndepData[jj].SetSize(m_pvIndependentData[jj].GetSize());
			m_pvWeightIndepData[jj] = 1;
		}
		setOneWeightIndepDesc(jj);
		///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	}
	*/
	nn = updateDataWrapper(nIndex);
	if ( nn < 0 )
		return nn;
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	
	m_vnSourcePlotUIDs.Add(dwPlotUID);	/// Iris NLF_81, will call resetSourcePlotUIDs when Reset Data Object, so can directly add here 
	m_nNumDataset++;
	
	return nn;
}

/// Hong 11/04/08 v8.0965b ADD_BACKWARD_COMPATIABLE
///Sophy 7/1/2009 MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
//int			NLFDataBase::SetData(const vector& vX, const vector& vY, const vector& vZ/* = NULL*/, int nIndex/* = 0*/, int nNumDeps/* = 1*/, int nNumIndeps/* = 1*/, int nNumTotalDataset/* = 1*/)
#ifndef	EXTEND_INTERFACES_OF_NLFITSESSION
int			NLFDataBase::SetData(const vector& vX, const vector& vY, const vector& vZ/* = NULL*/, int nIndex/* = 0*/, int nNumDeps/* = 1*/, int nNumIndeps/* = 1*/, int nNumTotalDataset/* = 1*/)
#else
int			NLFDataBase::SetData(const vector& vX, const vector& vY, const vector& vZ/* = NULL*/, int nIndex/* = 0*/, int nNumDeps/* = 1*/, int nNumIndeps/* = 1*/, int nNumTotalDataset/* = 1*/, const vector& vW/* = NULL*/)
#endif	//EXTEND_INTERFACES_OF_NLFITSESSION
///end MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
{
	// Hong, improvement, to do, try centralize two version of SetData
	if ( nIndex != 0 )
	{	// right now,  no NOT support variable dimension datas
		ASSERT(m_nNumDeps == nNumDeps);
		ASSERT(m_nNumIndeps == nNumIndeps);
		ASSERT( m_nNumDataset == nNumTotalDataset );
	}	
	m_nNumDeps = 	nNumDeps;
	m_nNumIndeps = 	nNumIndeps;				
	m_nNumDataset = nNumTotalDataset;
	
	if ( IsExceedLimitation(nIndex, nNumDeps -1, nNumIndeps - 1) )
		return -1;
	
	int		nDepIndex, nIndepIndex;
	nDepIndex = 	nIndex * m_nNumDeps;
	nIndepIndex = 	nIndex * m_nNumIndeps;			
	///Sophy 7/1/2009 MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
	//int		nn = setData(vX, vY, vZ, nIndex, nDepIndex, nIndepIndex);
#ifndef	EXTEND_INTERFACES_OF_NLFITSESSION
	int		nn = setData(vX, vY, vZ, nIndex, nDepIndex, nIndepIndex);
#else
	int		nn = setData(vX, vY, vZ, nIndex, nDepIndex, nIndepIndex, vW);
#endif	//EXTEND_INTERFACES_OF_NLFITSESSION
	///end MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
	if ( nn < 0 )
		return nn;	
		
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	/*
	for ( int ii = nDepIndex; ii < nDepIndex + nNumDeps; ii++ )
	{		
		m_pstDependentData[ii].pdData = m_pvDependentData[ii];
		m_pstDependentData[ii].nSize = m_pvDependentData[ii].GetSize();
	
		if ( 0 == m_pvWeightData[ii].GetSize() )
		{
			m_pvWeightData[ii].SetSize(m_pvDependentData[ii].GetSize());
			m_pvWeightData[ii] = 1;
		}
		///------ Folger 07/02/09 QA80-13870 MULTIPLE_SETS_GLOBAL_FITTING_WITH_WEIGHT_FAILS_SINCE_SR5
		//m_pstWeightDesc[ii].stWeightData.pdData	= m_pvWeightData[ii];
		//m_pstWeightDesc[ii].stWeightData.nSize		= m_pvWeightData[ii].GetSize();
		setOneWeightDesc(ii);
		///------ End MULTIPLE_SETS_GLOBAL_FITTING_WITH_WEIGHT_FAILS_SINCE_SR5
	}
	for ( int jj = nIndepIndex; jj < nIndepIndex + nNumIndeps; jj++ )
	{
		m_pstIndependentData[jj].pdData = m_pvIndependentData[jj];
		m_pstIndependentData[jj].nSize = m_pvIndependentData[jj].GetSize();
		///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
		if ( 0 == m_pvWeightIndepData[jj].GetSize() )
		{
			m_pvWeightIndepData[jj].SetSize(m_pvIndependentData[jj].GetSize());
			m_pvWeightIndepData[jj] = 1;
		}
		setOneWeightIndepDesc(jj);
		///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	}
	*/
	nn = updateDataWrapper(nIndex);
	if ( nn < 0 )
		return nn;
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	
	return nn;
}
/// end ADD_BACKWARD_COMPATIABLE
///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
int		NLFDataBase::SetData(const vector *pvDependentData, const vector *pvIndependentData, const vector *pvDependentWeightData, const vector *pvIndependentWeightData
						, int nNumDeps, int nNumIndeps
						, int nIndex/* = 0*/, int nNumTotalDataset/* = 1*/)
{
	// Hong, improvement, to do, try centralize two version of SetData
	if ( nIndex != 0 )
	{	// right now,  no NOT support variable dimension datas
		ASSERT(m_nNumDeps == nNumDeps);
		ASSERT(m_nNumIndeps == nNumIndeps);
		ASSERT( m_nNumDataset == nNumTotalDataset );
	}	
	m_nNumDeps = 	nNumDeps;
	m_nNumIndeps = 	nNumIndeps;				
	m_nNumDataset = nNumTotalDataset;
	
	if ( IsExceedLimitation(nIndex, nNumDeps -1, nNumIndeps - 1) )
		return -1;
	
	int		nn = setData(pvDependentData, pvIndependentData, pvDependentWeightData, pvIndependentWeightData, nIndex);
	if ( nn < 0 )
		return nn;
	
	nn = updateDataWrapper(nIndex);
	if ( nn < 0 )
		return nn;
	
	return nn;	
}

int		NLFDataBase::updateDataWrapper(int nIndex)
{
	int		nDepIndex, nIndepIndex;
	nDepIndex = 	nIndex * m_nNumDeps;
	nIndepIndex = 	nIndex * m_nNumIndeps;
	
	for ( int ii = nDepIndex; ii < nDepIndex + m_nNumDeps; ii++ )
	{		
		m_pstDependentData[ii].pdData = m_pvDependentData[ii];
		m_pstDependentData[ii].nSize = m_pvDependentData[ii].GetSize();
	
		if ( 0 == m_pvWeightData[ii].GetSize() )
		{
			m_pvWeightData[ii].SetSize(m_pvDependentData[ii].GetSize());
			m_pvWeightData[ii] = 1;
		}
		///------ Folger 07/02/09 QA80-13870 MULTIPLE_SETS_GLOBAL_FITTING_WITH_WEIGHT_FAILS_SINCE_SR5
		//m_pstWeightDesc[ii].stWeightData.pdData	= m_pvWeightData[ii];
		//m_pstWeightDesc[ii].stWeightData.nSize		= m_pvWeightData[ii].GetSize();
		setOneWeightDesc(ii);
		///------ End MULTIPLE_SETS_GLOBAL_FITTING_WITH_WEIGHT_FAILS_SINCE_SR5
	}
	for ( int jj = nIndepIndex; jj < nIndepIndex + m_nNumIndeps; jj++ )
	{
		m_pstIndependentData[jj].pdData = m_pvIndependentData[jj];
		m_pstIndependentData[jj].nSize = m_pvIndependentData[jj].GetSize();
		///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
		if ( 0 == m_pvWeightIndepData[jj].GetSize() )
		{
			m_pvWeightIndepData[jj].SetSize(m_pvIndependentData[jj].GetSize());
			m_pvWeightIndepData[jj] = 1;
		}
		setOneWeightIndepDesc(jj);
		///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	}
	
	return 1;
}
///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT

///------ Folger 08/17/10 ORG-824-P1 WEIGHTING_BROKEN_FOR_MULTIPLE_DEPS_FITTING
// bool		NLFDataBase::SetWeightData(int nWTMethod, double dWTa, double dWTb, double vdWTc, int nDataIndex) // = 0
// {
// 	if ( IsExceedLimitation(nDataIndex) )
// 		return false;
// 	
// 	m_pstWeightDesc[nDataIndex].method = nWTMethod;
// 	m_pstWeightDesc[nDataIndex].a = dWTa;
// 	m_pstWeightDesc[nDataIndex].b = dWTb;
// 	m_pstWeightDesc[nDataIndex].c = vdWTc;
// 	
// 	return true;
// }
bool		NLFDataBase::SetWeightData(int nWTMethod, double dWTa, double dWTb, double dWTc, int nDataIndex/* = 0*/, int nDep/* = 0*/)
{
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	//if ( IsExceedLimitation(nDataIndex, nDep) )
	if ( IsExceedLimitation(nDataIndex, nDep, -1) )
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
		return false;
	
	int		nIndex = nDataIndex * m_nNumDeps + nDep;
	m_pstWeightDesc[nIndex].method = nWTMethod;
	m_pstWeightDesc[nIndex].a = dWTa;
	m_pstWeightDesc[nIndex].b = dWTb;
	m_pstWeightDesc[nIndex].c = dWTc;
	
	return true;
}
///------ End WEIGHTING_BROKEN_FOR_MULTIPLE_DEPS_FITTING
///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
bool		NLFDataBase::SetWeightIndepData(int nWTMethod, double dWTa, double dWTb, double dWTc, int nDataIndex, int nIndep)
{
	if ( IsExceedLimitation(nDataIndex, -1, nIndep) )
		return false;
	
	int		nIndex = nDataIndex * m_nNumIndeps + nIndep;
	m_pstWeightIndepDesc[nIndex].method = nWTMethod;
	m_pstWeightIndepDesc[nIndex].a = dWTa;
	m_pstWeightIndepDesc[nIndex].b = dWTb;
	m_pstWeightIndepDesc[nIndex].c = dWTc;
	
	return true;
}
///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT

/// Hong 09/03/08 QA80-12130 NLFIT_SESSION_SUPPORT_SEPARATE_FIT
//PNLSFONEDATA	NLFDataBase::GetDependData()
//{
	//return m_pstDependentData;
//}
//
//PNLSFONEDATA	NLFDataBase::GetIndependData()
//{
	//return m_pstIndependentData;
//}
//
//PONEDATAWEIGHT	NLFDataBase::GetWeightData()
//{
	//return m_pstWeightDesc;
//}
PNLSFONEDATA	NLFDataBase::GetDependDatas(int nDataIndex/* = 0*/)
{
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	//if ( IsExceedLimitation(nDataIndex) )
	if ( IsExceedLimitation(nDataIndex, m_nNumDeps - 1, -1) )
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
		return NULL;
	/// Hong 12/22/08 v8.0989c FIX_MUL_DEPS_INDEPS_FAIL_CORRECT_FIT
	//return m_pstDependentData + nDataIndex;
	return m_pstDependentData + nDataIndex * m_nNumDeps;
	/// end FIX_MUL_DEPS_INDEPS_FAIL_CORRECT_FIT
}

PNLSFONEDATA	NLFDataBase::GetIndependDatas(int nDataIndex/* = 0*/)
{
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	//if ( IsExceedLimitation(nDataIndex) )
	if ( IsExceedLimitation(nDataIndex, -1, m_nNumIndeps - 1) )
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
		return NULL;
	/// Hong 12/22/08 v8.0989c FIX_MUL_DEPS_INDEPS_FAIL_CORRECT_FIT
	//return m_pstIndependentData + nDataIndex;
	return m_pstIndependentData + nDataIndex * m_nNumIndeps;
	/// end FIX_MUL_DEPS_INDEPS_FAIL_CORRECT_FIT
}

PONEDATAWEIGHT	NLFDataBase::GetWeightDatas(int nDataIndex/* = 0*/)
{
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	//if ( IsExceedLimitation(nDataIndex) )
	if ( IsExceedLimitation(nDataIndex, m_nNumDeps - 1, -1) )
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
		return NULL;
	/// Hong 12/22/08 v8.0989c FIX_MUL_DEPS_INDEPS_FAIL_CORRECT_FIT
	//return m_pstWeightDesc + nDataIndex;
	return m_pstWeightDesc + nDataIndex * m_nNumDeps;
	/// end FIX_MUL_DEPS_INDEPS_FAIL_CORRECT_FIT
}
/// end NLFIT_SESSION_SUPPORT_SEPARATE_FIT

///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
PONEDATAWEIGHT	NLFDataBase::GetWeightIndepDatas(int nDataIndex/* = 0*/)
{
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	//if ( IsExceedLimitation(nDataIndex) )
	if ( IsExceedLimitation(nDataIndex, -1, m_nNumIndeps - 1) )
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
		return NULL;
	return m_pstWeightIndepDesc + nDataIndex * m_nNumIndeps;
}
///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT

/// Hong 07/23/08 QA80-11816 AUTO_PARAMS_INIT_SUPPORT_MULTI_DEPS_MULTI_INDEPS
vector*		NLFDataBase::GetDependData(int nDataIndex, int nDepIndex) // = 0, 0
{
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	//if ( IsExceedLimitation(nDataIndex) )
		//return false;
	if ( IsExceedLimitation(nDataIndex, nDepIndex, -1) )
		return NULL;
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	
	return &m_pvDependentData[nDataIndex * m_nNumDeps + nDepIndex];	
}

vector*		NLFDataBase::GetIndependData(int nDataIndex, int nIndepIndex) // = 0, 0
{
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	//if ( IsExceedLimitation(nDataIndex) )
		//return false;
	if ( IsExceedLimitation(nDataIndex, -1, nIndepIndex) )
		return NULL;
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	
	return &m_pvIndependentData[nDataIndex * m_nNumIndeps + nIndepIndex];
}
/// end AUTO_PARAMS_INIT_SUPPORT_MULTI_DEPS_MULTI_INDEPS
	
bool		NLFDataBase::GetDependData(vector& vDependentData, int nDataIndex, int nDepIndex) // = 0, 0
{
	/// Hong 07/23/08 QA80-11816 AUTO_PARAMS_INIT_SUPPORT_MULTI_DEPS_MULTI_INDEPS
	/*
	if ( IsExceedLimitation(nDataIndex, nDepIndex) )
		return false;
	
	vDependentData = m_pvDependentData[nDataIndex * m_nNumDeps + nDepIndex];
	return true;
	*/
	vector*		pvVar;
	pvVar = GetDependData(nDataIndex, nDepIndex);
	if ( NULL == pvVar )
		return false;
	
	vDependentData = *pvVar;
	return true;	
	/// end AUTO_PARAMS_INIT_SUPPORT_MULTI_DEPS_MULTI_INDEPS
}

bool		NLFDataBase::GetIndependData(vector& vIndependentData, int nDataIndex, int nIndepIndex) // = 0, 0
{
	/// Hong 07/23/08 QA80-11816 AUTO_PARAMS_INIT_SUPPORT_MULTI_DEPS_MULTI_INDEPS
	/*
	if ( IsExceedLimitation(nDataIndex, 0, nIndepIndex) )
		return false;
	
	vIndependentData = m_pvIndependentData[nDataIndex * m_nNumIndeps + nIndepIndex];
	return true;
	*/
	vector*		pvVar;
	pvVar = GetIndependData(nDataIndex, nIndepIndex);
	if ( NULL == pvVar )
		return false;
	
	vIndependentData = *pvVar;
	return true;	
	/// end AUTO_PARAMS_INIT_SUPPORT_MULTI_DEPS_MULTI_INDEPS
}

bool		NLFDataBase::GetWeightData(vector& vWeightData, int nDataIndex) // = 0
{
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	//if ( IsExceedLimitation(nDataIndex) )
	if ( IsExceedLimitation(nDataIndex, m_nNumDeps - 1, -1) )
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
		return false;
	
	/// Hong 12/22/08 v8.0989c FIX_MUL_DEPS_INDEPS_FAIL_CORRECT_FIT
	//vWeightData = m_pvWeightData[nDataIndex];
	vWeightData = m_pvWeightData[nDataIndex * m_nNumDeps];
	/// end FIX_MUL_DEPS_INDEPS_FAIL_CORRECT_FIT
	return true;
}
///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
bool		NLFDataBase::GetWeightIndepData(vector& vWeightData, int nDataIndex) // = 0
{
	if ( IsExceedLimitation(nDataIndex, -1, m_nNumIndeps - 1) )
		return false;
	
	vWeightData = m_pvWeightIndepData[nDataIndex * m_nNumIndeps];
	return true;
}
///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT

///Sophy 1/12/2009 v8.0995c QA80-12613-P3 FIX_NLFIT_SHOW_WRONG_CUSTOMIZED_Y_MIN_MAX_ON_SURFACEFIT
//bool		NLFDataBase::GetXMinMax(double& dMin, double& dMax)
bool		NLFDataBase::GetIndepMinMax(double& dMin, double& dMax, int nDataIndex, int nIndepIndex)//0, 0
///end FIX_NLFIT_SHOW_WRONG_CUSTOMIZED_Y_MIN_MAX_ON_SURFACEFIT
{	
	vector	vData;
	///Sophy 1/12/2009 v8.0995c QA80-12613-P3 FIX_NLFIT_SHOW_WRONG_CUSTOMIZED_Y_MIN_MAX_ON_SURFACEFIT
	//if( !GetIndependData(vData) )
	if( !GetIndependData(vData, nDataIndex, nIndepIndex) )
	///end FIX_NLFIT_SHOW_WRONG_CUSTOMIZED_Y_MIN_MAX_ON_SURFACEFIT
		return false;
	
	// to find X min & max in all Xs
	vData.GetMinMax(dMin, dMax);
	return true;	
}

///Sophy 1/12/2009 v8.0995c QA80-12613-P3 FIX_NLFIT_SHOW_WRONG_CUSTOMIZED_Y_MIN_MAX_ON_SURFACEFIT
//bool		NLFDataBase::GetYMinMax(double& dMin, double& dMax)
bool		NLFDataBase::GetDepMinMax(double& dMin, double& dMax, int nDataIndex, int nDepIndex)//0, 0
///end FIX_NLFIT_SHOW_WRONG_CUSTOMIZED_Y_MIN_MAX_ON_SURFACEFIT
{	
	vector	vData;
	///Sophy 1/12/2009 v8.0995c QA80-12613-P3 FIX_NLFIT_SHOW_WRONG_CUSTOMIZED_Y_MIN_MAX_ON_SURFACEFIT
	//if( !GetDependData(vData) )
	if( !GetDependData(vData, nDataIndex, nDepIndex) )
	///endFIX_NLFIT_SHOW_WRONG_CUSTOMIZED_Y_MIN_MAX_ON_SURFACEFIT
		return false;
	
	// to find X min & max in all Xs
	vData.GetMinMax(dMin, dMax);
	return true;	
}


bool		NLFDataBase::IsAllSrcDataFromGraph()
{ 
	for(int index = 0; index < m_vnSourcePlotUIDs.GetSize(); index++)
	{
		GraphLayer gl;
		if( !get_graph_layer_by_plot_uid(gl, m_vnSourcePlotUIDs[index]) )
			return false; 
	}
	return true;
} 

DWORD		NLFDataBase::GetSourcePlotUID(int nDatasetIndex)
{ 
	DWORD dwPlotUID = 0;
	if( nDatasetIndex >= m_vnSourcePlotUIDs.GetSize() )
		return dwPlotUID;
	
	dwPlotUID = m_vnSourcePlotUIDs[nDatasetIndex];
	return dwPlotUID; 
}

bool		NLFDataBase::GetSourceGraphLayer(GraphLayer& glSource, int nDatasetIndex)
{
	return get_graph_layer_by_plot_uid( glSource, GetSourcePlotUID(nDatasetIndex) );
}

/// Iris 11/01/2008 v8.0964 NEW_PA_SUPPORT_CREATE_REPORT_GRAPH_ON_SOURCE
void		NLFDataBase::SetSourcePlotUID(int nDatasetIndex, DWORD dwPlotUID)
{
	if( nDatasetIndex >= m_vnSourcePlotUIDs.GetSize() )
		m_vnSourcePlotUIDs.SetSize(nDatasetIndex+1);
	m_vnSourcePlotUIDs[nDatasetIndex] = dwPlotUID;	
}
///end NEW_PA_SUPPORT_CREATE_REPORT_GRAPH_ON_SOURCE

//virtual
int			NLFDataBase::setData(const DataRange& drInput, DWORD dwRules, int nIndex, DWORD& dwPlotUID, int nDepIndex, int nIndepIndex, Worksheet* pwksData = NULL)
{
	/// Hong 10/17/08 QA80-10624 NLFIT_SUPPORT_FIT_SWAPPED_POLAR_PLOT
	//return drInput.GetNLFitData(dwRules, nIndex, &dwPlotUID, m_nNumDeps, m_pvDependentData + nDepIndex, m_nNumIndeps, m_pvIndependentData + nIndepIndex, m_pvWeightData + nDepIndex, pwksData);	
	vector<uint>		vnPlotUIDs;
	if ( drInput.GetPlots(vnPlotUIDs) > 0 )
	{		
		DataPlot		dp;
		dp = (DataPlot)Project.GetObject(vnPlotUIDs[0]);
		if ( dp && dp.IsPolarSwapped() )
		{
			ASSERT( 1 == vnPlotUIDs.GetSize() );
			m_nNumSwappedPolarPlot++;
		}
	}	
	/// end NLFIT_SUPPORT_FIT_SWAPPED_POLAR_PLOT
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	//return drInput.GetNLFitData(dwRules, nIndex, &dwPlotUID, m_nNumDeps, m_pvDependentData + nDepIndex, m_nNumIndeps, m_pvIndependentData + nIndepIndex, m_pvWeightData + nDepIndex, pwksData);
	return drInput.GetNLFitData(dwRules, nIndex, &dwPlotUID, m_nNumDeps, m_pvDependentData + nDepIndex, m_nNumIndeps, m_pvIndependentData + nIndepIndex, m_pvWeightData + nDepIndex, m_pvWeightIndepData + nIndepIndex, pwksData);
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
}

/// Hong 11/04/08 v8.0965b ADD_BACKWARD_COMPATIABLE
//virtual	
///Sophy 7/1/2009 MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
#ifndef	EXTEND_INTERFACES_OF_NLFITSESSION
int			NLFDataBase::setData(const vector& vX, const vector& vY, const vector& vZ, int nIndex, int nDepIndex, int nIndepIndex)
{
	ASSERT( NULL == vZ );
	*(m_pvDependentData + nDepIndex) = vY;
	*(m_pvIndependentData + nIndepIndex) = vX;
	return 1;
}
#else
int			NLFDataBase::setData(const vector& vX, const vector& vY, const vector& vZ, int nIndex, int nDepIndex, int nIndepIndex, const vector& vW)
{
	ASSERT( NULL == vZ );
	*(m_pvDependentData + nDepIndex) = vY;
	*(m_pvIndependentData + nIndepIndex) = vX;
	if ( vW != NULL )
		*(m_pvWeightData + nDepIndex) = vW;
	return 1;
}
#endif	//EXTEND_INTERFACES_OF_NLFITSESSION
///end MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
/// end ADD_BACKWARD_COMPATIABLE
///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
//virtual 
int			NLFDataBase::setData(const vector *pvDependentData, const vector *pvIndependentData, const vector *pvDependentWeightData, const vector *pvIndependentWeightData, int nIndex)
{
	int ii;
	
	for ( ii = 0; ii < m_nNumDeps; ii++ )
	{
		if ( pvDependentData )
			*(m_pvDependentData + nIndex*m_nNumDeps + ii) = *(pvDependentData + ii);
		if ( pvDependentWeightData )
			*(m_pvWeightData + nIndex*m_nNumDeps + ii) = *(pvDependentWeightData + ii);
	}
	for ( ii = 0; ii < m_nNumIndeps; ii++ )
	{
		if ( pvIndependentData )
			*(m_pvIndependentData + nIndex*m_nNumIndeps + ii) = *(pvIndependentData + ii);
		if ( pvIndependentWeightData )
			*(m_pvWeightIndepData + nIndex*m_nNumIndeps + ii) = *(pvIndependentWeightData + ii);
	}
	
	return 1;
}
///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT

void		NLFDataBase::resetSourcePlotUIDs()
{
	m_vnSourcePlotUIDs.SetSize(0);	
}
	
//#ifdef	NLF_DEBUG ///---Sim 2012-03-09 ORG-5227 FIX_CRASH_WHEN_SWITCH_FIT_FUNCTION
void		NLFDataBase::GetNumVars(int& nNumDeps, int& nNumIndeps)
{
	nNumDeps = m_nNumDeps;
	nNumIndeps = m_nNumIndeps;
}
//#endif	//NLF_DEBUG ///---Sim 2012-03-09 ORG-5227 FIX_CRASH_WHEN_SWITCH_FIT_FUNCTION

///------ Folger 07/02/09 QA80-13870 MULTIPLE_SETS_GLOBAL_FITTING_WITH_WEIGHT_FAILS_SINCE_SR5
void		NLFDataBase::setOneWeightDesc(int nIndex)
{
	/// Ugly bug, if use m_pstWeightDesc[nIndex].stWeightData directly, always NLSFONEDATA in the first m_pstWeightDesc will be returned.
	/// That makes multiple sets fitting with different weights fail.
	PONEDATAWEIGHT	pstWeightDesc = m_pstWeightDesc + nIndex;
	pstWeightDesc->stWeightData.pdData = m_pvWeightData[nIndex];
	pstWeightDesc->stWeightData.nSize = m_pvWeightData[nIndex].GetSize();
}
///------ End MULTIPLE_SETS_GLOBAL_FITTING_WITH_WEIGHT_FAILS_SINCE_SR5
///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
void		NLFDataBase::setOneWeightIndepDesc(int nIndex)
{
	PONEDATAWEIGHT	pstWeightIndepDesc = m_pstWeightIndepDesc + nIndex;
	pstWeightIndepDesc->stWeightData.pdData = m_pvWeightIndepData[nIndex];
	pstWeightIndepDesc->stWeightData.nSize = m_pvWeightIndepData[nIndex].GetSize();
}
///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT

//////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////NLFDataSingleIndep Implementation///////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
NLFDataSingleIndep::NLFDataSingleIndep()
{
	m_pvDependentData		= m_vDependentData;
	m_pvIndependentData		= m_vIndependentData;
	m_pvWeightData			= m_vWeightData;
	m_pvWeightIndepData		= m_vWeightIndepData; ///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	
	m_pstDependentData		= m_stDependentData;
	m_pstIndependentData 	= m_stIndependentData;
	m_pstWeightDesc			= m_stWeightDesc;
	m_pstWeightIndepDesc	= m_stWeightIndepDesc; ///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
}

// virtual
bool		NLFDataSingleIndep::isIndexExceedLimitation(int nIndex)
{
	return (nIndex < 0 || nIndex >= DATA_SINGLE_SET);
}

//////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////NLFDataMultiIndeps Implementation///////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
NLFDataMultiIndeps::NLFDataMultiIndeps()
{
	m_pvDependentData		= m_vDependentData;
	m_pvIndependentData		= m_vIndependentData;
	m_pvWeightData			= m_vWeightData;
	m_pvWeightIndepData		= m_vWeightIndepData; ///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	
	m_pstDependentData		= m_stDependentData;
	m_pstIndependentData 	= m_stIndependentData;
	m_pstWeightDesc			= m_stWeightDesc;
	m_pstWeightIndepDesc	= m_stWeightIndepDesc; ///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
}

// virtual
bool	NLFDataMultiIndeps::isIndexExceedLimitation(int nIndex)
{
	return (nIndex < 0 || nIndex >= MAX_DATASET_NUMBER);
}

//////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////NLFDataSurface Implementation///////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////

///------ Folger 07/28/09 QA80-14021 PREIVEW_UPDATE_IN_MATRIX_FIT_AND_SURFACE_FIT_MUCH_SLOWER_THAN_SR5
NLFDataSurface::NLFDataSurface()
{
	resetXYZRegularStatus();
	m_nFitMatRows = 0;
	m_nFitMatCols = 0;
}

/// virtual
void	NLFDataSurface::Reset()
{
	NLFDataBase::Reset();
	resetXYZRegularStatus();
}

#define			CHECK_GET_MAT_ROWS_AND_COLS(_nRows, _nCols)	\
				if ( NULL != _nRows )						\
					_nRows = m_nFitMatRows;					\
				if ( NULL != _nCols )						\
					_nCols = m_nFitMatCols;

/// virtual
bool		NLFDataSurface::CheckXYZRegularData( int& nRows, int& nCols )
{
	if ( XYZ_DATA_REGULAR_UNKNOWN != m_nXYZRegularStatus )
	{
		CHECK_GET_MAT_ROWS_AND_COLS(nRows, nCols)
		return XYZ_DATA_REGULAR_YES == m_nXYZRegularStatus;
	}
		
	vector vX, vY, vZ;
	GetIndependData( vX, 0, 0 );
	GetIndependData( vY, 0, 1 );
	GetDependData( vZ, 0, 0 );
	
	bool bRegular = false;		
	if(vX.GetSize() == vY.GetSize() && vX.GetSize() == vZ.GetSize() && vX.GetSize() != 0)
	{
		double 	dPrecision = 1E-8;
		int 	nSize = vX.GetSize();
		double 	Xmin, Ymin, Xstep, Ystep, Xmax, Ymax;
		
		int nRet = xyz_examine_data(nSize, vX, vY ,vZ, dPrecision, &nSize, &Xmin,
			&Xstep, &Xmax, &Ymin, &Ystep, &Ymax, true);	
		
		///------ Folger 09/15/2010 ORG-1055-P1 MATRIX_FITTED_CURVE_OPPOSITE_DIMENSION_WHEN_SAME_AS_INPUT_DATA
		//m_nFitMatRows = Xstep > 0 ? (int)((Xmax - Xmin) / Xstep + 0.5) + 1 : 1; 
		//m_nFitMatCols = Ystep > 0 ? (int)((Ymax - Ymin) / Ystep + 0.5) + 1 : 1; 
		m_nFitMatCols = Xstep > 0 ? (int)((Xmax - Xmin) / Xstep + 0.5) + 1 : 1; 
		m_nFitMatRows = Ystep > 0 ? (int)((Ymax - Ymin) / Ystep + 0.5) + 1 : 1; 
		///------ End MATRIX_FITTED_CURVE_OPPOSITE_DIMENSION_WHEN_SAME_AS_INPUT_DATA
		CHECK_GET_MAT_ROWS_AND_COLS(nRows, nCols)
		if(Examine_XYZ_Regular == nRet)
			bRegular = true;
	}
	
	m_nXYZRegularStatus = bRegular ? XYZ_DATA_REGULAR_YES : XYZ_DATA_REGULAR_NO;
	
	return bRegular;
}
///------ End PREIVEW_UPDATE_IN_MATRIX_FIT_AND_SURFACE_FIT_MUCH_SLOWER_THAN_SR5

//virtual
int			NLFDataSurface::setData(const DataRange& drInput, DWORD dwRules, int nIndex, DWORD& dwPlotUID, int nDepIndex, int nIndepIndex, Worksheet* pwksData)
{	
	ASSERT(1 == m_nNumDeps);
	ASSERT(2 == m_nNumIndeps);
	return drInput.GetData(dwRules, nIndex, &dwPlotUID, NULL, m_pvDependentData + nDepIndex, m_pvIndependentData + nIndepIndex, NULL, NULL, NULL, NULL, NULL, NULL, m_pvIndependentData + nIndepIndex + 1);	
}

/// Hong 11/04/08 v8.0965b ADD_BACKWARD_COMPATIABLE
//virtual	
///Sophy 7/1/2009 MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
//int			NLFDataSurface::setData(const vector& vX, const vector& vY, const vector& vZ, int nIndex, int nDepIndex, int nIndepIndex)
#ifndef	EXTEND_INTERFACES_OF_NLFITSESSION
int			NLFDataSurface::setData(const vector& vX, const vector& vY, const vector& vZ, int nIndex, int nDepIndex, int nIndepIndex)
#else
int			NLFDataSurface::setData(const vector& vX, const vector& vY, const vector& vZ, int nIndex, int nDepIndex, int nIndepIndex, const vector& vW)
#endif	//EXTEND_INTERFACES_OF_NLFITSESSION
///end MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
{
	ASSERT( NULL != vZ );
	*(m_pvDependentData + nDepIndex) = vZ;
	*(m_pvIndependentData + nIndepIndex) = vX;
	*(m_pvIndependentData + nIndepIndex + 1) = vY;
	return 1;
}
/// end ADD_BACKWARD_COMPATIABLE

//////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////NLFDataMatrix Implementation////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
/// Hong 08/14/08 v8.0922 FIX_MATRIX_FIT_FAIL_DO_REDUCE
//virtual
bool		NLFDataMatrix::GetDimention(int nDatasetIndex, int& nNumRows, int& nNumCols)
{
	///---Sim 2011-11-29 ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
	//if ( IsExceedLimitation(nDatasetIndex) )
	if ( IsExceedLimitation(nDatasetIndex, m_nNumDeps -1, m_nNumIndeps - 1) )
	///---END ORG-3379 ODR_NLFIT_SUPPORT_INDEP_WEIGHT
		return false;
	
	ASSERT(nDatasetIndex < m_vnRows.GetSize());
	nNumRows = m_vnRows[nDatasetIndex];
	nNumCols = m_vnCols[nDatasetIndex];
	return true;
}

//virtual
int			NLFDataMatrix::setData(const DataRange& drInput, DWORD dwRules, int nIndex, DWORD& dwPlotUID, int nDepIndex, int nIndepIndex, Worksheet* pwksData)
{
	/// Iris 4/25/2012 ORG-5473-P1 NO_NEED_CHECK_XYZ_REGULAR_FOR_SAME_AS_INPUT_DATA_FOR_MATRIX_FIT
	dwRules |= DRR_GET_MISSING;
	///End NO_NEED_CHECK_XYZ_REGULAR_FOR_SAME_AS_INPUT_DATA_FOR_MATRIX_FIT
	
	int			nRet = NLFDataSurface::setData(drInput, dwRules, nIndex, dwPlotUID, nDepIndex, nIndepIndex, pwksData);
	if ( nRet < 0 )
		return nRet;
	
	matrix 		mat;
	int			nn = drInput.GetData(mat);
	ASSERT(nn > 0);
	if ( nIndex >= m_vnRows.GetSize() )
	{
		m_vnRows.SetSize(nIndex + 1);
		m_vnCols.SetSize(m_vnRows.GetSize());
	}	
	m_vnRows[nIndex] = mat.GetNumRows();
	m_vnCols[nIndex] = mat.GetNumCols();
	
	return nRet;
}
/// end FIX_MATRIX_FIT_FAIL_DO_REDUCE

/// Iris 4/25/2012 ORG-5473-P1 NO_NEED_CHECK_XYZ_REGULAR_FOR_SAME_AS_INPUT_DATA_FOR_MATRIX_FIT
// virtual
bool		NLFDataMatrix::CheckXYZRegularData( int& nRows, int& nCols )
{		
	return true; // no need check XYZ regular, so always return true
}
///End NO_NEED_CHECK_XYZ_REGULAR_FOR_SAME_AS_INPUT_DATA_FOR_MATRIX_FIT

///------ Folger 12/31/2011 ORG-4454 REFACTOR_NLFITSESSION
#define	STR_CONCATENATE_COL_DESIGNATIONS	"XYEXYE"

class NLFRangeHolder
{
public:
	NLFRangeHolder()
	{
		///---Sim 2011-11-29 ORG-4454 ODR_NLFIT_SUPPORT_MULTI_VAR_FOR_IMPLICIT_FUNC
		m_nNumIndeps = 1;
		m_nNumDeps = 1;
		///---END ORG-4454 ODR_NLFIT_SUPPORT_MULTI_VAR_FOR_IMPLICIT_FUNC
	}
	~NLFRangeHolder()
	{
		if ( m_wksConcatenate )
			m_wksConcatenate.Destroy();
	}

public:
	void					SetAveType(int nType)					{ m_nAveType = nType; }
	void					PrepareConcatenateDataRange()
	{
		if( !m_wksConcatenate.IsValid() )
		{
			m_wksConcatenate.Create(NULL, CREATE_HIDDEN | CREATE_SET_MISSING_IN_MANAGER);
			m_wksConcatenate.SetSize(-1, COL_CONCATENATE_COUNT); // ConcatenateX, ConcatenateY, AveX, AveY, AveYErr, if average type is raw data, only first two columns have data
			m_wksConcatenate.SetColDesignations(STR_CONCATENATE_COL_DESIGNATIONS);
		}
		
		if(m_drConcatenateSrcData.IsValid())
			m_drConcatenateSrcData.Reset();
		m_drConcatenateSrcData.Add("X", m_wksConcatenate, 0, COL_CONCATENATE_X , -1, COL_CONCATENATE_X);
		m_drConcatenateSrcData.Add("Y", m_wksConcatenate, 0, COL_CONCATENATE_Y , -1,COL_CONCATENATE_Y);
		m_drConcatenateSrcData.Add("ED", m_wksConcatenate, 0, COL_CONCATENATE_YERR , -1, COL_CONCATENATE_YERR);
		m_wksConcatenate.Columns( COL_CONCATENATE_Y ).SetLongName(_L("Concatenated Data"));//(_L("Concatenate data"));
		
		if( !IsAveSrcData() )
		{		
			while(m_wksConcatenate.GetNumCols() < COL_CONCATENATE_COUNT)
				m_wksConcatenate.AddCol();
			m_wksConcatenate.SetColDesignations(STR_CONCATENATE_COL_DESIGNATIONS);
			
			if(m_drAveData.IsValid())
				m_drAveData.Reset();
			m_drAveData.Add("X", m_wksConcatenate, 0, COL_AVE_X , -1, COL_AVE_X);
			m_drAveData.Add("Y", m_wksConcatenate, 0, COL_AVE_Y , -1, COL_AVE_Y);
			m_drAveData.Add("ED", m_wksConcatenate, 0, COL_AVE_YERR , -1, COL_AVE_YERR);
			
			string strAveLegend = m_nAveType == PLOT_TYPE_MEAN_SE ? _L("Mean, SE") : _L("Mean, SD");
			m_wksConcatenate.Columns( COL_AVE_Y ).SetLongName(strAveLegend);
		}
		else
		{
			while(m_wksConcatenate.GetNumCols() > COL_CONCATENATE_YERR + 1)
				m_wksConcatenate.DeleteCol(m_wksConcatenate.GetNumCols() - 1);
		}
	}
	BOOL					CalcConcatenateAveData(DWORD dwRules)
	{
		int		nNumData = m_drSrcData.GetNumData(dwRules);
		if(nNumData <= 0)
			return error_report("no input data in NLFitSession::calcConcatenateAveData");
		
		DWORD	dwPlotID;
		vector 	vConcatenateX, vConcatenateY;
		vector	vConcatenateWeight; 
		m_drSrcData.GetNLFitData( DRR_COMBINED_SIMPLE | DRR_GET_DEPENDENT, 0, &dwPlotID, 1, &vConcatenateY, 1, &vConcatenateX, &vConcatenateWeight );
		
		
		ASSERT(m_drConcatenateSrcData); // should already prepare this data range in prepareConcatenateDataRange
		m_drConcatenateSrcData.SetData(&vConcatenateY, &vConcatenateX);
		/// Iris 2/13/2012 ORG-3911-P1 FIX_FIT_CURVE_DATA_NOT_FOLLOW_SOURCE_GRAPH_SCALE_TYPE_FOR_CONCATENATE_MODE
		m_drConcatenateSrcData.SetPlotUID(dwPlotID, 0);
		///End FIX_FIT_CURVE_DATA_NOT_FOLLOW_SOURCE_GRAPH_SCALE_TYPE_FOR_CONCATENATE_MODE
		Dataset dsErr(m_wksConcatenate.Columns(COL_CONCATENATE_YERR));
		dsErr = vConcatenateWeight;		
		
		if( !IsAveSrcData() )
		{
			ASSERT(m_drAveData); // should already prepare this data range in prepareConcatenateDataRange
			
			vector 	vAveX, vAveY, vAveErr;
			int		nAveSize = vConcatenateX.GetSize(); // ave size can be modified
			if(!nlsf_calc_ave_data(vConcatenateX, vConcatenateY, nAveSize, vAveX, vAveY, vAveErr, m_nAveType))
				return error_report("Fail to calculate ave data in NLFitSession::calcConcatenateAveData");
			
			m_drAveData.SetData(&vAveY, &vAveX);
			Dataset ds(m_wksConcatenate.Columns(COL_AVE_YERR));
			ds = vAveErr;			
		}	
		
		return true;
	}

	BOOL					GetSrcSubDataRange(DataRange& drSub, int nDatasetIndex = 0, int iDep = 0, int iIndep = 0)
	{
		if( IsConcatenateSrcData() )
		{
			drSub = IsAveSrcData() ? m_drConcatenateSrcData : m_drAveData;
			return TRUE;
		}
		
		///---Sim 2011-11-29 ORG-4454 ODR_NLFIT_SUPPORT_MULTI_VAR_FOR_IMPLICIT_FUNC
		if ( m_nNumDeps <= 0 ) // implicit function
		{
			DataRange drOneData;
			if ( !m_drSrcData.GetSubRange(drOneData, DRR_ONE_DEP_MULTIINDEP | DRR_NO_FACTORS, nDatasetIndex) || !drOneData || !drOneData.IsValid() )
				return error_report("fail to get sub data range in NLFDataBase::GetSrcSubDataRange");
			if ( !convert_datarange_type_from_xx_to_xy(drOneData, drSub) )
				return error_report("only support 2D or 3D implicit function plots");
			
			return TRUE;			
		}
		///---END ORG-4454 ODR_NLFIT_SUPPORT_MULTI_VAR_FOR_IMPLICIT_FUNC
		
		if ( !m_drSrcData.GetNLFitSubRange(drSub, DRR_NLFIT, nDatasetIndex, iDep, iIndep) || !drSub )
			return error_report("fail to get sub data range in NLFDataBase::GetSrcSubDataRange");
		
		return TRUE;
	}
	
	///---Sim 2011-11-29 ORG-4454 ODR_NLFIT_SUPPORT_MULTI_VAR_FOR_IMPLICIT_FUNC
	void					SetNumVars(int nNumIndeps, int nNumDeps)
	{
		m_nNumIndeps = nNumIndeps;
		m_nNumDeps = nNumDeps;
	}
	///---END ORG-4454 ODR_NLFIT_SUPPORT_MULTI_VAR_FOR_IMPLICIT_FUNC
	
	void					SetConcatenateSrcData(BOOL bOn)			{ O_SET_BIT(m_dwCntrl, NLFRANGECNTRL_CONCATENATESRCDATA, bOn); }
	BOOL					IsConcatenateSrcData()					{ return O_QUERY_BOOL(m_dwCntrl, NLFRANGECNTRL_CONCATENATESRCDATA); }	
	
	DataRange&				GetSrcDataRange()						{ return m_drSrcData; }
	DataRange				GetConcatenateDataRange()				{ return m_drConcatenateSrcData; }

private:
	int						m_nAveType;
	DataRange				m_drSrcData;
	DataRange				m_drConcatenateSrcData;
	DataRange				m_drAveData;
	Worksheet				m_wksConcatenate;
	
	///---Sim 2011-11-29 ORG-4454 ODR_NLFIT_SUPPORT_MULTI_VAR_FOR_IMPLICIT_FUNC
	int						m_nNumIndeps;
	int						m_nNumDeps;
	///---END ORG-4454 ODR_NLFIT_SUPPORT_MULTI_VAR_FOR_IMPLICIT_FUNC
	
	BYTE					m_dwCntrl;
	enum
	{
		NLFRANGECNTRL_CONCATENATESRCDATA				= 0x00000001,
	};
	
	BOOL					IsAveSrcData()							{ return PLOT_TYPE_RAW_DATA == m_nAveType; }
};
///------ End REFACTOR_NLFITSESSION

#endif //_NLF_DATA_H_

