/*------------------------------------------------------------------------------*
 * File Name: MultiPaneDlg.h													*
 * Creation: CPY 2/20/2004														*
 * Purpose: Origin C for base dialog class with button to open lower panel		*
 * to be used in any dialog	that needs multipane with button to open/close		*
 * Copyright (c) OriginLab Corp.2004											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Danice 3/31/04 ARRANGE_BOTTOM_BUTTON_FROM_LEFT_TO_RIGHT						*
 * Danice 5/10/04 V8.0869 SUPPORT_BOTTOM_BUTTON_RESIZE							*
 * Frank  5/26/04 V8.0876 INIT_BUTTOM_DIALOG_HIGHT_FIRST_TIME					*
 *	CPY 5/26/04 v7.5878 BOTTOM_PANE_OPEN_BUT_SIZE_ZERO							*
 * Danice 9/27/04 v8.0140 NEW_WAY_SHOW_TOP_AND_BOTTOM_PANE						*
 * Danice 10/13/04 QA70-7012 v8.0147 NLFIT_NEEDED_MINI_DIALOG					*
 * Danice 10/25/04 v8.0154 SAVE_TOP_PANE_HEIGHT									*
 * Danice 11/11/04 v8.0162 DLG_SIZE_CONSIGER_RIGHT_BOTTOM_BTN					*
 * Danice 11/18/04 v8.0164 ARRANGE_TWO_SHOW_PANE_BUTTON_NEW_WAY					*
 *	CPY 1/15/05 XF_DLG_CODE_CLEANUP												*
 *	Frank 4/1/05	RISIZEDIG_SAVE_DLG_NAME_ON_INIT								*
 *  DG 4/2/05 v8.0214 LOAD_SETTING_SHOULD_PASS_DLG_NAME							*
 *	CPY 4/3/06 SMOOTH_XF_PREVIEW_TOO_BIG										*
 *	CPY 9/24/06 XF_PREVIEW_DLG_NEED_PREVIEW_ON_THE_SIDE							*
 *	Jasmine 10/25/06 REMEMBER_TOP_PANE_SIZE										*
 *	Jasmine 11/21/06 FIX_TREE_PANE_FAIL_TO_DISPLAY								*
 *	Jasmine 11/22/06 FIX_TOP_PANE_HEIGHT_REDUCE_BUG								*
 *	TD ML 1-29-07 QA70-9327 FFT_DLG_SIZE_FORGOTTEN								*
 *	Jasmine 04/20/07 OPTION_HIDDEN_BUTTON_NOT_IN_CAL							*
 *  Iris 07/03/2007 v8.0654 FIX_ONE_BOX_FLASH_WHEN_CLICK_FORMULA_TAB_IN_NLSF_DLG*
 *	Folger Sim 11/02/07 FIX_MULTIPANE_DIALOG_RESIZE								*
 *	Folger 11/28/07 FIX_BUG_ON_REPOSITION_WHEN_RESIZE_DIALOG					*
 *	Jasmine 05/09/08 3_EDGE_IF_BOTH_TOP_BOTTOM_PANE_SHOW						*
 *	Folger 05/19/08 FIX_MULTIPANE_DIALOG_RESIZE_ERROR_WHEN_MINIMIZE_THEN_REOPEN	*
 *	Kyle 03/15/2010 QA80-15152 FIX_MAIN_CONTROL_IS_MISSING_AFTER_CLOSING_A_MINIMIZED_DIALOGUE
 *  Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE						*
 *	Folger 10/14/2010 ORG-1252 MULTIPANE_DIALOG_BAD_LAYOUT_IF_INVALID_PANE_HEIGHT_IN_REGISTRY
 *  Iris 1/12/2010 ORG-1826-P8 FIX_NOT_REMEMBER_LEFT_PANE_WIDTH					*
 *	Kenny 11/22/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG	*
 *	Kenny 11/24/2011 ORG-4404-P2 MULTI_PANE_COLLAPSE_INCORRECT_WINDOW_SIZE		*
 *  Iris 11/25/2011 ORG-4457-P1 FIX_SHOW_TOP_PANE_BUTTON_BUG					*
 *	Zech 12/27/2011 ORG-4657-S1 IMPROVE_RESIZE_PANE_BY_EDGE_FOR_MULTIPANEDLG	*
 *  Iris 3/23/2012 ORG-4457-P3 NEED_BETTER_FIX_TO_ARRANGE_NLFIT_BUTTONS			*
 *	Zech 08/09/2012 ORG-6255-S6 CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG		*
 *------------------------------------------------------------------------------*/

#ifndef _MULTI_PANE_DLG
#define _MULTI_PANE_DLG

#define WM_USER_ON_MOVE_LINE			(WM_USER + 1020)
#define WM_USER_ON_SET_TAB_TITLES		(WM_USER + 1021)

#define MIN_TOP_PANE_HEIGHT				150
#define MIN_BOTTOM_PANE_HEIGHT			80

enum
{
	SUBPANE_POS_BOTTOM,
	SUBPANE_POS_RIGHT,
	SUBPANE_POS_TOP,
	SUBPANE_POS_LEFT
};

///------ Folger 10/14/2010 ORG-1252 MULTIPANE_DIALOG_BAD_LAYOUT_IF_INVALID_PANE_HEIGHT_IN_REGISTRY
enum
{
	MULTIPANEDLGINIT_RESET_PANE_SIZE_IF_TOO_SMALL			= 0x00010000,
};
///------ End MULTIPANE_DIALOG_BAD_LAYOUT_IF_INVALID_PANE_HEIGHT_IN_REGISTRY

class MultiPaneDlg : public ResizeDialog
{
public:	//CPY 9/24/06 XF_PREVIEW_DLG_NEED_PREVIEW_ON_THE_SIDE added bBottomPaneOnTheSide
	/// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
	/*
	MultiPaneDlg(UINT nDlgID, LPCSTR lpcszDLL, BOOL bBottomPaneOnTheSide = false) : ResizeDialog( nDlgID, lpcszDLL )
	{
		m_bBottomPaneOnRight = bBottomPaneOnTheSide;
	}
	*/
	MultiPaneDlg(UINT nDlgID, LPCSTR lpcszDLL, int nSubPanePosition = SUBPANE_POS_BOTTOM) : ResizeDialog( nDlgID, lpcszDLL )
	{
		m_bBottomPaneOnRight = (SUBPANE_POS_RIGHT == nSubPanePosition);
		m_nSubPanePosition = nSubPanePosition;
	}
	///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
	///Joseph 1-30-07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	bool	GetPreviewOnRight()
	{
		return m_bBottomPaneOnRight;
	}
	///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	/// Iris 6/17/2009 QA80-13771 FILTER_GRAPH_FUNCTION_SUPPORT
	void	SetPreviewOnRight(bool bSet = true)
	{
		m_bBottomPaneOnRight = bSet;
	}
	///end FILTER_GRAPH_FUNCTION_SUPPORT
	
	/// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
	void SetSubPaneRightButtonIDs(const vector<uint>& vnButtonIDs)
	{
		m_vnSubPaneRightButtonIDs = vnButtonIDs;		
	}
	///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE	
protected:
	int		GetBottomPaneHeight(int nCheckMin = 10) 
	{
		if(nCheckMin > 0 && m_nBottomPaneHeight < nCheckMin)
			//m_nBottomPaneHeight = 150;	///DG 8/19/05 : bottom pane take top pane size, the first time dialog open, bottom is so large that no place for up-down buttom 
			m_nBottomPaneHeight = MIN_BOTTOM_PANE_HEIGHT;//80;
		return m_nBottomPaneHeight;
	}
	void	SetBottomPaneHeight(int ny) {m_nBottomPaneHeight = ny;}
	virtual int GetTopPaneMainID() { return m_nMainID;}
	/// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
	virtual int GetMainPaneControlIDs(vector<uint>& vnIDs) { return 0; }
	///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
	///Danice NLFIT_NEEDED_MINI_DIALOG
	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//int		GetTotalHeight(bool bMin = false)
	//{
	//	if(bMin)
	//	{
	int		GetMinClientTrackHeight()
	{
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
			//--- CPY 10/14/04 RUNTIME_ERR_ON_STARTUP_GET_MINMAX
			if(m_vnButtonIDs.GetSize() == 0)
				return GetMinTopPaneHeight();
			//---
			//------ Folger Sim 11/02/07 FIX_MULTIPANE_DIALOG_RESIZE
			/*
			RECT r1;
			int nEdge = GetControlGap();
			Button btn1 = GetItem(m_vnButtonIDs[0]);
			//btn1.GetWindowRect(&r1);
			GetClientRect(btn1, r1); //---- CPY 3/20/05 QA70-7459 CENTRALIZED_MOVE_CONTROL_WITH_BETTER_REDRAW

			int nHeight=RECT_HEIGHT(r1);
			if(!m_bBottomPaneOnRight && IsBottomPaneShown())
				nHeight+=GetMinTopPaneHeight();
			if(IsTopPaneShown())
				nHeight+=GetMinBottomPaneHeight();
			return  nHeight+2*nEdge;	//dialog minimums height
			*/
			
			int nEdge = GetControlGap();
			
			/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
			//int nHeight = GetWindowTitleHeight();
			int nHeight = 0;
			/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
			/// Kenny 11/25/2011 ORG-4404-P2 MULTI_PANE_COLLAPSE_INCORRECT_WINDOW_SIZE
			//nHeight += GetAllShowButtonHeight() + 2 * nEdge;
			UINT nPaneCount = 0;
			int nBtnsHeight = GetAllShowButtonHeight();
			if (nBtnsHeight > 0)
				++nPaneCount;
			nHeight += nBtnsHeight;
			/// End MULTI_PANE_COLLAPSE_INCORRECT_WINDOW_SIZE		
			
			if ( IsTopPaneShown() )
			{
				if ( IsBottomPaneShown() && !m_bBottomPaneOnRight )
					// when both top and bottom pane show, only bottom pane will be resize
					nHeight+=GetExactTopPaneHeight();
				else
					nHeight+=GetMinTopPaneHeight();
				/// Kenny 11/25/2011 ORG-4404-P2 MULTI_PANE_COLLAPSE_INCORRECT_WINDOW_SIZE
				//nHeight += 2*nEdge;
				++nPaneCount;
				/// End MULTI_PANE_COLLAPSE_INCORRECT_WINDOW_SIZE
			}
			
			if ( IsBottomPaneShown() )
			{
				/// Kenny 11/25/2011 ORG-4404-P2 MULTI_PANE_COLLAPSE_INCORRECT_WINDOW_SIZE
				//nHeight+=GetMinBottomPaneHeight() + 2*nEdge;
				nHeight += GetMinBottomPaneHeight();
				++nPaneCount;
				/// End MULTI_PANE_COLLAPSE_INCORRECT_WINDOW_SIZE
			}
			///Jasmine 05/09/08 3_EDGE_IF_BOTH_TOP_BOTTOM_PANE_SHOW
			/// Kenny 11/25/2011 ORG-4404-P2 MULTI_PANE_COLLAPSE_INCORRECT_WINDOW_SIZE
			//if(IsTopPaneShown() && IsBottomPaneShown())
			//	nHeight -= nEdge; 
			nHeight += (nPaneCount + 1) * nEdge;
			/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
			//nHeight += GetSystemMetrics(SM_CYSIZEFRAME);
			/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
			/// End MULTI_PANE_COLLAPSE_INCORRECT_WINDOW_SIZE
			///End 3_EDGE_IF_BOTH_TOP_BOTTOM_PANE_SHOW
			return nHeight;
			//------ End FIX_MULTIPANE_DIALOG_RESIZE
		/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//}
		//else
		//	return ResizeDialog::GetTotalHeight(bMin);
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	}
	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//int		GetTotalWidth(bool bGetMin = false)
	//{
	//	if(bGetMin)
	//	{
	int		GetMinClientTrackWidth()
	{
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
			//--- CPY 10/14/04 RUNTIME_ERR_ON_STARTUP_GET_MINMAX
			//if(0 > m_vnButtonIDs.GetSize())
			//	return 0;
			if(m_vnButtonIDs.GetSize() == 0)
				return 100;
			//---
			
			RECT r1, r2;
			int nEdge = GetControlGap();
			Button Leftbtn1 = GetItem(m_vnButtonIDs[0]);
			Button Rightbtn1=GetItem(m_vnUpdownButtonIDs[0]);
			//Leftbtn1.GetWindowRect(&r1);
			//Rightbtn1.GetWindowRect(&r2);
			GetClientRect(Leftbtn1, r1); //---- CPY 3/20/05 QA70-7459 CENTRALIZED_MOVE_CONTROL_WITH_BETTER_REDRAW
			GetClientRect(Rightbtn1, r2); //---- CPY 3/20/05 QA70-7459 CENTRALIZED_MOVE_CONTROL_WITH_BETTER_REDRAW

			int nLeftBtnWidth=RECT_WIDTH(r1), nRightBtnWidth=RECT_WIDTH(r2);
			int nNumLeftBtn = m_vnButtonIDs.GetSize()-1,nNumRightBtn=m_vnUpdownButtonIDs.GetSize()-1;
			///Joseph 12/11/06 ADD_BITMAP_BUTTON
			//int nWidthMain = nEdge+(nLeftBtnWidth+nEdge)*nNumLeftBtn+(nRightBtnWidth+nEdge)*nNumRightBtn;
			int nButtonGap, nGroupGap, nWidthMain;
			vector<int> vnGroupButtonWidth, vnButtonGroupSize;
			if(!GetButtonAndGroupInfo(nButtonGap, nGroupGap, vnGroupButtonWidth, vnButtonGroupSize))
				return 100;
			int nGroupNum = vnButtonGroupSize.GetSize();
			nWidthMain = nButtonGap+(nRightBtnWidth+nEdge)*nNumRightBtn;
			if(nGroupNum > 1)
			{
				for(int ii = 0; ii<nGroupNum; ii++)
				{
					nWidthMain = nWidthMain + vnButtonGroupSize[ii] * (vnGroupButtonWidth[ii] + nButtonGap) + nGroupGap;
				}
				nWidthMain -= nGroupGap;
			}
			else
				nWidthMain = nWidthMain + (nLeftBtnWidth+nButtonGap)*nNumLeftBtn;			///End	ADD_BITMAP_BUTTON
			///End ADD_BITMAP_BUTTON
			if(m_bBottomPaneOnRight && IsBottomPaneShown())
				return GetMinTopPaneHeight() + nWidthMain;
			return nWidthMain;
		/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//}
		//else
		//	return ResizeDialog::GetTotalWidth(bGetMin);
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	}
	virtual int GetMinTopPaneHeight() { return MIN_TOP_PANE_HEIGHT;}//150
	virtual int GetMinBottomPaneHeight() { return MIN_BOTTOM_PANE_HEIGHT;}//150
	///end
	
	//------ Folger Sim 11/02/07 FIX_MULTIPANE_DIALOG_RESIZE
	int GetExactTopPaneHeight()
	{
		//Control ctrl = GetItem(m_nMainID);
		//if(ctrl)
		//{
			//RECT rr;
			//GetClientRect(ctrl, rr);
			//return rr.bottom + 1;
		//}
		//
		//return 0;
		return m_nTopPaneHeight;
	}
	
	int GetAllShowButtonHeight()
	{
		int nHeight = 0;
		for (int ii=0; ii<m_vnUpdownButtonIDs.GetSize(); ii++)
		{
			if ( 0 == m_vnUpdownButtonIDs[ii] )
				break;
			
			Control ctrl;
			RECT rr;
			if ( GetControlClientRect(m_vnUpdownButtonIDs[ii], rr, ctrl))
				nHeight += RECT_HEIGHT(rr);
		}
		return nHeight;
	}
	//------ END FIX_MULTIPANE_DIALOG_RESIZE
	
	void	DisableBottomPane() 
	{
		m_chkShowViewBottomPane.Visible = false;
		m_chkShowViewBottomPane.Check  = false;
	}
	void	EnableBottomPane()
	{
		m_chkShowViewBottomPane.Visible = true;
		//m_chkShowViewBottomPane.Check  = true;
	}
	virtual BOOL OnShowBottomPane(Control cntrl)
	{
		SetInitReady(false);
		UpdateDlgSize();
		SetInitReady();
		return TRUE;
	}
	//----- CPY 1/15/05 XF_DLG_CODE_CLEANUP
	virtual int UpdateBottomPaneSubControls()
	{
		HideBottomPaneSubControls();	//hide then show to force refresh
		vector<uint> vnCntrls;
		int nSelTab = GetBottomPaneSubControls(vnCntrls);
		if(m_BottomTab)
		{
			//---- CPY 10/5/06 we need to first hide all, then show the selected on
			for(int ii = 0; ii < vnCntrls.GetSize(); ii++)
			{
				Control temp = GetItem(vnCntrls[ii]);
				if(temp)
					temp.Visible = false;
			}
			//----
			RECT rTab;
			//m_BottomTab.GetWindowRect(&rTab);
			//ScreenToClient(&rTab);
			GetClientRect(m_BottomTab, rTab); //---- CPY 3/20/05 QA70-7459 CENTRALIZED_MOVE_CONTROL_WITH_BETTER_REDRAW
			m_BottomTab.AdjustRect(FALSE, &rTab);
		if(nSelTab < vnCntrls.GetSize())
			{
				int nID = vnCntrls[nSelTab];
				if(nID)
				{
					Control ctrl  = GetItem(nID);
					if(ctrl)
					{
						/// Iris 07/03/2007 v8.0654 FIX_ONE_BOX_FLASH_WHEN_CLICK_FORMULA_TAB_IN_NLSF_DLG
						// should move tab to propriety place firstly, and then show it; else will see tab show in incorrect place as a flash.
						/*
						ctrl.Visible=true;
						//ctrl.MoveWindow(&rTab);
						MoveControl(ctrl, rTab);//---- CPY 3/20/05 QA70-7459 CENTRALIZED_MOVE_CONTROL_WITH_BETTER_REDRAW
						*/
						MoveControl(ctrl, rTab);
						ctrl.Visible=true;
						///end FIX_ONE_BOX_FLASH_WHEN_CLICK_FORMULA_TAB_IN_NLSF_DLG
						
					}
				}
			}
			else
				error_report("UpdateBottomPaneSubControls found Invalid nSelTab");
		}
		m_nActiveTab = nSelTab;	///Sophy 7/13/2012 ORG-6207-S2 GETNPREVIEW_DLG_NEED_REMEMBER_ACTIVE_TAB_WHEN_REOPEN
		return nSelTab;
	}	
	virtual void HideBottomPaneSubControls()
	{
		vector<uint> vnBottomSubControls;
		if(GetBottomPaneSubControls(vnBottomSubControls) >= 0)
		{
			vnBottomSubControls.Add(0); // ShowControls needed zero termination
			ShowControls(vnBottomSubControls, false);
		}
	}
	virtual int GetBottomPaneSubControls(vector<uint>& vnCntrls) {return -1;}
	//----- end XF_DLG_CODE_CLEANUP
	void UpdateDlgSize()
	{
		if(0 == GetTopPaneMainID())
			return;
		
		if(IsBottomPaneShown())
		{
			if(m_nBottomMainID)
			{
				Control	cntlBottom = GetItem(m_nBottomMainID);
				cntlBottom.Visible = true;
				if(m_bBottomPaneOnRight) // sub pane on right
				{
					/// TD ML 1-29-07 QA70-9327 FFT_DLG_SIZE_FORGOTTEN
					if(m_bResizeFirstTime)
						MoveControlToRightBottom(m_vnUpdownButtonIDs[BOTTOM_PANE], 0, m_nTopPaneHeight + 2 * GetControlGap());	///Jasmine 05/22/07 TO_GET_CORRECT_TOP_PANE_HEIGHT
					ResizeDlgToRightOfControl(m_vnUpdownButtonIDs[BOTTOM_PANE]);
					/// end FFT_DLG_SIZE_FORGOTTEN
					MoveControlToRight(m_nBottomMainID, m_vnUpdownButtonIDs[BOTTOM_PANE],  GetBottomPaneHeight());
					ResizeDlgToRightOfControl(m_nBottomMainID);
				}
				/// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
				//else
				else if ( SUBPANE_POS_BOTTOM == m_nSubPanePosition )
				///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
				{
					///Jasmine 10/25/06 REMEMBER_TOP_PANE_SIZE
					///Jasmine 05/22/07 TO_GET_CORRECT_TOP_PANE_HEIGHT
					RECT rr;
					Control btn = GetItem(m_vnUpdownButtonIDs[BOTTOM_PANE]);
					if(btn)
						GetClientRect(btn, rr);
					if(m_bResizeFirstTime)
						MoveControlToRightBottom(m_vnUpdownButtonIDs[BOTTOM_PANE], m_nTopPaneHeight + 3 * GetControlGap() + RECT_HEIGHT(rr));
					///End TO_GET_CORRECT_TOP_PANE_HEIGHT
					#ifndef __PA_FLICKER_FREE		/// Kenny 11/22/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
					ResizeDlgToBottomOfControl(m_vnUpdownButtonIDs[BOTTOM_PANE]);
					#endif // __PA_FLICKER_FREE		/// Kenny 11/22/2011 ORG-4177-P1 REDUCE_FLICKERING_WHEN_RESIZING_PA_WIZARD_DLG
					///End REMEMBER_TOP_PANE_SIZE
					MoveControlToBottom(m_nBottomMainID, m_vnUpdownButtonIDs[BOTTOM_PANE],  GetBottomPaneHeight());
					ResizeDlgToBottomOfControl(m_nBottomMainID);
				}
				/// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
				else if( SUBPANE_POS_LEFT == m_nSubPanePosition )
				{					
					resizeDlgOnLeftPaneShowHide(IsBottomPaneShown());
				}
				else
				{
					ASSERT(false);
				}
				///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
			}
			UpdateBottomPaneSubControls();
		}
		else
		{
			if(m_nBottomMainID)
			{
				Control	cntlBottom = GetItem(m_nBottomMainID);
				cntlBottom.Visible = false;
			}
			if(m_bBottomPaneOnRight)
			{
				/// TD ML 1-29-07 QA70-9327 FFT_DLG_SIZE_FORGOTTEN
				if(m_bResizeFirstTime)
					MoveControlToRightBottom(m_vnUpdownButtonIDs[BOTTOM_PANE], 0, m_nTopPaneHeight + 2 * GetControlGap());	///Jasmine 05/22/07 TO_GET_CORRECT_TOP_PANE_HEIGHT
				/// end FFT_DLG_SIZE_FORGOTTEN
				ResizeDlgToRightOfControl(m_vnUpdownButtonIDs[BOTTOM_PANE]);
			}
			/// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
			//else
			else if(SUBPANE_POS_BOTTOM == m_nSubPanePosition)
			///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
			///Jasmine 10/25/06 REMEMBER_TOP_PANE_SIZE			
			{
				///Jasmine 05/22/07 TO_GET_CORRECT_TOP_PANE_HEIGHT
				RECT rr;
				Control btn = GetItem(m_vnUpdownButtonIDs[BOTTOM_PANE]);
				if(btn)
					GetClientRect(btn, rr);
				//Move UpdownButtons to bottom of the dlg
				if(m_bResizeFirstTime)
					MoveControlToRightBottom(m_vnUpdownButtonIDs[BOTTOM_PANE], m_nTopPaneHeight + 3 * GetControlGap() + RECT_HEIGHT(rr));
				///End TO_GET_CORRECT_TOP_PANE_HEIGHT
				ResizeDlgToBottomOfControl(m_vnUpdownButtonIDs[BOTTOM_PANE]);
			}
			///End REMEMBER_TOP_PANE_SIZE
			/// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
			else if( SUBPANE_POS_LEFT == m_nSubPanePosition )
			{
				resizeDlgOnLeftPaneShowHide(IsBottomPaneShown());
			}
			///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
			HideBottomPaneSubControls();
		}
		
		///DG 8/17/05 : update top pane shown when it could be hided
		if(m_chkShowViewTopPane && IsTopPaneShown())
		{
			if(m_nMainID)
			{
				Control	cntlTop = GetItem(m_nMainID);
				cntlTop.Visible = true;
			}
		}
		///end
	
	}
	void UpdateDlgShow()
	{
		//CPY 1/15/05 XF_DLG_CODE_CLEANUP, not used anymore, all inside UpdateDlgSize
		/*
		Control	cntlBottom = GetItem(m_nBottomMainID);
		if(IsBottomPaneShown())
		{
			if(cntlBottom.Visible == false)
				cntlBottom.Visible = true;
			return;
		}
		else
		{
		}
		cntlBottom.Visible = false;
		*/
	}
	
	///Jasmine 01/17/11 ORG-1999 RESIZE_PANE_BY_RESIZING_EDGE
	void SetResizePaneByResizingEdge(bool bSet){ m_bResizePaneByResizingEdge = bSet; }
	bool IsResizePaneByResizingEdge(){ return m_bResizePaneByResizingEdge; }

	void OnDlgResizeOnResizingEdge(int cx, int cy, bool bRight)
	{
		/// Zech 08/09/2012 ORG-6255-S6 CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
		/*
		int nEdge = GetControlGap();
		if(SUBPANE_POS_RIGHT == m_nSubPanePosition)
		{
			RECT rMain;
			rMain.left 	= rMain.top = 0;
			rMain.right = cx - nEdge - m_nBottomPaneHeight;
			rMain.bottom= cy;			
			ResizeMainPaneControls(rMain, bRight);
					
			RECT rSub;
			rSub.left 	= cx - nEdge - m_nBottomPaneHeight;
			rSub.top 	= 0;
			rSub.right 	= cx;
			rSub.bottom	= cy;
			ResizeSubPaneControls(rSub);
		}
				
		if(SUBPANE_POS_LEFT == m_nSubPanePosition)
		{
			RECT rMain;
			rMain.left 	= m_nBottomPaneHeight + nEdge*2;//according to resizeLeftPaneOnDlgResize
			rMain.top 	= 0;
			rMain.right	= cx;
			rMain.bottom= cy;			
			ResizeMainPaneControls(rMain, bRight);
					
			RECT rSub;
			rSub.left 	= rSub.top = 0;
			rSub.right	= nEdge + m_nBottomPaneHeight;
			rSub.bottom	= cy;
			ResizeSubPaneControls(rSub);
		}					
				
		if(SUBPANE_POS_BOTTOM == m_nSubPanePosition)
		{
			RECT rMain;
			rMain.left 	= rMain.top = 0;
			rMain.right	= cx;
			rMain.bottom= cy - nEdge - m_nBottomPaneHeight;
			ResizeMainPaneControls(rMain, bRight);
					
			RECT rSub;
			rSub.left 	= 0;
			rSub.top 	= cy - nEdge - m_nBottomPaneHeight;
			rSub.right 	= cx;
			rSub.bottom	= cy;
			ResizeSubPaneControls(rSub);
		}
				
		if(SUBPANE_POS_TOP == m_nSubPanePosition)
		{
			RECT rMain;
			rMain.left 	= 0;
			rMain.top 	= nEdge + m_nBottomPaneHeight;
			rMain.right	= cx;
			rMain.bottom= cy;
			ResizeMainPaneControls(rMain, bRight);
					
			RECT rSub;
			rSub.left 	= rSub.top = 0;
			rSub.right 	= cx;
			rSub.bottom	= nEdge + m_nBottomPaneHeight;
			ResizeSubPaneControls(rSub);
		}
		*/
		RECT rMain, rSub;
		GetMainPaneRect(rMain, cx, cy);
		GetSubPaneRect(rSub, cx, cy);
		ResizeMainPaneControls(rMain, bRight);
		ResizeSubPaneControls(rSub);
		/// END CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
	}

	/// Zech 08/09/2012 ORG-6255-S6 CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
	void	GetMainPaneRect(RECT& rMainPane, int cx, int cy)
	{
		int nEdge = GetControlGap();
		switch (m_nSubPanePosition)
		{
		case SUBPANE_POS_RIGHT:
			rMainPane.left 	= rMainPane.top = 0;
			rMainPane.right = cx - nEdge - m_nBottomPaneHeight;
			rMainPane.bottom= cy;	
			break;
		case SUBPANE_POS_LEFT:
			rMainPane.left 	= m_nBottomPaneHeight + nEdge*2;//according to resizeLeftPaneOnDlgResize
			rMainPane.top 	= 0;
			rMainPane.right	= cx;
			rMainPane.bottom= cy;
			break;
		case SUBPANE_POS_BOTTOM:
			rMainPane.left 	= rMainPane.top = 0;
			rMainPane.right	= cx;
			rMainPane.bottom= cy - nEdge - m_nBottomPaneHeight;
			break;
		case SUBPANE_POS_TOP:
			rMainPane.left 	= 0;
			rMainPane.top 	= nEdge + m_nBottomPaneHeight;
			rMainPane.right	= cx;
			rMainPane.bottom= cy;
			break;
		}
	}

	void	GetSubPaneRect(RECT& rSubPane, int cx, int cy)
	{
		int nEdge = GetControlGap();
		switch (m_nSubPanePosition)
		{
		case SUBPANE_POS_RIGHT:
			rSubPane.left 	= cx - nEdge - m_nBottomPaneHeight;
			rSubPane.top 	= 0;
			rSubPane.right 	= cx;
			rSubPane.bottom	= cy;
			break;
		case SUBPANE_POS_LEFT:
			rSubPane.left 	= rSubPane.top = 0;
			rSubPane.right	= nEdge + m_nBottomPaneHeight;
			rSubPane.bottom	= cy;
			break;
		case SUBPANE_POS_BOTTOM:
			rSubPane.left 	= 0;
			rSubPane.top 	= cy - nEdge - m_nBottomPaneHeight;
			rSubPane.right 	= cx;
			rSubPane.bottom	= cy;
			break;
		case SUBPANE_POS_TOP:
			rSubPane.left 	= rSubPane.top = 0;
			rSubPane.right 	= cx;
			rSubPane.bottom	= nEdge + m_nBottomPaneHeight;
			break;
		}
	}
	/// END CHANGE_CUSTOM_FILTER_DLG_TO_MULTI_PANE_DLG
	
	bool IsSubPaneShown()
	{
		//ASSERT(0);//temp, should rewrite later
		return IsBottomPaneShown();
	}
	bool IsMainPaneShown()
	{
		//ASSERT(0);//temp, should rewrite later
		return IsTopPaneShown();
	}
	
	bool IsResizeSubPane()
	{
		bool bSubPaneShown = IsSubPaneShown();
		bool bMainPaneShown = IsMainPaneShown();
		
		if(!bSubPaneShown)
			return true;
		if(bSubPaneShown && !bMainPaneShown)
			return true;
		
		//bSubPaneShown && bMainPaneShown
		if(!IsResizePaneByResizingEdge())
			return true;
		
		DWORD dwResizing = GetResizingEdge();
		bool bResizingMainPane = false;
		switch(m_nSubPanePosition)
		{
		case SUBPANE_POS_BOTTOM:
			bResizingMainPane = (	WMSZ_TOP	== dwResizing ||
									WMSZ_TOPLEFT== dwResizing ||
									WMSZ_TOPRIGHT== dwResizing	);
			break;
		case SUBPANE_POS_RIGHT:
			bResizingMainPane = (	WMSZ_LEFT 	== dwResizing ||
									WMSZ_TOPLEFT== dwResizing ||
									WMSZ_BOTTOMLEFT== dwResizing);
			break;
		case SUBPANE_POS_TOP:
			bResizingMainPane = (	WMSZ_BOTTOM		== dwResizing ||
									WMSZ_BOTTOMLEFT	== dwResizing ||
									WMSZ_BOTTOMRIGHT== dwResizing);
			break;
		case SUBPANE_POS_LEFT:
			bResizingMainPane = (	WMSZ_RIGHT		== dwResizing ||
									WMSZ_TOPRIGHT	== dwResizing ||
									WMSZ_BOTTOMRIGHT== dwResizing);
			break;
		}
		return !bResizingMainPane;
	}
	
	virtual void ResizeMainPaneControls(RECT rr, bool bRight = true)//nButtonGap, nGroupButtonGap, bForceResize);
	{
		int nGap = GetControlGap();
		
		MoveControlToRightBottom(m_vnUpdownButtonIDs[BOTTOM_PANE], rr.bottom, rr.right);
		RECT rUpdownButton;
		GetControlClientRect(m_vnUpdownButtonIDs[BOTTOM_PANE], rUpdownButton);
		
		RECT rBtn;
		GetControlClientRect(m_vnButtonIDs[0], rBtn);
		
		/// Zech 12/27/2011 ORG-4657-S1 IMPROVE_RESIZE_PANE_BY_EDGE_FOR_MULTIPANEDLG
		RECT rrMain;
		if (bRight)
		{
		/// END IMPROVE_RESIZE_PANE_BY_EDGE_FOR_MULTIPANEDLG
			ArrangeControlsLeftRight(m_vnButtonIDs, rr.left + nGap, rr.bottom - nGap - RECT_HEIGHT(rBtn), nGap);
			GetControlClientRect(m_vnButtonIDs[0], rBtn);
			
			/// Zech 12/27/2011 ORG-4657-S1 IMPROVE_RESIZE_PANE_BY_EDGE_FOR_MULTIPANEDLG
			// Move the definition to outside of the if
			//RECT rrMain;
			/// END IMPROVE_RESIZE_PANE_BY_EDGE_FOR_MULTIPANEDLG
			rrMain.left = rr.left + nGap;
			rrMain.top = rr.top + nGap;
			rrMain.right = rr.right - nGap;
			rrMain.bottom = min(rBtn.top, rUpdownButton.top) - nGap;
			
			Control ccMain = GetItem( GetTopPaneMainID() );
			MoveControl(ccMain, rrMain);
		/// Zech 12/27/2011 ORG-4657-S1 IMPROVE_RESIZE_PANE_BY_EDGE_FOR_MULTIPANEDLG
		}
		else
		{
			ArrangeMainItemAndControls(m_vnButtonIDs, GetTopPaneMainID(), m_vnUpdownButtonIDs, bRight, 0, rr.bottom);

			bool bTopPaneBtn=false;
			if(m_chkShowViewTopPane)
				bTopPaneBtn=true;
			
			MoveControlToBottomRight(m_vnUpdownButtonIDs, GetTopPaneMainID(), m_vnButtonIDs[0], bRight, bTopPaneBtn);
			
			GetControlClientRect(GetTopPaneMainID(), rrMain);
		}
		/// END IMPROVE_RESIZE_PANE_BY_EDGE_FOR_MULTIPANEDLG

		if(SUBPANE_POS_TOP == m_nSubPanePosition || SUBPANE_POS_BOTTOM == m_nSubPanePosition)
			m_nTopPaneHeight = RECT_HEIGHT(rrMain);
		else
			m_nTopPaneHeight = RECT_WIDTH(rrMain);
			
	}
	virtual void ResizeSubPaneControls(RECT rr)
	{
		RECT rrSub;
		int nGap = GetControlGap();
		
		switch(m_nSubPanePosition)
		{
		case SUBPANE_POS_LEFT:
			rrSub.left	= rr.left	+ nGap;
			rrSub.top	= rr.top	+ nGap;
			rrSub.right	= rr.right;
			rrSub.bottom= rr.bottom	- nGap;
			break;
		case SUBPANE_POS_TOP:
			rrSub.left	= rr.left	+ nGap;
			rrSub.top	= rr.top	+ nGap;
			rrSub.right	= rr.right	- nGap;
			rrSub.bottom= rr.bottom;
			break;
		case SUBPANE_POS_RIGHT:
			rrSub.left	= rr.left;
			rrSub.top	= rr.top	+ nGap;
			rrSub.right	= rr.right	- nGap;
			rrSub.bottom= rr.bottom	- nGap;
			break;
		case SUBPANE_POS_BOTTOM:
			rrSub.left	= rr.left	+ nGap;
			rrSub.top	= rr.top;
			rrSub.right	= rr.right	- nGap;
			rrSub.bottom= rr.bottom	- nGap;
			break;
		}
		
		Control ccSub = GetItem(m_nBottomMainID);
		MoveControl(ccSub, rrSub);
		
		if(SUBPANE_POS_TOP == m_nSubPanePosition || SUBPANE_POS_BOTTOM == m_nSubPanePosition)
			m_nBottomPaneHeight = RECT_HEIGHT(rrSub);
		else
			m_nBottomPaneHeight = RECT_WIDTH(rrSub);
	}
	///End RESIZE_PANE_BY_RESIZING_EDGE

	/// Zech 12/27/2011 ORG-4657-S1 IMPROVE_RESIZE_PANE_BY_EDGE_FOR_MULTIPANEDLG
	virtual void GetBoundaryPositionBetweenPanes(int &nx, int &ny, int cx, int cy)
	{
		RECT rr;
		if(GetControlClientRect(m_vnUpdownButtonIDs[BOTTOM_PANE], rr))
		{
			switch(m_nSubPanePosition)
			{
			case SUBPANE_POS_RIGHT:
				nx = rr.right + GetControlGap();
				break;
			case SUBPANE_POS_BOTTOM:
				ny = rr.bottom + GetControlGap();
				break;
			case SUBPANE_POS_LEFT:
				break;
			}
			///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
		}
	}
	/// END IMPROVE_RESIZE_PANE_BY_EDGE_FOR_MULTIPANEDLG
	
	///Jasmine 04/20/07 OPTION_HIDDEN_BUTTON_NOT_IN_CAL
	///Joseph 12/11/06 ADD_BITMAP_BUTTON
	//void OnDlgResize(uint nButtonIDs[], int cx, int cy, bool bRight = true)
	//void OnDlgResize(uint nButtonIDs[], int cx, int cy, bool bRight = true, int nButtonGap = -1, int nGroupButtonGap = -1)
	void OnDlgResize(uint nButtonIDs[], int cx, int cy, bool bRight = true, int nButtonGap = -1, int nGroupButtonGap = -1, bool bForceResize = true)
	///End	ADD_BITMAP_BUTTON
	///End OPTION_HIDDEN_BUTTON_NOT_IN_CAL
	{	
		/// Iris 3/23/2012 ORG-4457-P3 NEED_BETTER_FIX_TO_ARRANGE_NLFIT_BUTTONS
		if( -1 != nButtonGap )
			m_nButtonGap = nButtonGap;
		if( -1 != nGroupButtonGap )
			m_nGroupGap = nGroupButtonGap;
		m_bForceResize = bForceResize;
		///End NEED_BETTER_FIX_TO_ARRANGE_NLFIT_BUTTONS
		
		saveButtonIDs(nButtonIDs);	//save first
		///---Danice ARRANGE_TWO_SHOW_PANE_BUTTON_NEW_WAY : resize updown button size
		if(m_bResizeFirstTime && m_chkShowViewTopPane)
		{
			RECT rr;
			GetControlClientRect(m_vnButtonIDs[0], rr);
			MakeSameSize(m_vnUpdownButtonIDs, true, RECT_HEIGHT(rr)/TOTAL_UPDOWN_BOTTON+GetControlGap());
			MakeSameSize(m_vnUpdownButtonIDs, false);
		}
		///---end ARRANGE_TWO_SHOW_PANE_BUTTON_NEW_WAY
		
		///Jasmine 01/17/11 ORG-1999 RESIZE_PANE_BY_RESIZING_EDGE
		if( !IsResizeSubPane() )
		{
			OnDlgResizeOnResizingEdge(cx, cy, bRight);
			/// Zech 12/27/2011 ORG-4657-S1 IMPROVE_RESIZE_PANE_BY_EDGE_FOR_MULTIPANEDLG
			if(m_bResizeFirstTime)
				m_bResizeFirstTime = false;
			if(IsBottomPaneShown())
				UpdateBottomPaneSubControls();
			/// END IMPROVE_RESIZE_PANE_BY_EDGE_FOR_MULTIPANEDLG
			return;
		}
		///End RESIZE_PANE_BY_RESIZING_EDGE
			
		int ny = 0, nx = 0;
		if(IsBottomPaneShown())
		{
			if(m_bResizeFirstTime)
			{
				if(m_nBottomPaneHeight == 0)
				{
					//--- CPY 11/12/05 RESET_BOTTOM_PANE_HEIGHT
					//out_str("m_nBottomPaneHeight = 0 is not possible, but true, so get out");
					//return;
					out_str("m_nBottomPaneHeight = 0, not supported, reset to 50");
					m_nBottomPaneHeight = 50;
					//---
				}
				//ny = cy - m_nBottomPaneHeight;	///Danice : this will make bottom pane smaller
				/// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
				/*
				//---- CPY 4/3/06 SMOOTH_XF_PREVIEW_TOO_BIG
				if(m_nBottomPaneHeight + 20 > (m_bBottomPaneOnRight? cx : cy))
				{
					out_int("saved m_nBottomPaneHeight too big, reset to half of dialog height :", m_nBottomPaneHeight);
					m_nBottomPaneHeight = m_bBottomPaneOnRight? cx/2 : cy/2;
				}
				//----
				if(m_bBottomPaneOnRight)
					nx = cx - m_nBottomPaneHeight - GetControlGap();
				else
					ny = cy - m_nBottomPaneHeight - GetControlGap();
				*/
				int nDlgSize = (SUBPANE_POS_RIGHT == m_nSubPanePosition || SUBPANE_POS_LEFT == m_nSubPanePosition)? cx : cy;
				if(m_nBottomPaneHeight + 20 > nDlgSize)
				{
					out_int("saved m_nBottomPaneHeight too big, reset to half of dialog height :", m_nBottomPaneHeight);
					m_nBottomPaneHeight = nDlgSize/2;
				}
				
				switch(m_nSubPanePosition)
				{
				case SUBPANE_POS_RIGHT:
					nx = cx - m_nBottomPaneHeight - GetControlGap();
					break;
				case SUBPANE_POS_BOTTOM:
					ny = cy - m_nBottomPaneHeight - GetControlGap();
					break;
				case SUBPANE_POS_LEFT:
					break;
				}
				///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
			}
			else // keep top pane unchange in height
			{
				/// Zech 12/27/2011 ORG-4657-S1 IMPROVE_RESIZE_PANE_BY_EDGE_FOR_MULTIPANEDLG
				// Make the logic below as a virtual function GetBoundaryPositionBetweenPanes,\
				   since not every dialog has same boundary position between panes.
				//RECT rr;
				//if(GetControlClientRect(m_vnUpdownButtonIDs[BOTTOM_PANE], rr))
				//{
					///// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
					///*
					//if(m_bBottomPaneOnRight)
					//nx = rr.right + GetControlGap();
					//else
					//ny = rr.bottom + GetControlGap();
					//*/
					//switch(m_nSubPanePosition)
					//{
					//case SUBPANE_POS_RIGHT:
						//nx = rr.right + GetControlGap();
						//break;
					//case SUBPANE_POS_BOTTOM:
						//ny = rr.bottom + GetControlGap();
						//if (IsResizePaneByResizingEdge()) 
						//{
							//if (IsBottomPaneShown())
								//ny = min(ny, cy - GetControlGap() - GetMinBottomPaneHeight());
							//ny = max(ny, GetMinTopPaneHeight() + GetControlGap());
						//}
						//break;
					//case SUBPANE_POS_LEFT:
						//break;
					//}
					/////End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
				//}
				GetBoundaryPositionBetweenPanes(nx, ny, cx, cy);
				/// END IMPROVE_RESIZE_PANE_BY_EDGE_FOR_MULTIPANEDLG
			}
			//---
		}
		
		///Danice NEW_WAY_SHOW_TOP_AND_BOTTOM_PANE
		//saveButtonIDs(nButtonIDs);	//move to head before return
		if(IsTopPaneShown())
		{
			/// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
			bool bBottomPaneShown = IsBottomPaneShown();
			if( SUBPANE_POS_LEFT == m_nSubPanePosition )
			{
				RECT rrMain, rrButton;
				Control ccMain;
				GetControlClientRect(m_nMainID, rrMain, &ccMain);
				GetControlClientRect(m_vnUpdownButtonIDs[0], rrButton);
				
				/// Iris 9/14/2010 OGR-9 FIX_NOT_REMEMBER_MAIN_PANE_WHEN
				//int nWidth = RECT_WIDTH(rrMain);
				int nWidth = m_bResizeFirstTime? m_nTopPaneHeight : RECT_WIDTH(rrMain);
				m_nTopPaneHeight = nWidth;
				///End FIX_NOT_REMEMBER_MAIN_PANE_WHEN
				rrMain.right = cx - GetControlGap();
				if( bBottomPaneShown )
					rrMain.left = rrMain.right - nWidth;
				else
					rrMain.left = GetControlGap();
				rrMain.bottom = cy - RECT_HEIGHT(rrButton) - 2 * GetControlGap();
				MoveControl(ccMain, rrMain);				
				
				//----- Iris 9/14/2010 cannot always assume only one up down button, so changed to the following more general codes.
				vector<uint> vnAllBottomButtons;
				/*
				vnAllBottomButtons.Add(m_vnUpdownButtonIDs[0]); // add Show Left button
				
				m_vnButtonIDs.RemoveAt(m_vnButtonIDs.GetSize()-1); // remove last one item: 0
				*/				
				for(int ii = 0; ii < m_vnUpdownButtonIDs.GetSize(); ii++)
				{
					if( m_vnUpdownButtonIDs[ii] > 0 )
						vnAllBottomButtons.Add(m_vnUpdownButtonIDs[ii]); // add Show Left buttons
				}
				//-----
				
				vnAllBottomButtons.Append(m_vnButtonIDs); // add other bottom buttons
				ArrangeControlsLeftRight(vnAllBottomButtons, rrMain.left, rrMain.bottom + GetControlGap());
			}
			else
			{
			///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
				///Jasmine 04/20/07 OPTION_HIDDEN_BUTTON_NOT_IN_CAL
				///Joseph 12/11/06 ADD_BITMAP_BUTTON
				////ArrangeMainItemAndControls(nButtonIDs, GetTopPaneMainID(), true, 0, ny);	///Danice 3/31/04 ARRANGE_BOTTOM_BUTTON_FROM_LEFT_TO_RIGHT
				//ArrangeMainItemAndControls(nButtonIDs, GetTopPaneMainID(), bRight, 0, ny);	///Danice DLG_SIZE_CONSIGER_RIGHT_BOTTOM_BTN
				//ArrangeMainItemAndControls(nButtonIDs, GetTopPaneMainID(), m_vnUpdownButtonIDs, bRight, nx, ny, nButtonGap, nGroupButtonGap);
				ArrangeMainItemAndControls(nButtonIDs, GetTopPaneMainID(), m_vnUpdownButtonIDs, bRight, nx, ny, nButtonGap, nGroupButtonGap, bForceResize);
				///Danice ARRANGE_TWO_SHOW_PANE_BUTTON_NEW_WAY
				///End	ADD_BITMAP_BUTTON
				///End OPTION_HIDDEN_BUTTON_NOT_IN_CAL
				/*
				//MoveControlToBottomRight(m_nUpdownButtonID, GetTopPaneMainID(), nButtonIDs[0]);	///Danice 3/31/04 ARRANGE_BOTTOM_BUTTON_FROM_LEFT_TO_RIGHT
				int nHeight=MoveControlToBottomRight(m_vnUpdownButtonIDs, GetTopPaneMainID(), nButtonIDs[0], bRight);
				*/
				bool bTopPaneBtn=false;
				if(m_chkShowViewTopPane)
					bTopPaneBtn=true;
				int nHeight=MoveControlToBottomRight(m_vnUpdownButtonIDs, GetTopPaneMainID(), nButtonIDs[0], bRight, bTopPaneBtn);			
			} /// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
			///end ARRANGE_TWO_SHOW_PANE_BUTTON_NEW_WAY
			
			///DG 7/19/05 The first time dialog open, m_nTopPaneHeight maybe change
			/// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
			//bool bBottomPaneShown = IsBottomPaneShown();
			///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
			if(!bBottomPaneShown || m_bResizeFirstTime)
			///Jasmine 10/25/06 REMEMBER_TOP_PANE_SIZE
				//m_nTopPaneHeight=nHeight;	//resize top pane
			{
				RECT rDlg;
				m_wndDlg.GetClientRect(&rDlg);
				///Kyle 03/15/2010 QA80-15152 FIX_MAIN_CONTROL_IS_MISSING_AFTER_CLOSING_A_MINIMIZED_DIALOGUE
				if( RECT_HEIGHT(rDlg) > 0 )			// do nothing if the dlg is minimized
				///End FIX_MAIN_CONTROL_IS_MISSING_AFTER_CLOSING_A_MINIMIZED_DIALOGUE
				{
					///Jasmine 11/21/06 FIX_TREE_PANE_FAIL_TO_DISPLAY
					//m_nTopPaneHeight = RECT_HEIGHT(rDlg) - (bBottomPaneShown? GetBottomPaneHeight() : 0);
					/// TD ML 1-29-07 QA70-9327 FFT_DLG_SIZE_FORGOTTEN
					//m_nTopPaneHeight = RECT_HEIGHT(rDlg) - ((bBottomPaneShown && !m_bBottomPaneOnRight)? (GetBottomPaneHeight()+GetControlGap()): 0);///Jasmine 11/22/06 FIX_TOP_PANE_HEIGHT_REDUCE_BUG
					///Jasmine 05/22/07 TO_GET_CORRECT_TOP_PANE_HEIGHT
					RECT rRightBottomBtn;
					Button btnRightBottom;
					int nRightBottomBtnID = m_vnUpdownButtonIDs[BOTTOM_PANE];
					if(m_bBottomPaneOnRight)
					{
						//m_nTopPaneHeight = RECT_WIDTH(rDlg) - (bBottomPaneShown? (GetBottomPaneHeight()+GetControlGap()): 0);
						int nLeft  = rDlg.left + GetControlGap();
						int nRight = rDlg.right - GetControlGap();
						btnRightBottom = GetItem(nRightBottomBtnID);
						if(btnRightBottom)
						{	
							GetClientRect(btnRightBottom, rRightBottomBtn);
							nRight = rRightBottomBtn.right;
						}
						m_nTopPaneHeight = nRight - nLeft;
					}
					/// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
					//else
					else if( SUBPANE_POS_BOTTOM == m_nSubPanePosition )
					///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
					{
						//m_nTopPaneHeight = RECT_HEIGHT(rDlg) - (bBottomPaneShown? (GetBottomPaneHeight()+GetControlGap()): 0);
						int nTop	= rDlg.top + GetControlGap();
						int nBottom = rDlg.bottom;
						if(m_vnUpdownButtonIDs[TOP_PANE]) nRightBottomBtnID = m_vnUpdownButtonIDs[TOP_PANE];
						btnRightBottom = GetItem(nRightBottomBtnID);
						if(btnRightBottom)
						{	
							GetClientRect(btnRightBottom, rRightBottomBtn);
							nBottom = rRightBottomBtn.top;
						}
						nBottom -= GetControlGap();
						m_nTopPaneHeight = nBottom - nTop;
					}
					/// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
					else if( SUBPANE_POS_LEFT == m_nSubPanePosition )
					{
						RECT rrMain;
						GetControlClientRect(m_nMainID, rrMain);
						m_nTopPaneHeight = RECT_WIDTH(rrMain);						
					}
					else
					{
						ASSERT(false);
					}
					///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
				}
				///End TO_GET_CORRECT_TOP_PANE_HEIGHT
				/// end FFT_DLG_SIZE_FORGOTTEN
				///End FIX_TREE_PANE_FAIL_TO_DISPLAY
			}
			///End REMEMBER_TOP_PANE_SIZE				
			if(bBottomPaneShown)
			{
				if(m_bBottomPaneOnRight)
				{
					MoveControlToRight(m_nBottomMainID, m_vnUpdownButtonIDs[BOTTOM_PANE],  GetBottomPaneHeight());					
					
					//------ Folger 05/19/08 FIX_MULTIPANE_DIALOG_RESIZE_ERROR_WHEN_MINIMIZE_THEN_REOPEN
					//ResizeMoveControlsRightBottom(m_nBottomMainID, NULL, NULL, cx, cy, &m_nBottomPaneHeight);
					int nBottomPaneHeight;
					if ( ResizeMoveControlsRightBottom(m_nBottomMainID, NULL, NULL, cx, cy, &nBottomPaneHeight) >= 0 )
						m_nBottomPaneHeight	= nBottomPaneHeight;
					//------
				}
				/// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
				//else
				else if( SUBPANE_POS_BOTTOM == m_nSubPanePosition )
				///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
				{
					/// Iris 2/27/2012 ORG-5146-P1 FIX_SET_VALUE_DLG_BOTTOM_PANEL_FLICKER_ISSUE
					if( m_nBottomMainID > 0 )
					///End FIX_SET_VALUE_DLG_BOTTOM_PANEL_FLICKER_ISSUE
					{
						MoveControlToBottom(m_nBottomMainID, m_vnUpdownButtonIDs[BOTTOM_PANE]);
					
						//------ Folger 05/19/08 FIX_MULTIPANE_DIALOG_RESIZE_ERROR_WHEN_MINIMIZE_THEN_REOPEN
						//m_nBottomPaneHeight = ResizeMoveControlsRightBottom(m_nBottomMainID, NULL, NULL, cx, cy);
						int nBottomPaneHeight;
						if ( (nBottomPaneHeight = ResizeMoveControlsRightBottom(m_nBottomMainID, NULL, NULL, cx, cy)) >= 0 )
							m_nBottomPaneHeight = nBottomPaneHeight;
						//------
					}
				}		
				/// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
				else if( SUBPANE_POS_LEFT == m_nSubPanePosition )
				{
					resizeLeftPaneOnDlgResize(cx, cy); 
				}
				///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
			}
			/// Iris 1/12/2010 ORG-1826-P8 FIX_NOT_REMEMBER_LEFT_PANE_WIDTH
			else
			{				
				// when first open dialog, need to set the width of left pane main control with the value of "BottomPaneHeight" key in registry.
				// Since when click Show left pane button, need to resize dialog according to the width of left pane.
				if( SUBPANE_POS_LEFT == m_nSubPanePosition )
				{
					if( m_bResizeFirstTime )
					{
						resizeLeftPaneOnDlgResize(cx, cy);
					}
				}				
			}
			////End FIX_NOT_REMEMBER_LEFT_PANE_WIDTH
			//else	//resize top pane
				//m_nTopPaneHeight=nHeight;
		}
		else
		{
			RepositionControls(GetTopPaneMainID(), nButtonIDs, m_vnUpdownButtonIDs, m_nBottomMainID);
			if(IsBottomPaneShown())
			{
				RECT rr;
				GetClientRect(GetItem(m_nBottomMainID), rr);
				m_nBottomPaneHeight = RECT_HEIGHT(rr);	
			}
			SetButtonAndGroupInfo(nButtonIDs, nButtonGap, nGroupButtonGap); ///Jasmine 05/21/07 SET_WHEN_TOP_PANE_HIDE
		}
		///end 
		if(m_bResizeFirstTime)
			m_bResizeFirstTime = false;
		//---- CPY 1/15/05 XF_DLG_CODE_CLEANUP
		if(IsBottomPaneShown())
			UpdateBottomPaneSubControls();
		//----
	}
	//--- CPY 6/9/2006 LOAD_SAMPLE_CHECK_OPEN_BEFORE_SCRIPT_BOX
	void ShowBottomPane(bool bShow)
	{
		if(m_chkShowViewBottomPane)
		{
			if(bShow && m_chkShowViewBottomPane.Check)
				return;
			if(!bShow && !m_chkShowViewBottomPane.Check)
				return;
			
			m_chkShowViewBottomPane.Check = !m_chkShowViewBottomPane.Check;
			OnShowBottomPane(m_chkShowViewBottomPane);
		}
	}
	//---
	bool IsBottomPaneShown() 
	{
		if(m_chkShowViewBottomPane)
			return m_chkShowViewBottomPane.Check? true:false;
		
		//----- CPY 5/26/04 v7.5878 BOTTOM_PANE_OPEN_BUT_SIZE_ZERO
		//return true;
		out_str("calling IsBottomPaneShown before m_chkShowViewBottomPane is ready");
		return false;
		//----
	}
	///Danice NEW_WAY_SHOW_TOP_AND_BOTTOM_PANE
	bool OnShowTopPane(Control cntrl)
	{
		SetInitReady(false);
		UpdateDlgShowShowTopPane();
		UpdateDlgSizeShowTopPane();
		//--- CPY 1/15/05, moved from NLFit, not sure if needed
		if(IsBottomPaneShown())
			UpdateBottomPaneSubControls();
		//---

		SetInitReady();
		return true;
	}
	void UpdateDlgSizeShowTopPane()
	{
		if(0 == GetTopPaneMainID())
			return;
		
		if(IsTopPaneShown())
		{
			MoveControlToTop(GetTopPaneMainID(), m_vnUpdownButtonIDs[TOP_PANE], m_nTopPaneHeight);///Danice SAVE_TOP_PANE_HEIGHT
			ResizeDlgToBottomOfControl(GetTopPaneMainID(), true);
			///Jasmine 05/21/07 REPOSITION_DLG_AFTER_SHOW_TOP_PANE
			RECT rtDlg;		
			m_wndDlg.GetWindowRect(&rtDlg);	
			//------ Folger 11/28/07 FIX_BUG_ON_REPOSITION_WHEN_RESIZE_DIALOG
			//if(0 >= rtDlg.top)
			if ( rtDlg.top <= -GetWindowTitleHeight() )
			//------
			{
				SIZE sz;
				sz.cx = RECT_WIDTH(rtDlg);
				sz.cy = RECT_HEIGHT(rtDlg);
				MoveDialogToCenter(sz);
			}
			///End REPOSITION_DLG_AFTER_SHOW_TOP_PANE
			RepositionControls(GetTopPaneMainID(), m_vnButtonIDs, m_vnUpdownButtonIDs, m_nBottomMainID);
		}
		else
		{
			ResizeDlgToBottomOfControl(m_vnUpdownButtonIDs[TOP_PANE], true);
			RepositionControls(GetTopPaneMainID(), m_vnButtonIDs, m_vnUpdownButtonIDs, m_nBottomMainID);
		}
		//if(!IsBottomPaneShown())
		//{
			//ResizeDlgToBottomOfControl(m_vnButtonIDs[0]);
		//}
	}
	void UpdateDlgShowShowTopPane()
	{
		Control	cntlTop = GetItem(GetTopPaneMainID());
		if(IsTopPaneShown())
		{
			if(cntlTop.Visible == false)
				cntlTop.Visible = true;
			return;
		}
		cntlTop.Visible = false;
	}
	bool IsTopPaneShown()
	{
		if(m_chkShowViewTopPane)
			return m_chkShowViewTopPane.Check ? false : true;	//top pane btn reverse show
		
		return true;
	}
	///end NEW_WAY_SHOW_TOP_AND_BOTTOM_PANE
	//----- CPY 10/3/04 GRAPH_CNTRL_BASE_CLASS_FOR_EMF
	BOOL DeleteBottomTabItem(int nIndex)
	{
		if(m_BottomTab)
			return m_BottomTab.DeleteItem(nIndex);
		
		return false;
	}
	virtual BOOL OnBottomTabChange(Control ctrl)
	{		
		UpdateBottomPaneSubControls();
		return true;
	}
	virtual void OnSetBottomTabTitles(WPARAM wParam, LPARAM lParam)
	{
		LPCSTR lpcsz = (LPCSTR)lParam;
		//out_str(lpcsz);
		if(m_BottomTab)
		{
			vector<string> vs;
			string str = lpcsz;
			str.GetTokens(vs, '\n');
			for(int ii = 0; ii < vs.GetSize(); ii++)
				m_BottomTab.SetItemText(ii, vs[ii]);	
		}
	}

	
	//-----
	//---- CPY 9/16/06 BETTER_DEFAULT_GETN_PREVIEW_DLG_SIZE
	/// AW 03/07/06 TIP_OF_SHOW_TOP__CHANGABLE
	//BOOL OnInitDialog(int nRefID, int nIdUpDownButton, int nIDMainBottom, vector<string>& vsTooltipsShowBottomPane, LPCSTR lpcszDlgName, int nIdShowTopButton=0, vector<string>& vsBottomTabNames = NULL, bool bInitOpenBottomPane = true)
	//BOOL OnInitDialog(int nRefID, int nIdUpDownButton, int nIDMainBottom, vector<string>& vsTooltipsShowBottomPane, LPCSTR lpcszDlgName, int nIdShowTopButton=0, vector<string>& vsBottomTabNames = NULL, bool bInitOpenBottomPane = true, vector<string>& vsTooltipsShowTopPane = NULL)
	///------ Folger 10/14/2010 ORG-1252 MULTIPANE_DIALOG_BAD_LAYOUT_IF_INVALID_PANE_HEIGHT_IN_REGISTRY
	//BOOL OnInitDialog(int nRefID, int nIdUpDownButton, int nIDMainBottom, vector<string>& vsTooltipsShowBottomPane, LPCSTR lpcszDlgName, int nIdShowTopButton=0, vector<string>& vsBottomTabNames = NULL, int nDefaultBottomPaneHeight = 250, vector<string>& vsTooltipsShowTopPane = NULL)
	BOOL OnInitDialog(int nRefID, int nIdUpDownButton, int nIDMainBottom, vector<string>& vsTooltipsShowBottomPane, LPCSTR lpcszDlgName, int nIdShowTopButton=0, vector<string>& vsBottomTabNames = NULL, int nDefaultBottomPaneHeight = 250, vector<string>& vsTooltipsShowTopPane = NULL, DWORD dwCntrl = 0)
	///------ End MULTIPANE_DIALOG_BAD_LAYOUT_IF_INVALID_PANE_HEIGHT_IN_REGISTRY
	/// END TIP_OF_SHOW_TOP__CHANGABLE
	{ 
		m_nMainID = nRefID;
		m_nBottomMainID = nIDMainBottom;
		//--- CPY 1/15/05 XF_DLG_CODE_CLEANUP
		if(vsBottomTabNames)
		{
			m_BottomTab = GetItem(m_nBottomMainID);
			if(m_BottomTab)
			{
				for(int ii = 0; ii < vsBottomTabNames.GetSize(); ii++)
					m_BottomTab.InsertItem(ii, vsBottomTabNames[ii]);
			}
		}
		//---
		///Frank 4/1/05	RISIZEDIG_SAVE_DLG_NAME_ON_INIT	
		//ResizeDialog::OnInitDialog(nRefID);
		//m_strDlgName = lpcszDlgName;
		m_strDlgName = lpcszDlgName;
		ResizeDialog::OnInitDialog(nRefID, m_strDlgName);
		///End	RISIZEDIG_SAVE_DLG_NAME_ON_INIT	
	
		m_strBottomPaneHeight = "BottomPaneHeight";
		//m_nBottomPaneHeight = LoadSetting(m_strBottomPaneHeight, 0); ///DG LOAD_SETTING_SHOULD_PASS_DLG_NAME : fixed m_nBottomPaneHeight=0 problem
		///------ Folger 10/14/2010 ORG-1252 MULTIPANE_DIALOG_BAD_LAYOUT_IF_INVALID_PANE_HEIGHT_IN_REGISTRY
		m_nBottomPaneHeight = LoadSetting(m_strBottomPaneHeight, nDefaultBottomPaneHeight, m_strDlgName);
		BOOL	bSuccessfullyLoadFromReg = FALSE;
		/// since ORG-1252 is complaining about top panel, and my fix seems not go very well for bottom panel, so better make a exact fix
		/*
		m_nBottomPaneHeight = LoadSetting(m_strBottomPaneHeight, nDefaultBottomPaneHeight, m_strDlgName, &bSuccessfullyLoadFromReg);
		if ( bSuccessfullyLoadFromReg && O_QUERY_BOOL(dwCntrl, MULTIPANEDLGINIT_RESET_PANE_SIZE_IF_TOO_SMALL) )
		{
			int		nMinBottomPaneHeight = GetMinBottomPaneHeight();
			if ( abs(m_nBottomPaneHeight) < nMinBottomPaneHeight )
				m_nBottomPaneHeight = nMinBottomPaneHeight;
		}
		*/
		///------ End MULTIPANE_DIALOG_BAD_LAYOUT_IF_INVALID_PANE_HEIGHT_IN_REGISTRY
			
		m_vnUpdownButtonIDs.SetSize(TOTAL_UPDOWN_BOTTON+1);
		m_vnUpdownButtonIDs[BOTTOM_PANE] = nIdUpDownButton;// for resize to use as ref only
		m_chkShowViewBottomPane = GetItem(nIdUpDownButton);
		//m_chkShowViewBottomPane.Init(2, IDB_DOWNUP_BTN, 12, vsTooltipsShowBottomPane);	///Danice NEW_WAY_SHOW_TOP_AND_BOTTOM_PANE
		
		///Danice 10/05/04 NEW_WAY_SHOW_TOP_AND_BOTTOM_PANE
		m_vnUpdownButtonIDs[TOP_PANE] = nIdShowTopButton;
		if(m_vnUpdownButtonIDs[TOP_PANE])
		{
			if(vsTooltipsShowBottomPane)
				m_chkShowViewBottomPane.Init(2, IDB_SMALL_DOWNUP_BTN, 12, vsTooltipsShowBottomPane);
			else
				DisableBottomPane(); 
				
			m_chkShowViewTopPane = GetItem(m_vnUpdownButtonIDs[TOP_PANE]);
			///---DG 7/19/05 SHOW_TOP_TIPS_PROBLEM
			//m_chkShowViewTopPane.Init(2, IDB_SMALL_DOWNUP_BTN, 12, vsTooltipsShowBottomPane);
			/// AW 03/07/06 TIP_OF_SHOW_TOP__CHANGABLE
			//vector<string> vsTopTips = {"Hide Top", "Show Top"};
			//m_chkShowViewTopPane.Init(2, IDB_SMALL_DOWNUP_BTN, 12, vsTopTips);
			if ( vsTooltipsShowTopPane )
				m_chkShowViewTopPane.Init(2, IDB_SMALL_DOWNUP_BTN, 12, vsTooltipsShowTopPane);
			else
			{
				/// Max 07-11-05 CORRECT_LOCALIZATION
				//vector<string> vsTopTips = {"Hide Top", "Show Top"};
				vector<string> vsTopTips;
				vsTopTips.Add(_L("Hide Top"));
				vsTopTips.Add(_L("Show Top"));
				/// END CORRECT_LOCALIZATION
				m_chkShowViewTopPane.Init(2, IDB_SMALL_DOWNUP_BTN, 12, vsTopTips);
			}
			/// END TIP_OF_SHOW_TOP__CHANGABLE
			///---end ON_SYSCOMMAND(OnSystemCommand)
			//m_chkShowViewTopPane.Check=true;
		}
		else	//Danice ARRANGE_TWO_SHOW_PANE_BUTTON_NEW_WAY
		{
			if(vsTooltipsShowBottomPane)
			{
				/// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
				//int nBtnBmpID = m_bBottomPaneOnRight?IDB_RIGHT_LEFT_BTN : IDB_DOWNUP_BTN;
				///Jasmine 12/22/10 ORG-1826-S1-7 SHOW_CORRECT_ARROW_BY_SUB_PANE_POSITION
				int nBtnBmpID;// = (SUBPANE_POS_RIGHT == m_nSubPanePosition || SUBPANE_POS_LEFT == m_nSubPanePosition )?IDB_RIGHT_LEFT_BTN : IDB_DOWNUP_BTN;
				switch(m_nSubPanePosition)
				{
				case SUBPANE_POS_BOTTOM:
					nBtnBmpID = IDB_DOWNUP_BTN;
					break;
				case SUBPANE_POS_RIGHT:
					nBtnBmpID = IDB_RIGHT_LEFT_BTN;
					break;
				case SUBPANE_POS_TOP:
					nBtnBmpID = IDB_UPDOWN_BTN;
					break;
				case SUBPANE_POS_LEFT:
					nBtnBmpID = IDB_LEFT_RIGHT_BTN;
					break;
				default:
					ASSERT(0);
					break;
				}
				///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
				m_chkShowViewBottomPane.Init(2, nBtnBmpID, 12, vsTooltipsShowBottomPane);
			}
			else
				DisableBottomPane();				
		}
		///end 
		
		///Danice SAVE_TOP_PANE_HEIGHT
		m_strTopPaneHeight = "TopPaneHeight";
		///Jasmine 10/25/06 REMEMBER_TOP_PANE_SIZE	 
		//m_nTopPaneHeight = LoadSetting(m_strTopPaneHeight, 0, m_strDlgName);
		///------ Folger 10/14/2010 ORG-1252 MULTIPANE_DIALOG_BAD_LAYOUT_IF_INVALID_PANE_HEIGHT_IN_REGISTRY
		//m_nTopPaneHeight = LoadSetting(m_strTopPaneHeight, GetMinTopPaneHeight(), m_strDlgName);
		int		nMinTopPaneHeight = GetMinTopPaneHeight();
		m_nTopPaneHeight = LoadSetting(m_strTopPaneHeight, nMinTopPaneHeight, m_strDlgName, &bSuccessfullyLoadFromReg);
		if ( bSuccessfullyLoadFromReg && O_QUERY_BOOL(dwCntrl, MULTIPANEDLGINIT_RESET_PANE_SIZE_IF_TOO_SMALL) )
		{
			if ( abs(m_nTopPaneHeight) < nMinTopPaneHeight )
			{
				/// Iris 11/25/2011 ORG-4457-P1 FIX_SHOW_TOP_PANE_BUTTON_BUG
				// Folger's code below not keep the sign when m_nTopPaneHeight is a negative. m_nTopPaneHeight is a negative means top pane is hidden.
				//m_nTopPaneHeight = nMinTopPaneHeight;
				m_nTopPaneHeight = m_nTopPaneHeight < 0 ? 0 - nMinTopPaneHeight : nMinTopPaneHeight;
				///End FIX_SHOW_TOP_PANE_BUTTON_BUG
			}
		}
		///------ End MULTIPANE_DIALOG_BAD_LAYOUT_IF_INVALID_PANE_HEIGHT_IN_REGISTRY
		///End REMEMBER_TOP_PANE_SIZE
		if(m_nTopPaneHeight > 10 || m_nTopPaneHeight == 0 )	///Danice 10/27/04: Default open both Top and bottom pane
		{
			if(m_chkShowViewTopPane)
			{
				///Jasmine 10/25/06 REMEMBER_TOP_PANE_SIZE	 
				//m_nTopPaneHeight = 150;
				//m_nTopPaneHeight = m_nTopPaneHeight? m_nTopPaneHeight:150;
				m_chkShowViewTopPane.Check = false;		//reverse show
			}
		}
		else
		{
			if(m_nTopPaneHeight < 0)
				m_nTopPaneHeight = -m_nTopPaneHeight;
			if(m_chkShowViewTopPane)
				m_chkShowViewTopPane.Check = true;//false;	//reverse show
			GetItem(GetTopPaneMainID()).Visible=false;
		}
		///end
		
		//----- CPY 5/26/04 v7.5878 BOTTOM_PANE_OPEN_BUT_SIZE_ZERO
		// the fix below was not the right fix
		//	///Frank  5/26/04 V8.0876 INIT_BUTTOM_DIALOG_HIGHT_FIRST_TIME
		//	if(m_nBottomPaneHeight < 10)
		//		m_nBottomPaneHeight = 150;
		//	///end  INIT_BUTTOM_DIALOG_HIGHT_FIRST_TIME
		//m_chkShowViewBottomPane.Check = m_nBottomPaneHeight > 10? true:false;
		if(m_nBottomPaneHeight > 10 || (m_nBottomPaneHeight == 0 && nDefaultBottomPaneHeight) )	///Danice 10/27/04: Default open both Top and bottom pane
		{
			m_chkShowViewBottomPane.Check = true;
			//UpdateDlgSize();
		}
		else
		{
			if(m_nBottomPaneHeight < 0)// we may have saved negative height to indicate hidden but keep the height
				m_nBottomPaneHeight = - m_nBottomPaneHeight;	
			m_chkShowViewBottomPane.Check = false;
		}
		m_bResizeFirstTime = true;
		//-----
		return TRUE;
	}
	BOOL OnDestroy()
	{
		if(!IsBottomPaneShown())
			m_nBottomPaneHeight = - abs(m_nBottomPaneHeight); //CPY 5/26/04, save negative height
		///Danice SAVE_TOP_PANE_HEIGHT
		if(!IsTopPaneShown())
			m_nTopPaneHeight = - abs(m_nTopPaneHeight);
		///------ Folger 10/15/2010 ORG-1252 MULTIPANE_DIALOG_BAD_LAYOUT_IF_INVALID_PANE_HEIGHT_IN_REGISTRY
		if ( 0 != m_nTopPaneHeight )
		///------ End MULTIPANE_DIALOG_BAD_LAYOUT_IF_INVALID_PANE_HEIGHT_IN_REGISTRY
			SaveSetting(m_strTopPaneHeight, m_nTopPaneHeight, m_strDlgName);
		///end
		///------ Folger 10/15/2010 ORG-1252 MULTIPANE_DIALOG_BAD_LAYOUT_IF_INVALID_PANE_HEIGHT_IN_REGISTRY
		if ( 0 != m_nBottomPaneHeight )
		///------ End MULTIPANE_DIALOG_BAD_LAYOUT_IF_INVALID_PANE_HEIGHT_IN_REGISTRY
			SaveSetting(m_strBottomPaneHeight, m_nBottomPaneHeight, m_strDlgName);
		return TRUE;
	}
	
private :
	///Danice NEW_WAY_SHOW_TOP_AND_BOTTOM_PANE
	void saveButtonIDs(uint nButtonIDs[])
	{		
		m_vnButtonIDs.SetSize(0);
		for(int ii=0; nButtonIDs[ii]>0; ii++)
			m_vnButtonIDs.Add(nButtonIDs[ii]);
		m_vnButtonIDs.Add(0);
	}
	///end
	
	/// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
	void resizeDlgOnLeftPaneShowHide(bool bShow)
	{
		RECT rrSubPane;
		Control ccSubPaneMainControl;
		GetControlClientRect(m_nBottomMainID, rrSubPane, &ccSubPaneMainControl);		
		int nSubPaneWidth = RECT_WIDTH(rrSubPane) + 2 * GetControlGap();
		
		if( m_vnSubPaneRightButtonIDs.GetSize() > 0 && m_vnSubPaneRightButtonIDs[0] != 0 )
		{
			/// Iris 12/30/2010 ORG-1879 LAYER_CONTENTS_DLG_ADDED_TWO_BUTTONS_TO_SUBPANEL
			/*
			RECT rrButton;
			Control ccButton;
			GetControlClientRect(m_vnSubPaneRightButtonIDs[0], rrButton, &ccButton);
			nSubPaneWidth += RECT_WIDTH(rrButton) + GetControlGap();
			*/
			int nRight;
			for(int nn = 0; nn < m_vnSubPaneRightButtonIDs.GetSize() && m_vnSubPaneRightButtonIDs[nn] != 0; nn++)
			{
				RECT rrButton;
				GetControlClientRect(m_vnSubPaneRightButtonIDs[nn], rrButton);
				if( 0 == nRight || rrButton.right > nRight)
					nRight = rrButton.right;				
			}
			/// Iris 01/06/2011 ORG-1826-P8 LC_DLG_RESIZE_NOT_GOOD_WHEN_CLICK_SHOW_SUB_PANEL_BUTTON
			//if( nRight > 0 )
			if( nRight > 0 && nRight > rrSubPane.right )
			///End LC_DLG_RESIZE_NOT_GOOD_WHEN_CLICK_SHOW_SUB_PANEL_BUTTON
				nSubPaneWidth = nRight - rrSubPane.left + 2 * GetControlGap();
			///End LAYER_CONTENTS_DLG_ADDED_TWO_BUTTONS_TO_SUBPANEL
		}
		
		RECT rrMain;
		GetControlClientRect(m_nMainID, rrMain);
		
		// enlarge dialog's width according the width of subpane main control
		RECT rtDlg;
		m_wndDlg.GetWindowRect(&rtDlg);
		m_wndDlg.ScreenToClient(&rtDlg);
		rtDlg.left = bShow? rtDlg.left - nSubPaneWidth : rtDlg.left + nSubPaneWidth;
		int nDlgBottom = rtDlg.bottom;
		m_wndDlg.ClientToScreen(&rtDlg);		
		m_wndDlg.MoveWindow(&rtDlg);
		
		// move main control to left pane
		if( bShow )
		{
			rrSubPane.left = GetControlGap();
			rrSubPane.top = GetControlGap();
			rrSubPane.right = rrSubPane.left + nSubPaneWidth - 2 * GetControlGap();
			rrSubPane.bottom = nDlgBottom - GetControlGap();
			MoveControl(ccSubPaneMainControl, rrSubPane);
		}
		
		// move main pane controls to right pane
		int nOffset = bShow? nSubPaneWidth : 0 - nSubPaneWidth;
		vector<uint> vnMainPaneControls;
		if( GetMainPaneControlIDs(vnMainPaneControls) > 0 )
		{
			MoveControls(vnMainPaneControls, nOffset, 0);
		}		
	}
	
	void resizeLeftPaneOnDlgResize(int cx, int cy)
	{
		ASSERT(SUBPANE_POS_LEFT == m_nSubPanePosition);
		if( SUBPANE_POS_LEFT != m_nSubPanePosition )
			return;
		
		RECT rrSubPane;
		Control ccSubPaneMainControl;
		GetControlClientRect(m_nBottomMainID, rrSubPane, &ccSubPaneMainControl);
		
		RECT rrMainPane;
		GetControlClientRect(m_nMainID, rrMainPane);
		rrSubPane.left = GetControlGap();
		rrSubPane.top = GetControlGap();
		/// Iris 1/12/2010 ORG-1826-P8 FIX_NOT_REMEMBER_LEFT_PANE_WIDTH
		if( m_bResizeFirstTime && !IsBottomPaneShown() )
			rrSubPane.right = rrSubPane.left + GetBottomPaneHeight();
		else
		///End FIX_NOT_REMEMBER_LEFT_PANE_WIDTH
			rrSubPane.right = cx - RECT_WIDTH(rrMainPane) - 3 * GetControlGap();
		rrSubPane.bottom = cy - GetControlGap();
		MoveControl(ccSubPaneMainControl, rrSubPane);
		
		m_nBottomPaneHeight = RECT_WIDTH(rrSubPane); /// Iris 1/12/2010 ORG-1826-P8 FIX_NOT_REMEMBER_LEFT_PANE_WIDTH		
	}
	///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
	
private:
	bool				m_bResizeFirstTime;
	string				m_strBottomPaneHeight;
	string				m_strDlgName;
	//int					m_nUpdownButtonID;
	//int					m_nShowTopButtonID;
	vector<uint>		m_vnUpdownButtonIDs;	///Danice NEW_WAY_SHOW_TOP_AND_BOTTOM_PANE
	int					m_nMainID;
	int					m_nBottomMainID;
	BitmapRadioButton	m_chkShowViewBottomPane;
	BitmapRadioButton	m_chkShowViewTopPane;	///Danice NEW_WAY_SHOW_TOP_AND_BOTTOM_PANE
	int 				m_nBottomPaneHeight;// = 150;
	
	///Danice SAVE_TOP_PANE_HEIGHT
	string				m_strTopPaneHeight;
	int					m_nTopPaneHeight;
	///end
	bool				m_bBottomPaneOnRight; //CPY 9/24/06 XF_PREVIEW_DLG_NEED_PREVIEW_ON_THE_SIDE
	/// Iris 9/07/2010 OGR-9 LAYER_CONTENTS_DLG_NEED_LEFT_PANE
	int					m_nSubPanePosition; 
	vector<uint>		m_vnSubPaneRightButtonIDs;
	///End LAYER_CONTENTS_DLG_NEED_LEFT_PANE
	
	vector<uint>		m_vnButtonIDs;
	
	bool 				m_bResizePaneByResizingEdge;///Jasmine 01/17/11 ORG-1999 RESIZE_PANE_BY_RESIZING_EDGE
	
protected:
	int					m_nActiveTab;	///Sophy 7/13/2012 ORG-6207-S2 GETNPREVIEW_DLG_NEED_REMEMBER_ACTIVE_TAB_WHEN_REOPEN
	TabCtrlEx			m_BottomTab;
};

#endif //_MULTI_PANE_DLG
