/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *  SY 03/17/2006 QA70-7813 IMPORT_NETCDF_INTO_ORIGIN							*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

#include <Origin.h>
#include <Dialog.h>
#include "ODlg8.h"


class MoreMatrixObjDlg : public Dialog
{
public:
	MoreMatrixObjDlg() : Dialog(IDD_MATRIX_OBJECTS, "ODlg8")
	{
		InitMsgMap();
	}
	~MoreMatrixObjDlg()
	{
	}

	void SetMatrixLayer(MatrixLayer& ml)
	{
		m_mlActive = ml;
	}

protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
//	ON_DESTROY(OnDestroy)
	/// SY 03/17/2006 QA70-7813 IMPORT_NETCDF_INTO_ORIGIN
	ON_OK(OnClickOK)
	ON_BN_CLICKED(IDC_ACTIVATE, OnClickActivate)
	ON_BN_CLICKED(IDC_DELETE, OnClickDelete)
	ON_LBN_SELCHANGE(IDC_OBJECTS, OnSelChange)
	/// end IMPORT_NETCDF_INTO_ORIGIN
EVENTS_END

	BOOL OnInitDialog()
	{
		m_lbObjects = GetItem(IDC_OBJECTS);
		/// SY 03/17/2006 QA70-7813 IMPORT_NETCDF_INTO_ORIGIN
		m_btActivate = GetItem(IDC_ACTIVATE);
		m_btDelete = GetItem(IDC_DELETE);
		/// end IMPORT_NETCDF_INTO_ORIGIN

		UpdateObjectList();
		UpdateButtons();
		return TRUE;
	}
	
	/// SY 03/17/2006 QA70-7813 IMPORT_NETCDF_INTO_ORIGIN
	BOOL SetActiveObject(int nIndex)
	{
		if( m_mlActive.IsValid() )
			return m_mlActive.SetActive(nIndex);
		return FALSE;
	}
	
	BOOL OnSelChange(Control ctrl)
	{
		UpdateButtons();
		return TRUE;
	}
	/// end IMPORT_NETCDF_INTO_ORIGIN

	BOOL OnClickActivate(Control ctrl)
	{
		/// SY 03/17/2006 QA70-7813 IMPORT_NETCDF_INTO_ORIGIN
		int nIndex = m_lbObjects.GetCurSel();
		return SetActiveObject(nIndex);
		/// end IMPORT_NETCDF_INTO_ORIGIN
	}

	BOOL OnClickOK()
	{
		/// SY 03/17/2006 QA70-7813 IMPORT_NETCDF_INTO_ORIGIN
		if( m_mlActive.IsValid() )
		{
			int nActiveObj = m_mlActive.GetActive();
			int nIndex = m_lbObjects.GetCurSel();
			if( nActiveObj != nIndex )
				return SetActiveObject(nIndex);
		}
		/// end IMPORT_NETCDF_INTO_ORIGIN
		
		return TRUE;
	}

	BOOL OnClickDelete(Control ctrl)
	{
		return TRUE;
	}

	void UpdateObjectList()
	{
		string str;
		int nIndex = 0;
		while( true )
		{
			MatrixObject mo(m_mlActive, nIndex);
			if( !mo )
				break;
			nIndex++;
			str.Format("Frame %d", nIndex);
			m_lbObjects.AddString(str);
		}
		
	}

	void UpdateButtons()
	{
		/// SY 03/17/2006 QA70-7813 IMPORT_NETCDF_INTO_ORIGIN
		int nSelCount = m_lbObjects.GetSelCount();
		
		m_btActivate.Enable = (nSelCount == 1);
		m_btDelete.Enable = (nSelCount > 0);
		/// end IMPORT_NETCDF_INTO_ORIGIN
	}

private:
	ListBox m_lbObjects;
	Button m_btActivate;
	Button m_btDelete;
	MatrixLayer m_mlActive;
};

int DoMoreMatrixObjectDialog(MatrixLayer& ml)
{
	MoreMatrixObjDlg dlg;
	dlg.SetMatrixLayer(ml);
	dlg.DoModal();

	/// SY 03/17/2006 QA70-7813 IMPORT_NETCDF_INTO_ORIGIN
	///	return 0;
	return ml.GetActive();
	/// end  IMPORT_NETCDF_INTO_ORIGIN
}
