/*------------------------------------------------------------------------------*
 * File Name: MatlabCmdControl.h												*
 * Creation: Jasmine 8/02/05													*
 * Purpose: for Matlab Console Dialog command 				 					*
 * Copyright (c) OriginLab Corp.	2005										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Jasmine 8/12/05 QA70-7998 v8.0286 CHECK_MATLAB_AVAILABILITY 					*
 * Jasmine 8/15/05 MOVE_TO_MATCMDCONTROL										*
 * Jasmine 08/24/05 QA70-7998 v8.0292 SENDMESSAGE_TO_CLOSE_WND					*
 * Jasmine 08/24/05 ADD_DESCONSTRUCT_FUNC										*
 * Jasmine 08/24/05 QA70-7998 v8.0292 PUT_GET_COMPLEX_EXCHANGE					*
 * Jasmine 03/24/06 QA70-7998 v8.0378 PUT_GET_REAL_MESSAGE						*
 * SY 2007-01-15 v8.0542 QA70-8759 NEW_NOTATION_FOR_TOOLS						*
 * Jasmine 03/14/07 QA70-9464  FIX_MATLAB_CONSOLE_BUG							*
 * Arvin/Cheney 2007-3-16 REWRITE_DO_ORIGIN_CMD									*
 * Cheney 2007-4-13 SHOULD_MAKE_DATA_RANGE_STRING_WHEN_MATRIX_LAYER				*
 * Cheney 2007-7-20 ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB			*
 * AW 09/28/07 QA80-9464 MORE_ON_MATLAB_CONSOLE									*
 * Kyle 09/24/08 SET_NO_NEED_TO_LOCALIZE										*
 *------------------------------------------------------------------------------*/
#include "CmdControl.h"

#include <externApps.h> // matlab class
#include <okocUtils.h> 	///	SY 2007-01-15 v8.0542 QA70-8759 NEW_NOTATION_FOR_TOOLS

///////////////////////////////////////////////////////////////////////////////////////////////////////
///Cheney 2007-7-20 ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB
//enum {CMDID_PUT_REAL, CMDID_GET_REAL, CMDID_PUT_COMPLEX, CMDID_GET_COMPLEX, CMDID_EXIT, CMDID_QUIT, CMDID_CLC, CMDID_PUT_WKS_REAL, CMDID_PUT_WKS_COMPLEX, CMDID_PUT_WKS_STRING, CMDID_GET_WKS_REAL, CMDID_GET_WKS_COMPLEX, CMDID_COUNT};///Arvin/Cheney 2007-3-16 REWRITE_DO_ORIGIN_CMD
//static StringArray s_asCmdList = {"pr", "gr", "pc", "gc",                   "exit",     "quit",     "clc", 	"pwr", 	"pwc", "pws", "gwr", "gwc"}; ///Arvin/Cheney 2007-3-16 REWRITE_DO_ORIGIN_CMD
enum {CMDID_PUT_REAL, CMDID_GET_REAL, CMDID_PUT_COMPLEX, CMDID_GET_COMPLEX, CMDID_EXIT, CMDID_QUIT, CMDID_CLC, CMDID_PUT_WKS_REAL, CMDID_PUT_WKS_COMPLEX, CMDID_PUT_WKS_STRING, CMDID_GET_WKS_REAL, CMDID_GET_WKS_COMPLEX, CMDID_GET_WORK_SPACE, CMDID_COUNT};
static StringArray s_asCmdList = {"pr", "gr", "pc", 			"gc",         "exit",     "quit",     "clc", 			"pwr", 				"pwc", 				"pws", 					"gwr", 				"gwc", 					"gwkspace"}; 
///end ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB
#define STR_NO_MATLAB 		_L("Matlab not available")
#define _USE_COMPLEX_TO_FIX_PR_FOR_MATLAB_7		///Jasmine 03/14/07 QA70-9464  FIX_MATLAB_CONSOLE_BUG


///Arvin/Cheney 2007-3-16 REWRITE_DO_ORIGIN_CMD

//Error Message
#define STR_INVALID_RANGE_FOR_PUT_DATA_TO_MATLAB	_L("Invalid range for putting data to matlab varible!")
#define STR_INVALID_RANGE_FOR_GET_DATA_FROM_MATLAB	_L("Invalid range for getting data from matlab varible!")
#define STR_FAIL_GET_DATA_FROM_DATA_RANGE			_L("Failed to get data from selected range")
#define STR_FAIL_SET_DATA_TO_DATA_RANGE				_L("Failed to set data to selected range")
#define STR_FAIL_PUT_DATA_TO_MATLAB					_L("Failed to put data to Matlab!")
#define STR_INVALID_MATLAB_OBJ						_L("Invalid Matlab Object")
#define STR_NOT_FOUND_MATRIX_IN_MATLAB				_L(": matrices not found in Matlab!")
#define STR_FAIL_PUT_MATRIX_TO_MATLAB				_L("Failed to put matrix to matlab")
#define STR_FAIL_GET_MATRIX_LAYER_FROM_DATA_RANGE	_L("Failed to get matrix layer from selected range")
#define STR_FAIL_GET_WKS_FROM_DATA_RANGE			_L("Failed to get worksheet from selected range")
#define STR_WRONG_DATA_TYPE							_L(": we can not support this type")
///Arvin 07/27/07 NEED_KEEP_DATA_TYPE_AFTER_GET_FROM_MATLAB
///Kyle 09/24/08 SET_NO_NEED_TO_LOCALIZE
//#define STR_INT										_L("int")
//#define STR_CHAR									_L("char")
//#define STR_SINGLE									_L("single")
//#define STR_LOGICAL									_L("logical")
//#define STR_INT8  									_L("int8")
//#define STR_INT16									_L("int16")
//#define STR_INT32									_L("int32")
//#define STR_INT64									_L("int64")
//#define STR_UINT8									_L("uint8")
//#define STR_UINT16									_L("uint16")
//#define STR_UINT32									_L("uint32")
//#define STR_UINT64									_L("uint64")
//#define STR_DOUBLE									_L("double")
#define STR_INT										"int"
#define STR_CHAR									"char"
#define STR_SINGLE									"single"
#define STR_LOGICAL									"logical"
#define STR_INT8  									"int8"
#define STR_INT16									"int16"
#define STR_INT32									"int32"
#define STR_INT64									"int64"
#define STR_UINT8									"uint8"
#define STR_UINT16									"uint16"
#define STR_UINT32									"uint32"
#define STR_UINT64									"uint64"
#define STR_DOUBLE									"double"
///End SET_NO_NEED_TO_LOCALIZE
///end NEED_KEEP_DATA_TYPE_AFTER_GET_FROM_MATLAB

//Error Code
enum{
	MCERR_NO_ERROR 									= 0,
	MCERR_INVALID_MATLAB_OBJECT 					= -1,
	MCERR_INVALID_RANGE   							= -2,
	MCERR_INVALID_MATRIX							= -3,
	MCERR_FAILED_PUT_DATA_TO_MATLAB					= -4,
	MCERR_FAILED_GET_MATRIX_FROM_MATLAB 			= -6,
	MCERR_FAILED_GET_DATA_FROM_RANGE				= -7,
	MCERR_FAILED_SET_DATA_TO_RANGE					= -8,
	MCERR_IMAGE_AND_REAL_MAT_SIZE_NOT_EQUAL 		= -9,
	MCERR_FAIL_GET_MATRIX_LAYER_FROM_DATA_RANGE		= -10,
	MCERR_FAILED_SET_RANGE_DATA_TYPE 				= -11,
	MCERR_FAIL_SET_MATRIX_DATA_TYPE_FROM_RANGE 		= -12,
	MCERR_WRONG_DATA_TYPE							= -13,
};

//base class
class RangeML
{
public:
	///Arvin 03/28/07 QA70-9503 CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
   	//RangeML(LPCSTR lpcszRangeStr);
   	RangeML(LPCSTR lpcszRangeStr, bool bOutput = false);
   	///end CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
   
   	bool 	SetMLObj(Matlab* pMLObj)
   	{
		if(pMLObj == NULL)
			return false;
		
		m_pMLObj = pMLObj;
		return true;
	}
	
	//send real data to matlab
	virtual int SendRealToMatlab(LPCSTR lpcszMatlabVar, string& strErrMsg);
	 	 
	//send complex data to matlab
	virtual int SendComplexToMatlab(LPCSTR lcszMatlabVar, string& strErrMsg);
	 
   	//get real data from matlab, will transfer matlab var to double
	virtual int GetRealFromMatlab(LPCSTR lpcszMatlabVar, string& strErrMsg);
   	
   	//get complex data from matlab
   	virtual int GetComplexFromMatlab(LPCSTR lpcszMatlabVar, string& strErrMsg);
   	
   	///Arvin 07/27/07 NEED_KEEP_DATA_TYPE_AFTER_GET_FROM_MATLAB
    int GetDataType(LPCSTR lpcszType);
    ///end NEED_KEEP_DATA_TYPE_AFTER_GET_FROM_MATLAB
protected:
	//when get data from matlab, layer's data type should match matlab var type
	virtual bool SetLayerDataType(DataRange& dr, int nCols, int nType, string& strErrMsg)
	{ 
		return false;
	}
	
	bool SetDataRange(DataRange& dr)
	{
		if(!dr.IsValid())
			return false;
		
		m_dr = dr;
		return true;
	}
	
protected:
	Matlab* m_pMLObj;
	
	DataRange m_dr;
};


//Worksheet
class WksRangeML : public RangeML
{
public:
	///Arvin 03/28/07 QA70-9503 CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
	//WksRangeML(LPCSTR lpcszRangeStr)
	WksRangeML(LPCSTR lpcszRangeStr, bool bOutput = false)
	///end CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
	{
		string strRange = lpcszRangeStr;
		///Arvin 03/28/07 QA70-9503 CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
		/*
		if(checkMakeFullRange(strRange))
		{
			DataRange dr;
 			dr.AddInput(strRange);
 			SetDataRange(dr);	
		}
		*/
		DataRange dr;
		int nErr = dr.Create(strRange, XVT_DATARANGE, bOutput);
		if(nErr != 0)
			return;
		SetDataRange(dr);	
		///end 	CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
	}
	
   	bool GetSheetName(string& strSheet)
   	{
   		Worksheet wks;
   		int c1, c2;
   		m_dr.GetRange(wks, c1, c2);
   		
   		if(!wks.IsValid())
   			return false;
   		
   		wks.GetName(strSheet);
   		return true;
   	}
   	
protected:
	//virtual
	bool SetLayerDataType(DataRange& dr, int nCols, int nType, string& strErrMsg);
	
private:
	bool checkMakeFullRange(string& strRange);
};


//Worksheet real
class RWksRangeML : public WksRangeML
{
public:	
	///Arvin 03/28/07 QA70-9503 CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
	//RWksRangeML(LPCSTR lpcszRangeStr) : WksRangeML(lpcszRangeStr){}
	RWksRangeML(LPCSTR lpcszRangeStr, bool bOutput = false) : WksRangeML(lpcszRangeStr, bOutput){}
	///end CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
};


//Worksheet complex
class CWksRangeML : public WksRangeML
{
public:
	///Arvin 03/28/07 QA70-9503 CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
	//CWksRangeML(LPCSTR lpcszRangeStr) : WksRangeML(lpcszRangeStr){}
	CWksRangeML(LPCSTR lpcszRangeStr, bool bOutput = false) : WksRangeML(lpcszRangeStr, bOutput){}
	///end CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
};


//Worksheet string
class StrWksRangeML : public WksRangeML
{
public:
	///Arvin 03/28/07 QA70-9503 CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
	//StrWksRangeML(LPCSTR lpcszRangeStr) : WksRangeML(lpcszRangeStr){}
	StrWksRangeML(LPCSTR lpcszRangeStr, bool bOutput = false) : WksRangeML(lpcszRangeStr, bOutput){}
	///end CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
   
   	int SendStringToMatlab(LPCSTR lcszMatlabVar, string& strErrMsg);

   	int GetStringFromMatlab(LPCSTR lpcszMatlabVar, string& strErrMsg);
	
private:	
	void makeStrVectorToStr(vector<string>& vs, string& str);
	
	int getLengths(vector<string>& vs, vector<int> &vret);
	
	// In MATLAB string array, all rows in the bracketed expression must have the same number of columns.
	void checkAndPadding(vector<string>& vs);
};


//MatrixLayer
class MatRangeML : public RangeML
{
	
public:
	///Arvin 03/28/07 QA70-9503 CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
	/*
	MatRangeML(LPCSTR lpcszRangeStr)
	{
		DataRange dr;
		checkMakeDataRange(lpcszRangeStr, dr);
		SetDataRange(dr);
	}
	*/
	///Cheney 2007-7-20 ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB	
	//MatRangeML(LPCSTR lpcszRangeStr, bool bOutput = false)
	MatRangeML(LPCSTR lpcszRangeStr, bool bOutput = false, bool bMakeRange = true)
	///end ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB
	{
		DataRange dr;
		///Cheney 2007-4-13 SHOULD_MAKE_DATA_RANGE_STRING_WHEN_MATRIX_LAYER
		//if from/to matrix, cmd is such as: pr var1, var2,..
		//need to make range string according to var's name
		string strRange(lpcszRangeStr);
		if(bMakeRange) ///Cheney 2007-7-20 ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB	
			makeDataRangeString(strRange);
		///end SHOULD_MAKE_DATA_RANGE_STRING_WHEN_MATRIX_LAYER
		///Arvin 07/27/07 GET_MATRIX_TO_WRONG_DEST_RANGE
		//int nErr = dr.Create(lpcszRangeStr, XVT_MATRIX, bOutput);
		int nErr = dr.Create(strRange, XVT_MATRIX, bOutput);
		///end GET_MATRIX_TO_WRONG_DEST_RANGE
		if(nErr != 0)
			return;

		SetDataRange(dr);
	}
	///end CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
protected:	
	//virtual
	bool SetLayerDataType(DataRange& dr, int nCols, int nType, string& strErrMsg);
	
private:
	//Make a data range use matrix
	///Cheney 2007-4-13 SHOULD_MAKE_DATA_RANGE_STRING_WHEN_MATRIX_LAYER
	//bool checkMakeDataRange(LPCSTR lpcszRangeStr, DataRange& dr);
	bool makeDataRangeString(string& strRange);
	///end SHOULD_MAKE_DATA_RANGE_STRING_WHEN_MATRIX_LAYER
};


//MatrixLayer real
class RMatRangeML : public MatRangeML
{
public:
	///Arvin 03/28/07 QA70-9503 CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
	//RMatRangeML(LPCSTR lpcszRangeStr) : MatRangeML( lpcszRangeStr){ }
	///Cheney 2007-7-20 ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB	
	//RMatRangeML(LPCSTR lpcszRangeStr, bool bOutput = false) : MatRangeML( lpcszRangeStr, bOutput){ }
	RMatRangeML(LPCSTR lpcszRangeStr, bool bOutput = false, bool bMakeRange = true) : MatRangeML( lpcszRangeStr, bOutput, bMakeRange){ }
	///end ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB
	///end CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
};


//MatrixLayer Complex
class CMatRangeML : public MatRangeML
{
public:
	///Arvin 03/28/07 QA70-9503 CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
	//CMatRangeML(LPCSTR lpcszRangeStr) : MatRangeML( lpcszRangeStr){ }
	///Cheney 2007-7-20 ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB	
	//CMatRangeML(LPCSTR lpcszRangeStr, bool bOutput = false) : MatRangeML( lpcszRangeStr, bOutput){ }
	CMatRangeML(LPCSTR lpcszRangeStr, bool bOutput = false, bool bMakeRange = true) : MatRangeML( lpcszRangeStr, bOutput, bMakeRange){ }
	///end ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB
	///end CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
};


////////////////////////////////////////////////////////////////////////
//////////////////////////Member Function Body//////////////////////////
////////////////////////////////////////////////////////////////////////

///Arvin 07/27/07 NEED_KEEP_DATA_TYPE_AFTER_GET_FROM_MATLAB
int RangeML::GetDataType(LPCSTR lpcszType)
{
	string strType(lpcszType);
	strType.TrimLeft();
	strType.TrimRight();
	if(strType.Compare(STR_CHAR)==0)
		return FSI_CHAR;
	if(strType.Compare(STR_INT8)==0 || strType.Compare(STR_INT16)==0)
		return FSI_SHORT;
	if(strType.Compare(STR_LOGICAL)==0 || strType.Compare(STR_UINT8)==0 || strType.Compare(STR_UINT16)==0)
		return FSI_USHORT;
	if(strType.Compare(STR_INT32)==0)
		return FSI_LONG;
	if(strType.Compare(STR_UINT32)==0)
		return FSI_ULONG;
	if(strType.Compare(STR_INT64)==0 || strType.Compare(STR_UINT64)==0 || strType.Compare(STR_SINGLE)==0 || strType.Compare(STR_DOUBLE)==0)
		return FSI_DOUBLE;
	
	return -1;
}
///end NEED_KEEP_DATA_TYPE_AFTER_GET_FROM_MATLAB
    
//send real data to matlab
int RangeML::SendRealToMatlab(LPCSTR lpcszMatlabVar, string& strErrMsg)
{
	Matlab* pMLObj = m_pMLObj;
	if(pMLObj == NULL)
	{
		strErrMsg = STR_INVALID_MATLAB_OBJ;
		return MCERR_INVALID_MATLAB_OBJECT;
	}
	
	DataRange dr;
	dr = m_dr;
	if(!dr.IsValid())
	{
		strErrMsg = STR_INVALID_RANGE_FOR_PUT_DATA_TO_MATLAB;
		return MCERR_INVALID_MATRIX;
	}
	
	matrix mm;
	DWORD dwRules = DRR_NO_FACTORS;
	if(dr.GetData(mm, dwRules) != 1)
	{
		strErrMsg = STR_FAIL_GET_DATA_FROM_DATA_RANGE;
		return MCERR_FAILED_GET_DATA_FROM_RANGE;
	}
	
	ocu_NANUM_to_nan((double *)mm, mm.GetNumRows() * mm.GetNumCols());
	
	bool bSucsess;
#ifndef _USE_COMPLEX_TO_FIX_PR_FOR_MATLAB_7
	bSucsess = pMLObj->PutMatrix(lpcszMatlabVar, &mm);
#else	// easwar found if imaginary matrix = 0, MATLAB automatically create real matrix, so since sending just real didn't work, this is a workaround
	matrix m1;
	m1 = mm; m1 = 0;
	bSucsess = pMLObj->PutMatrix(lpcszMatlabVar, &mm, &m1);
#endif	//_USE_COMPLEX_TO_FIX_PR_FOR_MATLAB_7

	if(!bSucsess)
	{
		strErrMsg = STR_FAIL_PUT_MATRIX_TO_MATLAB;
		return MCERR_FAILED_PUT_DATA_TO_MATLAB;
	}
	
	return MCERR_NO_ERROR;
}
 	 
//send complex data to matlab
int RangeML::SendComplexToMatlab(LPCSTR lcszMatlabVar, string& strErrMsg)
{
	Matlab* pMLObj = m_pMLObj;
	if(pMLObj == NULL)
	{
		strErrMsg = STR_INVALID_MATLAB_OBJ;
		return MCERR_INVALID_MATLAB_OBJECT;
	}
		
	DataRange dr;
	dr = m_dr;
	if(!dr.IsValid())
	{
		strErrMsg = STR_INVALID_RANGE_FOR_PUT_DATA_TO_MATLAB;
		return MCERR_INVALID_RANGE;
	}
	
	matrix<complex> mat;
	DWORD dwRules = DRR_COMPLEX;
	if(dr.GetData(mat, dwRules) != 1)
	{
		strErrMsg = STR_FAIL_GET_DATA_FROM_DATA_RANGE;
		return MCERR_FAILED_GET_DATA_FROM_RANGE;
	}
	
	matrix mmR, mmI;
	mat.GetReal(mmR);
	mat.GetImaginary(mmI);
	
	if(mmI.GetNumRows()!=mmR.GetNumRows() || mmI.GetNumCols()!=mmR.GetNumCols())
	{
		strErrMsg = "\r\n" + _L("Inconsistent Matrix Size.");
		return MCERR_IMAGE_AND_REAL_MAT_SIZE_NOT_EQUAL;
	}
		
	ocu_NANUM_to_nan((double *)mmR, mmR.GetNumRows() * mmR.GetNumCols());
	ocu_NANUM_to_nan((double *)mmI, mmI.GetNumRows() * mmI.GetNumCols());
		
	bool bSuccess = pMLObj->PutMatrix(lcszMatlabVar, &mmR, &mmI);
	if(!bSuccess)
	{
		strErrMsg = STR_FAIL_PUT_DATA_TO_MATLAB;
		return MCERR_FAILED_PUT_DATA_TO_MATLAB;
	}
	
	return MCERR_NO_ERROR;
}
 
//get real data from matlab, will transfer matlab var to double
int RangeML::GetRealFromMatlab(LPCSTR lpcszMatlabVar, string& strErrMsg)
{		
	Matlab* pMLObj = m_pMLObj;	
	if(pMLObj == NULL)
	{
		strErrMsg = STR_INVALID_MATLAB_OBJ;
		return MCERR_INVALID_MATLAB_OBJECT;
	}

	string strNamesTemp = "TMP_Var_For_Type", strTypeTmpe = "TMP_Var_For_Type_Transfer", strExecute, strResult;
	///Cheney 2007-7-20 ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB	
	//strExecute.Format("%s=whos('%s'); %s.class", strNamesTemp, lpcszMatlabVar, strNamesTemp);					
	strExecute.Format("%s=whos('%s'); %s=%s.class", strNamesTemp, lpcszMatlabVar, strTypeTmpe, strNamesTemp);					
	///end ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB
	bool bSuccess = pMLObj->Execute(strExecute, strResult);
	strExecute.Format("clear %s", strNamesTemp);
	pMLObj->Execute(strExecute);
	///Cheney 2007-7-20 ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB	
	strExecute.Format("clear %s", strTypeTmpe);
	pMLObj->Execute(strExecute);
	///end ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB
	
	int nFind = -1;
	if(!strResult.IsEmpty())
	{
		nFind = strResult.Find(STR_INT);
		if(0 > nFind)
			nFind = strResult.Find(STR_CHAR);
		if(0 > nFind)
			nFind = strResult.Find(STR_SINGLE);
	}
	
	if(-1 < nFind)
	{
		strExecute.Format("%s=%s;" "%s=double(%s);", strTypeTmpe, lpcszMatlabVar, lpcszMatlabVar, strTypeTmpe);
		pMLObj->Execute(strExecute);
	}

	///Arvin 07/27/07 NEED_KEEP_DATA_TYPE_AFTER_GET_FROM_MATLAB
	string strType = strResult.GetToken(1, '=');
	int nType = GetDataType(strType);
	if(nType < 0)
	{
		strErrMsg = strType + STR_WRONG_DATA_TYPE;
		return MCERR_WRONG_DATA_TYPE;
	}
	///END NEED_KEEP_DATA_TYPE_AFTER_GET_FROM_MATLAB	
	
	DataRange dr;
	dr = m_dr;
	if(!dr.IsValid())
	{
		strErrMsg = STR_INVALID_RANGE_FOR_GET_DATA_FROM_MATLAB;
		return MCERR_INVALID_RANGE;
	}
	
	matrix mm;
	bSuccess = pMLObj->GetMatrix(lpcszMatlabVar, &mm);
	if(!bSuccess)
	{
		string str(lpcszMatlabVar);
		strErrMsg = str + " " + STR_NOT_FOUND_MATRIX_IN_MATLAB;
		
		MatrixLayer ml;
		dr.GetParent(ml);
		if(ml.IsValid())
			ml.Destroy();
		
		return MCERR_FAILED_GET_MATRIX_FROM_MATLAB;
	}
	
	///Arvin 07/27/07 NEED_KEEP_DATA_TYPE_AFTER_GET_FROM_MATLAB
	//if(!SetLayerDataType(dr, mm.GetNumCols(), FSI_DOUBLE, strErrMsg))
	if(!SetLayerDataType(dr, mm.GetNumCols(), nType, strErrMsg))
	///end NEED_KEEP_DATA_TYPE_AFTER_GET_FROM_MATLAB
		return MCERR_FAIL_SET_MATRIX_DATA_TYPE_FROM_RANGE;
	
	ocu_nan_inf_to_NANUM((double *)mm, mm.GetNumRows() * mm.GetNumCols());
	
	if(!dr.SetData(mm))
	{
		strErrMsg = STR_FAIL_SET_DATA_TO_DATA_RANGE;
		return MCERR_FAILED_SET_DATA_TO_RANGE;
	}
	
	return MCERR_NO_ERROR;
}

//get complex data from matlab
int RangeML::GetComplexFromMatlab(LPCSTR lpcszMatlabVar, string& strErrMsg)
{
	Matlab* pMLObj = m_pMLObj;
	if(pMLObj == NULL)
	{
		strErrMsg = STR_INVALID_MATLAB_OBJ;
		return MCERR_INVALID_MATLAB_OBJECT;
	}
	
	DataRange dr;
	dr = m_dr;
	if(!dr.IsValid())
	{
		strErrMsg = STR_INVALID_RANGE_FOR_GET_DATA_FROM_MATLAB;
		return MCERR_INVALID_RANGE;
	}
	
	matrix mr, mi;
	bool bSuccess = pMLObj->GetMatrix(lpcszMatlabVar, &mr, &mi);
	/// end NEW_NOTATION_FOR_TOOLS
	if(!bSuccess)
	{
		string str(lpcszMatlabVar);
		strErrMsg = str + " " + STR_NOT_FOUND_MATRIX_IN_MATLAB;
		
		MatrixLayer ml;
		dr.GetParent(ml);
		if(ml.IsValid())
			ml.Destroy();
		
		return MCERR_FAILED_GET_MATRIX_FROM_MATLAB;
	}
	
	ocu_nan_inf_to_NANUM((double *)mr, mr.GetNumRows() * mr.GetNumCols());
	ocu_nan_inf_to_NANUM((double *)mi, mi.GetNumRows() * mi.GetNumCols());
	
	matrix<complex> mm;
	mm.MakeComplex(mr, mi);
	
	if(!SetLayerDataType(dr, mm.GetNumCols(), FSI_COMPLEX, strErrMsg))
		return MCERR_FAIL_SET_MATRIX_DATA_TYPE_FROM_RANGE;
	
	if(!dr.SetData(mm, 0, FALSE, DRS_COMPLEX))
	{
		strErrMsg = STR_FAIL_SET_DATA_TO_DATA_RANGE;
		return MCERR_FAILED_SET_DATA_TO_RANGE;
	}
	
	return MCERR_NO_ERROR;
}

bool WksRangeML::SetLayerDataType(DataRange& dr, int nCols, int nType, string& strErrMsg)
{
	if(!dr.IsValid())
	{
		strErrMsg = STR_INVALID_RANGE_FOR_PUT_DATA_TO_MATLAB;
		return false;
	}
	
	Worksheet wks;
	int c1, c2;
	dr.GetRange(wks, c1, c2);
	if(!wks.IsValid())
	{
		strErrMsg = STR_FAIL_GET_WKS_FROM_DATA_RANGE;
		return false;
	}
	
	if(c2-c1+1 < nCols)
		c2 = c1+nCols-1;

	for(int ii = c1; ii <= c2; ii++)
	{
		int nNumCols = wks.GetNumCols();
		if(ii > nNumCols-1)
			wks.AddCol();

		wks.Columns(ii).SetInternalData(nType);
	}
	
	return true;
}

bool WksRangeML::checkMakeFullRange(string& strRange)
{
	strRange.TrimLeft();
	if( strRange.IsEmpty() )
		return false;
	 
	 Datasheet ds = Project.ActiveLayer();
	 if( !ds.IsValid() )
	 	return false;
	 
	 Page pg = Project.Pages(); // Get the active page
	 if( strRange.Find('!') < 0 ) // need to add [book]sheet!
	 {
	 	strRange = "[" + pg.GetName() + "]" + ds.GetName() + "!" + strRange;
	 }
	 else if(strRange[0] != '[') // need to add [book]
	 {
	 	strRange = "[" + pg.GetName() + "]" + strRange;
	 }
	 
	 return true;
}

int StrWksRangeML::SendStringToMatlab(LPCSTR lcszMatlabVar, string& strErrMsg)
{
	Matlab* pMLObj = m_pMLObj;
	if(pMLObj == NULL)
	{
		strErrMsg = STR_INVALID_MATLAB_OBJ;
		return MCERR_INVALID_MATLAB_OBJECT;
	}
	
	DataRange dr;
	dr = m_dr;
	if(!dr.IsValid())
	{
		strErrMsg = STR_INVALID_RANGE_FOR_PUT_DATA_TO_MATLAB;
		return MCERR_INVALID_RANGE;
	}
	
	vector<string> strVec;
	if(!dr.GetData(&strVec, 0))
	{
		strErrMsg = STR_FAIL_GET_DATA_FROM_DATA_RANGE;
		return MCERR_FAILED_GET_DATA_FROM_RANGE;
	}
	
	string str;
	makeStrVectorToStr(strVec, str);
			
	string strCmd;
	strCmd.Format("%s = cellstr(%s)", lcszMatlabVar, str);
	bool bSuccess = pMLObj->Execute(strCmd, strErrMsg);
	if(!bSuccess)
		return MCERR_FAILED_PUT_DATA_TO_MATLAB;
}

int StrWksRangeML::GetStringFromMatlab(LPCSTR lpcszMatlabVar, string& strErrMsg)
{
	strErrMsg = STR_INVALID_MATLAB_OBJ;
	return MCERR_INVALID_MATLAB_OBJECT;	
}

void StrWksRangeML::makeStrVectorToStr(vector<string>& vs, string& str)
{
	if( 0 == vs.GetSize() )
		return;
	
	str = "[";
	checkAndPadding(vs);
	
	for( int ii = 0; ii < vs.GetSize(); ii++)
	{
		str += "\'"+ vs[ii] + "\';";
	}
	str.Delete( str.GetLength() - 1 ); 
	str += "]";
}

int StrWksRangeML::getLengths(vector<string>& vs, vector<int> &vret)
{
	int nMaxWidth = 0;
	int nTemp;
	int nSize = vs.GetSize();
	
	vret.SetSize(nSize);
	for(int ii = 0; ii < nSize; ii++)
	{
		nTemp = lstrlen(vs[ii]);
		if( nTemp > nMaxWidth )
			nMaxWidth = nTemp;
		
		vret[ii] = nTemp;
	}
	
	return nMaxWidth;
}

// In MATLAB string array, all rows in the bracketed expression must have the same number of columns.
void StrWksRangeML::checkAndPadding(vector<string>& vs)
{
	vector<int> vlen;
	int nMaxLen = getLengths(vs, vlen);

	int iNumPad;
	for( int ii = 0; ii < vlen.GetSize(); ii++ )
	{
		iNumPad = nMaxLen - vlen[ii];
		if( iNumPad > 0 )
		{
			while( iNumPad-- > 0 )
				vs[ii] += " ";
		}
	}
}

bool MatRangeML::SetLayerDataType(DataRange& dr, int nCols, int nType, string& strErrMsg)
{
	if(!dr.IsValid())
	{
		strErrMsg = STR_INVALID_RANGE_FOR_PUT_DATA_TO_MATLAB;
		return false;
	}
	
	MatrixLayer ml;
	dr.GetParent(ml);
	if(!ml.IsValid())
	{
		strErrMsg = STR_FAIL_GET_MATRIX_LAYER_FROM_DATA_RANGE;
		return false;
	}
	
	ml.SetInternalData(nType);
	return true;
}

///Cheney 2007-4-13 SHOULD_MAKE_DATA_RANGE_STRING_WHEN_MATRIX_LAYER
////Make a data range use matrix
//bool MatRangeML::checkMakeDataRange(LPCSTR lpcszRangeStr, DataRange& dr)
//{
	//string str = lpcszRangeStr;
	//string strMatName;
	//if( !okoc_find_dataset(str, &strMatName, NULL, DATASET_MATRIX) )
		//strMatName = lpcszRangeStr;
	//
	//MatrixLayer mltemp(strMatName);
	//if(!mltemp)
	//{
		//mltemp.Create();
		//mltemp.GetPage().Rename(strMatName);
	//}
	//string strPage = mltemp.GetPage().GetName();
	//string strSheet = mltemp.GetName();
	//string strRng;
	//strRng.Format("[%s]%s!1", strPage, strSheet);
	//dr.Add("X", strRng);
	//return true;
//}
/////end SHOULD_MAKE_DATA_RANGE_STRING_WHEN_MATRIX_LAYER
/////end REWRITE_DO_ORIGIN_CMD
bool MatRangeML::makeDataRangeString(string& strRange)
{
	string strMatName;
	if( !okoc_find_dataset(strRange, &strMatName, NULL, DATASET_MATRIX) )
		strMatName = strRange;
	
	MatrixLayer mltemp(strMatName);
	///Arvin 07/27/07 GET_MATRIX_TO_WRONG_DEST_RANGE
	//if(!mltemp)
	/// AW 09/28/07 QA80-9464 MORE_ON_MATLAB_CONSOLE
	//MatrixPage  mPage = mltemp.GetPage();
	MatrixPage  mPage;
	if ( mltemp )
		mPage = mltemp.GetPage();
	/// END MORE_ON_MATLAB_CONSOLE
	if(!mltemp || !mPage)
	///end GET_MATRIX_TO_WRONG_DEST_RANGE
	{
		mltemp.Create();
		mltemp.GetPage().Rename(strMatName);
	}
	string strPage = mltemp.GetPage().GetName();
	string strSheet = mltemp.GetName();
	strRange.Format("[%s]%s!1", strPage, strSheet);
	return true;
}
///end SHOULD_MAKE_DATA_RANGE_STRING_WHEN_MATRIX_LAYER

class MatlabCmdControl : public CmdControl
{
public:
	MatlabCmdControl()
	{
		m_pMATLABObj = NULL;	///Jasmine 8/15/05 MOVE_TO_MATCMDCONTROL
	}
	///Jasmine 08/24/05 ADD_DESCONSTRUCT_FUNC
	~MatlabCmdControl()
	{
		DelMatlabobj();
	}
		
	//virtual 
	void OnSetFocus()
	{
	}
	void addString(LPCSTR lpcszText, BOOL bAddNewLine=TRUE)
	{
		///Arvin/Cheney 2007-3-16 REWRITE_DO_ORIGIN_CMD	
		//Write(lpcszText);
		string str(lpcszText);
		Write(str + "\r\n");
		///end REWRITE_DO_ORIGIN_CMD
		if(bAddNewLine)
		{
			ReplaceSel("\r\n");
			SetSel(-1,-1);
		}
	}
	void MatlabobjCreate()
	{
		m_pMATLABObj = new Matlab(FALSE);
		return;
	}
	///Jasmine 8/15/05 MOVE_TO_MATCMDCONTROL
	/*
	void MatlabobjInit()
	{
		m_pMATLABObj = NULL;
		return;
	}
	*/
	bool IsReadyMatlabobj()
	{
		if(m_pMATLABObj && m_pMATLABObj->Attach(TRUE, FALSE, TRUE)) 
			return true;
		else
			return false;
	}
	
	///Jasmine 8/12/05 QA70-7998 v8.0286 CHECK_MATLAB_AVAILABILITY 
	bool IsMatlabAvailable()
	{
		MatlabobjCreate();
		if(IsReadyMatlabobj())
			return true;
		else
		{
			MessageBox(GetWindow(), _L("no MATLAB installed"));///Jasmine 08/01/07 QA70-10137 MUST_SUPPLY_PARENT_FOR_MESSAGEBOX
			return false;
		}
	}
	
	void DelMatlabobj()
	{
		/*	///Jasmine 08/24/05 ADD_DESCONSTRUCT_FUNC
		// we keep this running so next time dialog open the workspace is still there
		m_pMATLABObj->KeepMatlabRunning = TRUE;
		delete m_pMATLABObj;
		m_pMATLABObj = NULL;
		*/
		if(m_pMATLABObj)
		{
			// we keep this running so next time dialog open the workspace is still there
			m_pMATLABObj->KeepMatlabRunning = TRUE;
			delete m_pMATLABObj;
			m_pMATLABObj = NULL;
		}
		///End ADD_DESCONSTRUCT_FUNC
	}
protected:
	//virtual 
	void OnCmd(const string& strCmd, bool bAddNewLine = true)
	{
		//--- CPY 8/13/05 EXECUTE_HISTORY_NEEDED_TO_ADD_TO_HISTORY
		// change for LT force change in here as well
		/*
		strCmd.TrimLeft();strCmd.TrimRight();
		if(strCmd.IsEmpty())
			return;

		string strOutput = STR_NO_MATLAB;
		if(m_pMATLABObj && !is_Origin_command(strCmd, strOutput) && *m_pMATLABObj)
		{
			strOutput = m_pMATLABObj->Execute(strCmd);
		}
		
		addString(strOutput);
		return;
		*/
		if(bAddNewLine)
			WriteLine();
		TrimCmd(strCmd);
		if(!strCmd.IsEmpty())
		{
			string strOutput = STR_NO_MATLAB;
			if(m_pMATLABObj && !is_Origin_command(strCmd, strOutput) && *m_pMATLABObj)
			{
				strOutput = m_pMATLABObj->Execute(strCmd);
			}
			addString(strOutput);
		}
		SetActiveWindow( GetParent().GetSafeHwnd());///Sophy 6/18/2008 QA80-11210 KEEP_CURSOR_FOCUS_IN_MATLAB_CONSOLE_AFTER_RUN_CMD
		ShowPrompt();
		//--- end EXECUTE_HISTORY_NEEDED_TO_ADD_TO_HISTORY	
		
	}
private:
	bool is_Origin_command(LPCSTR lpcszCmd, string& strResult)	
	{
		string strCmdstr = lpcszCmd;
		
		strCmdstr.TrimLeft();	//Soapy 10/22/03 DELETE_SPACE_BEFORE_COMMAND
		
		//----- CPY 1/10/03
		// GetTokens has a bug, if str has ', will generate runtime error
		//int nArgs = strCmdstr.GetTokens(strCmdArgs);
		//if(nArgs < 1)
		//	return false;
		//string strCmd = strCmdArgs[0];
		int nSpace = strCmdstr.Find(' ');
		if(strCmdstr.IsEmpty() || nSpace == 0)
			return false;
	
		string strCmd = strCmdstr;
		if(nSpace > 0)
			strCmd = strCmdstr.Left(nSpace);
		//-----
	
		for(int nCmdID = 0; nCmdID < CMDID_COUNT; nCmdID++)
		{
			if(strCmd.CompareNoCase(s_asCmdList[nCmdID]) == 0)
			{
				//----- CPY 1/10/03
				StringArray	strCmdArgs;
				int nArgs = strCmdstr.GetTokens(strCmdArgs);
				if(nArgs < 1)
					return false;
				//-----
				do_Origin_commad(nCmdID, strCmdArgs, strResult);
				return true;
			}
		}
		return false;
	}
	///Arvin/Cheney 2007-3-16 REWRITE_DO_ORIGIN_CMD
	/*
	// reutrn true if matrix does not exist and has to be created
	bool get_Origin_matrix(string strMatName, MatrixLayer& mLayer)
	{
		/// SY 2007-01-15 v8.0542 QA70-8759 NEW_NOTATION_FOR_TOOLS
		string str = strMatName;
	#if _OC_VER >= 0x0800
		if( !okoc_find_dataset(str, &strMatName, NULL, DATASET_MATRIX) )
			strMatName = str;
	#endif
		/// end NEW_NOTATION_FOR_TOOLS
		MatrixLayer mltemp(strMatName);
		if(!mltemp)
		{
			mltemp.Create();
			mltemp.GetPage().Rename(strMatName);
			mLayer = mltemp;
			return true;
		}
		mLayer = mltemp;
		return false;
	}
	*/
	///end REWRITE_DO_ORIGIN_CMD
	void do_Origin_commad(int nCmdID, StringArray& asArgs, string& strResult)	
	{
		///---------- SY 02/08/2004 QA70-7383 MATLAB_CONSOLE_SEND_WKS_COL
		///	uint nArgSize = asArgs.GetSize();
		///	if(nArgSize < 2 && nCmdID <= CMDID_GET_COMPLEX) // no argument
		///	{
		///		strResult = "Usage:" + asArgs[0];
		///		strResult += " matName1 matName2 ...";
		///		return;
		///	}
		///	///	DVT 7/1/03 QA70-4753 v7.0614 MATLAB_CONSOLE_PUT_COMPLEX
		///	if(nArgSize < 3 && nCmdID == CMDID_PUT_COMPLEX) // not enough arguments
		///	{
		///		strResult = "Usage:" + asArgs[0];
		///		strResult += " matNameReal matNameImag [matlNameResult (= matNameReal)]";
		///		return;
		///	}
		///	///	end MATLAB_CONSOLE_PUT_COMPLEX
		///---------- end MATLAB_CONSOLE_SEND_WKS_COL
	
		if(NULL == m_pMATLABObj)
		{
			strResult = STR_NO_MATLAB;
			return;
		}
			
		/// SY 02/08/2004 QA70-7383 MATLAB_CONSOLE_SEND_WKS_COL
		uint nArgSize = asArgs.GetSize();
		// Parse argument
		switch( nCmdID )
		{
		case CMDID_PUT_REAL:
		case CMDID_GET_REAL:
		///Jasmine 03/24/06 PUT_GET_REAL_MESSAGE				
		case CMDID_GET_COMPLEX:
		case CMDID_PUT_COMPLEX: ///Arvin/Cheney 2007-3-16 REWRITE_DO_ORIGIN_CMD
			///Jasmine 08/24/05 QA70-7998 v8.0292 PUT_GET_COMPLEX_EXCHANGE
			/*
			if( nArgSize < 3 ) // not enough arguments
			{
				strResult = "Usage:" + asArgs[0];
				strResult += " matNameReal matNameImag [matlNameResult (= matNameReal)]";
				return;
			}
			*/
			if( nArgSize < 2 )
			{
				strResult = "Usage:" + asArgs[0];
				strResult += " matName1 matName2 ...";
				return;
			}
			///End PUT_GET_COMPLEX_EXCHANGE
			break;
		///Arvin/Cheney 2007-3-16 REWRITE_DO_ORIGIN_CMD
		/*
		case CMDID_PUT_COMPLEX:
			///Jasmine 08/24/05 QA70-7998 v8.0292 PUT_GET_COMPLEX_EXCHANGE
			/*	
			if( nArgSize < 2 )
			{
				strResult = "Usage:" + asArgs[0];
				strResult += " matName1 matName2 ...";
				return;
			}
			*/
			/*
			if( nArgSize < 3 ) // not enough arguments
			{
				strResult = "Usage:" + asArgs[0];
				strResult += " matNameReal matNameImag [matlNameResult (= matNameReal)]";
				return;
			}
			///End PUT_GET_COMPLEX_EXCHANGE
			break;
		*/
		///end REWRITE_DO_ORIGIN_CMD
		///End PUT_GET_REAL_MESSAGE
		case CMDID_PUT_WKS_REAL:
		case CMDID_PUT_WKS_STRING:
		case CMDID_PUT_WKS_COMPLEX: ///Arvin/Cheney 2007-3-16 REWRITE_DO_ORIGIN_CMD
			if( nArgSize != 2 && nArgSize != 3 )
			{
				strResult = "Usage:" + asArgs[0];
				strResult += " DatasetName [matName]";
				return;
			}
			break;
			
		///Arvin/Cheney 2007-3-16 REWRITE_DO_ORIGIN_CMD
		case CMDID_GET_WKS_REAL:
		case CMDID_GET_WKS_COMPLEX:
			if( nArgSize != 3 )
			{
				strResult = "Usage:" + asArgs[0];
				strResult += " DatasetName matName";
				return;
			}
			break;
		///Cheney 2007-7-20 ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB
		case CMDID_GET_WORK_SPACE:
			if( nArgSize > 2 )
			{
				strResult = "Usage:" + asArgs[0];
				strResult += " w/m, means import to worksheet or matrix layer";
				return;
			}
			break;
		///end ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB
		///end REWRITE_DO_ORIGIN_CMD
		
		///end REWRITE_DO_ORIGIN_CMD
		///Arvin/Cheney 2007-3-16 REWRITE_DO_ORIGIN_CMD
		/*
		case CMDID_PUT_WKS_COMPLEX:
			if( nArgSize != 3 && nArgSize != 4 )
			{
				strResult = "Usage:" + asArgs[0];
				strResult += " DatasetName1 DatasetName2 [matName (= DatasetName1)]";
				return;
			}
			break;
		*/
		///end REWRITE_DO_ORIGIN_CMD
		case CMDID_EXIT:
		case CMDID_QUIT:
		case CMDID_CLC:
		case CMDID_COUNT:
			break;
			
		default:
			return;
		}
		/// end MATLAB_CONSOLE_SEND_WKS_COL
			
		strResult.Empty();
		int ii;
		bool bSuccess;
	
		switch(nCmdID)
		{
		///Arvin/Cheney 2007-3-16 REWRITE_DO_ORIGIN_CMD	
		//case CMDID_PUT_REAL:
			//for(ii = 1; ii < nArgSize; ii++)
			//{
				///// SY 2007-01-15 v8.0542 QA70-8759 NEW_NOTATION_FOR_TOOLS
				/////	MatrixLayer mlay(asArgs[ii]);
				//string str = asArgs[ii];
			//#if _OC_VER >= 0x0800
				//if( !okoc_find_dataset(asArgs[ii], &str, NULL, DATASET_MATRIX) )
					//str = asArgs[ii];
			//#endif
				//MatrixLayer mlay(str);
				///// end NEW_NOTATION_FOR_TOOLS
				//if(!mlay)
				//{
					//strResult = "???\r\n " + asArgs[ii];
					//strResult += " is not an Origin matrix.\r\n";
					//return;
				//}
				//Matrix<double> mm(mlay);
				////--- CPY 2/1/05 MATLAB_7_PR_NOT_WORKING
				////m_pMATLABObj->PutMatrix(mm.GetName(), &mm);
//#ifndef _USE_COMPLEX_TO_FIX_PR_FOR_MATLAB_7
				//m_pMATLABObj->PutMatrix(mm.GetName(), &mm);
//#else	// easwar found if imaginary matrix = 0, MATLAB automatically create real matrix, so since sending just real didn't work, this is a workaround
				//matrix m1;
				//m1 = mm;m1 = 0;
				//m_pMATLABObj->PutMatrix(mm.GetName(), &mm, &m1);
//#endif //!_USE_COMPLEX_TO_FIX_PR_FOR_MATLAB_7
				////---
			//}
			//break;
		/////	DVT 7/1/03 QA70-4753 v7.0614 MATLAB_CONSOLE_PUT_COMPLEX
		//case CMDID_PUT_COMPLEX:
		//{
			///// SY 2007-01-15 v8.0542 QA70-8759 NEW_NOTATION_FOR_TOOLS
			/////	MatrixLayer mlayReal(asArgs[1]);
			//string str = asArgs[1];
		//#if _OC_VER >= 0x0800
			//if( !okoc_find_dataset(asArgs[1], &str, NULL, DATASET_MATRIX) )
				//str = asArgs[1];
		//#endif
			//MatrixLayer mlayReal(str);
			///// end NEW_NOTATION_FOR_TOOLS
			//if(!mlayReal)
			//{
				//strResult = "???\r\n " + asArgs[1];
				//strResult += " is not an Origin matrix.\r\n";
				//return;
			//}
			//Matrix<double> mmR(mlayReal);
			//
			///// SY 2007-01-15 v8.0542 QA70-8759 NEW_NOTATION_FOR_TOOLS
			/////	MatrixLayer mlayImag(asArgs[2]);
			//str = asArgs[2];
		//#if _OC_VER >= 0x0800
			//if( !okoc_find_dataset(asArgs[2], &str, NULL, DATASET_MATRIX) )
				//str = asArgs[2];
		//#endif
			//MatrixLayer mlayImag(str);
			///// end NEW_NOTATION_FOR_TOOLS
			//if(!mlayImag)
			//{
				//strResult = "???\r\n " + asArgs[2];
				//strResult += " is not an Origin matrix.\r\n";
				//return;
			//}
			//Matrix<double> mmI(mlayImag);
			//
			/////Soapy 9/19/03 CHECK_MATRIX_SIZE_BEFORE_PUT_MATRIX
			//if(mmI.GetNumRows()!=mmR.GetNumRows() || mmI.GetNumCols()!=mmR.GetNumCols())
			//{
				//strResult = "\r\nInconsistent Matrix Size.\r\n ";
				//return;
			//}
			/////END CHECK_MATRIX_SIZE_BEFORE_PUT_MATRIX
			//
			///// SY 2007-01-15 v8.0542 QA70-8759 NEW_NOTATION_FOR_TOOLS
			/////	m_pMATLABObj->PutMatrix(  nArgSize >= 4 ? asArgs[3] : mmR.GetName(), &mmR, &mmI );
			//str = nArgSize >= 4 ? asArgs[3] : mmR.GetName();
		//#if _OC_VER >= 0x0800
			//if( nArgSize >= 4 && !okoc_find_dataset(asArgs[3], &str, NULL, DATASET_MATRIX) )
				//str = asArgs[3];
		//#endif
			//m_pMATLABObj->PutMatrix(str, &mmR, &mmI);
			///// end NEW_NOTATION_FOR_TOOLS
			//break;
		//}
		/////	end MATLAB_CONSOLE_PUT_COMPLEX
		//case CMDID_GET_REAL:
			//string strNamesTemp = "TMP_Var_For_Type", strTypeTmpe = "TMP_Var_For_Type_Transfer", strExecute, strResult;
			//for(ii = 1; ii < nArgSize; ii++)
			//{
				/////Jasmine 03/14/07 QA70-9464  FIX_MATLAB_CONSOLE_BUG, GetMatlabOtherNumMatrices
				//strExecute.Format("%s=whos('%s'); %s.class", strNamesTemp, asArgs[ii], strNamesTemp);					
				//bSuccess = m_pMATLABObj->Execute(strExecute, strResult);
				//strExecute.Format("clear %s", strNamesTemp);
				//m_pMATLABObj->Execute(strExecute);
				//int nFind = -1;
				//if(!strResult.IsEmpty())
				//{
					//nFind = strResult.Find("int");
					//if(0 > nFind)
						//nFind = strResult.Find("char");
					//if(0 > nFind)
						//nFind = strResult.Find("single");
				//}
				//if(-1 < nFind)
				//{//transfer type
					//strExecute.Format("%s=%s;" "%s=double(%s);", strTypeTmpe, asArgs[ii], asArgs[ii], strTypeTmpe);
					//m_pMATLABObj->Execute(strExecute);
				//}
				/////End FIX_MATLAB_CONSOLE_BUG
				/////Soapy 9/26/03 REMOVE_DUPLICATED_CODE
				///*
				//bool bNew=false;
				//MatrixLayer mlay(asArgs[ii]);
				//if(!mlay)
				//{
					//mlay.Create();
					//mlay.GetPage().Rename(asArgs[ii]);
					//bNew = true;
				//}*/
				//MatrixLayer mlay;
				//bool bNew = get_Origin_matrix(asArgs[ii], mlay);
				/////END REMOVE_DUPLICATED_CODE
				//
				//Matrix<double> mm(mlay);
				/////Soapy 11/12/03 GET_REAL_MATRIX_BY_VARIABLE_NAME	
				////bSuccess = m_pMATLABObj->GetMatrix(mm.GetName(), &mm);
				///// SY 2007-01-15 v8.0542 QA70-8759 NEW_NOTATION_FOR_TOOLS
				/////	bSuccess = m_pMATLABObj->GetMatrix(asArgs[ii], &mm);
				//string str = asArgs[ii];
			//#if _OC_VER >= 0x0800
				//if( !okoc_find_dataset(asArgs[ii], &str, NULL, DATASET_MATRIX) )
					//str = asArgs[ii];
			//#endif
				//bSuccess = m_pMATLABObj->GetMatrix(str, &mm);
				///// end NEW_NOTATION_FOR_TOOLS
				/////END GET_REAL_MATRIX_BY_VARIABLE_NAME
				//if(!bSuccess )
				//{
					//if(bNew)
						//mlay.Destroy();
					//strResult += asArgs[ii] + " ";
				//}
				/////Jasmine 03/14/07 QA70-9464  FIX_MATLAB_CONSOLE_BUG
				//if(-1 < nFind)
				//{//transfer type
					//strExecute.Format("%s=%s;"  "clear %s",asArgs[ii], strTypeTmpe, strTypeTmpe);
					//m_pMATLABObj->Execute(strExecute);
				//}
				/////End FIX_MATLAB_CONSOLE_BUG
			//}
			//if(!strResult.IsEmpty())
				//strResult += ": matrices not found in Matlab!\r\n";
			//
			//break;
		//case CMDID_GET_COMPLEX:
			//// may need to see how to share code with CMDID_GET_REAL
			//for(ii = 1; ii < nArgSize; ii++)
			//{
				//MatrixLayer mlay_r, mlay_i;
				//bool bNewR= get_Origin_matrix(asArgs[ii]+"r", mlay_r);
				//bool bNewI= get_Origin_matrix(asArgs[ii]+"i", mlay_i);
				//
				//Matrix<double> mr(mlay_r), mi(mlay_i);
				///// SY 2007-01-15 v8.0542 QA70-8759 NEW_NOTATION_FOR_TOOLS
				/////	bSuccess = m_pMATLABObj->GetMatrix(asArgs[ii], &mr, &mi);
				//string str = asArgs[ii];
			//#if _OC_VER >= 0x0800
				//if( !okoc_find_dataset(asArgs[ii], &str, NULL, DATASET_MATRIX) )
					//str = asArgs[ii];
			//#endif
				//bSuccess = m_pMATLABObj->GetMatrix(str, &mr, &mi);
				///// end NEW_NOTATION_FOR_TOOLS
				//if(!bSuccess)
				//{
					//if(bNewR)
						//mlay_r.Destroy();
					//if(bNewI)
						//mlay_i.Destroy();
					//
					//strResult += asArgs[ii] + " ";
				//}
				/////Arvin 03/14 QA70-9464-S1 MERGE_REAL_AND_IMAG_PART_FOR_COMPLEX 
				//MatrixLayer mlay_c;
				//bool bNewC= get_Origin_matrix(asArgs[ii]+"c", mlay_c);
				//mlay_c.SetInternalData(FSI_COMPLEX);
				//Matrix<complex> mc(mlay_c);
				//matrix<complex> mComplex;
				//matrix mReal, mImag;
				//mReal = mr;
				//mImag = mi;
				//int nRet = mComplex.MakeComplex(mReal, mImag);
				//if(nRet == 0)
				//{
					//mc = mComplex;
					//mlay_r.Destroy();
					//mlay_i.Destroy();
				//}
				//else
				//{
					//if(bNewC)
						//mlay_c.Destroy();
				//}
				/////end MERGE_REAL_AND_IMAG_PART_FOR_COMPLEX
			//}
			//if(!strResult.IsEmpty())
				//strResult += ": matrices not found in Matlab!";
				//
			//break;
			//
		///// SY 02/08/2004 QA70-7383 MATLAB_CONSOLE_SEND_WKS_COL
		//case CMDID_PUT_WKS_STRING:
		//case CMDID_PUT_WKS_REAL:
			//{
				///// SY 2007-01-15 v8.0542 QA70-8759 NEW_NOTATION_FOR_TOOLS
				/////	Dataset ds(asArgs[1]);
				//string strName = asArgs[1];
			//#if _OC_VER >= 0x0800
				//if( !okoc_find_dataset(asArgs[1], &strName))//, NULL, DATASET_MATRIX) )///Jasmine 03/14/07 QA70-9464  FIX_MATLAB_CONSOLE_BUG
					//strName = asArgs[1];
			//#endif
				//Dataset ds(strName);
				///// end NEW_NOTATION_FOR_TOOLS
				//
				//if( !ds.IsValid() )
				//{
					//strResult.Format("\r\nDataset %s is invalid.\r\n", asArgs[1]); 
					//return;
				//}
				//
				//if( nArgSize == 3 && lstrcmpi(asArgs[1], asArgs[2]) )
				//{
					///// SY 2007-01-15 v8.0542 QA70-8759 NEW_NOTATION_FOR_TOOLS
					/////	Dataset dsTmp(asArgs[2]);
					//strName = asArgs[2];
				//#if _OC_VER >= 0x0800
					//if( !okoc_find_dataset(asArgs[2], &strName, NULL, DATASET_MATRIX) )
						//strName = asArgs[2];
				//#endif
					//Dataset dsTmp(strName);
					///// end NEW_NOTATION_FOR_TOOLS
					//if( dsTmp.IsValid() )
					//{
						//strResult.Format("\r\nThe variable %s is one of Origin dataset name.\r\nUsage: %s DatasetName [matName]\r\n", asArgs[2], asArgs[0]);
						//return;
					//}
				//}
				//
				//if( nCmdID == CMDID_PUT_WKS_STRING )
				//{
					//StringArray sa;
					//if( !ds.GetStringArray(sa) )
						//return;
					//
					//string str;
					//make_vector_string_to_string(sa, str);
					//
					////bSuccess = m_pMATLABObj->PutString((nArgSize == 3 ? asArgs[2] : ds.GetName()), str);
					//string strCmd;
					//strCmd.Format("%s = cellstr(%s)", (nArgSize == 3 ? asArgs[2] : ds.GetName()), str);
					//bSuccess = m_pMATLABObj->Execute(strCmd, strResult);
				//}
				//else
				//{
					//matrix mm(ds);
					//matrix m1;
					//m1 = mm;  m1 = 0;
//
					//ocu_NANUM_to_nan((double *)mm, mm.GetNumRows() * mm.GetNumCols());
					//
					///// SY 2007-01-15 v8.0542 QA70-8759 NEW_NOTATION_FOR_TOOLS
					/////	bSuccess = m_pMATLABObj->PutMatrix((nArgSize == 3 ? asArgs[2] : ds.GetName()), &mm, &m1);
					//strName = nArgSize == 3 ? asArgs[2] : ds.GetName();
				//#if _OC_VER >= 0x0800
					//if( nArgSize == 3 && !okoc_find_dataset(asArgs[2], &strName) )
						//strName = asArgs[2];
				//#endif
					//bSuccess = m_pMATLABObj->PutMatrix(strName, &mm, &m1);
					///// end NEW_NOTATION_FOR_TOOLS
				//}
			//}
			//break;
			//
		//case CMDID_PUT_WKS_COMPLEX:
			//{
				//// Assumed that datasetname1 and datasetname2 referes to columns in Origin that have real data.
				///// SY 2007-01-15 v8.0542 QA70-8759 NEW_NOTATION_FOR_TOOLS
				/////	Dataset ds1(asArgs[1]), ds2(asArgs[2]);
				//string str1 = asArgs[1], str2 = asArgs[2];
			//#if _OC_VER >= 0x0800
				//if( !okoc_find_dataset(asArgs[1], &str1) )
					//str1 = asArgs[1];
				//if( !okoc_find_dataset(asArgs[2], &str2) )
					//str2 = asArgs[2];
			//#endif
				//Dataset ds1(str1), ds2(str2);
				///// end NEW_NOTATION_FOR_TOOLS
				//
				//if( !ds1.IsValid() )
				//{
					//strResult.Format("\r\nDataset %s is invalid.\r\n", asArgs[1]); 
					//return;
				//}
				//
				//if( !ds2.IsValid() )
				//{
					//strResult.Format("\r\nDataset %s is invalid.\r\n", asArgs[2]); 
					//return;
				//}
				//
				//int nr1 = ds1.GetLowerBound();
				//int nr2 = ds2.GetLowerBound();
				//
				//if( nr1 != nr2 || ds1.GetSize() != ds2.GetSize() )
				//{
					//strResult.Format("\r\nDataset %s and %s is not match.\r\n", asArgs[1], asArgs[2]); 
					//return;
				//}
				//
				//matrix mmR(ds1);
				//matrix mmI(ds2);
				//
				//ocu_NANUM_to_nan((double *)mmR, mmR.GetNumRows() * mmR.GetNumCols());
				//ocu_NANUM_to_nan((double *)mmI, mmI.GetNumRows() * mmI.GetNumCols());
				//
				///// SY 2007-01-15 v8.0542 QA70-8759 NEW_NOTATION_FOR_TOOLS
				/////	bSuccess = m_pMATLABObj->PutMatrix((nArgSize == 4 ? asArgs[3] : ds1.GetName()), &mmR, &mmI);
				//string strName = nArgSize == 4 ? asArgs[3] : ds1.GetName();
			//#if _OC_VER >= 0x0800
				//if( nArgSize == 4 && !okoc_find_dataset(asArgs[3], &strName) )
					//strName = asArgs[3];
			//#endif
				//bSuccess = m_pMATLABObj->PutMatrix(strName, &mmR, &mmI);
				///// end NEW_NOTATION_FOR_TOOLS
			//}
			//break;
		///// end MATLAB_CONSOLE_SEND_WKS_COL
		
		case CMDID_PUT_REAL:
			for(ii = 1; ii < nArgSize; ii++)
			{
				RMatRangeML rMatRangeML(asArgs[ii]);
				rMatRangeML.SetMLObj(m_pMATLABObj);
				rMatRangeML.SendRealToMatlab(asArgs[ii], strResult);
			}
			break;
			
		case CMDID_PUT_COMPLEX:
			for(ii = 1; ii < nArgSize; ii++)
			{
				CMatRangeML cMatRangeML(asArgs[ii]);
				cMatRangeML.SetMLObj(m_pMATLABObj);
				cMatRangeML.SendComplexToMatlab(asArgs[ii], strResult);
			}
			break;
			
		case CMDID_GET_REAL:
			for(ii = 1; ii < nArgSize; ii++)
			{
				///Arvin 03/28/07 QA70-9503 CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
				//RMatRangeML rMatRangeML(asArgs[ii]);
				RMatRangeML rMatRangeML(asArgs[ii], true);
				///end CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
				rMatRangeML.SetMLObj(m_pMATLABObj);
				rMatRangeML.GetRealFromMatlab(asArgs[ii], strResult);
			}
			break;
			
		case CMDID_GET_COMPLEX:
			for(ii = 1; ii < nArgSize; ii++)
			{
				///Arvin 03/28/07 QA70-9503 CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
				//CMatRangeML cMatRangeML(asArgs[ii]);
				CMatRangeML cMatRangeML(asArgs[ii], true);
				///end CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
				cMatRangeML.SetMLObj(m_pMATLABObj);
				cMatRangeML.GetComplexFromMatlab(asArgs[ii], strResult);
			}
			break;
		case CMDID_PUT_WKS_STRING:
			string strRange, strMatlabVar;
			strRange = asArgs[1]; //Range string
			StrWksRangeML strWksRangeML(strRange);
			strWksRangeML.SetMLObj(m_pMATLABObj);
			strMatlabVar = _get_matlab_var_name(strRange, asArgs, &strWksRangeML);
			strWksRangeML.SendStringToMatlab(strMatlabVar, strResult);
			break;
			
		case CMDID_PUT_WKS_REAL:
			string strRange, strMatlabVar;
			strRange = asArgs[1]; //Range string
			RWksRangeML rWksRangeML(strRange);
			rWksRangeML.SetMLObj(m_pMATLABObj);
			strMatlabVar = _get_matlab_var_name(strRange, asArgs, &rWksRangeML);
			rWksRangeML.SendRealToMatlab(strMatlabVar, strResult);
			break;
			
		case CMDID_PUT_WKS_COMPLEX:
			string strRange, strMatlabVar;
			strRange = asArgs[1]; //Range string
			CWksRangeML cWksRangeML(strRange);
			cWksRangeML.SetMLObj(m_pMATLABObj);
			strMatlabVar = _get_matlab_var_name(strRange, asArgs, &cWksRangeML);
			cWksRangeML.SendComplexToMatlab(strMatlabVar, strResult);
			break;
			
		case CMDID_GET_WKS_REAL:
			string strRange, strMatlabVar;
			strRange = asArgs[1]; //Range string
			strMatlabVar = asArgs[2]; 
			///Arvin 03/28/07 QA70-9503 CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
			//RWksRangeML rWksRangeML(strRange);
			RWksRangeML rWksRangeML(strRange, true);
			///end CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
			rWksRangeML.SetMLObj(m_pMATLABObj);
			//strMatlabVar = _get_matlab_var_name(strRange, asArgs, &rWksRangeML);
			rWksRangeML.GetRealFromMatlab(strMatlabVar, strResult);
			break;
			
		case CMDID_GET_WKS_COMPLEX:	
			string strRange, strMatlabVar;
			strRange = asArgs[1]; //Range string
			strMatlabVar = asArgs[2]; 
			///Arvin 03/28/07 QA70-9503 CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
			//CWksRangeML cWksRangeML(strRange);
			CWksRangeML cWksRangeML(strRange, true);
			///end CP_HAS_ADD_FUNCTION_TO_CREATE_DATARANGE_FROM_STRING
			cWksRangeML.SetMLObj(m_pMATLABObj);
			//strMatlabVar = _get_matlab_var_name(strRange, asArgs, &cWksRangeML);
			cWksRangeML.GetComplexFromMatlab(strMatlabVar, strResult);
			break;
			
///end REWRITE_DO_ORIGIN_CMD		
		case CMDID_EXIT:
		case CMDID_QUIT:
			m_pMATLABObj->Detach();
		
			Window Wnd = GetParent();
			if(Wnd)
				///Jasmine 08/24/05 QA70-7998 v8.0292 SENDMESSAGE_TO_CLOSE_WND
				//Wnd.PostMessage(WM_USER_CLOSE_WND);
				Wnd.SendMessage(WM_CLOSE);

		break;
		case CMDID_CLC: // clear screen display
			Text="";
			//add_str_to_richEdit(cCmdWindow, STR_PROMPT, FALSE);
			break;
		///Cheney 2007-7-20 ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB	
		//gwkspace w means import matlab var to wks
		//otherwise import to mat
		case CMDID_GET_WORK_SPACE:
			bool bImportMatrix = true;
			if(asArgs.GetSize() == 2)
				///Arvin 07/27/07 CMD_GET_WKSPACE_MATRIX_AND_WORKSHEET_REVERSED
				//bImportMatrix = asArgs[1].CompareNoCase("w")? false : true;
				bImportMatrix = asArgs[1].CompareNoCase("w") == 0? false : true;
				///END CMD_GET_WKSPACE_MATRIX_AND_WORKSHEET_REVERSED
				
			importMatlabWorkSpace(strResult, bImportMatrix);
			break;
		///end 	ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB	
		}
		return;
	}
	
	///Arvin/Cheney 2007-3-16 REWRITE_DO_ORIGIN_CMD	
	///// SY 02/10/2004 QA70-7383 MATLAB_CONSOLE_SEND_WKS_COL
	//void make_vector_string_to_string(vector<string>& vs, string& str)
	//{
		//if( 0 == vs.GetSize() )
			//return;
		//
		//str = "[";
		//check_and_padding(vs);
		//
		//for( int ii = 0; ii < vs.GetSize(); ii++)
		//{
			//// MATLAB uses single quote and ; as delimitor
			//str += "\'"+ vs[ii] + "\';";
		//}
		//str.Delete( str.GetLength() - 1 ); // Delete the last ;
		//str += "]";
	//}
	//// Get all length and return the max length also
	//int get_lengths(vector<string>& vs, vector<int> &vret)
	//{
		//int nMaxWidth = 0;
		//int nTemp;
		//int nSize = vs.GetSize();
		//
		//vret.SetSize(nSize);
		//for(int ii = 0; ii < nSize; ii++)
		//{
			//nTemp = lstrlen(vs[ii]);
			//if( nTemp > nMaxWidth )
				//nMaxWidth = nTemp;
			//
			//vret[ii] = nTemp;
		//}
		//
		//return nMaxWidth;
	//}
	//
	//// In MATLAB string array, all rows in the bracketed expression must have the same number of columns.
	//void check_and_padding(vector<string>& vs)
	//{
		//vector<int> vlen;
		//int nMaxLen = get_lengths(vs, vlen);
//
		//int iNumPad;
		//for( int ii = 0; ii < vlen.GetSize(); ii++ )
		//{
			//iNumPad = nMaxLen - vlen[ii];
			//if( iNumPad > 0 )
			//{
				//while( iNumPad-- > 0 )
					//vs[ii] += " ";
			//}
		//}
	//}
	/// end MATLAB_CONSOLE_SEND_WKS_COL
	///end REWRITE_DO_ORIGIN_CMD
	///Cheney 2007-7-20 ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB	
	void importMatlabWorkSpace(string& strResult, bool bImportMatrix)
	{
		//get all variable names
		string strResultTemp;
		string strNamesTemp = "TMP_Var_For_Type", strExecute;
		strExecute.Format("%s=whos(); %s.name", strNamesTemp, strNamesTemp);					
		bool bSuccess = m_pMATLABObj->Execute(strExecute, strResultTemp);
		strExecute.Format("clear %s", strNamesTemp);
		m_pMATLABObj->Execute(strExecute);
		
		StringArray saVarNames;
		strResultTemp.GetTokens( saVarNames, '=' );
		
		//import all var to one book
		Page pg = createImportPage(bImportMatrix);
		if(!pg)
		{
			strResult = CER_INVALID_PAGE;
			return;
		}
		
		//loop to import
		int nLayerCount = 0;
		for(int ii = 1; ii < saVarNames.GetSize(); ii++)
		{			
			string strVarName = saVarNames[ii];
			if(strVarName.Compare("ans") != 0)
				strVarName.Replace("ans", "");
			strVarName.TrimLeft();
			strVarName.TrimRight();
		
			if( !isNumericMatlabVar(strVarName, strNamesTemp, strResultTemp))
				continue;
			
			Datasheet ds;
			ds = pg.Layers(nLayerCount);
			if(!ds)
				ds = pg.Layers( pg.AddLayer() );
			ds.SetName(strVarName);
			string strRange = "[" + pg.GetName() + "]" + ds.GetName() + "!1";
			
			if(isRealMatlabVar(strVarName, strNamesTemp, strResultTemp))
			{
				if(bImportMatrix)
				{
					RMatRangeML rMatRangeML(strRange, true, false);
					rMatRangeML.SetMLObj(m_pMATLABObj);
					rMatRangeML.GetRealFromMatlab(strVarName, strResult);
				}
				else
				{
					RWksRangeML rWksRangeML(strRange, true);
					rWksRangeML.SetMLObj(m_pMATLABObj);
					rWksRangeML.GetRealFromMatlab(strVarName, strResult);
				}
			}
			else
			{
				if(bImportMatrix)
				{
					///Arvin 07/27/07 CMD_GET_WKSPACE_CAN_NOT_GET_COMPLEX_MATRIX
					//CMatRangeML cMatRangeML(strVarName, true, false);
					CMatRangeML cMatRangeML(strRange, true, false);
					///END CMD_GET_WKSPACE_CAN_NOT_GET_COMPLEX_MATRIX
					cMatRangeML.SetMLObj(m_pMATLABObj);
					cMatRangeML.GetComplexFromMatlab(strVarName, strResult);
				}
				else
				{
					CWksRangeML cWksRangeML(strRange, true);
					cWksRangeML.SetMLObj(m_pMATLABObj);
					cWksRangeML.GetComplexFromMatlab(strVarName, strResult);
				}
			}
			nLayerCount++;
		}
	}
	
	Page createImportPage(bool bImportMatrix)
	{
		Page pg;
		if(bImportMatrix)
		{
			MatrixLayer ml;
			ml.Create();
			MatrixPage mp;
			ml.GetParent(mp);
			pg = mp;
		}
		else
		{
			Worksheet wks;
			wks.Create();
			WorksheetPage wp;
			wks.GetParent(wp);
			pg = wp;
		}
		return pg;
	}
	
	bool isNumericMatlabVar(LPCSTR lpcszVarName, LPCSTR lpcszNamesTemp, string& strResult)
	{
		string strExecute;
		string strNamesTemp(lpcszNamesTemp), strVarName(lpcszVarName);
		strExecute.Format("%s=isnumeric(%s)", strNamesTemp, strVarName);
		bool bSuccess = m_pMATLABObj->Execute(strExecute, strResult);
		strExecute.Format("clear %s", strNamesTemp);
		m_pMATLABObj->Execute(strExecute);
		
		strResult.TrimRight();
		return '1' == strResult.GetAt( strResult.GetLength() - 1 );
	}
	
	bool isRealMatlabVar(LPCSTR lpcszVarName, LPCSTR lpcszNamesTemp, string& strResult)
	{
		string strExecute;
		string strNamesTemp(lpcszNamesTemp), strVarName(lpcszVarName);
		strExecute.Format("%s=isreal(%s)", strNamesTemp, strVarName);
		bool bSuccess = m_pMATLABObj->Execute(strExecute, strResult);
		strExecute.Format("clear %s", strNamesTemp);
		m_pMATLABObj->Execute(strExecute);
		
		strResult.TrimRight();
		return '1' == strResult.GetAt( strResult.GetLength() - 1 );
	}
	///end 	ADD_A_CMD_TO_SUPPORT_IMPORT_ALL_WORKSPAVE_OF_MATLAB	
private:
	Matlab* 	m_pMATLABObj;

};

///Arvin/Cheney 2007-3-16 REWRITE_DO_ORIGIN_CMD	
static string _get_matlab_var_name(string& strRange, vector<string>& asArgs, WksRangeML* pWksRangeML)
{
	string strMatlabVar;
	int nArgSize = asArgs.GetSize();
	
	if(nArgSize == 3)
		strMatlabVar = asArgs[2];
	else
	{
		pWksRangeML->GetSheetName(strMatlabVar); //Get sheet name as matlab variable's name
		if(strMatlabVar.IsEmpty())
			strMatlabVar = strRange;
	}
	
	return strMatlabVar;
}
///end REWRITE_DO_ORIGIN_CMD
