/*------------------------------------------------------------------------------*
 * File Name: LayerPlotList.h 													*
 * Creation: Kit Chen															*
 * Purpose: Data plot list control												*
 * Copyright (c) OriginLab Corp.	2010, 2011									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Iris 3/15/2011 ORG-2371-P2 FIX_CHANGE_ROWRANGE_FOR_3D_LINE_PLOT_CAUSE_RESCALE_FAILED_ON_XY_AXES
 *	Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN	*
 *	Kit 04/28/2011 CLEAN_UP_CODE												*
 *	Tony 07/04/2012 ORG-2893-S1 ADD_BOOK_NAMING_COLUMN							*
 *------------------------------------------------------------------------------*/
#ifndef		_PLOTSCONTROL_H
#define		_PLOTSCONTROL_H

#include "DatasetList.h"

enum	PlotsCtrlHeader  
{
	PlotsCtrl_FixCol = 0,	
	///-----Kit 01/06/2011 ORG-1826-S13 USE_ROW_HEAD_INSTEAD_GROUP_COLUMN_TO_SHOW_GROUP_NUM
	//PlotsCtrl_HeaderFirst,
	//PlotsCtrl_Group = PlotsCtrl_HeaderFirst,
	PlotsCtrl_Group = PlotsCtrl_FixCol,
	PlotsCtrl_HeaderFirst,
	///-----End USE_ROW_HEAD_INSTEAD_GROUP_COLUMN_TO_SHOW_GROUP_NUM
	///Jasmine 12/29/10 ORG-1826-S1-3 HAVE_BOOK_SHEET_NAME_IN_BOTH_LEFT_RIGHT_LIST
	///-----Kit 01/06/2011 ORG-1826-S13 USE_ROW_HEAD_INSTEAD_GROUP_COLUMN_TO_SHOW_GROUP_NUM
	//PlotsCtrl_BookSN,
	///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	//PlotsCtrl_BookSN = PlotsCtrl_HeaderFirst,
	///------ Tony 07/04/2012 ORG-2893-S1 ADD_BOOK_NAMING_COLUMN
	//PlotsCtrl_BookLN = PlotsCtrl_HeaderFirst,
	PlotsCtrl_BookName = PlotsCtrl_HeaderFirst,
	PlotsCtrl_BookLN,
	///------ End ADD_BOOK_NAMING_COLUMN
	PlotsCtrl_BookSN,
	///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	PlotsCtrl_Sheet,
	///End HAVE_BOOK_SHEET_NAME_IN_BOTH_LEFT_RIGHT_LIST
	PlotsCtrl_DSName, /// Iris 12/23/2010 ORG-1826-S2 SHOW_DATASET_NAME_IN_BOTH_SIDES_GRID
	///Jasmine 12/22/10 ORG-1826-S1-3 PLOT_LIST_DEFAULT_SHOW_SNAME_LNAME_ETC
	PlotsCtrl_SName,
	PlotsCtrl_LName,
	///End PLOT_LIST_DEFAULT_SHOW_SNAME_LNAME_ETC
	PlotsCtrl_Legend,
	//PlotsCtrl_Plot,	///Jasmine 12/29/10 ORG-1826-S1-3 HAVE_BOOK_SHEET_NAME_IN_BOTH_LEFT_RIGHT_LIST
	PlotsCtrl_Range,
	PlotsCtrl_Show,
	PlotsCtrl_PlotType,
		
	PlotsCtrl_TotalCols,
};
// the order must be the same as the PlotsCtrlHeader
//#define STR_PLOTS_CTRL_HEADER	_L("|Group|Legend|Plot|Range|Show|PlotType")
/// Iris 12/23/2010 ORG-1826-S2 SHOW_DATASET_NAME_IN_BOTH_SIDES_GRID
//#define STR_PLOTS_CTRL_HEADER	_L("|Group|SName|LName|Legend|Plot|Range|Show|PlotType")	///Jasmine 12/22/10 ORG-1826-S1-3 PLOT_LIST_DEFAULT_SHOW_SNAME_LNAME_ETC
//#define STR_PLOTS_CTRL_HEADER	_L("|Group|Dataset Name|SName|LName|Legend|Plot|Range|Show|Plot Type")///Jasmine 12/29/10 ORG-1826-S1-3 HAVE_BOOK_SHEET_NAME_IN_BOTH_LEFT_RIGHT_LIST
///-----Kit 01/06/2011 ORG-1826-S13 USE_ROW_HEAD_INSTEAD_GROUP_COLUMN_TO_SHOW_GROUP_NUM
//#define STR_PLOTS_CTRL_HEADER	_L("|Group|Book|Sheet|Dataset Name|SName|LName|Legend|Range|Show|Plot Type")

///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
//#define STR_PLOTS_CTRL_HEADER	_L("Group|Book|Sheet|Dataset Name|Short Name|Long Name|Legend|Range|Show|Plot Type")
///------ Tony 07/04/2012 ORG-2893-S1 ADD_BOOK_NAMING_COLUMN
//#define STR_PLOTS_CTRL_HEADER	_L("Group|Book Long Name|Book Short Name|Sheet|Dataset Name|Short Name|Long Name|Legend|Range|Show|Plot Type")
#define STR_PLOTS_CTRL_HEADER	_L("Group|Book Name|Book Long Name|Book Short Name\
									|Sheet|Dataset Name|Short Name\
									|Long Name|Legend|Range\
									|Show|Plot Type")
///------ End ADD_BOOK_NAMING_COLUMN
///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
///-----USE_ROW_HEAD_INSTEAD_GROUP_COLUMN_TO_SHOW_GROUP_NUM
///End SHOW_DATASET_NAME_IN_BOTH_SIDES_GRID


#define WM_USER_MSG_ON_DATAPLOT_CHANGED				(WM_USER + 1000)

enum {
	LC_CHANGE_MOVED = 0x00000001,
	LC_CHANGE_GROUP	= 0x00000002,
	LC_CHANGE_PLOTTYPE = 0x00000004,
	LC_CHANGE_SHOW = 0x00000008,
	LC_CHANGE_ROWRANGE = 0x00000010,
	LC_CHANGE_ADD_PLOT = 0x00000020,
	LC_CHANGE_REMOVE_PLOT = 0x00000040,
	LC_CHANGE_RESCALE_MODE = 0x00000080,
	LC_CHANGE_LEGEND = 0x00000100,	///-----Kit 02/25/2011 ORG-2302-S1 MAKE_LEGEND_CAN_EDIT
};

typedef struct tagRangeEditorDlgInfo
{
	int		nMin;
	int		nMax;
	int		nFrom;
	int		nTo;
	BOOL	bFromAuto;
	BOOL	bToAuto;
} RangeEditorDlgInfo;

/// Iris 3/15/2011 ORG-2371-P2 FIX_CHANGE_ROWRANGE_FOR_3D_LINE_PLOT_CAUSE_RESCALE_FAILED_ON_XY_AXES
//#define GETLC_BITS 			GETLC_DATAPLOTS | GETLC_NO_LIMITS	
#define GETLC_BITS 			GETLC_DATAPLOTS
///End FIX_CHANGE_ROWRANGE_FOR_3D_LINE_PLOT_CAUSE_RESCALE_FAILED_ON_XY_AXES

class LayerContentTreeHelper
{
public:
	LayerContentTreeHelper();
	void	Init(DWORD dwLayerBits); /// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
	bool	GetLayerContentsTree( Tree &trContents, bool bApplyChanges = false );
	bool	SetLayerContentsTree( const Tree &trContents );
	void	SetLayerContentsChangeBit(DWORD dwBit);
	DWORD	GetLayerContentsChangeBit();	///-----Kit 03/05/2011 ORG-2307-P5 RUNTIME_ERROR_WHEN_REMOVE_A_PLOT_AFTER_APPLY
	bool	IsLayerContentsChanged();
	void	ClearLayerContentsChangeBits();

	bool	AddDataPlots( TreeNode &trNewLayer );
	bool	RemoveDataPlots( const vector<uint> &vuSelRows );
	/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
	//bool	MoveDataPlot(int nDataPlotIndex, int nNewPos, bool bToGroupForGroupBorderIndex = false);
	int		MoveDataPlot(int nDataPlotIndex, int nNewPos, bool bToGroupForGroupBorderIndex = false);
	/// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
	//bool	MoveDataPlots(const vector<uint>& vuDataPlotIndices, int nNewPos);
	bool	MoveDataPlots(const vector<uint>& vuDataPlotIndices, int nNewPos, bool& bGroupMoving);
	///End TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
	///End TO_MOVE_WHOLE_GROUP
	
	int 	SetDataPlotGroup(const vector<uint> &vnPlotIndices, bool bGroup);
	bool 	CanDoGroupPlots(const vector<uint>& vnPlots);
	bool	CanDoUngroupPlots(const vector<uint>& vnPlots);
	bool 	MoveDataPlotIntoGroup(int nDataPlotIndex, int nGroupIndex, int* pnNewDataPlotIndex);
	bool	GetAllDataPlotIndicesInGroup(int nPlotIndex, vector<int>& vnPlotsInGroup, int& nSelectGroup);
	
	bool	SetDataPlotShow(int nDataPlotIndex, bool bShow);

	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	//bool	GetRowContents( const TreeNode &trLayer, int nBeginDPIndex, int nEndDPIndex, vector<string> &vsRows, const vector<uint>& vnColMap );///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
	bool	GetContents( const TreeNode &trLayer, int nBeginDPIndex, int nEndDPIndex, vector<string> &vsRows, const vector<uint>& vnColMap, int nColType = -1 );
	///End TO_IMPROVE_UNGROUP_SPEED

	int 	ResetGroupIDAndDataPlotID();
	int		SetGroupIDAndDataPlotIDAttrib( TreeNode &trLayer );

	int		GetDataPlotNum(){ return m_nDataPlotNum; }
	bool	SetDataPlotNum( int nDataPlotNum ){ m_nDataPlotNum = nDataPlotNum; return true; }
	int		GetGroupNum() { return m_nGroupNum; }
	
	int 	GetDataPlotType(int nDPIndex);	///Jasmine 01/12/11 ORG-1997-S2 SHOW_CURRENT_PLOT_TYPE

	bool	GetPlotTypeCellComboStrAndPlotIDs( int nDPIndex, DWORD dwLayerBits, string &strComboStr, vector<int> &vnPlotIDs );
	bool	OnPlotTypeChange( int nDPIndex, int nNewPlotID );
	bool	SetDataPageType( int nDataPageType ){ m_nDataPageType = nDataPageType; return true; }
	int		GetDataPageType();

	bool	GetRowRangeInfo( int nDPIndex, RangeEditorDlgInfo &dlgInfo );
	bool	SetRowRangeInfo( int nDPIndex, const RangeEditorDlgInfo &dlgInfo );
	
	bool	IsSelDPInSameGroup( const vector<uint> &vuSelDPID );
	bool	IsDataPlotInGroup( int nDPIndex );
	
	bool	IsSamePlotType(const vector<uint>& vnPlotIndices, const vector<int>& vnCompatibleIDs = NULL, int* pnInvalidPlot = NULL);	///Jasmine 12/23/10 ORG-1826-S6 BATCH_CHANGE_PLOT_TYPE	
	TreeNode	GetDataPlotNode(int nPlotIndex, bool* pbIsGrouped = NULL, int* pnGroupIndex = NULL, TreeNode* ptrGroupNode = NULL) ;

private:
	bool	setTreeNodeGroupID( TreeNode &trNode );
	bool	setTreeNodeDataPlotID( TreeNode &trNode );
	
	TreeNode	getGroupNode(TreeNode& trLayer, int nGroupIndex);
	TreeNode 	checkGetGroupNode( TreeNode& trLayer, int nGroupIndex );	
	bool		checkUpdateOnlyOneNodeGroup(TreeNode& trGroupNode);
	
	void 		applyMoving();
	
	bool		changePlotTypeInGroup( int nDPIndex, int nNewPlotID );
	bool		changeOnePlotType( int nDPIndex, int nNewPlotID );///-----Kit 01/10/2011 STORGE_DP_TREE_INFO_AFTER_EDIT_TREE_NODE
	bool		changePlotType( int nNewPlotID, TreeNode &trDP );

private:  
	Tree	m_trContents;
	int		m_nGroupNum;
	int		m_nDataPlotNum;
	DWORD	m_dwChangeBits;
	int		m_nDataPageType;
	DWORD   m_dwLayerBits; /// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
};

class PlotTypeChangeHelper
{
public:
	/// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
	//PlotTypeChangeHelper( int nPlotID, int nPageType, TreeNode &trDP )
	PlotTypeChangeHelper( int nPlotID, int nPageType, DWORD dwLayerBits, TreeNode &trDP )
	///End IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
	{
		m_trDP		= trDP;
		m_nNewPlotID	= nPlotID;
		m_dwLayerBits = dwLayerBits; /// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
		m_nPageType = nPageType;
	}

	bool	ChangePlotType();
private:
	bool	getDPTreeInfo( PlotInfo &plotInfo );
	bool	changeDPTree( const TreeNode &trLayer );
private:
	TreeNode	m_trDP;
	int			m_nNewPlotID; // not plot type
	int			m_nPageType;
	DWORD		m_dwLayerBits;
};

///-----Kit 12/23/2010 ORG-1826-S5 FOLLOW_TEMPLATE_WHEN_ADDING_DATA_TO_RIGHT_PANEL
class StyleHolderHelper
{
public:
	StyleHolderHelper();
	
	bool	Init( const GraphLayer &gl, int nCurrentStyleHolder );
	bool	GetCurrentStyleHolderPlotID( int &nPlotType );
	bool	SetCurrentStyleHolderIndex( int nCurrentStyleHolder );
private:
	bool	getPlotInfo( int &nPlotType, DWORD &dwAuxPlotInfo, DWORD &dwLTPlotInfo );
private:
	int			m_nCurrentStyleHolderIndex;
	Tree		m_trStyleHolder;
	Collection<StyleHolder>    m_collStyleHolder;

	TreeNodeCollection			m_colltrStyleHolder;
};
///-----End FOLLOW_TEMPLATE_WHEN_ADDING_DATA_TO_RIGHT_PANEL

class LayerPlotList : public GridListControl
{
public:
	LayerPlotList();
	~LayerPlotList();
	bool	Init( UINT uID, WndContainer &Dlg, int nPageType );

	// virtual
	string  GetClassName() { return "LayerPlotList"; }

	bool 	GetSelRowsEx(vector<uint>& vuSelRows); /// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
	bool 	SelRowsEx(const vector<uint>& vuRows);
	
	bool 	CanMoveUpSelRows(const vector<uint>& vuSelRows);
	bool 	CanMoveDownSelRows(const vector<uint>& vuSelRows);
	
	bool 	CanDoGroupPlots(const vector<uint>& vuSelRows);
	bool	CanDoUngroupPlots(const vector<uint>& vuSelRows);
		
	bool	CanDoRemovePlots(const vector<uint>& vuSelRows);

	bool	IsSelSameRow();
	bool	IsAllowMoveRow(int nRow, int nNewRow);  /// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
	
	bool	SetDataPageType( int nDataPageType ){ return m_LCTreeHelper.SetDataPageType( nDataPageType ); }
	int		GetDataPageType(){ return m_LCTreeHelper.GetDataPageType(); }
	
	int		GetGroupNum() { return m_LCTreeHelper.GetGroupNum(); }
	
	void	SetLayerContentsChangeBit(int nBit) { m_LCTreeHelper.SetLayerContentsChangeBit(nBit); }
	bool	IsLayerContentsChanged() { return m_LCTreeHelper.IsLayerContentsChanged(); }
	void	SetLayerContentsTreeToCtrl();

	DWORD	GetLayerBits();
	bool 	GetCurrentStyleHolderPlotID( int &nStyleHolderPlotID );
	/// Iris 01/07/2011 ORG-1646-P1 SETBOLD_CAUSE_SLOW_SPEED_MORE
	//bool	UpdateBlodStatusByDatasetNames(const vector<string>& vsDatasetNames);
	bool   	UpdateBlodStatusByDatasetNames(GridListControl* pDatasetList); 
	///End SETBOLD_CAUSE_SLOW_SPEED_MORE

	///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
	void 	InitColsOrder();
	void	SaveColsOrder();
	int 	GetColPos(int nType){return m_colMap->GetColPos(nType);}
	int 	GetColType(int nPos){return m_colMap->GetColType(nPos);}
	void 	OnAfterMoveColumns(Control ctrl, long lCol, long *pnPosition){ m_colMap->OnAfterMoveColumns(lCol, pnPosition);}
	///End SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
	
	///Jasmine 01/12/11 ORG-1997-S2 SHOW_CURRENT_PLOT_TYPE
	string	GetCurDatasetName();	
	int 	GetCurDataPlotType();
	///End SHOW_CURRENT_PLOT_TYPE
	
	///Jasminie 02/14/11 ORG-2100-P8 SHOW_SOURCE_DATA_FOR_TEMP_PLOT
	int		CheckGetDifferentPageTypes(vector<int>& vnPageTypes);
	int		GetCurSourceSheets(vector<string>& vsBookSheets, int nPageType);
	int		GetCurSourceBooks(vector<string>& vsBooks, int nPageType);
	///End SHOW_SOURCE_DATA_FOR_TEMP_PLOT
	
	///-----Kit 03/01/2011 ORG-2319-P1 RUNTIME_ERROR_WHEN_GET_BOOK_SHEET_COL_TOOLTIP
	bool	GetDataPlotDescription(int nDPID, string &strDescription);
	///-----End RUNTIME_ERROR_WHEN_GET_BOOK_SHEET_COL_TOOLTIP

// event function!!!!!
public:	
	bool 	AddDataPlots( const TreeNode &trNewPlots, DWORD dwCtrl = ADDPLOTSFROMTREE_EDIT );
	/// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
	//bool	RemoveDataPlots( const vector<uint> &vuSelRows );
	/// Iris 12/29/2010 ORG-1826-S7 HIGHLIGHT_ADDED_OR_REMOVED_PLOTS
	//bool	RemoveDataPlots();
	bool	RemoveDataPlots(vector<string>& vsRemovedDatasetNames);
	///End HIGHLIGHT_ADDED_OR_REMOVED_PLOTS
	///End TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
	/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
	//bool	MoveDataPlot(int nRow, int nNewPos, bool bReorderRows = true, bool bUpdateGroup = true);
	bool 	MoveDataPlots(bool bMoveUp, bool bFirstOrLast = false, bool bReorderRows = true);
	bool 	MoveDataPlot(int nSelRow, int nNewPos);
	///End TO_MOVE_WHOLE_GROUP
	
	bool 	MoveDataPlotIntoGroup(int nGroupIndex);
	bool 	SetDataPlotGroup(bool bGroup);
	
	void	SetIsRescale(bool bRescale);
	bool	ApplyDataPlotsToLayer();

	void	OnBeforeMouseDown( short nButton, short nShift, float X, float Y, bool* pCancel );
	void	OnContextMenu(int nx, int ny);	///Sophy 2/7/2012 ORG-4478-P6 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	/// Iris 1/11/2010 USE_MOUSEUP_EVENT_REPLACE_SELCHANGE_EVENT_TO_CHECK_GROUPED_DATAPLOT_SELECTION
	void	OnSelChange();
	void 	OnMouseUp(short nButton, short nShift, float X, float Y);
	///End USE_MOUSEUP_EVENT_REPLACE_SELCHANGE_EVENT_TO_CHECK_GROUPED_DATAPLOT_SELECTION
	bool	OnCellBeforeEdit( int nRow, int nCol, BOOL* pCancel);
	bool	OnCellStartEdit( int nRow, int nCol, BOOL* pCancel);	///-----Kit 02/25/2011 ORG-2302-S1 MAKE_LEGEND_CAN_EDIT
	bool 	OnCellAfterEdit(int nRow, int nCol);
	bool	OnRangeCellBtnClick( int nRow, int nCol );

	void	OnMouseMove(short nButton, short nShift, float X, float Y);	///-----Kit 02/25/2011 ORG-2319-S1 SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW

	bool	CheckSelectAllPlotsInGroup();
	///Sophy 7/4/2011 ORG-3122 ORIGIN_DIALOG_CRASH_WITH_GRIDCONTROL_NOT_READY
	//bool	IsAllowSelectChangeEvent() { return m_bAllowSelectChangeEvent; } /// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	bool	IsAllowSelectChangeEvent() { return IsReady() && m_bAllowSelectChangeEvent; } /// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	///end ORIGIN_DIALOG_CRASH_WITH_GRIDCONTROL_NOT_READY

	int 	GetPlotTypeList(vector<string>& vsPlotType, int nPlotIndex);	///Jasmine 12/23/10 ORG-1826-S6 BATCH_CHANGE_PLOT_TYPE	

	void	OnLayerPropertiesDlgClose();
private:
	bool	addDataPlotsToCtrl( TreeNode &trLayer );
	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	//bool	setRowContents( const TreeNode &trLayer, int nBeginDPIndex, int nEndDPIndex );
	bool	setContents( const TreeNode &trLayer, int nBeginDPIndex = 0, int nEndDPIndex = -1, int nColType = -1 );
	bool	setColContents( int nColType, int nBeginDPIndex = 0, int nEndDPIndex = -1);
	///End TO_IMPROVE_UNGROUP_SPEED
	
	bool	deleteRows( const vector<uint> &vuSelRows );
	bool	updateGroupNumColumn();
	bool	initColumnsHeader();
	bool	initColumnsHidden();
	bool	getDefaultHiddenCols( vector<int> &vnCols );
	bool	canShowLegendCol();	///-----Kit 03/01/2011 ORG-2331-P3 HIDDEN_LEGEND_COL_WHEN_LAYER_IS_3D_OR_CONTOUR
	bool	initPlotTypeCellComboBox( int nRow, int nCol );
	
	/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
	int 	getMovingNewPos(const vector<uint>& vuSelRows, bool bMoveUp, int* pnNumSteps);
	int		getGroupIndex(int nSelRow);
	///End TO_MOVE_WHOLE_GROUP
	void 	onAfterMoveRows(int nRow, int nNewPos, bool bReorderRows, bool bUpdateGroup);
	bool	onOpenRangeEditorDlg( int nSelRow );
	bool	updateSelRowContent( int nSelRow );
	/// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
	//bool	selRowsAndNotSendEvent( const vector<uint> &vnSelRows);
	bool	selRowsAndNotSendEvent( const vector<uint> &vnSelRows, bool bSel = true );
	///End TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
	bool	canCellEditable( int nRow, int nCol );

	void 	onToggleRowColHeader(bool bShowMenu, int nx = 0, int ny = 0);	///Jasmine 12/23/10 ORG-1826-S3 HIDE_ROW_HEADER_TO_SAVE_SPACE
	void	onChangePlotType(int nIndex);	///Jasmine 12/23/10 ORG-1826-S6 BATCH_CHANGE_PLOT_TYPE			

	void 	autoColWidth();///Jasmine 12/29/10 ORG-1826-S1-3 COL_AUTO_WIDTH
	
	void 	setListHeading(LPCSTR lpczHeading);///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS	
	
	bool	initLayerContentsTreeHelper();	///-----Kit 01/10/2011 STORGE_DP_TREE_INFO_AFTER_EDIT_TREE_NODE
	
	///-----Kit 02/25/2011 ORG-2302-S1 MAKE_LEGEND_CAN_EDIT
	bool	initLegendCellBeforeEdit(int nRow, int nCol);
	bool	updateLegendCellAfterEdit(int nRow, int nCol);
	///-----End MAKE_LEGEND_CAN_EDIT

	///-----Kit 10/27/2011 ORG-4241-P1 MAKE_BAR_AND_COL_BAR_CAN_GROUP_IN_LAYER_CONTENT_AND_PLOT_SETUP
	bool	afterApplyClick();
	///-----End MAKE_BAR_AND_COL_BAR_CAN_GROUP_IN_LAYER_CONTENT_AND_PLOT_SETUP

private:
	bool						m_bRescale;
	GraphLayer					m_GraphLayer;
	LayerContentTreeHelper		m_LCTreeHelper;
	MoveColHelper				*m_colMap;		///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
// 	vector<int>					m_vnPlotsInGroup;
// 	bool						m_bIsAutoSelectionWholeGroupDone;
// 	int							m_nSelectedGroup;
// 	int							m_nRowIndexFirstPlotInGroup;
	vector<uint>				m_vnSelectedPlotsInGroup;  /// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
	bool						m_bAllowSelectChangeEvent; /// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	
	vector<int> 				m_vnStoragePlotIDsForPlotTypeCellChange;

	StyleHolderHelper			m_StyleHolderHelper;	
};

///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
// move to LayerPlotList.c
// class GeneratePlotInfoHelper
// {
// public:
// 	GeneratePlotInfoHelper(); 
// 	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
// 	//bool	GetRowContents( const TreeNode &trLayer, int nBeginDPIndex, int nEndDPIndex, vector<string> &vsRows, const vector<uint>& vnColMap );///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
// 	bool	GetContents( const TreeNode &trLayer, int nBeginDPIndex, int nEndDPIndex, vector<string> &vsRows, const vector<uint>& vnColMap, int nColType = -1 );
// 	///End TO_IMPROVE_UNGROUP_SPEED
// 	bool	IsInGroup();
// 
// private:
// 	bool	addLegend( const TreeNode &trDataPlot, vector<string> &vsRowContents );
// 	bool	addRowRange( const TreeNode &trDataPlot, vector<string> &vsRowContents );
// 	bool	addPlotTypeName( const TreeNode &trDataPlot,vector<string> &vsRowContents );
// 	bool	addShowInfo( const TreeNode &trDataPlot, vector<string> &vsRowContents );
// 	bool	addGroupInfo( const TreeNode &trDataPlot, vector<string> &vsRowContents );
// 	/// Iris 12/23/2010 ORG-1826-S2 SHOW_DATASET_NAME_IN_BOTH_SIDES_GRID
// 	bool	addDatasetName( const TreeNode &trDataPlot, vector<string> &vsDSNames );
// 	///End SHOW_DATASET_NAME_IN_BOTH_SIDES_GRID
// 	///Jasmine 12/22/10 ORG-1826-S1-3 PLOT_LIST_DEFAULT_SHOW_SNAME_LNAME_ETC
// 	bool	addColName( const TreeNode &trDataPlot, vector<string> &vsColNames );
// 	bool	addColLongName( const TreeNode &trDataPlot, vector<string> &vsColLNames );
// 	///End PLOT_LIST_DEFAULT_SHOW_SNAME_LNAME_ETC
// 
// 	bool	addBookLNName(const TreeNode& trDataPlot, vector<string> &vsNames);///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
// 	
// 	///Jasmine 12/29/10 ORG-1826-S1-3 HAVE_BOOK_SHEET_NAME_IN_BOTH_LEFT_RIGHT_LIST
// 	bool	addBookSNName( const TreeNode &trDataPlot, vector<string> &vsNames );
// 	bool	addSheetName( const TreeNode &trDataPlot, vector<string> &vsNames );
// 	///End HAVE_BOOK_SHEET_NAME_IN_BOTH_LEFT_RIGHT_LIST
// 	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
// 	//bool	getRowContents( const TreeNode &trDataPlot, vector<string> &vsRowContents );
// 	bool	getContents( const TreeNode &trDataPlot, vector<string> &vsRowContents, int nColType = -1 );
// 	///End TO_IMPROVE_UNGROUP_SPEED
// 	
// 	//
// 	bool	getColNameWithDesignation(const TreeNode &trDataPlot, string &strColNameWithDesignation);
// };
///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN

class PlotsControlHeaderMenu : public Menu
{
public:
	PlotsControlHeaderMenu(LayerPlotList* pPlotsCtrl);
	void 	OnMenuItem(UINT nPos) { m_uChoice = nPos - m_uOffset; }///Jasmine 12/23/10 ORG-1826-S3 HIDE_ROW_HEADER_TO_SAVE_SPACE
	bool	GetSel(UINT& uChoice);
	
private:
	bool	isSelOnValidColumHeader();
private:
	LayerPlotList*				m_pPlotsControl;
	UINT						m_uChoice;
	UINT						m_uOffset;		///Jasmine 12/23/10 ORG-1826-S3 HIDE_ROW_HEADER_TO_SAVE_SPACE
};

class PlotsGridMoveToMenu : public Menu
{
public:
	PlotsGridMoveToMenu(LayerPlotList* pPlotsCtrl);
	void 	OnMenuItem(UINT nPos) { m_nChoice = nPos; }
	bool	GetSel(uint& nChoice, int nSelCmd);
	
private:
	LayerPlotList*				m_pPlotsControl;
	int							m_nChoice;
};

class PlotsGridMenu : public Menu
{
public:
	//PlotsGridMenu(LayerPlotList* pPlotsCtrl, const Menu& subMenu);	///Jasmine 12/23/10 ORG-1826-S6 BATCH_CHANGE_PLOT_TYPE
	PlotsGridMenu(LayerPlotList* pPlotsCtrl, const Menu& subMenu, const Menu& subMenuPlotType);
	void 	OnMenuItem(uint nPos) { m_nChoice = nPos; }
	bool	GetSel(uint& nChoice);
	
private:
	LayerPlotList*				m_pPlotsControl;
	int							m_nChoice;
};

///Jasmine 12/23/10 ORG-1826-S6 BATCH_CHANGE_PLOT_TYPE
class PlotsGridPlotTypeMenu : public Menu
{
public:
	PlotsGridPlotTypeMenu(LayerPlotList* pPlotsCtrl);
	void 	OnMenuItem(UINT nPos) { m_nChoice = nPos; }
	bool	GetSel(uint& nChoice, int nSelCmd);
	
private:
	int 						m_nBegin;
	int 						m_nEnd; 
	int							m_nChoice;
};
///End BATCH_CHANGE_PLOT_TYPE

///-----Kit 02/25/2011 ORG-2319-S1 SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW
class SetPlotListToolTipHelper : public SetGridToolTipHelperBase
{
public:
	SetPlotListToolTipHelper(LayerPlotList *pPlotList) : SetGridToolTipHelperBase(pPlotList)
	{
	}
	// virtual
	bool GetRowToolTip(int nRow, string &strToolTip);
};

///-----End SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW
#endif	//_PLOTSCONTROL_H
