/*------------------------------------------------------------------------------*
 * File Name: LayerPlotList.c					 								*
 * Creation: Kit Chen															*
 * Purpose: Data plot list control												*
 * Copyright (c) OriginLab Corp.	2010, 2011									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Iris 1/20/2011 ORG-1962-P7 FIX_CANNOT_FIND_CORRECT_DATAPLOT_NODE_AFTER_CHANGE_PLOT_TYPE
 * Iris 3/10/2011 ORG-2371-P1 FIX_LC_RESCALE_ISSUE								*
 * Iris 3/15/2011 ORG-2371-P2 FIX_CHANGE_ROWRANGE_FOR_3D_LINE_PLOT_CAUSE_RESCALE_FAILED_ON_XY_AXES
 * Iris 3/15/2011 ORG-2371-S1 NEED_DISABLE_RANGE_EDIT_FOR_MATRIX_PLOT_EXCEPT_CONTOUR
 * Kit 04/21/2011 ORG-2690-P1 LAYER_PLOT_LIST_NEED_TO_SHOW_BOOK_LN_LIKE_DATASET_LIST
 * Kit 04/21/2011 ORG-2690-P3 WHEN_BOOK_LN_IS_EMPTY_SHOULD_SHOW_BOOK_SN			*
 *	Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN	*
 *	Kit 04/28/2011 CLEAN_UP_CODE												*
 *	Kit 05/17/2011 ORG-2614-P2 NOT_SHOW_SN_IN_LN_COL_WHEN_LN_IS_EMPTY			*
 *	Kit 05/23/2011 ORG-2932-P1 NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN		*
 *	Kit 11/02/2011 ORG-4062-P3 PUBLISH_WINDOW_THEME_FILE_OUT_OF_INDEX			*
 *	Folger 06/26/2012 ORG-5528-P22 SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT		*
 *	Jasmine 06/29/2012 ORG-6105-P1 GROUPING_NOT_AVAILABLE_FOR_MATRIX			*
 *	Tony 07/04/2012 ORG-2893-S1 ADD_BOOK_NAMING_COLUMN							*
 *	Philip 09/18/2012 ORG-5346-P1 AVOID_HIDE_ALL_COLUMNS_IN_BROWSERS			*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include "LayerPlotList.h"

/************************************************************************/
/* ---LayerPlotList                         		                    */
/************************************************************************/
#define NUM_FIXED_COL_WIDTH		400  /// Iris 01/07/2011 FIXED_COL_WIDTH_TOO_SMALL_TO_SHOW_GROUP_INDEX
		
#define	STR_HIDDEN_COL_SESSION_NAME "PlotsControlColHidden"

#define STR_GROUP_NAME 			"Group"
#define STR_DATAPLOT_NAME 		"DataPlot"
#define STR_GROUP_ID_ATTRIB 	"GroupID"
#define STR_GROUP_PREFIX		"g"	///Jasmine 01/12/11 ORG-1997-S4
#define STR_TEMP_NODE_NAME		"tmp"

#define	STR_BEFORE_EDIT_TREE_NODE_TAG_NAME "BeforeEdit"
#define FIND_2_LEVEL 2
enum {
	PLOTGRID_PLOT_TYPE,		///Jasmine 12/23/10 ORG-1826-S6 BATCH_CHANGE_PLOT_TYPE
	// pls add new item before this one
	PLOTGRID_MOVETO = 100
};

enum {
	MOVETO_SUBMENU_BEGIN,
	MOVETO_SUBMENU_PREVIOUS = MOVETO_SUBMENU_BEGIN,
	MOVETO_SUBMENU_NEXT,
	MOVETO_SUBMENU_TOP,
	MOVETO_SUBMENU_BOTTOM,
	MOVETO_SUBMENU_GROUP_BEGIN,
	MOVETO_SUBMENU_GROUP_END = MOVETO_SUBMENU_GROUP_BEGIN + 100,
	
	MOVETO_SUBMENU_END
};

#define STR_GROUP_DATAPLOTS_TIPS		_L("Can not group the selected plots. Plot type should be the same.")
#define STR_CHANGE_PLOT_TYPE_TIPS		_L("Can not change the selected plots' type. Plot type should be the same.") /// Iris 01/04/2011 ORG-1682-P4 IMPROVE_LAYER_CONTENTS_DLG_GROUP_MSG
///Jasmine 12/23/10 ORG-1826-S3 HIDE_ROW_HEADER_TO_SAVE_SPACE
#define STR_HIDE_FIX_COL		_L("Hide Row Header")
#define	MENU_HIDE_FIX_COL_ID	(MENU_AUTO_SIZE_COL_ID+1)//1000		///Jasmine 12/29/10 ORG-1826-S1-3 COL_AUTO_WIDTH
///End HIDE_ROW_HEADER_TO_SAVE_SPACE

#define GET_DATAPLOT_INDEX_FROM_SEL_ROW( _nSelRow ) ((_nSelRow) - 1)
#define GET_ROW_INDEX_BY_DATAPLOT_INDEX( _nDataPlotIndex ) ((_nDataPlotIndex) + 1)



static bool _is_dataplot_in_group( TreeNode &trNode )
{
	int nGroupNum = 0;
	int nDataPlotNum = 0;
	if( trNode.GetAttribute( STR_GROUP_ID_ATTRIB, nGroupNum ) && trNode.GetAttribute( STR_DATAID_ATTRIB, nDataPlotNum ) )
		return true;

	return false;
}

static bool _get_group_id_attrib_from_dp_tree_node( const TreeNode &trDP, string &strGroupInfo )
{
	string strTemp = "";
	if( !trDP.GetAttribute( STR_GROUP_ID_ATTRIB, strTemp ) )
	{	
		strGroupInfo = "";
		return false;
	}
	
	strGroupInfo = STR_GROUP_PREFIX + strTemp;
	return true;
}

static bool _get_plot_id_from_dp_tree_node( const TreeNode &trDP, int &nPlotID )
{
	if( !trDP.IsValid() )
		return false;
	
	TreeNode trPlotDesigs = trDP.PlotDesigs;
	if( !trPlotDesigs.IsValid() )
		return error_report("the DataPlot tree node does not have PlotDesigs tree node");

	TreeNode trPlotType = trPlotDesigs.Type;
	TreeNode trAuxPlotInfo = trPlotDesigs.AuxPlotInfo;
	TreeNode trLTPlotInfo = trPlotDesigs.LTPlotInfo;
	
	ASSERT( trPlotType.IsValid() && trAuxPlotInfo.IsValid() && trLTPlotInfo.IsValid() );

	DWORD dwAuxPlotInfo = (DWORD)trAuxPlotInfo.nVal;
	DWORD dwLTPlotInfo = (DWORD)trLTPlotInfo.nVal;

	nPlotID = ConvertPlotIds( trPlotType.nVal, &dwAuxPlotInfo, &dwLTPlotInfo );

	return true;
}

// return false if not create from page, otherwise return true
static bool _get_page_type_from_dp_tree_node( const TreeNode &trDP, int &nPageType )
{
	if( !trDP.IsValid() )
	{
		ASSERT(false);
		error_report("pass a invalid DataPlot tree node in static bool _get_page_type_from_dp_tree_node()");
		nPageType = EXIST_NONE;
		return false;
	}

	TreeNode trPageNode = trDP.PlotDesigs.WksPage;
	if( trPageNode.IsValid() && !trPageNode.IsEmpty() )
	{
		Page pg( trPageNode.strVal );
		nPageType = pg.GetType();		
	}
	else
		nPageType = EXIST_DATA; // loosedataset, virtual matrix or function plot
	return true;	
}

static bool _is_dp_from_virtual_matrix( const TreeNode &trDP )
{
	int nSuffix = 1;
	/// Iris 1/20/2011 FIX_FAIL_PLOT_VM
	//const bool bAlwaysDoUntilBreak;
	const bool bAlwaysDoUntilBreak = true;
	///End FIX_FAIL_PLOT_VM
	bool bIsVirtualMatrix = false;
	while( bAlwaysDoUntilBreak )
	{
		string strDPC = "DPC" + nSuffix;
		TreeNode trDPC = tree_get_node_by_tagname( trDP, strDPC, true );

		if( !trDPC.IsValid() )
			break;
		
		/// Iris 1/20/2011 FIX_FAIL_PLOT_VM
		/*
		TreeNode trDesigs = trDPC.Desigs;
		ASSERT( trDesigs.Name.IsValid() );

		if( okutil_is_virtual_matrix( trDesigs.Name.strVal ) )
		*/
		if( trDPC.Name.IsValid() && okutil_is_virtual_matrix( trDPC.Name.strVal ) )
		///End FIX_FAIL_PLOT_VM
		{
			bIsVirtualMatrix = true;
			break;
		}
		nSuffix++; /// Iris 1/20/2011 FIX_FAIL_PLOT_VM
	}

	return bIsVirtualMatrix;
}

static BOOL _open_RangeEditorDlg( RangeEditorDlgInfo &dlgInfo )
{
	return RangeEditorDlg( dlgInfo.nMin, dlgInfo.nMax, &dlgInfo.nFrom, &dlgInfo.nTo, &dlgInfo.bFromAuto, &dlgInfo.bToAuto );
}

static bool _get_row_range_from_str( LPCTSTR lpcszRowRange, int &nFrom, int &nTo, BOOL *pbFromAuto = NULL, BOOL *pbToAuto = NULL )
{
	string strRowRange = lpcszRowRange;
	if( strRowRange.IsEmpty() )
		return false;

	strRowRange.TrimLeft( '[' );
	strRowRange.TrimRight( ']' );
	
	int nFind = strRowRange.Find( ':' );

	if( nFind < 0 )
		return false;

	ASSERT( nFind > 0 );
	
	string strFrom = strRowRange.Mid( 0, nFind );
	string strTo = strRowRange.Mid( nFind+1, strRowRange.GetLength() );

	if( strFrom[nFind-1] == '*' )
	{
		strFrom.TrimRight( '*' );
		if( NULL != pbFromAuto )
			*pbFromAuto = TRUE;
	}
	else
	{
		if( NULL != pbFromAuto )
			*pbFromAuto = FALSE;
	}

	if( strTo[strTo.GetLength()-1] == '*' )
	{
		strTo.TrimRight( '*' );
		if( NULL != pbToAuto )
			*pbToAuto = TRUE;
	}
	else
	{
		if( NULL != pbToAuto )
			*pbToAuto = FALSE;
	}

	nFrom = atoi( strFrom );
	nTo = atoi( strTo );

	ASSERT( nFrom <= nTo );

	return true;

}

static bool _set_row_range_to_str( int nFrom, int nTo, string &strRowRange, BOOL *pbFromAuto = NULL, BOOL *pbToAuto = NULL )
{
	if( nFrom > nTo )
		return false;
	
	string strFrom = nFrom;
	string strTo = nTo;
	
	if( NULL != pbFromAuto && *pbFromAuto )
		strFrom += "*";
	
	if( NULL != pbFromAuto && *pbToAuto )
		strTo += "*";
	
	strRowRange.Empty();
	
	strRowRange.Format( "[%s:%s]", strFrom, strTo );
	
	return true;
}

///-----Kit 01/10/2011 STORGE_DP_TREE_INFO_AFTER_EDIT_TREE_NODE
static bool _storge_before_edit_dp_tree_node( const TreeNode &trOld, TreeNode &trNew )
{
	if( !(trOld.IsValid() && trNew.IsValid()) )
	{
		ASSERT( false );
		return false;
	}
	
	TreeNode trBeforeEdit = tree_get_node_by_tagname( trNew, STR_BEFORE_EDIT_TREE_NODE_TAG_NAME );
	// if have BeforeEdit tree node, no need to storge!
	if( trBeforeEdit.IsValid() )
		return false;

	trBeforeEdit = trNew.AddNode( STR_BEFORE_EDIT_TREE_NODE_TAG_NAME );
	
	/// Iris 1/20/2011 ORG-1962-P7 FIX_CANNOT_FIND_CORRECT_DATAPLOT_NODE_AFTER_CHANGE_PLOT_TYPE
	// here dataid attribute will effect GetDataPlotNode to get incorrect dataplot node after BeforeEdit
	// so remove the two attributes before add the node to BeforeEdit.
	trOld.RemoveAttribute(STR_DATAID_ATTRIB);
	trOld.RemoveAttribute(STR_GROUP_ID_ATTRIB);
	///End FIX_CANNOT_FIND_CORRECT_DATAPLOT_NODE_AFTER_CHANGE_PLOT_TYPE
	
	trBeforeEdit.AddNode( trOld );

	return true;
}
///-----End STORGE_DP_TREE_INFO_AFTER_EDIT_TREE_NODE

class HandleColorSizeDesignationHelper
{
public:
	HandleColorSizeDesignationHelper( vector<string> &vsName, vector<uint> &vuDesig, bool bNewTypeHasColor, bool bNewTypeHasSize )
	{
		m_pvsName = &vsName;
		m_pvuDesig = &vuDesig;
	
		if( !hasSpeicalColDesig( COLDESIG_COLOR, m_nColorIndex ) )
			m_nColorIndex = -1;

		if( !hasSpeicalColDesig( COLDESIG_SIZE, m_nSizeIndex ) )
			m_nSizeIndex = -1;

		m_bNewTypeHasColor = bNewTypeHasColor;
		m_bNewTypeHasSize = bNewTypeHasSize;
	}

	bool	UpdateColNameAndColDesignation()
	{
		if( m_pvuDesig->GetSize() != m_pvsName->GetSize() )
								return false;
	
		if( m_nColorIndex > 0 && m_nSizeIndex > 0 )
	{
			return handleColorSizeCase();
		}
		else if( m_nColorIndex > 0 )
		{
			return handleColorCase();
		}
		else if( m_nSizeIndex > 0 )
		{
			return handleSizeCase();
		}
		
		return false;
	}

private:
	bool	hasSpeicalColDesig( int nColDesig, int &nIndex )
		{
			vector<uint> vuIndex;
		if( m_pvuDesig->Find( MATREPL_TEST_EQUAL, nColDesig, vuIndex, 0, -1 ) > 0 )
			{
			nIndex = vuIndex[0];
			return true;
		}
				
		return false;
			}

	bool	handleColorSizeCase()
	{
		vector<int> vnRemoveIndex;
		if( m_bNewTypeHasColor )
		{
			vnRemoveIndex.Add( m_nSizeIndex );
		}
		else if( m_bNewTypeHasSize )
		{
			vnRemoveIndex.Add( m_nColorIndex );
		}
		else
		{
			vnRemoveIndex.Add( m_nColorIndex );
			vnRemoveIndex.Add( m_nSizeIndex );
		}
		
		for( int ii=0; ii<vnRemoveIndex.GetSize(); ++ii )
		{
			m_pvsName->RemoveAt( vnRemoveIndex[ii] );
			m_pvuDesig->RemoveAt( vnRemoveIndex[ii] );
		}
		
		return true;
	}
		
	bool	handleColorCase()
	{
		ASSERT( !m_bNewTypeHasColor );
		if( m_bNewTypeHasSize )
		{
			vector<uint> &vuDesig = *m_pvuDesig;
			vuDesig[m_nColorIndex] = COLDESIG_SIZE;
		}
		else
		{
			m_pvuDesig->RemoveAt( m_nColorIndex );
			m_pvsName->RemoveAt( m_nColorIndex );
		}
		
		return true;
	}
	bool	handleSizeCase() 
		{
		ASSERT( !m_bNewTypeHasSize );

		if( m_bNewTypeHasColor )
			{
			vector<uint> &vuDesig = *m_pvuDesig;
			vuDesig[m_nSizeIndex] = COLDESIG_COLOR;
			}
		else
		{
			m_pvuDesig->RemoveAt( m_nSizeIndex );
			m_pvsName->RemoveAt( m_nSizeIndex );
		}
		return true; 
	}
	
private:
	vector<string>	*m_pvsName;
	vector<uint>	*m_pvuDesig;
	int		m_nSizeIndex;
	int		m_nColorIndex;
	bool	m_bNewTypeHasColor;
	bool	m_bNewTypeHasSize;

};

static bool _get_new_plot_info( int nNewPlotID, int nPageType, DWORD dwLayerBits, PlotInfo &plotInfo )
{
	PlotInfo plotInfoNew;
	plotInfoNew.nPlotType = get_plot_type_info( nNewPlotID, nPageType, dwLayerBits, plotInfoNew.dwAuxTypeInfo, 
		plotInfoNew.dwLTPlotInfo, plotInfoNew.strColPattern );
	
	/// Iris 12/07/2011 ORG-4482-P5 FIX_LAYER_CONTECTS_DLG_AND_PLOT_SETUP_CHANGE_SURFACE_TO_3DBARS_FAILED
	if( IDM_PLOT_3D_MESH == plotInfoNew.nPlotType && IDM_PLOT_SURFACE_BARS == nNewPlotID )
	{
		plotInfoNew.nPlotType = nNewPlotID;
	}
	///End FIX_LAYER_CONTECTS_DLG_AND_PLOT_SETUP_CHANGE_SURFACE_TO_3DBARS_FAILED

	if( is_plottype_the_same( plotInfo.nPlotType, plotInfo.dwAuxTypeInfo, plotInfo.dwLTPlotInfo,
								plotInfoNew.nPlotType, plotInfoNew.dwAuxTypeInfo, plotInfoNew.dwLTPlotInfo ) )
								return false;
	
	HandleColorSizeDesignationHelper csHelper( 	plotInfo.vsColNames,
												plotInfo.vuColDesignations,
												HAS_COLDESIG_COLOR(plotInfoNew.dwAuxTypeInfo), 
												HAS_COLDESIG_SIZE( plotInfoNew.dwAuxTypeInfo ) );
	
	csHelper.UpdateColNameAndColDesignation();

	plotInfo.nPlotType = plotInfoNew.nPlotType;
	plotInfo.dwAuxTypeInfo = plotInfoNew.dwAuxTypeInfo;
	plotInfo.dwLTPlotInfo = plotInfoNew.dwLTPlotInfo;
	plotInfo.strColPattern = plotInfoNew.strColPattern;
	
	return true;
}

/************************************************************************/
/* ---DataPlotTreeNodeHelper                                            */
/************************************************************************/
class DataPlotTreeNodeHelper
{
public:
	DataPlotTreeNodeHelper(){}///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	DataPlotTreeNodeHelper( const TreeNode &trDP );

	///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	bool	SetDataPlotTreeNode(const TreeNode& trDP);
	bool	GetDataPlotTreeNode(TreeNode& trDP);
	///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	
	int		GetPlotType();	///-----Kit 10/27/2011 ORG-4241-P1 MAKE_BAR_AND_COL_BAR_CAN_GROUP_IN_LAYER_CONTENT_AND_PLOT_SETUP
	bool	GetPlotType( int &nPlotType );
	bool	GetAuxPlotInfo( DWORD &dwAuxPlotInfo );
	bool	GetLTPlotInfo( DWORD &dwLTPlotInfo );
	///-----Kit 04/21/2011 ORG-2690-P1 LAYER_PLOT_LIST_NEED_TO_SHOW_BOOK_LN_LIKE_DATASET_LIST
	//bool	GetPageLayerName( string &strPage, string &strLayer);
	bool	GetLayerName(string &strLayer);
	bool	GetPageShortName(string& strPageSN);
	bool	GetPageLongName(string& strPageLN);
	///-----End LAYER_PLOT_LIST_NEED_TO_SHOW_BOOK_LN_LIKE_DATASET_LIST
	
	bool	GetColNameAndColDesignation( vector<string> &vsName, vector<uint> &vuDesig );
	bool	GetRowRange( int arrRange[2] );
	bool	GetRowRange(string &strRange);
	bool	GetShowInfo( bool &bShow ); /// Iris 01/10/2011 FIX_CHANGE_PLOTTYPE_NOT_KEEP_SHOWINFO
	
	///-----Kit 02/25/2011 ORG-2302-S1 MAKE_LEGEND_CAN_EDIT
	bool	GetLegend(string &strLegend);
	bool	SetLegend(LPCTSTR lpcszLegend);
	///-----End MAKE_LEGEND_CAN_EDIT
	
	///-----Kit 03/01/2011 ORG-2319-P1 RUNTIME_ERROR_WHEN_GET_BOOK_SHEET_COL_TOOLTIP
	bool	GetDPDescription(string &strDescription);
	///-----End RUNTIME_ERROR_WHEN_GET_BOOK_SHEET_COL_TOOLTIP
	
	///-----Kit 03/09/2011 ORG-2331-S4 SHOW_COL_DESIGNATION_ON_RIGHT_PANEL
	bool	GetColNameWithDesig(string &strDesig);
	bool	GetDatasetName(string &strDSName);
	bool	GetPlotTypeName(string &strPlotTypeName);
	bool	GetColLongName(string &strColLongName);
	bool	GetPageType(int &nPageType);
	///-----End SHOW_COL_DESIGNATION_ON_RIGHT_PANEL
	///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
private:
	bool	init(const TreeNode& trDP);
	///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
private:
	TreeNode	m_trDP;
	TreeNode	m_trPlotDesigs;
};

///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
/************************************************************************/
/*   GeneratePlotInfoHelper                                             */
/************************************************************************/
// move from LayerPlotList.h
class GeneratePlotInfoHelper
{
public:
	GeneratePlotInfoHelper(); 
	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	//bool	GetRowContents( const TreeNode &trLayer, int nBeginDPIndex, int nEndDPIndex, vector<string> &vsRows, const vector<uint>& vnColMap );///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
	bool	GetContents( const TreeNode &trLayer, int nBeginDPIndex, int nEndDPIndex, vector<string> &vsRows, const vector<uint>& vnColMap, int nColType = -1 );
	///End TO_IMPROVE_UNGROUP_SPEED
	bool	IsInGroup();
	
private:
	///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	/// I have changed all the interface, they will use a class member instead always pass a parameter
	/// I just changed them, but did not add comment, otherwise there will be too many comment.
	bool	addLegend(vector<string> &vsRowContents);
	bool	addRowRange(vector<string> &vsRowContents);
	bool	addPlotTypeName(vector<string> &vsRowContents);
	bool	addShowInfo(vector<string> &vsRowContents);
	bool	addGroupInfo(vector<string> &vsRowContents);
	/// Iris 12/23/2010 ORG-1826-S2 SHOW_DATASET_NAME_IN_BOTH_SIDES_GRID
	bool	addDatasetName(vector<string> &vsDSNames);
	///End SHOW_DATASET_NAME_IN_BOTH_SIDES_GRID
	///Jasmine 12/22/10 ORG-1826-S1-3 PLOT_LIST_DEFAULT_SHOW_SNAME_LNAME_ETC
	bool	addColName(vector<string> &vsColNames);
	bool	addColLongName(vector<string> &vsColLNames);
	///End PLOT_LIST_DEFAULT_SHOW_SNAME_LNAME_ETC
	
	bool	addBookName(vector<string> &vsNames);///-----Tony 07/04/2012 ORG-2893-S1 ADD_BOOK_NAMING_COLUMN
	
	bool	addBookLNName(vector<string> &vsNames);///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	
	///Jasmine 12/29/10 ORG-1826-S1-3 HAVE_BOOK_SHEET_NAME_IN_BOTH_LEFT_RIGHT_LIST
	bool	addBookSNName(vector<string> &vsNames);
	bool	addSheetName(vector<string> &vsNames);
	///End HAVE_BOOK_SHEET_NAME_IN_BOTH_LEFT_RIGHT_LIST
	bool	getColNameWithDesignation(string &strColNameWithDesignation);

private:
	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	//bool	getRowContents( const TreeNode &trDataPlot, vector<string> &vsRowContents );
	bool	getContents( const TreeNode &trDataPlot, vector<string> &vsRowContents, int nColType = -1 );
	///End TO_IMPROVE_UNGROUP_SPEED
	///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
private:
	DataPlotTreeNodeHelper	m_DPHelper;
	///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
};
///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN

/************************************************************************/
/*  LayerPlotList                                                       */
/************************************************************************/
LayerPlotList::LayerPlotList()
{
	SetDlgName( STR_DLG_NAME );
	m_GraphLayer = Project.ActiveLayer();
	ASSERT( m_GraphLayer.IsValid() );
	m_bAllowSelectChangeEvent = true; 	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	///-----Kit 01/10/2011 STORGE_DP_TREE_INFO_AFTER_EDIT_TREE_NODE
// 	Tree trContents;
// 	m_GraphLayer.GetLayerContents( trContents, GETLC_BITS );
// 	ASSERT( trContents.IsValid() );
// 
// 	m_LCTreeHelper.SetLayerContentsTree( trContents );
	///-----Kit 01/12/2011 CLEAN_UP_LAYER_CONTENTS_CODE
	//initLayerContentsTreeHelper();
	///-----End CLEAN_UP_LAYER_CONTENTS_CODE
	///-----End STORGE_DP_TREE_INFO_AFTER_EDIT_TREE_NODE
}

LayerPlotList::~LayerPlotList()
{
	SaveColsWidthToReg();	
	SaveColsShowHiddenToReg( STR_HIDDEN_COL_SESSION_NAME );
	///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
	SaveColsOrder();
	delete m_colMap;
	///End SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
}

bool	LayerPlotList::Init( UINT uID, WndContainer &Dlg, int nPageType )
{
	GridListControl::Init( uID, Dlg ); 
	SetDrawHidedColMarker(true);	///Jasmine 01/13/11 ORG-1997-S6 DRAW_MARKER_FOR_THE_HIDEED_COLUMN
	
	initColumnsHeader();
	
	SetAlternateRowColors();
	
	SetDataPageType( nPageType );
	///-----Kit 01/12/2011 CLEAN_UP_LAYER_CONTENTS_CODE
	//Tree trContents;
	//m_LCTreeHelper.GetLayerContentsTree( trContents );
	//SetLayerContentsTreeToCtrl( trContents );
	SetLayerContentsTreeToCtrl();
	////-----

	/// Iris 01/05/2011 ORG-1826-P5 COL_GOOD_DEFAULT_SIZE_AND_REMEMBER_SIZE_WHEN_REOPEN_DLG
	// to resize columns after add layer contents.
	if( !InitColsWidthFromReg() )
	{
		ResizeCols();
		/// Iris 01/07/2011 FIXED_COL_WIDTH_TOO_SMALL_TO_SHOW_GROUP_INDEX
		//SetColWidth(PlotsCtrl_FixCol, 300);
		SetColWidth(PlotsCtrl_FixCol, NUM_FIXED_COL_WIDTH);
		///End FIXED_COL_WIDTH_TOO_SMALL_TO_SHOW_GROUP_INDEX
	}
	///End COL_GOOD_DEFAULT_SIZE_AND_REMEMBER_SIZE_WHEN_REOPEN_DLG
	
	initColumnsHidden();

	m_StyleHolderHelper.Init( m_GraphLayer, m_LCTreeHelper.GetDataPlotNum() );
	m_LCTreeHelper.Init( GetLayerBits() );
	return true; 
}

void	LayerPlotList::SetLayerContentsTreeToCtrl()
{
	///-----Kit 01/12/2011 CLEAN_UP_LAYER_CONTENTS_CODE
	//m_LCTreeHelper.SetLayerContentsTree( trContents );
	//m_LCTreeHelper.ResetGroupIDAndDataPlotID();
	initLayerContentsTreeHelper();
	Tree trContents;
	m_LCTreeHelper.GetLayerContentsTree( trContents );
	///-----
	
	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	//setRowContents( trContents.FirstNode );
	setContents( trContents.FirstNode );
	///End TO_IMPROVE_UNGROUP_SPEED
}

DWORD	LayerPlotList::GetLayerBits()
{
	return m_GraphLayer.GetSystemParam(GLI_PCD_BITS); 
}

bool 	LayerPlotList::AddDataPlots( const TreeNode &trNewPlots, DWORD dwCtrl /*= ADDPLOTSFROMTREE_EDIT */ )
{
	TreeNode trLayer = trNewPlots.FirstNode;
	if( trLayer.IsValid() )
	{
		int nCurrentNumPlots = m_LCTreeHelper.GetDataPlotNum();  /// Iris 12/29/2010 ORG-1826-S7 HIGHLIGHT_ADDED_OR_REMOVED_PLOTS
		addDataPlotsToCtrl( trLayer );
		m_LCTreeHelper.AddDataPlots( trLayer );
		int nNewPlots = m_LCTreeHelper.GetDataPlotNum() - nCurrentNumPlots;
		
		if( nNewPlots > 0 )
		{
			/// Iris 12/29/2010 ORG-1826-S7 HIGHLIGHT_ADDED_OR_REMOVED_PLOTS
			vector<uint> vuNewAddedRows;
			vuNewAddedRows.Data(nCurrentNumPlots + GetRowOffset(), m_LCTreeHelper.GetDataPlotNum(), 1);
			SelRowsEx(vuNewAddedRows);
			///End HIGHLIGHT_ADDED_OR_REMOVED_PLOTS
			
			/// Iris 01/07/2011 ORG-1646-P1 SETBOLD_CAUSE_SLOW_SPEED_MORE
			for(int index = 0; index < vuNewAddedRows.GetSize(); index++)
				SetBold(vuNewAddedRows[index], -1, true);
			///End SETBOLD_CAUSE_SLOW_SPEED_MORE
			
			m_StyleHolderHelper.SetCurrentStyleHolderIndex( m_LCTreeHelper.GetDataPlotNum() );
			return true;
		}
		return false;
	}
	
	return false;
}


bool 	LayerPlotList::addDataPlotsToCtrl( TreeNode &trLayer )
{
	int nBeginDPIndex = m_LCTreeHelper.GetDataPlotNum();
	int nDPsUpdate = m_LCTreeHelper.SetGroupIDAndDataPlotIDAttrib( trLayer );
	int nEndDPIndex = nBeginDPIndex + nDPsUpdate - 1;
	
	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	//return setRowContents( trLayer, nBeginDPIndex, nEndDPIndex );
	return setContents( trLayer, nBeginDPIndex, nEndDPIndex );
	///End TO_IMPROVE_UNGROUP_SPEED
}

bool 	LayerPlotList::initColumnsHeader() 
{
	SetReady(false);
	SetCols(PlotsCtrl_TotalCols, false);
	m_flx.FixedCols = 1;
	///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
	//SetColHeader( STR_PLOTS_CTRL_HEADER );
	m_colMap = new MoveColHelper();
	InitColsOrder();
	setListHeading(STR_PLOTS_CTRL_HEADER);
	///End SHARE_COL_MOVING_CODE_IN_BOTH_PANELS	
	
	SetColDataType( GetColPos(PlotsCtrl_Show), flexDTBoolean ); // checkbox	
	
	SetAllowSelection(true); // to allow select multiple rows
	m_flx.SelectionMode = flexSelectionListBox;
	
	//m_flx.ExtendLastCol = false; /// Iris 12/22/2010 ORG-1826-S1.4 CHANGED_TO_NO_GRAY_IN_BOTH_SIDES_GRID
 	m_flx.AllowUserResizing = flexResizeColumns;
	m_flx.AutoSizeMode = flexAutoSizeColWidth;
	/// Iris 1/11/2011 NEED_NOT_ALLOW_SORT_COL_IN_PLOTLIST_VIEW
	// sort column will effect the group info.
	//SetExplorerBar(flexExSortAndMove);	//flexExMoveRows		///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
	SetExplorerBar(flexExMoveColsAndRows);
	///End NEED_NOT_ALLOW_SORT_COL_IN_PLOTLIST_VIEW
	SetColAlignment(-1, flexAlignLeftCenter); /// Iris 01/05/2011 ORG-1826-P6 SET_COLUMN_LEFT_ALIGNMENT	
	
	m_flx.MergeCells = flexMergeSpill;///Jasmine 01/19/11 ORG-2046-S1 SPILL_LONG_TEXT
	
	/// Iris 01/05/2011 ORG-1826-P5 COL_GOOD_DEFAULT_SIZE_AND_REMEMBER_SIZE_WHEN_REOPEN_DLG
	/*
	//if( !InitColsWidthFromReg() )
		ResizeCols();
	SetColWidth(PlotsCtrl_FixCol, 300);
	*/
	///End COL_GOOD_DEFAULT_SIZE_AND_REMEMBER_SIZE_WHEN_REOPEN_DLG
	
	SetReady(true);		
	return true;
}
///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
void 	LayerPlotList::InitColsOrder()
{
	m_colMap->m_vnColMap.Data(PlotsCtrl_FixCol , PlotsCtrl_TotalCols - 1);
		
	string strVal;
	if( dlg_load_registry(GetDlgNameForRegistry(), "ColOrder", strVal) && !strVal.IsEmpty() )
	{
		vector<string> vsTemp;
		strVal.GetTokens(vsTemp, '|');
		convert_string_vector_to_uint_vector(vsTemp, m_colMap->m_vnColMap);
	}
}
void 	LayerPlotList::SaveColsOrder()
{	
	vector<string> vsTemp;
	convert_uint_vector_to_string_vector(m_colMap->m_vnColMap, vsTemp);
	
	string strVal;
	strVal.SetTokens(vsTemp, '|');
	
	dlg_save_to_registry(GetDlgNameForRegistry(), "ColOrder", strVal);		
}
///End SHARE_COL_MOVING_CODE_IN_BOTH_PANELS

void 	LayerPlotList::setListHeading(LPCSTR lpczHeading)
{
	if(m_colMap->m_vnColMap.GetSize() > 0)
	{
		vector<string> vstrListHeading;
		str_separate(lpczHeading, "|", vstrListHeading); 
		vstrListHeading.Reorder(m_colMap->m_vnColMap);///Jasmine 01/05/11 ORG-1826-S8 MOVE_COLUMN_ORDER
		SetColHeader( str_combine(vstrListHeading, "|") );
	}
	else
		SetColHeader(lpczHeading);
}
///End SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
bool 	LayerPlotList::initColumnsHidden()
{
	vector<int> vnDefaultHiddenCols;
	getDefaultHiddenCols( vnDefaultHiddenCols );
	InitColsShowHiddenFromReg( STR_HIDDEN_COL_SESSION_NAME, &vnDefaultHiddenCols );
	return true;
}

bool 	LayerPlotList::getDefaultHiddenCols( vector<int> &vnCols )
{
	///Jasmine 12/22/10 ORG-1826-S1-3 PLOT_LIST_DEFAULT_SHOW_SNAME_LNAME_ETC
	//vnCols = s_vnPlotsControlDefaultHidden;
	vnCols.SetSize(PlotsCtrl_TotalCols);
	vnCols = 1;
	
	vector<uint> vnDefalutShowCols = {PlotsCtrl_SName, PlotsCtrl_LName, PlotsCtrl_Legend, PlotsCtrl_PlotType};
	
	vnCols.Replace(vnDefalutShowCols, 0);
	///End PLOT_LIST_DEFAULT_SHOW_SNAME_LNAME_ETC
	
	vnCols[PlotsCtrl_Legend] = !canShowLegendCol();	///-----Kit 03/01/2011 ORG-2331-P3 HIDDEN_LEGEND_COL_WHEN_LAYER_IS_3D_OR_CONTOUR
	
	return true;
}

///-----Kit 03/01/2011 ORG-2331-P3 HIDDEN_LEGEND_COL_WHEN_LAYER_IS_3D_OR_CONTOUR
bool	LayerPlotList::canShowLegendCol()
{
	/// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
	//if( PCD_LAYER_3D == ( GetLayerBits() & MASK_PCD_LAYER_BITS) )	
	///------ Folger 06/26/2012 ORG-5528-P22 SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
	//if( O_QUERY_BOOL_EX(GetLayerBits(), PCD_LAYER_3D, MASK_PCD_LAYER_BITS) || O_QUERY_BOOL_EX(GetLayerBits(), PCD_LAYER_3D_GL, MASK_PCD_LAYER_BITS) )
	if( O_QUERY_BOOL_EX(GetLayerBits(), PCD_LAYER_3D, MASK_PCD_LAYER_BITS) )
	///------ End SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
	///End IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
		return false;

	// has contour plot ? 
	for( int ii = GetRowOffset(); ii < GetRows(); ++ii )
	{
		DataPlotTreeNodeHelper dpHelper(m_LCTreeHelper.GetDataPlotNode(GET_DATAPLOT_INDEX_FROM_SEL_ROW(ii)));
		int nPlotType = IDM_PLOT_UNKNOWN;
		dpHelper.GetPlotType(nPlotType);
		if( IDM_PLOT_CONTOUR == nPlotType 
			|| IDM_PLOT_TERNARY_CONTOUR == nPlotType 
			|| IDM_PLOT_TRI_CONTOUR == nPlotType
			)
			return false;
	}

	return true;
}
///-----End HIDDEN_LEGEND_COL_WHEN_LAYER_IS_3D_OR_CONTOUR

bool	LayerPlotList::CheckSelectAllPlotsInGroup()
{
	/// Iris 1/21/2011 ORG-162-P9 TO_IMPROVE_UNGROUP_SPEED
	if( !IsAllowSelectChangeEvent() )
		return false;
	///End TO_IMPROVE_UNGROUP_SPEED
	
	vector<uint> vuSelRows;
	if( !GetSelRows(vuSelRows) )
		return false; // no selection
	/*
	if( vuSelRows.GetSize() > 1 ) // if drag mouse to select multiple rows, GetSelRows can get all selected rows, no need m_vnSelectedPlotsInGroup.
		return false;
	
	// m_vnSelectedPlotsInGroup only take care one case: use mouse left click on grid.
	ASSERT( vuSelRows.GetSize() == 1 );
	int nSelRow = vuSelRows[0];
	
	if( !m_LCTreeHelper.IsDataPlotInGroup( GET_DATAPLOT_INDEX_FROM_SEL_ROW( nSelRow ) ) )
		return false;
	*/	 
	vector<uint> vuIndices;	
	if ( m_vnSelectedPlotsInGroup.GetSize() > 0 && m_vnSelectedPlotsInGroup.Find(vuIndices, m_flx.Row) <= 0 )
	{
		selRowsAndNotSendEvent(m_vnSelectedPlotsInGroup, false);
		m_vnSelectedPlotsInGroup.RemoveAll();
	}
	
		
	int 	nSelRow;
	bool 	bSelectionIncludedGroupedDataPlot = false;
	for(int index = 0; index < vuSelRows.GetSize(); index++)
	{
		nSelRow = vuSelRows[index];
		if( m_LCTreeHelper.IsDataPlotInGroup( GET_DATAPLOT_INDEX_FROM_SEL_ROW( nSelRow ) ) )
		{
			bSelectionIncludedGroupedDataPlot = true;
			break;
		}
	}
	if( !bSelectionIncludedGroupedDataPlot )
		return true;

	// if the selection included grouped data plots
	vector<int> vnDPIndex;
	int nSelGroup = 0;
	bool bRet = m_LCTreeHelper.GetAllDataPlotIndicesInGroup( GET_DATAPLOT_INDEX_FROM_SEL_ROW( nSelRow ), vnDPIndex, nSelGroup );
	ASSERT( bRet );
	if( !bRet )
		return false;	
	ASSERT( vnDPIndex.GetSize() > 1 );
	
	m_vnSelectedPlotsInGroup = vnDPIndex + GetRowOffset();
	
	// if cell selection not in grouped area, then set into.
	if( m_vnSelectedPlotsInGroup.Find(vuIndices, m_flx.Row) <= 0 ) 
		m_flx.Row = m_vnSelectedPlotsInGroup[ m_vnSelectedPlotsInGroup.GetSize() - 1 ];
	
	CancelSelRows(vuSelRows); // cancel the original highlight status
	selRowsAndNotSendEvent( m_vnSelectedPlotsInGroup ); // select this group
	return true;
}

///Jasmine 12/23/10 ORG-1826-S3 HIDE_ROW_HEADER_TO_SAVE_SPACE
void LayerPlotList::onToggleRowColHeader(bool bShowMenu, int nx/* = 0*/, int ny/* = 0*/)
{	
	if(bShowMenu)
	{
		bool bHideFixCol = (GetColWidth(PlotsCtrl_FixCol) <= 0);
		
		Menu myMenu;
		myMenu.Add(STR_HIDE_FIX_COL, MENU_HIDE_FIX_COL_ID, bHideFixCol? MF_CHECKED : MF_UNCHECKED);
		
		int nSelCmd;
		myMenu.TrackPopupMenu( 0, nx, ny, GetDlgSafeHwnd(), &nSelCmd );
		
		if(nSelCmd != MENU_HIDE_FIX_COL_ID)
			return;
	}
	
	/// Iris 01/07/2011 FIXED_COL_WIDTH_TOO_SMALL_TO_SHOW_GROUP_INDEX
	//int nFiColWidth = (GetColWidth(PlotsCtrl_FixCol) <= 0)? 300 : 0;
	int nFiColWidth = (GetColWidth(PlotsCtrl_FixCol) <= 0)? NUM_FIXED_COL_WIDTH : 0;
	///End FIXED_COL_WIDTH_TOO_SMALL_TO_SHOW_GROUP_INDEX
	SetColWidth(PlotsCtrl_FixCol, nFiColWidth);
}
///End HIDE_ROW_HEADER_TO_SAVE_SPACE
///Jasmine 12/29/10 ORG-1826-S1-3 COL_AUTO_WIDTH
void 	LayerPlotList::autoColWidth()
{
	bool bHideFixCol = (GetColWidth(PlotsCtrl_FixCol) <= 0);
	ResizeCols();
	/// Iris 01/07/2011 FIXED_COL_WIDTH_TOO_SMALL_TO_SHOW_GROUP_INDEX
	//SetColWidth(PlotsCtrl_FixCol, bHideFixCol?0 : 300);
	SetColWidth(PlotsCtrl_FixCol, bHideFixCol?0 : NUM_FIXED_COL_WIDTH);
	///End FIXED_COL_WIDTH_TOO_SMALL_TO_SHOW_GROUP_INDEX
}
///End COL_AUTO_WIDTH
void 	LayerPlotList::OnBeforeMouseDown( short nButton, short nShift, float X, float Y, bool* pCancel )
///Sophy 2/7/2012 ORG-4478-P6 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
{
}
void	LayerPlotList::OnContextMenu(int nx, int ny)
///end CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
{
	int nRow, nCol;
	GetMouseCell(nRow, nCol);
	
	///Jasmine 12/23/10 ORG-1826-S3 HIDE_ROW_HEADER_TO_SAVE_SPACE
	//if( nRow < 0 || nRow > GetRows() || nCol < 0 || nCol > GetCols() )
		//return;
	///Sophy 2/7/2012 ORG-4478-P6 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	//int nx = XTwipsToPixels(X);
	//int ny = YTwipsToPixels(Y);
	//ClientToScreen(nx, ny);
	//if( nRow < 0 || nRow > GetRows() || nCol < 0 || nCol > GetCols() )
	//{
		//if(nRow < 0 && nCol < 0 && MK_RBUTTON == nButton)
			//onToggleRowColHeader(true, nx, ny);
		//return;
	//}
	if ( nRow < 0 || nRow > GetRows() || nCol < 0 || nCol > GetCols() )
	{
		if ( nRow < 0 && nCol < 0 )
			onToggleRowColHeader(true, nx, ny);
		return;
	}
	///end CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	///End HIDE_ROW_HEADER_TO_SAVE_SPACE
	///Sophy 2/7/2012 ORG-4478-P6 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	//if(MK_RBUTTON == nButton)
	///end CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	{	
		if( nRow == 0 ) // right click header
		{
			PlotsControlHeaderMenu plotCtrlMenu( this );
	
			///Jasmine 12/23/10 ORG-1826-S3 HIDE_ROW_HEADER_TO_SAVE_SPACE
			//plotCtrlMenu.TrackPopupMenu( 0, nx, ny, GetDlgSafeHwnd() );						
			int nSelCmd;
			plotCtrlMenu.TrackPopupMenu( 0, nx, ny, GetDlgSafeHwnd(), &nSelCmd );
	
			UINT nSel;
			if( plotCtrlMenu.GetSel( nSel ) )
			{
				int nColIndex = nSel + GetColOffset();
				bool bHidden = IsColHidden(nColIndex);
				SetIsColHidden(nColIndex, !bHidden);
				///Jasmine 12/29/10 ORG-1826-S1-3 HIDE_SHOW_SAME_NAME_COL
				DWORD wParam = bHidden? 0 : HIDE_COL;
				PostDlgMessage(WM_USER_MSG_ON_HIDE_COL, wParam, nColIndex);
				///End HIDE_SHOW_SAME_NAME_COL
			}
			else if(nSelCmd == MENU_HIDE_FIX_COL_ID)
			{
				onToggleRowColHeader(false);
			}
			///End HIDE_ROW_HEADER_TO_SAVE_SPACE
			///Jasmine 12/29/10 ORG-1826-S1-3 COL_AUTO_WIDTH
			else if(nSelCmd == MENU_AUTO_SIZE_COL_ID)
			{
				autoColWidth();
			}
			///End COL_AUTO_WIDTH
		}
		else if( nRow >= GetRowOffset() && nRow < GetRows() ) // right click in grid
		{
			if( !GetIsSelected(nRow) )
				SelRow(nRow) ;//SetIsSelected(nRow, true);	//unsel other rows
			
			PlotsGridMoveToMenu moveToMenu(this);
			///Jasmine 12/23/10 ORG-1826-S6 BATCH_CHANGE_PLOT_TYPE	
			PlotsGridPlotTypeMenu subMenuPlotType(this);
			PlotsGridMenu gridMenu(this, moveToMenu, subMenuPlotType);
			///End BATCH_CHANGE_PLOT_TYPE
			
			int nSelCmd;
			gridMenu.TrackPopupMenu( 0, nx, ny, GetDlgSafeHwnd(), &nSelCmd );
			
			///Jasmine 12/23/10 ORG-1826-S6 BATCH_CHANGE_PLOT_TYPE	
			uint nPlotType;
			if(subMenuPlotType.GetSel(nPlotType, nSelCmd) )
			{
				onChangePlotType(nPlotType);
				return;
			}
			///End BATCH_CHANGE_PLOT_TYPE
			
			bool bRet;
			uint nChoice;
			if (moveToMenu.GetSel(nChoice, nSelCmd) )
			{
				if( nChoice >= MOVETO_SUBMENU_GROUP_BEGIN && nChoice < MOVETO_SUBMENU_GROUP_END )
				{
					int nGroupIndex = nChoice - MOVETO_SUBMENU_GROUP_BEGIN + 1; // group index is 1 offset
					bRet = MoveDataPlotIntoGroup(nGroupIndex);
					ASSERT(bRet);
				}
				else
				{
					switch(nChoice)
					{
					case MOVETO_SUBMENU_TOP:
						/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
						//bRet = MoveDataPlot(nRow, GetRowOffset());
						bRet = MoveDataPlots(true, true);
						///End TO_MOVE_WHOLE_GROUP
						break;
					case MOVETO_SUBMENU_BOTTOM:
						/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
						//bRet = MoveDataPlot(nRow, GetRows()-1);
						bRet = MoveDataPlots(false, true);
						///End TO_MOVE_WHOLE_GROUP
						break;
					case MOVETO_SUBMENU_NEXT:
						/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
						//bRet = MoveDataPlot(nRow, nRow+1);
						bRet = MoveDataPlots(false);
						///End TO_MOVE_WHOLE_GROUP
						break;
					case MOVETO_SUBMENU_PREVIOUS:
						/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
						//bRet = MoveDataPlot(nRow, nRow-1);
						bRet = MoveDataPlots(true);
						///End TO_MOVE_WHOLE_GROUP
						break;
					default:
						ASSERT(false);
						break;				
					}
				}
			}
			///Jasmine 12/29/10 ORG-1826-S1-3 COL_AUTO_WIDTH			
			if(MENU_AUTO_SIZE_COL_ID == nSelCmd)
				autoColWidth();
			///End COL_AUTO_WIDTH
			if( bRet )
			{
				PostDlgMessage(WM_USER_MSG_ON_DATAPLOT_CHANGED);
			}
				
		}
	}
	/*
	else if( MK_LBUTTON == nButton )
	{
		//---Iris 01/05/2011 to fix can not drap mouse left button to move row, if click fixed col, no need enter the following function to check editable.
		if( nCol < GetColOffset() )
			return;
		//---
		///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS		
		if( nRow < GetRowOffset() )
			return;
		///End SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
		*pCancel = !canCellEditable( nRow, nCol );	
	}	
	*/
}

/// Iris 1/11/2010 USE_MOUSEUP_EVENT_REPLACE_SELCHANGE_EVENT_TO_CHECK_GROUPED_DATAPLOT_SELECTION
void LayerPlotList::OnSelChange()
{	
	CheckSelectAllPlotsInGroup();
}

void LayerPlotList::OnMouseUp(short nButton, short nShift, float X, float Y)
{
	CheckSelectAllPlotsInGroup();
}
///End USE_MOUSEUP_EVENT_REPLACE_SELCHANGE_EVENT_TO_CHECK_GROUPED_DATAPLOT_SELECTION

///Jasmine 01/12/11 ORG-1997-S2 SHOW_CURRENT_PLOT_TYPE
string LayerPlotList::GetCurDatasetName()	
{
	vector<uint> vuSelRows;
	if( !GetSelRowsEx(vuSelRows) || vuSelRows.GetSize() <= 0 )
		return "";
	
	return GetCell(vuSelRows[0], GetColPos(PlotsCtrl_DSName))
}
///End SHOW_CURRENT_PLOT_TYPE

///Jasmine 12/23/10 ORG-1826-S6 BATCH_CHANGE_PLOT_TYPE	
int LayerPlotList::GetPlotTypeList(vector<string>& vsPlotType, int nPlotIndex)
{
	string strPlotTypeList;
	m_LCTreeHelper.GetPlotTypeCellComboStrAndPlotIDs( nPlotIndex, GetLayerBits(), strPlotTypeList, m_vnStoragePlotIDsForPlotTypeCellChange);	
	
	return strPlotTypeList.GetTokens( vsPlotType, '|' );
}

void	LayerPlotList::onChangePlotType(int nIndex)
{
	int nSize = m_vnStoragePlotIDsForPlotTypeCellChange.GetSize();
	if(nIndex < 0 || nIndex >= nSize)
		return;
	
	int nNewPlotID = m_vnStoragePlotIDsForPlotTypeCellChange[nIndex];
	
	vector<uint> vuSelRows;
	/// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
	//if( !GetSelRows(vuSelRows) )
	if( !GetSelRowsEx(vuSelRows) )
	///End TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
		return;
	
	vector<uint> vnPlots;
	vnPlots = vuSelRows - 1;
	
	///Jasmine 01/06/11 ORG-1826-S12 ALLOW_CHANGE_SIMILAR_PLOT_TYPE
	int nPlot;
	if( !m_LCTreeHelper.IsSamePlotType(vnPlots, m_vnStoragePlotIDsForPlotTypeCellChange, &nPlot) )
	{
		string strType = GetCell(nPlot+1, GetColPos(PlotsCtrl_PlotType));
		string strError;
		strError.Format(_L("Can not change the selected plots' type. Plot type %s is not compatible."), strType); 

		
		MessageBox(GetWindow(), strError, ERROR_TITLE);
		return;
	}
	///End ALLOW_CHANGE_SIMILAR_PLOT_TYPE
	nSize = vnPlots.GetSize();
	for(int ii = 0; ii < nSize; ii++)
	{
		if( m_LCTreeHelper.OnPlotTypeChange( vnPlots[ii], nNewPlotID ) )
			updateSelRowContent( vuSelRows[ii] );
	}
}
///End BATCH_CHANGE_PLOT_TYPE

void 	LayerPlotList::SetIsRescale(bool bRescale)
{
	m_bRescale = bRescale;	
}

bool 	LayerPlotList::ApplyDataPlotsToLayer()
{
	Tree trLayerContents;
	m_LCTreeHelper.GetLayerContentsTree( trLayerContents, true );

	TreeNode trLayer = trLayerContents.FirstNode;
	ASSERT( trLayer.IsValid() );
	
	trLayer.Rescale.nVal = m_bRescale;
	/// Kenny 1/6/2011 ORG-1879 LAYER_CONTENT_ADD_BOX_PLOT_SHOULD_USE_TEMPLATE
	//m_GraphLayer.AddPlots( trLayer, ADDPLOTSFROMTREE_EDIT );
	DWORD dwAddPlotsCtrl = ADDPLOTSFROMTREE_EDIT|ADDPLOTSFROMTREE_IMPLICIT_STYLEHOLDERS;
	int nNewPlotNum = m_GraphLayer.AddPlots( trLayer, dwAddPlotsCtrl );
	/// End ORG-1879 LAYER_CONTENT_ADD_BOX_PLOT_SHOULD_USE_TEMPLATE
	
	///-----Kit 10/27/2011 ORG-4241-P1 MAKE_BAR_AND_COL_BAR_CAN_GROUP_IN_LAYER_CONTENT_AND_PLOT_SETUP

	/////-----Kit 01/10/2011 STORGE_DP_TREE_INFO_AFTER_EDIT_TREE_NODE
	//// when apply all the data plot to graph layer, we need to get the new layer contents tree from the
	//// graph layer, because there are something important information have been added after AddPlots() functions called
	//initLayerContentsTreeHelper();
	/////-----End STORGE_DP_TREE_INFO_AFTER_EDIT_TREE_NODE

	/////-----Kit 03/05/2011 ORG-2307-P5 RUNTIME_ERROR_WHEN_REMOVE_A_PLOT_AFTER_APPLY
	//if( 0 == nNewPlotNum 
	//	&& (LC_CHANGE_ADD_PLOT & m_LCTreeHelper.GetLayerContentsChangeBit()) )
	//{
	//	// reset the grid when the new data plot can not add to layer
	//	SetRows(m_LCTreeHelper.GetDataPlotNum());
	//	m_LCTreeHelper.GetLayerContentsTree(trLayerContents);
	//	setContents(trLayerContents.FirstNode);
	//}
	/////-----End RUNTIME_ERROR_WHEN_REMOVE_A_PLOT_AFTER_APPLY

	//m_LCTreeHelper.ClearLayerContentsChangeBits();
	//return true;
	return afterApplyClick();
	///-----End MAKE_BAR_AND_COL_BAR_CAN_GROUP_IN_LAYER_CONTENT_AND_PLOT_SETUP
}

bool LayerPlotList::afterApplyClick()
{
	initLayerContentsTreeHelper();

	///-----Kit 10/27/2011 : will always reset the grid! If the speed is important, we can improve this function.
	SetRows(m_LCTreeHelper.GetDataPlotNum());
	Tree trLayerContents;
	m_LCTreeHelper.GetLayerContentsTree(trLayerContents);
	setContents(trLayerContents.FirstNode);

	m_LCTreeHelper.ClearLayerContentsChangeBits();
	return true;
}

/// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
//bool 	LayerPlotList::RemoveDataPlots( const vector<uint> &vuSelRows )
//{	
/// Iris 12/29/2010 ORG-1826-S7 HIGHLIGHT_ADDED_OR_REMOVED_PLOTS
//bool LayerPlotList::RemoveDataPlots()
bool LayerPlotList::RemoveDataPlots(vector<string>& vsRemovedDatasetNames)
///End HIGHLIGHT_ADDED_OR_REMOVED_PLOTS
{
	vector<uint> vuSelRows;
	GetSelRowsEx(vuSelRows);
///End TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
	
	/// Iris 12/29/2010 ORG-1826-S7 HIGHLIGHT_ADDED_OR_REMOVED_PLOTS
	vsRemovedDatasetNames.RemoveAll();
	for(int index = 0; index < vuSelRows.GetSize(); index++)
	{
		vsRemovedDatasetNames.Add( GetCell(vuSelRows[index], GetColPos(PlotsCtrl_DSName)) )
	}
	///End HIGHLIGHT_ADDED_OR_REMOVED_PLOTS
	
	if( m_LCTreeHelper.RemoveDataPlots( vuSelRows ) )
	{		
		//if( !deleteRows( vuSelRows ) || !updateGroupNumColumn() )
		//	return false;
		if( !deleteRows( vuSelRows ) )
			error_report("Fail to delete rows from plot list in LayerPlotList::RemoveDataPlots");
		if( !updateGroupNumColumn() )
			error_report("Fail to update Plot List Group column in LayerPlotList::RemoveDataPlots");
		
		return m_StyleHolderHelper.SetCurrentStyleHolderIndex( m_LCTreeHelper.GetDataPlotNum() );
	}	
	return false;
}

/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
/*
bool 	LayerPlotList::MoveDataPlot(int nRow, int nNewPos, bool bReorderRows, bool bUpdateGroup)
{	
	int nDataPlotIndex = nRow - GetRowOffset();
	int nNewDataPlotIndex = nNewPos - GetRowOffset();
	bool bRet = m_LCTreeHelper.MoveDataPlot(nDataPlotIndex, nNewDataPlotIndex);
	if( bRet )
	{
		onAfterMoveRows(nRow, nNewPos, bReorderRows, bUpdateGroup);
	}
	return bRet;
}	
*/
int 	LayerPlotList::getMovingNewPos(const vector<uint>& vuSelRows, bool bMoveUp, int* pnNumJump)
{
	int nSelRow = vuSelRows[0];
	int nStep = bMoveUp? -1 : 1;
	int nNumJump = nStep;
	int nNewRow = bMoveUp? nSelRow + nStep : nSelRow + vuSelRows.GetSize() - 1 + nStep;
			
	int nNewRowGroupIndex = getGroupIndex(nNewRow);
	if( nNewRowGroupIndex > 0 )
	{
		int nNewRowNext = nNewRow + nStep;
		while(nNewRowNext < GetRows() && nNewRowNext >= GetRowOffset() )
		{				
			int nNewRowNextGroupIndex = getGroupIndex(nNewRowNext);
			if( nNewRowNextGroupIndex < 0 || nNewRowNextGroupIndex != nNewRowGroupIndex )
				break;
			else
			{
				nNewRow = nNewRowNext;
				nNewRowNext += nStep;
				nNumJump += nStep;
			}
		}
	}
	if( NULL != pnNumJump )
		*pnNumJump = nNumJump;
	return nNewRow;		
}

// when bFirstOrLast is true, if bMoveUp is ture, will move to the top as the first;
// if bMoveUp is false, will move to the bottom as the last.
bool 	LayerPlotList::MoveDataPlots(bool bMoveUp, bool bFirstOrLast, bool bReorderRows)
{
	vector<uint> vuSelRows;
	/// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
	//if( !GetSelRows( vuSelRows ) )
	if( !GetSelRowsEx( vuSelRows ) )
	///End TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
		return false;	
		
	int nMovingSteps, nNewRow;
	if( bFirstOrLast )
	{
		nNewRow = bMoveUp ? GetRowOffset() : GetRows() - 1;
		nMovingSteps = bMoveUp ? 0 - (vuSelRows[0] - GetRowOffset()) : GetRows() - GetRowOffset() - vuSelRows[vuSelRows.GetSize()-1];
	}
	else
	{
		nNewRow = getMovingNewPos(vuSelRows, bMoveUp, &nMovingSteps);
	}
	
	vector<uint> vuDataPlotIndices;
	vuDataPlotIndices = vuSelRows - GetRowOffset();
	int nNewDataPlotIndex = nNewRow - GetRowOffset();
	/// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
	//if( !m_LCTreeHelper.MoveDataPlots(vuDataPlotIndices, nNewDataPlotIndex) )
	bool bGroupMoving;	
	if( !m_LCTreeHelper.MoveDataPlots(vuDataPlotIndices, nNewDataPlotIndex, bGroupMoving) )
	///End TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
		return error_report("Move dataplot tree failed in LayerContentTreeHelper::MoveDataPlots");
	
	vector<uint> vuNewRows;
	vuNewRows = vuSelRows + nMovingSteps;
	
	// reorder rows
	if( bReorderRows )
	{
		if ( bMoveUp )
		{
			for(int nn = 0; nn < vuSelRows.GetSize(); nn++)
			{
				SetRowPosition(vuSelRows[nn], vuNewRows[nn]);
			}
		}
		else
		{
			for(int time = 0; time < vuSelRows.GetSize(); time++)
			{
				SetRowPosition(vuSelRows[0], vuSelRows[0] + vuSelRows.GetSize() - 1 + nMovingSteps);
			}
		}
		
		// set back selection on rows
		m_bAllowSelectChangeEvent = false; /// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_MOVE_DATAPLOT_SPEED
		RemoveSelection();
		SelRowsEx(vuNewRows);
		m_bAllowSelectChangeEvent = true; /// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_MOVE_DATAPLOT_SPEED
	}	
	
	// update group column, move grouped dataplots will change the group index.
	if( bGroupMoving )
	{
		updateGroupNumColumn();
	}	
	return true;
}

bool	LayerPlotList::IsAllowMoveRow(int nRow, int nNewRow)
{	
	string strGroup;
	strGroup = GetCell(nRow, GetColPos(PlotsCtrl_Group));
	if( !strGroup.IsEmpty() )
		return false;
	
	int nAnotherRow = -1;
	if( nNewRow < nRow )
	{
		if( nNewRow - 1 >= GetRowOffset() )
		{
			nAnotherRow = nNewRow - 1;
		}			
	}
	else
	{
		if( nNewRow + 1 < GetRows() )
		{
			nAnotherRow = nNewRow + 1;
		}
	}
	
	if( nAnotherRow != -1 )
	{
		string strGroup1 = GetCell(nNewRow, GetColPos(PlotsCtrl_Group));	
		string strGroup2 = GetCell(nAnotherRow, GetColPos(PlotsCtrl_Group));
		return (strGroup1 != strGroup2 || strGroup1.IsEmpty() && strGroup2.IsEmpty());
	}
	
	return true;
}

bool 	LayerPlotList::MoveDataPlot(int nSelRow, int nNewRow)
{	
	int nDataPlotIndex = nSelRow - GetRowOffset();	
	int nNewDataPlotIndex = nNewRow - GetRowOffset();	
	
	bool bRet = m_LCTreeHelper.MoveDataPlot(nDataPlotIndex, nNewDataPlotIndex);
	if( !bRet )
		return error_report("m_LCTreeHelper.MoveDataPlot returns false");		
	return bRet;	
}	
///End TO_MOVE_WHOLE_GROUP

bool 	LayerPlotList::MoveDataPlotIntoGroup(int nGroupIndex)
{
	vector<uint> vuSelRows;
	if( !GetSelRowsEx(vuSelRows) )
		return false;
	
	for(int index = 0; index < vuSelRows.GetSize(); index++)
	{
		int nRow = vuSelRows[index];
		int nDataPlotIndex = nRow - GetRowOffset();
		int nNewDataPlotIndex;
		if( m_LCTreeHelper.MoveDataPlotIntoGroup(nDataPlotIndex, nGroupIndex, &nNewDataPlotIndex) )		
		{
			int nNewRow = nNewDataPlotIndex + GetRowOffset();
			if( nRow != nNewRow )
			{
				SetRowPosition(nRow, nNewRow);
				SetIsSelected(nRow, false);
			}
			
			if( index == vuSelRows.GetSize() -1 ) // only remain one row is selected since CheckSelectAllPlotsInGroup only take care when one row is selected in group.
			{
				m_flx.Row = -1;
				SetIsSelected(nNewRow, true);
			}
		}
		else
		{
			ASSERT(false);
		}
	}
	
	updateGroupNumColumn();
	return true;	
}

bool 	LayerPlotList::SetDataPlotGroup(bool bGroup)
{	
	vector<uint> vuSelRows;
	/// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
	//if( !GetSelRows(vuSelRows) )
	if( !GetSelRowsEx(vuSelRows) )
	///End TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
		return false;
	
	vector<uint> vnPlotIndices;
	vnPlotIndices = vuSelRows - 1;
	int nGroupResult = m_LCTreeHelper.SetDataPlotGroup(vnPlotIndices, bGroup);
	if( GROUPERR_NOT_SAME_PLOTTYPE == nGroupResult && bGroup )
	{
		//MessageBox(GetWindow(), _L("Can not group the selected plots. Plot type should be same."), _L("Attention"));
		MessageBox(GetWindow(), STR_GROUP_DATAPLOTS_TIPS, _L("Attention"));
		return false;
	}
	
	if( GROUPERR_NO_ERR == nGroupResult )
	{
		/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
		/*
		Tree trContents;
		m_LCTreeHelper.GetLayerContentsTree( trContents );		
		setRowContents( trContents.FirstNode);
		
		SelRowsEx(vuSelRows); // Iris 01/07/2011: cancel grouped selection, change to normal selection	
		*/
		setColContents( PlotsCtrl_Group );
		if( !bGroup )
			SelRowsEx(vuSelRows); // Iris 01/07/2011: cancel grouped selection, change to normal selection
		////End TO_IMPROVE_UNGROUP_SPEED
		
		return true;
	}	
	
	return false;
}

/// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
bool 	LayerPlotList::GetSelRowsEx(vector<uint>& vuSelRows)
{
	if( m_vnSelectedPlotsInGroup.GetSize() > 0 )
	{		
		vuSelRows = m_vnSelectedPlotsInGroup;
		return true;
	}
	else
	{
		return GetSelRows( vuSelRows );
	}	
}
///End TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE

bool 	LayerPlotList::SelRowsEx(const vector<uint>& vuRows)
{
	if( m_vnSelectedPlotsInGroup.GetSize() > 0 )
	{
		selRowsAndNotSendEvent(m_vnSelectedPlotsInGroup, false);
		m_vnSelectedPlotsInGroup.RemoveAll();
	}
	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	//return SelRows(vuRows);
	if( vuRows.GetSize() > 0 )
	{		
		if( m_LCTreeHelper.IsSelDPInSameGroup(vuRows-1) )
		{
			SetIsSelected( vuRows[0], true );			
		}
		else
		{
			for(int index = 0; index < vuRows.GetSize(); index++)
			{
				m_bAllowSelectChangeEvent = (index == vuRows.GetSize() - 1);
				SetIsSelected( vuRows[index], true );
			}			
		}
	}
	return true;
	///End TO_IMPROVE_UNGROUP_SPEED
}

bool 	LayerPlotList::CanMoveUpSelRows(const vector<uint>& vuSelRows)
{
	if( vuSelRows.GetSize() == 0 || GetRows() - GetRowOffset() <= 1 || vuSelRows[0] <= GetRowOffset() )
		return false;
	/// Iris 01/04/2011 ORG-1682-P4 IMPROVE_LAYER_CONTENTS_DLG_GROUP_MSG
	//if( vuSelRows.GetSize() > 1 && !_check_vec_inc((vector)vuSelRows, 1) ) // not support move the discontinuous rows
	if( vuSelRows.GetSize() > 1 && !check_vector_increment((vector)vuSelRows, 1) ) // not support move the discontinuous rows
	///End IMPROVE_LAYER_CONTENTS_DLG_GROUP_MSG
		return false;
	return true;
}

bool 	LayerPlotList::CanMoveDownSelRows(const vector<uint>& vuSelRows)
{
	if( vuSelRows.GetSize() == 0 || GetRows() - GetRowOffset() <= 1 || vuSelRows[vuSelRows.GetSize()-1] == GetRows() - 1 || vuSelRows[0] < GetRowOffset() )
		return false;
	/// Iris 01/04/2011 ORG-1682-P4 IMPROVE_LAYER_CONTENTS_DLG_GROUP_MSG
	//if( vuSelRows.GetSize() > 1 && !_check_vec_inc((vector)vuSelRows, 1) ) // not support move the discontinuous rows
	if( vuSelRows.GetSize() > 1 && !check_vector_increment((vector)vuSelRows, 1) ) // not support move the discontinuous rows
	///End IMPROVE_LAYER_CONTENTS_DLG_GROUP_MSG
		return false;
	return true;
}

bool 	LayerPlotList::CanDoGroupPlots(const vector<uint>& vuSelRows)
{
	vector<uint> vnPlots;
	vnPlots = vuSelRows - 1;
	return m_LCTreeHelper.CanDoGroupPlots(vnPlots);
}

bool	LayerPlotList::CanDoUngroupPlots(const vector<uint>& vuSelRows)
{
	vector<uint> vnPlots;
	vnPlots = vuSelRows - 1;
	return m_LCTreeHelper.CanDoUngroupPlots(vnPlots);
}

bool	LayerPlotList::CanDoRemovePlots(const vector<uint>& vuSelRows)
{
	//return ( GetRows() - GetRowOffset() != 0 && GetSelectedRow() >= GetRowOffset() );		
	return ( GetRows() - GetRowOffset() != 0 && vuSelRows.GetSize() > 0 );	
}
/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
bool	LayerPlotList::setColContents( int nColType, int nBeginDPIndex /* = 0*/, int nEndDPIndex/* = -1*/)
{
	Tree trContents;
	m_LCTreeHelper.GetLayerContentsTree(trContents);
	
	return setContents( trContents.FirstNode, nBeginDPIndex, nEndDPIndex, nColType);
}
///End TO_IMPROVE_UNGROUP_SPEED

/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
//bool 	LayerPlotList::setRowContents( const TreeNode &trLayer, int nBeginDPIndex = 0, int nEndDPIndex = -1)
bool 	LayerPlotList::setContents( const TreeNode &trLayer, int nBeginDPIndex/* = 0*/, int nEndDPIndex/* = -1*/, int nColType/* = -1*/)
///End TO_IMPROVE_UNGROUP_SPEED
{
	if( nEndDPIndex < 0 )
		nEndDPIndex = m_LCTreeHelper.GetDataPlotNum() - 1;
	
	if( nBeginDPIndex > nEndDPIndex )
		return false;

	vector<string> vsRowContents;
	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	//m_LCTreeHelper.GetRowContents( trLayer, nBeginDPIndex, nEndDPIndex, vsRowContents, m_colMap->m_vnColMap );
	m_LCTreeHelper.GetContents( trLayer, nBeginDPIndex, nEndDPIndex, vsRowContents, m_colMap->m_vnColMap, nColType );
	///End TO_IMPROVE_UNGROUP_SPEED
	int nStartRow = GET_ROW_INDEX_BY_DATAPLOT_INDEX( nBeginDPIndex );
	///-----Kit 01/06/2011 ORG-1826-S13 USE_ROW_HEAD_INSTEAD_GROUP_COLUMN_TO_SHOW_GROUP_NUM
	//int nNumCols = GetCols() - GetColOffset();
	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	//int nNumCols = GetCols();
	int nNumCols = nColType < 0 ? GetCols() : 1;
	///End TO_IMPROVE_UNGROUP_SPEED
	///-----
	int nNumRows = nEndDPIndex - nBeginDPIndex + 1;
	
	if( GetRows() - GetRowOffset() != m_LCTreeHelper.GetDataPlotNum() )
		SetRows( m_LCTreeHelper.GetDataPlotNum() );
	
	/// Iris 12/23/2010 ORG-1826-S1.5 SET_BOLD_FONT_ON_PLOTTED_DATASETS
	//return m_flx.SetTableValue( &vsRowContents, nNumRows, nNumCols, nStartRow, m_flx.FixedCols, true );
	///-----Kit 01/06/2011 ORG-1826-S13 USE_ROW_HEAD_INSTEAD_GROUP_COLUMN_TO_SHOW_GROUP_NUM
	//if( m_flx.SetTableValue( &vsRowContents, nNumRows, nNumCols, nStartRow, m_flx.FixedCols, true ) )
	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	//if( m_flx.SetTableValue( &vsRowContents, nNumRows, nNumCols, nStartRow, PlotsCtrl_FixCol, true ) )
	int nStartCol = nColType < 0 ? PlotsCtrl_FixCol : GetColPos(nColType);
	if( m_flx.SetTableValue( &vsRowContents, nNumRows, nNumCols, nStartRow, nStartCol, true ) )
	///End TO_IMPROVE_UNGROUP_SPEED
	///-----
	{
		/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
		//SetBold(-1, -1, true);
		///End TO_IMPROVE_UNGROUP_SPEED
		return true;
	}
	return false;
	///End SET_BOLD_FONT_ON_PLOTTED_DATASETS
}

bool 	LayerPlotList::deleteRows( const vector<uint> &vuSelRows )
{
	if( m_vnSelectedPlotsInGroup.GetSize() > 0 )
	{
		selRowsAndNotSendEvent(m_vnSelectedPlotsInGroup, false);
		m_vnSelectedPlotsInGroup.RemoveAll();
	}
	CancelSelRows( vuSelRows );
	m_flx.Row = -1;

	for( int ii=0; ii<vuSelRows.GetSize(); ii++ )
	{
		DeleteRow( vuSelRows[ii] - ii );
	}
	return true;
}

bool 	LayerPlotList::updateGroupNumColumn()
{
	if( GetNumRows() <= 0 )
		return true;
	
	ASSERT( GetRows() - GetRowOffset() == m_LCTreeHelper.GetDataPlotNum() );
	
	Tree trContents;
	m_LCTreeHelper.GetLayerContentsTree( trContents );
	
	vector<string> vsColValues;	
	for( int ii=GetRowOffset(); ii<GetRows(); ii++ )
	{
		TreeNode trDP = tree_get_node_by_dataid( trContents.FirstNode, ii, false, FIND_2_LEVEL );
		string strGroupInfo = "";
		_get_group_id_attrib_from_dp_tree_node( trDP, strGroupInfo );
		vsColValues.Add( strGroupInfo );
	}
	
	return m_flx.SetTableValue(&vsColValues, vsColValues.GetSize(), 1, m_flx.FixedRows, GetColPos(PlotsCtrl_Group), false);
}

bool 	LayerPlotList::OnCellAfterEdit( int nRow, int nCol )
{
	int nDataPlotIndex = nRow - GetRowOffset();
	
	bool bRet = false;
	switch( GetColType(nCol) )
	{
		case PlotsCtrl_Show:
			{
				bool bShow = atoi(GetCell(nRow, nCol));
				bRet = m_LCTreeHelper.SetDataPlotShow(nDataPlotIndex, bShow);	
			}
			break;
		case PlotsCtrl_PlotType:
			{	
				if( m_flx.ComboIndex < 0 )
					return false;

				int nNewPlotID = m_vnStoragePlotIDsForPlotTypeCellChange[m_flx.ComboIndex];	
				if( m_LCTreeHelper.OnPlotTypeChange( nDataPlotIndex, nNewPlotID ) )
				{
					bRet = updateSelRowContent( nRow );
				}
			}
			break;
		///-----Kit 02/25/2011 ORG-2302-S1 MAKE_LEGEND_CAN_EDIT
		case PlotsCtrl_Legend:
			updateLegendCellAfterEdit(nRow, nCol);
			break;
		///-----End MAKE_LEGEND_CAN_EDIT
		default:
			break;

	}

	return bRet;
}

bool 	LayerPlotList::OnCellBeforeEdit( int nRow, int nCol, BOOL* pCancel )
{
	if( nRow < GetRowOffset() || nCol < GetColOffset() )
		return false;			

	bool bEditable = canCellEditable( nRow, nCol );
	if( bEditable )
	{
		switch( GetColType(nCol) )
		{
		case PlotsCtrl_Range:
			/// Iris 3/15/2011 ORG-2371-S1 NEED_DISABLE_RANGE_EDIT_FOR_MATRIX_PLOT_EXCEPT_CONTOUR
			//SetCellComboList( nRow, GetColPos(PlotsCtrl_Range), "..." );			
			TreeNode trDP = m_LCTreeHelper.GetDataPlotNode(GET_DATAPLOT_INDEX_FROM_SEL_ROW(nRow));
			ASSERT(trDP);
			if( trDP )
			{
				int nPageType;
				_get_page_type_from_dp_tree_node(trDP, nPageType);
				
				int nPlotID;
				_get_plot_id_from_dp_tree_node(trDP, nPlotID);
				
				if( (nPageType != EXIST_MATRIX || nPageType == EXIST_MATRIX && IDM_PLOT_CONTOUR == nPlotID )
				&& !_is_dp_from_virtual_matrix(trDP) )
				{
					SetCellComboList( nRow, GetColPos(PlotsCtrl_Range), "..." );
				}
				else
				{
					bEditable = false;
				}
			}			
			///End NEED_DISABLE_RANGE_EDIT_FOR_MATRIX_PLOT_EXCEPT_CONTOUR
			break;
			
		case PlotsCtrl_PlotType:
			initPlotTypeCellComboBox(nRow, nCol);
			break;

		default:
			break;
		}
	}

	if( pCancel )
		*pCancel = !bEditable;

	return true;
}

///-----Kit 02/25/2011 ORG-2302-S1 MAKE_LEGEND_CAN_EDIT
bool	LayerPlotList::OnCellStartEdit(int nRow, int nCol, BOOL* pCancel)
{
	bool bEditable = canCellEditable(nRow, nCol);

	if( bEditable )
	{
		switch(GetColPos(nCol))
		{
		case PlotsCtrl_Legend:
			initLegendCellBeforeEdit(nRow, nCol);
			break;
		default:
			break;
		}

	}
	if( pCancel )
		*pCancel = !bEditable;
	return true;
}
///-----End MAKE_LEGEND_CAN_EDIT

bool 	LayerPlotList::OnRangeCellBtnClick( int nRow, int nCol )
{
	if( PlotsCtrl_Range == GetColType(nCol) )
	{
		return onOpenRangeEditorDlg( nRow );
	}

	return false;
}

///Jasmine 01/12/11 ORG-1997-S2 SHOW_CURRENT_PLOT_TYPE
int LayerPlotList::GetCurDataPlotType()
{
	vector<uint> vuSelRows;
	GetSelRowsEx(vuSelRows);
	return m_LCTreeHelper.GetDataPlotType( GET_DATAPLOT_INDEX_FROM_SEL_ROW(vuSelRows[0]) );
}
///End SHOW_CURRENT_PLOT_TYPE

///Jasminie 02/14/11 ORG-2100-P8 SHOW_SOURCE_DATA_FOR_TEMP_PLOT
int		LayerPlotList::CheckGetDifferentPageTypes(vector<int>& vnPageTypes)
{
	vector<string> vsPages;
	if( !GetColValues(GetColPos(PlotsCtrl_BookSN), vsPages, GetRowOffset() ) )
		return -1;
	
	int nCount = vsPages.GetSize();
	for(int ii = 0; ii < nCount; ii++)
	{
		Page pg( vsPages[ii] );
		if(pg)
		{
			int nType = pg.GetType();
			vector<uint> vecIndex;
			if(vnPageTypes.Find(vecIndex, nType) > 0)
			{
				vector<int> vnRemove;
				vnRemove = vecIndex;				
				vnPageTypes.RemoveAt(vnRemove);
				if(vnPageTypes.GetSize() <= 0)
					break;
			}
		}
	}
	
	return vnPageTypes.GetSize();
}
int		LayerPlotList::GetCurSourceSheets(vector<string>& vsBookSheets, int nPageType)
{
	vector<string> vsBooks, vsSheets;
	if( !GetColValues(GetColPos(PlotsCtrl_BookSN), vsBooks, GetRowOffset() ) || 
		!GetColValues(GetColPos(PlotsCtrl_Sheet), vsSheets, GetRowOffset() ) )
		return -1;
		
	vsBookSheets.SetSize(0);
	int nCount = vsBooks.GetSize();
	for(int ii = 0; ii < nCount; ii++)
	{
		Page pg( vsBooks[ii] );
		if(pg && pg.GetType() == nPageType)
		{
			string strTemp = make_book_sheet_name(vsBooks[ii], vsSheets[ii]);
			vector<uint> vecIndex;
			if(vsBookSheets.Find(strTemp) < 0)
				vsBookSheets.Add(strTemp);
		}
	}
	
	return vsBookSheets.GetSize();
}
int		LayerPlotList::GetCurSourceBooks(vector<string>& vsBooks, int nPageType)
{
	vsBooks.SetSize(0);
	if( !GetColValues(GetColPos(PlotsCtrl_BookSN), vsBooks, GetRowOffset() ) )
		return -1;
		
	remove_repeat_item(vsBooks);	 
	int nCount = vsBooks.GetSize();
	for(int ii = nCount-1; ii >=0; ii--)
	{
		Page pg( vsBooks[ii] );
		if(!pg || pg.GetType() != nPageType)
		{
			vsBooks.RemoveAt(ii);
		}
	}
	
	return vsBooks.GetSize();
}
///End SHOW_SOURCE_DATA_FOR_TEMP_PLOT

///-----Kit 03/01/2011 ORG-2319-P1 RUNTIME_ERROR_WHEN_GET_BOOK_SHEET_COL_TOOLTIP
bool	LayerPlotList::GetDataPlotDescription(int nDPID, string &strDescription)
{
	TreeNode trDP = m_LCTreeHelper.GetDataPlotNode(nDPID);
	if( !trDP.IsValid() )
		return false;

	if( _is_dp_from_virtual_matrix(trDP) )
	{
		QueryResult qr;
		qr.Build(SQL_STR_SEL_VM_FROM_PROJECT);
		vector<string> vsVMDescription;
		qr.GetNames(vsVMDescription, QUERYRESULTNAME_RANGE);
		vector<string> vsVMDSName;
		qr.GetColInfo(vsVMDSName, QUERYRESULTCOL_DATANAME);

		string strCurRowDSName = GetCell(flexcpText, GET_ROW_INDEX_BY_DATAPLOT_INDEX(nDPID), GetColPos(PlotsCtrl_DSName));
		ASSERT(!strCurRowDSName.IsEmpty());
		int nIndex = vsVMDSName.Find(strCurRowDSName, 0, true);
		if( nIndex < 0 )
		{
			ASSERT(false);
			return false;
		}

		strDescription = vsVMDescription[nIndex];
	}
	else
	{
		DataPlotTreeNodeHelper dpHelper(trDP);
		dpHelper.GetDPDescription(strDescription);
	}

	return true;
}
///-----End RUNTIME_ERROR_WHEN_GET_BOOK_SHEET_COL_TOOLTIP

bool 	LayerPlotList::initPlotTypeCellComboBox( int nRow, int nCol )
{
	int nDPIndex = GET_DATAPLOT_INDEX_FROM_SEL_ROW( nRow );
	string strPlotTypeList;
	m_LCTreeHelper.GetPlotTypeCellComboStrAndPlotIDs( nDPIndex, GetLayerBits(), strPlotTypeList, m_vnStoragePlotIDsForPlotTypeCellChange );	
	
	SetCellComboList( nRow, nCol, strPlotTypeList );	
	return true;
}

///-----Kit 02/25/2011 ORG-2302-S1 MAKE_LEGEND_CAN_EDIT
bool	LayerPlotList::initLegendCellBeforeEdit(int nRow, int nCol)
{
	int nDPIndex = GET_DATAPLOT_INDEX_FROM_SEL_ROW(nRow);
	string strEidtContent = "";
	strEidtContent.Format("%%(%d)", nDPIndex + 1);
	SetCell(strEidtContent, flexcpText, nRow, GetColType(PlotsCtrl_Legend));	
	return true;
}

bool	LayerPlotList::updateLegendCellAfterEdit(int nRow, int nCol)
{
	string strCellContent = GetCell(flexcpText, nRow, GetColPos(nCol));
	okutil_arg_copy(strCellContent);

	TreeNode trDPNode = m_LCTreeHelper.GetDataPlotNode(GET_DATAPLOT_INDEX_FROM_SEL_ROW(nRow));
	DataPlotTreeNodeHelper dpnHelper(trDPNode);

	string strLegendOld = "";
	dpnHelper.GetLegend(strLegendOld);
	
	if( strLegendOld.CompareNoCase(strCellContent) != 0 )
	{
		SetCell(strCellContent, flexcpText, nRow, GetColPos(nCol));
		dpnHelper.SetLegend(strCellContent);
		m_LCTreeHelper.SetLayerContentsChangeBit(LC_CHANGE_LEGEND);
		PostDlgMessage(WM_USER_MSG_ON_DATAPLOT_CHANGED);
		return true;
	}

	return false;
}
///-----End MAKE_LEGEND_CAN_EDIT

bool 	LayerPlotList::onOpenRangeEditorDlg( int nSelRow )
{
	RangeEditorDlgInfo dlgInfo;
	int nDPIndex = GET_DATAPLOT_INDEX_FROM_SEL_ROW( nSelRow );
	if( !m_LCTreeHelper.GetRowRangeInfo( nDPIndex, dlgInfo ) )
		return false;

	if( !_open_RangeEditorDlg( dlgInfo ) )
		return false;
	
	if( !m_LCTreeHelper.SetRowRangeInfo( nDPIndex, dlgInfo ) )
		return false;
	
	return updateSelRowContent( nSelRow );
}

bool 	LayerPlotList::updateSelRowContent( int nSelRow )
{
	Tree trContent;
	m_LCTreeHelper.GetLayerContentsTree( trContent );
	int nBeginDPIndex = GET_DATAPLOT_INDEX_FROM_SEL_ROW( nSelRow );

	int nEndDPIndex;
	if( m_LCTreeHelper.IsDataPlotInGroup( GET_DATAPLOT_INDEX_FROM_SEL_ROW( nSelRow ) ) )
	{
		vector<int> vnDPIndex;
		int nSelGroup = 0;
		m_LCTreeHelper.GetAllDataPlotIndicesInGroup( GET_DATAPLOT_INDEX_FROM_SEL_ROW( nSelRow ), vnDPIndex, nSelGroup );
		/// Iris 12/27/2010 TO_FIX_CHANGE_PLOTTYPE_IN_GROUP_FAILED
		//nEndDPIndex = nBeginDPIndex + vnDPIndex.GetSize();
		nBeginDPIndex = vnDPIndex[0];
		nEndDPIndex = nBeginDPIndex + vnDPIndex.GetSize() - 1;
		///End TO_FIX_CHANGE_PLOTTYPE_IN_GROUP_FAILED
	}
	else
	{
		nEndDPIndex = GET_DATAPLOT_INDEX_FROM_SEL_ROW( nSelRow );
	}
	
	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	//return setRowContents( trContent.FirstNode, nBeginDPIndex, nEndDPIndex );
	return setContents( trContent.FirstNode, nBeginDPIndex, nEndDPIndex );
	///End TO_IMPROVE_UNGROUP_SPEED
}

int		LayerPlotList::getGroupIndex(int nSelRow)
{
	string strGroup = GetCell(nSelRow, GetColPos(PlotsCtrl_Group));
	if( !strGroup.IsEmpty() )
	{
		char szBuffer[MAXLINE];
		int nGroupIndex = string_to_prefix_end_number(szBuffer, strGroup);	
		return nGroupIndex;
	}
	return 0;
}

/// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
//bool LayerPlotList::selRowsAndNotSendEvent( const vector<uint> &vnSelRows )
bool LayerPlotList::selRowsAndNotSendEvent( const vector<uint> &vnSelRows, bool bSel )
///End TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
{
	for( int ii = 0; ii < vnSelRows.GetSize(); ++ii )
	{
		/// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
		//SetRowAlwaySelected( vnSelRows[ii], true );		
		SetRowAlwaySelected( vnSelRows[ii], bSel );		
		///End TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
	}

	return true;
}

bool LayerPlotList::canCellEditable( int nRow, int nCol )
{
	if( nRow < GetRowOffset() || nCol < GetColOffset() )
	{
		return false;
	}
	
	vector<uint> 	vuIndices;
	int				nColType = GetColType(nCol);
	if( nColType == PlotsCtrl_Range || nColType == PlotsCtrl_Show 
		) //|| nColType == PlotsCtrl_Legend )	///-----Kit 02/25/2011 ORG-2302-S1 MAKE_LEGEND_CAN_EDIT	now Legend can not edit!!!!!! do remove this comment
	{
		return true;
	}
	else if( nColType == PlotsCtrl_PlotType )
	{
		if( m_vnSelectedPlotsInGroup.GetSize() == 0 )
			return true;
		
		if( m_vnSelectedPlotsInGroup.Find(vuIndices, nRow) )
		{
			int nFirstRowInSelRows = m_vnSelectedPlotsInGroup[0];
			if( nRow == nFirstRowInSelRows ) 
				return true;			
		}
	}
	
	return false;
}

bool LayerPlotList::GetCurrentStyleHolderPlotID( int &nStyleHolderPlotID )
{
	return m_StyleHolderHelper.GetCurrentStyleHolderPlotID( nStyleHolderPlotID );
}

/// Iris 12/27/2010 ORG-1826-S1.5 SET_BOLD_FONT_ON_PLOTTED_DATASETS
/// Iris 01/07/2011 ORG-1646-P1 SETBOLD_CAUSE_SLOW_SPEED_MORE
/*
bool	LayerPlotList::UpdateBlodStatusByDatasetNames(const vector<string>& vsDatasetNames)
{
	vector<string> vsPlottedDatasetNames;
	if( !GetColValues(PlotsCtrl_DSName, vsPlottedDatasetNames, GetRowOffset() ) )
		return false; // no row
	
	SetBold(-1, -1, false);	
	if( vsDatasetNames.GetSize() > 0 )			
	{
		for(int nn = 0; nn < vsPlottedDatasetNames.GetSize(); nn++)
		{
			if( vsDatasetNames.Find( vsPlottedDatasetNames[nn] ) >= 0 ) 
				SetBold(nn + GetRowOffset(), -1, true);
		}
	}	
*/
bool	LayerPlotList::UpdateBlodStatusByDatasetNames(GridListControl* pDatasetList)
{
	vector<string> vsPlottedDatasetNames;
	if( !GetColValues(GetColPos(PlotsCtrl_DSName), vsPlottedDatasetNames, GetRowOffset() ) )
		return false; // no row
	
	if( NULL == pDatasetList || pDatasetList->GetNumRows() == 0 )
		return false;
	
	for(int index = 0; index < vsPlottedDatasetNames.GetSize(); index++)
	{
		bool bFound = pDatasetList->FindRow( vsPlottedDatasetNames[index], COL_DSNAME ) >= pDatasetList->GetRowOffset();
		int nRowInPlotList = index + GetRowOffset();
		SetBold(nRowInPlotList, -1, bFound);
	}
	return true;
}
///End SETBOLD_CAUSE_SLOW_SPEED_MORE
///End SET_BOLD_FONT_ON_PLOTTED_DATASETS

void	LayerPlotList::OnLayerPropertiesDlgClose()
{
	Tree trLC;
	m_GraphLayer.GetLayerContents(trLC, GETLC_BITS);
	ASSERT( trLC.IsValid() );
	
	LayerContentTreeHelper lcHeller;
	lcHeller.Init(GetLayerBits()); /// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
	///-----Kit 01/12/2011 CLEAN_UP_LAYER_CONTENTS_CODE
	//lcHeller.ResetGroupIDAndDataPlotID( trLC.FirstNode );	
	///-----
	lcHeller.SetLayerContentsTree( trLC );
	
	int nNumPlots;
	ASSERT( (nNumPlots = lcHeller.GetDataPlotNum()) == m_LCTreeHelper.GetDataPlotNum() );
	
	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	//bool bChanged = false;
	bool bShowChanged = false, bPlotTypeChanged = false;
	///End TO_IMPROVE_UNGROUP_SPEED
	for( int nPlot = 0; nPlot < nNumPlots; nPlot++ )
	{
		TreeNode trDP1 = lcHeller.GetDataPlotNode(nPlot);
		TreeNode trDP2 = m_LCTreeHelper.GetDataPlotNode(nPlot);
		int nRow = nPlot + GetRowOffset();
		
		ASSERT( trDP1.ShowInfo );
		ASSERT( trDP2.ShowInfo );
		if( trDP1.ShowInfo.nVal != trDP2.ShowInfo.nVal )
		{
			bool bShow = trDP1.ShowInfo.nVal;
			m_LCTreeHelper.SetDataPlotShow(nPlot, bShow);
			/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
			//SetCell(nRow, PlotsCtrl_Show, bShow); 
			//bChanged = true;
			bShowChanged = true;
			///End TO_IMPROVE_UNGROUP_SPEED
		}
		
		ASSERT( trDP1.PlotDesigs.Type );
		ASSERT( trDP2.PlotDesigs.Type );
		if( trDP1.PlotDesigs.Type.nVal != trDP2.PlotDesigs.Type.nVal )
		{
			if( m_LCTreeHelper.OnPlotTypeChange( nPlot, trDP1.PlotDesigs.Type.nVal ) )
			{
				/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
				/*
				updateSelRowContent( nRow ); 
				bChanged = true;
				*/
				bPlotTypeChanged = true;
				///End TO_IMPROVE_UNGROUP_SPEED
			}
		}
	}
	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	if( bShowChanged )
		setColContents( PlotsCtrl_Show );
	if( bPlotTypeChanged )
		setColContents( PlotsCtrl_PlotType );
	///End TO_IMPROVE_UNGROUP_SPEED
	
	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	//if( bChanged )
	if( bShowChanged || bPlotTypeChanged )
	///End TO_IMPROVE_UNGROUP_SPEED
		m_LCTreeHelper.ClearLayerContentsChangeBits();
}

///-----Kit 01/10/2011 STORGE_DP_TREE_INFO_AFTER_EDIT_TREE_NODE
bool LayerPlotList::initLayerContentsTreeHelper()
{
	Tree trContents;
	m_GraphLayer.GetLayerContents( trContents, GETLC_BITS );
	ASSERT( trContents.IsValid() );
	
	m_LCTreeHelper.SetLayerContentsTree( trContents );	
	
	return true;	
}
///-----End STORGE_DP_TREE_INFO_AFTER_EDIT_TREE_NODE


/************************************************************************/
/* ---LayerContentTreeHelper                                            */
/************************************************************************/
LayerContentTreeHelper::LayerContentTreeHelper()
{
	m_nGroupNum = 0;
	m_nDataPlotNum = 0;
}

/// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
void LayerContentTreeHelper::Init(DWORD dwLayerBits)
{
	m_dwLayerBits = dwLayerBits;
}
///End IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS

TreeNode LayerContentTreeHelper::getGroupNode(TreeNode& trLayer, int nGroupIndex)
{
	ASSERT(trLayer);
	
	TreeNodeCollection trColl(trLayer, STR_GROUP_NAME);
	
	TreeNode trGroup;
	if( trColl.Count() > 0 && nGroupIndex < trColl.Count() )
		trGroup = trColl.Item(nGroupIndex);
	return trGroup;
}

TreeNode LayerContentTreeHelper::checkGetGroupNode( TreeNode& trLayer, int nGroupIndex )
{
	ASSERT(trLayer);
	
	TreeNode trGroup = getGroupNode(trLayer, nGroupIndex);
	if( !trGroup )
		trGroup = trLayer.AddNode(STR_GROUP_NAME);
	
	ASSERT(trGroup);
	return trGroup;
}

// apply dataplot moving 
void LayerContentTreeHelper::applyMoving()
{	
	TreeNode trContentsClone = m_trContents.Clone();
	TreeNode trLayer = trContentsClone.FirstNode;
	foreach(TreeNode trN in trLayer.Children)
	{
		if( check_tree_node_tagName_is_DataPlot(trN) || 0 == trN.tagName.CompareNoCase(STR_GROUP_NAME) )
		{
			trN.Remove();
		}			
	}
	
	// Copy dataplot node from m_trContents to temp tree
	for(int nPlot = 0; nPlot < m_nDataPlotNum; nPlot++)
	{
		bool bIsGrouped;
		int nGroupIndex;
		TreeNode trDataPlot = GetDataPlotNode(nPlot, &bIsGrouped, &nGroupIndex);
		ASSERT(trDataPlot);
		
		TreeNode trParent = trLayer;
		if( bIsGrouped )
		{
			trParent = checkGetGroupNode(trLayer, nGroupIndex - 1);				
		}		
		TreeNode trNew = trParent.AddNode(STR_DATAPLOT_NAME + (string)(nPlot+1));
		trNew.Replace(trDataPlot, true, true, false);			
	}
	
	m_trContents = trContentsClone;	
}

bool	LayerContentTreeHelper::GetLayerContentsTree( Tree &trContents, bool bApplyChanges )
{
	if( bApplyChanges)
	{
		if( m_dwChangeBits & LC_CHANGE_MOVED )
			applyMoving();
	}
	
	trContents = m_trContents;
	return true;
}

void LayerContentTreeHelper::SetLayerContentsChangeBit(DWORD dwBit)
{
	m_dwChangeBits |= dwBit;
}

///-----Kit 03/05/2011 ORG-2307-P5 RUNTIME_ERROR_WHEN_REMOVE_A_PLOT_AFTER_APPLY
DWORD LayerContentTreeHelper::GetLayerContentsChangeBit()
{
	return m_dwChangeBits;
}
///-----End RUNTIME_ERROR_WHEN_REMOVE_A_PLOT_AFTER_APPLY

bool LayerContentTreeHelper::IsLayerContentsChanged()
{
	return (m_dwChangeBits != 0);
}

void LayerContentTreeHelper::ClearLayerContentsChangeBits()
{
	m_dwChangeBits = 0;
}

bool LayerContentTreeHelper::SetLayerContentsTree( const Tree &trContents )
{
	m_trContents = trContents;
	ResetGroupIDAndDataPlotID();	///-----Kit 01/12/2011 CLEAN_UP_LAYER_CONTENTS_CODE
	return true;
}

bool LayerContentTreeHelper::AddDataPlots( TreeNode &trNewLayer )
{
	foreach( TreeNode trNode in trNewLayer.Children )
	{
		if( check_tree_node_tagName_is_DataPlot( trNode ) 
			|| trNode.tagName.CompareNoCase( STR_GROUP_NAME ) == 0 )
		{
			m_trContents.FirstNode.AddNode( trNode, true );
		}
	}

	m_dwChangeBits |= LC_CHANGE_ADD_PLOT;
	return true;
}

///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
/************************************************************************/
/* ---GeneratePlotInfoHelper	                                        */
/************************************************************************/
GeneratePlotInfoHelper::GeneratePlotInfoHelper()
{
}

bool GeneratePlotInfoHelper::addLegend(vector<string> &vsRowContents )
{
	string strLegend;
	if( !m_DPHelper.GetLegend(strLegend) )
	{
		///-----Kit 05/23/2011 ORG-2932-P1 NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
		//return false;
		strLegend = "";
		///-----End NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
	}
		
	vsRowContents.Add(strLegend);
	return true;
}

bool GeneratePlotInfoHelper::addRowRange(vector<string> &vsRowContents )
{
	string strRowRange;
	if( !m_DPHelper.GetRowRange(strRowRange) )
	{
		///-----Kit 05/23/2011 ORG-2932-P1 NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
		//return false;
		strRowRange = "";
		///-----End NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
	}

	vsRowContents.Add(strRowRange);
	return true;
}

bool GeneratePlotInfoHelper::addPlotTypeName(vector<string> &vsRowContents )
{
	string strPlotTypeName;
	if( !m_DPHelper.GetPlotTypeName(strPlotTypeName) )
	{
		///-----Kit 05/23/2011 ORG-2932-P1 NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
		//return false;
		ASSERT(false);	// should not failed!!!
		strPlotTypeName = "";
		///-----End NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
	}

	vsRowContents.Add(strPlotTypeName);
	return true;
}

bool GeneratePlotInfoHelper::addShowInfo(vector<string> &vsRowContents )
{
	bool bShow = false;
	if( !m_DPHelper.GetShowInfo(bShow) )
	{
		///-----Kit 05/23/2011 ORG-2932-P1 NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
		//return false;
		ASSERT(false);	// should not be failed!
		///-----End NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
	}

	vsRowContents.Add(bShow ? "1" : "0");
	return true;
}

bool GeneratePlotInfoHelper::addGroupInfo(vector<string> &vsRowContents )
{
	string strGroupInfo = "";
	TreeNode trDP;
	if( !m_DPHelper.GetDataPlotTreeNode(trDP) )
	{
		ASSERT(false);	// should not be empty!
		return error_report("m_DPHelper.GetDataPlotTreeNode(trDP) failed!!");
	}

	_get_group_id_attrib_from_dp_tree_node(trDP, strGroupInfo);
	vsRowContents.Add( strGroupInfo );

	return true;
}

/// Iris 12/23/2010 ORG-1826-S2 SHOW_DATASET_NAME_IN_BOTH_SIDES_GRID
bool GeneratePlotInfoHelper::addDatasetName(vector<string> &vsDSNames )
{
	string strDSName;
	if( !m_DPHelper.GetDatasetName(strDSName) )
	{
		///-----Kit 05/23/2011 ORG-2932-P1 NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
		//return false;
		_DBSTR("No dataset name in current data plot!!!!!!!");
		ASSERT(false);	// should not be empty!
		strDSName = "";
		///-----End NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
	}

	vsDSNames.Add(strDSName);
	return true;
}
///End SHOW_DATASET_NAME_IN_BOTH_SIDES_GRID

///Jasmine 12/22/10 ORG-1826-S1-3 PLOT_LIST_DEFAULT_SHOW_SNAME_LNAME_ETC
bool GeneratePlotInfoHelper::addColName(vector<string> &vsColNames)
{
	string strColName;
	if( !m_DPHelper.GetColNameWithDesig(strColName) )
	{
		///-----Kit 05/23/2011 ORG-2932-P1 NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
		//return false;
		_DBSTR("No column name in current data plot!!!!");
		ASSERT(false);	// should not be empty!
		strColName = "";
		///-----End NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
	}
	
	vsColNames.Add(strColName);
	return true;
}

bool GeneratePlotInfoHelper::addColLongName(vector<string> &vsColLNames)
{
	string strColLonaName;
	if( !m_DPHelper.GetColLongName(strColLonaName))
	{
		///-----Kit 05/23/2011 ORG-2932-P1 NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
		//return false;
		_DBSTR("No column long name in current data plot");
		strColLonaName = "";
		///-----End NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
	}
	
	vsColLNames.Add(strColLonaName);
	return true;
}
///End PLOT_LIST_DEFAULT_SHOW_SNAME_LNAME_ETC

///------ Tony 07/04/2012 ORG-2893-S1 ADD_BOOK_NAMING_COLUMN
bool GeneratePlotInfoHelper::addBookName(vector<string> &vsNames)
{
	string strPageNAME;
	if( !m_DPHelper.GetPageLongName(strPageNAME) || strPageNAME.IsEmpty() )
	{
		_DBSTR("No book long name in current data plot");
		if( !m_DPHelper.GetPageShortName(strPageNAME) )
			{
				_DBSTR("Not page short name in current data plot!");
				strPageNAME.Empty();
			}
	}
	
	vsNames.Add(strPageNAME);
	return true;
}
///------ End ADD_BOOK_NAMING_COLUMN

///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
bool GeneratePlotInfoHelper::addBookLNName(vector<string> &vsNames)
{
	string strPageLN;
	if( !m_DPHelper.GetPageLongName(strPageLN) )
	{
		///-----Kit 05/23/2011 ORG-2932-P1 NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
		//return error_report("dpHelper.GetPageLongName(strPageLN)!");
		_DBSTR("No book long name in current data plot");
		strPageLN = "";
		///-----End NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
	}

	///-----Kit 05/04/2011 ORG-2614-S1 KEEP_CONSISTENT_IN_BOOK_LN_CELL
	///-----Kit 05/17/2011 ORG-2614-P2 NOT_SHOW_SN_IN_LN_COL_WHEN_LN_IS_EMPTY
	/*
	if( strPageLN.IsEmpty() && !m_DPHelper.GetPageShortName(strPageLN) )
	{
		return error_report("m_DPHelper.GetPageShortName(strPageLN)!!");
	}
	*/
	///-----End NOT_SHOW_SN_IN_LN_COL_WHEN_LN_IS_EMPTY
	///-----End KEEP_CONSISTENT_IN_BOOK_LN_CELL

	vsNames.Add(strPageLN);
	return true;
}
///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
///Jasmine 12/29/10 ORG-1826-S1-3 HAVE_BOOK_SHEET_NAME_IN_BOTH_LEFT_RIGHT_LIST
bool GeneratePlotInfoHelper::addBookSNName(vector<string> &vsNames )
{
	///-----Kit 04/21/2011 ORG-2690-P1 LAYER_PLOT_LIST_NEED_TO_SHOW_BOOK_LN_LIKE_DATASET_LIST
	//string strPage, strLayer;
	//dpHelper.GetPageLayerName(strPage, strLayer);
	string strPage;
	///-----Kit 04/21/2011 ORG-2690-P3 WHEN_BOOK_LN_IS_EMPTY_SHOULD_SHOW_BOOK_SN
	//if( !(is_use_long_name_when_available() && dpHelper.GetPageLongName(strPage)) )
	///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	//if( !(is_use_long_name_when_available() && dpHelper.GetPageLongName(strPage)) || strPage.IsEmpty() )
	///-----End WHEN_BOOK_LN_IS_EMPTY_SHOULD_SHOW_BOOK_SN
	if( !m_DPHelper.GetPageShortName(strPage) )
	{
		///-----Kit 05/23/2011 ORG-2932-P1 NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
		//return error_report("dpHelper.GetPageShortName(strPage) failed!");
		_DBSTR("Not page short name in current data plot!");
		strPage = "";
		///-----End NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
	}
	///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	///-----End LAYER_PLOT_LIST_NEED_TO_SHOW_BOOK_LN_LIKE_DATASET_LIST

	vsNames.Add(strPage);
	return true;
}
bool GeneratePlotInfoHelper::addSheetName(vector<string> &vsNames )
{
	///-----Kit 04/21/2011 ORG-2690-P1 LAYER_PLOT_LIST_NEED_TO_SHOW_BOOK_LN_LIKE_DATASET_LIST
	//string strPage, strLayer;
	//dpHelper.GetPageLayerName(strPage, strLayer);
	string strLayer;
	if( !m_DPHelper.GetLayerName(strLayer) )
	{
		///-----Kit 05/23/2011 ORG-2932-P1 NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
		//return error_report("bool GeneratePlotInfoHelper::addSheetName() failed!");
		_DBSTR("No layer name is current data plot");
		strLayer = "";
		///-----End NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
	}
	///-----End LAYER_PLOT_LIST_NEED_TO_SHOW_BOOK_LN_LIKE_DATASET_LIST
	vsNames.Add(strLayer);
	return true;
}
///End HAVE_BOOK_SHEET_NAME_IN_BOTH_LEFT_RIGHT_LIST

///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
//bool GeneratePlotInfoHelper::GetRowContents( const TreeNode &trLayer, int nBeginDPIndex, int nEndDPIndex, vector<string> &vsRows, const vector<uint>& vnColMap )
bool GeneratePlotInfoHelper::GetContents( const TreeNode &trLayer, int nBeginDPIndex, int nEndDPIndex, vector<string> &vsRows, const vector<uint>& vnColMap, int nColType )
///End TO_IMPROVE_UNGROUP_SPEED
{
	// change to 1 offset
	int nBeginDPID = nBeginDPIndex + 1;
	int nEndDPID = nEndDPIndex + 1;
	
	for( int ii=nBeginDPID; ii<=nEndDPID; ++ii )
	{
		TreeNode trDP = tree_get_node_by_dataid( trLayer, ii, false, FIND_2_LEVEL );
		ASSERT( trDP.IsValid() );
		
		vector<string> vsOneRow;
		/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
		//getRowContents( trDP, vsOneRow);
		getContents( trDP, vsOneRow, nColType);
		///End TO_IMPROVE_UNGROUP_SPEED
		vsOneRow.Reorder(vnColMap);
		vsRows.Append(vsOneRow);
	}

	return true;
}
///End SHARE_COL_MOVING_CODE_IN_BOTH_PANELS

/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
//bool GeneratePlotInfoHelper::getRowContents( const TreeNode &trDataPlot, vector<string> &vsRowContents )
bool GeneratePlotInfoHelper::getContents( const TreeNode &trDataPlot, vector<string> &vsRowContents, int nColType )
///End TO_IMPROVE_UNGROUP_SPEED
{
	///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	if( !trDataPlot.IsValid() )
	{
		ASSERT(false);
		return error_report("pass a invalid tree node to bool GeneratePlotInfoHelper::getContents() function");
	}

	m_DPHelper.SetDataPlotTreeNode(trDataPlot);
	///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	
	if( nColType == PlotsCtrl_Group || nColType < 0 )
		addGroupInfo(vsRowContents);
	///------ Tony 07/04/2012 ORG-2893-S1 ADD_BOOK_NAMING_COLUMN
	if( nColType == PlotsCtrl_BookName || nColType < 0 )
		addBookName(vsRowContents);
	///END ADD_BOOK_NAMING_COLUMN
	///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	if( nColType == PlotsCtrl_BookLN || nColType < 0 )
		addBookLNName(vsRowContents);
	///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	if( nColType == PlotsCtrl_BookSN || nColType < 0 )
		addBookSNName(vsRowContents );
	if( nColType == PlotsCtrl_Sheet || nColType < 0 )
		addSheetName(vsRowContents );
	if( nColType == PlotsCtrl_DSName || nColType < 0 )
		addDatasetName(vsRowContents );
	if( nColType == PlotsCtrl_SName || nColType < 0 )
		addColName(vsRowContents );
	if( nColType == PlotsCtrl_LName || nColType < 0 )
		addColLongName(vsRowContents );
	if( nColType == PlotsCtrl_Legend || nColType < 0 )
		addLegend(vsRowContents);
	if( nColType == PlotsCtrl_Range || nColType < 0 )
		addRowRange(vsRowContents);
	if( nColType == PlotsCtrl_Show || nColType < 0 )
		addShowInfo(vsRowContents);
	if( nColType == PlotsCtrl_PlotType || nColType < 0 )
		addPlotTypeName(vsRowContents);
	
	return true;
}

/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
//bool LayerContentTreeHelper::GetRowContents( const TreeNode &trLayer, int nBeginDPIndex, int nEndDPIndex, vector<string> &vsRows, const vector<uint>& vnColMap )
bool LayerContentTreeHelper::GetContents( const TreeNode &trLayer, int nBeginDPIndex, int nEndDPIndex, vector<string> &vsRows, const vector<uint>& vnColMap, int nColType )
///End TO_IMPROVE_UNGROUP_SPEED
{
	GeneratePlotInfoHelper rowHelper(); 
	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_UNGROUP_SPEED
	//rowHelper.GetRowContents( trLayer, nBeginDPIndex, nEndDPIndex, vsRows, vnColMap);
	rowHelper.GetContents( trLayer, nBeginDPIndex, nEndDPIndex, vsRows, vnColMap, nColType);
	///End TO_IMPROVE_UNGROUP_SPEED
	
	return true;
}

bool LayerContentTreeHelper::RemoveDataPlots( const vector<uint> &vuSelRows )
{
	for( int ii=0; ii<vuSelRows.GetSize(); ++ii )
	{
		TreeNode trNode = tree_get_node_by_dataid( m_trContents.FirstNode, vuSelRows[ii], false, FIND_2_LEVEL );
		if( _is_dataplot_in_group( trNode ) )
		{
			TreeNode trGroup = trNode.Parent();
			ASSERT( trGroup.IsValid() && trGroup.GetNodeCount() > 1 );
			
			if( trGroup.GetNodeCount() == 2 )
			{
				trNode.Remove();
				TreeNode trFirstNodeInGroup = trGroup.FirstNode;
				trFirstNodeInGroup.RemoveAttribute( STR_GROUP_ID_ATTRIB );
				trGroup.Replace( trFirstNodeInGroup, true );
			}
			else
			{
				trNode.Remove();
			}
		}
		else
		{
			trNode.Remove();
		}
	}

	ResetGroupIDAndDataPlotID();
	m_dwChangeBits |= LC_CHANGE_REMOVE_PLOT;	
	
	return true;
}

int LayerContentTreeHelper::ResetGroupIDAndDataPlotID()
{	
	m_nDataPlotNum = 0;
	m_nGroupNum = 0;	
			
	return SetGroupIDAndDataPlotIDAttrib( m_trContents.FirstNode );
}

bool LayerContentTreeHelper::setTreeNodeGroupID( TreeNode &trNode )
{
	m_nGroupNum++;
	trNode.SetAttribute( STR_GROUP_ID_ATTRIB, m_nGroupNum );

	return true;
}

bool LayerContentTreeHelper::setTreeNodeDataPlotID( TreeNode &trNode )
{
	m_nDataPlotNum++;
	trNode.DataID = m_nDataPlotNum;				
	return true;
}

TreeNode LayerContentTreeHelper::GetDataPlotNode(int nPlotIndex, bool* pbIsGrouped, int* pnGroupIndex, TreeNode* ptrGroupNode) 
{	
	TreeNode trJunk;
	if( nPlotIndex < 0 )
		return trJunk;
	
	bool bIsGrouped;
	TreeNode trLayer = m_trContents.FirstNode;	
	
	/// Iris 1/21/2011 ORG-162-P9 TO_IMPROVE_UNGROUP_SPEED
	//TreeNode trDataPlot = tree_get_node_by_dataid(trLayer, nPlotIndex + 1, true);
	TreeNode trDataPlot = tree_get_node_by_dataid(trLayer, nPlotIndex + 1, false, FIND_2_LEVEL);
	///End TO_IMPROVE_UNGROUP_SPEED
	if( trDataPlot )
	{
		int nGroupIndex;
		bool bIsGrouped = trDataPlot.GetAttribute(STR_GROUP_ID_ATTRIB, nGroupIndex);
		
		if( pbIsGrouped )
			*pbIsGrouped = bIsGrouped;
		if( pnGroupIndex )
			*pnGroupIndex = nGroupIndex;
		if( bIsGrouped && ptrGroupNode )
		{
			*ptrGroupNode = trDataPlot.Parent();
			ASSERT(ptrGroupNode->tagName == STR_GROUP_NAME);
		}
	}
	
	return trDataPlot;
}

bool    LayerContentTreeHelper::checkUpdateOnlyOneNodeGroup(TreeNode& trGroupNode)
{
	if( trGroupNode && trGroupNode.tagName.CompareNoCase(STR_GROUP_NAME) == 0 && trGroupNode.GetNodeCount() <= 1 ) 
	{
		TreeNode trOnlyOne = trGroupNode.FirstNode;
		if( trOnlyOne )
		{
			trOnlyOne.RemoveAttribute(STR_GROUP_ID_ATTRIB);
			return trGroupNode.Replace(trOnlyOne);		
		}
	}
	return false;
}

/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
enum {
	MOVING_ERROR,
	MOVING_DATAPLOT_DONE,
	MOVING_GROUP_DONE
};

/// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
//bool	LayerContentTreeHelper::MoveDataPlots(const vector<uint>& vuDataPlotIndices, int nNewPos)
bool	LayerContentTreeHelper::MoveDataPlots(const vector<uint>& vuDataPlotIndices, int nNewPos, bool& bGroupMoving)
///End TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
{	
	bGroupMoving = false; /// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
	if( vuDataPlotIndices.GetSize() == 1 )
	{
		return MoveDataPlot(vuDataPlotIndices[0], nNewPos);		
	}
	else // multi selection
	{
		int nMovingOK;
		int nCurrentPlot;
		bool bMoveUp = nNewPos < vuDataPlotIndices[0];
	
		if( bMoveUp )
		{
			int count = 0;
			for(int index = vuDataPlotIndices.GetSize()-1; index >= 0; index--)
			{
				nCurrentPlot = vuDataPlotIndices[index] + count++;
				nMovingOK = MoveDataPlot(nCurrentPlot, nNewPos);
				if( MOVING_ERROR == nMovingOK )
					return error_report("Error in MoveDataPlot");
				if( MOVING_GROUP_DONE == nMovingOK )
				{
					bGroupMoving = true; /// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
					break;
			}
		}
		}
		else
		{
			int nCurrentPlot = vuDataPlotIndices[0];			
			for( int time = 0; time < vuDataPlotIndices.GetSize(); time++)
			{
				nMovingOK = MoveDataPlot(nCurrentPlot, nNewPos);
				if( MOVING_ERROR == nMovingOK )
					return error_report("Error in MoveDataPlot");
				if( MOVING_GROUP_DONE == nMovingOK )
				{
					bGroupMoving = true; /// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
					break;
			}
			}
				
		}
		
		return true;
	}	
}
///End TO_MOVE_WHOLE_GROUP

int  	LayerContentTreeHelper::MoveDataPlot(int nDataPlotIndex, int nNewPos, bool bToGroupForGroupBorderIndex)
{
	int nCurrentPlotIndex = nDataPlotIndex;
	int nNewPlotIndex = nNewPos;
	
	if( nCurrentPlotIndex < 0 || nNewPlotIndex < 0 
		|| nCurrentPlotIndex > m_nDataPlotNum || nNewPlotIndex >= m_nDataPlotNum
		|| nCurrentPlotIndex == nNewPlotIndex )
		/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
		//return false;
		return MOVING_ERROR;
		///End TO_MOVE_WHOLE_GROUP
		
	bool bIsCurrentInGroup;
	int nCurrentGroupIndex;
	TreeNode trCurrentGroup;
	TreeNode trCurrentDataPlot = GetDataPlotNode(nCurrentPlotIndex, &bIsCurrentInGroup, &nCurrentGroupIndex, &trCurrentGroup);

	/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
	//bool bIsDestGrouped;
	//int nDestGroupIndex;
	///End TO_MOVE_WHOLE_GROUP
	TreeNode trDestNode;
	
	TreeNode trLayer = m_trContents.FirstNode;		
	TreeNode trParentNode = trLayer;
			
	/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
	//bool bIsNewInGroup, bIsNewNextDataPlotInGroup;
	//int nNewGroupIndex, nNewNextDataPlotGroupIndex;
	//TreeNode trNewDataPlot, trNewGroup;
	//trNewDataPlot = GetDataPlotNode(nNewPlotIndex, &bIsNewInGroup, &nNewGroupIndex, &trNewGroup);		
	bool bIsNewInGroup;
	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_MOVE_DATAPLOT_SPEED
	//TreeNode trNewDataPlot = GetDataPlotNode(nNewPlotIndex, &bIsNewInGroup);
	TreeNode trNewGroup;
	TreeNode trNewDataPlot = GetDataPlotNode(nNewPlotIndex, &bIsNewInGroup, NULL, &trNewGroup);
	///End TO_IMPROVE_MOVE_DATAPLOT_SPEED
	///End TO_MOVE_WHOLE_GROUP
	
	/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
	//if( bToGroupForGroupBorderIndex && !bIsCurrentInGroup && !bIsNewInGroup )
	if( bToGroupForGroupBorderIndex )
	///End TO_MOVE_WHOLE_GROUP
	{
		bool bIsNewPreviousDataPlotInGroup;
		int nNewPreviousDataPlotGroupIndex;
		TreeNode trNewPreviousDataPlotGroup;
		TreeNode trNewPrevioudNode = GetDataPlotNode(nNewPlotIndex < nCurrentPlotIndex? nNewPlotIndex-1 : nNewPlotIndex+1, &bIsNewPreviousDataPlotInGroup, &nNewPreviousDataPlotGroupIndex, &trNewPreviousDataPlotGroup);
		if( bIsNewPreviousDataPlotInGroup )
		{
			if( nNewPlotIndex < nCurrentPlotIndex )
				trDestNode = trNewPreviousDataPlotGroup.AddNode(STR_TEMP_NODE_NAME);
			else
				trDestNode = trNewPreviousDataPlotGroup.InsertNode(trNewPreviousDataPlotGroup.FirstNode, STR_TEMP_NODE_NAME);
			/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
			//bIsDestGrouped = true;
			//nDestGroupIndex = nNewPreviousDataPlotGroupIndex;
			///End TO_MOVE_WHOLE_GROUP
		}
	}
	else 
	{
		/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
		/*
		if( nNewPlotIndex < nCurrentPlotIndex )	// move up		  
		{				
			if( 0 == nNewPlotIndex )
			{
				bool bIsInGroup;
				int nGroupIndex;
				TreeNode trGroup;
				TreeNode trFirstDataPlot = GetDataPlotNode(0, &bIsInGroup, &nGroupIndex, &trGroup);
				if( bIsInGroup )
					trParentNode = trGroup;
				trDestNode = trParentNode.InsertNode(trFirstDataPlot, STR_TEMP_NODE_NAME);	
				bIsDestGrouped = bIsInGroup;
				nDestGroupIndex = nGroupIndex;
			}
			else if( nNewPlotIndex == m_nDataPlotNum - 1 ) // last one
			{		
				if( bIsCurrentInGroup && nCurrentGroupIndex == m_nGroupNum ) // moving in same group
				{
					trParentNode = trCurrentGroup;			
				}
				trDestNode = trParentNode.AddNode(STR_TEMP_NODE_NAME); // add to last without group
				bIsDestGrouped = bIsCurrentInGroup;
				nDestGroupIndex = nCurrentGroupIndex;
			}
			else 
			{
				if ( bIsCurrentInGroup && bIsNewInGroup )
				{
					if( nCurrentGroupIndex == nNewGroupIndex )
					{
						trParentNode = trCurrentGroup;
						nDestGroupIndex = nCurrentGroupIndex;
					}
					else
					{
						trParentNode = trNewGroup;	
						nDestGroupIndex = nNewGroupIndex;
					}
					bIsDestGrouped = true;					
				}				
				else if( (!bIsCurrentInGroup && bIsNewInGroup) )
				{
					trParentNode = trNewGroup;	
					bIsDestGrouped = bIsCurrentInGroup;
					nDestGroupIndex = nCurrentGroupIndex;
				}
				else if( (bIsCurrentInGroup && !bIsNewInGroup) )
				{
					bIsDestGrouped = false;
				}
				
				trDestNode = trParentNode.InsertNode(trNewDataPlot, STR_TEMP_NODE_NAME);
			}		
		}
		else // nNewPlotIndex > nCurrentPlotIndex, move down
		{
			TreeNode trNewNextDataPlot, trNewNextDataPlotGroup;
			trNewNextDataPlot = GetDataPlotNode(nNewPlotIndex + 1, &bIsNewNextDataPlotInGroup, &nNewNextDataPlotGroupIndex, &trNewNextDataPlotGroup);
	
			if( trNewNextDataPlot )
			{		
				TreeNode trInsertBefore;
				if( bIsCurrentInGroup == bIsNewInGroup && !bIsNewNextDataPlotInGroup )
				{												
					bIsDestGrouped = bIsCurrentInGroup;
					nDestGroupIndex = nCurrentGroupIndex;
					
					if( bIsCurrentInGroup )
						trDestNode = trCurrentGroup.AddNode(STR_TEMP_NODE_NAME);
					else
						trDestNode = trLayer.InsertNode(trNewNextDataPlot, STR_TEMP_NODE_NAME);
				}
				else 
				{
					if( bIsNewNextDataPlotInGroup )
					{
						if( !bIsNewInGroup ) //1
						{								
							trInsertBefore = trNewNextDataPlotGroup;
						}
						else // 2
						{
							trParentNode = trNewNextDataPlotGroup;
							trInsertBefore = trNewNextDataPlot;
						}
					}
					else if( bIsCurrentInGroup && !bIsNewInGroup )
					{							
						trInsertBefore = trNewNextDataPlot;
					}
					bIsDestGrouped = bIsNewInGroup;
					nDestGroupIndex = nNewGroupIndex;
					
					trDestNode = trParentNode.InsertNode(trInsertBefore, STR_TEMP_NODE_NAME);
				}
				
			}
			else
			{
				if( bIsCurrentInGroup )
					trParentNode = trCurrentGroup;
				trDestNode = trParentNode.AddNode(STR_TEMP_NODE_NAME);
				bIsDestGrouped = bIsCurrentInGroup;
				nDestGroupIndex = nCurrentGroupIndex;
			}
		}
		*/		
		if( 0 == nNewPlotIndex )
		{
			/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_MOVE_DATAPLOT_SPEED
			/*
			bool bIsInGroup;
			int nGroupIndex;
			TreeNode trGroup;
			TreeNode trFirstDataPlot = GetDataPlotNode(0, &bIsInGroup, &nGroupIndex, &trGroup);
			if( bIsInGroup )
				trDestNode = trParentNode.InsertNode(trGroup, STR_TEMP_NODE_NAME);	
			else
				trDestNode = trParentNode.InsertNode(trFirstDataPlot, STR_TEMP_NODE_NAME);
			*/
			if( bIsNewInGroup )
				trDestNode = trParentNode.InsertNode(trNewGroup, STR_TEMP_NODE_NAME);	
			else
				trDestNode = trParentNode.InsertNode(trNewDataPlot, STR_TEMP_NODE_NAME);
			///End TO_IMPROVE_MOVE_DATAPLOT_SPEED
		}
		else if( nNewPlotIndex == m_nDataPlotNum - 1 ) // last one
		{
			trDestNode = trParentNode.AddNode(STR_TEMP_NODE_NAME); // add to last without group
		}
		else
		{
			int nInsertBefore = nNewPos;
			if( nNewPos > nDataPlotIndex ) // move down, need to do insert, so need get the next of new pos
				nInsertBefore++;

			bool bInsertBeforeIsGrouped;
			TreeNode trInsertBeforeGroupNode;
			TreeNode trInsertBefore = GetDataPlotNode(nInsertBefore, &bInsertBeforeIsGrouped, NULL, &trInsertBeforeGroupNode);
			if( bInsertBeforeIsGrouped )
				trDestNode = trParentNode.InsertNode(trInsertBeforeGroupNode, STR_TEMP_NODE_NAME);	
			else
				trDestNode = trParentNode.InsertNode(trInsertBefore, STR_TEMP_NODE_NAME);	
		}
		///End TO_MOVE_WHOLE_GROUP
	}
	
	ASSERT(trDestNode);
	if( !trDestNode )
		/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
		//return false;
		return MOVING_ERROR;
		///End TO_MOVE_WHOLE_GROUP
	
	/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
	/*
	bool bRet = trDestNode.Replace(trCurrentDataPlot);
	ASSERT(trDestNode);
	if( !bRet || !trDestNode)
		return false;	
	
	trCurrentDataPlot.Remove();		
	checkUpdateOnlyOneNodeGroup(trCurrentGroup);
	*/
	if( bIsCurrentInGroup )
	{
		trDestNode.Replace(trCurrentGroup);
		trCurrentGroup.Remove();
	}
	else 
	{
		trDestNode.Replace(trCurrentDataPlot);	
		trCurrentDataPlot.Remove();		
	}
	///End TO_MOVE_WHOLE_GROUP
	
	ResetGroupIDAndDataPlotID();
	m_dwChangeBits |= LC_CHANGE_MOVED;
	
	/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
	//return bRet;
	return bIsCurrentInGroup? MOVING_GROUP_DONE : MOVING_DATAPLOT_DONE;
	///End TO_MOVE_WHOLE_GROUP
}

bool 	LayerContentTreeHelper::MoveDataPlotIntoGroup(int nDataPlotIndex, int nGroupIndex, int* pnNewDataPlotIndex)
{
	if( nGroupIndex <= 0 || nGroupIndex > m_nGroupNum )
		return false;
	
	int nCurrentGroupIndex;
	TreeNode trDataPlot = GetDataPlotNode(nDataPlotIndex, NULL, &nCurrentGroupIndex);
	if( !trDataPlot || nCurrentGroupIndex == nGroupIndex )
		return false;
	
	TreeNode trGroup;
	TreeNode trLayer = m_trContents.FirstNode;
	bool bRet = octree_find_node(&trLayer, &trGroup, STR_GROUP_ID_ATTRIB, nGroupIndex, false);
	ASSERT(bRet);
	if( !trGroup )
		return false;
	
	TreeNode trFirstDataPlotInGroup = trGroup.FirstNode;
	TreeNode trLastDataPlotInGroup = trGroup.LastNode;
	ASSERT(trFirstDataPlotInGroup);
	ASSERT(trLastDataPlotInGroup);
	if( !trFirstDataPlotInGroup || !trLastDataPlotInGroup )
		return false;	
	int nFirstDataPlotIndex = trFirstDataPlotInGroup.DataID - 1;
	int nLastDataPlotIndex = trLastDataPlotInGroup.DataID - 1;
	
	ASSERT(nDataPlotIndex < nFirstDataPlotIndex || nDataPlotIndex > nLastDataPlotIndex);
	if( nDataPlotIndex >= nFirstDataPlotIndex && nDataPlotIndex <= nLastDataPlotIndex ) // already in this group, nothing need to do
		return false;
	
	// if current data plot nearby this group, no need to reorder, just move dataplot node to group branch and set group attrbute.
	if( nDataPlotIndex == nFirstDataPlotIndex - 1 || nDataPlotIndex == nLastDataPlotIndex + 1 )
	{
		TreeNode trNew;
		if( nDataPlotIndex == nFirstDataPlotIndex - 1 )
			trNew = trGroup.InsertNode(trFirstDataPlotInGroup, STR_TEMP_NODE_NAME);	
		else
			trNew = trGroup.AddNode(STR_TEMP_NODE_NAME);
		
		if( trNew && trNew.Replace(trDataPlot) )
		{
			trDataPlot.Remove();
			
			int nOldGroupIndex;
			bool bOldIsGrouped = trNew.GetAttribute(STR_GROUP_ID_ATTRIB, nOldGroupIndex);
			trNew.SetAttribute(STR_GROUP_ID_ATTRIB, nGroupIndex);			
			
			if( bOldIsGrouped ) 
			{
				TreeNode trOldGroup = getGroupNode(trLayer, nOldGroupIndex - 1); // convert to 0 offset
				ASSERT(trOldGroup);
				if( trOldGroup )
				{
					checkUpdateOnlyOneNodeGroup(trOldGroup);
					ResetGroupIDAndDataPlotID();
				}
			}
			
			if(pnNewDataPlotIndex)
				*pnNewDataPlotIndex = nDataPlotIndex;
			
			m_dwChangeBits |= LC_CHANGE_GROUP;
			return true;
		}	
		else
		{
			ASSERT(false);
			return false;
		}
	}	
	
	// 
	bool bMoveToGroupTop = (nDataPlotIndex < nFirstDataPlotIndex); // else will move to the last in this group
	/// Iris 12/22/2010 TO_MOVE_WHOLE_GROUP
	//int nNewPos = bMoveToGroupTop ? nFirstDataPlotIndex : nLastDataPlotIndex + 1;
	int nNewPos = bMoveToGroupTop ? nFirstDataPlotIndex - 1 : nLastDataPlotIndex + 1;
	///End TO_MOVE_WHOLE_GROUP
	if( pnNewDataPlotIndex )
		*pnNewDataPlotIndex = nNewPos;
	return MoveDataPlot(nDataPlotIndex, nNewPos, true);
}

enum
{
	ACTION_NOT_INIT = -1,
	ACTION_INSERT_BEFORE,
	ACTION_INSERT_AFTER,
	ACTION_APPEND
};	

enum
{
	GROUPERR_NO_ERR = 0,
	GROUPERR_GROUP_MUST_HAVE_AT_LEAST_TWO_MEMBERS,
	GROUPERR_NOT_SAME_PLOTTYPE,
	GROUPERR_INTERNAL_ERR
};

///-----Kit 10/27/2011 ORG-4241-P1 MAKE_BAR_AND_COL_BAR_CAN_GROUP_IN_LAYER_CONTENT_AND_PLOT_SETUP
static bool _compare_plot_type(int nPlotTypeLeft, int nPlotTypeRight, DWORD dwLayerBits)
{
	if ( GOGT_NEVER == get_grouping_type(nPlotTypeLeft) 
		|| GOGT_NEVER == get_grouping_type(nPlotTypeRight) )
		return false;

	///-----Kit 11/02/2011 ORG-4062-P3 PUBLISH_WINDOW_THEME_FILE_OUT_OF_INDEX
	//return compare_plot_types_with_pcd_check(nPlotTypeLeft, nPlotTypeRight, dwLayerBits);
	return compare_plot_types_with_pcd_check(nPlotTypeLeft, nPlotTypeRight, dwLayerBits, FALSE);
	///-----End PUBLISH_WINDOW_THEME_FILE_OUT_OF_INDEX
}
///-----End MAKE_BAR_AND_COL_BAR_CAN_GROUP_IN_LAYER_CONTENT_AND_PLOT_SETUP

///Jasmine 01/06/11 ORG-1826-S12 ALLOW_CHANGE_SIMILAR_PLOT_TYPE
bool LayerContentTreeHelper::IsSamePlotType(const vector<uint>& vnPlotIndices, const vector<int>& vnCompatibleIDs/* = NULL*/, int* pnInvalidPlot/* = NULL*/)
{
	///-----Kit 10/27/2011 ORG-4241-P1 MAKE_BAR_AND_COL_BAR_CAN_GROUP_IN_LAYER_CONTENT_AND_PLOT_SETUP
	//int nPlotType = -1;
	//for(int index = 0; index < vnPlotIndices.GetSize(); index++)
	//{
	//	TreeNode trDataPlot = GetDataPlotNode(vnPlotIndices[index]);	
	//	TreeNode trPlotType = trDataPlot.PlotDesigs.Type;

	//	if( !trPlotType )
	//	{
	//		ASSERT(false);
	//		return false;		
	//	}

	//	bool bCompatible = false;
	//	if(vnCompatibleIDs)
	//	{
	//		vector<uint> vnIndex;
	//		bCompatible = vnCompatibleIDs.Find(vnIndex, trPlotType.nVal);
	//		if(!bCompatible)
	//		{
	//			if(pnInvalidPlot)
	//				*pnInvalidPlot = index;
	//			return false;
	//		}
	//	}

	//	if( 0 == index )
	//	{
	//		nPlotType = trPlotType.nVal;
	//	}
	//	else if( nPlotType != trPlotType.nVal )
	//	{
	//		if(bCompatible)
	//			continue;

	//		if(pnInvalidPlot)
	//			*pnInvalidPlot = index;
	//		return false;			
	//	}
	//}
	//return true;
	const size_t countSelPlots = vnPlotIndices.GetSize();
	
	ASSERT(countSelPlots > 1);

	TreeNode trDP = GetDataPlotNode(vnPlotIndices[0]);
	ASSERT(trDP.IsValid());
	DataPlotTreeNodeHelper dpHelper(trDP);

	const int nPlotType = dpHelper.GetPlotType();

	GraphLayer gl = Project.ActiveLayer();
	ASSERT(gl.IsValid());
	const DWORD dwLayerBits = gl.GetSystemParam(GLI_PCD_BITS);

	int index = 1;	// from 1 !
	for ( ; index < countSelPlots; ++index )
	{
		trDP = GetDataPlotNode(vnPlotIndices[index]);
		dpHelper.SetDataPlotTreeNode(trDP);
		const int nCurPlotType = dpHelper.GetPlotType();

		bool bCompatible = false;

		if ( vnCompatibleIDs )
		{
			vector<uint> vuIndies;
			bCompatible = (vnCompatibleIDs.Find(vuIndies, nCurPlotType) <= 0);
			if ( !bCompatible )
				break;
		}

		if ( _compare_plot_type(nPlotType, nCurPlotType, dwLayerBits) )
			continue;

		if ( bCompatible )
			continue;

		break;
	}

	if ( index == countSelPlots )
		return true;

	if ( NULL != pnInvalidPlot )
		*pnInvalidPlot = index;

	return false;
	///-----End MAKE_BAR_AND_COL_BAR_CAN_GROUP_IN_LAYER_CONTENT_AND_PLOT_SETUP
}
///End ALLOW_CHANGE_SIMILAR_PLOT_TYPE
int LayerContentTreeHelper::SetDataPlotGroup(const vector<uint>& vnPlotIndices, bool bGroup)
{	
	if( vnPlotIndices.GetSize() == 0 )
		return GROUPERR_GROUP_MUST_HAVE_AT_LEAST_TWO_MEMBERS;
	
	TreeNode trLayer = m_trContents.FirstNode;
	
	if( bGroup )
	{
		ASSERT(vnPlotIndices.GetSize() > 1);
		if( vnPlotIndices.GetSize() <= 1 )
			return GROUPERR_GROUP_MUST_HAVE_AT_LEAST_TWO_MEMBERS;	
			
		if( !IsSamePlotType(vnPlotIndices) )
			return GROUPERR_NOT_SAME_PLOTTYPE;
		
		// find the first node in selection
		bool bIsGroup;
		TreeNode trGroupNode;
		TreeNode trFirstSelNode = GetDataPlotNode(vnPlotIndices[0], &bIsGroup, NULL, &trGroupNode);
		ASSERT(trFirstSelNode);
		if( !trFirstSelNode.IsValid() )
			return GROUPERR_INTERNAL_ERR;
		
		// prepare new group node
		TreeNode trNewGroup;
		if( bIsGroup )
			trNewGroup = trLayer.InsertNode(trGroupNode, STR_GROUP_NAME);
		else
			trNewGroup = trLayer.InsertNode(trFirstSelNode, STR_GROUP_NAME);
		ASSERT(trNewGroup);
		if( !trNewGroup.IsValid() )
			return GROUPERR_INTERNAL_ERR;
		
		m_nGroupNum++;
		for(int index = 0; index < vnPlotIndices.GetSize(); index++)
		{
			int nPlot = vnPlotIndices[index];												
			TreeNode trDataPlot = GetDataPlotNode(nPlot, &bIsGroup, NULL, &trGroupNode);
			ASSERT(trDataPlot);
			
			TreeNode trNewDataPlot = trNewGroup.AddNode(STR_TEMP_NODE_NAME);
			if( trNewDataPlot.Replace(trDataPlot) )
			{
				trDataPlot.Remove();
				if( bIsGroup && trGroupNode.IsValid() && trGroupNode.GetNodeCount() <= 1 ) // remove group branch if this group only has one data plot node.
				{
					TreeNode trTemp = trGroupNode.FirstNode;
					trGroupNode.Replace(trTemp);
				}
				trNewDataPlot.SetAttribute(STR_GROUP_ID_ATTRIB, m_nGroupNum);
			}				
		}				
	}
	else // set ungroup
	{
		int nInsert = ACTION_NOT_INIT;
		for(int index = 0; index < vnPlotIndices.GetSize(); index++)
		{
			int nPlot = vnPlotIndices[index];	
			
			bool bIsGroup;
			TreeNode trGroupNode;
			TreeNode trDataPlot = GetDataPlotNode(nPlot, &bIsGroup, NULL, &trGroupNode);
			ASSERT(trDataPlot);
			
			if( trDataPlot && bIsGroup )
			{
				TreeNode trNewDataPlot;				
				
				TreeNode trFirstInGroup = trGroupNode.FirstNode;
				if( ACTION_INSERT_BEFORE == nInsert || ACTION_NOT_INIT == nInsert && 0 == index && trFirstInGroup && 0 == trDataPlot.tagName.CompareNoCase(trFirstInGroup.tagName) ) // is the first data plot node in group branch
				{
					trNewDataPlot = trLayer.InsertNode(trGroupNode, STR_TEMP_NODE_NAME);
					nInsert = ACTION_INSERT_BEFORE;
				}
				else if( ACTION_INSERT_AFTER == nInsert || ACTION_NOT_INIT == nInsert && trGroupNode.NextNode )
				{
					trNewDataPlot = trLayer.InsertNode(trGroupNode.NextNode, STR_TEMP_NODE_NAME);
					nInsert = ACTION_INSERT_AFTER;
				}
				else
				{
					trNewDataPlot = trLayer.AddNode(STR_TEMP_NODE_NAME);
					nInsert = ACTION_APPEND;
				}
				
				if( trNewDataPlot.Replace(trDataPlot) )
				{
					trNewDataPlot.RemoveAttribute(STR_GROUP_ID_ATTRIB);
					trDataPlot.Remove();					
				}
				
				// remove group branch if there is only one data plot node in this group	
				checkUpdateOnlyOneNodeGroup(trGroupNode);
			}
		}
	}	
	
	ResetGroupIDAndDataPlotID();   
	m_dwChangeBits |= LC_CHANGE_GROUP;	
	return GROUPERR_NO_ERR;	
}

bool	LayerContentTreeHelper::SetDataPlotShow(int nDataPlotIndex, bool bShow)
{
	TreeNode trDataPlot = GetDataPlotNode(nDataPlotIndex);
	ASSERT(trDataPlot);
	if( !trDataPlot )
		return false;
	
	TreeNode trShowInfo = trDataPlot.ShowInfo;
	ASSERT(trShowInfo);
	if( !trShowInfo )
		return false;
	
	trShowInfo.nVal = bShow;
	m_dwChangeBits |= LC_CHANGE_SHOW;
	return true;
}

/// Iris 01/04/2011 ORG-1682-P4 IMPROVE_LAYER_CONTENTS_DLG_GROUP_MSG
/*
static bool _check_vec_inc(const vector& vec, double dInc)
{
	vector vDiff;
	vec.Difference(vDiff);
	
	double min, max;
	vDiff.GetMinMax(min, max);
	
	return( is_equal(min, max) && is_equal(min, dInc) );
}
*/
///End IMPROVE_LAYER_CONTENTS_DLG_GROUP_MSG

bool 	LayerContentTreeHelper::CanDoGroupPlots(const vector<uint>& vnPlots)
{
	vector vdPlots;
	vdPlots = vnPlots;
	/// Iris 01/04/2011 ORG-1682-P4 IMPROVE_LAYER_CONTENTS_DLG_GROUP_MSG
	//if( vnPlots.GetSize() < 2 || !_check_vec_inc(vdPlots, 1) )
	if( vnPlots.GetSize() < 2 )
	///End IMPROVE_LAYER_CONTENTS_DLG_GROUP_MSG
		return false;
	
	///-----Kit 10/27/2011 ORG-4241-P1 MAKE_BAR_AND_COL_BAR_CAN_GROUP_IN_LAYER_CONTENT_AND_PLOT_SETUP
	///-----Kit 10/27/2011 : I don't know why we did not use IsSameTypes() function to check here if it can do group!!!!
	///-----End MAKE_BAR_AND_COL_BAR_CAN_GROUP_IN_LAYER_CONTENT_AND_PLOT_SETUP

	for(int index; index < vnPlots.GetSize(); index++)
	{
		bool bIsGroup;
		TreeNode trDataPlot = GetDataPlotNode(vnPlots[index], &bIsGroup);
		if( !trDataPlot )
			return false;
		if( bIsGroup )
			return false;
		
		///Jasmine 06/29/2012 ORG-6105-P1 GROUPING_NOT_AVAILABLE_FOR_MATRIX
		int nPageType;
		_get_page_type_from_dp_tree_node(trDataPlot, nPageType);
		if(EXIST_MATRIX == nPageType)
			return false;
		
		if( _is_dp_from_virtual_matrix(trDataPlot) )
			return false;
		///End GROUPING_NOT_AVAILABLE_FOR_MATRIX
		
		///Jasmine 09/25/2012 ORG-6105-P2 GROUPING_NOT_AVAILABLE_FOR_XYZ_PLOT
		if( is_xyz_plot(trDataPlot) )	
			return false;
		///End GROUPING_NOT_AVAILABLE_FOR_XYZ_PLOT
	}
	return true;
}

bool	LayerContentTreeHelper::CanDoUngroupPlots(const vector<uint>& vnPlots)
{
	vector vdPlots;
	vdPlots = vnPlots;
	/// Iris 01/04/2011 ORG-1682-P4 IMPROVE_LAYER_CONTENTS_DLG_GROUP_MSG
	//if( vnPlots.GetSize() == 0 || vnPlots.GetSize() > 1 && !_check_vec_inc(vdPlots, 1) )
	if( vnPlots.GetSize() == 0 || vnPlots.GetSize() > 1 && !check_vector_increment(vdPlots, 1) )
	///End IMPROVE_LAYER_CONTENTS_DLG_GROUP_MSG
		return false;
	
	int nGroupIndexTmp = -1;
	for(int index; index < vnPlots.GetSize(); index++)
	{
		bool bIsGroup;
		int nGroupIndex;
		TreeNode trDataPlot = GetDataPlotNode(vnPlots[index], &bIsGroup, &nGroupIndex);
		
		if( !trDataPlot )
			return false;		
		if( !bIsGroup )
			return false;
		
		if( -1 == nGroupIndexTmp )
			nGroupIndexTmp = nGroupIndex;
		
		if( nGroupIndexTmp != nGroupIndex )
			return false;
	}
	return true;
}

bool	LayerContentTreeHelper::GetAllDataPlotIndicesInGroup(int nPlotIndex, vector<int>& vnPlotsInGroup, int& nSelectGroup)
{
	vnPlotsInGroup.RemoveAll();
	
	bool bIsGrouped;
	int nGroupIndex;	
	TreeNode trGroup;
	TreeNode trDataPlot = GetDataPlotNode(nPlotIndex, &bIsGrouped, &nGroupIndex, &trGroup);
	if( !trDataPlot || !bIsGrouped || nSelectGroup == nGroupIndex )
		return false;
	
	ASSERT(trGroup);
	TreeNode trFirstInGroup = trGroup.FirstNode;
	int begin = trFirstInGroup.DataID - 1;
	int end = begin + trGroup.Children.Count() - 1;
	vnPlotsInGroup.Data(begin, end, 1);
	nSelectGroup = nGroupIndex;
	return true;
}

int LayerContentTreeHelper::SetGroupIDAndDataPlotIDAttrib( TreeNode &trLayer )
{
	int nDataPlots = 0;
	foreach( TreeNode trNode in trLayer.Children )
	{
		if( check_tree_node_tagName_is_DataPlot( trNode ) )
		{	
			setTreeNodeDataPlotID( trNode );
			nDataPlots++;
			
			trNode.RemoveAttribute(STR_GROUP_ID_ATTRIB);
		}
		else if( trNode.tagName.CompareNoCase( STR_GROUP_NAME) == 0 )
		{	
			setTreeNodeGroupID( trNode );
			foreach( TreeNode trInGroup in trNode.Children )
			{
				// must be DataPlot
				ASSERT( check_tree_node_tagName_is_DataPlot( trInGroup ) );
				
				trInGroup.SetAttribute( STR_GROUP_ID_ATTRIB, m_nGroupNum );
				setTreeNodeDataPlotID( trInGroup );
				nDataPlots++;
			}
		}
	}
	
	return nDataPlots;
}

///Jasmine 01/12/11 ORG-1997-S2 SHOW_CURRENT_PLOT_TYPE
int LayerContentTreeHelper::GetDataPlotType(int nDPIndex)
{
	TreeNode trDP = GetDataPlotNode( nDPIndex );

	if( !trDP.IsValid() )
		return PLOT_ID_FOR_AUTO;

	int nPlotID;
	return _get_plot_id_from_dp_tree_node( trDP, nPlotID )? nPlotID : PLOT_ID_FOR_AUTO;
}
///End SHOW_CURRENT_PLOT_TYPE

bool LayerContentTreeHelper::GetPlotTypeCellComboStrAndPlotIDs( int nDPIndex, DWORD dwLayerBits, string &strComboStr, vector<int> &vnPlotIDs )
{
	TreeNode trDP = GetDataPlotNode( nDPIndex );

	if( !trDP.IsValid() )
		return false;

	int nPlotID;
	if( !_get_plot_id_from_dp_tree_node( trDP, nPlotID ) )
		return false;

	/// Iris 1/19/2011 FAIL_TO_CHANGE_PLOTTYPE_FROM_LINE_TO_SCATTER_IN_3D_SURFACE_GRAPH
	//ChangePlotTypeList plotTypeList( GetDataPageType(), dwLayerBits, _is_dp_from_virtual_matrix( trDP ), nPlotID );
	int nPageType;
	_get_page_type_from_dp_tree_node(trDP, nPageType);
	ChangePlotTypeList plotTypeList( nPageType, dwLayerBits, _is_dp_from_virtual_matrix( trDP ), nPlotID );
	///End FAIL_TO_CHANGE_PLOTTYPE_FROM_LINE_TO_SCATTER_IN_3D_SURFACE_GRAPH
	
	vector<string> vsPlotType;
	plotTypeList.GetPlotTypesListName( vsPlotType );
	strComboStr.Empty();
	strComboStr.SetTokens( vsPlotType, '|' );
	
	plotTypeList.GetPlotIDs( vnPlotIDs );

	return true;
}

int LayerContentTreeHelper::GetDataPageType()
{
	int nFitstDP = 1;
	TreeNode trDP = tree_get_node_by_dataid( m_trContents.FirstNode, nFitstDP, false, FIND_2_LEVEL );
	if( !trDP.IsValid() )
		return m_nDataPageType;

	int nPageType;
	if( _get_page_type_from_dp_tree_node( trDP, nPageType ) )
		return nPageType;

	return m_nDataPageType;
}

bool LayerContentTreeHelper::OnPlotTypeChange( int nDPIndex, int nNewPlotID )
{
	bool bSuccess = false;

	if( IsDataPlotInGroup( nDPIndex ) )
	{
		bSuccess = changePlotTypeInGroup( nDPIndex, nNewPlotID );
	}
	else
	{
		bSuccess = changeOnePlotType( nDPIndex, nNewPlotID );
	}

	if( bSuccess )
		m_dwChangeBits |= LC_CHANGE_PLOTTYPE;

	return bSuccess;
}

bool LayerContentTreeHelper::GetRowRangeInfo( int nDPIndex, RangeEditorDlgInfo &dlgInfo )
{
	TreeNode trSelDP = GetDataPlotNode( nDPIndex );
	
	if( !trSelDP.IsValid() )
		return false;

	TreeNode trRowRange = trSelDP.RowRange;
	ASSERT( trRowRange.IsValid() );

	string strRowRange = trRowRange.strVal;
	if( !okutil_parse_row_range(strRowRange, &dlgInfo.nFrom, &dlgInfo.bFromAuto, &dlgInfo.nTo, &dlgInfo.bToAuto) )
		return false;
	dlgInfo.nFrom++;
	dlgInfo.nTo++;

	string strMinMaxRange;
	if( !trRowRange.GetAttribute( STR_COMBO_ATTRIB, strMinMaxRange ) )
		return false;
	
	/// Iris 3/10/2011 ORG-2371-P1 FIX_LC_RESCALE_ISSUE
	// strMinMaxRange is [1:32]1 < X < 32, 1 < Y < 32 format, this format will cause the following okutil_parse_row_range function 
	// return false. So remove the "1 < X < 32, 1 < Y < 32" part, just remind [1:32].
	int nPos = strMinMaxRange.Find(']');
	if( nPos >= 0 )
		strMinMaxRange = strMinMaxRange.Mid(0, nPos+1);
	///End FIX_LC_RESCALE_ISSUE
	
	if( okutil_parse_row_range( strMinMaxRange, &dlgInfo.nMin, NULL, &dlgInfo.nMax, NULL ) )
	{
		dlgInfo.nMin++;
		dlgInfo.nMax++;
		return true;
	}
	return false;
}

bool	LayerContentTreeHelper::SetRowRangeInfo( int nDPIndex, const RangeEditorDlgInfo &dlgInfo )
{
	TreeNode trSelDP = GetDataPlotNode( nDPIndex );
	
	if( !trSelDP.IsValid() )
		return false;
	
	TreeNode trRowRange = trSelDP.RowRange;
	ASSERT( trRowRange.IsValid() );
	
	string strRowRange;
	okutil_create_row_range_string(&strRowRange, dlgInfo.nFrom, dlgInfo.nTo, dlgInfo.bFromAuto, dlgInfo.bToAuto);
	if( strRowRange.IsEmpty() )
		return error_report("fail to create row range string in LayerContentTreeHelper::SetRowRangeInfo");
	
	if( strRowRange.CompareNoCase( trRowRange.strVal ) == 0 )
		return false;
	
	trRowRange.strVal = strRowRange;
	
	/// Iris 3/15/2011 ORG-2371-P2 FIX_CHANGE_ROWRANGE_FOR_3D_LINE_PLOT_CAUSE_RESCALE_FAILED_ON_XY_AXES
	TreeNode trLimits = trSelDP.PlotDesigs.Limits;
	if( trLimits )
	{
		foreach(TreeNode trN in trLimits.Children)
		{
			trN.Min.nVal = dlgInfo.nFrom;
			trN.Max.nVal = dlgInfo.nTo;
		}
		Project.UpdateDataPlotLimits(trSelDP);
	}
	///End FIX_CHANGE_ROWRANGE_FOR_3D_LINE_PLOT_CAUSE_RESCALE_FAILED_ON_XY_AXES
	
	m_dwChangeBits |= LC_CHANGE_ROWRANGE;
	return true;
	
}

bool LayerContentTreeHelper::IsSelDPInSameGroup( const vector<uint> &vuSelDPID )
{
	TreeNode trGroup;
	bool	bGroup;
	int		nGroupIndex;
	TreeNode trDP = GetDataPlotNode( vuSelDPID[0], &bGroup, &nGroupIndex, &trGroup );
	ASSERT( trDP.IsValid() );

	if( !bGroup || !trGroup.IsValid() )
		return false;

	int iSelDPIndex = 0;
	foreach( TreeNode trDPInGroup in trGroup.Children )
	{
		int nDPID = trDPInGroup.DataID;
		if( iSelDPIndex >= vuSelDPID.GetSize() || nDPID != vuSelDPID[iSelDPIndex] )
			return false;

		iSelDPIndex++;
	}

	return true;
}

bool LayerContentTreeHelper::IsDataPlotInGroup( int nDPIndex )
{
	TreeNode trDP = GetDataPlotNode( nDPIndex );
	if( !trDP.IsValid() )
		return false;
	
	return _is_dataplot_in_group( trDP );
}

bool LayerContentTreeHelper::changePlotTypeInGroup( int nDPIndex, int nNewPlotID )
{
	TreeNode trGroup;
	bool	bGroup;
	int		nGroupIndex;
	TreeNode trDP = GetDataPlotNode( nDPIndex, &bGroup, &nGroupIndex, &trGroup );
	ASSERT( bGroup && trGroup.IsValid() && trDP.IsValid() );

	TreeNode trCloneOldDP = trDP.Clone();	///-----Kit 01/10/2011 STORGE_DP_TREE_INFO_AFTER_EDIT_TREE_NODE

	int nTotalTreeNode = trGroup.GetNodeCount();
	/// Iris 12/27/2010 TO_FIX_CHANGE_PLOTTYPE_IN_GROUP_FAILED
	//for( int iDP = nDPIndex; iDP < nTotalTreeNode; ++iDP )
	for( int iDP = nDPIndex; iDP < nDPIndex + nTotalTreeNode; ++iDP )
	///End TO_FIX_CHANGE_PLOTTYPE_IN_GROUP_FAILED
	{
		trDP = GetDataPlotNode( iDP );
		ASSERT( trDP.IsValid() );
		if( !changePlotType( nNewPlotID, trDP ) )
			return false;
	}

	_storge_before_edit_dp_tree_node( trCloneOldDP, trDP ); ///-----Kit 01/10/2011 STORGE_DP_TREE_INFO_AFTER_EDIT_TREE_NODE

	m_dwChangeBits |= LC_CHANGE_PLOTTYPE;

	return true;
}

///-----Kit 01/10/2011 STORGE_DP_TREE_INFO_AFTER_EDIT_TREE_NODE
bool LayerContentTreeHelper::changeOnePlotType( int nDPIndex, int nNewPlotID )
{
	TreeNode trDP = GetDataPlotNode( nDPIndex );
	ASSERT( trDP.IsValid() );
	TreeNode trCloneOldDP = trDP.Clone();

	if( changePlotType( nNewPlotID, trDP ) )
	{
		_storge_before_edit_dp_tree_node( trCloneOldDP, trDP );
		return true;
	}

	return false;
}
///-----End STORGE_DP_TREE_INFO_AFTER_EDIT_TREE_NODE

bool LayerContentTreeHelper::changePlotType( int nNewPlotID, TreeNode &trDP )
{
	ASSERT( trDP.IsValid() );

	/// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
	//PlotTypeChangeHelper ptHelper( nNewPlotID, GetDataPageType(), trDP );
	PlotTypeChangeHelper ptHelper( nNewPlotID, GetDataPageType(), m_dwLayerBits, trDP );
	///End IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS

	return ptHelper.ChangePlotType();
}

/************************************************************************/
/*  DataPlotTreeNodeHelper			                                    */
/************************************************************************/
DataPlotTreeNodeHelper::DataPlotTreeNodeHelper( const TreeNode &trDP )
{
	init(trDP);
}

bool	DataPlotTreeNodeHelper::SetDataPlotTreeNode(const TreeNode& trDP)
{
	return init(trDP);
}
bool	DataPlotTreeNodeHelper::GetDataPlotTreeNode(TreeNode& trDP)
{
	if( !m_trDP.IsValid() )
		return false;
	
	trDP	= m_trDP;
	return true;
}

///-----Kit 10/27/2011 ORG-4241-P1 MAKE_BAR_AND_COL_BAR_CAN_GROUP_IN_LAYER_CONTENT_AND_PLOT_SETUP
int		DataPlotTreeNodeHelper::GetPlotType()
{
	int nPlotType = -1;
	GetPlotType(nPlotType);
	ASSERT(nPlotType != -1);
	return nPlotType;
}
///-----End MAKE_BAR_AND_COL_BAR_CAN_GROUP_IN_LAYER_CONTENT_AND_PLOT_SETUP

bool	DataPlotTreeNodeHelper::GetPlotType( int &nPlotType )
{
	TreeNode trPlotType = m_trPlotDesigs.Type;
	if( !trPlotType.IsValid() )
	{
		ASSERT( false );
		return false;
	}
	
	nPlotType = trPlotType.nVal;

	return true;
}

bool DataPlotTreeNodeHelper::GetAuxPlotInfo( DWORD &dwAuxPlotInfo )
{
	TreeNode trAuxPlotInfo = m_trPlotDesigs.AuxPlotInfo;
	if( !trAuxPlotInfo.IsValid() )
	{
		ASSERT( false );
		return false;
	}

	dwAuxPlotInfo = (DWORD)trAuxPlotInfo.nVal;
	return true;
}

bool DataPlotTreeNodeHelper::GetLTPlotInfo( DWORD &dwLTPlotInfo )
{
	TreeNode trLTPlotInfo = m_trPlotDesigs.LTPlotInfo;
	if( !trLTPlotInfo.IsValid() )
	{
		ASSERT( false );
		return false;
	}
	
	dwLTPlotInfo = (DWORD)trLTPlotInfo.nVal;
	return true;	
}

///-----Kit 04/21/2011 ORG-2690-P1 LAYER_PLOT_LIST_NEED_TO_SHOW_BOOK_LN_LIKE_DATASET_LIST
/*
bool DataPlotTreeNodeHelper::GetPageLayerName( string &strPage, string &strLayer)
{
	TreeNode trPage = m_trPlotDesigs.WksPage;
	TreeNode trLayer = m_trPlotDesigs.WksLayer;

	if( !trPage.IsValid() || !trLayer.IsValid() )
	{
		return false;
	}
		

	strPage = trPage.strVal;
	strLayer = trLayer.strVal;
	return true;
}
*/
///-----End LAYER_PLOT_LIST_NEED_TO_SHOW_BOOK_LN_LIKE_DATASET_LIST

///-----Kit 04/21/2011 ORG-2690-P1 LAYER_PLOT_LIST_NEED_TO_SHOW_BOOK_LN_LIKE_DATASET_LIST
bool DataPlotTreeNodeHelper::GetPageShortName(string& strPageSN)
{
	TreeNode trPage = m_trPlotDesigs.WksPage;
	if( !trPage.IsValid() )
		return false;

	strPageSN = trPage.strVal;
	return true;
}

bool DataPlotTreeNodeHelper::GetPageLongName(string& strPageLN)
{
	string strPageSN;
	///-----Kit 05/23/2011 ORG-2932-P1 NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
	//if( !GetPageShortName(strPageSN) )
	if( !GetPageShortName(strPageSN) && strPageSN.IsEmpty() )
	///-----End NO_NEED_TO_CHECK_FUNC_POLT_BOOK_LN_AND_SN
		return false;
	
	Page pg(strPageSN);
	if( !pg.IsValid() )
	{
		ASSERT(false);
		return error_report("Can't not get the correct book!");
	}

	strPageLN = pg.GetLongName();
	return true;
}

bool DataPlotTreeNodeHelper::GetLayerName(string &strLayer)
{
	TreeNode trLayer = m_trPlotDesigs.WksLayer;
	if( !trLayer.IsValid() )
		return false;

	strLayer = trLayer.strVal;
	return true;
}
///-----End LAYER_PLOT_LIST_NEED_TO_SHOW_BOOK_LN_LIKE_DATASET_LIST

bool DataPlotTreeNodeHelper::GetColNameAndColDesignation( vector<string> &vsName, vector<uint> &vuDesig )
{
	const bool bAlwaysDoUntilBreak = true;
	int nSuffix = 1;
	while( bAlwaysDoUntilBreak )
	{
		string strDPC = "DPC" + nSuffix;
		TreeNode trDPC = tree_get_node_by_tagname( m_trPlotDesigs, strDPC, true );
		
		if( !trDPC.IsValid() )
				break;
			
		TreeNode trDesig = trDPC.Desig;
		TreeNode trName = trDPC.Name;
		ASSERT( trDesig.IsValid() && trName.IsValid() );
			
		vuDesig.Add( trDesig.nVal );
		vsName.Add( trName.strVal );
		
		nSuffix++;
	}
	
	return true;
}

///-----Kit 03/09/2011 ORG-2331-S4 SHOW_COL_DESIGNATION_ON_RIGHT_PANEL
bool DataPlotTreeNodeHelper::GetRowRange(string &strRange)
{
	TreeNode trRowRange = m_trDP.RowRange;
	
	if( !trRowRange.IsValid() )
		return false;

	strRange = trRowRange.strVal;
	return true;
}
///-----End SHOW_COL_DESIGNATION_ON_RIGHT_PANEL

bool DataPlotTreeNodeHelper::GetRowRange( int arrRowRange[2] )
{
	string strRowRange = "";
	GetRowRange(strRowRange);

	BOOL bAuto1, bAuto2;
	if( okutil_parse_row_range( strRowRange, arrRowRange, &bAuto1, arrRowRange+1, &bAuto2 ) )
	{
		if( bAuto1 )
			arrRowRange[0] = -1;
		else
			arrRowRange[0]++;
		
		if( bAuto2 )
			arrRowRange[1] = -1;
		else
			arrRowRange[1]++;
		return true;
	}
	ASSERT(false);
	return false;
}

/// Iris 01/10/2011 FIX_CHANGE_PLOTTYPE_NOT_KEEP_SHOWINFO
bool DataPlotTreeNodeHelper::GetShowInfo( bool &bShow )
{
	TreeNode trShow = m_trDP.ShowInfo;
	ASSERT(trShow);
	if( !trShow )
		return false;
	bShow = trShow.nVal;
	return true;
}
///End FIX_CHANGE_PLOTTYPE_NOT_KEEP_SHOWINFO

///-----Kit 02/25/2011 ORG-2302-S1 MAKE_LEGEND_CAN_EDIT
bool DataPlotTreeNodeHelper::GetLegend(string &strLegend)
{
	TreeNode trLegend = m_trDP.Legend;
	if( !trLegend.IsValid() )
	{
		ASSERT(false);
		return false;
	}

	strLegend = trLegend.strVal;
	return true;
}

bool DataPlotTreeNodeHelper::SetLegend(LPCTSTR lpcszLegend)
{
	TreeNode trLegend = m_trDP.Legend;
	if( !trLegend.IsValid() )
	{
		ASSERT(false);
		return false;
	}

	trLegend.strVal = lpcszLegend;
		
	return true;
}
///-----End MAKE_LEGEND_CAN_EDIT

///-----Kit 03/01/2011 ORG-2319-P1 RUNTIME_ERROR_WHEN_GET_BOOK_SHEET_COL_TOOLTIP
bool DataPlotTreeNodeHelper::GetDPDescription(string &strDescription)
{
	return m_trDP.GetAttribute(STR_LABEL_ATTRIB, strDescription);
}
///-----End RUNTIME_ERROR_WHEN_GET_BOOK_SHEET_COL_TOOLTIP

///-----Kit 03/09/2011 ORG-2331-S4 SHOW_COL_DESIGNATION_ON_RIGHT_PANEL
bool DataPlotTreeNodeHelper::GetColNameWithDesig(string &strColNameWithDesig)
{	
	TreeNode trDPC = m_trPlotDesigs.DPC1;
	if( !trDPC.IsValid() )
		return false;
	
	int nPageType;
	if( !GetPageType(nPageType) )
	{
		ASSERT(false);
		return false;
	}

	if( EXIST_MATRIX == nPageType )
	{
		vector<string> vsColName;
		vector<uint> vuDesig;
		if( !GetColNameAndColDesignation(vsColName, vuDesig) )
		{
			ASSERT(false);
			return false;
		}
		
		ASSERT(vsColName.GetSize() > 0 );
		strColNameWithDesig = vsColName[0];
	}
	else
	{
		strColNameWithDesig = trDPC.Heading.strVal;
	}

	return true;
}

bool DataPlotTreeNodeHelper::GetDatasetName(string &strDSName)
{
	vector<string> vsColName;
	vector<uint> vuDesig;
	int nPageType;
	if( !GetColNameAndColDesignation(vsColName, vuDesig) || !GetPageType(nPageType) )
	{
		ASSERT(false);
		return false;
	}

	ASSERT(vsColName.GetSize() > 0);

	string strPage, strLayer;
	///-----Kit 04/21/2011 ORG-2690-P1 LAYER_PLOT_LIST_NEED_TO_SHOW_BOOK_LN_LIKE_DATASET_LIST
	//GetPageLayerName(strPage, strLayer);
	GetPageShortName(strPage);
	GetLayerName(strLayer);
	///-----End LAYER_PLOT_LIST_NEED_TO_SHOW_BOOK_LN_LIKE_DATASET_LIST
	
	Page pg(strPage);
	Datasheet ds = pg.Layers(strLayer);
	bool bRet = true;
	switch( nPageType )
	{
	case EXIST_WKS:
	case EXIST_EXTERN_WKS:
		{
			ASSERT(pg.IsValid() && !strLayer.IsEmpty());
			Worksheet wks = ds;
			
			ASSERT(wks.IsValid());
			Column col = wks.Columns(vsColName[0]);
			ASSERT( col.IsValid() );
			strDSName = col.GetDatasetName();
		}
		break;
	case EXIST_MATRIX:
		{
			ASSERT(pg.IsValid() && !strLayer.IsEmpty());
			MatrixLayer ml = pg.Layers(strLayer);
			ASSERT(ml.IsValid());
			MatrixObject mo = ml.MatrixObjects(vsColName[0]);
			strDSName = mo.GetDatasetName();
		}
		break;
	case EXIST_DATA:
		strDSName = vsColName[0];
		break;
	default:
		ASSERT(false);
		bRet = false;
		break;
	}

	return bRet;
}

bool DataPlotTreeNodeHelper::GetPlotTypeName(string &strPlotTypeName)
{
	TreeNode trPlotType = m_trDP.PlotType;
	
	if( !trPlotType.IsValid() )
		return false;

	strPlotTypeName = trPlotType.strVal;
	return true;
}

bool DataPlotTreeNodeHelper::GetColLongName(string &strColLongName)
{
	TreeNode trDPC = m_trPlotDesigs.DPC1;
	if( !trDPC.IsValid() )
		return false;
	
	strColLongName = trDPC.ColLN.strVal;	
	return true;
}

bool DataPlotTreeNodeHelper::GetPageType(int &nPageType)
{
	///-----Kit 04/21/2011 ORG-2690-P1 LAYER_PLOT_LIST_NEED_TO_SHOW_BOOK_LN_LIKE_DATASET_LIST
	/*
	string strPage, strLayer;
	GetPageLayerName(strPage, strLayer);
	if( strPage.IsEmpty() && strLayer.IsEmpty() )
	{
		nPageType = EXIST_DATA;
		return true;
	}
	*/
	string strPage;
	if( !GetPageShortName(strPage) || strPage.IsEmpty() )
	{
		nPageType = EXIST_DATA;
		return true;
	}
	///-----End LAYER_PLOT_LIST_NEED_TO_SHOW_BOOK_LN_LIKE_DATASET_LIST

	Page pg(strPage);
	if( !pg.IsValid() )
	{
		ASSERT(false);
		return false;
	}

	nPageType = pg.GetType();

	return true;
}
///-----End SHOW_COL_DESIGNATION_ON_RIGHT_PANEL

///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
bool	DataPlotTreeNodeHelper::init(const TreeNode& trDP)
{
	if( !trDP.IsValid() )
	{
		ASSERT(false);
		return error_report("pass a invalid DataPlot tree node to bool	DataPlotTreeNodeHelper::init()");
	}

	m_trDP = trDP;
	
	if(!trDP.PlotDesigs.IsValid())
	{
		ASSERT(false);
		return error_report("the DataPlot Tree does not has PlotDesigs tree node!!");
	}

	m_trPlotDesigs = trDP.PlotDesigs;
	return true;
}
///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN

/************************************************************************/
/* ---PlotTypeChangeHelper	                                            */
/************************************************************************/
bool PlotTypeChangeHelper::ChangePlotType()
{
	PlotInfo plotInfo;
	
	if( !getDPTreeInfo( plotInfo ) )
		return false;
	
	if( !_get_new_plot_info( m_nNewPlotID, m_nPageType, m_dwLayerBits, plotInfo ) )
		return false;
	
	Tree trPlot;
	if( !make_plot_tree( trPlot, plotInfo, DPEDTVIEW_REPLACE | DPEDTVIEW_HIDE_STYLEHOLDERS | DPEDTVIEW_HIDE_LIMITS) )
	{
		ASSERT( false );
		return false;
	}

	return changeDPTree( trPlot.FirstNode );
}

bool PlotTypeChangeHelper::getDPTreeInfo( PlotInfo &plotInfo )
{
	DataPlotTreeNodeHelper dpHelper( m_trDP );

	///-----Kit 04/21/2011 ORG-2690-P1 LAYER_PLOT_LIST_NEED_TO_SHOW_BOOK_LN_LIKE_DATASET_LIST
	//dpHelper.GetPageLayerName( plotInfo.strPageName, plotInfo.strLayerName );
	dpHelper.GetPageShortName(plotInfo.strPageName);
	dpHelper.GetLayerName(plotInfo.strLayerName);
	///-----End LAYER_PLOT_LIST_NEED_TO_SHOW_BOOK_LN_LIKE_DATASET_LIST

	dpHelper.GetPlotType( plotInfo.nPlotType );
	dpHelper.GetColNameAndColDesignation( plotInfo.vsColNames, plotInfo.vuColDesignations );
	dpHelper.GetAuxPlotInfo( plotInfo.dwAuxTypeInfo );
	dpHelper.GetLTPlotInfo( plotInfo.dwLTPlotInfo );
	dpHelper.GetRowRange( plotInfo.arrRangeRows );
	dpHelper.GetShowInfo( plotInfo.bShow); /// Iris 01/10/2011 FIX_CHANGE_PLOTTYPE_NOT_KEEP_SHOWINFO

	return true;
}

bool PlotTypeChangeHelper::changeDPTree( const TreeNode &trLayer )
{
	int nSuffix = 1;
	string strDataPlot = STR_DATAPLOT_NAME + nSuffix;
	
	TreeNode trDP = tree_get_node_by_tagname( trLayer, strDataPlot, true );
	if( !trDP.IsValid() )
	{
		ASSERT( false );
		return false;
	}

	TreeNode trCloneOldDP = m_trDP.Clone();
	if( !m_trDP.Replace( trDP, true, true ) )
		return false;

	///-----Kit 01/10/2011 STORGE_DP_TREE_INFO_AFTER_EDIT_TREE_NODE
// 	if( trCloneOldDP.PlotDesigs.DPPresentID.IsValid() && !m_trDP.PlotDesigs.DPPresentID.IsValid() )
// 	{
// 		TreeNode trOldDPPresentID = trCloneOldDP.PlotDesigs.DPPresentID;
// 
// 		TreeNode trPlotDesigs = m_trDP.PlotDesigs;
// 		ASSERT( trPlotDesigs.IsValid() );
// 
// 		trPlotDesigs.AddNode( trOldDPPresentID );
// 	}
	///-----End STORGE_DP_TREE_INFO_AFTER_EDIT_TREE_NODE
	m_trDP.DataID = trCloneOldDP.DataID;

	int nGroupID = 0;
	if( trCloneOldDP.GetAttribute( STR_GROUP_ID_ATTRIB, nGroupID ) )
	{
		m_trDP.SetAttribute( STR_GROUP_ID_ATTRIB, nGroupID );
	}

	trCloneOldDP.Remove();
	return true;
}

/************************************************************************/
/* ---PlotsControlHeaderMenu                                            */
/************************************************************************/
PlotsControlHeaderMenu::PlotsControlHeaderMenu( LayerPlotList* pPlotsCtrl )
{
	m_uChoice = -1;//PlotsCtrl_TotalCols - PlotsCtrl_HeaderFirst; ///Jasmine 12/23/10 ORG-1826-S3 HIDE_ROW_HEADER_TO_SAVE_SPACE
	
	string strItems = STR_PLOTS_CTRL_HEADER;
	vector<string> vs;
	strItems.GetTokens(vs, '|'); 
	vs.RemoveAt(0); // remove fixed column header text, it is empty string
	ASSERT( vs.GetSize() == PlotsCtrl_TotalCols - PlotsCtrl_HeaderFirst );
	
	///Jasmine 12/23/10 ORG-1826-S3 HIDE_ROW_HEADER_TO_SAVE_SPACE
	m_uOffset = 0;
	int nFlag = (pPlotsCtrl->GetColWidth(PlotsCtrl_FixCol) <= 0)? MF_CHECKED : MF_UNCHECKED;
	Add(STR_HIDE_FIX_COL, OnMenuItem, nFlag|MF_STRING|MF_BYCOMMAND, MENU_HIDE_FIX_COL_ID); 	m_uOffset++;
	Add(STR_COL_AUTO_WIDTH_MENU, OnMenuItem, MF_STRING, MENU_AUTO_SIZE_COL_ID);				m_uOffset++;
	Add(NULL, OnMenuItem, MF_SEPARATOR);													m_uOffset++;
	///End HIDE_ROW_HEADER_TO_SAVE_SPACE
	///Philip 09/18/2012 ORG-5346-P1 AVOID_HIDE_ALL_COLUMNS_IN_BROWSERS
	int nShow = 0;
	int nCols = pPlotsCtrl->GetCols();
	for(int ii = pPlotsCtrl->GetColOffset(); ii < nCols && nShow <= 1; ii++)
	{
		if(!pPlotsCtrl->IsColHidden(ii))
			nShow++;
	}
	ASSERT(nShow);
	bool bOnly1ColShown = (nShow == 1);
	///end AVOID_HIDE_ALL_COLUMNS_IN_BROWSERS
	for( int iCol = 0; iCol < vs.GetSize(); iCol++ )
	{
		UINT uFlag = MF_STRING; 
		int nCol = iCol + pPlotsCtrl->GetColOffset();
		///Philip 09/18/2012 ORG-5346-P1 AVOID_HIDE_ALL_COLUMNS_IN_BROWSERS
		//uFlag |= pPlotsCtrl->IsColHidden(nCol) ? MF_UNCHECKED : MF_CHECKED;
		bool isHidden = pPlotsCtrl->IsColHidden(nCol);
		uFlag |= isHidden ? MF_UNCHECKED : MF_CHECKED;
		///end AVOID_HIDE_ALL_COLUMNS_IN_BROWSERS
		///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
		int nColType = pPlotsCtrl->GetColType(nCol) - 1;//no Group column
		///Philip 09/18/2012 ORG-5346-P1 AVOID_HIDE_ALL_COLUMNS_IN_BROWSERS
		if(bOnly1ColShown && !isHidden)
			uFlag |= MF_DISABLED | MF_GRAYED;
		///end AVOID_HIDE_ALL_COLUMNS_IN_BROWSERS
		Add(vs[nColType], OnMenuItem, uFlag);
		///End SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
	}
}

bool PlotsControlHeaderMenu::GetSel( UINT& uChoice )
{
	if( isSelOnValidColumHeader() )
	{
		uChoice = m_uChoice;
		return true;
	}
	return false;
}

bool PlotsControlHeaderMenu::isSelOnValidColumHeader()
{
	int nValidColBegin = 0;
	int nNumValidCols = PlotsCtrl_TotalCols - PlotsCtrl_HeaderFirst;
	int nValidColEnd = nValidColBegin + nNumValidCols;

	return ( nValidColBegin <= m_uChoice && m_uChoice < nValidColEnd );
}

/************************************************************************/
/* ---PlotsGridMenu                                    				    */
/************************************************************************/
PlotsGridMenu::PlotsGridMenu(LayerPlotList* pPlotsCtrl, const Menu& subMenu, const Menu& subMenuPlotType)///Jasmine 12/23/10 ORG-1826-S6 BATCH_CHANGE_PLOT_TYPE
{	
	m_nChoice = -1;
	///Jasmine 12/29/10 ORG-1826-S1-3 COL_AUTO_WIDTH
	Add(STR_COL_AUTO_WIDTH_MENU, OnMenuItem, MF_STRING, MENU_AUTO_SIZE_COL_ID);
	Add(NULL, OnMenuItem, MF_SEPARATOR);
	///End COL_AUTO_WIDTH
	AddPopup(_L("Change Plot Type"), subMenuPlotType);///Jasmine 12/23/10 ORG-1826-S6 BATCH_CHANGE_PLOT_TYPE

	AddPopup(_L("Move to"), subMenu);
}

bool PlotsGridMenu::GetSel(uint& nChoice)
{
	if( m_nChoice < 0 ) 
		return false; 
	nChoice = m_nChoice; 
	return true;
}
	
/************************************************************************/
/* ---PlotsGridMoveToMenu                              				    */
/************************************************************************/
PlotsGridMoveToMenu::PlotsGridMoveToMenu(LayerPlotList* pPlotsCtrl)
{
	m_nChoice = -1;
	
	if( pPlotsCtrl )
	{
		vector<uint> vuSelRows;
		/// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
		//if( pPlotsCtrl->GetSelRows(vuSelRows) && vuSelRows.GetSize() > 0 )
		if( pPlotsCtrl->GetSelRowsEx(vuSelRows) && vuSelRows.GetSize() > 0 )
		///End TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
		{
			//int nSelRow = vuSelRows[0]; // only keep care of the first selection
			UINT nDefaultFlags = MF_STRING;
			if( vuSelRows.GetSize() > 1 && !check_vector_increment((vector)vuSelRows, 1) ) // if the selection is discontiguous, move to menu will be disable
				nDefaultFlags |= MF_GRAYED | MF_DISABLED;
			
			UINT nFlags;
			int nCmd = PLOTGRID_MOVETO + MOVETO_SUBMENU_BEGIN;		
			
			bool bIsFirst = vuSelRows[0] == pPlotsCtrl->GetRowOffset();
			bool bIsLast = vuSelRows[vuSelRows.GetSize()-1] == pPlotsCtrl->GetRows()-1;
			
			nFlags = bIsFirst ? nDefaultFlags | MF_GRAYED | MF_DISABLED : nDefaultFlags;
			Add(_L("Previous"), OnMenuItem, nFlags, nCmd++);
			
			nFlags = bIsLast ? nDefaultFlags | MF_GRAYED | MF_DISABLED : nDefaultFlags;
			Add(_L("Next"), OnMenuItem, nFlags, nCmd++);
			
			Add(NULL, OnMenuItem, MF_SEPARATOR); // seperator
			nFlags = bIsFirst ? nDefaultFlags | MF_GRAYED | MF_DISABLED : nDefaultFlags;			
			Add(_L("Top"), OnMenuItem, nFlags, nCmd++);			
			
			nFlags = bIsLast ? nDefaultFlags | MF_GRAYED | MF_DISABLED : nDefaultFlags;
			Add(_L("Bottom"), OnMenuItem, nFlags, nCmd++);			
			
			
			int nGroupNum = pPlotsCtrl->GetGroupNum();
			if( nGroupNum != 0 )
			{
				Add(NULL, OnMenuItem, MF_SEPARATOR); // seperator
				
				bool bIsSelectedGroupRow;
				for(int index = 0; index < vuSelRows.GetSize(); index++)
				{
					if( !pPlotsCtrl->GetCell(vuSelRows[index], pPlotsCtrl->GetColPos(PlotsCtrl_Group)).IsEmpty() )
					{
						bIsSelectedGroupRow = true;
						break;
					}
				}
				
				ASSERT( nGroupNum <= MOVETO_SUBMENU_GROUP_END - MOVETO_SUBMENU_GROUP_BEGIN);
				for(index = 0; index < nGroupNum; index++)
				{		
					string str = STR_GROUP_PREFIX + (index+1);
					nFlags = MF_STRING;
					if( bIsSelectedGroupRow )
						nFlags |= MF_GRAYED | MF_DISABLED;
					
					Add(str, OnMenuItem, nFlags, nCmd++);
				}
			}
			
		}
	}
}

bool PlotsGridMoveToMenu::GetSel(uint& nChoice, int nSelCmd)
{
	int nCmd = nSelCmd - PLOTGRID_MOVETO;
	if(nCmd >= MOVETO_SUBMENU_BEGIN && nCmd < MOVETO_SUBMENU_END)
	{
		nChoice = nCmd;
		return true;
	}		
	return false;
}

///Jasmine 12/23/10 ORG-1826-S6 BATCH_CHANGE_PLOT_TYPE
void PlotsGridPlotTypeMenu::PlotsGridPlotTypeMenu(LayerPlotList* pPlotsCtrl)
{
	m_nChoice = -1;
	
	vector<uint> vuSelRows;
	/// Iris 12/27/2010 TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
	//if( !pPlotsCtrl->GetSelRows(vuSelRows) )
	if( !pPlotsCtrl->GetSelRowsEx(vuSelRows) )
	///End TO_UNSELECTED_PLOTS_IN_GROUP_AFTER_SEL_ROW_CHANGE
		return;
			
	vector<string> vsPlotType;
	int nSize = pPlotsCtrl->GetPlotTypeList( vsPlotType, GET_DATAPLOT_INDEX_FROM_SEL_ROW(vuSelRows[0]) );	
	m_nBegin= PLOTGRID_PLOT_TYPE + 1;//offset
	m_nEnd 	= PLOTGRID_PLOT_TYPE + nSize;
	
	for(int ii = 0; ii< nSize; ii++)
	{
		Add(vsPlotType[ii], PLOTGRID_PLOT_TYPE+ii+1);
	}
}

bool PlotsGridPlotTypeMenu::GetSel(uint& nChoice, int nSelCmd)
{
	if(nSelCmd >= m_nBegin && nSelCmd <= m_nEnd)
	{
		nChoice = nSelCmd - PLOTGRID_PLOT_TYPE - 1;
		return true;
	}		
	return false;
}
///End BATCH_CHANGE_PLOT_TYPE


///-----Kit 12/23/2010 ORG-1826-S5 FOLLOW_TEMPLATE_WHEN_ADDING_DATA_TO_RIGHT_PANEL
/************************************************************************/
/* StyleHolderHelper                                                    */
/************************************************************************/
StyleHolderHelper::StyleHolderHelper()
{
	m_nCurrentStyleHolderIndex = 0;
}

bool StyleHolderHelper::Init( const GraphLayer &gl, int nCurrentStyleHolder )
{
	if( !gl.IsValid() )
		return false;

	m_nCurrentStyleHolderIndex = nCurrentStyleHolder;
	
	if( !gl.GetLayerContents( m_trStyleHolder, GETLC_STYLE_HOLDERS ) )
		return false;
	  
	const string strStyleHolder = "StyleHolder";
	TreeNodeCollection collStyleHolder( m_trStyleHolder.FirstNode, strStyleHolder );
		m_colltrStyleHolder = collStyleHolder;
	///-----Kit 01/06/2011 ORG-1879-P1 ALWAYS_READ_THE_FIRST_STYLE_HOLDER_PLOT_ID
	//!!!!!!!!!!!!!!!!!!!!!01/06/2011!!!!!!!!!!!!!!!!!!!
	// Now just use the first style holder plot id, for temporary, don't use m_colltrStyleHolder and m_nCurrentStyleHolderIndex
	// to get the style holder tree.
	
// 	if( collStyleHolder.Count() == 0 && m_trStyleHolder.FirstNode.Group )
// 	{
// 		TreeNodeCollection collGroupStyleHolder( m_trStyleHolder.FirstNode.Group, strStyleHolder );
// 		m_colltrStyleHolder = collGroupStyleHolder;
// 	}
// 	else
// 	{
// 		m_colltrStyleHolder = collStyleHolder;
// 	}
// 
// 	m_colltrStyleHolder = collStyleHolder;
// 	
// 	return ( m_colltrStyleHolder.Count() == 0 );

	///-----End ALWAYS_READ_THE_FIRST_STYLE_HOLDER_PLOT_ID

	return true;
}

bool StyleHolderHelper::GetCurrentStyleHolderPlotID( int &nStyleHolderPlotID )
{
	///-----Kit 01/06/2011 ORG-1879-P1 ALWAYS_READ_THE_FIRST_STYLE_HOLDER_PLOT_ID
	//if( 0 == m_colltrStyleHolder.Count() )  
		//return false;

	///// Iris 12/31/2010 ORG-1879 ADD_AUTO_PLOTTYPE_IN_PLOTTYPE_BMP_BUTTON
	////if( m_colltrStyleHolder.Count() <= m_nCurrentStyleHolderIndex )
	////	return false;
	//// If selected Auto plot type and template is Box, we allow plot multiple box in one layer, 
	//// so if m_nCurrentStyleHolderIndex > style holder number, index can be 0.

	//if( m_nCurrentStyleHolderIndex >= m_colltrStyleHolder.Count() )
	//	m_nCurrentStyleHolderIndex = 0;

	/////End ADD_AUTO_PLOTTYPE_IN_PLOTTYPE_BMP_BUTTON
	///-----End ALWAYS_READ_THE_FIRST_STYLE_HOLDER_PLOT_ID
	int nPlotType = 0;
	DWORD dwAuxPlotInfo = 0, dwLTPlotInfo = 0;
	getPlotInfo( nPlotType, dwAuxPlotInfo, dwLTPlotInfo );

	int nPlotID = ConvertPlotIds( nPlotType, &dwAuxPlotInfo, &dwLTPlotInfo );

	if( nPlotID < 0 )
	{
		ASSERT( false );
		return false;
	}

	nStyleHolderPlotID = nPlotID;
	return true;
}

bool StyleHolderHelper::SetCurrentStyleHolderIndex( int nCurrentStyleHolderIndex )
{
	m_nCurrentStyleHolderIndex = nCurrentStyleHolderIndex;
	return true;
}

bool StyleHolderHelper::getPlotInfo( int &nPlotType, DWORD &dwAuxPlotInfo, DWORD &dwLTPlotInfo )
{
	//ASSERT( m_colltrStyleHolder.Count() > m_nCurrentStyleHolderIndex );

	///-----Kit 01/06/2011 ORG-1879-P1 ALWAYS_READ_THE_FIRST_STYLE_HOLDER_PLOT_ID
	//!!!!!!!!!!!!!!!!!!01/06/2011!!!!!!!!!!!!!!!!!!
	// When the style holder tree have Group node and style holder node in the same tree node level, 
	// we cannot reliably be determined how to select the style holder plot id. So just use the first
	// style holder in the tree for temporary.

	//TreeNode trStyleHolder = m_colltrStyleHolder.Item( m_nCurrentStyleHolderIndex );
	LPCTSTR lpcszFirstStyleHolder = "StyleHolder1";
	TreeNode trStyleHolder = tree_get_node_by_tagname( m_trStyleHolder.FirstNode, lpcszFirstStyleHolder, true );
	///-----End ALWAYS_READ_THE_FIRST_STYLE_HOLDER_PLOT_ID
	
	if( !trStyleHolder.IsValid() )
		return false;

	DataPlotTreeNodeHelper dpHelper( trStyleHolder );

	if( !dpHelper.GetPlotType( nPlotType ) 
		|| !dpHelper.GetAuxPlotInfo( dwAuxPlotInfo )
		|| !dpHelper.GetLTPlotInfo( dwLTPlotInfo ) )
	{
		ASSERT( false );
		return false;
	}

	return true;
}
///-----End FOLLOW_TEMPLATE_WHEN_ADDING_DATA_TO_RIGHT_PANEL

///-----Kit 02/25/2011 ORG-2319-S1 SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW
/************************************************************************/
/* SetPlotListToolTipHelper												*/
/************************************************************************/
// virtual
bool SetPlotListToolTipHelper::GetRowToolTip(int nRow, string &strToolTip)
{
	LayerPlotList *pPlotList = (LayerPlotList*)m_pGridList;
	if( NULL == pPlotList )
	{
		ASSERT(false);
		return false;
	}
	
	if( !pPlotList->GetDataPlotDescription(GET_DATAPLOT_INDEX_FROM_SEL_ROW(nRow), strToolTip) )
		return false;

	return true;
}
///-----End SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW
