/*------------------------------------------------------------------------------*
 * File Name:InsertUserVar.h													*
 * Creation:  																	*
 * Purpose: OriginC header file for declaration of  One Way ANOVA operation 	*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
 *	Kyle 08/26/2009 INSERT_MULTIPLE_TIMES_FOR_SCV								*
 *	Kenny 09/01/2009 QA81-14241 DEFINE_VARIABLE_MENU_WANTED						*
 *	Sophy 9/9/2009 INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG
 *	Folger 09/21/09 QA80-14283 GET_RID_OF_ONSELECTIONCHANGE_EVENT_DURING_GRID_ATTACH
 *------------------------------------------------------------------------------*/
 
#include <o8dlg.h>

#ifndef _INSERT_USER_VAR_
#define	_INSERT_USER_VAR_

#define	WM_USER_VARIABLE_CLICK_INSERT		(WM_USER + 1300)				///Kyle 08/26/2009 INSERT_MULTIPLE_TIMES_FOR_SCV


// open Insert Info Variables dialog and return str to insert
// *lpType = 0 if insert as is, =1 if insert as link
bool InsertUserVar(HWND hWndParent, string& str, int* lpType = NULL);

#ifdef SET_VALUES_SUPPORT_DEFINE_VARIBLE
enum
{
	///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
	//// 8 bits for filter out tree nodes
	//INSERT_INFO_INFO_FILTER_BITS				= 0x00FF,
	//INSERT_INFO_FILTER_FILE_INFO				= 0x0001,
//
	//INSERT_INFO_INSERT_TO_CELL					= 0x0100,
	INSERT_INFO_VAL_FORMAT_TEXT_OBJECT			= 0,					//
	INSERT_INFO_VAL_FORMAT_CELL,										//
	INSERT_INFO_VAL_FORMAT_LT,											//
	INSERT_INFO_VAL_FORMAT_MARK					= 0x000F,

	INSERT_INFO_INFO_FILTER_BITS				= 0x0FF0,
	INSERT_INFO_FILTER_FILE_INFO				= 0x0010,
	
	INSERT_INFO_ENABLE_VAR_TYPE					= 0x1000,
	INSERT_INFO_ENABLE_PROJECT_TREE				= 0x2000,
	INSERT_INFO_ENABLE_PROP_VAL_PAIR			= 0x4000,
	
	INSERT_INFO_MULTI_INSERT					= 0x8000,			///Kyle 08/26/2009 INSERT_MULTIPLE_TIMES_FOR_SCV
	///End SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
	/// Kenny 09/01/2009 QA81-14241 DEFINE_VARIABLE_MENU_WANTED
	INSERT_INFO_OPEN_LABEL_TAB					= 0x00010000,
	/// End QA81-14241 DEFINE_VARIABLE_MENU_WANTED
	INSERT_INFO_OPEN_TAB_ON_REG					= 0x00020000,		///Jasmine 07/23/2012 ORG-5458-S2 ACTIVATE_LABEL_TAB_BY_DEFAULT
};

/**$
		Get page info
		Parameters:
			str 					= [output] string value
			lpType 					= [output] value type, 1: link, 0: value
			dwCtrl					= [input]  see INSERT_INFO_*
			pbDisableLinkAndDefType = [input] if not NULL, will disable link btn, and use *pbDisableLinkAndDefType as the link type
			hWndParent				= [input] 
		Return:
			return TRUE for success, FALSE for failure

*/
///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
//bool InsertUserVarEx(string& str, int* lpType, DWORD dwCtrl = 0, bool* pbDisableLinkAndDefType = NULL, HWND hWndParent = NULL);
///Sophy 9/9/2009 INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG
//bool InsertUserVarEx(string& str, int* lpType, vector<uint>* pvnDataTypes, DWORD dwCtrl = 0, bool* pbDisableLinkAndDefType = NULL, HWND hWndParent = NULL);
bool InsertUserVarEx(string& str, int* lpType, vector<uint>* pvnDataTypes, DWORD dwCtrl = 0, bool* pbDisableLinkAndDefType = NULL, HWND hWndParent = NULL, UINT colUID = 0);
///end INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG
///End SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE

#endif // SET_VALUES_SUPPORT_DEFINE_VARIBLE


#endif //_INSERT_USER_VAR_