/*------------------------------------------------------------------------------*
 * File Name:InsertUserVar.c	 												*
 * Creation: CPY																*
 * Purpose: OriginC Source C file for Insert User Variables dialog				*
 * Copyright (c) Originlab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 12/31/03 v7.5793 MAKE_RESIZABLE											*			
 *  SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H					*
 *	EJP 2005-03-31 v8.0214 QA70-6816 SHOW_IMPORT_FILE_INFO_IN_USER_VAR_DLG		*
 *	Jasmine 12/21/06 STR_VAR_VAL_SEP											*
 *	Jasmine 01/15/07 QA70-9269 INSERT_TO_CELL_AS_LINK							*
 *	Jasmine 01/17/07 QA70-9273 SHOW_USER_TREE_INFO_IN_USER_VAR_DLG				*
 *	Jasmine 01/17/07 CONVERT_VARIABLES_STRING									*
 *	Jasmine 03/22/07 SEPARATE_OBJ_LEVEL_AND_TREE_SHOW_LEVEL						*
 *	Jasmine 03/22/07 ADD_RANGE_EDIT_BOX											*
 *	Jasmine 03/22/07 MODIFICATION_ON_GET_PROJECT_TREE							*
 *	Folger 07/19/07 FIXED_BUGS_IN_DIALOG_RESIZE									*
 *	Jasmine 05/08/08 RESTRICT_INSERT_VAR_DLG_MIN_WIDTH							*
 *	Kyle 06/26/2009 INSERT_INFO_SUPPORT_FILTER_TREE_NODES_AND_DISABLE_INSERT_AS_LINK_BTN
 *	Kyle 07/06/2009 FOLDER_TREE_KEEP_LAST_SHOWING_LEVEL							*
 *	Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
 *	Kyle 08/26/2009 QA80-14190 DEFINE_VARIABLE_FROM_COLUMN_LABELS_IN_SCV_DB		*
 *	Kyle 08/26/2009 INSERT_MULTIPLE_TIMES_FOR_SCV								*
 *	Kyle 08/27/2009 QA80-14213 HIDE_INSERT_MODE_FOR_INSERT_VARIABLE_WKS_CELL_TEXT_OBJECT
 *	Kyle 08/27/2009 QA80-14213 CHECK_INSERT_AS_LINK_BY_DEFAULT					*
 *	Kyle 08/27/2009 QA80-14210 FIX_EMBEDDED_GRAPHS_HAS_NO_FOLDER				*
 *	Kyle 08/27/2009 QA80-14210 CLEAN_CODE_TO_FIX_RUNTIME_ERROR_WHEN_TREE_INVALID*
 *	Kenny 09/01/2009 QA81-14241 DEFINE_VARIABLE_MENU_WANTED						*
 *	Kenny 09/03/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS			*
 *	Sophy 9/3/2009 QA80-14241 CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
 *	Sophy 9/4/2009 QA80-14241 INSERT_MODE_SUPPORT_NAME_INDEX_ON_LAYER_AND_OBJ_LEVEL
 *	Sophy 9/9/2009 WRONG_EXPRESSION_WHEN_INSERT_NUMERIC_COL_COMMENTS_LABEL_AS_STRING
 *	Sophy 9/9/2009 INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG
 *	Sophy 9/9/2009 MORE_WORK_ON_REMEMBER_LAST_SETTINGS_OF_INSERTVAR_DLG			*
 *	Sophy 9/17/2009 SMART_PAGE_NAME_WHEN_INSERT_VAR_INFO_IN_SAME_PAGE			*
 *	Folger 09/21/09 QA80-14283 GET_RID_OF_ONSELECTIONCHANGE_EVENT_DURING_GRID_ATTACH
 *	Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES						*
 *	Kyle 11/26/2009 FIND_FUNCTION_MAKES_MOUSE_FLASHING_BECAUSE_OF_WAIT_CURSOR	*
 *	Jasmine 12/14/09 QA81-14845 NO_ASSERT_IF_UID_NOT_PROVIDE					*
 * 	Jasmine 12/14/09 QA81-14845-P2 MAKE_TREE_SIMPLIER_TO_SEARCH					*
 *	Jasmine 12/14/09 QA81-14845-P3 ACCESS_FILE_INFO_WITH_PLOT_NOTATION			*
 *	Jasmine 12/16/09 QA81-14845-P4 SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
 *	Kenny 12/19/2009 QA81-14845-P5 INSERT_USER_VAR_DLG_FOR_GOBJECT_SHOULD_NOT_CLOSE_ON_INSERT*
 *	Kenny 12/22/2009 QA81-14748-P2 INSERT_USER_VAR_DLG_FAILS_TO_SHOW_MULTILINE_NODE*
 *	Jasmine 12/14/09 QA81-14845-P3 ACCESS_FILE_INFO_WITH_PLOT_NOTATION			*
 *	Jasmine 12/28/09 QA81-14845-S1 ACCESS_SOURCE_BOOK_SHEET_COLUMN_FROM_PLOT	*
 *	Jasmine 01/07/10 QA81-14845-S2 INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET		*
 *	Kyle 01/15/2010 QA80-14970 SUPPORT_DATE_DISPLAY_IN_TREE_EDITOR				*
 *	Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
 *	Kyle 02/02/2010 QA80-15056 NEED_INSERT_LABEL_FOR_TEXT_OBJECT				*
 *	Kyle 02/04/2010 READ_SHEET_INPORT_FILE_INFO									*
 *	Jasmine 02/08/10 USER_NOT_USE_CUSTOM_FMT_MOSTLY								*
 *	Kenny 02/23/2010 QA81-14845-P8 INSERT_VAL_FAILS_TO_INSERT_VAR_IN_INPLACE_EDIT_OF_RICH_TEXT_CELL*
 *	Kenny 04/27/2010 QA80-15357 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID	*
 *	Kenny 6/23/2010 ORG-127-S1 ADD_HINT_TO_GUIDE_USAGE_OF_DISPLAY_FORMAT_OF_LABEL_FORM*
 *	Bill 02/23/2011 ORG-2261-S2 CHECK_VERBATIM_IN_THE_INSERT_VARIABLE_DIALOG	*
 *	Sophy 7/4/2011 ORG-3189-P1 NEED_PROPER_POSITION_DIALOG_CONTROL_ON_120_DPI_SETTINGS
 *	Sophy 7/27/2011 ORG-3189-P2 NEED_PROPER_POSITION_DIALOG_CONTROL_ON_120_DPI_SETTINGS
 *	Folger 05/08/2012 ORG-5627-P3 ORIGIN_CRASH_IF_WXGRID_TREE_WITH_MANY_ICONS	*
 *	Jasmine 06/11/2012 ORG-5458-S1 INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION	*
 *	Jasmine 06/12/2012 ORG-5458-S1 RESTRUCTURE_PLOT_TREE_FOR_INSERT_VAR_DB		*
 *	Jasmine 07/12/2012 ORG-5458-P1 PLOT_INDEX_NOT_WORK_FOR_FILE_INFO			*
 *	Tony 07/13/2012 ORG-5387-P1 ADD_DATAOBJECT_SHORTNAME_ATTRIBUTE				*
 *	Jasmine 07/19/2012 ORG-5458-S1 ADD_OBJ_NAME_TO_IDENTIFY_EACH_NODE			*
 *  Junon 06/08/2012 ORG-4042-P8 ORIGIN_WINDOW_FLICKERS_FREQUENTLY_WHEN_RESIZING  *
 *------------------------------------------------------------------------------*/
#include <Origin.h>
#include <xfutils.h>
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///	#include <Dialog.h>
///	#include "ResizeDialog.h"
#include "DialogEx.h"     // Dialog class
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
#include <TreeEditor.h>
/// Kenny 09/11/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
#include <event_utils.h>
/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS

///Kyle 06/26/2009 INSERT_INFO_SUPPORT_FILTER_TREE_NODES_AND_DISABLE_INSERT_AS_LINK_BTN
#ifdef SET_VALUES_SUPPORT_DEFINE_VARIBLE
#include "InsertUserVar.h"
#endif // SET_VALUES_SUPPORT_DEFINE_VARIBLE
///End INSERT_INFO_SUPPORT_FILTER_TREE_NODES_AND_DISABLE_INSERT_AS_LINK_BTN
#include "GridControl.h"
#define STR_VAR_VAL_SEP				"|=|"	
///Jasmine 01/17/07 QA70-9273 SHOW_USER_TREE_INFO_IN_USER_VAR_DLG
#define STR_DLG_NAME				_L("Insert Variables")
#define	DEFAULT_RIGHT_PANE_WIDTH	250
#define	MIN_MAIN_DLG_WIDTH			600

#define STR_INSERT_VARIABLE_COL_LABEL_ATTRIB		"InsertVarColLabel"		///Kyle 02/02/2010 QA80-15056 NEED_INSERT_LABEL_FOR_TEXT_OBJECT

///Sophy 9/3/2009 QA80-14241 CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
//enum{PT_SHOW_PAGE, PT_SHOW_LAYER, PT_SHOW_OBJECT, PT_SHOW_LAST_ITEM};
enum{
	PT_SHOW_PAGE, 
	PT_SHOW_LAYER, 
	PT_SHOW_OBJECT, 
		PT_SEPARATOR, 
	PT_SHOW_FULL_RANGE, 
	///Jasmine 01/07/10 QA81-14845-S2 INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET
		PT_SEPARATOR2, 
	PT_GO_TO_FILE_INFO, 
	///End INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET
	PT_SHOW_LAST_ITEM
};
///end CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE

///Sophy 9/9/2009 MORE_WORK_ON_REMEMBER_LAST_SETTINGS_OF_INSERTVAR_DLG
/// Kenny 09/11/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS, moved to event_utils.h
//#define	STR_INSERTMODE				"InsertMode"
/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
#define	STR_PROJECT_TREE_CTRL		"ProjectTreeControl"
///end MORE_WORK_ON_REMEMBER_LAST_SETTINGS_OF_INSERTVAR_DLG

/// Kenny 09/01/2009 QA81-14241 DEFINE_VARIABLE_MENU_WANTED
enum	// Tab
{
	TAB_INFO,
	TAB_LABEL,
};

#define STR_TAB_INFO								_L("Info")
#define STR_TAB_LABEL								_L("Label")
/// End QA81-14241 DEFINE_VARIABLE_MENU_WANTED

///Jasmine 06/11/2012 ORG-5458-S1 INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
#define	STR_REG_LINK_WITH			"LinkWith"
enum{
	INSERT_LINK_WITH_PLOT_INDEX = 0,
	INSERT_LINK_WITH_COL_INDEX
};
///End INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION

#define STR_REG_INSERT_TAB			"_CurSelTab"		///Jasmine 07/23/2012 ORG-5458-S2 ACTIVATE_LABEL_TAB_BY_DEFAULT

///Sophy 9/4/2009 QA80-14241 INSERT_MODE_SUPPORT_NAME_INDEX_ON_LAYER_AND_OBJ_LEVEL
/// Kenny 09/11/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS, moved to event_utils.h
// enum {
// 	INSERT_MODE_NAME	= 0,
// 	INSERT_MODE_INDEX	= 1,
// };
/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
///end INSERT_MODE_SUPPORT_NAME_INDEX_ON_LAYER_AND_OBJ_LEVEL
///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
enum
{
	VAR_TYPE_AUTO,
	VAR_TYPE_NUMERIC_DOUBLE,
	VAR_TYPE_NUMERIC_INT,
	VAR_TYPE_STRING,
};
///End SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
			
///Jasmine 01/07/10 QA81-14845-S2 INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET
struct PTreeMenuControl
{
	DWORD 	dwPTCtrl;
	int		nShowingLevel;
	int		nLimitToLevel;
	int		nNodeLevel;
};
///End INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET
class PTreeMenu : public Menu
{
public:
	///Sophy 9/3/2009 QA80-14241 CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
	//PTreeMenu(int nLevel)
	//PTreeMenu(int nLevel, DWORD dwCtrl = PT_CTRL_SHOW_FULL_RANGE, int nLimitToLevel = -1)
	PTreeMenu(PTreeMenuControl menuCtrl)
	///end CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
	{
		ASSERT(-1 == menuCtrl.nLimitToLevel || menuCtrl.nShowingLevel == menuCtrl.nLimitToLevel);
		
		m_nChoice = -1;
		/// Kenny 09/03/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		vector<int> 	vnIDs = {PTL_PAGE, PTL_LAYER, PTL_OBJ};
		vector<string> 	vsItems;
		vsItems.SetSize( vnIDs.GetSize() );
		int ii = 0 ;
		vsItems[ii]		= _L("Show Book Level");
		vsItems[++ii] 	= _L("Show Sheet Level");
		vsItems[++ii] 	= _L("Show Column Level");
		
		for(ii = 0; ii < vsItems.GetSize(); ii++)
		{
			int nFlag = MF_STRING | (menuCtrl.nShowingLevel == vnIDs[ii] ? MF_CHECKED: MF_UNCHECKED);
			if(menuCtrl.nLimitToLevel != -1 && menuCtrl.nLimitToLevel != vnIDs[ii])
				nFlag |= MF_DISABLED|MF_GRAYED;
			Add(vsItems[ii], OnMenuItem,  nFlag);
		}
		/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		///Sophy 9/3/2009 QA80-14241 CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
		Add(NULL, OnMenuItem, MF_SEPARATOR);
		Add(_L("Show Full Range"), OnMenuItem, menuCtrl.dwPTCtrl & PT_CTRL_SHOW_FULL_RANGE ? MF_CHECKED : MF_UNCHECKED);
		///end CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
		///Jasmine 01/07/10 QA81-14845-S2 INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET
		Add(NULL, OnMenuItem, MF_SEPARATOR);
		Add(_L("Go to File Info"), OnMenuItem, menuCtrl.nNodeLevel > PTL_PAGE? MF_ENABLED : MF_GRAYED | MF_DISABLED);
		///End INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET
	}
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= PT_SHOW_PAGE && m_nChoice <= PT_SHOW_LAST_ITEM)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
private:
	int	m_nChoice;
};
///End SHOW_USER_TREE_INFO_IN_USER_VAR_DLG

///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
///Sophy 9/9/2009 WRONG_EXPRESSION_WHEN_INSERT_NUMERIC_COL_COMMENTS_LABEL_AS_STRING
//static int _check_convert_data_type(string& strLink, int nVarType, int nDataType)
static void _update_label_notation(string& strLink)
{
	int nSheetRangeEnd = strLink.Find('!');
	if ( nSheetRangeEnd > 0 )
	{
		string strSheetRange = strLink.Left(nSheetRangeEnd);
		int nColNameBegin = strLink.Find('(', nSheetRangeEnd);
		int nColNameEnd = strLink.Find(')', nColNameBegin);
		string strColRange = strLink.Mid(nColNameBegin + 1, nColNameEnd - nColNameBegin - 1);
		int nLabelNameBegin = strLink.Find('[', nColNameEnd);
		int nLabelNameEnd = strLink.Find(']', nLabelNameBegin);
		string strLabel = strLink.Mid(nLabelNameBegin + 1, nLabelNameEnd - nLabelNameBegin - 1);
		strLink.Format("%s, %s, %s", strSheetRange, strColRange, strLabel);
	}
	strLink = "%(" + strLink + ")";
}
static int _check_convert_data_type(string& strLink, int nVarType, int nDataType, bool bColLabel)
///end WRONG_EXPRESSION_WHEN_INSERT_NUMERIC_COL_COMMENTS_LABEL_AS_STRING
{
	switch(nVarType)
	{
	case VAR_TYPE_NUMERIC_DOUBLE:
	case VAR_TYPE_NUMERIC_INT:
		///Sophy 9/9/2009 WRONG_EXPRESSION_WHEN_INSERT_NUMERIC_COL_COMMENTS_LABEL_AS_STRING
		//if(nDataType == TRGP_STR)
		if(nDataType == TRGP_STR && !bColLabel)
		///end WRONG_EXPRESSION_WHEN_INSERT_NUMERIC_COL_COMMENTS_LABEL_AS_STRING
		{
			int nIndex = strLink.Find("$");
			if(nIndex >= 0)
				strLink.Delete(nIndex);
		}
		else if ( bColLabel )
		{
			_update_label_notation(strLink);
		}
		if(nVarType == VAR_TYPE_NUMERIC_DOUBLE)
			nDataType = TRGP_DOUBLE;
		else
			nDataType = ONODETYPE_EDIT_BOX_NUMERIC_INT;
		break;
		
	case VAR_TYPE_STRING:
		///Sophy 9/9/2009 WRONG_EXPRESSION_WHEN_INSERT_NUMERIC_COL_COMMENTS_LABEL_AS_STRING
		//if(nDataType != TRGP_STR)
		/// Kenny 12/22/2009 QA81-14748-P2 INSERT_USER_VAR_DLG_FAILS_TO_SHOW_MULTILINE_NODE
		//if(nDataType != TRGP_STR && !bColLabel)
		if( !IS_TEXT_NODE_ID(nDataType) && !bColLabel)
		/// End QA81-14748-P2 INSERT_USER_VAR_DLG_FAILS_TO_SHOW_MULTILINE_NODE
		///end WRONG_EXPRESSION_WHEN_INSERT_NUMERIC_COL_COMMENTS_LABEL_AS_STRING
			strLink = "$(" + strLink + ")";
		nDataType = TRGP_STR;
		break;
		
	case VAR_TYPE_AUTO:
		///Sophy 9/9/2009 WRONG_EXPRESSION_WHEN_INSERT_NUMERIC_COL_COMMENTS_LABEL_AS_STRING
		if ( bColLabel && nDataType == TRGP_DOUBLE )
		{
			_update_label_notation(strLink);
		}
		///Sophy 6/24/2010 ORG-394-P1 FAIL_TO_INSERTVAR_OF_HEADER_NAME_WITH_AUTO_TYPE
		else if ( nDataType == ONODETYPE_BUTTON_FILE_PATH )
		{
			nDataType = TRGP_STR;
		}
		///end FAIL_TO_INSERTVAR_OF_HEADER_NAME_WITH_AUTO_TYPE
		///end WRONG_EXPRESSION_WHEN_INSERT_NUMERIC_COL_COMMENTS_LABEL_AS_STRING
		break;

	}
	return nDataType;
}
///End SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE

///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
static bool _is_node_numeric(int nDataType)
{
	switch(nDataType)
	{
	case ONODETYPE_EDIT_BOX_NUMERIC_FLOAT:
	case ONODETYPE_EDIT_BOX_NUMERIC_UINT:
	case ONODETYPE_EDIT_BOX_NUMERIC_INT:
	case ONODETYPE_DROPDOWN_NUMERIC_FLOAT:
		return true;
	}
	return false;
}
///End SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT

///Kyle 08/26/2009 QA80-14190 DEFINE_VARIABLE_FROM_COLUMN_LABELS_IN_SCV_DB
class UserVarConstructHelper
{
public:
	///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
	//UserVarConstructHelper(LPCSTR lpcszObj, LPCSTR lpcszObjLevelStr, int nNodeLevel, bool bUseLink, bool bPropValPair, int nValFormat = INSERT_INFO_VAL_FORMAT_TEXT_OBJECT, int nVarType = VAR_TYPE_AUTO)
	/// Bill 02/23/2011 ORG-2261-S2 CHECK_VERBATIM_IN_THE_INSERT_VARIABLE_DIALOG
	//UserVarConstructHelper(LPCSTR lpcszObj, LPCSTR lpcszObjLevelStr, int nNodeLevel, bool bUseLink, bool bPropValPair, int nValFormat = INSERT_INFO_VAL_FORMAT_TEXT_OBJECT, int nVarType = VAR_TYPE_AUTO, LPCSTR lpcszDisFmt = NULL)
	UserVarConstructHelper(	LPCSTR lpcszObj, LPCSTR lpcszObjLevelStr, int nNodeLevel, bool bUseLink, bool bPropValPair, HWND hParentWnd, int nValFormat = INSERT_INFO_VAL_FORMAT_TEXT_OBJECT, int nVarType = VAR_TYPE_AUTO, LPCSTR lpcszDisFmt = NULL, 
							bool bInsertLinkWithPlotIndex = false)	///Jasmine 06/11/2012 ORG-5458-S1 INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
	/// End CHECK_VERBATIM_IN_THE_INSERT_VARIABLE_DIALOG
	///End SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
	{
		m_strObj = lpcszObj;
		m_strObjLevelStr = lpcszObjLevelStr;
		m_nNodeLevel = nNodeLevel;
		m_bUseLink = bUseLink;
		m_bPropValPair = bPropValPair;
		m_nValFormat = nValFormat;
		m_nVarType = nVarType;
		m_strDisplayFormat = lpcszDisFmt;			///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
		m_hParentWnd = hParentWnd;					/// Bill 02/23/2011 ORG-2261-S2 CHECK_VERBATIM_IN_THE_INSERT_VARIABLE_DIALOG
		m_bInsertLinkWithPlotIndex = bInsertLinkWithPlotIndex;	///Jasmine 06/11/2012 ORG-5458-S1 INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
	}
	
	string ConstructVariable(LPCSTR lpcszVarName, LPCSTR lpcszValue, int& nDataType, bool bColLabel, int nPlotIndex = 0)
	{
		string	strName = lpcszVarName,
				strValue = lpcszValue,
				strObj = m_strObj;			// it will be modified
		///Kyle 02/02/2010 QA80-15056 NEED_INSERT_LABEL_FOR_TEXT_OBJECT
		//if(bColLabel == false)
		//{
			//if(m_nValFormat != INSERT_INFO_VAL_FORMAT_TEXT_OBJECT)
			//{
				//int nIndex = strObj.Find('!');
				//if(-1 < nIndex)
					//strObj = strObj.Left(nIndex);
				//strObj += "!" + m_strObjLevelStr;
			//}
			//else
			//{
				//if(!strObj.Right(1).Compare("!"))
					//strObj.TrimRight('!');
				//if(!strObj.Right(1).Compare("]"))
				//{
					//strObj.TrimRight(']');
					//strObj.TrimLeft('[');
				//}
			//}
		//}
		if( m_nValFormat == INSERT_INFO_VAL_FORMAT_TEXT_OBJECT )
		{
			if( bColLabel )			// needs sheet obj only
			{
				int nIndex = strObj.Find('!');
				if(-1 < nIndex)
					strObj = strObj.Left(nIndex);
			}
			else
			{
				if(!strObj.Right(1).Compare("!"))
					strObj.TrimRight('!');
				if(!strObj.Right(1).Compare("]"))
				{
					strObj.TrimRight(']');
					strObj.TrimLeft('[');
				}
			}
		}
		else if(bColLabel == false)
		{
			int nIndex = strObj.Find('!');
			if(-1 < nIndex)
				strObj = strObj.Left(nIndex);
			strObj += "!" + m_strObjLevelStr;
		}
		///End NEED_INSERT_LABEL_FOR_TEXT_OBJECT
		if(m_nValFormat == INSERT_INFO_VAL_FORMAT_TEXT_OBJECT)				// a special format: %(obj name, @W, tree.branch.leaf)
		{
			///Kyle 02/02/2010 QA80-15056 NEED_INSERT_LABEL_FOR_TEXT_OBJECT
			// ASSERT(bColLabel == false);
			// if(m_bUseLink)
			// {
			//	///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
			//	/////Jasmine 12/28/09 QA81-14845-S1 ACCESS_SOURCE_BOOK_SHEET_COLUMN_FROM_PLOT
			//	//format_text_object_value_string(strValue, strObj, nPlotIndex, m_nNodeLevel)
			//	/////End ACCESS_SOURCE_BOOK_SHEET_COLUMN_FROM_PLOT
			//	format_text_object_value_string(strValue, strObj, nPlotIndex, m_nNodeLevel, _is_node_numeric(nDataType) ? m_strDisplayFormat : "");
			//	///End SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
			// }
			if( m_bUseLink )
			{
				if( bColLabel )
				{
					///Jasmine 06/11/2012 ORG-5458-S1 INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
					//%(%H, 1, C)
					if( m_bInsertLinkWithPlotIndex )
					{
						prepare_text_object_for_plot(strValue);
					}
					///End INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
					
					strValue.Replace("%H", strObj);
				}
				else
					format_text_object_value_string(strValue, strObj, nPlotIndex, m_nNodeLevel, _is_node_numeric(nDataType) ? m_strDisplayFormat : "");
			}
			///End NEED_INSERT_LABEL_FOR_TEXT_OBJECT
						
			/// Bill 02/23/2011 ORG-2261-S2 CHECK_VERBATIM_IN_THE_INSERT_VARIABLE_DIALOG
			//int n1 = strValue.Find('\\');
			//if(n1 >= 0 && !isFormatting(strValue, n1))			
			//{
			//	strValue = "\\v(" + strValue + ")";
			//}
			bool bVerbatim = false;
			
			if (INSERT_INFO_VAL_FORMAT_TEXT_OBJECT == m_nValFormat)				
			{
				Window Wnd( m_hParentWnd );
				
				const void * pVerbatim = &bVerbatim;
			
				ODWP wParam = GET_VERBATIM_PROPERTY;
				ODWP lParam = (ODWP) pVerbatim;
				Wnd.SendMessage(WM_USER_GET_SET_VERBATIM_PROPERTY, wParam, lParam);
			}			
			if (!bVerbatim)
			{
				strValue = "\\v(" + strValue + ")";
			}
			/// End CHECK_VERBATIM_IN_THE_INSERT_VARIABLE_DIALOG			
		}
		else
		{
			if(m_bUseLink)				// link
			{
				if(m_nValFormat == INSERT_INFO_VAL_FORMAT_CELL)
				{
					if(bColLabel)
					{
						int nPos = strValue.Find('$');			// '$' is not needed
						if(nPos > 0)
							strValue.Delete(nPos);
						strValue = "cell://" + m_strObj + strValue;
					}
					else
						strValue = "var://" + strObj + ".info." + strValue;
				}
				else if(m_nValFormat == INSERT_INFO_VAL_FORMAT_LT)
				{
					if(bColLabel)
					{
						/// Kenny 09/03/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
						//strValue = m_strObj + strValue;
						strValue = strObj + strValue;
						/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
					}
					else
					{
						strValue = strObj + ".info." + strValue;
					}
					///Sophy 9/9/2009 WRONG_EXPRESSION_WHEN_INSERT_NUMERIC_COL_COMMENTS_LABEL_AS_STRING
					//nDataType = _check_convert_data_type(strValue, m_nVarType, nDataType); //move into !bColLabel
					nDataType = _check_convert_data_type(strValue, m_nVarType, nDataType, bColLabel); //move into !bColLabel
					///end WRONG_EXPRESSION_WHEN_INSERT_NUMERIC_COL_COMMENTS_LABEL_AS_STRING
				}
			}
		}
		if(m_bPropValPair)
		{
			if(m_nValFormat == INSERT_INFO_VAL_FORMAT_TEXT_OBJECT)
				strValue = strName + " = " + strValue;
			else
				strValue = strName + STR_VAR_VAL_SEP + strValue;
		}
		return strValue;
	}
	///Jasmine 12/14/09 QA81-14845-P3 ACCESS_FILE_INFO_WITH_PLOT_NOTATION
	bool NeedPlotIndex()
	{
		return m_nValFormat == INSERT_INFO_VAL_FORMAT_TEXT_OBJECT && m_bUseLink;
	}
	///End ACCESS_FILE_INFO_WITH_PLOT_NOTATION
	bool IsUseLink()
	{
		return m_bUseLink;
	}
	
	int GetValFormat()
	{
		return m_nValFormat;
	}
	///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
	bool GetDispFormat(string& strFmt)
	{
		if( m_nValFormat == INSERT_INFO_VAL_FORMAT_TEXT_OBJECT )
		{
			strFmt = m_strDisplayFormat;
			return true;
		}
		return false;
	}
	///End SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
private:
	bool isFormatting(const string& str, int n1)
	{
		int nLen = str.GetLength();
		if(n1+1 < nLen && str[n1+1] == '\\')
			return false; // not possible if \\ as part of network path
		if(n1+2 < nLen && str[n1+2] == '(')
			return true;
		
		// no other checking, can add later
		return false;
	}
private:
	bool m_bUseLink;
	bool m_bPropValPair;
	bool m_bInsertLinkWithPlotIndex;	///Jasmine 06/11/2012 ORG-5458-S1 INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
	int m_nValFormat;
	int m_nVarType;
	int m_nNodeLevel;
	string m_strObjLevelStr;
	string m_strObj;
	string		m_strDisplayFormat;			///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
	HWND m_hParentWnd;					/// Bill 02/23/2011 ORG-2261-S2 CHECK_VERBATIM_IN_THE_INSERT_VARIABLE_DIALOG
};
///End DEFINE_VARIABLE_FROM_COLUMN_LABELS_IN_SCV_DB

class InfoVarsControl : public GridListControl
{
private:
	TreeEditor	m_treeEditor;
public:
	void Init(int nID, Dialog& dlg)
	{
		GridListControl::InitControl(nID, dlg);
		m_treeEditor = dlg.GetItem(nID);
/// Kenny 04/27/2010 QA80-15357 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
#ifdef		__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
		/// Hong 08/30/10 FIX_ORIGIN_CRASH
		//TreeGridControl		gridCntrl 	= dlg.GetDlgItem(nID);
		//ASSERT(gridCntrl);
		//m_flx = gridCntrl.GetGridCtrlInterface();
		m_flx = m_treeEditor.GetGridCtrlInterface();
		/// end FIX_ORIGIN_CRASH
#else		//__REPLACE_VSFLEX_WITH_64_MP_WXGRID__
/// End QA80-15357 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
		m_flx = m_treeEditor.GetActiveXControl();
#endif		//__REPLACE_VSFLEX_WITH_64_MP_WXGRID__	/// Kenny 04/27/2010 QA80-15357 REPLACE_VSFLEX_WITH_64_MP_COMPATIABLE_WXGRID
		
		SetFont();
		//m_treeEditor.Root = tr;				///Jasmine 12/14/09 QA81-14845-P2 MAKE_TREE_SIMPLIER_TO_SEARCH
		
		m_flx.Editable = flexEDNone;
		//m_flx.HighLight = flexHighlightNever;
		m_flx.FocusRect = flexFocusLight;
		
		SetReady();
	}
	void Update(Tree& tr)
	{
		if(IsReady())
		{
			m_treeEditor.Root = tr;
			
			///Jasmine 12/14/09 QA81-14845-P2 MAKE_TREE_SIMPLIER_TO_SEARCH
			SetAllCollapsed();

			if(tr.GetNodeCount() == 1)
				SetIsCollapsed( 0 + GetRowOffset(), flexOutlineExpanded);//flexOutlineSubtotals
			///End MAKE_TREE_SIMPLIER_TO_SEARCH
		}
	}
	///Jasmine 01/17/07 QA70-9273 SHOW_USER_TREE_INFO_IN_USER_VAR_DLG
	///Jasmine 01/15/07 QA70-9269 INSERT_TO_CELL_AS_LINK
	///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
	//bool GetSelStr(const string strObj, string& str, bool bLink, bool bPropValPair, bool bToCell = false)
	///Kyle 08/26/2009 QA80-14190 DEFINE_VARIABLE_FROM_COLUMN_LABELS_IN_SCV_DB
	//bool GetSelStr(const string strObj, string& str, vector<uint>& vnDataTypes, bool bLink, bool bPropValPair, int nValFormat = INSERT_INFO_VAL_FORMAT_TEXT_OBJECT, int nInsertMode = VAR_TYPE_AUTO)
	bool GetSelStr(string& str, vector<uint>& vnDataTypes, const UserVarConstructHelper& helper)
	///End DEFINE_VARIABLE_FROM_COLUMN_LABELS_IN_SCV_DB
	///End SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
	{
		str.Empty();					///Kyle 08/26/2009 QA80-14190 DEFINE_VARIABLE_FROM_COLUMN_LABELS_IN_SCV_DB
		vnDataTypes.SetSize(0);			///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
		vector<uint> arrRows;
		if(m_treeEditor.GetSelectedRows(&arrRows, TRUE) > 0)
		{
			string strTemp;
			int nDataType;		///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
			for(int ii = 0; ii < arrRows.GetSize(); ii++)
			{
				///Bill 07/02/2010 ORG-477 INSERT_VARIABLE_SHOULD_NOT_INSERT_THE_HIDDEN_FILTER_INFO 
				TreeNode trTemp;
				trTemp = tree_get_node(m_treeEditor.Root, arrRows[ii] - GetRowOffset());				
				if ( !trTemp.Show )
					continue;				
				///End INSERT_VARIABLE_SHOULD_NOT_INSERT_THE_HIDDEN_FILTER_INFO 

				///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
				//if(getRowStr(strObj, strTemp, arrRows[ii], bLink, bPropValPair, bToCell))
				///Kyle 08/26/2009 QA80-14190 DEFINE_VARIABLE_FROM_COLUMN_LABELS_IN_SCV_DB
				//if(getRowStr(strObj, strTemp, nDataType, arrRows[ii], bLink, bPropValPair, nValFormat, nInsertMode))
				if(getRowStr(strTemp, nDataType, arrRows[ii], helper))
				///End DEFINE_VARIABLE_FROM_COLUMN_LABELS_IN_SCV_DB
				///End SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
				{
					if(!str.IsEmpty())
						str += "\r\n";
					str += strTemp;
					vnDataTypes.Add(nDataType);			///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
				}
			}
			return true;
		}
		return false;
	}
private:
	///Kyle 08/26/2009 QA80-14190 DEFINE_VARIABLE_FROM_COLUMN_LABELS_IN_SCV_DB
	bool getRowStr(string& str, int& nDataType, int nRow, const UserVarConstructHelper& helper)
	{
		str.Empty();
		ODWP	dwData = m_treeEditor.GetProperty(nRow);
		if(dwData)
		{
			// get data type: numeric, int, string
			nDataType = ONODETYPE_INVALID;
			TreeNode tr = m_treeEditor.Root;
			///Kyle 02/02/2010 QA80-15056 NEED_INSERT_LABEL_FOR_TEXT_OBJECT
			int nColLabel;
			bool bColLabel = (tr.GetAttribute(STR_INSERT_VARIABLE_COL_LABEL_ATTRIB, nColLabel) && nColLabel);
			///End NEED_INSERT_LABEL_FOR_TEXT_OBJECT
			tr = tree_get_node(tr, nRow - GetRowOffset());
			if(tr)
				tr.GetAttribute(STR_ID_ATTRIB, nDataType);

			int nValFormat = helper.GetValFormat();
			EditorManager	trNodeManager;
			
			// get variable value or link
			string strValue;
			if( helper.IsUseLink() )
			{
				if(nValFormat == INSERT_INFO_VAL_FORMAT_TEXT_OBJECT)
					strValue = trNodeManager.GetStrData(dwData);
				else if(tr.IsValid())
					tr.GetAttribute(STR_PATH_ATTRIB, strValue);
			}
			///Kyle 01/15/2010 QA80-14970 SUPPORT_DATE_DISPLAY_IN_TREE_EDITOR
			else if(nValFormat == INSERT_INFO_VAL_FORMAT_LT)		// may display in date, here we need the value only
			{
				ASSERT(tr);
				strValue = tr.strVal;
			}
			///End SUPPORT_DATE_DISPLAY_IN_TREE_EDITOR
			///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
			else if( nValFormat == INSERT_INFO_VAL_FORMAT_TEXT_OBJECT && _is_node_numeric(nDataType) )
			{
				string strFormat;
				helper.GetDispFormat(strFormat);
				if( strFormat.IsEmpty() )				// no format
				{
					strValue = tr.strVal;
				}
				else if( strFormat.Compare("0")==0 )	// follow format in storage, so get the display string
				{
					strValue = trNodeManager.GetText(dwData, FALSE);
				}
				else									// custom format
				{
					double dValue = atof(tr.strVal);
					strValue = ftoa(dValue, strFormat);
				}
			}
			///End SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
			else
			{
				strValue = trNodeManager.GetText(dwData, FALSE);
			}
			// variable name
			string strVarName = GetTextMatrix(nRow, 0);
			
			///Jasmine 12/14/09 QA81-14845-P3 ACCESS_FILE_INFO_WITH_PLOT_NOTATION
			int nPlotIndex = helper.NeedPlotIndex()? getPlotindexFromTreeData(nRow) : -1;
			///End ACCESS_FILE_INFO_WITH_PLOT_NOTATION
			///Kyle 02/02/2010 NEED_INSERT_LABEL_FOR_TEXT_OBJECT
			//str = helper.ConstructVariable(strVarName, strValue, nDataType, isColLabel(strValue), nPlotIndex);
			str = helper.ConstructVariable(strVarName, strValue, nDataType, bColLabel, nPlotIndex);
			///End NEED_INSERT_LABEL_FOR_TEXT_OBJECT

			return true;
		}
		return false;
	}
	
	///Jasmine 12/14/09 QA81-14845-P3 ACCESS_FILE_INFO_WITH_PLOT_NOTATION
	int getPlotindexFromTreeData(int nRow)
	{		
		TreeNode tr = m_treeEditor.Root;
		tr = tree_get_node(tr, nRow - GetRowOffset());
		
		for(int nPlotIndex = -1;;)
		{
			TreeNode trParent = tr.Parent();
			if(!trParent )
				break;
			if( trParent.GetAttribute(STR_PLOT_INDEX_ATTRIB, nPlotIndex) )
				break;
			tr = trParent;
		}
		
		return nPlotIndex;
	}
	///End ACCESS_FILE_INFO_WITH_PLOT_NOTATION
	
	///Kyle 02/02/2010 QA80-15056 NEED_INSERT_LABEL_FOR_TEXT_OBJECT
	/*
	bool isColLabel(LPCSTR lpcsz)
	{
		string str(lpcsz);
		if(str.IsEmpty())
			return false;
		int nLen = str.GetLength();
		if(str[nLen-1] == '$')
		{
			str.Delete(nLen-1);
			nLen--;
		}
		if(str[0] != '[' || str[nLen-1] != ']')
			return false;
		str.Delete(nLen-1);
		str.Delete(0);
		
		vector<int> vIndex;
		okutil_convert_labels_string_to_indices(str, &vIndex);
		if(vIndex.GetSize() == 1 && vIndex[0] >= RCLT_LONG_NAME && vIndex[0] <= RCLT_MAX_TYPE)
			return true;
		return false;
	}
	*/
	///End NEED_INSERT_LABEL_FOR_TEXT_OBJECT
	///End DEFINE_VARIABLE_FROM_COLUMN_LABELS_IN_SCV_DB
	
	//n1 if the '\\' location, we then check if in the form of \a(bc)
	bool isFormatting(const string& str, int n1)
	{
		int nLen = str.GetLength();
		if(n1+1 < nLen && str[n1+1] == '\\')
			return false; // not possible if \\ as part of network path
		if(n1+2 < nLen && str[n1+2] == '(')
			return true;
		
		// no other checking, can add later
		return false;
	}
	///Jasmine 01/17/07 CONVERT_VARIABLES_STRING
	void convertVariablesString(string& str, bool bToCell)
	{
		if(bToCell)
		{
			vector<string> vs;		
			if(str.GetTokens(vs, '.') && !vs[0].CompareNoCase("Variables"))
				str = "user." + vs[0] + "." + vs[vs.GetSize()-1];
			return;
		}
		if(-1 < str.Find("Variables.", 0))
			str.Delete(str.ReverseFind('$'));		
	}
	///End CONVERT_VARIABLES_STRING
};

// open Insert Info Variables dialog and return str to insert
// *lpType = 0 if insert as is, =1 if insert as link
///Kyle 06/26/2009 INSERT_INFO_SUPPORT_FILTER_TREE_NODES_AND_DISABLE_INSERT_AS_LINK_BTN, move function declaration to InsertUserVar.h
//bool InsertUserVar(HWND hWndParent, string& str, int* lpType = NULL)
#ifdef SET_VALUES_SUPPORT_DEFINE_VARIBLE
bool InsertUserVar(HWND hWndParent, string& str, int* lpType)
#else
bool InsertUserVar(HWND hWndParent, string& str, int* lpType = NULL)
#endif // SET_VALUES_SUPPORT_DEFINE_VARIBLE
///End INSERT_INFO_SUPPORT_FILTER_TREE_NODES_AND_DISABLE_INSERT_AS_LINK_BTN
{
	InsertUserVarDlg MyDlg(str);///Jasmine 01/15/07 QA70-9269 INSERT_TO_CELL_AS_LINK
	
	int nRet = MyDlg.DoModalEx(hWndParent);
	str = MyDlg.m_strRet;
	if(lpType)
		*lpType = MyDlg.m_bUseLink;
	return (IDCANCEL == nRet)? false:true;
}

///Kyle 06/26/2009 INSERT_INFO_SUPPORT_FILTER_TREE_NODES_AND_DISABLE_INSERT_AS_LINK_BTN
#ifdef SET_VALUES_SUPPORT_DEFINE_VARIBLE

///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
//bool InsertUserVarEx(string& str, int* lpType, DWORD dwCtrl, bool* pbDisableLinkAndDefType, HWND hWndParent)
///Sophy 9/9/2009 INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG
//bool InsertUserVarEx(string& str, int* lpType, vector<uint>* pvnDataTypes, DWORD dwCtrl, bool* pbDisableLinkAndDefType, HWND hWndParent)
bool InsertUserVarEx(string& str, int* lpType, vector<uint>* pvnDataTypes, DWORD dwCtrl, bool* pbDisableLinkAndDefType, HWND hWndParent, UINT colUID)
///end INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG
///End SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
{
	///Sophy 9/9/2009 INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG
	//InsertUserVarDlg MyDlg(dwCtrl, pbDisableLinkAndDefType);
	InsertUserVarDlg MyDlg(dwCtrl, pbDisableLinkAndDefType, colUID);
	///end INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG

	int nRet = MyDlg.DoModalEx(hWndParent);
	str = MyDlg.m_strRet;
	if(lpType)
		*lpType = MyDlg.m_bUseLink;
	///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
	if(pvnDataTypes)
		*pvnDataTypes = MyDlg.m_vnDataTypes;
	///End SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
	return (IDCANCEL == nRet)? false:true;
}

#endif // SET_VALUES_SUPPORT_DEFINE_VARIBLE
///End INSERT_INFO_SUPPORT_FILTER_TREE_NODES_AND_DISABLE_INSERT_AS_LINK_BTN

///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
enum
{
	DISP_FMT_NONT,
	DISP_FMT_FOLLOW_INFO_STORAGE,
	DISP_FMT_CUSTOM_FORMAT,
};

#define STR_DISP_FMT_NONT					_L("None")
#define STR_DISP_FMT_FOLLOW_INFO_STORAGE	_L("Use Internal Display Format")//_L("Follow Format in Storage") CPY 2/12/10 changed as Jessica at Addtive pointed out this does not make sense to users
#define STR_DISP_FMT_CUSTOM_FORMAT			_L("Custom Format")
///End SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT

///Jasmine 01/17/07 QA70-9273 SHOW_USER_TREE_INFO_IN_USER_VAR_DLG
//class InsertUserVarDlg : public ResizeDialog	//add Project Tree Panel
class InsertUserVarDlg : public MultiPaneDlg
{
private:
	GridTreeControl	m_trFolder;
	Tree			m_tree;
	InfoVarsControl m_InfoVars;
	Button			m_btnUseLink;
	Button			m_btnPorpValPair;
	///Junon 06/08/2012 ORG-4042-P8 ORIGIN_WINDOW_FLICKERS_FREQUENTLY_WHEN_RESIZING
	//TabControl 		m_tab;
	TabCtrlEx		m_tab;
	///End ORIGIN_WINDOW_FLICKERS_FREQUENTLY_WHEN_RESIZING
	///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
	//bool			m_bInsertToCell;	///Jasmine 01/15/07 QA70-9269 INSERT_TO_CELL_AS_LINK
	int				m_nValFormat;
	///End SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
	int				m_nNodeLevel;	///Jasmine 03/22/07 SEPARATE_OBJ_LEVEL_AND_TREE_SHOW_LEVEL
	int				m_nShowLevel;
	int 			m_nActivePageType;	///Jasmine 12/16/09 QA81-14845-P4 SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
	DWORD			m_dwPTCtrl; ///Sophy 9/3/2009 QA80-14241 CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
	UINT			m_nCurColUID;///Sophy 9/9/2009 INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG
	
	string 			m_strGoTo;	///Jasmine 01/07/10 QA81-14845-S2 INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET
	
	///Kyle 06/26/2009 INSERT_INFO_SUPPORT_FILTER_TREE_NODES_AND_DISABLE_INSERT_AS_LINK_BTN
#ifdef SET_VALUES_SUPPORT_DEFINE_VARIBLE
	DWORD			m_dwInfoFilter;
	BOOL			m_bDisableLinkBtn;
#endif // SET_VALUES_SUPPORT_DEFINE_VARIBLE
	///End INSERT_INFO_SUPPORT_FILTER_TREE_NODES_AND_DISABLE_INSERT_AS_LINK_BTN

	ComboBox		m_comboLinkIndex;	///Jasmine 06/11/2012 ORG-5458-S1 INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
	/// Kenny 09/03/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	ComboBox		m_comboInsertMode;
	/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	
	///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
	ComboBox		m_comboVarType;
	
	bool			m_bEnableVarType;
	bool			m_bEnableProjectTree;
	bool			m_bEnablePropValPair;
	///End SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
	
	bool			m_bMultiInsert;		///Kyle 08/26/2009 INSERT_MULTIPLE_TIMES_FOR_SCV

	/// Kenny 12/19/2009 QA81-14845-P5 INSERT_USER_VAR_DLG_FOR_GOBJECT_SHOULD_NOT_CLOSE_ON_INSERT
	HWND			m_hParentWnd;
	/// End QA81-14845-P5 INSERT_USER_VAR_DLG_FOR_GOBJECT_SHOULD_NOT_CLOSE_ON_INSERT
	
	///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
	Control			m_ctrlStaticDispFmt;
	ComboBox		m_comboDispFmt;
	Edit			m_edCustomFmt;
	RichEdit		m_edCustomFmtHint;
	///End SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT

public:
	//InsertUserVarDlg(LPCSTR lpcszTo = NULL) : ResizeDialog(IDD_PASTE_USER_VAR, "ODlg")
	InsertUserVarDlg(LPCSTR lpcszTo = NULL) : MultiPaneDlg(IDD_PASTE_USER_VAR, "ODlg", true)
	///End SHOW_USER_TREE_INFO_IN_USER_VAR_DLG
	{
		if(lpcszTo && !lstrcmpi(lpcszTo, "cell"))///Jasmine 01/15/07 QA70-9269 INSERT_TO_CELL_AS_LINK
		///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
			//m_bInsertToCell = true;
		{
			m_nValFormat = INSERT_INFO_VAL_FORMAT_CELL;
			m_bEnableProjectTree = true;
			m_bEnablePropValPair = false;
		}
		else
		{
			m_nValFormat = INSERT_INFO_VAL_FORMAT_TEXT_OBJECT;
			m_bEnableProjectTree = true;//false;///Jasmine 12/16/09 QA81-14845-P4 SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
			m_bEnablePropValPair = true;
		}
		m_bEnableVarType = false;
		m_bDisableLinkBtn = false;
		///End SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
		
		m_bMultiInsert = false;		///Kyle 08/26/2009 INSERT_MULTIPLE_TIMES_FOR_SCV

		/// Kenny 12/19/2009 QA81-14845-P5 INSERT_USER_VAR_DLG_FOR_GOBJECT_SHOULD_NOT_CLOSE_ON_INSERT
		m_hParentWnd = NULL;
		/// End QA81-14845-P5 INSERT_USER_VAR_DLG_FOR_GOBJECT_SHOULD_NOT_CLOSE_ON_INSERT
		
		///Jasmine 07/23/2012 ORG-5458-S2 ACTIVATE_LABEL_TAB_BY_DEFAULT
		m_dwCtrl |= INSERT_INFO_OPEN_TAB_ON_REG;
		///End ACTIVATE_LABEL_TAB_BY_DEFAULT
	}

	///Kyle 06/26/2009 INSERT_INFO_SUPPORT_FILTER_TREE_NODES_AND_DISABLE_INSERT_AS_LINK_BTN
#ifdef SET_VALUES_SUPPORT_DEFINE_VARIBLE
	///Sophy 9/9/2009 INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG
	//InsertUserVarDlg(DWORD dwCtrl, bool* pbDisableLinkAndDefType = NULL) : MultiPaneDlg(IDD_PASTE_USER_VAR, "ODlg", true)
	InsertUserVarDlg(DWORD dwCtrl, bool* pbDisableLinkAndDefType = NULL, UINT colUID = 0) : MultiPaneDlg(IDD_PASTE_USER_VAR, "ODlg", true)
	///end INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG
	{
		///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
		//m_bInsertToCell = INSERT_INFO_INSERT_TO_CELL & dwCtrl;
		m_nValFormat = INSERT_INFO_VAL_FORMAT_MARK & dwCtrl;
		m_bEnableVarType = INSERT_INFO_ENABLE_VAR_TYPE & dwCtrl;
		m_bEnableProjectTree = INSERT_INFO_ENABLE_PROJECT_TREE  & dwCtrl;
		///End SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
		m_dwInfoFilter = (INSERT_INFO_INFO_FILTER_BITS & dwCtrl);
		m_bDisableLinkBtn = (pbDisableLinkAndDefType != NULL);
		if(pbDisableLinkAndDefType)
			m_bUseLink = *pbDisableLinkAndDefType;
		m_bMultiInsert = INSERT_INFO_MULTI_INSERT & dwCtrl;		///Kyle 08/26/2009 INSERT_MULTIPLE_TIMES_FOR_SCV
		m_dwCtrl = dwCtrl;		/// Kenny 09/01/2009 QA81-14241 DEFINE_VARIABLE_MENU_WANTED
		m_nCurColUID = colUID;	///Sophy 9/9/2009 INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG

		/// Kenny 12/19/2009 QA81-14845-P5 INSERT_USER_VAR_DLG_FOR_GOBJECT_SHOULD_NOT_CLOSE_ON_INSERT
		m_hParentWnd = NULL;
		/// End QA81-14845-P5 INSERT_USER_VAR_DLG_FOR_GOBJECT_SHOULD_NOT_CLOSE_ON_INSERT
	}
#endif // SET_VALUES_SUPPORT_DEFINE_VARIBLE
	///End INSERT_INFO_SUPPORT_FILTER_TREE_NODES_AND_DISABLE_INSERT_AS_LINK_BTN

	int DoModalEx(HWND hWndParent = NULL)
	{
		/// Kenny 12/19/2009 QA81-14845-P5 INSERT_USER_VAR_DLG_FOR_GOBJECT_SHOULD_NOT_CLOSE_ON_INSERT
		m_hParentWnd = hWndParent;
		/// End QA81-14845-P5 INSERT_USER_VAR_DLG_FOR_GOBJECT_SHOULD_NOT_CLOSE_ON_INSERT

		InitMsgMap();// will be called from internal later
		return DoModal(hWndParent);
	}
	
	string 			m_strRet;
	vector<uint>	m_vnDataTypes;			///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
	bool			m_bUseLink;
	DWORD			m_dwCtrl;				/// Kenny 09/01/2009 QA81-14241 DEFINE_VARIABLE_MENU_WANTED
protected:
	///----------------------------------------------
	///----------------- Message Map ----------------
	///
	EVENTS_BEGIN
		///Jasmine 05/08/08 RESTRICT_INSERT_VAR_DLG_MIN_WIDTH
		ON_SYSCOMMAND(OnSystemCommand)
		ON_GETMINMAXINFO(OnMinMaxInfo)
		///End RESTRICT_INSERT_VAR_DLG_MIN_WIDTH
		ON_INIT(OnInitDialog) 
		ON_DESTROY(OnDestroy)
		ON_READY(OnReady)
		ON_OK(OnOK)
		ON_SIZE(OnDlgResize)
		ON_CONTEXTMENU(OnShowMenu)
		ON_GRID_ROW_COL_CHANGE(IDC_PASTEVAR_PROJECT_TREE, OnSelectTreeNode)
		ON_BN_CLICKED(IDC_SHOW_BOTTOM, OnShowBottomPane)//OnShowProjectTree)
		///Joseph 02/15/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
		ON_INIT_SIZE(OnInitSize)	
		ON_RESTORESIZE(OnRestoreSize)
		///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
		/// Kenny 09/01/2009 QA81-14241 DEFINE_VARIABLE_MENU_WANTED
		ON_TAB_SEL_CHANGE(IDC_PASTEVAR_TAB, OnTabChange)
		/// End QA81-14241 DEFINE_VARIABLE_MENU_WANTED

		/// Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		ON_CBN_SELCHANGE(IDC_PASTEVAR_TREE, OnVarTreeSelChange)
		/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS

		ON_IDLE(OnIdle)		///------ Folger 09/21/09 QA80-14283 GET_RID_OF_ONSELECTIONCHANGE_EVENT_DURING_GRID_ATTACH
		
		ON_BN_CLICKED(IDC_PASTEVAR_KEEP_LINK, OnCheckInsertLink)				///Jasmine 06/11/2012 ORG-5458-S1 INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
		///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
		ON_CBN_SELCHANGE(IDC_PASTEVAR_DISPLAY_FORMAT, OnDispFmtSelChange)
		///End SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
		
	EVENTS_END
	///----------------------------------------------
	
	///////////////////////////////////////////////////////
	/// Event Handlers
	///////////////////////////////////////////////////////
	///Jasmine 05/08/08 RESTRICT_INSERT_VAR_DLG_MIN_WIDTH
	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//int	GetTotalWidth(bool bMin = false)
	int	GetMinClientTrackWidth()
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	{
		if( IsBottomPaneShown() )
		{
			RECT rSownBtn;
			GetClientRect(GetItem(IDC_SHOW_BOTTOM), rSownBtn);
			///Sophy 7/27/2011 ORG-3189-P2 NEED_PROPER_POSITION_DIALOG_CONTROL_ON_120_DPI_SETTINGS
			//return rSownBtn.right + GetMinBottomPaneHeight() + 2*GetControlGap();
			int nRight = rSownBtn.right;
			RECT rOK;
			GetClientRect(GetItem(IDOK), rOK);
			if ( nRight < rOK.right )
				nRight = rOK.right;
			RECT rInsertMode;
			GetClientRect(m_comboInsertMode, rInsertMode);
			if ( nRight < rInsertMode.right )
				nRight = rInsertMode.right;
			return (nRight + GetMinBottomPaneHeight() + 3 * GetControlGap());
			///end NEED_PROPER_POSITION_DIALOG_CONTROL_ON_120_DPI_SETTINGS
		}
		
		/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//return getDlgMinWidth();
		return getMinClientWidth();
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	}
	///End RESTRICT_INSERT_VAR_DLG_MIN_WIDTH
	
	BOOL OnInitDialog()
	{		
		waitCursor _junk;
		
		///Jasmine 12/16/09 QA81-14845-P4 SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
		m_nActivePageType = -1;
		Page pg = Project.Pages();
		if(pg)
			m_nActivePageType = pg.GetType();	
		///End SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
		
		///Jasmine 01/17/07 QA70-9273 SHOW_USER_TREE_INFO_IN_USER_VAR_DLG
		//ResizeDialog::OnInitDialog();
		//vector<string> vsTooltipsShowBottomPane = {"Show Preview", "No Preview"};		
		vector<string> vsTooltipsShowBottomPane;
		vsTooltipsShowBottomPane.Add(_L("Show Preview"));
		vsTooltipsShowBottomPane.Add(_L("No Preview"));
		MultiPaneDlg::OnInitDialog(IDC_PASTEVAR_TAB, IDC_SHOW_BOTTOM, IDC_PASTEVAR_PROJECT_TREE, vsTooltipsShowBottomPane, STR_DLG_NAME, 0, NULL, DEFAULT_RIGHT_PANE_WIDTH);

		m_btnUseLink = GetItem(IDC_PASTEVAR_KEEP_LINK);
		m_btnPorpValPair = GetItem(IDC_PASTEVAR_PROP_VALUE);
		m_btnUseLink.Check = true;			///Kyle 08/27/2009 QA80-14213 CHECK_INSERT_AS_LINK_BY_DEFAULT
		/// Kenny 09/04/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		//ResizeDialog::LoadCheckBoxSettings("InsertUserVar", IDC_PASTEVAR_KEEP_LINK, IDC_PASTEVAR_PROP_VALUE);
		ResizeDialog::LoadCheckBoxSettings("InsertUserVar", IDC_PASTEVAR_KEEP_LINK, IDC_PASTEVAR_PROP_VALUE, IDC_PASTEVAR_FULL_RANGE);
		/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		///Kyle 06/26/2009 INSERT_INFO_SUPPORT_FILTER_TREE_NODES_AND_DISABLE_INSERT_AS_LINK_BTN
#ifdef SET_VALUES_SUPPORT_DEFINE_VARIBLE
		if(m_bDisableLinkBtn)			// since the button is disabled, should set Check/UnCheck by user
		{
			m_btnUseLink.Enable = false;
			m_btnUseLink.Check = m_bUseLink;
		}
#endif //SET_VALUES_SUPPORT_DEFINE_VARIBLE
		///End INSERT_INFO_SUPPORT_FILTER_TREE_NODES_AND_DISABLE_INSERT_AS_LINK_BTN

		///Jasmine 06/11/2012 ORG-5458-S1 INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
		m_comboLinkIndex = GetItem(IDC_PASTEVAR_LINK_COMBO);	
		m_comboLinkIndex.InsertString(INSERT_LINK_WITH_PLOT_INDEX, _L("Link with Plot Index"));
		m_comboLinkIndex.InsertString(INSERT_LINK_WITH_COL_INDEX, _L("Link with Column Index"));
		m_comboLinkIndex.AdjustDroppedWidth();
		int nLinkWith = INSERT_LINK_WITH_PLOT_INDEX;
		nLinkWith = LoadSetting(STR_REG_LINK_WITH, nLinkWith, STR_DLG_NAME);
		m_comboLinkIndex.SetCurSel(nLinkWith);
		///End INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
		
		/// Kenny 09/01/2009 QA81-14241 DEFINE_VARIABLE_MENU_WANTED
		m_tab = GetItem(IDC_PASTEVAR_TAB);
		m_tab.InsertItem(TAB_INFO, STR_TAB_INFO);
		///Kyle 02/02/2010 QA80-15056 NEED_INSERT_LABEL_FOR_TEXT_OBJECT
		//if ( m_nValFormat != INSERT_INFO_VAL_FORMAT_TEXT_OBJECT )
		//{
			//Text = STR_DLG_NAME;
			//m_tab.InsertItem(TAB_LABEL, STR_TAB_LABEL);
		//}
		m_tab.InsertItem(TAB_LABEL, STR_TAB_LABEL);
		Text = STR_DLG_NAME;				// _L("Insert Variables")
		///End NEED_INSERT_LABEL_FOR_TEXT_OBJECT
		/// End QA81-14241 DEFINE_VARIABLE_MENU_WANTED
		
		///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
		m_comboVarType = GetItem(IDC_PASTEVAR_VAR_TYPE);
		m_comboVarType.ResetContent();
		vector<string> vsItems;
		vsItems.Add(_L("Auto"));
		vsItems.Add(_L("Numeric double"));
		vsItems.Add(_L("Numeric int"));
		vsItems.Add(_L("String"));
		for( int nItem = 0; nItem < vsItems.GetSize(); nItem++ )
			m_comboVarType.AddString(vsItems[nItem]);
		m_comboVarType.SetCurSel(0);
		
		m_comboVarType.Enable = m_bEnableVarType;
		GetItem(IDC_PASTEVAR_STATIC_VAR_TYPE).Enable = m_bEnableVarType;

		m_comboInsertMode = GetItem(IDC_PASTEVAR_INSERT_MODE);
		m_comboInsertMode.ResetContent();
		vsItems.RemoveAll();
		/// Kenny 09/11/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
// 		vsItems.Add( _L("Sheet/Column Name") );
// 		vsItems.Add( _L("Sheet/Column Index") );
		vsItems.Add( STR_INSERT_MODE_NAME );
		vsItems.Add( STR_INSERT_MODE_INDEX );
		/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		for( int ii = 0; ii < vsItems.GetSize(); ii++ )
			m_comboInsertMode.AddString(vsItems[ii]);
		///Sophy 9/9/2009 MORE_WORK_ON_REMEMBER_LAST_SETTINGS_OF_INSERTVAR_DLG
		//m_comboInsertMode.SetCurSel(INSERT_MODE_NAME);
		int nInsertMode = INSERT_MODE_NAME;
		nInsertMode = LoadSetting(STR_INSERTMODE, nInsertMode, STR_DLG_NAME);
		m_comboInsertMode.SetCurSel(nInsertMode);
		///end MORE_WORK_ON_REMEMBER_LAST_SETTINGS_OF_INSERTVAR_DLG
		
		GetItem(IDC_PASTEVAR_PROJECT_TREE).Visible = m_bEnableProjectTree;
		GetItem(IDC_SHOW_BOTTOM).Visible = m_bEnableProjectTree;
		if(!m_bEnableProjectTree)
			ShowBottomPane(false);

		m_btnPorpValPair.Check = m_btnPorpValPair.Visible = m_bEnablePropValPair;
		///End SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
		m_dwPTCtrl = PT_CTRL_SKIP_HIERARCHY; ///Sophy 9/3/2009 QA80-14241 CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
		///Sophy 9/9/2009 MORE_WORK_ON_REMEMBER_LAST_SETTINGS_OF_INSERTVAR_DLG
		m_dwPTCtrl = LoadSetting(STR_PROJECT_TREE_CTRL, m_dwPTCtrl, STR_DLG_NAME);
		///end MORE_WORK_ON_REMEMBER_LAST_SETTINGS_OF_INSERTVAR_DLG
		initFolderTree();

		m_InfoVars.Init(IDC_PASTEVAR_TREE, *this);	

		GetItem(IDC_PASTEVAR_PROJECT_TREE).Visible = IsBottomPaneShown();		//------Folger 07/19/07 FIXED_BUGS_IN_DIALOG_RESIZE		
		/// Kenny 09/03/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		//arrangeInsertModeBtns();		///Kyle 08/27/2009 QA80-14213 HIDE_INSERT_MODE_FOR_INSERT_VARIABLE_WKS_CELL_TEXT_OBJECT
		arrangeVarTypeBtns();
		arrangeFullRangeCtrl();
		/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
		m_ctrlStaticDispFmt = GetItem(IDC_PASTEVAR_STATIC_DISP_FMT);
		m_comboDispFmt = GetItem(IDC_PASTEVAR_DISPLAY_FORMAT);
		m_edCustomFmt = GetItem(IDC_PASTEVAR_CUSTOM_FORMAT);
		m_edCustomFmtHint = GetItem(IDC_PASTEVAR_CUSTOM_FORMAT_HINT);
		arrangeDispFormatBtns();
		///End SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
		
		///Jasmine 07/23/2012 ORG-5458-S2 ACTIVATE_LABEL_TAB_BY_DEFAULT
		if(m_dwCtrl & INSERT_INFO_OPEN_TAB_ON_REG)
		{
			int nTab = LoadSetting(STR_REG_INSERT_TAB, TAB_LABEL, STR_DLG_NAME);
			SwitchToTab(nTab);
		}
		else
		///End ACTIVATE_LABEL_TAB_BY_DEFAULT
		{
			///Kyle 02/02/2010 QA80-15056 NEED_INSERT_LABEL_FOR_TEXT_OBJECT
			//if ( (m_dwCtrl & INSERT_INFO_OPEN_LABEL_TAB) && m_nValFormat != INSERT_INFO_VAL_FORMAT_TEXT_OBJECT)
			if ( m_dwCtrl & INSERT_INFO_OPEN_LABEL_TAB )
			///End NEED_INSERT_LABEL_FOR_TEXT_OBJECT
			{
				SwitchToTab(TAB_LABEL);
			}
			else
				SwitchToTab(TAB_INFO);
		}
		
		OnCheckInsertLink(m_btnUseLink);					///Jasmine 06/11/2012 ORG-5458-S1 INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
		
		/// Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		updateInsertBtnStatus();
		/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		return TRUE;	
	}
	
	//---- CPY 12/31/03 v7.5793 MAKE_RESIZABLE
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		//------Folger 07/19/07 FIXED_BUGS_IN_DIALOG_RESIZE
		if(!IsInitReady())
			return TRUE;
		
		/// Kenny 02/22/2012 ORG-4042-P8 ORIGIN_WINDOW_FLICKER_FREE
		MoveControlsHelper clMoveCtrlHelper(this);
		/// End ORIGIN_WINDOW_FLICKER_FREE
		//------End FIXED_BUGS_IN_DIALOG_RESIZE
		//ResizeMoveControlsRightBottom(IDC_PASTEVAR_TREE, NULL, NULL, cx, cy);
		uint nButtonIDs[] = {IDC_SHOW_BOTTOM, 0};		
		MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, false);		
		///Kyle 08/27/2009 QA80-14213 HIDE_INSERT_MODE_FOR_INSERT_VARIABLE_WKS_CELL_TEXT_OBJECT, fix the position of IDC_PASTEVAR_EDIT not good
		/*
		RECT rTab, rText, rShow;
		m_tab.GetWindowRect(&rTab);
		ScreenToClient(&rTab);
		m_tab.AdjustRect(FALSE, &rTab);
		GetItem(IDC_PASTEVAR_TREE).MoveWindow(&rTab);
		///Jasmine 03/22/07 ADD_RANGE_EDIT_BOX	
		GetClientRect(GetItem(IDC_PASTEVAR_TEXT), rText);
		GetClientRect(GetItem(IDC_SHOW_BOTTOM), rShow);
		//int nH = RECT_HEIGHT(rText);
		//rText.top = rTab.bottom + GetControlGap();
		//rText.bottom = rText.top + nH;
		//MoveControl(GetItem(IDC_PASTEVAR_TEXT), rText); 
		uint nBottomButtonIDs[] = {IDC_PASTEVAR_TEXT, IDC_PASTEVAR_EDIT, 0};		
		ArrangeControlsLeftRight(nBottomButtonIDs, rText.left, rTab.bottom + GetControlGap(), rShow.left - GetControlGap(), IDC_PASTEVAR_EDIT);
		*/
		RECT rTab, rText, rEdit, rShow;
		GetClientRect(GetItem(IDC_PASTEVAR_TEXT), rText);
		GetClientRect(GetItem(IDC_PASTEVAR_EDIT), rEdit);
		int nBottomBtnsHeight = RECT_HEIGHT(rText);
		if(nBottomBtnsHeight < RECT_HEIGHT(rEdit))
			nBottomBtnsHeight = RECT_HEIGHT(rEdit);
		GetClientRect(m_tab, rTab);
		rTab.bottom = cy - nBottomBtnsHeight - 2 * GetControlGap();
		MoveControl(m_tab, rTab);

		m_tab.AdjustRect(FALSE, &rTab);
		GetItem(IDC_PASTEVAR_TREE).MoveWindow(&rTab);

		GetClientRect(GetItem(IDC_SHOW_BOTTOM), rShow);
		uint nBottomButtonIDs[] = {IDC_PASTEVAR_TEXT, IDC_PASTEVAR_EDIT, 0};		
		ArrangeControlsLeftRight(nBottomButtonIDs, rText.left, rTab.bottom + GetControlGap(), rShow.left - GetControlGap(), IDC_PASTEVAR_EDIT);
		///End HIDE_INSERT_MODE_FOR_INSERT_VARIABLE_WKS_CELL_TEXT_OBJECT
		///End ADD_RANGE_EDIT_BOX
		
		///Sophy 7/4/2011 ORG-3189-P1 NEED_PROPER_POSITION_DIALOG_CONTROL_ON_120_DPI_SETTINGS
		///Sophy 7/27/2011 ORG-3189-P2 NEED_PROPER_POSITION_DIALOG_CONTROL_ON_120_DPI_SETTINGS
		//Control ctrlBtn;
		//RECT rBtn;
		//uint nBtnIDs[] = {IDOK, IDCANCEL, 0};
		//for ( int iBtn = 0; nBtnIDs[iBtn] != 0; iBtn++ )
		//{
			//ctrlBtn = GetItem(nBtnIDs[iBtn]);
			//GetClientRect(ctrlBtn, rBtn);
			//int nWidth = RECT_WIDTH(rBtn);
			//rBtn.right = rShow.right;
			//rBtn.left = rBtn.right - nWidth;
			//ctrlBtn.MoveWindow(&rBtn);
		//}
		///end NEED_PROPER_POSITION_DIALOG_CONTROL_ON_120_DPI_SETTINGS
		///end NEED_PROPER_POSITION_DIALOG_CONTROL_ON_120_DPI_SETTINGS
			
		return TRUE;
	}
	//----
	//BOOL OnDestroy(){ return MultiPaneDlg::OnDestroy();}

	///Kyle 07/06/2009 FOLDER_TREE_KEEP_LAST_SHOWING_LEVEL
	BOOL OnDestroy()
	{
		SaveSetting("FolderTreeShowLevel", m_nShowLevel, STR_DLG_NAME);
		///Sophy 9/9/2009 MORE_WORK_ON_REMEMBER_LAST_SETTINGS_OF_INSERTVAR_DLG
		/// Kenny 09/11/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		//int nInsertMode = m_comboInsertMode.GetCurSel();
		int nInsertMode = getInsertMode();
		/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		SaveSetting(STR_INSERTMODE, nInsertMode, STR_DLG_NAME);	
		SaveSetting(STR_PROJECT_TREE_CTRL, m_dwPTCtrl, STR_DLG_NAME);
		///end MORE_WORK_ON_REMEMBER_LAST_SETTINGS_OF_INSERTVAR_DLG
		SaveSetting(STR_REG_LINK_WITH, m_comboLinkIndex.GetCurSel(), STR_DLG_NAME);
		
		SaveSetting(STR_REG_INSERT_TAB, m_tab.GetCurSel(), STR_DLG_NAME);			///Jasmine 07/23/2012 ORG-5458-S2 ACTIVATE_LABEL_TAB_BY_DEFAULT
			
		/// Kenny 09/04/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		ResizeDialog::SaveCheckBoxSettings();
		/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		
		///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
		if( isDispFormatShown() )
		{
			SaveSetting("DispFormat", m_comboDispFmt.GetCurSel(), STR_DLG_NAME);
			dlg_save_to_registry(STR_DLG_NAME, "CustomDispFormat", m_edCustomFmt.Text);
		}
		///End SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
		return MultiPaneDlg::OnDestroy();
	}
	///End FOLDER_TREE_KEEP_LAST_SHOWING_LEVEL

	BOOL OnReady()
	{
		///Joseph 02/15/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
		//UpdateDlgSize();	
		///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
		UpdateDlgShow();		
		SetInitReady();
		ShowWindow(SW_SHOW);
		return TRUE;
	}

	BOOL OnOK()
	{
		///Kyle 08/26/2009 QA80-14190 DEFINE_VARIABLE_FROM_COLUMN_LABELS_IN_SCV_DB
		/*
		bool bPropValPair = m_btnPorpValPair.Check;
		m_bUseLink = m_btnUseLink.Check;
		string strObj = GetItem(IDC_PASTEVAR_EDIT).Text;///Jasmine 03/22/07 ADD_RANGE_EDIT_BOX	
		//strObj = strObj.GetToken(1, ':');
		strObj.TrimLeft(); strObj.TrimRight();
		int nIndex = strObj.Find('!');
		if(-1 < nIndex)
			strObj = strObj.Left(nIndex);
		///Jasmine 01/17/07 CONVERT_VARIABLES_STRING
		///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
		//if(m_bInsertToCell)
		if(m_nValFormat != INSERT_INFO_VAL_FORMAT_TEXT_OBJECT)
		///End SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
			strObj += "!" + getObjLevelString(m_nNodeLevel);///Jasmine 03/22/07 SEPARATE_OBJ_LEVEL_AND_TREE_SHOW_LEVEL
		else
		{
			if(!strObj.Right(1).Compare("!"))
				strObj.TrimRight('!');
			if(!strObj.Right(1).Compare("]"))
			{
				strObj.TrimRight(']');
				strObj.TrimLeft('[');
			}
		}
		///End CONVERT_VARIABLES_STRING
		///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
		//m_InfoVars.GetSelStr(strObj, m_strRet, m_bUseLink, bPropValPair, m_bInsertToCell);///Jasmine 01/15/07 QA70-9269 INSERT_TO_CELL_AS_LINK
		int nInsertMode = m_comboVarType.GetCurSel();
		m_InfoVars.GetSelStr(strObj, m_strRet, m_vnDataTypes, m_bUseLink, bPropValPair, m_nValFormat, nInsertMode);
		///End SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
		*/
		// centralize code
		constructSelVars();
		///End DEFINE_VARIABLE_FROM_COLUMN_LABELS_IN_SCV_DB
		
		///Kyle 08/26/2009 INSERT_MULTIPLE_TIMES_FOR_SCV
		if(m_bMultiInsert)			// post message, not to close the dialog
		{
			if(m_vnDataTypes.GetSize() <= 0)		//
				return false;
			Window Wnd(GetParent());
			if(Wnd)
			{
				const void *pStrVal = (LPCSTR)m_strRet;
				ODWP wParam = (ODWP)pStrVal;

				string strDataTypes;
				vector<string> vsDataTypes;
				vector<int> vn;
				vn = m_vnDataTypes;					// convert_int_vector_to_string_vector requires vector<int>
				convert_int_vector_to_string_vector(vn, vsDataTypes);
				strDataTypes.SetTokens(vsDataTypes, '|');
				const void *pDataTypes = (LPCSTR)strDataTypes;
				ODWP lParam = (ODWP)pDataTypes;
				
				
				Wnd.SendMessage(WM_USER_VARIABLE_CLICK_INSERT, wParam, lParam);
			}

			return false;
		}
		///End INSERT_MULTIPLE_TIMES_FOR_SCV
		/// Kenny 09/04/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		//ResizeDialog::SaveCheckBoxSettings();
		/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS

		/// Kenny 02/23/2010 QA81-14845-P8 INSERT_VAL_FAILS_TO_INSERT_VAR_IN_INPLACE_EDIT_OF_RICH_TEXT_CELL
		// We need this dialog get closed of we are now inserting variable into a worksheet cell,
		// to do that, we need to return TRUE only if any cell was highlighted.
		Worksheet wks = Project.ActiveLayer();
		if ( wks )
		{
			Grid gg;
			gg.Attach(wks);
			if ( gg )
			{
				int nRow = -1, nCol = -1;
				gg.GetCurrentCell(nRow, nCol);
				if ( nRow >= 0)
					return TRUE;
			}
		}
		/// End QA81-14845-P8 INSERT_VAL_FAILS_TO_INSERT_VAR_IN_INPLACE_EDIT_OF_RICH_TEXT_CELL

		/// Kenny 12/19/2009 QA81-14845-P5 INSERT_USER_VAR_DLG_FOR_GOBJECT_SHOULD_NOT_CLOSE_ON_INSERT
		if ( INSERT_INFO_VAL_FORMAT_TEXT_OBJECT == m_nValFormat )
		{
			ASSERT(m_hParentWnd);
			Window Wnd( m_hParentWnd );
			if(Wnd)
			{
				const void *pStrVal = (LPCSTR)m_strRet;
				ODWP wParam = (ODWP)pStrVal;
				DWORD lParam = m_bUseLink;
				Wnd.PostMessage(WM_OTEXT_INSERT_STR, wParam, lParam);
				return FALSE;	// Must return FALSE to prevent this dialog get closed!
			}
		}
		/// End QA81-14845-P5 INSERT_USER_VAR_DLG_FOR_GOBJECT_SHOULD_NOT_CLOSE_ON_INSERT

		return TRUE;
	}

	///------ Folger 09/21/09 QA80-14283 GET_RID_OF_ONSELECTIONCHANGE_EVENT_DURING_GRID_ATTACH
	BOOL OnIdle()
	{
		okutil_dialog_event_special_bits_access(DIALOGEVENTSPECIALBITSOPTIONS_REMOVEALL);
		return TRUE;
	}
	///------ End GET_RID_OF_ONSELECTIONCHANGE_EVENT_DURING_GRID_ATTACH

	/// Kenny 09/10/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	BOOL OnVarTreeSelChange(Control ctrl)
	{	
		updateInsertBtnStatus();
		return TRUE;
	}
	/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	
	///Jasmine 06/11/2012 ORG-5458-S1 INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
	BOOL OnCheckInsertLink(Control ctrl)
	{
		m_comboLinkIndex.Visible = 	m_btnUseLink.Check 
									&& INSERT_INFO_VAL_FORMAT_TEXT_OBJECT == m_nValFormat 
									&& EXIST_PLOT == m_nActivePageType
									&& TAB_LABEL == m_tab.GetCurSel();///Jasmine 07/12/2012 ORG-5458-P1 PLOT_INDEX_NOT_WORK_FOR_FILE_INFO
		/*
		RECT 	rCombo, rCheck;
		GetClientRect(m_comboLinkIndex, rCombo);
		GetClientRect(m_btnUseLink, rCheck);
		int 	nGap 	= GetControlGap();
		rCombo.bottom 	= rCheck.bottom + nGap + RECT_HEIGHT(rCombo);
		rCombo.top 		= rCheck.bottom + nGap;
		rCombo.right	= rCheck.left + RECT_WIDTH(rCombo);
		rCombo.left 	= rCheck.left; 
		MoveControl(m_comboLinkIndex, rCombo);
		
		int 	nDy = RECT_HEIGHT(rCombo) + nGap;
		if(!m_comboLinkIndex.Visible)
			nDy *= -1;			
		
		vector<uint> vnIDs = {	IDC_PASTEVAR_STATIC_DISP_FMT, IDC_PASTEVAR_DISPLAY_FORMAT, IDC_PASTEVAR_CUSTOM_FORMAT, 
								IDC_PASTEVAR_CUSTOM_FORMAT_HINT, 0};
		MoveControls(vnIDs, 0, nDy);	
		
		showCustomFomatHint( m_comboDispFmt.GetCurSel() );
		*/
		return TRUE;
	}
	///End INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
	
	///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
	BOOL OnDispFmtSelChange(Control ctrl)
	{
		m_edCustomFmt.Enable = m_comboDispFmt.GetCurSel() == DISP_FMT_CUSTOM_FORMAT;
		showCustomFomatHint( m_comboDispFmt.GetCurSel() );///Jasmine 02/08/10 USER_NOT_USE_CUSTOM_FMT_MOSTLY
		return true;
	}
	///End SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT

	void UpdateTreePane(int nLevel = PTL_PAGE)
	{
		//get current page
		Page pg = Project.Pages();
		///Kyle 08/27/2009 QA80-14210 FIX_EMBEDDED_GRAPHS_HAS_NO_FOLDER
		//string strPage = pg.GetName(), strPath = pg.GetFolder().GetPath();
		if(!pg)		// error
			return;
		
		string strPage = pg.GetName();
		Folder fld = pg.GetFolder();
		if( !fld )			// try to get the folder of the parent page
		{
			Datasheet parentSheet;
			if(pg.GetEmbeddingInfo(parentSheet))
			{
				ASSERT(parentSheet);
				Page pgParent = parentSheet.GetPage();
				fld = pgParent.GetFolder();
			}
		}
		if(!fld)			// default folder: Project
		{
			fld = Project.ActiveFolder();
			ASSERT(fld);
		}
		string strPath = fld.GetPath();
		///End FIX_EMBEDDED_GRAPHS_HAS_NO_FOLDER
		strPath.TrimLeft('/');
		strPath.TrimRight('/');
		vector<string> vs;
		strPath.GetTokens(vs, '/');
		vs.Add(strPage);
		
		m_trFolder.ClearAll();
		m_tree.Reset();
		m_nShowLevel = nLevel;///Jasmine 03/22/07 SEPARATE_OBJ_LEVEL_AND_TREE_SHOW_LEVEL
		///Sophy 9/3/2009 QA80-14241 CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
		//bool flag = get_project_tree(m_tree, m_nShowLevel, pg.GetType());
		ProjectTreeOptions stOptions;
		stOptions.bGetEmbeddedGraph = false;
		stOptions.bSortPages = false;
		stOptions.bFilter3DGraph = false;
		stOptions.dwCtrl = m_dwPTCtrl;
		///end CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
		///Jasmine 12/16/09 QA81-14845-P4 SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
		if(INSERT_INFO_VAL_FORMAT_TEXT_OBJECT == m_nValFormat && EXIST_PLOT == m_nActivePageType)
		{	
			GraphLayer gl = Project.ActiveLayer();
			bool flag = get_graphlayer_plots(gl, m_tree, m_dwPTCtrl);
			flag = m_trFolder.AddTreeNodes(m_tree);	
			
			DataPlot dpActive;
			if(gl)
				dpActive = gl.DataPlots();
			
			int nIndex = -1;
			if(dpActive)
				nIndex = dpActive.GetIndex();
			
			TreeNode trActivePlot;
			if(nIndex > -1)
				trActivePlot = m_tree.GetNode("Plot"+nIndex);	
				
			if(trActivePlot)
			{
				int nRowExpand = tree_get_node_row(m_tree, trActivePlot);//m_tree does not show and get_node_row has 1 offset
				m_trFolder.SetAllCollapsed();

				if(nRowExpand > -1)
				{
					m_trFolder.SetCollapsed(nRowExpand, false);
					int nRow = trActivePlot.FirstNode? nRowExpand+1 : nRowExpand;						
					m_trFolder.SelRow(nRow);
				}
			}
		}
		else
		///End SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
		{
			bool flag = get_project_tree(m_tree, m_nShowLevel, m_nActivePageType, 0, NULL, stOptions);
			flag = m_trFolder.AddTreeNodes(m_tree, ATRN_LOOP_MARDED_NODE_ONLY);//, STR_DISPLAY_ATTRIB);	
			m_trFolder.SetAllCollapsed();
			
			int nRow = -1;
			for(int ii = 0; ii < vs.GetSize(); ii++)
				nRow = m_trFolder.FindRow(vs[ii], 0, false, true, nRow + 1);
			for(int nRowExpand = nRow; nRowExpand > -1;)
			{
				///------ Folger 05/08/2012 ORG-5627-P3 ORIGIN_CRASH_IF_WXGRID_TREE_WITH_MANY_ICONS
				//m_trFolder.SetCollapsed(nRowExpand, false);
				m_trFolder.SetIsCollapsed(nRowExpand, nRowExpand == nRow ? flexOutlineSubtotals : flexOutlineExpanded);
				///------ End ORIGIN_CRASH_IF_WXGRID_TREE_WITH_MANY_ICONS
				nRowExpand = m_trFolder.GetParent(nRowExpand);
			}
			m_trFolder.SelRow(nRow);
		}
	}
	/// Kenny 09/01/2009 QA81-14241 DEFINE_VARIABLE_MENU_WANTED
	void SwitchToTab(int nTab)
	{
		ASSERT( TAB_INFO == nTab || TAB_LABEL == nTab);
		m_tab.SetCurSel(nTab);
		checkEnableDispFormat();				///Kyle 02/02/2010 QA80-15056 NEED_INSERT_LABEL_FOR_TEXT_OBJECT
		UpdateInfoVar();
	}
	BOOL OnTabChange(Control ctrl)
	{
		///Jasmine 07/12/2012 ORG-5458-P1 PLOT_INDEX_NOT_WORK_FOR_FILE_INFO
		Control junk;
		OnCheckInsertLink(junk);
		///End PLOT_INDEX_NOT_WORK_FOR_FILE_INFO
		checkEnableDispFormat();				///Kyle 02/02/2010 QA80-15056 NEED_INSERT_LABEL_FOR_TEXT_OBJECT
		UpdateInfoVar();
		return TRUE;
	}
	BOOL GetInfoTreeObjAttribute(TreeNode& trSel, OriginObject& obj, int& nDataIndex, int& nLevel, int& nDisplay, string& strName)
	{
		int nSelRow = m_trFolder.GetSelectedRow();
		trSel = tree_get_node(m_tree, nSelRow);
		if( !trSel.IsValid() )//temp
			return FALSE;	
		trSel.GetAttribute(STR_DATA_ATTRIB, nDataIndex);	
		trSel.GetAttribute(STR_STOP_ATTRIB, nLevel);
		trSel.GetAttribute(STR_DISPLAY_ATTRIB, nDisplay);
		///Sophy 9/3/2009 QA80-14241 CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
		//trSel.GetAttribute(STR_LABEL_ATTRIB, strName);
		trSel.GetAttribute(STR_NAME_ATTRIB, strName);
		///------ Tony 07/13/2012 ORG-5387-P1 ADD_DATAOBJECT_SHORTNAME_ATTRIBUTE
		string strShortName;
		trSel.GetAttribute(STR_SHORTNAME_ATTRIB, strShortName);
		///------ End ADD_DATAOBJECT_SHORTNAME_ATTRIBUTE
		///end CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE

		switch(nLevel)
		{
		case PTL_OBJ:
			///Jasmine 12/16/09 QA81-14845-P4 SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
			DataPlot dp;
			okxf_resolve_string_get_origin_object(strName, &dp);
			if(dp)
			{
				obj = dp;
				break;
			}
			
			Column col;
			///------ Tony 07/13/2012 ORG-5387-P1 ADD_DATAOBJECT_SHORTNAME_ATTRIBUTE
			//okxf_resolve_string_get_origin_object(strName, &col);
			okxf_resolve_string_get_origin_object(strShortName, &col);
			///------ End ADD_DATAOBJECT_SHORTNAME_ATTRIBUTE
			if(col)
			{
				obj = col;
				break;
			}
			
			MatrixObject mo;
			okxf_resolve_string_get_origin_object(strName, &mo);
			if(mo)
			{
				obj = mo;
				break;
			}
			///End SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
			break;
		case PTL_LAYER:	
			///Jasmine 12/16/09 QA81-14845-P4 SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
			Worksheet wks;
			okxf_resolve_string_get_origin_object(strName, &wks);
			if(wks)
			{
				obj = wks;
				break;
			}

			MatrixLayer ml;
			okxf_resolve_string_get_origin_object(strName, &ml);
			if(ml)
			{
				obj = ml;
				break;
			}

			GraphLayer gl;
			okxf_resolve_string_get_origin_object(strName, &gl);
			if(gl)
			{
				obj = gl;
				break;
			}
			///End SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
			break;
		case PTL_PAGE:
			trSel.GetAttribute(STR_LABEL_ATTRIB, strName);
			///Jasmine 07/19/2012 ORG-5458-S1 ADD_OBJ_NAME_TO_IDENTIFY_EACH_NODE
			if(INSERT_INFO_VAL_FORMAT_TEXT_OBJECT == m_nValFormat && EXIST_PLOT == m_nActivePageType)
			{
				int nFind = strName.Find(" - ");
				if(nFind > 0)
					strName.Delete(0, nFind + 3);
			}
			///End ADD_OBJ_NAME_TO_IDENTIFY_EACH_NODE
			Page pg(strName);
			obj = pg;
			break;
		default:
			break;
		}
		return TRUE;
	}
	void UpdateObjectRangeString(OriginObject& obj)
	{
		if(obj.IsValid())
		{
			DWORD dwCtrl = NTYPE_GOOD_LN_OR_SN;
			DataPlot dp;
			dp = obj;
			if(dp)
				dwCtrl = NTYPE_FOR_RANGE;
			string strRange;
			obj.GetRangeString(strRange, dwCtrl);
			if( !strRange.Right(1).Compare("!") )
				strRange.TrimRight('!');
			GetItem(IDC_PASTEVAR_EDIT).Text = strRange;
		}
	}
	void GetLabelTree(TreeNode& tr)
	{
		TreeNode trSel;
		OriginObject obj;
		int nDataIndex, nLevel, nDisplay;
		string strName;
		if ( !GetInfoTreeObjAttribute(trSel, obj, nDataIndex, nLevel, nDisplay, strName) )
			return;
		m_nNodeLevel = nLevel;
		if ( PTL_OBJ == nLevel && obj.IsValid() )
		{
			Column col;
			col = obj;
			///------ Folger 09/21/09 QA80-14283 GET_RID_OF_ONSELECTIONCHANGE_EVENT_DURING_GRID_ATTACH
			okutil_dialog_event_special_bits_access(DIALOGEVENTSPECIALBITSOPTIONS_SET, DIALOGEVENTSPECIALBITS_GRIDATTACH);
			///------ End GET_RID_OF_ONSELECTIONCHANGE_EVENT_DURING_GRID_ATTACH
			tree_add_column_labels_info(tr, col);
		}
		UpdateObjectRangeString(obj);
	}
	/// End QA81-14241 DEFINE_VARIABLE_MENU_WANTED
	void GetInfoTree(TreeNode& tr)
	{
		/// Kenny 09/02/2009 QA81-14241 DEFINE_VARIABLE_MENU_WANTED
		TreeNode trSel;
		OriginObject obj;
		int nDataIndex, nLevel, nDisplay;
		string strName;
		if ( !GetInfoTreeObjAttribute(trSel, obj, nDataIndex, nLevel, nDisplay, strName) )
			return;
		m_nNodeLevel = nLevel;
		Tree trJunk;
		switch (nLevel)
		{
		///Jasmine 12/16/09 QA81-14845-P4 SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
		case PTL_OBJ:
			if(EXIST_PLOT == m_nActivePageType)
			{
				///Jasmine 12/28/09 QA81-14845-S1 ACCESS_SOURCE_BOOK_SHEET_COLUMN_FROM_PLOT
				//DataPlot dp;
				//dp = obj;
				//if(dp)
				//{
					//TreeNode trWkslist = trJunk.AddNode("InfoVars");
					//if( dataplot_get_info_tree(dp, trWkslist) )
						//tr = trWkslist;
				//}
				///End ACCESS_SOURCE_BOOK_SHEET_COLUMN_FROM_PLOT
			}
			break;
		///End SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
		case PTL_LAYER:
			if(EXIST_PLOT == m_nActivePageType)
			{
				GraphLayer glactive;
				glactive = obj;
				if(glactive)
				{
					TreeNode trWkslist = trJunk.AddNode("InfoVars");
					if( graph_get_info_tree(glactive, trWkslist) )
						tr = trWkslist;
					break;
				}
				//else obj is a datasheet
			}
			
			if(obj && tree_add_info(trJunk, obj, NULL, NULL, NPLOT_FOR_WKS))
				tr = trJunk;

			///Kyle 02/04/2010 READ_SHEET_INPORT_FILE_INFO
			tree_add_obj_import_file_info(obj, tr);
			///End READ_SHEET_INPORT_FILE_INFO

			break;
		case PTL_PAGE:
			Page pg;
			pg = obj;
			if( pg && tree_add_info(trJunk, pg, NULL, NULL, NPLOT_FOR_WKS) )
				tr = trJunk;
#ifdef SET_VALUES_SUPPORT_DEFINE_VARIBLE
			if(!(INSERT_INFO_FILTER_FILE_INFO&m_dwInfoFilter))
#endif //SET_VALUES_SUPPORT_DEFINE_VARIBLE
				tree_add_import_file_info(tr, pg);
			obj = pg;
			break;
		}
		if ( obj.IsValid() )
		{
			tree_add_user_tree_info(tr, obj);
		}
		UpdateObjectRangeString(obj);
		/// End QA81-14241 DEFINE_VARIABLE_MENU_WANTED
	}
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny)
	{
		if(IDC_PASTEVAR_PROJECT_TREE == nResIDCtrl)
			return showPTreeMenu(nx, ny);
		return FALSE;
	}
	void OnSelectTreeNode(Control ctrl)
	/// Kenny 09/01/2009 QA81-14241 DEFINE_VARIABLE_MENU_WANTED
	{
		UpdateInfoVar();
		///Sophy 9/3/2009 QA80-14241 CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
		bool bEnable = PTL_OBJ == m_nNodeLevel || PTL_LAYER == m_nNodeLevel;
		enableInsertMode(bEnable);
		///end CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
	}

	void UpdateInfoVar()
	/// End QA81-14241 DEFINE_VARIABLE_MENU_WANTED
	{
		if( !m_InfoVars.IsReady() )
			return;
		///Jasmine 12/16/09 QA81-14845-P4 SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
		/*
		///Kyle 08/13/2009 SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
		//if(!m_bInsertToCell)//no project tree for the old ctrl-H dlg
		if(INSERT_INFO_VAL_FORMAT_TEXT_OBJECT == m_nValFormat)
		///End SET_COLUMN_VALUES_SUPPORT_DEFINE_VARIABLES_IN_BASIC_DATA_TYPE
			return;
		*/
		///End SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
		Tree trInfo;
		/// Kenny 09/01/2009 QA81-14241 DEFINE_VARIABLE_MENU_WANTED
		//GetInfoTree(trInfo);
		int nSel = m_tab.GetCurSel();
		if ( TAB_INFO == nSel )
			GetInfoTree(trInfo);
		else
		{
			GetLabelTree(trInfo);
			///Kyle 02/02/2010 QA80-15056 NEED_INSERT_LABEL_FOR_TEXT_OBJECT
			int nColLabel = 1;
			trInfo.SetAttribute(STR_INSERT_VARIABLE_COL_LABEL_ATTRIB, nColLabel);
			///End NEED_INSERT_LABEL_FOR_TEXT_OBJECT
		}
		/// End QA81-14241 DEFINE_VARIABLE_MENU_WANTED
		m_InfoVars.Update(trInfo);
		
		///Jasmine 01/07/10 QA81-14845-S2 INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET
		indicateFileInfo(trInfo);
		///End INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET
	}
	//BOOL OnShowProjectTree(Control cntrl){ return MultiPaneDlg::OnShowBottomPane(cntrl);}
	
	///Joseph 02/15/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	BOOL	OnInitSize(int &left, int &top, int &right, int  &bottom)
	{
		return FALSE;
	}
	BOOL OnRestoreSize(ODWP dwSizeInfo)
	{
		void * p = (void*)dwSizeInfo;
		DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
		
		lstrcpyn(pSz->szDialogName, STR_DLG_NAME, MAXLINE);
		pSz->top = -1;
		pSz->left =-1;
		///Kyle 06/30/2009  Insert and Close buttons overlap with right panel of the Insert Info. variables dialog in Snow's Computer
		//pSz->width = max(800, getDlgMinWidth() + DEFAULT_RIGHT_PANE_WIDTH);
		/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//pSz->width = max(800, getDlgMinWidth() + max(DEFAULT_RIGHT_PANE_WIDTH, GetBottomPaneHeight()));
		pSz->width = max(800, GetMinTrackWidth() + max(DEFAULT_RIGHT_PANE_WIDTH, GetBottomPaneHeight()));
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		/// ------
		pSz->height = 400;
		//SetBottomPaneHeight(120);		//------Folger 07/19/07 FIXED_BUGS_IN_DIALOG_RESIZE
		return TRUE;
	}
	///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
private:
	///Jasmine 01/07/10 QA81-14845-S2 INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET
	int getPageRow(int nRow, int nLevel)
	{
		if(nRow < 0)
			return -1;
		
		for(int nPaRow = nRow, nPaLevel = nLevel; nPaLevel > PTL_PAGE; nPaLevel--)
		{
			nPaRow = m_trFolder.GetParent(nPaRow);
			if(nPaRow < 0)			
				break;
		}
		///Jasmine 06/12/2012 ORG-5458-S1 RESTRUCTURE_PLOT_TREE_FOR_INSERT_VAR_DB
		TreeNode trPage = tree_get_node(m_tree, nPaRow);
		int nStopLevel;
		if(!trPage || !trPage.GetAttribute(STR_STOP_ATTRIB, nStopLevel) || PTL_PAGE != nStopLevel)
			nPaRow = -1;
		///End RESTRUCTURE_PLOT_TREE_FOR_INSERT_VAR_DB
		
		if(nPaRow < 0)
		{
			///Jasmine 06/12/2012 ORG-5458-S1 RESTRUCTURE_PLOT_TREE_FOR_INSERT_VAR_DB
			//return -1;
			TreeNode trSel = tree_get_node(m_tree, nRow);
			if(PTL_LAYER == nLevel && trSel && trSel.PrevNode)
			{
				trPage = trSel.PrevNode;
				if(trPage.GetAttribute(STR_STOP_ATTRIB, nStopLevel) && PTL_PAGE == nStopLevel)
					return nRow - 1;
			}
			
			if(trSel)
			{
				trPage = trSel.FindNodeByAttribute(STR_STOP_ATTRIB, PTL_PAGE); 
				if(trPage)
				{
					nPaRow = tree_get_node_row(m_tree, trPage);
					return nPaRow;
				}
			}
			///End RESTRUCTURE_PLOT_TREE_FOR_INSERT_VAR_DB
		}
		
		ASSERT(m_trFolder.GetLevel(nRow) - m_trFolder.GetLevel(nPaRow) == nLevel - nPaLevel);
		return nPaRow;
	}
	
	void indicateFileInfo(const TreeNode& trInfo)
	{
		TreeNode trSel;
		OriginObject obj;
		int nDataIndex, nLevel, nDisplay;
		string strName;
		if ( !GetInfoTreeObjAttribute(trSel, obj, nDataIndex, nLevel, nDisplay, strName) 
			|| PTL_PAGE != nLevel) //book storage has many File1, File2...so it need to indicate one of them
			return;
		
		Page pg;
		pg = obj;
		if(!pg)
			return;
		
		TreeNodeCollection trColl;
		bool bValid = false;//Collection class does not have IsValid()
		//TreeNode File1 may be deleted in Workbook Organizer
		string strPrefix = "File";
		Tree trFiles;
		tree_add_import_file_info(trFiles, pg);
		if(trFiles.FirstNode)
		{
			ASSERT( trFiles.FirstNode.tagName.Find(strPrefix) == 0 );
			TreeNode trOneFile = tree_get_node_by_tagname(trInfo, trFiles.FirstNode.tagName, true);
			if( trOneFile && trOneFile.Parent() )
			{
				TreeNodeCollection trTempColl(trOneFile.Parent(), strPrefix);
				trColl = trTempColl;
				bValid = true;
			}
		}
		int nCount = bValid? trColl.Count() : 0;
		if(nCount <= 0)
			return;
		
		if(INSERT_INFO_VAL_FORMAT_TEXT_OBJECT == m_nValFormat && EXIST_PLOT == m_nActivePageType)
		{
			int nStopLevel = -1;
			for(TreeNode trDataObj = trSel; trDataObj.FirstNode.IsValid(); trDataObj = trDataObj.FirstNode)
			{	
				trDataObj.GetAttribute(STR_STOP_ATTRIB, nStopLevel);
				if(PTL_OBJ == nStopLevel)
					break;	
			}
			trDataObj.GetAttribute(STR_STOP_ATTRIB, nStopLevel);
			///Jasmine 06/12/2012 ORG-5458-S1 RESTRUCTURE_PLOT_TREE_FOR_INSERT_VAR_DB
			if(PTL_OBJ != nStopLevel)
			{
				for(trDataObj = trSel; trDataObj.Parent().IsValid(); trDataObj = trDataObj.Parent())
				{	
					trDataObj.GetAttribute(STR_STOP_ATTRIB, nStopLevel);
					if(PTL_OBJ == nStopLevel)
						break;	
				}
			}
			///End RESTRUCTURE_PLOT_TREE_FOR_INSERT_VAR_DB
			ASSERT(PTL_OBJ == nStopLevel);
			
			string strRange;
			trDataObj.GetAttribute(STR_NAME_ATTRIB, strRange);
			
			int nRow;
			string strIndicatedNode = _find_compatible_range_node(trColl, strRange);	
			if( !strIndicatedNode.IsEmpty() )
				nRow = m_InfoVars.FindRow(strIndicatedNode, 0, true);
			if(nRow > -1)
				m_InfoVars.SetBold(nRow, 0, true);
		}
		
		if( !m_strGoTo.IsEmpty() )
		{
			int nRow;
			string strIndicatedNode = _find_compatible_range_node(trColl, m_strGoTo);
			if( !strIndicatedNode.IsEmpty() )
				nRow = m_InfoVars.FindRow(strIndicatedNode, 0, true);
			if(nRow > -1)
				m_InfoVars.SelRow(nRow);
			m_strGoTo = "";
		}
	}
	///End INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET
		
	///Sophy 9/3/2009 QA80-14241 CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
	void enableInsertMode(bool bEnable = true)
	{
		m_comboInsertMode.Enable = bEnable;
		
		///Jasmine 12/16/09 QA81-14845-P4 SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
		if(INSERT_INFO_VAL_FORMAT_TEXT_OBJECT == m_nValFormat && EXIST_PLOT == m_nActivePageType)
		{
			m_comboInsertMode.Enable = 
			m_comboInsertMode.Visible = 
			GetItem(IDC_PASTEVAR_STATIC_INSERT_MODE).Visible = false;
		}
		///End SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
	}
	///end CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
	///Kyle 08/27/2009 QA80-14213 HIDE_INSERT_MODE_FOR_INSERT_VARIABLE_WKS_CELL_TEXT_OBJECT
	/// Kenny 09/03/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
// 	void arrangeInsertModeBtns()
// 	{
// 		if(m_bEnableVarType == false)
// 		{
// 			GetItem(IDC_PASTEVAR_STATIC_VAR_TYPE).Visible = false;
// 			m_comboVarType.Visible = false;
// 
// 			Control ctrlLink = GetItem(IDC_PASTEVAR_KEEP_LINK);
// 			RECT rr;
// 			GetClientRect(ctrlLink, rr);
// 			
// 			int nTabTop = rr.bottom + GetControlGap();
// 			GetClientRect(m_tab, rr);
// 			int nHeight = RECT_HEIGHT(rr);
// 			rr.top = nTabTop;
// 			rr.bottom = rr.top + nHeight;
// 			MoveControl(m_tab, rr);
// 		}
// 	}
	void arrangeFullRangeCtrl()
	{
		BOOL bShowFullRangeCtrl = FALSE;//m_nValFormat != INSERT_INFO_VAL_FORMAT_TEXT_OBJECT;
		Control ctrl = GetItem(IDC_PASTEVAR_FULL_RANGE);
		ctrl.Visible = bShowFullRangeCtrl;
		if ( bShowFullRangeCtrl )
		{
			ASSERT( !m_btnPorpValPair.Visible );
			RECT rect;
			GetClientRect(m_btnPorpValPair, rect);
			POINT pt;
			pt.x = rect.left;
			pt.y = rect.top;
			GetClientRect(ctrl, rect);
			rect.right += pt.x - rect.left;
			rect.bottom += pt.y - rect.top;
			rect.left = pt.x;
			rect.top = pt.y;
			MoveControl(ctrl, rect);
		}
	}
	void arrangeVarTypeBtns()
	{
		if ( !m_bEnableVarType )
		{
			Control ctrlStatic = GetItem(IDC_PASTEVAR_STATIC_VAR_TYPE);
			ctrlStatic.Visible = FALSE;
			m_comboVarType.Visible = FALSE;

			// Move the static control and the insert mode combo to the left side that the var type combo was placed at.
			RECT rect;
			GetClientRect(ctrlStatic, rect);
			int nX1 = rect.left;
			
			ctrlStatic = GetItem(IDC_PASTEVAR_STATIC_INSERT_MODE);
			GetClientRect(ctrlStatic, rect);
			int nXOffset = rect.left - nX1;

			rect.left -= nXOffset;
			rect.right -= nXOffset;
			MoveControl(ctrlStatic, rect);

			GetClientRect(m_comboInsertMode, rect);
			rect.left -= nXOffset;
			rect.right -= nXOffset;
			MoveControl(m_comboInsertMode, rect);
		}
	}
	///Kyle 02/02/2010 QA80-15056 NEED_INSERT_LABEL_FOR_TEXT_OBJECT
	void checkEnableDispFormat()
	{
		if( isDispFormatShown() )
		{
			enableDispFormat(TAB_INFO == m_tab.GetCurSel());
		}
	}

	void enableDispFormat(bool bEnable = true)
	{
		if( !isDispFormatShown() )
		{
			ASSERT(false);
			return;
		}
		m_comboDispFmt.Enable = bEnable;
		m_edCustomFmt.Enable = bEnable && DISP_FMT_CUSTOM_FORMAT==m_comboDispFmt.GetCurSel();
	}
	///End NEED_INSERT_LABEL_FOR_TEXT_OBJECT
	///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
	bool isDispFormatShown()
	{
		return (m_nValFormat == INSERT_INFO_VAL_FORMAT_TEXT_OBJECT && EXIST_PLOT == m_nActivePageType);
	}

	void arrangeDispFormatBtns()
	{
		if( isDispFormatShown() )
		{
			// position
			RECT rect;
			int nx, ny, nGap, nWidth, nHeight;

			nGap = GetControlGap();

			GetClientRect(m_btnUseLink, rect);
			nx = rect.left;
			ny = rect.bottom + nGap;

			uint nDispFmtButtonIDs[] = {IDC_PASTEVAR_STATIC_DISP_FMT, IDC_PASTEVAR_DISPLAY_FORMAT, IDC_PASTEVAR_CUSTOM_FORMAT, 0};
			ArrangeControlsLeftRight(nDispFmtButtonIDs, nx, ny, nGap);

			GetClientRect(m_ctrlStaticDispFmt, rect);
			nx = rect.left;
			ny = rect.bottom + nGap;

			GetClientRect(m_edCustomFmtHint, rect);
			nWidth = RECT_WIDTH(rect);
			nHeight = RECT_HEIGHT(rect);
			rect.left = nx;
			rect.right = nx + nWidth;
			rect.top = ny;
			rect.bottom = ny + nHeight;
			MoveControl(m_edCustomFmtHint, rect);
			
			ny = rect.bottom + nGap;
			GetClientRect(m_tab, rect);
			rect.top = ny;
			MoveControl(m_tab, rect);

			// context
			m_comboDispFmt.ResetContent();
			vector<string> vsItems;
			vsItems.Add(STR_DISP_FMT_NONT);
			vsItems.Add(STR_DISP_FMT_FOLLOW_INFO_STORAGE);
			vsItems.Add(STR_DISP_FMT_CUSTOM_FORMAT);
			for(int ii = 0; ii < vsItems.GetSize(); ii++)
				m_comboDispFmt.AddString(vsItems[ii]);
			
			int nCurSel = LoadSetting("DispFormat", DISP_FMT_FOLLOW_INFO_STORAGE, STR_DLG_NAME);
			m_comboDispFmt.SetCurSel(nCurSel);
			showCustomFomatHint(nCurSel);	///Jasmine 02/08/10 USER_NOT_USE_CUSTOM_FMT_MOSTLY

			string strCustomFormat;
			dlg_load_registry(STR_DLG_NAME, "CustomDispFormat", strCustomFormat);
			m_edCustomFmt.Text = strCustomFormat;
			m_edCustomFmt.Enable = (nCurSel == DISP_FMT_CUSTOM_FORMAT);
	
			m_edCustomFmtHint.Enable = false;
			/// Kenny 06/23/2010 ORG-127-S1 ADD_HINT_TO_GUIDE_USAGE_OF_DISPLAY_FORMAT_OF_LABEL_FORM
			//m_edCustomFmtHint.Text = _L("Use *n to set significant digits, add * at the end to trim trailing zero.\nUse Dnn/Tnn to display the data in date/time format. nn matches the index (0 offset) in the Display dropdown list of Format Cells dialog.");
			string strText;
			ocu_load_err_msg_str(IDS_DISPLAY_FORMAT_STRING_HINT, &strText);
			m_edCustomFmtHint.Text = strText;
			/// End ORG-127-S1 ADD_HINT_TO_GUIDE_USAGE_OF_DISPLAY_FORMAT_OF_LABEL_FORM
			m_edCustomFmtHint.SetTextColor(0, -1, color_index_to_rgb(SYSCOLOR_BLUE));
		}
		else
		{
			m_ctrlStaticDispFmt.Visible = false;
			m_comboDispFmt.Visible = false;
			m_edCustomFmt.Visible = false;
			m_edCustomFmtHint.Visible = false;
		}
	}
	///End SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
	/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	///End HIDE_INSERT_MODE_FOR_INSERT_VARIABLE_WKS_CELL_TEXT_OBJECT
	
	///Jasmine 02/08/10 USER_NOT_USE_CUSTOM_FMT_MOSTLY
	void showCustomFomatHint(int nFomat = -1)
	{
		RECT rHint;
		GetClientRect(m_edCustomFmtHint, rHint);
		
		RECT rTab;
		GetClientRect(m_tab, rTab);
		
		if(DISP_FMT_CUSTOM_FORMAT == nFomat)
		{
			m_edCustomFmtHint.Visible = true;			
			rTab.top = rHint.bottom + GetControlGap();
		}
		else
		{
			m_edCustomFmtHint.Visible = false;			
			rTab.top = rHint.top;
		}
		
		MoveControl(m_tab, rTab);		
		m_tab.AdjustRect(FALSE, &rTab);
		GetItem(IDC_PASTEVAR_TREE).MoveWindow(&rTab);
	}
	///End USER_NOT_USE_CUSTOM_FMT_MOSTLY
	
	/// Kenny 09/03/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	void updateInsertBtnStatus()
	{
		vector<uint> arrRows;
		TreeEditor trEditor = GetItem(IDC_PASTEVAR_TREE);
		BOOL bEnable = trEditor.GetSelectedRows(&arrRows, TRUE) > 0;
		GetItem(IDOK).Enable = bEnable;
	}
	int getInsertMode()
	{
		return m_comboInsertMode.GetCurSel();
	}
	
	///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
	//bool getSelectedObjInTree(WorksheetPage& wkp, Worksheet& wks, Column& col)
	bool getSelectedObjInTree(Page& pg, Layer& layer, DataObject& obj)
	///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
	{
		TreeNode trSel;
		OriginObject ObjTmp;
		int nDataIndex, nLevel, nDisplay;
		string strName;
		if ( !GetInfoTreeObjAttribute(trSel, ObjTmp, nDataIndex, nLevel, nDisplay, strName) )
			return false;
		switch (nLevel)
		{
		case PTL_PAGE:
			///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
			//wkp = ObjTmp;
			pg = ObjTmp;
			///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
			break;
		case PTL_LAYER:
			///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
			//wks = ObjTmp;
			//wks.GetParent(wkp);
			layer = ObjTmp;
			if(layer)
				pg = layer.GetPage();
			///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
			break;
		case PTL_OBJ:
			///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
			//col = ObjTmp;
			//col.GetParent(wks);
			//if ( wks )
			//	wks.GetParent(wkp);
			obj = ObjTmp;
			obj.GetParent(layer);
			if( layer )
				pg = layer.GetPage();
			///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
			break;
		}
		return true;
	}
	/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
	
	///Jasmine 12/28/09 QA81-14845-S1 ACCESS_SOURCE_BOOK_SHEET_COLUMN_FROM_PLOT
	int getPlotindexFromTreeData()
	{		
		int nSelRow = m_trFolder.GetSelectedRow();
		TreeNode trSel = tree_get_node(m_tree, nSelRow);
		
		for(int nPlotIndex = -1;;)
		{
			if(!trSel)
				break;
			if( trSel.tagName.Find("Plot") > -1 && trSel.GetAttribute(STR_DATA_ATTRIB, nPlotIndex) )
				break;
			trSel = trSel.Parent();
		}
		
		return nPlotIndex+1;//for labtalk 
	}
	///End 	ACCESS_SOURCE_BOOK_SHEET_COLUMN_FROM_PLOT
	
	///Jasmine 06/11/2012 ORG-5458-S1 INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
	string getPlotDesigFromTreeData()
	{
		string strDesig = "";
		int nSelRow = m_trFolder.GetSelectedRow();
		TreeNode trSel = tree_get_node(m_tree, nSelRow);
		
		for(;;)
		{
			if(!trSel)
				break;
			
			int nStopLevel;
			trSel.GetAttribute(STR_STOP_ATTRIB, nStopLevel);
			if(PTL_OBJ == nStopLevel)
			{
				trSel.GetAttribute(STR_COL_DESIGNATION_ATTRIB, strDesig);
				break;
			}
			else
				trSel = trSel.Parent();
		}
		
		return strDesig;
	}
	
	bool isInsertLinkWithPlotIndex()
	{
		return (m_comboLinkIndex.Visible == TRUE && m_comboLinkIndex.GetCurSel() == INSERT_LINK_WITH_PLOT_INDEX);
	}
	///End INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
	
	///Kyle 08/26/2009 QA80-14190 DEFINE_VARIABLE_FROM_COLUMN_LABELS_IN_SCV_DB
	void constructSelVars()
	{
		bool bPropValPair = m_btnPorpValPair.Check;
		m_bUseLink = m_btnUseLink.Check;
		string strObj;
		///Jasmine 12/28/09 QA81-14845-S1 ACCESS_SOURCE_BOOK_SHEET_COLUMN_FROM_PLOT
		if(m_nValFormat == INSERT_INFO_VAL_FORMAT_TEXT_OBJECT && m_bUseLink && EXIST_PLOT == m_nActivePageType)
		{
			///Jasmine 06/11/2012 ORG-5458-S1 INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
			//strObj.Format( "%d@W", getPlotindexFromTreeData() );
			int nPlotIndex = getPlotindexFromTreeData();
			strObj.Format( "%d@W", nPlotIndex);
			if( isInsertLinkWithPlotIndex() )
			{
				string strDesig = getPlotDesigFromTreeData();
				if( strDesig.IsEmpty() )
					ASSERT(0);
				else
					strObj.Format("%d%s", nPlotIndex, strDesig);
			}
			///End INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
		}
		///End ACCESS_SOURCE_BOOK_SHEET_COLUMN_FROM_PLOT
		else
		{
			strObj = GetItem(IDC_PASTEVAR_EDIT).Text;
			strObj.TrimLeft(); strObj.TrimRight();
		}
	
		/// Kenny 09/03/2009 QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		Button btn = GetItem(IDC_PASTEVAR_FULL_RANGE);
		BOOL bInsertAsFullRange = btn.Visible && btn.Check;
		PFN_SMART_UPDATE_OBJ_RANGE pfn_smart_update_obj_range = Project.FindFunction("smart_update_obj_range", "Originlab\\event_utils.c", true);
		///Jasmine 07/12/2012 ORG-5458 SMART_UPDATE_MAKE_NO_SENSE_FOR_PLOT_INDEX_OBJ_RANGE
		//if ( pfn_smart_update_obj_range )
		if( isInsertLinkWithPlotIndex() )
		{
			;//strObj is "1Y" and no need to call smart_update_obj_range
		}
		else if ( pfn_smart_update_obj_range )
		///End SMART_UPDATE_MAKE_NO_SENSE_FOR_PLOT_INDEX_OBJ_RANGE
		{
			ObjNameInfo info;
			///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
			//info.nSelectedColUID = m_nCurColUID;
			info.nSelectedObjUID = m_nCurColUID;
			///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
			info.nInsertMode = getInsertMode();
			info.nObjLevel = m_nNodeLevel;
			info.bFullRange = bInsertAsFullRange;
			info.dwSmartCtrl = (TAB_INFO == m_tab.GetCurSel() ? SMART_INFO_VAR : SMART_COL_LABEL);	///Sophy 9/17/2009 SMART_PAGE_NAME_WHEN_INSERT_VAR_INFO_IN_SAME_PAGE
			///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
			//if ( getSelectedObjInTree(info.wkp, info.wks, info.col) )
			if( getSelectedObjInTree(info.pg, info.layer, info.obj) )
			///End DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
			{
				bool bRet = pfn_smart_update_obj_range(strObj, info);
				///Jasmine 12/14/09 QA81-14845 NO_ASSERT_IF_UID_NOT_PROVIDE
				if(m_nCurColUID != 0)
				///End NO_ASSERT_IF_UID_NOT_PROVIDE
					ASSERT(bRet);
			}
		}
		else
		{
			ASSERT(0);
		}
		/// End QA81-14241 DEFINE_VARIABLE_NEED_MORE_IMPROVEMENTS
		
		string strObjLevelStr = getObjLevelString(m_nNodeLevel);
		
		int nVarType = m_comboVarType.GetCurSel();
		
		///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
		//UserVarConstructHelper helper(strObj, strObjLevelStr, m_nNodeLevel, m_bUseLink, bPropValPair, m_nValFormat, nVarType);
		/// Bill 02/23/2011 ORG-2261-S2 CHECK_VERBATIM_IN_THE_INSERT_VARIABLE_DIALOG
		//UserVarConstructHelper helper(strObj, strObjLevelStr, m_nNodeLevel, m_bUseLink, bPropValPair, m_nValFormat, nVarType, getNumericDisFmt());
		UserVarConstructHelper helper(	strObj, strObjLevelStr, m_nNodeLevel, m_bUseLink, bPropValPair, m_hParentWnd, m_nValFormat, nVarType, getNumericDisFmt(), 
										isInsertLinkWithPlotIndex() );	///Jasmine 06/11/2012 ORG-5458-S1 INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
		/// End CHECK_VERBATIM_IN_THE_INSERT_VARIABLE_DIALOG
		///End SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
		m_strRet.Empty();
		m_vnDataTypes.SetSize(0);
		m_InfoVars.GetSelStr(m_strRet, m_vnDataTypes, helper);
	}
	///End DEFINE_VARIABLE_FROM_COLUMN_LABELS_IN_SCV_DB
	
	///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
	string getNumericDisFmt()
	{
		//special handling, if from text object in wks, the display format controls is not shown, so by default follows the format in info storage
		if( m_nValFormat == INSERT_INFO_VAL_FORMAT_TEXT_OBJECT && EXIST_WKS == m_nActivePageType)
		{
			return "0";
		}

		if( !isDispFormatShown() )
			return "";

		string strFmt;
		switch(m_comboDispFmt.GetCurSel())
		{
		case DISP_FMT_NONT:
			strFmt = "";
			break;
		case DISP_FMT_FOLLOW_INFO_STORAGE:
			strFmt = "0";
			break;
		case DISP_FMT_CUSTOM_FORMAT:
			strFmt = m_edCustomFmt.Text;
			strFmt.TrimLeft();
			strFmt.TrimRight();
			break;
		default:
			ASSERT(false);
		}
		return strFmt;
	}
	///End SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT

	void initFolderTree()
	{
		m_trFolder.Init(IDC_PASTEVAR_PROJECT_TREE, *this);		

		/// Kenny 09/02/2009 QA81-14241 DEFINE_VARIABLE_MENU_WANTED
		m_trFolder.SetAllowSelection(false);
		m_trFolder.SetSelection(flexSelectionByRow);
		/// End QA81-14241 DEFINE_VARIABLE_MENU_WANTED
		
		m_trFolder.SetColAlignment(-1, flexAlignLeftCenter);
		
		///Kyle 07/06/2009 FOLDER_TREE_KEEP_LAST_SHOWING_LEVEL
		//UpdateTreePane();
		/// Kenny 09/02/2009 QA81-14241 DEFINE_VARIABLE_MENU_WANTED
		//int nLevel = LoadSetting("FolderTreeShowLevel", PTL_PAGE, STR_DLG_NAME);
		int nLevel;
		if ( m_dwCtrl & INSERT_INFO_OPEN_LABEL_TAB )
			nLevel = PTL_OBJ;
		else
			nLevel = LoadSetting("FolderTreeShowLevel", PTL_PAGE, STR_DLG_NAME);
		/// End QA81-14241 DEFINE_VARIABLE_MENU_WANTED
		
		// make sure nLevel = PTL_PAGE, PTL_LAYER or PTL_OBJ
		if(nLevel != PTL_PAGE && nLevel != PTL_LAYER && nLevel != PTL_OBJ)
			nLevel = PTL_PAGE;

		///Jasmine 12/16/09 QA81-14845-P4 SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
		if(INSERT_INFO_VAL_FORMAT_TEXT_OBJECT == m_nValFormat && EXIST_PLOT == m_nActivePageType)
			nLevel = PTL_OBJ;//always show to dataplot level
		///End SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK

		UpdateTreePane(nLevel);
		///End FOLDER_TREE_KEEP_LAST_SHOWING_LEVEL

		/// Kenny 09/02/2009 QA81-14241 DEFINE_VARIABLE_MENU_WANTED
		if ( m_dwCtrl & INSERT_INFO_OPEN_LABEL_TAB )
		{
			///Sophy 9/9/2009 INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG
			Column col;
			col = (Column)Project.GetObject(m_nCurColUID);
			if ( col )
			{
				int nSelRow = -1;
				string strRange;
				col.GetRangeString(strRange);
				if ( (m_dwPTCtrl & PT_CTRL_SHOW_FULL_RANGE) ) 
				{
					nSelRow = m_trFolder.FindRow(strRange, 0, false, true, nSelRow + 1);
				}
				else	//not show full range string
				{
					string strPage, strLayer, strObj;
					okutil_parse_complete_range_string(strRange, &strPage, &strLayer, &strObj);
					nSelRow = m_trFolder.FindRow(strPage, 0, false, true, nSelRow + 1);
					nSelRow = m_trFolder.FindRow(strLayer, 0, false, true, nSelRow + 1);
					
					strObj = get_column_name(col, true, true);
					nSelRow = m_trFolder.FindRow(strObj, 0, false, true, nSelRow + 1);
				}
				m_trFolder.SelRow(nSelRow);
			}
			///end INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG
		}
		/// End QA81-14241 DEFINE_VARIABLE_MENU_WANTED
	}
	bool showPTreeMenu(int nx, int ny)
	{		
		int nClickRow, nClickCol, nCmd, nLevel = m_nShowLevel;///Jasmine 03/22/07 SEPARATE_OBJ_LEVEL_AND_TREE_SHOW_LEVEL
		m_trFolder.GetMouseCell(nClickRow, nClickCol);
		m_trFolder.SelRow(nClickRow);
		
		///Jasmine 12/16/09 QA81-14845-P4 SHOW_SELECTED_PLOT_INFO_TO_AVOID_DUPLICATED_SOURCE_BOOK
		int nLimitToLevel = -1;
		if(INSERT_INFO_VAL_FORMAT_TEXT_OBJECT == m_nValFormat && EXIST_PLOT == m_nActivePageType)
		{
			nLimitToLevel = PTL_OBJ;
			ASSERT(m_nShowLevel == nLimitToLevel);
		}
		
		///Jasmine 01/07/10 QA81-14845-S2 INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET
		string strRange;
		int nSelLevel 	= -1;
		int nSelRow = m_trFolder.GetSelectedRow();
		TreeNode trSel = tree_get_node(m_tree, nSelRow);
		if( trSel.IsValid() )
		{
			trSel.GetAttribute(STR_STOP_ATTRIB, nSelLevel);
			trSel.GetAttribute(STR_NAME_ATTRIB, strRange);
		}
		///End INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET
		
		///Sophy 9/3/2009 QA80-14241 CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
		//PTreeMenu	myMenu(m_nShowLevel);
		//PTreeMenu	myMenu(m_nShowLevel, m_dwPTCtrl, nLimitToLevel);
		PTreeMenuControl menuCtrl;
		menuCtrl.dwPTCtrl 		= m_dwPTCtrl;
		menuCtrl.nShowingLevel 	= m_nShowLevel;
		menuCtrl.nLimitToLevel 	= nLimitToLevel;
		menuCtrl.nNodeLevel 	= nSelLevel;
		PTreeMenu	myMenu(menuCtrl);
		///end CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
		myMenu.TrackPopupMenu(0,  nx, ny, GetSafeHwnd());
		if(myMenu.GetCommand(nCmd))
		{
			switch(nCmd)
			{
			case PT_SHOW_PAGE:
				nLevel = PTL_PAGE;
				break;
			case PT_SHOW_LAYER:
				nLevel = PTL_LAYER;
				break;
			case PT_SHOW_OBJECT:
				nLevel = PTL_OBJ;
				break;
			///Sophy 9/3/2009 QA80-14241 CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
			case PT_SHOW_FULL_RANGE:
				m_dwPTCtrl = m_dwPTCtrl & PT_CTRL_SHOW_FULL_RANGE ? (m_dwPTCtrl & ~PT_CTRL_SHOW_FULL_RANGE) : (m_dwPTCtrl |= PT_CTRL_SHOW_FULL_RANGE);
				break;
			///end CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
			///Jasmine 01/07/10 QA81-14845-S2 INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET
			case PT_GO_TO_FILE_INFO:
				m_strGoTo = strRange;
				int nPageRow = getPageRow(nSelRow, nSelLevel);
				m_trFolder.SelRow(nPageRow);
				break;
			///End INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET
			}
			
			if(INSERT_INFO_VAL_FORMAT_TEXT_OBJECT == m_nValFormat && EXIST_PLOT == m_nActivePageType)
				ASSERT(nCmd != PT_SHOW_PAGE && nCmd != PT_SHOW_LAYER);
			
			///Sophy 9/3/2009 QA80-14241 CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
			//if(m_nShowLevel != nLevel)///Jasmine 03/22/07 SEPARATE_OBJ_LEVEL_AND_TREE_SHOW_LEVEL
			if ( m_nShowLevel != nLevel || nCmd == PT_SHOW_FULL_RANGE ) //PT_SHOW_FULL_RANGE is an check/uncheck item, need to swich status whenever click on it.
			///end CTRL_WHETHER_SHOW_FULL_SYNTAX_OF_RANGE_IN_PROJECT_TREE
				UpdateTreePane(nLevel);
		}
		return TRUE;
	}
	string getObjLevelString(int nLevel)
	{
		switch(nLevel)
		{
		case PTL_PAGE:			
			return "page";
		case PTL_LAYER:			
			return "layer";
		case PTL_OBJ://now only col:	
			string strObj = GetItem(IDC_PASTEVAR_EDIT).Text;///Jasmine 03/22/07 ADD_RANGE_EDIT_BOX	
			//strObj = strObj.GetToken(1, ':');
			strObj.TrimLeft(); strObj.TrimRight();
			vector<string> vs;
			int nIndex;
			if(strObj.GetTokens(vs, '!'))
			{
				int nIndex;
				TreeNode trSel = tree_get_node(m_tree, m_trFolder.GetSelectedRow());
				///Jasmine 03/22/07 MODIFICATION_ON_GET_PROJECT_TREE	
				if(trSel.IsValid())//temp
					trSel.GetAttribute(STR_DATA_ATTRIB, nIndex);	
				Worksheet wks(vs[0]);
				Column col;
				if(wks)
					col = wks.Columns(nIndex);//vs[1].Mid(4, vs[1].GetLength()-5));
				if(col)
					return "wks.col" + (nIndex+1);//col.GetIndex()+1);
			}	///End MODIFICATION_ON_GET_PROJECT_TREE
			break;
		}
		return "";
	}
	///End SHOW_USER_TREE_INFO_IN_USER_VAR_DLG
	/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//int getDlgMinWidth()
	int getMinClientWidth()
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	{
		Control ctrl = GetItem(IDOK);
		if(!ctrl)
			return MIN_MAIN_DLG_WIDTH;
		
		RECT rr;
		GetClientRect(ctrl, rr);
		///Sophy 7/27/2011 ORG-3189-P2 NEED_PROPER_POSITION_DIALOG_CONTROL_ON_120_DPI_SETTINGS
		//return rr.right + GetControlGap();
		int nRight = rr.right;
		GetClientRect(m_edCustomFmtHint, rr);
		if ( nRight < rr.right )
			nRight = rr.right;
		GetClientRect(m_comboInsertMode, rr);
		if ( nRight < rr.right )
			nRight = rr.right;
		return (nRight + 2 * GetControlGap());
		///end NEED_PROPER_POSITION_DIALOG_CONTROL_ON_120_DPI_SETTINGS
	}
private:
	///////////////////////////////////////////////////////
	/// General utilities
	///////////////////////////////////////////////////////
	
	// from the given graph, we will add all the page.info.User.Variables to our tree 
	bool graph_get_info_tree(GraphLayer gl, TreeNode& trNode)
	{
		return page_graph_get_info_tree(gl, trNode);
	}
};
///Jasmine 12/24/09 QA81-14845-S1 SHOW_SOURCE_DATA_TREE_UNDER_PLOT_NODE
static bool	get_graphlayer_plots(const GraphLayer& gl, TreeNode &trProject, DWORD dwCtrl = PT_CTRL_SHOW_FULL_RANGE)
{
	///Jasmine 07/24/2012 ORG-5458-P5 MAKE_PLOT_COLUMNS_SIMILAR_TO_PLOT_DETAIL_DB
	Tree trLayerContent;
	gl.GetLayerContents(trLayerContent, GETLC_DATAPLOTS);
	TreeNode trLayer = trLayerContent.FirstNode;
	if(!trLayer.DataPlot1)
		trLayer = trLayer.Group;
	///End MAKE_PLOT_COLUMNS_SIMILAR_TO_PLOT_DETAIL_DB
	
	string strFolder;
	Folder fld = gl.GetPage().GetFolder();
	if(fld)
		strFolder = fld.GetPath();
	foreach(DataPlot dp in gl.DataPlots)
	{		
		///Jasmine 06/12/2012 ORG-5458-S1 RESTRUCTURE_PLOT_TREE_FOR_INSERT_VAR_DB
		//string strNode = "Plot" + dp.GetIndex();
		//string strRange;
		//dp.GetRangeString(strRange, NTYPE_FOR_RANGE);
		//
		//string strLabel;
		//if ( dwCtrl & PT_CTRL_SHOW_FULL_RANGE )
			//dp.GetRangeString(strLabel, NTYPE_FOR_RANGE);
		//else
			//dp.GetLegend(strLabel);
		//
		//TreeNode tnp = trProject.AddNode(strNode);
		//tnp.SetAttribute(STR_LABEL_ATTRIB, strLabel);		
		//tnp.SetAttribute(STR_DATA_ATTRIB, dp.GetIndex());
		string strIndex = dp.GetIndex(), strRange, strLabel;
		dp.GetRangeString(strRange, NTYPE_FOR_RANGE);
		if ( dwCtrl & PT_CTRL_SHOW_FULL_RANGE )
			strLabel = strRange;
		else
			dp.GetLegend(strLabel);
		
		TreeNode tnp = trProject.AddNode("Plot" + strIndex);
		///Jasmine 07/19/2012 ORG-5458-S1 ADD_OBJ_NAME_TO_IDENTIFY_EACH_NODE
		strLabel.Format("Plot%d - %s", dp.GetIndex()+1, strLabel);
		///End ADD_OBJ_NAME_TO_IDENTIFY_EACH_NODE
		tnp.SetAttribute(STR_LABEL_ATTRIB, strLabel);
		tnp.SetAttribute(STR_DATA_ATTRIB, strIndex);
		///End RESTRUCTURE_PLOT_TREE_FOR_INSERT_VAR_DB
		tnp.SetAttribute(STR_NAME_ATTRIB, strRange);		
		tnp.SetAttribute(STR_STOP_ATTRIB, PTL_OBJ);
		if( !strFolder.IsEmpty() )
			tnp.SetAttribute(STR_PATH_ATTRIB, strFolder + strRange);
		
		///Jasmine 07/24/2012 ORG-5458-P5 MAKE_PLOT_COLUMNS_SIMILAR_TO_PLOT_DETAIL_DB
		//bool bRet = get_plot_data_tree(dp, tnp, dwCtrl);
		TreeNode trDataPlot;
		if(trLayer){ trDataPlot = trLayer.GetNode("DataPlot"+(string)(dp.GetIndex()+1)); }
		if(trDataPlot){ trDataPlot = trDataPlot.GetNode("PlotDesigs"); }
		bool bRet = get_plot_data_tree(dp, tnp, dwCtrl, trDataPlot);
		///End MAKE_PLOT_COLUMNS_SIMILAR_TO_PLOT_DETAIL_DB
		ASSERT(bRet);
	}
	
	return true;
}
///End SHOW_SOURCE_DATA_TREE_UNDER_PLOT_NODE

///Jasmine 06/11/2012 ORG-5458-S1 INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION
//strValue = %(%H, nCol, strLabel)		
static void prepare_text_object_for_plot(string& strValue)
{
	int nH =  strValue.Find("%H");
	if(nH < 0) nH = 0;
	
	int nFirstComma = strValue.Find(',', nH+1);
	if(nFirstComma <= nH)
		return;
	
	int nSecondComma = strValue.Find(',', nFirstComma+1);
	if(nSecondComma <= nFirstComma)
		return;
	
	int nRight = strValue.ReverseFind(')');	
	if(nRight <= nSecondComma)
		nRight = lstrlen(strValue) - 1;
	if(nRight <= nSecondComma)
		return;
	
	string strLabel = strValue.Mid(nSecondComma + 1, nRight - nSecondComma - 1);
	strLabel.TrimLeft(); strLabel.TrimRight();
	strLabel = "@L" + strLabel;
	
	string strNew = strValue.Left(nFirstComma + 1) + strLabel + strValue.Right(lstrlen(strValue)-nRight);
	strValue = strNew;
}
///End INSERT_LINK_WITH_COL_OR_PLOT_INDEX_OPTION

///Jasmine 12/28/09 QA81-14845-S1 ACCESS_SOURCE_BOOK_SHEET_COLUMN_FROM_PLOT
//strValue = %(%H, @W, %s)		
///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
//static void format_text_object_value_string(string& strValue, LPCSTR lpcszObj, int nPlotIndex = -1, int nLevel = -1)
static void format_text_object_value_string(string& strValue, LPCSTR lpcszObj, int nPlotIndex = -1, int nLevel = -1, LPCSTR lpcszDisFmt = NULL)
///End SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
{
	string strObj(lpcszObj);
	
	///Jasmine 12/14/09 QA81-14845-P3 ACCESS_FILE_INFO_WITH_PLOT_NOTATION
	if(nPlotIndex > 0)
		strObj.Format("%d@W", nPlotIndex);
	///End ACCESS_FILE_INFO_WITH_PLOT_NOTATION
	
	strValue.Replace("%H", strObj);
	
	//if strObj = #@W, it means strValue is for plot
	bool bPlot = strObj.Find("@W") > -1;
	if(nLevel > -1)
	{
		string strAtWPostfix;
		switch(nLevel)
		{
		case PTL_LAYER:	//@WS = source sheet, #14745
			strAtWPostfix = "S";
			break;
		case PTL_OBJ:	//@WY = source Y column, @WC = column
			strAtWPostfix = bPlot? "Y" : "C";
			break;
		default:		//@W = source book
			strAtWPostfix = "";
			break;
		}
		
		//replace @W, but not replace 1@W or @WL
		bool bReplace = false;		
		int nComma =  strValue.Find(',');
		if( nComma >= 0 && !strAtWPostfix.IsEmpty() )
		{
			int nAtW =  strValue.Find("@W", nComma+1);
			if(nAtW > nComma)
			{
				//check char right before @W
				if(nAtW > nComma+1)
				{
					string strPrefix = strValue.Mid(nAtW-1, 1);
					bReplace = strPrefix == "," || strPrefix == " ";
				}
				else
					bReplace = true;
				//check char right after @W
				int nPostfix = nAtW+2;
				if(bReplace && strValue.GetLength() > nPostfix)
				{
					string strPostfix = strValue.Mid(nPostfix, 1);
					bReplace = strPostfix == "," || strPostfix == " ";
				}
				
				if(bReplace)
				{
					strValue.Insert(nPostfix, strAtWPostfix);
				}
			}
		}
	}
	///Kyle 01/18/2010 QA80-14970 SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
	if( lpcszDisFmt && *lpcszDisFmt )
	{
		string strDisFmt = lpcszDisFmt;
		strDisFmt.TrimLeft();
		strDisFmt.TrimRight();
		if( !strDisFmt.IsEmpty() )
		{
			strDisFmt = ","+strDisFmt;
			int nPos = strValue.Find(')');
			if( nPos > 0 )
				strValue.Insert(nPos, strDisFmt);
		}
	}
	///End SUPPORT_INSERT_LINK_DISPLAY_IN_DATE_OR_CUSTOM_FORMAT
}
///End ACCESS_SOURCE_BOOK_SHEET_COLUMN_FROM_PLOT

///Jasmine 01/07/10 QA81-14845-S2 INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET
static string _find_compatible_range_node(	const TreeNodeCollection& trColl, const OriginObject& obj, bool bLayer, int nIndex)
{
	Layer lay;
	if(bLayer)
		lay = obj;
	else
		obj.GetParent(lay);
	if(!lay)
		return "";
	
	//find from the latest node
	for(int ii = trColl.Count() - 1; ii >= 0; ii--)
	{
		TreeNode trNode = trColl.Item(ii);
		if(!trNode)
			continue;
		
		TreeNode trRange = tree_get_node_by_tagname(trNode, IFI_DATA_RANGE_NODE_NAME, true);
		
		DataRange dr;
		dr = get_and_check_range(trRange, lay.GetPage().GetName());
		if(!dr)
			continue;
		
		Datasheet ds;
		int c1, c2;
		dr.GetRange(ds, c1, c2);
		if( !is_same_layer(ds, lay) )
			continue;
		if(bLayer)
			break;
		if(nIndex >= c1 && (c2 < 0 || nIndex <= c2))
			break;
	}
	
	string strName = "";
	if(ii < 0)
		return strName;	
	
	TreeNode trCompatible = trColl.Item(ii);
	if(trCompatible)
	{
		if( !trCompatible.GetAttribute(STR_LABEL_ATTRIB, strName) )
			strName = trCompatible.tagName;
	}
	
	return strName;
}

#define _FIND_COMPATIBLE_RANGE( _OBJ, _IS_LAYER ) 		\
{	\
	okxf_resolve_string_get_origin_object(lpcszRange, &_OBJ);	\
	if( _OBJ )	\
		return _find_compatible_range_node(trColl, _OBJ, _IS_LAYER, _OBJ.GetIndex());	\
}

static string _find_compatible_range_node(	const TreeNodeCollection& trColl, LPCSTR lpcszRange)
{
	Worksheet wks;
	_FIND_COMPATIBLE_RANGE( wks, true )

	MatrixLayer ml;
	_FIND_COMPATIBLE_RANGE( ml, true )
	
	Column col;
	_FIND_COMPATIBLE_RANGE( col, false )
	
	MatrixObject mo;
	_FIND_COMPATIBLE_RANGE( mo, false )
	
	return "";
}
///End INDICATE_FILE_INFO_FOR_SPECIFIED_SHEET
