/*------------------------------------------------------------------------------*
 * File Name: ImpWizardPage.h													*
 * Creation: GJL 7/11/2001														*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Danice 12/15/03 v7.5783 CHANGE_TO_SOURCEPAGE									*
 * Danice 3/1/04 v8.0828 PAGE_INIT_ONCE											*
 * EJP 06-08-2004 v8.0886 QA70-5417 IMPROVE_DATA_CHANGE_DETECTION				*
 * SY 09/29/2004 QA70-5658 v8.0142 IMPROVE_HDRVAR_EXTRACTION					*
 * EJP 10-06-2004 QA70-5658 v8.0144 IMPROVE_HDRVAR_EXTRACTION					*
 * EJP 01-11-2005 v8.0183 QA70-6555 NEW_IMPORT_MODES							*
 *------------------------------------------------------------------------------*/


#ifndef _IMPWIZARDPAGE_H
#define _IMPWIZARDPAGE_H

/// EJP 10/01/2004 QA70-5658 v8.0143 IMPROVE_HDRVAR_EXTRACTION
#define IW_FILTER			m_pSheet->m_trFilter
#define IW_ASCIMP			m_pSheet->m_ascimp
#define IW_ASCIMP_PTR		m_pSheet->GetASCIMP_Pointer()
#define IW_DATAFILE			m_pSheet->GetFileName()
#define IW_PREVIEW_FONT 	m_pSheet->GetPreviewFont()

//#define ASCIMP_TOTAL_HEADER_LINES(_ascimp) ((_ascimp)->iHeaderLines + (_ascimp)->iSubHeaderLines) ///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER: Use this Origin crash when compile
#define ASCIMP_TOTAL_HEADER_LINES(m_ascimp) (m_ascimp->iHeaderLines + m_ascimp->iSubHeaderLines)
/// end IMPROVE_HDRVAR_EXTRACTION

/// EJP 06-08-2004 v8.0886 QA70-5417 IMPROVE_DATA_CHANGE_DETECTION
#define IS_DATAFROM_CLIPBOARD			(m_pSheet->IsDataFromClipboard())
#define IS_DATAFROM_FILE				!IS_DATAFROM_CLIPBOARD
#define SET_DATAFROM_CLIPBOARD			m_pSheet->SetDataFromClipboard()
#define SET_DATAFROM_FILE				m_pSheet->SetDataFromFile()
/// end IMPROVE_DATA_CHANGE_DETECTION

class ImpWizSheet;

// Base WizPage class
class ImpWizardPage : public PropertyPage
{
public:
	ImpWizardPage();

	// must do this as the very first thing, before any other usage of this class
	void InitPage(int nID, ImpWizSheet* pSheet);
	
	//EVENTS_BEGIN
		//PAGE_ON_INIT(OnInitWizPage)
	//EVENTS_END
	// Event handler when WizPage becomes active (inherited by all WizPage derived classes)	
	
	///Danice 3/1/04 v8.0828 PAGE_INIT_ONCE
	BOOL Init();
	///END PAGE_INIT_ONCE

	/// SY 09/29/2004 QA70-5658 v8.0142 IMPROVE_HDRVAR_EXTRACTION
	void EnableFlag(DWORD dwFlag);
	void DisableFlag(DWORD dwFlag);
	BOOL IsFlagEnabled(DWORD dwFlag);
	BOOL IsFlagDisabled(DWORD dwFlag);
	/// end IMPROVE_HDRVAR_EXTRACTION

	void SetComboBoxItems(ComboBox& cb, StringArray& sa);
	void SetComboBoxItems(ComboBox& cb, LPCSTR lpcszItems, int nDelim);

	/// EJP 01-11-2005 v8.0183 QA70-6555 NEW_IMPORT_MODES
	int GetListIndexFromImportMode(int nImportMode);
	int GetImportModeFromListIndex(int nListIndex);
	/// end NEW_IMPORT_MODES

	BOOL GetRichEditSelection(RichEdit& re, int& nFirstLine, int& nLastLine, int& nFirstLineChar, int& nLastLineChar);

protected:
	ImpWizSheet* m_pSheet;
	bool		bHasPageInit;	///Danice PAGE_INIT_ONCE
};


/// EJP 10-06-2004 QA70-5658 v8.0144 IMPROVE_HDRVAR_EXTRACTION
//--------------------------------------------------------------------------
// ImpWizAscPage
// 
//--------------------------------------------------------------------------
class ImpWizAscPage : public ImpWizardPage
{
public:
	int DataFileErrorMsgBox();

	bool GetHeaderLines(StringArray& saHdrLines);
	
	bool GetHeaderLines(string& strLines);
	
	void InsertLineNumbers(StringArray& sa);

	bool SetRichEdit(RichEdit& re, StringArray& sa);

	void InitRichEditWithHeaderLines(RichEdit& re);
};
/// end IMPROVE_HDRVAR_EXTRACTION

#endif //_IMPWIZARDPAGE_H
