/*------------------------------------------------------------------------------*
 * File Name: ImpWizHeaderBytes.h												*
 * Creation: Jacky 12/12/2003													*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	 Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME							    *
 *	 Jacky 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL		                        *
 *   Jacky 12/12/03 v7.5780 DEFINE_SOME_NEW_MEMBER                              *
 *   Jacky 12/12/03 v7.5780 PAGE_QUESTION_UNSOLVED                              *
 *   Danice 12/23/03 v7.5786 SAVE_CHANGE										*
 *   Danice 12/25/03 v7.5788 CALL_SHEET_FUNCTION								*
 *   Danice 12/25/03 v7.5788 NOTUSE_SHOW                                        *
 *   Danice 12/26/03 v7.5789 SKIP_BYTES											*
 *	 Jason 12/26/03 v7.5789 USE_M_EDVALUE										*
 *   Jacky 12/28/03 v7.5788 USE_M_LBPARAMS                                      *
 *   Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER						*
 *   Danice 1/17/04 v8.0802 FOR_CONTROL_UPGRADE_DATA							*
 *   Danice 2/23/04 v8.0824 REFRESH_PREVIEW_WHEN_CHANGE							*
 *   Danice 3/1/04 v8.0828 PAGE_INIT_ONCE										*
 *------------------------------------------------------------------------------*/
 

 
#define ON_PAGE_CHECK_BIN_HEADER			if(!IS_SHOW_BIN_HEADER_PAGE) return FALSE;

enum {PARAM_TYPE_INT=0,PARAM_TYPE_UINT,PARAM_TYPE_REAL,PARAM_TYPE_STR};


// Derived WizPage class for WizPage1
class ImpWizHeaderBytesPage : public ImpWizardPage
{
	
// Constructor for ImpWizHeaderBytesPage class, use parent constructor
//ImpWizHeaderBytesPage(int nID) : ImpWizardPage(nID) {}


public:
	
	EVENTS_BEGIN
		///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME
		PAGE_ON_ACTIVE(OnActivate_BinHeader)
		PAGE_ON_KILLACTIVE(OnKillActive_BinHeader)
		PAGE_ON_INIT(OnInit_BinHeader)
		ON_EN_CHANGE(IDC_BIW_HEADER_SKIPHEADER_EDIT, OnChangeHeaderSize_BinHeader)
		//ON_TOOLBAR_BN_CLICKED(IDB_IW_BIN_HEADER_REFRESH, OnClickRefresh_BinHeader)
		ON_BN_CLICKED(IDC_IW_BIN_HEADER_TBHLDR, OnClickRefresh_BinHeader)
		ON_BN_CLICKED(IDC_BIW_HEADER_BIGENDIAN_CHECK, OnClickBigEndian_BinHeader)
		ON_BN_CLICKED(IDC_BIW_USE_PARAMETER_DEFINITIONS, OnClickDefineParam_BinHeader)
		ON_BN_CLICKED(IDC_BIW_HEADER_ADD_BUTTON, OnClickAddParam_BinHeader)
		ON_BN_CLICKED(IDC_BIW_HEADER_REMOVE_BUTTON, OnClickRemoveParam_BinHeader)
		ON_CBN_SELCHANGE(IDC_BIW_HEADER_CANDINTERP_COMBO, OnSelChangeParamType_BinHeader)
		ON_EN_CHANGE(IDC_BYTE_OFFSET, OnChangeByteOffset_BinHeader)
		ON_CBN_SELCHANGE(IDC_BIN_PREVIEW_FONT, OnSelChangeFont_BinHeader) /// EJP 10-24-2003 v7.5730 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT
		///End CHANGE_FUNCTION_NAME
		
		//PAGE_ON_IS_SHOW(OnIsShowBinary)		///Danice 12/25/03 v7.5788 NOTUSE_SHOW
		ON_EN_SELCHANGE(IDC_BIW_HEADER_ASCII_RICHEDIT, OnSelChangeAscPreview)
		ON_EN_SELCHANGE(IDC_BIW_HEADER_HEX_RICHEDIT, OnSelChangeHexPreview)
		ON_EN_VSCROLL(IDC_BIW_HEADER_ASCII_RICHEDIT, OnVScrollAscPreview)
		ON_EN_VSCROLL(IDC_BIW_HEADER_HEX_RICHEDIT, OnVScrollHexPreview)

	EVENTS_END
	
protected :
	//Events handles
	
	DWORD OnShowStatus(DWORD InternalStatus);
	
	void InitializeBitmapButtons();
	
	int AddBinHdrParam(LPCSTR lpcszName, int nType, int nSize, int nOffset);

	BOOL DelBinHdrParam(int nIndex);
	
	BOOL GetBinHdrParamListStr(string &str, int nIndex, BOOL bWithValue=true);
	
	BOOL OnInit_BinHeader();	///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME
	
	void iw_InitFontComboBox(int iCtrl);

	BOOL OnActivate_BinHeader();	///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME

	BOOL OnKillActive_BinHeader();	///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME
	/// EJP 10-20-2003 v7.5726 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT
	void BinHdr_SetFont(int iFont);

	void iw_SetRichEditFont(int iCtrl, int iFont);

	BOOL OnSelChangeFont_BinHeader(Control ctrl);	///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME
	/// end ALLOW_CHANGING_PREVIEW_FONT

	BOOL OnSelChangeParamType_BinHeader(Control ctrl);	///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME

	BOOL BinHeader_WriteHeaderParamsToTree();

	bool BinHeader_ReadHeaderParamsFromTree();

	//------ CPY 1/2/03 v7.0478 QA70-3604 RICH_EDIT_SCROLL_SYNCHRONIZED 
	void OnVScrollAscPreview(Control ctrl);

	int get_bin_preview_char_index(int nAscPreviewCharIndex, RichEdit& reAscPreview, RichEdit& reBinPreview);

	// we try to select same in hex dump as in ascii dump
	BOOL OnSelChangeAscPreview(Control ctrl);
	//------ end CPY 1/2/03 v7.0478 QA70-3604 RICH_EDIT_SCROLL_SYNCHRONIZED 

	void OnVScrollHexPreview(Control ctrl);

	// we try to select same in hex dump as in ascii dump
	BOOL OnSelChangeHexPreview(Control ctrl);

	void ConvertHexPreviewSelToAscPreviewSel(long &nStartChar, long &nEndChar);

	int get_ascii_preview_char_index(int nBinPreviewCharIndex);

	BOOL OnChangeHeaderSize_BinHeader(Control ctrl);	///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME

	BOOL OnChangeByteOffset_BinHeader(Control ctrl);	///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME

	BOOL OnClickBigEndian_BinHeader(Control ctrl);	///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME

	BOOL OnClickRefresh_BinHeader(Control ctrl);	///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME

	BOOL OnClickDefineParam_BinHeader(Control ctrl);	///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME

	BOOL OnClickAddParam_BinHeader(Control ctrl);	///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME

	BOOL OnClickRemoveParam_BinHeader(Control cntrl);	///Jacky 12/12/03 v7.5780 CHANGE_FUNCTION_NAME

	void BinHdr_UpdatePreview();

	void BinHeader_AddParamToListBox(int nIndex);

	void BinHeader_UpdateParamListBox();

	BOOL BinHeader_GetSelectedBytes(long &nFirst, long &nLast);

	BOOL BinHeader_GetParamInfo(int &nType, int &nOffset, int &nSize);

	int BinHeader_GetParamValAsStr(int nType, int nOffset, int nSize, string &strVal);

	void BinHeader_UpdateParamValPreview();

	int GetByteOffsetFromHexPreviewCharIndex(int iCharIndex);

	int GetHexPreviewCharIndexFromByteOffset(int iByteOffset);

	int GetByteOffsetFromAscPreviewCharIndex(int iCharIndex);

	int GetAscPreviewCharIndexFromByteOffset(int iByteOffset);

private:
	//int   m_iPreviewFont;	///Danice 12/25/03 v7.5788 CALL_SHEET_FUNCTION
	
	//StringArray s_saDataFiles;
	StringArray m_saHdrParamName;
	
	///Jacky 12/12/03 v7.5780 DEFINE_SOME_NEW_MEMBER
	//Control m_paramsList;     ///Jacky 12/28/03 v7.5788 USE_M_LBPARAMS;
	//Control m_valueEdit;		///Jason 12/26/03 v7.5789 USE_M_EDVALUE
	
	Button m_paramChk;
	Button m_btnAdd;
	Button m_btnRemove;
	Button m_chkBigEndian;

	Edit m_editHeader;
	Edit m_edByteOffset;
	Edit m_edValue;

	RichEdit m_reAscPreview;
	RichEdit m_reBinPreview;
	
	ListBox m_lbParams;
	ListBox m_typeList;
	///End DEFINE_SOME_NEW_MEMBER
	
	//BINIMP 	m_pBinimp;	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	BINIMP* 	m_pBinimp;
	vector<int>	m_vHdrParamType;
	vector<int>	m_vHdrParamOffset;
	vector<int>	m_vHdrParamSize;

};

