/*------------------------------------------------------------------------------*
 * File Name: ImpWizHeadVariables.c												*
 * Creation: 																	*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 08/12/08 QA80-11980 VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
 *	Sim 2011-07-05 SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR							*
 *	Folger 10/26/2011 ORG-4183-P1 GRID_FONT_SIZE_TOO_BIG_IN_IMPORT_WIZARD_HEADER_VARIABLES
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include "IWfirst.h"

///Danice 2/12/04 v8.0819 CHANGE_GRID_TO_CLASS
ASCHdrVarList::ASCHdrVarList()
{
}

void ASCHdrVarList::Init(int nID, WndContainer& dlg)
{		
	GridListControl::Init(nID, dlg);

	///Danice 2/16/04 v8.0821 ADD_SOME_ACCESS_FUNCTION
	//SetupRowsCols(0, 1, 2, 1);	///Danice 3/29/04 v8.0844b CHANGE_PARA_ORDER_ROW_COL
	SetupRowsCols(1, 0, 1, 2);
	m_flx.Editable = flexEDNone;
	//m_flx.FixedCols = 0;
	//m_flx.FixedRows = 1;
	m_flx.ExtendLastCol = TRUE;
	m_flx.AllowUserResizing = flexResizeColumns;
	m_flx.ColWidthMin = 4;
	m_flx.ColWidthMax = 0;
	
	//m_flx.Rows = 1;
	//m_flx.Cols = 2;
	///END ADD_SOME_ACCESS_FUNCTION

	/*
	m_flx.Row = 0; // 0=Column headers
	m_flx.Col = ASCHDR_VARCOL_NAME;
	m_flx.ColWidth(ASCHDR_VARCOL_NAME) = m_flx.ClientWidth * 0.5;
	m_flx.Text = IW_COLHDR_NAME;
	m_flx.Col = ASCHDR_VARCOL_VALUE;
	m_flx.Text = IW_COLHDR_VALUE;
	*/
	SetColHeading(ASCHDR_VARCOL_NAME, _L("Name"));
	SetColHeading(ASCHDR_VARCOL_VALUE, _L("Value"));
	ResizeCols(ASCHDR_TOTAL_COLS, m_flx.ClientWidth/ASCHDR_TOTAL_COLS);//a little less, so the roll bar don't appear at first
	
	m_flx.AutoSizeMode = flexAutoSizeColWidth; /// EJP 10-08-2003 v7.5715 QA70-5289.3 UPDATE_COL_WIDTH
	
}

void ASCHdrVarList::UpdateGrid(string strFileName, Tree& trFilter)
{
	m_flx.Rows = 1; // only column headings

	int i;
	/// EJP 07-28-2003 v7.0637 QA70-4911 IMPROVE_HDR_VAR_SCAN
	/*
	string strName, strVal;
	
	for( int iLine = 0; iLine < saLines.GetSize(); iLine++ )
	{
		i = saLines[iLine].Find(iSeparator);
		if( i > 0 )
		{
			strName = saLines[iLine].Left(i);
			strName.TrimLeft();
			strName.TrimRight();
			strName.MakeValidCName('_');
			if( !strName.IsEmpty() )
			{
				strVal = saLines[iLine].Mid(i + 1);
				strVal.TrimLeft();
				strVal.TrimRight();
			
				i = gridVar.Rows;
				gridVar.Rows = i + 1;
				gridVar.Cell(flexcpText, i, ASCHDR_VARCOL_NAME) = strName;
				gridVar.Cell(flexcpText, i, ASCHDR_VARCOL_VALUE) = strVal;
			}
		}
	}
	*/
	StringArray saNames, saValues;

	//////get_ascii_file_header_variables(saNames, saValues, strFileName, trFilter);
	///import_header_variables(saNames, saValues, strFileName, trFilter);
	/// Hong 08/12/08 QA80-11980 VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
	//import_and_check_variables_by_scanning(saNames, saValues, strFileName, trFilter);
	StringArray		saNiceNames;
	StringArray*	psaNiceNames = NULL;
#ifdef		GUI_SHOW_NICE_NAME
	psaNiceNames = &saNiceNames;
#endif		//GUI_SHOW_NICE_NAME
	import_and_check_variables_by_scanning(saNames, saValues, strFileName, trFilter, psaNiceNames);
	if ( psaNiceNames && psaNiceNames->GetSize() > 0 )
		saNames = *psaNiceNames;
	/// end VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
	
	for( int iVar = 0; iVar < saNames.GetSize(); iVar++ )
	{
		i = m_flx.Rows;
		m_flx.Rows = i + 1;
		SetCell(saNames[iVar], flexcpText, i, ASCHDR_VARCOL_NAME);
		SetCell(saValues[iVar], flexcpText, i, ASCHDR_VARCOL_VALUE);
	}
	/// end IMPROVE_HDR_VAR_SCAN
	
	m_flx.AutoSize(ASCHDR_VARCOL_VALUE); /// EJP 10-08-2003 v7.5715 QA70-5289.3 UPDATE_COL_WIDTH
}
///END CHANGE_GRID_TO_CLASS


	
/// EJP 10/01/2004 QA70-5658 v8.0143 IMPROVE_HDRVAR_EXTRACTION
///	///Danice 12/25/03 v7.5788 NOTUSE_SHOW
///	/*
///	BOOL OnIsShow_AscHdrVar(DWORD dwPageID, DWORD lParam)
///	{
///		m_pSheet->GetASCIMP(IW_ASCIMP_PTR);	///Danice 12/23/03 v7.5786 INIT_LOCAL
///		return IS_SHOW_ASC_HEADER_PARAM_PAGE;
///	}
///	*/
///	DWORD    OnShowStatus(DWORD InternalStatus)
///	{
///		//m_pSheet->GetASCIMP(IW_ASCIMP_PTR);	///Danice 12/23/03 v7.5786 INIT_LOCAL	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
///		if(IW_ASCIMP_PTR == NULL)
///		{
///			IW_ASCIMP_PTR = m_pSheet->GetASCIMP_Pointer();	//IW_ASCIMP_PTR take part in the Show judgement
///		}
///		return (IS_SHOW_ASC_HEADER_PARAM_PAGE ? PSS_Show : PSS_Ignore);
///	}
///	///END NOTUSE_SHOW
BOOL ImpWizHeadVariablesPage::IsShowPage()
{
	if( fuIsExtractVarByScanning(IW_FILTER) )
		return TRUE;
	return FALSE;
}

DWORD ImpWizHeadVariablesPage::OnShowStatus(DWORD InternalStatus)
{
	if( IsShowPage() )
		return PSS_Show;
	return PSS_Ignore;
}
/// end IMPROVE_HDRVAR_EXTRACTION

void ImpWizHeadVariablesPage::InitializeBitmapButtons()
{
	BitmapRadioButton radioButton;
	
	radioButton = GetItem(IDC_ASCHDRVAR_LINESREFRESH_TBHLDR);
	vector<string>  vstrTips;
	vstrTips.SetSize(1);
	vstrTips[0] = _L("Select the Lines to be scanned and click the refresh button");
	radioButton.Init(1, IDB_REFRESH_BLACK, 16, vstrTips);
	
}

BOOL ImpWizHeadVariablesPage::OnInit()
{
	///Danice PAGE_INIT_ONCE
	if(!ImpWizardPage::Init())
		return FALSE;
	///END PAGE_INIT_ONCE

	InitializeBitmapButtons();

	//m_reHdr = 		GetItem(IDC_HDRVAR_HEADER);
	m_cbLastLine = 	GetItem(IDC_HDRVAR_LASTLINE);
	m_reHdrLines = 	GetItem(IDC_HDRVAR_HEADER);
	m_cbFrom = 		GetItem(IDC_HDRVAR_FIRSTLINE);
	//m_cbTo = 		GetItem(IDC_HDRVAR_LASTLINE);
	m_cbSeparator = GetItem(IDC_HDRVAR_SEPARATOR);
	m_ebOther = 	GetItem(IDC_HDRVAR_OTHERSEPARATOR);
	//m_ctrlVar = 	GetItem(IDC_HDRVAR_VARIABLES);	///Danice CHANGE_GRID_TO_CLASS
	m_cbFilter =	GetItem(IDC_HDRVAR_FILTER); ///---Sim 2011-07-05 SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR


	m_strAscHdrVarSeparators = "=,\t :";
	
	// No check, because we always want to setup the grid in case
	// user clicks Back and turns on "Define User Variables".
	///ON_PAGE_CHECK_ASC_HEADER_PARAM
	
	///Danice 2/12/04 v8.0819 CHANGE_GRID_TO_CLASS
	/*
	//Control ctrlVar = ImportWizDlg.GetItem(IDC_HDRVAR_VARIABLES, IDD_AIW_HDRVAR);
	if( m_ctrlVar )
	{
		Object gridVar = m_ctrlVar.GetActiveXControl();
		if( gridVar )
		{
			gridVar.Editable = flexEDNone;
			gridVar.FixedCols = 0;
			gridVar.FixedRows = 1;
			gridVar.ExtendLastCol = TRUE;
			gridVar.AllowUserResizing = 1;
			gridVar.ColWidthMin = 4;
			gridVar.ColWidthMax = 0;
			
			gridVar.Rows = 1;
			gridVar.Cols = 2;
	
			gridVar.Row = 0; // 0=Column headers
			gridVar.Col = ASCHDR_VARCOL_NAME;
			gridVar.ColWidth(ASCHDR_VARCOL_NAME) = gridVar.ClientWidth * 0.5;
			gridVar.Text = IW_COLHDR_NAME;
			gridVar.Col = ASCHDR_VARCOL_VALUE;
			gridVar.Text = IW_COLHDR_VALUE;
			
			gridVar.AutoSizeMode = flexAutoSizeColWidth; /// EJP 10-08-2003 v7.5715 QA70-5289.3 UPDATE_COL_WIDTH
		}
	}
	*/
	m_HdrVarList.Init(IDC_HDRVAR_VARIABLES, *this);
	///END CHANGE_GRID_TO_CLASS

	return true;
}

BOOL ImpWizHeadVariablesPage::OnActive_AscHdrVar()
{
	ON_PAGE_CHECK_ASC_HEADER_PARAM
	
	ASCIMP* pai = m_pSheet->GetASCIMP_Pointer();
	fuSetASCIMP(IW_FILTER, *pai);

	/// EJP 10-06-2004 QA70-5658 v8.0144 IMPROVE_HDRVAR_EXTRACTION
	/*
	string str;
	if( LoadTextFile(str, s_strDataFile, ASCIMP_TOTAL_HEADER_LINES(IW_ASCIMP_PTR)) )
		iwDataFileErrorMsgBox();
	//RichEdit reHdr = ImportWizDlg.GetItem(IDC_HDRVAR_HEADER, IDD_AIW_HDRVAR);
	if( m_reHdrLines )
	{
		m_reHdrLines.Text = str;
		/// EJP 10-20-2003 v7.5726 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT
		///reHdr.SetFont(SYSTEM_FIXED_FONT);
		m_reHdrLines.SetFont(IW_PREVIEW_FONT);
		/// end ALLOW_CHANGING_PREVIEW_FONT
		m_reHdrLines.SetSel(0, 0);
	}
	*/
	InitRichEditWithHeaderLines(m_reHdrLines);
	/// end IMPROVE_HDRVAR_EXTRACTION
	
	/// EJP 10-23-2003 v7.5726 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT
	//iw_SetGridFont(IDC_HDRVAR_VARIABLES, IW_PREVIEW_FONT);	///Danice 12/26/03 v7.5789 PUT_FUNCTION_TO_SHEET
	//m_pSheet->iw_SetGridFont(m_ctrlVar, IW_PREVIEW_FONT);		///Danice CHANGE_GRID_TO_CLASS
	///------ Folger 10/26/2011 ORG-4183-P1 GRID_FONT_SIZE_TOO_BIG_IN_IMPORT_WIZARD_HEADER_VARIABLES
	//m_HdrVarList.SetGridFont(IW_PREVIEW_FONT);
	///------ End GRID_FONT_SIZE_TOO_BIG_IN_IMPORT_WIZARD_HEADER_VARIABLES
	/// end ALLOW_CHANGING_PREVIEW_FONT
	
	AscHdrVar_Update(); // update dialog from filter
	return TRUE;
}

///Danice 12/26/03 v7.5789 PUT_FUNCTION_TO_SHEET
/*
BOOL ImpWizHeadVariablesPage::iw_SetGridFont(int iCtrl, int iFont)
{
	//Control ctrlGrid = ImportWizDlg.GetItem(iCtrl, iPage);	///Jason 12/18/03 v7.5781 NO_NEED_DIALOG_CALL	
	Control ctrlGrid = GetItem(iCtrl);
	if( ctrlGrid )
	{
		Object objGrid = ctrlGrid.GetActiveXControl();
		if( objGrid )
		{
			int iFontSize;
			objGrid.FontName = GetFontName(iFont, &iFontSize);
			return TRUE;
		}
	}
	return FALSE;
}
*/
///END PUT_FUNCTION_TO_SHEET

/// EJP 10-06-2004 QA70-5658 v8.0144 IMPROVE_HDRVAR_EXTRACTION
/* This function moved to base class
int ImpWizHeadVariablesPage::iwDataFileErrorMsgBox()
{
	string strText;
	strText.Format("Error opening/reading data file:\n%s", GetFileName(s_strDataFile));
	//return MessageBox(ImportWizDlg.GetWindow().GetSafeHwnd(), strText, "Import Wizard");
	return MessageBox(GetSafeHwnd(), strText, "Import Wizard");
}
*/
/// end IMPROVE_HDRVAR_EXTRACTION

BOOL ImpWizHeadVariablesPage::OnKillActive_AscHdrVar()
{
	ON_PAGE_CHECK_ASC_HEADER_PARAM
	AscHdrVar_Update(false); // false = update filter from dialog
	
	//m_pSheet->SetASCIMP(IW_ASCIMP_PTR);	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	return true;
}

BOOL ImpWizHeadVariablesPage::OnSelChangeFirstLine_AscHdrVar(Control ctrl)
{
	ComboBox cbFirstLine(ctrl);
	int iSel = cbFirstLine.GetCurSel();
	//ComboBox cbLastLine = ImportWizDlg.GetItem(IDC_HDRVAR_LASTLINE, IDD_AIW_HDRVAR);
	if( 0 == iSel || 1 == iSel )
		m_cbLastLine.Enable = 0;
	else
		m_cbLastLine.Enable = 1;
	return TRUE;
}

BOOL ImpWizHeadVariablesPage::OnClickRefresh_AscHdrVar(Control ctrl)
{
	int iFrom, iTo, iSeparator;
	///---Sim 2011-07-05 SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
	//AscHdrVar_GetScanSettings(iFrom, iTo, iSeparator);
	int iFilter;
	AscHdrVar_GetScanSettings(iFrom, iTo, iSeparator, iFilter);
	///---END SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
	
	//RichEdit reHdrLines = ImportWizDlg.GetItem(IDC_HDRVAR_HEADER, IDD_AIW_HDRVAR);
	long nStartChar, nEndChar;
	m_reHdrLines.GetSel(nStartChar, nEndChar);
	
	iFrom = m_reHdrLines.LineFromChar(nStartChar);
	iTo = m_reHdrLines.LineFromChar(nEndChar);
	///---Sim 2011-07-05 SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
	//AscHdrVar_SetScanSettings(iFrom, iTo, iSeparator);
	AscHdrVar_SetScanSettings(iFrom, iTo, iSeparator, iFilter);
	///---END SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR

	return TRUE;
}

BOOL ImpWizHeadVariablesPage::OnSelChangeSeparator_AscHdrVar(Control ctrl)
{
	ComboBox cbSeparator2(ctrl);
	int iSel = cbSeparator2.GetCurSel();
	//Edit ebOther = ImportWizDlg.GetItem(IDC_HDRVAR_OTHERSEPARATOR, IDD_AIW_HDRVAR);
	if( DELIMITER_OTHER == iSel )
		m_ebOther.Enable = 1;
	else
		m_ebOther.Enable = 0;
	return TRUE;
}

BOOL ImpWizHeadVariablesPage::OnClickScan_AscHdrVar(Control ctrl)
{
	/// EJP 07-28-2003 v7.0637 QA70-4911 IMPROVE_HDR_VAR_SCAN
	///int iFrom, iTo, iSeparator;
	///AscHdrVar_GetScanSettings(iFrom, iTo, iSeparator);
	///AscHdrVar_UpdateGrid(iFrom, iTo, iSeparator);
	AscHdrVar_Update(false); // false = update filter
	AscHdrVar_UpdateGrid();
	/// end IMPROVE_HDR_VAR_SCAN
	return TRUE;
}

void ImpWizHeadVariablesPage::AscHdrVar_Update(bool bTreeToDlg) //=true)
{
	int iFirstLine, iLastLine, iSeparator;
	int iFilter; ///---Sim 2011-07-05 SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR

	if( bTreeToDlg )
	{
		///---Sim 2011-07-05 SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
		//if( !fuGetHdrVarScan(s_trFilter, iFirstLine, iLastLine, iSeparator) )
		if( !fuGetHdrVarScan(s_trFilter, iFirstLine, iLastLine, iSeparator, iFilter) )
		///---END SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
		{
			iFirstLine = 0;
			iLastLine = ASCIMP_TOTAL_HEADER_LINES(IW_ASCIMP_PTR) - 1;
			iSeparator = '\t';
			iFilter = HDVAR_FILTER_ALL; ///---Sim 2011-07-05 SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
			///---Sim 2011-07-05 SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
			//fuSetHdrVarScan(s_trFilter, iFirstLine, iLastLine, iSeparator); /// EJP 07-28-2003 v7.0637 QA70-4911 IMPROVE_HDR_VAR_SCAN
			fuSetHdrVarScan(s_trFilter, iFirstLine, iLastLine, iSeparator, iFilter); /// EJP 07-28-2003 v7.0637 QA70-4911 IMPROVE_HDR_VAR_SCAN
			///---END SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
		}
		///---Sim 2011-07-05 SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
		//AscHdrVar_SetScanSettings(iFirstLine, iLastLine, iSeparator);
		AscHdrVar_SetScanSettings(iFirstLine, iLastLine, iSeparator, iFilter);
		///---END SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
		/// EJP 07-28-2003 v7.0637 QA70-4911 IMPROVE_HDR_VAR_SCAN
		///AscHdrVar_UpdateGrid(iFirstLine, iLastLine, iSeparator);
		AscHdrVar_UpdateGrid();
		/// end IMPROVE_HDR_VAR_SCAN
	}
	else // update tree from dlg
	{
		///---Sim 2011-07-05 SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
		//AscHdrVar_GetScanSettings(iFirstLine, iLastLine, iSeparator);
		//fuSetHdrVarScan(s_trFilter, iFirstLine, iLastLine, iSeparator);
		AscHdrVar_GetScanSettings(iFirstLine, iLastLine, iSeparator, iFilter);
		fuSetHdrVarScan(s_trFilter, iFirstLine, iLastLine, iSeparator, iFilter);
		///---END SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
	}
}

void ImpWizHeadVariablesPage::AscHdrVar_UpdateGrid()
{
	/// EJP 07-28-2003 v7.0637 QA70-4911 IMPROVE_HDR_VAR_SCAN
	///StringArray saLines;
	///ReadFileLines(saLines, s_strDataFile, iTo - iFrom + 1, iFrom);
	/// end IMPROVE_HDR_VAR_SCAN
	
	///Danice 2/12/04 v8.0819 CHANGE_GRID_TO_CLASS
	/*
	//Control ctrlVar = ImportWizDlg.GetItem(IDC_HDRVAR_VARIABLES, IDD_AIW_HDRVAR);
	if( !m_ctrlVar )
		return;
	Object gridVar = m_ctrlVar.GetActiveXControl();
	if( gridVar )
	{
		gridVar.Rows = 1; // only column headings
		
		int i;
	*/
		/// EJP 07-28-2003 v7.0637 QA70-4911 IMPROVE_HDR_VAR_SCAN
		/*
		string strName, strVal;
		
		for( int iLine = 0; iLine < saLines.GetSize(); iLine++ )
		{
			i = saLines[iLine].Find(iSeparator);
			if( i > 0 )
			{
				strName = saLines[iLine].Left(i);
				strName.TrimLeft();
				strName.TrimRight();
				strName.MakeValidCName('_');
				if( !strName.IsEmpty() )
				{
					strVal = saLines[iLine].Mid(i + 1);
					strVal.TrimLeft();
					strVal.TrimRight();
					
					i = gridVar.Rows;
					gridVar.Rows = i + 1;
					gridVar.Cell(flexcpText, i, ASCHDR_VARCOL_NAME) = strName;
					gridVar.Cell(flexcpText, i, ASCHDR_VARCOL_VALUE) = strVal;
				}
			}
		}
		*/
	/*	StringArray saNames, saValues;
		get_ascii_file_header_variables(saNames, saValues, s_strDataFile, s_trFilter);
		for( int iVar = 0; iVar < saNames.GetSize(); iVar++ )
		{
			i = gridVar.Rows;
			gridVar.Rows = i + 1;
			gridVar.Cell(flexcpText, i, ASCHDR_VARCOL_NAME) = saNames[iVar];
			gridVar.Cell(flexcpText, i, ASCHDR_VARCOL_VALUE) = saValues[iVar];
		}
		/// end IMPROVE_HDR_VAR_SCAN
		
		gridVar.AutoSize(ASCHDR_VARCOL_VALUE); /// EJP 10-08-2003 v7.5715 QA70-5289.3 UPDATE_COL_WIDTH
	}
	*/
	m_HdrVarList.UpdateGrid(s_strDataFile, s_trFilter);
	///END CHANGE_GRID_TO_CLASS
}

///---Sim 2011-07-05 SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
//void ImpWizHeadVariablesPage::AscHdrVar_GetScanSettings(int &iFrom, int &iTo, int &iSeparator)
void ImpWizHeadVariablesPage::AscHdrVar_GetScanSettings(int &iFrom, int &iTo, int &iSeparator, int &iFilter)
///---END SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
{
	//ComboBox cbFrom = ImportWizDlg.GetItem(IDC_HDRVAR_FIRSTLINE, IDD_AIW_HDRVAR);
	//ComboBox cbTo = ImportWizDlg.GetItem(IDC_HDRVAR_LASTLINE, IDD_AIW_HDRVAR);
	//ComboBox cbSeparator = ImportWizDlg.GetItem(IDC_HDRVAR_SEPARATOR, IDD_AIW_HDRVAR);
	//Edit ebOther = ImportWizDlg.GetItem(IDC_HDRVAR_OTHERSEPARATOR, IDD_AIW_HDRVAR);
	string str;
	
	iTo = atoi(m_cbLastLine.Text) - 1;
	if( iTo < 0 )
	{
		if( 0 == m_cbLastLine.Text.CompareNoCase(SZ_IW_END) )
			iTo = ASCIMP_TOTAL_HEADER_LINES(IW_ASCIMP_PTR) - 1;
	}

	iFrom = atoi(m_cbFrom.Text) - 1;
	if( iFrom < 0 )
	{
		if( 0 == m_cbFrom.Text.CompareNoCase(SZ_IW_NONE) )
		{
			iFrom = -1;
			iTo = -1;
		}
		else if( 0 == m_cbFrom.Text.CompareNoCase(SZ_IW_ALL) )
		{
			iFrom = 0;
			iTo = ASCIMP_TOTAL_HEADER_LINES(IW_ASCIMP_PTR) - 1;
		}
	}
	
	if( iFrom > iTo )
	{
		int iSwap = iFrom;
		iFrom = iTo;
		iTo = iSwap;
	}

	if( iFrom >= ASCIMP_TOTAL_HEADER_LINES(IW_ASCIMP_PTR) )
		iFrom = ASCIMP_TOTAL_HEADER_LINES(IW_ASCIMP_PTR) - 1;
	if( iTo >=  ASCIMP_TOTAL_HEADER_LINES(IW_ASCIMP_PTR) )
		iTo = ASCIMP_TOTAL_HEADER_LINES(IW_ASCIMP_PTR) - 1;
	
	iSeparator = m_cbSeparator.GetCurSel();
	if( -1 == iSeparator )
		iSeparator = '\t';
	else if( DELIMITER_OTHER == iSeparator )
	{
		if( m_ebOther.Text.IsEmpty() )
			iSeparator = '\t';
		else
			iSeparator = m_ebOther.Text.GetAt(0);
	}
	else
	{
		iSeparator = m_strAscHdrVarSeparators[iSeparator];
	}
	
	///---Sim 2011-07-05 SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
	iFilter = m_cbFilter.GetCurSel();
	///---END SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
}

///---Sim 2011-07-05 SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
//void ImpWizHeadVariablesPage::AscHdrVar_SetScanSettings(int iFrom, int iTo, int iSeparator)
void ImpWizHeadVariablesPage::AscHdrVar_SetScanSettings(int iFrom, int iTo, int iSeparator, int iFilter)
///---END SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
{
	//ComboBox cbFrom = ImportWizDlg.GetItem(IDC_HDRVAR_FIRSTLINE, IDD_AIW_HDRVAR);
	//ComboBox cbTo = ImportWizDlg.GetItem(IDC_HDRVAR_LASTLINE, IDD_AIW_HDRVAR);
	//ComboBox cbSeparator = ImportWizDlg.GetItem(IDC_HDRVAR_SEPARATOR, IDD_AIW_HDRVAR);
	//Edit ebOther = ImportWizDlg.GetItem(IDC_HDRVAR_OTHERSEPARATOR, IDD_AIW_HDRVAR);
	string str;

	if( iTo < iFrom || iTo == ASCIMP_TOTAL_HEADER_LINES(IW_ASCIMP_PTR) - 1 )
		str = SZ_IW_END;
	else
		str.Format("%d", iTo + 1);
	m_cbLastLine.Text = str;
	m_cbLastLine.Enable = 1;

	if( iFrom == -1 )
		str = SZ_IW_NONE;
	else
	{
		if( iFrom == 0 && iTo == ASCIMP_TOTAL_HEADER_LINES(IW_ASCIMP_PTR) - 1 )
		{
			str = SZ_IW_ALL;
			m_cbLastLine.Enable = 0;
		}
		else
			str.Format("%d", iFrom + 1);
	}
	m_cbFrom.Text = str;

	int i = m_strAscHdrVarSeparators.Find((char)iSeparator);
	if( i >= 0 )
	{
		m_cbSeparator.SetCurSel(i);
		m_ebOther.Enable = 0;
	}
	else // other
	{
		m_cbSeparator.SetCurSel(DELIMITER_OTHER);
		m_ebOther.Text.Format("%c", iSeparator);
		m_ebOther.Enable = 1;
	}
	
	///---Sim 2011-07-05 SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
	m_cbFilter.SetCurSel(iFilter);
	///---END SUPPORT_IMPWIZ_REMOVE_UNWANTED_VAR
}