/*------------------------------------------------------------------------------*
 * File Name: ImpWizHeadLines.h													*
 * Creation: GJL 7/11/2001														*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Danice 12/15/03 v7.5783 GET_ASCIMP_INIT										*
 * Danice 12/23/03 v7.5786 SAVE_CHANGE											*
 * Jason 12/26/03 v7.5789 USE_M_CBHEADERLINES									*
 * Jason 12/26/03 v7.5789 USE_M_CBCOLNAMEFROM									*
 * Jason 12/26/03 v7.5789 USE_M_CBCOLLABELFROM									*
 * Jason 12/26/03 v7.5789 USE_M_CBCOLLABELTO									*
 * Jason 12/26/03 v7.5789 USE_M_REHDRPREVIEW									*
 * Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER							*
 * Danice 1/17/04 v8.0802 FOR_CONTROL_UPGRADE_DATA								*
 * Danice 3/1/04 v8.0828 PAGE_INIT_ONCE											*
 * EJP 06-10-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES						*
 * EJP 09-24-2004 v8.0140 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP					*
 * EJP 11-18-2004 v8.0164 QA70-6554 EXTRACT_VARS_FROM_FILENAME					*
 * EJP 2005-02-16 v8.0193 QA70-7038 IMPROVE_HEADER_LINE_COLORING				*
 * EJP 2005-08-26 v8.0196 QA70-7894 USER_SPECIFY_NUM_PREVIEW_LINES				*
 * Sim 08-20-2007 ADD_HEADER_LINE_NUM_LABEL_ON_PREVIEW							*
 *------------------------------------------------------------------------------*/
 
#define ON_PAGE_CHECK_ASC_HEADER			if(!IS_SHOW_ASC_HEADER_PAGE) return FALSE;

/// EJP 06-10-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES
typedef struct {
	int HeaderLines;
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	int AutoSubHeaderLines;
	int SubHeaderLines;
	///---END SUPPORT_AUTO_HEADER_LINES
	int ShortNameFirstLine;
	int LongNameFirstLine;
	int UnitFirstLine;
	int CommentFirstLine;
	int CommentLastLine;
	int ParamFirstLine;
	int ParamLastLine;
	///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	int UserParamFirstLine;
	int UserParamLastLine;
	///---END SUPPORT_USER_PARAMETER
	int SaveFirstLine;
	int SaveLastLine;
} HEADERLINEINFO;
/// end MORE_HEADER_LINE_TYPES

// Derived WizPage class for WizPage1
class ImpWizHeadLinesPage : public ImpWizardPage
{
	// Constructor for ImpWizSourcePage class, use parent constructor
	//ImpWizSourcePage(int nID) : ImpWizardPage(nID) {}

public:
	EVENTS_BEGIN
		////////////////////////////////////////////////////////////////////////
		// ASCII Header Page
		////////////////////////////////////////////////////////////////////////
		///Danice 12/14/03 v7.5781 EVENTHANDLE_NOT_WORK : ON_PAGE_ not work
		//PAGE_ON_IS_SHOW(OnIsShowASCII)	///Danice 12/25/03 v7.5788 NOTUSE_SHOW
		//ON_PAGE_INIT(IDD_AIW_HEADER, AscHeader_OnInit)
		PAGE_ON_INIT(OnInit_AscHeader)
		PAGE_ON_ACTIVE(OnActive_AscHeader)
		PAGE_ON_KILLACTIVE(OnKillActive_AscHeader)
	
		// Number of header lines
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		ON_CBN_EDITCHANGE(IDC_IW_SUB_HEADER_LINES, OnChangeSubHeaderLines_AscHeader)
		ON_CBN_SELCHANGE(IDC_IW_SUB_HEADER_LINES, OnSelChangeSubHeaderLines_AscHeader)
		ON_BN_CLICKED(IDC_IW_SUB_HEADER_LINES_TBHLDR, OnRefreshSubHeaderLines_AscHeader)
		ON_BN_CLICKED(IDC_IW_AUTO_HEADER_LINES, OnClickAutoSubHeaderLines_AscHeader)
		ON_BN_CLICKED(IDC_IW_LINE_NUMBER_FROM_BOTTOM, OnClickLineNumberFromBottom_AscHeader)
		///---END SUPPORT_AUTO_HEADER_LINES
		ON_CBN_EDITCHANGE(IDC_IW_HEADER_LINES, OnChangeHeaderLines_AscHeader)
		ON_CBN_SELCHANGE(IDC_IW_HEADER_LINES, OnSelChangeHeaderLines_AscHeader)
		//ON_TOOLBAR_BN_CLICKED(IDB_IW_HEADER_LINES_REFRESH, OnRefreshHeaderLines_AscHeader)
		ON_BN_CLICKED(IDC_IW_HEADER_LINES_TBHLDR, OnRefreshHeaderLines_AscHeader)
	
		// Column names
		ON_CBN_EDITCHANGE(IDC_IW_COL_NAME_FROM, OnEditChangeColNameFrom_AscHdr)
		ON_CBN_SELCHANGE(IDC_IW_COL_NAME_FROM, OnSelChangeColNameFrom_AscHdr)
		/// EJP 06-10-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES
		///	//ON_TOOLBAR_BN_CLICKED(IDB_IW_COL_NAME_REFRESH, OnTBClickRefreshColNameFrom_AscHeader)
		///	ON_BN_CLICKED(IDC_IW_COL_NAME_TBHLDR, OnTBClickRefreshColNameFrom_AscHeader)
		/// end MORE_HEADER_LINE_TYPES
		
		// Column labels
		/// EJP 08-15-2003 v7.5662 CLEAN_HEADER_LINES_INPUT
		///ON_CBN_EDITCHANGE(IDC_IW_COL_LABEL_FROM, AscHeader_OnChangeColNameFromLabelRange)
		///ON_CBN_SELCHANGE(IDC_IW_COL_LABEL_FROM, AscHeader_OnSelChangeColNameLabel)
		///ON_CBN_EDITCHANGE(IDC_HDR_LABEL_TO, AscHeader_OnChangeColNameFromLabelRange)
		///ON_CBN_SELCHANGE(IDC_HDR_LABEL_TO, AscHeader_OnSelChangeColNameLabel)
		ON_CBN_EDITCHANGE(IDC_IW_COL_LABEL_FROM, OnEditChangeColLabelFrom_AscHdr)
		ON_CBN_SELCHANGE(IDC_IW_COL_LABEL_FROM, OnSelChangeColLabelFrom_AscHdr)
		ON_CBN_EDITCHANGE(IDC_HDR_LABEL_TO, OnEditChangeColLabelFrom_AscHdr)
		ON_CBN_SELCHANGE(IDC_HDR_LABEL_TO, OnSelChangeColLabelFrom_AscHdr)
		/// end CLEAN_HEADER_LINES_INPUT
		/// EJP 06-10-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES
		///	//ON_TOOLBAR_BN_CLICKED(IDB_IW_COL_LABEL_REFRESH, OnRefreshColLabelFrom_AscHeader)
		///	ON_BN_CLICKED(IDC_IW_COL_LABEL_TBHLDR, OnRefreshColLabelFrom_AscHeader)
		/// end MORE_HEADER_LINE_TYPES
		
		ON_CBN_EDITCHANGE(IDC_HDR_SAVE_FROM, OnEditChangeSaveFirstLine_AscHdr)
		ON_CBN_SELCHANGE(IDC_HDR_SAVE_FROM, OnSelChangeSaveFirstLine_AscHdr)
	
		/// JCG 05/28/03 v7.0540 HOOK_COMBO_BOX	
		ON_CBN_EDITCHANGE(IDC_HDR_SAVE_TO, OnEditChangeSaveFirstLine_AscHdr)
		ON_CBN_SELCHANGE(IDC_HDR_SAVE_TO, OnSelChangeSaveFirstLine_AscHdr)
		/// end HOOK_COMBO_BOX	
	
		ON_CBN_SELCHANGE(IDC_ASC_PREVIEW_FONT, OnSelChangeFont_AscHdr) /// EJP 10-20-2003 v7.5726 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT
		/// EJP 11-18-2004 v8.0164 QA70-6554 EXTRACT_VARS_FROM_FILENAME
		///ON_BN_CLICKED(IDC_HDRPARAM_DEFINEVAR, OnClickDefineVar_AscHeader)
		/// end EXTRACT_VARS_FROM_FILENAME
		
		/// EJP 10-27-03 v7.5733 QA70-5412 SKIP_CHARS_FOR_COL_NAME_LABEL
		ON_CBN_EDITCHANGE(IDC_NAME_LABEL_CHAR_OFFSET, OnEditChangeNameOffset_AscHdr)
		ON_CBN_SELCHANGE(IDC_NAME_LABEL_CHAR_OFFSET, OnSelChangeNameOffset_AscHdr)
		/// end SKIP_CHARS_FOR_COL_NAME_LABEL

		/// EJP 06-10-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES
		ON_CBN_EDITCHANGE(IDC_COL_LONGNAME_FROM, OnEditChangeLineType)
		ON_CBN_SELCHANGE(IDC_COL_LONGNAME_FROM, OnSelChangeLineType)
		ON_BN_CLICKED(IDC_COL_LONGNAME_UPDATE, OnClickLineTypeUpdate)

		ON_CBN_EDITCHANGE(IDC_COL_UNIT_FROM, OnEditChangeLineType)
		ON_CBN_SELCHANGE(IDC_COL_UNIT_FROM, OnSelChangeLineType)
		ON_BN_CLICKED(IDC_COL_UNIT_UPDATE, OnClickLineTypeUpdate)
		
		ON_CBN_EDITCHANGE(IDC_COL_PARAM_FROM, OnEditChangeLineType)
		ON_CBN_SELCHANGE(IDC_COL_PARAM_FROM, OnSelChangeLineType)
		ON_CBN_EDITCHANGE(IDC_COL_PARAM_TO, OnEditChangeLineType)
		ON_CBN_SELCHANGE(IDC_COL_PARAM_TO, OnSelChangeLineType)
		ON_BN_CLICKED(IDC_COL_PARAM_UPDATE, OnClickLineTypeUpdate)
		///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
		ON_CBN_EDITCHANGE(IDC_COL_USER_PARAM_FROM, OnEditChangeLineType)
		ON_CBN_SELCHANGE(IDC_COL_USER_PARAM_FROM, OnSelChangeLineType)
		ON_CBN_EDITCHANGE(IDC_COL_USER_PARAM_TO, OnEditChangeLineType)
		ON_CBN_SELCHANGE(IDC_COL_USER_PARAM_TO, OnSelChangeLineType)
		ON_BN_CLICKED(IDC_COL_USER_PARAM_UPDATE, OnClickLineTypeUpdate)
		///---END SUPPORT_USER_PARAMETER
		
		ON_BN_CLICKED(IDC_SAVE_HDR_UPDATE, OnClickLineTypeUpdate)
		ON_BN_CLICKED(IDC_IW_COL_LABEL_TBHLDR, OnClickLineTypeUpdate)
		ON_BN_CLICKED(IDC_IW_COL_NAME_TBHLDR, OnClickLineTypeUpdate)
		/// end MORE_HEADER_LINE_TYPES
		
		/// EJP 2005-08-26 v8.0196 QA70-7894 USER_SPECIFY_NUM_PREVIEW_LINES
		ON_CBN_EDITCHANGE(IDC_PREVIEW_LINES, OnEditPreviewLines)
		ON_CBN_SELCHANGE(IDC_PREVIEW_LINES, OnSelPreviewLines)
		/// end USER_SPECIFY_NUM_PREVIEW_LINES

	EVENTS_END

	///Danice 12/25/03 v7.5788 NOTUSE_SHOW
	DWORD    OnShowStatus(DWORD InternalStatus);
	///END NOTUSE_SHOW
	void InitializeBitmapButtons();
	
	bool OnInit_AscHeader();		///Danice 12/14/03 V 7.5781 CHANGE_FUNCTION_NAME

	void iw_InitFontComboBox(int iCtrl);

	bool OnActive_AscHeader();		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	bool OnKillActive_AscHeader();		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	BOOL OnChangeSubHeaderLines_AscHeader(Control ctrl);
	BOOL OnSelChangeSubHeaderLines_AscHeader(Control ctrl);
	BOOL OnRefreshSubHeaderLines_AscHeader(Control cntrl);
	BOOL OnClickAutoSubHeaderLines_AscHeader(Control ctrl);
	BOOL OnClickLineNumberFromBottom_AscHeader(Control ctrl);
	///---END SUPPORT_AUTO_HEADER_LINES
	
	BOOL OnChangeHeaderLines_AscHeader(Control ctrl);		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	BOOL OnSelChangeHeaderLines_AscHeader(Control ctrl);		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME

	//BOOL OnRefreshHeaderLines_AscHeader();		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	BOOL OnRefreshHeaderLines_AscHeader(Control cntrl);		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	BOOL OnEditChangeColNameFrom_AscHdr(Control ctrl);		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME

	bool OnSelChangeColNameFrom_AscHdr(Control ctrl);		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME

#ifdef JUNK /// EJP 06-10-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES
	//bool OnTBClickRefreshColNameFrom_AscHeader();		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	BOOL OnTBClickRefreshColNameFrom_AscHeader(Control ctrl);		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	//BOOL AscHeader_OnTBClickRefreshColNameFrom();
#endif // JUNK /// EJP 06-10-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES

	bool OnEditChangeColLabelFrom_AscHdr(Control ctrl);		//Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	bool OnSelChangeColLabelFrom_AscHdr(Control ctrl);		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME

	void AscHdr_EnableCtrls();
	
	void AscHdr_UpdatePreviewColor();

	/// EJP 2005-02-16 v8.0193 QA70-7038 IMPROVE_HEADER_LINE_COLORING
	void SetHeaderLineColor(DWORD dwColor, int nFirstLine, int nLineCount = 1, int nSkipChars = 0);
	void SetPreviewLineType(int nType, int nFirstLine, int nLineCount = 1);
	void ClearAllPreviewLineTypes();
	/// end IMPROVE_HEADER_LINE_COLORING
	
	///---Sim 08-20-2007 ADD_HEADER_LINE_NUM_LABEL_ON_PREVIEW
	void SetPreviewHeaderLineType(int nType, int nFirstLine, int nLineCount = 1);
	///---END ADD_HEADER_LINE_NUM_LABEL_ON_PREVIEW

#ifdef JUNK /// EJP 06-10-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES
	//bool OnRefreshColLabelFrom_AscHeader();			///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	BOOL OnRefreshColLabelFrom_AscHeader(Control ctrl);			///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
#endif // JUNK /// EJP 06-10-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES

	bool OnEditChangeSaveFirstLine_AscHdr(Control ctrl);		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	bool OnSelChangeSaveFirstLine_AscHdr(Control ctrl);		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	bool OnSelChangeFont_AscHdr(Control ctrl);		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	void iw_SetRichEditFont(int iCtrl, int iFont);

	/// EJP 11-18-2004 v8.0164 QA70-6554 EXTRACT_VARS_FROM_FILENAME
	///bool OnClickDefineVar_AscHeader(Control ctrl);		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	/// end EXTRACT_VARS_FROM_FILENAME

	bool OnEditChangeNameOffset_AscHdr(Control ctrl);		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
	
	bool OnSelChangeNameOffset_AscHdr(Control ctrl);		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME

	void AscHeader_Update(BOOL bDataToDlg=TRUE);
	
	///---Sim 12-26-2006 NO_NEED
	/*
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//void AscHdr_GetFromDialog(int& iHeaderLines, int& iColNameFrom, int& iColLabelFrom, int& iColLabelTo);
	void AscHdr_GetFromDialog(int& iHeaderLines, int& iColNameFrom, int& iColLabelFrom, int& iColLabelTo, int& iAutoSubHeaderLines, int& iSubHeaderLines);
	///---END SUPPORT_AUTO_HEADER_LINES
	*/
	///---END NO_NEED
	
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	bool GetHeaderLines(int& nMainHeaderLines, int& nSubHeaderLines, int& nAutoSubHeaderLines, bool bDialog = true);
	bool SetHeaderLines(int nMainHeaderLines, int nSubHeaderLines, int nAutoSubHeaderLines, bool bDialog = true);
	//bool AscHdr_GetActualSubHeaderLines(int& iAutoSubHeaderLines, int& iSubHeaderLines);
	bool GetAutoSubHeaderLines(int& nAutoSubHeaderLines, bool bDialog = true);
	///---END SUPPORT_AUTO_HEADER_LINES
	
	//bool AscHdr_GetColLabelLines(int &iColLabelFrom, int &iColLabelTo); ///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES remove
	
	//int AscHdr_GetColNameFrom(); ///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES remove
	
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//void AscHdr_Check(int& iHeaderLines, int& iColNameFrom, int& iColLabelFrom, int& iColLabelTo);
	void AscHdr_Check(int& iHeaderLines, int& iColNameFrom, int& iColLabelFrom, int& iColLabelTo, int& iAutoSubHeaderLines, int& iSubHeaderLines);
	///---END SUPPORT_AUTO_HEADER_LINES
	
	void AscHdr_GetSaveLines(int &iFirstLine, int &iNumLines, bool bFromDlg=true);
	
	void AscHdr_SetSaveLines(int iFirstLine, int iNumLines, bool bToDlg=true);
	/// EJP 06-10-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES
	BOOL OnEditChangeLineType(Control ctrl);

	BOOL OnSelChangeLineType(Control ctrl);

	BOOL OnClickLineTypeUpdate(Control ctrl);

	void GetSelLines(int& nFirstLine, int& nLastLine);
	
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	bool GetShortNameHeaderLine(int& nFirstLine, bool bDialog=true);
	bool SetShortNameHeaderLine(int nFirstLine, bool bDialog=true);

	bool GetCommentHeaderLine(int& nFirstLine, int& nLastLine, bool bDialog=true);
	bool SetCommentHeaderLine(int nFirstLine, int nLastLine, bool bDialog=true);
	///---END SUPPORT_AUTO_HEADER_LINES
	
	bool GetLongNameHeaderLine(int& nFirstLine, bool bDialog=true);

	bool SetLongNameHeaderLine(int nFirstLine, bool bDialog=true);

	bool GetUnitHeaderLine(int& nFirstLine, bool bDialog=true);

	bool SetUnitHeaderLine(int nFirstLine, bool bDialog=true);

	bool GetParamHeaderLine(int& nFirstLine, int& nLastLine, bool bDialog=true);

	bool SetParamHeaderLine(int nFirstLine, int nLastLine, bool bDialog=true);
	///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	bool GetUserParamHeaderLine(int& nFirstLine, int& nLastLine, bool bDialog=true);
	bool SetUserParamHeaderLine(int nFirstLine, int nLastLine, bool bDialog=true);
	///---END SUPPORT_USER_PARAMETER

	void GetHeaderLineInfo(HEADERLINEINFO& hli);

	void UpdatePreviewLines();

	void UpdatePreviewLineTypes();

	void UpdatePreviewText();
	/// end MORE_HEADER_LINE_TYPES

	void AscHdr_UpdatePreviewText();

	void AscHdr_DialogToASCIMP();
	void AscHdr_ASCIMPToDialog(); ///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES

	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	///---Sim 12-26-2006 NO_NEED
	////void AscHdr_SetToASCIMP(int iHeaderLines, int iColNameFrom, int iColLabelFrom, int iColLabelTo);
	//void AscHdr_SetToASCIMP(int iHeaderLines, int iColNameFrom, int iColLabelFrom, int iColLabelTo, int iAutoSubHeaderLines = 1, int iSubHeaderLines = 0);
	//
	////void AscHdr_GetFromASCIMP(int& iHeaderLines, int& iColNameFrom, int& iColLabelFrom, int& iColLabelTo);
	//void AscHdr_GetFromASCIMP(int& iHeaderLines, int& iColNameFrom, int& iColLabelFrom, int& iColLabelTo, int& iAutoSubHeaderLines, int& iSubHeaderLines);
	//
	////void AscHdr_SetToDialog(int iHeaderLines, int iColNameFrom, int iColLabelFrom, int iColLabelTo);
	//void AscHdr_SetToDialog(int iHeaderLines, int iColNameFrom, int iColLabelFrom, int iColLabelTo, int iAutoSubHeaderLines = 1, int iSubHeaderLines = 0);
	///---END NO_NEED
	
	bool IsFromBottomHeaderLines(bool bDialog=true);
	bool SetFromBottomHeaderLines(bool bValue, bool bDialog=true);
	///---END SUPPORT_AUTO_HEADER_LINES
	
	void AscHdr_UpdateSaveLines(bool bUpdateData=true);

	/// EJP 2005-08-26 v8.0196 QA70-7894 USER_SPECIFY_NUM_PREVIEW_LINES
	BOOL OnEditPreviewLines(Control ctrl);
	BOOL OnSelPreviewLines(Control ctrl);
	/// end USER_SPECIFY_NUM_PREVIEW_LINES
	
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	int AscHdr_GetActualMainHeaderLines();
	int AscHdr_GetActualSubHeaderLines();
	//int AscHdr_GetHeaderLines();
	
	int AscHdr_GetActualHeaderLines(int* pnMainHeaderLines = NULL, int* pnSubHeaderLines = NULL);
	void AscHdr_SetActualHeaderLinesByAuto(int nMainHeaderLines, int nSubHeaderLines, int nAutoSubHeaderLines = 1);
	
	void AscHdr_CheckAbsolutePos(int& nAbsolPos);
	void AscHdr_CheckAbsolutePos(int& nAbsolFirstPos, int& nAbsolLastPos);
	void AscHdr_CheckRelativePos(int& nRelatFirstPos, int& nRelatLastPos);
	
	int GetAbsolutePos(int nRelatPos);
	int GetRelativePos(int nAbsolPos);
	
	int ChangePosFromBottom(int nRelatPos);
	bool ChangePosFromBottom(int& nRelatFirstPos, int& nRelatLastPos);	
	///---END SUPPORT_AUTO_HEADER_LINES
	
private :
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	int		m_nMainHeaderLines;
	int		m_nSubHeaderLines;
	///---END SUPPORT_AUTO_HEADER_LINES

	int		m_iStartingNumHdrLines; /// EJP 07-14-2003 v7.0624 SCAN_FOR_NUM_COLS_ON_CHANGE_HEADER_LINES

	//RichEdit 	m_reHdr ;				///Jason 12/26/03 v7.5789 USE_M_REHDRPREVIEW
	//RichEdit 	m_reAscPreview ;		///Jason 12/26/03 v7.5789 USE_M_REHDRPREVIEW
	//RichEdit 	m_rePreview ;			///Jason 12/26/03 v7.5789 USE_M_REHDRPREVIEW
	RichEdit 	m_reHdrPreview ;

	ComboBox 	m_cbColLabelFrom ;
	ComboBox 	m_cbColLabelTo ;
	ComboBox 	m_cbColNameFrom ;
	ComboBox 	m_cbColNameLabelOffset ;
	ComboBox 	m_cbFirstLine ;
	ComboBox 	m_cbHeaderLines ;
	ComboBox 	m_cbLastLine ;
	//ComboBox 	m_cmbxColLabelTo ;		///Jason 12/26/03 v7.5789 USE_M_CBCOLLABELTO
	//ComboBox 	m_cmbxColLabelFrom ;	///Jason 12/26/03 v7.5789 USE_M_CBCOLLABELFROM
	//ComboBox 	m_cmbxColNameFrom ;		///Jason 12/26/03 v7.5789 USE_M_CBCOLNAMEFROM
	//ComboBox 	m_cmbxHeaderLines ;		///Jason 12/26/03 v7.5789 USE_M_CBHEADERLINES
	//ComboBox 	m_mbxColLabelTo ;		///Jason 12/26/03 v7.5789 USE_M_CBCOLLABELTO
	
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	ComboBox	m_cbSubHeaderLines;
	Button		m_chkAutoSubHeaderLines;
	Button		m_chkLineNumberFromBottom;
	///---END SUPPORT_AUTO_HEADER_LINES
	
	Control 	m_btnColNameRefresh ;
	Control 	m_btnColLabelRefresh ;
	
	Button 		m_chkDefineVar ;
	
	//ASCIMP	m_pAscimp;	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	ASCIMP* 	m_pAscimp;

	/// EJP 06-10-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES
	ComboBox m_cbColLongNameFrom;
	ComboBox m_cbColUnitFrom;
	ComboBox m_cbColParamFrom;
	ComboBox m_cbColParamTo;
	///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	ComboBox m_cbColUserParamFrom;
	ComboBox m_cbColUserParamTo;
	///---END SUPPORT_USER_PARAMETER
	ComboBox m_cbSaveLineFrom;
	ComboBox m_cbSaveLineTo;
	BitmapRadioButton m_btnColLongNameUpdate;
	BitmapRadioButton m_btnColUnitUpdate;
	BitmapRadioButton m_btnColParamUpdate;
	BitmapRadioButton m_btnColUserParamUpdate; ///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	BitmapRadioButton m_btnSaveUpdate;
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	BitmapRadioButton m_btnHeaderLinesUpdate;
	BitmapRadioButton m_btnSubHeaderLinesUpdate;
	///---END SUPPORT_AUTO_HEADER_LINES
	StringArray m_saPreviewLines;
	/// end MORE_HEADER_LINE_TYPES
	
	Button m_btnUDLNames; /// Hong 04/28/07 QA80-8584-S12 ALLOW_SEPCIAL_USER_PARAMETER_NAME
	
	ComboBox m_cbPreviewLines; /// EJP 2005-08-26 v8.0196 QA70-7894 USER_SPECIFY_NUM_PREVIEW_LINES
};
