/*------------------------------------------------------------------------------*
 * File Name: ImpWizDrapAndDrop.c												*
 * Creation: 																	*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Bill 12/17/2010 ORG-1737-S1 ADD_OPTION_TO_SPECIFY_WHEN_TO_RUN_SCRIPT		*
 *------------------------------------------------------------------------------*/
 

#include <Origin.h>
#include "IWfirst.h"

///Danice 12/25/03 v7.5788 NOTUSE_SHOW
DWORD ImpWizDrapAndDropPage::OnShowStatus(DWORD InternalStatus)
{
	return (IS_SHOW_ADVANCED ? PSS_Show : PSS_Ignore);
}
///END NOTUSE_SHOW

BOOL ImpWizDrapAndDropPage::OnInit_DragDrop()	///Jason 12/12/03 v7.5780 CHANGE_SOME_FUNCTION_NAME
{
	ON_PAGE_CHECK_DRAG_DROP
	
	///Danice PAGE_INIT_ONCE
	if(!ImpWizardPage::Init())
		return FALSE;
	///END PAGE_INIT_ONCE

	/// EJP 09-10-2003 v7.5890 QA70-5135.11 REMOVE_PLOTPAGE_OPTION_FROM_DRAGDROP_PAGE
	/*
	if( !(s_iActivePageType == EXIST_PLOT) )
	{
		ComboBox cbGraph = ImportWizDlg.GetItem(IDC_DROP_FILES_IN_GRAPH, IDD_IW_DRAP_AND_DROP);
		if( cbGraph.GetCount() > FILTER_DDGRAPH_PLOTSETTINGS )
			cbGraph.DeleteString(FILTER_DDGRAPH_PLOTSETTINGS);
	}
	*/
	/// end REMOVE_PLOTPAGE_OPTION_FROM_DRAGDROP_PAGE
	
	m_cbGraph = GetItem(IDC_DROP_FILES_IN_GRAPH);
	m_cbWorkspace = GetItem(IDC_DROP_FILES_IN_WKSP);
	m_ebScript = GetItem(IDC_POST_IMPORT_EXECUTE);
	m_ebOpenIn = GetItem(IDC_OPEN_FILES_IN);

	/// Bill 12/17/2010 ORG-1737-S1 ADD_OPTION_TO_SPECIFY_WHEN_TO_RUN_SCRIPT
	m_rbRunOptionAfterAll = GetItem(IDC_ALL_FILE_IMPORTED);
	m_rbRunOptionAfterAll.Value = false;
	
	m_rbRunOptionAfterEach = GetItem(IDC_EACH_FILE_IMPORTED);
	m_rbRunOptionAfterEach.Value = true;
	/// End ADD_OPTION_TO_SPECIFY_WHEN_TO_RUN_SCRIPT

	return TRUE;
}

BOOL ImpWizDrapAndDropPage::OnActive_DragDrop()	///Jason 12/12/03 v7.5780 CHANGE_SOME_FUNCTION_NAME
{
	ON_PAGE_CHECK_DRAG_DROP
	DragDrop_Update();

#ifdef DISABLE_FILE_TYPES_PAGE
	//Button btnNext = ImportWizDlg.GetItem(IDC_NEXT);	///Jason 12/12/03 v7.5780 MOVE_TO_ON_INIT_SAVE_FILTERS
	m_pSheet->EnableNextBT(FALSE);
#endif // ENABLE_FILE_TYPES_PAGE

	return TRUE;
}

BOOL ImpWizDrapAndDropPage::OnKillActive_DragDrop()	///Jason 12/12/03 v7.5780 CHANGE_SOME_FUNCTION_NAME
{
	ON_PAGE_CHECK_DRAG_DROP
	DragDrop_Update(FALSE);

#ifdef DISABLE_FILE_TYPES_PAGE
	//Button btnNext = ImportWizDlg.GetItem(IDC_NEXT);	///Jason 12/12/03 v7.5780 MOVE_TO_ON_INIT_SAVE_FILTERS
	m_pSheet->EnableNextBT(TRUE);
#endif // ENABLE_FILE_TYPES_PAGE

	return TRUE;
}

BOOL ImpWizDrapAndDropPage::OnFinish()
{
	DragDrop_Update(FALSE);
	return TRUE;
}

void ImpWizDrapAndDropPage::DragDrop_Update(BOOL bDataToDlg) //=TRUE)
{
	string str;
	
	//ComboBox cbGraph = ImportWizDlg.GetItem(IDC_DROP_FILES_IN_GRAPH, IDD_IW_DRAP_AND_DROP);	///Jason 12/12/03 v7.5780 MOVE_TO_ON_INIT_SAVE_FILTERS
	//ComboBox cbWorkspace = ImportWizDlg.GetItem(IDC_DROP_FILES_IN_WKSP, IDD_IW_DRAP_AND_DROP);	///Jason 12/12/03 v7.5780 MOVE_TO_ON_INIT_SAVE_FILTERS
	/// EJP 07-07-2003 v7.0619 QA70-4783 POST_IMPORT_EXECUTE
	//Edit ebScript = ImportWizDlg.GetItem(IDC_POST_IMPORT_EXECUTE, IDD_IW_DRAP_AND_DROP);	///Jason 12/12/03 v7.5780 MOVE_TO_ON_INIT_SAVE_FILTERS
	/// end POST_IMPORT_EXECUTE

	if( bDataToDlg )
	{
		m_cbGraph.SetCurSel(fuGetDragDropGraph(s_trFilter));
		m_cbWorkspace.SetCurSel(fuGetDragDropWorkspace(s_trFilter));
	
		//Edit ebOpenIn = ImportWizDlg.GetItem(IDC_OPEN_FILES_IN, IDD_IW_DRAP_AND_DROP);	///Jason 12/12/03 v7.5780 MOVE_TO_ON_INIT_SAVE_FILTERS
		int i = fuGetTargetPage(s_trFilter);
		if( EXIST_MATRIX == i )
			m_ebOpenIn.Text = "Matrix";
		else
			m_ebOpenIn.Text = "Worksheet";
	
		/// EJP 07-07-2003 v7.0619 QA70-4783 POST_IMPORT_EXECUTE
		fuGetPostImportScript(s_trFilter, str);
		m_ebScript.Text = str;
		/// end POST_IMPORT_EXECUTE
		
		/// Bill 12/17/2010 ORG-1737-S1 ADD_OPTION_TO_SPECIFY_WHEN_TO_RUN_SCRIPT
		m_rbRunOptionAfterAll.Value = fuIsRunScriptAfterAllFileImported(s_trFilter);
		m_rbRunOptionAfterEach.Value = !m_rbRunOptionAfterAll.Value;
		/// End ADD_OPTION_TO_SPECIFY_WHEN_TO_RUN_SCRIPT
	}
	else
	{
		fuSetDragDropGraph(s_trFilter, m_cbGraph.GetCurSel());
		fuSetDragDropWorkspace(s_trFilter, m_cbWorkspace.GetCurSel());

		/// EJP 07-07-2003 v7.0619 QA70-4783 POST_IMPORT_EXECUTE
		str = m_ebScript.Text;
		str.TrimLeft();
		str.TrimRight();
		fuSetPostImportScript(s_trFilter, str);
		/// end POST_IMPORT_EXECUTE
		
		/// Bill 12/17/2010 ORG-1737-S1 ADD_OPTION_TO_SPECIFY_WHEN_TO_RUN_SCRIPT
		int nOption = (m_rbRunOptionAfterAll.Value == 1 ? 1 : 0);
		fuSetIsRunScriptAfterAllFileImported(s_trFilter, nOption);
		/// End ADD_OPTION_TO_SPECIFY_WHEN_TO_RUN_SCRIPT
	}
}	
