/*------------------------------------------------------------------------------*
 * File Name: ImpWizDataPattern.c												*
 * Creation: 																	*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT				*
 *	Sim 11-01-2008 v8.0964c QA80-12260 FIX_TYPE_FIRST_LETTER_IN_TYPE_COMBO_LIST_NOT_UPDATE_DIALOG
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include "IWfirst.h"
 
//--- CPY 2/10/04 CHANGE_GRID_TO_CLASS
// we need to use class to represent all vsFlexGrid, should not have GetActiveXControl anywere in importwizard codes
BinDataElementsList::BinDataElementsList() 
{
}

void BinDataElementsList::Init(int nID, WndContainer& dlg)
{		
	GridListControl::Init(nID, dlg);

	///Danice 2/16/04 v8.0821 ADD_SOME_ACCESS_FUNCTION
	//SetupRowsCols(0, 1, GRIDCOL_TOTAL_COLS);	///Danice 3/29/04 v8.0844b CHANGE_PARA_ORDER_ROW_COL
	SetupRowsCols(1, 0, -1, GRIDCOL_TOTAL_COLS);
	m_flx.AllowUserResizing = flexResizeColumns;
	m_flx.Editable = flexEDKbdMouse;
	//m_flx.Cols = 4;
	//m_flx.FixedCols = 0;
	//m_flx.Rows = 2; // column headers and 1 data row
	///Danice 2/20/04 v8.0822 INIT_GRID
	m_flx.SelectionMode = flexSelectionFree ;
	m_flx.AllowSelection = true;
	m_flx.ExtendLastCol = false;
	///END INIT_GRID
	///END ADD_SOME_ACCESS_FUNCTION
	
	//m_flx.Row = 0;
	m_flx.BackColorBkg = RGB(255, 255, 255);
	/*
	m_flx.Col = GRIDCOL_BINPARAM_COLUMN;
	m_flx.ColWidth(GRIDCOL_BINPARAM_COLUMN) = m_flx.ClientWidth * 0.15;
	m_flx.Text = _L("Column");
	m_flx.Col = GRIDCOL_BINPARAM_TYPE;
	m_flx.ColWidth(GRIDCOL_BINPARAM_TYPE) = m_flx.ClientWidth * 0.35;
	m_flx.Text = _L("Type");
	m_flx.Col = GRIDCOL_BINPARAM_SIZE;
	m_flx.ColWidth(GRIDCOL_BINPARAM_SIZE) = m_flx.ClientWidth * 0.25;
	m_flx.Text = _L("Size");
	m_flx.Col = GRIDCOL_BINPARAM_COUNT;
	m_flx.ColWidth(GRIDCOL_BINPARAM_COUNT) = m_flx.ClientWidth * 0.2499; //0.25
	m_flx.Text = _L("Count");
	*/
	SetColHeading(GRIDCOL_BINPARAM_COLUMN, _L("Column"));
	SetColHeading(GRIDCOL_BINPARAM_TYPE, _L("Type"));
	SetColHeading(GRIDCOL_BINPARAM_SIZE, _L("Size"));
	SetColHeading(GRIDCOL_BINPARAM_COUNT, _L("Count"));
	
	vector	vColWidthPercent = {0.15, 0.35, 0.25, 0.2499};//Sum a little less then 1, so the rollbar don't appear at first
	ResizeCols(vColWidthPercent);
	
	string str = BINIMP_DATA_TYPE_TOKENS;
	SetColComboList(GRIDCOL_BINPARAM_TYPE, str);
	/*
	m_flx.Row = 1;
	m_flx.Col = 0;
	m_flx.Text = "1";
	*/
	SetCell(1, GRIDCOL_BINPARAM_COLUMN, 1);	//first columns first row always equal 1
}

void BinDataElementsList::OnGridBeforeEdit(int nRow, int nCol)
{
	if( nRow == m_flx.Rows - 1 && GRIDCOL_BINPARAM_COUNT == nCol )
	{
		string str = GetCell(flexcpText, nRow, GRIDCOL_BINPARAM_COLUMN);
		if( !str.IsEmpty() && atoi(str) > 0 )
			m_flx.Rows += 1;
	}
}

void BinDataElementsList::UpdateDataColumnOffsets(int iEditTextRow)
{
	if( m_flx.Rows <= 1 )
		return; // nothing to do

	string str;
	int iCount, iDataCol = 1; // first data col is always 1
	for(int iRow = 1; iRow < m_flx.Rows; iRow++ )
	{
		SetCell(iDataCol, flexcpText, iRow, GRIDCOL_BINPARAM_COLUMN);
		if( iRow == iEditTextRow )
			str = m_flx.EditText;
		else
			str = GetCell(flexcpText, iRow, GRIDCOL_BINPARAM_COUNT);
		iCount = atoi(str);
		iDataCol += iCount;
	}
}

void BinDataElementsList::UpdateParamVectorsFromGrid(int iEditTextRow, int iEditTextCol, vector<BYTE>& vParamType, vector<WORD>& vParamCount, vector<WORD>& vParamSize, int& iNumColumns)
{
	vParamType.SetSize(0);
	vParamCount.SetSize(0);
	vParamSize.SetSize(0);

	int iBinImpDataTypes[] = {BIP_TYPE_INT, BIP_TYPE_UINT, BIP_TYPE_REAL, BIP_TYPE_STRING};
	
	string strBinImpDataTypes(BINIMP_DATA_TYPE_TOKENS);
	
	string strType, strCount, strSize;
	int iType, iCount, iSize;

	for(int iRow = 1; iRow < m_flx.Rows; iRow++ )
	{
		strType = GetCell(flexcpText, iRow, GRIDCOL_BINPARAM_TYPE);
		if( strType.IsEmpty() )
			continue;//break;//Hong 8/10/06 QA70-5211 v.8.0459b LOST_ROW_WHEN_INSERT_EMPTY_ROW
		iType = strBinImpDataTypes.FindToken(strType, '|');
		if( iType < 0 || iType > 3 )
			continue;//break;//Hong 8/10/06 QA70-5211 v.8.0459b LOST_ROW_WHEN_INSERT_EMPTY_ROW
		
		if( iRow == iEditTextRow && GRIDCOL_BINPARAM_COUNT == iEditTextCol )
			strCount = m_flx.EditText;
		else
			strCount = GetCell(flexcpText, iRow, GRIDCOL_BINPARAM_COUNT);
		iCount = atoi(strCount);
///		if( iCount <= 0 )
///			break;
		
		if( iRow == iEditTextRow && GRIDCOL_BINPARAM_SIZE == iEditTextCol )
			strSize = m_flx.EditText;
		else
			strSize = GetCell(flexcpText, iRow, GRIDCOL_BINPARAM_SIZE);
		iSize = atoi(strSize);
///		if( iSize <= 0 )
///			break;
		
		vParamType.Add(iBinImpDataTypes[iType]);
		vParamCount.Add(iCount);
		vParamSize.Add(iSize);
	}
	
	iNumColumns = 0;
	for( int i = 0; i < vParamCount.GetSize(); i++ )
		iNumColumns += vParamCount[i];
}

void BinDataElementsList::UpdateGridFromParamVectors(const vector<BYTE>& vParamType, const vector<WORD>& vParamCount, const vector<WORD>& vParamSize)
{
	m_flx.Rows = 1; // 1 for only the column headings

	if( vParamCount.GetSize() > 0 )
	{
		
		m_flx.Rows = vParamCount.GetSize() + 1;
		int iColumns = 1;

		string strBinImpDataTypes(BINIMP_DATA_TYPE_TOKENS); 

		for( int iParam = 0; iParam < vParamCount.GetSize(); iParam++ )
		{
			m_flx.Row = iParam + 1;

			m_flx.Col = GRIDCOL_BINPARAM_COLUMN;
			m_flx.Text = iColumns;
			
			iColumns += vParamCount[iParam];
			
			m_flx.Col = GRIDCOL_BINPARAM_TYPE;
			if( vParamType[iParam] == BIP_TYPE_INT )
				m_flx.Text = strBinImpDataTypes.GetToken(PARAM_TYPE_INT, '|');
			else if( vParamType[iParam] == BIP_TYPE_UINT )
				m_flx.Text = strBinImpDataTypes.GetToken(PARAM_TYPE_UINT, '|');
			else if( vParamType[iParam] == BIP_TYPE_REAL )
				m_flx.Text = strBinImpDataTypes.GetToken(PARAM_TYPE_REAL, '|');
			else if( vParamType[iParam] == BIP_TYPE_STRING )
				m_flx.Text = strBinImpDataTypes.GetToken(PARAM_TYPE_STR, '|');
			
			m_flx.Col = GRIDCOL_BINPARAM_SIZE;
			m_flx.Text = vParamSize[iParam];
			
			m_flx.Col = GRIDCOL_BINPARAM_COUNT;
			m_flx.Text = vParamCount[iParam];
		}
	}
}

void BinDataElementsList::AddRowToGrid()
{
	m_flx.AddItem("", m_flx.Rows);
}

void BinDataElementsList::UpdateDataViewColoring(int& iTotal)
{
	string strLength, strCount;
	for(int iRows = 1; iRows < m_flx.Rows; iRows++)
	{
		strLength = GetCell(0, iRows, 2);
		strCount = GetCell(0, iRows, 3);
		/// EJP 11-11-2003 v7.5751 QA70-5211.7 FIX_USED_BYTES_COLORING
		///if(iRows == grdPattern.Row && atoi(strCount) == 0)
		///	strCount = grdPattern.EditText;
		if( iRows == m_flx.Row )
		{
			string str;
			str = m_flx.EditText;
			if( !str.IsEmpty() )
			{
				if( 2 == m_flx.Col )
					strLength = m_flx.EditText;
				else
					strCount = m_flx.EditText;
			}
		}
		/// end FIX_USED_BYTES_COLORING
		if(atoi(strLength) * atoi(strCount) == 0)
			break;
		iTotal = iTotal + (atoi(strLength) * atoi(strCount));
	}
}

void BinDataElementsList::GetRowAndCol(int& iRow, int& iCol)
{
	iRow = m_flx.Row;
	iCol = m_flx.Col;
}

void BinDataElementsList::OnGridComboCloseUp()
{
	int iSel = m_flx.ComboIndex;
	m_flx.Col = GRIDCOL_BINPARAM_SIZE;
	if( PARAM_TYPE_INT == iSel || PARAM_TYPE_UINT == iSel )
		m_flx.Text = "4"; // default size of int/uint
	else if( PARAM_TYPE_REAL == iSel )
		m_flx.Text = "8"; // default size of Real
	if( PARAM_TYPE_STR != iSel ) // if param type is not string
		m_flx.Col = GRIDCOL_BINPARAM_COUNT; // set focus to the Count column
}
///Danice ADD_SOME_ACCESS_FUNCTION
/*
void SetFinishEditing(bool bFinish = true)
{
	m_flx.FinishEditing = bFinish;
}
void InsertRow()
{
	/// EJP 09-04-2003 v7.5684 QA70-5106 INSERT_BIN_PATTERN_BEFORE_FIRST_ROW
	///if( objGrid.Row <= 1 )
	if( m_flx.Row < 1 )
	/// end INSERT_BIN_PATTERN_BEFORE_FIRST_ROW
		m_flx.Rows += 1;
	else
		m_flx.AddItem("", m_flx.Row);
}

bool DeleteRow()
{
	if( m_flx.Row < 1 )
		return FALSE;
	m_flx.RemoveItem(m_flx.Row);
	return TRUE;
}
*/
///END ADD_SOME_ACCESS_FUNCTION
//--- end CHANGE_GRID_TO_CLASS

///Danice 12/25/03 v7.5788 NOTUSE_SHOW
DWORD ImpWizDataPatternPage::OnShowStatus(DWORD InternalStatus)
{
	return (IS_FILTER_TYPE_BINARY ? PSS_Show : PSS_Ignore);
}
///END NOTUSE_SHOW

//--------------------------------------------------------------------------
// UpdateWksCtrl
//
// Call this function to update the worksheet control on the specified page.
//--------------------------------------------------------------------------
void ImpWizDataPatternPage::UpdateWksCtrl(int iWizPageID)
{
	///Danice 12/26/03 v7.5789 UPDATE_DIRECTLY
/*	int iCtrlID;
	switch( iWizPageID )
	{
	case IDD_AIW_COLUMNS:
		iCtrlID = IDC_COL_WKS_PREVIEW;
		break;
	case IDD_IW_RANGE:
		iCtrlID = IDC_RANGE_PREVIEW;
		break;
	case IDD_BIW_DATAPATERN:
		iCtrlID = IDC_BIW_DATAPATERN_PREVIEW_LC;
		break;
	default:
		return;
	}*/
	///END 	UPDATE_DIRECTLY

	//WorksheetControl wc = ImportWizDlg.GetItem(iCtrlID, iWizPageID);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	//WorksheetControl wc = GetItem(IDC_BIW_DATAPATERN_PREVIEW_LC);
	//wc.Attach(s_strWks);
	m_wc.Attach(m_pSheet->GetWksName());
	
	m_wc.Update();
}

void ImpWizDataPatternPage::UpdatePreview(int iWizPageID)
{
	///Danice 12/25/03 v7.5788 SAVE_BEFORE_CHANGE		///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	//m_pSheet->SetASCIMP(m_ascimp);
	//m_pSheet->SetBINIMP(m_pBinimp);
	
	m_pSheet->UpdateImpStructCommonFromTree();
	m_pSheet->ImportToWks();
	
	//m_pSheet->GetASCIMP(m_ascimp);
	//m_pSheet->GetBINIMP(m_pBinimp);
	///END SAVE_BEFORE_CHANGE	NEW_ACCESS_METHOD_GET_POINTER
			
	UpdateWksCtrl(iWizPageID);

}
int ImpWizDataPatternPage::BinHeader_GetParamValAsStr(int nType, int nOffset, int nSize, string &strVal)
{
	file ff;
	if( ff.Open(s_strDataFile, file::modeRead|file::shareDenyRead|file::typeBinary) )
	{
		ReadBinaryHeaderParam(strVal, ff, nType, nOffset, nSize, !m_pBinimp->iBigEndian);
		ff.Close();
		return 0;
	}
	return 1; // failed to open
}
BOOL ImpWizDataPatternPage::GetBinHdrParamListStr(string &str, int nIndex, BOOL bWithValue) //=true)
{
	if( nIndex < 0 || nIndex >= HDRPARAM_COUNT )
		return FALSE;

	char cTypeCode;
	switch( m_vHdrParamType[nIndex] )
	{
	case BIP_TYPE_INT:
		cTypeCode = 'I';
		break;
	case BIP_TYPE_UINT:
		cTypeCode = 'U';
		break;
	case BIP_TYPE_REAL:
		cTypeCode = 'R';
		break;
	case BIP_TYPE_STRING:
		cTypeCode = 'S';
		break;
	default:
		return FALSE;
	}
	
	str.Format("%s(%c%d,%d)", m_saHdrParamName[nIndex], cTypeCode, m_vHdrParamSize[nIndex], m_vHdrParamOffset[nIndex]);

	if( bWithValue )
	{
		string strVal;
		BinHeader_GetParamValAsStr(m_vHdrParamType[nIndex], m_vHdrParamOffset[nIndex], m_vHdrParamSize[nIndex], strVal);
		str += "=";
		str += strVal;
	}
	return TRUE;
}

BOOL ImpWizDataPatternPage::OnInit_BinPattern()    ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	ON_PAGE_CHECK_BIN_PATTERN
	
	///Danice PAGE_INIT_ONCE
	if(!ImpWizardPage::Init())
		return FALSE;
	///END PAGE_INIT_ONCE
		
	///Jacky 12/14/03 v7.5781 DEFINE_SOME_NEW_MEMBER 
	//m_ctrlGrid 		= GetItem(IDC_BIW_DATAPATERN_PATERN_GRID);	///Danice CHANGE_GRID_TO_CLASS
	//m_octrl 		= GetItem(IDC_BIW_DATAPATERN_PATERN_GRID);
	m_ctrlParamText = GetItem(IDC_PARAMETER_TEXT);
	m_ctrlValueText = GetItem(IDC_VALUE_TEXT);
	m_comboParams 	= GetItem(IDC_BIW_DATAPATERN_PARAMS);
	//m_wc 			= GetItem(IDC_BIW_DATAPATERN_PREVIEW_LC);

	if( !m_wc ) /// EJP 02-26-2004 v7.5828 ONLY_CREATE_WKS_CTRL_ONCE
	{
		Control ctrlTmp =		GetItem(IDC_BIW_DATAPATERN_PREVIEW_LC);
		HWND hWnd = ctrlTmp.GetSafeHwnd();
		if(hWnd)
			m_wc.CreateControl(hWnd);
		else
			ASSERT(FALSE);
	}

	m_reDataView 	= GetItem(IDC_BIW_DATAPATERN_HEXDUMP_RICHEDIT);
	m_editValue 	= GetItem(IDC_BIW_DATAPATERN_VALUE);
	///End DEFINE_SOME_NEW_MEMBER 
	
	m_chkKeepColFormat = GetItem(IDC_IW_KEEP_COL_FORMAT); // Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
	
	///Danice INIT_WITH_SHEET : Init the varialbe with Sheet property	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	m_pBinimp = m_pSheet->GetBINIMP_Pointer();
	//m_pSheet->GetASCIMP(m_ascimp);
	//m_pSheet->GetBINIMP(m_pBinimp);
	m_pSheet->GetHdrParam(m_saHdrParamName, m_vHdrParamType, m_vHdrParamOffset, m_vHdrParamSize);
	///END INIT_WITH_SHEET

	
	// Setup the Data View controls
	//Control pgSource = ImportWizDlg.GetItem(IDD_BIW_DATAPATERN); ///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	if( IS_BINPATTERN_BINVIEW )
		
		//pgSource.CheckRadioButton(IDC_BIW_DATAPATERN_HEX, IDC_BIW_DATAPATERN_ASCII, IDC_BIW_DATAPATERN_HEX);
		CheckRadioButton(IDC_BIW_DATAPATERN_HEX, IDC_BIW_DATAPATERN_ASCII, IDC_BIW_DATAPATERN_HEX);
	else
		//pgSource.CheckRadioButton(IDC_BIW_DATAPATERN_HEX, IDC_BIW_DATAPATERN_ASCII, IDC_BIW_DATAPATERN_ASCII);
		CheckRadioButton(IDC_BIW_DATAPATERN_HEX, IDC_BIW_DATAPATERN_ASCII, IDC_BIW_DATAPATERN_ASCII);
	
	//RichEdit reDataView = ImportWizDlg.GetItem(IDC_BIW_DATAPATERN_HEXDUMP_RICHEDIT, IDD_BIW_DATAPATERN);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//reDataView.SendMessage(EM_SETEVENTMASK, 0, ENM_CHANGE|ENM_SCROLL|ENM_SELCHANGE);
	m_reDataView.SendMessage(EM_SETEVENTMASK, 0, ENM_CHANGE|ENM_SCROLL|ENM_SELCHANGE);
	
	/// EJP 10-20-2003 v7.5726 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT
	///reDataView.SetFont(SYSTEM_FIXED_FONT);
	/// end ALLOW_CHANGING_PREVIEW_FONT
	//BinPattern_UpdateDataView();	///Danice REFRESH_PREVIEW_WHEN_CHANGE
	
	// Setup the Pattern grid control
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_BIW_DATAPATERN_PATERN_GRID, IDD_BIW_DATAPATERN);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	///Dancie 2/12/04 v8.0819 CHANGE_GRID_TO_CLASS
	/*
	//if( ctrlGrid )
	if( m_ctrlGrid )
	{
		//Object objGrid = ctrlGrid.GetActiveXControl();
		Object objGrid = m_ctrlGrid.GetActiveXControl();
		if( objGrid )
		{
			objGrid.AllowUserResizing = flexResizeColumns;
			objGrid.Editable = flexEDKbdMouse;
		//--- CPY 2/10/04 CHANGE_GRID_TO_CLASS
		// moved into inside class to show it works
		//	objGrid.Cols = 4;
		//---
			objGrid.FixedCols = 0;
			objGrid.Rows = 2; // column headers and 1 data row
			objGrid.Row = 0;
			objGrid.BackColorBkg = RGB(255, 255, 255);
			objGrid.Col = GRIDCOL_BINPARAM_COLUMN;
			objGrid.ColWidth(GRIDCOL_BINPARAM_COLUMN) = objGrid.ClientWidth * 0.15;
			objGrid.Text = _L("Column");
			objGrid.Col = GRIDCOL_BINPARAM_TYPE;
			objGrid.ColWidth(GRIDCOL_BINPARAM_TYPE) = objGrid.ClientWidth * 0.35;
			objGrid.Text = _L("Type");
			objGrid.Col = GRIDCOL_BINPARAM_SIZE;
			objGrid.ColWidth(GRIDCOL_BINPARAM_SIZE) = objGrid.ClientWidth * 0.25;
			objGrid.Text = _L("Size");
			objGrid.Col = GRIDCOL_BINPARAM_COUNT;
			objGrid.ColWidth(GRIDCOL_BINPARAM_COUNT) = objGrid.ClientWidth * 0.25;
			objGrid.Text = _L("Count");
			string str = BINIMP_DATA_TYPE_TOKENS;
			objGrid.ColComboList(GRIDCOL_BINPARAM_TYPE) = str;
			objGrid.Row = 1;
			objGrid.Col = 0;
			objGrid.Text = "1";
		}
	}
	*/
	
	//--- CPY 2/10/04 CHANGE_GRID_TO_CLASS
	m_dataElements.Init(IDC_BIW_DATAPATERN_PATERN_GRID, *this);
	//---
	///END CHANGE_GRID_TO_CLASS
	
	BOOL bVisible = false;
	if( HDRPARAM_COUNT )
	{
		bVisible = true;
		
		string str;
		//ComboBox comboParams = ImportWizDlg.GetItem(IDC_BIW_DATAPATERN_PARAMS, IDD_BIW_DATAPATERN);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
		
		//comboParams.ResetContent();
		m_comboParams.ResetContent();
		
		for( int n = 0; n < HDRPARAM_COUNT; n++ )
		{
			GetBinHdrParamListStr(str, n);
			
			//comboParams.AddString(str);
			m_comboParams.AddString(str);
		}
	}

	//Control ctrlParamText = ImportWizDlg.GetItem(IDC_PARAMETER_TEXT, IDD_BIW_DATAPATERN);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//ctrlParamText.Visible = bVisible;
	m_ctrlParamText.Visible = bVisible;
	
	//Control ctrlValueText = ImportWizDlg.GetItem(IDC_VALUE_TEXT, IDD_BIW_DATAPATERN);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//ctrlValueText.Visible = bVisible;
	m_ctrlValueText.Visible = bVisible;
	
	//ComboBox comboParams = ImportWizDlg.GetItem(IDC_BIW_DATAPATERN_PARAMS, IDD_BIW_DATAPATERN);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//comboParams.Visible = bVisible;
	m_comboParams.Visible = bVisible;
	
	//Edit editValue = ImportWizDlg.GetItem(IDC_BIW_DATAPATERN_VALUE, IDD_BIW_DATAPATERN);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//editValue.Visible = bVisible;
	m_editValue.Visible = bVisible;
	
	///Danice 12/23/03 v7.5786 SAVE_CHANGE	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	//m_pSheet->SetASCIMP(m_ascimp);
	//m_pSheet->SetBINIMP(m_pBinimp);
	m_pSheet->SetHdrParam(m_saHdrParamName, m_vHdrParamType, m_vHdrParamOffset, m_vHdrParamSize);
	///END SAVE_CHANGE

	return true;
}

BOOL ImpWizDataPatternPage::OnActivate_BinPattern()       ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	ON_PAGE_CHECK_BIN_PATTERN
	
	///Danice REFRESH_PREVIEW_WHEN_CHANGE
	if(IS_UPDATE_PREVIEW_NEEDED)
	{
		BinPattern_UpdateDataView();
		DISABLE_UPDATE_PREVIEW_NEEDED;
	}
	///END REFRESH_PREVIEW_WHEN_CHANGE
	
	///Danice INIT_WITH_SHEET : Init the varialbe with Sheet property	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	//m_pSheet->GetASCIMP(m_ascimp);
	//m_pSheet->GetBINIMP(m_pBinimp);
	m_pSheet->GetHdrParam(m_saHdrParamName, m_vHdrParamType, m_vHdrParamOffset, m_vHdrParamSize);
	///END INIT_WITH_SHEET

	
	/// EJP 10-20-2003 v7.5726 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT
	iw_SetRichEditFont(IDC_BIW_DATAPATERN_HEXDUMP_RICHEDIT, IW_PREVIEW_FONT);
	//WorksheetControl wc = ImportWizDlg.GetItem(IDC_BIW_DATAPATERN_PREVIEW_LC, IDD_BIW_DATAPATERN);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL

	BinPattern_UpdateDataViewColoring(); ///---Sim 09-21-2006 FIX_SHOW_HEAD_LINE must be after set Font function
	
	//if( wc )
	if( m_wc )
	//	wc.SetFont(IW_PREVIEW_FONT);
	    m_wc.SetFont(IW_PREVIEW_FONT);
	    
	/// end ALLOW_CHANGING_PREVIEW_FONT

	/// Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
	m_chkKeepColFormat.Check = fuIsKeepTargetColFormat(IW_FILTER);
	/// end MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
	
	BinPattern_UpdateGridFromParamVectors();
	BinCols_AddRowToGrid(); // a starting point for another param
	UpdatePreview(IDD_BIW_DATAPATERN);
	return TRUE;
}

void ImpWizDataPatternPage::iw_SetRichEditFont(int iCtrl, int iFont)
{
	RichEdit re = GetItem(iCtrl);
	if( re );
		m_pSheet->iw_SetRichEditFont(re, iFont);
}


BOOL ImpWizDataPatternPage::OnKillActive_BinPattern()          ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	///Danice SAVE_CHANGE	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	//m_pSheet->SetASCIMP(m_ascimp);
	//m_pSheet->SetBINIMP(m_pBinimp);
	m_pSheet->SetHdrParam(m_saHdrParamName, m_vHdrParamType, m_vHdrParamOffset, m_vHdrParamSize);
	///END SAVE_CHANGE
	
	/// Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
	fuSetKeepTargetColFormat(IW_FILTER, m_chkKeepColFormat.Check );
	/// end MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT

	ON_PAGE_CHECK_BIN_PATTERN
	return TRUE;
}

BOOL ImpWizDataPatternPage::OnClickDataView_BinPattern(Control ctrl)    ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	//Control pgSource = ImportWizDlg.GetItem(IDD_BIW_DATAPATERN);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//int n = pgSource.GetCheckedRadioButton(IDC_BIW_DATAPATERN_HEX, IDC_BIW_DATAPATERN_ASCII);
	int n = GetCheckedRadioButton(IDC_BIW_DATAPATERN_HEX, IDC_BIW_DATAPATERN_ASCII);
	
	if( IDC_BIW_DATAPATERN_HEX == n )
		SET_BINPATTERN_BINVIEW;
	else
		SET_BINPATTERN_ASCVIEW;
	BinPattern_UpdateDataView();
	BinPattern_UpdateDataViewColoring();
	return TRUE;
}

/// Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
BOOL ImpWizDataPatternPage::OnClickKeepColFormat(Control ctrl)
{
	Button chk = ctrl;
	
	fuSetKeepTargetColFormat(IW_FILTER, chk.Check );
	
	return TRUE;
}
/// end MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT

BOOL ImpWizDataPatternPage::OnBeforeEditGrid_BinPattern(Control ctrl, int nRow, int nCol, BOOL *pCancel)  ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	///Danice 2/12/04 v8.0819 CHANGE_GRID_TO_CLASS
	//Object objGrid = ctrl.GetActiveXControl();
	if( GRIDCOL_BINPARAM_COLUMN == nCol )
	{
		*pCancel = TRUE;
		return TRUE;
	}
	/*
	if( nRow == objGrid.Rows - 1 && GRIDCOL_BINPARAM_COUNT == nCol )
	{
		string str = objGrid.Cell(flexcpText, nRow, GRIDCOL_BINPARAM_COLUMN);
		if( !str.IsEmpty() && atoi(str) > 0 )
			objGrid.Rows += 1;
	}
	*/
	m_dataElements.OnGridBeforeEdit(nRow, nCol);
	///END CHANGE_GRID_TO_CLASS
	return TRUE;
}

///---Sim 11-01-2008 v8.0964c QA80-12260 FIX_TYPE_FIRST_LETTER_IN_TYPE_COMBO_LIST_NOT_UPDATE_DIALOG
//BOOL ImpWizDataPatternPage::OnChangeEditGrid_BinPattern(Control ctrl, int nRow, int nCol)  ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME	/// TD 09-25-2008 QA80-12260 FLEXGRID_EVENT_HANDLER_CRASH  (Changed prototype)
BOOL ImpWizDataPatternPage::OnAfterEditGrid_BinPattern(Control ctrl, int nRow, int nCol)  ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME	/// TD 09-25-2008 QA80-12260 FLEXGRID_EVENT_HANDLER_CRASH  (Changed prototype)
///---END v8.0964c QA80-12260 FIX_TYPE_FIRST_LETTER_IN_TYPE_COMBO_LIST_NOT_UPDATE_DIALOG
{
	///Danice CHANGE_GRID_TO_CLASS
	//Object objGrid = ctrl.GetActiveXControl();
	int iRow, iCol;
	m_dataElements.GetRowAndCol(iRow, iCol);
	//if( GRIDCOL_BINPARAM_COUNT == objGrid.Col )
	if( GRIDCOL_BINPARAM_COUNT == iCol )
		//BinPattern_UpdateDataColumnOffsetsInGrid(objGrid.Row);
		BinPattern_UpdateDataColumnOffsetsInGrid(iRow);
	//if( GRIDCOL_BINPARAM_COUNT == objGrid.Col || GRIDCOL_BINPARAM_SIZE == objGrid.Col )
	if( GRIDCOL_BINPARAM_COUNT == iCol || GRIDCOL_BINPARAM_SIZE == iCol )
	{
		//BinPattern_UpdateParamVectorsFromGrid(objGrid.Row, objGrid.Col);
		BinPattern_UpdateParamVectorsFromGrid(iRow, iCol);
		UpdatePreview(IDD_BIW_DATAPATERN);
		BinPattern_UpdateDataViewColoring();
	}
	///END CHANGE_GRID_TO_CLASS
	return TRUE;
}

///---Sim 11-01-2008 v8.0964c QA80-12260 FIX_TYPE_FIRST_LETTER_IN_TYPE_COMBO_LIST_NOT_UPDATE_DIALOG
BOOL ImpWizDataPatternPage::OnChangeEditGrid_BinPattern(Control ctrl)
{
	int iRow, iCol;
	m_dataElements.GetRowAndCol(iRow, iCol);
	if( GRIDCOL_BINPARAM_TYPE == iCol )
		OnGridComboCloseUp_BinPattern(ctrl, iRow, iCol, NULL); // force update setting once parameter type change
	return TRUE;
}
///---END v8.0964c QA80-12260 FIX_TYPE_FIRST_LETTER_IN_TYPE_COMBO_LIST_NOT_UPDATE_DIALOG

void ImpWizDataPatternPage::OnGridComboCloseUp_BinPattern(Control ctrl, int nRow, int nCol, BOOL* pFinishEdit)  ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	///Danice CHANGE_GRID_TO_CLASS
	/*
	Object objGrid = ctrl.GetActiveXControl();
	int iSel = objGrid.ComboIndex;
	objGrid.Col = GRIDCOL_BINPARAM_SIZE;
	if( PARAM_TYPE_INT == iSel || PARAM_TYPE_UINT == iSel )
		objGrid.Text = "4"; // default size of int/uint
	else if( PARAM_TYPE_REAL == iSel )
		objGrid.Text = "8"; // default size of Real
	if( PARAM_TYPE_STR != iSel ) // if param type is not string
		objGrid.Col = GRIDCOL_BINPARAM_COUNT; // set focus to the Count column
	*/
	m_dataElements.OnGridComboCloseUp();
	int iRow, iCol;
	m_dataElements.GetRowAndCol(iRow, iCol);
	//BinPattern_UpdateParamVectorsFromGrid(objGrid.Row, GRIDCOL_BINPARAM_TYPE);
	BinPattern_UpdateParamVectorsFromGrid(iRow, GRIDCOL_BINPARAM_TYPE);
	UpdatePreview(IDD_BIW_DATAPATERN);
	BinPattern_UpdateDataViewColoring();
	//objGrid.FinishEditing(FALSE);
	m_dataElements.SetFinishEditing(FALSE);
	///END CHANGE_GRID_TO_CLASS
}

void ImpWizDataPatternPage::BinPattern_UpdateDataViewColoring()
{
	///Danice CHANGE_GRID_TO_CLASS
	/*
	//Control octrl = ImportWizDlg.GetItem(IDC_BIW_DATAPATERN_PATERN_GRID, IDD_BIW_DATAPATERN);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//Object grdPattern = octrl.GetActiveXControl();
	Object grdPattern = m_ctrlGrid.GetActiveXControl();
	
	//RichEdit rePreview = ImportWizDlg.GetItem(IDC_BIW_DATAPATERN_HEXDUMP_RICHEDIT, IDD_BIW_DATAPATERN);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	string strLength, strCount;
	int iLines;
	int iTotal;
	for(int iRows = 1; iRows < grdPattern.Rows; iRows++)
	{
		strLength = grdPattern.Cell(0, iRows, 2);
		strCount = grdPattern.Cell(0, iRows, 3);
		/// EJP 11-11-2003 v7.5751 QA70-5211.7 FIX_USED_BYTES_COLORING
		///if(iRows == grdPattern.Row && atoi(strCount) == 0)
		///	strCount = grdPattern.EditText;
		if( iRows == grdPattern.Row )
		{
			string str;
			str = grdPattern.EditText;
			if( !str.IsEmpty() )
			{
				if( 2 == grdPattern.Col )
					strLength = grdPattern.EditText;
				else
					strCount = grdPattern.EditText;
			}
		}
		/// end FIX_USED_BYTES_COLORING
		if(atoi(strLength) * atoi(strCount) == 0)
			break;
		iTotal = iTotal + (atoi(strLength) * atoi(strCount));
	}
	*/
	int iLines;
	int iTotal;
	m_dataElements.UpdateDataViewColoring(iTotal);
	///END CHANGE_GRID_TO_CLASS

	int nHeaderByChar = 0; ///---Sim 09-21-2006 FIX_SHOW_HEAD_LINE
	
	///Jacky 12/21/03 v7.5784 NOT_NEED_PAGE_TO_CALL	
	//if(ImportWizDlg.Page.DataPatern.Hex == 1)
	Button btnHex = GetItem(IDC_BIW_DATAPATERN_HEX);
 	if(btnHex.Check)
 	///End NOT_NEED_PAGE_TO_CALL
 	{		
		iTotal *= 3;
		nHeaderByChar = m_pBinimp->iHeaderBytes * 3; ///---Sim 09-21-2006 FIX_SHOW_HEAD_LINE
	}
	else
	{
		iLines = iTotal/20;
		iTotal += (iLines * 2);
		nHeaderByChar = m_pBinimp->iHeaderBytes + 2*(m_pBinimp->iHeaderBytes/BIN_DATA_PREVIEW_BYTES_PER_ROW); ///---Sim 09-21-2006 FIX_SHOW_HEAD_LINE
	}
	int nTotal = 0;
	
	//int nLineCount = rePreview.GetLineCount();
	int nLineCount = m_reDataView.GetLineCount();
	
	for (int ii = 0; ii < nLineCount; ii++)
	{
		//nTotal += rePreview.LineLength(ii) + 2;
		nTotal += m_reDataView.LineLength(ii) + 2;
	}
	//rePreview.SetTextColor(0, nTotal, RGB(0, 0, 0));
	m_reDataView.SetTextColor(0, nTotal, RGB(0, 0, 0));
	
	//rePreview.SetTextColor(0, iTotal, RGB(0, 0, 255));
	///---Sim 09-21-2006 FIX_SHOW_HEAD_LINE
	//m_reDataView.SetTextColor(0, iTotal, RGB(0, 0, 255));
	m_reDataView.SetTextColor(nHeaderByChar, nHeaderByChar + iTotal, RGB(0, 0, 255));
	m_reDataView.SetTextColor(0, nHeaderByChar, AIW_COLOR_BIN_HEADER_LINES);
	///---END FIX_SHOW_HEAD_LINE
	
	//rePreview.SetSel(0, 0); // put cursor at beginning of first line
	m_reDataView.SetSel(0, 0); // put cursor at beginning of first line
}

BOOL ImpWizDataPatternPage::OnClickInsertRow_BinPattern(Control ctrl) ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	///Danice CHANGE_GRID_TO_CLASS
	/*
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_BIW_DATAPATERN_PATERN_GRID, IDD_BIW_DATAPATERN);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//Object objGrid = ctrlGrid.GetActiveXControl();
	Object objGrid = m_ctrlGrid.GetActiveXControl();
	
	/// EJP 09-04-2003 v7.5684 QA70-5106 INSERT_BIN_PATTERN_BEFORE_FIRST_ROW
	///if( objGrid.Row <= 1 )
	if( objGrid.Row < 1 )
	/// end INSERT_BIN_PATTERN_BEFORE_FIRST_ROW
		objGrid.Rows += 1;
	else
		objGrid.AddItem("", objGrid.Row);
	*/
	m_dataElements.InsertRow();
	///END CHANGE_GRID_TO_CLASS
	BinPattern_UpdateDataColumnOffsetsInGrid(-1);
	BinPattern_UpdateParamVectorsFromGrid(-1,-1);
	UpdatePreview(IDD_BIW_DATAPATERN);
	BinPattern_UpdateDataViewColoring();
	return TRUE;
}

BOOL ImpWizDataPatternPage::OnClickDeleteRow_BinPattern(Control oCntrl) ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	///Danice CHANGE_GRID_TO_CLASS
	/*
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_BIW_DATAPATERN_PATERN_GRID, IDD_BIW_DATAPATERN);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//Object objGrid = ctrlGrid.GetActiveXControl();
	Object objGrid = m_ctrlGrid.GetActiveXControl();
	
	if( objGrid.Row < 1 )
		return TRUE;
	objGrid.RemoveItem(objGrid.Row);
	*/
	if(!m_dataElements.DeleteRow())
		return TRUE;
	///END CHANGE_GRID_TO_CLASS
	BinPattern_UpdateDataColumnOffsetsInGrid(-1);
	BinPattern_UpdateParamVectorsFromGrid(-1,-1);
	UpdatePreview(IDD_BIW_DATAPATERN);
	BinPattern_UpdateDataViewColoring();
	return TRUE;
}

BOOL ImpWizDataPatternPage::BinPattern_UpdateDataView()  
{
	int nRead;
	int nCurRows = BIN_HDR_PREVIEW_NUM_ROWS;//CPY 1/1/03
	string strDumpTotal;

	file ff;
	if( FALSE == ff.Open(s_strDataFile, file::modeRead | file::shareDenyRead | file::typeBinary) )
		return FALSE;

	///---Sim 09-21-2006 FIX_SHOW_HEAD_LINE
	//ff.Seek(m_pBinimp->iHeaderBytes, file::begin);
	///---END FIX_SHOW_HEAD_LINE

	if( IS_BINPATTERN_BINVIEW )
	{
		BYTE by[BIN_DATA_PREVIEW_NUM_BYTES];
		nRead = ff.Read(by, BIN_DATA_PREVIEW_NUM_BYTES);
		if( nRead )
			strDumpTotal = GetHexDump(by, nRead);
	}
	else // Show as ASCII
	{
		char szTemp[BIN_DATA_PREVIEW_BYTES_PER_ROW + 1];
		for( int iRow = 0; iRow < nCurRows; iRow++ )
		{
			nRead = ff.Read(szTemp, BIN_DATA_PREVIEW_BYTES_PER_ROW);
			if( 0 == nRead )
				break;
			szTemp[nRead] = 0; // NULL terminate string
	
			for( int iChar = 0; iChar < nRead; iChar++ )
			{
				// Display all non-visible chars as periods.
				if( szTemp[iChar] < 32 || 127 < szTemp[iChar] )
					szTemp[iChar] = '.';			
			}
			strDumpTotal += szTemp;
			strDumpTotal += "\r\n";
		}
	}
	ff.Close();
	
    ///Jacky 12/21/03 v7.5784 NOT_NEED_PAGE_TO_CALL	
	//ImportWizDlg.Page.DataPatern.HexDump$ = strDumpTotal;  
	m_reDataView.Text = strDumpTotal;
	///End NOT_NEED_PAGE_TO_CALL	
	
	return TRUE;
}

BOOL ImpWizDataPatternPage::OnSelChangeHeaderVariable_BinPattern(Control ctrl)  ///Jacky 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	/* Will get to this after ver 8 beta1 is out
	string ltString = "%A=IW!Page.BinHeader.HeaderParams.v$(IW!Page.DataPatern.Parameters.Choice)$;"
					  "%A=%[%A,>'='];"
					  "IW!Page.DataPatern.value.v1$=%A;";
	LT_execute(ltString);
	*/
	return true;
}

void ImpWizDataPatternPage::BinPattern_UpdateDataColumnOffsetsInGrid(int iEditTextRow)
{
	///Danice CHANGE_GRID_TO_CLASS
	/*
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_BIW_DATAPATERN_PATERN_GRID, IDD_BIW_DATAPATERN);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	//Object objGrid = ctrlGrid.GetActiveXControl();
	Object objGrid = m_ctrlGrid.GetActiveXControl();

	if( objGrid.Rows <= 1 )
		return; // nothing to do

	string str;
	int iCount, iDataCol = 1; // first data col is always 1
	for(int iRow = 1; iRow < objGrid.Rows; iRow++ )
	{
		objGrid.Cell(flexcpText, iRow, GRIDCOL_BINPARAM_COLUMN) = iDataCol;
		if( iRow == iEditTextRow )
			str = objGrid.EditText;
		else
			str = objGrid.Cell(flexcpText, iRow, GRIDCOL_BINPARAM_COUNT);
		iCount = atoi(str);
		iDataCol += iCount;
	}
	*/
	m_dataElements.UpdateDataColumnOffsets(iEditTextRow);
	///END CHANGE_GRID_TO_GRID
}

void ImpWizDataPatternPage::BinPattern_UpdateGridFromParamVectors()
{
	///Danice CHANGE_GRID_TO_CLASS
	/*
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_BIW_DATAPATERN_PATERN_GRID, IDD_BIW_DATAPATERN);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//if( !ctrlGrid )
	if( !m_ctrlGrid )
		return;
	
	//Object objGrid = ctrlGrid.GetActiveXControl();
	Object objGrid = m_ctrlGrid.GetActiveXControl();
	
	if( !objGrid )
		return;
	
	objGrid.Rows = 1; // 1 for only the column headings

	if( m_pBinimp->vParamCount.GetSize() > 0 )
	{
		
		objGrid.Rows = m_pBinimp->vParamCount.GetSize() + 1;
		int iColumns = 1;

		string strBinImpDataTypes(BINIMP_DATA_TYPE_TOKENS); 

		for( int iParam = 0; iParam < m_pBinimp->vParamCount.GetSize(); iParam++ )
		{
			objGrid.Row = iParam + 1;

			objGrid.Col = GRIDCOL_BINPARAM_COLUMN;
			objGrid.Text = iColumns;
			
			iColumns += m_pBinimp->vParamCount[iParam];
			
			objGrid.Col = GRIDCOL_BINPARAM_TYPE;
			if( m_pBinimp->vParamType[iParam] == BIP_TYPE_INT )
				objGrid.Text = strBinImpDataTypes.GetToken(PARAM_TYPE_INT, '|');
			else if( m_pBinimp->vParamType[iParam] == BIP_TYPE_UINT )
				objGrid.Text = strBinImpDataTypes.GetToken(PARAM_TYPE_UINT, '|');
			else if( m_pBinimp->vParamType[iParam] == BIP_TYPE_REAL )
				objGrid.Text = strBinImpDataTypes.GetToken(PARAM_TYPE_REAL, '|');
			else if( m_pBinimp->vParamType[iParam] == BIP_TYPE_STRING )
				objGrid.Text = strBinImpDataTypes.GetToken(PARAM_TYPE_STR, '|');
			
			objGrid.Col = GRIDCOL_BINPARAM_SIZE;
			objGrid.Text = m_pBinimp->vParamSize[iParam];
			
			objGrid.Col = GRIDCOL_BINPARAM_COUNT;
			objGrid.Text = m_pBinimp->vParamCount[iParam];
		}
	}
	*/
	m_dataElements.UpdateGridFromParamVectors(m_pBinimp->vParamType, m_pBinimp->vParamCount, m_pBinimp->vParamSize);
	///END CHANGE_GRID_TO_CLASS
}

void ImpWizDataPatternPage::BinPattern_UpdateParamVectorsFromGrid(int iEditTextRow, int iEditTextCol)
{
	///Danice CHANGE_GRID_TO_CLASS
	/*
	m_pBinimp->vParamType.SetSize(0);
	m_pBinimp->vParamCount.SetSize(0);
	m_pBinimp->vParamSize.SetSize(0);

	int iBinImpDataTypes[] = {BIP_TYPE_INT, BIP_TYPE_UINT, BIP_TYPE_REAL, BIP_TYPE_STRING};
	
	string strBinImpDataTypes(BINIMP_DATA_TYPE_TOKENS);
	
	string strType, strCount, strSize;
	int iType, iCount, iSize;

	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_BIW_DATAPATERN_PATERN_GRID, IDD_BIW_DATAPATERN);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//Object objGrid = ctrlGrid.GetActiveXControl();
	Object objGrid = m_ctrlGrid.GetActiveXControl();
	
	for(int iRow = 1; iRow < objGrid.Rows; iRow++ )
	{
		strType = objGrid.Cell(flexcpText, iRow, GRIDCOL_BINPARAM_TYPE);
		if( strType.IsEmpty() )
			break;
		iType = strBinImpDataTypes.FindToken(strType, '|');
		if( iType < 0 || iType > 3 )
			break;
		
		if( iRow == iEditTextRow && GRIDCOL_BINPARAM_COUNT == iEditTextCol )
			strCount = objGrid.EditText;
		else
			strCount = objGrid.Cell(flexcpText, iRow, GRIDCOL_BINPARAM_COUNT);
		iCount = atoi(strCount);
///		if( iCount <= 0 )
///			break;
		
		if( iRow == iEditTextRow && GRIDCOL_BINPARAM_SIZE == iEditTextCol )
			strSize = objGrid.EditText;
		else
			strSize = objGrid.Cell(flexcpText, iRow, GRIDCOL_BINPARAM_SIZE);
		iSize = atoi(strSize);
///		if( iSize <= 0 )
///			break;
		
		m_pBinimp->vParamType.Add(iBinImpDataTypes[iType]);
		m_pBinimp->vParamCount.Add(iCount);
		m_pBinimp->vParamSize.Add(iSize);
	}
	
	m_pBinimp->iNumColumns = 0;
	for( int i = 0; i < m_pBinimp->vParamCount.GetSize(); i++ )
		m_pBinimp->iNumColumns += m_pBinimp->vParamCount[i];
	*/
	m_dataElements.UpdateParamVectorsFromGrid(iEditTextRow, iEditTextCol, m_pBinimp->vParamType, m_pBinimp->vParamCount, m_pBinimp->vParamSize, m_pBinimp->iNumColumns);
	///END CHANGE_GRID_TO_CLASS
	
}

void ImpWizDataPatternPage::BinCols_AddRowToGrid()
{
	///Danice CHANGE_GRID_TO_CLASS
	/*
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_BIW_DATAPATERN_PATERN_GRID, IDD_BIW_DATAPATERN);///Jacky 12/14/03 v7.5781 NOT_NEED_DIALOG_TO_CALL
	
	//if( !ctrlGrid )
	if( !m_ctrlGrid )
		return;
	
	//Object objGrid = ctrlGrid.GetActiveXControl();
	Object objGrid = m_ctrlGrid.GetActiveXControl();
	
	if( !objGrid )
		return;
	objGrid.AddItem("", objGrid.Rows);
	*/
	m_dataElements.AddRowToGrid();
	///END CHANGE_GRID_TO_CLASS
	BinPattern_UpdateDataColumnOffsetsInGrid(-1);
}
