/*------------------------------------------------------------------------------*
 * File Name:	ImageProfileDlg.h 												*
 * Creation: 																	*
 * Purpose: OriginC Head file													*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Kyle 01/21/2011 ORG-2042-S1 IMAGE_PROFILE_WITHOUT_DIALOG					*
 *	Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS		*
 *------------------------------------------------------------------------------*/

#include <..\OriginLab\DialogEx.h>
/// Iris 5/28/2010 ORG-98 CHANGE_IMG_PROFILE_DLG_AS_MULTI_PANE_DLG
//#define BASE_WINDOW			ResizeDialog
#define BASE_WINDOW 	MultiPaneDlg
///End CHANGE_IMG_PROFILE_DLG_AS_MULTI_PANE_DLG
#include <..\OriginLab\DynaDlg.h>

#include "ImageProfile.h"

#define STR_DLG_NAME_E		_LE("Image Profile")

#define STR_VTEXT_LOCATION_OPTIONS	_L("Top|Bottom")
#define STR_HTEXT_LOCATION_OPTIONS	_L("Left|Right")

enum{
	IPROFILE_TAB_MENU_RENAME			= 1,
};


enum
{
	IPROFILE_NUMBER_POINTS_ID = 1,
	IPROFILE_NUMBER_VPOINTS_ID,
	IPROFILE_NUMBER_HPOINTS_ID,

	///Kyle 06/12/2010 ORG-98-S37 SUPPORT_WIDTH_IN_PIXEL_AND_IN_SCALE
	/*
	//IPROFILE_PROFILE_WIDTH_ID,			///Kyle 06/07/2010 ORG-98 REMOVE_PROFILE_WIDTH_AND_ONLY_KEEP_LINE_WIDTH
	IPROFILE_LINE_WIDTH_ID,
	*/
	///Kyle 06/17/2010 ORG-98-S40 NEW_WIDTH_CONTROL_WITHOUT_DROP_DOWN
	//IPROFILE_WIDTH_IN_PIXEL_ID,
	//IPROFILE_WIDTH_UNIT_ID,
	//IPROFILE_CUSTOM_WIDTH_IN_PIXEL_ID,
	//IPROFILE_CUSTOM_WIDTH_IN_SCALE_ID,
	IPROFILE_WIDTH_UNIT_ID,
	IPROFILE_WIDTH_IN_PIXEL_ID,
	IPROFILE_WIDTH_IN_SCALE_ID,
	///End NEW_WIDTH_CONTROL_WITHOUT_DROP_DOWN
	///End SUPPORT_WIDTH_IN_PIXEL_AND_IN_SCALE
	///Kyle 06/09/2010 ORG-98-S30 SHOW_PROFILE_COLOR_AT_TOP, can be line or rect
	//IPROFILE_LINE_COLOR_ID,
	IPROFILE_PROFILE_COLOR_ID,
	///End SHOW_PROFILE_COLOR_AT_TOP

	IPROFILE_CROSS_LINE_X_ID,
	IPROFILE_CROSS_LINE_Y_ID,
	IPROFILE_CROSS_LINE_Z_ID,

	IPROFILE_VERTICAL_LINE_X_ID,
	IPROFILE_HORIZONTAL_LINE_Y_ID,
	
	IPROFILE_ARBITRARY_LINE_X1_ID,
	IPROFILE_ARBITRARY_LINE_Y1_ID,
	IPROFILE_ARBITRARY_LINE_X2_ID,
	IPROFILE_ARBITRARY_LINE_Y2_ID,

	IPROFILE_ADD_POINT_BTN_ID,
	
	/// Iris 6/12/2010 ORG-98-S39 NEW_SUGGESTION_FOR_TEXT_OBJECT
	IPROFILE_VERTICAL_TEXT_LOCATION_ID,
	IPROFILE_HORIZONTAL_TEXT_LOCATION_ID,
	///End NEW_SUGGESTION_FOR_TEXT_OBJECT
};

//#define FTOA_DEFAULT(_dVal)		ftoa(_dVal, "*")			///Kyle 06/18/2010 ORG-98-S38 ONLY_NEED_TO_SHOW_4_SIGNIFICANT_DIGITS_FOR_POS_VALUES

#define STR_EMPTY_PROFILE_HINT			\
_L("Use the first four buttons to select a layout type:\nCrossed Lines (same graph as data)\nVertical Line (same graph as data)\nHorizontal Line (same graph as data)\nProfile lines in separate graphs\n\nUse the other buttons to add additional vertical or\nhorizontal lines, or to delete or duplicate lines.\n\nClicking on line in image graph will activate the\ncorresponding tab.")

//#define STR_LINE_WIDTH_HINT				\
_L("0 means line.")


class ImageProfileDlg : public DynaDlg
{
public:	
#ifdef _DEBUG
	bool	m_bDeleteOnDestroy;
#endif // _DEBUG
	
public:
	ImageProfileDlg() : DynaDlg(IDD_IMAGE_PROFILE_DLG, NULL, "ODlg8")
	{
#ifdef _DEBUG
		m_bDeleteOnDestroy 	= false;
#endif // _DEBUG
	}

	~ImageProfileDlg()
	{
	}

	int Create(HWND hWndParent = NULL)
	{
		InitMsgMap();
		
		DWORD dwDlgOptions = 0;
		int nRet = DynaDlg::Create(hWndParent, dwDlgOptions);
		return nRet;
	}

	///Kyle 01/21/2011 ORG-2042-S1 IMAGE_PROFILE_WITHOUT_DIALOG
	//void StartProfile(DWORD dwLayoutMode, DWORD dwOptions = IPROFILE_PROTECT_SOURCE);
	void StartProfile(DWORD dwLayoutMode, DWORD dwOptions = IPROFILE_PROTECT_SOURCE, LPCSTR lpcszTemplate = NULL);
	///End IMAGE_PROFILE_WITHOUT_DIALOG

protected :
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_RESTORESIZE(OnRestoreSize)
	ON_GETMINMAXINFO(OnMinMaxInfo)
	ON_SIZE(OnDlgResize)
	ON_OK(OnOK)
	ON_CANCEL(OnClose)
	ON_DESTROY(OnDestroy)
	ON_READY(OnReady)

	ON_SYSCOMMAND(OnSystemCommand)//make min button to rollup dialog
	ON_GETMINMAXINFO(OnMinMaxInfo)//customize minimum size

	ON_CONTEXTMENU(OnShowMenu)

	ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)
	ON_USER_MSG(WM_USER_IMAGE_PROFILE_UPDATE, OnImageProfileUpdate)

	ON_CHANGE_LAYER(OnActiveLayerChange)
	ON_CHANGE_PAGE(OnActivePageChange)
	ON_OBJECT_MODIFY(OnOriginModify)
	///Kyle 07/01/2010 ORG-355-P11 FIX_PROFILE_IS_NOT_REMOVED_ON_CLOSE_PAGE_WHEN_THERE_IS_NO_PATH
	ON_LAYER_DESTROY(OnLayerDestroy)
	ON_PAGE_DESTROY(OnPageDestroy)
	///End FIX_PROFILE_IS_NOT_REMOVED_ON_CLOSE_PAGE_WHEN_THERE_IS_NO_PATH

	ON_TAB_SEL_CHANGE(IDC_IMAGE_PROFILE_TAB, OnTabChange)

	ON_BN_CLICKED(IDC_SAME_GRAPH_CLINE, OnSameGraphCLine)
	ON_BN_CLICKED(IDC_SAME_GRAPH_VLINE, OnSameGraphVLine)
	ON_BN_CLICKED(IDC_SAME_GRAPH_HLINE, OnSameGraphHLine)
	ON_BN_CLICKED(IDC_SEPARATE_GRAPH, OnSeparateGraph)

	ON_BN_CLICKED(IDC_IPROFILE_ADD_VLINE, OnAddVLine)
	ON_BN_CLICKED(IDC_IPROFILE_ADD_HLINE, OnAddHLine)
	ON_BN_CLICKED(IDC_IPROFILE_ADD_ALINE, OnAddALine)		///Kyle 01/18/2011 ORG-2042-S1 TURN_ON_ARBITRARY_LINE_PROFILE

	ON_BN_CLICKED(IDC_IPROFILE_ACTIVATE_OUTPUT, OnActivateOutput)
	ON_BN_CLICKED(IDC_IPROFILE_DELETE, OnDeletePath)
	ON_BN_CLICKED(IDC_IPROFILE_DUPLICATE, OnDuplicatePath)

	/// Iris 5/28/2010 ORG-98 CHANGE_IMG_PROFILE_DLG_AS_MULTI_PANE_DLG
	ON_BN_CLICKED(IDC_IMG_PROFILE_UPDOWN, OnMyShowBottomPane)
	///End CHANGE_IMG_PROFILE_DLG_AS_MULTI_PANE_DLG

	//ON_BN_CLICKED(IDC_CHECK_KEEP_GRAPHS, OnKeepGraphsClick)
	ON_BN_CLICKED(IDC_CHECK_DEL_ALL, OnDeleteAllClick)
EVENTS_END

	BOOL OnInitDialog();
	BOOL OnRestoreSize(ODWP dwSizeInfo);
	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//int	GetTotalWidth(bool bMin = false);
	//int	GetTotalHeight(bool bMin = false);
	int	GetMinClientTrackWidth();
	int	GetMinClientTrackHeight();
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	BOOL OnDlgResize(int nType, int cx, int cy);
	BOOL OnOK();
	BOOL OnClose();
	BOOL OnDestroy();
	BOOL OnReady();
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus);

	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny);

	void OnAfterValueChange(int nRow, DWORD lParam);
	BOOL OnImageProfileUpdate(uint wParam, uint lParam = 0);

	BOOL OnActiveLayerChange();
	BOOL OnActivePageChange();
	BOOL OnOriginModify(OriginObject obj, int nKind);
	///Kyle 07/01/2010 ORG-355-P11 FIX_PROFILE_IS_NOT_REMOVED_ON_CLOSE_PAGE_WHEN_THERE_IS_NO_PATH
	BOOL OnLayerDestroy(Layer lay, DWORD dwCntrl);
	BOOL OnPageDestroy(Page pg, DWORD dwCntrl);
	///End FIX_PROFILE_IS_NOT_REMOVED_ON_CLOSE_PAGE_WHEN_THERE_IS_NO_PATH

	BOOL OnTabChange(Control ctrl);

	BOOL	OnSameGraphCLine(Control ctrl);
	BOOL	OnSameGraphVLine(Control ctrl);
	BOOL	OnSameGraphHLine(Control ctrl);
	BOOL	OnSeparateGraph(Control ctrl);

	BOOL	OnAddVLine(Control ctrl);
	BOOL	OnAddHLine(Control ctrl);
	BOOL	OnAddALine(Control ctrl);		///Kyle 01/18/2011 ORG-2042-S1 TURN_ON_ARBITRARY_LINE_PROFILE

	BOOL	OnActivateOutput(Control ctrl);
	BOOL	OnDeletePath(Control ctrl);
	BOOL	OnDuplicatePath(Control ctrl);

	/// Iris 5/28/2010 ORG-98 CHANGE_IMG_PROFILE_DLG_AS_MULTI_PANE_DLG
	BOOL	OnMyShowBottomPane(Control ctrl);
	///End CHANGE_IMG_PROFILE_DLG_AS_MULTI_PANE_DLG

	//BOOL	OnKeepGraphsClick(Control ctrl);
	BOOL	OnDeleteAllClick(Control ctrl);
	
protected:
	BOOL UpdateButtonState();

	BOOL OnAddPath(int nPathType);

	BOOL RenamePath(int nSelPath);

	BOOL DeleteProfilePath(ImageProfileManager* pProfile, int nIndex);
	BOOL DuplicateProfilePath(ImageProfileManager* pProfile, int nIndex);

	///Iris 6/11/2010 ORG-98-S36 SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS
	//void ClearPathOnSwitchLayout(ImageProfileManager* pProfile);
	void ClearPathOnSwitchLayout(ImageProfileManager* pProfile, vector<int>& vnDeletedPathIndeces);
	///End SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS

	void CheckHideCloseDlg();

private:
	///Kyle 01/21/2011 ORG-2042-S1 IMAGE_PROFILE_WITHOUT_DIALOG
	//ImageProfileManager* getCurrentProfile();
	ImageProfileManager* getCurrentProfile(bool bWithDlgOnly = true);
	///End IMAGE_PROFILE_WITHOUT_DIALOG

	///Kyle 06/22/2010 ORG-355 BETTER_HANDLING_OF_DIALOG_SIZE
	/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//int getDlgBorderSize(bool bWidth);
	//int	getDlgMinWidth();
	//int	getDlgMinHeight(bool bBottomPanelShow);
	int	getMinClientHeight(bool bBottomPanelShow);
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	
	int getGapBetweenGroups();
	int getGapInGroup();
	
	int getTopLeftBtns(vector<uint>& vnBtns);
	///End BETTER_HANDLING_OF_DIALOG_SIZE

	void initProfileControls(const ImageProfileManager* pProfile, int nIndex);
	///Kyle 06/17/2010 ORG-98 ADD_DIRTY_BITS_FOR_GUI_UPDATE
	//void loadProfilePathValues(const ImageProfileManager* pProfile, int nIndex);
	void loadProfilePathValues(const ImageProfileManager* pProfile, int nIndex, DWORD dwDirtyBits);
	///End ADD_DIRTY_BITS_FOR_GUI_UPDATE
	void showHideBottomControls(bool bShowTab);
	void initControls();

	///Kyle 06/17/2010 ORG-98 ONE_LAYER_ONE_PROFILE_AND_SHARE_CALCULATOR_TO_SPEED_UP
	//int		getPolylineProfilePoints(GraphPage& gp, vector& vx, vector& vy);
	int		getPolylineProfilePoints(GraphLayer& gl, vector& vx, vector& vy);
	///End ONE_LAYER_ONE_PROFILE_AND_SHARE_CALCULATOR_TO_SPEED_UP

	void 	setDialogResizing();
	
	///Iris 6/11/2010 ORG-98-S36 SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS
	bool	switchLayoutMode(int nNewMode);
	void 	checkAddProfilePath(ImageProfileManager* pProfile, vector<int>& vnPathTypes, int nPathType);
	///End SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS

private:
	TabControl			m_tab;
	
	//Button				m_ckKeepGraph;
	Button				m_ckDelAll;

	BitmapRadioButton	m_btnSameGraphCLine;
	BitmapRadioButton	m_btnSameGraphVLine;
	BitmapRadioButton	m_btnSameGraphHLine;
	BitmapRadioButton	m_btnSeparateGraph;

	BitmapRadioButton	m_btnAddVLine;
	BitmapRadioButton	m_btnAddHLine;
	BitmapRadioButton	m_btnAddALine;		///Kyle 01/18/2011 ORG-2042-S1 TURN_ON_ARBITRARY_LINE_PROFILE

	BitmapRadioButton	m_btnActivateOutput;
	BitmapRadioButton	m_btnDeletePath;
	BitmapRadioButton	m_btnDuplicatePath;
};
