/*------------------------------------------------------------------------------*
 * File Name:	ImageProfileDlg.c 												*
 * Creation: 																	*
 * Purpose: OriginC Head file													*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Kyle 01/21/2011 ORG-2042-S1 IMAGE_PROFILE_WITHOUT_DIALOG						*
 * Kit 02/10/2011 ORG-2207-S1 KEEP_2_DECIMAL_PLACES_FOR_THE_SET_VALUE_DLG		*
 * Kyle 11/03/2011 ORG-1830-P9 DISABLE_ARBITRARY_LINE_IN_SAME_GRAPH_VLINE_OR_HLINE
 *------------------------------------------------------------------------------*/

#include "ImageProfileDlg.h"


static ImageProfileDlg* 		s_pProfileDlg;

// enable arbitrary line profile here
#define __ENABLE_ARBITRARY_LINE_PROFILE__

/*----------------------------------------------------------------------------*/
/* ImageProfileDlg
/*----------------------------------------------------------------------------*/
///Kyle 01/21/2011 ORG-2042-S1 IMAGE_PROFILE_WITHOUT_DIALOG
//void ImageProfileDlg::StartProfile(DWORD dwLayoutMode, DWORD dwOptions)
void ImageProfileDlg::StartProfile(DWORD dwLayoutMode, DWORD dwOptions, LPCSTR lpcszTemplate)
///End IMAGE_PROFILE_WITHOUT_DIALOG
{
	GraphPage gp = Project.Pages();
	///Kyle 01/21/2011 ORG-2042-S1 IMAGE_PROFILE_WITHOUT_DIALOG
	//int nProfileIndex = get_image_profile_holder()->StartProfile(gp, dwLayoutMode, dwOptions);
	int nProfileIndex = get_image_profile_holder()->StartProfile(gp, dwLayoutMode, dwOptions, lpcszTemplate);
	///End IMAGE_PROFILE_WITHOUT_DIALOG
	if(nProfileIndex >= 0)
	{
		// default select same graph crossed line for a new profile
		ImageProfileManager* pProfile = getCurrentProfile(false);
		if( pProfile )
		{
			if(  pProfile->GetNumProfilePaths() == 0 )
			{
				if( pProfile->CanAddProfilePath(VERTICAL_LINE_IMAGE_PROFILE) )
					pProfile->AddProfilePath(VERTICAL_LINE_IMAGE_PROFILE);
				if( pProfile->CanAddProfilePath(HORIZONTAL_LINE_IMAGE_PROFILE) )
					pProfile->AddProfilePath(HORIZONTAL_LINE_IMAGE_PROFILE);
			}
			pProfile->SetKeepGraphsOnClosing(!m_ckDelAll.Check);
			
			///Kyle 02/21/2012 SRVC-79 IMAGE_PROFILE_DESTROY_ON_LAYER_DEACTIVE
			if( pProfile->IsProfileNoDialog() )
				Visible = false;
			if( pProfile->DestroyOnDeactive() )
				pProfile->SetKeepGraphsOnClosing(false);
			///End IMAGE_PROFILE_DESTROY_ON_LAYER_DEACTIVE
		}

		OnImageProfileUpdate(IPUPDATE_ACTIVE_PROFILE_CHANGE);
	}
	else
	{
		//SendMessage(WM_CLOSE);
		CheckHideCloseDlg();
	}
}

BOOL ImageProfileDlg::OnInitDialog()
{
	/// Iris 5/28/2010 ORG-98 CHANGE_IMG_PROFILE_DLG_AS_MULTI_PANE_DLG
	//DynaDlg::OnInitDialog(IDC_IMAGE_PROFILE_TAB, STR_DLG_NAME_E);		
	vector<string> vstrTipsUpDown;
	vstrTipsUpDown.Add(_L("Show Tabs"));
	vstrTipsUpDown.Add(_L("Not Show Tabs"));
	DynaDlg::OnInitDialog(
		IDC_DYNA_CTRL,		// id of dyna control
		IDC_IMG_PROFILE_UPDOWN,		// id of button used to show/hide bottom pane
		IDC_IMAGE_PROFILE_TAB,				// id of bottom control
		vstrTipsUpDown,				// tips for button used to show/hide bottom pane
		STR_DLG_NAME_E, 0, NULL, -260);		
	///End CHANGE_IMG_PROFILE_DLG_AS_MULTI_PANE_DLG	

	InitDynaControl(IDC_DYNA_CTRL, *this);
	
	initControls();

	Text = GetLocalized(STR_DLG_NAME_E);

	setDialogResizing();

	return TRUE;
}

BOOL ImageProfileDlg::OnRestoreSize(ODWP dwSizeInfo)
{
	void * p = (void*)dwSizeInfo;
	DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
	
	lstrcpyn(pSz->szDialogName, STR_DLG_NAME_E, MAXLINE);

	pSz->top = -1;
	pSz->left = -1;
	///Kyle 06/22/2010 ORG-355 BETTER_HANDLING_OF_DIALOG_SIZE
	//pSz->width = 395;
	//pSz->height = 95;
	/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//pSz->width = getDlgMinWidth();
	//pSz->height = getDlgMinHeight(false);
	pSz->width	= GetMinTrackWidth();
	pSz->height	= GetMinTrackHeight();
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	///End BETTER_HANDLING_OF_DIALOG_SIZE
	return TRUE;
}

/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
//int	ImageProfileDlg::GetTotalWidth(bool bMin)
//{
//	///Kyle 06/22/2010 ORG-355 BETTER_HANDLING_OF_DIALOG_SIZE
//	//return 395;				// 
//	if(bMin)
//		return getDlgMinWidth();
//	else
//		return DynaDlg::GetTotalWidth(bMin);
//	///End BETTER_HANDLING_OF_DIALOG_SIZE
//}
/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS

/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
//int	ImageProfileDlg::GetTotalHeight(bool bMin)
int	ImageProfileDlg::GetMinClientTrackHeight()
/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
{
	///Kyle 06/22/2010 ORG-355 BETTER_HANDLING_OF_DIALOG_SIZE
	/*
	if( IsBottomPaneShown() )
		return 250;
	return 95;				// 
	*/
	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//if( bMin )
	//	return getDlgMinHeight(IsBottomPaneShown());
	//else
	//	return DynaDlg::GetTotalHeight(bMin);
	return getMinClientHeight(IsBottomPaneShown());
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	///End BETTER_HANDLING_OF_DIALOG_SIZE
}

///Kyle 06/22/2010 ORG-355 BETTER_HANDLING_OF_DIALOG_SIZE
/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
//int ImageProfileDlg::getDlgBorderSize(bool bWidth)
//{
//	RECT rtDlg;
//	GetWindowRect(&rtDlg);
//	ScreenToClient(&rtDlg);
//	RECT rWindow;
//	GetClientRect(&rWindow);
//
//	return bWidth ? (RECT_WIDTH(rtDlg) - RECT_WIDTH(rWindow)) : (RECT_HEIGHT(rtDlg) - RECT_HEIGHT(rWindow));
//}
//
//int	ImageProfileDlg::getDlgMinWidth()
int	ImageProfileDlg::GetMinClientTrackWidth()
/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
{
	static int nDlgMinWidth = 0;
	if( nDlgMinWidth == 0 )
	{
		vector<uint> vnBtns;
		getTopLeftBtns(vnBtns);

		int nGapBetweenGroups = getGapBetweenGroups();
		int nGapInGroup = getGapInGroup();

		Control btn = GetItem(IDC_SAME_GRAPH_CLINE);
		RECT rrButton;
		GetClientRect(btn, rrButton);
		int nHeight = RECT_HEIGHT(rrButton);

		for(int ii = 0; ii < vnBtns.GetSize(); ii++)
		{
			if( vnBtns[ii] )
			{
				nDlgMinWidth += nHeight;
				if( ii > 0 )
					nDlgMinWidth += (vnBtns[ii-1] ? nGapInGroup : nGapBetweenGroups);
			}
		}
		nDlgMinWidth += 2 * GetControlGap();
		
		/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//nDlgMinWidth += getDlgBorderSize(true);
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	}

	return nDlgMinWidth;
}

/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
//int	ImageProfileDlg::getDlgMinHeight(bool bBottomPanelShow)
int	ImageProfileDlg::getMinClientHeight(bool bBottomPanelShow)
/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
{
	if( bBottomPanelShow )
		return 350;

	static int nDlgMinHeight = 0;
	if( nDlgMinHeight == 0 )
	{
		Control btn = GetItem(IDC_SAME_GRAPH_CLINE);
		RECT rrButton;
		GetClientRect(btn, rrButton);
		int nHeight = RECT_HEIGHT(rrButton);

		nDlgMinHeight += nHeight;
		
		RECT rrCheckBox;
		GetClientRect(m_ckDelAll, rrCheckBox);
		nDlgMinHeight += RECT_HEIGHT(rrCheckBox);
		
		nDlgMinHeight += 3 * GetControlGap();
		
		/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//nDlgMinHeight += getDlgBorderSize(false);
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	}

	return nDlgMinHeight;

}

int ImageProfileDlg::getGapBetweenGroups()
{
	return GetControlGap() * 2;
}

int ImageProfileDlg::getGapInGroup()
{
	return GetControlGap() / 2;
}

int ImageProfileDlg::getTopLeftBtns(vector<uint>& vnBtns)
{
	const vector<uint> vBtns = {	IDC_SAME_GRAPH_CLINE, IDC_SAME_GRAPH_VLINE, IDC_SAME_GRAPH_HLINE, IDC_SEPARATE_GRAPH, 0,
#ifdef __ENABLE_ARBITRARY_LINE_PROFILE__
									IDC_IPROFILE_ADD_VLINE, IDC_IPROFILE_ADD_HLINE, IDC_IPROFILE_ADD_ALINE, 0,
#else // __ENABLE_ARBITRARY_LINE_PROFILE__
									IDC_IPROFILE_ADD_VLINE, IDC_IPROFILE_ADD_HLINE, 0,
#endif // __ENABLE_ARBITRARY_LINE_PROFILE__
									IDC_IPROFILE_ACTIVATE_OUTPUT, IDC_IPROFILE_DUPLICATE, IDC_IPROFILE_DELETE, 0,
									IDC_IMG_PROFILE_UPDOWN};
	vnBtns = vBtns;
	return vnBtns.GetSize();
}
///End BETTER_HANDLING_OF_DIALOG_SIZE

BOOL ImageProfileDlg::OnDlgResize(int nType, int cx, int cy)
{
	/// Iris 5/28/2010 ORG-98 CHANGE_IMG_PROFILE_DLG_AS_MULTI_PANE_DLG
	/*
	MoveControlsHelper	_temp(this);	
	vector<uint> nBtns = {IDCANCEL, 0};
	ArrangeMainItemAndControls(nBtns, IDC_IMAGE_PROFILE_TAB, NULL, false);

	int nGap = GetControlGap();
	Control btnCancel = GetItem(IDCANCEL);
	RECT rrCancel;
	GetClientRect(btnCancel, rrCancel);
	
	int nHeight = RECT_HEIGHT(rrCancel);
	int nX = nGap;
	int nY = rrCancel.top;
	
	vector<uint> vBtns = {	IDC_SAME_GRAPH_CLINE, IDC_SAME_GRAPH_VLINE, IDC_SAME_GRAPH_HLINE, IDC_SEPARATE_GRAPH, 0,
							IDC_IPROFILE_ADD_VLINE, IDC_IPROFILE_ADD_HLINE, 0, IDC_IPROFILE_ACTIVATE_OUTPUT, IDC_IPROFILE_DELETE, IDC_IPROFILE_DUPLICATE};
	
	*/		
	MoveControlsHelper	_temp(this);
	
	/// Iris 5/28/2010 ORG-98 CHANGE_IMG_PROFILE_DLG_AS_MULTI_PANE_DLG
	uint nIDs[] = {IDCANCEL, 0};
	MultiPaneDlg::OnDlgResize(nIDs, cx, cy, false);
	///End CHANGE_IMG_PROFILE_DLG_AS_MULTI_PANE_DLG
	
	int nGap = GetControlGap();
	
	RECT rrCheckBox;	
	GetClientRect(m_ckDelAll, rrCheckBox);
	
	int nHeight = RECT_HEIGHT(rrCheckBox);
	int nWidth = RECT_WIDTH(rrCheckBox);
	
	rrCheckBox.top = nGap;
	rrCheckBox.left = nGap;
	rrCheckBox.bottom = rrCheckBox.top + nHeight;
	rrCheckBox.right = rrCheckBox.left + nWidth;	
	MoveControl(m_ckDelAll, rrCheckBox);
	
	Control btn = GetItem(IDC_SAME_GRAPH_CLINE);
	RECT rrButton;
	GetClientRect(btn, rrButton);

	nHeight = RECT_HEIGHT(rrButton);
	int nX = nGap;
	int nY = rrCheckBox.bottom + nGap;
	
	///Kyle 06/22/2010 ORG-355 BETTER_HANDLING_OF_DIALOG_SIZE
	/*
	vector<uint> vBtns = {	IDC_SAME_GRAPH_CLINE, IDC_SAME_GRAPH_VLINE, IDC_SAME_GRAPH_HLINE, IDC_SEPARATE_GRAPH, 0,
							IDC_IPROFILE_ADD_VLINE, IDC_IPROFILE_ADD_HLINE, 0, IDC_IPROFILE_ACTIVATE_OUTPUT, IDC_IPROFILE_DUPLICATE, IDC_IPROFILE_DELETE,
							0, IDC_IMG_PROFILE_UPDOWN};
	*/
	vector<uint> vBtns;
	getTopLeftBtns(vBtns);

	int nGapBetweenGaps = getGapBetweenGroups();
	int nGapInGroup = getGapInGroup();
	///End BETTER_HANDLING_OF_DIALOG_SIZE
	///End CHANGE_IMG_PROFILE_DLG_AS_MULTI_PANE_DLG
	
	for(int ii = 0; ii < vBtns.GetSize(); ii++)
	{
		if( vBtns[ii] )
		{
			///Kyle 06/22/2010 ORG-355 BETTER_HANDLING_OF_DIALOG_SIZE
			if( ii > 0 )
			{
				if( vBtns[ii - 1] )
					nX += nGapInGroup;
				else
					nX += nGapBetweenGaps;
			}
			///End BETTER_HANDLING_OF_DIALOG_SIZE

			Control ctrl = GetItem(vBtns[ii]);
			if( ctrl )
			{
				RECT rr;
				rr.top = nY;
				rr.left = nX;
				rr.bottom = rr.top + nHeight;
				rr.right = rr.left + nHeight;
	
				MoveControl(ctrl, rr);

				///Kyle 06/22/2010 ORG-355 BETTER_HANDLING_OF_DIALOG_SIZE
				//nX += (nHeight + nGap);
				nX += nHeight;
				///End BETTER_HANDLING_OF_DIALOG_SIZE
			}
		}
		///Kyle 06/22/2010 ORG-355 BETTER_HANDLING_OF_DIALOG_SIZE
		/*
		else
			nX += nHeight / 2;
		*/
		///End BETTER_HANDLING_OF_DIALOG_SIZE
	}
	
	ImageProfileManager* pProfile = getCurrentProfile();
	showHideBottomControls( pProfile && pProfile->GetNumProfilePaths()>0 );

	return TRUE;
}

void ImageProfileDlg::CheckHideCloseDlg()
{
	ASSERT( NULL == getCurrentProfile() );

	if(get_image_profile_holder()->GetNumProfiles() > 0)
	{
		Visible = false;
	}
	else
	{
		SendMessage(WM_CLOSE);
	}
}

BOOL ImageProfileDlg::OnOK()
{
	return FALSE;		// do nothing on enter down
}

BOOL ImageProfileDlg::OnClose()
{
	//DWORD dwVal = m_ckKeepGraph.Check;
	//SaveSetting(STR_KEEP_GRAPH_REG_KEY, dwVal, STR_DLG_NAME_E);

	get_image_profile_holder()->RemoveProfile();			// remove active profile, do nothing if no profile actived
	Visible = false;

#ifdef _DEBUG
	if (m_bDeleteOnDestroy)
	{
		m_bDeleteOnDestroy = false;
		return TRUE;
	}
#endif // _DEBUG

	return get_image_profile_holder()->GetNumProfiles()==0;		// close dlg if no profiles, otherwise hide the dlg
}

BOOL ImageProfileDlg::OnDestroy()
{
	ASSERT( get_image_profile_holder()->GetNumProfiles()==0 );
	get_image_profile_holder()->ResetParentWnd();

	DynaDlg::OnDestroy();
	if(s_pProfileDlg)
	{
		delete this;
		s_pProfileDlg = NULL;
	}
	return TRUE;
}

BOOL ImageProfileDlg::OnReady()
{
	SetInitReady();
	return TRUE;
}

BOOL ImageProfileDlg::OnShowMenu(UINT nResIDCtrl, int nx, int ny)
{
	if(IDC_IMAGE_PROFILE_TAB == nResIDCtrl)	
	{
		ImageProfileManager* pProfile = getCurrentProfile();
		if( !pProfile )
		{
			ASSERT(0);
			return false;
		}

		for(int nSelTab = pProfile->GetNumProfilePaths()-1; nSelTab >= 0; nSelTab--)
		{
			RECT rr;
			m_tab.GetItemRect(nSelTab, &rr);
			ClientToScreen(&rr);
			if(rr.left < nx && nx < rr.right)
				break;
		}
		if( nSelTab < 0 )
			return false;
		if( m_tab.GetCurSel() != nSelTab )
		{
			m_tab.SetCurSel(nSelTab);
			OnTabChange(m_tab);
		}

		IProfileTabMenu myMenu;
		int nCmd = 0;
		myMenu.TrackPopupMenu(0, nx, ny, GetSafeHwnd(), &nCmd);
		if( IPROFILE_TAB_MENU_RENAME == nCmd )
			return RenamePath(nSelTab);
	}
	
	return FALSE;
}

void ImageProfileDlg::OnAfterValueChange(int nRow, DWORD lParam)
{
	ImageProfileManager* pProfile = getCurrentProfile();
	if( !pProfile )
	{
		ASSERT(0);
		return;
	}
	int nIndex = pProfile->GetActivePath();//m_tab.GetCurSel();		// pProfile->GetActivePath() != m_tab.GetCurSel() if from OnTabChange, should update path first and then switch the active path
	ImageProfilerPath* pActivePath = pProfile->GetProfilePath(nIndex);

	TreeNode trChange = m_DynaCntrl.GetTreeNode(nRow);

	int nID = -1;
	if(trChange.IsValid())
		trChange.GetAttribute(STR_DATAID_ATTRIB, nID);
	
	TreeNode trGUI = GetTree();				///Kyle 06/12/2010 ORG-98-S37 SUPPORT_WIDTH_IN_PIXEL_AND_IN_SCALE
	TreeNode trWidth = trGUI.Width;			///Kyle 06/21/2010 ORG-355-S2 MAKE_CELL_AND_SCALE_CONTROLS_SUB_NODE_OF_WIDTH

	bool bUpdateGUI = false;
	switch(nID)
	{
	/*
	case IPROFILE_NUMBER_POINTS_ID:
	case IPROFILE_NUMBER_VPOINTS_ID:
	case IPROFILE_NUMBER_HPOINTS_ID:
		{
			bool bVertical = (IPROFILE_NUMBER_VPOINTS_ID==nID) || (IPROFILE_NUMBER_POINTS_ID==nID && VERTICAL_LINE_IMAGE_PROFILE==pActivePath->GetPathType());
			int nAuto;
			trChange.GetAttribute(STR_ATTRIB_AUTO, nAuto);
			if( nAuto )
			{
				pProfile->SetNumPoints(-1, nIndex, bVertical);
				trChange.nVal = pActivePath->GetNumPoints(bVertical);
				bUpdateGUI = true;
			}
			else
			{
				if( !pProfile->SetNumPoints(trChange.nVal, nIndex, bVertical) )
				{
					trChange.nVal = pActivePath->GetNumPoints(bVertical);
					bUpdateGUI = true;
				}
			}
		}
		break;
	*/
	///Kyle 06/07/2010 ORG-98 REMOVE_PROFILE_WIDTH_AND_ONLY_KEEP_LINE_WIDTH
	/*
	case IPROFILE_PROFILE_WIDTH_ID:
		pProfile->SetProfileWidth(nIndex, trChange.dVal);
		if( pActivePath )
		{
			double dLineWidth = pActivePath->GetLineWidth( VERTICAL_LINE_IMAGE_PROFILE == pActivePath->GetPathType());
			
			TreeNode trGUI = GetTree();
			trGUI.LineWidth.strVal = FTOA_DEFAULT(dLineWidth);
			
			bUpdateGUI = true;
		}
		break;
	*/
	///Kyle 06/12/2010 ORG-98-S37 SUPPORT_WIDTH_IN_PIXEL_AND_IN_SCALE
	/*
	case IPROFILE_LINE_WIDTH_ID:
		if( !pProfile->SetLineWidth(nIndex, trChange.dVal) )
		{
			trChange.dVal = pActivePath->GetLineWidth();
			bUpdateGUI = true;
		}
		break;
	///End REMOVE_PROFILE_WIDTH_AND_ONLY_KEEP_LINE_WIDTH
	*/
	///Kyle 06/17/2010 ORG-98-S40 NEW_WIDTH_CONTROL_WITHOUT_DROP_DOWN
	/*
	case IPROFILE_WIDTH_IN_PIXEL_ID:
		{
			string strCombo;
			trChange.GetAttribute(STR_COMBO_ATTRIB, strCombo);
			vector<string> vsCombo;
			strCombo.GetTokens(vsCombo, '|');

			bool bCustom = (trChange.nVal == vsCombo.GetSize()-1);
			pActivePath->SetProfileWidthCustom(bCustom);

			trGUI.WidthUnit.Show = bCustom;
			trGUI.CustomWidthInPixel.Show = bCustom && IPROFILE_PATH_WIDTH_PIXEL==trGUI.WidthUnit.nVal;
			trGUI.CustomWidthInScale.Show = bCustom && IPROFILE_PATH_WIDTH_SCALE==trGUI.WidthUnit.nVal;

			if( bCustom )
			{
				int nUnit = trGUI.WidthUnit.nVal;
				double dWidth = IPROFILE_PATH_WIDTH_PIXEL==nUnit ? trGUI.CustomWidthInPixel.dVal : trGUI.CustomWidthInScale.dVal;
				if( !pProfile->SetProfileWidth(nIndex, dWidth, nUnit) )
					trChange.dVal = pActivePath->GetProfileWidth(nUnit);
			}
			else
			{
				string str = vsCombo[trChange.nVal];
				str = str.Left(str.Find(' '));
				int nWidth = atoi(str);
				pProfile->SetProfileWidth(nIndex, nWidth, IPROFILE_PATH_WIDTH_PIXEL);
			}
			bUpdateGUI = true;
		}
		break;
	case IPROFILE_WIDTH_UNIT_ID:
		{
			int nUnit = trChange.nVal;
			bool bUnitInPixel = IPROFILE_PATH_WIDTH_PIXEL==nUnit;
			trGUI.CustomWidthInPixel.Show = bUnitInPixel;
			trGUI.CustomWidthInScale.Show = !bUnitInPixel;

			double dWidth = bUnitInPixel ? trGUI.CustomWidthInPixel.dVal : trGUI.CustomWidthInScale.dVal;
			if( !pProfile->SetProfileWidth(nIndex, dWidth, nUnit) )
			{
				trChange.dVal = pActivePath->GetProfileWidth(nUnit);
				bUpdateGUI = true;
			}
		}
		break;

	case IPROFILE_CUSTOM_WIDTH_IN_PIXEL_ID:
		{
			ASSERT( pActivePath->IsProfileWidthCustom() );
			if( !pProfile->SetProfileWidth(nIndex, trChange.dVal, IPROFILE_PATH_WIDTH_PIXEL) )
			{
				_reset_string_value_from_old_value(trChange);
				bUpdateGUI = true;
			}
		}
		break;
		
	case IPROFILE_CUSTOM_WIDTH_IN_SCALE_ID:
		{
			ASSERT( pActivePath->IsProfileWidthCustom() );
			if( !pProfile->SetProfileWidth(nIndex, trChange.dVal, IPROFILE_PATH_WIDTH_SCALE) )
			{
				_reset_string_value_from_old_value(trChange);
				bUpdateGUI = true;
			}
		}
		break;
	*/
	case IPROFILE_WIDTH_UNIT_ID:
		{
			int nUnit = trChange.nVal;
			bool bInPixelUnit = (IPROFILE_PATH_WIDTH_PIXEL==nUnit);
			///Kyle 06/21/2010 ORG-355-S2 MAKE_CELL_AND_SCALE_CONTROLS_SUB_NODE_OF_WIDTH
			//trGUI.WidthInPixel.Enable = bInPixelUnit;
			//trGUI.WidthInScale.Enable = !bInPixelUnit;
			//
			//double dWidth = bInPixelUnit ? trGUI.WidthInPixel.nVal : trGUI.WidthInScale.dVal;
			trWidth.WidthInPixel.Enable = bInPixelUnit;
			trWidth.WidthInScale.Enable = !bInPixelUnit;
			double dWidth = bInPixelUnit ? trWidth.WidthInPixel.nVal : trWidth.WidthInScale.dVal;
			///End MAKE_CELL_AND_SCALE_CONTROLS_SUB_NODE_OF_WIDTH

			if( pProfile->SetProfileWidth(nIndex, dWidth, nUnit) )
			{
				///Kyle 06/21/2010 ORG-355-S2 MAKE_CELL_AND_SCALE_CONTROLS_SUB_NODE_OF_WIDTH
				/*
				if( bInPixelUnit )
					_update_profile_width_to_treenode(trGUI.WidthInScale, pActivePath, IPROFILE_PATH_WIDTH_SCALE);
				else
					_update_profile_width_to_treenode(trGUI.WidthInPixel, pActivePath, IPROFILE_PATH_WIDTH_PIXEL);
				*/
				if( bInPixelUnit )
					_update_profile_width_to_treenode(trWidth.WidthInScale, pActivePath, IPROFILE_PATH_WIDTH_SCALE);
				else
					_update_profile_width_to_treenode(trWidth.WidthInPixel, pActivePath, IPROFILE_PATH_WIDTH_PIXEL);
				///End MAKE_CELL_AND_SCALE_CONTROLS_SUB_NODE_OF_WIDTH
			}
			else
			{
				ASSERT(0);
				_update_profile_width_to_treenode(trChange, pActivePath, nUnit);
			}
			bUpdateGUI = true;
		}
		break;

	case IPROFILE_WIDTH_IN_PIXEL_ID:
		{
			int nWidth = trChange.nVal;
			if( nWidth >= 1 && pProfile->SetProfileWidth(nIndex, trChange.nVal, IPROFILE_PATH_WIDTH_PIXEL) )			// SetProfileWidth() accepts num < 1
				///Kyle 06/21/2010 ORG-355-S2 MAKE_CELL_AND_SCALE_CONTROLS_SUB_NODE_OF_WIDTH
				//_update_profile_width_to_treenode(trGUI.WidthInScale, pActivePath, IPROFILE_PATH_WIDTH_SCALE);
				_update_profile_width_to_treenode(trWidth.WidthInScale, pActivePath, IPROFILE_PATH_WIDTH_SCALE);
				///End MAKE_CELL_AND_SCALE_CONTROLS_SUB_NODE_OF_WIDTH
			else
				_reset_string_value_from_old_value(trChange);
			bUpdateGUI = true;
		}
		break;
		
	case IPROFILE_WIDTH_IN_SCALE_ID:
		{
			if( pProfile->SetProfileWidth(nIndex, trChange.dVal, IPROFILE_PATH_WIDTH_SCALE) )
				///Kyle 06/21/2010 ORG-355-S2 MAKE_CELL_AND_SCALE_CONTROLS_SUB_NODE_OF_WIDTH
				//_update_profile_width_to_treenode(trGUI.WidthInPixel, pActivePath, IPROFILE_PATH_WIDTH_PIXEL);
				_update_profile_width_to_treenode(trWidth.WidthInPixel, pActivePath, IPROFILE_PATH_WIDTH_PIXEL);
				///End MAKE_CELL_AND_SCALE_CONTROLS_SUB_NODE_OF_WIDTH
			else
				_reset_string_value_from_old_value(trChange);
			bUpdateGUI = true;
		}
		break;
	///End NEW_WIDTH_CONTROL_WITHOUT_DROP_DOWN
	///End SUPPORT_WIDTH_IN_PIXEL_AND_IN_SCALE


	///Kyle 06/09/2010 ORG-98-S30 SHOW_PROFILE_COLOR_AT_TOP
	//case IPROFILE_LINE_COLOR_ID:
	case IPROFILE_PROFILE_COLOR_ID:
	///End SHOW_PROFILE_COLOR_AT_TOP
		pActivePath->SetProfileLineColor(trChange.nVal, true);
		break;

	//case IPROFILE_CROSS_LINE_X_ID:
	//case IPROFILE_CROSS_LINE_Y_ID:
	//	{
	//		ImageProfilerCrossLinePath* clPath = (ImageProfilerCrossLinePath*)pActivePath;

	//		bool bVertical = IPROFILE_CROSS_LINE_X_ID==nID;
	//		if( !clPath->SetLinePosition(trChange.dVal, bVertical) )
	//		{
	//			double dValue;
	//			clPath->GetLinePosition(dValue, bVertical);
	//			trChange.strVal = FTOA_DEFAULT(dValue);
	//			bUpdateGUI = true;
	//		}
	//	}
	//	break;
		
	case IPROFILE_VERTICAL_LINE_X_ID:
	case IPROFILE_HORIZONTAL_LINE_Y_ID:
		{
			ImageProfilerHVPath* hvPath = (ImageProfilerHVPath*)pActivePath;
			bool bVertical = IPROFILE_VERTICAL_LINE_X_ID==nID;
			if( !hvPath->SetLinePosition(trChange.dVal, bVertical) )
			{
				///Kyle 06/18/2010 ORG-98-S38 ONLY_NEED_TO_SHOW_4_SIGNIFICANT_DIGITS_FOR_POS_VALUES
				/*
				double dValue;
				hvPath->GetLinePosition(dValue, bVertical);
				trChange.strVal = FTOA_DEFAULT(dValue);
				*/
				_reset_string_value_from_old_value(trChange);
				///End ONLY_NEED_TO_SHOW_4_SIGNIFICANT_DIGITS_FOR_POS_VALUES
				bUpdateGUI = true;
			}
		}
		break;

	case IPROFILE_ARBITRARY_LINE_X1_ID:
	case IPROFILE_ARBITRARY_LINE_Y1_ID:
	case IPROFILE_ARBITRARY_LINE_X2_ID:
	case IPROFILE_ARBITRARY_LINE_Y2_ID:
		{
			ASSERT( ARBITRARY_LINE_IMAGE_PROFILE == pActivePath->GetPathType() );
			vector vx, vy;
			if( pActivePath->GetLinePosition(vx, vy) )
			{
				ASSERT( vx.GetSize()==2 && vy.GetSize()==2 );
				switch(nID)
				{
				case IPROFILE_ARBITRARY_LINE_X1_ID:
					vx[0] = trChange.dVal;
					break;

				case IPROFILE_ARBITRARY_LINE_Y1_ID:
					vy[0] = trChange.dVal;
					break;

				case IPROFILE_ARBITRARY_LINE_X2_ID:
					vx[1] = trChange.dVal;
					break;

				case IPROFILE_ARBITRARY_LINE_Y2_ID:
					vy[1] = trChange.dVal;
					break;
				}
				pActivePath->SetLinePosition(vx, vy);
			}
		}
		break;
	/*
	case IPROFILE_ADD_POINT_BTN_ID:
		{
			ASSERT( POLYLINE_IMAGE_PROFILE == pActivePath->GetPathType() );

			GraphLayer gl = pActivePath->GetSourceLayer();
			set_active_layer(gl);
			
			GraphPage gp = gl.GetPage();
			vector vx, vy;
			if( getPolylineProfilePoints(gp, vx, vy) >= 1 )
			{
				ImageProfilerPolyLinePath* pPolylinePath = (ImageProfilerPolyLinePath*)pActivePath;
				pPolylinePath->AddAnchorPoints(vx, vy);
			}
		}
		break;
	*/
	
	/// Iris 6/12/2010 ORG-98-S39 NEW_SUGGESTION_FOR_TEXT_OBJECT
	case IPROFILE_VERTICAL_TEXT_LOCATION_ID:
	case IPROFILE_HORIZONTAL_TEXT_LOCATION_ID:
		{
			pActivePath->SetTextObjectLocation(trChange.nVal);
			
			ImageProfilerHVPath* hvPath = (ImageProfilerHVPath*)pActivePath;
			hvPath->ChangeTextObjectLocation();
			
			pProfile->SaveToStorage();
		}
		break;
	///End NEW_SUGGESTION_FOR_TEXT_OBJECT
	
	}

	if( bUpdateGUI )
	{
		UpdateDynaControl(true, GETNEVENT_ON_CHANGE_UPDATE_GUI);
	}
}

BOOL ImageProfileDlg::OnImageProfileUpdate(uint wParam, uint lParam)
{
	const ImageProfileManager* pProfile = getCurrentProfile();
	if(pProfile)
	{
		if( !Visible )
			Visible = true;			// show dlg

		switch(wParam)
		{
		case IPUPDATE_ACTIVE_PROFILE_CHANGE:
			{
				m_ckDelAll.Check = !pProfile->IsKeepGraphsOnClosing();
		
				m_tab.DeleteAllItems();
				if( pProfile->GetNumProfilePaths() == 0 )
				{
					m_tab.InsertItem(0, "Hint");
					m_tab.SetCurSel(0);
				}
				else
				{
					for(int ii = pProfile->GetNumProfilePaths()-1; ii >= 0; ii--)
					{
						ImageProfilerPath* pPath = pProfile->GetProfilePath(ii);
						m_tab.InsertItem(0, pPath->GetPathName());
					}
				}
				// go on to update path info
			}
		case IPUPDATE_ACTIVE_PATH_CHANGE:
			{
				int nSelPath = pProfile->GetActivePath();
				if( nSelPath < 0 || nSelPath >= pProfile->GetNumProfilePaths() )
					nSelPath = 0;
				m_tab.SetCurSel(nSelPath);
				pProfile->SetActivePath(nSelPath);

				initProfileControls(pProfile, nSelPath);
				///Kyle 06/17/2010 ORG-98 ADD_DIRTY_BITS_FOR_GUI_UPDATE
				//loadProfilePathValues(pProfile, nSelPath);
				loadProfilePathValues(pProfile, nSelPath, IPUPDATE_PATH_CONTENTS);
				///End ADD_DIRTY_BITS_FOR_GUI_UPDATE
				
				UpdateButtonState();
			}
			break;
	
		case IPUPDATE_LAYOUT_MODE_CHANGE:
			{
				/*
				TreeNode trGUI = GetTree();
				int nSelPath = m_tab.GetCurSel();
				if( nSelPath >= 0 && nSelPath < pProfile->GetNumProfilePaths() && trGUI.Buttons )
				{
					ImageProfilerPath* pPath = pProfile->GetProfilePath(nSelPath);
					bool bCanDuplicate = pProfile->CanAddProfilePath(pPath->GetPathType());
					trGUI.Buttons.SetAttribute(STR_COMBO_ATTRIB, bCanDuplicate ? _L("Active Output|Delete|Duplicate"): _L("Active Output|Delete"));
					UpdateDynaControl(true, GETNEVENT_ON_CHANGE_UPDATE_GUI);
				}
				*/
				UpdateButtonState();
			}
			break;
		///Kyle 06/17/2010 ORG-98 ADD_DIRTY_BITS_FOR_GUI_UPDATE
		/*
		case IPUPDATE_PATH_CONTENT:
			{
				int nIndex = lParam;
				ASSERT( pProfile->GetActivePath() == m_tab.GetCurSel() );
				if( nIndex>=0 && nIndex<pProfile->GetNumProfilePaths() && nIndex==pProfile->GetActivePath() )
				{
					loadProfilePathValues(pProfile, nIndex);
				}
			}
			break;
		*/
		///End ADD_DIRTY_BITS_FOR_GUI_UPDATE
	
		default:
			///Kyle 06/17/2010 ORG-98 ADD_DIRTY_BITS_FOR_GUI_UPDATE
			//ASSERT(0);
			ASSERT(0 == (wParam&(~IPUPDATE_PATH_CONTENTS)));
			///End ADD_DIRTY_BITS_FOR_GUI_UPDATE
		}

		///Kyle 06/17/2010 ORG-98 ADD_DIRTY_BITS_FOR_GUI_UPDATE
		if( IPUPDATE_PATH_CONTENTS & wParam )
		{
			int nIndex = lParam;
			ASSERT( pProfile->GetActivePath() == m_tab.GetCurSel() );
			if( nIndex>=0 && nIndex<pProfile->GetNumProfilePaths() && nIndex==pProfile->GetActivePath() )
			{
				loadProfilePathValues(pProfile, nIndex, IPUPDATE_PATH_CONTENTS & wParam);
			}
		}
		///End ADD_DIRTY_BITS_FOR_GUI_UPDATE

	}
	else
	{
		//SendMessage(WM_CLOSE);	// no profile in the active layer, hide the window
		CheckHideCloseDlg();
	}

	return TRUE;
}

BOOL ImageProfileDlg::OnActiveLayerChange()
{
	if( !get_image_profile_holder()->IsUpdatingHolder() )
	{
		bool bRet = get_image_profile_holder()->OnActiveLayerChange();
		//if( bRet )
		//{
		//	ImageProfileManager* pProfile = getCurrentProfile();
		//	if( pProfile )
		//		m_ckDelAll.Check = !pProfile->IsKeepGraphsOnClosing();
		//}
		if( get_image_profile_holder()->GetNumProfiles()==0 )		// close dlg if no profiles
			PostMessage(WM_CLOSE);

		return bRet; 
	}

	return true;
}

BOOL ImageProfileDlg::OnActivePageChange()
{
	return OnActiveLayerChange();
}

BOOL ImageProfileDlg::OnOriginModify(OriginObject obj, int nKind)
{ 
	if( obj && !get_image_profile_holder()->IsUpdatingHolder() )
	{
		string strRange;
		obj.GetRangeString(strRange);

		DataRange drChange;
		if( okxf_init_range_from_string(&drChange, strRange) && drChange.IsValid() )
			get_image_profile_holder()->OnDataModify(drChange);
	}
	return TRUE;
}

///Kyle 07/01/2010 ORG-355-P11 FIX_PROFILE_IS_NOT_REMOVED_ON_CLOSE_PAGE_WHEN_THERE_IS_NO_PATH
BOOL ImageProfileDlg::OnLayerDestroy(Layer lay, DWORD dwCntrl)
{
	if( lay.IsValid() && !get_image_profile_holder()->IsUpdatingHolder() )
	{
		GraphLayer gl = lay;
		if( gl )
			get_image_profile_holder()->OnLayerDestroy(gl);
	}
	return TRUE;
}

BOOL ImageProfileDlg::OnPageDestroy(Page pg, DWORD dwCntrl)
{
	if( pg.IsValid() && !get_image_profile_holder()->IsUpdatingHolder() )
	{
		GraphPage gp = pg;
		if( gp )
			get_image_profile_holder()->OnPageDestroy(gp);
	}
	return TRUE;
}
///End FIX_PROFILE_IS_NOT_REMOVED_ON_CLOSE_PAGE_WHEN_THERE_IS_NO_PATH

BOOL ImageProfileDlg::OnTabChange(Control cntrl)
{
	m_DynaCntrl.AbjustFocusToSave();			// force updating current path before switch

	ImageProfileManager* pProfile = getCurrentProfile();
	if( pProfile )
	{
		///Kyle 06/11/2010 ORG-98-P13 NO_NEED_TO_BEING_OBJECT_TO_FRONT_ON_SELECT_OBJECT
		//pProfile->SetActivePath(m_tab.GetCurSel());
		pProfile->SetActivePath(m_tab.GetCurSel(), true);
		///End NO_NEED_TO_BEING_OBJECT_TO_FRONT_ON_SELECT_OBJECT
		OnImageProfileUpdate(IPUPDATE_ACTIVE_PATH_CHANGE);
		return TRUE;
	}
	else
		ASSERT(0);

	return TRUE;
}
///Iris 6/11/2010 ORG-98-S36 SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS
bool	ImageProfileDlg::switchLayoutMode(int nNewMode)
{
	ImageProfileManager* pProfile = getCurrentProfile();
	if( pProfile )
	{
		vector<int> vnDeletedPathIndeces, vnPathTypes;
		pProfile->SetLayoutMode(nNewMode, &vnDeletedPathIndeces, &vnPathTypes);	
			
		ImageProfileManager* pProfile = getCurrentProfile();
		if(pProfile)
		{
			checkAddProfilePath(pProfile, vnPathTypes, VERTICAL_LINE_IMAGE_PROFILE);
			checkAddProfilePath(pProfile, vnPathTypes, HORIZONTAL_LINE_IMAGE_PROFILE);
		}
		OnImageProfileUpdate(IPUPDATE_ACTIVE_PROFILE_CHANGE);			

		return true;
	}
	return false;
}

void 	ImageProfileDlg::checkAddProfilePath(ImageProfileManager* pProfile, vector<int>& vnPathTypes, int nPathType)
{
	if( pProfile && pProfile->CanAddProfilePath(nPathType) )
	{
		vector<uint> vn;
		if( vnPathTypes.GetSize() > 0 && vnPathTypes.Find(MATREPL_TEST_EQUAL, nPathType, vn) > 0 )
			return;
		
		pProfile->AddProfilePath(nPathType);	
	}
}
///End SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS

BOOL	ImageProfileDlg::OnSameGraphCLine(Control ctrl)
{
	if( m_btnSameGraphCLine.PressedDown )
		return false;
	HOLDER_BEFORE_UPDATE_NO_CHECK(get_image_profile_holder());

	///Iris 6/11/2010 ORG-98-S36 SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS
	/*
	ImageProfileManager* pProfile = getCurrentProfile();
	if( pProfile )
	{
		ClearPathOnSwitchLayout(pProfile);
		pProfile->SetLayoutMode(IMAGE_PROFILE_LAYOUT_SAME_GRAPH_CLINE);

		pProfile->AddProfilePath(VERTICAL_LINE_IMAGE_PROFILE);
		pProfile->AddProfilePath(HORIZONTAL_LINE_IMAGE_PROFILE);
		OnImageProfileUpdate(IPUPDATE_ACTIVE_PROFILE_CHANGE);
		return TRUE;
	}
	
	ASSERT(0);
	return FALSE;
	*/
	return switchLayoutMode(IMAGE_PROFILE_LAYOUT_SAME_GRAPH_CLINE);
	///End SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS
}

BOOL	ImageProfileDlg::OnSameGraphVLine(Control ctrl)
{
	if( m_btnSameGraphVLine.PressedDown )
		return false;
	HOLDER_BEFORE_UPDATE_NO_CHECK(get_image_profile_holder());

	///Iris 6/11/2010 ORG-98-S36 SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS
	/*
	ImageProfileManager* pProfile = getCurrentProfile();
	if( pProfile )
	{
		ClearPathOnSwitchLayout(pProfile);
		pProfile->SetLayoutMode(IMAGE_PROFILE_LAYOUT_SAME_GRAPH_VLINE);
		pProfile->AddProfilePath(VERTICAL_LINE_IMAGE_PROFILE);
		OnImageProfileUpdate(IPUPDATE_ACTIVE_PROFILE_CHANGE);
		return TRUE;
	}
	
	ASSERT(0);
	return FALSE;
	*/
	return switchLayoutMode(IMAGE_PROFILE_LAYOUT_SAME_GRAPH_VLINE);
	///End SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS
}

BOOL	ImageProfileDlg::OnSameGraphHLine(Control ctrl)
{
	if( m_btnSameGraphHLine.PressedDown )
		return false;
	HOLDER_BEFORE_UPDATE_NO_CHECK(get_image_profile_holder());

	///Iris 6/11/2010 ORG-98-S36 SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS
	/*
	ImageProfileManager* pProfile = getCurrentProfile();
	if( pProfile )
	{
		ClearPathOnSwitchLayout(pProfile);
		pProfile->SetLayoutMode(IMAGE_PROFILE_LAYOUT_SAME_GRAPH_HLINE);
		pProfile->AddProfilePath(HORIZONTAL_LINE_IMAGE_PROFILE);
		OnImageProfileUpdate(IPUPDATE_ACTIVE_PROFILE_CHANGE);
		return TRUE;
	}
	
	ASSERT(0);
	return FALSE;
	*/
	return switchLayoutMode(IMAGE_PROFILE_LAYOUT_SAME_GRAPH_HLINE);	
	///End SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS
}

BOOL	ImageProfileDlg::OnSeparateGraph(Control ctrl)
{
	if( m_btnSeparateGraph.PressedDown )
		return false;
	HOLDER_BEFORE_UPDATE_NO_CHECK(get_image_profile_holder());

	///Iris 6/11/2010 ORG-98-S36 SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS
	/*
	ImageProfileManager* pProfile = getCurrentProfile();
	if( pProfile )
	{
		ClearPathOnSwitchLayout(pProfile);

		pProfile->SetLayoutMode(IMAGE_PROFILE_LAYOUT_SEPARATE_GRAPH);
		pProfile->AddProfilePath(VERTICAL_LINE_IMAGE_PROFILE);
		pProfile->AddProfilePath(HORIZONTAL_LINE_IMAGE_PROFILE);
		
		OnImageProfileUpdate(IPUPDATE_ACTIVE_PROFILE_CHANGE);
		return TRUE;
	}
	
	ASSERT(0);
	return FALSE;
	*/
	return switchLayoutMode(IMAGE_PROFILE_LAYOUT_SEPARATE_GRAPH);
	///End SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS
}

BOOL	ImageProfileDlg::OnActivateOutput(Control ctrl)
{
	HOLDER_BEFORE_UPDATE_NO_CHECK(get_image_profile_holder());

	ImageProfileManager* pProfile = getCurrentProfile();
	if( pProfile )
	{
		ImageProfilerPath* pActivePath = pProfile->GetProfilePath(pProfile->GetActivePath());
		if( pActivePath )
			pActivePath->ActiveOutputPlots();
		return TRUE;
	}

	ASSERT(0);
	return FALSE;
}

BOOL	ImageProfileDlg::OnDeletePath(Control ctrl)
{
	ImageProfileManager* pProfile = getCurrentProfile();
	if( pProfile )
	{
		ASSERT( pProfile->GetActivePath() == m_tab.GetCurSel() );
		int nIndex = pProfile->GetActivePath();
		return DeleteProfilePath(pProfile, nIndex);
	}

	return false;
}

BOOL	ImageProfileDlg::OnDuplicatePath(Control ctrl)
{
	ImageProfileManager* pProfile = getCurrentProfile();
	if( pProfile )
	{
		ASSERT( pProfile->GetActivePath() == m_tab.GetCurSel() );
		int nIndex = pProfile->GetActivePath();
		return DuplicateProfilePath(pProfile, nIndex);
	}

	return false;
}

BOOL	ImageProfileDlg::OnAddVLine(Control ctrl)
{
	return OnAddPath(VERTICAL_LINE_IMAGE_PROFILE);
}

BOOL	ImageProfileDlg::OnAddHLine(Control ctrl)
{
	return OnAddPath(HORIZONTAL_LINE_IMAGE_PROFILE);
}

///Kyle 01/18/2011 ORG-2042-S1 TURN_ON_ARBITRARY_LINE_PROFILE
BOOL	ImageProfileDlg::OnAddALine(Control ctrl)
{
	return OnAddPath(ARBITRARY_LINE_IMAGE_PROFILE);
}
///End TURN_ON_ARBITRARY_LINE_PROFILE

void 	ImageProfileDlg::setDialogResizing()
{
	int nStyleCurrent = GetWindowLong(Window::GetSafeHwnd(), GWL_STYLE);
	if( IsBottomPaneShown() )
	{
		nStyleCurrent |= WS_THICKFRAME;
	}
	else
	{
		nStyleCurrent &= (~WS_THICKFRAME);
	}
	SetWindowLong(Window::GetSafeHwnd(), GWL_STYLE, nStyleCurrent);	
}

/// Iris 5/28/2010 ORG-98 CHANGE_IMG_PROFILE_DLG_AS_MULTI_PANE_DLG
BOOL	ImageProfileDlg::OnMyShowBottomPane(Control ctrl)
{
	BOOL bRet = OnShowBottomPane(ctrl);
	
	ImageProfileManager* pProfile = getCurrentProfile();
	showHideBottomControls( pProfile && pProfile->GetNumProfilePaths()>0 );

	setDialogResizing();
	
	return bRet;	
}
///End CHANGE_IMG_PROFILE_DLG_AS_MULTI_PANE_DLG

//BOOL	ImageProfileDlg::OnKeepGraphsClick(Control ctrl)
BOOL	ImageProfileDlg::OnDeleteAllClick(Control ctrl)
{
	ImageProfileManager* pProfile = getCurrentProfile();
	pProfile->SetKeepGraphsOnClosing(!m_ckDelAll.Check);
	return true;
}

BOOL	ImageProfileDlg::UpdateButtonState()
{
	ImageProfileManager* pProfile = getCurrentProfile();
	if( pProfile )
	{
		ASSERT( pProfile->GetNumProfilePaths()==0 || pProfile->GetActivePath() == m_tab.GetCurSel() );
		DWORD dwLayoutMode = pProfile->GetLayoutMode();
		ImageProfilerPath* pActivePath = pProfile->GetProfilePath(pProfile->GetActivePath());

		bool	bLayoutSameGraphAllowed = pProfile->IsLayoutSameGraphAllowed();
		m_btnSameGraphCLine.Enable =
		m_btnSameGraphVLine.Enable =
		m_btnSameGraphHLine.Enable = bLayoutSameGraphAllowed;

		if( IMAGE_PROFILE_LAYOUT_SEPARATE_GRAPH == dwLayoutMode )
		{
			m_btnSameGraphCLine.PressedDown = false;
			m_btnSameGraphVLine.PressedDown = false;
			m_btnSameGraphHLine.PressedDown = false;
			m_btnSeparateGraph.PressedDown = true;
		}
		else
		{
			ASSERT( bLayoutSameGraphAllowed );
			m_btnSameGraphCLine.PressedDown = dwLayoutMode == IMAGE_PROFILE_LAYOUT_SAME_GRAPH_CLINE;
			m_btnSameGraphVLine.PressedDown = dwLayoutMode == IMAGE_PROFILE_LAYOUT_SAME_GRAPH_VLINE;
			m_btnSameGraphHLine.PressedDown = dwLayoutMode == IMAGE_PROFILE_LAYOUT_SAME_GRAPH_HLINE;
			m_btnSeparateGraph.PressedDown = false;
		}

		m_btnAddVLine.Enable = IMAGE_PROFILE_LAYOUT_SAME_GRAPH_HLINE != dwLayoutMode;
		m_btnAddHLine.Enable = IMAGE_PROFILE_LAYOUT_SAME_GRAPH_VLINE != dwLayoutMode;
		
		m_btnAddALine.Enable = IMAGE_PROFILE_LAYOUT_SAME_GRAPH_CLINE == dwLayoutMode || IMAGE_PROFILE_LAYOUT_SEPARATE_GRAPH == dwLayoutMode;	///Kyle 11/03/2011 ORG-1830-P9 DISABLE_ARBITRARY_LINE_IN_SAME_GRAPH_VLINE_OR_HLINE

		m_btnActivateOutput.Enable = pActivePath != NULL && IMAGE_PROFILE_LAYOUT_SEPARATE_GRAPH == dwLayoutMode;
		m_btnDeletePath.Enable = pActivePath != NULL;// && pProfile->GetNumProfilePaths() > 1;
		m_btnDuplicatePath.Enable = pActivePath != NULL;// && pActivePath->GetPathType() != CROSSED_LINES_IMAGE_PROFILE;
	}
	else
	{
		ASSERT(0);
	}

	return TRUE;
}

BOOL ImageProfileDlg::OnAddPath(int nPathType)
{
	if( !IS_VALID_PATH_TYPE(nPathType) )
		return FALSE;

	ImageProfileManager* pProfile = getCurrentProfile();
	if( !pProfile )
		return false;

	int nIndex = -1;
	if( nPathType == POLYLINE_IMAGE_PROFILE )
	{
		///Kyle 06/17/2010 ORG-98 ONE_LAYER_ONE_PROFILE_AND_SHARE_CALCULATOR_TO_SPEED_UP
		//GraphPage gpSource = pProfile->GetSourcePage();
		//vector vx, vy;
		//if( getPolylineProfilePoints(gpSource, vx, vy) < 2 )
		//	return false;
		GraphLayer glSource = pProfile->GetSourceLayer();
		vector vx, vy;
		if( getPolylineProfilePoints(glSource, vx, vy) < 2 )
			return false;
		///End ONE_LAYER_ONE_PROFILE_AND_SHARE_CALCULATOR_TO_SPEED_UP
		nIndex = pProfile->AddProfilePath(nPathType, vx, vy);
	}
	else
	{
		nIndex = pProfile->AddProfilePath(nPathType);
	}

	if( nIndex >= 0 )
	{
		if( pProfile->GetNumProfilePaths() == 1 )
		{
			//ASSERT( m_tab.GetItemCount() == 1);
			OnImageProfileUpdate(IPUPDATE_ACTIVE_PROFILE_CHANGE);
		}
		else
		{

			ImageProfilerPath* pPath = pProfile->GetProfilePath(nIndex);
			ASSERT( pPath );
			m_tab.InsertItem(nIndex, pPath->GetPathName());

			pProfile->SetActivePath(nIndex);
			OnImageProfileUpdate(IPUPDATE_ACTIVE_PATH_CHANGE);
		}
	}

	return TRUE;
}

BOOL ImageProfileDlg::RenamePath(int nSelPath)
{
	ImageProfileManager* pProfile = getCurrentProfile();
	if( !pProfile || nSelPath < 0 || nSelPath >= pProfile->GetNumProfilePaths() )
		return false;

	ImageProfilerPath* pPath = pProfile->GetProfilePath(nSelPath);
	if( !pPath )
		return false;
	
	string strOldPathName = pPath->GetPathName(), strNewPathName;
	
	Tree tr;
	TreeNode trNewName = tr.AddNode();
	GETN_USE(trNewName)
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	GETN_STR(name, _L("New Path Name"), strOldPathName)
	if(GetNBox(trNewName, "Rename Path"))
	{
		strNewPathName = trNewName.name.GetNodeText();
		strNewPathName.TrimLeft();
		strNewPathName.TrimRight();
		if( !strNewPathName.IsEmpty() && strOldPathName.CompareNoCase(strNewPathName) && pProfile->SetPathName(nSelPath, strNewPathName) )
			return m_tab.SetItemText(nSelPath, strNewPathName);
	}
	return false;
}

BOOL ImageProfileDlg::DeleteProfilePath(ImageProfileManager* pProfile, int nIndex)
{
	if( !pProfile || nIndex < 0 || nIndex >= pProfile->GetNumProfilePaths() )
		return false;
	
	HOLDER_BEFORE_UPDATE_NO_CHECK(get_image_profile_holder());

	if( pProfile->DeleteProfilePath(nIndex) )
	{
		int nSelPath = m_tab.GetCurSel();
		if( nSelPath > nIndex )
			nSelPath--;
		m_tab.DeleteItem(nIndex);

		if( pProfile->GetNumProfilePaths() == 0 )
		{
			// reconstruct the tab
			OnImageProfileUpdate(IPUPDATE_ACTIVE_PROFILE_CHANGE);
		}
		else
		{
			if( nSelPath >= pProfile->GetNumProfilePaths() )
				nSelPath = pProfile->GetNumProfilePaths() - 1;

			pProfile->SetActivePath(nSelPath);
			OnImageProfileUpdate(IPUPDATE_ACTIVE_PATH_CHANGE);
		}

		return true;
	}

	return false;
}

BOOL ImageProfileDlg::DuplicateProfilePath(ImageProfileManager* pProfile, int nIndex)
{
	if( !pProfile || nIndex < 0 || nIndex >= pProfile->GetNumProfilePaths() )
		return false;
	HOLDER_BEFORE_UPDATE_NO_CHECK(get_image_profile_holder());

	int nClonePath = pProfile->DuplicateProfilePath(nIndex);

	if( nClonePath >= 0 )
	{
		ImageProfilerPath* pClonePath = pProfile->GetProfilePath(nClonePath);
		m_tab.InsertItem(nClonePath, pClonePath->GetPathName());
		pProfile->SetActivePath(nClonePath);
		OnImageProfileUpdate(IPUPDATE_ACTIVE_PATH_CHANGE);
		return true;
	}
	return false;
}

///Iris 6/11/2010 ORG-98-S36 SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS
//void ImageProfileDlg::ClearPathOnSwitchLayout(ImageProfileManager* pProfile)
void ImageProfileDlg::ClearPathOnSwitchLayout(ImageProfileManager* pProfile, vector<int>& vnDeletedPathIndeces)
///End SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS
{
	if(!pProfile)
		return;
	HOLDER_BEFORE_UPDATE_NO_CHECK(get_image_profile_holder());

	///Iris 6/11/2010 ORG-98-S36 SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS
	/*
	//for(int ii = pProfile->GetNumProfilePaths() - 1; ii >= 0; ii--)
	//{
	//	ImageProfilerPath* pPath = pProfile->GetProfilePath(ii);
	//	ASSERT( FALSE == pPath->IsKeepOutput() );
	//	pProfile->DeleteProfilePath(ii);
	//}
	while( pProfile->GetNumProfilePaths() > 0 )
	{
		pProfile->DeleteProfilePath(0);
	}
	/// Iris 6/07/2010 ORG_98-P8 NEED_DEL_TABS_WHEN_SWITCH_LAYOUT_MODE
	m_tab.DeleteAllItems();
	///End NEED_DEL_TABS_WHEN_SWITCH_LAYOUT_MODE
	*/
	int nNumDel = 0;
	for(int index = 0; index < vnDeletedPathIndeces.GetSize(); index++)
	{
		int nOriginalIndex = vnDeletedPathIndeces[index] - nNumDel;
		m_tab.DeleteItem(nOriginalIndex);
		nNumDel++;
	}
	///End SWITCH_MODE_NEED_KEEP_MEANINGFUL_PATHS
}

///Kyle 01/21/2011 ORG-2042-S1 IMAGE_PROFILE_WITHOUT_DIALOG
//ImageProfileManager* ImageProfileDlg::getCurrentProfile()
//{
//	return get_image_profile_holder()->GetActiveProfile();
//}
ImageProfileManager* ImageProfileDlg::getCurrentProfile(bool bWithDlgOnly)	// = true
{
	ImageProfileManager *pProfile = get_image_profile_holder()->GetActiveProfile();
	if( pProfile && bWithDlgOnly )
	{
		if( pProfile->IsProfileNoDialog() )
			pProfile = NULL;
	}
	return pProfile;
}
///End IMAGE_PROFILE_WITHOUT_DIALOG

void ImageProfileDlg::initProfileControls(const ImageProfileManager* pProfile, int nIndex)
{
	if( !pProfile )
	{
		ASSERT(0);
		return;
	}
	ASSERT( pProfile->GetNumProfilePaths()==0 || (nIndex>=0 && nIndex<pProfile->GetNumProfilePaths()) );

	ImageProfilerPath* pPath = pProfile->GetProfilePath(nIndex);
	
	TreeNode trGUI = InitTree();
	GETN_USE(trGUI)

	if( pPath )
	{
		showHideBottomControls(true);	// show tab

		/*
		if( CROSSED_LINES_IMAGE_PROFILE != pPath->GetPathType() )
		{
			GETN_NUM(Points, _L("Number of Points"), 100)					GETN_ID(IPROFILE_NUMBER_POINTS_ID)
			GETN_ADD_AUTO(1);
		}
		else
		{
			GETN_NUM(XPoints, _L("Number of Vertical Points"), 100)			GETN_ID(IPROFILE_NUMBER_VPOINTS_ID)
			GETN_ADD_AUTO(1);
			GETN_NUM(YPoints, _L("Number of Horizontal Points"), 100)		GETN_ID(IPROFILE_NUMBER_HPOINTS_ID)
			GETN_ADD_AUTO(1);
		}
		*/
		
		GETN_COLOR(ProfileColor, _L("Color"), 0)						GETN_ID(IPROFILE_PROFILE_COLOR_ID)	///Kyle 06/09/2010 ORG-98-S30 SHOW_PROFILE_COLOR_AT_TOP

		///Kyle 06/12/2010 ORG-98-S37 SUPPORT_WIDTH_IN_PIXEL_AND_IN_SCALE
		/*
		///Kyle 06/07/2010 ORG-98 REMOVE_PROFILE_WIDTH_AND_ONLY_KEEP_LINE_WIDTH
		//GETN_COMBO(ProfileWidth, _L("Profile Width"), 0, "|1|2|5|8|10")		GETN_ID(IPROFILE_PROFILE_WIDTH_ID)
		//
		//GETN_NUM(LineWidth, _L("Line Width"), 0)							GETN_ID(IPROFILE_LINE_WIDTH_ID)		GETN_READ_ONLY_EX(ENABLE_READ_ONLY)
		GETN_COMBO(LineWidth, _L("Width"), 0, "|1|2|5|8|10")			GETN_ID(IPROFILE_LINE_WIDTH_ID)
		GETN_STR(Hint, STR_LINE_WIDTH_HINT, "")					 		GETN_HINT
		///End REMOVE_PROFILE_WIDTH_AND_ONLY_KEEP_LINE_WIDTH
		*/
		///Kyle 06/17/2010 ORG-98-S40 NEW_WIDTH_CONTROL_WITHOUT_DROP_DOWN
		//GETN_LIST(WidthInPixel, _L("Width"), 0, "|1|2|5|8|10")			GETN_ID(IPROFILE_WIDTH_IN_PIXEL_ID)
		//GETN_RADIO_INDEX(WidthUnit, 0, _L("by Pixel|by Scale"))			GETN_ID(IPROFILE_WIDTH_UNIT_ID)
		//GETN_NUM(CustomWidthInPixel, _L("Custom Width"), 0)				GETN_ID(IPROFILE_CUSTOM_WIDTH_IN_PIXEL_ID)
		//GETN_NUM(CustomWidthInScale, _L("Custom Width"), 0)				GETN_ID(IPROFILE_CUSTOM_WIDTH_IN_SCALE_ID)
		///Kyle 06/21/2010 ORG-355-S2 MAKE_CELL_AND_SCALE_CONTROLS_SUB_NODE_OF_WIDTH
		//GETN_RADIO_INDEX_EX(WidthUnit, _L("Width"), 0, _L("by Cell|by Scale"))		GETN_ID(IPROFILE_WIDTH_UNIT_ID)
		GETN_BEGIN_BRANCH(Width, _L("Width"))		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
			GETN_RADIO_INDEX(WidthUnit, 0, _L("By Pixel|By Scale"))		GETN_ID(IPROFILE_WIDTH_UNIT_ID)
		///End MAKE_CELL_AND_SCALE_CONTROLS_SUB_NODE_OF_WIDTH
			GETN_NUM(WidthInPixel, _L("Pixels"), 0)						GETN_ID(IPROFILE_WIDTH_IN_PIXEL_ID)
			GETN_NUM(WidthInScale, _L("Scale"), 0)						GETN_ID(IPROFILE_WIDTH_IN_SCALE_ID)		GETN_CURRENT_SUBNODE.SetAttribute(STR_ATTRIB_NUMFMT, "*4*");
		GETN_END_BRANCH(Width)							///Kyle 06/21/2010 ORG-355-S2 MAKE_CELL_AND_SCALE_CONTROLS_SUB_NODE_OF_WIDTH
		///End NEW_WIDTH_CONTROL_WITHOUT_DROP_DOWN
		///End SUPPORT_WIDTH_IN_PIXEL_AND_IN_SCALE

		//GETN_COLOR(LineColor, _L("Line Color"), 0)						GETN_ID(IPROFILE_LINE_COLOR_ID)	///Kyle 06/09/2010 ORG-98-S30 SHOW_PROFILE_COLOR_AT_TOP
		
		switch( pPath->GetPathType() )
		{
		//case CROSSED_LINES_IMAGE_PROFILE:
		//	{
		//		GETN_NUM(VLine, _L("X ="), 0)			GETN_ID(IPROFILE_CROSS_LINE_X_ID)
		//		GETN_NUM(HLine, _L("Y ="), 0)			GETN_ID(IPROFILE_CROSS_LINE_Y_ID)
		//		GETN_NUM(ZValue, _L("Z Value"), 0)		GETN_ID(IPROFILE_CROSS_LINE_Z_ID)		GETN_READ_ONLY_EX(ENABLE_READ_ONLY)
		//	}
		//	break;

		case VERTICAL_LINE_IMAGE_PROFILE:
		case HORIZONTAL_LINE_IMAGE_PROFILE:
			{
				if( VERTICAL_LINE_IMAGE_PROFILE == pPath->GetPathType() )
				{
					GETN_NUM(VLine, _L("X"), 0)			GETN_ID(IPROFILE_VERTICAL_LINE_X_ID)
					GETN_CURRENT_SUBNODE.SetAttribute(STR_ATTRIB_NUMFMT, "*4*");		///Kyle 06/18/2010 ORG-98-S38 ONLY_NEED_TO_SHOW_4_SIGNIFICANT_DIGITS_FOR_POS_VALUES
					GETN_LIST(VTextLoc, _L("Text Location"), 0, STR_VTEXT_LOCATION_OPTIONS)	GETN_ID(IPROFILE_VERTICAL_TEXT_LOCATION_ID) /// Iris 6/12/2010 ORG-98-S39 NEW_SUGGESTION_FOR_TEXT_OBJECT
				}
				else
				{
					GETN_NUM(HLine, _L("Y"), 0)			GETN_ID(IPROFILE_HORIZONTAL_LINE_Y_ID)
					GETN_CURRENT_SUBNODE.SetAttribute(STR_ATTRIB_NUMFMT, "*4*");		///Kyle 06/18/2010 ORG-98-S38 ONLY_NEED_TO_SHOW_4_SIGNIFICANT_DIGITS_FOR_POS_VALUES
					GETN_LIST(HTextLoc, _L("Text Location"), 0, STR_HTEXT_LOCATION_OPTIONS)	GETN_ID(IPROFILE_HORIZONTAL_TEXT_LOCATION_ID) /// Iris 6/12/2010 ORG-98-S39 NEW_SUGGESTION_FOR_TEXT_OBJECT
				}
			}
			break;

		///Kyle 01/20/2011 ORG-2042-S1 RECTANGLE_IMAGE_PROFILE_TO_DO_PROFILING_BOTH_VERTICAL_AND_HORIZONTAL
		case RECTANGLE_IMAGE_PROFILE:
			{
				// to do
			}
			break;
		///End RECTANGLE_IMAGE_PROFILE_TO_DO_PROFILING_BOTH_VERTICAL_AND_HORIZONTAL

		case ARBITRARY_LINE_IMAGE_PROFILE:
			{
				GETN_NUM(VLine1, _L("X1"), 0)			GETN_ID(IPROFILE_ARBITRARY_LINE_X1_ID)
				GETN_CURRENT_SUBNODE.SetAttribute(STR_ATTRIB_NUMFMT, "*4*");		///Kyle 06/18/2010 ORG-98-S38 ONLY_NEED_TO_SHOW_4_SIGNIFICANT_DIGITS_FOR_POS_VALUES
				GETN_NUM(HLine1, _L("Y1"), 0)			GETN_ID(IPROFILE_ARBITRARY_LINE_Y1_ID)
				GETN_CURRENT_SUBNODE.SetAttribute(STR_ATTRIB_NUMFMT, "*4*");		///Kyle 06/18/2010 ORG-98-S38 ONLY_NEED_TO_SHOW_4_SIGNIFICANT_DIGITS_FOR_POS_VALUES
				GETN_NUM(VLine2, _L("X2"), 0)			GETN_ID(IPROFILE_ARBITRARY_LINE_X2_ID)
				GETN_CURRENT_SUBNODE.SetAttribute(STR_ATTRIB_NUMFMT, "*4*");		///Kyle 06/18/2010 ORG-98-S38 ONLY_NEED_TO_SHOW_4_SIGNIFICANT_DIGITS_FOR_POS_VALUES
				GETN_NUM(HLine2, _L("Y2"), 0)			GETN_ID(IPROFILE_ARBITRARY_LINE_Y2_ID)
				GETN_CURRENT_SUBNODE.SetAttribute(STR_ATTRIB_NUMFMT, "*4*");		///Kyle 06/18/2010 ORG-98-S38 ONLY_NEED_TO_SHOW_4_SIGNIFICANT_DIGITS_FOR_POS_VALUES
			}
			break;
		/*
		case POLYLINE_IMAGE_PROFILE:
			{
				GETN_BUTTON_GROUP(BtnAddPoint, "", 0, _L("Add anchor point")) GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_CENTER)	GETN_ID(IPROFILE_ADD_POINT_BTN_ID)
			}
			break;
		*/

		default:
			ASSERT(0);
		}
	}
	else
	{
		showHideBottomControls(false);	// hide tab
		GETN_STR(Hint, STR_EMPTY_PROFILE_HINT, "") 		GETN_HINT
	}
	
	UpdateDynaControl(true, GETNEVENT_ON_INIT, true, DYNALAYOUT_NO_SET_FOCUS);
}

///Kyle 06/17/2010 ORG-98 ADD_DIRTY_BITS_FOR_GUI_UPDATE
//void ImageProfileDlg::loadProfilePathValues(const ImageProfileManager* pProfile, int nIndex)
void ImageProfileDlg::loadProfilePathValues(const ImageProfileManager* pProfile, int nIndex, DWORD dwDirtyBits)
///End ADD_DIRTY_BITS_FOR_GUI_UPDATE
{
	if( !pProfile )
	{
		ASSERT(0);
		return;
	}
	ASSERT( pProfile->GetNumProfilePaths()==0 || (nIndex>=0 && nIndex<pProfile->GetNumProfilePaths()) );
	///Kyle 06/17/2010 ORG-98 ADD_DIRTY_BITS_FOR_GUI_UPDATE, not dirty, do nothing
	if( !dwDirtyBits )
		return;
	///End ADD_DIRTY_BITS_FOR_GUI_UPDATE

	TreeNode trGUI = GetTree();
	if( !trGUI )
		return;			// not ready

	ImageProfilerPath* pPath = pProfile->GetProfilePath(nIndex);
	if( pPath )
	{
		/*
		bool bAuto;
		if( CROSSED_LINES_IMAGE_PROFILE != pPath->GetPathType() )
		{
			bool bVertical = VERTICAL_LINE_IMAGE_PROFILE==pPath->GetPathType();
			trGUI.Points.nVal = pPath->GetNumPoints(bVertical, &bAuto);
			trGUI.Points.SetAttribute(STR_ATTRIB_AUTO, bAuto);
		}
		else
		{
			trGUI.XPoints.nVal = pPath->GetNumPoints(true, &bAuto);
			trGUI.XPoints.SetAttribute(STR_ATTRIB_AUTO, bAuto);
			
			trGUI.YPoints.nVal = pPath->GetNumPoints(false, &bAuto);
			trGUI.YPoints.SetAttribute(STR_ATTRIB_AUTO, bAuto);
		}
		*/

		///Kyle 06/12/2010 ORG-98-S37 SUPPORT_WIDTH_IN_PIXEL_AND_IN_SCALE
		/*
		///Kyle 06/07/2010 ORG-98 REMOVE_PROFILE_WIDTH_AND_ONLY_KEEP_LINE_WIDTH
		//trGUI.ProfileWidth.strVal = FTOA_DEFAULT(pPath->GetProfileWidth());
		//
		//double dLineWidth = pPath->GetLineWidth( VERTICAL_LINE_IMAGE_PROFILE == pPath->GetPathType());
		//trGUI.LineWidth.strVal = FTOA_DEFAULT(dLineWidth);
		vector vWidths;
		pPath->GetSuitableWidths(vWidths);
		vector<string> vsWidths;
		vector<string> vsFormat(vWidths.GetSize());
		for(int ii = 0; ii < vsFormat.GetSize(); ii++)
		{
			if( vWidths[ii] > 1.0 )
				vsFormat[ii] = ".2*";
			else
				vsFormat[ii] = "*2*";
		}
		convert_double_vector_to_string_vector(vWidths, vsWidths, vWidths.GetSize(), vsFormat);
		for(ii = vsWidths.GetSize() - 1; ii > 0; ii--)
		{
			if( vsWidths.Find(vsWidths[ii], 0, true, true, ii-1) >= 0 )
				vsWidths.RemoveAt(ii);
		}
		string strCombo;
		strCombo.SetTokens(vsWidths, '|');
		strCombo = "|" + strCombo;
		trGUI.LineWidth.SetAttribute(STR_COMBO_ATTRIB, strCombo);

		string strLineWidth;
		double dLineWidth = pPath->GetLineWidth();
		if( dLineWidth > 1.0 )
			strLineWidth = ftoa(dLineWidth, ".2*");
		else
			strLineWidth = ftoa(dLineWidth, "*2*");
		trGUI.LineWidth.strVal = strLineWidth;
		///End REMOVE_PROFILE_WIDTH_AND_ONLY_KEEP_LINE_WIDTH

		double dProfileWidth;
		string strHint;
		if( pPath->GetProfileWidth(dProfileWidth, &strHint) )
		{
			strHint = STR_LINE_WIDTH_HINT + strHint;
		}
		else
		{
			strHint = STR_LINE_WIDTH_HINT;
		}
		trGUI.Hint.SetAttribute(STR_LABEL_ATTRIB, strHint);
		*/
		if(IPUPDATE_PATH_CONTENT_WIDTH & dwDirtyBits )		///Kyle 06/17/2010 ORG-98 ADD_DIRTY_BITS_FOR_GUI_UPDATE
		{
			///Kyle 06/17/2010 ORG-98-S40 NEW_WIDTH_CONTROL_WITHOUT_DROP_DOWN
			/*
			vector<int> vnWidthInPixel;
			string strWidths;
			_construct_default_profile_width(pPath, vnWidthInPixel, strWidths);
			strWidths = strWidths + "|" + _L("<Custom>");
			trGUI.WidthInPixel.SetAttribute(STR_COMBO_ATTRIB, strWidths);
	
			int nUnit = pPath->GetProfileWidthUnit();
			int nWidthInPixel = nint(pPath->GetProfileWidth(IPROFILE_PATH_WIDTH_PIXEL));
			bool bWidthCustom = pPath->IsProfileWidthCustom();
			int nWidthIndex;
			if( bWidthCustom )
				nWidthIndex = vnWidthInPixel.GetSize();
			else
			{
				vector<uint> vec;
				if( vnWidthInPixel.Find(vec, nWidthInPixel) > 0 )
					nWidthIndex = vec[0];
				else
					nWidthIndex = 0;
			}
	
			trGUI.WidthUnit.Show = bWidthCustom;
			trGUI.CustomWidthInPixel.Show = bWidthCustom && IPROFILE_PATH_WIDTH_PIXEL==nUnit;
			trGUI.CustomWidthInScale.Show = bWidthCustom && IPROFILE_PATH_WIDTH_SCALE==nUnit;
	
			trGUI.WidthInPixel.nVal = nWidthIndex;
			trGUI.WidthUnit.nVal = nUnit;
			trGUI.CustomWidthInPixel.nVal = nWidthInPixel;
	
			double dWidthInScale = pPath->GetProfileWidth(IPROFILE_PATH_WIDTH_SCALE);
			string strLineWidth;
			if( dWidthInScale > 1.0 )
				strLineWidth = ftoa(dWidthInScale, ".2*");
			else
				strLineWidth = ftoa(dWidthInScale, "*2*");
			trGUI.CustomWidthInScale.strVal = strLineWidth;
			*/
			int nUnit = pPath->GetProfileWidthUnit();
			
			///Kyle 06/21/2010 ORG-355-S2 MAKE_CELL_AND_SCALE_CONTROLS_SUB_NODE_OF_WIDTH
			/*
			trGUI.WidthUnit.nVal = nUnit;
			_update_profile_width_to_treenode(trGUI.WidthInPixel, pPath, IPROFILE_PATH_WIDTH_PIXEL);
			_update_profile_width_to_treenode(trGUI.WidthInScale, pPath, IPROFILE_PATH_WIDTH_SCALE);
			
			trGUI.WidthInPixel.Enable = IPROFILE_PATH_WIDTH_PIXEL==nUnit;
			trGUI.WidthInScale.Enable = IPROFILE_PATH_WIDTH_SCALE==nUnit;
			*/
			TreeNode trWidth = trGUI.Width;
			trWidth.WidthUnit.nVal = nUnit;

			///Kyle 11/29/2010 ORG-1516 XYZ_CONTOUR_PROFILING_DISABLE_WIDTH_IN_PIXEL
			///Kyle 01/18/2011 ORG-2042-S1 TURN_ON_ARBITRARY_LINE_PROFILE
			//trWidth.WidthUnit.Enable = pPath->IsPixelUnitSupported();
			trWidth.WidthUnit.Enable = pPath->IsUnitSupported(IPROFILE_PATH_WIDTH_PIXEL);
			///End TURN_ON_ARBITRARY_LINE_PROFILE
			ASSERT( trWidth.WidthUnit.Enable || nUnit == IPROFILE_PATH_WIDTH_SCALE );
			///End XYZ_CONTOUR_PROFILING_DISABLE_WIDTH_IN_PIXEL
			_update_profile_width_to_treenode(trWidth.WidthInPixel, pPath, IPROFILE_PATH_WIDTH_PIXEL);
			_update_profile_width_to_treenode(trWidth.WidthInScale, pPath, IPROFILE_PATH_WIDTH_SCALE);
			
			trWidth.WidthInPixel.Enable = IPROFILE_PATH_WIDTH_PIXEL==nUnit;
			trWidth.WidthInScale.Enable = IPROFILE_PATH_WIDTH_SCALE==nUnit;
			///End MAKE_CELL_AND_SCALE_CONTROLS_SUB_NODE_OF_WIDTH
			///End NEW_WIDTH_CONTROL_WITHOUT_DROP_DOWN
		}
		///End SUPPORT_WIDTH_IN_PIXEL_AND_IN_SCALE

		///Kyle 06/09/2010 ORG-98-S30 SHOW_PROFILE_COLOR_AT_TOP
		//trGUI.LineColor.nVal = pPath->GetProfileLineColor();
		if(IPUPDATE_PATH_CONTENT_COLOR & dwDirtyBits )		///Kyle 06/17/2010 ORG-98 ADD_DIRTY_BITS_FOR_GUI_UPDATE
			trGUI.ProfileColor.nVal = pPath->GetProfileLineColor();
		///End SHOW_PROFILE_COLOR_AT_TOP

		if(IPUPDATE_PATH_CONTENT_POSITION & dwDirtyBits )		///Kyle 06/17/2010 ORG-98 ADD_DIRTY_BITS_FOR_GUI_UPDATE
		{
			switch( pPath->GetPathType() )
			{
			//case CROSSED_LINES_IMAGE_PROFILE:
			//	{
			//		ImageProfilerCrossLinePath* clPath = (ImageProfilerCrossLinePath*)pPath;
	
			//		double dHLine, dVLine, dZValue;
			//		clPath->GetLinePosition(dHLine, false);
			//		clPath->GetLinePosition(dVLine, true);
			//		clPath->GetLineIntersection(dZValue);
	
			//		trGUI.VLine.strVal = FTOA_DEFAULT(dVLine);
			//		trGUI.HLine.strVal = FTOA_DEFAULT(dHLine);
			//		trGUI.ZValue.strVal = FTOA_DEFAULT(dZValue);
			//	}
			//	break;
	
			case VERTICAL_LINE_IMAGE_PROFILE:
			case HORIZONTAL_LINE_IMAGE_PROFILE:
				{
					double dValue;
					bool bVertical = VERTICAL_LINE_IMAGE_PROFILE == pPath->GetPathType();
					ImageProfilerHVPath* hvPath = (ImageProfilerHVPath*)pPath;
	
					hvPath->GetLinePosition(dValue, bVertical);
					int nTextObjectLocation = hvPath->GetTextObjectLocation(); /// Iris 6/12/2010 ORG-98-S39 NEW_SUGGESTION_FOR_TEXT_OBJECT
					if( bVertical )
					{
						///Kyle 06/18/2010 ORG-98-S38 ONLY_NEED_TO_SHOW_4_SIGNIFICANT_DIGITS_FOR_POS_VALUES
						//trGUI.VLine.strVal = FTOA_DEFAULT(dValue);
						trGUI.VLine.dVal = dValue;
						///End ONLY_NEED_TO_SHOW_4_SIGNIFICANT_DIGITS_FOR_POS_VALUES
						trGUI.VTextLoc.nVal = nTextObjectLocation; /// Iris 6/12/2010 ORG-98-S39 NEW_SUGGESTION_FOR_TEXT_OBJECT
					}
					else
					{
						///Kyle 06/18/2010 ORG-98-S38 ONLY_NEED_TO_SHOW_4_SIGNIFICANT_DIGITS_FOR_POS_VALUES
						//trGUI.HLine.strVal = FTOA_DEFAULT(dValue);
						trGUI.HLine.dVal = dValue;
						///End ONLY_NEED_TO_SHOW_4_SIGNIFICANT_DIGITS_FOR_POS_VALUES
						trGUI.HTextLoc.nVal = nTextObjectLocation; /// Iris 6/12/2010 ORG-98-S39 NEW_SUGGESTION_FOR_TEXT_OBJECT
					}
				}
				break;
			
			///Kyle 01/20/2011 ORG-2042-S1 RECTANGLE_IMAGE_PROFILE_TO_DO_PROFILING_BOTH_VERTICAL_AND_HORIZONTAL
			case RECTANGLE_IMAGE_PROFILE:
				{
					// to do
				}
				break;
			///End RECTANGLE_IMAGE_PROFILE_TO_DO_PROFILING_BOTH_VERTICAL_AND_HORIZONTAL
	
			case ARBITRARY_LINE_IMAGE_PROFILE:
				{
					vector vx, vy;
					if( !pPath->GetLinePosition(vx, vy) )
					{
						vx.SetSize(2);
						vy.SetSize(2);
						vx = NANUM;
						vy = NANUM;
					}
					ASSERT( vx.GetSize()==2 && vy.GetSize()==2 );
					///Kyle 06/18/2010 ORG-98-S38 ONLY_NEED_TO_SHOW_4_SIGNIFICANT_DIGITS_FOR_POS_VALUES
					/*
					trGUI.VLine1.strVal = FTOA_DEFAULT(vx[0]);
					trGUI.HLine1.strVal = FTOA_DEFAULT(vy[0]);
					trGUI.VLine2.strVal = FTOA_DEFAULT(vx[1]);
					trGUI.HLine2.strVal = FTOA_DEFAULT(vy[1]);
					*/
					trGUI.VLine1.dVal = vx[0];
					trGUI.HLine1.dVal = vy[0];
					trGUI.VLine2.dVal = vx[1];
					trGUI.HLine2.dVal = vy[1];
					///End ONLY_NEED_TO_SHOW_4_SIGNIFICANT_DIGITS_FOR_POS_VALUES
				}
				break;
	
			case POLYLINE_IMAGE_PROFILE:
				break;
	
			default:
				ASSERT(0);
			}
		}
		
		UpdateDynaControl(true, GETNEVENT_ON_CHANGE_UPDATE_GUI);
	}
}

void ImageProfileDlg::showHideBottomControls(bool bShowTab)
{
	/// Iris 5/28/2010 ORG-98 CHANGE_IMG_PROFILE_DLG_AS_MULTI_PANE_DLG
	//m_tab.Visible = bShowTab; 
	m_tab.Visible = IsBottomPaneShown() && bShowTab;
	m_DynaCntrl.Visible = IsBottomPaneShown();
	///End CHANGE_IMG_PROFILE_DLG_AS_MULTI_PANE_DLG
	
	RECT rr;
	GetClientRect(m_tab, rr);

	if( bShowTab )
		m_tab.AdjustRect(FALSE, &rr);
	MoveControl(m_DynaCntrl, rr);
}

void ImageProfileDlg::initControls()
{
	m_tab = GetItem(IDC_IMAGE_PROFILE_TAB);
	m_tab.InsertItem(0, _L("Hint"));	// to arrange controls correctly in OnDlgResize() when m_tab shown, for save	
	
	m_ckDelAll = GetItem(IDC_CHECK_DEL_ALL);
	m_ckDelAll.Check = false;
	//DWORD dwVal = LoadSetting(STR_KEEP_GRAPH_REG_KEY, 1, STR_DLG_NAME_E);
	//m_ckKeepGraph.Check = dwVal;
	
	m_btnSameGraphCLine = GetItem(IDC_SAME_GRAPH_CLINE);
	m_btnSameGraphVLine = GetItem(IDC_SAME_GRAPH_VLINE);
	m_btnSameGraphHLine = GetItem(IDC_SAME_GRAPH_HLINE);
	m_btnSeparateGraph = GetItem(IDC_SEPARATE_GRAPH);

	m_btnAddVLine = GetItem(IDC_IPROFILE_ADD_VLINE);
	m_btnAddHLine = GetItem(IDC_IPROFILE_ADD_HLINE);
	m_btnAddALine = GetItem(IDC_IPROFILE_ADD_ALINE);		///Kyle 01/18/2011 ORG-2042-S1 TURN_ON_ARBITRARY_LINE_PROFILE

	m_btnActivateOutput = GetItem(IDC_IPROFILE_ACTIVATE_OUTPUT);
	m_btnDeletePath = GetItem(IDC_IPROFILE_DELETE);
	m_btnDuplicatePath = GetItem(IDC_IPROFILE_DUPLICATE);

	vector<string> vsTips(1);

	vsTips[0] = _L("Same Graph: Crossed Lines");
	m_btnSameGraphCLine.Init(1, IDB_IPROFILE_SAME_GRAPH_CLINE, 16, vsTips);
	
	vsTips[0] = _L("Same Graph: Vertical Line");
	m_btnSameGraphVLine.Init(1, IDB_IPROFILE_SAME_GRAPH_VLINE, 16, vsTips);
	
	vsTips[0] = _L("Same Graph: Horizontal Line");
	m_btnSameGraphHLine.Init(1, IDB_IPROFILE_SAME_GRAPH_HLINE, 16, vsTips);
	
	vsTips[0] = _L("Separate Graph");
	m_btnSeparateGraph.Init(1, IDB_IPROFILE_SEPARATE_GRAPH, 16, vsTips);
	
	vsTips[0] = _L("Add Vertical Line");
	m_btnAddVLine.Init(1, IDB_IPROFILE_ADD_VLINE, 16, vsTips);
	
	vsTips[0] = _L("Add Horizontal Line");
	m_btnAddHLine.Init(1, IDB_IPROFILE_ADD_HLINE, 16, vsTips);
	
	///Kyle 01/18/2011 ORG-2042-S1 TURN_ON_ARBITRARY_LINE_PROFILE
	vsTips[0] = _L("Add Arbitrary Line");
	m_btnAddALine.Init(1, IDB_IPROFILE_ADD_ALINE, 16, vsTips);
#ifndef __ENABLE_ARBITRARY_LINE_PROFILE__
	m_btnAddALine.Visible = false;				// for 8.51, not show this
#endif // !__ENABLE_ARBITRARY_LINE_PROFILE__
	///End TURN_ON_ARBITRARY_LINE_PROFILE

	vsTips[0] = _L("Activate Output");
	m_btnActivateOutput.Init(1, IDB_IPROFILE_ACTIVATE_OUTPUT, 16, vsTips);
	
	vsTips[0] = _L("Delete Active Profile");
	m_btnDeletePath.Init(1, IDB_IPROFILE_DELETE, 16, vsTips);
	
	vsTips[0] = _L("Duplicate Active Profile");
	m_btnDuplicatePath.Init(1, IDB_IPROFILE_DUPLICATE, 16, vsTips);
}

#define STR_ADD_PROFILE_POINTS 		_L("Double-click on the graph layer to add points inside the layer for the profile line")
///Kyle 06/17/2010 ORG-98 ONE_LAYER_ONE_PROFILE_AND_SHARE_CALCULATOR_TO_SPEED_UP
//int ImageProfileDlg::getPolylineProfilePoints(GraphPage& gp, vector& vx, vector& vy)
int ImageProfileDlg::getPolylineProfilePoints(GraphLayer& gl, vector& vx, vector& vy)
///End ONE_LAYER_ONE_PROFILE_AND_SHARE_CALCULATOR_TO_SPEED_UP
{
	///Kyle 06/17/2010 ORG-98 ONE_LAYER_ONE_PROFILE_AND_SHARE_CALCULATOR_TO_SPEED_UP
	/*
	if(!gp)
		return FALSE;
	
	GraphLayer gl = gp.Layers();
	*/
	///End ONE_LAYER_ONE_PROFILE_AND_SHARE_CALCULATOR_TO_SPEED_UP
	if(!gl)
		return FALSE;
	set_active_layer(gl);
	
	graph_get_points(vx, vy, STR_ADD_PROFILE_POINTS);
	ASSERT(vx.GetSize()==vy.GetSize());
	return vx.GetSize();
}

/*----------------------------------------------------------------------------*/
/* Context Menu
/*----------------------------------------------------------------------------*/
class IProfileTabMenu : public Menu
{
public:
	IProfileTabMenu()
	{
		Add(_L("Rename"), OnMenuItem, MF_STRING, IPROFILE_TAB_MENU_RENAME);
	}
	void OnMenuItem(UINT nPos)
	{
	}
};

/************************************************************************/
/* static 				                                                */
/************************************************************************/

///Kyle 06/12/2010 ORG-98-S37 SUPPORT_WIDTH_IN_PIXEL_AND_IN_SCALE
static void _reset_string_value_from_old_value(TreeNode& trChange)
{
	string strOldVal;
	if( trChange && trChange.GetAttribute(STR_CHANGED_ATTRIB, strOldVal) )
		trChange.strVal = strOldVal;
}
///End SUPPORT_WIDTH_IN_PIXEL_AND_IN_SCALE

///Kyle 06/17/2010 ORG-98-S40 NEW_WIDTH_CONTROL_WITHOUT_DROP_DOWN
static void _update_profile_width_to_treenode(TreeNode& trn, ImageProfilerPath* pPath, int nUnit)
{
	ASSERT(trn && pPath);
	switch(nUnit)
	{
	case IPROFILE_PATH_WIDTH_PIXEL:
		{
			///Kyle 11/29/2010 ORG-1516 XYZ_CONTOUR_PROFILING_DISABLE_WIDTH_IN_PIXEL
			///Kyle 01/18/2011 ORG-2042-S1 TURN_ON_ARBITRARY_LINE_PROFILE
			//if( !pPath->IsPixelUnitSupported() )
			if( !pPath->IsUnitSupported(IPROFILE_PATH_WIDTH_PIXEL) )
			///End TURN_ON_ARBITRARY_LINE_PROFILE
			{
				trn.nVal = 1;
				return;
			}
			///End XYZ_CONTOUR_PROFILING_DISABLE_WIDTH_IN_PIXEL

			int nWidthInPixel = nint(pPath->GetProfileWidth(IPROFILE_PATH_WIDTH_PIXEL));
			if( nWidthInPixel < 1 )
				nWidthInPixel = 1;
			trn.nVal = nWidthInPixel;
		}
		break;
		
	case IPROFILE_PATH_WIDTH_SCALE:
		{
			double dWidthInScale = pPath->GetProfileWidth(IPROFILE_PATH_WIDTH_SCALE);
			//trn.strVal = dWidthInScale > 1.0 ? ftoa(dWidthInScale, ".2*") : ftoa(dWidthInScale, "*2*");
			trn.dVal = dWidthInScale;		// show full precision in edit mode
		}
		break;
		
	default:
		ASSERT(0);
	}
}
///End NEW_WIDTH_CONTROL_WITHOUT_DROP_DOWN


/*----------------------------------------------------------------------------*/
/* Public interface
/*----------------------------------------------------------------------------*/
///Kyle 01/21/2011 ORG-2042-S1 IMAGE_PROFILE_WITHOUT_DIALOG
//BOOL ImageProfile(int nMsg, int nLayoutMode = IMAGE_PROFILE_LAYOUT_SAME_GRAPH_CLINE, DWORD dwOptions = IPROFILE_PROTECT_SOURCE)
BOOL ImageProfile(int nMsg, int nLayoutMode = IMAGE_PROFILE_LAYOUT_SAME_GRAPH_CLINE, DWORD dwOptions = IPROFILE_PROTECT_SOURCE, LPCSTR lpcszTemplate = NULL)
///End IMAGE_PROFILE_WITHOUT_DIALOG
{  
	if (OMSG_CLOSE == nMsg)
	{
		if (s_pProfileDlg)
		{
			s_pProfileDlg->SendMessage(WM_CLOSE);
		}
		return TRUE;
	}
	
	if ( !s_pProfileDlg )
	{
		s_pProfileDlg = new ImageProfileDlg();
		
		if( !s_pProfileDlg || !s_pProfileDlg->Create(GetWindow()) )
			return error_report("Failed to create the tool window!", true);
		
		get_image_profile_holder()->SetParentWnd(s_pProfileDlg);
	}
	s_pProfileDlg->ShowWindow(SW_NORMAL);				// run time error if dlg hidden, show it first
	///Kyle 01/21/2011 ORG-2042-S1 IMAGE_PROFILE_WITHOUT_DIALOG
	//s_pProfileDlg->StartProfile(nLayoutMode, dwOptions);
	s_pProfileDlg->StartProfile(nLayoutMode, dwOptions, lpcszTemplate);
	///End IMAGE_PROFILE_WITHOUT_DIALOG
	
	return TRUE;
}

#ifdef _DEBUG
void DestroyImageProfileDlg()
{
	if(s_pProfileDlg)
	{
		s_pProfileDlg->m_bDeleteOnDestroy = TRUE;
		ImageProfile(OMSG_CLOSE);
	}
	get_image_profile_holder()->ClearAllProfile();
}
#endif//_DEBUG

/*----------------------------------------------------------------------------*/
/* graph object event
/*----------------------------------------------------------------------------*/
///-----Kit 01/21/2011 SEPARATE_DLG_EVENT_AND_IMAGE_PROFILE_EVENT
// BOOL CheckInitImageProfileDlgAndExecEvent(int nEvent, string strLayerName, string strObjectName)
// {
// 	///Kyle 06/24/2010 ORG-288 WALK_AROUND_ORIGIN_CRASH_ON_COPY_PASTE_FORMAT_FROM_SOURCE_LAYER_TO_OUTPUT_LAYER
// 	/*
// 	if( OE_WIN_CLOSE!=nEvent && OE_SCALE_CHANGE!=nEvent && OE_STYLE_CHANGE!=nEvent && OE_SELECT!=nEvent && OE_GRAPHOBJ_EDIT!=nEvent && OE_MOVE!=nEvent && OE_DELETE!=nEvent && OE_DELETE_PART!=nEvent )
// 		return true;
// 
// 	{
// 	*/
// 	///End WALK_AROUND_ORIGIN_CRASH_ON_COPY_PASTE_FORMAT_FROM_SOURCE_LAYER_TO_OUTPUT_LAYER
// 		GraphLayer gl;
// 		 if( !okxf_resolve_string_get_origin_object(strLayerName, &gl) )
// 		 	return false;
// 		GraphObject go = gl.GraphObjects(strObjectName);
// 		if( !go )
// 			return false;
// 	
// 		if(OE_GRAPHOBJ_EDIT == nEvent || OE_SELECT == nEvent || OE_MOVE == nEvent || OE_MOVING == nEvent)
// 		{
// 			///Kyle 07/21/2010 ORG-584-P2 CHECK_SHOW_DIALOG_AFTER_LOADING_PROFILE
// 			//int nProfileIndex = get_image_profile_holder()->CheckLoadProfile(gl, true);
// 			//if(nProfileIndex >= 0 && !s_pProfileDlg)
// 			//{
// 			//	ImageProfile(OMSG_OPEN);		// new the dialog and save to profile holder
// 			//	ASSERT(s_pProfileDlg);
// 			//}
// 			bool bIsActive;
// 			int nProfileIndex = get_image_profile_holder()->CheckLoadProfile(gl, true, &bIsActive);
// 			if( nProfileIndex >= 0 && (!s_pProfileDlg || !bIsActive) )
// 			{
// 				if( s_pProfileDlg )
// 				{
// 					get_image_profile_holder()->OnActiveLayerChange();
// 				}
// 				else
// 				{
// 					ImageProfile(OMSG_OPEN);		// new the dialog and save to profile holder if dialog doesn't exist, and activate the current profile
// 					ASSERT(s_pProfileDlg);
// 				}
// 			}
// 			///End CHECK_SHOW_DIALOG_AFTER_LOADING_PROFILE
// 		}
// 
// 		if( !get_image_profile_holder()->IsUpdatingHolder() )
// 		{
// 		const UINT uObjUID = go.GetUID(TRUE);
// 		const UINT uPageUID = gl.GetPage().GetUID(TRUE);
// 			get_image_profile_holder()->OnImageProfileEvent(nEvent, uPageUID, uObjUID);
// 		}
// 	//}		///Kyle 06/24/2010 ORG-288 WALK_AROUND_ORIGIN_CRASH_ON_COPY_PASTE_FORMAT_FROM_SOURCE_LAYER_TO_OUTPUT_LAYER
// 
// 	return TRUE;
// }
BOOL OnImageProfileDlg(int nEvent, string strLayerName, string strObjectName)
{
	GraphLayer gl;
	if( !okxf_resolve_string_get_origin_object(strLayerName, &gl) )
		return false;

	return OnImageProfileDlgEx(nEvent, gl, strObjectName);
}
///-----End SEPARATE_DLG_EVENT_AND_IMAGE_PROFILE_EVENT

BOOL OnHVProfileReadOutChange(int nEvent, string strLayerName, string strObjectName)
{
	GraphLayer gl;
	if( !okxf_resolve_string_get_origin_object(strLayerName, &gl) )
		return false;

	return on_hv_profile_text_label_event(nEvent, gl, strObjectName);
}

///Kyle 01/21/2011 ORG-2042-S1 IMAGE_PROFILE_WITHOUT_DIALOG
BOOL OnImageProfileDlgEx(int nEvent, GraphLayer& gl, string strObjectName)
{
	if( !gl )
		return false;
	GraphObject go = gl.GraphObjects(strObjectName);
	if( !go )
		return FALSE;

	if(OE_GRAPHOBJ_EDIT == nEvent || OE_SELECT == nEvent || OE_MOVE == nEvent || OE_MOVING == nEvent)
	{
		bool bIsActive;
		int nProfileIndex = get_image_profile_holder()->CheckLoadProfile(gl, true, &bIsActive);
		if( nProfileIndex >= 0 && (!s_pProfileDlg || !bIsActive) )
		{
			if( s_pProfileDlg )
			{
				get_image_profile_holder()->OnActiveLayerChange();
			}
			else
			{
				ImageProfile(OMSG_OPEN);
				ASSERT(s_pProfileDlg);
			}
		}
	}

	return on_image_profile_event(nEvent, gl, strObjectName);
}

// for 81 used
BOOL OnImageProfileEvent81(int nEvent, string strObjectName)
{
	GraphLayer gl = Project.ActiveLayer();
	if( !gl )
		return false;
	return OnImageProfileDlgEx(nEvent, gl, strObjectName);
}

// for 81 used
BOOL OnHVProfileReadOutChange81(int nEvent, string strObjectName)
{
	GraphLayer gl = Project.ActiveLayer();
	if( !gl )
		return false;
	return on_hv_profile_text_label_event(nEvent, gl, strObjectName);
}

BOOL start_image_profile(DWORD dwLayoutMode, DWORD dwOptions, string strTemplate)
{
	TIME_PROFILER;
	return ImageProfile(OMSG_OPEN, dwLayoutMode, dwOptions, strTemplate);
}

///Kyle 02/21/2012 SRVC-79 IMAGE_PROFILE_DESTROY_ON_LAYER_DEACTIVE
BOOL image_profile_set_owner(void *pOwner, FUNC_IMG_PROFILE_DEACTIVE_CALLBACK pCallBack, int nProfile = -1)
{
	return get_image_profile_holder()->SetOwner(pOwner, pCallBack, nProfile);
}

BOOL image_profile_close_profile(void *pOwner)
{
	return get_image_profile_holder()->CloseProfile(pOwner);
}

BOOL image_profile_get_position(double& dPos, bool bVertical, int nProfile = -1)
{
	return get_image_profile_holder()->GetHVProfilePos(bVertical, dPos, nProfile);
}

BOOL image_profile_set_position(double dPos, bool bVertical, int nProfile = -1)
{
	return get_image_profile_holder()->SetHVProfilePos(bVertical, dPos, nProfile);
}

BOOL image_profile_set_position_unit(int nUnit, bool bVertical, int nProfile = -1)
{
	return get_image_profile_holder()->SetHVProfilePosUnit(bVertical, nUnit, nProfile);
}

BOOL image_profile_set_line_width_in_pixel(double dWidth, bool bVertical, int nProfile = -1)
{
	return get_image_profile_holder()->SetHVProfileWidthInPixel(bVertical, dWidth, nProfile);
}

BOOL image_profile_set_position_label_location(int nLocation, bool bVertical, int nProfile = -1)
{
	return get_image_profile_holder()->SetHVProfilePosLabelLocation(bVertical, nLocation, nProfile);
}
BOOL image_profile_invalidate(int nProfile = -1)
{
	return get_image_profile_holder()->InvalidateProfile(nProfile);
}
///End IMAGE_PROFILE_DESTROY_ON_LAYER_DEACTIVE

BOOL image_profiler_add_path(int nPathType)
{
	TIME_PROFILER;
	bool bRet = false;
	HOLDER_BEFORE_UPDATE_NO_CHECK(get_image_profile_holder());

	ImageProfileManager* pProfile = get_image_profile_holder()->GetActiveProfile();
	bRet = pProfile && (pProfile->AddProfilePath(nPathType) >= 0);

	return bRet;
}

BOOL image_profiler_set_profile_full_range(bool bSet)
{
	bool bRet = false;
	HOLDER_BEFORE_UPDATE_NO_CHECK(get_image_profile_holder());

	ImageProfileManager* pProfile = get_image_profile_holder()->GetActiveProfile();
	int nPath = pProfile->GetActivePath();
	if( nPath < 0 )
		nPath = 0;
	ImageProfilerPath* pPath = pProfile->GetProfilePath(nPath);
	if(pPath)
	{
		pPath->SetProfileFullRange(bSet);
		pProfile->SaveToStorage();
		bRet = true;
	}

	return bRet;
}

BOOL image_profiler_activate_output()
{
	bool bRet = false;
	HOLDER_BEFORE_UPDATE_NO_CHECK(get_image_profile_holder());

	ImageProfileManager* pProfile = get_image_profile_holder()->GetActiveProfile();
	if( pProfile )
	{
		ImageProfilerPath* pActivePath = pProfile->GetProfilePath(pProfile->GetActivePath());
		if( pActivePath )
		{
			pActivePath->ActiveOutputPlots();
			bRet = true;
		}
	}

	return bRet;
}

BOOL image_profile_duplicate_path(int nPath)
{
	bool bRet = false;
	HOLDER_BEFORE_UPDATE_NO_CHECK(get_image_profile_holder());

	ImageProfileManager* pProfile = get_image_profile_holder()->GetActiveProfile();
	if( pProfile )
	{
		if( nPath >= 0 && nPath < pProfile->GetNumProfilePaths() )
			bRet = (pProfile->DuplicateProfilePath(nPath) >= 0);
	}

	return bRet;
}

BOOL	image_profile_get_active_path_moving_cntrl(DWORD& dwCntrl)
{
	bool bRet = false;
	ImageProfileManager* pProfile = get_image_profile_holder()->GetActiveProfile();
	if( pProfile )
	{
		int nPath = pProfile->GetActivePath();
		if( nPath < 0 )
			nPath = 0;

		ImageProfilerPath* pPath = pProfile->GetProfilePath(nPath);
		if(pPath)
		{
			dwCntrl = pPath->GetMovingCntrl();
			bRet = true;
		}
	}

	return bRet;
}

bool	image_profile_set_active_path_moving_cntrl(DWORD dwCntrl)
{
	bool bRet = false;

	HOLDER_BEFORE_UPDATE_NO_CHECK(get_image_profile_holder());
	ImageProfileManager* pProfile = get_image_profile_holder()->GetActiveProfile();
	if( pProfile )
	{
		int nPath = pProfile->GetActivePath();
		if( nPath < 0 )
			nPath = 0;

		ImageProfilerPath* pPath = pProfile->GetProfilePath(nPath);
		bRet = pPath && pPath->SetMovingCntrl(dwCntrl);
	}

	return bRet;
}

static void _get_obj_position(double& dTop, double& dBottom, double& dLeft, double& dRight, const vector& vx, const vector& vy, bool bXReverse, bool bYReverse)
{
	vx.GetMinMax(dLeft, dRight);
	if( bXReverse )
	{
		double dTmp = dLeft;
		dLeft = dRight;
		dRight = dTmp;
	}
	
	vy.GetMinMax(dBottom, dTop);
	if( bYReverse )
	{
		double dTmp = dBottom;
		dBottom = dTop;
		dTop = dTmp;
	}
}

static void _check_load_profile_and_make_active()
{
	GraphLayer gl = Project.ActiveLayer();
	bool bActive = false;
	if( get_image_profile_holder()->CheckLoadProfile(gl, true, &bActive) >= 0 )
	{
		if( !bActive )
		{
			get_image_profile_holder()->OnActiveLayerChange();
		}
	}
}

bool	image_profile_get_obj_pos(double& dTop, double& dBottom, double& dLeft, double& dRight, bool bCheckLoadProfile = false)
{
	bool bRet = false;

	if( bCheckLoadProfile )
		_check_load_profile_and_make_active();

	ImageProfileManager* pProfile = get_image_profile_holder()->GetActiveProfile();
	if( pProfile )
	{
		int nPath = pProfile->GetActivePath();
		if( nPath < 0 )
			nPath = 0;

		ImageProfilerPath* pPath = pProfile->GetProfilePath(nPath);
		if( pPath && pPath->GetPathType() == RECTANGLE_IMAGE_PROFILE )
		{
			vector vx, vy;
			if( pPath->GetLinePosition(vx, vy) )
			{
				GraphLayer glSource = pPath->GetSourceLayer();
				_get_obj_position(dTop, dBottom, dLeft, dRight, vx, vy, glSource.X.From > glSource.X.To, glSource.Y.From > glSource.Y.To);
				bRet = true;
			}
		}
	}

	return bRet;
}

bool	image_profile_set_obj_pos(double dTop, double dBottom, double dLeft, double dRight, bool bCheckLoadProfile = false)
{
	bool bRet = false;

	if( bCheckLoadProfile )
		_check_load_profile_and_make_active();

	ImageProfileManager* pProfile = get_image_profile_holder()->GetActiveProfile();
	if( pProfile )
	{
		int nPath = pProfile->GetActivePath();
		if( nPath < 0 )
			nPath = 0;

		ImageProfilerPath* pPath = pProfile->GetProfilePath(nPath);
		if( pPath && pPath->GetPathType() == RECTANGLE_IMAGE_PROFILE )
		{
			vector vx(2), vy(2);
			vx[0] = dLeft;
			vx[1] = dRight;
			vy[0] = dTop;
			vy[1] = dBottom;
			bRet = pPath->SetLinePosition(vx, vy);
		}
	}

	return bRet;
}

static bool _image_profile_input_values_event(TreeNode& tr, int nRow, int nCntrlType, Dialog& getNDlg)
{
	TreeNode trNode = tree_get_node(tr, nRow);
	if( trNode && trNode.tagName == "BtnReset" )
	{
		GraphLayer gl = Project.ActiveLayer();
		if( gl )
		{
			double dWidth = gl.X.To - gl.X.From;
			double dLeft = gl.X.From + 0.25 * dWidth;
			double dRight = gl.X.From + 0.75 * dWidth;
			if( dRight < dLeft )
				_swap(dLeft, dRight);
			
			double dHeight = gl.Y.To - gl.Y.From;
			double dBottom = gl.Y.From + 0.25 * dHeight;
			double dTop = gl.Y.From + 0.75 * dHeight;
			if( dTop < dBottom )
				_swap(dTop, dBottom);
			
			int nRoundKeepNumDecimal;
			if( tr.GetAttribute("RoundPos", nRoundKeepNumDecimal) && nRoundKeepNumDecimal >= 0 )
			{
				///-----Kit 02/10/2011 ORG-2207-S1 KEEP_2_DECIMAL_PLACES_FOR_THE_SET_VALUE_DLG
				/*
				dLeft = nint(dLeft);
				dRight = nint(dRight);
				dBottom = nint(dBottom);
				dTop = nint(dTop);
				*/
				dLeft	= round(dLeft, nRoundKeepNumDecimal);
				dRight	= round(dRight, nRoundKeepNumDecimal);
				dBottom	= round(dBottom, nRoundKeepNumDecimal);
				dTop	= round(dTop, nRoundKeepNumDecimal);
				///-----End KEEP_2_DECIMAL_PLACES_FOR_THE_SET_VALUE_DLG
			}

			tr.Exc.Lower.dVal = dLeft;
			tr.Exc.Upper.dVal = dRight;
			tr.Emi.Lower.dVal = dBottom;
			tr.Emi.Upper.dVal = dTop;
		}
	}

	return true;
}

static void _swap(double& dVal1, double& dVal2)
{
	double dTemp = dVal1;
	dVal1 = dVal2;
	dVal2 = dTemp;
}

///-----Kit 02/10/2011 ORG-2207-S1 KEEP_2_DECIMAL_PLACES_FOR_THE_SET_VALUE_DLG
//bool image_profile_set_rect_pos(bool bRoundToInt = false)
bool image_profile_set_rect_pos(int nRoundKeepNumDecimal = -1)
///-----
{
	double dTop, dBottom, dLeft, dRight;
	if( !image_profile_get_obj_pos(dTop, dBottom, dLeft, dRight, true) )
		return false;

	GraphLayer glSource;
	ImageProfileManager* pProfile = get_image_profile_holder()->GetActiveProfile();
	if( pProfile )
		glSource = pProfile->GetSourceLayer();
	if( !glSource )
		return false;
	set_active_layer(glSource);

	if( nRoundKeepNumDecimal >= 0 )
	{
		///-----Kit 02/10/2011 ORG-2207-S1 KEEP_2_DECIMAL_PLACES_FOR_THE_SET_VALUE_DLG
		/*
		dLeft = nint(dLeft);
		dRight = nint(dRight);
		dBottom = nint(dBottom);
		dTop = nint(dTop);
		*/
		dLeft	= round(dLeft, nRoundKeepNumDecimal);
		dRight	= round(dRight, nRoundKeepNumDecimal);
		dBottom = round(dBottom, nRoundKeepNumDecimal);
		dTop	= round(dTop, nRoundKeepNumDecimal);
		///-----End KEEP_2_DECIMAL_PLACES_FOR_THE_SET_VALUE_DLG
	}

	GETN_TREE(tr)
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	
	///-----Kit 02/10/2011 ORG-2207-S1 KEEP_2_DECIMAL_PLACES_FOR_THE_SET_VALUE_DLG
	//tr.SetAttribute("RoundPos", bRoundToInt);
	tr.SetAttribute("RoundPos", nRoundKeepNumDecimal);
	///-----
	GETN_BEGIN_BRANCH(Exc, "Excitation Profile")	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_NUM(Lower, "Lower Value", dLeft)
		GETN_NUM(Upper, "Upper Value", dRight)
	GETN_END_BRANCH(Exc)
	GETN_BEGIN_BRANCH(Emi, "Emission Profile")		GETN_OPTION_BRANCH(GETNBRANCH_OPEN)
		GETN_NUM(Lower, "Lower Value", dBottom)
		GETN_NUM(Upper, "Upper Value", dTop)
	GETN_END_BRANCH(Emi)
	GETN_BUTTON_GROUP(BtnReset, "", 0, _L("Reset to Center")) GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_RIGHT)

	if( GetNBox(tr, "Input Values", NULL, NULL, _image_profile_input_values_event, GetWindow()) )
	{
		// Excitation, X
		double dXFrom = glSource.X.From;
		double dXTo = glSource.X.To;
		if( dXFrom > dXTo )
			_swap(dXFrom, dXTo);
		if( tr.Exc.Lower.dVal >= dXFrom && tr.Exc.Lower.dVal < dXTo )
		   dLeft = tr.Exc.Lower.dVal;
		else
		   dLeft = dXFrom;
	
		if( tr.Exc.Upper.dVal > dLeft && tr.Exc.Upper.dVal <= dXTo )
		   dRight = tr.Exc.Upper.dVal;
		else
		   dRight = dXTo;
	
		// Emission, Y
		double dYFrom = glSource.Y.From;
		double dYTo = glSource.Y.To;
		if( dYFrom > dYTo )
			_swap(dYFrom, dYTo);
		if( tr.Emi.Lower.dVal >= dYFrom && tr.Emi.Lower.dVal < dYTo )
		   dBottom = tr.Emi.Lower.dVal;
		else
		   dBottom = dYFrom;
		
		if( tr.Emi.Upper.dVal > dBottom && tr.Emi.Upper.dVal <= dYTo )
		   dTop = tr.Emi.Upper.dVal;
		else
		   dTop = dYTo;
		
		return image_profile_set_obj_pos(dTop, dBottom, dLeft, dRight);
	}

	return false;
}

bool image_profile_output_profile(Worksheet& wksOutput, bool bVertical, bool bHorizontal, GraphLayer& glVertical, GraphLayer& glHorizontal)
{
	bool bRet = false;

	HOLDER_BEFORE_UPDATE_NO_CHECK(get_image_profile_holder());
	ImageProfileManager* pProfile = get_image_profile_holder()->GetActiveProfile();
	if( pProfile )
	{
		int nPath = pProfile->GetActivePath();
		if( nPath < 0 )
			nPath = 0;

		ImageProfilerPath* pPath = pProfile->GetProfilePath(nPath);
		bRet = pPath && pPath->OutputProfile(wksOutput, bVertical, bHorizontal, glVertical, glHorizontal);
	}

	return bRet;
}

static Page _get_input_range_page(const DataPlot& dpSrc)
{
	if( !dpSrc.IsValid() )
		return NULL;

	DataPlotStrings descStrs;
	switch( dpSrc.GetPlotType(&descStrs) )
	{
	case IDM_PLOT_CONTOUR:
	case IDM_PLOT_MATRIX_IMAGE:
	case IDM_PLOT_TRI_CONTOUR:
		{
			Page pg(descStrs.szWorkBook);
			return pg;
		}
		break;
	}

	return NULL;
}

bool image_profile_output_profile(bool bVertical, bool bHorizontal, bool bCheckLoadProfile = false)
{
	if( !(bVertical || bHorizontal) )
		return false;

	if( bCheckLoadProfile )
		_check_load_profile_and_make_active();

	GraphLayer glSource;
	Worksheet wksOutput;

	HOLDER_BEFORE_UPDATE_NO_CHECK(get_image_profile_holder());
	ImageProfileManager* pProfile = get_image_profile_holder()->GetActiveProfile();
	if( pProfile )
	{
		glSource = pProfile->GetSourceLayer();

		int nPath = pProfile->GetActivePath();
		if( nPath < 0 )
			nPath = 0;
		ImageProfilerPath* pPath = pProfile->GetProfilePath(nPath);

		DataPlot dpSrc;
		if( pPath && pPath->GetSourcePlot(dpSrc) && dpSrc.IsValid() )
		{
			WorksheetPage wp = _get_input_range_page(dpSrc);
			if( wp )
			{
				int nLayer = wp.AddLayer("Profile", 0, "origin");
				wksOutput = wp.Layers(nLayer);
			}
			else
			{
				wksOutput.Create("origin", CREATE_HIDDEN | CREATE_LOAD_1ST_LAYER_ONLY);
			}
		}
	}

	if( !(glSource && wksOutput) )
		return false;

	GraphLayer glVertical, glHorizontal;
	if( bVertical )
		glVertical = image_profile_new_output_layer("Profile", glSource.GetPage().GetName(), true);
	if( bHorizontal )
		glHorizontal = image_profile_new_output_layer("Profile", glSource.GetPage().GetName(), true);

	set_active_layer(glSource);

	if( image_profile_output_profile(wksOutput, bVertical, bHorizontal, glVertical, glHorizontal) )
	{
		double dTop, dBottom, dLeft, dRight;
		image_profile_get_obj_pos(dTop, dBottom, dLeft, dRight);

		if( glHorizontal )
		{
			///-----Kit 02/10/2011 ORG-2207-S1 ONLY_FILL_THE_DATA_INSIDE_RECT_RANGE
			//update_output_layer_mask(glHorizontal, dLeft, dRight);
			glHorizontal.Rescale();
			///-----
			_embed_graph_into_a_new_column(wksOutput, "Excitation", 10, 14, glHorizontal);
		}

		if( glVertical )
		{
			///-----Kit 02/10/2011 ORG-2207-S1 ONLY_FILL_THE_DATA_INSIDE_RECT_RANGE
			//update_output_layer_mask(glVertical, dBottom, dTop);
			glVertical.Rescale();
			///-----
			_embed_graph_into_a_new_column(wksOutput, "Emission", 10, 14, glVertical);
		}

		// remove the active profile after creating report
		{
			Worksheet wksXYZData;
			ImageProfileManager* pProfile = get_image_profile_holder()->GetActiveProfile();
			if( pProfile )
			{
				DataPlot dp;
				if( pProfile->GetSrcPlot(dp) && dp.IsValid() )
				{
					DataRange dr;
					int c1, c2;
					if( dp.GetDataRange(dr) && dr.IsValid() )
					{
						int c1, c2;
						dr.GetRange(wksXYZData, c1, c2);
					}
				}
				pProfile->SetKeepGraphsOnClosing(false);
			}
			get_image_profile_holder()->RemoveProfile();
			if( wksXYZData.IsValid() && is_destroy_wks_on_create_report(wksXYZData) )
			{
				wksXYZData.Destroy();
			}
		}

		set_active_layer(wksOutput);
		return true;
	}

	return false;
}

static int _embed_graph_into_a_new_column(Worksheet& wks, LPCSTR lpcszColName, int nRows, int nColSize, GraphLayer& gl)
{
	int nCol = wks.AddCol();
	if( nCol >= 0 )
	{
		Column col(wks, nCol);
		col.SetLongName(lpcszColName);
		col.SetWidth(nColSize);

		if( nRows > 1 )
		{
			Grid gg;
			gg.Attach(wks);
			ORANGE rng;
			rng.c1 = rng.c2 = nCol;
			rng.r1 = 0;
			rng.r2 = nRows - 1;

			gg.MergeCells(rng);
		}

		GraphPage gp = gl.GetPage();
		wks.EmbedGraph(0, nCol, gp);
	}

	return nCol;
}

static void _set_rece_position(GraphObject goRect, double x0, double x1, double y0, double y1)
{
	if( goRect )
	{
		vector vx(4), vy(4);
		vx[0] = x0, vx[1] = x1; vx[2] = x1; vx[3] = x0; ///---Sim 10-17-2006 CORRECT_VECTOR_VALUE
		vy[0] = y0, vy[1] = y0; vy[2] = y1; vy[3] = y1;

		Tree tr;
		tr.Root.Data.X.dVals = vx;
		tr.Root.Data.Y.dVals = vy;

		if( 0 == goRect.UpdateThemeIDs(tr.Root) )
			goRect.ApplyFormat(tr, true, true);
	}
}

BOOL update_output_layer_mask(GraphLayer& glOutput, double dSelFrom, double dSelTo)
{
	if( !glOutput )
		return false;

	double dTop = glOutput.Y.To;
	double dBottom = glOutput.Y.From;

	double dLayFrom = glOutput.X.From;
	double dLayTo = glOutput.X.To;
	
	if( dLayFrom < dLayTo && dSelFrom >= dSelTo )
	{
		double dTemp = dSelFrom;
		dSelFrom = dSelTo;
		dSelTo = dTemp;
	}

	GraphObject goRect = glOutput.GraphObjects("Rect");
	if( goRect )
		_set_rece_position(goRect, dLayFrom, dSelFrom, dBottom, dTop);

	GraphObject goRect1 = glOutput.GraphObjects("Rect1");
	if( goRect1 )
		_set_rece_position(goRect1, dSelTo, dLayTo, dBottom, dTop);

	return true;
}

BOOL update_output_layer_mask(string strLayerName, double dSelFrom, double dSelTo)
{
	GraphLayer glOutput;
	if( !okxf_resolve_string_get_origin_object(strLayerName, &glOutput) )
		return false;

	return update_output_layer_mask(glOutput, dSelFrom, dSelTo);
}

BOOL check_get_xyz_data_sheet(Worksheet& wksSource, Worksheet& wksXYZData)
{
	if( !wksSource.IsValid() )
		return false;

	Tree trStorage;
	tree_get_binary_storage(trStorage, wksSource, "TREE");

	if( trStorage.HJYDataInfo && trStorage.HJYDataInfo.XYZDataSheetUID )
	{
		wksXYZData = (Worksheet)Project.GetObject(trStorage.HJYDataInfo.XYZDataSheetUID.nVal);
		return wksXYZData.IsValid();
	}
	return false;
}

BOOL check_get_raw_data_sheet(Worksheet& wksSource, GraphLayer& glSource, Worksheet& wksRawData)
{
	if( !wksSource.IsValid() )
		return false;

	Tree trStorage;
	tree_get_binary_storage(trStorage, wksSource, "TREE");

	if( trStorage.HJYDataInfo && trStorage.HJYDataInfo.RawDataSheetUID )
		wksRawData = (Worksheet)Project.GetObject(trStorage.HJYDataInfo.RawDataSheetUID.nVal);

	if( !wksRawData.IsValid() )
	{
		DataPlot dp = get_waterfall_plot(wksSource, glSource);
		if( dp )
		{
			DataRange dr;
			if( dp.GetDataRange(dr) && dr.IsValid() )
			{
				int c1, c2;
				dr.GetRange(wksRawData, c1, c2);
			}
		}
	}

	return wksRawData.IsValid();
}

DataPlot get_waterfall_plot(Worksheet& wksSource, GraphLayer& glSource)
{
	if( glSource )
		return glSource.DataPlots();

	DataPlot dp;
	if( wksSource )
	{
		GraphPage gp;
		gp = wksSource.EmbeddedPages(0);

		if( gp )
		{
			GraphLayer gl = gp.Layers();
			if( gl )
				dp = gl.DataPlots();
		}
	}

	return dp;
}

BOOL check_if_valid_for_JYProfile(Worksheet& wksSource, GraphLayer& glSource)
{
	if( !wksSource )
		return false;

	DataPlot dp = get_waterfall_plot(wksSource, glSource);
	if( !dp )
		return false;
	int nPlotType = dp.GetPlotType();
	if( IDM_PLOT_LINESYMB != nPlotType && IDM_PLOT_AREA != nPlotType )
		return false;

	return true;
}


BOOL prepare_xyz_data_for_JYProfile()
{
	Worksheet wksSource = Project.ActiveLayer();
	GraphLayer glSource = Project.ActiveLayer();
	if( !wksSource.IsValid() && glSource.IsValid() )
	{
		GraphPage gpSource = glSource.GetPage();
		if( gpSource )
			gpSource.GetEmbeddingInfo(wksSource);
	}
	if( !check_if_valid_for_JYProfile(wksSource, glSource) )
		return false;

	Worksheet wksXYZData;
	if( !check_get_xyz_data_sheet(wksSource, wksXYZData) )
	{
		Worksheet wksRawData;
		if( check_get_raw_data_sheet(wksSource, glSource, wksRawData) )
		{
			string strMsg = "Rendering the XYZ dataset may take some time.  Do you want to continue?";
			if( IDYES != warning_msg_box(strMsg, true, 'W', MB_YESNO) )
				return false;

			set_active_layer(wksRawData);
			string strScript = "w2xyz format:=xcol xlabel:=param param:=\"Long Name\" ycol:=1;";
			LT_execute(strScript);

			wksXYZData = Project.ActiveLayer();
			if( wksXYZData && !is_same_layer(wksXYZData, wksRawData) )
				set_destroy_wks_on_create_report(wksXYZData);
		}
	}

	if( !wksXYZData.IsValid() )
		return false;

	set_active_layer(wksXYZData);

	// select the first 3 columns
	vector<int> vR1(1), vR2(1), vC1(1), vC2(1);
	vR1[0] = 0;
	vR2[0] = wksXYZData.GetNumRows() - 1;
	vC1[0] = 0;
	vC2[0] = 2;
	return wksXYZData.SetSelectedRange(vR1, vC1, vR2, vC2);
}

#define STR_DESTROY_ON_CREATE_REPORT	"JYProfileDestroyWks"
void set_destroy_wks_on_create_report(Worksheet& wks, bool bSet = true)
{
	if( bSet )
	{
		Tree tr;
		tr.DelWksOnCreateReport.nVal = 1;
		wks.PutBinaryStorage(STR_DESTROY_ON_CREATE_REPORT, tr);
	}
	else
	{
		wks.SetMemory(STR_DESTROY_ON_CREATE_REPORT, NULL);
	}
}

bool is_destroy_wks_on_create_report(Worksheet& wks)
{
	Tree tr;
	if( wks.GetBinaryStorage(STR_DESTROY_ON_CREATE_REPORT, tr) && tr.DelWksOnCreateReport )
	{
		return tr.DelWksOnCreateReport.nVal != 0;
	}
	return false;
}
///End IMAGE_PROFILE_WITHOUT_DIALOG
