/*------------------------------------------------------------------------------*
 * File Name:ImagePreview.h 													*
 * Creation: CPY 2/3/2004														*
 * Purpose: GetNBox Preview Box to show an image, base class					*
 * Copyright (c) Originlab Corp.	2004										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#define NOCLICK_ALL (NOCLICK_AXES | NOCLICK_DATA_PLOT | NOCLICK_LABEL | NOCLICK_LAYER | NOCLICK_TICKLABEL)

 // base class for the Preview Box in GetNView dialog
class ImagePreview
{
public:
	ImagePreview() {}
	bool Init(Dialog& dlg, int nViewCntrlID)
	{
		m_strSrcMatrix.Empty();
		m_strTempMatrix.Empty();
		m_bReady = false;
		Control cView = dlg.GetItem(nViewCntrlID);
		if(cView)
		{
			m_matCntrl.CreateControl(cView.GetSafeHwnd());
			m_matCntrl.Create(NOCLICK_ALL, "Origin");
			m_mpCntrl = m_matCntrl.GetPage();
			m_mlCntrl = m_mpCntrl.Layers(0);
			m_mpCntrl.GetName(m_strTempMatrix);
			
			if(OnInitPreview())
			{
				m_mlCntrl.SetViewImage();
				return true;
			}
		}
		return false;
	}
	bool Update(TreeNode tr)
	{
		return OnUpdatePreview(tr);
	}
protected:
	string 			m_strSrcMatrix;
	MatrixControl	m_matCntrl;
	MatrixPage		m_mpCntrl;
	MatrixLayer 	m_mlCntrl;
	virtual bool OnInitPreview()
	{
		checkConvertType(m_mlCntrl);
		return copyImage();
	}
	virtual bool OnUpdatePreview(TreeNode tr)
	{
		return false;
	}
private:
	bool copyImage()
	{
		MatrixLayer ml = Project.ActiveLayer();
		if(!ml)
			return false;
		ml.GetPage().GetName(m_strSrcMatrix);
		checkConvertType(ml);
		Matrix<ushort> mat1(ml);
		Matrix<ushort> mat2(m_mlCntrl);
		mat2 = mat1;
		return true;
	}		
private:
	bool checkConvertType(MatrixLayer& ml, int nType = FSI_USHORT)
	{
		if(ml.GetInternalData() != nType)
		{
			ml.SetInternalData(nType, TRUE, FALSE);
			return true;
		}
		return false;
	}

	bool			m_bReady;
	string m_strTempMatrix;
};

