
#include "file_utils.h"


enum PackedFileRecordType {
	kUnusedRecord = 0,
	kVariablesRecord,		//  1: Contains system numeric variables (e.g., K0) and user numeric and string variables.
	kHistoryRecord,			//  2: Contains the experiment's history as plain text.
	kWaveRecord,			//  3: Contains the data for a wave
	kRecreationRecord,		//  4: Contains the experiment's recreation procedures as plain text.
	kProcedureRecord,		//  5: Contains the experiment's main procedure window text as plain text.
	kUnused2Record,
	kGetHistoryRecord,		//  7: Not a real record but rather, a message to go back and read the history text.
	kPackedFileRecord,		//  8: Contains the data for a procedure file or notebook in a packed form.
	kDataFolderStartRecord,	//  9: Marks the start of a new data folder.
	kDataFolderEndRecord,	// 10: Marks the end of a data folder.
	kPlatformRecord=20		// 20: Info about Igor that wrote experiment. Added for Igor Pro 5.5D.
	
	/*	Igor writes other kinds of records in a packed experiment file, for storing
		things like pictures, page setup records, and miscellaneous settings. The
		format for these records is quite complex and is not described in PTN003.
		If you are writing a program to read packed files, you must skip any record
		with a record type that is not listed above.
	*/
};

#define IGP_MAC		1
#define IGP_WIN		2

#define TYPE_IBW	1
#define TYPE_PXP	2

#define MAXDIMS 4
#define MAX_WAVE_NAME2 18	// Maximum length of wave name in version 1 and 2 files. Does not include the trailing null.
#define MAX_WAVE_NAME5 31	// Maximum length of wave name in version 5 files. Does not include the trailing null.
#define MAX_UNIT_CHARS 3


#define HEADER_WIDTH1 118
#define HEADER_WIDTH2 126
#define HEADER_WIDTH3 130
#define HEADER_WIDTH5 384


#define IGP_WAVE_DIM1	1
#define IGP_WAVE_DIM2	2
#define IGP_WAVE_DIM3	3
#define IGP_WAVE_DIM4	4


#define IGP_VER1	1
#define IGP_VER2	2
#define IGP_VER3	3
#define IGP_VER5	5



#define NT_TEXT 0			// Text Waves
#define NT_CMPLX 1			// Complex numbers.
#define NT_FP32 2			// 32 bit fp numbers.
#define NT_FP64 4			// 64 bit fp numbers.
#define NT_I8 8				// 8 bit signed integer. Requires Igor Pro 2.0 or later.
#define NT_I16 	0x10		// 16 bit integer numbers. Requires Igor Pro 2.0 or later.
#define NT_I32 	0x20		// 32 bit integer numbers. Requires Igor Pro 2.0 or later.
#define NT_UNSIGNED 0x40	// Makes above signed integers unsigned. Requires Igor Pro 3.0 or later.

typedef void igp_Column;
typedef void igp_Layer;
typedef void igp_Chunk;

typedef struct _igp_Info{
	short version;
	short type;
	long wdSize;
	unsigned char platform;
	char bname[MAX_WAVE_NAME5+2];
	long nDim[MAXDIMS];
	short dim;
	double sfA[MAXDIMS];
	double sfB[MAXDIMS];
	long npts;
	int elementSize;
	int offset;
	long noteSize;
	long fmSize;
	long dataEUSize;
	long dimEUSize[MAXDIMS];
	long dimELSize[MAXDIMS];
	long sIndSize;
}igp_Info;

class IgorProFile : public BinFile{
public:
	IgorProFile(LPCSTR lpcszFileName);
	~IgorProFile(){
		Close();
	}
	int Open(int nBaseOffset = 0);
	int GetVersion();
	int GetDim();
	int GetType();
	int GetAxis(vector &vd, int dim);
	int ImportIBW(Worksheet&, int nCol=1);
	int ImportALL(TreeNode&, string, Worksheet&);
	int ReadHeader(TreeNode &);

private:
//	file m_fin;
	int m_nBaseOffset;		// base position of file
	igp_Info m_info;
	int m_nColIndex;
	int m_type;

	int ImportWave(string, Worksheet&);
	int Import2Matrix(MatrixLayer&, int, int, int);
	int ImportVariables(Worksheet&, TreeNode &);

};


