/*------------------------------------------------------------------------------*
 * File Name: IWAscHdrVarToken.h												*
 * Purpose: Ask user how to extract ASCII header variables.						*
 * Copyright (c) OriginLab Corp. 2004											*
 * 																				*
 * Modification Log:															*
 * SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER						*
 * EJP 2006-04-26 v8.0400 UPDATE_PREVIEW_LINES_ON_CHANGE_NUM_HDR_LINES			*
 *------------------------------------------------------------------------------*/

//--------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------
///#define SHOW_TOKEN_INFO_IN_GRID 1

// EJP: Define the following to have the value settings change to equal the
// name settings when a user changes a name setting.  When not defined the
// name settings will follow the value settings.
//#define VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS

#define IW_EXTRACT_VAR_PREVIEW_LINE_PREFIX_WIDTH 6


//--------------------------------------------------------------------------
// HdrVarTokenGridListCtrl
//
//--------------------------------------------------------------------------
class IWVarListCtrl : public GridListControl
{
public:
	IWVarListCtrl();
	
	void Init(int nID, WndContainer& dlg);

	void SetCell(int nRow, int nCol, int n);

	void SetCell(int nRow, int nCol, LPCSTR lpcsz);

	int Add(LPCSTR lpcszVarName, LPCSTR lpcszVarValue, BOOL bDelim);

	#ifdef SHOW_TOKEN_INFO_IN_GRID
	int AddVarInfo(TreeNode& trVar);
	#endif // SHOW_TOKEN_INFO_IN_GRID
};

//--------------------------------------------------------------------------
// IWAscVarPage
//
// This is the page where the user specifies how to tokenize the header
// lines to get variable names and values.
//--------------------------------------------------------------------------
class IWGetVarPage : public ImpWizAscPage
{
public:
	IWGetVarPage();

	enum {
		VarType_Unknown = 0,
		VarType_Delimiter,
		VarType_Position
	};
	virtual int GetPageVarType() {return VarType_Unknown;}
	
	//----------------------------------------------------------------------
	// Methods for handling events
	//----------------------------------------------------------------------
	BOOL OnInit();
	BOOL OnActive();

	BOOL OnClickVarNameConst(Control ctrl);
	BOOL OnSelChangeVarNameLine(Control ctrl);
	BOOL OnSelChangeVarValueLine(Control ctrl);

	BOOL OnClickSave(Control ctrl);
	BOOL OnClickEdit(Control ctrl);
	BOOL OnClickDelete(Control ctrl);

	BOOL OnSelChangeVar(Control ctrl);

	//----------------------------------------------------------------------
	// Methods that a derived class must over-ride
	//----------------------------------------------------------------------
	virtual BOOL UpdateVarNameControlsEnable();
	
	virtual BOOL IsShowPage() {return FALSE;}
	virtual void GetLines(StringArray& saLines) {saLines.SetSize(0);}
	
	virtual void ShowVarNameControls(BOOL bVisible) {return;}

	//----------------------------------------------------------------------
	// Helper Methods
	//----------------------------------------------------------------------
	BOOL GetVar(TreeNode& tnVar);
	virtual BOOL GetVarName(TreeNode& tnVarName, BOOL bAllowConstant=TRUE) {return FALSE;}
	virtual BOOL GetVarValue(TreeNode& tnVarValue) {return FALSE;}
	
	BOOL SetVar(TreeNode& tnVar);
	virtual BOOL SetVarName(TreeNode& tnVarName) {return FALSE;}
	virtual BOOL SetVarValue(TreeNode& tnVarValue) {return FALSE;}

	int GetLineIndex(BOOL bVarValue = TRUE);
	void SetLineIndex(int nLine, BOOL bVarValue = TRUE);

	BOOL GetLine(string& strLine, int nLine);

	BOOL AddVarToFilter(TreeNode& tnVar);
	BOOL DelVarFromFilter(int nIndex);
	BOOL GetVarFromFilter(TreeNode& tnVar, int nIndex);
	BOOL GetVarsFromFilter(TreeNode& tnVars);
	
	void AddVarToGrid(TreeNode& tnVar);
	void AddVarsToGrid(TreeNode& tnVars);

	BOOL AddVar(); // get var settings from dialog and add to grid and filter
	BOOL DeleteSelectedVars(); // delete selected vars from grid and filter

	void UpdateData(bool bFromDialogToData=true);
	void UpdateTokenComboBoxItems(bool bVarValue=true);

	BOOL UpdateLines();
	void UpdateLineComboBoxItems();

	BOOL AdjustVariableGroupHeight();

protected:
	int m_nNumHdrLines; /// EJP 2006-04-26 v8.0400 UPDATE_PREVIEW_LINES_ON_CHANGE_NUM_HDR_LINES
	string m_strDataFileName;
	StringArray m_saLines;

	RichEdit m_reLines;

//	Button m_chkVarNameConst;
	Edit m_ebVarName;
	ComboBox m_cbVarNameLine;
	
	ComboBox m_cbVarValueLine;
	
	IWVarListCtrl m_gridVars;
};

//--------------------------------------------------------------------------
// IWGetVarByDelimPage
//
// This is the page where the user specifies how to tokenize the header
// lines to get variable names and values.
//--------------------------------------------------------------------------
class IWGetVarByDelimPage : public IWGetVarPage
{
public:
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInit)
		PAGE_ON_ACTIVE(OnActive)
		PAGE_ON_KILLACTIVE(OnKillActive)
		
		//-----------------------------------------------------------
		// Events handled by methods in base class
		//-----------------------------------------------------------
		ON_BN_CLICKED(IDC_VARNAME_CONST, OnClickVarNameConst)

		ON_BN_CLICKED(IDC_VAR_SAVE, OnClickSave)
		ON_BN_CLICKED(IDC_VAR_EDIT, OnClickEdit)
		ON_BN_CLICKED(IDC_VAR_DELETE, OnClickDelete)

		ON_GRID_SEL_CHANGE(IDC_HDRVAR_VARIABLES, OnSelChangeVar)

		//-----------------------------------------------------------
		// Events unique for Delimiter page
		//-----------------------------------------------------------
		ON_CBN_SELCHANGE(IDC_VARNAME_DELIM, OnSelChangeVarNameDelim)
		ON_EN_CHANGE(IDC_VARNAME_DELIM_OTHER, OnChangeVarNameDelimOther)
		ON_CBN_SELCHANGE(IDC_VARVAL_DELIM, OnSelChangeVarValueDelim)
		ON_EN_CHANGE(IDC_VARVAL_DELIM_OTHER, OnChangeVarValueDelimOther)

		ON_CBN_SELCHANGE(IDC_VARNAME_LINE, OnSelChangeVarNameLine)
		ON_CBN_SELCHANGE(IDC_VARVAL_LINE, OnSelChangeVarValueLine)
	EVENTS_END

	enum {
		DelimComma = 0,
		DelimTab,
		DelimSpace,
		DelimEqual,
		DelimColon,
		DelimOther,
		DelimMulti,	/// SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER
	};

	IWGetVarByDelimPage();
	int GetPageVarType() {return VarType_Delimiter;}
	DWORD OnShowStatus(DWORD InternalStatus);
	BOOL IsShowPage();

	//----------------------------------------------------------------------
	// Methods for handling events
	//----------------------------------------------------------------------
	BOOL OnInit();
	BOOL OnActive();
	BOOL OnKillActive();

	BOOL OnSelChangeVarNameDelim(Control ctrl);
	BOOL OnChangeVarNameDelimOther(Control ctrl);
	BOOL OnSelChangeVarValueDelim(Control ctrl);
	BOOL OnChangeVarValueDelimOther(Control ctrl);

	BOOL OnSelChangeVarNameLine(Control ctrl);
	BOOL OnSelChangeVarValueLine(Control ctrl);

	//----------------------------------------------------------------------
	// Methods that over-ride base class
	//----------------------------------------------------------------------
	BOOL UpdateVarNameControlsEnable();
	void UpdateVarValueControlsEnable();

	BOOL GetVarName(TreeNode& tnVarName, BOOL bAllowConstant=TRUE);
	BOOL GetVarValue(TreeNode& tnVarValue);

	BOOL SetVarName(TreeNode& tnVarName);
	BOOL SetVarValue(TreeNode& tnVarValue);

	BOOL GetTokenInfo(int& nLine, int& nToken, int& nDelim, BOOL bVarValue = TRUE);
	BOOL SetTokenInfo(int nLine, int nToken, int nDelim, BOOL bVarValue = TRUE);
	/// SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER
	BOOL GetTokenInfo(int& nLine, int& nToken, vector<int>& vnDelim, BOOL bVarValue = TRUE);
	BOOL SetTokenInfo(int nLine, int nToken, vector<int>& vnDelim, BOOL bVarValue = TRUE);
	/// end SUPPORT_MULTI_DELIMITER

	void ShowVarNameControls(BOOL bVisible);

	//----------------------------------------------------------------------
	// Helper Methods
	//----------------------------------------------------------------------
	void GetDelimiters(string& str);
	void GetDelimiterNames(string& str);

#ifdef VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	void CopyNameDelimToValueDelim();
#else // !VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	void CopyValueDelimToNameDelim();
#endif // !VAR_VALUE_SETTINGS_FOLLOW_VAR_NAME_SETTINGS
	
	void UpdateTokenComboBoxItems(BOOL bVarValue = TRUE);

protected:
	ComboBox m_cbVarNameDelim;
	Edit m_ebVarNameDelimOther;
	ComboBox m_cbVarNameToken;
	
	ComboBox m_cbVarValueDelim;
	Edit m_ebVarValueDelimOther;
	ComboBox m_cbVarValueToken;
};

//--------------------------------------------------------------------------
// IWGetVarByPosPage
//
// This is the page where the user specifies how to tokenize the header
// lines to get variable names and values.
//--------------------------------------------------------------------------
class IWGetVarByPosPage : public IWGetVarPage
{
public:
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInit)
		PAGE_ON_ACTIVE(OnActive)
		PAGE_ON_KILLACTIVE(OnKillActive)

		ON_CBN_SELCHANGE(IDC_VARNAME_LINE, OnSelChangeVarNameLine)
		ON_EN_CHANGE(IDC_VARNAME_START, OnChangeVarNameStart)
		ON_EN_CHANGE(IDC_VARNAME_END, OnChangeVarNameEnd)
		ON_BN_CLICKED(IDC_SET_VARNAME_USING_SEL, OnClickSetVarName)

		ON_CBN_SELCHANGE(IDC_VARVAL_LINE, OnSelChangeVarValueLine)
		ON_EN_CHANGE(IDC_VARVAL_START, OnChangeVarValueStart)
		ON_EN_CHANGE(IDC_VARVAL_END, OnChangeVarValueEnd)
		ON_BN_CLICKED(IDC_SET_VARVALUE_USING_SEL, OnClickSetVarValue)

		//-----------------------------------------------------------
		// Events handled by methods in base class
		//-----------------------------------------------------------
		ON_BN_CLICKED(IDC_VARNAME_CONST, OnClickVarNameConst)

		ON_BN_CLICKED(IDC_VAR_SAVE, OnClickSave)
		ON_BN_CLICKED(IDC_VAR_EDIT, OnClickEdit)
		ON_BN_CLICKED(IDC_VAR_DELETE, OnClickDelete)

		ON_GRID_SEL_CHANGE(IDC_HDRVAR_VARIABLES, OnSelChangeVar)
	EVENTS_END

	IWGetVarByPosPage();
	int GetPageVarType() {return VarType_Position;}
	DWORD OnShowStatus(DWORD InternalStatus);
	BOOL IsShowPage();

	//----------------------------------------------------------------------
	// Methods for handling events
	//----------------------------------------------------------------------
	BOOL OnInit();
	BOOL OnActive();
	BOOL OnKillActive();

	BOOL OnSelChangeVarNameLine(Control ctrl);
	BOOL OnChangeVarNameStart(Control ctrl);
	BOOL OnChangeVarNameEnd(Control ctrl);
	BOOL OnClickSetVarName(Control ctrl);

	BOOL OnSelChangeVarValueLine(Control ctrl);
	BOOL OnChangeVarValueStart(Control ctrl);
	BOOL OnChangeVarValueEnd(Control ctrl);
	BOOL OnClickSetVarValue(Control ctrl);

	//----------------------------------------------------------------------
	// Methods that over-ride base class
	//----------------------------------------------------------------------
	BOOL UpdateVarNameControlsEnable();
	BOOL UpdateVarPreview(BOOL bVarValue=TRUE);

	BOOL GetVarName(TreeNode& tnVarName, BOOL bAllowConstant=TRUE);
	BOOL GetVarValue(TreeNode& tnVarValue);

	BOOL SetVarName(TreeNode& tnVarName);
	BOOL SetVarValue(TreeNode& tnVarValue);

	BOOL GetTokenInfo(int& nLine, int& nToken, int& nDelim, BOOL bVarValue = TRUE);
	BOOL SetTokenInfo(int nLine, int nToken, int nDelim, BOOL bVarValue = TRUE);

	void ShowVarNameControls(BOOL bVisible);

	void CheckInitDefaultSettings();

	//----------------------------------------------------------------------
	// Helper Methods
	//----------------------------------------------------------------------
	BOOL GetTokenFromSelectedText(TreeNode& tnToken);

protected:
	Edit m_ebVarNameStart;
	Edit m_ebVarNameEnd;
	Edit m_ebVarNamePreview;
	BitmapRadioButton m_btnSetName;

	
	Edit m_ebVarValueStart;
	Edit m_ebVarValueEnd;
	Edit m_ebVarValuePreview;
	BitmapRadioButton m_btnSetValue;
};
