/*------------------------------------------------------------------------------*
 *	File Name: 	HelpId.h     													*
 *	Purpose:	Dialog box ids that are also used for context help.				*
 *  Creation:	03-26-97, by EJP												*
 *																				*
 *	Copyright Microcal Software Inc. 1992-1997									*
 *																				*
 *	Modification Log:                                                        	*
 *																				*
 *																				*
 *	ML 5/7/97 t2064 TOOLBARS_DIALOG_CONTEXT_HELP								*
 *	sth vStats 5/12/97 ADDING_ADVANCED_BOX_CHARTS								*
 *	EJP v5.006 08-07-97 CHANGE_DLG_ID_VALUE_TO_DLG_RANGE						*
 *	SFX 7/8/98 v6.0125 SELECT_DIFFERENT_PLOT_TYPE_STRING						*
 *	SFX 8/14/98 v6.0128 SPECTRUM_CONTROL_TAB									*
 *	ML 9/18/98 3D_MESH_TYPE_CHANGES												*
 *	CPY v6.0134 10/21/98 t3810 REMOVE_OLD_SEL_COL_PLOTTING						*
 *	GCJ 1/25/99 t5056 v6.0155 ORIGIN_DIALOG_IDS									*
 *	DVT	23/10/98 v6.0133 t4438 ICONIZED_IN_50_HIDDEN_IN_60_DB					*
 *	CPY 2/1/99 v6.0158 PUT_SEL_COL_PLOTTING_DLG_BACK							*
 *  IV 02/16/99 RENAME_WIND_DLG	                                                *
 *	CPY v6.0171 t3440 3/5/99 DEMO_ABOUT_DLG										*
 *	RB 3/30/99 v6.0178 t5775 REORGANIZE_MATRIX_PROPERTIES_AND_DIMENSIONS_DLGS	*
 *  IV 10/18/99 t1305 SPECIAL_PROMPT_DLG                                        *
 *  IV 11/17/99 t7001 ADD_DELETE_USER_GROUPS                                    * 
 *	ML 1/15/2000 v6.0252 t6867 MULTIPLE_PAGE_GRAPH_PRINTING_UI					*
 *	DSC 2/29/00 t7047 v6.0262  STUDENT_VERSION_CHECK_ACCESS_CODE				*
 *  IV 3/17/2000 RENAME_NOTES_DLG                                               *
 *  IV 2/28/2000 t7308 MODIFY_USER_GROUP                                        *
 *  IV 4/24/2000 REGISTRY_MSG_DLG                                               *
 *  IV 6/19/2000, t7996, v6.0291 EXPORT_USERDEF_CATEGORY                        *
 *	ML 6/21/2000 v6.0293 t7620 PRINT_DIMENSIONS_TAB_FOR_PAGE_ON_PLOTDETAILS_DLG	*
 *	CPY v6.1012 7/31/00 OU_OD_RC_CLEAN_UP										*
 *	ML 9/8/2000 v6.1046 RESOLVE_CONFLICT_WITH_TOOLS_DLL_FOR_CONTEXT_HELP		*
 *	YuI 08/03/01 v6.9062 t9355 NEW_PROPERTIES_DIALOG_FOR_GRAPHIC_OBJECTS		*
 *	DSC 11/05/01 v6.9116 t9661  DEMO_TO_STUDENT_INFO_DLG						*
 *	YuI 11/06/01 v6.90117 t9673 NEW_PAGE_TO_GROBJ_DIALOG						*
 *	EJP	11-06-2001 v6.9117 t9518 COPY_PROTECT_MODULES							*
 *  SY 11-09-2001 t9638 ADD_VIEW_SPC_MEMOBJ_DIALOG								*
 *	ML 11/15/2001 t9716 INDICATING_READ_ONLY_PROJECT_IN_MAINFRAME_TITLEBAR		*
 *	YuI 11/22/01 v6.9132 t3342 SYMBOL_MAP_DIALOG								*
 *  IV 2/8/2002 MOVE_DIALOG_IDS_FROM_NLSF                                       *
 *  SY 02/15/2002 QA70-843 HELP_TOPIC_TRANSLATION								*
 *	YuI 2/27/02 AMPO9180 V7.0222 INCREMENTAL_MANAGER							*
 *	ML 12/2/2002 CONNECT_LINE_COMBO_FOR_TREEEDITOR								*
 *  SY 12-20-02 QA70-3371 v7.0466 CHANGE_APPLY_TO_ALL_GROUPS					*
 *  SY 01-21-2003 QA70-3135 v7.0493 ARRANGE_CUSTOMIZE_TOOLBARS_HELP_ID			*
 *	JCG 01/28/03 QA-3159 v7.0500 ADD_NEW_METHODS_TO_WORKSHEET_CTRL				*
 *  LAS 3/27/03 QA-3236 v7.0545 CREATE_MOVE_TAB_FOR_LAYER_TOOL                  *
 *  SY 04-16-2003 QA70-4183 v7.0563 PLACE_BAR_IN_BROWSE_FOR_FOLDER_DLG			*
 *	CPY 4/20/03 QA70-4278 v7.0565 WKS_HEADER_REGION_CHANGE_PARAM_BUTTON			*
 *	EJP 07-25-2003 v7.0633 MOVE_IMPWIZ_DLG_IDS_TO_HELPID						*
 *	CPY v7.5656 8/11/03 QA70-4994 SEPARATE_REMINDER_MSG_BOX_FOR_YES_NO			*
 *	DSC 10/15/03 v7.5722 QA70-5339 BORROW_FROM_ORIGIN							*
 *	YuI 10/27/03 v7.5733 QA70-4995 DONGLE_SUPPORT_IMPLEMENTATION				*
 *	YuI 3/24/04 v7.5846 QA70-6118 NEW_DATA_SELECTOR_TOOL						*
 *	YuI 5/27/04 v7.5838 GETN_DATA_RANGE_CONTROL									*
 *	EJP 10-22-2004 v8.0152 QA70-6554 EXTRACT_VARS_FROM_FILENAME					*
 *  SY 11/12/2004 QA70-7066 v8.0163 EXPORT_TOOLBARS_BUTTONS_INTO_OPK			*
 *	DSC 1/20/2005 QA70-7334 NEW_NODELOCKED_LICENSE_DIALOGS						*
 *	RVD 3/15/2005 QA70-7498 v8.0204 XFUNCTION_ANCHORS							*
 *	TD 12-14-05 QA70-8061 PROJECT_AND_PAGE_UNLOCK_PROMPT_USING_POSTED_MESSAGES	*
 *	EJP 2006-01-17 v8.0358 UNIQUE_ID_FOR_HELP_WITH_GETN_BOX						*
 *	ML 3/22/2006 QA70-2306 TRICONTOUR_SMOOTHING									*
 *	RVD 12/20/2005 QA80-5536 v8.0350 WATERFALL_HIDDEN_REMOVAL					*
 *	TD 5-12-06 NEW_DLG_RESOURCE_FOR_DYNOBOX_THEME								*
 *	DSC 7/10/06 QA70-7334 IMPROVE_NODELOCKED_LIC_DLGS							*
 *	RVD 9/11/2006 QA80-8781 v8.0479 PLOT_STACK_WITH_OFFSET						*
 *	AW 04/11/07 QA80-9609 v8.0598 MORE_ON_CHANGE_COL_IN_IMPWIZ					*
 *	CPY 10/8/2007 QA70-10494 XF_BASED_DIALOG_VIA_OC_SHOULD_STILL_USE_XF_HELP	*
 *	Folger 10/09/07 CLEAN_IDS_ALREADY_DEFINE_IN_O8DLG							*
 *	Hong 10/10/07 v8.0721 MOVE_FROM_HELPID_TO_O8DLG								*
 *	Kyle 02/04/2009 QA70-13017-P1 COLORMAP_IMPROVEMENTS							*
 *	DSC 6/30/09 QA70-13824 NEW_LEASED_NODELOCKED_EVALUATION_LIC					*
 *	Kyle 12/04/2009 QA80-14451 THUMBNAIL_VIEW_OF_IMAGES_IN_MATRIX_BOOKS			*
 *	Kyle 07/22/2010 ORG-614-P1 INSERT_INFO_VARIABLES_DLG_CONTEXT_HELP_NOT_USE_XF_HELP
 *	CPY 7/23/10 ORG-435 LIC_DEACTIVATE_DLG										*
 *	Kyle 09/16/2010 ORG-1061-P1 CONTEXT_HELP_FOR_COLOR_MAP_DIALOGS				*
 *	Kyle Gareth 9/20/2010 ORG-1072-P1 3D_PLANES_GUI_REDESIGN					*
 *	Hong 02/21/11 ORG-2292 OGL_COMBINE_3D_SURFACE_PLOT_TYPE						*
 *	CPY 7/12/2011 ORG-2629 MOVE_ODLG_9_TO_DLG_8									*
 *	Kenny 07/15/2011 ORG-3219 NEW_GUI_FOR_OGL_SURFACE_PLOT						*
 *	EJP 2012-05-08 ORG-5568-P1 ADD_GRAPH_ASPECT_RATIO_MODES						*
 *	Kyle 09/04/2012 ORG-6284 AXIS_PLANES_FRAME_CONTROL_WANTED					*
 *------------------------------------------------------------------------------*/

/// EJP v4.97 03-26-97 ORIGIN_ONLINE_HELP
#ifndef _HELPID_H
#define _HELPID_H
/// end ORIGIN_ONLINE_HELP

//Different file from odlg8.h, a new file saving dialog IDs, which is in \C\SDK
#include <o8dlg.h>		//------ Folger 10/09/07 CLEAN_IDS_ALREADY_DEFINE_IN_O8DLG

//--------------------------------------------------------------------------
//								Begin of File
//--------------------------------------------------------------------------

///RKM CONSTANT_REORDER  These are not resource ids (IDM)
/* help id */
#define 	IDM_HELP			7800
#define		IDM_HELP_ABOUT		7801
#define		IDM_HELP_INDEX		7802

/* Origin.HLP related begin */
#define		IDM_HELP_KEY		7803
#define		IDM_HELP_TOOLS		7804
#define		IDM_HELP_PLOT_CMD	7805
#define		IDM_HELP_WKS_CMD	7806
#define		IDM_HELP_PLOT_PROC	7807
#define		IDM_HELP_GLOSSARY	7809
#define		IDM_HELP_MOUSE		7810

#define		IDM_HELP_PLOT_FILE		7820
#define		IDM_HELP_PLOT_EDIT		7821
#define		IDM_HELP_PLOT_OPTIONS	7822
#define		IDM_HELP_PLOT_PAGE		7823
#define		IDM_HELP_PLOT_PLOT		7824
#define		IDM_HELP_PLOT_DATA		7825

#define		IDM_HELP_WKS_FILE		7830
#define		IDM_HELP_WKS_EDIT		7831
#define		IDM_HELP_WKS_COLUMN		7832
#define		IDM_HELP_WKS_DATA		7833

#define		IDM_HELP_TUTORIAL		7835

///EJP v3.85 11-10-95 HELP_MENU_ITEMS
/// search help
#define IDM_HELP_PARTIALKEY			7836
///end HELP_MENU_ITEMS
///ANU v4.09 04/26/96 TIP_OF_DAY
#define	IDM_HELP_TIP				7837
///end TIP_OF_DAY
/* end */


#define		IDM_HELP_WKS_PROC	7807 /*IDM_HELP_PLOT_PROC*/
#define		IDM_HELP_HELP		7850
#define 	IDM_HELP_END		7850 /* IDM_HELP_HELP */


/* Dialog box ids should be in the range of 23265 -> 23399
 * to receive online help
 */

///CPY v4.133 b1343 9/5/96 	GETNUMBER_BROKEN_POWERSTAT
/// need to move these ids to higher number to prevent conflict with PowerStat dialogs
//#define	ABOUTDLOG		256
//
///* for the GetString command  */
//#define STRDLOG			259
//
//
///* for the parameter dialog */
//#define PARAMDLOG		260
//#define ABORTPNTDLOG	101


////////////////////////////////////////////////////////////
///////	RKM Begin Dialog Section	3000-3200/////////////////
///////	CONSTANT_REORDER			///////////////////////////
////////////////////////////////////////////////////////////

#define IDD_BEGIN_HELPID	3000
///RKM CONSTANT_REORDER These are dialogs in Okern.rc
//#define	ABOUTDLOG		3001		/// move to o8dlg.h
#define	STRDLOG			3002
#define	PARAMDLOG		3003
#define	ABORTPNTDLOG	3004
/// these ids are before the F1 help access that are in the range of  LOWER_LIMIT_FOR_DIALOG_F1_HELP and ...


#define	OPENSCRDLOG		3005
#define	GRIDDLOG		3009

#define SGETNUMDLOG		3012 //CPY 7/30/01 t9095 APPLY_BUTTON_IN_SINGLE_GET_NUMBER_DIALOG
#define FITDLOG		3016
#define FITFUNCDLOG		3017
#define	FITFUNC2DLOG	3018
///CPY v3.8 PLAYER_DLOG 6/16/95
///

/// EJP v5.006 08-07-97 CHANGE_DLG_ID_VALUE_TO_DLG_RANGE
///#define MATH1DLOG		293
/// end CHANGE_DLG_ID_VALUE_TO_DLG_RANGE
/* similar to mathDLOG, except can not create new dataset */

#define ARROWDLOG		3033
#define SHAPEDLOG		3034

#define	PICKWKSHEETDLOG	3047

#define	MATRIXDLOG		3048

#define	PAGEDLOG		3049
/// ML 9/8/2000 v6.1046 RESOLVE_CONFLICT_WITH_TOOLS_DLL_FOR_CONTEXT_HELP
// Since for 6.1 we've introduced context help for DDK dialogs,
// there is a conflict with this "Page Color" dialog.
// So, I am changing its values something that is not used in tools.dll (see below for 3054)
// (according to CP, we should in the future get rid of all these SDK dialogs).
//#define	PAGECOLORDLOG	3050
/// end RESOLVE_CONFLICT_WITH_TOOLS_DLL_FOR_CONTEXT_HELP

//#define	GRCNTRLDLOG		3051		//move to o8dlg.h


/// ML 9/8/2000 v6.1046 RESOLVE_CONFLICT_WITH_TOOLS_DLL_FOR_CONTEXT_HELP
#define	PAGECOLORDLOG	3054
/// end RESOLVE_CONFLICT_WITH_TOOLS_DLL_FOR_CONTEXT_HELP

#define	ASCIIDLOG		3055




///STH	V3.84 9/25/95 MATRIX_DIALOG
#define	FORMATMATRIXDLOG	3060
///



#define	WKSDDLOG		3063


#define	CONSTRDLOG		3065

#define	IMAGEDLOG		3066

#define	WKSPDLOG		3067

#define	PRNPDLOG		3068

//	CPY v3.8 8/14/95 PREFER_DLOG
//#define	PREFERDLOG		3069
///

///sth v4.06 3/15/96 ADVANCED_RENAME_WINDOW
///end ADVANCED_RENAME_WINDOW

/// CPY v3.8 8/15/95 FILE_PARTIAL_DLOG
#define	IMPRGDLOG		3071
///

// EJP v3.85 10-25-95 MORE_DATASET
#define MORE_DATASET_DLG	3074


/// ML 5/7/97 t2064 TOOLBARS_DIALOG_CONTEXT_HELP
#define	TOOLBARS_DIALOG_CONTEXT_HELP	3075
/// end TOOLBARS_DIALOG_CONTEXT_HELP

/// SFX 8/14/98 v6.0128 SPECTRUM_CONTROL_TAB
/// end SPECTRUM_CONTROL_TAB

//sth v3.80 6/26/95 WKSPLOT_OBJECT_DIALOG
#define 	WKSPLOTCHOICEDLG		3077

#define	PLOTDLOG		3053   ///CPY 2/1/99 v6.0158 PUT_SEL_COL_PLOTTING_DLG_BACK
//#define	PLOT2DLOG		3054

//---------------- CPY v6.0134 10/21/98 t3810 REMOVE_OLD_SEL_COL_PLOTTING
// dialog that are no longer used starting with 6.0 beta 1
//#define	AXISSTYLEDLOG	3006 /// this is the id that defines begine of F1 help, see LOWER_LIMIT_FOR_DIALOG_F1_HELP in bdialog.h
//#define	AXISDLOG		3007
//#define	AXISLABELDLOG	3008
//#define	FUNCTIONDLOG	3010
//#define	TEXTDLOG		3011
//#define	OpenDILG		3012
//#define	SaveasDILG		3013
//#define fileOpenDLOG		3014	/* general file open */
//#define dscOpenDLOG		3015
//#define LAYERDLOG			3030 /* layer control dialog */
//#define	AXISBREAKDLOG	3035
//#define	MTICKDLOG		3036
//#define	SCATTERDLOG		3037	/* line graph data set control */
//#define	VECTORDLOG		3038
//#define BARGRAPHDLOG		3039
//#define	ERRORBARDLOG	3041
//#define	GRAPHTYPEDLOG	3042
//#define ADVBOXCHARTDLOG	3043
//#define	BOXCHARTDLOG	3044
//#define	DOTDIALOG		3045
//#define COLCALCDLOG		3046
//#define	PLOTDLOG		3053
//#define	PLOT2DLOG		3054
//#define	LINKAXISDLOG	3056
//#define	TXTPLTDLOG		3062
#define MOVE_DLOGS_TO_OK_PLT_DETAILS
//---------------- end CPY v6.0134 10/21/98 t3810 REMOVE_OLD_SEL_COL_PLOTTING
#define IDD_END_HELPID			3200

////////////////////////////////////////////////////////////
///////	RKM End Dialog Section	3000-3200	/////////////////
///////	CONSTANT_REORDER			///////////////////////////
////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
//Begin Simple Dialog Builder (100-500)
////////////////////////////////////////////////////////////
#define IDD_TTestMean1Sample            100
#define IDD_TTestMean2Sample            101
#define IDD_ANOVA1Way                   102
#define IDD_ANOVA2Way                   103
#define IDD_KaplanMeier                 104
#define IDD_CoxPHM                      105
#define IDD_WilcoxonRankTest            106
#define IDD_MannWhitneyUTest            107


#define IDD_DMC                         110
//-------------- CPY 10/8/2007 QA70-10494 XF_BASED_DIALOG_VIA_OC_SHOULD_STILL_USE_XF_HELP
//////////////////////////////////////////////
// these are independent Operation dialogs
//////////////////////////////////////////////
//--------------
#define IDD_DYNABOX                     119 //CPY 2/26/06 new GetNBox using DynaControl, no theme
#define IDD_GSR                         120
#define IDD_SPARSEXYZ                   121
#define IDD_LABVIEW_IMPORT				125
#define IDD_GET_N_BOX					126 // vsFlex and Tree based parameters editor
#define IDD_THEME_ORGANIZER             128
#define IDD_INFO_VARIABLES				134
#define IDD_NLSF_PARAMS_FIT             135
#define IDD_NLSF_PARAM_CONSTRAINT       137
#define IDD_NLSF_SETTINGS				139
#define IDD_GET_N_BOX_RANGE				141 // GetNBox with ActiveCurve Range controls
#define IDD_GET_N_BOX_TREE				142 // same as IDD_GET_N_BOX, but use default look, IDD_GET_N_BOX has dialog look
#define IDD_REPORT_SETTINGS             145
#define IDD_REPORT_CONTENT              147
#define	IDD_DATA_RANGE					148/// YuI 5/03/04 v7.5838 GETN_DATA_RANGE_CONTROL
#define	IDD_DATA_RANGE_GRAPH			149/// YuI 5/27/04 v7.5838 GETN_DATA_RANGE_CONTROL
#define IDD_NLSFWizard					150

//---- CPY QA70-6953 9/22/04 moved from okRes
#define IDD_LISTBOX                     151	
#define IDD_COMBOINPUTBOX				152
//----
#define IDD_TIMER_PROGRESS_BOX			156

//#define IDD_WKS_SCRIPT                157	/// Fisher 2008-9-19 Moved to o8dlg.h

#define IDD_GRID_BOX					160 // a general vsFlexgrid

///Joseph 02/24/07 GETNBOX_PREVIEW_DLG_SUPPORT_NO_THEME
//GetNBox_Dlg With Theme
//#define IDD_GETNBOX_PREVIEW				162	// a GetNBox that also has a Preview box
///End 	GETNBOX_PREVIEW_DLG_SUPPORT_NO_THEME
#define IDD_GETNBOX_THEME				163 // ------ CPY 9/9/04 QA70-6682 SETTINGS_THEME_FILE_SAVE_LOAD
//---- CPY 8/16/05 QA70-8027					
#define IDD_GETNBOX_NEXT_REPV			164

#define IDD_TX_EDITOR                   172
#define IDD_COL_LIST_DLG                177
#define IDD_NL_PARA_BOUNDS_DLG          179
#define IDD_XF_LIST                     181
#define IDD_ADO_QUERY_BUILDER_OLD       182
#define IDD_ADO_QUERY_BUILDER           183
#define IDD_BASELINE_DLG                184
#define IDD_ADO_QUERY                   188
#define IDD_GETN_PREVIEW                191
#define IDD_GETN_EX                     192
#define IDD_GETN_WIZ                    193
#define IDD_WKS_CTRLRGN                 195
#define IDD_DYNA_PREVIEW                196
#define IDD_MATOBJ_DLG                  198
#define IDD_MULTI_EDIT_BOX              199
#define IDR_EXTRACT_DATA_MENU           202
#define IDD_PKG_LIST                    206
#define IDD_WK_SCRIPT_PANEL             207
#define IDD_GETN_PREVIEW_THEME          209
//-----
#define IDD_TEMPLATE_LIBRARY            210
#define IDD_OPK                         215
#define IDD_TX_DISPLAY                  219

#define IDD_OPK_UNINSTALL               220
#define IDD_GRIDDING                    225
#define IDD_TUNING                      230
#define IDD_REPORT_TREE_DLG             234
#define IDD_USER_INFO_DLG               235
#define IDD_LAYERTOOL                   237
#define IDD_SELECTCAT                   238
#define IDD_FitCmp                      240
#define IDD_SELFILTER					245
#define IDD_DYNABOX_THEME				246 /// TD 5-12-06 NEW_DLG_RESOURCE_FOR_DYNOBOX_THEME

//GetNBox_Dlg Without Theme
#define IDD_GETNBOX_PREVIEW				247 ///Joseph 02/24/07 GETNBOX_PREVIEW_DLG_SUPPORT_NO_THEME

#define IDD_IMGOBJ_DLG                  250

#define IDC_NEXT						298		//I looked and see all odlg and odlg8 control ids are greater then 300
#define IDC_PREV						299
/// Bill 07/14/2011 ORG-2629 MOVE_TO_DLG8
//---- CPY 7/12/2011 ORG-2629 MOVE_ODLG_9_TO_DLG_8
//#define IDD_3D_LIGHTING_CONTROL         501
//#define	IDD_BOOK_NEW_DLG				502
//#define IDD_2D_FUNCTION_PLOT_NEW_DLG	503
//#define IDD_3D_FUNCTION_PLOT_NEW_DLG	504
//---- end MOVE_ODLG_9_TO_DLG_8
/// End MOVE_TO_DLG8
////////////////////////////////////////////////////////////
//End Simple Dialog Builder
//////////////////////////////////////////////////////////// 
///Kyle 07/22/2010 ORG-614-P1 INSERT_INFO_VARIABLES_DLG_CONTEXT_HELP_NOT_USE_XF_HELP, move these ids to odlg8.h except IDD_PASTE_USER_VAR(moved to o8dlg.h)
/*
//-------------- CPY 10/8/2007 QA70-10494 XF_BASED_DIALOG_VIA_OC_SHOULD_STILL_USE_XF_HELP
#define IDD_BEGIN_XF_OC_DLG				390

#define IDD_XYZ_GRIDDING_DLG            391		
#define IDD_EXTRACT_DATA_DLG            392
#define IDD_CELL_FORMAT_DLG             393
#define IDD_PASTE_USER_VAR				394
#define IDD_LAYER_TOOL					395

#define IDD_END_XF_OC_DLG				420
//-------------- end XF_BASED_DIALOG_VIA_OC_SHOULD_STILL_USE_XF_HELP
*/
///End INSERT_INFO_VARIABLES_DLG_CONTEXT_HELP_NOT_USE_XF_HELP
////////////////////////////////////////////////////////////
//Begin Pages/Tabs Dialog Builder (3001-5000)
////////////////////////////////////////////////////////////
/// Hong 10/10/07 v8.0721 MOVE_FROM_HELPID_TO_O8DLG
/*
/// EJP 07-25-2003 v7.0633 MOVE_IMPWIZ_DLG_IDS_TO_HELPID
#define IDD_IW_FILETYPES                3050
/// end MOVE_IMPWIZ_DLG_IDS_TO_HELPID
/// EJP 10-06-2004 v8.0145 QA70-5658 IMPROVE_HDRVAR_EXTRACTION
#define IDD_GET_VAR_HOW					3060
#define IDD_GET_VAR_BY_DELIM            3061
/// end IMPROVE_HDRVAR_EXTRACTION
/// EJP 10-22-2004 v8.0152 QA70-6554 EXTRACT_VARS_FROM_FILENAME
#define IDD_FILENAME_OPTIONS			3062
#define IDD_GET_VAR_BY_POS				3063
/// end EXTRACT_VARS_FROM_FILENAME
*/
/// end MOVE_FROM_HELPID_TO_O8DLG

#define IDD_LR_OPERATION                3510
#define IDD_LR_SETTINGS                 3515
#define IDD_PR_OPERATION                3520
#define IDD_PR_SETTINGS                 3525
#define IDD_SR_OPERATION                3530
#define IDD_SR_SETTINGS                 3535
#define IDD_BASELINE_BASE               3540
#define IDD_BASELINE_PEAKS              3545
#define IDD_BASELINE_AREA               3550
#define IDD_SMOOTH_OPERATION            3555
#define IDD_SMOOTH_SETTINGS             3560
#define IDD_LAYERTOOL_ADD               3565
#define IDD_LAYERTOOL_ARRANGE           3570
#define IDD_LAYERTOOL_MOVE				3571 //CREATE_MOVE_TAB_FOR_LAYER_TOOL
#define IDD_FFTTOOL_OPERATION           3575
#define IDD_FFTTOOL_SETTINGS            3580
#define IDD_Function                    3605
#define IDD_Peaks                       3610
#define IDD_PandW                       3615
#define IDD_Fit                         3620
#define IDD_Results                     3625


////////////////////////////////////////////////////////////
//End Pages/Tabs
////////////////////////////////////////////////////////////




////////////////////////////////////////////////////////////
///////	RKM Begin Strings Section	0X61A0-0X62FF	/////////////////
///////	CONSTANT_REORDER			///////////////////////////
////////////////////////////////////////////////////////////

//--------------- CPY v6.1012 7/31/00 OU_OD_RC_CLEAN_UP
///RKM These two are also defined in DLGID.H
//#define		ID_LIST_AXIS_LEFT_POS	0X6190
//#define		ID_LIST_AXIS_RIGHT_POS	0X6191
///
//--------------- end CPY v6.1012 7/31/00 OU_OD_RC_CLEAN_UP


#define IDS_BEGIN_HELPID				0X61A0

#define		ID_TITLE_TOP			0X61A0
#define		ID_TITLE_BOT			0X61A1
#define		ID_TITLE_LEFT			0X61A2
#define		ID_TITLE_RIGHT			0X61A3

#define		ID_LIST_AXIS_TOP_POS	0X61A4
#define		ID_LIST_AXIS_BOT_POS	0X61A5


#define		ID_NUM_DIGITS_TYPE		0X61A6 ///CPY v4.09 6/5/96 BOTH_SIGDIGITS_AND_DECIMAL_DIGITS

#define		ID_INT_DATA_TYPES		0X61A7

#define		ID_AXIS_SCALE_TYPE		0X61A8
#define		ID_AXIS_RESCALE_TYPE	0X61A9

#define		ID_GRAPH_TYPES			0X61AA
///sth v4.983 5/13/97 ADDING_ADVANCED_BOX_CHARTS
#define		ID_ADD_GRAPH_TYPES		0X61AB
///end ADDING_ADVANCED_BOX_CHARTS
/// ML 12/2/2002 CONNECT_LINE_COMBO_FOR_TREEEDITOR
// Moved to OCntrlsRedIDs.h
//#define		ID_CONNECTION_TYPES		25004	// =0X61AC
/// end CONNECT_LINE_COMBO_FOR_TREEEDITOR
#define		ID_ARROW_TYPES			0X61AD
#define		ID_SYMBOL_TYPES			0X61AE
#define		ID_SYMBOL_FILLS			0X61AF
//#define		ID_COLUMN_GAPS			2526
///sth v3.98 12/15/95 VECTOR_PLOTS_DIALOG
//#define		ID_SYMBOL_VECTOR_RAD	2527
//#define		ID_SYMBOL_VECTOR_DEG	2528
//#define		ID_SYMBOL_VECTOR_GRD	2529
///end VECTOR_PLOTS_DIALOG

/// SFX 7/8/98 v6.0125 SELECT_DIFFERENT_PLOT_TYPE_STRING
#define		ID_GRAPH_TYPES_2		0X61B0
/// end SELECT_DIFFERENT_PLOT_TYPE_STRING
/// ML 9/18/98 3D_MESH_TYPE_CHANGES
#define		ID_GRAPH_TYPES_3D_MESH	0X61B1
/// end 3D_MESH_TYPE_CHANGES
/// ML 11/15/2001 t9716 INDICATING_READ_ONLY_PROJECT_IN_MAINFRAME_TITLEBAR
#define		ID_READ_ONLY			0X61B2
/// end INDICATING_READ_ONLY_PROJECT_IN_MAINFRAME_TITLEBAR

#define		ID_COL_AS_ABBRE			0X61B3 // JCG 01/28/03 QA-3159 v7.0500 ADD_NEW_METHODS_TO_WORKSHEET_CTRL		

///sth v4.07 4/1/96 BOX_CHAR_IMPROVEMENTS
//#define		ID_DOTS_GAPS			2530
#define		ID_WHISKER_TYPE			0X61C0
#define		ID_BOX_TYPE				0X61C1
//#define 	ID_BOXW_COEFS			2538
///end BOX_CHAR_IMPROVEMENTS

/// EJP v4.97 03-36-97 ORIGIN_ONLINE_HELP
/// For OK and SDK these are defined in DlgId.h
/// For OU these are defined in OUserRes.h
///#define		ID_APPLY_ALL_IN			2532
/// end ORIGIN_ONLINE_HELP

#define		ID_DELIMITORS			0X61C2
#define		ID_ASCII_DLG_TITLE		0X61C3

/// CPY v3.8 8/15/95 FILE_PARTIAL_DLOG
#define		ID_IMPORT_INTO			0X61C4
#define		ID_IMP_OPTN_TITLE		0X61C5
//
#define		ID_TEXT_NUM_FIELDS		0X61C6

#define		ID_AXS_TOP				0X61C7
#define		ID_AXS_BOT				0X61C8
#define		ID_AXS_LEFT				0X61C9
#define		ID_AXS_RIGHT			0X61CA

#define		ID_COL_TYPES			0X61CB

/// AR  ver3.8, ENHANCED_DIALOG
#define		ID_COL_AS				0X61CC
///end ENHANCED_DIALOG

#define		ID_COL_TYPES_ABBRE		0X61CD // JCG 01/28/03 QA-3159 v7.0500 ADD_NEW_METHODS_TO_WORKSHEET_CTRL		
#define		ID_APP_CUR_COL_TO_ALL	0X61CE // JCG 01/28/03 QA-3159 v7.0500 ADD_NEW_METHODS_TO_WORKSHEET_CTRL

/// EJP v4.97 03-26-97 ORIGIN_ONLINE_HELP
/// For OK and SDK these are defined in DlgId.h
/// For OU these are defined in OUserRes.h
/*
#define		ID_TIME_FORMATS			2552
#define		ID_DATE_FORMATS			2554
#define		ID_DAY_FORMATS			0X61CD
#define		ID_MONTH_FORMATS		0X61CE
*/
/// end ORIGIN_ONLINE_HELP

#define		ID_DIM_UNITS			0X61CF
#define		ID_PAGE_UNITS			0X61D0

#define		ID_PAGE_VIEW_MODE		0X61D1

#define		ID_GR_CMD_TYPE			0X61D2

/// YuI 11/06/01 v6.90117 t9673 NEW_PAGE_TO_GROBJ_DIALOG
#define		IDS_PAGE_UNITS_EX		0X61D3
/// end NEW_PAGE_TO_GROBJ_DIALOG

#define		ID_COL_SETTING			0x61D4	//CPY 1/17/03 , Jason had this file	checked out, so I cannot build, so I have to add, not sure if correct number

#define ID_PAGE_LEGEND_TYPES		0X61D5 //----- CPY 7/14/2007 QA70-10059 MORE_OPTIONS_ON_LEGEND_WITH_Y_TITLE_COMMENTS

#define IDS_ASPECT_RATIO_MODES		0X61D6 /// EJP 2012-05-08 ORG-5568-P1 ADD_GRAPH_ASPECT_RATIO_MODES

/// EJP v4.97 03-26-97 ORIGIN_ONLINE_HELP
/// For OK and SDK these are defined in DlgId.h
/// For OU these are defined in OUserRes.h
///#define		ID_TICK_ALIGNMENT		2568
/// end ORIGIN_ONLINE_HELP

#define		ID_EPS_STRING			0X61F0

#define		ID_TITLE_BACK			0X61F1
#define		ID_TITLE_FRONT			0X61F2

#define		ID_AXES_BACK			0X61F3
#define		ID_AXES_FRONT			0X61F4

#define		ID_DASH_TYPES			0X61F5
#define		ID_PATTERN_TYPES		0X61F6
//#define		ID_LINE_THICKNESS		2624
//#define		ID_SYMBOL_SIZE			2626
#define		ID_BORDER_TYPES			0X61F7

#define		ID_XAXIS_BREAK			0X61F8
#define		ID_YAXIS_BREAK			0X61F9

#define		ID_FIT_WT_MODE			0X61FA


/// ML v3.821 9/5/95 NUMERIC_FORMAT
#define		ID_NUM_SEPARATORS		0X61FC
/// end NUMERIC_FORMAT

/// AW 04/11/07 QA80-9609 v8.0598 MORE_ON_CHANGE_COL_IN_IMPWIZ
#define ID_COL_DATA_TYPES			0x61FD
/// END MORE_ON_CHANGE_COL_IN_IMPWIZ

#define ID_LIST_PLANE_TYPE			0x61FE	///Kyle Gareth 9/20/2010 ORG-1072-P1 3D_PLANES_GUI_REDESIGN

#define ID_LIST_3D_PLANES_CORNER_TYPE	0x61FF	///Kyle 09/04/2012 ORG-6284 AXIS_PLANES_FRAME_CONTROL_WANTED

/// ML v3.821 9/5/95 NUM_THRESHOLDS
//#define		ID_NUM_LOWER_THRESHOLD	2644
//#define		ID_NUM_UPPER_THRESHOLD	2646
/// end NUM_THRESHOLDS
/// ML v3.840 10/13/95 READ_BUILT_IN_ADDONDLL_COMMAND_ASSOCIATIONS
///CPY v4.11 7/2/96 MOVE_EXTERNAL_NAMES_TO_CMD
//#define		ID_DEFAULT_ADDON_COMMAND_DLL	2650
/// end READ_BUILT_IN_ADDONDLL_COMMAND_ASSOCIATIONS

//--------------------------------------------------------------------------
//								End of File
//--------------------------------------------------------------------------

/// EJP v4.97 03-26-97 ORIGIN_ONLINE_HELP

#define IDS_END_HELPID				0X62FF
////////////////////////////////////////////////////////////
///////	RKM End Strings Section	0X61A0-0X62FF	/////////////////
///////	CONSTANT_REORDER			///////////////////////////
////////////////////////////////////////////////////////////

/// GCJ 1/25/99 t5056 v6.0155 ORIGIN_DIALOG_IDS
/////////////////////////////////////////////////////////////////////
///////	MOVING DIALOG IDS FROM OUSRERES.H	/////////////////////////
/////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
///////////////////		IDD Section Begin	1008-2511	 ///////////////
///////////////////		Dialog Pages go here			///////////////
////RKM 6/17/97 These need to be above the ids created by online 
////////////help which should be less than 500 //////////
///////	CONSTANT_REORDER			/////////////
////////////////////////////////////////////////////////////
#define IDD_BEGIN_OU					1008

#define IDD_PROJVIEW                    1008 ///CPY:was changed to 107 jliu, but don't know why
/// ML 8/23/96 TOOLBARS_DIALOG
#define IDD_TOOLBARS_DLG                1009
/// end TOOLBARS_DIALOG

///CPY t1296 8/27/96 TAB_AXES_DIALOG
#define IDD_AXES_FORMAT                 1011
#define IDD_AXES_TICKS                  1012
/// HYYU define grid fialog

///HYYU add axis style dialog

/// RKM  12/9/96

/// EJP v4.133 09-19-96 t1409 WYSIWYG_INTERFACE_FOR_TEXT_LABELS

/// end WYSIWYG_INTERFACE_FOR_TEXT_LABELS

/// RKM 12/6/96 tick label dialog
//#define IDD_TICKLABEL_OPTIONS			1018	  // unused
//#define IDD_TICKLABEL_POSITION			1019  // unused
///RKM 1/6/96 changed from show to custom so it is more descriptive
///

/// RKM	1/2/97 Preferences dialog
#define IDD_PREF_GRID					1025
///

///HYYU 1/20/97 ADD_APPLY_TO_DIALOG
#define IDD_APPLY_WIZARD                1031
//end ADD_APPLY_TO_DIALOG

///RKM 2/10/97 New Window Dialog
#define IDD_NEW_WINDOW					1032
///

///RKM 2/13/97 Open Excel dialog
#define IDD_OPEN_EXCEL					1033

///RKM 2/19/97 Plot Excel Workbook dialog

///RKM 3/10/97 Print dialogs
#define IDD_PRINT_SETUP                 1036
//#define IDD_GRAPH_PRINT                 1037		//move to o8dlg.h


///RKM 3/31/97 Data Display properties dialog
#define	IDD_DATA_DISPLAY_PROPERTY		1038

///RKM 4/16/97
#define IDD_SAVE_EXCEL_TIP				1039

///RKM 4/17/97 this is to test the function of the new Excel dialog 
///temporary ID
#define IDD_PLOT_EXCEL_TEST				1040

///RKM 4/20/97 for control of closing multiple windows
#define IDD_WINDOW_CONTROL				1041

///RKM 4/23/97 for saving Excel workbooks

///RKM 4/29/97 for renaming Excel workbooks

///RKM 5/14/97	for when Excel workbooks are removed
#define IDD_EXCEL_SELECT_NEW_SHEET		1044

/// EJP v4.988 05-28-97 T2256 ERROR_BAR_DLG_NEED_DISABLE_DEL_BTN
#define IDD_ERRBAR_DLG                  1045
/// end ERROR_BAR_DLG_NEED_DISABLE_DEL_BTN

////RKM 10/16/97 v6.0 for the new Plot Details 
#define IDD_PLOTDTLS_GROUP              1048
///  GCJ 5/11/98 t3793 IDD_PLOTDTLS_BOXCHART
#define IDD_PLOTDTLS_BOXCHART           1052
/// end IDD_PLOTDTLS_BOXCHART
//#define IDD_PLOTDTLS_BOX                1052
//#define IDD_PLOTDTLS_HISTOGRAM          1053
//#define IDD_PLOTDTLS_WHISKER            1055
///DSC 4/23/98
///#define	IDD_PLOTDTLS_PIE_LABELS			1061
#define IDD_PLOTDTLS_PIE_LABELS_TAB		1061
#define IDD_PLOTDTLS_PIE_SUB_SLICE		1062

/// SFX 1/14/98 v6.00 ADD_PLOTDTLS_ERROR_BAR
/// end ADD_PLOTDTLS_ERROR_BAR

#define IDD_PLOTDTLS_RELATE		1064
/// CPY 3/11/98, we will put area info into line tab
//#define IDD_PLOTDTLS_AREA		1065

///RKM 3/17/98 v6.0 for the color tab of plot details
#define IDD_PLOTDTLS_COLOR		1065

///RKM 3/23/98	ZScale dialog
#define IDD_PLOTDTLS_ZSCALE		1066

/// SFX 6/24/98 v6.0124 ADD_3D_CHOICE_PAGE
/// end ADD_3D_CHOICE_PAGE

/// SFX 6/29/98 v6.0125 SPLIT_BAR_TAB_TO_PATTERN_AND_SPACING
/// end SPLIT_BAR_TAB_TO_PATTERN_AND_SPACING

///	DVT 9/10/98 t4176 v6.0129 DOCKABLE_OUTPUT_LOG
#define	IDD_OUTPUT_LOG_PROPERTY			1069
///	end DOCKABLE_OUTPUT_LOG


/////////////////////////////////////////////
// Layer tabs will appear when a layer icon in the
// Graph Details dialog is selected, the following tabs
// are needed.  These are work similar to Layer Control (v5.0)
#define IDD_LAYER_CONTENTS				1074

/////////////////////////////////////////////////////
//We will eventually delete this dialog, since we have broken
//up the dialog into seperate tabs
#define IDD_LAYER_PROPERTIES			1075

///	DVT	10/21/98 v6.0133 CHANGE_WND_CLOSE_PROMPT
#define IDS_WND_CLOSE_PROMPT			1077
///	end CHANGE_WND_CLOSE_PROMPT

/// EJP 12-10-98 v6.0141 t4176 OUTPUTLOG_VIEWER
/// end OUTPUTLOG_VIEWER

/// SFX 1/13/99 v6.0153 t4101 MOVE_COLOR_TAB_OUT_OF_OPTION_DIALOG
#define IDD_COLOR_PALETTE				1079
/// end MOVE_COLOR_TAB_OUT_OF_OPTION_DIALOG

/////////////////////////////////////////////////////
// Page tabs will appear when the page icon in the
// Graph Details dialog is selected, the following tabs
// are needed. These are work similar to Page Control (v5.0)
//#define IDD_PAGE_COLOR					1083
/// ML 6/21/2000 v6.0293 t7620 PRINT_DIMENSIONS_TAB_FOR_PAGE_ON_PLOTDETAILS_DLG
/// end PRINT_DIMENSIONS_TAB_FOR_PAGE_ON_PLOTDETAILS_DLG

/// SFX 7/22/98 v6.0126 ADD_SYSTEM_COLOR_PAGE
#define IDD_PREF_COLOR					1084
/// end ADD_SYSTEM_COLOR_PAGE

/// YuI 2/27/02 AMPO9180 V7.0222 INCREMENTAL_MANAGER
/// end INCREMENTAL_MANAGER


/// YuI 3/24/04 v7.5846 QA70-6118 NEW_DATA_SELECTOR_TOOL
#define	IDD_SELECT_FROM_LIST_DLG		1086
/// end NEW_DATA_SELECTOR_TOOL

///DSC t3565 3/11/98 MATRIX_ADD_TWO_BYTE_SUPPORT
////////////////////Dialog IDD_MATRIX_SIZE //////////////////////////
#define IDD_MATRIX_SIZE                 1090
///end t3565 3/11/98 MATRIX_ADD_TWO_BYTE_SUPPORT

///RKM 3/17/98  new pClamp dialog
#define IDD_PCLAMP						1091

/// RB 4/6/98 t1393 SORT_DIALOG_BOX
/// end  SORT_DIALOG_BOX

/// RB 7/1/98 t4043 WINDOWS_TAB_IN_OPTIONS_DLG
/// end  WINDOWS_TAB_IN_OPTIONS_DLG

/// RB 12/14/98 v6.0143 t3810 SEL_COL_FOR_PLOT
#define IDD_PLOT_OBJ_EDIT				1094
/// end SEL_COL_FOR_PLOT

///RKM 3/30/98  3D plot details dialog
/// SFX 9/2/98 v6.0128 REDESIGN_SURFACE_TABS
//#define	IDD_PLOTDTLS_3D_SYMBOL		1095
//#define	IDD_PLOTDTLS_3D_ANCHOR		1096
//#define	IDD_PLOTDTLS_3D_SURFACE		1097
//#define	IDD_PLOTDTLS_3D_WIRE		1098
//#define IDD_PLOTDTLS_3D_LINES		1099
/// TD 12-14-05 QA70-8061 PROJECT_AND_PAGE_UNLOCK_PROMPT_USING_POSTED_MESSAGES
#define IDD_PASSWORD_PROMPT             1099
/// end PROJECT_AND_PAGE_UNLOCK_PROMPT_USING_POSTED_MESSAGES
/// SFX 9/2/98 v6.0128 REDESIGN_SURFACE_TABS

/// RB 3/30/99 v6.0178 t5775 REORGANIZE_MATRIX_PROPERTIES_AND_DIMENSIONS_DLGS
#define IDD_MATRIX_DIMENSIONS		1105
/// end REORGANIZE_MATRIX_PROPERTIES_AND_DIMENSIONS_DLGS

///Kyle 12/04/2009 QA80-14451 THUMBNAIL_VIEW_OF_IMAGES_IN_MATRIX_BOOKS
#define			IDD_MATRIX_TOOLBAR			1106
///End THUMBNAIL_VIEW_OF_IMAGES_IN_MATRIX_BOOKS

///	DVT	4/29/98	FIND_WINDOW_IN_FOLDER_TREE
//not yet used
#define IDD_PROJECT_EXPLORER_GOTO	1131
///	end	FIND_WINDOW_IN_FOLDER_TREE

///	DVT	v6.012 5/8/98	DELETE_ALL_WITH_PROMPT_IN_PROJECT_EXPLORER
#define IDD_PROJECT_EXPLORER_DELETE	1132
//#define IDD_PROJECT_EXPLORER_DEL_FOLDER	1133
///	end	DELETE_ALL_WITH_PROMPT_IN_PROJECT_EXPLORER

/// GCJ 8/12/98 v6.0127 t4124 FUNCTION_TAB_IN_PLOTDTLS
/// end FUNCTION_TAB_IN_PLOTDTLS

///EJP 08-21-98 v60128 t4142 OPTION_DLG_INTERFACE_FOR_LABTALK_SYSTEM_FILEEXT
/// SY 12-20-02 QA70-3371 v7.0466 CHANGE_APPLY_TO_ALL_GROUPS
///	#define IDD_FILEEXTGROUP_DEFAULTS		1134
/// end CHANGE_APPLY_TO_ALL_GROUPS
///end OPTION_DLG_INTERFACE_FOR_LABTALK_SYSTEM_FILEEXT

/// GCJ 9/3/98 v6.0128 t3706 COLUMN_VALUES_DIALOG
/// end COLUMN_VALUES_DIALOG
/// GCJ	11/18/98 v6.0140 NEW_SET_MATRIX_VALUES_DIALOG
#define IDD_MATRIX_VALUES               1137
/// end NEW_SET_MATRIX_VALUES_DIALOG

/// SY 12-20-02 QA70-3371 v7.0466 CHANGE_APPLY_TO_ALL_GROUPS
#define IDD_FILEEXTGROUP_DEFAULTS_8		1138
#ifdef ENABLE_FILEEXTGROUP_CHANGE_APPLY_TO_ALL_GROUPS
#define IDD_FILEEXTGROUP_DEFAULTS		IDD_FILEEXTGROUP_DEFAULTS_8
#else // !ENABLE_FILEEXTGROUP_CHANGE_APPLY_TO_ALL_GROUPS
#define IDD_FILEEXTGROUP_DEFAULTS 		IDD_FILEEXTGROUP_DEFAULTS_7
#endif // ENABLE_FILEEXTGROUP_CHANGE_APPLY_TO_ALL_GROUPS
/// end CHANGE_APPLY_TO_ALL_GROUPS

/// ML 12/14/98 COLORMAP_TAB_2
/// end COLORMAP_TAB_2

///Kyle 09/16/2010 ORG-1061-P1 CONTEXT_HELP_FOR_COLOR_MAP_DIALOGS, moved to o8dlg.h
// /// ML 12/16/98 COLORMAP_FILL_DIALOG
// #define	IDD_CMAP_FILL_CELL_DLG			1140
// #define	IDD_CMAP_FILL_DLG				1141
// /// end COLORMAP_FILL_DIALOG
// 
// /// ML 12/25/98 COLORMAP_LINE_DIALOG
// #define	IDD_CMAP_LINE_DLG				1142
// /// end COLORMAP_LINE_DIALOG
///End CONTEXT_HELP_FOR_COLOR_MAP_DIALOGS

/// ML 1/5/99 LABELS_DLG
#define	IDD_CMAP_LABELS_DLG				1143
/// end LABELS_DLG

/// ML 1/6/99 LEVELS_HEADER_DLG
#define	IDD_CMAP_LEVELS_DLG				1144
/// end LEVELS_HEADER_DLG

///Kyle 09/16/2010 ORG-1061-P1 CONTEXT_HELP_FOR_COLOR_MAP_DIALOGS, moved to o8dlg.h
// /// ML 1/7/99 NEW_LINE_HEADING_DLG
// #define	IDD_CMAP_LINEHEADING_DLG		1145
// /// end NEW_LINE_HEADING_DLG
///End CONTEXT_HELP_FOR_COLOR_MAP_DIALOGS

/// ML 1/14/99 CONTOUR_LABEL_DIALOG_TAB
/// end CONTOUR_LABEL_DIALOG_TAB

///Kyle 09/16/2010 ORG-1061-P1 CONTEXT_HELP_FOR_COLOR_MAP_DIALOGS, moved to o8dlg.h
// ///Kyle 02/04/2009 QA70-13017-P1 COLORMAP_IMPROVEMENTS
// #define	IDD_CMAP_LEVELS_DLG2				1147
// ///End COLORMAP_IMPROVEMENTS
///End CONTEXT_HELP_FOR_COLOR_MAP_DIALOGS

/// SY 01-21-2003 QA70-3135 v7.0493 ARRANGE_CUSTOMIZE_TOOLBARS_HELP_ID
// IV's defined value for IDD_USERDEF_MODIFY_BUTTON seems typo error, 
// So I move it to 1153 
///	///IV 11/30/98 v6.0142 t3890 USERDEF_TBBUTTONS                                     
///	#define IDD_USERDEF_MODIFY_BUTTON       148
///	///end  USERDEF_TBBUTTONS
/// end ARRANGE_CUSTOMIZE_TOOLBARS_HELP_ID

//---------------------- CPY v6.0251 1/17/00 t7155 APPEND_PROJ_SHOULD_HAVE_DONT_ASK_AGAIN_CHECKBOX
/////	DVT 1/20/99 v6.0152 t3733 APPEND_PROJECT_CREATES_FOLDER_OPTION
//#define IDD_PROJECT_APPEND_OPTION       1147
/////	end APPEND_PROJECT_CREATES_FOLDER_OPTION
//----------------------

///IV 02/16/99 RENAME_WIND_DLG
///end RENAME_WIND_DLG

///IV 11/17/99 t7001 ADD_DELETE_USER_GROUPS
///end ADD_DELETE_USER_GROUPS

/// ML 1/15/2000 v6.0252 t6867 MULTIPLE_PAGE_GRAPH_PRINTING_UI
#define	IDD_PRINT_GR_OPT_GEOMETRY		1150
/// end MULTIPLE_PAGE_GRAPH_PRINTING_UI

//IV 3/17/2000 RENAME_NOTES_DLG
#define IDD_RENAME_WIND_NOTES           1151
//end RENAME_NOTES_DLG
//IV 2/28/2000 t7308 MODIFY_USER_GROUP
#define IDD_USERDEF_ADD_BUTTON			1152
//end MODIFY_USER_GROUP

/// SY 01-21-2003 QA70-3135 v7.0493 ARRANGE_CUSTOMIZE_TOOLBARS_HELP_ID
/// end ARRANGE_CUSTOMIZE_TOOLBARS_HELP_ID

//IV 6/19/2000, t7996, v6.0291 EXPORT_USERDEF_CATEGORY
//end EXPORT_USERDEF_CATEGORY

//DSC 7/20/00 v6.1006 t8203  REGISTRATION_CHECK_CUSTOMER_ID_VALID
#define IDD_REGISTER_INFO               1157
#define IDD_REGISTER                    1158
//end  REGISTRATION_CHECK_CUSTOMER_ID_VALID
//DSC 11/05/01 v6.9116 t9661  DEMO_TO_STUDENT_INFO_DLG
#define IDD_STUDENT_VERSION_INFO        1159            
//end  DEMO_TO_STUDENT_INFO_DLG

/// SY 11/12/2004 QA70-7066 v8.0163 EXPORT_TOOLBARS_BUTTONS_INTO_OPK
/// end EXPORT_TOOLBARS_BUTTONS_INTO_OPK
/// ML 3/22/2006 QA70-2306 TRICONTOUR_SMOOTHING
/// end TRICONTOUR_SMOOTHING
/// RVD 12/20/2005 QA80-5536 v8.0350 WATERFALL_HIDDEN_REMOVAL
/// end WATERFALL_HIDDEN_REMOVAL

/// YuI 08/03/01 v6.9062 t9355 NEW_PROPERTIES_DIALOG_FOR_GRAPHIC_OBJECTS
/// SY 02/15/2002 QA70-843 HELP_TOPIC_TRANSLATION
#define IDD_NEW_OBJPROPTS_LINE_PAGE		IDD_NEW_OBJPROPTS_BEGIN
/// YuI 11/06/01 v6.90117 t9673 NEW_PAGE_TO_GROBJ_DIALOG
#define IDD_NEW_OBJPROPTS_END			IDD_NEW_OBJPROPTS_IMAGE_PAGE	
/// end HELP_TOPIC_TRANSLATION
/// end NEW_PAGE_TO_GROBJ_DIALOG
/// end NEW_PROPERTIES_DIALOG_FOR_GRAPHIC_OBJECTS
/// YuI 11/22/01 v6.9132 t3342 SYMBOL_MAP_DIALOG
/// end SYMBOL_MAP_DIALOG
/// YuI 01/07/02 v6.178 t9867 NEW_SHORTCUT_HANDLING_IN_TEXT_EDITOR
/// end NEW_SHORTCUT_HANDLING_IN_TEXT_EDITOR

/// RVD 3/15/2005 QA70-7498 v8.0204 XFUNCTION_ANCHORS
#define IDD_NEW_OBJPROPTS_XF_PAGE		1179
/// end XFUNCTION_ANCHORS


#define IDD_WKS_MAT_HEADER_DIALOG_BAR	1181  //CPY 4/20/03 QA70-4278 v7.0565 WKS_HEADER_REGION_CHANGE_PARAM_BUTTON

#define IDD_LIC_FILE_INFO       1185  ///DSC 6/25/02 v7/0327 LICENSE_FILE_DLG

#define IDD_USER_PATH           1186 ///DSC 4/9/03 QA70-4209 v7.0562 USER_CHOOSE_USER_FILES_FOLDER
#define IDD_NODE_LOCKED_INFO    1187 ///DSC 6/04/03 v7.0597 QA70-4602 NODE_LOCKED_INFO_DLG
#define IDD_LIC_BORROW_FLEX     1188 ///DSC 10/15/03 v7.5722 QA70-5339 BORROW_FROM_ORIGIN

#define IDD_DONGLE_LIC_FILE_INFO	1189/// YuI 10/27/03 v7.5733 QA70-4995 DONGLE_SUPPORT_IMPLEMENTATION

///DSC 1/20/2005 QA70-7334 NEW_NODELOCKED_LICENSE_DIALOGS
#define IDD_NODELOCKED_LIC_NEEDED       1190
#define IDD_NODELOCKED_COMPUTER_ID      1191
#define IDD_NODELOCKED_ENTER_LICENSE_TEXT 1192
///DSC 7/10/06 QA70-7334 IMPROVE_NODELOCKED_LIC_DLGS
#define IDD_NODELOCKED_ERROR_MSG        1193
#define IDD_NODELOCKED_GRACE_PERIOD_MSG 1194
///end IMPROVE_NODELOCKED_LIC_DLGS
///end NEW_NODELOCKED_LICENSE_DIALOGS

///DSC 6/30/09 QA70-13824 NEW_LEASED_NODELOCKED_EVALUATION_LIC
#define IDD_EVALUATION_LIC_NEEDED             1196
///end NEW_LEASED_NODELOCKED_EVALUATION_LIC

/// Hong 02/21/11 ORG-2292 OGL_COMBINE_3D_SURFACE_PLOT_TYPE
/// Kenny 07/15/2011 ORG-3219 NEW_GUI_FOR_OGL_SURFACE_PLOT
//#define IDD_PLOTDTLS_MESH_GENERAL		1197
/// End NEW_GUI_FOR_OGL_SURFACE_PLOT
/// end OGL_COMBINE_3D_SURFACE_PLOT_TYPE

#define IDD_END_OU							2511






///-------------- SY 02/15/2002 QA70-843 HELP_TOPIC_TRANSLATION
// all these ids are copy from file c:\c\DDK Tools\Tools.h, this file need clean up later
// will move all help ids to here.
#define IDD_LAYERTOOL_BEGIN				IDD_LAYERTOOL_ADD
#define IDD_LAYERTOOL_END				IDD_LAYERTOOL_ARRANGE

#define IDD_BASELINE_BEGIN				IDD_BASELINE_BASE
#define IDD_BASELINE_END				IDD_BASELINE_AREA

#define IDD_SMOOTH_BEGIN				IDD_SMOOTH_OPERATION
#define IDD_SMOOTH_END					IDD_SMOOTH_SETTINGS

#define IDD_LR_BEGIN					IDD_LR_OPERATION
#define IDD_LR_END						IDD_LR_SETTINGS

#define IDD_PR_BEGIN					IDD_PR_OPERATION
#define IDD_PR_END						IDD_PR_SETTINGS

#define IDD_SR_BEGIN					IDD_SR_OPERATION
#define IDD_SR_END						IDD_SR_SETTINGS

#define IDD_FFTTOOL_BEGIN				IDD_FFTTOOL_OPERATION
#define IDD_FFTTOOL_END					IDD_FFTTOOL_SETTINGS

#define IDD_PRINT_BEGIN					IDD_WKS_PRINT
#define IDD_PRINT_END					IDD_GRAPH_PRINT

#define IDD_PLOTDTLS_BOX_BEGIN			IDD_PLOTDTLS_BOXCHART
#define IDD_PLOTDTLS_BOX_END			IDD_PLOTDTLS_PERCENTILE

#define IDD_CMAP_BEGIN					IDD_PLOTDTLS_COLORMAP_2
#define IDD_CMAP_END					IDD_CMAP_LINEHEADING_DLG

#define IDD_NLSF_WIZARD_BEGIN			IDD_Data			
#define IDD_NLSF_WIZARD_END				IDD_Results
///-------------- end SY 02/15/2002 QA70-843 HELP_TOPIC_TRANSLATION

//------------------ CPY QA70-872 2/16/02 
#define IDD_STAT_SURVIVAL_BEING			IDD_KaplanMeier
#define IDD_STAT_SURVIVAL_END			IDD_CoxPHM

/// the following ids are from 
//-----	\\C\\Sec_Header\\Include\\secres.h, I cannot centralized this, so have to copy them here

//------------------ end CPY QA70-872 2/16/02 

////////////////////////////////////////////////////////////
/////////////////// IDD Section End		 ///////////////
///////				CONSTANT_REORDER			/////////////
////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////
///////////		DIALOGS FROM OKERN96 //////////////////////////
///////////  MOVED FROM OK96RES.H    //////////////////////////
///////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
///////	RKM Begin Dialog Section	4000-4200	/////////////////
///////	CONSTANT_REORDER			///////////////////////////
////////////////////////////////////////////////////////////
#define IDD_BEGIN_OKRES					4000

///HYYU multi open dialog
#define IDD_MULTI_OPEN                  4000

///HYYU ADD_GET_FILE_NAME_DIALOG
#define IDD_GET_FILE_NAME               4001

///HYYU
#define IDD_GET_FOLDER                  4002

/// EJP	11-05-2001 v6.9117 t9518 COPY_PROTECT_MODULES
#define IDD_MODULE_KEY					4003
/// end COPY_PROTECT_MODULES

/// SY 11-09-2001 t9638 ADD_VIEW_SPC_MEMOBJ_DIALOG
#define IDD_COL_ADDITIONAL_INFO_DIALOG  4004
/// end ADD_VIEW_SPC_MEMOBJ_DIALOG

/// SY 04-16-2003 QA70-4183 v7.0563 PLACE_BAR_IN_BROWSE_FOR_FOLDER_DLG
#define IDD_FDLOG_GET_FOLDER			4005
/// end PLACE_BAR_IN_BROWSE_FOR_FOLDER_DLG

///	DVT	23/10/98 v6.0133 t4438 ICONIZED_IN_50_HIDDEN_IN_60_DB
#define IDD_ICONIZED_AS_HIDDEN_PREF		4006
///	end ICONIZED_IN_50_HIDDEN_IN_60_DB

//IV 10/18/99 t1305 SPECIAL_PROMPT_DLG
#define IDD_REMINDER_MSG_BOX    		4007
//end SPECIAL_PROMPT_DLG

#define IDD_MESSAGE_PROMPT_DLG			4008 //7/10/03

#define IDD_REMINDER_MSG_BOX_YES_NO		4009 //----- CPY v7.5656 8/11/03 QA70-4994 SEPARATE_REMINDER_MSG_BOX_FOR_YES_NO

///RKM 4/30/98 Move outl dialogs to Okern96 for EJP
#define IDD_FILE_OPEN					4010
#define IDD_FILE_OPEN_MULTI				4011
#define IDD_EXPORT_ASCII				4012
#define IDD_SAVE_AS						4013
///RKM EXPLORER DIALOG ADD ONS
#define IDD_EXPL_ASCII					4014
#define IDD_EXPL_OPTION					4015
#define IDD_EXPL_SAVE_AS				4016
//IV 11/13/98 IMPLEMENT_FILE_LIST
#define IDD_MULTI_OPEN_FILELIST         4017
//end IMPLEMENT_FILE_LIST

#define IDD_LIC_DEACTIVATE				4019 //--- CPY 7/23/10 ORG-435 LIC_DEACTIVATE_DLG
 
#define IDD_END_OKRES					4200

////////////////////////////////////////////////////////////
///////	RKM End Dialog Section	4000-4200	/////////////////
///////	CONSTANT_REORDER			///////////////////////////
////////////////////////////////////////////////////////////


//IV 2/8/2002 MOVE_DIALOG_IDS_FROM_NLSF
#define FIT_DLG_SELECT_FUNC         23380
#define FIT_DLG_DEF_FUNC            23381
#define FIT_DLG_FIT_SESSION         23382
#define FIT_DLG_SIMULATE            23383
#define FIT_DLG_CONTROL             23384
#define FIT_DLG_RESULTS             23385
#define FIT_DLG_DATASET             23386
#define FIT_DLG_INIT                23387
#define FIT_DLG_NLSF                23388
#define FIT_DLG_CONSTRAINTS         23389
#define FIT_DLG_AFTER_FIT           23390
#define FIT_DLG_DEF_FILE            23391
#define FIT_DLG_ATTSAVE             23392
#define FIT_DLG_ADVOPTIONS          23393
#define FIT_DLG_ABOUT               23394
#define FIT_DLG_SELECT_FUNC2        23395
#define FIT_DLG_SAVE_AS				23396
#define FIT_DLG_FIT_SESSION2        23397
#define FIT_DLG_MSG3                23398
#define FIT_DLG_MSG2                23399
#define FIT_DLG_DATASET2            23400
#define FIT_DLG_MSG1                23401
#define FIT_DLG_DEF_FUNC2           23402
#define	FIT_DLG_EDIT_FUNC			23403
#define	FIT_DLG_ON_PARAM_CHANGE		23405
#define FIT_DLG_PARAM_DISP          23406
#define FIT_DLG_MODIFY_CATEGORY		23407
#define	FIT_DLG_BEFORE_FIT			23408
#define FIT_DLG_CONSTRANT_SMALL		23409 // from Parameter dialog	
//end MOVE_DIALOG_IDS_FROM_NLSF


//----- CPY v7.0220 QA70-883 
#define IDD_DATABASE		23600
//-----
/// end ORIGIN_DIALOG_IDS

/// EJP 2006-01-17 v8.0358 UNIQUE_ID_FOR_HELP_WITH_GETN_BOX
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
///
/// Values 0x8000 to 0x8FFF are being reserved for dialogs and windows that are
/// also being used in OC Trees.
/// The range can increase or decrease as long as existing IDs do not change.
///	This range has also been reserved in DataIDs.h.  If you change the range then
/// please also update DataIDs.h.
///
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
#define IDD_IDST_BEGIN				0x00008000
#define IDD_IDST_END				0x00008FFF
/// end UNIQUE_ID_FOR_HELP_WITH_GETN_BOX

/// AW 09/15/06 QA80-8978 v8.0483 HELP_XF_NAME_LINK_TO_CHM
#define XF_HELP_START_BEGIN			0x00009000    
#define XF_CHM_FILE_NAME			"OXF.chm"
#define XF_HELP_ID_FILE				"XFHelpID"
/// END HELP_XF_NAME_LINK_TO_CHM

//---- CPY 10/26/06 QA70-9063 DYNAMIC_ERR_MSG_IN_GETN_DIALOGS
// universal for all dialog
#define IDC_ERR_MESSAGE_BOX             42
//----


#endif // _HELPID_H_
/// end ORIGIN_ONLINE_HELP

