/*------------------------------------------------------------------------------*
 * File Name: FilePublish.c	 													*
 * Creation: Jasmine 08/15/07													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Folger 08/27/07 ADD_ROWS_ONCE_TO_OPTIMIZE_GRID_SHOW							*
 * Folger 08/27/07 CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY	*
 * Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80							*
 * Folger 08/30/07 MODIFY_NLSF_CODES_TO_SUPPORT_TRANSFER_FILES_FROM_75_TO_80	*
 * Folger 09/03/07 SUPPORT_MORE_FILE_TYPES										*
 * Folger 09/03/07 ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO							*
 * Folger 09/08/07 SUPPORT_PATCH_FILE											*
 * Folger 09/12/07 CHECK_SREVER_LICENSE_TO_SHOW_PROPER_ITEM						*
 * Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR			*
 * Folger 09/14/07 SAVE_USER_COMBO_SELECTION									*
 * Folger 09/14/07 ADD_SET_GROUP_FOLDER_DIALOG									*
 * Folger 09/18/07 CENTRALIZE_GET_SET_CODE_IN_GROUPMGR							*
 * CPY 9/22/2007 QA70-10384 CODE_CLEANUP										* 
 *	CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH			*
 * Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION						*
 * Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE						*
 * Folger 09/28/07 SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION						* 
 * Folger 09/28/07 SPECIFY_POSSIBLE_ERROR_IN_JULIAN_DATE_COMAPARE				*
 * EJP 2007-10-02 v8.0714 QA70-10469 MORE_WORK_FOR_OPX_AND_GROUP_FOLDER			*
 * Folger 10/24/07 FIX_BUG_IN_FILE_MODIFIED_TIME_COMPARE						*
 * Folger 11/14/07 MAP_DIALOG_CHM_HELP											*
 *	Folger 03/20/08 QA80-11192 SUPPORT_DEFAULT_SETTINGS_FILE					*
 *	Folger 06/05/08 OPX_FILE_PUBLISH_SHOULD_IDENTIFY_BY_VERSION_FIRST			*
 *	Folger 09/18/08 QA80-12217 SUPPORT_PUBLISHING_DATABASE_FILES				*
 *	Folger 09/24/08 CORRECT_FILE_TYPES_THAT_NEEDS_LOCALIZED						*
 *	Folger 01/04/09 v8.0993c PACKAGE_FILE_COMPARE_FAILS_IN_GROUP_FOLDER_MANAGER	*
 *	Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER			*
 *	Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL		*
 *	Kyle 08/02/2010 ORG-692-P1 TRANSFER_USER_FILES_HANDLE_DOCX_FILE				*
 *	Kit 8/05/2010 ORG-539-S1 HINT_>>_CAN_NOT_SHOW_IN_GROUP_FOLDER_MANAGER		*
 *	Folger 09/25/2010 ORG-1141-P1 REMEMBER_LAST_SPECIFIED_LOCATION_IN_TRANSFER_UFF
 *	Kyle 10/18/2010 ORG-1253-S1 REDO_POP_REMINDER_MESSAGE_FOR_TRANSFER_USER_FILES_WHEN_STARTING_ORIGIN
 *	Kit 01/04/2011 ORG-1885-S1 SUPPORT_TEXT_FILE_IN_TRANSFER_USER_FILES			*
 *	Kit 01/26/2011 ORG-2126-S1 USE_MOVE_LEFT_OR_RIGHT_BITMAP_BTN_INSTEAD_SIMPLE_BTN
 *	Kit 01/30/2011 ORG-2126-S2 ADD_CURRENT_FILE_PATH_INFO						*
 *	Kit 01/31/2011 ORG-2126-S2 USE_FILE_NAME_AS_FIST_COL_NAME					*
 *	Kit 02/11/2011 ORG-2126-S1 MOVE_PUBLIC_BTN_IN_THE_MIDDLE_OF_TWO_PANNEL		*
 *	Kit 02/11/2011 ORG-2126-S1 MAKE_CTRL_LOOK_WELL_BOTH_IN_XP_AND_WIN7			*
 *	Kit 02/11/2011 ORG-2126-S2 UPDATE_FOLDER_PATH_WHEN_CHANGE_LOCATION			*
 *	Kit 02/17/2011 ORG-2126-P2 SET_FILE_TYPE_COL_AS_STRING_DATA_FOR_SORT		*
 *	Kit 02/17/2011 ORG-2126-P4 SET_ROW_COLOR_WHEN_PUBLISH_FILES					*
 *	Kit 02/17/2011 ORG-2126-S6 SUPPORT_DOUBLE_CLICK_TO_PUBLISH_FILES			*
 *	Kit 02/21/2011 ORG-2126-P2 MAKE_MODIFIED_DATE_COLUMN_CAN_SORT				*
 *	Kit 03/30/2011 ORG-2126-P2 SUPPORT_COLUMN_SHORT_DATE_SORT					*
 *	Folger 03/31/2011 OPEN_FOLDER_HINT_NOT_FULLY_DISPLAY_IN_J					*
 *	Kit 10/08/2011 ORG-3938-P2 IMPORVE_UFF_TRANSFER_DEFAULT_FILE_TYPE			*
 *	Folger 12/09/2011 ORG-4362-P9 COPY_CLIENTUPDATE_EXE_AFTER_PUBLISH_FILES		*
 *	Kit 01/10/2012 ORG-4069-P4 OPK_FILE_COLOR_SHOWN_IS_NOT_CORRECT_AFTER_PUBLISH*
 *	Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN		*
 *	Tony 07/18/2012 ORG-5952-S1 FIX_FITTING_FUNCTIONS							*
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include "DialogEx.h" 
#include "FilePublish.h"
#include "INIFileEx.h"				//------ Folger 09/14/07 ADD_SET_GROUP_FOLDER_DIALOG
#include "MenuBase.h"				///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
#include <ocu.h>
#include "GroupFolderManager.h"

#define STR_DLG_NAME						_L("Group Folder Manager")
#define STR_DLG_NAME_TRANSFER_USER_FILES	_L("Transfer User Files")	//------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
#define STR_COL_STATUS						_L("Status")

#define COLOR_GRAY							RGB(200,200,200)

///-----Kit 01/28/2011 ORG-2126-S5 COLOR_HINT_USE_COLOR_TO_SHOW
//#define STR_COLOR_EXPLAINATION	_L("Red : newer \t Green : older \t Blue : identical")
#define	COLOR_DARKGREEN						RGB(0, 100, 0)
#define	STR_COLOR_HINT_RED					_L("Red : newer")
#define	STR_COLOR_HINT_GREEN				_L("Green : older")
#define	STR_COLOR_HINT_BLUE					_L("Blue : identical")

///-----Kit 01/28/2011 ORG-2126-S3 ADD_HINT_TO_TELL_HOW_TO_OPEN_FOLDER
#define STR_OPEN_FOLDER_HINTS				_L("Right click on a file to go to the folder containing that file.\n")
///-----
///-----Kit 01/30/2011 ORG-2126-S2 ADD_CURRENT_FILE_PATH_INFO
//#define STR_OPEN_FOLDER_TITLE	_L("Open")

#define STR_OLD_VERSION						_L("Older version")
#define	STR_CURRENT_VERSION					_L("Current version")
#define STR_USER_FOLDER						_L("User folder")
#define STR_GROUP_FOLDER					_L("Group folder")
///-----
//------ Folger 09/03/07 ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO
#define STR_SECTION							"UpdateInfo"
#define STR_VERSION							"version"
#define STR_IS_PUBLISHED					"IsPublished"
//------ End ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO

#define STR_LAST_SELECTION					"LastSelection"			//------ Folger 09/14/07 SAVE_USER_COMBO_SELECTION

#define STR_SPECIFIED_FOLDER				_L("Specified Folder")		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

///------ Folger 09/25/2010 ORG-1141-P1 REMEMBER_LAST_SPECIFIED_LOCATION_IN_TRANSFER_UFF
#define	STR_LAST_SPECIFIED_LOCATION			"LastLocation"
#define	STR_OLD_VERSION_KEY					"OldVersion"
///------ End REMEMBER_LAST_SPECIFIED_LOCATION_IN_TRANSFER_UFF

//------ Folger 09/24/08 CORRECT_FILE_TYPES_THAT_NEEDS_LOCALIZED
/*
//------ Folger 09/28/07 SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
////------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
//#define STR_FILE_TYPE_COMBO				_L("#0;Analysis Templates|#1;Dialog Themes|#2;Fitting Functions|#3;Import Filters|#4;LabTalk Scripts Files|#5;OriginC Files|#6;Page Templates|#7;Patches|#8;Project Files|#9;Window Themes|#10;XFunctions|#11;Other Files")
////------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
#ifdef SUPPORT_PACKAGE_FILES
#define STR_FILE_TYPE_COMBO				_L("#0;Analysis Templates|\
											#1;Dialog Themes|\
											#2;Fitting Functions|\
											#3;Import Filters|\
											#4;LabTalk Scripts Files|\
											#5;Database Files|\
											#6;OriginC Files|\
											#7;Package Files|\
											#8;Page Templates|\
											#9;Patches|\
											#10;Project Files|\
											#11;Window Themes|\
											#12;XFunctions|\
											#13;Default Settings|\
											#14;Other Files")
#else
#define STR_FILE_TYPE_COMBO				_L("#0;Analysis Templates|\
											#1;Dialog Themes|\
											#2;Fitting Functions|\
											#3;Import Filters|\
											#4;LabTalk Scripts Files|\
											#5;Database Files|\
											#6;OriginC Files|\
											#7;Page Templates|\
											#8;Patches|\
											#9;Project Files|\
											#10;Window Themes|\
											#11;XFunctions|\
											#12;Default Settings|\
											#13;Other Files")
#endif
//------ End SUPPORT_PACKAGE_FILES_IN_COMBO_SELECTION
*/
///-----Kit 01/27/2011 ORG-2126-P1 SHOULD_NOT_SHOW_FITE_TYPE_COMBO_BOX
/* move to FilePublish.h
#define		STR_FILE_TYPE_OGW				_L("Analysis Templates")
#define		STR_FILE_TYPE_DIALOG_THEME		_L("Dialog Themes")
#define		STR_FILE_TYPE_FDF				_L("Fitting Functions")
#define		STR_FILE_TYPE_IMPORT_FILTER		_L("Import Filters")
#define		STR_FILE_TYPE_OGS				_L("LabTalk Scripts Files")
#define		STR_FILE_TYPE_DATABASE			_L("Database Files")
#define		STR_FILE_TYPE_ORIGINC			_L("OriginC Files")
//#ifdef SUPPORT_PACKAGE_FILES				///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
#define		STR_FILE_TYPE_PACKAGE			_L("Package Files")
//#endif										///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
#define		STR_FILE_TYPE_TEMPLATE			_L("Page Templates")
#define		STR_FILE_TYPE_PATCH				_L("Patches")
#define		STR_FILE_TYPE_PROJECT			_L("Project Files")
#define		STR_FILE_TYPE_THEME				_L("Window Themes")
#define		STR_FILE_TYPE_XF				_L("X-Functions")
///------ Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
//#ifdef		__SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
#define		STR_FILE_TYPE_OMC				_L("Menu Customization Files")
//#endif		/// __SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER__		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
///------ Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER

#define		STR_FILE_TYPE_DEFAULT_SETTINGS	_L("Default Settings")
#define		STR_FILE_TYPE_TEXT_FILE			_L("Column Formula")				///-----Kit 01/04/2011 ORG-1885-S1 SUPPORT_TEXT_FILE_IN_TRANSFER_USER_FILES
#define		STR_FILE_TYPE_OTHER_FILE		_L("Other Files")
*/
///-----End SHOULD_NOT_SHOW_FITE_TYPE_COMBO_BOX
 //------ End CORRECT_FILE_TYPES_THAT_NEEDS_LOCALIZED

///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
/*
enum
{
	COL_FILE,
	COL_FILESIZE,
	COL_FILEDATE,
	COL_CATEGORY,
	COL_FILETYPE,		//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
	COL_STATUS,
	COL_NUMS,
};
*/
///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

///-----Kit 09/27/2011 ORG-3938	REFACTOR_CODE
// move to GroupFolderManager.h
///-----Kit 09/27/2011 :	I have move class FileListControl declaration to GroupFolderManager.h
//							And for the code clean, I also remove some code mark
//							if you need them, please get the old version from sos
/************************************************************************/
/* FileListControl
/************************************************************************/
enum
{
	FILE_DATE_OLD 	= -1,
	FILE_DATE_EQUAL,
	FILE_DATE_NEW,
	FILE_NEW,
};

FileListControl::FileListControl(int nID, WndContainer &dlg, bool bSource, FilePublishBase *pFilePublish)
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
{
	m_pFilePublish = pFilePublish;
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	//m_nPath = nPath;
	//m_bGroupMgr = bGroupMgr;		//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
	m_bSource = bSource;
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	Init(nID, dlg);
	UpdateList();
}

void FileListControl::Init(int nID, WndContainer &dlg)
{
	GridListControl::Init(nID, dlg);
	SetAllowSelection(true);
	SetSelection(flexSelectionListBox);
	SetEditable();

	m_flx.ExplorerBar = flexExSortShow;


	vector<string> vsColHeading;
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	//int nSize = m_pFilePublish->GetColNames(vsColHeading, m_nPath);
	int nSize = m_pFilePublish->GetColNames(vsColHeading, m_bSource);
	m_pFilePublish->GetShownInfo(m_vbShow);
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	SetupRowsCols(1, 0,  -1, nSize + 1);
	for (int ii=0; ii<nSize; ii++)
		SetColHeading(ii, vsColHeading[ii]);
	SetupColTypes();						///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

	m_nColStatus = nSize;
	SetColHeading(m_nColStatus, STR_COL_STATUS);

	m_vbShow.Add(false);			// status
	ShowCols(m_vbShow);
	ResizeCols();
	SetReady();
}

void FileListControl::UpdateList()
{
	ClearAll();
	vector<string> vsFiles;
	m_pFilePublish->GetFiles(m_bSource, vsFiles);
	AddRowsFromFileNames(vsFiles);
}

int FileListControl::AddRowsFromFileNames(const vector<string> &vsFiles)
{
	int nSize = vsFiles.GetSize();
	if ( 0 == nSize )
		return 0;

	int nRowOffset = GetRowOffset();
	int nColOffset = GetColOffset();
	vector<string> vsVals;
	///-----Kit 1025/2011 ORG-4062-P2 GET_WRONG_FILE_FULL_PATH_LEAD_TO_GET_FILE_MODIFY_TIME_WRONG
	//GetColValues(nColOffset + FB_COL_FILE, vsVals, nRowOffset);

	//{
	//	vector<string> vsCates;
	//	GetColValues(nColOffset + FB_COL_CATEGORY, vsCates, nRowOffset);

	//	_insert_string_in_vector(vsVals, vsCates);
	//}
	GetFilesWithSubCategory(vsVals);
	///-----End GET_WRONG_FILE_FULL_PATH_LEAD_TO_GET_FILE_MODIFY_TIME_WRONG

	vector<string> vsRowInfo;
	getRowInfoByFilesName(vsFiles, vsVals, vsRowInfo);

	AddRows(vsRowInfo);		//------ Folger 08/27/07 ADD_ROWS_ONCE_TO_OPTIMIZE_GRID_SHOW

	ResizeCols();

	return nSize;
}

int FileListControl::AddRows(const vector<string> &vsRowsInfo)
{
	// PS: use m_flx.SetTableValue() is more efficiency
	int nNumRows = vsRowsInfo.GetSize()/FB_COL_NUMS;
	if(nNumRows <= 0)
	{
		ASSERT(vsRowsInfo.GetSize() <= 0);
		return false;
	}

	int nNumCols = FB_COL_NUMS;
	int nStartRow = GetRows();
	int nStartCol = FB_COL_FILE;
	SetRows(GetNumRows() + nNumRows);

	if(!m_flx.SetTableValue( &vsRowsInfo, nNumRows, nNumCols, nStartRow, nStartCol, true))
	{
		ASSERT(false);
		return false;
	}

	const int nEndRow = nStartRow + nNumRows;
	for(int ii = nStartRow; ii < nEndRow; ii++)
	{
		SetRowProperties(ii, FILE_DATE_EQUAL);
	}

	return true;
}

int FileListControl::FilterSelected(vector<string> &vsFiles, bool bFilterOlder /*= false*/, vector<bool>* pvbOlder /*= NULL*/)
{
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	vsFiles.SetSize(0);
	if(pvbOlder)
		pvbOlder->SetSize(0);
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	vector<uint> vnSelected;

	GetSelRows(vnSelected);
	int nSize = vnSelected.GetSize();
	int nRowOffset = GetRowOffset();
	int nColOffset = GetColOffset();

	for (int ii=0; ii<nSize; ii++)
	{
		int nFileStatus = atoi(GetCell(vnSelected[ii], nColOffset + m_nColStatus));
		///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL, only filter out the identical files, support moving older files from 7.5 to 8.1 ect
		//if (nFileStatus > FILE_DATE_EQUAL)
		if (nFileStatus != FILE_DATE_EQUAL && (!bFilterOlder || nFileStatus > FILE_DATE_EQUAL) )
			///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		{
			string strVal = GetCell(vnSelected[ii], nColOffset + FB_COL_CATEGORY) + GetCell(vnSelected[ii], nColOffset + FB_COL_FILE);

			vsFiles.Add(strVal);
			///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
			if(pvbOlder)
				pvbOlder->Add(nFileStatus < FILE_DATE_EQUAL);
			///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
		}
	}

	return vsFiles.GetSize();
}

int FileListControl::GetSelFiles(vector<string> &vsFiles)
{
	vector<uint> vnSelected;

	GetSelRows(vnSelected);
	int nSize = vnSelected.GetSize();
	int nColOffset = GetColOffset();

	for (int ii=vnSelected.GetSize()-1; ii>=0; ii--)
	{
		//string strVal = 
		vsFiles.Add(GetCell(vnSelected[ii], nColOffset + FB_COL_CATEGORY) + GetCell(vnSelected[ii], nColOffset + FB_COL_FILE));
	}

	return vsFiles.GetSize();
}

int FileListControl::RemoveSelRows(const vector<string> &vsFiles)
{
	int nRowOffset = GetRowOffset();
	int nColOffset = GetColOffset();
	int nRow = GetSelectedRow();
	
	///-----Kit 1025/2011 ORG-4062-P2 GET_WRONG_FILE_FULL_PATH_LEAD_TO_GET_FILE_MODIFY_TIME_WRONG
	//GetColValues(nColOffset + FB_COL_FILE, vsVals, nRowOffset);
	//
	//{
	//	vector<string> vsCates;
	//	GetColValues(nColOffset + FB_COL_CATEGORY, vsCates, nRowOffset);
	//	_insert_string_in_vector(vsVals, vsCates);
	//}
	vector<string> vsVals;
	GetFilesWithSubCategory(vsVals);
	///-----End GET_WRONG_FILE_FULL_PATH_LEAD_TO_GET_FILE_MODIFY_TIME_WRONG

	for ( int ii=0; ii < vsFiles.GetSize(); ii++ )
	{
		ASSERT(vsFiles[ii].GetNumTokens('\\') == vsVals[ii].GetNumTokens('\\'));
		const int nIndex = vsVals.Find(vsFiles[ii]);
		if (nIndex >= 0)
		{
			DeleteRow(nRowOffset + nIndex);
		}
	}

	selectRow(nRow);
	return vsFiles.GetSize();
}

void FileListControl::RestoreItemsStatus(const vector<string> &vsFiles, bool bPublish /*= true*/)
{
	const int nSize = vsFiles.GetSize();
	const int nRowOffset = GetRowOffset();
	const int nColOffset = GetColOffset();
	vector<string> vsVals;

	///-----Kit 1025/2011 ORG-4062-P2 GET_WRONG_FILE_FULL_PATH_LEAD_TO_GET_FILE_MODIFY_TIME_WRONG
	//GetColValues(nColOffset + FB_COL_FILE, vsVals, nRowOffset);
	//
	//{
	//	if(m_pFilePublish->IsSrcPathSpecified())			// can not get category info from gui
	//	{
	//		const int count = vsVals.GetSize() - 1;
	//		for(size_t nFile = 0; nFile < count; ++nFile)		// all file type
	//		{
	//			string strCategory = m_pFilePublish->GetDestCategory(vsVals[nFile]);
	//			if( !strCategory.IsEmpty() )
	//				vsVals[nFile] = strCategory + vsVals[nFile];
	//		}
	//	}
	//	else
	//	{
	//		vector<string> vsCates;
	//		GetColValues(nColOffset + FB_COL_CATEGORY, vsCates, nRowOffset);
	//		_insert_string_in_vector(vsVals, vsCates);
	//	}
	//}
	GetFilesWithSubCategory(vsVals);
	///-----End GET_WRONG_FILE_FULL_PATH_LEAD_TO_GET_FILE_MODIFY_TIME_WRONG

	for (int ii = 0; ii < nSize; ii++ )
	{
		///-----Kit 1025/2011 ORG-4062-P2 GET_WRONG_FILE_FULL_PATH_LEAD_TO_GET_FILE_MODIFY_TIME_WRONG
		//const int nIndex = vsVals.Find(vsFiles[ii]);
		ASSERT(vsVals[ii].GetNumTokens('\\') == vsFiles[ii].GetNumTokens('\\'));	// this ASSERT() mean, if vsVals[ii] has sub category, vsFiles must have the same category
		const int nIndex = vsVals.Find(vsFiles[ii]);
		///-----End GET_WRONG_FILE_FULL_PATH_LEAD_TO_GET_FILE_MODIFY_TIME_WRONG
		if (nIndex >= 0)
		{
			if (bPublish)
			{
				SetRowProperties(nRowOffset + nIndex, FILE_DATE_EQUAL);
				SetIsSelected(nRowOffset + nIndex, false);
			}
			else
			{
				SetRowProperties(nRowOffset + nIndex, FILE_NEW);
			}
			//------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
		}
	}
}

int FileListControl::GetColStatus()
{
	return m_nColStatus;
}
//set cell color of COL_FILE, and value of col m_nColStatus
void FileListControl::SetRowProperties(int nRow, int nFileStatus)
{
	int nColOffset = GetColOffset();
	int nColor;
	switch (nFileStatus)
	{
	case FILE_DATE_EQUAL:
		nColor = COLOR_BLUE;
		break;
	case FILE_NEW:
		nColor = COLOR_BLACK;
		break;
	default:
		break;
	}

	SetRowColor(nRow, nColor, -1, true);
	SetCell(nRow, nColOffset + m_nColStatus, nFileStatus);
}

///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
void FileListControl::OnMouseMove(Control cntrl, short nButton, short nShift, float X, float Y)
{
	int nRow, nCol;
	if(!GetMouseCell(nRow, nCol)) 
		return;

	string strTooltips;
	if( 0 <= nRow && nRow < GetRowOffset() )
	{
		strTooltips = m_bSource ? m_pFilePublish->GetSrcPath() : m_pFilePublish->GetDestPath();
	}
	SetToolTipsText(strTooltips);
}

///------ Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
//void FileListControl::OnBeforeMouseDown(short nButton, short nShift, float X, float Y, BOOL* pCancel)
void FileListControl::ShowMenu(int nx, int ny)
///------ End CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
{
	///------ Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	//if(nButton != MK_RBUTTON || nShift != 0)
	//	return;
	///------ End CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN

	int nRow = m_flx.MouseRow;
	int nCol = m_flx.MouseCol;
	if(nCol < 0)
		return;

	vector<uint> vnRows;
	GetSelRows(vnRows);
	if( nRow >= GetRowOffset() )
	{
		vector<uint> vec;
		if( vnRows.Find(vec, nRow) <= 0)
		{
			SelRow(nRow);
			vnRows.SetSize(1);
			vnRows[0] = nRow;
		}
	}
	else
	{
		RemoveSelection();
		vnRows.SetSize(0);
	}
	if(vnRows.GetSize() > 1)
		return;

	bool bSelection = vnRows.GetSize() > 0;

	MenuBase MyMenu;
	string strMenuText = bSelection ? _L("Open Containing Folder") : _L("Open Folder");
	MyMenu.Add(strMenuText, MenuBase::OnMenuItem, MF_STRING);

	///------ Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	//int    nx = XTwipsToPixels(X);
	//int    ny = YTwipsToPixels(Y);
	//ClientToScreen(nx, ny);
	///------ End CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN

	int nRet = MyMenu.DoTrackPopup(nx, ny, GetDlgSafeHwnd());
	if( nRet >= 0 )
	{
		string strFullPathFile;
		if(bSelection)
		{
			string 	strSrcFullPathFile, strDestFullPathFile;
			strSrcFullPathFile = strDestFullPathFile = GetCell(vnRows[0], GetColOffset() + FB_COL_CATEGORY) + GetCell(vnRows[0], GetColOffset() + FB_COL_FILE);
			m_pFilePublish->GetFileFullPath(strSrcFullPathFile, strDestFullPathFile);
			strFullPathFile = m_bSource ? strSrcFullPathFile : strDestFullPathFile;
		}
		else
		{
			strFullPathFile = m_bSource ? m_pFilePublish->GetSrcPath() : m_pFilePublish->GetDestPath();
		}
		okutil_open_os_explorer(strFullPathFile);
	}
}
///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

///-----Kit 1025/2011 ORG-4062-P2 GET_WRONG_FILE_FULL_PATH_LEAD_TO_GET_FILE_MODIFY_TIME_WRONG
int		FileListControl::GetFilesWithSubCategory(vector<string> &vsFileNamesWithSubCate)
{
	GetColValues(GetColOffset() + FB_COL_FILE, vsFileNamesWithSubCate, GetRowOffset());

	///-----Kit 10/25/2011 : Now no need to check if it's a specified path
	///						 Because I have add all the category's info in user file list control's FB_COL_CATEGORY column
	//if ( !m_pFilePublish->IsSrcPathSpecified() )			// can not get category info from gui

	vector<string> vsCates;
	GetColValues(GetColOffset() + FB_COL_CATEGORY, vsCates, GetRowOffset());
	_insert_string_in_vector(vsFileNamesWithSubCate, vsCates);
	return vsFileNamesWithSubCate.GetSize();
}
///-----End GET_WRONG_FILE_FULL_PATH_LEAD_TO_GET_FILE_MODIFY_TIME_WRONG

///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
void	FileListControl::SetupColTypes()
{
	int nCol;
	for(nCol = 0; nCol < m_flx.Cols; nCol++)
	{
		switch(nCol)
		{
		case FB_COL_FILE:
		case FB_COL_CATEGORY:
		case FB_COL_FILETYPE:///-----Kit 02/17/2011 ORG-2126-P2 SET_FILE_TYPE_COL_AS_STRING_DATA_FOR_SORT
			SetColDataType(nCol, flexDTString);
			break;
		case FB_COL_FILEDATE:///-----Kit 02/21/2011 ORG-2126-P2 MAKE_MODIFIED_DATE_COLUMN_CAN_SORT
			SetColDataType(nCol, flexDTDate);
			SetColFormat(nCol, COL_DATE_FORMAT_TYPE_ShortDate);
			break;
		case FB_COL_FILESIZE:
			SetColDataType(nCol, flexDTLong);
			break;
		default:
			break;
		}
	}		
}
///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

void FileListControl::selectRow(int nRow /*= -1*/)
{
	if(GetRows() <= 0)
		return;

	while(nRow >= GetRows())
		nRow--;

	if(nRow < 0)
		nRow = GetSelectedRow(); // get 1st if multiple selection, -1 if none selected
	if( nRow < 0 )
		nRow = 0;

	if (nRow != 0) SelRow(nRow);	
}

///-----Kit 01/27/2011 ORG-2126-P1 SPEED_UP_SHOW_FILE_IN_BOTH_GRID_CTRL
bool	FileListControl::getRowInfoByFilesName(const vector<string> &vsFiles, const vector<string> &vsColVals, vector<string> &vsRowInfo)
{
	for (int ii=0; ii<vsFiles.GetSize(); ii++)
	{
		int nIndex = vsColVals.Find(vsFiles[ii]);
		if (nIndex < 0)
		{
			vector<string> vsTmp;
			m_pFilePublish->GetRowInfo(vsFiles[ii], vsTmp, m_bSource);
			vsRowInfo.Append(vsTmp);
		}
		else
		{
			SetRowProperties(nIndex + GetRowOffset(), FILE_DATE_EQUAL);
		}
	}

	return true;
}
///-----End SPEED_UP_SHOW_FILE_IN_BOTH_GRID_CTRL

//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
//enum
//{
	////------ Folger 09/14/07 REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
	////FILE_TYPE_TEMPLATE,
	////FILE_TYPE_IMPORT_FILTER,
	////FILE_TYPE_FDF,
	////FILE_TYPE_OGS,
	////FILE_TYPE_THEME,
	//////------ Folger 09/03/07 SUPPORT_MORE_FILE_TYPES
	////FILE_TYPE_PROJECT,
	////FILE_TYPE_ORIGINC,
	//////------ End SUPPORT_MORE_FILE_TYPES
	////FILE_TYPE_XF,
	////FILE_TYPE_PATCH,	//------ Folger 09/08/07 SUPPORT_PATCH_FILE
	//
	//FILE_TYPE_OGW,
	//FILE_TYPE_DIALOG_THEME,
	//FILE_TYPE_FDF,
	//FILE_TYPE_IMPORT_FILTER,
	//FILE_TYPE_OGS,
	//FILE_TYPE_ORIGINC,
	//FILE_TYPE_TEMPLATE,
	//FILE_TYPE_PATCH,
	//FILE_TYPE_PROJECT,
	//FILE_TYPE_THEME,
	//FILE_TYPE_XF,
	//FILE_TYPE_OTHER_FILE,
	////------ End REARRANGE_DROP_DOWN_LIST_ITEMS_SUGGESTED_BY_EASWAR
//};
//------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION

//------ Folger 06/05/08 OPX_FILE_PUBLISH_SHOULD_IDENTIFY_BY_VERSION_FIRST
enum		// dwSpecialFileType
{
	SPECIAL_FILE_TYPE_PACKAGE		=	0x00000001,
};
//------

///------ Folger 01/04/09 v8.0993c PACKAGE_FILE_COMPARE_FAILS_IN_GROUP_FOLDER_MANAGER
static	bool	_is_opx_file(LPCSTR lpcszFile)
{
	string		strOPXExt = STR_PACKAGE_80_EXT;
	string		strExt;
	separate_file_name_ext(lpcszFile, NULL, &strExt);
	return strOPXExt.CompareNoCase("." + strExt) == 0 ? true : false;
}
///------ End PACKAGE_FILE_COMPARE_FAILS_IN_GROUP_FOLDER_MANAGER

///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

static string _registry_key_to_version(LPCSTR lpcszRegKey)
{
	// Assuming the string in format "Origin %fJunk", the version %f is 7.5, 8 or 8.1
	string strVersion(lpcszRegKey);
	strVersion = strVersion.GetToken(1, ' ');
	strVersion.TrimLeft();
	
	for(int ii=0; ii<strVersion.GetLength(); ii++)
	{
		if(strVersion[ii] != '.' && (strVersion[ii] < '0' || strVersion[ii] > '9') )
		{
			strVersion = strVersion.Left(ii);
			break;
		}
	}
	return strVersion;
}

static int _check_get_old_version_origin_registry_key(vector<string>& vsVersionKeys)
{
	vsVersionKeys.SetSize(0);

	///Kyle 10/18/2010 ORG-1253-S1 REDO_POP_REMINDER_MESSAGE_FOR_TRANSFER_USER_FILES_WHEN_STARTING_ORIGIN
	/*
	Registry reg(HKEY_CURRENT_USER);
	string strMainKey = STR_ORIGIN_REGISTRY_KEY;
	vector<string> vsKeys;
	if(!reg.EnumKey( vsKeys, strMainKey))
		return vsVersionKeys.GetSize();

	string strKey, strUserPath, strVersion;
	vector vdVersions;
	for(int ii=0; ii<vsKeys.GetSize(); ii++)
	{
		strVersion = _registry_key_to_version(vsKeys[ii]);
		double dVersion = atof(strVersion);
		if(dVersion == NANUM || dVersion >= CURRENT_VERSION)
			continue;
		if(get_origin_user_path(strUserPath, vsKeys[ii], true) )
		{
			vsVersionKeys.Add(vsKeys[ii]);
			vdVersions.Add(dVersion);
		}
	}
	// sort by versions
	vector<uint> vnIndex;
	vdVersions.Sort(SORT_ASCENDING, TRUE, vnIndex);
	vsVersionKeys.Reorder(vnIndex);
	*/
	vector vdVersions;
	okutil_get_installed_origins(&vdVersions, &vsVersionKeys, NULL, NULL, GETINSTALLEDORG_SORT_BY_VERSION | GETINSTALLEDORG_OLDER_VERSIONS);
	///End REDO_POP_REMINDER_MESSAGE_FOR_TRANSFER_USER_FILES_WHEN_STARTING_ORIGIN

	return vsVersionKeys.GetSize();
}

///-----Kit 01/30/2011 ORG-2126-S2 ADD_CURRENT_FILE_PATH_INFO
static bool _cut_the_file_path(string &strPath, int nMinChar = 8)
{
	if(strPath.GetLength() <= nMinChar)
		return false;
	
	string strCutPath = strPath.Mid(0, nMinChar);
	strCutPath += "...";
	strPath = strCutPath;
	
	return true;
}
///-----End ADD_CURRENT_FILE_PATH_INFO

class CategoryListMenu : public MenuBase
{
public:
	CategoryListMenu(const vector<string>& vsCategoryes)
	{
		for(int ii=0; ii<vsCategoryes.GetSize(); ii++)
			Add(vsCategoryes[ii], OnMenuItem);
	}
};

class UseEllipsisCutTextHelper
{
public:
	bool GetText(const DeviceContext &dc, int nWidthAfterCut, string &strText)
	{
		if(strText.IsEmpty() || nWidthAfterCut <= 0)
			return false;
		
		return editText(dc, nWidthAfterCut, strText);
	}
private:
	// this algorithm can be improve, such as use binary chop
	bool editText(const DeviceContext &dc, int nWidth, string &strText)
	{
		int nPathLen = strText.GetLength();
		for(int ii = nPathLen-1; ii >= 0; ii--)
		{
			SIZE szPath;
			szPath = dc.GetTextExtent(strText);
			if(szPath.cx <= nWidth)
				break;
			
			strText.Delete(ii);
		}
		
		return nPathLen != strText.GetLength();
	}
};

/************************************************************************/
/*  FilePublishDlg
/************************************************************************/
FilePublishDlg::FilePublishDlg(bool bGroupMgr /*= true*/) 
	: ResizeDialog(IDD_FILE_PUBLISH_DLG, "ODlg8")
{
	m_bGroupMgr = bGroupMgr;		//------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
	m_strSpecifiedPath.Empty();			///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL, spicified folder empty by default, will keep last selection while running

	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	m_bFilterOlder = OM_RETURN_NO==OptionalMessageStatus("FBReplaceNewerWithOlder");
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
}

FilePublishDlg::~FilePublishDlg()
{
	NICE_SAFE_REMOVAL(m_pFilePublish);
}

int FilePublishDlg::DoModalEx(HWND hWndParent /*= NULL*/)
{
	InitMsgMap();
	int nRet = ResizeDialog::DoModal(hWndParent);		
	return nRet;
}

BOOL FilePublishDlg::OnInitDialog()
{
	Text = m_strDlgName = m_bGroupMgr ? STR_DLG_NAME : STR_DLG_NAME_TRANSFER_USER_FILES;
	ResizeDialog::OnInitDialog();

	SetInitReady();		//------ Folger 09/18/07 CENTRALIZE_GET_SET_CODE_IN_GROUPMGR

	m_btnOK = GetItem(IDC_FP_OK_BTN);

	
	InitRadioBitmapButton(IDC_FP_PUBLISH_BTN, IDB_ARROW_RIGHT);///-----Kit 01/26/2011 ORG-2126-S1 USE_MOVE_LEFT_OR_RIGHT_BITMAP_BTN_INSTEAD_SIMPLE_BTN

	string strShowTip;
	ocu_load_err_msg_str( MSG_SHOW_TIP_ON_LEFT_PANEL, strShowTip );
	GetItem(IDC_FP_PUBLISH_BTN).SetToolTip( strShowTip );

	if( m_bGroupMgr )
	{
		InitRadioBitmapButton(IDC_FP_GET_BACK_BTN, IDB_ARROW_LEFT);	///-----Kit 01/26/2011 ORG-2126-S1 USE_MOVE_LEFT_OR_RIGHT_BITMAP_BTN_INSTEAD_SIMPLE_BTN
		ocu_load_err_msg_str( MSG_SHOW_TIP_ON_RIGHT_PANEL, strShowTip );
		GetItem(IDC_FP_GET_BACK_BTN).SetToolTip( strShowTip );
	}

	GetItem(IDC_FP_GROUP_BTN).Visible = false;
	initHintCtrl();

	initFileTypeCombo();
	initDestCategoryCombo();			// hidden by default

	if(m_bGroupMgr)
	{
		// Old Version Controls
		GetItem(IDC_FP_VERSION_STATIC).Visible = false;
		GetItem(IDC_FP_VERSION_COMBO).Visible = false;
		GetItem(IDC_FP_VERSION_SPECIFY).Visible = false;

		INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + STR_UPDATE_INI_FILE);
		int nIsPublished = iniFile.ReadInt(STR_SECTION, STR_IS_PUBLISHED, -1);
		m_btnOK.Text = _L("Publish");
		m_btnOK.Enable = !nIsPublished;

		OnComboChange(m_FileTypeCombo);
	}
	else
	{
		GetItem(IDC_FP_GET_BACK_BTN).Visible = false;
		GetItem(IDC_FP_REMOVE_USER_BTN).Visible = false;
		m_btnOK.Visible = false;

		initOldVersionCombo();
		OnVersionComboChange(m_OldVersionCombo);			//OnComboChange will be called in OnVersionComboChange()
	}
	GetItem(IDC_OPEN_GROUP_LIST_PATH_BTN).SetToolTip(getGroupListFolderPath());

	return TRUE;
}

BOOL FilePublishDlg::OnDlgResize(int nType, int cx, int cy)
{
	//------ Folger 09/18/07 CENTRALIZE_GET_SET_CODE_IN_GROUPMGR
	if(!IsInitReady())
		return TRUE;
	//------ End CENTRALIZE_GET_SET_CODE_IN_GROUPMGR

	MoveControlsHelper	_temp(this);			///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

	uint nButtonIDs[] = {IDCANCEL, IDC_FP_OK_BTN, 0};
	ArrangeMainItemAndControls(nButtonIDs, IDC_FP_USER_LIST, NULL, false);

	int nEdge = GetControlGap();

	vector<uint> vnGroup = {IDC_FILE_TYPE, IDC_FP_DROPDOWN, 0};
	ArrangeControlsLeftRight(vnGroup, nEdge, nEdge);

	///-----Kit 02/11/2011 ORG-2126-S1 MAKE_CTRL_LOOK_WELL_BOTH_IN_XP_AND_WIN7
	RECT rrFPDropDown;
	GetControlClientRect(IDC_FP_DROPDOWN, rrFPDropDown);
	///-----End MAKE_CTRL_LOOK_WELL_BOTH_IN_XP_AND_WIN7

	Control ctrlUser;
	RECT 	rrUser;
	GetControlClientRect(IDC_FP_USER_LIST, rrUser, &ctrlUser);

	Control ctrlGroup;
	RECT 	rrGroup;
	GetControlClientRect(IDC_FP_GROUP_LIST, rrGroup, &ctrlGroup);

	Control btnPublish;
	RECT 	rrPublish;
	GetControlClientRect(IDC_FP_PUBLISH_BTN, rrPublish, &btnPublish);

	Control btnGetBack;
	RECT	rrGetBack;
	GetControlClientRect(IDC_FP_GET_BACK_BTN, rrGetBack, &btnGetBack);

	Control btnRemoveUser;
	RECT	rrRemoveUser;
	GetControlClientRect(IDC_FP_REMOVE_USER_BTN, rrRemoveUser, &btnRemoveUser);

	Control btnRemoveGroup;
	RECT	rrRemoveGroup;
	GetControlClientRect(IDC_FP_REMOVE_GROUP_BTN, rrRemoveGroup, &btnRemoveGroup);

	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	Control staticVersion, comboVersion, btnVersion;
	RECT rrStaticVersion, rrComboVersion, rrBtnVersion;
	GetControlClientRect(IDC_FP_VERSION_STATIC, rrStaticVersion, &staticVersion);
	GetControlClientRect(IDC_FP_VERSION_COMBO, rrComboVersion, &comboVersion);
	GetControlClientRect(IDC_FP_VERSION_SPECIFY, rrBtnVersion, &btnVersion);

	Control staticCate, comboCate;
	RECT rrStaticCate, rrComboCate;
	GetControlClientRect(IDC_FP_DEST_CATEGORY_STATIC, rrStaticCate, &staticCate);
	GetControlClientRect(IDC_FP_DEST_CATEGORY_COMBO, rrComboCate, &comboCate);
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

	int nBtnWidth = RECT_WIDTH(rrPublish);
	int nBtnHeight = RECT_HEIGHT(rrPublish);
	// DlgWidth = Gap + ListWid + Gap + ButtonWid + GapListWid + Gap, the width of List is same as the width of Tree
	int nListWidth = (RECT_WIDTH(rrUser) - 2 * nEdge - nBtnWidth) / 2;

	///-----Kit 01/28/2011 ORG-2126-S3 ADD_HINT_TO_TELL_HOW_TO_OPEN_FOLDER
	//rrUser.bottom -= nBtnHeight + 2 * nEdge;
	int nColorHintHeight = nBtnHeight - 3;
	rrUser.bottom -= nBtnHeight + nColorHintHeight + nEdge;
	///-----End ADD_HINT_TO_TELL_HOW_TO_OPEN_FOLDER
	///-----Kit 02/11/2011 ORG-2126-S1 MAKE_CTRL_LOOK_WELL_BOTH_IN_XP_AND_WIN7
	RECT rrBtnOpenFolder;
	GetControlClientRect(IDC_USER_LIST_PATH_TEXT, rrBtnOpenFolder);
	rrUser.top = rrBtnOpenFolder.bottom + nEdge;
	///-----End MAKE_CTRL_LOOK_WELL_BOTH_IN_XP_AND_WIN7

	rrGroup.top = rrUser.top;
	rrGroup.bottom = rrUser.bottom;
	rrGroup.right = rrUser.right;
	rrGroup.left = rrGroup.right - nListWidth;
	MoveControl(ctrlGroup, rrGroup);

	rrUser.right = rrUser.left + nListWidth;
	MoveControl(ctrlUser, rrUser);

	rrPublish.right = rrGroup.left - nEdge;
	rrPublish.left = rrPublish.right - nBtnWidth;
	///-----Kit 02/11/2011 ORG-2126-S1 MOVE_PUBLIC_BTN_IN_THE_MIDDLE_OF_TWO_PANNEL
	rrPublish.top		= rrUser.top + RECT_HEIGHT(rrUser) / 2 - nBtnHeight;
	rrPublish.bottom	= rrPublish.top + nBtnHeight;
	///-----End MOVE_PUBLIC_BTN_IN_THE_MIDDLE_OF_TWO_PANNEL
	MoveControl(btnPublish, rrPublish);

	rrGetBack.top = rrPublish.bottom + nEdge;
	rrGetBack.bottom = rrGetBack.top + nBtnHeight;
	rrGetBack.left = rrPublish.left;
	rrGetBack.right = rrPublish.right;
	MoveControl(btnGetBack, rrGetBack);

	int nRemoveBtnWidth = RECT_WIDTH(rrRemoveUser);

	rrRemoveUser.top = rrUser.bottom + nEdge;
	rrRemoveUser.bottom = rrRemoveUser.top + nBtnHeight;
	rrRemoveUser.left = rrUser.left;
	rrRemoveUser.right = rrRemoveUser.left + nRemoveBtnWidth;
	MoveControl(btnRemoveUser, rrRemoveUser);

	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	// the same place with IDC_FP_REMOVE_USER_BTN, which will be shown if m_bGroupMgr==true
	// and these controls are only shown when m_bGroupMgr==false
	int nStaticVersionWidth = RECT_WIDTH(rrStaticVersion);
	rrStaticVersion.top = rrUser.bottom + nEdge;
	rrStaticVersion.bottom = rrStaticVersion.top + nBtnHeight;
	rrStaticVersion.left = rrUser.left;
	rrStaticVersion.right = rrStaticVersion.left + nStaticVersionWidth;
	MoveControl(staticVersion, rrStaticVersion);

	int nComboVersionWidth = RECT_WIDTH(rrComboVersion);
	int nComboVersionHeight = RECT_HEIGHT(rrComboVersion);
	rrComboVersion.top = rrUser.bottom + nEdge;
	rrComboVersion.bottom = rrComboVersion.top + nComboVersionHeight;
	rrComboVersion.left = rrStaticVersion.right + nEdge;
	rrComboVersion.right = rrComboVersion.left + nComboVersionWidth;
	MoveControl(comboVersion, rrComboVersion);

	int nBtnVersionWidth = RECT_WIDTH(rrBtnVersion);
	rrBtnVersion.top = rrUser.bottom + nEdge;
	rrBtnVersion.bottom = rrBtnVersion.top + nBtnHeight;
	rrBtnVersion.left = rrComboVersion.right + nEdge;
	rrBtnVersion.right = rrBtnVersion.left + nBtnHeight;			// width same with height
	MoveControl(btnVersion, rrBtnVersion);
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL


	rrRemoveGroup.top = rrRemoveUser.top;
	rrRemoveGroup.bottom = rrRemoveUser.bottom;
	rrRemoveGroup.left = rrGroup.left;
	rrRemoveGroup.right = rrRemoveGroup.left + nRemoveBtnWidth;
	MoveControl(btnRemoveGroup, rrRemoveGroup);

	resizeColorHint(rrRemoveUser.bottom + nEdge, rrUser.left, nColorHintHeight);
	RECT rrColorText;
	GetControlClientRect(IDC_COLOR_HINT_RED, rrColorText);

	BOOL	bIsGLan = 'G' == okutil_get_current_lang();
	putCtrl(IDC_OPEN_FOLDER_HINTS, rrRemoveUser.bottom + nEdge, rrGroup.left, nColorHintHeight * (bIsGLan ? 2 : 1), true, !bIsGLan);

	Control btnGroup;
	RECT	rrBtnGroup;
	GetControlClientRect(IDC_FP_GROUP_BTN, rrBtnGroup, &btnGroup);

	int nBtnGroupWidth = RECT_WIDTH(rrBtnGroup);
	rrBtnGroup.right = rrGroup.right;
	rrBtnGroup.left = rrBtnGroup.right - nBtnGroupWidth;
	MoveControl(btnGroup, rrBtnGroup);

	
	Control ctrlFileTypeStatic;
	RECT rrFileTypeStatic;
	GetControlClientRect(IDC_FILE_TYPE, rrFileTypeStatic, &ctrlFileTypeStatic);
	
	int nCateWidth = RECT_WIDTH(rrStaticCate);
	int nCateHeight = RECT_HEIGHT(rrStaticCate);
	rrStaticCate.top = rrFileTypeStatic.top;
	rrStaticCate.bottom = rrStaticCate.top + nCateHeight;
	rrStaticCate.left = rrGroup.left;
	rrStaticCate.right = rrStaticCate.left + nCateWidth;
	MoveControl(staticCate, rrStaticCate);

	nCateWidth = RECT_WIDTH(rrComboCate);
	nCateHeight = RECT_HEIGHT(rrComboCate);
	rrComboCate.top = rrStaticCate.top;
	rrComboCate.bottom = rrComboCate.top + nCateHeight;
	rrComboCate.left = rrStaticCate.right + nEdge;
	rrComboCate.right = rrComboCate.left + nCateWidth;
	MoveControl(comboCate, rrComboCate);
	

	int nPathHintTop = rrFPDropDown.bottom + nEdge;
	resizeUserListFolderPathCtrl(false, nPathHintTop, nBtnHeight);
	resizeGroupFolderPathCtrl(nPathHintTop, nBtnHeight);
	

	return TRUE;
}

BOOL FilePublishDlg::OnRestoreSize(ODWP dwSizeInfo)
{
	void * p = (void*)dwSizeInfo;
	DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;

	//string strDlgName = STR_DLG_NAME;
	string strDlgName = m_bGroupMgr ? STR_DLG_NAME : STR_DLG_NAME_TRANSFER_USER_FILES;
	lstrcpyn(pSz->szDialogName, strDlgName, MAXLINE);

	pSz->top = -1;
	pSz->left = -1;
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	//pSz->width = 450;  //hard code, will change later
	/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//pSz->width = max(700, getMinWidth());
	pSz->width = max(700, GetMinTrackWidth());
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	pSz->height = 400;  //hard code, will change later
	return TRUE;
}

/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
// int	FilePublishDlg::GetTotalWidth(bool bMin)
// {
// 	if(bMin)
// 		return getMinWidth();
// 	return ResizeDialog::GetTotalWidth(bMin);
// }
/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS

/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
//int	FilePublishDlg::GetTotalHeight(bool bMin)
int	FilePublishDlg::GetMinClientTrackHeight()
/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
{
	return 400;
}

BOOL FilePublishDlg::OnDestroy()
{
	if (m_FileTypeCombo)
	{
		int nCurSel = m_FileTypeCombo.GetCurSel();
		dlg_save_to_registry(m_strDlgName, STR_LAST_SELECTION, nCurSel);
		dlg_save_to_registry(m_strDlgName, STR_LAST_SPECIFIED_LOCATION, m_strSpecifiedPath);
		dlg_save_to_registry(m_strDlgName, STR_OLD_VERSION_KEY, m_strCurOldVersionKey);
	}

	return true;
}

BOOL FilePublishDlg::OnComboChange(Control ctrl)
{
	const int nCurSel = getComboCurSel();
	DWORD		dwSpecialFileType = 0;
	initFilePublish(nCurSel);

	if ( FILE_TYPE_PACKAGE == nCurSel )
		dwSpecialFileType |= SPECIAL_FILE_TYPE_PACKAGE;
	initDestCategoryCombo(m_pFilePublish->IsSrcPathSpecified());					// 

	initFileListControl();

	setListColor(dwSpecialFileType);
	

	GetItem(IDC_FP_PUBLISH_BTN).Enable =
		GetItem(IDC_FP_REMOVE_USER_BTN).Enable =
		GetItem(IDC_FP_GET_BACK_BTN).Enable =
		GetItem(IDC_FP_REMOVE_GROUP_BTN).Enable = false;

	GetItem(IDC_FP_REMOVE_USER_BTN).Text = (nCurSel == FILE_TYPE_FDF || nCurSel == FILE_TYPE_TEMPLATE) ? _L("Remove") : _L("Delete");
	GetItem(IDC_FP_REMOVE_GROUP_BTN).Text = (!m_bGroupMgr && (nCurSel == FILE_TYPE_FDF || nCurSel == FILE_TYPE_TEMPLATE)) ? _L("Remove") : _L("Delete");

	///-----Kit 02/11/2011 ORG-2126-S2 UPDATE_FOLDER_PATH_WHEN_CHANGE_LOCATION
	resizeUserListFolderPathCtrl(true);
	GetItem(IDC_OPEN_USER_LIST_PATH_BTN).SetToolTip(getUserListFolderPath());
	UpdateWindow();
	///-----

	return true;
}

///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
BOOL FilePublishDlg::OnVersionComboChange(Control ctrl)
{
	int nCurSel = m_OldVersionCombo.GetCurSel();
	if(nCurSel >= 0 && nCurSel < m_vsOldVersionKeys.GetSize())
	{
		m_strCurOldVersionKey = m_vsOldVersionKeys[nCurSel];
		m_btnVersionSpecify.Enable = false;
	}
	else
	{
		m_strCurOldVersionKey = STR_SPECIFIED_FOLDER;
		m_btnVersionSpecify.Enable = true;
	}
	//m_strSpecifiedPath.Empty();
	OnComboChange(m_FileTypeCombo);

	return false;
}

BOOL FilePublishDlg::OnVersionSpecify(Control ctrl)
{
	char szNewPath[MAX_PATH];
	
	string	strDefPath = m_strSpecifiedPath.IsEmpty() ? okutil_get_origin_path(ORIGIN_PATH_USER) : m_strSpecifiedPath;
	if ( IDOK == browse_get_path_dialog(GetSafeHwnd(), szNewPath, strDefPath, "Please choose a folder.") )
	{
		string strPath = szNewPath;
		if(strPath.IsEmpty())
			return false;
		m_strSpecifiedPath = strPath;
		OnComboChange(m_FileTypeCombo);

		return true;
	}
	return false;
}

BOOL FilePublishDlg::OnMouseMoveSrcFileList(Control cntrl, short nButton, short nShift, float X, float Y)
{
	if(!m_pUserList)
		return false;
	m_pUserList->OnMouseMove(cntrl, nButton, nShift, X, Y);
	return true;
}
BOOL FilePublishDlg::OnMouseMoveDestFileList(Control cntrl, short nButton, short nShift, float X, float Y)
{
	if(!m_pGroupList)
		return false;
	m_pGroupList->OnMouseMove(cntrl, nButton, nShift, X, Y);
	return true;
}

BOOL FilePublishDlg::OnDestCateComboChange(Control ctrl)
{
	string strCate;
	int nCurSel = m_CateCombo.GetCurSel();
	if(nCurSel >= 0)
	{
		m_CateCombo.GetLBText(nCurSel, strCate);
		m_pFilePublish->SetDestCategory(strCate);
		OnComboChange(m_FileTypeCombo);
		return true;
	}
	return false;
}

void FilePublishDlg::OnBeforeMouseDownUser(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
{
	//m_pUserList->OnBeforeMouseDown(nButton, nShift, X, Y, pCancel);		///------ Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
}

void FilePublishDlg::OnBeforeMouseDownGroup(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
{
	//m_pGroupList->OnBeforeMouseDown(nButton, nShift, X, Y, pCancel);		///------ Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
}
///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

///------ Folger 02/01/2012 ORG-4478-S1 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
BOOL	FilePublishDlg::OnContextMenu(UINT nResIDCtrl, int nx, int ny)
{
	if ( IDC_FP_USER_LIST == nResIDCtrl )
	{
		m_pUserList->ShowMenu(nx, ny);
		return TRUE;
	}
	if ( IDC_FP_GROUP_LIST == nResIDCtrl )
	{
		m_pGroupList->ShowMenu(nx, ny);
		return TRUE;
	}

	return FALSE;
}
///------ End CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN

///-----Kit 02/17/2011 ORG-2126-S6 SUPPORT_DOUBLE_CLICK_TO_PUBLISH_FILES
void FilePublishDlg::OnDBLClickToPublishFile(Control ctrl)
{
	OnPublish(ctrl);
}
///-----End SUPPORT_DOUBLE_CLICK_TO_PUBLISH_FILES

BOOL FilePublishDlg::OnPublish(Control ctrl)
{
	vector<string> vsFiles;
	vector<bool> vbOlder;
	m_pUserList->FilterSelected(vsFiles, m_bFilterOlder, &vbOlder);	// need improve
	if(!m_bFilterOlder)
		checkRemoveOlder(vsFiles, vbOlder);
	
	int nSize = vsFiles.GetSize();

	m_pFilePublish->PublishFiles(vsFiles, true);	//------ Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
	//------ Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
	if (nSize != vsFiles.GetSize())
		warning_msg_box(CER_COPY_FILE, false, 'E');
	//------ End ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
	m_pUserList->RestoreItemsStatus(vsFiles, true);		//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
	int nAddRowNum = m_pGroupList->AddRowsFromFileNames(vsFiles);

	string strOutInfo;
	ocu_load_err_msg_str( m_bGroupMgr ? MSG_NUM_FILES_MOVE_FROM_GROUP : MSG_NUM_FILES_TRANSFERRED, strOutInfo );
	strOutInfo.Format( strOutInfo, nAddRowNum );

	///-----Kit 09/29/2011 ORG-3724-P7 SCRIPT_WIN_SHOULD_NOT_OPEN_WHEN_DUMP_INFO_TO_MSG_LOG
	//LT_execute( "ty -a" );
	//out_str( strOutInfo );
	warning_msg_box(strOutInfo, false, 'W');
	///-----End SCRIPT_WIN_SHOULD_NOT_OPEN_WHEN_DUMP_INFO_TO_MSG_LOG

	m_btnOK.Enable = true;
	{
		INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + STR_UPDATE_INI_FILE);
		iniFile.WriteInt(STR_SECTION, STR_IS_PUBLISHED, 0);
	}
	return true;
}

BOOL FilePublishDlg::OnGetBack(Control ctrl)
{
	vector<string> vsFiles;
	vector<bool> vbOlder;
	m_pGroupList->FilterSelected(vsFiles, m_bFilterOlder, &vbOlder );
	if(!m_bFilterOlder)
		checkRemoveOlder(vsFiles, vbOlder);
	
	int nSize = vsFiles.GetSize();		//------ Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE

	m_pFilePublish->PublishFiles(vsFiles, false);
	//------ Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
	if (nSize != vsFiles.GetSize())
		warning_msg_box(CER_COPY_FILE, false, 'E');
	//------ End ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
	m_pGroupList->RestoreItemsStatus(vsFiles, true);	//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION

	/// Kit 7/16/2010 ORG-539-S1 SHOW_INFORMATIVE_HINT_TO_INDICATE_TRANSFER_SUCCESSFULLY
	//m_pUserList->AddRows(vsFiles);
	int nAddRowsNum = m_pUserList->AddRowsFromFileNames(vsFiles);
	/// Kit 8/02/2010 ORG-539-S1 MAKE_BETTER_INFO_AFTER_FILES_MOVE
	string strOutInfo; 
	ocu_load_err_msg_str( MSG_NUM_FILES_MOVE_FROM_USER, strOutInfo );
	strOutInfo.Format( strOutInfo, nAddRowsNum );
	/// End MAKE_BETTER_INFO_AFTER_FILES_MOVE

	///-----Kit 09/29/2011 ORG-3724-P7 SCRIPT_WIN_SHOULD_NOT_OPEN_WHEN_DUMP_INFO_TO_MSG_LOG
	//LT_execute( "ty -a" );/// Kit 7/22/2010 ORG-539-S1 SHOW_MSG_WHATEVER_SCRIPT_WINDOW_OPEN_OR_NOT
	//out_str( strOutInfo );
	warning_msg_box(strOutInfo, false, 'W');
	///-----End SCRIPT_WIN_SHOULD_NOT_OPEN_WHEN_DUMP_INFO_TO_MSG_LOG
	/// End SHOW_INFORMATIVE_HINT_TO_INDICATE_TRANSFER_SUCCESSFULLY
	return true;
}

BOOL FilePublishDlg::OnRemoveUser(Control ctrl)
{		
	vector<string> vsFiles;

	m_pUserList->GetSelFiles(vsFiles);
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	ASSERT(vsFiles.GetSize());
	string strMsg = _L("Are you sure you want to remove the files?");
	if(IDYES != warning_msg_box(strMsg, true, 'W', MB_YESNO))
		return FALSE;
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

	int nSize = vsFiles.GetSize();		//------ Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	//m_pFilePublish->RemoveFiles(vsFiles, false);
	m_pFilePublish->RemoveFiles(vsFiles, true);
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	//------ Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
	if (nSize != vsFiles.GetSize())
		warning_msg_box(CER_DELETE_FILE, false, 'E');
	//------ End ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
	m_pUserList->RemoveSelRows(vsFiles);
	m_pGroupList->RestoreItemsStatus(vsFiles, false);

	OnGroupSelChange(ctrl);

	return true;
}

BOOL FilePublishDlg::OnRemoveGroup(Control ctrl)
{
	vector<string> vsFiles;

	m_pGroupList->GetSelFiles(vsFiles);
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	ASSERT(vsFiles.GetSize());
	string strMsg = _L("Are you sure you want to remove the files?");
	if(IDYES != warning_msg_box(strMsg, true, 'W', MB_YESNO))
		return FALSE;
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL

	int nSize = vsFiles.GetSize();		//------ Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	//m_pFilePublish->RemoveFiles(vsFiles, true);
	m_pFilePublish->RemoveFiles(vsFiles, false);
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	//------ Folger 09/26/07 ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
	if (nSize != vsFiles.GetSize())
		warning_msg_box(CER_DELETE_FILE, false, 'E');
	//------ End ERROR_CHECKING_FOR_COPY_AND_DELETE_FILE
	m_pGroupList->RemoveSelRows(vsFiles);
	m_pUserList->RestoreItemsStatus(vsFiles, false);

	OnUserSelChange(ctrl);

	//------ Folger 09/03/07 ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO
	m_btnOK.Enable = true;
	//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
	//INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_GROUP) + STR_UPDATE_INI_FILE);
	INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + STR_UPDATE_INI_FILE);
	//------
	iniFile.WriteInt(STR_SECTION, STR_IS_PUBLISHED, 0);
	//------ End ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO

	return true;
}

//------ Folger 09/03/07 ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO
BOOL FilePublishDlg::OnOK(Control ctrl)
{
	//------ CPY 9/22/2007 QA70-10384 CODE_CLEANUP_SEPARATE_UNC_AND_LOCAL_PATH
	//INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_GROUP) + STR_UPDATE_INI_FILE);
	INIFile iniFile(okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + STR_UPDATE_INI_FILE);
	//------
	int nVersion = iniFile.ReadInt(STR_SECTION, STR_VERSION, -1);
	nVersion++;
	iniFile.WriteInt(STR_SECTION, STR_VERSION, nVersion);
	iniFile.WriteInt(STR_SECTION, STR_IS_PUBLISHED, 1);
	CopyClientUpdateEXE();		///------ Folger 12/09/2011 ORG-4362-P9 COPY_CLIENTUPDATE_EXE_AFTER_PUBLISH_FILES
	PostMessage(WM_CLOSE);
	return true;
}
//------ End ADD_OK_BUTTON_TO_MODIFY_UPDATE_INFO
void FilePublishDlg::OnUserSelChange(Control control)
{
	if (m_pUserList)
		enableButtons(m_pUserList, IDC_FP_PUBLISH_BTN, IDC_FP_REMOVE_USER_BTN);
}

void FilePublishDlg::OnGroupSelChange(Control control)
{
	if (m_pGroupList)
		enableButtons(m_pGroupList, IDC_FP_GET_BACK_BTN, IDC_FP_REMOVE_GROUP_BTN);
}

//------ Folger 11/14/07 MAP_DIALOG_CHM_HELP
BOOL FilePublishDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
{
	nHelpID = m_bGroupMgr ? IDD_GROUP_FOLDER_DLG : IDD_UUF_DLG;
	return true;
}
//------ End MAP_DIALOG_CHM_HELP

///-----Kit 01/30/2011 ORG-2126-S2 ADD_CURRENT_FILE_PATH_INFO
BOOL FilePublishDlg::OnClickOpenUserListFolder(Control ctrl)
{
	okutil_open_os_explorer(getUserListFolderPath());
	return TRUE;
}

BOOL FilePublishDlg::OnClickOpenGroupListFolder(Control ctrl)
{
	okutil_open_os_explorer(getGroupListFolderPath());
	return TRUE;
}
///-----End ADD_CURRENT_FILE_PATH_INFO

int FilePublishDlg::getComboCurSel()
{
	int nCurSel = m_FileTypeCombo.GetCurSel();

	//------ Folger 09/12/07 CHECK_SREVER_LICENSE_TO_SHOW_PROPER_ITEM
	if ( m_bGroupMgr )
	{
		if ( !okutil_is_group_files_update_feature_permitted() )
		{
			//------ Folger 09/26/07 SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
			//nCurSel = FILE_TYPE_PATCH;
			switch (nCurSel)
			{
			case 0:
				nCurSel = FILE_TYPE_PATCH;
				break;
			case 1:
				nCurSel = FILE_TYPE_ALL_FILE;
				break;
			default:
				break;
			}
			//------ End SUPPORT_ALL_FILE_TYPE_IN_COMBO_SELECTION
		}
	}
	///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL, show Patch file type only for group folder manager
	else
	{
		if(nCurSel >= FILE_TYPE_PATCH)
			nCurSel += 1;
	}
	///End TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
	//------ End CHECK_SREVER_LICENSE_TO_SHOW_PROPER_ITEM

	return nCurSel;
}

BOOL FilePublishDlg::initFilePublish(int nComboCurSel)
{
	NICE_SAFE_REMOVAL(m_pFilePublish);

	ASSERT(m_pFilePublish == NULL);

	m_pFilePublish = create_file_publish(nComboCurSel, m_bGroupMgr, m_strCurOldVersionKey, m_strSpecifiedPath);	///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PALETTE_FILES
	
	ASSERT(NULL != m_pFilePublish);
	return TRUE;
}

BOOL FilePublishDlg::initFileListControl()
{
	NICE_SAFE_REMOVAL(m_pUserList);  
	NICE_SAFE_REMOVAL(m_pGroupList);

	m_pUserList = new FileListControl(IDC_FP_USER_LIST, *this, true, m_pFilePublish);
	m_pGroupList = new FileListControl(IDC_FP_GROUP_LIST, *this, false, m_pFilePublish);

	ASSERT(NULL != m_pUserList && NULL != m_pGroupList);
	return TRUE;
}
///-----End REFACTOR_CODE

///Kyle 08/28/2009 QA80-14216 TRANSFER_USER_FILES_ADD_OLD_VERSION_CONTROL
/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
//int FilePublishDlg::getMinWidth()
int FilePublishDlg::GetMinClientTrackWidth()
/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
{
	static int nMinWidth = 0;
	if(nMinWidth == 0)
	{
		int nEdge = GetControlGap();
		RECT 	rrFileType, rrFileDrop;
		GetControlClientRect(IDC_FILE_TYPE, rrFileType);
		GetControlClientRect(IDC_FP_DROPDOWN, rrFileDrop);
		int nMinLeft = RECT_WIDTH(rrFileType) + nEdge + RECT_WIDTH(rrFileDrop);

		RECT rrStaticCate, rrComboCate;
		GetControlClientRect(IDC_FP_DEST_CATEGORY_STATIC, rrStaticCate);
		GetControlClientRect(IDC_FP_DEST_CATEGORY_COMBO, rrComboCate);
		int nMinRight = RECT_WIDTH(rrStaticCate) + nEdge + RECT_WIDTH(rrComboCate);

		RECT 	rrPublish;
		GetControlClientRect(IDC_FP_PUBLISH_BTN, rrPublish);

		///------ Folger 03/31/2011 OPEN_FOLDER_HINT_NOT_FULLY_DISPLAY_IN_J
		//nMinWidth = 2 * max(nMinLeft, nMinRight) + RECT_WIDTH(rrPublish) + 5 * nEdge;
		const	int		nFactor = 30;
		nMinWidth = 2 * max(nMinLeft, nMinRight) + RECT_WIDTH(rrPublish) + nFactor * nEdge;
		///------ End OPEN_FOLDER_HINT_NOT_FULLY_DISPLAY_IN_J
	}
	return nMinWidth;
}

bool FilePublishDlg::checkRemoveOlder(vector<string>& vsFiles, vector<bool>& vbOlder)
{
	bool bSkipOlder = false;
	for(int ii=vbOlder.GetSize() - 1; ii >= 0; ii--)
	{
		if(vbOlder[ii])
		{
			if( OM_RETURN_NO == OptionalMessage("FBReplaceNewerWithOlder", MB_YESNO) )
				bSkipOlder = true;

			m_bFilterOlder = OM_RETURN_NO==OptionalMessageStatus("FBReplaceNewerWithOlder");
			break;
		}
	}
	if(bSkipOlder)
	{
		for(ii=vbOlder.GetSize()-1; ii>=0; ii--)
		{
			if(vbOlder[ii])
			{
				vsFiles.RemoveAt(ii);
				vbOlder.RemoveAt(ii);
			}
		}
	}
	return bSkipOlder;
}

void FilePublishDlg::setListColor(DWORD dwSpecialFileType)
{
	vector<string> vsUserFiles;
	vector<string> vsGroupFiles;

	const int nUserRowOffset = m_pUserList->GetRowOffset();
	const int nGroupRowOffset = m_pGroupList->GetRowOffset();
	const int nUserColOffset = m_pUserList->GetColOffset();
	const int nGroupColOffset = m_pGroupList->GetColOffset();

	///-----Kit 1025/2011 ORG-4062-P2 GET_WRONG_FILE_FULL_PATH_LEAD_TO_GET_FILE_MODIFY_TIME_WRONG
	//m_pUserList->GetColValues(nUserColOffset + FB_COL_FILE, vsUserFiles, nUserRowOffset);
	//m_pGroupList->GetColValues(nGroupColOffset + FB_COL_FILE, vsGroupFiles, nGroupRowOffset);
	//{
	//	vector<string> vsCates;
	//	if(m_pFilePublish->IsSrcPathSpecified())			// can not get category info from gui
	//	{
	//		for(int nFile=vsUserFiles.GetSize()-1; nFile >= 0; nFile--)		// all file type
	//		{
	//			string strCategory = m_pFilePublish->GetDestCategory(vsUserFiles[nFile]);
	//			if(!strCategory.IsEmpty())
	//				vsUserFiles[nFile] = strCategory + vsUserFiles[nFile];
	//		}
	//	}
	//	else
	//	{
	//		m_pUserList->GetColValues(nUserColOffset + FB_COL_CATEGORY, vsCates, nUserRowOffset);
	//		_insert_string_in_vector(vsUserFiles, vsCates);
	//	}

	//	m_pGroupList->GetColValues(nGroupColOffset + FB_COL_CATEGORY, vsCates, nGroupRowOffset);
	//	_insert_string_in_vector(vsGroupFiles, vsCates);
	//}
	m_pUserList->GetFilesWithSubCategory(vsUserFiles);
	m_pGroupList->GetFilesWithSubCategory(vsGroupFiles);
	///-----End GET_WRONG_FILE_FULL_PATH_LEAD_TO_GET_FILE_MODIFY_TIME_WRONG
	
	const int nUserSize = vsUserFiles.GetSize();
	const int nGroupSize = vsGroupFiles.GetSize();
	const int nUserColStatus = m_pUserList->GetColStatus();
	const int nGroupColStatus = m_pGroupList->GetColStatus();

	for (int ii=0; ii<nUserSize; ii++)
	{
		const int nIndex = vsGroupFiles.Find(vsUserFiles[ii]);
		if (nIndex < 0)
		{
			m_pUserList->SetRowProperties(nUserRowOffset + ii, FILE_NEW);
			continue;
		}

		int nUserColor = COLOR_BLUE, nGroupColor = COLOR_BLUE;
		double dUserFileTime;
		double dGroupFileTime;
		string strUserFile = vsUserFiles[ii];
		string strGroupFile = vsGroupFiles[nIndex];
		m_pFilePublish->GetFileFullPath(strUserFile, strGroupFile);
		int		nRet = 0;

		///-----Kit 01/10/2012 ORG-4069-P4 OPK_FILE_COLOR_SHOWN_IS_NOT_CORRECT_AFTER_PUBLISH
		//if ( O_QUERY_BOOL(dwSpecialFileType, SPECIAL_FILE_TYPE_PACKAGE) || _is_opx_file(strUserFile) )
		if ( O_QUERY_BOOL(dwSpecialFileType, SPECIAL_FILE_TYPE_PACKAGE) && _is_opx_file(strUserFile) )	// not check when file suffix is opk
		///-----End OPK_FILE_COLOR_SHOWN_IS_NOT_CORRECT_AFTER_PUBLISH
			nRet = opx_file_version_compare(strUserFile, strGroupFile);

		if ( nRet == 0 )
			nRet =  file_last_modified_time_compare(strUserFile, strGroupFile);

		if (nRet > 0)
		{
			nUserColor = COLOR_RED;
			//nGroupColor = COLOR_GREEN;
			nGroupColor = COLOR_DARKGREEN;		// a little darker
			m_pUserList->SetCell(nUserRowOffset + ii, nUserColOffset + nUserColStatus, FILE_DATE_NEW);
			m_pGroupList->SetCell(nGroupRowOffset + nIndex, nGroupColOffset + nGroupColStatus, FILE_DATE_OLD);
		}
		else if (nRet < 0)
		{
			nUserColor = COLOR_DARKGREEN;		// a little darker
			nGroupColor = COLOR_RED;
			m_pGroupList->SetCell(nGroupRowOffset + nIndex, nGroupColOffset + nGroupColStatus, FILE_DATE_NEW);
			m_pUserList->SetCell(nUserRowOffset + ii, nUserColOffset + nUserColStatus, FILE_DATE_OLD);
		}
		m_pUserList->SetRowColor(nUserRowOffset + ii, nUserColor, -1, true);
		m_pGroupList->SetRowColor(nGroupRowOffset + nIndex, nGroupColor, -1, true);
	}

	for ( ii = 0; ii < nGroupSize; ii++)
	{
		if ( vsUserFiles.Find(vsGroupFiles[ii]) < 0 )
			m_pGroupList->SetRowProperties(nUserRowOffset + ii, FILE_NEW);
	}
}

void FilePublishDlg::initFileTypeCombo()
{
	m_FileTypeCombo = (ComboBox)GetItem(IDC_FP_DROPDOWN);
	m_FileTypeCombo.ResetContent();

	if(m_bGroupMgr && !okutil_is_group_files_update_feature_permitted())
	{
		m_FileTypeCombo.AddString(STR_FILE_TYPE_PATCH + "(EXE)");
	}
	else
	{
		m_FileTypeCombo.AddString(STR_FILE_TYPE_OGW + "(OGW)");
		m_FileTypeCombo.AddString(STR_FILE_TYPE_DIALOG_THEME + "(OIS, ODT)");	///-----Kit 10/19/2011 ORG-4121-S1 MAKE_TRANSFER_USER_FILE_SUPPORT_ODT_FILE, odt for dialog theme
		m_FileTypeCombo.AddString(STR_FILE_TYPE_FUNCTION_THEME + "(OFP)");		///------ Tony 07/18/2012 ORG-5952-S1 FIX_FITTING_FUNCTIONS
		m_FileTypeCombo.AddString(STR_FILE_TYPE_FDF + "(FDF)");
		m_FileTypeCombo.AddString(STR_FILE_TYPE_IMPORT_FILTER + "(OIF)");
		m_FileTypeCombo.AddString(STR_FILE_TYPE_OGS + "(OGS)");
		m_FileTypeCombo.AddString(STR_FILE_TYPE_DATABASE + "(ODQ, ODS)");
		m_FileTypeCombo.AddString(STR_FILE_TYPE_ORIGINC + "(H, C, CPP)");
		m_FileTypeCombo.AddString(STR_FILE_TYPE_PACKAGE + "(OPK, OPX)");
		m_FileTypeCombo.AddString(STR_FILE_TYPE_TEMPLATE + "(OTP, OTW, OTM)");
		if(m_bGroupMgr)			// show Patch file type only for group folder manager
			m_FileTypeCombo.AddString(STR_FILE_TYPE_PATCH + "(EXE)");
		m_FileTypeCombo.AddString(STR_FILE_TYPE_PROJECT + "(OPJ)");
		m_FileTypeCombo.AddString(STR_FILE_TYPE_THEME + "(OTH)");
		m_FileTypeCombo.AddString(STR_FILE_TYPE_XF + "(OXF)");
		m_FileTypeCombo.AddString(STR_FILE_TYPE_OMC + "(OMC)");
		///-----Kit 10/08/2011 ORG-3938-P2 IMPORVE_UFF_TRANSFER_DEFAULT_FILE_TYPE
		//m_FileTypeCombo.AddString(STR_FILE_TYPE_DEFAULT_SETTINGS + "(XML)");
		m_FileTypeCombo.AddString(STR_FILE_TYPE_DEFAULT_SETTINGS + "(XML, INI)");
		///-----End IMPORVE_UFF_TRANSFER_DEFAULT_FILE_TYPE
		m_FileTypeCombo.AddString(STR_FILE_TYPE_TEXT_FILE + "(TXT)" );	///-----Kit 01/04/2011 ORG-1885-S1 SUPPORT_TEXT_FILE_IN_TRANSFER_USER_FILES
		m_FileTypeCombo.AddString(STR_FILE_TYPE_PAL_FILE + "(PAL)");	///-----Kit 09/29/2011 ORG3938-P1 SUPPORT_PALETTE_FILES
		m_FileTypeCombo.AddString(STR_FILE_TYPE_USERBUTTONS + "(OPX)");	///Sophy 3/5/2012 ORG-2840-P4 TRANSFER_USER_FILE_SHOUD_SUPPORT_USER_DEFINED_BUTTON_GROUP_SETTINGS
		m_FileTypeCombo.AddString(STR_FILE_TYPE_OTHER_FILE + "(DOC, DOCX, PDF)");
	}
	m_FileTypeCombo.AddString(_L("All Supported Files"));
	DWORD dwSel = 0;
	dlg_load_registry(m_strDlgName, STR_LAST_SELECTION, dwSel, m_FileTypeCombo.GetCount()-1);
	if(dwSel >= m_FileTypeCombo.GetCount())
		dwSel = m_FileTypeCombo.GetCount()-1;
	
	m_FileTypeCombo.SetCurSel(dwSel);
	dlg_load_registry(m_strDlgName, STR_LAST_SPECIFIED_LOCATION, m_strSpecifiedPath);
}

void FilePublishDlg::initOldVersionCombo()
{

	m_OldVersionCombo = GetItem(IDC_FP_VERSION_COMBO);
	m_btnVersionSpecify = GetItem(IDC_FP_VERSION_SPECIFY);
	_check_get_old_version_origin_registry_key(m_vsOldVersionKeys);

	m_OldVersionCombo.ResetContent();
	for(int ii=0; ii<m_vsOldVersionKeys.GetSize(); ii++)
	{
		m_OldVersionCombo.AddString(m_vsOldVersionKeys[ii] + " " + _L("User Files Folder"));
	}
	m_OldVersionCombo.AddString(STR_SPECIFIED_FOLDER);

	// select the latest version
	int nCurSel = m_vsOldVersionKeys.GetSize()-1;
	if ( dlg_load_registry(m_strDlgName, STR_OLD_VERSION_KEY, m_strCurOldVersionKey) && !m_strCurOldVersionKey.IsEmpty() )
	{
		int		nIndex = m_vsOldVersionKeys.Find(m_strCurOldVersionKey);
		if ( nIndex >= 0 )
		{
			nCurSel = nIndex;
		}
		else if ( compare_string_localization(m_strCurOldVersionKey, STR_SPECIFIED_FOLDER) )
		{
			++nCurSel;
		}
	}

	if(nCurSel < 0)
		nCurSel = 0;

	m_OldVersionCombo.SetCurSel(nCurSel);
}

void FilePublishDlg::initDestCategoryCombo(bool bShow /*= false*/)
{
	GetItem(IDC_FP_DEST_CATEGORY_STATIC).Visible = bShow;
	GetItem(IDC_FP_DEST_CATEGORY_COMBO).Visible = bShow;

	if(bShow)
	{
		///-----Kit 10/19/2011 ORG-4062-P2 DST_CATEGORY_NOT_GET_CORRECT
		//if(!m_CateCombo)		// it's used only for theme transfer, so init it for only once
		//{
		//	m_CateCombo = GetItem(IDC_FP_DEST_CATEGORY_COMBO);
		//	m_CateCombo.ResetContent();
		//	vector<string> vsCates;
		//	m_pFilePublish->GetAvailableCates(vsCates);
		//	for(int ii=0; ii<vsCates.GetSize(); ii++)
		//		m_CateCombo.AddString(vsCates[ii]);
		//	m_CateCombo.SetCurSel(0);
		//}
		//int nCurSel = m_CateCombo.GetCurSel();
		//if(nCurSel >= 0)
		//{
		//	string strCate;
		//	m_CateCombo.GetLBText(nCurSel, strCate);
		//	m_pFilePublish->SetDestCategory(strCate);
		//}
		// now it only show in window theme transfer!!!
		if ( !m_CateCombo )
		{
			vector<string> vsCates;
			if ( m_pFilePublish->GetAvailableCates(vsCates) > 0 )
			{
				m_CateCombo = GetItem(IDC_FP_DEST_CATEGORY_COMBO);
				m_CateCombo.ResetContent();
				for(int ii=0; ii<vsCates.GetSize(); ii++)
				{
					m_CateCombo.AddString(vsCates[ii]);
				}
				m_CateCombo.SetCurSel(0);
				m_pFilePublish->SetDestCategory(vsCates[0]);
			}
		}
		else
		{
			int nCurSel = m_CateCombo.GetCurSel();
			if(nCurSel >= 0)
			{
				string strCate;
				m_CateCombo.GetLBText(nCurSel, strCate);
				m_pFilePublish->SetDestCategory(strCate);
			}
		}
		///-----End DST_CATEGORY_NOT_GET_CORRECT
	}
}

void FilePublishDlg::enableButtons(FileListControl *filelist, int nBtnAddID, int nBtnRemoveID)
{
	vector<string> vsFiles;
	filelist->FilterSelected(vsFiles, m_bFilterOlder);

	GetItem(nBtnAddID).Enable = vsFiles.GetSize();

	vector<uint> vnSelected;
	filelist->GetSelRows(vnSelected);
	GetItem(nBtnRemoveID).Enable = vnSelected.GetSize();
}

///-----Kit 01/28/2011 ORG-2126-S3 ADD_HINT_TO_TELL_HOW_TO_OPEN_FOLDER
void FilePublishDlg::initHintCtrl()
{
	RichEdit reOpenFolderHint = GetItem(IDC_OPEN_FOLDER_HINTS);
	reOpenFolderHint.Text = STR_OPEN_FOLDER_HINTS;
	reOpenFolderHint.Enable = false;
	reOpenFolderHint.SetTextColor(0, -1, SYSCOLOR_BLACK);

	initColorHint();///-----Kit 01/28/2011 ORG-2126-S5 COLOR_HINT_USE_COLOR_TO_SHOW
}

int getHowManyLinesInText(LPCTSTR lpcszText)
{
	string strText = lpcszText;
	return strText.GetNumTokens('\n') + 1;
}
///-----Kit 01/28/2011 ORG-2126-S5 COLOR_HINT_USE_COLOR_TO_SHOW
void FilePublishDlg::initColorHint()
{
	setHintColor(IDC_COLOR_HINT_RED, COLOR_RED, STR_COLOR_HINT_RED);
	setHintColor(IDC_COLOR_HINT_GREEN, COLOR_DARKGREEN, STR_COLOR_HINT_GREEN);
	setHintColor(IDC_COLOR_HINT_BLUE, COLOR_BLUE, STR_COLOR_HINT_BLUE);
}

void FilePublishDlg::setHintColor(uint uResourceID, uint uColor, LPCTSTR lpcszHint)
{
	RichEdit reHint = GetItem(uResourceID);
	reHint.Text = lpcszHint;
	reHint.SetTextColor(0, -1, uColor);
	reHint.Enable = false;
}

void FilePublishDlg::resizeColorHint(int nTop, int nLeft, int nHintHeight)
{
	int nNextHintLeft = putCtrl(IDC_COLOR_HINT_RED, nTop, nLeft, nHintHeight);
#define COLOR_HINT_GAP	13
	nNextHintLeft = putCtrl(IDC_COLOR_HINT_GREEN, nTop, nNextHintLeft + COLOR_HINT_GAP, nHintHeight);
	nNextHintLeft = putCtrl(IDC_COLOR_HINT_BLUE, nTop, nNextHintLeft + COLOR_HINT_GAP, nHintHeight);
}

int FilePublishDlg::putCtrl(uint uResourceID, int nTop, int nLeft, int nCtrlHeight, bool bResizeCtrlByCtrlText /*= true*/, bool bSingleLine /*= true*/)
{
	Control ctrlHint = GetItem(uResourceID);
	RECT rrCtrl;
	GetControlClientRect(uResourceID, rrCtrl, &ctrlHint);

	int nOldWidth = RECT_WIDTH(rrCtrl);
	rrCtrl.top = nTop;
	rrCtrl.bottom = rrCtrl.top + nCtrlHeight;
	rrCtrl.left = nLeft;

	int nNewWidth = nOldWidth;
	if(bResizeCtrlByCtrlText)
	{
		ctrlHint.Measure(ctrlHint.Text, &nNewWidth, bSingleLine);
	}

	rrCtrl.right = rrCtrl.left + nNewWidth;	
	MoveControl(ctrlHint, rrCtrl);
	return rrCtrl.right;

}

void FilePublishDlg::resizeUserListFolderPathCtrl(bool bUseCurrentTopHeight, int nTop /*= -1*/, int nCtrlHeight /*= -1*/)
{
	if(bUseCurrentTopHeight)
	{
		RECT rrFolderHint;
		GetControlClientRect(IDC_USER_LIST_PATH_TEXT, rrFolderHint);
		nTop	= rrFolderHint.top;
		nCtrlHeight = RECT_HEIGHT(rrFolderHint);
	}

	ASSERT(nTop >= 0 && nCtrlHeight >= 0);

	vector<int> vnResIDs = {IDC_USER_LIST_PATH_TEXT, IDC_OPEN_USER_LIST_PATH_BTN};
	string strPath = getUserListFolderPathTextPrefix() + " : " + getUserListFolderPath();
	resizeFolderPathCtrl(vnResIDs, IDC_FP_USER_LIST, nTop, nCtrlHeight, strPath);
}

void FilePublishDlg::resizeGroupFolderPathCtrl(int nTop, int nCtrlHeight)
{
	vector<int> vnResIDs = {IDC_GROUP_LIST_PATH_TEXT, IDC_OPEN_GROUP_LIST_PATH_BTN};
	string strPath = getGroupListFolderPathTextPrefix() + " : " + getGroupListFolderPath();
	resizeFolderPathCtrl(vnResIDs, IDC_FP_GROUP_LIST, nTop, nCtrlHeight, strPath);
}

void FilePublishDlg::resizeFolderPathCtrl(const vector<int> &vnResIDs, int nRefResourceID, int nTop, int nCtrlHeight, LPCTSTR lpcszPath)
{
	ASSERT(vnResIDs.GetSize() == 2);
	RECT rrCtrl;
	GetControlClientRect(nRefResourceID, rrCtrl);

	string strPath = lpcszPath;
	getEllipsisText(RECT_WIDTH(rrCtrl), strPath);
	GetItem(vnResIDs[0]).Text = strPath;

	int nCtrlLeft = putCtrl(vnResIDs[0], nTop, rrCtrl.left, nCtrlHeight);
	putCtrl(vnResIDs[1], nTop, nCtrlLeft + GetControlGap(), nCtrlHeight, false);
}

bool FilePublishDlg::getEllipsisText(int nWidth, string &strText)
{
	string strEllipsis = "...";
	int nEllipsisWidth = 0;
	GetTextExtentSize(strEllipsis, &nEllipsisWidth);
	UseEllipsisCutTextHelper cutText;

	DeviceContext dc(m_wndDlg);
	if(!cutText.GetText(dc, nWidth - nEllipsisWidth, strText))
		return false;

	strText += strEllipsis;
	return true;
}

string FilePublishDlg::getUserListFolderPath()
{
	ASSERT(m_pFilePublish != NULL);
	return m_pFilePublish->GetSrcPath();
}

string FilePublishDlg::getGroupListFolderPath()
{
	ASSERT(m_pFilePublish != NULL);
	return m_pFilePublish->GetDestPath();
}

string FilePublishDlg::getUserListFolderPathTextPrefix()
{
	if(m_bGroupMgr)
		return STR_USER_FOLDER;
	return STR_OLD_VERSION;
}

string FilePublishDlg::getGroupListFolderPathTextPrefix()
{
	if(m_bGroupMgr)
		return STR_GROUP_FOLDER;
	return STR_CURRENT_VERSION;
}

///------ Folger 12/09/2011 ORG-4362-P9 COPY_CLIENTUPDATE_EXE_AFTER_PUBLISH_FILES
BOOL	FilePublishDlg::CopyClientUpdateEXE()
{
	return copyfile(okutil_get_origin_path(ORIGIN_PATH_SYSTEM, ALL_USERS_FOLDER) + AUTO_UPDATE_EXE, okutil_get_origin_path(ORIGIN_PATH_SERVER_GROUP_FOLDER) + AUTO_UPDATE_EXE);
}
///------ End COPY_CLIENTUPDATE_EXE_AFTER_PUBLISH_FILES

//------ Folger 08/27/07 CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY
static void _insert_string_in_vector(vector<string> &vsTarget, const vector<string> &vsInsert)
{
	int nSize = vsInsert.GetSize();
	for (int ii=0; ii<nSize; ii++)
	{
		vsTarget[ii] = vsInsert[ii] + vsTarget[ii];
	}
}
//------ End CREATE_FILE_CATEGORY_PUBLISH_TO_SUPPORT_GRID_WITH_CATEGORY

BOOL OpenGroupFolderManager(HWND hParent = NULL)
{
	FilePublishDlg myDlg;
	int nRet = myDlg.DoModalEx(hParent);
	return nRet >= 0? true:false;
}
//------ Folger 08/28/07 SUPPORT_TRANSFER_FILES_FROM_75_TO_80
BOOL OpenTransferUserFiles(HWND hParent = NULL)
{
	FilePublishDlg myDlg(false);
	int nRet = myDlg.DoModalEx(hParent);
	return nRet >= 0? true:false;
}
//------ End SUPPORT_TRANSFER_FILES_FROM_75_TO_80

//void _op(bool bGroupMgr = true)
//{
	//if (bGroupMgr)
		//OpenGroupFolderManager();
	//else
		//OpenTransferUserFiles();
//}
//------ Folger 09/18/07 CENTRALIZE_GET_SET_CODE_IN_GROUPMGR
//static bool _copy_essential_files()
//{
	//vector<string> vsFilesFrom;
	//vector<string> vsFilesTo = {"OClientUpdate.exe", "OLicense.lic", "origin.ini"};
	//vsFilesFrom.Add(okutil_get_origin_path(ORIGIN_PATH_SYSTEM, "Group\\") + "OClientUpdate.exe");
	//string strUserFolder = okutil_get_origin_path(ORIGIN_PATH_USER);
	//vsFilesFrom.Add(strUserFolder + "OLicense.lic");
	//vsFilesFrom.Add(strUserFolder + "origin.ini");
	//string strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP);
	//
	//for (int ii=0; ii<vsFilesFrom.GetSize(); ii++)
	//{
		//CopyFile(vsFilesFrom[ii], strGroupPath + vsFilesTo[ii]);
	//}
	//
	//return true;
//}
//------ End CENTRALIZE_GET_SET_CODE_IN_GROUPMGR
