/*------------------------------------------------------------------------------*
 * File Name: GraphObjTools.h 													*
 * Creation: Sim 01-08-2010														*
 * Purpose: OriginC Header H file												*
 * Copyright (c) Originlab Corp. 2006											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS								*
 *	Sophy 1/18/2010 CLEAN_CODE_SUPPORT_FLEXIBLE_COLOR_SETTING_ACCESS			*
 *	Sophy 1/19/2010 QA80-14832 ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS	*
 *	Sophy 1/19/2010 QA80-14832 SHOW_TOOLNAME_FOR_ROI_TOOLS						*
 *	Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT						*
 *	Sophy 2/2/2010 RESET_TOP_LABEL_POS_WHEN_CHANGE_FUNC_OR_PREFERENCES			*
 *	Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU				*
 *	Sophy 2/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY			*
 *	Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
 *	Folger 02/04/10 SUPPORT_AUTO_FOR_X_SCALE									*
 *	Sophy 2/5/2010 FAIL_TO_LOAD_THEME_WITH_DUPLICATED_IDS						*
 *  Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU						*
 *	Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU						*
 *	Folger 02/23/10 ROI_TOOLS_DO_EXPAND_FAILS_TO_PLACE_BUTTONS_CORRECTLY		*
 *	Kenny 03/05/2010 QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR	*
 *	Kyle 03/08/2010 CUSTOM_CMD_IN_CONTEXT_MENU_OF_GRAPH_OBJ_TOOLS				*
 *	Kyle 03/12/2010 PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT							*
 *	Kyle 03/15/2010 IS_PLOT_FOR_ROI_GIVE_OPTION_TO_SPECIFY_THE_NAME_TO_TAG_A_DATAOBJ
 *	Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS			*
 *	Sophy 4/9/2010 QA81-15290 QUICK_STATS_SHOW_PREVIEW_LINE_LABELS				*
 *	Foler 04/12/10 QA81-15288 QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2			*
 *	Sophy 4/13/2010 SUPPORT_CHANGE_DERIV_ORDER_FROM_CONTEXT_MENU				*
 *	Sophy 4/14/2010 BACKWORD_COMPATIBILITY_SUPPORT_FOR_GADGET_ATTACHMENTS		*
 *	Sophy 6/13/2010 ORG-23-S5 SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG		*
 *	Kyle 09/08/2010 ORG-998-P6 SHOW_BASELINE_INSIDE_THE_RECTANGLE_ONLY			*
 *	Sophy 10/15/2010 ORG-1263-P1 UPDATE_INDICATOR_SETTINGS_FOR_RISETIME_TOOL	*
 *	Folger 11/29/2010 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
 *	Folger 12/01/2010 ORG-1551-S5 SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK		*
 *	Folger 12/15/2010 ORG-1752-P1 QUICK_PEAKS_FAILED_TO_FIND_PREVIEW_DATA_WKS_IF_SOURCE_GRAPH_NAME_TOO_LONG
 *	Sophy 12/15/2010 ORG-1755-S1 SUPPORT_SEL_DATA_IN_GADGET_DLG					*
 *	Folger 01/04/2011 ORG-1065-P1 APPLY_SETTINGS_FROM_PREFERENCE_DIALOG_SHOULD_UPDATE_LAST_USED_THEME
 *	Hong 01/14/11 ORG-1944-P2 FIX_OLD_PRE_MARKER_NOT_REMOVED_WHEN_CHANGE_DATA	*
 *	Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
 *	Sophy 1/20/2011 ORG-2068-S1 GROBJTOOLS_REMEMBER_LAST_MAIN_OBJ_POSITION_SUPPORT
 *	Kit 02/14/2011 ORG-2229-P1 BRING_GADGET_TO_FONT_WHEN_SEL					*
 *	Kit 02/17/2011 ORG-2229-P2 MOVE_ALL_RELATE_OBJS_TO_TOP_WHEN_SEL_ROI_OBJS	*
 *	Folger 03/18/2011 ORG-2479-S1 MAKE_QUICKFIT_FOLLOW_GENERAL_GADGETS			*
 *	Folger 03/18/2011 ORG-2486-P1 QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE
 *	Folger 03/25/2011 MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET			*
 *	Sophy 3/28/2011 ORG-2536-P1 UPDATE_ROI_VERSION_FOR_COMPATIBILITY_ISSUES		*
 *	Folger 05/18/2011 ORG-2887-P2 QUICK_PEAKS_TOO_SLOW_ON_CELL_LINKED_DATA		*
 *	Sophy 6/10/2011 ORG-3046-S1 GADGET_NEW_DIALOG_FOR_SELECT_MULTIPLE_PLOTS		*
 *	Sophy 8/10/2011 ORG-3496-P1 QUICK_FIT_SUBPOPUP_CONTEXT_MENU_NOT_CHECKED_PROPERLY
 *  Sen 08/25/2011 ORG-2298-P2 MAKE_BASELINE_TAB_WORK_CORRECTLY					*
 *  Sen 08/29/2011 ORG-2298-P9 MAKE_FULL_RANGE_HATCH_AREA_CORRECT				*
 *	Sophy 10/13/2011 ORG-4031-P1 INTEG_GADGET_BASELINE_DATASET_LOST_FROM_851_TO_86
 *	Folger 03/01/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER							*
 *	Philip 07/18/2012 ORG-6183 INTEG_GAGDET_INCORRECT_DRAW_WHEN_USE_BASELINEMODE_UED_AND_EPW
 *------------------------------------------------------------------------------*/

#ifndef _GROBJ_TOOLS_H_
#define _GROBJ_TOOLS_H_

enum
{
	GROBJEVENTS_FROM_EVENT_FUNCTION			= 0x00010000,
	GROBJEVENTS_SELF_DELAY_EVENT			= 0x00020000,	///Sophy 7/19/2010 ORG-25-P8 MULTAI_GADGETS_ON_SAME_LAYER_FAIL_TO_UPDATE_CORRECTLY_ON_RESCALE
};

void graphobjtool_events(GraphObjTool& iTool, LPCSTR lpcszMainObjName, int nEvent, int nMsg = 0);
///Sophy 12/5/2011 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
int	graphobjtool_msg(GraphObjTool& iTool, LPVOID lpMsgInfo);
///end LT_OBJ_TO_CONTROL_GADGET_TOOLS
int	GlobalGadget_graphobjtool(GraphObjTool& iTool, int nMsg, WPARAM wParam, LPARAM lParam);	///------ Folger 03/01/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Sophy 9/13/2008 GRAPH_OBJ_TOOL

///Sophy 2/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY
#define	STR_VERSION_ATTRIB	(GetXFName() + "ROIVersion")
#define	STR_XFNAME_ATTRIB	"XFName"	///Sophy 3/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY need this attribute in storage to identify ROI tool type
///end VERSION_CHECKING_FOR_ROI_COMPATIBILITY
///Sophy 1/5/2010 QA80-14904-S1 CLEAN_CODE_FOR_ROI_TOOLS
enum {
	GOT_BTN_OUTPUT	= 0x0001,
	GOT_BTN_EDIT	= 0x0002,
	///Sophy 1/15/2010 ADD_EDIT_FUNCTION_LIST_IN_CONTEXT_MENU_FOR_QUICKFIT_ROI
	GOT_BTN_UPDATE_LIST	= 0x0003, //this CmdID is currently used for quick fit tool, but can also be used in other ROI classes
	///end ADD_EDIT_FUNCTION_LIST_IN_CONTEXT_MENU_FOR_QUICKFIT_ROI
	GOT_BTN_CLOSE	= 0x0004,
	GOT_BTN_LOCKED	= 0x0005,	///Sophy 1/6/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	GOT_BTN_FIT		= 0x0006,
	GOT_BTN_FINDXY	= 0x0007,
	GOT_BTN_CONTEXT	= 0x0008,
	GOT_BTN_GOTO_SOURCE	= 0x0009,	///Sophy 1/4/2011 ORG-1889-S1 ADD_GOTO_SOURCE_WORKSHEET_CONTEXT_FOR_CLUSTER_TOOL
	GOT_BTN_GOTO_REPORT	= 0x000A,	///Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
	GOT_BTN_UPDATE_LAST_OUTPUT	= 0x000B, /// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	GOT_BTN_SEL_ALL_PLOTS		= 0x000C,
	GOT_BTN_DATA_EDIT			= 0x000D,
	GOT_BTN_APPLY				= 0x000E,	///Sophy 6/13/2010 ORG-23-S5 SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG
	GOT_BTN_DATA_EDIT_APPLY		= 0x000F,	///Sophy 12/17/2010 ORG-1783-S1 APPLY_BUTTON_ON_DATA_EDIT_DLG_SUPPORT
	GOT_BTN_EXPAND_FULL_RANGE	= 0x0010,
	GOT_BTN_EXPAND_VERTICAL		= 0x0011,
	GOT_BTN_EXPAND_HORIZONTAL	= 0x0012,
	/// Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
	GOT_BTN_OUTPUT_MARKER_ONLY,
	/// end QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
	
	///Sophy 3/1/2011 ORG-2342-S1 GROBJTOOL_CONTEXT_MENU_FOR_MOVE_ROI_TO_SELECTION_POSITION
	GOT_MARKER_BEGIN	= 0x8000,
	GOT_MARKER_END		= 0x80FF,
	///end GROBJTOOL_CONTEXT_MENU_FOR_MOVE_ROI_TO_SELECTION_POSITION
	
	GOT_DATAPLOT_BEGIN	= 0x9000,
	GOT_DATAPLOT_LOCKED	= 0x91FA,
	///Sophy 2/14/2011 ORG-2225-P1 CLUSTER_GADGET_NEW_MENU_FOR_EDITING_DATA_POINTS
	GOT_DATAPLOT_INNER	= 0x91FB,
	GOT_DATAPLOT_OUTER	= 0x91FC,
	///end CLUSTER_GADGET_NEW_MENU_FOR_EDITING_DATA_POINTS
	GOT_DATAPLOT_USER	= 0x91FD,	///Sophy 6/10/2011 ORG-3046-S1 GADGET_NEW_DIALOG_FOR_SELECT_MULTIPLE_PLOTS
	GOT_DATAPLOT_ALL	= 0x91FE,
	GOT_DATAPLOT_END	= 0x91FF,
	///Sophy 1/19/2010 QA80-14832 ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS
	GOT_THEME_BEGIN			= 0x9200,
	GOT_THEME_SAVE_DEFAULT	= 0x92FD,
	GOT_THEME_SAVE			= 0x92FE,
	GOT_THEME_END			= 0x92FF,
	///end ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS
	///Jasmine 06/08/2011 ORG-3016-S2 ADD_SHOW_ASYMPTOTES_TO_MENU
	GOT_SHOW_ASYMPTOTES		= 0x9300,
	///End ADD_SHOW_ASYMPTOTES_TO_MENU
	///Sophy 8/10/2011 ORG-3496-P1 QUICK_FIT_SUBPOPUP_CONTEXT_MENU_NOT_CHECKED_PROPERLY
	//seems menuid for popup should not use higher word with VS2010 newer compiler //should not use 0x9400 on grpah layer, or else plots on this layer will be append at the end!!!
	GOT_FUNCTION_BEGIN		= 0x9500,
	GOT_FUNCTION_END		= 0x95FF,
	///end QUICK_FIT_SUBPOPUP_CONTEXT_MENU_NOT_CHECKED_PROPERLY
	///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	GOT_BTN_FIXED_MASK	= 0xFFFF0000,
	GOT_BTN_FLEX_MASK	= 0x0000FFFF,
	GOT_BTN_PLOTS		= 0x00010000,
	GOT_BTN_FUNCTION	= 0x00020000,
	
	GOT_CMD_CUSTOM		= 0x00040000,
};

enum {
	ROI_OPTION_IGNORE_EVENT		= 0x0001,
	ROI_OPTION_RESET_LABEL_POS	= 0x0002,	///Sophy 2/2/2010 RESET_TOP_LABEL_POS_WHEN_CHANGE_FUNC_OR_PREFERENCES
	ROI_OPTION_VERSION_CHECKED	= 0x0004,	///Sophy 2/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY
	ROI_OPTION_SCALE_CHANGED	= 0x0008,	///Sophy 2/8/2010 ROI_STATS_CURVE_NEED_TO_DELAY_HANDLE_SCALE_CHANGE
	ROI_OPTION_ON_MOVE_EVENT	= 0x0010,
	ROI_OPTION_IGNORE_DESTROY	= 0x0020,	///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	ROI_OPTION_DO_CONTEXT		= 0x0040,
	ROI_OPTION_UNDO_BEGIN		= 0x0080,	///Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	ROI_OPTION_INGORE_THIS		= 0x0100,	///Sophy 2/23/2011 ORG-2313-P1 GROBJCURVETOOL_NEED_OPTION_TO_BLOCK_THIS_TOOL_EVENTS
};

enum {
	ROI_OP_GET, 
	ROI_OP_SET,
	ROI_OP_REMOVE,
	ROI_OP_RESET,
	///Sophy 1/5/2012 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
	ROI_OP_REPLACE,
	ROI_OP_ADD,
	////end LT_OBJ_TO_CONTROL_GADGET_TOOLS
	///Sophy 12/14/2010 ORG-1704-S8 OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
	ROI_OP_TOGGLE,	
	ROI_OP_UPDATE,	//do nothing, just update GUI.
	///end OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
	///Sophy 2/23/2011 ORG-2313-P1 GROBJCURVETOOL_NEED_OPTION_TO_BLOCK_THIS_TOOL_EVENTS
	ROI_OP_GET_THIS,
	ROI_OP_SET_THIS,
	///end GROBJCURVETOOL_NEED_OPTION_TO_BLOCK_THIS_TOOL_EVENTS
	///Sophy 1/5/2012 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
	ROI_OP_MASK	= 0x00FF,
	ROI_OP_LT	= 0x0100,	//from Labtalk.
	///end LT_OBJ_TO_CONTROL_GADGET_TOOLS
};


enum {
	GADGET_EDIT_INNER_POINTS	= 0x0001,
	GADGET_DATA_ALLOW_LOCKED	= 0x0002,
	GADGET_DATA_STATS_ALL_PLOTS	= 0x0004,	///Sophy 2/15/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
};

/// Sen 08/25/2011 ORG-2298-P2 MAKE_BASELINE_TAB_WORK_CORRECTLY
///Sophy 10/21/2011 CENTRALIZE_BASELINE_RANGE_CODE
//enum
//{
	//BASELINE_RANGE_WITHIN_ROI= 0,
	//BASELINE_RANGE_FULL,			
//};
enum
{
	BASELINE_RANGE_FULL			= 0,
	BASELINE_RANGE_WITHIN_ROI,
};
///end CENTRALIZE_BASELINE_RANGE_CODE
/// End MAKE_BASELINE_TAB_WORK_CORRECTLY

///Sophy 6/10/2010 ORG-48-P14 BETTER_EVENT_HANDLE_FOR_PREFERENCE_IN_ROI_TOOLS
#define	STR_GETN_HANDLE			"GETNHandle"
#define	STR_EVENT_HANDLE		"GETNEVT"

#define	GETN_GLOBAL_EVT(_PFN)	{PEVENT_GETN __dfn = _PFN;ODWP _dw_fn = (ODWP)__dfn;\
 if(_dw_fn) {string strTemp = _dw_fn;_tmpSubNode.SetAttribute(STR_GETN_HANDLE, strTemp);}}

#define	GET_GETN_EVT(_Node, _pfn)	PEVENT_GETN _pfn = NULL; {string strTemp = ""; if(_Node)_Node.GetAttribute(STR_GETN_HANDLE, strTemp);\
 if (!strTemp.IsEmpty()) { ODWP _dw_fn = (ODWP)atoOIP(strTemp); _pfn = (PEVENT_GETN)_dw_fn;}}
///end ///Sophy 6/10/2010 ORG-48-P14 BETTER_EVENT_HANDLE_FOR_PREFERENCE_IN_ROI_TOOLS

///Sophy 6/13/2010 ORG-23-S5 SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG
#define	STR_MAINOBJ_NAME_ATTRIB	"MainObjName"
#define	STR_APPLY_HANDLE		"ApplyHandle"
#define	STR_APPLY_EVT			"APPLYEVT"
#define	GETN_APPLY_EVT(_PFN)	{PAPPLY_FUNC __dfn = _PFN;ODWP _dw_fn = (ODWP)__dfn;\
 if(_dw_fn) {string strTemp = _dw_fn;_tmpSubNode.SetAttribute(STR_APPLY_HANDLE, strTemp);}}
 	
#define	GET_APPLY_EVT(_Node, _pfn)	PAPPLY_FUNC _pfn = NULL; {string strTemp = ""; if(_Node)_Node.GetAttribute(STR_APPLY_HANDLE, strTemp);\
 if (!strTemp.IsEmpty()) { ODWP _dw_fn = (ODWP)atoOIP(strTemp); _pfn = (PAPPLY_FUNC)_dw_fn;}}
 	
bool	ROI_apply_handle(TreeNode& tr);
///end SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG

///Sophy 2/10/2010 QA81-15097 ROI_TOOLS_DONT_WORK_WHEN_XY_AXIS_EXCHANGED
bool	is_active_graphlayer_xyexchanged();
///end ROI_TOOLS_DONT_WORK_WHEN_XY_AXIS_EXCHANGED

int		roi_tool_option_access(DWORD dwTestBit, int nOption = 0);
#define	QUERY_ROI_TOOL_OPTION(_dwTestBit)		(roi_tool_option_access(_dwTestBit, ROI_OP_GET) ? TRUE : FALSE)
#define	REMOVE_ROI_TOOL_OPTION(_dwTestBit)		(roi_tool_option_access(_dwTestBit, ROI_OP_REMOVE))
#define	FLIP_ROI_TOOL_OPTION(_dwTestBit)		(roi_tool_option_access(_dwTestBit, ROI_OP_TOGGLE))
#define	SET_ROI_TOOL_OPTION(_dwTestBit)			(roi_tool_option_access(_dwTestBit, ROI_OP_SET))
///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
///Kyle 03/15/2010 IS_PLOT_FOR_ROI_GIVE_OPTION_TO_SPECIFY_THE_NAME_TO_TAG_A_DATAOBJ
//bool	is_plot_for_ROI(const DataPlot& dp, const GraphObject& gr, vector<int>& vnI1 = NULL, vector<int>& vnI2 = NULL);
bool	is_plot_for_ROI(const DataPlot& dp, const GraphObject& gr, LPCSTR lpcszTag = NULL, vector<int>& vnI1 = NULL, vector<int>& vnI2 = NULL);
///End IS_PLOT_FOR_ROI_GIVE_OPTION_TO_SPECIFY_THE_NAME_TO_TAG_A_DATAOBJ

bool	update_roi_position(GraphObject& go, double dLeft, double dRight, double dTop, double dBottom);

#define	STR_ROI_MAIN_OBJ_STORAGE	"ROIMainObjName"
bool	get_ROI_main_obj_name(const GraphLayer& gl, LPCSTR lpcszROIType, string& strObjName);
bool	set_ROI_main_obj_name(const GraphLayer& gl, LPCSTR lpcszROIType, LPCSTR lpcszObjName = NULL);
///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL

///Sophy 2/17/2011 ORG-2227-P1 MULTIPLE_GADGET_TOOLS_ON_SAME_GRAPH_NEED_VARYING_FILLING_COLOR
bool	access_ROI_fill_color(const GraphLayer& gl, int& nColor, int nOpt);
bool	update_auto_fill_color(TreeNode& trColor);
///end MULTIPLE_GADGET_TOOLS_ON_SAME_GRAPH_NEED_VARYING_FILLING_COLOR
///Kyle 03/12/2010 PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT
bool check_get_roi_x_position(const GraphLayer& gl, double& strLeft, double& strRight, LPCSTR lpcszRect = NULL);

int get_source_data_plot_index_from_ROI(const GraphObject& go);
///End PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT

///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
#define	GROBJCURVETOOL_GUI_COMMON_NODEID_BEGIN	(GET_USER_DATAID(0) + 1024)
enum {
	GROBJ_ROI_BOX_BRANCH_ID = GROBJCURVETOOL_GUI_COMMON_NODEID_BEGIN + 1,
	GROBJ_XSCALE_BRANCH_ID,
	GROBJ_XSCALE_FROM_ID,
	GROBJ_XSCALE_TO_ID,
	GROBJ_XSCALE_FIXED_ID,
	///Sophy 3/5/2011 ORG-2388-P1 GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
	GROBJ_POSITION_BRANCH_ID,
	GROBJ_POSITION_X_FROM_ID,
	GROBJ_POSITION_X_TO_ID,
	GROBJ_POSITION_Y_FROM_ID,
	GROBJ_POSITION_Y_TO_ID,
	///end GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
	//!!!new common node should be add before the following item!!!
	GROBJCURVETOOL_GUI_COMMON_NODEID_END,
};
int	grobjtool_construct_x_scale_branch(TreeNode& trParent);
bool	check_update_roi_x_position(TreeNode& trXScale, LPCSTR lpcszXFName);
///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
///Sophy 3/5/2011 ORG-2388-P1 GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
int grobjtool_construct_position_branch(TreeNode& trParent);
///end GROBJTOOL_XSCALE_SHOULD_DISPLAY_ACCORDING_TO_SOURCE_DATA_FORMAT
///Sophy 1/18/2010 QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS
class ROIToolOptionAccessHelper
{
public:
	ROIToolOptionAccessHelper(DWORD dwEventID)
	{
		if ( (m_dwEventID = QUERY_ROI_TOOL_OPTION(dwEventID) ? 0 : dwEventID) )
			roi_tool_option_access(dwEventID, ROI_OP_SET);
	}
	~ROIToolOptionAccessHelper()
	{
		if ( m_dwEventID )
			roi_tool_option_access(m_dwEventID, ROI_OP_REMOVE);
	}
private:
	DWORD	m_dwEventID;
};
///End QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS

///Sophy 2/23/2011 ORG-2313-P1 GROBJCURVETOOL_NEED_OPTION_TO_BLOCK_THIS_TOOL_EVENTS
class ROIToolEventBlockHelper
{
public:
	ROIToolEventBlockHelper(DWORD dwThis)
	{
		roi_tool_option_access(ROI_OPTION_INGORE_THIS, ROI_OP_SET);
		roi_tool_option_access(dwThis, ROI_OP_SET_THIS);
	}
	~ROIToolEventBlockHelper()
	{
		roi_tool_option_access(ROI_OPTION_INGORE_THIS, ROI_OP_REMOVE);
		roi_tool_option_access(0, ROI_OP_SET_THIS);
	}
};
///end GROBJCURVETOOL_NEED_OPTION_TO_BLOCK_THIS_TOOL_EVENTS
#define	STR_ROI_LABEL	_L("ROI Box")
#define	STR_PREFERENCES	_L("Preferences")
#define	STR_FILL_COLOR	_L("Fill Color")
/// Iris 2/01/2010 UPDATED_ACCORDING_TO_WIKI
//#define	STR_GOTO_REPORT	_L("Go to Report")
#define	STR_GOTO_REPORT	_L("Go to Report Worksheet")
///End UPDATED_ACCORDING_TO_WIKI
#define	STR_GOTO_SOURCE	_L("Go to Source Worksheet")
#define	STR_TOOLNAME	_L("Show Tool Name")
#define	STR_SHOW_PLOTS	_L("Change Data")
/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
//#define	STR_DO_OUTPUT	_L("Output Report")
#define	STR_DO_OUTPUT	_L("New Output")
#define	STR_UPDATE_LAST_OUTPUT	_L("Update Last Output")
///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
#define	STR_SAVE_THEME	_L("Save Theme...")	///Sophy 1/19/2010 QA80-14832 ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS
#define	STR_SAVE_THEME_DEFAULT	_L("Save as <default>")	///Sophy 1/5/2011 ORG-1906-S2 GROBJTOOL_SAVE_DEFAULT_THEME_SUPPORT
///------ Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
#define	STR_DO_THEMES	_L("Load Theme")
///------ End SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
#define	STR_DO_EDIT		_L("Preferences...")
#define	STR_EXPAND_FULL_RANGE	_L("Expand to Full Plot(s) Range")
#define	STR_EXPAND_VERTICAL		_L("Expand to Full Layer Height")
#define	STR_EXPAND_HORIZONTAL	_L("Expand to Full Layer Width")
///end CLEAN_CODE_FOR_ROI_TOOLS
///Sophy 1/6/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
#define	STR_LOCK_MAIN_OBJ		_L("Fix ROI Position")
///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
//----- CPY 9/17/08 CLEANUP_CODE_RELATED_TO_USING_BASE_CLASS_SET_TREE, I added code related to lpcszMainObjName to allow in constructor and optional for OnMove
class	GraphObjTool
{
public:
	GraphObjTool(LPCSTR lpcszMainObjName = NULL);
	BOOL	IsValidLayer() {if(m_gl) return true; else return false;}
	BOOL	IsValidGrObj() {if(m_go) return true; else return false;}
	BOOL	SetTree( const TreeNode& tr ); //Sophy, currently, we just need to save information of m_go( main graph object )
	BOOL	GetTree( TreeNode& tr );
	//virtual BOOL OnDestroy(){return true;}
	//---- CPY 9/27/08 CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS
	virtual void	OnEvent(int nEvent, int nMsg = 0);
	//----
	///Sophy 12/5/2011 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
	virtual	void	OnMessage(GadgetMsgPtr pMsg){ return; } //empty
	///end LT_OBJ_TO_CONTROL_GADGET_TOOLS

	///------ Folger 03/01/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER
	virtual	int		OnGlobalGadget(int nMsg, LPARAM lParam)	{ return -1; }
	virtual	int		Create(TreeNode& trGUI)					{ return -1; }
	///------ End GLOBAL_GADGET_MANAGER

	//----- CPY 9/17/08 CLEANUP_CODE_RELATED_TO_USING_BASE_CLASS_SET_TREE
	///---Sim
	//virtual BOOL Init();
	virtual BOOL Init(LPCSTR lpcszMainObjName);
	///---End Sim
	
	BOOL	GetMainObjName(string& strObjName);
	///Sophy 1/4/2010 QA80-14904-S1 SUPPORT_FLEXIBLE_ATTACHED_GROBJ_FOR_ROI_TOOLS
	//void	DestroyInternal();
	//virtual	bool	DoShowPlots(){ return false; }
	//virtual	bool	DoOutput(){return false;}
	//virtual	bool	DoEdit(){return false;}
	//virtual	bool	DoFunction(){ return false; }
	//virtual	bool	CheckAttachObjs(){ return false; }
	///end SUPPORT_FLEXIBLE_ATTACHED_GROBJ_FOR_ROI_TOOLS
	///Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	enum {
		UNDO_INCRE	= 0,
		UNDO_DECRE,
		UNDO_UNDOABLE,
	};
	BOOL		UndoControl(DWORD dwCtrl, int* pnBlockID = NULL);
	///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
private:
	bool	connectToObj(LPCSTR lpcszName);
	//void	saveClassInfo();
	//bool	readClassInfo();
	//-----
	///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	bool	saveClassInfo();
	bool	loadClassInfo();
	///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS

	///-----Kit 02/17/2011 ORG-2229-P2 MOVE_ALL_RELATE_OBJS_TO_TOP_WHEN_SEL_ROI_OBJS
	//string	getAttObjName(int nObjID);
protected:
	string	GetAttObjName(int ObjID);
	///-----End MOVE_ALL_RELATE_OBJS_TO_TOP_WHEN_SEL_ROI_OBJS
protected:
	///Sophy 3/2/2011 ORG-2313-P1 NOTIFY_GROBJS_WHEN_SOURCE_DATA_SERIES_CHANGE
	void	DelayTranslateMessage(int nEventID, int nMsg = 0);
	///end NOTIFY_GROBJS_WHEN_SOURCE_DATA_SERIES_CHANGE
	///Sophy 1/20/2011 ORG-2068-S1 GROBJTOOLS_REMEMBER_LAST_MAIN_OBJ_POSITION_SUPPORT
	bool	PrevMainObjPositionAccess(double* pdX1, double* pdX2, double* pdY1 = NULL, double* pdY2 = NULL, bool bGet = true);
	///end GROBJTOOLS_REMEMBER_LAST_MAIN_OBJ_POSITION_SUPPORT
	virtual	bool	IsSupportEditData(){ return false; }	
	///Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	int		GetUndoStack(vector<int>& vnUndoBlockIDs);
	int		SetUndoStack(const vector<int> vnUndoBlockIDs);
	///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	virtual	bool OnActivate(){ return CheckROIVersion(); }	///Sophy 12/14/2010 ORG-1704-S8 OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
	virtual	bool OnDeactivate(){ return true; }	///Sophy 4/6/2011 ORG-2592-P1 GROBJTOOLS_EVENTS_HANDLING_WHEN_PAGE_DEACTIVATE
	virtual	bool CheckROIVersion(){ return true; }	///Sophy 2/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY
	//---- CPY 9/27/08 CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS
	virtual void OnMoving();
	///Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	//virtual BOOL OnMove() {return true;}
	virtual	BOOL	OnMove();
	///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	//----
	virtual BOOL OnPreMove();

	/// Hong 01/14/11 ORG-1944-P2 FIX_OLD_PRE_MARKER_NOT_REMOVED_WHEN_CHANGE_DATA
	virtual BOOL OnBeforePlotChanged() { return TRUE; }
	/// end FIX_OLD_PRE_MARKER_NOT_REMOVED_WHEN_CHANGE_DATA
	/// Kenny 03/05/2010 QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR
	virtual BOOL OnPlotChanged()	{ return TRUE; }
	/// End QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR
	
	/// Fisher 7/20/09 QA80-13975 	HANDLE_RESCALE_EVENT_FOR_GRAPH_OBJ_TOOL
	///Sophy 12/3/2009 QA80-14686 CENTRALIZE_CODE_FOR_UPDATE_RESULT_ON_RESCALE_GRAPH
	//virtual BOOL OnRescale() {return true;}
	virtual	BOOL IsDelayUpdate(){ return TRUE; }	///Sophy 2/8/2010 ROI_STATS_CURVE_NEED_TO_DELAY_HANDLE_SCALE_CHANGE
	virtual BOOL OnRescale() { return InvalidateResults();}
	virtual BOOL InvalidateResults(){ return OnMove(); }
	///end CENTRALIZE_CODE_FOR_UPDATE_RESULT_ON_RESCALE_GRAPH
	/// End HANDLE_RESCALE_EVENT_FOR_GRAPH_OBJ_TOOL
	///Sophy 12/4/2009 QA80-14799 EXPOSE_DATAMASK_EVENT_TO_OC_GRAPHOBJECT
	virtual	BOOL OnMasked(){ return InvalidateResults();}
	///end EXPOSE_DATAMASK_EVENT_TO_OC_GRAPHOBJECT
	
	//---- CPY 9/26/08 QA70-12266 ADDTOOL_XF_NEEDS_PROJ_VAR_TO_INDICATE_THEY_ARE_STILL_ACTIVE
	virtual string GetSignature() {
		ASSERT(false);
		return "xf_addtool_unknown";
	}
	int 	GetTotalNumTools();
	virtual BOOL OnDestroy();
	bool	Attach(LPCSTR lpcszMainObjName);//---- CPY 9/27/08 CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS
	///Jasmine 02/27/09 GraphVerticalCursor_WANT_IT_PROTECTED
	int 	referenceCount(bool bInc); // true to increment, false to decrement
	///End GraphVerticalCursor_WANT_IT_PROTECTED
	
	///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	virtual bool	SaveClassInfo(TreeNode& tr) { return true; }
	virtual bool	LoadClassInfo(const TreeNode& tr) { return true; }
	///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
private:

	///Sandy 2008-12-23 add
	virtual void 		getBoundingBoxInfo(string& str);
	//end 
	
protected:
	//-----
	// returns <0 for err, 1 if already existed and type correct then just get out, 0 if normal creation on empty slot
	// nParam if > 0 might be used for additional setting, like font size if text
	int		CreateAttachment(GraphObject& go, int nObjID, int nPos, int nObjType = GROBJ_TN_TEXT, LPCSTR lpcszInitText = NULL, int nParam = -1);
	int		GetAttachment(GraphObject& go, int nObjID);
	///Sophy 1/14/2010 MOVE_CLOSE_BUTTON_TO_BASE_CLASS
	virtual	string	GetXFName() { return ""; }
	virtual	int		CreateAttachments();
	virtual	int		GetAttachments();
	///end MOVE_CLOSE_BUTTON_TO_BASE_CLASS
	///Sophy 4/14/2010 BACKWORD_COMPATIBILITY_SUPPORT_FOR_GADGET_ATTACHMENTS
	virtual	int		CheckCreateAttachments(){ return 0; }
	///end BACKWORD_COMPATIBILITY_SUPPORT_FOR_GADGET_ATTACHMENTS

	///-------Sandy 2008-12-9 add color option
	///----- Sandy 2008-12-2 add ployline as one kind of free line
	//int		CreateAttachedFreeLine(GraphObject* pgo=NULL, int nFreePos = 0);
	//int		CreateAttachedFreeLine(GraphObject* pgo=NULL, int nFreePos = 0,  int nLineType = GROBJ_TN_LINE2);
	int		CreateAttachedFreeLine(GraphObject* pgo=NULL, int nFreePos = 0,  int nLineType = GROBJ_TN_LINE2, int nColor = SYSCOLOR_BLACK);
	
	///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	////----- CPY 9/17/08 CLEANUP_CODE_RELATED_TO_USING_BASE_CLASS_SET_TREE
	////int		GetAttachmentCount();
	//// this is just a utility function but I see no better place to put this so leave here for now.
	void AddNewLine(string& str, string strNew);
	////-----
	///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	virtual	int*	GetXFEventHandlersState() { return NULL; }	///Sophy 6/10/2010 ORG-48-P14 BETTER_EVENT_HANDLE_FOR_PREFERENCE_IN_ROI_TOOLS move from derived class

	///Sophy 1/5/2010 QA80-14904-S1 CLEAN_CODE_FOR_ROI_TOOLS
	//virtual	int		CreateAdvancedButtons(LPCSTR lpcszXFName, DWORD dwCtrl = GOT_BTN_PLOTS | GOT_BTN_OUTPUT | GOT_BTN_EDIT | GOT_BTN_CLOSE);
	///end CLEAN_CODE_FOR_ROI_TOOLS
	
protected:
	GraphPage 	m_gp;
	GraphLayer 	m_gl;
	GraphObject m_go;
	GraphObject m_goClose;
	string		m_strGrName;
	
	vector<int>		m_vnObjIDs;
	vector<string>	m_vsObjNames;
	//vector<int>		m_vnObjTypes;
	//vector<int>		m_vnObjPositions;
	OGRGAP		m_gapCtrl;

private:
	int				m_nRightTopObjs;
};
///end GRAPH_OBJ_TOOL

GraphObject& get_master_gr(GraphObject &go);/// Fisher 2008-9-19

//---- CPY 9/27/08 CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS
enum {
	GCTC_FREE_FORM_RECT = 0x0001,
};
//---- end

///Sophy 12/17/2009 QA80-14598-P4 RISE_TIME_TOOL_NEED_CREATE_LONGNAME_IN_RESULT_COLUMN
//!!!! new enum item should all use high 32bits of the DWORD, as these value will be combined with TREE2STR_CHECK_USER_LABEL, etc. !!!!//
enum {
	OUTTREE_USE_TAGNAME_IN_SCRIPT_WIN = 0x00010000,
};
///end RISE_TIME_TOOL_NEED_CREATE_LONGNAME_IN_RESULT_COLUMN

///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
enum {
	GOT_OBJ_PLOTS	= 1,
	GOT_OBJ_OUTPUT,
	GOT_OBJ_EDIT,
	GOT_OBJ_CLOSE,
	GOT_OBJ_FUNCTION,
	GOT_OBJ_CONTEXT,
	GOT_OBJ_LABEL,
	GOT_OBJ_NAME,
	GOT_OBJ_TOTAL,
};
///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS

enum {
	SHAPE_RECT,
	SHAPE_CIRCLE,
};

enum {
	DATA_SELECTED_CURVE,
	DATA_ALL_CURVES
};

///Sophy 5/4/2010 QA82-15364-P2 ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
enum {
	GROBJ_MASKED_AS_MISSING		= GDPS_AFTER_MASK,	//0x0001, use in VC level
	GROBJ_SKIP_ALL_MASKED_DATA	= 0x00010000,		//use high word as in OC level
};
#define	GROBJ_DATA_DEFAULT	(GROBJ_MASKED_AS_MISSING | GROBJ_SKIP_ALL_MASKED_DATA)
///end ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
/// Fisher 2008-9-13	GRAPH_OBJ_CURVE_TOOL
class GraphObjCurveTool : public GraphObjTool
{
public:
	GraphObjCurveTool(LPCSTR lpcszMainObjName = NULL);
	///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	virtual BOOL Init(LPCSTR lpcszMainObjName);
	///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	///Sophy 8/21/2009 QA80-14175 CREATE_ALL_NODES_IN_ONE_TREE_TO_GET_RID_OF_OPTIONS_BRANCH
	//int 	Create(LPCSTR lpcszOCFuncName, int color, DWORD dwCntrl = 0, const TreeNode& trGUI = NULL); //---- CPY 9/27/08 CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS	
	int 	Create(LPCSTR lpcszOCFuncName, DWORD dwCntrl = 0, const TreeNode& trGUI = NULL, int nROIShape = SHAPE_RECT); //---- CPY 9/27/08 CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS	
	///end CREATE_ALL_NODES_IN_ONE_TREE_TO_GET_RID_OF_OPTIONS_BRANCH
	
	///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	//virtual bool	CreateAttachObjs();
	///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	
	virtual void	OnEvent(int nEvent, int nMsg = 0);
	///Sophy 12/5/2011 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
	virtual	void	OnMessage(GadgetMsgPtr pMsg);
	///end LT_OBJ_TO_CONTROL_GADGET_TOOLS

	///------ Folger 03/01/2012 ORG-4970-S1 GLOBAL_GADGET_MANAGER
	virtual	int		OnGlobalGadget(int nMsg, LPARAM lParam);
	virtual	int		Create(TreeNode& trGUI);
	///------ End GLOBAL_GADGET_MANAGER

	bool	DoContext();

	///------ Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
	void			UpdateAttribsInGUITree(TreeNode& trGUI);
	///------ End CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
	///Sophy 6/13/2010 ORG-23-S5 SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG move from protected
	///Sophy 1/6/2011 ORG-1065-P1 CENTRALIZE_CODE_UPDATE_LAST_USED_THEME_ON_GUI_CHANGE
	//bool	SetGUITree(const TreeNode& trGUI);
	bool	SetGUITree(const TreeNode& trGUI, bool bUpdateLastUsedTheme = false);	
	///end CENTRALIZE_CODE_UPDATE_LAST_USED_THEME_ON_GUI_CHANGE
	///end SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG

	///------ Folger 01/04/2011 ORG-1065-P1 APPLY_SETTINGS_FROM_PREFERENCE_DIALOG_SHOULD_UPDATE_LAST_USED_THEME
	///Sophy 1/6/2011 ORG-1065-P1 CENTRALIZE_CODE_UPDATE_LAST_USED_THEME_ON_GUI_CHANGE
	//BOOL			SetGUITreeUpdateLastUsed(const TreeNode& trGUI);
	///end CENTRALIZE_CODE_UPDATE_LAST_USED_THEME_ON_GUI_CHANGE
	///------ End APPLY_SETTINGS_FROM_PREFERENCE_DIALOG_SHOULD_UPDATE_LAST_USED_THEME

	virtual	BOOL	SetReportWorksheet(LPCSTR lpcszWorksheetName){ return FALSE; } ///Sophy 6/25/2010 ORG-25-P5 UPDATE_REPORT_SHEET_NAME_FROM_GADGETTOOL_DLG
	///Sophy 2/15/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
	virtual	BOOL	GetPlotsForStats(vector<int>& vnPlots){ return FALSE; }
	virtual	BOOL	SetPlotsForStats(const vector<int>& vnPlots){ return FALSE; }
	virtual	BOOL	UpdateTableMenu(Menu& menu){ return FALSE; }
	virtual	BOOL	OnStatsPlotsChange(int nCmdID){ return FALSE; }
	///end CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
	virtual	BOOL	DoToolControl(int nType, int nOpt){ return FALSE; }
	///Sophy 3/1/2011 ORG-2342-S1 GROBJTOOL_CONTEXT_MENU_FOR_MOVE_ROI_TO_SELECTION_POSITION
	BOOL	DoMoveCmd(int nCmdID);
	///end GROBJTOOL_CONTEXT_MENU_FOR_MOVE_ROI_TO_SELECTION_POSITION
	///Sophy 1/5/2012 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
	//BOOL	DoDataCmd(int nCmdID);
	BOOL	DoDataCmd(int nCmdID, DWORD dwCtrl = 0);
	///end LT_OBJ_TO_CONTROL_GADGET_TOOLS
	BOOL	DoThemeCmd(int nCmdID);
	BOOL	GetPlotsMenu(Menu& menu){ return ConstructPlotsMenu(menu); }
	BOOL	GetThemesMenu(Menu& menu){ return ConstructThemesMenu(menu); }
	BOOL	UpdateROIState(DWORD& dwState, bool bSet = true);
	BOOL	OnUpdateData(){ return UpdateData(); }
	virtual	BOOL	OnUndo();
	virtual	BOOL	IsUndoable();
	virtual	BOOL	ChangeShape(){ return FALSE; }
	virtual	BOOL	OnPreferences(HWND hWndParent = NULL){ return DoEdit(hWndParent); }
	virtual	BOOL	OnActivateResult(){ return DoActiveReport(); }
	virtual	BOOL	GetSourceWorksheet(Worksheet& wks) { return FALSE; }
	virtual	BOOL	OnActivateSource(){ return FALSE; }
	virtual	BOOL	OnResetPosition();
	virtual	BOOL	OnCopyData() { return FALSE; }
	BOOL	GetSelectedPlots(vector<int>& vnPlots);
	BOOL	SetSelectedPlots(const vector<int>& vnPlots);
	BOOL	ExpandFullRange();
	BOOL	ExpandHorizontal();
	BOOL	ExpandVertical();
	BOOL	IsAllPlotsAllowEdit();	///Sophy 1/6/2011 ORG-1934-P1 UPDATE_GADGET_CONTROL_ON_SELECT_LOCKED_PLOTS

	///------ Folger 03/25/2011 MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET
	virtual	void		ApplyAfterEdit(TreeNode& trGUI);
	///------ End MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET
protected:
	///Sophy 1/5/2012 ORG-4519 LT_OBJ_TO_CONTROL_GADGET_TOOLS
	BOOL	SaveTheme(LPCSTR lpcszThemeFile);
	BOOL	LoadTheme(LPCSTR lpcszThemeFile);
	///end LT_OBJ_TO_CONTROL_GADGET_TOOLS
	///Sophy 4/8/2011 ORG-2026-P1 PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED
	BOOL			CreateMainObj(GraphObject& goMainObj, double dX0, double dY0, double dX1, double dY1, int nColor, int nDirection, int nShape = SHAPE_RECT);
	///end PROPER_CREATE_ROI_TOOLS_WHEN_XY_AXIS_EXCHANGED
	///Sophy 1/7/2011 ORG-1934-P4 STATS_DOES_NEED_SHOW_LOCKED_PLOTS_CONTROL_MENU
	virtual	BOOL	IsShowLockedPlotsMenu() { return FALSE; }
	///end STATS_DOES_NEED_SHOW_LOCKED_PLOTS_CONTROL_MENU
	///Sophy 1/6/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	//virtual	BOOL	IsAllowLockedROI() { return FALSE; }
	//virtual	TreeNode	GetGUILockNode(TreeNode& trGUI) { ASSERT(false); TreeNode trJunk; return trJunk; }
	virtual	BOOL	IsAllowLockedROI() { return TRUE; }
	virtual	TreeNode	GetGUILockNode(TreeNode& trGUI) {if ( trGUI ) return trGUI.roi.xScale.fixscale; }
	///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	BOOL	UpdateGUILockNode(int nOp = ROI_OP_GET, int* pnLockState = NULL);
	BOOL	OnLockROI();
	///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	virtual	BOOL	IsAllowFullWidth() { return FALSE; }
	virtual	BOOL	IsAllowFullHeight() { return FALSE; }
	///Sophy 2/5/2010 FAIL_TO_LOAD_THEME_WITH_DUPLICATED_IDS
	virtual	bool	UpdateBranchIDs(TreeNode& trGetN, TreeNode& trGUI);
	///end FAIL_TO_LOAD_THEME_WITH_DUPLICATED_IDS
		
	///Sophy 2/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY
	bool	SetVersion();
	///Sophy 3/28/2011 ORG-2536-P1 UPDATE_ROI_VERSION_FOR_COMPATIBILITY_ISSUES
	//virtual	double	GetVersion(){ return 8.102; } //set current ROI tools' version to 81SR2, if any tool's version updated, need to overwrite this member and return a bigger value.
	virtual	double	GetVersion(){ return 8.1851; } //set current ROI tools' version to 81SR2, if any tool's version updated, need to overwrite this member and return a bigger value.
	///end UPDATE_ROI_VERSION_FOR_COMPATIBILITY_ISSUES
	//virtual
	bool	CheckROIVersion();
	///end VERSION_CHECKING_FOR_ROI_COMPATIBILITY

	///------ Foler 04/12/10 QA81-15288 QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2
	BOOL	RemakeGUITree();
	///------ End QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2
	///Sophy 10/13/2011 ORG-4031-P1 INTEG_GADGET_BASELINE_DATASET_LOST_FROM_851_TO_86
	virtual	BOOL	BeforeUpdateGUITree(TreeNode& trSrc, TreeNode& trDst){ return FALSE; }
	virtual	BOOL	AfterUpdateGUITree(TreeNode& trSrc, TreeNode& trDst){ return FALSE; }
	///end INTEG_GADGET_BASELINE_DATASET_LOST_FROM_851_TO_86

	//---- CPY 10/1/08 MOVE_DATA_DISPLAY_CODE_TO_BASE_CLASS
	//virtual BOOL GetData(DataPlot& dp, int& i1, int& i2);
	///Sophy 5/4/2010 QA82-15364-P2 ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
	//virtual 	BOOL GetData();
	virtual BOOL		GetData(DWORD dwCtrl = GROBJ_DATA_DEFAULT);	//I do NOT think this method needs to be virtual member.
	///end ///Sophy 5/4/2010 QA82-15364-P2 ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
	//----
	/// YuI 10/09/08 QA70-12265-P3 CURVE_STATS_QUICK_TOOL_MUST_BE_SMARTER
	///Sophy 12/14/2009 QA80-14686-P2 DATAPLOT_GET_DATAPOINTS_NEED_TO_SKIP_MASKED_DATA
	//virtual 	BOOL GetData(vector& vX, vector& vY	);
	 BOOL		GetData(vector& vX, vector& vY, DWORD dwCtrl = 0);
	///end DATAPLOT_GET_DATAPOINTS_NEED_TO_SKIP_MASKED_DATA
	/// end CURVE_STATS_QUICK_TOOL_MUST_BE_SMARTER

	///Sophy 1/25/2010 SHOW_WARNING_ON_NOT_GETTTING_ENOUGH_DATA_POINTS
	virtual		int	GetPointsLimit(){ return 2; }
	///end SHOW_WARNING_ON_NOT_GETTTING_ENOUGH_DATA_POINTS

	///Sophy 8/26/2009 QA80-14169 MAKE_GRAPHOBJECT_FOR_PROGRAMMING_CONTROL_PRINTABLE
	virtual	bool	MakePrintable(GraphObject& go) { return set_go_printable(go); }
	///end MAKE_GRAPHOBJECT_FOR_PROGRAMMING_CONTROL_PRINTABLE
	///Sophy 8/21/2009 QA80-14175 CREATE_ALL_NODES_IN_ONE_TREE_TO_GET_RID_OF_OPTIONS_BRANCH
	int		UpdateMainRect(const TreeNode& trGUI);
	///end CREATE_ALL_NODES_IN_ONE_TREE_TO_GET_RID_OF_OPTIONS_BRANCH
	// return < 0 if no preview graph, 1 = initial show, 0 = already shown 
	// this function will always check and create wks if has been deleted by user
	int		CheckShowPreview();
	// return < 0 if no temp wks, 1 = initial wks, 0 = already have temp wks 	
	// this function used when there is wks but no separate preview graph 
	int		CheckPreviewDataWks(bool bCreate = true);//---- CPY 7/20/09 QA70-13575 HANDLE_RESCALE_EVENT_FOR_GRAPH_OBJ_TOOL added bCreate
	string	GetPreviewGraphName() {return m_strPreviewGraphName;}
	//---- CPY 9/27/08 CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS
	///Sophy 6/13/2010 ORG-23-S5 SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG
	//bool	SetGUITree(const TreeNode& trGUI); move to public
	///end SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG
	bool	GetGUITree(Tree& trGUI);
	bool	SetResultsTree(const TreeNode& trResults);
	virtual bool GetResultsTree(TreeNode& trResults);
	bool    GetResultsTree(TreeNode& trResults, LPCSTR lpcszTagName);///Sandy add 2009-2-24 get result tree by clone sub-tree of gui
	void	ConnectToTempPreviewDataAndGraph(); 
	//virtual
	BOOL	OnDestroy();
	//
	//virtual 
	BOOL OnMove();
	//---- end CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS
	
	void 	OutputResultTree(bool bToScript, bool bToResLog, bool bAppendWks, string strWksPageName, DWORD dwCtrl);///Sandy 2009-2-25 add CENTRALIZE_TO_BASE_CLASS_GROBJ_UTILS
	void 	GetRectCoordinate(double& dLeft, double& dRight, double& dTop = NULL, double& dBottom = NULL);
	
	///Sophy 11/26/2009 EVT_HANDLER_IN_TREENODE_INVALID_WHEN_RESTART_ORIGIN
	void	UpdateGUITree(TreeNode& trGUI);
	virtual	string	GetXFName(){ return ""; }
	virtual	string	GetToolName(){ return ""; } ///Sophy 1/22/2010 CENTRALIZE_OPEN_PREFERENCE_DIALOG_TO_BASE_CLASS
	virtual	string	GetPreferenceTitle(){ return ""; }
	virtual	BOOL	GetReportWorksheet(Worksheet& wksReport){ return FALSE; }	///Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
	///EVT_HANDLER_IN_TREENODE_INVALID_WHEN_RESTART_ORIGIN
	///Sophy 1/18/2010 CLEAN_CODE_SUPPORT_FLEXIBLE_COLOR_SETTING_ACCESS
	virtual	TreeNode	GetFillColorNode(const TreeNode& trGUI);
	///end CLEAN_CODE_SUPPORT_FLEXIBLE_COLOR_SETTING_ACCESS
	///Sophy 1/19/2010 QA80-14832 SHOW_TOOLNAME_FOR_ROI_TOOLS
	virtual	TreeNode	GetToolNameNode(const TreeNode& trGUI);
	///end SHOW_TOOLNAME_FOR_ROI_TOOLS
	virtual	bool	UpdateAttachments(){ return false; }	///Sophy 10/15/2010 ORG-1263-P1 UPDATE_INDICATOR_SETTINGS_FOR_RISETIME_TOOL
	
	/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
	// return the left x scale and right x scale value.
	/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	//virtual bool CheckGetMainObjectXPositionFromGUITree(const TreeNode& trGUI, double& x0, double& x1) { return false; }
	///Sophy 3/5/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	//virtual bool CheckGetMainObjectXPositionFromGUITree(const TreeNode& trGUI, double& x0, double& x1, bool& bFixWidth) { return false; }
	///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	//virtual bool CheckGetMainObjectPositionFromGUITree(const TreeNode& trGUI, double& x0, double& x1, bool& pbFixWidth, double& y0, double& y1) { return false; }
	virtual bool CheckGetMainObjectPositionFromGUITree(const TreeNode& trGUI, double& x0, double& x1, bool& pbFixWidth, double& y0, double& y1);
	virtual	bool UpdateXScaleSettings();
	void		CheckUpdateMainObjPosition();
	///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	virtual bool CheckSetMainObjectXPosition(double& x0, double& x1);
	///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
	///Kyle 09/08/2010 ORG-998-P6 SHOW_BASELINE_INSIDE_THE_RECTANGLE_ONLY
	virtual bool GetMainObjectXPosition(double& x0, double& x1);
	///End SHOW_BASELINE_INSIDE_THE_RECTANGLE_ONLY
	
	///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	virtual bool	SaveClassInfo(TreeNode &tr);
	virtual bool	LoadClassInfo(const TreeNode &tr);
	///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	
	///Sophy 1/4/2010 QA80-14904-S1 SUPPORT_FLEXIBLE_ATTACHED_GROBJ_FOR_ROI_TOOLS
	void	Destroy();
	//virtual	bool	DoShowPlots(); CPY 2/2/10 QA81-15066 CONTEXT_MENU_POPUP_POSITION_MAKE_CONSISTENT removed
	/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	//virtual	bool	DoOutput(){ return false; }
	/// Hong 01/20/11 ORG-2067-S2 QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
	//virtual	bool	DoOutput(bool bUpdateLastOutput){ return false; }
	virtual	bool	DoOutput(bool bUpdateLastOutput, bool bMarkerOnly = false){ return false; }
	/// end QUICK_PEAK_ALLOW_OUTPUT_PEAK_MARKERS_WITHOUT_OUTPUT_TO_WKS
	///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
	virtual	bool	IsCloneMainObj(){ return false; }
	bool	SetCloneMainObjName(LPCSTR lpcszName, LPCSTR lpcszTextName);
	bool	GetCloneMainObjName(string& strName, string& strTextName);
	///end CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
	virtual	bool	DoEdit(HWND hWndParent = NULL);
	//virtual	bool	DoFunction(){ return false; }
	virtual	bool	UpdateInnerAttachments();
	//virtual	bool	CheckAttachObjs(){ return false; }
	///end SUPPORT_FLEXIBLE_ATTACHED_GROBJ_FOR_ROI_TOOLS
	
	///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	//virtual
	int		CreateAttachments();
	//virtual
	int		GetAttachments();
	///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	
	bool	UpdateTopLabel(LPCSTR lpcszText = NULL, bool bShow = true);	///Sophy 1/23/2010 MAKE_QUICK_CURVE_STATS_AS_STANDARD_ROI_TOOL
	bool	SetLabelTransparent(GraphObject& goLabel);	///Sophy 4/12/2010 QA81-15290 LABELS_INSIDE_ROI_SHOULD_NOT_BE_WHITEOUT
	int		AddPlots(Menu& pm, uint& nPosition);
	///Sophy 3/1/2011 ORG-2342-S1 GROBJTOOL_CONTEXT_MENU_FOR_MOVE_ROI_TO_SELECTION_POSITION
	int		AddMarkers(Menu& pm, uint& nPosition, DWORD dwFlag);
	///end GROBJTOOL_CONTEXT_MENU_FOR_MOVE_ROI_TO_SELECTION_POSITION
	///Sophy 12/15/2010 ORG-1755-S1 SUPPORT_SEL_DATA_IN_GADGET_DLG
	bool	ConstructPlotsMenu(Menu& pm);
	///end SUPPORT_SEL_DATA_IN_GADGET_DLG
	bool	ConstructThemesMenu(Menu& thm);
	///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	virtual	bool	IsPlotForROI(const DataPlot& dp);
	virtual	bool	UpdatePlotsMenu(Menu& pm, uint& nPosition);
	virtual	bool	IsSupportMultiPlots() { return false; }
	virtual	bool	SetMultiPlotsState(bool bOn = true);
	bool	DoSelAllPlots();
	bool	GetMultiPlotsState();
	bool	AddDataEdit(Menu& pm, uint& nPosition);
	bool	DoEditData(HWND hWndParent = NULL);
	bool	UpdateData();
	///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	virtual bool AddUpdateLastOutputSubmenu(Menu& pm, uint& nPosition) { return false; }
	///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	///Kyle 03/08/2010 CUSTOM_CMD_IN_CONTEXT_MENU_OF_GRAPH_OBJ_TOOLS
	virtual bool OnCmdCustom(int nCmdID)		{	return false;	}
	///End CUSTOM_CMD_IN_CONTEXT_MENU_OF_GRAPH_OBJ_TOOLS
	bool	AddGotoReport(Menu& pm, uint& nPosition);	///Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
	bool	AddGotoSource(Menu& pm, uint& nPosition);	///Sophy 1/4/2011 ORG-1889-S1 ADD_GOTO_SOURCE_WORKSHEET_CONTEXT_FOR_CLUSTER_TOOL
	bool	DoActiveReport();	///Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
	bool	DoExpand();
	bool	DoSaveTheme();	///Sophy 1/19/2010 QA80-14832 ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS
	bool	DoSaveThemeDefault();	///Sophy 1/5/2010 ORG-1906-S2 GROBJTOOL_SAVE_DEFAULT_THEME_SUPPORT
	bool	CheckUpdateToolName();	///Sophy 1/19/2010 QA80-14832 SHOW_TOOLNAME_FOR_ROI_TOOLS
	bool	OnSetPlot(int nIndex); 	///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	bool	SetPlot(int nIndex);
	virtual bool 	GetSelectedPlot(DataPlot& dp); /// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	virtual	bool	UpdateContextMenu(Menu& pm, uint& nPosition){ return false; }
	bool	RemoveMenu(Menu& pm, uint& nPosition, uint nDeletePos = 0); //since in XF it is impossible to call member function without including Control.h(but we are not suggested to use dialog relative header in XF)
	virtual	bool	DoFit(){ return false; }
	virtual	bool	DoFindXY(){ return false; }
	virtual	bool	SetFunction(int nIndex){ return false; }
	///Sophy 1/15/2010 ADD_EDIT_FUNCTION_LIST_IN_CONTEXT_MENU_FOR_QUICKFIT_ROI
	virtual	bool	DoUpdateList(){ return false; }
	///end ADD_EDIT_FUNCTION_LIST_IN_CONTEXT_MENU_FOR_QUICKFIT_ROI
	virtual	bool	UpdateThemeTree(TreeNode& trThemeTree);	///Sophy 1/21/2010 QA80-14832 DISPLAY_DEFAULT_THEME_NAME_WHEN_SAVE_THEME_FOR_ROI_TOOL

	///------ Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
	string			GetCurrentThemeName();
	///------ End CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS

	///------ Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
	virtual	bool	UpdateROIGUI();
	virtual	bool	DoFunction()	{ ASSERT(FALSE); return false; }
	
	/// Iris 2/25/2010 TO_FIX_ALWAYS_CHANGE_LAYER_SCALE_WHEN_EXPAND_FULL_RANGE
	void	BeforeExpandRect(DataPlot& dp, double& dMinX, double& dMaxX, double& dMinY, double& dMaxY);
	///End TO_FIX_ALWAYS_CHANGE_LAYER_SCALE_WHEN_EXPAND_FULL_RANGE
	///Sophy 4/8/2010 EXPAND_FULL_RANGE_SUPPORT_MULTIPLE_DATAPLOTS
	void	ExpandROI(double dMinX, double dMaxX, double dMinY, double dMaxY);
	///end EXPAND_FULL_RANGE_SUPPORT_MULTIPLE_DATAPLOTS

	void			AddThemes(Menu& pm);

	virtual	void	UpdateGUIOnThemeChange(TreeNode& trGUI);
	///------ End SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU

	///------ Folger 02/23/10 ROI_TOOLS_DO_EXPAND_FAILS_TO_PLACE_BUTTONS_CORRECTLY
	///Sophy 2/28/2011 ORG-1930-S1 ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	//virtual	BOOL	IsExpandable()		{ return TRUE; }
	virtual	BOOL	IsExpandable();
	///end ADD_LOCK_ROI_BOX_OPTION_FOR_GROBJTOOL
	virtual	void	DoExpand(DataPlot& dp);
	///------ End ROI_TOOLS_DO_EXPAND_FAILS_TO_PLACE_BUTTONS_CORRECTLY
	
	///Sophy 4/9/2010 QA81-15290 QUICK_STATS_SHOW_PREVIEW_LINE_LABELS
	virtual	bool	CloneAttachments(GraphObject& goCloneMain);
	bool		CloneAndConnect(GraphObject& goMain, GraphObject& goSrc);
	///end QUICK_STATS_SHOW_PREVIEW_LINE_LABELS
	
	///Sophy 4/13/2010 SUPPORT_CHANGE_DERIV_ORDER_FROM_CONTEXT_MENU
	bool		InsertPopup(Menu& pm, uint nPosition, LPCSTR lpcszLabel, const vector<string>& vsItems, const vector<int>& vnCmdIDs, int nCheckIndex = -1);
	bool		InsertMenuItem(Menu& pm, uint nPosition, LPCSTR lpcszLabel, int nCmdID, UINT nFlags);
	///end SUPPORT_CHANGE_DERIV_ORDER_FROM_CONTEXT_MENU

	///------ Folger 11/29/2010 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
	virtual	BOOL	BranchAsTab()		{ return TRUE; }
	///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS

	///------ Folger 12/15/2010 ORG-1752-P1 QUICK_PEAKS_FAILED_TO_FIND_PREVIEW_DATA_WKS_IF_SOURCE_GRAPH_NAME_TOO_LONG
	BOOL		PreviewDataWksNameAccess(BOOL bLoad);
	///------ End QUICK_PEAKS_FAILED_TO_FIND_PREVIEW_DATA_WKS_IF_SOURCE_GRAPH_NAME_TOO_LONG

	///------ Foler 04/12/10 QA81-15288 QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2
	virtual	BOOL		MakeTree(TreeNode& tr);
	///------ End QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2

	///-----Kit 02/14/2011 ORG-2229-P1 BRING_GADGET_TO_FONT_WHEN_SEL
	virtual bool		OnSelect();
	///-----End BRING_GADGET_TO_FONT_WHEN_SEL

	///Jasmine 06/08/2011 ORG-3016-S2 ADD_SHOW_ASYMPTOTES_TO_MENU
	virtual bool 		DoShowAsyptotes(){return true;}
	///End ADD_SHOW_ASYMPTOTES_TO_MENU
	
protected:	
	string		m_strGraphTemplate;
	string		m_strPreviewGraphName;
	string		m_strPreviewGraphLongName;
	string		m_strPreviewDataWksName;
	string		m_strPreviewDataWksLongName;
	//WorksheetPage m_wp; CPY 9/13/08, no need for this as we assume only one sheet
	//GraphPage 	m_gpPreview;
	Worksheet	m_wks;
	GraphLayer	m_glPreview;
	///Sophy 1/5/2010 QA80-14904-S1 CLEAN_CODE_FOR_ROI_TOOLS
	GraphObject	m_goLabel;
	GraphObject	m_goPlots;
	GraphObject	m_goOutput;
	GraphObject	m_goEdit;
	GraphObject	m_goContext;
	GraphObject m_goToolName;
	///end CLEAN_CODE_FOR_ROI_TOOLS
	
	//---- CPY 10/1/08 MOVE_DATA_DISPLAY_CODE_TO_BASE_CLASS
	DataPlot	m_dp;
	int			m_i1, m_i2;
	double		m_x1, m_x2;
	///Sophy 1/7/2011 ORG-1845-S3 SHOW_MULTI_SELECTION_PLOTS_INFO_ON_DATA_DISPLAY_BOX
	vector<string>	m_vsPlotLegend;
	vector<int>	m_vI1, m_vI2;
	///end SHOW_MULTI_SELECTION_PLOTS_INFO_ON_DATA_DISPLAY_BOX
	//----
	vector		m_vX, m_vY;	///Sophy 5/4/2010 QA82-15364-P2 ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
private:
	///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
	bool		checkCloneMainObj();
	bool		updateLastCloneObjs();
	bool		cloneObj(GraphObject& goSrc, GraphObject& goDst);
	bool		connectObj(GraphObject& goMain, GraphObject& go); //connect without justify, for cloned object
	///end CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
	///Sandy 2008-12-23 add
	void 		getBoundingBoxInfo(string& str);
	//end 

	virtual		TreeNode	GetResultNode(TreeNode& trGUI, LPCSTR lpcszName);/// Sen 08/25/2011 ORG-2298-P2 MAKE_BASELINE_TAB_WORK_CORRECTLY
};
/// end	GRAPH_OBJ_CURVE_TOOL

///Sophy 10/21/2011 ORG-1931-S1 GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE
#define	SET_MODIFIED_OUTSIDE(_trNode, bSet) { \
	int nXFBits = 0; \
	_trNode.GetAttribute(STR_XF_BITS, nXFBits); \
	O_SET_BIT(nXFBits, DYNALAYOUT_THEME_MODIFIED_OUTSIDE, bSet); \
	_trNode.SetAttribute(STR_XF_BITS, nXFBits); \
}
///end GADGET_PREFERENCE_INDICATE_THEME_CHANGED_OUTSIDE

///Sophy 6/25/2010 ORG-23-S8 XY_INTERP_FOR_GADGET_TOOL_DLG
typedef struct {
	int	nPlotIndex;
	int ni1;
	int ni2;
	int nMethod;
	int nBoundary;
	double dSmoothFactor;
} InterpParams;

void	OpenInterpXYDlg(InterpParams& stParams);
///end XY_INTERP_FOR_GADGET_TOOL_DLG

///------ Folger 11/29/2010 QA81-15177 GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS
#define		GADGET_GUI_FIRST_SUBNODES_AS_TABS(_TR)	GETN_FIRST_SUBNODES_AS_TABS(_TR);_TR.SetAttribute(STR_PARENT_OF_SUBNODE_DISPLAY_AS_TAB_ATTRIB, "trGUI")
///------ End GETNBOX_SUPPORT_MOVE_FIRST_LEVEL_BRANCHES_INTO_TABS

///------ Folger 12/01/2010 ORG-1551-S5 SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK
class IntegrateMissingValueHelper
{
public:
	IntegrateMissingValueHelper(vector& vx, vector& vy, BOOL bNeedRestore);
	~IntegrateMissingValueHelper();
	
	int		GetSize();
	
private:
	vector*			m_pvx;
	vector*			m_pvy;
	BOOL			m_bNeedRestore;
	vector			m_vBackupX;
	vector			m_vBackupY;
};

struct IntegInfo
{
	int		nSize;
	vector	vx;
	vector	vy;
	vector	vIntgCurve;
};

class IntegToolHelper
{
public:
	///------ Folger 05/18/2011 ORG-2887-P2 QUICK_PEAKS_TOO_SLOW_ON_CELL_LINKED_DATA
	//IntegToolHelper(vector& vx, vector& vy, double& x1, double& x2);
	IntegToolHelper(vector& vx, vector& vy, double& x1, double& x2, vector* pvxPlot = NULL, vector* pvyPlot = NULL);
	///------ End QUICK_PEAKS_TOO_SLOW_ON_CELL_LINKED_DATA
	~IntegToolHelper();

	string	CreateArea(GraphLayer& gl, LPCSTR lpcszName);
	BOOL	UpdateAreaSettings(BOOL bShow = TRUE);
	
	/// Sen 08/25/2011 ORG-2298-P2 MAKE_BASELINE_TAB_WORK_CORRECTLY	
	//BOOL	Integ(IntegrationResult& pInteg, BOOL bNeedExtrapolate = FALSE, BOOL bLimitToRect = TRUE, int nAreaType = MATHEMATICAL_AREA, IntegInfo* pstInfo = NULL);
	BOOL	Integ(IntegrationResult& pInteg, BOOL bNeedExtrapolate = FALSE, BOOL bLimitToRect = TRUE, int nAreaType = MATHEMATICAL_AREA, IntegInfo* pstInfo = NULL, int	nBaselineRange = BASELINE_RANGE_WITHIN_ROI);
	/// End  MAKE_BASELINE_TAB_WORK_CORRECTLY
	BOOL	RemoveMissingValuesAndSort(vector& vX, vector& vY, DWORD dwSortOptions, vector& vxRef = NULL, vector& vyRef = NULL);
	/// Sen 08/25/2011 ORG-2298-P9 MAKE_FULL_RANGE_HATCH_AREA_CORRECT
	//void	InterploateRectBounds(vector& vX, vector& vY, double& dY1, double& dY2, BOOL bNeedExtrap, DataPlot& Plot);
	void	InterploateRectBounds(vector& vX, vector& vY, double& dY1, double& dY2, BOOL bNeedExtrap, DataPlot& Plot, vector* pvInterpolateX = NULL, vector* pvInterpolateY = NULL);
	/// End MAKE_FULL_RANGE_HATCH_AREA_CORRECT
	BOOL	UpdateIntegArea(DataPlot& Plot, BOOL bLimitToRect = TRUE, BOOL bNeedExtrap = FALSE, BOOL bShow = TRUE);

private:
	void Sort(vector& vX, vector& vY, DWORD dwSortOptions);
	
public:
	GraphObject	m_goIntegArea;
	
	vector      m_vbx;
	vector      m_vby;
	double		m_Area;
	vector 		m_vxEx;
	vector		m_vyEx;
	double		m_dxPeak;	///Sophy 2/24/2012 ORG-5151-S1 SHOW_FWHM_INSTEAD_OF_ROI_X_RANGE_ON_TOP
	double      m_s1; 
	double      m_s2;

private:
	double*		m_pX1;
	double*		m_pX2;
	vector*		m_pvX;
	vector*		m_pvY;

	///------ Folger 05/18/2011 ORG-2887-P2 QUICK_PEAKS_TOO_SLOW_ON_CELL_LINKED_DATA
	vector		m_vxPlot;
	vector		m_vyPlot;
	///------ End QUICK_PEAKS_TOO_SLOW_ON_CELL_LINKED_DATA
	
	///Philip 07/18/2012 ORG-6183 INTEG_GAGDET_INCORRECT_DRAW_WHEN_USE_BASELINEMODE_UED_AND_EPW
	//is running addtool_curve_integ ?
public:
	bool m_bIsCurveInteg;//only used for Integrate gadget !
	///end INTEG_GAGDET_INCORRECT_DRAW_WHEN_USE_BASELINEMODE_UED_AND_EPW
};
///------ End SUPPORT_PEAK_INTEGRATION_FOR_QUICK_PEAK

///------ Folger 03/18/2011 ORG-2479-S1 MAKE_QUICKFIT_FOLLOW_GENERAL_GADGETS
#define		GUI_TREE(_trGUI, _trRoot)		TreeNode	_trGUI = roi_get_gui_tree(_trRoot)
TreeNode	roi_get_gui_tree(TreeNode& tr);

bool	roi_is_event_from_preference_dlg(TreeNode& tr);
///------ End MAKE_QUICKFIT_FOLLOW_GENERAL_GADGETS

///------ Folger 03/18/2011 ORG-2486-P1 QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE
bool get_rect_ROI_init_x_range(const GraphLayer& gl, double& x0, double& x1);
///------ End QUICKFIT_BAD_INIT_ROI_POSITION_FOR_NONLINEAR_SCALE

///Sophy 4/9/2012 ORG-4611-P1 GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME
bool get_plot_source_format(const GraphLayer& gl, int nPlotIndex, ColFmtInfoPtr pxFmtInfo = NULL, ColFmtInfoPtr pyFmtInfo = NULL);
///end GADGET_TOOL_NEED_DATETIME_PICKER_CTRL_WHEN_SOURCE_IS_DATETIME

///------ Folger 03/25/2011 MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET
void	gadget_gui_apply_support(TreeNode& trGUI, PEVENT_GETN pfn, PAPPLY_FUNC pfnApply);
///------ End MAKE_QUICK_PEAKS_REFERENCE_SAME_AS_GENERAL_GADGET

bool	init_shape_position(TreeNode& trGUI, bool bCheckInitAttrib = true);	

///Jasmine 05/30/2011 ORG-1352 move from QuickFit to share with PickPeak
///------ Folger 01/12/09 QA81-14832 QUICKFIT_ROI_OBJECTS_SHOULD_BE_REMOVED_AFTER_OPEN_NLFIT_FROM_CONTEXT_MENU
class	QuickFitROIObjsCleanupHelper
{
public:
	QuickFitROIObjsCleanupHelper(LPCSTR lpcszLayer, LPCSTR lpcszObjName)
	{
		m_strObjName = lpcszObjName;
		m_strLayer = lpcszLayer;
		string		strScript;
		strScript.Format("layer -o %s { run.section(graph_controls, ShowObjects, %s %d); }", m_strLayer, m_strObjName, 0);
		LT_execute(strScript);
	}
	~QuickFitROIObjsCleanupHelper()
	{
		string		strScript;
		///Sophy 1/25/2010 LT_COMMAND_TO_REMOVE_ALL_LINKED_OBJECTS
		//strScript.Format("run.section(graph_controls, DestroyObjects, %s);", m_strObjName);
		///Sophy 3/3/2010 ROI_OBJS_FAIL_TO_CLEAN_UP_WHEN_LAYER_NOT_ACTIVE
		//strScript.Format("run.section(graph_controls, DelayDestroy, %s);", m_strObjName);
		strScript.Format(";layer -o %s { label -rc %s; }", m_strLayer, m_strObjName);
		///end ROI_OBJS_FAIL_TO_CLEAN_UP_WHEN_LAYER_NOT_ACTIVE
		///end LT_COMMAND_TO_REMOVE_ALL_LINKED_OBJECTS
		LT_execute(strScript);
	}
	
private:
	string	m_strObjName;
	string	m_strLayer;	///Sophy 3/3/2010 ROI_OBJS_FAIL_TO_CLEAN_UP_WHEN_LAYER_NOT_ACTIVE
};
///------ End QUICKFIT_ROI_OBJECTS_SHOULD_BE_REMOVED_AFTER_OPEN_NLFIT_FROM_CONTEXT_MENU

#endif // _GROBJ_TOOLS_H_
