/*------------------------------------------------------------------------------*
 * File Name:	GraphObjToolDlg.h												*
 * Creation: 	Sophy 3/9/2010													*
 * Purpose: OriginC Source H file												*
 * Copyright (c) OriginLab Corp.2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////

///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
#include <..\OriginLab\DialogEx.h>
#include <..\OriginLab\GridTableControl.h>

///Sophy 12/17/2010 ORG-1755-S4 ROI_GADGET_DLG_NEED_FLEXIBLE_GRID_LIST_CONTROL
#define	WM_USER_SHOW_HIDE_COL	(WM_USER + 432)
enum {
	MSG_TOGGLE_ONE	= 0x0001,
	MSG_TOGGLE_ALL,
};
enum {
	MENU_CMD_INVALID	= 0,
	MENU_CMD_COPY,
	///Sophy 2/15/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
	MENU_CMD_DATAPLOT_BEGIN	= 0x0900,
	MENU_CMD_DATAPLOT_ALL	= 0x09FE,
	MENU_CMD_DATAPLOT_END	= 0x09FF,
	///end CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
	MENU_CMD_LAST_ITEM,
};
class	GadgetTableContextMenu : public Menu
{
public:
	///Sophy 2/15/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
	//GadgetTableContextMenu()
	GadgetTableContextMenu(GraphObjCurveTool* pTool, BOOL bAllowCopy)
	///end CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
	{
		if ( bAllowCopy )
		{
			Add(_L("Copy"), MENU_CMD_COPY, MF_STRING);
			Add(NULL, 0, MF_SEPARATOR);
		}
		///Sophy 2/15/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
		m_pTool = pTool;
		if ( m_pTool != NULL )
		{
			m_pTool->UpdateTableMenu(*this);
		}
		///end CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
	}
	//bool	GetCommand(int& nCmd)
	//{
		//if ( m_nChoice > MENU_CMD_INVALID && nCmd < MENU_CMD_LAST_ITEM )
		//{
			//nCmd = m_nChoice;
			//return true;
		//}
		//return false;
	//}
protected:
	//void	OnMenuItem(UINT nPos) { m_nChoice = nPos; }
	
	///Sophy 2/15/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
	GraphObjCurveTool*	m_pTool;
	///end CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
//private:
	//int	m_nChoice;
};

///Jasmine 07/20/2011 ORG-3106-S3-2-7 GENERAL_COPY_GRID_VALUE
////this is in theme_utils.c, I dont want to include theme_utils here, so just declare the prototype and link to it.
//bool copy_to_clipboard(const string& str, bool bEmptyFirst = true, bool bUseOriginFormat = true);
///End GENERAL_COPY_GRID_VALUE

class	GadgetGridTable : public GridTableControl
{
public:
	//virtual
	void 	Init(int nID, WndContainer& dlg, LPCSTR lpcszDlgName)
	{
		GridTableControl::Init(nID, dlg, lpcszDlgName);
		SetEditable(flexEDNone);
		///Sophy 2/14/2011 ORG-2226-P1 PROPER_RESIZE_GRIDTABLELIST_COLUMNS_WHEN_RESIZE_GADGET_DLG
		SetExtendLastCol(false);
		///end PROPER_RESIZE_GRIDTABLELIST_COLUMNS_WHEN_RESIZE_GADGET_DLG
		m_nFixedRow = -1; //means no fixed row.
	}
	
	void	SetRowFixed(int nRow){ m_nFixedRow = nRow; }
	BOOL	BeforeSort()
	{
		if ( -1 == m_nFixedRow )
			return FALSE;
		m_vsRowValuesBuffer.SetSize(0);
		for( int iCol = 0; iCol < GetNumCols(); iCol++ )
			m_vsRowValuesBuffer.Add(GetCell(m_nFixedRow + GetRowOffset(), iCol));
		DeleteRow(m_nFixedRow + GetRowOffset());
		return TRUE;
	}
	BOOL	AfterSort()
	{
		if ( -1 == m_nFixedRow )
			return FALSE;
		SetCells(m_vsRowValuesBuffer, m_nFixedRow, false);
		return TRUE;
	}
	
	BOOL	UpdateDisplay(UINT wParam, UINT lParam)
	{
		switch(wParam)
		{
		case MSG_TOGGLE_ONE:
			{
				int nColIndex = (int)lParam;
				HideCol(nColIndex, !IsColHidden(nColIndex));
				return TRUE;
			}
			break;
		case MSG_TOGGLE_ALL:
			bool bHide = (0 == lParam) ? true : false;
			HideCol(-1, bHide);
			break;
		default:
			ASSERT(false);
			break;
		}
		return FALSE;
	}
	///Sophy 2/15/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
	//BOOL	ShowContextMenu(int nX, int nY)
	BOOL	ShowContextMenu(GraphObjCurveTool* pTool, int nX, int nY)
	///end CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
	{
		m_pTool = pTool;
		int nRow, nCol;
		GetMouseCell(nRow, nCol);
		///Sophy 12/21/2010 ORG-1755-S4 GRAY_AREA_HIT_TEST_WHEN_ALL_COLS_HIDDEN
		//if ( nRow <= 0 ) //on column header or blank space, so Show/Hide menu
		///Sophy 2/17/2011 ORG-1955-S5 SHOW_COLUMN_MENU_WHEN_CLICK_ON_FIRST_EMPTY_ROW_WHEN_HIDE_ALL_COLUMNS
		//if ( nRow == 0 && nCol >= 0 ) //on column header
		if ( nRow == 0 )
		///end SHOW_COLUMN_MENU_WHEN_CLICK_ON_FIRST_EMPTY_ROW_WHEN_HIDE_ALL_COLUMNS
		///end GRAY_AREA_HIT_TEST_WHEN_ALL_COLS_HIDDEN
		{
			vector<int> vnColIndex;
			vnColIndex.Data(0, GetNumCols() - 1, 1);
			vector<string> vsColHeader;
			m_strColHeader.GetTokens(vsColHeader, '|');
			vector<byte> vbColShow(vnColIndex.GetSize());
			for ( int ii = 0; ii < vnColIndex.GetSize(); ii++ )
			{
				vbColShow[ii] = !IsColHidden(vnColIndex[ii]);
			}
			vector<bool> vbItemsDisable;
			GetColMenuDisableItems(vnColIndex, vbItemsDisable);
			
			vsColHeader.Add(""); //separator
			vbColShow.Add(false);
			vbItemsDisable.Add(false);
			
			vsColHeader.Add(_L("Show All Columns"));
			vbColShow.Add(false);
			vbItemsDisable.Add(false);
			
			vsColHeader.Add(_L("Hide All Columns"));
			vbColShow.Add(false);
			vbItemsDisable.Add(false);
			
			CheckMenu cm(vbColShow, vsColHeader, vbItemsDisable);
			int nChoice = cm.DoTrackPopup(nX, nY, GetDlgSafeHwnd());
			if ( nChoice >= 0 )
			{
				if ( nChoice < vnColIndex.GetSize() )
				{
					HideCol(vnColIndex[nChoice], !IsColHidden(vnColIndex[nChoice])); //toggle show/hide
					PostDlgMessage(WM_USER_SHOW_HIDE_COL, MSG_TOGGLE_ONE, vnColIndex[nChoice]);
				}
				else
				{
					bool bHide = (nChoice == vsColHeader.GetSize() - 1) ? true : false;
					//for ( ii = 0; ii < vnColIndex.GetSize(); ii++ )
					//{
						//if ( !vbItemsDisable[ii] )
							//HideCol(vnColIndex[ii], bHide);
					//}
					HideCol(-1, bHide); //show hide all;
					PostDlgMessage(WM_USER_SHOW_HIDE_COL, MSG_TOGGLE_ALL, bHide ? 0 : 1);
				}
			}
		}
		else //show copy paste menu
		{
			int nCmd = MENU_CMD_INVALID;
			///Sophy 2/15/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
			//GadgetTableContextMenu cm();
			GadgetTableContextMenu cm(m_pTool, nRow > 0 && nCol >= 0 );
			///end CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
			cm.TrackPopupMenu(0, nX, nY, GetDlgSafeHwnd(), &nCmd);
			if ( nCmd > 0 )
			{
				///Sophy 2/15/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
				if ( nCmd >= MENU_CMD_DATAPLOT_BEGIN && nCmd <= MENU_CMD_DATAPLOT_END )
				{
					return m_pTool->OnStatsPlotsChange(nCmd);
				}
				///end CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
				switch(nCmd)
				{
				case MENU_CMD_COPY:
					{
						///Jasmine 07/20/2011 ORG-3106-S3-2-7 GENERAL_COPY_GRID_VALUE
						//string strVal = "";
						//if ( m_flx.ColSel == m_flx.Col && m_flx.RowSel == m_flx.Row )
						//{
							//strVal = GetCell(nRow, nCol);
						//}
						//else //multiple cells
						//{
							//int nRowBegin, nRowEnd, nColBegin, nColEnd;
							//nRowBegin = min(m_flx.RowSel, m_flx.Row);
							//nRowEnd = max(m_flx.RowSel, m_flx.Row);
							//nColBegin = min(m_flx.ColSel, m_flx.Col);
							//nColEnd = max(m_flx.ColSel, m_flx.Col);
							//for ( int iRow = nRowBegin; iRow <= nRowEnd; iRow++ )
							//{
								//for(int iCol = nColBegin; iCol <= nColEnd; iCol++ )
								//{
									//strVal += GetCell(iRow, iCol);
									//if ( iCol < nColEnd )
										//strVal += "\t";
								//}
								//if ( iRow < nRowEnd )
									//strVal += "\r\n";
							//}
						//}
						//copy_to_clipboard(strVal, true, false);
						CopySelectedCellsValue(nRow, nCol);
						///End GENERAL_COPY_GRID_VALUE
					}
					break;
				default:
					ASSERT(false);
					break;
				}
			}
		}
		return TRUE;
	}
private:
	int				m_nFixedRow;
	vector<string>	m_vsRowValuesBuffer;
	///Sophy 2/15/2011 ORG-1955-S3 CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
	GraphObjCurveTool*	m_pTool;
	///end CLUSTER_GADGET_NEED_NEW_CONTEXT_MENU_ON_STATS_REPORT_TABLE
};
///end ROI_GADGET_DLG_NEED_FLEXIBLE_GRID_LIST_CONTROL
enum {
	MSG_CREATE,
	MSG_CHECK_CREATE,
	MSG_DESTROY,
	MSG_START_GADGET,	//attach, when ActiveLayer change etc
	MSG_UPDATE_DATA,	//update data, when OnMove etc
	MSG_PLOT_CHANGED,
	MSG_THEME_CHANGED,
	MSG_UNDO_CHANGED,	//undo stack changed.
	MSG_PAGE_DEACTIVATE,	///Sophy 4/6/2011 ORG-2592-P1 GROBJTOOLS_EVENTS_HANDLING_WHEN_PAGE_DEACTIVATE
};

enum {
	TAB_INNER_POINTS = 0,
	TAB_OUTER_POINTS = 1,
};

enum {
	TOOL_CTRL_TYPE_ATTACHESMODE,
	TOOL_CTRL_TYPE_REALTIME,
};

#define	IDC_BTN_PREPERENCES	IDC_BUTTON1
#define	IDC_COPY_DATA				IDC_BUTTON1
#define	IDC_OUTPUT_RESULT	IDC_BUTTON2
///Sophy 12/14/2010 ORG-1704-S2 OPTION_FOR_SHOW_HIDE_GADGET_ATTACHED_BUTTONS
#define	IDC_GOTO_SRC_WORKSHEET		IDC_BUTTON3
#define	IDC_UNDO					IDC_BUTTON4
#define	IDC_DELETE_ROW				IDC_BUTTON5
#define	IDC_MASK					IDC_BUTTON6
#define	IDC_UNMASK					IDC_BUTTON7
#define	IDC_CLEAR_DATA				IDC_BUTTON8
#define	IDC_SET_DATA				IDC_BUTTON9
#define	IDC_DELETE_XY				IDC_BUTTON10
#define	IDC_NEW_VALUE_LABEL			IDC_REPORT_LABEL
#define	IDC_NEW_VALUE				IDC_EDIT_REPORT_SHEET //reuse the edit box
///end OPTION_FOR_SHOW_HIDE_GADGET_ATTACHED_BUTTONS
///Sophy 2/18/2011 ORG-2225-P1 ADD_EDIT_INNER_OUTER_SWITCH_BUTTON
#define	IDC_EDIT_INNER_OUTER		IDC_BUTTON11
///end ADD_EDIT_INNER_OUTER_SWITCH_BUTTON

///Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
typedef	int	(*	PFN_GADGET_MSG_HANDLER)	(int nMsg, DWORD dwParam = 0);
///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
///Sophy 4/6/2011 ORG-2589-P1 PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
enum {
	GADGETDLG_CTRL_MAKE_INVISIBLE = 0x0001,
};
///end PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ

///Sophy 12/23/2010 ORG-1841 NEW_GUI_FOR_CLUSTER_DATA_MANIPULATION_GADGET
//class	GadgetDlg : public ResizeDialog
class	GadgetDlg : public MultiPaneDlg
///end NEW_GUI_FOR_CLUSTER_DATA_MANIPULATION_GADGET
{
public:
	GadgetDlg();
	~GadgetDlg();
	///Sophy 4/6/2011 ORG-2589-P1 PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
	//BOOL	Create(HWND hWndParent = NULL);
	BOOL	Create(HWND hWndParent = NULL, BOOL bVisible = TRUE);
	BOOL	UpdateDlgCtrl(DWORD dwBits, int nOpt);
	///end PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
	virtual	BOOL	StartGadget(){ m_pTool = NULL; return FALSE; }
	virtual	BOOL	UpdateDlgData(){ return FALSE; }
	virtual	BOOL	UpdateSettings(){ return FALSE; }
	virtual	BOOL	ChangeData() { initDataMenu(); updateControls(); return TRUE; }
	virtual	BOOL	ChangeTheme() { initSettingsMenu(); return TRUE; }
	virtual	BOOL	UndoChange() { updateUndoSettings(); return TRUE; }
	///Sophy 4/6/2011 ORG-2592-P1 GROBJTOOLS_EVENTS_HANDLING_WHEN_PAGE_DEACTIVATE
	BOOL	OnPageDeactivate() { UpdateDlgCtrl(GADGETDLG_CTRL_MAKE_INVISIBLE, ROI_OP_SET); return TRUE; }
	///end GROBJTOOLS_EVENTS_HANDLING_WHEN_PAGE_DEACTIVATE
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_READY(OnReady)
	ON_SIZE(OnDlgResize)
	ON_RESTORESIZE(OnRestoreSize)
	ON_DESTROY(OnDestroy)
	ON_HELPINFO(OnHelp)
	ON_OK(OnOK)
	ON_CANCEL(OnCancel)
	///Sophy 4/6/2011 ORG-2589-P1 PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
	ON_IDLE(OnIdle)
	///end PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
	
	ON_TAB_SEL_CHANGE(IDC_BOTTOM_TAB, OnTabChange)
	///Sophy 12/17/2010 ORG-1755-S4 ROI_GADGET_DLG_NEED_FLEXIBLE_GRID_LIST_CONTROL
	//ON_GRID_BEFORE_MOUSE_DOWN(IDC_VSFLEXGRID_1, OnBeforeMouseDownTable)
	//ON_GRID_BEFORE_MOUSE_DOWN(IDC_VSFLEXGRID_2, OnBeforeMouseDownTable)
	ON_GRID_BEFORE_SORT(IDC_VSFLEXGRID_1, OnBeforeSort)
	ON_GRID_BEFORE_SORT(IDC_VSFLEXGRID_2, OnBeforeSort)
	ON_GRID_AFTER_SORT(IDC_VSFLEXGRID_1, OnAfterSort)
	ON_GRID_AFTER_SORT(IDC_VSFLEXGRID_2, OnAfterSort)
	ON_CONTEXTMENU(OnContext)
	///end ROI_GADGET_DLG_NEED_FLEXIBLE_GRID_LIST_CONTROL
	ON_CHANGE_LAYER(OnActiveLayerChange)
	
	ON_BN_CLICKED(IDC_BTN_ACTIVATE_REPORT, OnActivateReportClicked)
	ON_BN_CLICKED(IDC_BTN_PREPERENCES, OnPreferencesClicked)
	ON_BN_CLICKED(IDC_OUTPUT_RESULT, OnOutputResult)
	///Sophy 12/23/2010 ORG-1841 NEW_GUI_FOR_CLUSTER_DATA_MANIPULATION_GADGET
	ON_BN_CLICKED(IDC_SHOW_BOTTOM, OnShowBottomPane)
	///end NEW_GUI_FOR_CLUSTER_DATA_MANIPULATION_GADGET
	///Sophy 12/14/2010 ORG-1704-S8 OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
	ON_BN_CLICKED(IDC_GOTO_SRC_WORKSHEET, OnGotoSrcWorksheetClicked)
	///end OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
	ON_BN_CLICKED(IDC_DELETE_ROW, OnDeleteRowClicked)
	ON_BN_CLICKED(IDC_DELETE_XY, OnDeleteXYClicked)
	ON_BN_CLICKED(IDC_COPY_DATA, OnCopyDataClicked)
	ON_BN_CLICKED(IDC_MASK, OnMaskClicked)
	ON_BN_CLICKED(IDC_UNMASK, OnUnmaskClicked)
	ON_BN_CLICKED(IDC_CLEAR_DATA, OnClearDataClicked)
	ON_BN_CLICKED(IDC_SET_DATA, OnSetDataClicked)
	ON_BN_CLICKED(IDC_UNDO, OnUndoClicked)
	ON_BN_CLICKED(IDC_EDIT_INNER_OUTER, OnEditSwitch)	///Sophy 2/18/2011 ORG-2225-P1 ADD_EDIT_INNER_OUTER_SWITCH_BUTTON
	ON_EN_CHANGE(IDC_NEW_VALUE, OnValueChange)
	//menu
	ON_CMD_UI_UPDATE(ID_UNDO, OnCmdUIUpdate)
	///Sophy 1/6/2011 ORG-1934-P1 UPDATE_GADGET_CONTROL_ON_SELECT_LOCKED_PLOTS
	ON_CMD_UI_UPDATE(ID_DELETE_ROWS, OnCmdUIUpdate)
	ON_CMD_UI_UPDATE(ID_COPY_DATA, OnCmdUIUpdate)
	ON_CMD_UI_UPDATE(ID_COPY_DATA, OnCmdUIUpdate)
	ON_CMD_UI_UPDATE(ID_MASK_DATA, OnCmdUIUpdate)
	ON_CMD_UI_UPDATE(ID_UNMASK_DATA, OnCmdUIUpdate)
	ON_CMD_UI_UPDATE(ID_CLEAR_DATA, OnCmdUIUpdate)
	///end UPDATE_GADGET_CONTROL_ON_SELECT_LOCKED_PLOTS
	ON_MENU_CMD(ID_UNDO, OnUndo)
	ON_MENU_CMD(ID_DELETE_ROWS, OnDeleteRow)
	ON_MENU_CMD(ID_DELETE_XY, OnDeleteXY)
	ON_MENU_CMD(ID_COPY_DATA, OnCopyData)
	ON_MENU_CMD(ID_MASK_DATA, OnMask)
	ON_MENU_CMD(ID_UNMASK_DATA, OnUnmask)
	ON_MENU_CMD(ID_CLEAR_DATA, OnClearData)
	ON_MENU_CMD(ID_INNER_POINTS, OnInnerPoints)
	ON_MENU_CMD(ID_OUTER_POINTS, OnOuterPoints)
	ON_MENU_CMD_RANGE(GOT_DATAPLOT_BEGIN, GOT_DATAPLOT_END, OnChangeData)
	ON_MENU_CMD_RANGE(GOT_THEME_BEGIN, GOT_THEME_END, OnChangeTheme)
	
	ON_MENU_CMD(ID_CHANGE_SHAPE, OnChangeShape)
	ON_MENU_CMD(ID_SHOWHIDE_ATTACHES, OnShowHideAttaches)
	ON_MENU_CMD(ID_REALTIME_CALC, OnRealtime)
	ON_MENU_CMD(ID_EXPAND_FULL_RANGE, OnExpandFullRange)
	ON_MENU_CMD(ID_EXPAND_FULL_HORIZONTAL, OnExpandHorizontal)
	ON_MENU_CMD(ID_EXPAND_FULL_VERTICAL, OnExpandVertical)
	ON_MENU_CMD(ID_RESET_POSITION, OnResetPosition)
	ON_MENU_CMD(ID_SAVE_DEFAULT_THEME, OnSaveDefaultTheme)
	ON_MENU_CMD(ID_SAVE_THEME, OnSaveTheme)
	ON_MENU_CMD(ID_PREFERENCES, OnPreferences)
	//user message
	///Sophy 12/17/2010 ORG-1755-S4 ROI_GADGET_DLG_NEED_FLEXIBLE_GRID_LIST_CONTROL
	ON_USER_MSG(WM_USER_SHOW_HIDE_COL, OnShowHideCols)
	///end ROI_GADGET_DLG_NEED_FLEXIBLE_GRID_LIST_CONTROL

EVENTS_END

	///Sophy 1/5/2011 ORG-1841-S10 PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL
	virtual	PFN_GADGET_MSG_HANDLER	GetMsgHandler() { return NULL; }
	///end PROPER_PREPARE_UNDO_BLOCK_FOR_GROBJTOOL


	BOOL	OnInitDialog();
	BOOL	OnReady();
	BOOL	OnDlgResize(int nType, int cx, int cy);
	BOOL OnRestoreSize(ODWP dwSizeInfo);
	virtual	BOOL	OnDestroy();
	BOOL	OnHelp(int &nHelpID, int nIdCtrlFocus);
	BOOL	OnOK();
	BOOL	OnCancel();
	
	///Sophy 4/6/2011 ORG-2589-P1 PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
	BOOL	OnIdle();
	///end PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ
	
	BOOL	OnTabChange(Control ctrl);
	///Sophy 12/17/2010 ORG-1755-S4 ROI_GADGET_DLG_NEED_FLEXIBLE_GRID_LIST_CONTROL
	//BOOL	OnBeforeMouseDownTable(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel);
	BOOL	OnBeforeSort(Control ctrl, long lCol, short* pSort);
	BOOL	OnAfterSort(Control ctrl, long lCol, short* pSort);
	BOOL	OnContext(UINT nResID, int nX, int nY);
	///end ROI_GADGET_DLG_NEED_FLEXIBLE_GRID_LIST_CONTROL
	BOOL	OnActiveLayerChange();
	virtual	BOOL	OnActivateReportClicked(Control ctrl);
	BOOL	OnPreferencesClicked(Control ctrl);
	virtual	BOOL	OnEditData(Control ctrl){ return FALSE; }
	virtual	BOOL	OnOutputResult(Control ctrl){ return FALSE; }
	///Sophy 12/14/2010 ORG-1704-S8 OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
	virtual	BOOL	OnGotoSrcWorksheetClicked(Control ctrl){ return GotoSrcWorksheet(); }
	BOOL	OnDeleteRowClicked(Control ctrl);
	BOOL	OnDeleteXYClicked(Control ctrl);
	BOOL	OnCopyDataClicked(Control ctrl);
	BOOL	OnMaskClicked(Control ctrl);
	BOOL	OnUnmaskClicked(Control ctrl);
	BOOL	OnClearDataClicked(Control ctrl);
	BOOL	OnSetDataClicked(Control ctrl);
	BOOL	OnUndoClicked(Control ctrl){ return OnUndo(); }
	///Sophy 2/22/2011 ORG-2225-P1 ADD_EDIT_INNER_OUTER_SWITCH_BUTTON
	BOOL	OnEditSwitch(Control ctrl);
	///end ADD_EDIT_INNER_OUTER_SWITCH_BUTTON
	BOOL	OnValueChange(Control ctrl);
	///end OPTIONS_TO_CONTROL_CALCULATION_FOR_SPEEDUP_PURPOSE
	virtual	BOOL	OnContextMenu(Control ctrl){ return FALSE; }	///Sophy 12/15/2010 ORG-1755-S1 SUPPORT_SEL_DATA_IN_GADGET_DLG
	BOOL	OnResultSheetChange(Control ctrl);
	///Sophy 12/23/2010 ORG-1841 NEW_GUI_FOR_CLUSTER_DATA_MANIPULATION_GADGET
	virtual	BOOL	OnShowBottomPane(Control ctrl);
	BOOL	OnResize();
	
	BOOL	InitMenu();
	BOOL	OnCmdUIUpdate(CmdUI cmdUI);
	BOOL	OnUndo();
	BOOL	OnDeleteRow();
	BOOL	OnMask();
	BOOL	OnUnmask();
	BOOL	OnClearData();
	BOOL	OnDeleteXY();
	BOOL	OnCopyData();
	BOOL	OnInnerPoints();
	BOOL	OnOuterPoints();
	BOOL	OnChangeShape(){ return m_pTool->ChangeShape(); }
	BOOL	OnShowHideAttaches() { m_pTool->DoToolControl(TOOL_CTRL_TYPE_ATTACHESMODE, ROI_OP_TOGGLE); initSettingsMenu(); return TRUE;}
	BOOL	OnRealtime() { m_pTool->DoToolControl(TOOL_CTRL_TYPE_REALTIME, ROI_OP_TOGGLE); initSettingsMenu(); return TRUE;}
	BOOL	GotoSrcWorksheet() { return m_pTool->OnActivateSource(); }
	BOOL	OnExpandFullRange();
	BOOL	OnExpandHorizontal();
	BOOL	OnExpandVertical();
	BOOL	OnResetPosition();
	BOOL	OnSaveTheme(){ return OnChangeTheme(GOT_THEME_SAVE); }
	BOOL	OnSaveDefaultTheme() { return OnChangeTheme(GOT_THEME_SAVE_DEFAULT); }
	BOOL	OnPreferences();
	virtual	BOOL	OnChangeData(int nCmdID){ UpdateROIState(true); return m_pTool->DoDataCmd(nCmdID); }
	virtual	BOOL	OnChangeTheme(int nCmdID){ return m_pTool->DoThemeCmd(nCmdID); }
	///end NEW_GUI_FOR_CLUSTER_DATA_MANIPULATION_GADGET
	///Sophy 12/17/2010 ORG-1755-S4 ROI_GADGET_DLG_NEED_FLEXIBLE_GRID_LIST_CONTROL
	BOOL	OnShowHideCols(UINT wParam, UINT lParam);
	///end ROI_GADGET_DLG_NEED_FLEXIBLE_GRID_LIST_CONTROL


protected:
	///Sophy 12/23/2010 ORG-1841 NEW_GUI_FOR_CLUSTER_DATA_MANIPULATION_GADGET
	void	SetAllowResizing(BOOL bAllow);
	///end NEW_GUI_FOR_CLUSTER_DATA_MANIPULATION_GADGET

	BOOL	CheckInitTool();
	virtual	string	GetToolType(){ return "InValidType"; }
	virtual	BOOL	InitButtons();
	virtual	BOOL	ArrangeControls();
	virtual	BOOL	UpdateReportSheetName(LPCSTR lpcszSheetName){ return FALSE; }	///Sophy 6/25/2010 ORG-25-P5 UPDATE_REPORT_SHEET_NAME_FROM_GADGETTOOL_DLG
	void	UpdateROIState(bool bToROI = true);
	
private:
	void	initEditMenu();
	void	initDataMenu();
	void	initSettingsMenu();
	void	updateControls();	///Sophy 1/6/2011 ORG-1934-P1 UPDATE_GADGET_CONTROL_ON_SELECT_LOCKED_PLOTS
	void	updateUndoSettings();
	virtual	int		GetHelpID()			{ return IDD_GADGET_DLG; }

protected:
	string	m_strLastValue;
	Edit	m_edtNewValue;	///Sophy 3/4/2011 ORG-1782-P5 OC_EDIT_CONTROL_NEED_TO_PROVIDE_SIMPLE_CONTEXT_MENU
	TabControl	m_BottomTab;
	GadgetGridTable	m_TableOne;
	GadgetGridTable	m_TableTwo;
	GraphLayer	m_gl;
	string		m_strMainObjName;
	GraphObjCurveTool*	m_pTool;
	DWORD		m_dwState;
	DWORD		m_dwCtrl;	///Sophy 4/6/2011 ORG-2589-P1 PROPER_CHECK_SHOW_GADGET_DLG_ON_LOADING_OPJ

};


///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL

///Sophy 6/25/2010 ORG-23-S8 XY_INTERP_FOR_GADGET_TOOL_DLG
//this dialog will reuse the resource for quickfit findxy dialog
enum {
	OUTPUT_TO_SCRIPTWINDOW = 0,
	OUTPUT_TO_RESULTLOG,
	OUTPUT_TO_WORKSHEET,
};
#define	IDC_BTN_INTERP				IDC_BTN_FINDXY
#define	IDC_BTN_OUTPUT				IDC_BTN_FINDXY_OUTPUT
#define	IDC_OUTPUT_TO_SCRIPTWINDOW	IDC_FINDXY_OUTPUT_TO_SCRIPT_WINDOW
#define	IDC_OUTPUT_TO_RESULTLOG		IDC_FINDXY_OUTPUT_TO_RESULT_LOG
#define	IDC_OUTPUT_TO_WORKSHEET		IDC_FINDXY_OUTPUT_TO_WORKSHEET
#define	IDC_OUTPUT_WORKSHEET_NAME	IDC_FINDXY_WORKSHEET
#define	IDC_X_VALUES				IDC_FINDXY_X
#define	IDC_Y_VALUES				IDC_FINDXY_Y
#define	IDC_RANGE_HINTS				IDC_FINDXY_RANGE_HINT

class	InterpXYDlg : public ResizeDialog
{
public:
	InterpXYDlg();
	int DoModalEx(InterpParams& stParams, HWND hWndParent = NULL);
	
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_READY(OnReady)
	ON_IDLE(OnIdle)
	ON_DESTROY(OnDestroy)
	ON_BN_CLICKED(IDC_OUTPUT_TO_SCRIPTWINDOW, OnOutputChange)
	ON_BN_CLICKED(IDC_OUTPUT_TO_RESULTLOG, OnOutputChange)
	ON_BN_CLICKED(IDC_OUTPUT_TO_WORKSHEET, OnOutputChange)
	
	ON_BN_CLICKED(IDC_BTN_INTERP, OnClickInterp)
	ON_BN_CLICKED(IDC_BTN_OUTPUT, OnClickOutput);
	ON_BN_CLICKED(IDC_BTN_GO_TO_REPORT, OnClickGoToWorksheet)
	ON_EN_CHANGE(IDC_OUTPUT_WORKSHEET_NAME, OnOutputWorksheetChange)
EVENTS_END
	BOOL	OnInitDialog();
	BOOL	OnReady();
	BOOL	OnIdle();
	BOOL	OnDestroy();
	BOOL	OnOutputChange(Control ctrl);
	BOOL	OnClickInterp(Control ctrl);
	BOOL	OnClickOutput(Control ctrl);
	BOOL	OnClickGoToWorksheet(Control ctrl);
	BOOL	OnOutputWorksheetChange(Control ctrl);

protected:
	void	InitControls();
	void	InitRangeText();
	void	LoadSettings();//registry settings
	void	SaveSettings();
	void	UpdateButtonState();
	int		GetInput(vector& vInput);
	int		GetOutput(const vector& vInput, vector& vOutput);
	int		Calculate(vector& vInput, vector& vOutput);
	
private:
	int		m_nOutputTarget;
	Button	m_btnOutputScriptWindow;
	Button	m_btnOutputResultLog;
	Button	m_btnOutputWorksheet;
	Edit	m_edtWorksheetName;
	Edit	m_edtX;
	Edit	m_edtY;
	InterpParams	m_stParams;
	DataPlot		m_dpSrc;
	bool	m_bFocusReset;
};
///end XY_INTERP_FOR_GADGET_TOOL_DLG
