/*------------------------------------------------------------------------------*
 * File Name: GlobalEvents.c 													*
 * Creation: CPY 2/17/04														*
 * Purpose: OriginC Source C file for Origin Events								*
 * Copyright (c) Originlab Corp.	2005										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	DSC 3/14/05 v8.0204 QA70-7500 EVENT_ORGANIZER_DLG							*
 *	DSC ML 3/31/05 QA70-7500 GET_XF_FROM_ACCELERATOR							*
 *	DSC 6/16/05 ADD_SORT_XF_LIST_OPTIONS										*
 *	DSC 7/26/05 MORE_EVENT_ORGANIZER											*
 *	DSC 7/26/05 REMOVE_EO_SHOW_ADVANCED											*
 *	DSC 8/16/05 MORE_FILTERS_FOR_COMBO_BOX										*
 *	DSC 3/1/06 v8.0371 FF_FILTER_XF_BY_ARGUMENT_INFO							*
 *------------------------------------------------------------------------------*/
 
#include <origin.h>
//#include "FunctionGroup.h"
#include "XFunctionEx.h"
#include <GetNBox.h>
#include <MsgMap.h>
#include <Tools.h>
//#include "theme_utils.h"

#include <Profiler.h>

static	bool	execute_xf_by_id(int nId)
{
	string		strName;
	if(!get_xf_name(strName, nId) || strName.IsEmpty())
		return false;
	
	if(nId >= IDXF_USGCTXT_WKS_SEL_CHANGE && nId <= IDXF_USGCTXT_WKS_SEL_TRACKING) 
		XF_RunWksSelection(strName);
	else
		CallXFunction(strName, NULL, LTXF_EXECUTE, 0);
	
	return true;
}


#define HOUR_GLASS			waitCursor junk;
#define PROFILE_HRGLASS		HOUR_GLASS	//Profiler junk;//
///DSC 7/26/05 QA70-7500 MORE_EVENT_ORGANIZER
///DSC 8/16/05 MORE_FILTERS_FOR_COMBO_BOX
// static string _make_combo_list_of_xf(int nIDFX)

//#define XF_VARS_SET_COL_VALUES  0x0001 
//#define XF_VARS_WKS_SEL			0x0002
//#define XF_VARS_GRAPH_SEL		0x0004
static string _make_combo_list_of_xf(int nIDFX, int nIDFX1=0, int nIDFX2=0)
{
	vector<string> vsNames, vsFiles;
	
	///DSC 8/16/05 MORE_FILTERS_FOR_COMBO_BOX
	// int		nNumFiles = okutil_find_files(&vsNames, &vsFiles, SUPPORTFILE_XF, 0, &nIDFX, 1);
	DWORD		dwIDFXs[3];
	dwIDFXs[0] = nIDFX;
	int			nSize = 1;
	if(nIDFX1!=0)
	{
		dwIDFXs[1] = nIDFX1;
		nSize = 2;
	}
	if(nIDFX2!=0)
	{
		dwIDFXs[2] = nIDFX2;
		nSize = 3;
	}
	int		nNumFiles = okutil_find_files_from_map(&vsNames, &vsFiles, SUPPORTFILE_XF, 0, dwIDFXs, nSize);
	///end MORE_FILTERS_FOR_COMBO_BOX
	
	/// DSC 3/21/06 SORT_INSIDE_FIND_FILES
	// ///DSC 6/16/05 ADD_SORT_XF_LIST_OPTIONS
	// sort_composite_name_vs(vsNames);
	// ///end  ADD_SORT_XF_LIST_OPTIONS
	/// end SORT_INSIDE_FIND_FILES
	
	string strList;
	strList.SetTokens(vsNames, '|');
	
	string strCombo = STR_NONE + "|" + strList;
	return strCombo;
}
///end MORE_FILTERS_FOR_COMBO_BOX

///DSC 3/1/06 v8.0371 FF_FILTER_XF_BY_ARGUMENT_INFO
// static string _make_combo_list_of_xf_ex(DWORD * pvdwIDFXs, int nSize)
static string _make_combo_list_of_xf_ex(DWORD * pvdwIDFXs, int nSize,  DWORD dwArgFilter=0x0)
///end FF_FILTER_XF_BY_ARGUMENT_INFO
{
	vector<string> vsNames, vsFiles;
	///DSC 3/1/06 v8.0371 FF_FILTER_XF_BY_ARGUMENT_INFO
	// int		nNumFiles = okutil_find_files_from_map(&vsNames, &vsFiles, SUPPORTFILE_XF, 0, pvdwIDFXs, nSize);
	int		nNumFiles = okutil_find_files_from_map(&vsNames, &vsFiles, SUPPORTFILE_XF, 0, pvdwIDFXs, nSize, NULL, NULL, ORIGIN_PATH_PREFER_USER, dwArgFilter);
	///end FF_FILTER_XF_BY_ARGUMENT_INFO	
	///end MORE_FILTERS_FOR_COMBO_BOX
	
	/// DSC 3/21/06 SORT_INSIDE_FIND_FILES
	// ///DSC 6/16/05 ADD_SORT_XF_LIST_OPTIONS
	// sort_composite_name_vs(vsNames);
	// ///end  ADD_SORT_XF_LIST_OPTIONS
	/// end SORT_INSIDE_FIND_FILES
	
	string strList;
	strList.SetTokens(vsNames, '|');
	
	string strCombo = STR_NONE + "|" + strList;
	return strCombo;
}

static bool _is_selected_exists_and_is_in_combo_list(TreeNode& tn, string strCombo)
{
	tn.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	string strSelected = tn.strVal;
	StringArray saList;
	strCombo.GetTokens(saList, '|');
	
	for(int ii=0; ii<saList.GetSize(); ii++)
	{
		if(strSelected.CompareNoCase(saList[ii])==0)//found
			break;	
	}
	string strFullpath;
	if(ii<saList.GetSize())
	{
		// check file exists
		okutil_find_file_from_composite_name(&strFullpath, strSelected, SUPPORTFILE_XF);
		
		return strFullpath.IsFile()?true:false;;
	}
	//---- CPY 5/8/2006
	// not in list but maybe it is valid
	strFullpath.Empty();
	int nn = okutil_find_file_from_composite_name(&strFullpath, strSelected, SUPPORTFILE_XF);
	if(nn != ORIGIN_PATH_UNDEF && strFullpath.IsFile())
	{
		saList.Add(strSelected);
		strCombo.SetTokens(saList, '|');
		tn.SetAttribute(STR_COMBO_ATTRIB, strCombo);
		return true;
	}
	//----	
		
	return false;
}
static void _set_combo_and_selection(TreeNode tn, string strCombo)
{	
//	StringArray saList;
//	strCombo.GetTokens(saList, '|');
	
	//set combo
	//tn.SetAttribute(STR_COMBO_ATTRIB, strCombo);

	//check selected xf exists
	if(!_is_selected_exists_and_is_in_combo_list(tn,  strCombo))
		tn.strVal=STR_NONE; //tn.SetAttribute(STR_LABEL_ATTRIB, "");

}
///end MORE_EVENT_ORGANIZER

void EventsOrganizer()
{
	PROFILE_HRGLASS
	
	DWORD dwIDFX[4];///DSC 8/16/05 MORE_FILTERS_FOR_COMBO_BOX
	
	//NOTIFY_XF_FILE_CHANGE //CPY, temp solution, no on-idle check, right now only if saving from FO and XFDialog
	
	///DSC 7/26/05 REMOVE_EO_SHOW_ADVANCED
	//GETN_NAMED_TREE(tr, GUI);
	GETN_TREE(tr);
	GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG
	///end REMOVE_EO_SHOW_ADVANCED
	
	load_XF_events_handler_tree(tr);
	
	//-- fill combo with x-functions
	// find XF files then
	// string strCombo = "<none>|OnWksSelChange|file1|file2";
	// see cvt_str_to_predefined_type
	// build list by 1st getting a tree of XF
	/*
	vector<string> vsNames, vsFiles;
	
	int		nEvent = IDXF_USGCTXT_WKS_SEL_CHANGE;
	int		nNumFiles = okutil_find_files(&vsNames, &vsFiles, SUPPORTFILE_XF, 0, &nEvent, 1);
	/// end ML 3/30/2005	
	
	string strList;
	strList.SetTokens(vsNames, '|');
	
	///DSC 4/1/05 QA70-7500 v8.215 GET_XF_FROM_ACCELERATOR
	string strCombo = STR_NONE + "|" + strList;
	*/
	string strCombo = _make_combo_list_of_xf(IDXF_USGCTXT_WKS_SEL_CHANGE);
	//tr.OnWksSelectionChange.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	//if(!_is_selected_exists_and_is_in_combo_list(tr.OnWksSelectionChange.strVal,  strCombo))
	//	tr.OnWksSelectionChange.SetAttribute(STR_LABEL_ATTRIB, "");
	_set_combo_and_selection(tr.OnWksSelectionChange, strCombo);

	
	///DSC 8/16/05 MORE_FILTERS_FOR_COMBO_BOX
	// strCombo = _make_combo_list_of_xf(IDXF_USGCTXT_WKS_SEL);
	//"LT, Menu, AND, winType"
	dwIDFX[0] = IDXF_USGCTXT_LABTALK;
	dwIDFX[1] = IDXF_USGCTXT_MAIN_MENUS;
	dwIDFX[2] = IDXF_USGCTXT_LOGICAL_AND;
	dwIDFX[3] = IDXF_USGCTXT_WKS_SEL;
	
	///DSC 3/1/06 v8.0371 FF_FILTER_XF_BY_ARGUMENT_INFO
	// strCombo = _make_combo_list_of_xf_ex(dwIDFX, 4);
	strCombo = _make_combo_list_of_xf_ex(dwIDFX, 4 , XF_VARS_WKS_SEL);
	///end FF_FILTER_XF_BY_ARGUMENT_INFO
	
	//tr.wks.CtrlF1.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	//tr.wks.CtrlF2.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	//tr.wks.CtrlF3.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	//tr.wks.CtrlF7.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	//tr.wks.CtrlF8.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	//tr.wks.CtrlF9.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	_set_combo_and_selection(tr.wks.CtrlF1, strCombo);
	_set_combo_and_selection(tr.wks.CtrlF2, strCombo);
	_set_combo_and_selection(tr.wks.CtrlF3, strCombo);
	_set_combo_and_selection(tr.wks.CtrlF7, strCombo);
	_set_combo_and_selection(tr.wks.CtrlF8, strCombo);
	_set_combo_and_selection(tr.wks.CtrlF9, strCombo);
	///end GET_XF_FROM_ACCELERATOR
	
	/// ML 3/30/2005	
	//xf_filter_names(vsNames, vsFiles, IDXF_USGCTXT_WKS_SEL_TRACKING,  vsSubset);
	/*
	nEvent = IDXF_USGCTXT_WKS_SEL_TRACKING;
	nNumFiles = okutil_find_files(&vsNames, &vsFiles, SUPPORTFILE_XF, 0, &nEvent, 1);
	/// end ML 3/30/2005	
	strList.Empty();
	strCombo.Empty();
	/// ML 3/30/2005	
	//strList.SetTokens(vsSubset, '|');
	strList.SetTokens(vsNames, '|');
	/// end ML 3/30/2005	
	strCombo = STR_NONE + "|" + strList;
	*/
	strCombo = _make_combo_list_of_xf(IDXF_USGCTXT_WKS_SEL_TRACKING);
	//tr.OnWksSelectionTracking.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	//if(!_is_selected_exists_and_is_in_combo_list(tr.OnWksSelectionTracking.strVal,  strCombo))
	//	tr.OnWksSelectionTracking.strVal =  "";
	_set_combo_and_selection(tr.OnWksSelectionTracking, strCombo);

	///DSC 4/1/05 QA70-7500 v8.215 GET_XF_FROM_ACCELERATOR
	///IDXF_USGCTXT_GO
	/// ML 3/30/2005	
	//xf_filter_names(vsNames, vsFiles, IDXF_USGCTXT_WKS_SEL_TRACKING,  vsSubset);
	/*
	nEvent = IDXF_USGCTXT_GO;
	nNumFiles = okutil_find_files(&vsNames, &vsFiles, SUPPORTFILE_XF, 0, &nEvent, 1);
	/// end ML 3/30/2005	
	strList.Empty();
	strCombo.Empty();
	/// ML 3/30/2005	
	//strList.SetTokens(vsSubset, '|');
	strList.SetTokens(vsNames, '|');
	/// end ML 3/30/2005	
	strCombo = STR_NONE + "|" + strList;
	*/
	///DSC 8/16/05 MORE_FILTERS_FOR_COMBO_BOX
	// // strCombo = _make_combo_list_of_xf(IDXF_USGCTXT_GO);
	// strCombo = _make_combo_list_of_xf(IDXF_USGCTXT_GO, IDXF_USGCTXT_MAIN_MENUS, IDXF_USGCTXT_LABTALK);
	//"LT, Menu, AND, winType"
	dwIDFX[0] = IDXF_USGCTXT_LABTALK;
	dwIDFX[1] = IDXF_USGCTXT_MAIN_MENUS;
	dwIDFX[2] = IDXF_USGCTXT_LOGICAL_AND;
	dwIDFX[3] = IDXF_USGCTXT_GO;
	
	strCombo = _make_combo_list_of_xf_ex(dwIDFX, 4);
	
	///end MORE_FILTERS_FOR_COMBO_BOX
	//tr.graph.CtrlF1.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	//tr.graph.CtrlF2.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	//tr.graph.CtrlF3.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	//tr.graph.CtrlF7.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	//tr.graph.CtrlF8.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	//tr.graph.CtrlF9.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	_set_combo_and_selection(tr.graph.CtrlF1, strCombo);
	_set_combo_and_selection(tr.graph.CtrlF2, strCombo);
	_set_combo_and_selection(tr.graph.CtrlF3, strCombo);
	_set_combo_and_selection(tr.graph.CtrlF7, strCombo);
	_set_combo_and_selection(tr.graph.CtrlF8, strCombo);
	_set_combo_and_selection(tr.graph.CtrlF9, strCombo);
	///end GET_XF_FROM_ACCELERATOR
	
	
	///DSC 7/25/05 MORE_EVENT_ORGANIZER Matrix
	
	///DSC 8/16/05 MORE_FILTERS_FOR_COMBO_BOX
	// strCombo = _make_combo_list_of_xf(IDXF_USGCTXT_WINDOW_MATRIX);
	dwIDFX[0] = IDXF_USGCTXT_LABTALK;
	dwIDFX[1] = IDXF_USGCTXT_MAIN_MENUS;
	dwIDFX[2] = IDXF_USGCTXT_LOGICAL_AND;
	dwIDFX[3] = IDXF_USGCTXT_WINDOW_MATRIX;
	strCombo = _make_combo_list_of_xf_ex(dwIDFX, 4);
	///end MORE_FILTERS_FOR_COMBO_BOX
	
	_set_combo_and_selection(tr.matrix.CtrlF1, strCombo);
	_set_combo_and_selection(tr.matrix.CtrlF2, strCombo);
	_set_combo_and_selection(tr.matrix.CtrlF3, strCombo);
	_set_combo_and_selection(tr.matrix.CtrlF7, strCombo);
	_set_combo_and_selection(tr.matrix.CtrlF8, strCombo);
	_set_combo_and_selection(tr.matrix.CtrlF9, strCombo);
	///end MORE_EVENT_ORGANIZER
	
				/*
				//-- get user selections from theme
				string strHandlerName = get_reg_value_wks_sel_change_XF(STR_EVENT_XF, IDXF_USGCTXT_WKS_SEL_CHANGE);//, IDXF_USGCTXT_WKS_SEL_CHANGE);
				
				if(strHandlerName.IsEmpty())
					strHandlerName = STR_NONE;
				tr.OnWksSelectionChange.strVal = strHandlerName;
			
				strHandlerName = get_reg_value_wks_sel_change_XF(STR_EVENT_XF, IDXF_USGCTXT_WKS_SEL_TRACKING);//, IDXF_USGCTXT_WKS_SEL_TRACKING);
				
				if(strHandlerName.IsEmpty())
					strHandlerName = STR_NONE;	
				tr.OnWksSelectionTracking.strVal = strHandlerName;
				*/
	
	if(GetNBox(tr, "Event Organizer", "Set X-functions for global events"))
	{
		save_XF_events_handler_tree(tr);
	}
}

BOOL DoXFAccel(OriginObject &oo, int wParam, int lParam)
{
	//-- check if graph or wks is active
	int				nIDEvent = 0;
	Worksheet		wks = Project.ActiveLayer();
	GraphLayer		grl = Project.ActiveLayer();
	MatrixLayer		ml = Project.ActiveLayer(); ///DSC 7/26/05 MORE_EVENT_ORGANIZER
	
	
	//-- 
	if (wks)
	{
		switch(wParam)
		{
		case 0://Ctrl-F1
			nIDEvent = IDEO_EVENTORG_WKSHOTKEY1;
			break;
		case 1:
			nIDEvent = IDEO_EVENTORG_WKSHOTKEY2;
			break;
		case 2:
			nIDEvent = IDEO_EVENTORG_WKSHOTKEY3;
			break;
		case 6://Ctrl-F7
			nIDEvent = IDEO_EVENTORG_WKSHOTKEY4;
			break;
		case 7:
			nIDEvent = IDEO_EVENTORG_WKSHOTKEY5;
			break;
		case 8:
			nIDEvent = IDEO_EVENTORG_WKSHOTKEY6;
			break;
		default:
			return FALSE;
		}
		
	}
	else if (grl)
	{
		//nIDEvent =IDEO_EVENTORG_GRHOTKEY1;
		switch(wParam)
		{
		case 0://Ctrl-F1
			nIDEvent = IDEO_EVENTORG_GRHOTKEY1;
			break;
		case 1:
			nIDEvent = IDEO_EVENTORG_GRHOTKEY2;
			break;
		case 2:
			nIDEvent = IDEO_EVENTORG_GRHOTKEY3;
			break;
		case 6://Ctrl-F7
			nIDEvent = IDEO_EVENTORG_GRHOTKEY4;
			break;
		case 7:
			nIDEvent = IDEO_EVENTORG_GRHOTKEY5;
			break;
		case 8:
			nIDEvent = IDEO_EVENTORG_GRHOTKEY6;
			break;
		default:
			return FALSE;
		}
	}
	else if (ml)
	{
		switch(wParam)
		{
		case 0://Ctrl-F1
			nIDEvent = IDEO_EVENTORG_MATHOTKEY1;
			break;
		case 1:
			nIDEvent = IDEO_EVENTORG_MATHOTKEY2;
			break;
		case 2:
			nIDEvent = IDEO_EVENTORG_MATHOTKEY3;
			break;
		case 6://Ctrl-F7
			nIDEvent = IDEO_EVENTORG_MATHOTKEY4;
			break;
		case 7:
			nIDEvent = IDEO_EVENTORG_MATHOTKEY5;
			break;
		case 8:
			nIDEvent = IDEO_EVENTORG_MATHOTKEY6;
			break;
		default:
			return FALSE;
		}
	}
	
	//-- call XF
	execute_xf_by_id(nIDEvent);
	return TRUE;	
}
///end GET_XF_FROM_ACCELERATOR

	
void XF_RunWksSelection(LPCSTR lpcszXFCompositeName)
{
	/// YuI 11/09/05 QA70-8279 REPORT_TREE_AND_REPORT_DATA_XVARIABLES
	/*
	string strXFfile;
	string strCat;
	if(ORIGIN_PATH_UNDEF == okutil_find_file_from_composite_name(&strXFfile, lpcszXFCompositeName, SUPPORTFILE_XF))
	{
		printf("X-Function %s not found\n", lpcszXFCompositeName);
		return;
	}
	Tree trXF;
	XFunction xf;
	if(!xf.Load(trXF, strXFfile))
	{
		printf("failed to load X-Function %s\n", lpcszXFCompositeName);
		return;
	}
	int nIn, nOut, nInOut;
	// XFunctionOrganizer xfo;

	// if(!xfo.CountVariables(trXF, nIn, nOut, nInOut))
	if( !xf_count_variables(trXF, nIn, nOut, nInOut) )	
	{
		printf("only support a single variable to handle wks selection\n", lpcszXFCompositeName);
		return;
	}
		
	DataRange dr;
	if( EXIST_WKS == Project.GetSelection(dr) )
	{
		if(nOut)
		{
			//CPY 12/11/05 wait Yuri to change this
			//xf.Evaluate(NULL, &dr, false);
		}
		else
			xf.Evaluate(&dr, NULL, false);
	}
	*/
	ASSERT(FALSE);
	// invocation of XFunction from OriginC is not designed yet
	// I comment this code out since as it is written - it will not work
	/// end REPORT_TREE_AND_REPORT_DATA_XVARIABLES
}

/// YuI 04/22/05 QA70-6857 OBJECT_CONNECTION_IMPLEMENTATION
static BOOL add_cursor_to_data_reader_point(int nShape, int nColor)
{
	DataReaderTool drTool;
	drTool = Project.GetTool(OTT_DATA_READER);
	if( drTool )
	{
		DataPlot dp;
		int nIndex;
		if( !drTool.GetDataPoint(dp, nIndex) )
			return FALSE;
		
		GraphLayer gl;
		dp.GetParent(gl);
		if( !gl )
			return FALSE;

		PolylineGraphObject grCursor;
		grCursor = (PolylineGraphObject) gl.CreateGraphObject(GROT_CURSOR);
	
		double dX;
		double dY;
		if( !dp.GetDataPoint(nIndex, &dX, &dY) )
			return FALSE;
		vector vX;
		vector vY;
		vX.Add(dX);
		vY.Add(dY);
		grCursor.SetPoints(vX, vY);
		/// YuI 11/27/06 QA70-9156 MORE_OPTIONS_TO_CONNECTING_OBJECTS
		//	grCursor.ConnectTo(dp, nIndex, -1, FALSE, TRUE);
		grCursor.ConnectTo(dp, nIndex, -1, FALSE, OCR_SITE1 | OCR_SITE2);
		/// end MORE_OPTIONS_TO_CONNECTING_OBJECTS
		TreeNode tr = grCursor.GetFormat(FPB_ALL, FOB_ALL, true, true);
		TreeNode trSymbol = tr.Root.Symbol;
		if( !trSymbol )
			return FALSE;
			
		
		trSymbol.Size.nVal = 12;
		trSymbol.Shape.nVal = nShape;
		trSymbol.EdgeColor.nVal = nColor;
		trSymbol.Interior.nVal = 5;
		grCursor.ApplyFormat(tr, true, true);
		Project.ResetTools();
		return TRUE;
	}
	
	return FALSE;
}
static BOOL	add_annotation_to_data_reader_point(LPCSTR lpcszText, BOOL bVisible, BOOL bRigid)
{
	// need to add annotation
	DataReaderTool drTool;
	drTool = Project.GetTool(OTT_DATA_READER);
	if( drTool )
	{
		DataPlot dp;
		int nIndex;
		if( !drTool.GetDataPoint(dp, nIndex) )
			return FALSE;
		GraphLayer gl;
		dp.GetParent(gl);
		if( !gl )
			return FALSE;
		
		GraphObject grAnnotation = gl.CreateGraphObject(GROT_TEXT);
		if( !grAnnotation )
			return FALSE;
		double dX;
		double dY;
		if( !dp.GetDataPoint(nIndex, &dX, &dY) )
			return FALSE;
		
		grAnnotation.Text = lpcszText;
		grAnnotation.X = dX + grAnnotation.DX / 2;
		grAnnotation.Y = dY + grAnnotation.DY / 2;
		/// YuI 11/27/06 QA70-9156 MORE_OPTIONS_TO_CONNECTING_OBJECTS
		//	grAnnotation.ConnectTo(dp, nIndex, -1, bVisible, bRigid);
		grAnnotation.ConnectTo(dp, nIndex, -1, bVisible, bRigid ? (OCR_SITE1 | OCR_SITE2) : 0);
		/// end MORE_OPTIONS_TO_CONNECTING_OBJECTS
		Project.ResetTools();
		return TRUE;
	}
	
	return FALSE;
}

#define	DEFAULT_DATAPLOT_ANNOTATION	_L("Annotation")
BOOL	OnDataReaderKeyDown(int nChar)
{
	switch( nChar )
	{
	case 'a':
	case 'A':
		return add_annotation_to_data_reader_point(DEFAULT_DATAPLOT_ANNOTATION, TRUE, TRUE);
		
	case 'b':
	case 'B':
		return add_annotation_to_data_reader_point(DEFAULT_DATAPLOT_ANNOTATION, FALSE, TRUE);
		
	case 'c':
	case 'C':
		return add_cursor_to_data_reader_point(2, 3);
	}
	return TRUE;
}
BOOL	OnDataReaderToolEvent(OriginObject &oo, int wParam, int lParam)
{
	switch( wParam )
	{
	case WM_KEYDOWN:
		{
			return OnDataReaderKeyDown(lParam);
		}
	}
	return FALSE;
}
/// end OBJECT_CONNECTION_IMPLEMENTATION




