/*------------------------------------------------------------------------------*
 * File Name: GetPtsDlg.c														*
 * Creation: CPY 2/5/2008														*
 * Purpose: GraphGetPts GUI help to allow Done button on graph					*
 * Copyright (c) OriginLab Corp.2008											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Sim 03-13-2008 FIX_SHOW_X_Y_POS												*
 * Sim 03-14-2008 IMPROVE_GET_POINTS_DLG										*
 *	Hong 03/26/08 v8/0832b PA_PEAKS_DEL_REQUIRE_FOLLOWING_DATA_SUPPORT			*
 *	Hong 03/26/08 QA80-11323 v8.0832b PA_PEAKS_ADD_DONE_DIALOG_WHEN_MODIFY		*
 *	YuI 04/02/08 OPTION_TO_AUTOSIZE_GETPOINTSDIALOG								*
 *	CPY 4/5/08 ADD_TITLE_TO_SMALL_GRAPH_DIALOG									*
 *	Hong 04/05/08 v8.0838 FIX_GET_PTS_DLG_FAIL_SPECIFY_DLG_TITLE				*
 *	Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG				*
 *	Jasmine 02/25/09 MOVE_DOONE_BUTTON_TO_MOST_LEFT_TO_SHOW_IN_SMALL_WINDOW		*
 *	Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
 *	Sophy 8/17/2009 QA80-14087-P3 NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
 *	Folger 08/25/09 QA80-14087-P10 NEED_TO_DISABLE_ORIGIN_GUI_WHEN_GET_POINTS_DIALOG_OPEN
 *	Folger 11/10/2010 ORG-27 NEW_DIGITIZER_GADGET								*
 *	Kit 12/02/2010 ORG-1532-S3 ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg	*
 *	Kit 01/30/2011 ORG-2155-P2 WHEN_THERE_IS_NO_PTS_SEL_DISABLE_FIT_BTN			*
 *	Jasmine 03/14/11 ORG-2434-S1 HIDE_HINTS_TO_SAVE_PLACE						*
 *	Folger 03/16/2011 ORG-2434-S2 CNTRL_ENTER_TO_DONE_GET_POINTS_DLG			*
 *	Folger 03/21/2011 ORG-2434-P1 GETPTSDLG_FAILED_TO_USE_KEYBOARD_AFTER_CLICK_HIDE_HINTS_BUTTON
 *	Folger 03/22/2011 ORG-2499 GET_POINTS_DLG_FOR_MULTIPLE_PEAKS_FIT_SUPPORT_HIDE_HINT
 *	Jasmine 05/06/2011 ORG-2781-S1 OFFSET_GETPTS_DLG_IN_PAGE					*
 *	Jasmine 05/06/2011 ORG-2781-S2 KEEP_HIDE_HIDE_STATE							*
 *------------------------------------------------------------------------------*/
#include <Origin.h>
#include "DialogEx.h" 

#define STR_LT_VAR_DONE "DoneGetPts"   

class	UserGetPts;		///------ Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN

///------ Folger 03/22/2011 ORG-2434-S2 CNTRL_ENTER_TO_DONE_GET_POINTS_DLG
#define		ID_GETPTSDLG_MSG_ON_FINISH		0x1000
///------ End CNTRL_ENTER_TO_DONE_GET_POINTS_DLG

#define STR_HINT_HIDE_SETTING 				"HideHintSetting"		///Jasmine 05/06/2011 ORG-2781-S2 KEEP_HIDE_HIDE_STATE

class GraphGetPtsDlg : public ResizeDialog
{
public:
	GraphGetPtsDlg() : ResizeDialog( IDD_GRAPH_GETPTS, "oDlg8" )
	{
		/// YuI 04/02/08 OPTION_TO_AUTOSIZE_GETPOINTSDIALOG
		m_nMaxLength = -1; // to indicate no need to resize
		/// end OPTION_TO_AUTOSIZE_GETPOINTSDIALOG
		
		m_bDeleteOnDestroy = false;	///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
		m_pGetPts = NULL;			///------ Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
	}
	//m_bDeleteOnDestroy = true in DoModal
	virtual int  Create(HWND hParent = NULL)
	{
		m_bDeleteOnDestroy = true;	///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
		
		InitMsgMap();
		int nRet = ResizeDialog::Create(hParent);
		///------ Folger 11/25/2010 ORG-27 NEW_DIGITIZER_GADGET
		m_hwndParent = hParent;
		///------ End NEW_DIGITIZER_GADGET		
		return nRet;
	}
	
	/// YuI 04/02/08 OPTION_TO_AUTOSIZE_GETPOINTSDIALOG
	BOOL IsAutoSize()
	{
		return m_nMaxLength >= 0? true:false;
	}
	
	void SetAutoSize(BOOL bOn = TRUE)
	{
		m_nMaxLength = bOn? 0:-1;
	}
	/// end OPTION_TO_AUTOSIZE_GETPOINTSDIALOG	
	
	void ShowMsg(LPCSTR lpcsz)
	{
		m_staticHintLabel.Text = lpcsz;
		/// CPY 04/02/08 OPTION_TO_AUTOSIZE_GETPOINTSDIALOG
		int nLen = lstrlen(lpcsz);
		///Jasmine 03/14/11 ORG-2434-S1 HIDE_HINTS_TO_SAVE_PLACE
		//if( IsAutoSize() && nLen > 25)
		if( IsAutoSize() && nLen > 25 && m_staticHintLabel.Visible)
		///End HIDE_HINTS_TO_SAVE_PLACE
		{	
			///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
			//autosize if static text is not height enough
			int nHeight = m_staticHintLabel.Measure( lpcsz, &m_nMaxLength );
			RECT rr;
			GetClientRect(m_staticHintLabel, rr);
			///End OPTIMIZE_PICKED_POINT
			
			if(nLen > m_nMaxLength) // will only grow in size
				m_nMaxLength = nLen;
			///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
			else if(RECT_HEIGHT(rr) < nHeight)
				;//resize
			///End OPTIMIZE_PICKED_POINT
			///-----Kit 12/02/2010 ORG-1532-S3 ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg
			//else
			else if( !isHintTextWinTooLarge( lpcsz ) )
			///-----End ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg
				return;
			
			///------ Folger 11/10/2010 ORG-27 NEW_DIGITIZER_GADGET
			//ResizeControlWidth(m_staticHintLabel, 10, false);
			ResizeHintText(lpcsz);
			///------ End NEW_DIGITIZER_GADGET
			
			///Jasmine 02/25/09 MOVE_DOONE_BUTTON_TO_MOST_LEFT_TO_SHOW_IN_SMALL_WINDOW
			//uint nButtonIDs[] = {IDC_STATIC_NEXTPTS, IDC_DONE, 0};
			///-----Kit 12/02/2010 ORG-1532-S3 ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg
			//uint nButtonIDs[] = {IDC_DONE, IDC_STATIC_NEXTPTS, 0};
			//ArrangeControlsLeftRight(nButtonIDs, 0, 0);
			////ResizeDlgToRightOfControl(IDC_DONE, true, true);
			/////------ Folger 11/24/2010 ORG-27 NEW_DIGITIZER_GADGET
			////ResizeDlgToRightOfControl(IDC_STATIC_NEXTPTS, true, true);
			//ResizeDlgToRightOfControl(IDC_STATIC_NEXTPTS, true, true, m_hwndParent);
			/////------ End NEW_DIGITIZER_GADGET
			ArrangeControls();
			///-----End ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg
			///End MOVE_DOONE_BUTTON_TO_MOST_LEFT_TO_SHOW_IN_SMALL_WINDOW
		}
		/// end OPTION_TO_AUTOSIZE_GETPOINTSDIALOG
	}
	
	///------ Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
	void	SetUserGetPtsPointer(UserGetPts* pGetPts)
	{
		m_pGetPts = pGetPts;
	}
	///------ End ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
	
	///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	void SetTxtColor(COLORREF crColor)
	{
		if(!m_colorText)
		{
			///Jasmine 05/06/2011 ORG-2781-S2 KEEP_HIDE_HIDE_STATE
			bool bShow = m_staticHintLabel.Visible; 
			///End KEEP_HIDE_HIDE_STATE
			m_colorText.CreateControl(m_staticHintLabel.GetSafeHwnd());		
			m_staticHintLabel = GetItem(IDC_STATIC_NEXTPTS);
			///Jasmine 05/06/2011 ORG-2781-S2 KEEP_HIDE_HIDE_STATE
			m_staticHintLabel.Visible = bShow; 
			///End KEEP_HIDE_HIDE_STATE
		}
		m_colorText.SetTxtColor(crColor);
	}
	///End OPTIMIZE_PICKED_POINT
	
	///Jasmine 05/06/2011 ORG-2781-S2 KEEP_HIDE_HIDE_STATE
	void ResizeOnStart()
	{		
		bool bHide = LoadSetting( STR_HINT_HIDE_SETTING, 0, GetRegistryDialogName() );
		if(bHide)
		{
			ArrangeControls();
			OnHideHints( GetItem(IDC_HIDE_HINTS_BTN) );
		}
	}
	///End KEEP_HIDE_HIDE_STATE
	
protected:

EVENTS_BEGIN
	ON_INIT( OnInitDialog )
	ON_DESTROY(OnDestroy)
	ON_BN_CLICKED(IDC_DONE, OnDone)
	///Jasmine 03/14/11 ORG-2434-S1 HIDE_HINTS_TO_SAVE_PLACE
	ON_BN_CLICKED(IDC_HIDE_HINTS_BTN, OnHideHints)	
	ON_SYSCOMMAND(OnSystemCommand)
	ON_GETMINMAXINFO(OnMinMaxInfo)
	//ON_GETMINMAXINFO(OnMinMaxInfo)
	///End HIDE_HINTS_TO_SAVE_PLACE
	ON_SIZE(OnDlgResize)	
	ON_READY(OnReady)	///Jasmine 05/06/2011 ORG-2781-S1 OFFSET_GETPTS_DLG_IN_PAGE
	///------ Folger 03/22/2011 ORG-2434-S2 CNTRL_ENTER_TO_DONE_GET_POINTS_DLG
	ON_USER_MSG(ID_GETPTSDLG_MSG_ON_FINISH, OnFinish)
	///------ End CNTRL_ENTER_TO_DONE_GET_POINTS_DLG
EVENTS_END
	BOOL OnInitDialog()
	{
		ResizeDialog::OnInitDialog();
		m_staticHintLabel = GetItem(IDC_STATIC_NEXTPTS);
		///Jasmine 03/14/11 ORG-2434-S1 HIDE_HINTS_TO_SAVE_PLACE
		Control btnHide = GetItem(IDC_HIDE_HINTS_BTN);
		btnHide.Visible = true;
		///End HIDE_HINTS_TO_SAVE_PLACE
		return TRUE;
	}
	virtual BOOL OnDestroy(void)
	{
		///Jasmine 05/06/2011 ORG-2781-S2 KEEP_HIDE_HIDE_STATE
		Control btnHide = GetItem(IDC_HIDE_HINTS_BTN);
		bool bHide = btnHide.Text.CompareNoCase(">") == 0;
		SaveSetting( STR_HINT_HIDE_SETTING, bHide, GetRegistryDialogName() );
		///End KEEP_HIDE_HIDE_STATE
		
		///------ Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
		if ( m_pGetPts )
			m_pGetPts->ResetDlgPointer();
		///------ End ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
		
		ResizeDialog::OnDestroy();
		
		///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
		if(m_bDeleteOnDestroy)
			delete this;
		///End RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
#ifdef	_DEBUG_
		out_str("GraphGetPtsDlg::Destroy");
#endif		
		return true;
	}
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		return TRUE;
	}
	///Jasmine 05/06/2011 ORG-2781-S1 OFFSET_GETPTS_DLG_IN_PAGE
	virtual BOOL OnReady()
	{				
		RECT rDlg;
		rDlg.top 	= 20;//offset
		rDlg.left 	= 0;
		rDlg.right 	= 100;//temp, dialog will resize later
		rDlg.bottom = 100;
		MoveWindow(&rDlg);
		
		return TRUE;
	}
	///End OFFSET_GETPTS_DLG_IN_PAGE
	/// Hong 03/26/08 QA80-11323 v8.0832b PA_PEAKS_ADD_DONE_DIALOG_WHEN_MODIFY
	//BOOL OnDone(Control ctrl)
	virtual BOOL OnDone(Control ctrl)
	/// end PA_PEAKS_ADD_DONE_DIALOG_WHEN_MODIFY
	{
		LT_execute(STR_LT_VAR_DONE "= 1");
		return true;
	}

	///------ Folger 03/22/2011 ORG-2434-S2 CNTRL_ENTER_TO_DONE_GET_POINTS_DLG
	BOOL	OnFinish(WPARAM wParam, LPARAM lParam)
	{
		int		nBtnID = FinishButtonID();
		if ( !GetItem(nBtnID).Enable )
			return FALSE;

		return SendMessage(WM_COMMAND, MAKELONG(nBtnID, BN_CLICKED));
	}
	///------ End CNTRL_ENTER_TO_DONE_GET_POINTS_DLG
	
	///Jasmine 03/14/11 ORG-2434-S1 HIDE_HINTS_TO_SAVE_PLACE
	BOOL OnHideHints(Control ctrl)
	{
		bool bHide = ctrl.Text.CompareNoCase("<") == 0;
		ctrl.Text = bHide? ">" : "<";
		m_staticHintLabel.Visible = !bHide;		
		ShowMsg(m_staticHintLabel.Text);//resize hints control
		///------ Folger 03/22/2011 ORG-2499 GET_POINTS_DLG_FOR_MULTIPLE_PEAKS_FIT_SUPPORT_HIDE_HINT
		//ResizeDlgToRightOfControl(bHide? IDC_HIDE_HINTS_BTN : IDC_STATIC_NEXTPTS, true, true, m_hwndParent);
		ResizeDlgToRightOfControl(bHide? IDC_HIDE_HINTS_BTN : IDC_STATIC_NEXTPTS, ResizeDlgBottonWhenHideHint(), true, m_hwndParent);
		///------ End GET_POINTS_DLG_FOR_MULTIPLE_PEAKS_FIT_SUPPORT_HIDE_HINT
		
		///------ Folger 03/21/2011 ORG-2434-P1 GETPTSDLG_FAILED_TO_USE_KEYBOARD_AFTER_CLICK_HIDE_HINTS_BUTTON
		//return TRUE;  
		return RestoreFocusOnGraph();
		///------ End GETPTSDLG_FAILED_TO_USE_KEYBOARD_AFTER_CLICK_HIDE_HINTS_BUTTON
	}
	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//int	GetTotalHeight(bool bMin = false)
	int	GetMinClientTrackHeight()
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	{
		RECT rr;
		GetClientRect(GetItem(IDC_HIDE_HINTS_BTN), rr);
		int nHeight = rr.bottom;
		
		if(m_staticHintLabel.Visible)
		{
			RECT rrHints;
			GetClientRect(GetItem(IDC_STATIC_NEXTPTS), rrHints); 
		 	nHeight = max(rrHints.bottom, nHeight);
		}
		
		/// Kenny 12/11/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
		//return nHeight + GetWindowTitleHeight() + GetControlGap();
		return nHeight + GetControlGap();
		/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	}
	/// Kenny 12/09/2011 ORG-2303-P1 PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	//int	GetTotalWidth(bool bMin = false)
	int	GetMinClientTrackWidth()
	/// End PLOTSETUP_RESIZE_MINMAX_TRACKING_LIMITS
	{
		int 	id = (m_staticHintLabel.Visible? IDC_STATIC_NEXTPTS : IDC_HIDE_HINTS_BTN);		
		RECT 	rr;
		GetClientRect(GetItem(id), rr);
		return rr.right + GetControlGap()*2;
	}
	///End HIDE_HINTS_TO_SAVE_PLACE

	///-----Kit 12/02/2010 ORG-1532-S3 ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg
	bool isHintTextWinTooLarge( LPCTSTR lpcszMsg )
	{	  
		RECT rctHint;
		m_staticHintLabel.GetClientRect( &rctHint );
		int nWidth = RECT_WIDTH( rctHint );
		
		int nHeight = m_staticHintLabel.Measure( lpcszMsg, &nWidth );
		
		if( nHeight < RECT_HEIGHT( rctHint ) || nWidth*1.1 < RECT_WIDTH( rctHint ) )
			return true;
		return false;
	}
	///-----End ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg

	///------ Folger 11/10/2010 ORG-27 NEW_DIGITIZER_GADGET
	void	ResizeHintText(LPCSTR lpcsz)
	{
		string			str = lpcsz;
		vector<string>	vs;
		int				nTokens = str.GetTokens(vs, '\n');
		if ( nTokens > 1 )
		{
			int		nMaxLen = 0;
			int		jj = 0;
			for ( int ii=0; ii<nTokens; ++ii )
			{
				int		nn = vs[ii].GetLength();
				if ( nMaxLen < nn )
				{
					nMaxLen = nn;
					jj = ii;
				}
			}
			m_staticHintLabel.Text = vs[jj];
			ResizeControlWidth(m_staticHintLabel, 10, false);
			
			RECT	rr;
			GetClientRect(m_staticHintLabel, rr);
			
			int		nWidth = RECT_WIDTH(rr);
			int		nHeight = m_staticHintLabel.Measure(lpcsz, &nWidth);				
			
			rr.right = rr.left + nWidth * 1.1;
			rr.bottom = rr.top + nHeight;
			MoveControl(m_staticHintLabel, rr);
			
			m_staticHintLabel.Text = lpcsz;
		}
		else
		{
			ResizeControlWidth(m_staticHintLabel, 10, false);
		}
	}
	///------ End NEW_DIGITIZER_GADGET

	///-----Kit 12/02/2010 ORG-1532-S3 ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg
	virtual int ArrangeControls()
	{
		///Jasmine 03/14/11 ORG-2434-S1 HIDE_HINTS_TO_SAVE_PLACE
		//uint nButtonIDs[] = {IDC_DONE, IDC_STATIC_NEXTPTS, 0};
		//int nLowestYPos = ArrangeControlsLeftRight(nButtonIDs, 0, 0);
		uint nButtonIDs[] = {IDC_DONE, IDC_HIDE_HINTS_BTN, IDC_STATIC_NEXTPTS, 0};
		int nLowestYPos = ArrangeControlsLeftRight(nButtonIDs, 0, 0, 0);
		///End HIDE_HINTS_TO_SAVE_PLACE
		ResizeDlgToRightOfControl(IDC_STATIC_NEXTPTS, true, true, m_hwndParent);

		return nLowestYPos;
	}

	UserGetPts *GetGetPtsPointer()
	{
		return m_pGetPts;
	}
	///-----End ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg

	///------ Folger 03/21/2011 ORG-2434-P1 GETPTSDLG_FAILED_TO_USE_KEYBOARD_AFTER_CLICK_HIDE_HINTS_BUTTON
	BOOL	RestoreFocusOnGraph()
	{
		GraphPage	pg = Project.Pages();
		Window		win = pg.GetWindow(-1);
		return SetFocus(win.GetSafeHwnd()) ? TRUE : FALSE;
	}
	///------ End GETPTSDLG_FAILED_TO_USE_KEYBOARD_AFTER_CLICK_HIDE_HINTS_BUTTON

	///------ Folger 03/22/2011 ORG-2434-S2 CNTRL_ENTER_TO_DONE_GET_POINTS_DLG
	virtual	int		FinishButtonID()
	{
		return IDC_DONE;
	}
	///------ End CNTRL_ENTER_TO_DONE_GET_POINTS_DLG

	///------ Folger 03/22/2011 ORG-2499 GET_POINTS_DLG_FOR_MULTIPLE_PEAKS_FIT_SUPPORT_HIDE_HINT
	virtual	BOOL	ResizeDlgBottonWhenHideHint()
	{
		return TRUE;
	}
	///------ End GET_POINTS_DLG_FOR_MULTIPLE_PEAKS_FIT_SUPPORT_HIDE_HINT

	///Jasmine 05/06/2011 ORG-2781-S2 KEEP_HIDE_HIDE_STATE
	virtual string  GetRegistryDialogName()
	{
		return "GraphGetPtsDlg:"+Text;
	}
	///End KEEP_HIDE_HIDE_STATE
	
///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
protected:
	bool 	m_bDeleteOnDestroy;
///End RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
	HWND	m_hwndParent;	///-----Kit 12/02/2010 ORG-1532-S3 ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg
private:
	Control	m_staticHintLabel;
	/// YuI 04/02/08 OPTION_TO_AUTOSIZE_GETPOINTSDIALOG
	int	m_nMaxLength;
	/// end OPTION_TO_AUTOSIZE_GETPOINTSDIALOG
	
	UserGetPts* m_pGetPts;		///------ Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN

	///-----Kit 12/02/2010 ORG-1532-S3 ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg
	/////------ Folger 11/24/2010 ORG-27 NEW_DIGITIZER_GADGET
	//HWND		m_hwndParent;
	/////------ End NEW_DIGITIZER_GADGET
	
	ColorText 	m_colorText;		///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
};

/*
void ggg(int nClose = 0)
{
	_close_dlg();
	if(nClose)
		return;
	
	GraphPage gp = Project.Pages();
	if(!gp)
		return;
	
	Window ww = gp.GetWindow();
	if(!ww)
		return;
	
	HWND hWndParent = ww.GetSafeHwnd();//GetWindow();
	hWndParent = GetWindow(hWndParent, GW_CHILD); 	/// TD 02-06-2008 QA80-11056 CHILD_DIALOG_TO_MDI_CHILD_FRAME
	s_pGetPtsDlg = new GraphGetPtsDlg;
	s_pGetPtsDlg->Create(hWndParent);
	/// TD 02-06-2008 QA80-11056 CHILD_DIALOG_TO_MDI_CHILD_FRAME
	//HWND hWndDlg = NULL;
	//Window wndDlg = *s_pGetPtsDlg;
	//hWndDlg  = wndDlg.GetSafeHwnd();
	//SetWindowPos(hWndDlg, HWND_TOP, 0,0,0,0, SWP_NOSIZE|SWP_NOMOVE);
	/// end CHILD_DIALOG_TO_MDI_CHILD_FRAME
	s_pGetPtsDlg->ShowDialog(false);
}
*/


#define GETPTS_UNKNOWN 100
class UserGetPts : public GetGraphPoints
{
public:
	///Sophy 8/17/2009 QA80-14087-P3 NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
	//UserGetPts(int nCursor, LPCSTR lpcszTitle, LPCSTR lpcszInitMsg = NULL, LPCSTR lpcszContinueMsg = NULL, bool bAutoResize = true)
	///------ Folger 11/10/2010 ORG-27 NEW_DIGITIZER_GADGET
	//UserGetPts(int nCursor, LPCSTR lpcszTitle, LPCSTR lpcszInitMsg = NULL, LPCSTR lpcszContinueMsg = NULL, bool bAutoResize = true, bool bShowDlg = true)
	UserGetPts(int nCursor, LPCSTR lpcszTitle, LPCSTR lpcszInitMsg = NULL, LPCSTR lpcszContinueMsg = NULL, bool bAutoResize = true, bool bShowDlg = true, FUNC_GET_POINTS_CALLBACK pfnDisplay = NULL, FUNC_GET_POINTS_CALLBACK pfnNewPoint = NULL, int nAdditioanlPointsToDisplay = 0)
	///------ End NEW_DIGITIZER_GADGET
	///end NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
	{
		m_pGetPtsDlg = NULL;
		/// Hong 04/05/08 v8.0838 FIX_GET_PTS_DLG_FAIL_SPECIFY_DLG_TITLE
		//openDlg(bAutoResize);
		/// end FIX_GET_PTS_DLG_FAIL_SPECIFY_DLG_TITLE
		m_strInitMsg = lpcszInitMsg;
		m_strContinueFmt = lpcszContinueMsg;
		//----- CPY 4/5/08 ADD_TITLE_TO_SMALL_GRAPH_DIALOG
		m_strTitle = lpcszTitle;
		if(m_strTitle.IsEmpty())
			/// Hong 04/05/08 v8.0838 FIX_GET_PTS_DLG_FAIL_SPECIFY_DLG_TITLE
			//m_strTitle = "Get Points";
			m_strTitle = _L("Get Points");
			/// end FIX_GET_PTS_DLG_FAIL_SPECIFY_DLG_TITLE
		//-----
		/// Hong 04/05/08 v8.0838 FIX_GET_PTS_DLG_FAIL_SPECIFY_DLG_TITLE
		///Sophy 8/17/2009 QA80-14087-P3 NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
		//openDlg(bAutoResize);
		if ( bShowDlg ) //since the "Done" button is senseless when select only one point, allow not to it.
		{
			openDlg(bAutoResize);
		}
		///end NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
		/// end FIX_GET_PTS_DLG_FAIL_SPECIFY_DLG_TITLE	
		SetCursor(nCursor);
		
		///------ Folger 08/25/09 QA80-14087-P10 NEED_TO_DISABLE_ORIGIN_GUI_WHEN_GET_POINTS_DIALOG_OPEN
		okutil_enable_origin_gui(FALSE);
		///------ End NEED_TO_DISABLE_ORIGIN_GUI_WHEN_GET_POINTS_DIALOG_OPEN

		///------ Folger 11/10/2010 ORG-27 NEW_DIGITIZER_GADGET
		m_pfnDisplay = pfnDisplay;
		m_pfnNewPoint = pfnNewPoint;
		m_nAdditioanlPointsToDisplay = nAdditioanlPointsToDisplay;
		m_nFailurePoints = 0;				///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
		///------ End NEW_DIGITIZER_GADGET
	}
	~UserGetPts()
	{
		///------ Folger 08/25/09 QA80-14087-P10 NEED_TO_DISABLE_ORIGIN_GUI_WHEN_GET_POINTS_DIALOG_OPEN
		okutil_enable_origin_gui(TRUE);
		///------ End NEED_TO_DISABLE_ORIGIN_GUI_WHEN_GET_POINTS_DIALOG_OPEN
		///------ Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
		if ( m_pGetPtsDlg )
			m_pGetPtsDlg->SetUserGetPtsPointer(NULL);
		///------ End ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
		closeDlg();
	}
	virtual void OnStart()
	{
		///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
		if(m_pfnDisplay && m_pGetPtsDlg)
			m_pGetPtsDlg->SetTxtColor(COLOR_BLACK);
		///End OPTIMIZE_PICKED_POINT
		
		if(m_strInitMsg.IsEmpty())
			m_strInitMsg = "Move to the 1st point and double-click to select it";
		m_strMsg = m_strInitMsg;
		OutMsg(m_strMsg);	
	}
	virtual void OnDisplay(string& str, int nPoint)
	{
		///------ Folger 03/16/2011 ORG-2434-S2 CNTRL_ENTER_TO_DONE_GET_POINTS_DLG
		if ( !IsUpdateDisplay(str) )
			return;
		///------ End CNTRL_ENTER_TO_DONE_GET_POINTS_DLG

		GetGraphPoints::OnDisplay(str, nPoint);
		int nTotalPts = GetTotalPoints();
		if(GETPTS_UNKNOWN == nTotalPts)
			nTotalPts = -1; // temp

		///------ Folger 11/15/2010 ORG-27 NEW_DIGITIZER_GADGET
		nPoint += m_nAdditioanlPointsToDisplay;
		nPoint -= m_nFailurePoints;				///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
		///------ End NEW_DIGITIZER_GADGET
		
		///---Sim 03-13-2008 FIX_SHOW_X_Y_POS
		/*
		string strFmt = m_strContinueFmt;
		if (strFmt.IsEmpty())
			strFmt = "%d/%d: Double-click to get this point\r\n%s";		
		m_strMsg.Format(strFmt, nPoint+1, nTotalPts, str); // use LT indexing for display
		outMsg(m_strMsg);
		str = m_strMsg;
		*/
		///---Sim 03-14-2008 IMPROVE_GET_POINTS_DLG
		//outMsg(m_strContinueFmt);
		string strFmt;
		strFmt.Format(m_strContinueFmt, nPoint);
		///------ Folger 11/10/2010 ORG-27 NEW_DIGITIZER_GADGET
		if ( m_pfnDisplay )
		{
			double	x, y;
			GetCursorPos(x, y);
			string	str;
			///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
			//m_pfnDisplay(x, y, &str);
			bool bRet = m_pfnDisplay(x, y, &str);
			if(m_pGetPtsDlg)
				m_pGetPtsDlg->SetTxtColor(bRet? COLOR_BLACK : COLOR_RED);
			///End OPTIMIZE_PICKED_POINT
			strFmt += "\n" + str;
		}
		///------ End NEW_DIGITIZER_GADGET
		OutMsg(strFmt);
		///---END IMPROVE_GET_POINTS_DLG
		///---END FIX_SHOW_X_Y_POS
	}
	
	///------ Folger 11/11/2010 ORG-27 NEW_DIGITIZER_GADGET
	virtual void OnNewPoint(int nPoint)
	{
		if ( m_pfnNewPoint )
		{
			double	x, y;
			GetCursorPos(x, y);
			if( !m_pfnNewPoint(x, y) )
				m_nFailurePoints++;				///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
			SetCursorPos(x, y);
		}
	}
	///------ End NEW_DIGITIZER_GADGET

	///------ Folger 03/22/2011 ORG-2434-S2 CNTRL_ENTER_TO_DONE_GET_POINTS_DLG
	virtual void OnFinish()
	{
		if ( m_pGetPtsDlg )
		{
			m_pGetPtsDlg->PostMessage(ID_GETPTSDLG_MSG_ON_FINISH);
		}
	}
	///------ End CNTRL_ENTER_TO_DONE_GET_POINTS_DLG
	
	///------ Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
	void	ResetDlgPointer()
	{
		m_pGetPtsDlg = NULL;
	}
	///------ End ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN

	///-----Kit 12/02/2010 ORG-1532-S3 ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg
	virtual GraphGetPtsDlg *CreateGetPtsDlg()
	{
		GraphGetPtsDlg *pGetPtsDlg = new GraphGetPtsDlg;
		ASSERT( pGetPtsDlg != NULL );
		return pGetPtsDlg;
	}
	
	void	SetSelButton( GetPtsDlgSelBtnID selBtnID )
	{
		m_selBtnID = selBtnID;
	}
	
	int GetSelButton()
	{
		return m_selBtnID;
	}
	///-----End ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg

protected:
	///------ Folger 03/16/2011 ORG-2434-S2 CNTRL_ENTER_TO_DONE_GET_POINTS_DLG
	BOOL	IsUpdateDisplay(LPCSTR lpcsz)
	{
		if ( m_strOldDisplayStr.Compare(lpcsz) == 0 )
			return FALSE;

		m_strOldDisplayStr = lpcsz;
		return TRUE;
	}

	void	OutMsg(LPCSTR lpcsz)
	{
		if(m_pGetPtsDlg)
			m_pGetPtsDlg->ShowMsg(lpcsz);
	}
	///------ End CNTRL_ENTER_TO_DONE_GET_POINTS_DLG

private:
	void closeDlg()
	{
		if(m_pGetPtsDlg)
		{
			Window winDlg = m_pGetPtsDlg->GetWindow();
			if(winDlg)
				winDlg.SendMessage(WM_CLOSE);
		
			//delete m_pGetPtsDlg;	///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
		}
		LT_execute("del -v "  STR_LT_VAR_DONE);
		
		m_pGetPtsDlg = NULL;
	}
	bool openDlg(bool bAutoResize)
	{
		GraphPage gp = Project.Pages();
		if(!gp)
			return false;
		
		//Window ww = gp.GetWindow();
		Window ww = gp.GetWindow(-1); /// TD 02-06-2008 QA80-11056 CHILD_DIALOG_TO_MDI_CHILD_FRAME (Get the drawing window)
		if(!ww)
			return false;
		
		HWND hWndParent = ww.GetSafeHwnd();//GetWindow();
		//hWndParent = GetWindow(hWndParent, GW_CHILD); 	/// TD 02-06-2008 QA80-11056 CHILD_DIALOG_TO_MDI_CHILD_FRAME
		///-----Kit 12/02/2010 ORG-1532-S3 ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg
		//m_pGetPtsDlg = new GraphGetPtsDlg;
		m_pGetPtsDlg = CreateGetPtsDlg();
		///-----End ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg
		m_pGetPtsDlg->SetUserGetPtsPointer(this);		///------ Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
		m_pGetPtsDlg->Create(hWndParent);
		
		m_pGetPtsDlg->SetAutoSize(bAutoResize);/// YuI 04/02/08 OPTION_TO_AUTOSIZE_GETPOINTSDIALOG
		//---- CPY 4/5/08 ADD_TITLE_TO_SMALL_GRAPH_DIALOG
		m_pGetPtsDlg->Text = m_strTitle;
		//----
		
		m_pGetPtsDlg->ResizeOnStart();		///Jasmine 05/06/2011 ORG-2781-S2 KEEP_HIDE_HIDE_STATE
		
		m_pGetPtsDlg->ShowDialog(false);
		LT_execute(STR_LT_VAR_DONE  "= 0");
		return true;
	}

///-----Kit 12/02/2010 ORG-1532-S3 ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg
protected:
	GraphGetPtsDlg* m_pGetPtsDlg;
	string m_strInitMsg;
	string m_strContinueFmt;
///-----

private:
	///-----Kit 12/02/2010 ORG-1532-S3 ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg
	//GraphGetPtsDlg* m_pGetPtsDlg;
	//string m_strInitMsg;
	//string m_strContinueFmt;
	///-----

	string m_strMsg;
	string m_strTitle; //CPY 4/5/08 ADD_TITLE_TO_SMALL_GRAPH_DIALOG

	///------ Folger 11/10/2010 ORG-27 NEW_DIGITIZER_GADGET
	FUNC_GET_POINTS_CALLBACK		m_pfnDisplay;
	FUNC_GET_POINTS_CALLBACK		m_pfnNewPoint;
	int								m_nAdditioanlPointsToDisplay;
	int								m_nFailurePoints;				///Jasmine 03/09/11 ORG-2286 OPTIMIZE_PICKED_POINT
	///------ End NEW_DIGITIZER_GADGET

	GetPtsDlgSelBtnID		m_selBtnID;		///-----Kit 12/02/2010 ORG-1532-S3 ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg

	///------ Folger 03/16/2011 ORG-2434-S2 CNTRL_ENTER_TO_DONE_GET_POINTS_DLG
	string					m_strOldDisplayStr;
	///------ End CNTRL_ENTER_TO_DONE_GET_POINTS_DLG
};

/// Hong 03/26/08 v8/0832b PA_PEAKS_DEL_REQUIRE_FOLLOWING_DATA_SUPPORT
//int GetPtsDlg(vector& vx, vector& vy, int nPts, int nCursorType, LPCSTR lpcszMsg1, LPCSTR lpcszMsg2)
///Sophy 8/17/2009 QA80-14087-P3 NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
//int GetPtsDlg(vector& vx, vector& vy, int nPts, int nCursorType, LPCSTR lpcszMsg1, LPCSTR lpcszMsg2, LPCSTR lpcszTitle = NULL, int* pnPlotIndex = NULL)
///------ Folger 11/10/2010 ORG-27 NEW_DIGITIZER_GADGET
//int GetPtsDlg(vector& vx, vector& vy, int nPts, int nCursorType, LPCSTR lpcszMsg1, LPCSTR lpcszMsg2, LPCSTR lpcszTitle = NULL, int* pnPlotIndex = NULL, vector<int>& vnDatapointIndices = NULL, bool bShowDlg = true, vector<int>& vnDataplotIndices = NULL)
int GetPtsDlg(vector& vx, vector& vy, int nPts, int nCursorType, LPCSTR lpcszMsg1, LPCSTR lpcszMsg2, LPCSTR lpcszTitle = NULL, int* pnPlotIndex = NULL, vector<int>& vnDatapointIndices = NULL, bool bShowDlg = true, vector<int>& vnDataplotIndices = NULL, FUNC_GET_POINTS_CALLBACK pfnDisplay = NULL, FUNC_GET_POINTS_CALLBACK pfnNewPoint = NULL)
///------ End NEW_DIGITIZER_GADGET
///end NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
/// end PA_PEAKS_DEL_REQUIRE_FOLLOWING_DATA_SUPPORT
{
	GraphLayer gl = Project.ActiveLayer();
	if(!gl)
		return -1;
	
	if(NULL == lpcszMsg2)
		lpcszMsg2 = lpcszMsg1;
	
	///Sophy 8/17/2009 QA80-14087-P3 NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
	//UserGetPts sp(nCursorType, lpcszTitle, lpcszMsg1, lpcszMsg2);
	///------ Folger 11/10/2010 ORG-27 NEW_DIGITIZER_GADGET
	//UserGetPts sp(nCursorType, lpcszTitle, lpcszMsg1, lpcszMsg2, true, bShowDlg);
	int		nAdditioanlPointsToDisplay = vx.GetSize();
	UserGetPts sp(nCursorType, lpcszTitle, lpcszMsg1, lpcszMsg2, true, bShowDlg, pfnDisplay, pfnNewPoint, nAdditioanlPointsToDisplay);
	///------ End NEW_DIGITIZER_GADGET
	///end NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
	/// Hong 03/26/08 v8/0832b PA_PEAKS_DEL_REQUIRE_FOLLOWING_DATA_SUPPORT
	//sp.SetFollowData(false, 0);
	bool	bFollowData = false;
	int 	nPlotIndex = -1;
	if ( pnPlotIndex != NULL )
	{
		bFollowData	= true;
		nPlotIndex	= *pnPlotIndex;
	}
	sp.SetFollowData(bFollowData, nPlotIndex);
	/// end PA_PEAKS_DEL_REQUIRE_FOLLOWING_DATA_SUPPORT
	if(nPts < 0)
		nPts = GETPTS_UNKNOWN;
	
	//if(sp.GetPoints(GETPTS_UNKNOWN, gl, STR_LT_VAR_DONE) > 0)
	if(sp.GetPoints(nPts, gl, STR_LT_VAR_DONE) > 0) /// Hong 02/27/08 v8.0813 IMPROVE_GET_POINT_OF_SCALE_OFFSET
		///Sophy 8/17/2009 QA80-14087-P3 NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
		//return sp.GetData(vx, vy);
		return sp.GetData(vx, vy, vnDatapointIndices, vnDataplotIndices);
		///end NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
	
	///------ Folger 11/24/2010 ORG-27 NEW_DIGITIZER_GADGET
	//return 0;
	return -2;		/// means Cancel
	///------ End NEW_DIGITIZER_GADGET
}

/// Hong 03/26/08 QA80-11323 v8.0832b PA_PEAKS_ADD_DONE_DIALOG_WHEN_MODIFY
class GraphDoneDlg : public GraphGetPtsDlg
{
	GraphDoneDlg() : GraphGetPtsDlg()
	{}
	
	~GraphDoneDlg()
	{
		post_getn_dialog_message(WM_USER_ON_GRAPH_OBJECT_CHANGE, WPARAM_DONE_DLG_COSE);
#ifdef	_DEBUG_
		out_str("GraphDoneDlg::Destroy");
#endif
	}
	
EVENTS_BEGIN
	ON_BN_CLICKED(IDC_DONE, OnDone)
EVENTS_END
	BOOL OnDone(Control ctrl)
	{	
	#ifdef	_DEBUG_
		out_str("OnDone");
	#endif		
		SendMessage(WM_CLOSE);	
		//delete this;	///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
		return true;
	}
	
	///Jasmine 05/06/2011 ORG-2781-S2 KEEP_HIDE_HIDE_STATE
	virtual string  GetRegistryDialogName()
	{
		return "GraphDoneDlg:"+Text;
	}
	///End KEEP_HIDE_HIDE_STATE
};

/**$
	This function create a done window as child window of the active GraphPage,
	it done nothing but only post a message WM_USER_ON_GRAPH_OBJECT_CHANGE to the GetN dialog 
	which attached to the page when close
*/
///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
//bool GetDoneDlg(LPCSTR lpcstrMsg, BOOL bAutoResize, LPCSTR lpcszTitle = NULL)
bool GetDoneDlg(ODWP& dwDlg, LPCSTR lpcstrMsg, BOOL bAutoResize, LPCSTR lpcszTitle = NULL)
///End RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
{
	GraphPage gp = Project.Pages();
	if ( !gp )
		return false;
	/// Do NOT know what -1 mean here, copy from UserGetPts::openDlg, keep code above
	Window ww = gp.GetWindow(-1); /// TD 02-06-2008 QA80-11056 CHILD_DIALOG_TO_MDI_CHILD_FRAME (Get the drawing window)
	if ( !ww )
		return false;		
	
	HWND hWndParent = ww.GetSafeHwnd();
	GraphDoneDlg* pDlg = new GraphDoneDlg();
	pDlg->Create(hWndParent);
	SetFocus(hWndParent); /// TD 03-31-2008 QA80-11353  GRAPH_VIEW_LOOSES_KEYFOCUS_WHEN_CHILD_DIALOG
	//---- CPY 4/5/08 ADD_TITLE_TO_SMALL_GRAPH_DIALOG
	if(lpcszTitle && *lpcszTitle)
		pDlg->Text = lpcszTitle;
	//----
	pDlg->ResizeOnStart();		///Jasmine 05/06/2011 ORG-2781-S2 KEEP_HIDE_HIDE_STATE
	pDlg->ShowDialog(false);
	
	pDlg->SetAutoSize(bAutoResize);/// YuI 04/02/08 OPTION_TO_AUTOSIZE_GETPOINTSDIALOG

	if ( NULL != lpcstrMsg )
		pDlg->ShowMsg(lpcstrMsg);
	
	dwDlg = (ODWP)pDlg;	///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
	
	return true;
}
/// end PA_PEAKS_ADD_DONE_DIALOG_WHEN_MODIFY

///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
bool CloseGetDoneDlg(ODWP dwDlg)
{
	GraphDoneDlg* pDlg = NULL;
	
	try
	{
		pDlg = (GraphDoneDlg*)dwDlg;
	}
	catch ( int nErr )
	{
		ASSERT(false);
		return false;
	}
	              
#ifdef	_DEBUG_
		out_str("CloseGetDoneDlg");
#endif		
	
	if(pDlg)
	{
		pDlg->SendMessage(WM_CLOSE);
		return true;
	}
	
	return false;
}
///End RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG

///-----Kit 12/02/2010 ORG-1532-S3 ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg
class DoubleBtnGetPts;
#define STR_GRAPH_DOUBLE_BTN_DLG_NAME "GraphDoubleBtnGetPtsDlg"
class GraphDoubleBtnGetPtsDlg : public GraphGetPtsDlg
{
public:
	GraphDoubleBtnGetPtsDlg() : GraphGetPtsDlg()
	{
	}
protected:
	EVENTS_BEGIN
		ON_INIT( OnInitDialog )
		ON_BN_CLICKED( IDC_OPEN_NLFIT_BUTITON_ID, OnClickOpenFitNL )
		ON_BN_CLICKED( IDC_FIT_BUTTON_ID, OnClickFit )
		///------ Folger 03/22/2011 ORG-2499 GET_POINTS_DLG_FOR_MULTIPLE_PEAKS_FIT_SUPPORT_HIDE_HINT
		ON_BN_CLICKED(IDC_HIDE_HINTS_BTN, OnHideHints)
		ON_GETMINMAXINFO(OnMinMaxInfo)
		ON_USER_MSG(ID_GETPTSDLG_MSG_ON_FINISH, OnFinish)
		///------ End GET_POINTS_DLG_FOR_MULTIPLE_PEAKS_FIT_SUPPORT_HIDE_HINT
		ON_READY(OnReady)			///Jasmine 05/06/2011 ORG-2781-S1 OFFSET_GETPTS_DLG_IN_PAGE
		ON_DESTROY(OnDestroy)		///Jasmine 05/06/2011 ORG-2781-S2 KEEP_HIDE_HIDE_STATE
	EVENTS_END
protected:
	enum
	{
		IDC_FIT_BUTTON_ID			= IDC_GRAPH_GETPTS_DLG_BUTTON2, 
		IDC_OPEN_NLFIT_BUTITON_ID	= IDC_DONE, 
		IDC_HINT_ID					= IDC_STATIC_NEXTPTS,
	};

	BOOL	OnInitDialog()
	{
		GraphGetPtsDlg::OnInitDialog();
		///------ Folger 03/22/2011 ORG-2499 GET_POINTS_DLG_FOR_MULTIPLE_PEAKS_FIT_SUPPORT_HIDE_HINT
		/////Jasmine 03/14/11 ORG-2434-S1 HIDE_HINTS_TO_SAVE_PLACE
		//Control btnHide = GetItem(IDC_HIDE_HINTS_BTN);
		//btnHide.Visible = false;
		/////End HIDE_HINTS_TO_SAVE_PLACE
		///------ End GET_POINTS_DLG_FOR_MULTIPLE_PEAKS_FIT_SUPPORT_HIDE_HINT
		
		Button btnFit = GetDlgItem( IDC_FIT_BUTTON_ID );
		Button btnOpenNLFit = GetDlgItem( IDC_OPEN_NLFIT_BUTITON_ID );
		
		btnFit.Visible			= true;
		btnFit.Enable			= false;///-----Kit 01/30/2011 ORG-2155-P2 WHEN_THERE_IS_NO_PTS_SEL_DISABLE_FIT_BTN
		btnFit.Text			= _L("Fit");
		btnOpenNLFit.Text	= _L("Open NLFit");
		///-----Kit 12/09/2010 ORG-1532-S3 ADD_TOOLTIP_INSTEAD_SHOW_ALL_MSG_WHEN_OPEN_GETPTSDLG
		btnFit.SetToolTip( _L( "Click \"Fit\" button to perform fitting directly.") );
		btnOpenNLFit.SetToolTip( _L("Click \"Open NLFit\" button to open the NLFit dialog to customize parameters.") );
		///-----ADD_TOOLTIP_INSTEAD_SHOW_ALL_MSG_WHEN_OPEN_GETPTSDLG
		
		return true;  
	}  
	// virtual 
	BOOL	Create( HWND hParent = NULL )
	{
		m_bDeleteOnDestroy = false;
		InitMsgMap();
		BOOL	bRet = ResizeDialog::Create( hParent );
		m_hwndParent = hParent;
		return bRet;
	}
	
	BOOL	OnClickFit( Control ctrl )
	{
		GetGetPtsPointer()->SetSelButton( SelBtnID_Fit );
		return GraphGetPtsDlg::OnDone(ctrl);
	}

	BOOL	OnClickOpenFitNL( Control ctrl )
	{
		GetGetPtsPointer()->SetSelButton( SelBtnID_OpenFitNL );
		return GraphGetPtsDlg::OnDone(ctrl);
	}

	// virtual
	int ArrangeControls()
	{
		///------ Folger 03/22/2011 ORG-2499 GET_POINTS_DLG_FOR_MULTIPLE_PEAKS_FIT_SUPPORT_HIDE_HINT
		//uint nButtonIDs[] = { IDC_FIT_BUTTON_ID, IDC_HINT_ID, 0 };
		uint nButtonIDs[] = { IDC_FIT_BUTTON_ID, IDC_HIDE_HINTS_BTN, IDC_HINT_ID, 0 };
		///------ End GET_POINTS_DLG_FOR_MULTIPLE_PEAKS_FIT_SUPPORT_HIDE_HINT
		ArrangeControlsLeftRight( nButtonIDs, 0, 0 );
	
		ResizeDlgToRightOfControl(IDC_HINT_ID, true, true, m_hwndParent);

		Button btnFit = GetDlgItem( IDC_FIT_BUTTON_ID );
		RECT rctFit;
		btnFit.GetWindowRect( &rctFit );
		int nFitBtnHeight = RECT_HEIGHT( rctFit );

		uint nSecondLineButtonIDs[] = { IDC_OPEN_NLFIT_BUTITON_ID, 0 };
		int nLowestYPos = ArrangeControlsLeftRight( nSecondLineButtonIDs, 0, nFitBtnHeight );	

		RECT rctHint;
		Window wndHint = GetDlgItem( IDC_HINT_ID );
		wndHint.GetWindowRect( &rctHint );
		int nHintHeight = RECT_HEIGHT( rctHint );

		///------ Folger 03/22/2011 ORG-2499 GET_POINTS_DLG_FOR_MULTIPLE_PEAKS_FIT_SUPPORT_HIDE_HINT
		//uint uResizeToBottomCtrlID = nLowestYPos > nHintHeight ? IDC_OPEN_NLFIT_BUTITON_ID : IDC_HINT_ID;
		RECT	rrOpenNLFIT;
		GetControlClientRect(IDC_OPEN_NLFIT_BUTITON_ID, rrOpenNLFIT);

		/*
 		RECT	rrHideHint;
 		Control	ctrlHideHint;
 		GetControlClientRect(IDC_HIDE_HINTS_BTN, rrHideHint, &ctrlHideHint);
		rrHideHint.bottom = rrOpenNLFIT.bottom;
		MoveControl(ctrlHideHint, rrHideHint);
		*/

		ScreenToClient(&rctHint);
		if ( rctHint.bottom < nLowestYPos )
		{
			rctHint.bottom = nLowestYPos;
			MoveControl(GetItem(IDC_HINT_ID), rctHint);
		}
		uint uResizeToBottomCtrlID = IDC_OPEN_NLFIT_BUTITON_ID;
		///------ End GET_POINTS_DLG_FOR_MULTIPLE_PEAKS_FIT_SUPPORT_HIDE_HINT

		ResizeDlgToBottomOfControl( uResizeToBottomCtrlID, false, true, m_hwndParent );

		return nLowestYPos;	// return the lowest y position
	}

	///Jasmine 05/06/2011 ORG-2781-S2 KEEP_HIDE_HIDE_STATE
	void OnDestroy()
	{
		Control btnHide = GetItem(IDC_HIDE_HINTS_BTN);
		bool bHide = btnHide.Text.CompareNoCase(">") == 0;
		SaveSetting( STR_HINT_HIDE_SETTING, bHide, GetRegistryDialogName() );
		
		ResizeDialog::OnDestroy();
	}
	///End KEEP_HIDE_HIDE_STATE
		
	///------ Folger 03/22/2011 ORG-2499 GET_POINTS_DLG_FOR_MULTIPLE_PEAKS_FIT_SUPPORT_HIDE_HINT
	virtual	BOOL	ResizeDlgBottonWhenHideHint()
	{
		return FALSE;
	}

	virtual	int		FinishButtonID()
	{
		return IDC_FIT_BUTTON_ID;
	}
	///------ End GET_POINTS_DLG_FOR_MULTIPLE_PEAKS_FIT_SUPPORT_HIDE_HINT

	///Jasmine 05/06/2011 ORG-2781-S2 KEEP_HIDE_HIDE_STATE
	virtual string  GetRegistryDialogName()
	{
		return GetRuntimeClass()+":"+Text;
	}
	///End KEEP_HIDE_HIDE_STATE
	
	///-----Kit 01/30/2011 ORG-2155-P2 WHEN_THERE_IS_NO_PTS_SEL_DISABLE_FIT_BTN
public:
	//virtual
	string GetRuntimeClass()
	{
		return STR_GRAPH_DOUBLE_BTN_DLG_NAME;
	}

	void ChangeFirstBtnState(bool bEnable = true)
	{
		GetDlgItem(IDC_FIT_BUTTON_ID).Enable = bEnable;
	}
	///-----End WHEN_THERE_IS_NO_PTS_SEL_DISABLE_FIT_BTN

};

class DoubleBtnGetPts : public UserGetPts
{
public:
	DoubleBtnGetPts( int nCursorType, LPCTSTR lpcszTitle, LPCTSTR lpcszInitMsg, LPCTSTR lpcszContinueMsg ) : 
	  UserGetPts( nCursorType, lpcszTitle, lpcszInitMsg, lpcszContinueMsg )
	{
	}
	
	// virtual
	~DoubleBtnGetPts()
	{
	}

	// virtual
#define	STR_ORIGIN_GLOBAL_NUMERIC_SETTING "*"
	void	OnDisplay( string& str, int nPoint )
	{
		///------ Folger 03/16/2011 ORG-2434-S2 CNTRL_ENTER_TO_DONE_GET_POINTS_DLG
		if ( !IsUpdateDisplay(str) )
			return;
		///------ End CNTRL_ENTER_TO_DONE_GET_POINTS_DLG

		GetGraphPoints::OnDisplay( str, nPoint );
		
		string strShowInDlg = "";
		strShowInDlg.Format( m_strContinueFmt, nPoint );

		double dX, dY;
		GetCursorPos( dX, dY );
		string strXYPos = "";
		strXYPos.Format( "X = %s, Y = %s", ftoa( dX, STR_ORIGIN_GLOBAL_NUMERIC_SETTING ), ftoa( dY, STR_ORIGIN_GLOBAL_NUMERIC_SETTING ) );
		
		strShowInDlg += "\n" + strXYPos;

		OutMsg(strShowInDlg);
	}
	
	///-----Kit 01/30/2011 ORG-2155-P2 WHEN_THERE_IS_NO_PTS_SEL_DISABLE_FIT_BTN
	//virtual 
	void OnNewPoint(int nPoint)
	{
		///------ Folger 03/16/2011 ORG-2434-S2 CNTRL_ENTER_TO_DONE_GET_POINTS_DLG
		UserGetPts::OnNewPoint(nPoint);
		///------ End CNTRL_ENTER_TO_DONE_GET_POINTS_DLG
		if( nPoint > 0)
			return ;
		
		if( m_pGetPtsDlg->GetRuntimeClass() == STR_GRAPH_DOUBLE_BTN_DLG_NAME )
		{
			GraphDoubleBtnGetPtsDlg *pDblDlg = (GraphDoubleBtnGetPtsDlg*)m_pGetPtsDlg;
			ASSERT(pDblDlg != NULL);
			pDblDlg->ChangeFirstBtnState(true);
		}
	}
	///-----End WHEN_THERE_IS_NO_PTS_SEL_DISABLE_FIT_BTN

	// virtual
	GraphGetPtsDlg *CreateGetPtsDlg()
	{
		GraphGetPtsDlg *pGetPtsDlg = new GraphDoubleBtnGetPtsDlg;
		ASSERT( pGetPtsDlg != NULL );
		return pGetPtsDlg;
	}	
};

int DoubleBtnGetPtsDlg( GraphGetPtsDlgParams *pGetPtsParams )
{
	if( pGetPtsParams == NULL )
		return -1;

	GraphLayer gl = Project.ActiveLayer();
	if( !gl.IsValid() )
		return -1;
	
	if(NULL == pGetPtsParams->lpcszContinueMsg)
		pGetPtsParams->lpcszContinueMsg = pGetPtsParams->lpcszInitMsg;

	DoubleBtnGetPts nlfGetPts( pGetPtsParams->nCursorType, pGetPtsParams->lpcszTitle, pGetPtsParams->lpcszInitMsg, pGetPtsParams->lpcszContinueMsg );

	if( pGetPtsParams->nPtsNeed < 0 )
		pGetPtsParams->nPtsNeed = GETPTS_UNKNOWN;

	if( nlfGetPts.GetPoints( pGetPtsParams->nPtsNeed, gl, STR_LT_VAR_DONE ) > 0 )
	{
		int nRetID = nlfGetPts.GetSelButton();
		int *pnID = pGetPtsParams->pnRetMsg;
		*pnID = nRetID;
		vector *pvx = pGetPtsParams->pvX;
		vector *pvy = pGetPtsParams->pvY;
		
		return nlfGetPts.GetData( *pvx, *pvy );
	}

	return -2; // cancel get points
}
///-----End ADD_TWO_BTN_INSTEAD_NONE_BTN_IN_GraphGetPtsDlg
