/*------------------------------------------------------------------------------*
 * File Name:	GetNImageDlg.c 													*
 * Creation: 	CPY 2/16/2006													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) Originlab Corp.	2006										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Iris 10/30/06 ADD_DYNAMIC_MESSAGE_BOX_ON_DYNA_IMAGE_BOX						*
 *	CPY 10/31/06 RESIZE_STATUS_BOX_MADE_IT_NOT_VISIBLE							*
 *  Joseph 11/09/06  ADD_THEME_CHANGE_EVENT										*
 *	Joseph 11/13/06  ADD_THEME_DESCRIPTION										*
 *  Iris 11/20/06 v8.0513 STATIC_ERR_BAR_NOT_SHOW_ON_INIT_TIME					*
 *	Joseph 11/20/06	CHANGE_TEHME_DESCRIPTION_ENABLE								*
 *  Iris 11/20/06 OK_BUTTON_DISABLED_BY_EVENT									*
 *	Joseph 11/21/06	SET_THEME_DESCRIPTION_TRIM_MENU								*
 *  Iris 11/21/06 v8.0513c PLACE_OK_CANCEL_AT_DLG_BOTTOM						*
 *	Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS										*
 *	Jasmine 04/20/07 OPTION_HIDDEN_BUTTON_NOT_IN_CAL							*
 *	Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU						*
 *	Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM						*
 *  Format 05/23/08 MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER						*
 *	Folger 05/29/08 GETN_IMAGE_DIALOG_SHOULD_INVOKE_ON_THEME_CHANGE_EVENT		*
 *	Folger 07/02/08 CLEAN_UP_FACTORY_DEFAULT_THEME_THAT_SHOULD_BE_REPLACED_BY_EMPTY_THEME
 *	Kenny 04/09/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG					*
 *	Sim 11-13-2009 QA81-14623 NOT_CLOSE_DLG_WHEN_ENTER_PRESSED					*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include "DialogEx.h"

#pragma labtalk(0) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS

#include <image_utils.h>
#include "ImageControl.h"

/// ML 2/16/2006
//#include "TreeEditSplitter.h"
#include "SplitterControl.h"


/// ML 2/21/2006
//#define BASE_WINDOW	SplitterControl
//#include	"TreeEditDlg2.h"
#include	"DynaSplitter.h"
/// end ML 2/21/2006


#include "GraphPageControl.h"

#include <Profiler.h>
#define PROFILE_HRGLASS			waitCursor junk;
#define WM_USER_MSG_ON_DLG_FROM_SPLITTER	(WM_USER +1010)//----- Iris 10/30/06 ADD_DYNAMIC_MESSAGE_BOX_ON_DYNA_IMAGE_BOX
#define WM_USER_MSG_UPDATE_OK_BUTTON		(WM_USER +1020)//--- Iris 11/20/06 OK_BUTTON_DISABLED_BY_EVENT 

///Joseph 1-30-07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
#define	DIALOG_TITL_HEIGHT  25 
#define BOTTOM_PANE_HEIGHT 150
///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
#include "GetNImageDlg.h"

static bool s_bTreeEditRightPane;
static bool s_bSplitterHorz = true;//---- CPY 9/12/05 GET_N_IMAGE_DIALOG
static HWND s_hdlg;

#define STR_DLG_NAME_SEPERATOR	":"	///Joseph 1-30-07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
//---- CPY 9/12/05 GET_N_IMAGE_DIALOG
bool GetNImageBox(TreeNode& tr, PIMAGE_FUNC pfn, LPCSTR lpcszTitle, LPCSTR lpcszDescription, HWND hWndParent)
{
	int nID = IDD_GETNBOX_PREVIEW;
	
	s_bTreeEditRightPane = false;//true;CPY 5/14/06 move dyna part to top so image part can resize with dialog
	s_bSplitterHorz = false;

	///Joseph 04/03/07 CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE
	/*
	///Joseph 02/09/07 ADD_NEW_PREVIEW_DLG_NO_THEME	
	//GetNImageDlg myDlg(tr, lpcszTitle, lpcszDescription, pfn, XF_GETN_IMAGE);	
	if( (is_xf_gui_getn_tree(tr) && tr.tagName.CompareNoCase(XFGUI_GETN_TAGNAME_NO_THEME) )|| tr.tagName == "GUI")
		nID = IDD_GETNBOX_PREVIEW_THEME;
	else
		nID = IDD_GETNBOX_PREVIEW;	
	*/
	//clean code
	if(!tr)
		return false;
	
	if(is_theme_dialog(tr))
		nID = IDD_GETNBOX_PREVIEW_THEME;
	else
		nID = IDD_GETNBOX_PREVIEW;	
	///End CHANGE_PARAMETER_SHOULD_NOT_SUPPORT_THEME_AND_AUTOUPDATE_MODE
	
	GetNImageDlg myDlg(tr, nID, lpcszTitle, lpcszDescription, pfn, XF_GETN_IMAGE);	
	///End ADD_NEW_PREVIEW_DLG_NO_THEME

	
	int nRet = myDlg.DoModalEx(hWndParent);
	if(IDOK == nRet)
	{
		myDlg.UpdateEditTreeNode(tr);
		return true;
	}
	return false;
}
//----
/*
void PostMsgToGetNImageDlg(string str)
{
	Window win(s_hdlg);
	if(win)
	{
		win.PostMessage(WM_USER_GETNGRAPH_CHANGED_BY_GRAPH, -1);
	}
}
*/
///DG 6/21/05 QA70-7824 v8.0253 : bug

///Joseph 02/09/07 ADD_NEW_PREVIEW_DLG_NO_THEME
//GetNImageDlg::GetNImageDlg(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PIMAGE_FUNC pfnImg, int nEventID, DWORD dwOptions)
//: MultiPaneDlg(IDD_GETNBOX_PREVIEW, "ODlg")
GetNImageDlg::GetNImageDlg(TreeNode& tr, int nDlgID, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PIMAGE_FUNC pfnImg, int nEventID, DWORD dwOptions)
: MultiPaneDlg(nDlgID, "ODlg")
///End ADD_NEW_PREVIEW_DLG_NO_THEME

{		
	m_nDlgID = nDlgID;		//--------Folger 07/20/07 USE_BITMAP_RADIO_BUTTON_INSTEAD_OF_TEXT_BUTTON
	m_strTitle = lpcszTitle;
	m_strDescription = lpcszDescription;
	
	m_splitter.Setup(tr, pfnImg, nEventID, dwOptions);
}
GetNImageDlg::~GetNImageDlg()
{
	s_hdlg = NULL;
}

/// YuI 09/29/05 MATRIX_OBJECT_VAR_INTERACTIVE_CONTROL
BOOL GetNImageDlg::OnDestroy()
{
	// I am adding this as additional protection against OC runtime error which could
	// prevent EnableGUI execution when interactive control is destroyed
//	Project.EnableGUI(TRUE);
	/// end VECTORIAL_NUMERIC_FUNCTIONS
		
	return MultiPaneDlg::OnDestroy();
}
/// end MATRIX_OBJECT_VAR_INTERACTIVE_CONTROL

BOOL GetNImageDlg::OnInitDialog()
{
	//------ Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU
#ifndef THEME_CONTROL_POPUP_MENU
	vector<uint> vnThemeSaveGroup = {IDC_GETN_THEME_TEXT, IDC_GETN_THEME_COMB, IDC_GETN_SAVE_BTN, IDC_GETN_SAVE_AS_BTN, 0};
#else
	vector<uint> vnThemeSaveGroup = {IDC_GETN_THEME_TEXT, IDC_GETN_THEME_COMB, IDC_GETN_SAVE_AS_BTN, 0};
#endif
	//------
	m_vnThemeSaveGroup = vnThemeSaveGroup;
	
	PROFILE_HRGLASS
		
	MultiPaneDlg::OnInitDialog(IDC_PARAMS_PREVIEW, IDC_PARAMS_MORE, 0, NULL, m_strTitle);
	
	//----- Iris 10/30/06 ADD_DYNAMIC_MESSAGE_BOX_ON_DYNA_IMAGE_BOX
	
	///Format 05/23/08 MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER
	//m_btnErrMessage = GetItem(IDC_ERR_MESSAGE_BOX);	
	//if(m_btnErrMessage)
	//	m_btnErrMessage.Text = "";
	//m_splitter.SetErrMsg(*this, "");	///Kenny 04/09/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
	Control ctrl = GetItem(IDC_ERR_MESSAGE_BOX);
	if(ctrl)
		ctrl.Visible = false;
	//----- 
	///MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER
	
	//theme
	m_comboTheme = GetItem(IDC_GETN_THEME_COMB);
	m_btnSaveTheme = GetItem(IDC_GETN_SAVE_BTN);
	//------ Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU
#ifndef THEME_CONTROL_POPUP_MENU
	//--------Folger 07/20/07 USE_BITMAP_RADIO_BUTTON_INSTEAD_OF_TEXT_BUTTON
	if (m_nDlgID == IDD_GETNBOX_PREVIEW_THEME)
	{
		vector<string> vsTips;
		vsTips.Add(_L("Save theme"));
		m_btnSaveTheme.Init(1, IDB_PAGEXFBAR_SAVE, 16, vsTips);
		
		BitmapRadioButton m_btnSaveAs = GetItem(IDC_GETN_SAVE_AS_BTN);	
		vsTips.RemoveAll();
		vsTips.Add(_L("Save theme as..."));
		m_btnSaveAs.Init(1, IDB_PAGEXFBAR_SAVEAS, 16, vsTips);
	}
#else
	if ( m_comboTheme )
		m_comboTheme.Enable = false;
	if ( m_btnSaveTheme )
		m_btnSaveTheme.Visible = false;
	if ( m_nDlgID == IDD_GETNBOX_PREVIEW_THEME )
	{
		BitmapRadioButton btnSaveAs = GetItem(IDC_GETN_SAVE_AS_BTN);	
		vector<string> vsTips;
		btnSaveAs.Init(1, IDB_DROP_DOWN_UP, 16, vsTips);
	}
#endif	
	//------ End ADD_THEME_CONTROL_POPUP_MENU
	
	///Joseph 11/13/06  ADD_THEME_DESCRIPTION
	//the new line
	m_vnThemeDescrip.Add(IDC_PARAMS_DESCRIPTION_LABEL);
	m_vnThemeDescrip.Add(IDC_PARAMS_DESCRIPTION);
	//m_vnThemeDescrip.Add(IDOK);//---Iris 11/21/06 v8.0513c PLACE_OK_CANCEL_AT_DLG_BOTTOM
	m_vnThemeDescrip.Add(0);
	///End ADD_THEME_DESCRIPTION
	//InitThemeControls();
	m_ctrlLabel = GetItem(IDC_PARAMS_DESCRIPTION); ///Joseph 11/20/06	CHANGE_TEHME_DESCRIPTION_ENABLE
	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	//loadThemeFilesToCombo(getInputTree());
	m_splitter.SPLInitThemeControls(this, getInputTree(), IDC_GETN_THEME_COMB, IDC_GETN_THEME_TEXT, IDC_GETN_SAVE_BTN, IDC_GETN_SAVE_AS_BTN, IDC_PARAMS_DESCRIPTION, IDC_PARAMS_DESCRIPTION_LABEL);
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE

	m_splitter.Init(IDC_PARAMS_PREVIEW, *this, 0, m_strTitle);
	
	SetDialogTitle(m_strTitle);
	///Joseph 11/20/06	CHANGE_TEHME_DESCRIPTION_ENABLE
	//m_ctrlLabel = GetItem(IDC_PARAMS_DESCRIPTION);
	///End CHANGE_TEHME_DESCRIPTION_ENABLE
	if(m_strDescription.IsEmpty())	//no description
	{
		replaceLabelSizeForSplitter();	//do later, hide description label and enlarge splitter
		m_ctrlLabel.Visible = false;
	}
	else
		///Joseph 11/21/06	SET_THEME_DESCRIPTION_TRIM_MENU
		//m_ctrlLabel.Text = m_strDescription;
		setThemeDescirp();
		///End SET_THEME_DESCRIPTION_TRIM_MENU
	///---Sim 11-13-2009 QA81-14623 NOT_CLOSE_DLG_WHEN_ENTER_PRESSED
	if ( DYNALAYOUT_NOT_CLOSE_ON_ENTER_KEY & m_splitter.GetXFBits() )
		SetDefaultButton(FALSE);
	///---END QA81-14623 NOT_CLOSE_DLG_WHEN_ENTER_PRESSED
	return true;
}
//---- CPY 9/22/05 SPLITTER_INIT_SIZE_ON_READY	
BOOL GetNImageDlg::OnReady()
{
	UpdateDlgShow();
	m_splitter.OnReady();
	SetInitReady();
	///Joseph 01/31/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	///Joseph 03/08/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	//need argument: Dlg name
	//if(0 == HasPreviousSize())
	string strClassOption, strDlgName;
	theme_get_class_option(getInputTree(), strClassOption);
	strDlgName = STR_DLG_NAME + STR_DLG_NAME_SEPERATOR + strClassOption;
	if(0 == HasPreviousSize(strDlgName))
	///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	{
		SetInitSize();
	}
	///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	return true;
}
//----
BOOL GetNImageDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
{
	string strClassOption;;
	theme_get_class_option(getInputTree(), strClassOption);
	if(!strClassOption.IsEmpty())
	{
		string strLT;
		strLT.Format("help %s", strClassOption);
		LT_execute(strLT);
	}
	//----

	return false;
}
BOOL GetNImageDlg::OnClickOK()
{
	return true;
}
BOOL GetNImageDlg::OnClickCancel()
{
	return true;
}
BOOL GetNImageDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return true;
	///Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS
	MoveControlsHelper	_temp(this);		
	_temp.Exclude(IDC_ERR_MESSAGE_BOX);
	_temp.Exclude(IDC_PARAMS_PREVIEW);	///Joseph 04/11/06 FIX_IMAGE_ERRMSG_NOT_SHOW_ISSUE
	///End DLG_RESIZE_PAINT_MESS
	//---Iris 11/21/06 v8.0513c PLACE_OK_CANCEL_AT_DLG_BOTTOM
	//uint nButtonIDs[] = {IDC_GETN_SAVE_AS_BTN, IDOK, IDCANCEL, 0};	
	uint nButtonIDs[] = {IDCANCEL, IDOK, 0};	
	
	//no bottom panel in GetNImage dialog, but exist a hidden UpDown button, will cause a big gap between Cancel and border when do resize 
	Control btnUPDown = GetItem(IDC_PARAMS_MORE);
	if(false == btnUPDown.Visible)
	{
		RECT rr;
		rr.top = 1;
		rr.bottom = 2;
		rr.left = 1;
		rr.right = 2;
		btnUPDown.MoveWindow(&rr);
	}
	//---
	
	//----- Iris 11/20/06 v8.0513 STATIC_ERR_BAR_NOT_SHOW_ON_INIT_TIME
	/*
	///Joseph 11/13/06  ADD_THEME_DESCRIPTION
	//MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, true);
	//resizeTopPaneControl(cx, cy);
	resizeTopPaneControl(cx, cy);
	MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, true);	
	*/
	///End ADD_THEME_DESCRIPTION
	
	///Jasmine 04/20/07 OPTION_HIDDEN_BUTTON_NOT_IN_CAL
	//---Iris 11/21/06 v8.0513c PLACE_OK_CANCEL_AT_DLG_BOTTOM
	//MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, true);
	//MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, false);
	MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, false, -1, -1, false);
	//---
	///End OPTION_HIDDEN_BUTTON_NOT_IN_CAL
	
	resizeTopPaneControl(cx, cy);
	//-----
	m_splitter.OnResize(nType, cx, cy);// need to force resize of 1st pane

	return true;
}
BOOL GetNImageDlg::OnShowPreview(Control ctrl)
{
	MultiPaneDlg::OnShowBottomPane(ctrl);
	return true;
}
BOOL GetNImageDlg::OnComboChangeTheme(Control ctrl)
{
	string strSel;
	m_comboTheme.GetLBText(m_comboTheme.GetCurSel(),strSel);
	updateSaveButton(strSel);	
	///Joseph 11/09/06  ADD_THEME_CHANGE_EVENT
	TreeNode trNode = getInputTree();
	if(theme_update_on_new_sel(trNode, strSel))
	//if(theme_update_on_new_sel(getInputTree(), strSel))
	///End ADD_THEME_CHANGE_EVENT
	{
		m_splitter.OnInputTreeModified();//SetTree(m_input_tr, true);
		
		///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
		//updateThemeDescription(trNode, false); ///Joseph 11/13/06  ADD_THEME_DESCRIPTION
		///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
		
		//------ Folger 05/29/08 GETN_IMAGE_DIALOG_SHOULD_INVOKE_ON_THEME_CHANGE_EVENT
		//m_splitter.OnChangeTheme();///Joseph 11/09/06  ADD_THEME_CHANGE_EVENT
		//------
	}
	return	true;// event handler always returns true
}
BOOL GetNImageDlg::OnSaveTheme(Control ctrl)
{
	
	///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
	/*
	///Joseph 11/13/06  ADD_THEME_DESCRIPTION
	//TreeNode tr = getInputTree();
	//updateThemeDescription(tr);
	///End ADD_THEME_DESCRIPTION
	*/
	///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
	
	saveAsTheme(NULL);
	return true;
}
BOOL GetNImageDlg::OnSaveThemeAs(Control ctrl)
{
	//------ Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU
#ifndef THEME_CONTROL_POPUP_MENU
	string strFullFileName = theme_ask_save_as_filename(getInputTree(), GetSafeHwnd());
	if(strFullFileName.IsEmpty())
		return true; // event handler, always return true

	TreeNode tr = getInputTree();
	
	///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
	//updateThemeDescription(tr, false);
	///---End NOT_USE_THEME_DESCRIPTION_ANY_MORE
	
	if(	saveAsTheme(strFullFileName) )
		loadThemeFilesToCombo(tr);
	
	return true;
#else
	return m_splitter.OnShowThemeMenu(ctrl, &m_comboTheme, &m_btnSaveTheme);
#endif
	//-------
}

///---Joseph 03/31/06 NOT_USE_THEME_DESCRIPTION_ANY_MORE
/*
///Joseph 11/13/06  ADD_THEME_DESCRIPTION
//string GetNImageDlg::updateThemeDescription(TreeNode& tr, bool bEditToTree)
//{
	//string str;
	//if(m_ctrlLabel)
	//{
		//if(bEditToTree)
			//tr.SetAttribute(STR_THEME_COMMENT_ATTRIB, m_ctrlLabel.Text);
		//else
		//{
			//tr.GetAttribute(STR_THEME_COMMENT_ATTRIB, str);
			//setThemeDescirp();
		//}
	//}
	//return str;
//}
///End ADD_THEME_DESCRIPTION
*/
///End NOT_USE_THEME_DESCRIPTION_ANY_MORE

bool GetNImageDlg::saveAsTheme(LPCSTR lpcszThemeFilename)
{	
	///Joseph 11/21/06	SET_THEME_DESCRIPTION_TRIM_MENU
	//return theme_save_settings(getInputTree(), lpcszThemeFilename);
	return theme_save_settings(getGUITree(), lpcszThemeFilename);
	///End SET_THEME_DESCRIPTION_TRIM_MENU
	
}
void GetNImageDlg::loadThemeFilesToCombo(TreeNode& trGUI)
{
	/// YuI 08/25/05 should not be here The class option attribue is set in the xfunction_tree_to_getn_tree
	//trGUI.SetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, m_strTitle);	//temp code
	///Joseph 02/09/07 ADD_NEW_PREVIEW_DLG_NO_THEME
	//when no theme control, return
	if(! m_comboTheme)
		return;
	///End ADD_NEW_PREVIEW_DLG_NO_THEME
	m_comboTheme.ResetContent();
	vector<string> vsThemeList;
	int nSel = theme_get_list(trGUI, vsThemeList);
	
	if(vsThemeList.GetSize() == 0)
		return;
	
	for(int ii = 0; ii < vsThemeList.GetSize(); ii++)
		m_comboTheme.AddString(vsThemeList[ii]);
	
	m_comboTheme.SetCurSel(nSel);
	updateSaveButton(vsThemeList[nSel]);
}
void GetNImageDlg::updateSaveButton(const string& strSelTheme)
{
	bool bEnable = true;
	//------ Folger 07/02/08 CLEAN_UP_FACTORY_DEFAULT_THEME_THAT_SHOULD_BE_REPLACED_BY_EMPTY_THEME
	//if( PDS_LAST_USED == cvt_str_to_predefined_type(strSelTheme) || strSelTheme.IsEmpty() )	
	if( PDS_LAST_USED == cvt_str_to_predefined_type(strSelTheme) || theme_is_factory_default(strSelTheme) )	
	//------
		bEnable = false;
		
	m_btnSaveTheme.Enable = bEnable;
	
	///Joseph 04/25/07 DLG_DESCRIPTION_SUPPORT_MULTILINE
	//m_ctrlLabel.Enable = bEnable;		
	///End DLG_DESCRIPTION_SUPPORT_MULTILINE
	///End CHANGE_TEHME_DESCRIPTION_ENABLE
}

void GetNImageDlg::SetDialogTitle(LPCSTR lpcszTitle)
{
	Window wDlg=GetWindow();
	wDlg.Text = lpcszTitle;
}

//----- Iris 10/30/06 ADD_DYNAMIC_MESSAGE_BOX_ON_DYNA_IMAGE_BOX

///Joseph 04/25/07 DLG_DESCRIPTION_SUPPORT_MULTILINE
/*
int GetNImageDlg::getDlgStatusMsgBoxHeight(int nStatusBoxWidth)
{
	if(!m_btnErrMessage)
		return 0;
	int nLength = m_btnErrMessage.Text.GetLength();
	if(nLength < 1)
		return 0;
	uint nn = GetDialogBaseUnits();
	int nw1 = LOWORD(nn);nw1 = 0.5 + 0.6*nw1;
	int nh1 = HIWORD(nn);nh1 = 0.5 + 0.95*nh1;
	int nTextWidth = nLength * nw1;
	return nh1 * (1 + nTextWidth/nStatusBoxWidth);
}
*/

int GetNImageDlg::getMsgBoxHeight(Control ctrl, int nMsgBoxWidth)
{
	if(!ctrl)
		return 0;
	string str = ctrl.Text;
	int nLength = ctrl.Text.GetLength();
	if(nLength < 1)
		return 0;
	uint nn = GetDialogBaseUnits();
	int nw1 = LOWORD(nn);nw1 = 0.5 + 0.8*nw1;
	int nh1 = HIWORD(nn);nh1 = 0.5 + 0.95*nh1;
	int nTextWidth = nLength * nw1;
	return nh1 * (1 + nTextWidth/nMsgBoxWidth);
}
///End DLG_DESCRIPTION_SUPPORT_MULTILINE

void GetNImageDlg::resizeStatusMsgBox()
{
	RECT rrDlg;
	m_wndDlg.GetClientRect(&rrDlg);

	int nEdge = GetControlGap();
	Control ctrlGrid = GetItem(IDC_PARAMS_PREVIEW);
	RECT rr;
	GetClientRect(ctrlGrid, rr);
	
	//---Iris 11/21/06 v8.0513c PLACE_OK_CANCEL_AT_DLG_BOTTOM
	//rr.bottom = rrDlg.bottom - nEdge;//--- CPY 10/31/06 RESIZE_STATUS_BOX_MADE_IT_NOT_VISIBLE, first make sure this has the correct size so rr2 = rr will be correct later
	RECT 		rrOK;
	Control 	ctrlOK = GetItem(IDOK);
	GetClientRect(ctrlOK, rrOK);	
	
	rr.bottom = rrDlg.bottom - nEdge - RECT_HEIGHT(rrOK) - nEdge;
	//---
	
	RECT rr2;
	rr2 = rr;
	
	///Joseph 04/25/07 DLG_DESCRIPTION_SUPPORT_MULTILINE
	//int		nErrMessageHeight = getDlgStatusMsgBoxHeight(RECT_WIDTH(rr));
	
	///Format 05/23/08 MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER
	//int		nErrMessageHeight = getMsgBoxHeight(m_btnErrMessage, RECT_WIDTH(rr));
	int nErrMessageHeight = m_splitter.getMsgBoxHeight(RECT_WIDTH(rr));
	///MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER
	
	///End DLG_DESCRIPTION_SUPPORT_MULTILINE
	//printf("nErrMessageHeight is %d\n", nErrMessageHeight);
	
	///Format 05/23/08 MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER, use the button IDC_ERR_MESSAGE_BOX
	Control ctrl = GetItem(IDC_ERR_MESSAGE_BOX);
	if(!ctrl)
		return;
	///MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER
	
	if(nErrMessageHeight)
	{
		rr.bottom -= nErrMessageHeight + nEdge;	//--- CPY 10/31/06 RESIZE_STATUS_BOX_MADE_IT_NOT_VISIBLE		
		///Format 05/23/08 MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER, 
		//m_btnErrMessage.Visible = true;
		ctrl.Visible = true;
		///MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER
	}
	else	
	{
		//rr.bottom = rrDlg.bottom - nEdge;//--- CPY 10/31/06 RESIZE_STATUS_BOX_MADE_IT_NOT_VISIBLE, moved to above
		///Format 05/23/08 MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER
		//m_btnErrMessage.Visible = false;
		ctrl.Visible = false;
		///MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER
	}	
	ctrlGrid.MoveWindow(&rr);
	rr2.top = rr.bottom + nEdge;
	///Format 05/23/08 MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER
	//m_btnErrMessage.MoveWindow(&rr2);
	ctrl.MoveWindow(&rr2);
	///MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER
}
//-----

void GetNImageDlg::resizeTopPaneControl(int cx, int cy)
{
	int nEdge=GetControlGap(), nx=nEdge, ny=nEdge;
	
	///DG THEME_COMBO_RESIZABLE
	//ny=ArrangeControlsLeftRight(m_vnThemeSaveGroup, nx, ny)+nEdge;
	
	//----- Iris 11/20/06 v8.0513 STATIC_ERR_BAR_NOT_SHOW_ON_INIT_TIME
	/*
	///Joseph 11/13/06  ADD_THEME_DESCRIPTION
	//ArrangeControlsLeftRight(m_vnThemeSaveGroup, nx, ny, cx-nEdge, IDC_GETN_THEME_COMB);
	ny = ArrangeControlsLeftRight(m_vnThemeSaveGroup, nx, ny, cx - nEdge, IDC_GETN_THEME_COMB) + nEdge;
	ArrangeControlsLeftRight(m_vnThemeDescrip, nx, ny, cx - nEdge, IDC_PARAMS_DESCRIPTION);
	///End ADD_THEME_DESCRIPTION
	*/
	///Joseph 02/09/07 ADD_NEW_PREVIEW_DLG_NO_THEME
	//when theme control is not valid, resize the m_splitter
	//ny = ArrangeControlsLeftRight(m_vnThemeSaveGroup, nx, ny, cx, IDC_GETN_THEME_COMB) + nEdge;
	//ArrangeControlsLeftRight(m_vnThemeDescrip, nx, ny, cx, IDC_PARAMS_DESCRIPTION);
	if(m_ctrlLabel)
	{
		ny = ArrangeControlsLeftRight(m_vnThemeSaveGroup, nx, ny, cx, IDC_GETN_THEME_COMB) + nEdge;
		resizeDlgDescrip(cx, cy, ny);	///Joseph 04/24/07 DLG_DESCRIPTION_SUPPORT_MULTILINE
		ArrangeControlsLeftRight(m_vnThemeDescrip, nx, ny, cx, IDC_PARAMS_DESCRIPTION);
	}
	else
	{
		RECT rSplitter;
		m_splitter.GetClientRect(&rSplitter);
		rSplitter.top = nx;
		rSplitter.bottom = ny;
		m_splitter.MoveWindow(&rSplitter, true);
	}
	///End ADD_NEW_PREVIEW_DLG_NO_THEME
	//----- 
	
	///end THEME_COMBO_RESIZABLE
	resizeStatusMsgBox();//----- Iris 10/30/06 ADD_DYNAMIC_MESSAGE_BOX_ON_DYNA_IMAGE_BOX
}

///Joseph 04/24/07 DLG_DESCRIPTION_SUPPORT_MULTILINE
bool GetNImageDlg::resizeDlgDescrip(int cx, int cy, int ny)
{
	Control ctrlDescripLabel;
	ctrlDescripLabel = GetItem(IDC_PARAMS_DESCRIPTION_LABEL);
	if(! m_ctrlLabel || ! ctrlDescripLabel)
		return false;
	
	RECT rtDesp, rtLabel, rtSplitter;
	int nEdge = GetControlGap();
	GetClientRect(m_ctrlLabel, rtDesp);
	GetClientRect(ctrlDescripLabel, rtLabel);
	int nHeight = getMsgBoxHeight(m_ctrlLabel, cx - RECT_WIDTH(rtLabel) + 3 * nEdge);
	rtDesp.bottom = rtDesp.bottom - RECT_HEIGHT(rtDesp) + nHeight;
	rtDesp.right = cx - nEdge;
	m_ctrlLabel.MoveWindow(&rtDesp);
	
	m_splitter.GetClientRect(&rtSplitter);
	rtSplitter.top = ny + nHeight + nEdge;
	rtSplitter.bottom = cy;
	m_splitter.MoveWindow(&rtSplitter, true);
	return true;
}
///End DLG_DESCRIPTION_SUPPORT_MULTILINE



///Joseph 11/22/06	SET_THEME_DESCRIPTION_TRIM_MENU
void GetNImageDlg::setThemeDescirp()
{
	///Joseph 02/09/07 ADD_NEW_PREVIEW_DLG_NO_THEME
	//if theme control is not valid, return
	if(! m_ctrlLabel)
		return;
	///End ADD_NEW_PREVIEW_DLG_NO_THEME
	string strMenu, strBriefDescription;
	xf_seperate_description(m_strDescription, strMenu, strBriefDescription);
	m_ctrlLabel.Text = strBriefDescription;
}
///End	SET_THEME_DESCRIPTION_TRIM_MENU

void GetNImageDlg::replaceLabelSizeForSplitter()
{
	RECT rrLabel, rrSplitter;
	GetClientRect(m_ctrlLabel, rrLabel);
	Control cSplitter = GetItem(IDC_PARAMS_PREVIEW);
	GetClientRect(cSplitter, rrSplitter);
	
	rrSplitter.top = rrLabel.top + GetControlGap();
	MoveControl(cSplitter, rrSplitter);
}


/*
BOOL	GetNImageSplitter::OnInteractiveDataRange(Control ctrl)
{
	Window wnd = GetParent();
	return m_treeEditCntrl.DoInteractiveDlg(&wnd, TRUE, TRUE);
}

BOOL	GetNImageSplitter::OnInteractiveXYDataRange(Control ctrl)
{
	Window wnd = GetParent();
	return m_treeEditCntrl.DoXYDataRangeDlg(&wnd, TRUE);
}

BOOL	GetNImageSplitter::OnInteractivePopUp(Control ctrl)
{
	Window wnd = GetParent();
	RECT rectButton;
	ctrl.GetWindowRect(&rectButton);
	int nX = (rectButton.left + rectButton.right) / 2;
	int nY = (rectButton.top + rectButton.bottom) / 2;
	
	return m_treeEditCntrl.DoInteractivePopUp(&wnd, nX, nY);
}
*/

//----- Iris 10/30/06 ADD_DYNAMIC_MESSAGE_BOX_ON_DYNA_IMAGE_BOX
BOOL GetNImageDlg::OnDynamicMsg(WPARAM wParam, LPARAM lParam)
{
	///Format 05/23/08 MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER, move this code into GetNImageSplitter
	//string strMsg;
	//LPCSTR lpcsz;
	//if(0 == wParam)
	//{
		//lpcsz = (LPCSTR)lParam;
	//}
	//else 
	//{
		//string str1;
		//if(ocu_load_err_msg_str(wParam, &str1))
		//{
			//// lParam is always in string form, strErrMsg is like "123:456" or "123:str"
			//LPCSTR lpcsz = (LPCSTR)lParam;
			//if(str1.Find("%d") >= 0)
			//{
				//int nCode = atoi(lpcsz);
				//strMsg.Format(str1, nCode);
			//}
			//else if(str1.Find("%s") >= 0)
				//strMsg.Format(str1, lpcsz);
			//else	
				//strMsg = str1;
		//}
		//else
			//strMsg.Format("Error Message %d was not found, please contact Originlab to fix this problem.", wParam);
		//
		//lpcsz = strMsg;
	//}
	//if(m_btnErrMessage)
	//{
		//string strOldText = m_btnErrMessage.Text;
		//int nOldLength = strOldText.GetLength();
		//m_btnErrMessage.Text = lpcsz;
		//int nLength = m_btnErrMessage.Text.GetLength();
		//if(nOldLength == 0 && nLength!= 0 ||
		   //nOldLength != 0 && nLength== 0 ||
			//nLength > nOldLength + 2 || nLength + 2 < nOldLength)
			//{
				//out_str("need to resize dlg to update status msg");	
				resizeStatusMsgBox();
			//}
	//}	
	///MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER
	return true;
}
//-----

//--- Iris 11/20/2006 OK_BUTTON_DISABLED_BY_EVENT
BOOL GetNImageDlg::OnUpdateOKButton(uint wParam, uint lParam)
{
	Control ctlOKButton = GetItem(IDOK);
	if(ctlOKButton)
		ctlOKButton.Enable = (wParam & GETNGEVT_OK_ENABLE)? true:false;
	return 	true;
}
//---

/////////////////////////////////////////////////////////////////////
//////////////////           Splitter           /////////////////////
/////////////////////////////////////////////////////////////////////

///DG 6/21/05 QA70-7824 v8.0253 : bug
GetNImageSplitter::GetNImageSplitter() : DynaSplitter(s_bSplitterHorz, s_bTreeEditRightPane)
{
	m_bIsReady = false;
	
	//m_bShowPreviewGraph = true;
}
void GetNImageSplitter::Setup(TreeNode& tr, PIMAGE_FUNC pfnImg, int nEventID, DWORD dwOptions)
{
	m_dwOptions = dwOptions;
	//m_input_tr = tr;
	SetInputTree(tr);
	m_pImageFunc = pfnImg;
}
BOOL GetNImageSplitter::OnInitSplitter()
{
	m_bIsReady = false;
	
	CreateTreeEditPane();
	
	PictureControl picCntrl;
	CreateMainPane(picCntrl);
	m_pimgView = new MOImageControl(picCntrl);

	SetReady();
	initAllEvents();
	/// ML 2/16/2006
	//m_treeEditCntrl.SetReady(false);
	//m_treeEditCntrl.Update(m_trSplitter, true, true, true);
	//m_bIsReady = true;
	
	//update(m_trSplitter, true, true, true);
	UpdateDynaControl(true, GETNEVENT_ON_INIT, true);
//	s_hdlg = GetSafeHwnd();
	return true;
}

//------ Folger 05/29/08 GETN_IMAGE_DIALOG_SHOULD_INVOKE_ON_THEME_CHANGE_EVENT
//virtual
void	GetNImageSplitter::OnChangeTheme(const string& strSel, TreeNode& tr)
{
	invokeHandlers(-1, -1, -1, GETNEVENT_ON_THEME);
}
//------

//------ CPY 9/12/05 GET_N_IMAGE_DIALOG
void GetNImageSplitter::invokeHandlers(int nRow, int nCol, int nCntrlType, DWORD nEventInfo)
{
	//return;
	///////////////////////////////////////////////////////////////
	
	
	TreeNode trNode;
	if(nRow >= 0 && nCol >= 0)
		/// ML 2/16/2006
		//trNode = m_treeEditCntrl.GetTreeNode(nRow, nCol);
		trNode = m_DynaCntrl.GetTreeNode(nRow, nCol);

	int nUpdate = 0;
	PIMAGE_FUNC pfnImg  = getImageHandler();
	if(pfnImg)
		nUpdate = pfnImg(GetTree(), nRow, nCol, trNode, nEventInfo | GETNEVENT_UPDATE_GRAPH, nCntrlType, *this, m_pimgView);

	if(nUpdate & GETNGEVT_GRID_NEED_UPDATE)
	{
		/// ML 2/16/2006
		//m_treeEditCntrl.SetReady(false);
		//m_treeEditCntrl.Update(m_trSplitter, true, false, false);
		//m_treeEditCntrl.SetReady(true);
		
		
		//update(m_trSplitter, true, false, false);
		///Joseph 03/16/07 FIX_BUG_ON_CHANGE_THEME_IN_IMPAGE_BINARY
		//In xf ImgBinary, if change theme to factory default, should update gui tree. 
		//UpdateDynaControl();
		UpdateDynaControl(true, GETNEVENT_ON_CHANGE_UPDATE_GUI);	
		///End FIX_BUG_ON_CHANGE_THEME_IN_IMPAGE_BINARY
	}
	//--- Iris 11/20/2006 OK_BUTTON_DISABLED_BY_EVENT
	Window Wnd = GetParent();
	if(Wnd)
		Wnd.SendMessage(WM_USER_MSG_UPDATE_OK_BUTTON, nUpdate);
	//---
}

BOOL GetNImageSplitter::OnTrackSlider(WPARAM wParam, LPARAM lParam)
{
	int nPos = wParam;
	double* pVal = (double*) lParam;
	if(pVal)
	{
		// This cannot be done yet as I need a method from Tarak to retrieve
		// the TreeNode being edited.
		/*
		int nEditRow = m_treeEditCntrl.GetEditRow();
		TreeNode trEdit = m_treeEditCntrl.GetEditNode();
		//printf("%d) Slider %d and %g, tree val = %g\n", nEditRow, nPos, *pVal, trEdit.dVal);
		trEdit.dVal = *pVal;
		invokeHandlers(nEditRow, 1, trEdit.ID, 0);
		*/
		
	}	
	return true;
}
//------ end GET_N_IMAGE_DIALOG

//----- Iris 10/30/06 ADD_DYNAMIC_MESSAGE_BOX_ON_DYNA_IMAGE_BOX
BOOL	GetNImageSplitter::OnDynamicMsg(WPARAM wParam, LPARAM lParam)
{
	///Format 05/23/08 MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER
	//Window Wnd = GetParent();
	//if(Wnd)
		//Wnd.SendMessage(WM_USER_MSG_ON_DLG_FROM_SPLITTER, wParam, lParam);
	//return true;

	string strMsg;
	LPCSTR lpcsz;
	if(0 == wParam)
	{
		lpcsz = (LPCSTR)lParam;
	}
	else 
	{
		string str1;
		if(ocu_load_err_msg_str(wParam, &str1))
		{
			// lParam is always in string form, strErrMsg is like "123:456" or "123:str"
			LPCSTR lpcsz = (LPCSTR)lParam;
			if(str1.Find("%d") >= 0)
			{
				int nCode = atoi(lpcsz);
				strMsg.Format(str1, nCode);
			}
			else if(str1.Find("%s") >= 0)
				strMsg.Format(str1, lpcsz);
			else	
				strMsg = str1;
		}
		else
			strMsg.Format("Error Message %d was not found, please contact Originlab to fix this problem.", wParam);
		
		lpcsz = strMsg;
	}
	if(m_btnErrMessage)
	{
		string strOldText = m_btnErrMessage.Text;
		int nOldLength = strOldText.GetLength();
		///Kenny 04/09/2009 QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
		//m_btnErrMessage.Text = lpcsz;
		CountSetErrMsg(lpcsz);
		///End QA80-13422 COUNT_APPEAR_TIMES_OF_ERR_MSG
		int nLength = m_btnErrMessage.Text.GetLength();
		if(nOldLength == 0 && nLength!= 0 ||
		   nOldLength != 0 && nLength== 0 ||
			nLength > nOldLength + 2 || nLength + 2 < nOldLength)
			{
				//out_str("need to resize dlg to update status msg");	
				//resizeStatusMsgBox();
				Window Wnd = GetParent();
				if(Wnd)
					Wnd.SendMessage(WM_USER_MSG_ON_DLG_FROM_SPLITTER, wParam, lParam);
			}
	}
	return true;
	
	
	///MOVE_BTN_ERR_MSG_INTO_GETNIMAGESPLITTER
}

//-----
/*
BOOL GetNImageSplitter::OnSelectionChange()
{
	return m_DynaCntrl.OnSelectionChange();
}

BOOL GetNImageSplitter::OnSelectionTrack()
{
	return m_DynaCntrl.OnSelectionTrack();
}

*/

///Joseph 1-30-07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
//hard code, must be changed later
BOOL	GetNImageDlg::OnInitSize()
{
	return FALSE;
}
BOOL GetNImageDlg::OnRestoreSize(ODWP dwSizeInfo)
{
	void * p = (void*)dwSizeInfo;
	DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
	string strClassOption, strDlgName;
	theme_get_class_option(getInputTree(), strClassOption);
	strDlgName = STR_DLG_NAME + STR_DLG_NAME_SEPERATOR + strClassOption;
	lstrcpyn(pSz->szDialogName, strDlgName, MAXLINE);
	if(0 == HasPreviousSize(strDlgName)) //---- CPY 2/15/2007 DLGSIZEINFO_CALL_NEED_PREV_SIZ added strDlgName to pass in
	{
		pSz->bStartHidden = true;
	}
	
	SIZE sz;
	GetDlgOptimalSize(sz);
	///Joseph 02/15/07 ROLL_BRAK_TO_TD_DESIGN
	//pSz->top = -100;
	//pSz->left = -50;
	pSz->top = -1;
	pSz->left = -1;
	///End ROLL_BRAK_TO_TD_DESIGN
	pSz->width = 100;
	pSz->height = 200;
	return TRUE;
}

bool GetNImageDlg::GetDlgOptimalSize(SIZE& sze)
{

	Control ctrlThemeCombo = GetItem(IDC_GETN_THEME_COMB);
	Control ctrlThemeDesp = GetItem(IDC_PARAMS_DESCRIPTION);
	Control ctrlOKButton = GetItem(IDOK);
	RECT rCombo, rThemeDesp, rOKButton;
	GetClientRect(m_comboTheme, rCombo);
	GetClientRect(ctrlThemeDesp, rThemeDesp);
	GetClientRect(ctrlOKButton, rOKButton);
	
	sze = m_splitter.GetOptimalSize();
	int nGridx, nGridy;
	int nEdge = GetControlGap();
	nGridx = sze.cx + RECT_HEIGHT(rCombo) + RECT_HEIGHT(rThemeDesp) + RECT_HEIGHT(rOKButton) + 5 * nEdge;
	nGridy = sze.cy + 2 * nEdge + DIALOG_TITL_HEIGHT;  
	if(GetPreviewOnRight())
	{
		nGridx = nGridx + 2 * nEdge + BOTTOM_PANE_HEIGHT;
	}
	else
	{
		nGridy = nGridy + nEdge + BOTTOM_PANE_HEIGHT;
	}
	sze.cx = nGridx;
	sze.cy = nGridy;
	return true;
}
bool GetNImageDlg::SetInitSize()
{
	//---- CPY 2/15/2007 DLGSIZEINFO_CALL_NEED_PREV_SIZ
	/*
	RECT rDlg;
	rDlg.top = 0;
	SIZE sz;
	GetDlgOptimalSize(sz);
	rDlg.bottom = sz.cy;
	rDlg.left = 0;
	rDlg.right = sz.cx;
	SetBottomPaneHeight(BOTTOM_PANE_HEIGHT);
	MoveWindow(&rDlg);
	*/
	SIZE sz;
	GetDlgOptimalSize(sz);
	SetBottomPaneHeight(BOTTOM_PANE_HEIGHT);
	MoveDialogToCenter(sz);
	//----
	return true;
}
///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS