/*------------------------------------------------------------------------------*
 * File Name:	GetNGraphDlg.c 													*
 * Creation: 	Danice 6/11/05													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * DG 6/11/05 GETN_PREVIEW_DIALOG												*
 *	CPY 9/12/05 GET_N_IMAGE_DIALOG												*
 *	CPY 9/22/05 SPLITTER_INIT_SIZE_ON_READY										*
 *	CPY 12/26/05 GETNGRAPH_BOX_TYPE_4											*
 *	Sim 09-05-2008 CLEAN_DEFAULT_THEME											*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
#include "DialogEx.h"

#include <image_utils.h>
//------ CPY 9/12/05 GET_N_IMAGE_DIALOG
#include "ImageControl.h"
//------
//#include "DialogEx.h"


#include "TreeEditSplitter.h"
#include "GraphPageControl.h"

#include <Profiler.h>
#define PROFILE_HRGLASS			waitCursor junk;

static bool s_bTreeEditRightPane;
static bool s_bSplitterHorz = true;//---- CPY 9/12/05 GET_N_IMAGE_DIALOG

#include "GetNGraphDlg.h"

bool GetNGraphBox(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PGRAPH_FUNC pfn, HWND hWndParent, int nEventID) //=NULL, NULL, NULL, NULL, 0
{
	int nID = IDD_GETNBOX_PREVIEW;
	bool bTreeEditRightPane = false;
	s_bTreeEditRightPane = false;
	s_bSplitterHorz = true;//nEventID == XF_GETN_GRAPH_PREVIEW?true:false;
		
	GetNGraphDlg myDlg(tr, lpcszTitle, lpcszDescription, pfn, NULL, nEventID);
	
	int nRet = myDlg.DoModalEx(hWndParent);
	if(IDOK == nRet)
	{
		myDlg.UpdateEditTreeNode(tr);
		return true;
	}
	return false;
}
//---- CPY 9/12/05 GET_N_IMAGE_DIALOG
/*
bool GetNImageBox(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PIMAGE_FUNC pfn, HWND hWndParent)
{
	int nID = IDD_GETNBOX_PREVIEW;
	
	s_bTreeEditRightPane = true;
	s_bSplitterHorz = false;
		
	GetNGraphDlg myDlg(tr, lpcszTitle, lpcszDescription, NULL, pfn, XF_GETN_IMAGE);
	
	int nRet = myDlg.DoModalEx(hWndParent);
	if(IDOK == nRet)
	{
		myDlg.UpdateEditTreeNode(tr);
		return true;
	}
	return false;
}
*/
//----
static HWND s_hdlg;

void PostMsgToGetNDlg(string str)
{
	Window win(s_hdlg);
	if(win)
	{
		win.PostMessage(WM_USER_GETNGRAPH_CHANGED_BY_GRAPH, -1);
	}
}

///DG 6/21/05 QA70-7824 v8.0253 : bug
GetNGraphDlg::GetNGraphDlg(TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PGRAPH_FUNC pfn, PIMAGE_FUNC pfnImg, int nEventID, DWORD dwOptions) : MultiPaneDlg(IDD_GETNBOX_PREVIEW, "ODlg")
{	
	m_input_tr = tr;
	
	m_strTitle = lpcszTitle;
	m_strDescription = lpcszDescription;
	
	m_splitter.InitTree(m_input_tr, pfn, pfnImg, nEventID, dwOptions);
}
GetNGraphDlg::~GetNGraphDlg()
{
	s_hdlg = NULL;
}

/// YuI 09/29/05 MATRIX_OBJECT_VAR_INTERACTIVE_CONTROL
BOOL GetNGraphDlg::OnDestroy()
{
	// I am adding this as additional protection against OC runtime error which could
	// prevent EnableGUI execution when interactive control is destroyed
	Project.EnableGUI(TRUE);
	/// end VECTORIAL_NUMERIC_FUNCTIONS
		
	return MultiPaneDlg::OnDestroy();
}
/// end MATRIX_OBJECT_VAR_INTERACTIVE_CONTROL

BOOL GetNGraphDlg::OnInitDialog()
{
	vector<uint> vnThemeSaveGroup = {IDC_GETN_THEME_TEXT, IDC_GETN_THEME_COMB, IDC_GETN_SAVE_BTN, IDC_GETN_SAVE_AS_BTN, 0};
	m_vnThemeSaveGroup = vnThemeSaveGroup;
	
	PROFILE_HRGLASS
	if(m_splitter.IsImageMode())
	{
		MultiPaneDlg::OnInitDialog(IDC_PARAMS_PREVIEW, IDC_PARAMS_MORE, 0, NULL, m_strTitle);
	}
	else
	{
		vector<string>  vstrTipsUpDown;
		vstrTipsUpDown.SetSize(2);
		vstrTipsUpDown[0] = _L("Show Previews");
		vstrTipsUpDown[1] = _L("Hide Previews");
		MultiPaneDlg::OnInitDialog(IDC_PARAMS_PREVIEW, IDC_PARAMS_MORE, IDC_GETN_RESULT_PREVIEW, vstrTipsUpDown, m_strTitle);
	}

	//theme
	m_comboTheme = GetItem(IDC_GETN_THEME_COMB);
	m_btnSaveTheme = GetItem(IDC_GETN_SAVE_BTN);
	loadThemeFilesToCombo(m_input_tr);
	
	
	Control ctrl = GetItem(IDC_GETN_RESULT_PREVIEW);
	HWND hWnd = ctrl.GetSafeHwnd();
	GraphControl gcCntrl;
	gcCntrl.CreateControl(hWnd);
	m_splitter.CreatePreviewGraph(gcCntrl);
	
	m_splitter.Init(IDC_PARAMS_PREVIEW, *this, 0, m_strTitle);
	if(!m_splitter.IsPreviewGraphUsed())
	{
		//diable preview pane when it's not used
		MultiPaneDlg::DisableBottomPane();
		//OnShowPreview(ctrl); CPY 12/28/05, this line will lead to splitter not getting the needed 2nd resize that is necessary to init the divider
	}
	
	SetDialogTitle(m_strTitle);
	m_ctrlLabel = GetItem(IDC_PARAMS_DESCRIPTION);
	if(m_strDescription.IsEmpty())	//no description
	{
		replaceLabelSizeForSplitter();	//do later, hide description label and enlarge splitter
		m_ctrlLabel.Visible = false;
	}
	else
		m_ctrlLabel.Text = m_strDescription;
		
	return true;
}
//---- CPY 9/22/05 SPLITTER_INIT_SIZE_ON_READY	
BOOL GetNGraphDlg::OnReady()
{
	//UpdateDlgSize();
	UpdateDlgShow();
	m_splitter.OnReady();
	SetInitReady();
	return true;
}
//----
BOOL GetNGraphDlg::OnHelp(int &nHelpID, int nIdCtrlFocus)
{
	string strClassOption;;
	theme_get_class_option(m_input_tr, strClassOption);
	if(!strClassOption.IsEmpty())
	{
		string strLT;
		strLT.Format("help %s", strClassOption);
		LT_execute(strLT);
	}
	//----

	return false;
}
BOOL GetNGraphDlg::OnClickOK()
{
	return true;
}
BOOL GetNGraphDlg::OnClickCancel()
{
	return true;
}
BOOL GetNGraphDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return true;
	
	uint nButtonIDs[] = {IDC_GETN_SAVE_AS_BTN, IDOK, IDCANCEL, 0};
	MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, true);
	
	resizeTopPaneControl(cx, cy);
	return true;
}
BOOL GetNGraphDlg::OnShowPreview(Control ctrl)
{
	MultiPaneDlg::OnShowBottomPane(ctrl);
	return true;
}
BOOL GetNGraphDlg::OnComboChangeTheme(Control ctrl)
{
	string strSel;
	m_comboTheme.GetLBText(m_comboTheme.GetCurSel(),strSel);
	updateSaveButton(strSel);
	
	if(theme_update_on_new_sel(m_input_tr, strSel))
	{
		m_splitter.SetTree(m_input_tr, true);
	}
	return	true;// event handler always returns true
}
BOOL GetNGraphDlg::OnSaveTheme(Control ctrl)
{
	saveAsTheme(NULL);
	return true;
}
BOOL GetNGraphDlg::OnSaveThemeAs(Control ctrl)
{
	string strFullFileName = theme_ask_save_as_filename(m_input_tr, GetSafeHwnd());
	if(strFullFileName.IsEmpty())
		return true; // event handler, always return true

	if(	saveAsTheme(strFullFileName) )
		loadThemeFilesToCombo(m_input_tr);

	return true;
}
BOOL GetNGraphDlg::OnSelectionChange()
{
	return m_splitter.OnSelectionChange();
}
BOOL GetNGraphDlg::OnSelectionTrack()
{
	return m_splitter.OnSelectionTrack();
}

bool GetNGraphDlg::saveAsTheme(LPCSTR lpcszThemeFilename)
{
	return theme_save_settings(m_input_tr, lpcszThemeFilename);
}
void GetNGraphDlg::loadThemeFilesToCombo(TreeNode& trGUI)
{
	/// YuI 08/25/05 should not be here The class option attribue is set in the xfunction_tree_to_getn_tree
	//trGUI.SetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, m_strTitle);	//temp code
	m_comboTheme.ResetContent();
	vector<string> vsThemeList;
	int nSel = theme_get_list(trGUI, vsThemeList);
	
	if(vsThemeList.GetSize() == 0)
		return;
	
	for(int ii = 0; ii < vsThemeList.GetSize(); ii++)
		m_comboTheme.AddString(vsThemeList[ii]);
	
	m_comboTheme.SetCurSel(nSel);
	updateSaveButton(vsThemeList[nSel]);
}
void GetNGraphDlg::updateSaveButton(const string& strSelTheme)
{
	///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
	//if( PDS_LAST_USED == cvt_str_to_predefined_type(strSelTheme) || PDS_FACTORY_DEFAULT == cvt_str_to_predefined_type(strSelTheme) )
	if ( PDS_LAST_USED == cvt_str_to_predefined_type(strSelTheme) || theme_is_factory_default(strSelTheme) )
	///---END CLEAN_DEFAULT_THEME
		m_btnSaveTheme.Enable = false;
	else
		m_btnSaveTheme.Enable = true;
}

void GetNGraphDlg::SetDialogTitle(LPCSTR lpcszTitle)
{
	Window wDlg=GetWindow();
	wDlg.Text = lpcszTitle;
}

void GetNGraphDlg::resizeTopPaneControl(int cx, int cy)
{
	int nEdge=GetControlGap(), nx=nEdge, ny=nEdge;
	///DG THEME_COMBO_RESIZABLE
	//ny=ArrangeControlsLeftRight(m_vnThemeSaveGroup, nx, ny)+nEdge;
	ArrangeControlsLeftRight(m_vnThemeSaveGroup, nx, ny, cx-nEdge, IDC_GETN_THEME_COMB);
	///end THEME_COMBO_RESIZABLE
}
void GetNGraphDlg::replaceLabelSizeForSplitter()
{
	RECT rrLabel, rrSplitter;
	GetClientRect(m_ctrlLabel, rrLabel);
	Control cSplitter = GetItem(IDC_PARAMS_PREVIEW);
	GetClientRect(cSplitter, rrSplitter);
	
	rrSplitter.top = rrLabel.top + GetControlGap();
	MoveControl(cSplitter, rrSplitter);
}

BOOL	GetNGraphSplitter::OnInteractiveDataRange(Control ctrl)
{
	Window wnd = GetParent();
	return m_treeEditCntrl.DoInteractiveDlg(&wnd, TRUE, TRUE);
}

BOOL	GetNGraphSplitter::OnInteractiveXYDataRange(Control ctrl)
{
	Window wnd = GetParent();
	return m_treeEditCntrl.DoXYDataRangeDlg(&wnd, TRUE);
}

BOOL	GetNGraphSplitter::OnInteractivePopUp(Control ctrl)
{
	Window wnd = GetParent();
	RECT rectButton;
	ctrl.GetWindowRect(&rectButton);
	int nX = (rectButton.left + rectButton.right) / 2;
	int nY = (rectButton.top + rectButton.bottom) / 2;
	
	return m_treeEditCntrl.DoInteractivePopUp(&wnd, nX, nY);
}


/////////////////////////////////////////////////////////////////////
//////////////////           Splitter           /////////////////////
/////////////////////////////////////////////////////////////////////

///DG 6/21/05 QA70-7824 v8.0253 : bug
GetNGraphSplitter::GetNGraphSplitter() : TreeEditSplitter(s_bSplitterHorz, s_bTreeEditRightPane)
{
	m_bIsReady = false;
	
	m_bShowViewGraph = true;
	//m_bShowPreviewGraph = true;
}
void GetNGraphSplitter::InitTree(TreeNode& tr, PGRAPH_FUNC pfnView, PIMAGE_FUNC pfnImg, int nEventID, DWORD dwOptions)
{
	m_dwOptions = dwOptions;
	//m_trSplitter = tr;
	SetTree(tr, false);
	//----- CPY 12/26/05 GETNGRAPH_BOX_TYPE_4
	//m_pEventFunc = pfnEvent;
	m_nGetNDlgType = nEventID;
	//-----
	m_pGraphFunc = pfnView;
	m_pImageFunc = pfnImg;
}
void GetNGraphSplitter::SetTree(TreeNode& tr, bool bUpdateGUI)
{
	m_trSplitter = tr;
	if(bUpdateGUI)
	{
		m_treeEditCntrl.SetReady(false);
		m_treeEditCntrl.Update(m_trSplitter, true, true, true);
		m_treeEditCntrl.SetReady(true);
	}
}

//----- CPY 12/26/05 GETNGRAPH_BOX_TYPE_4
bool GetNGraphSplitter::IsImageMode()
{	
	return (XF_GETN_IMAGE==m_nGetNDlgType)? true:false;
}
//-----

void GetNGraphSplitter::GetTree(TreeNode& tr)
{
	tr = m_trSplitter;
}
void GetNGraphSplitter::CreatePreviewGraph(GraphControl& gcCntrl)
{
	createGraph(gcCntrl, m_gpPreview, "origin", "PreviewGraph");
}
bool GetNGraphSplitter::IsPreviewGraphUsed()
{
	//----- CPY 12/26/05 GETNGRAPH_BOX_TYPE_4
	//	return m_bShowPreviewGraph;
	return (XF_GETN_GRAPH_PREVIEW==m_nGetNDlgType)? true:false;
	//-----
}
BOOL GetNGraphSplitter::OnSelectionChange()
{
	return m_treeEditCntrl.OnSelectionChange();
}
BOOL GetNGraphSplitter::OnSelectionTrack()
{
	return m_treeEditCntrl.OnSelectionTrack();
}

BOOL GetNGraphSplitter::OnInitSplitter()
{
	m_bIsReady = false;
	
	CreateTreeEditPane();
	//------ CPY 9/12/05 GET_N_IMAGE_DIALOG
	/*
	GraphControl gcCntrl;
	CreateMainPane(gcCntrl);
	createGraph(gcCntrl, m_gpView, STR_VIEW_GRAPH_TEMPLATE, "ViewGraph");
	*/
	if(IsImageMode())
	{
		PictureControl picCntrl;
		CreateMainPane(picCntrl);
		m_pimgView = new MOImageControl(picCntrl);
	}
	else
	{
		GraphControl gcCntrl;
		CreateMainPane(gcCntrl);
		createGraph(gcCntrl, m_gpView, "GetNGraph", "CntrlGraph");
	}
	//------
	SetReady();
	initAllEvents();
	m_treeEditCntrl.SetReady(false);
	m_treeEditCntrl.Update(m_trSplitter, true, true, true);
	m_bIsReady = true;
	
	s_hdlg = GetSafeHwnd();
	return true;
}
BOOL GetNGraphSplitter::OnResize(int nType, int cx, int cy)
{
	if(!m_bIsReady)
		return true;
	
	TreeEditSplitter::OnResize(nType, cx, cy);
	if(!m_bShowViewGraph)
	{
		TreeEditSplitter::SetTreeEditPaneSize(100);
	}
	
	return true;
}
void GetNGraphSplitter::OnAfterValueChange(int nRow, int nCol)
{
	//--- CPY 9/22/05
	/*
	DWORD nEventInfo = 0; 	//can get from tree later
	int nCntrlType = -1;	//can be used later
	TreeNode trNode = m_treeEditCntrl.GetTreeNode(nRow, nCol);
	
	PEVENT_FUNC pEventfn = getEventHandler();
	if(pEventfn)
		pEventfn(m_trSplitter, nRow, 0, GetParent());
	
	PGRAPH_FUNC pViewfn = getGraphHandler();
	if(pViewfn)
	{
		pViewfn(m_trSplitter, nRow, nCol, trNode, nEventInfo | GETNEVENT_UPDATE_GRAPH, nCntrlType, *this, m_gpView.GetPage(), m_gpView.GetWorksheet());
		pViewfn(m_trSplitter, nRow, nCol, trNode, nEventInfo | GETNEVENT_UPDATE_PREVIEW, nCntrlType, *this, m_gpPreview.GetPage(), m_gpPreview.GetWorksheet());
	}
	//------ CPY 9/12/05 GET_N_IMAGE_DIALOG
	PIMAGE_FUNC pfnImg  = getImageHandler();
	if(pfnImg)
		pfnImg(m_trSplitter, nRow, nCol, trNode, nEventInfo | GETNEVENT_UPDATE_GRAPH, nCntrlType, *this, m_pimgView);
	//------	
	
	if(pEventfn || pViewfn || pfnImg)
	{
		m_treeEditCntrl.SetReady(false);
		m_treeEditCntrl.Update(m_trSplitter, true, false, false);
		m_treeEditCntrl.SetReady(true);
	}
	*/
	invokeHandlers(nRow, nCol, -1, 0);
}
void GetNGraphSplitter::OnChangeByGraph(DWORD wParam, DWORD lParam)
{
	//------ CPY 11/13/05 GETN_IMAGE_BOX_EVENTS_CLEAN
	/*
	TreeNode trjunk;
	PGRAPH_FUNC pViewfn = getGraphHandler();
	pViewfn(m_trSplitter, -1, -1, trjunk, GETNEVENT_UPDATE_GUI_TREE, -1, *this, m_gpView.GetPage(), m_gpView.GetWorksheet());
	pViewfn(m_trSplitter, -1, -1, trjunk, GETNEVENT_UPDATE_PREVIEW, -1, *this, m_gpPreview.GetPage(), m_gpPreview.GetWorksheet());
	
	m_treeEditCntrl.SetReady(false);
	m_treeEditCntrl.Update(m_trSplitter, true, false, false);
	m_treeEditCntrl.SetReady(true);
	*/
	invokeHandlers(-1, -1, -1, GETNEVENT_UPDATE_GUI_TREE);
	//------- end GETN_IMAGE_BOX_EVENTS_CLEAN
}
void GetNGraphSplitter::createGraph(GraphControl& gcCntrl, GraphPageControl& graphCtrl, LPCSTR lpcszTemplate, LPCSTR lpcszWksName)
{
	if(gcCntrl)
	{
		DWORD dwNoClicks = NOCLICK_DATA_PLOT | NOCLICK_TICKLABEL | NOCLICK_LAYER | NOCLICK_LAYERICON | NOCLICK_AXES;
		graphCtrl.Create(gcCntrl, dwNoClicks, lpcszTemplate, NULL, NULL, lpcszWksName);
		
		//graphCtrl.AddPlot(0, 1);	//init dataplot
	}
}
PEVENT_FUNC GetNGraphSplitter::getEventHandler()
{
	return m_pEventFunc;
}
PGRAPH_FUNC GetNGraphSplitter::getGraphHandler()
{
	return m_pGraphFunc;
}
void GetNGraphSplitter::initAllEvents()
{
	//--- CPY 9/22/05
	/*
	int nCntrlType = -1;	//can be used later
	PEVENT_FUNC pEventfn = getEventHandler();
	if(pEventfn)
		pEventfn(m_trSplitter, 0, nCntrlType, GetParent());
	
	PGRAPH_FUNC pGraphfn = getGraphHandler();
	TreeNode trjunk;
	if(pGraphfn)
	{
		m_bShowViewGraph = pGraphfn(m_trSplitter, -1, -1, trjunk, GETNEVENT_ON_INIT | GETNEVENT_UPDATE_GRAPH, nCntrlType, *this, m_gpView.GetPage(), m_gpView.GetWorksheet());
		m_bShowPreviewGraph = pGraphfn(m_trSplitter, -1, -1, trjunk, GETNEVENT_ON_INIT | GETNEVENT_UPDATE_PREVIEW, nCntrlType, *this, m_gpPreview.GetPage(), m_gpPreview.GetWorksheet());
	}
	//------ CPY 9/12/05 GET_N_IMAGE_DIALOG
	PIMAGE_FUNC pfnImg  = getImageHandler();
	if(pfnImg)
		pfnImg(m_trSplitter, -1, -1, trjunk, GETNEVENT_ON_INIT | GETNEVENT_UPDATE_GRAPH, nCntrlType, *this, m_pimgView);
	//------	
	*/
	invokeHandlers(-1, -1, -1, GETNEVENT_ON_INIT);
}

//------ CPY 9/12/05 GET_N_IMAGE_DIALOG
void GetNGraphSplitter::invokeHandlers(int nRow, int nCol, int nCntrlType, DWORD nEventInfo)
{
	TreeNode trNode;
	if(nRow >= 0 && nCol >= 0)
		trNode = m_treeEditCntrl.GetTreeNode(nRow, nCol);

	int nUpdate = 0;
	PEVENT_FUNC pEventfn = getEventHandler();
	if(pEventfn)
	{
		/// TD 8-3-06 QA70-8843 DOWNCAST_BUG
		Dialog dlg;
		dlg = GetParent();
		/// end DOWNCAST_BUG
		nUpdate = pEventfn(m_trSplitter, nRow, 0, dlg)? 1:0;
	}
	
	PGRAPH_FUNC pViewfn = getGraphHandler();
	if(pViewfn)
	{
		int nRet = pViewfn(m_trSplitter, nRow, nCol, trNode, nEventInfo, nCntrlType, *this, m_gpView.GetPage(), m_gpView.GetWorksheet()); // grid event
		if(nRet & GETNGEVT_GRID_NEED_UPDATE)
			nUpdate += 1;
		if((nRet & GETNGEVT_GRAPH_NEED_UPDATE) || (GETNEVENT_ON_INIT & nEventInfo) || (GETNEVENT_UPDATE_GUI_TREE & nEventInfo))
		{
			if(!(GETNEVENT_UPDATE_GUI_TREE & nEventInfo))
			{
				pViewfn(m_trSplitter, nRow, nCol, trNode, nEventInfo | GETNEVENT_UPDATE_GRAPH, nCntrlType, *this, m_gpView.GetPage(), m_gpView.GetWorksheet());
			
				if(IsPreviewGraphUsed())
					pViewfn(m_trSplitter, nRow, nCol, trNode, nEventInfo | GETNEVENT_UPDATE_PREVIEW, nCntrlType, *this, m_gpPreview.GetPage(), m_gpPreview.GetWorksheet());
			}
		}
	}
	PIMAGE_FUNC pfnImg  = getImageHandler();
	if(pfnImg)
	{
		if(pfnImg(m_trSplitter, nRow, nCol, trNode, nEventInfo | GETNEVENT_UPDATE_GRAPH, nCntrlType, *this, m_pimgView))
			nUpdate++;
	}	
	if(nUpdate)
	{
		m_treeEditCntrl.SetReady(false);
		m_treeEditCntrl.Update(m_trSplitter, true, false, false);
		m_treeEditCntrl.SetReady(true);
	}
}

BOOL GetNGraphSplitter::OnTrackSlider(WPARAM wParam, LPARAM lParam)
{
	int nPos = wParam;
	double* pVal = (double*) lParam;
	if(pVal)
	{
		int nEditRow = m_treeEditCntrl.GetEditRow();
		TreeNode trEdit = m_treeEditCntrl.GetEditNode();
		//printf("%d) Slider %d and %g, tree val = %g\n", nEditRow, nPos, *pVal, trEdit.dVal);
		trEdit.dVal = *pVal;
		invokeHandlers(nEditRow, 1, trEdit.ID, 0);
	}	
	return true;
}
//------ end GET_N_IMAGE_DIALOG


