/*------------------------------------------------------------------------------*
 * File Name: FitINIFile.h														*
 * Creation: Sim 04-02-2008														*
 * Purpose: Origin C Header Files												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef __FIT_INI_H__
#define __FIT_INI_H__

#include <settings.h>

/*
trINI ( this tagName inessential)
|-Fit
|-Baseline
	|-Function.strVal
	|-Values.dVals
|-Parameters
    |-Functions.strVals
    |-Share.nVals
    |-Fixed.nVals
    |-LowerBounds.dVals
    |-LowerBoundsExclusive.nVals
    |-LowerBoundsEnable.nVals
    |-UpperBounds.dVals
    |-UpperBoundsExclusive.nVals
    |-UpperBoundsEnable.nVals 
    |-Values.dVals
    |-SignificantDigit.nVals
*/    
class FitINIFile : public INIFile // should derived as protected, but OC can't support
{
public:
	FitINIFile(LPCSTR lpcszFilename = NULL, BOOL bUseIniPath = TRUE);
public:
	//bool Save(const TreeNode& trINI);
	bool Load(TreeNode& trINI);
protected:
	bool Load75(TreeNode& trINI);
	bool IsFrom75File();
	
	bool TreeToVector(const TreeNode& trINI);
	bool VectorToTree(TreeNode& trINI);
	
	int GetItemNums(const StringArray& saItems, LPCSTR lpcszItemPrefix);
	void ResetVector();
	
protected:
	string			m_strBFunction;
	vector<int>		m_vnBPValues;
	
	vector<string>	m_vsFunctions;
	vector<int>		m_vnShare;
	vector<int>		m_vnFixed;
	vector<double>	m_vdLowerBounds;
	vector<int>		m_vnLowerBoundsExclusive;
	vector<int>		m_vnLowerBoundsEnable;
	vector<double>	m_vdUpperBounds;
	vector<int>		m_vnUpperBoundsExclusive;
	vector<int>		m_vnUpperBoundsEnable;
	vector<double>	m_vdValues;
	vector<int>		m_vnSignificantDigit;
};

#endif		//__FIT_INI_H__
