/*------------------------------------------------------------------------------*
 * File Name: FitFuncWiz.c	 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Folger 06/28/10 ORG-423 EDIT_FIT_FUNC_USING_WIZARD							*
 *	Folger 07/12/10 ORG-423-P1 OPEN_FO_IF_EDIT_BUILTIN_FUNCTION_FROM_LABTALK	*
 *	Folger 09/06/2010 ORG-958-P5 FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
 *	Folger 09/26/2010 ORG-1139-S1 PROMPT_FOR_USER_WHEN_CANCEL_WIZARD			*
 *	Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
 *	Tony 08/28/2012 ORG-3079-S1 SET_BIT_TO_DISABLE_CATEGORY					*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
//put additional include files here
#ifdef _FOR_SMART_LOADING_ONLY
#include <event_utils.h>
#include <..\OriginLab\nlsf_utils.h>
#include <..\OriginLab\NLFitSelFunction.h>
#include <..\OriginLab\NumFunctionOrganizer.h>
#include <..\OriginLab\FFWFunctionOrganizer.h>
#endif//_FOR_SMART_LOADING_ONLY
#include "FFWFunctionOrganizer.h"
#include "FitFuncWiz.h"

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
//bool OpenFitFuncWizDlg(TreeNode& trFuntion, HWND hParent = NULL)
///------ Folger 09/06/2010 ORG-958-P5 FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
//bool OpenFitFuncWizDlg(TreeNode& trFuntion, HWND hParent = NULL, int nMode = FFW_MODE_AUTO)
/************************* Important !!! ***************************/
/// If change prototype, please update FUNC_OPEN_FFW in common.h
/************************* Important !!! ***************************/
///------ Tony 08/28/2012 ORG-3079-S1 SET_BIT_TO_DISABLE_CATEGORY
// /// Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
//bool OpenFitFuncWizDlg(TreeNode& trFuntion, HWND hParent = NULL, int nMode = FFW_MODE_AUTO, NumFunctionOrganizer* pNFO = NULL)

//bool OpenFitFuncWizDlg(TreeNode& trFuntion, HWND hParent = NULL, int nMode = FFW_MODE_AUTO, NumFunctionOrganizer* pNFO = NULL, bool bIwNewCategory = false, LPCSTR lpcszCategory = NULL)
bool OpenFitFuncWizDlg(TreeNode& trFuntion, HWND hParent = NULL, int nMode = FFW_MODE_AUTO, NumFunctionOrganizer* pNFO = NULL, bool bIwNewCategory = false, LPCSTR lpcszCategory = NULL, DWORD dwCntrl = 0)
// /// END OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
///------ End SET_BIT_TO_DISABLE_CATEGORY
///------ End FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
///end SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
{
	///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	//FitFuncWizDlg myDlg;
	///------ Folger 09/06/2010 ORG-958-P5 FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
	//FitFuncWizDlg myDlg(nMode);
	///------ Folger 09/26/2010 ORG-1139-S1 PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
	//FitFuncWizDlg myDlg(nMode, pNFO);       
	DWORD	dwResults = 0;
	
	///------ Tony 08/28/2012 ORG-3079-S1 SET_BIT_TO_DISABLE_CATEGORY
	// /// Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
	//FitFuncWizDlg myDlg(nMode, pNFO, &dwResults);
	//FitFuncWizDlg myDlg(nMode, pNFO, &dwResults, bIwNewCategory, lpcszCategory);
	FitFuncWizDlg myDlg(nMode, pNFO, &dwResults, bIwNewCategory, lpcszCategory, dwCntrl);
	// /// END OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
	///------ End SET_BIT_TO_DISABLE_CATEGORY
	
	///------ End PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
	///------ End FAIED_TO_SAVE_FDF_NAME_NEW_FUNCION_IN_FFW_OPEN_FROM_FO
	///end SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
	if(NULL == hParent)
		hParent = GetWindow();

	int nRet = myDlg.DoModalEx(hParent, trFuntion);
	///------ Folger 09/26/2010 ORG-1139-S1 PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
	//if(IDCANCEL != nRet)
	if ( O_QUERY_BOOL(dwResults, FFWRESULTS_ONFINISH) )
	///------ End PROMPT_FOR_USER_WHEN_CANCEL_WIZARD
	{
		TreeNode trChange;
		myDlg.GetFunction(trChange);
		trFuntion.Replace(trChange, TRUE, FALSE, FALSE);		
		return true;
	}
	
	return false;
}

///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
bool OpenFFWDlgWithGoalPage(TreeNode& trFunction, HWND hParent = NULL)
{
	int nMode = FFW_CREATE_OR_EDIT | FFW_OPT_CREATE_NEW;
	return OpenFitFuncWizDlg(trFunction, hParent, nMode);
}
///end SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE

///------ Folger 06/28/10 ORG-423 EDIT_FIT_FUNC_USING_WIZARD
int		FitFuncWiz(int nMsg, DWORD dwCntrl = 0, LPVOID lpData = NULL)
{
	switch ( nMsg )
	{
	case FFWMSG_CHECKOPEN:
		{
			LPCSTR	lpcszName = (LPCSTR)lpData;
			///Sophy 7/15/2010 ORG-545 CENTRALIZE_CODE_FOR_LOADING_FDF_TREE_FROM_FUNCTIONNAME
			/*
			string	strCategory, strFDF;
			if ( !nlf_get_fdf_filename(lpcszName, &strCategory, NULL, &strFDF) )
				return 1;
			
			Tree	trFDF;
			if ( !nlsf_load_FDF_to_tree(strFDF, &trFDF, FDFT_CONVERT_BOOL_TO_01, true) )
				return 1;

			trFDF.SetAttribute(STR_FILENAME_ATTRIB, strFDF);
			int		nLocation = -1;
			if ( !nlf_find_category(lpcszName, strCategory, nLocation) )
				return 1;

			///------ Folger 07/12/10 ORG-423-P1 OPEN_FO_IF_EDIT_BUILTIN_FUNCTION_FROM_LABTALK
			bool	bBuiltin = false;
			nlf_is_built_in_func(trFDF, bBuiltin);
			if ( !bBuiltin )
			{
				trFDF.SetAttribute(STR_CATEGORY_ATTRIB, strCategory);	///Sophy 7/15/2010 ORG-545-P8 PROPER_INIT_CATEGORY_WHEN_OPEN_FROM_EDIT_COMMAND
				OpenFitFuncWizDlg(trFDF, NULL);
			}
			else
			{
				FUNC_STR_DWORD_HWND_TREENODE	pfn = Project.FindFunction("OpenFO", "OriginLab\\FunctionOrganizerDlg.cpp", TRUE);
				if ( pfn )
				{
					string	str = lpcszName;
					pfn(strCategory + "|" + str, 0, NULL, trFDF);
				}
			}
			///------ End OPEN_FO_IF_EDIT_BUILTIN_FUNCTION_FROM_LABTALK
			*/
			Tree trFDF;
			string strCategory;
			int nType = nlsf_load_FDF_to_tree(trFDF, lpcszName, &strCategory);
			if ( nType <= FDFTYPE_UNKNOWN )
				return 1;

			BOOL	bOpenFO = nType == FDFTYPE_BUILTIN;
			if ( !bOpenFO )
			{
				string	strFDF;
				trFDF.GetAttribute(STR_FILENAME_ATTRIB, strFDF);
				if ( ORIGIN_PATH_GROUP == okutil_get_origin_path_type(strFDF) )
					bOpenFO = TRUE;
			}
			if ( bOpenFO )
			{
				FUNC_STR_DWORD_HWND_TREENODE	pfn = Project.FindFunction("OpenFO", "OriginLab\\FunctionOrganizerDlg.cpp", TRUE);
				if ( pfn )
				{
					string	str = lpcszName;
					pfn(strCategory + "|" + str, 0, NULL, trFDF);
				}
			}
			else
			{
				OpenFitFuncWizDlg(trFDF, NULL);
			}
			///end CENTRALIZE_CODE_FOR_LOADING_FDF_TREE_FROM_FUNCTIONNAME
			return 0;
		}
		break;

	case FFWMSG_NEWOPEN:
		{
			Tree	trDummy;
			///Sophy 7/13/2010 ORG-545-P1 SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
			//OpenFitFuncWizDlg(trDummy, NULL);
			OpenFFWDlgWithGoalPage(trDummy, NULL);
			///end SUPPORT_CREATE_OR_EDIT_ON_GOAL_PAGE
			return 0;
		}
		
	default:
		ASSERT(FALSE);
		break;
	}
	
	return 1;
}
///------ End EDIT_FIT_FUNC_USING_WIZARD
