/*------------------------------------------------------------------------------*
 * File Name: FilterManager.h													*
 * Creation: Sim 06-28-2007														*
 * Purpose: Origin C header														*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sim 09-11-2007 IMPROVE_APPLY_BUTTON_ENABLE									*
 * 	Hong 09/11/07 v8.0700 ADD_FILTER_FILE_EXTENSIONS							*
 *	Folger 11/02/07 SET_FILTER_MANAGER_INITIAL_SIZE								*
 *	Folger 11/14/07 MAP_DIALOG_CHM_HELP											*
 *	Hong 12/12/07 v8.0767 IMPROVE_EDIT_BTN_ENABLE								*
 *	Sim 12-28-2010 ORG-1832 SUPPORT_DRAG_AND_DROP_DAT_EXTENSION_EXCLUSION_FOR_PCLAMP_MDF_ETC
 *	Bill 09/13/2011 ORG-3359-S5 TO_OPEN_IMPORT_CUSTOMIZE_MENU_DLG				*
 *------------------------------------------------------------------------------*/
 
#ifndef _FILTER_MANAGER_
#define _FILTER_MANAGER_


class FilterListControl : public GridListControl
{
public:
	void Init(int nID, Dialog& dlg)
	{	
		
		GridListControl::Init(nID, dlg);
		ClearAll();
		SetAlternateRowColors();
		
		m_flx.ExtendLastCol = true;
		m_flx.SelectionMode = flexSelectionListBox;
		m_flx.AllowUserResizing = flexResizeColumns;
		m_flx.AutoSizeMode = flexAutoSizeColWidth;
		m_flx.Editable = flexEDKbd;
		
		// allow sorting
		m_flx.ExplorerBar = flexExSortShow;
	}
};

class FilterManagerDlg : public ResizeDialog
{
public:
	FilterManagerDlg() : ResizeDialog(IDD_FILTER_MANAGER_DLG, "ODlg8")
	{
	}
	~FilterManagerDlg()
	{
	}
	int  DoModalEx(HWND hParent = NULL);
	virtual int  Create(HWND hParent = NULL);
	
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_SIZE(OnDlgResize)
	ON_RESTORESIZE(OnRestoreSize)		//------ Folger 11/02/07 SET_FILTER_MANAGER_INITIAL_SIZE
	ON_CANCEL(OnCancel)
	ON_BN_CLICKED(IDC_FILTER_EDIT, OnEdit)
	ON_BN_CLICKED(IDC_APPLY, OnApply)
	ON_GRID_BEFORE_EDIT(IDC_FILTER_LIST, OnBeforeEditParaControl) ///---Sim 12-28-2010 ORG-1832 SUPPORT_DRAG_AND_DROP_DAT_EXTENSION_EXCLUSION_FOR_PCLAMP_MDF_ETC
	ON_GRID_AFTER_EDIT(IDC_FILTER_LIST, OnAfterEditParaControl) ///---Sim 09-11-2007 IMPROVE_APPLY_BUTTON_ENABLE
	ON_GRID_SEL_CHANGE(IDC_FILTER_LIST, OnSelChange) /// Hong 12/12/07 v8.0767 IMPROVE_EDIT_BTN_ENABLE
	//ON_HELPINFO(OnHelp)			//------ Folger 11/14/07 MAP_DIALOG_CHM_HELP
	ON_BN_CLICKED(IDC_OPEN_CUSTOMIZE_MENU_DLG, OnOpenCustomizeMenuDlg) /// Bill 09/13/2011 ORG-3359-S5 TO_OPEN_IMPORT_CUSTOMIZE_MENU_DLG
EVENTS_END

	BOOL OnInitDialog();
	BOOL OnDlgResize(int nType, int cx, int cy);
	BOOL OnRestoreSize(ODWP dwSizeInfo);		//------ Folger 11/02/07 SET_FILTER_MANAGER_INITIAL_SIZE
	BOOL OnCancel();
	
	BOOL OnEdit(Control cntrl);
	BOOL OnApply(Control cntrl);
	void OnBeforeEditParaControl(Control flxControl, long nRow, long nCol, BOOL* pCancel); ///---Sim 12-28-2010 ORG-1832 SUPPORT_DRAG_AND_DROP_DAT_EXTENSION_EXCLUSION_FOR_PCLAMP_MDF_ETC
	void OnAfterEditParaControl(Control flxControl, int nRow, int nCol); ///---Sim 09-11-2007 IMPROVE_APPLY_BUTTON_ENABLE
	
	void OnSelChange(Control control); /// Hong 12/12/07 v8.0767 IMPROVE_EDIT_BTN_ENABLE
	//BOOL OnHelp(int &nHelpID, int nIdCtrlFocus);		//------ Folger 11/14/07 MAP_DIALOG_CHM_HELP

	BOOL OnOpenCustomizeMenuDlg(Control ctrl); /// Bill 09/13/2011 ORG-3359-S5 TO_OPEN_IMPORT_CUSTOMIZE_MENU_DLG
	
private:
	void initList();
	/// Hong 09/11/07 v8.0700 ADD_FILTER_FILE_EXTENSIONS
	//int constructFilterList(vector<string>& vsFilter, vector<int>& viLocalization, vector<bool>& vbSupportDragDrop);
	///---Sim 12-28-2010 ORG-1832 SUPPORT_DRAG_AND_DROP_DAT_EXTENSION_EXCLUSION_FOR_PCLAMP_MDF_ETC
	//int constructFilterList(vector<string>& vsFilter, vector<int>& viLocalization, vector<bool>& vbSupportDragDrop, vector<string>& vsFileExts);
	int constructFilterList(vector<string>& vsFilter, vector<int>& viLocalization, vector<bool>& vbSupportDragDrop, vector<string>& vsFileExts, vector<string>& vsFileExtExclusions);
	///---END ORG-1832 SUPPORT_DRAG_AND_DROP_DAT_EXTENSION_EXCLUSION_FOR_PCLAMP_MDF_ETC
	/// end ADD_FILTER_FILE_EXTENSIONS

	void initButtonState();	///-----Kit 10/26/2011 ORG-4157-P2 DISABLE_CUSTOMIZE_MENU_BTN_IN_FILTER_MNGR_WHEN_ACTIVE_LAYER_NOT_WKS

	void enableButton(uint nBtnID, bool bEnable); ///---Sim 09-11-2007 IMPROVE_APPLY_BUTTON_ENABLE
	
	
private:	
	FilterListControl m_list;
	//vector<string> m_vsFilter;
	//vector<int>	m_vLocalization;
	//vector<bool> m_vbSupportDragDrop;
};

#endif //_FILTER_MANAGER_

