/*------------------------------------------------------------------------------*
 * File Name: FactorialANOVA.h													*				 										
 * Creation:																	*
 * Purpose:																		*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
#define STR_FACTOR_SEPERATOR		"*"
#define STR_STAT_OVERALL_E			_LE("Overall")
#define STR_NONE_ITEM				_L("None")//if use <none>, resplotx will be invalid object
#define STR_PREDICTED_Y				_L("Predicted Y")

/*------------------------------------------*
*	Data:									*
*-------------------------------------------*
	
Nitrogen	Sulphate	Location	Yield
	1			1			1		259
	1			1			1		645
	1			1			2		614
	1			1			2		470
	1			1			3		355
	1			1			3		570
	1			2			1		609
	1			2			1		837
	1			2			2		601
	1			2			2		707
	1			2			3		627
	1			2			3		470
	1			3			1		608
	1			3			1		590
	1			3			2		369
	1			3			2		499
	1			3			3		523
	1			3			3		540
	1			4			1		408
	1			4			1		321
	1			4			2		311
	1			4			2		457
	1			4			3		459
	1			4			3		483
	2			1			1		403
	2			1			1		308
	2			1			2		351
	2			1			2		469
	2			1			3		425
	2			1			3		262
	2			2			1		272
	2			2			1		421
	2			2			2		585
	2			2			2		455
	2			2			3		427
	2			2			3		305
	2			3			1		361
	2			3			1		586
	2			3			2		416
	2			3			2		357
	2			3			3		590
	2			3			3		490
	2			4			1		527
	2			4			1		321
	2			4			2		259
	2			4			2		263
	2			4			3		304
	2			4			3		295
*/
class UnstackInfo;

class FactorialANOVAReport
{
private:
	Array<UnstackInfo&> m_arrUnstackInfo;
	vector<string>		m_vsFactorNames;	
	
public:
	FactorialANOVAReport();
	
	bool SortCheckData(const Range& factors, const Range& irng, const vector<string>& vsFactors, Worksheet& wksSort);
						
	void OutputSortData(const Worksheet& wksSort, int nFactors,
						vector<int>& vnFactorColumnIDs, vector<int>& vnDataColumnIDs, ReportTable& rtOutput, int& id);
	
	bool OutputReport(	const Range& factors, const Range& irng, 
						int nfac, int nBlock, int mterm, double *table,
						double *tmean, int *imean,
						const TreeNode& trStats, const TreeNode& trEffect, double dSigLevel,
						int tukey, int bonf, int dunnsidak, int lsd, int scheffe, int holmbonf, int holmsidak,
						bool actpower, bool hypotpower, double siglevel, LPCSTR lpczhypotsize,
						ReportTree& rtSheet);	
						
	bool OutputMeansData(	const Range& irng, const vector& vMean,  
							LPCSTR lpczEffect, LPCSTR xfactor, LPCSTR dpfactor, LPCSTR lfactor,
							//plot
							vector<string>& vsNames, ReportTree& rt,  
							ReportData& rd, int& id);

	int FacANOVAPower(	int iInteractions,
						 double siglevel, int nfac,
						 double *vSampleSizes, int iSize,
						 double *table, int mterm,
						 double *vSSPOW, 
						 int iSource);
						 
private:
	void addDescriptiveStatistics(const Range& factors, const Range& irng, const TreeNode& trEffect, ReportTree& rtANOVA, int& ID);
	
	void addOverallAnova(int nBlock, int mterm, double *table, const TreeNode& trEffect, ReportTree& rtANOVA, int& ID);
	
	void addMeansComparisons(	const Range& factors, const Range& irng,
								int mterm, double *table,
								double *tmean, int *imean, 
								const TreeNode& trEffect, double dSigLevel, const vector<int>& vnMeansComparisonTypes,
								ReportTree& rtANOVA, int& ID);
	
	void getMeansComparisonsLabel(int nMeansComparision, string& strNode, string& strLabel, vector<string>& vsTagNames, vector<string>& vsLabels);
	
	void addOneMeansComparisonTables(	const Range& irng,
										int mterm, double *tmean, int *imean, double dMSE, int nDOF, 
										int iTestType, LPCSTR lpcszTypeName, LPCSTR lpcszTypeLabel, 
										const vector<string>& vsColLabels, const vector<string>& vsColTagNames,
										double dSigLevel, const TreeNode& trEffect,
										ReportTable& rtMeansComparisons, int& ID);
											
	bool countGroupSize(const Range& irng, LPCSTR lpczFactor, 
						vector<string>& vsFactorNames, vector<string>& vsFactorValues = NULL, vector<int>& vnGroupSize = NULL);
						
	int getFactorColIndex(const Worksheet& wks, LPCSTR lpczName, Column& colFactor = NULL);
	
	bool addFactorNumberTable(LPCSTR lpczFactor, ReportTable& rtMeansComparisons, int& ID);
	
	void addMeansComparisonTable(	int nEffect,
									int mterm, double *tmean, int *imean, double dMSE, int nDOF, 
									const vector<int>& vNpts,
									int iTestType, const vector<string>& vsColLabels, const vector<string>& vsColTagNames,
									double dSigLevel,
									ReportTable& rtMeansComparisons, int& ID);
									
	void sortByPlotFactors(const vector<string>& vsFactors, LPCSTR xfactor, LPCSTR dpfactor, LPCSTR lfactor, Worksheet& wks);
							
	int addPowerReport(	const Range& factors, int nfac, double *table, int mterm,
						bool actpower, bool hypotpower, double siglevel, LPCSTR lpczhypotsize,  
						const TreeNode& trEffect, ReportTree& rtANOVA, int& ID);

	double calANOVAPower( double dFval, double ddf1, double ddf2, double dnc);
};

bool FactorialANOVAReport::OutputReport(//data range and factor range	
										const Range& factors, const Range& irng, 
										//factorial result
										int nfac, int nBlock, int mterm, double *table, double *tmean, int *imean,
										const TreeNode& trStats, //Descriptive Statistics
										//means comparison settings
										const TreeNode& trEffect, double dSigLevel,
										int tukey, int bonf, int dunnsidak, int lsd, int scheffe, int holmbonf, int holmsidak,
										//power settings
										bool actpower, bool hypotpower, double siglevel, LPCSTR lpczhypotsize,
										//report tree
										ReportTree& rtSheet)
{
	int ID = IDST_ANOVAS;
	
	addDescriptiveStatistics(factors, irng, trStats, rtSheet, ID);
	
	
	addOverallAnova(nBlock, mterm, table, trEffect, rtSheet, ID);
	
	
	vector<int> vnMeansComparisonTypes;
	if(tukey)
		vnMeansComparisonTypes.Add(ANOVA_TUKEY);
	if(bonf)
		vnMeansComparisonTypes.Add(ANOVA_BONFERRON);
	if(dunnsidak)
		vnMeansComparisonTypes.Add(ANOVA_SIDAK);
	if(lsd)
		vnMeansComparisonTypes.Add(ANOVA_FISHER);
	if(scheffe)
		vnMeansComparisonTypes.Add(ANOVA_SCHEFFE);
	if(holmbonf)
		vnMeansComparisonTypes.Add(ANOVA_BONHOLM);
	if(holmsidak)
		vnMeansComparisonTypes.Add(ANOVA_SIDAKHOLM);	
	addMeansComparisons(factors, irng,
						mterm, table,
						tmean, imean, 
						trEffect, dSigLevel, vnMeansComparisonTypes,
						rtSheet, ID);
						
	//power settings
	if(actpower || hypotpower)
		addPowerReport(factors, nfac, table, mterm, actpower, hypotpower, siglevel, lpczhypotsize, trEffect, rtSheet, ID);
	
	return true;
}

void FactorialANOVAReport::sortByPlotFactors(const vector<string>& vsFactors, LPCSTR xfactor, LPCSTR dpfactor, LPCSTR lfactor, Worksheet& wks)
{	
	vector<string> vsPlotFactore(3);
	vsPlotFactore[0] = lfactor;
	vsPlotFactore[1] = dpfactor;
	vsPlotFactore[2] = xfactor;
	
	vector<int> vSortByCols;
	for(int ii = 0; ii < vsPlotFactore.GetSize(); ii++)
	{
		int nFind = vsFactors.Find( vsPlotFactore[ii] );
		if(nFind >= 0)
			vSortByCols.Add(nFind);
	}
		
	vector<BOOL> vOrder;
	vOrder.SetSize(vSortByCols.GetSize());
	vOrder = SORT_ASCENDING;
	wks.Sort(vSortByCols, vOrder);
}

void FactorialANOVAReport::addDescriptiveStatistics(const Range& factors, const Range& irng, const TreeNode& trEffect,
													ReportTree& rtANOVA, int& ID)
{
	bool bNoEffect = true;
	foreach(TreeNode tn in trEffect.Children)
	{
		if(tn.nVal)
		{
			bNoEffect = false;
			break;
		}
	}
	if(bNoEffect)
		return;	
	
	Worksheet 		wksData;
	vector<uint> 	vnIndices;
	if( !_get_wks_and_col_selection(irng, wksData, vnIndices) )
		return;
	
	int ii = 0;
	int nStatItems = 6;
	vector<string> vsLabels(nStatItems);
	vsLabels[ii++] = "N";
	vsLabels[ii++] = "Missing";
	vsLabels[ii++] = "Mean";
	vsLabels[ii++] = "SD";
	vsLabels[ii++] = "SEM";
	vsLabels[ii++] = "Variance";
	
	ReportTable rtDescpStats = rtANOVA.CreateTable("DescriptiveStatistics", _L("Descriptive Statistics"), ID++);
	collapse_report_tree_branch(rtDescpStats);	
	
	int nIndex = -1;
	foreach(TreeNode trOneEffect in trEffect.Children)
	{
		nIndex++;		
		if(!trOneEffect.nVal)
			continue;
		
		UnstackInfo *pInfo;
			
		string strFactors;
		trOneEffect.GetAttribute(STR_LABEL_ATTRIB, strFactors);
		vector<string> vsFactors;
		int nFactors = str_separate(strFactors, STR_FACTOR_SEPERATOR, vsFactors);
		
		ReportTable rtOneDescpStats = rtDescpStats.CreateTable("Stats"+(string)nIndex, strFactors, ID++);
	
		DataRange drTemp;
		irng.Clone(drTemp);		
		if( !compare_string_localization(strFactors, STR_STAT_OVERALL_E) )
		{		
			pInfo = new UnstackInfo;
			pInfo->vsFactorNames 	= vsFactors;
		
			for(int nn = 0; nn < nFactors; nn++)
			{
				int nCol = getFactorColIndex(wksData, vsFactors[nn]);
				ASSERT(nCol > -1);
				drTemp.Add(wksData, nCol, "F", nCol);
			}
		}
		
		DWORD dwRules = DRR_GET_MISSING|DRR_BAD_WEIGHT_TREATMENT;
		int nNumData = drTemp.GetNumData(dwRules);
		for(int nn = 0; nn < nNumData; nn++)
		{
			vector 			vData;
			vector<string> 	vsFactorValues;			
			DWORD uidAux = 0;
			int nMainCol = drTemp.GetData(dwRules, nn, &uidAux, NULL, &vData, NULL, NULL, &vsFactorValues);
			if(nMainCol < 0)
			{
				ASSERT(0);
				continue;
			}
			int nDataSize = vData.GetSize();
			
			if(pInfo)
			{				
				pInfo->vsFactorValues.Append(vsFactorValues);
				pInfo->vnDataNum.Add(nDataSize); 
			}
		
			vector vStatResults(nStatItems);
			int nN, nMissing;
			double dMean, dSD, dSE, dVar;
			int nRet = ocmath_basic_summary_stats(nDataSize, vData, &nN, &dMean, &dSD, &dSE, &dVar, NULL, NULL, NULL, NULL, NULL, NULL, NULL, &nMissing);
			if ( STATS_NO_ERROR != nRet)	
			{
				ASSERT(0);
				continue;
			}
			ii = 0;
			vStatResults[ii++] = nN;
			vStatResults[ii++] = nMissing;
			vStatResults[ii++] = dMean;			
			vStatResults[ii++] = dSD;
			vStatResults[ii++] = dSE;
			vStatResults[ii++] = dVar;
			
			string strDataColName = get_column_name( wksData.Columns(nMainCol) );
			TreeNode trRow = rtOneDescpStats.AddRow("Row"+(string)nn, vStatResults, strDataColName, vsLabels, NULL, ID++);
			tree_add_more_labels(trRow, vsFactorValues);
		}
		
		if(pInfo)
		{
			if(m_vsFactorNames.Find(strFactors) >= 0)
			{
				delete pInfo;
				return;
			}
			
			m_arrUnstackInfo.Add(*pInfo);
			m_vsFactorNames.Add(strFactors);
		}
	}
}

#define TABLE(I,J)	table[(I)*5 + (J)]
void FactorialANOVAReport::addOverallAnova(int nBlock, int mterm, double *table, const TreeNode& trEffect, ReportTree& rtANOVA, int& ID)
{
	ReportTable rtOverallANOVA = rtANOVA.CreateTable("OverallANOVA", _L("Overall ANOVA"), ID++);
		
	int nSize = 5;
	vector<string> vsLabels(nSize);
	int ii = 0;
	vsLabels[ii++] = _L("DF");
	vsLabels[ii++] = _L("Sum of Squares");
	vsLabels[ii++] = _L("Mean Square");
	vsLabels[ii++] = _L("F Value");
	vsLabels[ii++] = _L("P Value");	
	
	int nRow = 0;
	
	//block
	//int nBlockRow = 0;
	if (nBlock > 1)
	{		
		vector vec(nSize);
		for(int ii = 0; ii < nSize; ii++)
			vec[ii] = TABLE(0, ii);
	
		rtOverallANOVA.AddRow("Row"+(nRow+1), vec, "Blocks", vsLabels, NULL, ID++);
		nRow++;
		//nBlockRow = 1;
	}
	
	//treatment
	int ntreat = mterm - 3;//block, residual and total
	TreeNode trOneEffect = trEffect.FirstNode;
	for(int nn = 0; nn < ntreat; nn++)
	{
		vector vec(nSize);
		for(int ii = 0; ii < nSize; ii++)
			vec[ii] = TABLE(nn + 1, ii);//1 : block
		
		string strFactors;
		trOneEffect.GetAttribute(STR_LABEL_ATTRIB, strFactors);
		
		rtOverallANOVA.AddRow("Row"+(nRow+1), vec, strFactors, vsLabels, NULL, ID++);
		
		nRow++;
		trOneEffect = trOneEffect.NextNode;
	}
	
	//residual
	{
		nSize = 3;//no F Value or P Value
		vector vec(nSize);
		for(int ii = 0; ii < nSize; ii++)
			vec[ii] = TABLE(mterm-2, ii);
		
		rtOverallANOVA.AddRow("Row"+(nRow+1), vec, "Error", vsLabels, NULL, ID++);
		nRow++;
	}
	
	//total
	{
		nSize = 2;//only DF and Sum of Squares
		vector vec(nSize);
		for(int ii = 0; ii < nSize; ii++)
			vec[ii] = TABLE(mterm-1, ii);
		
		rtOverallANOVA.AddRow("Row"+(nRow+1), vec, "Corrected Total", vsLabels, NULL, ID++);
		nRow++;
	}
}

void FactorialANOVAReport::addMeansComparisons(	//data range and factor range
												const Range& factors, const Range& irng,
												//factorial anova result
												int mterm, double *table,
												double *tmean, int *imean, 
												//settings
												const TreeNode& trEffect, double dSigLevel, const vector<int>& vnMeansComparisonTypes,
												//reprot tree
												ReportTree& rtANOVA, int& ID)
{	
	int nTypeNum = vnMeansComparisonTypes.GetSize();

	//check if no effect or no method selected
	if(nTypeNum <= 0)
		return;
	
	bool bNoEffect = true;
	foreach(TreeNode tn in trEffect.Children)
	{
		if(tn.nVal)
		{
			bNoEffect = false;
			break;
		}
	}
	if(bNoEffect)
		return;	
		
	//for(int nnn = 0; nnn < mterm; nnn++)//test
		//out_int("", imean[nnn]);
	
	//mterm - 2: residual sum of squares\error
	int 	nDOF = (int)TABLE(mterm - 2, 0);
	double 	dMSE = TABLE(mterm - 2, 2);
	
	//means comparision type
	ReportTable rtMeansComparisons = rtANOVA.CreateTable("MeansComparisons", _L("Means Comparisons"), ID++);		
	collapse_report_tree_branch(rtMeansComparisons);	
	for(int ii = 0; ii < nTypeNum; ii++) 
	{
		int nMeansComparision = vnMeansComparisonTypes[ii];
			
		string strNode, strLabel;
		vector<string> vsLabels, vsTagNames;
		getMeansComparisonsLabel(nMeansComparision, strNode, strLabel, vsTagNames, vsLabels);		
		
		addOneMeansComparisonTables(irng, 
									mterm, tmean, imean, dMSE, nDOF,
									nMeansComparision, strNode, strLabel, vsLabels, vsTagNames,
									dSigLevel, trEffect,
									rtMeansComparisons, ID);
	}
}

void FactorialANOVAReport::getMeansComparisonsLabel(int nMeansComparision, 
													string& strNode, string& strLabel, vector<string>& vsTagNames, vector<string>& vsLabels)
{		
	switch(nMeansComparision)
	{
	case ANOVA_BONFERRON:
		strNode = "Bonferr";
		strLabel = _L("Bonferroni Test");
		//nID = IDST_ANOVA2_MEAN_COMPARE_BONF_TABLE;
		break;
	case ANOVA_TUKEY:
		strNode = "Turey";
		strLabel = _L("Tukey Test");
		//nID = IDST_ANOVA2_MEAN_COMPARE_TUK_TABLE;
		break;
	case ANOVA_SCHEFFE:
		strNode = "Scheffe";
		strLabel = _L("Scheffe Test");
		//nID = IDST_ANOVA2_MEAN_COMPARE_SCHE_TABLE;
		break;
	case ANOVA_SIDAK:
		strNode = "Sidak";
		strLabel = _L("Sidak Test");
		//nID = IDST_ANOVA2_MEAN_COMPARE_SIDAK_TABLE;
		break;	
	case ANOVA_FISHER:
		strNode = "Fisher";
		strLabel = _L("Fisher Test");
		//nID = IDST_ANOVA2_MEAN_COMPARE_FISHER_TABLE;
		break;	
	case ANOVA_BONHOLM:
		strNode = "Bonholm";
		strLabel = _L("Bonholm Test");
		//nID = IDST_ANOVA2_MEAN_COMPARE_BONHOLM_TABLE;
		break;	
	case ANOVA_SIDAKHOLM:
		strNode = "Sidakholm";
		strLabel = _L("Sidakholm Test");
		//nID = IDST_ANOVA2_MEAN_COMPARE_SIDAKHOLM_TABLE;
		break;
	case ANOVA_DUNNETT:
		strNode = "Dunnett";
		strLabel = _L("Dunnett Test");
		//nID = IDST_ANOVA2_MEAN_COMPARE_DUNN_TABLE;
		break;	
	default:
		ASSERT(0);
		break;
	}
	
	vsLabels.Add( _L("MeanDiff") );		vsTagNames.Add( "MeanDiff" );
	vsLabels.Add( _L("SEM") );			vsTagNames.Add( "SEM" );
	
	if(ANOVA_TUKEY == nMeansComparision || ANOVA_DUNNETT == nMeansComparision)
	{
		vsLabels.Add( _L("q Value") );	vsTagNames.Add( "qValue" );
	}
	else if(ANOVA_SCHEFFE == nMeansComparision)
	{
		vsLabels.Add( _L("F Value") );	vsTagNames.Add( "FValue" );
	}
	else
	{
		vsLabels.Add( _L("t Value") );	vsTagNames.Add( "tValue" );
	}
	
	vsLabels.Add( _L("Prob") );			vsTagNames.Add( "Prob" );
	vsLabels.Add( _L("Alpha") );		vsTagNames.Add( "Alpha" );
	vsLabels.Add( _L("Sig") );			vsTagNames.Add( "Sig" );
	vsLabels.Add( _L("LCL") );			vsTagNames.Add( "LCL" );
	vsLabels.Add( _L("UCL") );			vsTagNames.Add( "UCL" );
}

void FactorialANOVAReport::addOneMeansComparisonTables(	//data
														const Range& irng,
														//factorial anova result
														int mterm, double *tmean, int *imean, double dMSE, int nDOF, 
														//means comparison type
														int iTestType, LPCSTR lpcszTypeName, LPCSTR lpcszTypeLabel, 
														const vector<string>& vsColLabels, const vector<string>& vsColTagNames,
														//settings
														double dSigLevel, const TreeNode& trEffect,
														//report tree
														ReportTable& rtMeansComparisons, int& ID)
{
	ReportTable rtOneComparison = rtMeansComparisons.CreateTable(lpcszTypeName, lpcszTypeLabel, ID++);
	
	int nIndex = -1;
	foreach(TreeNode trOneEffect in trEffect.Children)
	{
		nIndex++;
		
		if(!trOneEffect.nVal)
			continue;
		
		string strFactors;
		trOneEffect.GetAttribute(STR_LABEL_ATTRIB, strFactors);
		//out_str(strFactors);//test
			
		ReportTable rtOneFactor = rtOneComparison.CreateTable("Factor"+(string)nIndex, strFactors, ID++);		
		
		vector<int> vNpts;
		if( !countGroupSize(irng, strFactors, NULL, NULL, vNpts) )
			continue;

		if( !addFactorNumberTable(strFactors, rtOneFactor, ID) )
			continue;
		
		addMeansComparisonTable(nIndex,
								mterm, tmean, imean, dMSE, nDOF, 
								vNpts,
								iTestType, vsColLabels, vsColTagNames,
								dSigLevel,
								rtOneFactor, ID);
	}
	
}

/*------------------------------------------*
*	unstack with factor Nitrogen*Sulphate:	*
*-------------------------------------------*	
Nitrogen	1	1	1	1	2	2	2	2
Sulphate	1	2	3	4	1	2	3	4
	1		259	609	608	408	403	272	361	527
	2		645	837	590	321	308	421	586	321
	3		614	601	369	311	351	585	416	259
	4		470	707	499	457	469	455	357	263
	5		355	627	523	459	425	427	590	304
	6		570	470	540	483	262	305	490	295
group size = 8
*/
class UnstackInfo//struct
{
public:
	vector<string>	vsFactorNames;	//Nitrogen, Sulphate
	vector<string> 	vsFactorValues;	//1,1; 1,2; 1,3...
	vector<int>		vnDataNum;		//6, 6,...
	
//public://test
	//UnstackInfo(){out_str("UnstackInfo");}
	//~UnstackInfo(){out_str("~UnstackInfo");}
};

bool FactorialANOVAReport::countGroupSize(	const Range& irng,
											LPCSTR lpczFactor/*Nitrogen*Sulphate*/, 
											vector<string>& vsFactorNames/* = NULL {N, S}*/, 
											vector<string>& vsFactorValues/* = NULL {1,1, 1,2..}*/,
											vector<int>& vnGroupSize/* = NULL {6,...}*/)
{		
	int nFind = m_vsFactorNames.Find(lpczFactor);
	if(nFind > -1)
	{
		UnstackInfo &oneInfo = m_arrUnstackInfo.GetAt(nFind);
		if(vsFactorNames)
			vsFactorNames = oneInfo.vsFactorNames;
		if(vnGroupSize)
			vnGroupSize = oneInfo.vnDataNum;
		if(vsFactorValues)
			vsFactorValues = oneInfo.vsFactorValues;
		
		return true;
	}
	
	Worksheet 		wksData;
	vector<uint> 	vnIndices;
	if( !_get_wks_and_col_selection(irng, wksData, vnIndices) )
		return false;
	
	if( compare_string_localization(lpczFactor, STR_STAT_OVERALL_E) )
		return false;
		
	vector<string> vsFactors;
	int nFactors = str_separate(lpczFactor, STR_FACTOR_SEPERATOR, vsFactors);
		
	UnstackInfo* pInfo = new UnstackInfo;
	pInfo->vsFactorNames = vsFactors;
	
	DataRange drTemp;
	irng.Clone(drTemp);		
	for(int nn = 0; nn < nFactors; nn++)
	{
		int nCol = getFactorColIndex(wksData, vsFactors[nn]);
		ASSERT(nCol > -1);
		drTemp.Add(wksData, nCol, "F", nCol);
	}

	DWORD dwRules = DRR_GET_MISSING|DRR_BAD_WEIGHT_TREATMENT;
	int nNumData = drTemp.GetNumData(dwRules);
	for(nn = 0; nn < nNumData; nn++)
	{
		vector 			vData;
		vector<string> 	vsFactorValues;			
		DWORD uidAux = 0;
		if(drTemp.GetData(dwRules, nn, &uidAux, NULL, &vData, NULL, NULL, &vsFactorValues) < 0)
		{
			ASSERT(0);
			continue;
		}
		int nDataSize = vData.GetSize();
		
		if(pInfo)
		{				
			pInfo->vsFactorValues.Append(vsFactorValues);
			pInfo->vnDataNum.Add(nDataSize); 
		}	
	}
	
	m_arrUnstackInfo.Add(*pInfo);
	m_vsFactorNames.Add(lpczFactor);
	
	if(vsFactorNames)
		vsFactorNames = pInfo->vsFactorNames;
	if(vsFactorValues)
		vsFactorValues = pInfo->vsFactorValues;
	if(vnGroupSize)
		vnGroupSize = pInfo->vnDataNum;
	
	return true;
}

//_get_factor_col_index
int FactorialANOVAReport::getFactorColIndex(const Worksheet& wks, LPCSTR lpczName, Column& colFactor/* = NULL*/)
{
	Column col = wks.FindCol(lpczName, 0, true, true, -1, /*bAllowShortName=*/false);
	if(!col)
		col = wks.FindCol(lpczName, 0, true, true, -1, /*bAllowShortName=*/true);
	
	int nIndex = -1;
	if( col.IsValid() )
	{
		nIndex = col.GetIndex();
		if(colFactor)
			colFactor = wks.Columns(nIndex);
	}
	
	return nIndex;
}

bool FactorialANOVAReport::addFactorNumberTable(LPCSTR lpczFactor, ReportTable& rtMeansComparisons, int& ID)
{
	int nFind = m_vsFactorNames.Find(lpczFactor);
	if(nFind < 0)
		return false;

	ReportTable rtFactorNumber = rtMeansComparisons.CreateTable("FactorNumber", _L("Factor Number"), ID++);
	
	UnstackInfo &oneInfo = m_arrUnstackInfo.GetAt(nFind);
	int nFactors = oneInfo.vsFactorNames.GetSize();

	vector<string> vsColNames(nFactors);
	for(int ii = 0; ii < nFactors; ii++)
	{
		vsColNames[ii] = "Factor"+(string)(ii+1);
	}
	
	int nGroupSize = oneInfo.vnDataNum.GetSize();
	for(ii = 0; ii < nGroupSize; ii++)
	{
		vector<string> vsTemp;
		_get_sub_vector(oneInfo.vsFactorValues, vsTemp, ii*nFactors, (ii+1)*nFactors-1);	
		rtFactorNumber.AddRow("Number"+(ii+1), vsTemp, (string)(ii+1), oneInfo.vsFactorNames, vsColNames, ID++);
	}
	
	return true;
}

void FactorialANOVAReport::addMeansComparisonTable(	int nEffect,//int nEffect = nIndex;// + 1;//block
													//factorial anova result
													int mterm, double *tmean, int *imean, double dMSE, int nDOF, 
													//factor group size
													const vector<int>& vNpts,
													//means comparison type
													int iTestType, const vector<string>& vsColLabels, const vector<string>& vsColTagNames,
													//settings
													double dSigLevel,
													//report tree
													ReportTable& rtMeansComparisons, int& ID)
{
	int nLevels = imean[nEffect] - (nEffect == 0? 0 : imean[nEffect-1]);
	ASSERT(vNpts.GetSize() == nLevels);

	vector 		vMean(nLevels);
	for(int ll = (nEffect == 0? 0 : imean[nEffect-1]), kk = 0; ll < imean[nEffect]; ll++, kk++)
	{
		vMean[kk] = tmean[ll];
		//printf("%g ", vMean[kk]);//test
	}
	//out_str("");//test
	
	vector<int> vIndexComparison;
	vector<long> vSig;
	vector		vMeanDiffs, vLCLs, vUCLs, vSe, vStat, vProb, vAlpha;
	
	int nSize = nLevels * (nLevels - 1)/2;
	vIndexComparison.SetSize(nSize);
	vMeanDiffs.SetSize(nSize);
	vLCLs.SetSize(nSize);
	vUCLs.SetSize(nSize);
	vSe.SetSize(nSize);
	vStat.SetSize(nSize);
	vProb.SetSize(nSize);
	vSig.SetSize(nSize);
	vAlpha.SetSize(nSize);
	

	int iErr = ocmath_anova_mean_comparison( vMean, vMean.GetSize(),
											 vNpts, vNpts.GetSize(),
											 dMSE,
											 nDOF,
											 dSigLevel,
											 nLevels,
											 vIndexComparison, nSize,
											 vMeanDiffs, nSize,
											 vLCLs, nSize,
											 vUCLs, nSize,
											 vSe, nSize,
											 vStat, nSize,
											 vProb, nSize,
											 vSig, nSize,
											 vAlpha, nSize,
											 iTestType
											 );
	if (iErr != NE_NOERROR)
	{
		ASSERT(0);
		return;
	}
	
	ReportTable rtOneFactor = rtMeansComparisons.CreateTable("MeansComparison", _L("Means Comparison"), ID++);
			
	vector<uint> vSortIndex;
	vIndexComparison.Sort(SORT_ASCENDING, true, vSortIndex);

	int nRow = 0;	
	for(int i = 0; i < nLevels; i++)
	{
		for(int j = 0; j < i; j++)
		{
			string strRowLabel;
			strRowLabel.Format("%d %d", i+1, j+1);
			
			int nIndex = vSortIndex[nRow];
			vector vec;
			vec.Add( vMeanDiffs[nIndex] );
			vec.Add( vSe[nIndex] );
			vec.Add( vStat[nIndex] );
			vec.Add( vProb[nIndex] );
			vec.Add( vAlpha[nIndex] );
			vec.Add( vSig[nIndex] );
			vec.Add( vLCLs[nIndex] );
			vec.Add( vUCLs[nIndex] );
			
			TreeNode trRow = rtOneFactor.AddRow("Row"+(nRow+1), vec, strRowLabel, vsColLabels, vsColTagNames, ID++);
			if(ANOVA_BONHOLM == iTestType || ANOVA_SIDAKHOLM == iTestType)
				trRow.LCL.Show = trRow.UCL.Show = false;
			
			nRow++;
		}
	}
}

//Code is copied from ocStats.cpp  OCMATH_API 
//int ocmath_osANOVA2Way_Compute_Power
int FactorialANOVAReport::addPowerReport(const Range& factors, int nfac, double *table, int mterm,
										bool actpower, bool hypotpower, double siglevel, LPCSTR lpczhypotsize,  
										const TreeNode& trEffect, ReportTree& rtANOVA, int& ID)
{
	ReportTable rtPowers = rtANOVA.CreateTable("Powers", _L("Powers"), ID++);
	collapse_report_tree_branch(rtPowers);	
	
	vector vSampleSizes;
	if(hypotpower)
	{
		string strSamples(lpczhypotsize);
		strSamples.GetTokens(vSampleSizes, ' ');
	}	
	if(actpower)
	{
		string strDescriptive;
		vector vData;
		factors.GetData(DRR_NO_WEIGHTS, 0, NULL, &strDescriptive, &vData);		
		//factors.GetData(vData, 0);
		vSampleSizes.InsertAt(0, vData.GetSize());
	}
	int nSampleSize = vSampleSizes.GetSize();
	
	vector<string> vsHeaders(nSampleSize);
	if(hypotpower)
	{
		string strDefault = _L("Hypothesis Powers");
		init_vector_string(vsHeaders, nSampleSize, strDefault);
	}
	if(actpower)
		vsHeaders[0] = _L("Actual Power");
	//rtPowers.AddColumn(vsHeaders, "PowerName", ID++, NULL, OKDATAOBJ_DESIGNATION_X);
	
	vector vAlpha(nSampleSize);
	vAlpha = siglevel;
	rtPowers.AddRow("Alpha", vAlpha, " ", vsHeaders, NULL, ID++, _L("Alpha"));	
	rtPowers.AddRow("SampleSize", vSampleSizes, " ", vsHeaders, NULL, ID++, _L("Sample Size"));
			
	
	int iInteractions = 1;
	int iAlpha = (1 - siglevel) * STATS_ROUND_FACTOR1 + 0.5;
		
	//dnPts = (double)arANOVA2_Table[0].DOF  + (double)arANOVA2_Table[1].DOF + (double)arANOVA2_Table[2].DOF +(double)arANOVA2_Table[4].DOF + 1; 
	double dnPts = 1;
	for (int ii = 1; ii <= mterm-2; ii++)
		dnPts += TABLE(ii, 0);
	
	int iSource = 0;
	foreach(TreeNode trOneEffect in trEffect.Children)
	{
		iSource++;
		
		//dNC = arANOVA2_Table[iSource].SSq / arANOVA2_Table[4].MeanSq;
		double dNC = TABLE(iSource, 1)/TABLE(mterm - 2, 2);//mterm - 2: residual sum of squares\error
	
		double dProd = 1;
		for(ii = 0; ii < nfac; ii++)
		{
			if( iInteractions )
				dProd *= TABLE(ii + 1, 0) + 1;
			else	
				dProd += TABLE(ii + 1, 0);
		}

		double dSS, dssNC, dssDFE, dssDevF;
		int iSize = vSampleSizes.GetSize();
		vector vSSPOW(iSize);
		for(ii = 0 ; ii < iSize; ii++ )
		{
			// Compute non-centrality factor for hypothetical sample size
			dSS = (double) vSampleSizes[ii];
			if (dSS < 0)
				return 	STATS_ERROR_SETTING;
			else
			{			
				dssNC = ( dSS / dnPts ) * dNC;
				
				// Compute the Degrees of Freedom of Error for hypothetical sample size 
				//if(iInteractions):dssDFE = dSS - ( arANOVA2_Table[0].DOF + 1 ) * ( arANOVA2_Table[1].DOF + 1 );
				//else: 			dssDFE = dSS - arANOVA2_Table[0].DOF - arANOVA2_Table[1].DOF - 1;
				dssDFE = dSS - dProd;
	
				if( dssDFE < 1 )
					return STATS_ERROR_SETTING; 
				else
				{
					//dssDevF = finv((double)iAlpha/STATS_ROUND_FACTOR1, (int) arANOVA2_Table[iSource].DOF, (int) dssDFE);
					dssDevF = finv((double)iAlpha/STATS_ROUND_FACTOR1, (int) TABLE(iSource, 0), (int) dssDFE);
	
					// Compute power for hypothetical sample size
					//vSSPOW[ii] = osANOVA_Power( dssDevF, arANOVA2_Table[iSource].DOF, dssDFE, dssNC);
					vSSPOW[ii] = calANOVAPower( dssDevF, TABLE(iSource, 0), dssDFE, dssNC);
				} 
			}
		}
		
		string strFactors;
		trOneEffect.GetAttribute(STR_LABEL_ATTRIB, strFactors);	
		rtPowers.AddRow("Power"+(string)iSource, vSSPOW, _L("Power"), vsHeaders, NULL, ID++, strFactors);
	}
	
	return true;
}

double FactorialANOVAReport::calANOVAPower( double dFval, double ddf1, double ddf2, double dnc)
{
	double dtol = 1e-6;		// Required accuracy of the solution
	int imaxiter = 10000;	// Maximum number of iterations to be performed

	
	double dPower = NANUM;							// Computed power
	NagError fail;
	//INIT_FAIL(fail);
	
	//dPower = 1 - ocmath_non_central_f_cdf(&dFval, &ddf1, &ddf2, &dnc, &iErr);	
	dPower = 1 - nag_prob_non_central_f_dist(dFval, ddf1, ddf2, dnc, dtol, imaxiter, &fail);
	return dPower;
}
/*------------------------------------------*
*	utilities functions:					*
*-------------------------------------------*/
void collapse_report_tree_branch(TreeNode& trReport);

//copy from wunstackcol
static bool _get_wks_and_col_selection(const Range& iy, Worksheet& wks, vector<uint>& vnIndices)
{
	if ( !iy || 0 == iy.GetNumRanges() || 0 == iy.GetNumData() )
		return false;
	
	for ( int iSub = 0; iSub < iy.GetNumRanges(); iSub++ )
	{
		Worksheet		wksRange;
		int				c1, c2;
		iy.GetRange(wksRange, c1, c2, iSub);
		if ( !wks )
			wks = wksRange;
		else
		///------ Folger 09/01/09 UNSTACK_ERROR_CHECKING_IMPROVEMENT
			//ASSERT(is_same_layer(wks, wksRange));
		{
			if ( !is_same_layer(wks, wksRange) )
				continue;
		}
		///------ End UNSTACK_ERROR_CHECKING_IMPROVEMENT
		if ( -1 == c2 )
			c2 = wksRange.GetNumCols() - 1;
		for ( int ii = c1; ii <= c2; ii++)
		{
			if ( -1 == _find_in_list(ii, vnIndices, false) )
				vnIndices.Add(ii);
		}
	}
	return vnIndices.GetSize() > 0 ? true : false;
}
static int _find_in_list(int nVal, const vector<uint>& vn, bool bWasSortedAccending)
{
	if(vn.GetSize() < 1)
		return -1;

	for(int ii = 0; ii < vn.GetSize(); ii++)
	{
		if(vn[ii] == nVal)
			return ii;
		else if( bWasSortedAccending && vn[ii] > nVal )
			return -1;
	}
	return -1;
}	

static bool _get_sub_vector(const vector<string>& vsSource, vector<string>& vsSub, int nBegin, int nEnd)
{
	int nSize = vsSource.GetSize();
	if(nBegin >= nSize || nEnd >= nSize)
		return false;
	
	int begin =	nBegin <= nEnd? nBegin : nEnd;
	int end = 	nEnd >= nBegin? nEnd : nBegin;
	
	vsSub.SetSize(end - begin + 1);
	for(int ii = begin, jj = 0; ii <= end; ii++, jj++)
		vsSub[jj] = vsSource[ii];
	
	return true;
}		

static void _get_sub_vector(const vector<string>& vsSource, const vector<uint>& vnIndices, vector<string>& vsSub)
{
	int nSize = vsSource.GetSize();
	int nSubSize = vnIndices.GetSize();
	vsSub.SetSize(nSubSize);
	for(int ii = 0; ii < nSubSize; ii++)
	{
		int nIndex = vnIndices[ii];
		vsSub[ii] = (0 <= nIndex && nIndex < nSize)? vsSource[nIndex] : "";
	}
}

int 	count_factors_levels(const Range& drFactor, const Range& drData, vector<int>& vnLevels);


void 	output_residual_data_and_plot(	const DataRange& drInput, const DataRange& drFactors, const vector& vResidual,
										const vector<string>& vsNames, LPCSTR lpczLabel, LPCSTR resplotx, const int& probplot, 
										ReportTree& rt, ReportData& rd, ReportData& rdProb,	int& id);
/*------------------------------------------*
*	end utilities functions:				*
*-------------------------------------------*/
