/*------------------------------------------------------------------------------*
 * File Name: FFWParamControls.h		 										*
 * Creation: 																	*
 * Purpose: 																	*
 * Copyright (c) Originlab Corp.	2005, 2006, 2007, 2008, 2009, 2010			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Jasmine 07/19/10 ORG-591-P4 FUNCTION_BODY_IS_EMPTY_SO_NO_NEED_CHECK_COMPILE_OC
 *	Jasmine 09/03/10 ORG-975-S1 ADD_SIGNIFICANT_DIGITS_COLUMN					*
 *	Jasmine 12/24/10 ORG938-P4 GET_TRUE_VALUE_WITHOUT_FORMAT					*
 *	Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE		*
 *	Folger 01/09/2012 ORG-4454 REFACTOR_NLFITSESSION							*
 *------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
 this file contains two classes:
 	1. FFWParamSetting
 	2. FFWConstantSetting
 *------------------------------------------------------------------------------*/ 
 
#ifndef _FFW_PARAM_GRID_H
#define _FFW_PARAM_GRID_H

#define _NLF_81(_NAME) 

#include <..\originlab\NLFitSession.h>

#include <event_utils.h>
#include "GridTableControl.h"
#include "NLFitParaControl.h"


/*------------------------------------------------------------------------------*
 * FFWParamSetting 			 													*
 *------------------------------------------------------------------------------*/
class FFWParamSetting : public NLFParamsControl
{
public:
	void Init(int nID, WndContainer& dlg,LPCSTR lpcszDlgName);
	bool SetTree(TreeNode &trFunct, int* pnErrorCode = NULL);
	bool GetTree(TreeNode & trFunction);

	//void AddParam();
	//void DelParam();
	
	/// Hong 07/01/10 ORG-432 FFW_NEW_GUI_DESIGN
	int	GetParamsVals(vector& vv);
	/// end FFW_NEW_GUI_DESIGN	
	
	void OnBeforeEditParaControl(Control flxControl, int nRow, int nCol, BOOL* pCancel);
	
private:
	FFWFunctionOrganizer	m_NFO;
	NLFitSession			m_NLFitSession;

private:
	void initGroupColList(vector<int>& vncollists);
	bool getParamStringValues(NLPARAMGRIDCOLTYPE colType, vector<string>& vsValue);
	int GetNumParameter();
		
	/// Bill 04/27/2011 ORG-2473 SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
#ifdef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	virtual bool isParameterTabDraggable() { return false; }
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
	/// End SUPPORT_NLFIT_PARAMETER_BOUNDS_TAB_DRAGGABLE
};

void FFWParamSetting::Init(int nID, WndContainer& dlg,LPCSTR lpcszDlgName)
{
	m_NLFitSession.SetAutoInitParams(false);

	SetNLParamsMngr(m_NLFitSession.GetNLParamsMngr());

	NLFParamsControl::Init(nID, dlg, lpcszDlgName);
	SetColHeading(NLPARAMGRIDCOLTYPE_VALUE, _L("Initial Value"));

	vector<uint> vnDefaultShows;
	vector<int> vnColList;
	initGroupColList(vnColList);
	vnDefaultShows.SetSize(vnColList.GetSize());
	vnDefaultShows = 1;
	AddGroup(vnColList, vnDefaultShows);

	SetVisible(true);
}

bool FFWParamSetting::SetTree(TreeNode & trFunction, int * pnErrorCode /* = NULL */)
{
	string strFunction = m_NFO.GetFunctionName(trFunction);
	///Jasmine 07/19/10 ORG-591-P4 FUNCTION_BODY_IS_EMPTY_SO_NO_NEED_CHECK_COMPILE_OC
	string strCategory, strFullPath;
	trFunction.GetAttribute(STR_CATEGORY_ATTRIB, strCategory);
	trFunction.GetAttribute(STR_FILENAME_ATTRIB, strFullPath);
	
	//m_NLFitSession.SetFunction(trFunction, 1, true, strFunction, strCategory, 0, NULL, NULL);
		
	NLParametersManager		*pNLParamsMngr = m_NLFitSession.GetNLParamsMngr();
	pNLParamsMngr->OnAfterResetNLFit();						
	///------ Folger 01/09/2012 ORG-4454 REFACTOR_NLFITSESSION
	//if ( pNLParamsMngr->SetOneFunc(strFullPath, trFunction, strFunction, strCategory, 0) )
	if ( m_NLFitSession.SetOneFunc(strFullPath, trFunction, strFunction, strCategory, 0) )
	///------ End REFACTOR_NLFITSESSION
		return error_report("SetFunction error");
	m_NLFitSession.SetParamByFDFSettings(0);

	///End FUNCTION_BODY_IS_EMPTY_SO_NO_NEED_CHECK_COMPILE_OC
	
	Update(false);
	
	return true;
}

bool FFWParamSetting::GetTree(TreeNode & trFunction)
{	
	///Jasmine 07/14/10 ORG-486-S1 CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
	Tree trModify;
	trModify = m_NLFitSession.GetTreeFDFModified();
	
	bool bPeakFunction = m_NFO.IsPeak(trFunction);
	if(bPeakFunction)
	{
		vector<string> vsPeakAttributes;
		GetColValues(NLPARAMGRIDCOLTYPE_PEAK_ATTRIBUTE, vsPeakAttributes, GetRowOffset());
		write_peak_attributes_to_tree(vsPeakAttributes, trModify);				
	}		
	m_NFO.CheckCopyPeakAttributeNodes(bPeakFunction, trModify, trFunction);
	
	TreeNode trParaSetting = trFunction.GetNode(cvt_str_to_tag_name(STR_FUNC_FIT_PARAM), false);
	TreeNode trModifyParaSetting = trModify.GetNode(cvt_str_to_tag_name(STR_FUNC_FIT_PARAM), false);
	
	if(trParaSetting && trModifyParaSetting)
		trParaSetting.Replace(trModifyParaSetting, true, true);
	///End CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
		
	return true;
}

/*void FFWParamSetting::AddParam()
{
	int nOldRowCount = GetRows() - GetRowOffset();	
	SetRows(nOldRowCount + 1);
}

void FFWParamSetting::DelParam()
{
	RemoveSelection();
}*/

/// Hong 07/01/10 ORG-432 FFW_NEW_GUI_DESIGN
int	FFWParamSetting::GetParamsVals(vector& vv)
{
	vector<string> vsValues;
	getParamStringValues(NLPARAMGRIDCOLTYPE_VALUE, vsValues);
	convert_str_vector_to_num_vector(vsValues, vv);
	
	return vv.GetSize();
}
/// end FFW_NEW_GUI_DESIGN
///Jasmine 07/14/10 ORG-486-S1 CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
void FFWParamSetting::OnBeforeEditParaControl(Control flxControl, int nRow, int nCol, BOOL* pCancel)
{
	if(NLPARAMGRIDCOLTYPE_UNIT == nCol || NLPARAMGRIDCOLTYPE_MEANING == nCol)
		return;
	
	NLFParamsControl::OnBeforeEditParaControl(flxControl, nRow, nCol, pCancel);
	
	if(NLPARAMGRIDCOLTYPE_PEAK_ATTRIBUTE == nCol)
	{
		string strPeakInfoLilst = "";
		
		///Jasmine 07/19/10 ORG-486 NOT_ALLOW_USER_EDIT_TO_PREVENT_WRONG_STRING
		if(GetRowOffset() < nRow)//not allow change offsett parameter
		{
			int nDeps, nIndeps;
			m_NLFitSession.GetNumVars( &nDeps, &nIndeps);
			
			strPeakInfoLilst = ConstructPeakAttributeString(GetRowOffset() == nRow, nIndeps>1);
			
			if(pCancel)
				*pCancel = false;
		}
		else if(pCancel)
			*pCancel = true;			
		///End NOT_ALLOW_USER_EDIT_TO_PREVENT_WRONG_STRING
				
		SetColComboList(NLPARAMGRIDCOLTYPE_PEAK_ATTRIBUTE, strPeakInfoLilst);
	}		
}

void FFWParamSetting::initGroupColList(vector<int>& vncollists)
{
	vector<int> vn = { 	NLPARAMGRIDCOLTYPE_NAME, 
						NLPARAMGRIDCOLTYPE_VALUE,
						NLPARAMGRIDCOLTYPE_FIXED,
						NLPARAMGRIDCOLTYPE_MEANING, 
						NLPARAMGRIDCOLTYPE_UNIT,
						NLPARAMGRIDCOLTYPE_SD,				///Jasmine 09/03/10 ORG-975-S1 ADD_SIGNIFICANT_DIGITS_COLUMN
						NLPARAMGRIDCOLTYPE_PEAK_ATTRIBUTE};	///Jasmine 07/09/10 ORG-486 CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
	vncollists = vn;
}	

bool FFWParamSetting::getParamStringValues(NLPARAMGRIDCOLTYPE colType, vector<string>& vsValue)
{
	///Jasmine 12/24/10 ORG938-P4 GET_TRUE_VALUE_WITHOUT_FORMAT
	/*if (GetColValues(colType, vsValue) > 0)
	{
		vsValue.RemoveAt(0);
		return true;
	}
	else
	{
		return false;
	}*/
	NLParametersManager		*pNLParamsMngr = m_NLFitSession.GetNLParamsMngr();
	if ( pNLParamsMngr->GetColumn(colType, vsValue, FALSE) <= 0 )
		return false;
	
	return true;
	///End GET_TRUE_VALUE_WITHOUT_FORMAT
}

int FFWParamSetting::GetNumParameter()
{
	vector<string> vsNames;

	getParamStringValues(NLPARAMGRIDCOLTYPE_NAME, vsNames);

	for (int ii = vsNames.GetSize() - 1 ; ii >= 0 ; --ii)
		if (vsNames[ii] == "")
		{
			DeleteRow(ii);
		}

	return GetRows() - GetRowOffset();
}

/*------------------------------------------------------------------------------*
 * End FFWParamSetting		 													*
 *------------------------------------------------------------------------------*/

 
 /*------------------------------------------------------------------------------*
 * FFWConstantSetting		 													*
 *------------------------------------------------------------------------------*/
enum{
	CONSTANT_VARIABLE_COLUMN,
	CONSTANT_VALUE_COLUMN,

	CONSTANT_COLUMN_TOTAL
};

class FFWConstantSetting : public GridListControl
{
public:
	void Init(int nID, WndContainer& dlg, WndContainer* pParentDlg = NULL);
	void Update(const vector<string>& vsVariables, const vector<string>& vsValues);
	void AddConst();
	void DelConst();
};
 
void FFWConstantSetting::Init(int nID, WndContainer& dlg, WndContainer* pParentDlg/* = NULL*/)
{
	GridListControl::Init(nID, dlg);
	SetCols(CONSTANT_COLUMN_TOTAL); /// Hong 11/10/10 ORG-1487 FIX_CONSTANT_GRID_RUNTIME_DUE_TO_ASSUME_TWO_COLS
	SetSelection(flexSelectionFree);	///Sophy 7/8/2010 ORG-518 MAKE_CONSTANT_GRID_SELECT_MODE_SAME_AS_PARAM_GRID
	m_flx.ExtendLastCol = false;
	
	SetColHeading(CONSTANT_VARIABLE_COLUMN, _L("Name"));
	SetColHeading(CONSTANT_VALUE_COLUMN, _L("Value"));

	SetEditable(flexEDKbdMouse);
	
	SetColAlignment(CONSTANT_VARIABLE_COLUMN, flexAlignCenterCenter);
	SetColAlignment(CONSTANT_VALUE_COLUMN, flexAlignCenterCenter);
}

void FFWConstantSetting::Update(const vector<string>& vsVariables, const vector<string>& vsValues)
{
	SetRows( vsVariables.GetSize() );
	SetColValues(CONSTANT_VARIABLE_COLUMN, vsVariables);
	SetColValues(CONSTANT_VALUE_COLUMN, vsValues);
}

void FFWConstantSetting::AddConst()
{
	int nOldRowCount = GetRows() - GetRowOffset();	
	SetRows(nOldRowCount + 1);
}

void FFWConstantSetting::DelConst()
{
	RemoveSelection();
}
 /*------------------------------------------------------------------------------*
 * End FFWConstantSetting		 												*
 *------------------------------------------------------------------------------*/

///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
 /*------------------------------------------------------------------------------*
 * FFWConstantSetting		 													*
 *------------------------------------------------------------------------------*/
enum{
	INTEG_ELEMENT_COLUMN,
	INTEG_VALUE_COLUMN,

	INTEG_COLUMN_TOTAL
};

class FFWIntegSetting : public GridListControl
{
public:
	void Init(int nID, WndContainer& dlg);//, WndContainer* pParentDlg = NULL);
};

void FFWIntegSetting::Init(int nID, WndContainer& dlg)//, WndContainer* pParentDlg/* = NULL*/)
{
	GridListControl::Init(nID, dlg);
	SetCols(INTEG_COLUMN_TOTAL); /// Hong 11/10/10 ORG-1487 FIX_CONSTANT_GRID_RUNTIME_DUE_TO_ASSUME_TWO_COLS
	SetSelection(flexSelectionFree);	///Sophy 7/8/2010 ORG-518 MAKE_CONSTANT_GRID_SELECT_MODE_SAME_AS_PARAM_GRID
	m_flx.ExtendLastCol = false;
	
	SetColHeading(INTEG_ELEMENT_COLUMN, _L("Element"));
	SetColHeading(INTEG_VALUE_COLUMN, _L("Value"));

	SetEditable(flexEDKbdMouse);
	
	SetColAlignment(INTEG_ELEMENT_COLUMN, flexAlignCenterCenter);
	SetColAlignment(INTEG_VALUE_COLUMN, flexAlignCenterCenter);
}
///End CREATE_FITFUNC_WITH_INTEGRAL

#endif//_FFW_PARAM_GRID_H
