/*------------------------------------------------------------------------------*
 * File Name:FFWPages.h		 													*
 * Creation: 																	*
 * Purpose: 																	*
 * Copyright (c) Originlab Corp.	2005, 2006, 2007, 2008, 2009, 2010			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Jasmine 06/17/10 ORG-2 TURN_OFF_UNTIL_INTEGRAL_CONVOLUTION_READY			*
 *	Jasmine 06/18/10 ORG-2-S1 ADD_NEW_CATEGORY_NAME_USER_DEFINED				*
 *	Jasmine 06/23/10 ORG-2-S6 WANT_FILE_PATH_TO_DISPLAY							*
 *	Folger 06/24/10 ORG-390-P3 FDF_FILE_NAME_SHOULD_UPDATE_AFTER_FUNCTION_NAME_CHANGED
 *	Jasmine 07/08/10 ORG-2-P4 AUTO_RUN_INIT_CODE_IS_RESET_IF_INIT_CODE_EMPTY	*
 *  Jacky 7/12/2010 ORG-518-P9 ADD_FFWGOALPAGE                                  *
 *  Jacky 7/14/2010 ORG-545-P2 FIX_CATEGORY_ALWAYS_THE_LAST_USED_ONE            *
 *  Bill 07/14/2010 ORG-576-S1 MOVE_TO_NEXT_ROW_IF_USER_PRESS_ENTER             *
 *  Bill 07/16/2010  CHANGE_ID_DIFF_WITH_FUNCTION_BODY_PAGE                     *
 *	Folger 08/11/10 ORG-762 BETTER_ERROR_CHECKING_FOR_DERIVED_PARAMS_EQUATIONS	*
 *	Folger 08/16/10 ORG-762-P2 MORE_ERROR_CHECKING_ON_DERIVED_PARAMS_EQUATIONS	*
 *	Jasmine 08/17/10 ORG-745-P5 SHARE_FO_NAME_CHECKING_CODE						*
 *	Jasmine 08/18/10 ORG-820-S1 NOT_ALLOW_FINISH_UNTIL_DERIVED_PARAM_CHECK_OK	*
 *	Jasmine 08/18/10 ORG-745-S1 DISABLE_EQUATION_IF_NO_DERIVED_PARAM			*
 *	Jasmine 08/18/10 ORG-745-P5 AUTO_CORRECT_INVALID_FUNCTION_NAME				*
 *	Folger 08/31/2010 ORG-958-P3 BOUNDS_GRID_BAD_COLUMN_SIZE_IN_G				*
 *	Jasmine 09/15/10 ORG-1056-P1 PREVENT_DELETE_THE_SAME_OLD_NAME_FILE			*
 *	Folger 12/24/2010 ORG-938-P2 PROPER_UPDATE_NLFIT_PARAM_GRID_AFTER_DATE_TIME_FORMAT_CHANGE
 *	Folger 01/28/2011 ORG-2153-P1 ADJUST_WIDTH_OF_OC_COMBOBOX					*
 *	Jasmine 03/11/11 ORG-2418-S1 SPACE_TRIM_MSG_NOT_CORRECT_SINCE_DASH_TRIM		*
 *	Folger 07/14/2011 ORG-3257-P1 FFW_SELECT_CATEGORY_DROP_DOWN_LIST_TOO_NARROW	*
 *	Folger 07/20/2011 ORG-3257-P1 FFW_SELECT_USER_DEFINED_FDF_DROP_DOWN_LIST_TOO_NARROW
 *	Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL					*
 *	Jasmine 08/08/2011 ORG-342-S1 ERR_CHECK_FOR_INTEG							*		 
 *	Jasmine 08/23/2011 ADD_INCLUDE_INTEGRATION_HINT								*
 *	Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
 *	Folger 11/05/2011 ORG-4301-P1 FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
 *  Iris 7/03/2012 ORG-6109-S4 DISABLE_IMPLICIT_FUNC_OPTIONS_IN_FIT_FUNC_WIZ	*
 *  Junon 08/17/2012 ORG-5003 DISABLE_PEAK_FUNCTION_CHECKBOX_AND_INTEGRATION_CHEXKBOX_FOR_IMPLICT_FUNCTION
 *	Tony 08/28/2012 ORG-3079-S1 SET_BIT_TO_DISABLE_CATEGORY					*
 *	Tony 08/28/2012 ORG-3079-S2 REMOVE_SURFACE_PFW_BASELINE_IMPLICIT_FROM_CATEGORY_LIST	*
 *------------------------------------------------------------------------------*/
 
/*------------------------------------------------------------------------------*
 this file contains these classes:
 	. FFWPathHelper
 	. FFWPageBase	
 	|-. FFWGoalPage
 	|-. FFWNameTypePage
 	|-. FFWInitialCodePage
 	|-. FFWBoundsConstraintsPage
 	|-. FFWDerivedParametersPage
 	|-. FFWBeforeAfterPage
 *------------------------------------------------------------------------------*/ 
 
#ifndef _FFW_PAGE_BASE_H
#define _FFW_PAGE_BASE_H

#define STR_FFW_HINTS_TXT			"FunctionWizardHints.txt"	///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT

//---for FFWBoundsConstraintsPage
#include "nlsf_utils.h"
#include "NLFitSession.h"
#include "GridTableControl.h"
#include "NLFitParaControl.h"
#include "FOParametersSetting.h"
//---
#include "FunctionMgr.h"//for FFWInitialCodePage

#define	STR_DIALOG_TITLE_SEPARATOR		" - "

#define	STR_LOCALIZD_CATEGORY	"FFW"

#define	STR_ERROR		_LC("Error", STR_LOCALIZD_CATEGORY)

/*------------------------------------------------------------------------------*
 * FFWPathHelper 					 											*
 *------------------------------------------------------------------------------*/
class FFWPathHelper
{
private:
	int		m_nFrom;
	int		m_nTo;
	
public:
	FFWPathHelper(){m_nFrom = m_nTo = -1;}
	void 	RecordFromPage(int nFrom)
	{
		if ( nFrom != -1)
			m_nFrom = nFrom;
	}
	void 	RecordToPage(int nTo){m_nTo = nTo;}
	int 	RetrieveFromPage(){return m_nFrom;}
	int 	RetrieveToPage(){return m_nTo;}
};
/*------------------------------------------------------------------------------*
 * FFWPathHelper End				 											*
 *------------------------------------------------------------------------------*/
 
/*------------------------------------------------------------------------------*
 * FFWPageBase				 													*
 *------------------------------------------------------------------------------*/
#define		STR_ITEM_SEPARATOR		','			///Jasmine 08/08/2011 ORG-342-S1 ERR_CHECK_FOR_INTEG

///------ Folger 11/05/2011 ORG-4301-P1 FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
#define		WM_FFW_USER_MSG_RESTORE_PAGE_SIZE			0x2000
///------ End FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS

class FitFuncWizPlaceHolder;
class FFWPageBase : public PropertyPage
{
public:
	FFWPageBase(int nID);
	void InitPage(int nID, FitFuncWizPlaceHolder* pHolder, WndContainer& dlg);
	
	void SetHints(LPCSTR lpcszHintsd, bool bNextPage = false);
	DWORD OnShowStatus(DWORD InternalStatus);
	
	virtual BOOL OnInitPage();
	virtual BOOL OnActivatePage();
	virtual BOOL OnKillActiviePage();
	virtual BOOL OnNext();
	virtual BOOL OnBack();
	
	virtual string GetName(){return "base";} //For testing only, DO NOT use.

	virtual	int				GetPageID()		{ return GetID(); }

	void StringToEditText(const string & str, Edit & edit);
	void EditTextToString(Edit & edit, string & str);

	///------ Folger 11/05/2011 ORG-4301-P1 FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
	void			RestorePageSize();
	///------ End FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS

protected:
	virtual bool 	UpdateTreeToPageGUI(const TreeNode& trFunction){ASSERT(0); return false;}
	virtual bool 	UpdatePageGUIToTree(TreeNode& trFunction){ASSERT(0); return false;}
	virtual string	GetPageHints(bool bNextPage = false);
	virtual string	GetPageHintsName(bool bNextPage = false){ ASSERT(0); return ""; }///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT
	
	virtual string	GetHintsBySection(LPCSTR lpcSection);

	FFWFunctionOrganizer&		FuncOrganizer()
	{
		return *m_pHolder->m_pNFO;
	}
	virtual	bool	UpdateDlgTitle(LPCSTR lpcszFunctionName);	///Sophy 7/2/2010 ORG-432-S4 SHOW_FUNCTION_NAME_ON_FFW_DIALOG_TITLE
	int 			MessageBox(LPCSTR lpText, LPCSTR lpCaption = NULL, UINT uType = MB_OK );

	///Jasmine 08/08/2011 ORG-342-S1 ERR_CHECK_FOR_INTEG, move from FFWParamPage
	//refer to NumFunctionOrganizerEx::correctVarNameList
	bool 			checkEditControlValue(Control ctrl, LPCSTR lpczCtrlName, bool bAllowEmpty, string& strErrMsg);
	///End ERR_CHECK_FOR_INTEG

	///------ Folger 11/05/2011 ORG-4301-P1 FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
private:
	void	GetThisRect(RECT& rr);
	///------ End FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS

protected:
	FitFuncWizPlaceHolder*	m_pHolder;
	Window					m_wndParent;
	bool					m_bUpdatePageDone;
	
	FFWPathHelper			m_PathHelper;
	///------ Folger 11/05/2011 ORG-4301-P1 FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
	RECT					m_rrThis;
	///------ End FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
	
};

FFWPageBase::FFWPageBase(int nID) : PropertyPage(nID)
{
	m_pHolder = NULL; 
	m_bUpdatePageDone = false;
}	

void FFWPageBase::InitPage(int nID, FitFuncWizPlaceHolder* pHolder, WndContainer& dlg)
{
	SetID(nID);
	m_pHolder = pHolder;
			
	Window wTemp(dlg.GetSafeHwnd());
	m_wndParent = wTemp;
}

void FFWPageBase::SetHints(LPCSTR lpcszHints, bool bNextPage/* = false*/)
{
	Control edHints = m_wndParent.GetDlgItem(bNextPage? IDC_FIT_FUNC_NEXT_HINTS : IDC_FIT_FUNC_HINTS);
	if ( edHints)
		edHints.Text = lpcszHints;
}

virtual BOOL FFWPageBase::OnInitPage()
{
	///------ Folger 11/05/2011 ORG-4301-P1 FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
	GetThisRect(m_rrThis);
	///------ End FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS

	return TRUE;//return OnActivatePage();///Jasmine 07/14/10 OnActivatePage should be called on event
}

virtual BOOL FFWPageBase::OnActivatePage()
{	
	if ( !m_pHolder->IsExpectedPage( GetPageID() ) || !m_pHolder->IsEditablePage( GetPageID() ) )
		return TRUE;

	if ( m_bUpdatePageDone)
	{
		UpdateDlgTitle(FuncOrganizer().GetFunctionName(m_pHolder->m_trFunction)); //update the title after VC level update
		return TRUE;
	}
	m_bUpdatePageDone = true;
	
	m_PathHelper.RecordFromPage( m_pHolder->RetrieveFromPage() );
	m_pHolder->ResetExpectedPage();
	
	m_pHolder->UpdateButtonStatus( GetPageID() );

	TreeNode trFunction = m_pHolder->m_trFunction;
	UpdateTreeToPageGUI(trFunction);

	///Sophy 6/29/2010 ORG-432-S4 SHOW_FUNCTION_NAME_ON_FFW_DIALOG_TITLE
	UpdateDlgTitle(FuncOrganizer().GetFunctionName(m_pHolder->m_trFunction));
	///end SHOW_FUNCTION_NAME_ON_FFW_DIALOG_TITLE
	
	SetHints(GetPageHints());
	SetHints(GetPageHints(true), true);
	return TRUE;
}

///------ Folger 11/05/2011 ORG-4301-P1 FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS
void	FFWPageBase::RestorePageSize()
{
	RECT	rr;
	GetThisRect(rr);

	rr.bottom = rr.top + RECT_HEIGHT(m_rrThis);
	rr.right = rr.left + RECT_WIDTH(m_rrThis);

	MoveWindow(&rr);
}

void	FFWPageBase::GetThisRect(RECT& rr)
{
	GetWindowRect(&rr);
	m_pHolder->ScreenToClient(&rr);
}
///------ End FIT_FUNC_BUILDER_NOT_DISPLAY_WELL_WHEN_USE_ENGLISH_ORIGIN_UNDER_COS_AND_JOS

virtual BOOL FFWPageBase::OnKillActiviePage()
{	
	if ( !m_bUpdatePageDone)
		return TRUE;
	
	UpdatePageGUIToTree(m_pHolder->m_trFunction);	
	m_bUpdatePageDone = false;
	return TRUE;
}

//virtual 	
BOOL FFWPageBase::OnNext()
{	
	int nRet = m_pHolder->MarkNextPage(m_PathHelper.RetrieveFromPage(), m_PathHelper.RetrieveToPage(), GetPageID());
	m_PathHelper.RecordToPage(nRet);
	
	return TRUE;
}

//virtual 
BOOL FFWPageBase::OnBack()
{	
	m_pHolder->MarkPreviousPage(m_PathHelper.RetrieveFromPage(), m_PathHelper.RetrieveToPage(), GetPageID());
	
	return TRUE;
}

DWORD FFWPageBase::OnShowStatus(DWORD InternalStatus)
{	
	DWORD	dwTemp;
	if ( m_pHolder->IsExpectedPage(GetPageID()) && m_pHolder->IsEditablePage(GetPageID()) )
		dwTemp = PSS_Show;
	else
		dwTemp = PSS_Ignore;
	//dwTemp = PropertyPage::OnShowStatus(InternalStatus);
	
	return dwTemp;
}

//virtual
string FFWPageBase::GetPageHints(bool bNextPage /* = false*/)
{
	///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT
	string strSection = GetPageHintsName(bNextPage);
	return GetHintsBySection(strSection);
	///End MOVE_FFW_HINTS_TO_TXT
}

string FFWPageBase::GetHintsBySection(LPCSTR lpcSection)
{
	static bool bFirst = true;
	static string strPath;

	if ( bFirst )
	{
		bFirst = false;
		okutil_find_sys_path_with_file(&strPath, STR_FFW_HINTS_TXT, GLOBAL_LOCALIZED_PATH, TRUE);
	}

	string strHints;
	okutil_read_file_section(strPath + STR_FFW_HINTS_TXT, lpcSection, &strHints, NULL); 
	
	return strHints;
}

void FFWPageBase::StringToEditText(const string & str, Edit & edit)
{
	string strTemp = str;
	strTemp.Replace("\n", "\r\n");

	edit.Text = strTemp;
}

void FFWPageBase::EditTextToString(Edit & edit, string & str)
{
	str = edit.Text;
	str.Replace("\r\n", "\n");
}
///Sophy 7/2/2010 ORG-432-S4 SHOW_FUNCTION_NAME_ON_FFW_DIALOG_TITLE
bool FFWPageBase::UpdateDlgTitle(LPCSTR lpcszFunctionName)
{
	vector<string>	vs;
	int		nTokens = str_separate(m_wndParent.Text, STR_DIALOG_TITLE_SEPARATOR, vs);
	if ( nTokens < 2 ) //if only on token, ignore it.
		return false;
	
	if(lstrlen(lpcszFunctionName) < 1)
		vs.SetSize(2);
	else
	{
		vs.SetSize(3);
		vs[2] = lpcszFunctionName;
	}
	m_wndParent.Text = str_combine(vs, STR_DIALOG_TITLE_SEPARATOR);
	return true;
}
///end SHOW_FUNCTION_NAME_ON_FFW_DIALOG_TITLE

int FFWPageBase::MessageBox(LPCSTR lpText, LPCSTR lpCaption, UINT uType)
{
	return MessageBox(GetParent().GetParent().GetSafeHwnd(), lpText, lpCaption, uType);
}

///Jasmine 08/08/2011 ORG-342-S1 ERR_CHECK_FOR_INTEG
//refer to NumFunctionOrganizerEx::correctVarNameList
bool FFWPageBase::checkEditControlValue(Control ctrl, LPCSTR lpczCtrlName, bool bAllowEmpty, string& strErrMsg)
{
	if(!ctrl)
		return false;
	
	string strTemp = ctrl.Text;
	strTemp.TrimLeft();
	strTemp.TrimRight();
	
	//is it empty?
	if( strTemp.IsEmpty() )
	{
		if(!bAllowEmpty)
		{
			//strErrMsg.Format("%s cannot be empty.", lpczCtrlName);
			ocu_load_msg_str(FFWERR_ST_CANNOT_BE_EMPTY, &strErrMsg, lpczCtrlName);
			return false;
		}
		return true;
	}
	
	//is it valid?
	vector<string> vsItem;
	int nCount = strTemp.GetTokens(vsItem, STR_ITEM_SEPARATOR);
	for(int ii = 0; ii < nCount; ii++)
	{
		string strName = vsItem[ii];
		strName.MakeValidCName();
		vsItem[ii] = strName;
	}

	remove_repeat_item(vsItem);
	
	strTemp.SetTokens(vsItem, STR_ITEM_SEPARATOR);
	
	if( strTemp.IsEmpty() )
	{
		strErrMsg.Format("%s are invalid.", lpczCtrlName);
		return false;
	}
	
	if(lstrcmpi(ctrl.Text, strTemp) != 0)
		ctrl.Text = strTemp;
	return true;
}

#define CHECK_EIDT_CONTROL_VALUE(_NAME, _ALLOWEMPTY)		\
	string strErrMsg;										\	
	if(	!checkEditControlValue(ctrl, _NAME, _ALLOWEMPTY, strErrMsg) )\
	{														\
		if( !strErrMsg.IsEmpty() )							\
			MessageBox(strErrMsg, STR_ERROR, MB_OK);\
		return FALSE;										\
	}														\
	return TRUE;

///End ERR_CHECK_FOR_INTEG

/*------------------------------------------------------------------------------*
 * FFWPageBase End			 													*
 *------------------------------------------------------------------------------*/

//---Jacky 7/12/2010 ORG-518-P9 ADD_FFWGOALPAGE
 /*------------------------------------------------------------------------------*
 * FFWGoalPage				 										          	*
 *------------------------------------------------------------------------------*/
class FFWGoalPage : public FFWPageBase
{
private:
	ComboBox  		m_cmbBox;
 	
public:
	FFWGoalPage(int nID = 0) : FFWPageBase(nID){}
	// Event handlers for this page
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)
		PAGE_ON_KILLACTIVE(OnKillActiviePage)
		PAGE_ON_NEXT(OnNext)
		PAGE_ON_BACK(OnBack)
		
		ON_BN_CLICKED(IDC_RADIO_NEW_FUNCTION, OnChoiceChange);
		ON_BN_CLICKED(IDC_RADIO_EDIT_EXIST_FUNC, OnChoiceChange);
	EVENTS_END

	BOOL OnInitPage();
	BOOL OnChoiceChange(Control ctrl);

#ifdef FFW_TEST_SPEED
	BOOL OnActivatePage()
	{
		_SHOW_TIME(GetPageID(), "OnActivatePage")
		return FFWPageBase::OnActivatePage();
	}
	BOOL OnKillActiviePage()
	{
		_SHOW_TIME(GetPageID(), "OnKillActiviePage")
		return FFWPageBase::OnKillActiviePage();
	}
	BOOL OnNext()
	{
		_SHOW_TIME(GetPageID(), "OnNext")
		return FFWPageBase::OnNext();
	}
#endif//FFW_TEST_SPEED

protected:
	//virtual 
	bool 	UpdateTreeToPageGUI(const TreeNode& trFunction){return true;}
	bool 	UpdatePageGUIToTree(TreeNode& trFunction);
	
	string	GetPageHintsName(bool bNextPage = false);
	
	//virtual
	bool	UpdateDlgTitle(LPCSTR lpcszFunctionName){ return FALSE; } ///sophy first page do NOT need to show function name.
};
 
BOOL FFWGoalPage::OnInitPage()
{
	_SHOW_TIME(GetPageID(), "OnInitPage")
	
 	m_cmbBox = GetItem(IDC_COMBO_FUNC_NAME);
 	
 	vector<string> vsFuncs;
 	int nCount = nlsf_get_func_list(ORIGIN_PATH_USER, vsFuncs); 	
 	for(int ii=0;ii<nCount;ii++)
 	{
 		int nRet = m_cmbBox.AddString(vsFuncs[ii]);
 	}
 	///------ Folger 01/28/2011 ORG-2153-P1 ADJUST_WIDTH_OF_OC_COMBOBOX
	if ( nCount > 0 )
	{
		m_cmbBox.AdjustDroppedWidth();
		///------ Folger 07/20/2011 ORG-3257-P1 FFW_SELECT_USER_DEFINED_FDF_DROP_DOWN_LIST_TOO_NARROW
		m_cmbBox.SetDroppedVisibleItemCount();
		///------ End FFW_SELECT_USER_DEFINED_FDF_DROP_DOWN_LIST_TOO_NARROW
	}
 	///------ End ADJUST_WIDTH_OF_OC_COMBOBOX
 	m_cmbBox.SetCurSel(0);
 	
 	
 	int nFFWMode = m_pHolder->GetMode(); 	
 	CheckRadioButton(IDC_RADIO_NEW_FUNCTION, IDC_RADIO_EDIT_EXIST_FUNC, (nFFWMode & FFW_OPTION_MASK) == FFW_OPT_CREATE_NEW? IDC_RADIO_NEW_FUNCTION : IDC_RADIO_EDIT_EXIST_FUNC); 	
 	Control ctrlJunk;
 	OnChoiceChange(ctrlJunk);
 	
 	
    return FFWPageBase::OnInitPage();
}

BOOL FFWGoalPage::OnChoiceChange(Control ctrl)
{	
 	Control ctrText = GetItem(IDC_STATIC_SHOWMSG);
 	
 	int nRadioID = GetCheckedRadioButton(IDC_RADIO_NEW_FUNCTION, IDC_RADIO_EDIT_EXIST_FUNC);
 	if(IDC_RADIO_NEW_FUNCTION == nRadioID)
 	{
 		m_cmbBox.Visible = ctrText.Visible = false;
 		m_pHolder->EnableNextButton(true);
 	}
 	else
 	{
 		m_cmbBox.Visible = m_cmbBox.GetCount() > 0;
 		ctrText.Visible = !m_cmbBox.Visible;
 		m_pHolder->EnableNextButton(m_cmbBox.Visible);
 	}
 	
 	//Sophy 7/15/2010 ORG-545-P7 KEEP_SETTINGS_WHEN_BACK_TO_GOALPAGE_AND_NEXT_WITHOUT_CHANGES this should only be done once when click Next button
	//int nFFWMode = m_pHolder->GetMode(); 	
 	//O_SET_BIT(nFFWMode, FFW_OPT_CREATE_NEW, IDC_RADIO_NEW_FUNCTION == nRadioID);
 	//m_pHolder->SetMode(nFFWMode);
 	///end KEEP_SETTINGS_WHEN_BACK_TO_GOALPAGE_AND_NEXT_WITHOUT_CHANGES
 	return TRUE;
}

bool FFWGoalPage::UpdatePageGUIToTree(TreeNode& trFunction)
{
	///Sophy 7/15/2010 ORG-545-P7 KEEP_SETTINGS_WHEN_BACK_TO_GOALPAGE_AND_NEXT_WITHOUT_CHANGES
	int nOldMode = m_pHolder->GetMode();
	int nNewMode = FFW_CREATE_OR_EDIT;
	
	int nRadioID = GetCheckedRadioButton(IDC_RADIO_NEW_FUNCTION, IDC_RADIO_EDIT_EXIST_FUNC);
	O_SET_BIT(nNewMode, FFW_OPT_CREATE_NEW, IDC_RADIO_NEW_FUNCTION == nRadioID);
	if ( O_QUERY_BOOL(nOldMode, FFW_OPT_CREATE_NEW) && nOldMode == nNewMode ) //new function
		return false;
	///end KEEP_SETTINGS_WHEN_BACK_TO_GOALPAGE_AND_NEXT_WITHOUT_CHANGES
	
 	if (IDC_RADIO_EDIT_EXIST_FUNC == nRadioID )
 	{
 		Tree trFDF;
 		Control ctrlCombo = GetItem(IDC_COMBO_FUNC_NAME);
 		string strFDFName = ctrlCombo.Text;
 		string strFDFFile;
 		string	strCategory;
 		///Sophy 7/15/2010 ORG-545-P7 KEEP_SETTINGS_WHEN_BACK_TO_GOALPAGE_AND_NEXT_WITHOUT_CHANGES
 		if ( nOldMode == nNewMode )
 		{
	 		string strOldFDFName = FuncOrganizer().GetFunctionName(trFunction);
	 		if ( strFDFName.CompareNoCase(strOldFDFName) == 0 ) //edit same FDF
	 			return false;
 		}
 		///end KEEP_SETTINGS_WHEN_BACK_TO_GOALPAGE_AND_NEXT_WITHOUT_CHANGES
 		if ( !nlf_get_fdf_filename(strFDFName, &strCategory, NULL, &strFDFFile) || 	
 			/// Iris 11/18/2010 ORG-1446-P1 STILL_NO_ERR_MSG_SHOW_WHEN_FAIL_TO_READ_FDFFILE
 			//!nlsf_load_FDF_to_tree(strFDFFile, &trFDF, FDFT_CONVERT_BOOL_TO_01, true))
 			(FDFERR_NO_ERROR != nlsf_load_FDF_to_tree(strFDFFile, &trFDF, FDFT_CONVERT_BOOL_TO_01, true)))
 			///End STILL_NO_ERR_MSG_SHOW_WHEN_FAIL_TO_READ_FDFFILE
 			return false;
 		//--- Jacky 7/14/2010 ORG-545-P2 FIX_CATEGORY_ALWAYS_THE_LAST_USED_ONE
 		trFDF.SetAttribute(STR_CATEGORY_ATTRIB, strCategory);
 		//--- end FIX_CATEGORY_ALWAYS_THE_LAST_USED_ONE
 		trFDF.SetAttribute(STR_FILENAME_ATTRIB, strFDFFile);
 			
 		trFunction = trFDF.Clone();
 	}
 	else
 	{
 		if(trFunction.FirstNode)
 			trFunction.Reset();
 	}
 	m_pHolder->SetMode(nNewMode);	///Sophy 7/15/2010 ORG-545-P7 KEEP_SETTINGS_WHEN_BACK_TO_GOALPAGE_AND_NEXT_WITHOUT_CHANGES
 	
 	return true;
}

string FFWGoalPage::GetPageHintsName(bool bNextPage/* = false*/)
{
	return "Goal";
}
 /*------------------------------------------------------------------------------*
 * FFWGoalPage End			 										         	*
 *------------------------------------------------------------------------------*/
//---end ADD_FFWGOALPAGE 
 
/*------------------------------------------------------------------------------*
 * FFWNameTypePage		 														*
 *------------------------------------------------------------------------------*/ 
class FFWNameTypePage : public FFWPageBase
{
public:
	FFWNameTypePage(int nID = 0) : FFWPageBase(nID){}
	
	bool	IsCheckFitWithInteg();	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
				
	// Event handlers for this page
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)
		PAGE_ON_KILLACTIVE(OnKillActiviePage)
		PAGE_ON_NEXT(OnNext)
		PAGE_ON_BACK(OnBack)		
		
		ON_BN_CLICKED(IDC_FIT_FUNC_NEW_CATEGORY, OnNewCategory);
		
		ON_EN_KILLFOCUS(IDC_FIT_FUNC_NAME, OnAfterEditFunctionName)
		
		ON_BN_CLICKED(IDC_RADIO_SINGLE_EQUATION, OnTypeRadioClidk)
		ON_BN_CLICKED(IDC_RADIO_MULTI_EQUATION, OnTypeRadioClidk)
		
		///Junon 08/17/2012 ORG-5003 DISABLE_PEAK_FUNCTION_CHECKBOX_AND_INTEGRATION_CHEXKBOX_FOR_IMPLICT_FUNCTION
		ON_BN_CLICKED(IDC_RADIO_IMPLICIT, OnTypeRadioClidk)
		ON_BN_CLICKED(IDC_RADIO_EXPLICIT, OnTypeRadioClidk)
		///End DISABLE_PEAK_FUNCTION_CHECKBOX_AND_INTEGRATION_CHEXKBOX_FOR_IMPLICT_FUNCTION
#ifdef	INTEGRAL_CONVOLUTION_READY_IN_FFW	///Jasmine 06/17/10 ORG-2 TURN_OFF_UNTIL_INTEGRAL_CONVOLUTION_READY
		ON_BN_CLICKED(IDC_RADIO_FIT_INTEGRAL, OnTypeRadioClidk)
		ON_BN_CLICKED(IDC_RADIO_FIT_CONVOLUTION, OnTypeRadioClidk)
#endif//INTEGRAL_CONVOLUTION_READY_IN_FFW
		ON_BN_CLICKED(IDC_RADIO_LABTALK, OnTypeRadioClidk)
		ON_BN_CLICKED(IDC_RADIO_ORIGIN_C, OnTypeRadioClidk)
		ON_BN_CLICKED(IDC_RADIO_EXTERNAL_DLL, OnTypeRadioClidk)
		ON_BN_CLICKED(IDC_RADIO_FIT_INTEGRAL, OnCheckIncludeInteg)		///Jasmine 08/23/2011 ADD_INCLUDE_INTEGRATION_HINT
	EVENTS_END

	BOOL OnInitPage();
	BOOL OnActivatePage();
	///Sophy 7/14/2010 ORG-545 BACK_AND_FORTH_WITH_GOALPAGE_INCRE_FDF_FILENAME_SUFFIX
	//virtual
	BOOL OnBack();
	///end BACK_AND_FORTH_WITH_GOALPAGE_INCRE_FDF_FILENAME_SUFFIX
	BOOL OnNext();
	
#ifdef FFW_TEST_SPEED
	BOOL OnKillActiviePage()
	{
		_SHOW_TIME(GetPageID(), "OnKillActiviePage")
		return FFWPageBase::OnKillActiviePage();
	}
#endif//FFW_TEST_SPEED
		
	void OnNewCategory(Control ctrl);
	
	BOOL OnAfterEditFunctionName(Control ctrl);

	string	GetCategory();///Jasmine 07/09/10 ORG-2-P11 REMEMBER_LAST_USE_CATEGORY
	
	void	DisableCategory();		///------ Tony 08/28/2012 ORG-3079-S1 SET_BIT_TO_DISABLE_CATEGORY
	
	void	OnCheckIncludeInteg(Control ctrl);		///Jasmine 08/23/2011 ADD_INCLUDE_INTEGRATION_HINT
	
	void 	OnTypeRadioClidk(Control ctrl);
	
protected:
	void SetRadioCheck(int nRadioID);
	void SetFuncModelRadio(int nFuncModel); /// Iris 2/07/2012 ORG-4412-S3 FIT_FUNC_WIZARD_CHANGE_INDEP_DEP_VAR_CONTROLS_FOR_IMPLICIT_FUNC

	string GetName(){return "FFWNameTypePage";}

protected:
	//virtual 
	bool 	UpdateTreeToPageGUI(const TreeNode& trFunction);
	//virtual 
	bool 	UpdatePageGUIToTree(TreeNode& trFunction);
	//virtual 
	string	GetPageHintsName(bool bNextPage = false);///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT
	//virtual
	string 	GetPageHints(bool bNextPage = false);		///Jasmine 08/23/2011 ADD_INCLUDE_INTEGRATION_HINT
	
	bool 	initCategoryList();
	bool 	isCategorySeparator(const string & str);
	
private:
	bool	checkFunctionName(string& strErrMsg);
	
	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	void	updateCheckBoxStatus(int nRadioID);
	///End CREATE_FITFUNC_WITH_INTEGRAL
	
private:
	ComboBox 	m_comboCategory;
	Control 	m_edFunction;
	Control		m_edDescrip;
	
	string 		m_strNewCategory;
	
	int			m_nRadioID;
	string		m_strFDFName;	///Sophy 7/14/2010 ORG-518-P5 SMART_DISPLAY_FITTING_FUNCTION_FILENAME_WHEN_IN_UFF
};

BOOL FFWNameTypePage::OnInitPage()
{
	_SHOW_TIME(GetPageID(), "OnInitPage")
#ifndef	INTEGRAL_CONVOLUTION_READY_IN_FFW
	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	/*
	Control ctrl = GetItem(IDC_RADIO_FIT_INTEGRAL);
	if ( ctrl)
		ctrl.Visible = false;
	*/
	///End CREATE_FITFUNC_WITH_INTEGRAL
	Control ctrl = GetItem(IDC_RADIO_FIT_CONVOLUTION);
	if ( ctrl)
		ctrl.Visible = false;
#endif//INTEGRAL_CONVOLUTION_READY_IN_FFW
	m_comboCategory = GetItem(IDC_FIT_FUNC_CATEGORY);
	if ( !m_comboCategory )
		return FALSE;
	
	if ( !initCategoryList() )
		return FALSE;

	m_edFunction = GetItem(IDC_FIT_FUNC_NAME);
	if ( !m_edFunction )
		return FALSE;

	m_edDescrip		= GetItem(IDC_FIT_FUNC_DESCRIPTION);
	if ( !m_edDescrip )
		return FALSE;
	
	///Jasmine 06/23/10 ORG-2-S6 WANT_FILE_PATH_TO_DISPLAY
	RichEdit edit = GetItem(IDC_FIT_FUNC_FILE);
	if ( edit)
		edit.SetReadOnly();
	///End WANT_FILE_PATH_TO_DISPLAY
	
	/// Iris 7/03/2012 ORG-6109-S4 DISABLE_IMPLICIT_FUNC_OPTIONS_IN_FIT_FUNC_WIZ
	if( !is_pro_version() )
	{
		Control ctrlExplicit = GetItem(IDC_RADIO_EXPLICIT);
		Control ctrlImplicit = GetItem(IDC_RADIO_IMPLICIT);
		if( ctrlExplicit && ctrlImplicit )
		{
			ctrlExplicit.Enable = 
			ctrlImplicit.Enable = 
			false;
		}
	}
	///End DISABLE_IMPLICIT_FUNC_OPTIONS_IN_FIT_FUNC_WIZ
	return FFWPageBase::OnInitPage();
}
BOOL FFWNameTypePage::OnActivatePage()
{
	_SHOW_TIME(GetPageID(), "OnActivatePage")
	
	/// Bill 07/05/2010 ORG-478-P3 CHECK_CREATE_OR_EDIT_FUNCTION
	//if ( m_pHolder->IsEditMode() )
	bool bEditMode = m_pHolder->IsEditMode();
	{
		m_comboCategory.Enable = !bEditMode;
		m_edFunction.Enable = !bEditMode;

		Control bnNewCategory = GetItem(IDC_FIT_FUNC_NEW_CATEGORY);
		bnNewCategory.Enable = !bEditMode;
	}
	/// End CHECK_CREATE_OR_EDIT_FUNCTION
	
	DisableCategory();		///------ Tony 08/28/2012 ORG-3079-S1 SET_BIT_TO_DISABLE_CATEGORY
	
	/// Zech 09/27/2011 ORG-3577-S1 OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
	string strCategory = m_pHolder->GetOpenedCategory();
	if (m_pHolder->IsNewCategory())
	{
		PostMessage(WM_COMMAND, MAKELONG(IDC_FIT_FUNC_NEW_CATEGORY, BN_CLICKED));
		
		// will not open New Category box again next time
		m_pHolder->SetIsNewCategory(false);
		m_pHolder->SetOpenedCategory("");
	}
	if (strCategory.GetLength())
		m_comboCategory.SelectString(0, strCategory);
	/// END OPEN_FFW_WHEN_CLICK_DROPDOWN_LIST_ITEM_TO_CREATE_NEW_CATEGORY_AND_NEW_FUNCTION
	
	return FFWPageBase::OnActivatePage();
}

///Sophy 7/14/2010 ORG-545 BACK_AND_FORTH_WITH_GOALPAGE_INCRE_FDF_FILENAME_SUFFIX
BOOL FFWNameTypePage::OnBack()
{	
	if ( m_pHolder->IsCreateMode() )
	{
		DeleteFile(m_strFDFName);
	}
	return FFWPageBase::OnBack();
}
///end BACK_AND_FORTH_WITH_GOALPAGE_INCRE_FDF_FILENAME_SUFFIX
	
BOOL FFWNameTypePage::OnNext()
{	
	string strErrMsg;

	/// Bill 07/05/2010 ORG-478-P3 CHECK_CREATE_OR_EDIT_FUNCTION
	//if ( !checkFunctionName(strErrMsg) )
	if ( m_pHolder->IsCreateMode() && !checkFunctionName(strErrMsg) )
	/// End CHECK_CREATE_OR_EDIT_FUNCTION
	{		
		if ( !strErrMsg.IsEmpty() )
			MessageBox(strErrMsg, STR_ERROR, MB_OK);
		
		return FALSE;
	}

	return FFWPageBase::OnNext();
}

void FFWNameTypePage::OnNewCategory(Control ctrl)
{
	while (1)
	{
		GETN_BOX(tr)
		GETN_AUTO_SAVE_BRANCH_OPEN(1) /// Iris 7/04/2012 ORG-6033-P1 TO_PREVENT_GETN_AUTO_SAVE_BRANCH_OPEN_STATUS_TO_REG

		GETN_STR(Input, _L("Name"), m_strNewCategory)	GETN_EDIT_DISPLAY_WIDTH_RANGE( "30-30" )

		if ( !GetNBox(tr, _L("Category Name"), NULL, NULL, NULL, GetParent().GetParent().GetSafeHwnd()) )
			break;

		string & strNewCategory = tr.Input.strVal;

		if ( FuncOrganizer().IsCategoryExist(strNewCategory) )
		{
			MessageBox(_L("This category already exists."), STR_ERROR, MB_OK);
		}
		else
		{
			// Delete Older New Category Name In The Draw List
			if ( !m_strNewCategory.IsEmpty() )
				m_comboCategory.DeleteString(m_comboCategory.GetCount() - 1);

			m_strNewCategory = strNewCategory;
			m_comboCategory.AddString(strNewCategory);
			m_comboCategory.SelectString(-1, strNewCategory);

			break;
		}
	}
}

///Jasmine 09/15/10 ORG-1056-P1 PREVENT_DELETE_THE_SAME_OLD_NAME_FILE
static	void	_check_remove_attribute(TreeNode& tr, LPCTSTR lpcszAttr1, LPCTSTR lpcszAttr2)
{
	string		str1, str2;
	tr.GetAttribute(lpcszAttr1, str1);
	tr.GetAttribute(lpcszAttr2, str2);
	if ( str1.CompareNoCase(str2) == 0 )
		tr.RemoveAttribute(lpcszAttr2);	
}
///End PREVENT_DELETE_THE_SAME_OLD_NAME_FILE

BOOL FFWNameTypePage::OnAfterEditFunctionName(Control ctrl)
{
	string strErrMsg;
	///Jasmine 08/17/10 ORG-745-P5 SHARE_FO_NAME_CHECKING_CODE
	//bool bGoodName = checkFunctionName(strErrMsg);
	
	//if ( bGoodName)
	///End SHARE_FO_NAME_CHECKING_CODE
	{
		string strNewFunction = m_edFunction.Text;
		///------ Folger 06/24/10 ORG-390-P3 FDF_FILE_NAME_SHOULD_UPDATE_AFTER_FUNCTION_NAME_CHANGED
		string	strFile;
		
		///Jasmine 08/17/10 ORG-745-P5 SHARE_FO_NAME_CHECKING_CODE
		bool bRet = FuncOrganizer().CheckUpdateFuncName(strNewFunction, m_pHolder->m_trFunction, &strErrMsg, &strFile);
		if(!bRet)
		{
			if( !strErrMsg.IsEmpty() )
				MessageBox(strErrMsg, _L("Warning"), MB_OK);
			
			///Jasmine 08/18/10 ORG-745-P5 AUTO_CORRECT_INVALID_FUNCTION_NAME
			string strCorrectName = FuncOrganizer().GetFunctionName(m_pHolder->m_trFunction);
			if ( m_edFunction.Text != strCorrectName )
				m_edFunction.Text = strCorrectName;
			///End AUTO_CORRECT_INVALID_FUNCTION_NAME
			
			return FALSE;
		}
		///End SHARE_FO_NAME_CHECKING_CODE

		///Jasmine 09/15/10 ORG-1056-P1 PREVENT_DELETE_THE_SAME_OLD_NAME_FILE
		_check_remove_attribute(m_pHolder->m_trFunction, STR_LABEL_ATTRIB, STR_CHANGED_ATTRIB);
		_check_remove_attribute(m_pHolder->m_trFunction, STR_FILENAME_ATTRIB, STR_OLDFILENAME_ATTRIB);
		///End PREVENT_DELETE_THE_SAME_OLD_NAME_FILE
			
		///Sophy 7/14/2010 ORG-518-P5 SMART_DISPLAY_FITTING_FUNCTION_FILENAME_WHEN_IN_UFF
		//GetItem(IDC_FIT_FUNC_FILE).Text = strFile;
		m_strFDFName = strFile;
		int nPathType = okutil_get_origin_path_type(GetFilePath(strFile), TRUE);
		if ( nPathType == ORIGIN_PATH_USER )
			strFile = GetFileName(strFile);
		GetItem(IDC_FIT_FUNC_FILE).Text = strFile;
		///end SMART_DISPLAY_FITTING_FUNCTION_FILENAME_WHEN_IN_UFF
		///------ End FDF_FILE_NAME_SHOULD_UPDATE_AFTER_FUNCTION_NAME_CHANGED
		UpdateDlgTitle(strNewFunction);	///Sophy 7/7/2010 ORG-432-S4 SHOW_FUNCTION_NAME_ON_FFW_DIALOG_TITLE

		/// Bill 07/08/2010 ORG-2-P10 DISPLAY_NEW_FUNCTION_NAME_THAT_TRIMED_SPACE
		string strCorrectName = FuncOrganizer().GetFunctionName(m_pHolder->m_trFunction);
		if ( m_edFunction.Text != strCorrectName )
		{
			///Jasmine 03/11/11 ORG-2418-S1 SPACE_TRIM_MSG_NOT_CORRECT_SINCE_DASH_TRIM
			//MessageBox(_L("The spaces in the function name have been trimed."), _L("Warning"), MB_OK);
			MessageBox(_L("The function name has been trimmed."), _L("Warning"), MB_OK);
			///End SPACE_TRIM_MSG_NOT_CORRECT_SINCE_DASH_TRIM
			m_edFunction.Text = strCorrectName;
		}
		/// End DISPLAY_NEW_FUNCTION_NAME_THAT_TRIMED_SPACE
	}
		
	if ( !strErrMsg.IsEmpty() )
		MessageBox(strErrMsg, STR_ERROR, MB_OK);
	
	return TRUE;
}

///Jasmine 07/09/10 ORG-2-P11 REMEMBER_LAST_USE_CATEGORY
string FFWNameTypePage::GetCategory()
{
	return m_comboCategory? m_comboCategory.Text : "";
}
///End REMEMBER_LAST_USE_CATEGORY

///------ Tony 08/28/2012 ORG-3079-S1 SET_BIT_TO_DISABLE_CATEGORY
void FFWNameTypePage::DisableCategory()
{	
	if(!m_pHolder->IsEditMode())
	{
		bool bDisableCategory = m_pHolder->IsDisableCategory();
		m_comboCategory.Enable = !bDisableCategory;
		Control bnNewCategory = GetItem(IDC_FIT_FUNC_NEW_CATEGORY);
		bnNewCategory.Enable = !bDisableCategory;
	}
}
///------ End SET_BIT_TO_DISABLE_CATEGORY

///Jasmine 08/23/2011 ADD_INCLUDE_INTEGRATION_HINT
void FFWNameTypePage::OnCheckIncludeInteg(Control ctrl)
{
	SetHints(GetPageHints());
}
///End ADD_INCLUDE_INTEGRATION_HINT

void FFWNameTypePage::OnTypeRadioClidk(Control ctrl)
{
	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	//Jasmine 08/10/2011 ORG-3484-S5 HIDE_IMPLICIT_CHECKBOX
	//int nRadio = GetCheckedRadioButton(IDC_RADIO_SINGLE_EQUATION, IDC_RADIO_FIT_CONVOLUTION);
	int nRadio = GetCheckedRadioButton(IDC_RADIO_SINGLE_EQUATION, IDC_RADIO_EXTERNAL_DLL);
	///End HIDE_IMPLICIT_CHECKBOX
	updateCheckBoxStatus(nRadio);
	///End CREATE_FITFUNC_WITH_INTEGRAL
	
	SetHints(GetPageHints());
}

void FFWNameTypePage::SetRadioCheck(int nRadioID)
{
	//Jasmine 08/10/2011 ORG-3484-S5 HIDE_IMPLICIT_CHECKBOX
	//CheckRadioButton(IDC_RADIO_SINGLE_EQUATION, IDC_RADIO_FIT_CONVOLUTION, nRadioID);
	CheckRadioButton(IDC_RADIO_SINGLE_EQUATION, IDC_RADIO_EXTERNAL_DLL, nRadioID);
	///End HIDE_IMPLICIT_CHECKBOX
}

/// Iris 2/07/2012 ORG-4412-S3 FIT_FUNC_WIZARD_CHANGE_INDEP_DEP_VAR_CONTROLS_FOR_IMPLICIT_FUNC
void FFWNameTypePage::SetFuncModelRadio(int nFuncModel)
{	
	CheckRadioButton(IDC_RADIO_EXPLICIT, IDC_RADIO_IMPLICIT, IDC_RADIO_EXPLICIT + nFuncModel);
}
///End FIT_FUNC_WIZARD_CHANGE_INDEP_DEP_VAR_CONTROLS_FOR_IMPLICIT_FUNC

//virtual
bool FFWNameTypePage::UpdateTreeToPageGUI(const TreeNode& trFunction)
{	
	// Category Name
	string strCategory;
	trFunction.GetAttribute(STR_CATEGORY_ATTRIB, strCategory);
	///Jasmine 06/18/10 ORG-2-S1 ADD_NEW_CATEGORY_NAME_USER_DEFINED
	if( strCategory.IsEmpty() )
	{
		///Jasmine 07/09/10 ORG-2-P11 REMEMBER_LAST_USE_CATEGORY
		//strCategory = "User Defined";	
		string strDefault = "User Defined";
		dlg_load_registry(STR_FFW_DLG_NAME, STR_FFW_DLG_CATEGORY, strCategory, strDefault);
		if(strCategory.IsEmpty())
			strCategory = strDefault;
		///End REMEMBER_LAST_USE_CATEGORY
	}
	
	int nRet = m_comboCategory.SelectString(-1, strCategory);
	if ( nRet == -1 )
		nRet = m_comboCategory.SelectString(-1, "Origin Basic Functions");
	if ( nRet == -1 )
		m_comboCategory.SetCurSel(0);
	///End ADD_NEW_CATEGORY_NAME_USER_DEFINED
	
	// Function Name
	string strFunction = FuncOrganizer().GetFunctionName(trFunction);	
	if ( strFunction.IsEmpty() )
	{		
		strFunction = FuncOrganizer().CreateNewFunctionName(STR_LABEL_ATTRIB, STR_NEW_FUNCTION_PREFIX, " (User)");
	}
	m_edFunction.Text = strFunction;
	
	/// Bill 07/05/2010 ORG-478-P3 CHECK_CREATE_OR_EDIT_FUNCTION
	/////Sophy 7/2/2010 ORG-432-P1 MORE_WORK_ON_CHECK_EXIST_IN_USER_DEFINED_FUNCTION_CATEGORY
	//string strChkCateg = FuncOrganizer().FindFunctionCategory(strFunction);
	//if ( !strChkCateg.IsEmpty() )
	//{
		//m_edFunction.Enable = false;
	//}
	/////end MORE_WORK_ON_CHECK_EXIST_IN_USER_DEFINED_FUNCTION_CATEGORY
	///End CHECK_CREATE_OR_EDIT_FUNCTION
	
	//Description
	m_edDescrip.Text = FuncOrganizer().GetDescription(trFunction);
	
	//Function Type
	string strType = FuncOrganizer().GetType(trFunction);
	if ( STR_FUNCTION_TYPE_EXTERN_DLL == strType )
		m_nRadioID = IDC_RADIO_EXTERNAL_DLL;
	else
	{
		string strForm = FuncOrganizer().GetForm(trFunction);

		if ( strForm.CompareNoCase(STR_FUNCTION_FORM_EXPRESSION) == 0 )
			m_nRadioID = IDC_RADIO_SINGLE_EQUATION;
		else if ( strForm.CompareNoCase(STR_FUNCTION_FORM_EQUATIONS) == 0 )
			m_nRadioID = IDC_RADIO_MULTI_EQUATION;
		else if ( strForm.CompareNoCase(STR_FUNCTION_FORM_Y_SCRIPT) == 0 )
			m_nRadioID = IDC_RADIO_LABTALK;
		else if ( strForm.CompareNoCase(STR_FUNCTION_FORM_ORIGIN_C) == 0 )
			m_nRadioID = IDC_RADIO_ORIGIN_C;
		else
			m_nRadioID = IDC_RADIO_SINGLE_EQUATION;
	}
	SetRadioCheck(m_nRadioID);
	
	/// Iris 2/07/2012 ORG-4412-S3 FIT_FUNC_WIZARD_CHANGE_INDEP_DEP_VAR_CONTROLS_FOR_IMPLICIT_FUNC
	int nFuncModel = nlsf_get_func_model(trFunction);
	SetFuncModelRadio(nFuncModel);
	///End FIT_FUNC_WIZARD_CHANGE_INDEP_DEP_VAR_CONTROLS_FOR_IMPLICIT_FUNC
	
	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	updateCheckBoxStatus(m_nRadioID);
	
	Button btnIntegral = GetItem(IDC_RADIO_FIT_INTEGRAL);
	if(btnIntegral && btnIntegral.Enable)
	{
		bool bCheck = false;
		int nRet = FuncOrganizer().ReadTempWithIntegState(trFunction);
		if(nRet == -1)
		{
			string strBody = FuncOrganizer().GetFormula(trFunction);
			bCheck = FuncOrganizer().IntegralLTPos(strBody) >= 0;
		}
		else
			bCheck = nRet;
		btnIntegral.Check = bCheck;
	}
	///End CREATE_FITFUNC_WITH_INTEGRAL

	///Jasmine 06/23/10 ORG-2-S6 WANT_FILE_PATH_TO_DISPLAY
	//new function's form is Origin C, but in wizard function should be expression by default.
	//therefore I put NewFunction() after GetForm()
	if ( !trFunction.FirstNode)
		FuncOrganizer().NewFunction(trFunction, strFunction);
	
	//File Name
	string strFullPathFileName;
	trFunction.GetAttribute(STR_FILENAME_ATTRIB, strFullPathFileName);
	///Sophy 7/12/2010 ORG-518-P5 SMART_DISPLAY_FITTING_FUNCTION_FILENAME_WHEN_IN_UFF
	//GetItem(IDC_FIT_FUNC_FILE).Text = strFullPathFileName;
	m_strFDFName = strFullPathFileName;	///Sophy 7/14/2010 ORG-518-P5 SMART_DISPLAY_FITTING_FUNCTION_FILENAME_WHEN_IN_UFF
	int nPathType = okutil_get_origin_path_type(GetFilePath(strFullPathFileName), TRUE);
	if ( nPathType == ORIGIN_PATH_USER )
		strFullPathFileName = GetFileName(strFullPathFileName);
	GetItem(IDC_FIT_FUNC_FILE).Text = strFullPathFileName;
	///end SMART_DISPLAY_FITTING_FUNCTION_FILENAME_WHEN_IN_UFF
	///End WANT_FILE_PATH_TO_DISPLAY
	
	
	//for other page
	///Jasmine 08/17/10 ORG-745-P7 COPY_DERIVED_PARAM_SETTINGS_FROM_EQUATION_FOR_OLD_FDF
	FuncOrganizer().CvtDerivedParameterNames(trFunction);
	///END COPY_DERIVED_PARAM_SETTINGS_FROM_EQUATION_FOR_OLD_FDF
	
	return true;
}

//virtual 
bool FFWNameTypePage::UpdatePageGUIToTree(TreeNode& trFunction)
{	
	string strCategory = m_comboCategory.Text;
	string strFunction = m_edFunction.Text;
	string strDescrip = m_edDescrip.Text;
	
	if ( strFunction.Compare( FuncOrganizer().GetFunctionName(trFunction) )!= 0)
		FuncOrganizer().SetFunctionName(strFunction, trFunction);
	
	trFunction.SetAttribute(STR_CATEGORY_ATTRIB, strCategory);
	FuncOrganizer().SetDescription(strDescrip, trFunction);
	/*doing
	m_NFO.SetFuncFileName(trFunctionNew, strFilePath);
		m_NFO.SetLabel( trFunctionNew, nfo.GetFunctionNameStr(strName, USER_FOLDER) );*/
	
	///------ Folger 06/24/10 ORG-390-P3 FDF_FILE_NAME_SHOULD_UPDATE_AFTER_FUNCTION_NAME_CHANGED
	///Sophy 7/14/2010 ORG-518-P5 SMART_DISPLAY_FITTING_FUNCTION_FILENAME_WHEN_IN_UFF
	//trFunction.SetAttribute(STR_FILENAME_ATTRIB, GetItem(IDC_FIT_FUNC_FILE).Text);
	trFunction.SetAttribute(STR_FILENAME_ATTRIB, m_strFDFName);
	///end SMART_DISPLAY_FITTING_FUNCTION_FILENAME_WHEN_IN_UFF
	///------ End FDF_FILE_NAME_SHOULD_UPDATE_AFTER_FUNCTION_NAME_CHANGED
	
	string strFuncType = STR_FUNCTION_TYPE_USER_DEFINE;
	string strFuncForm;
	string strFuncSource = STR_NO_DLL_SOURCE;
	
	//Jasmine 08/10/2011 ORG-3484-S5 HIDE_IMPLICIT_CHECKBOX
	//int nRadioID = GetCheckedRadioButton(IDC_RADIO_SINGLE_EQUATION, IDC_RADIO_FIT_CONVOLUTION);
	int nRadioID = GetCheckedRadioButton(IDC_RADIO_SINGLE_EQUATION, IDC_RADIO_EXTERNAL_DLL);
	///End HIDE_IMPLICIT_CHECKBOX
	switch(nRadioID)
	{
	case IDC_RADIO_SINGLE_EQUATION:
		strFuncForm = STR_FUNCTION_FORM_EXPRESSION;
		break;
	case IDC_RADIO_MULTI_EQUATION:
		strFuncForm = STR_FUNCTION_FORM_EQUATIONS;
		break;
#ifdef	INTEGRAL_CONVOLUTION_READY_IN_FFW
	case IDC_RADIO_FIT_INTEGRAL:
	case IDC_RADIO_FIT_CONVOLUTION:
		break;
#endif//INTEGRAL_CONVOLUTION_READY_IN_FFW
	case IDC_RADIO_LABTALK:
		strFuncForm = STR_FUNCTION_FORM_Y_SCRIPT;
		break;
	case IDC_RADIO_ORIGIN_C:
		strFuncForm = STR_FUNCTION_FORM_ORIGIN_C;
		break;
	case IDC_RADIO_EXTERNAL_DLL:
		strFuncType = STR_FUNCTION_TYPE_EXTERN_DLL;
		strFuncForm = STR_FUNCTION_FORM_EXPRESSION;
		strFuncSource = "";//set in external dll page
		break;
	default:
		ASSERT(FALSE);
		return false;
	}
	
	/// Iris 2/07/2012 ORG-4412-S3 FIT_FUNC_WIZARD_CHANGE_INDEP_DEP_VAR_CONTROLS_FOR_IMPLICIT_FUNC
	string strFuncModel;
	nRadioID = GetCheckedRadioButton(IDC_RADIO_EXPLICIT, IDC_RADIO_IMPLICIT);
	if( IDC_RADIO_IMPLICIT == nRadioID )
	{
		strFuncModel = STR_FUNC_MODEL_IMPLICIT;
	}
	else
	{
		ASSERT( IDC_RADIO_EXPLICIT == nRadioID );
		strFuncModel = STR_FUNC_MODEL_EXPLICIT;
	}	
	FuncOrganizer().SetFunctionModel(strFuncModel, trFunction);
	///End FIT_FUNC_WIZARD_CHANGE_INDEP_DEP_VAR_CONTROLS_FOR_IMPLICIT_FUNC
	
	FuncOrganizer().SetType(strFuncType, trFunction);
	FuncOrganizer().SetForm(strFuncForm, trFunction);
	if ( !strFuncSource.IsEmpty() )
		FuncOrganizer().SetSource(strFuncSource, trFunction);
	FuncOrganizer().UpdateCompileState(trFunction);
	
	///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
	FuncOrganizer().TempRecordWithIntegState( trFunction, IsCheckFitWithInteg() );
	///End CREATE_FITFUNC_WITH_INTEGRAL
	
	return true;
}

///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT
//virtual 
string FFWNameTypePage::GetPageHintsName(bool bNextPage/* = false*/)
{
	if ( bNextPage )
		return "Name and Type next page";
	
	//Jasmine 08/10/2011 ORG-3484-S5 HIDE_IMPLICIT_CHECKBOX	
	//int nRadio = GetCheckedRadioButton(IDC_RADIO_SINGLE_EQUATION, IDC_RADIO_FIT_CONVOLUTION);
	int nRadio = GetCheckedRadioButton(IDC_RADIO_SINGLE_EQUATION, IDC_RADIO_EXTERNAL_DLL);
	///End HIDE_IMPLICIT_CHECKBOX
	string strHintsName;
	
	switch (nRadio)
	{
		case IDC_RADIO_SINGLE_EQUATION:
			strHintsName = "Function Type: Single-line Expression";
			break;
		case IDC_RADIO_MULTI_EQUATION:
			strHintsName = "Function Type: Equations";
			break;
#ifdef	INTEGRAL_CONVOLUTION_READY_IN_FFW
		case IDC_RADIO_FIT_INTEGRAL:
			strHintsName = "Function Type: Fitting with Integral";
			break;
		case IDC_RADIO_FIT_CONVOLUTION:
			strHintsName = "Function Type: Fitting with Convolution";
			break;
#endif//INTEGRAL_CONVOLUTION_READY_IN_FFW
		case IDC_RADIO_LABTALK:
			strHintsName = "Function Type: LabTalk Script";
			break;
		case IDC_RADIO_ORIGIN_C:
			strHintsName = "Function Type: Origin C";
			break;
		case IDC_RADIO_EXTERNAL_DLL:
			strHintsName = "Function Type: External DLL";
			break;
		default:
			ASSERT(FALSE);
	}
	
	return strHintsName;	
}
///End MOVE_FFW_HINTS_TO_TXT

///Jasmine 08/23/2011 ADD_INCLUDE_INTEGRATION_HINT
//virtual
string FFWNameTypePage::GetPageHints(bool bNextPage /* = false*/)
{
	Button btnIntegral = GetItem(IDC_RADIO_FIT_INTEGRAL);
		
	string strHint = FFWPageBase::GetPageHints(bNextPage);
	if ( !bNextPage )
	{
		if(btnIntegral && btnIntegral.Enable && btnIntegral.Check)
		{
			string strPath;	
			okutil_find_sys_path_with_file(&strPath, STR_FFW_HINTS_TXT, GLOBAL_LOCALIZED_PATH, TRUE);
			
			string strIntegkHint;
			okutil_read_file_section(strPath + STR_FFW_HINTS_TXT, "Include Integration", &strIntegkHint, NULL); 
			
			strHint += "\r\n\r\n" + strIntegkHint;
		}
	}
	
	return strHint;
}
///End ADD_INCLUDE_INTEGRATION_HINT

bool FFWNameTypePage::initCategoryList()
{
	if ( !m_comboCategory)
		return false;
	
	vector<string> vsItems;
	int nSize = nlsf_get_category_list(vsItems);
	
	///------ Tony 08/28/2012 ORG-3079-S2 REMOVE_SURFACE_PFW_BASELINE_IMPLICIT_FROM_CATEGORY_LIST
	if(m_pHolder->IsRemoveReserveCategory())
	{
		vector<string>	vsCatsRemove;
		string strCateReserve = STR_CATE_RESERVE;
		strCateReserve.GetTokens(vsCatsRemove, '|');
		vsCatsRemove.Add(STR_CATE_NAME_IMPLICIT);
		remove_if_in_list(vsItems, vsCatsRemove);
	}
	nSize = vsItems.GetSize();
	///------ End REMOVE_SURFACE_PFW_BASELINE_IMPLICIT_FROM_CATEGORY_LIST
	
	m_comboCategory.ResetContent();
	for(int ii = 0; ii < nSize; ii++)
		m_comboCategory.AddString( vsItems[ii] );
	
	///------ Folger 07/14/2011 ORG-3257-P1 FFW_SELECT_CATEGORY_DROP_DOWN_LIST_TOO_NARROW
	m_comboCategory.SetDroppedVisibleItemCount();
	///------ End FFW_SELECT_CATEGORY_DROP_DOWN_LIST_TOO_NARROW
	
	return true;
}

bool FFWNameTypePage::isCategorySeparator(const string & str)
{
	int nIndex = str.Find("-----");
	return (nIndex != -1);
}

bool FFWNameTypePage::checkFunctionName(string& strErrMsg)
{	
	bool bGoodName;
	
	string strNewFunction = m_edFunction.Text;
	
	///Jasmine 08/17/10 ORG-745-P5 SHARE_FO_NAME_CHECKING_CODE
	bool bRet = FuncOrganizer().CheckUpdateFuncName(strNewFunction, m_pHolder->m_trFunction, &strErrMsg, NULL, false);
	return bRet;
	
	//string strCategory = FuncOrganizer().FindFunctionCategory(strNewFunction);
	//
	/////Sophy 7/2/2010 ORG-432-P1 MORE_WORK_ON_CHECK_EXIST_IN_USER_DEFINED_FUNCTION_CATEGORY
	////if ( !strCategory.IsEmpty() )
	//if ( !strCategory.IsEmpty() && m_edFunction.Enable )
	/////end MORE_WORK_ON_CHECK_EXIST_IN_USER_DEFINED_FUNCTION_CATEGORY
	//{
		//strErrMsg.Format(_L("This function already exists in the category %s\n"), strCategory);
		//bGoodName = false;
	//}	
	//else if ( !is_str_valid_for_filename(strNewFunction) )
	//{
		//if ( strNewFunction.IsEmpty() )
			//strErrMsg = _L("Function name cannot be empty.");
		//else
			//strErrMsg.Format(_L("This function name %s is invalid\n"), strNewFunction);
		//bGoodName = false;
	//}
	//else
	//{
		//strErrMsg = "";
		//bGoodName = true;
	//}
	//
	//return bGoodName;
	///End SHARE_FO_NAME_CHECKING_CODE
}

///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
bool FFWNameTypePage::IsCheckFitWithInteg()
{
	Button btnIntegral = GetItem(IDC_RADIO_FIT_INTEGRAL);
	if(!btnIntegral)
		return false;
	return btnIntegral.Check;
}
void FFWNameTypePage::updateCheckBoxStatus(int nRadioID)
{
	///Junon 08/17/2012 ORG-5003 DISABLE_PEAK_FUNCTION_CHECKBOX_AND_INTEGRATION_CHEXKBOX_FOR_IMPLICT_FUNCTION
	//Button btnIntegral = GetItem(IDC_RADIO_FIT_INTEGRAL);
	//if(!btnIntegral)
		//return;
	//
	//bool bEnableIntegral = false;
	//switch (nRadioID)
	//{
	//case IDC_RADIO_SINGLE_EQUATION:
	//case IDC_RADIO_MULTI_EQUATION:
	//case IDC_RADIO_LABTALK:
		//bEnableIntegral = true;
		//break;
	//default:
		//break;
	//}
	//
	//btnIntegral.Enable = bEnableIntegral;
	//if(!bEnableIntegral)
		//btnIntegral.Check = false;
	int nRadioModel = GetCheckedRadioButton(IDC_RADIO_EXPLICIT, IDC_RADIO_IMPLICIT);
	Button btnIntegral = GetItem(IDC_RADIO_FIT_INTEGRAL);
	if(!btnIntegral)
		return;
	if(IDC_RADIO_EXPLICIT == nRadioModel)
	{
		bool bEnableIntegral = false;
		switch (nRadioID)
		{
		case IDC_RADIO_SINGLE_EQUATION:
		case IDC_RADIO_MULTI_EQUATION:
		case IDC_RADIO_LABTALK:
			bEnableIntegral = true;
			break;
		default:
			break;
		}
		
		btnIntegral.Enable = bEnableIntegral;
		if(!bEnableIntegral)
			btnIntegral.Check = false;
	}
	else
	{
		btnIntegral.Enable = false;
	}
	if(!btnIntegral.Enable)
	{
		SetHints(GetPageHints());
		btnIntegral.Check = false;
	}
	///End DISABLE_PEAK_FUNCTION_CHECKBOX_AND_INTEGRATION_CHEXKBOX_FOR_IMPLICT_FUNCTION
}
///End CREATE_FITFUNC_WITH_INTEGRAL
/*------------------------------------------------------------------------------*
 * FFWNameTypePage End															*
 *------------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------*
 * FFWInitialCodePage 			 												*
 *------------------------------------------------------------------------------*/

class FFWInitialCodePage : public FFWPageBase
{
public:
	FFWInitialCodePage(int nID = 0) : FFWPageBase(nID){}
	
	// Event handlers for this page
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)
		PAGE_ON_KILLACTIVE(OnKillActiviePage)
		PAGE_ON_NEXT(OnNext)
		PAGE_ON_BACK(OnBack)
		ON_BN_CLICKED(IDC_FIT_FUNC_INIT_OPEN_CODE_BUILDER, OnOpenCodeBuilder)
		ON_BN_CLICKED(IDC_FIT_FUNC_USE_OC_CHECK, OnUseOC);
	EVENTS_END

	//virtual
	BOOL OnInitPage();

	string GetName(){return "FFWInitialCodePage";}

	void OnContentChange();

protected:
	//virtual 
	bool 	UpdateTreeToPageGUI(const TreeNode& trFunction);
	//virtual 
	bool 	UpdatePageGUIToTree(TreeNode& trFunction);
	//virtual
	string	GetPageHintsName(bool bNextPage = false);///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT

private:
	void OnOpenCodeBuilder(Control ctrl);
	void OnUseOC(Control ctrl);

private:
	Edit   m_editInitialCode;
	Button m_checkAutoInitial;
	Button m_checkUseOC;
};

//virtual
BOOL FFWInitialCodePage::OnInitPage()
{
	m_editInitialCode = GetItem(IDC_FIT_FUNC_INITIAL_CODE);
	if ( !m_editInitialCode )
		return FALSE;

	m_editInitialCode.Text = "//Code to be executed to initialize parameters\r\n";

	m_checkAutoInitial = GetItem(IDC_FIT_FUNC_INITIAL_CHECK);
	if ( !m_checkAutoInitial )
		return FALSE;

	m_checkUseOC = GetItem(IDC_FIT_FUNC_USE_OC_CHECK);
	if ( !m_checkUseOC )
		return FALSE;
	
	BitmapRadioButton btnOpenCB = GetItem(IDC_FIT_FUNC_INIT_OPEN_CODE_BUILDER);
	vector<string> vsTips(1);
	vsTips[0] = _L("Open Code Builder");
	btnOpenCB.Init(1, IDB_OPEN_CB, 16, vsTips);
	
	return TRUE;
}

void FFWInitialCodePage::OnContentChange()
{
	string strCode = FuncOrganizer().GetInitialCode(m_pHolder->m_trFunction);
	StringToEditText(strCode, m_editInitialCode);
}

void FFWInitialCodePage::OnOpenCodeBuilder(Control ctrl)
{
	string strCode;
	EditTextToString(m_editInitialCode, strCode);

	FuncOrganizer().SetInitialCode(strCode, m_pHolder->m_trFunction);

	Functions.EditFunctionInCodeBuilder(m_pHolder->m_trFunction, m_wndParent, true);
}

void FFWInitialCodePage::OnUseOC(Control ctrl)
{
	Button bnOpenCodeBuilder = GetItem(IDC_FIT_FUNC_INIT_OPEN_CODE_BUILDER);
	bnOpenCodeBuilder.Visible = m_checkUseOC.Check;
}

//virtual
bool FFWInitialCodePage::UpdateTreeToPageGUI(const TreeNode & trFunction)
{
	string strCode = FuncOrganizer().GetInitialCode(trFunction);
	StringToEditText(strCode, m_editInitialCode);

	m_checkAutoInitial.Check = FuncOrganizer().IsAutoInitial(trFunction);

	m_checkUseOC.Check = FuncOrganizer().IsUseOC(trFunction);
	OnUseOC(m_checkUseOC);

	return true;
}

//virtual
bool FFWInitialCodePage::UpdatePageGUIToTree(TreeNode & trFunction)
{
	string strCode;
	EditTextToString(m_editInitialCode, strCode);

	FuncOrganizer().SetInitialCode(strCode, trFunction);

	FuncOrganizer().SetAutoInitial(m_checkAutoInitial.Check, trFunction);

	FuncOrganizer().SetUseOC(m_checkUseOC.Check, trFunction);

	return true;
}

///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT
//virtual 
string FFWInitialCodePage::GetPageHintsName(bool bNextPage/* = false*/)
{
	if ( !bNextPage )
		return "Parameter Initialization Code";
	else
		return "Parameter Initialization Code next page";
}
///End MOVE_FFW_HINTS_TO_TXT
/*------------------------------------------------------------------------------*
 * FFWInitialCodePage End		 												*
 *------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
 * FFWBoundsConstraintsPage 	 												*
 *------------------------------------------------------------------------------*/

class FFWBoundsConstraintsPage : public FFWPageBase
{
public:
	FFWBoundsConstraintsPage(int nID = 0) : FFWPageBase(nID){}
	
	// Event handlers for this page
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)
		PAGE_ON_KILLACTIVE(OnKillActiviePage)
		PAGE_ON_NEXT(OnNext)
		PAGE_ON_BACK(OnBack)
		ON_BN_CLICKED(IDC_FIT_FUNC_CONSTRAINTS_CHECK, OnConstraintsCheck)
		ON_GRID_AFTER_EDIT(IDC_FIT_FUNC_BOUNDS_GRID, OnAfterEditBoundControl)
		ON_GRID_BEFORE_EDIT(IDC_FIT_FUNC_BOUNDS_GRID, OnBeforeEditBoundControl)
		ON_GRID_DBLCLICK(IDC_FIT_FUNC_BOUNDS_GRID, OnDblClickBoundControl)
		ON_GRID_MOUSE_MOVE(IDC_FIT_FUNC_BOUNDS_GRID, OnMouseMoveParaControl)
		ON_GRID_BEFORE_MOUSE_DOWN(IDC_FIT_FUNC_BOUNDS_GRID, OnBeforeMouseDownParaControl)			///Jasmine 12/16/10 ORG-938-P1 DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS
	EVENTS_END

	//virtual
	BOOL OnInitPage();
	BOOL OnActivatePage(); /// Iris 2/08/2012 ORG-4412-S4 TO_HIDE_CONSTRAINTS_CONTROL_FOR_IMPLICIT_FUNC

	string GetName(){return "FFWBoundsConstraintsPage";}

protected:
	//virtual 
	bool 	UpdateTreeToPageGUI(const TreeNode& trFunction);
	//virtual 
	bool 	UpdatePageGUIToTree(TreeNode& trFunction);
	//virtual 
	string	GetPageHintsName(bool bNextPage = false);///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT

private:
	void OnConstraintsCheck(Control ctrl);
	void OnAfterEditBoundControl(Control flxControl, int nRow, int nCol);
	void OnBeforeEditBoundControl(Control flxControl, int nRow, int nCol, BOOL * pConcel);
	void OnDblClickBoundControl(Control flxControl);
	void OnMouseMoveParaControl(Control cntrl, short nButton, short nShift, float X, float Y);
	void OnBeforeMouseDownParaControl(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel);	///Jasmine 12/16/10 ORG-938-P1 DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS

private:
	Button	m_checkConstraints;
	Edit	m_editConstraints;
	FOParamSetting	m_GridBounds;

private:
	bool InitBoundGrid();
};

bool FFWBoundsConstraintsPage::InitBoundGrid()
{
	vector<int> vnCols = {
		NLPARAMGRIDCOLTYPE_LB,
		NLPARAMGRIDCOLTYPE_LB_CONTROL,
		NLPARAMGRIDCOLTYPE_NAME_DUP,
		NLPARAMGRIDCOLTYPE_UB_CONTROL,
		NLPARAMGRIDCOLTYPE_UB
	};
	vector<byte> vbShows;

	vbShows.SetSize(vnCols.GetSize());
	vbShows = true;

	m_GridBounds.Init(IDC_FIT_FUNC_BOUNDS_GRID, *this, "junk");
	m_GridBounds.SetGroupColShows(0, vnCols, vbShows);
	m_GridBounds.ShowGroup(0);
	//--- Jacky 07/16/10 ORG-589-P1 CENTRALIZE_CODE_MAKE_GRID_HEADERS_FOR_BOUNDS centralized in base class
	//string strOperaters;
	//strOperaters.Format("< %s <=", _L("or"));
	//m_GridBounds.SetColHeading(NLPARAMGRIDCOLTYPE_LB, _L("Lower Bounds"));
	//m_GridBounds.SetColHeading(NLPARAMGRIDCOLTYPE_LB_CONTROL, strOperaters);
	//m_GridBounds.SetColHeading(NLPARAMGRIDCOLTYPE_UB_CONTROL, strOperaters);
	//m_GridBounds.SetColHeading(NLPARAMGRIDCOLTYPE_UB, _L("Upper Bounds"));
	///end CENTRALIZE_CODE_MAKE_GRID_HEADERS_FOR_BOUNDS
	///------ Folger 08/31/2010 ORG-958-P3 BOUNDS_GRID_BAD_COLUMN_SIZE_IN_G
	m_GridBounds.ResizeCols();
	///------ End BOUNDS_GRID_BAD_COLUMN_SIZE_IN_G
	return true;
}

//virtual
BOOL FFWBoundsConstraintsPage::OnInitPage()
{
	m_checkConstraints = GetItem(IDC_FIT_FUNC_CONSTRAINTS_CHECK);
	if ( !m_checkConstraints )
		return FALSE;

	m_editConstraints = GetItem(IDC_FIT_FUNC_BOUNDS_CONSTRAINTS_EDIT);
	if ( !m_editConstraints )
		return FALSE;

	if ( !InitBoundGrid() )
		return FALSE;

	return FFWPageBase::OnInitPage();
}

/// Iris 2/08/2012 ORG-4412-S4 TO_HIDE_CONSTRAINTS_CONTROL_FOR_IMPLICIT_FUNC
BOOL FFWBoundsConstraintsPage::OnActivatePage()
{
	bool bImplicit = nlsf_is_implicit_func(FuncOrganizer().GetFunctionModel(m_pHolder->m_trFunction));
	GetItem(IDC_FIT_FUNC_CONSTRAINTS_CHECK).Visible = 
	GetItem(IDC_FIT_FUNC_CONSTRAINTS_GROUP).Visible = 
	GetItem(IDC_FIT_FUNC_BOUNDS_CONSTRAINTS_EDIT).Visible = 
	!bImplicit;
	
	return FFWPageBase::OnActivatePage();
}
///End TO_HIDE_CONSTRAINTS_CONTROL_FOR_IMPLICIT_FUNC

void FFWBoundsConstraintsPage::OnConstraintsCheck(Control ctrl)
{
	m_editConstraints.Enable = m_checkConstraints.Check;
}

void FFWBoundsConstraintsPage::OnAfterEditBoundControl(Control flxControl, int nRow, int nCol)
{
	m_GridBounds.OnAfterEdit(flxControl, nRow, nCol);
}

void FFWBoundsConstraintsPage::OnBeforeEditBoundControl(Control flxControl, int nRow, int nCol, BOOL * pConcel)
{
	m_GridBounds.OnBeforeEditParaControl(flxControl, nRow, nCol, pConcel);
}

void FFWBoundsConstraintsPage::OnDblClickBoundControl(Control flxControl)
{
	int nRow = 0, nCol = 0;
	int nx = -1, ny = -1;

	m_GridBounds.GetSelCell(nx, ny, nRow, nCol);

	if ( NLPARAMGRIDCOLTYPE_LB_CONTROL == nCol || NLPARAMGRIDCOLTYPE_UB_CONTROL == nCol )
	{
		m_GridBounds.OnButtonClick(flxControl, nRow, nCol);
		OnAfterEditBoundControl(flxControl, nRow, nCol)
	}
}

void FFWBoundsConstraintsPage::OnMouseMoveParaControl(Control cntrl, short nButton, short nShift, float X, float Y)
{
	int nRow, nCol;
	if ( !m_GridBounds.GetMouseCell(nRow, nCol) )
		return;
	
	string strTooltips;
	nCol -= m_GridBounds.GetColOffset();
	if ( nRow >= m_GridBounds.GetRowOffset() && 
		 (nCol == NLPARAMGRIDCOLTYPE_LB_CONTROL || nCol == NLPARAMGRIDCOLTYPE_UB_CONTROL) )
	{
		m_GridBounds.SetToolTipsText( _L("Double-click the cell to set an operator") );
	}
}

///Jasmine 12/17/10 ORG-938-P1 DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS
void FFWBoundsConstraintsPage::OnBeforeMouseDownParaControl(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
{
	if( nButton != MK_RBUTTON )
		return;

	int nRow, nCol, nX, nY;
	m_GridBounds.GetMousePixel( X, Y, nRow, nCol, nX, nY );
	if ( NLPARAMGRIDCOLTYPE_VALUE == nCol
		|| NLPARAMGRIDCOLTYPE_UB == nCol
		|| NLPARAMGRIDCOLTYPE_LB == nCol)
	{
		vector<string>	vsItem;
		vector<byte>  	vbShow;
		vector<bool>	vbDisable;
		vector<int>		vnChoiceContextMenu;
		DWORD			dwCntrl = 0;
		dwCntrl |= CM_CNTRL_NO_APPLT_TO_ALL;
		m_GridBounds.GetItemContextMenu(nRow, nCol, vsItem, vbShow, vbDisable, vnChoiceContextMenu, dwCntrl);
		if ( 0 == vsItem.GetSize() )
			return ;
		
		//only Format Cells...
		if( lstrcmp(vsItem[0], STR_GRID_FORMAT_CELLS + STR_THREE_DOTS) != 0 )
			return;
		int nOnlyOneFormatCells = 1;
		vbShow.SetSize(nOnlyOneFormatCells);
		vsItem.SetSize(nOnlyOneFormatCells);
		vbDisable.SetSize(nOnlyOneFormatCells);
		
		
		CheckMenu 	MyMenu( vbShow, vsItem, vbDisable );				
		int nChoice = MyMenu.DoTrackPopup( nX, nY, m_GridBounds.GetDlgSafeHwnd() );
		if(0 != nChoice)
			return;
		
		int nRet = m_GridBounds.OnItemContextMenu(nRow, nCol, vnChoiceContextMenu[nChoice]);
		///------ Folger 12/24/2010 ORG-938-P2 PROPER_UPDATE_NLFIT_PARAM_GRID_AFTER_DATE_TIME_FORMAT_CHANGE
		//if(nRet & NLDLGPART_PARAMETERS_GRID)
		if ( O_QUERY_BOOL(nRet, NLDLGPART_PARAMETERS_GRID | NLDLGPART_PARAMETERS_DISPLAY) )
		///------ End PROPER_UPDATE_NLFIT_PARAM_GRID_AFTER_DATE_TIME_FORMAT_CHANGE
			m_GridBounds.Update();
	}
}
///End DATE_TIME_SUPPORT_IN_NLFIT_PARAMTERS

//virtual
bool FFWBoundsConstraintsPage::UpdateTreeToPageGUI(const TreeNode & trFunction)
{
	string strConstraints = FuncOrganizer().GetConstraints(trFunction);
	StringToEditText(strConstraints, m_editConstraints);

	m_checkConstraints.Check = FuncOrganizer().IsEnableConstraint(trFunction);
	m_editConstraints.Enable = m_checkConstraints.Check;

	TreeNode trTemp = m_pHolder->m_trFunction;
	m_GridBounds.SetTree(trTemp);
	m_GridBounds.Update();

	///------ Folger 08/31/2010 ORG-958-P3 BOUNDS_GRID_BAD_COLUMN_SIZE_IN_G
	//vector<double> vdColWidth(m_GridBounds.GetCols());
	//vdColWidth[NLPARAMGRIDCOLTYPE_LB]			= 0.25;
	//vdColWidth[NLPARAMGRIDCOLTYPE_LB_CONTROL]	= 0.1;
	//vdColWidth[NLPARAMGRIDCOLTYPE_NAME_DUP]		= 0.3;
	//vdColWidth[NLPARAMGRIDCOLTYPE_UB_CONTROL]	= 0.1;
	//vdColWidth[NLPARAMGRIDCOLTYPE_UB]			= 0.25;

	//m_GridBounds.ResizeCols(vdColWidth);
	///------ End BOUNDS_GRID_BAD_COLUMN_SIZE_IN_G

	return true;
}

//virtual
bool FFWBoundsConstraintsPage::UpdatePageGUIToTree(TreeNode & trFunction)
{
	///Jasmine 07/08/10 ORG-2-P4 AUTO_RUN_INIT_CODE_IS_RESET_IF_INIT_CODE_EMPTY
	/// Bill 07/06/2010 ORG-478-P7 PREVENT_GETTREE_OVERWRITE_CONSTRAINT
	Tree trTemp;
	m_GridBounds.GetTree(trTemp);
	trFunction.FittingParameters.LowerBounds.strVal = trTemp.FittingParameters.LowerBounds.strVal;
	trFunction.FittingParameters.UpperBounds.strVal = trTemp.FittingParameters.UpperBounds.strVal;
	/// End PREVENT_GETTREE_OVERWRITE_CONSTRAINT
	///End AUTO_RUN_INIT_CODE_IS_RESET_IF_INIT_CODE_EMPTY

	string strConstraints;
	EditTextToString(m_editConstraints, strConstraints);

	FuncOrganizer().SetConstraints(strConstraints, trFunction);

	FuncOrganizer().EnableConstraint(m_checkConstraints.Check, trFunction);

	/// Bill 07/06/2010 ORG-478-P7 PREVENT_GETTREE_OVERWRITE_CONSTRAINT
	//m_GridBounds.GetTree(trFunction);
	/// End PREVENT_GETTREE_OVERWRITE_CONSTRAINT

	return true;
}

///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT
//virtual 
string FFWBoundsConstraintsPage::GetPageHintsName(bool bNextPage/* = false*/)
{
	if ( !bNextPage )
		return "Bounds and Constraints";
	else
		return "Bounds and Constraints next page";
}
///End MOVE_FFW_HINTS_TO_TXT
/*------------------------------------------------------------------------------*
 * FFWBoundsConstraintsPage End		 											*
 *------------------------------------------------------------------------------*/
 
/*------------------------------------------------------------------------------*
 * FFWDerivedParametersPage 			 										*
 *------------------------------------------------------------------------------*/

enum DERIVED_GRID_COLUMN {
	DERIVED_NAME_COLUMN = 0,
	DERIVED_MEANING_COLUMN,
	DERIVED_UNIT_COLUMN,
	
	DERIVED_TOTAL_COLUMN
};

class FFWDerivedParametersPage : public FFWPageBase
{
public:
	FFWDerivedParametersPage(int nID = 0) : FFWPageBase(nID){}
	
	// Event handlers for this page
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)
		PAGE_ON_KILLACTIVE(OnKillActiviePage)
		PAGE_ON_NEXT(OnNext)
		PAGE_ON_BACK(OnBack)
		ON_BN_CLICKED(IDC_FIT_FUNC_ADD_PARAM, OnAddParam)
		ON_BN_CLICKED(IDC_FIT_FUNC_DEL_PARAM, OnDelParam)
		ON_GRID_BEFORE_EDIT(IDC_FIT_FUNC_DERIVED_PARAMETERS_GRID, OnBeforeEditParaControl)	///Sophy 7/16/2010 ORG-518-P6 DISABLE_EDIT_PARAM_AND_CONSTANT_NAME
		ON_GRID_AFTER_EDIT(IDC_FIT_FUNC_DERIVED_PARAMETERS_GRID, OnAfterEditParaControl)
		
		ON_EN_KILLFOCUS(IDC_FIT_FUNC_DERIVED_PARAMETERS_EDIT, OnEquationChange)		///Jasmine 08/18/10 ORG-820-S1 NOT_ALLOW_FINISH_UNTIL_DERIVED_PARAM_CHECK_OK
	EVENTS_END

	//virtual
	BOOL OnInitPage();
	BOOL OnActivatePage();
	
	///------ Folger 08/11/10 ORG-762 BETTER_ERROR_CHECKING_FOR_DERIVED_PARAMS_EQUATIONS
	virtual BOOL OnNext();
	///------ End BETTER_ERROR_CHECKING_FOR_DERIVED_PARAMS_EQUATIONS

	string GetName(){return "FFWDerivedParametersPage";}

protected:
	//virtual 
	bool 	UpdateTreeToPageGUI(const TreeNode& trFunction);
	//virtual 
	bool 	UpdatePageGUIToTree(TreeNode& trFunction);
	//virtual 
	string	GetPageHintsName(bool bNextPage = false);///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT

private:
	BOOL OnAddParam(Control ctrl);
	BOOL OnDelParam(Control ctrl);
	void OnBeforeEditParaControl(Control flxControl, int nRow, int nCol, BOOL* pCancel);	///Sophy 7/16/2010 ORG-518-P6 DISABLE_EDIT_PARAM_AND_CONSTANT_NAME
	void OnAfterEditParaControl(Control flxControl, int nRow, int nCol);
	///------ Folger 08/11/10 ORG-762 BETTER_ERROR_CHECKING_FOR_DERIVED_PARAMS_EQUATIONS
	BOOL CheckEquation(bool bKeepSilence = false);		///Jasmine 08/18/10 ORG-820-S1 NOT_ALLOW_FINISH_UNTIL_DERIVED_PARAM_CHECK_OK
	///------ End  BETTER_ERROR_CHECKING_FOR_DERIVED_PARAMS_EQUATIONS
	
	///Jasmine 08/18/10 ORG-820-S1 NOT_ALLOW_FINISH_UNTIL_DERIVED_PARAM_CHECK_OK
	BOOL OnEquationChange(Control ctrl);		
	
	void checkEnableFinishBtn();	
	///End NOT_ALLOW_FINISH_UNTIL_DERIVED_PARAM_CHECK_OK
private:
	Edit			m_editEquation;
	GridListControl	m_gridDerivedParameter;

private:
	bool InitGridDerivedParameter();
};

//virtual
BOOL FFWDerivedParametersPage::OnInitPage()
{
	m_editEquation = GetItem(IDC_FIT_FUNC_DERIVED_PARAMETERS_EDIT);
	if ( !m_editEquation )
		return FALSE;

	if ( !InitGridDerivedParameter() )
		return FALSE;

	return FFWPageBase::OnInitPage();
}

BOOL FFWDerivedParametersPage::OnActivatePage()
{
	BOOL bRet = FFWPageBase::OnActivatePage();
	
	///Jasmine 08/18/10 ORG-820-S1 NOT_ALLOW_FINISH_UNTIL_DERIVED_PARAM_CHECK_OK
	checkEnableFinishBtn();
	///End NOT_ALLOW_FINISH_UNTIL_DERIVED_PARAM_CHECK_OK
	
	return bRet;
}

///------ Folger 08/11/10 ORG-762 BETTER_ERROR_CHECKING_FOR_DERIVED_PARAMS_EQUATIONS
/// virtual
BOOL FFWDerivedParametersPage::OnNext()
{
	string strErrMsg;
	if ( !CheckEquation() )
		return FALSE;
	
	return FFWPageBase::OnNext();
}
///------ End BETTER_ERROR_CHECKING_FOR_DERIVED_PARAMS_EQUATIONS

BOOL FFWDerivedParametersPage::OnAddParam(Control ctrl)
{
	int nOldRowCount = m_gridDerivedParameter.GetRows() - m_gridDerivedParameter.GetRowOffset();

	m_gridDerivedParameter.SetRows(nOldRowCount + 1);

	return TRUE;
}

BOOL FFWDerivedParametersPage::OnDelParam(Control ctrl)
{
	vector<uint> vuSelections;

	m_gridDerivedParameter.GetSelRows(vuSelections);

	for (int ii = vuSelections.GetSize() - 1 ; ii >= 0 ; --ii)
		m_gridDerivedParameter.DeleteRow(vuSelections[ii]);

	return TRUE;
}

///Sophy 7/16/2010 ORG-518-P6 DISABLE_EDIT_PARAM_AND_CONSTANT_NAME
void FFWDerivedParametersPage::OnBeforeEditParaControl(Control flxControl, int nRow, int nCol, BOOL* pCancel)
{
	if ( DERIVED_NAME_COLUMN == nCol && pCancel )
	{
		*pCancel = TRUE;
	}
}
///end DISABLE_EDIT_PARAM_AND_CONSTANT_NAME

void FFWDerivedParametersPage::OnAfterEditParaControl(Control flxControl, int nRow, int nCol)
{
	if ( DERIVED_NAME_COLUMN == nCol)
	{
		vector<string> vsNames;

		m_gridDerivedParameter.GetColValues(DERIVED_NAME_COLUMN, vsNames);

		string strNew = vsNames[nRow];

		vsNames.RemoveAt(nRow);
		vsNames.RemoveAt(0);

		if ( vsNames.Find(strNew) != -1)
		{
			string strErrMsg;
			strErrMsg.Format(_L("The derived parameter %s already exists"), strNew);

			MessageBox(strErrMsg, STR_ERROR, MB_OK);

			string strDummy = "";

			m_gridDerivedParameter.SetCell(nRow, nCol, strDummy);
		}
	}

	/// Bill 07/14/2010 ORG-576-S1 MOVE_TO_NEXT_ROW_IF_USER_PRESS_ENTER
	m_gridDerivedParameter.OnAfterEdit(nRow, nCol);
	/// End MOVE_TO_NEXT_ROW_IF_USER_PRESS_ENTER
}

bool FFWDerivedParametersPage::InitGridDerivedParameter()
{
	m_gridDerivedParameter.Init(IDC_FIT_FUNC_DERIVED_PARAMETERS_GRID, *this);

	m_gridDerivedParameter.SetCols(DERIVED_TOTAL_COLUMN);

	m_gridDerivedParameter.SetColAlignment(DERIVED_NAME_COLUMN, DISPLAY_LEFT);
	m_gridDerivedParameter.SetColAlignment(DERIVED_MEANING_COLUMN, DISPLAY_LEFT);
	m_gridDerivedParameter.SetColAlignment(DERIVED_UNIT_COLUMN, DISPLAY_LEFT);

	m_gridDerivedParameter.SetColHeading(DERIVED_NAME_COLUMN, _L("Name"));
	m_gridDerivedParameter.SetColHeading(DERIVED_MEANING_COLUMN, _L("Meaning"));
	m_gridDerivedParameter.SetColHeading(DERIVED_UNIT_COLUMN, _L("Unit"));

	m_gridDerivedParameter.SetEditable(flexEDKbdMouse);

	/// Bill 07/15/2010 ORG-576-S1 SET_SELECTION_TO_FREE
	m_gridDerivedParameter.SetSelection(flexSelectionFree);
	/// End SET_SELECTION_TO_FREE

	return true;
}

//virtual
bool FFWDerivedParametersPage::UpdateTreeToPageGUI(const TreeNode & trFunction)
{
	vector<string> vsName;
	vector<string> vsMeaning;
	vector<string> vsUnit;

	int nCounts;
	nCounts = FuncOrganizer().GetDerivedParameterSetting(m_pHolder->m_trFunction, vsName, vsMeaning, vsUnit);

	string strEquation = FuncOrganizer().GetDerivedParameterEquation(trFunction);
	StringToEditText(strEquation, m_editEquation);

	if (1)//( nCounts > 0)	///Jasmine 08/17/10 ORG-745-P7 DERIVED_PARAM_SETTINGS_ARE_INDEPENDENT_WITH_EQUATION
	{
		m_gridDerivedParameter.SetRows(nCounts);

		m_gridDerivedParameter.SetColValues(DERIVED_NAME_COLUMN, vsName);
		m_gridDerivedParameter.SetColValues(DERIVED_MEANING_COLUMN, vsMeaning);
		m_gridDerivedParameter.SetColValues(DERIVED_UNIT_COLUMN, vsUnit);
	}
	else
	{
		vector<string> vsDummyValues;
		nCounts = FuncOrganizer().EquationParse(strEquation, '\n', vsName, vsDummyValues);

		m_gridDerivedParameter.SetRows(nCounts);

		m_gridDerivedParameter.SetColValues(DERIVED_NAME_COLUMN, vsName);
	}

	///Jasmine 08/18/10 ORG-745-S1 DISABLE_EQUATION_IF_NO_DERIVED_PARAM
	m_editEquation.Enable = nCounts > 0 || !strEquation.IsEmpty();
	//End DISABLE_EQUATION_IF_NO_DERIVED_PARAM
	
	return true;
}

//virtual
bool FFWDerivedParametersPage::UpdatePageGUIToTree(TreeNode & trFunction)
{
	string strEquation;
	EditTextToString(m_editEquation, strEquation);

	FuncOrganizer().SetDerivedParameterEquation(strEquation, trFunction);

	vector<string> vsNames;
	vector<string> vsMeanings;
	vector<string> vsUnit;

	m_gridDerivedParameter.GetColValues(DERIVED_NAME_COLUMN, vsNames);
	m_gridDerivedParameter.GetColValues(DERIVED_MEANING_COLUMN, vsMeanings);
	m_gridDerivedParameter.GetColValues(DERIVED_UNIT_COLUMN, vsUnit);

	vsNames.RemoveAt(0);
	vsMeanings.RemoveAt(0);
	vsUnit.RemoveAt(0);

	for (int ii = vsNames.GetSize() - 1 ; ii >= 0 ; --ii)
		if ( vsNames[ii] == "")
		{
			vsNames.RemoveAt(ii);
			vsMeanings.RemoveAt(ii);
			vsUnit.RemoveAt(ii);
		}

	FuncOrganizer().SetDerivedParameterSetting(trFunction, vsNames, vsMeanings, vsUnit);

	return true;
}

///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT
//virtual 
string FFWDerivedParametersPage::GetPageHintsName(bool bNextPage/* = false*/)
{
	if ( !bNextPage )
		return "Derived Parameters";
	else
		return "Derived Parameters next page";
}
///End MOVE_FFW_HINTS_TO_TXT

///------ Folger 08/11/10 ORG-762 BETTER_ERROR_CHECKING_FOR_DERIVED_PARAMS_EQUATIONS
BOOL FFWDerivedParametersPage::CheckEquation(bool bKeepSilence/* = false*/)///Jasmine 08/18/10 ORG-820-S1 NOT_ALLOW_FINISH_UNTIL_DERIVED_PARAM_CHECK_OK
{
	string	strEquation;
	EditTextToString(m_editEquation, strEquation);
	strEquation.TrimLeft();
	strEquation.TrimRight();

	StringArray	vsNames;
	FuncOrganizer().GetDerivedParameterSetting(m_pHolder->m_trFunction, vsNames);
	if ( strEquation.IsEmpty() )
	{
		if ( vsNames.GetSize() > 0 )
		{
			if(!bKeepSilence)	///Jasmine 08/18/10 ORG-820-S1 NOT_ALLOW_FINISH_UNTIL_DERIVED_PARAM_CHECK_OK
				MessageBox(_L("Equations are empty"), STR_ERROR, MB_OK);
			return FALSE;
		}
	}

	string	strErrMsg;
	NumericFunction nf(m_pHolder->m_trFunction);
	///------ Folger 08/16/10 ORG-762-P2 MORE_ERROR_CHECKING_ON_DERIVED_PARAMS_EQUATIONS
	//if ( !nf.CheckEquations(strEquation, &strErrMsg) )
	if ( !nf.CheckDerivedParamEquations(strEquation, vsNames, &strErrMsg) )
	///------ End MORE_ERROR_CHECKING_ON_DERIVED_PARAMS_EQUATIONS
	{
		if(!bKeepSilence)	///Jasmine 08/18/10 ORG-820-S1 NOT_ALLOW_FINISH_UNTIL_DERIVED_PARAM_CHECK_OK
			MessageBox(strErrMsg, STR_ERROR, MB_OK);
		return FALSE;
	}
	
	return TRUE;
}
///------ End  BETTER_ERROR_CHECKING_FOR_DERIVED_PARAMS_EQUATIONS

///Jasmine 08/18/10 ORG-820-S1 NOT_ALLOW_FINISH_UNTIL_DERIVED_PARAM_CHECK_OK
BOOL FFWDerivedParametersPage::OnEquationChange(Control ctrl)
{
	checkEnableFinishBtn();
	
	return TRUE;
}

void FFWDerivedParametersPage::checkEnableFinishBtn()
{
	bool bEnable = CheckEquation(true);	
	m_pHolder->EnableFinishButton(bEnable);
}
///End NOT_ALLOW_FINISH_UNTIL_DERIVED_PARAM_CHECK_OK
/*------------------------------------------------------------------------------*
 * FFWDerivedParametersPage End		 											*
 *------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
 * FFWBeforeAfterPage				 											*
 *------------------------------------------------------------------------------*/

class FFWBeforeAfterPage : public FFWPageBase
{
public:
	FFWBeforeAfterPage(int nID = 0) : FFWPageBase(nID){}
	
	// Event handlers for this page
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)
		PAGE_ON_KILLACTIVE(OnKillActiviePage)
		PAGE_ON_NEXT(OnNext)
		PAGE_ON_BACK(OnBack)
	EVENTS_END

	//virtual
	BOOL OnInitPage();

	string GetName(){return "FFWBeforeAfterPage";}
	
protected:
	//virtual 
	bool 	UpdateTreeToPageGUI(const TreeNode& trFunction);
	//virtual 
	bool 	UpdatePageGUIToTree(TreeNode& trFunction);
	//virtual 
	string	GetPageHintsName(bool bNextPage = false);///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT

private:
	Edit	m_editBeforeScript;
	Edit	m_editAfterScript;
};

BOOL FFWBeforeAfterPage::OnInitPage()
{
	m_editBeforeScript = GetItem(IDC_FIT_FUNC_BEFORE_SCRIPT);
	if ( !m_editBeforeScript )
		return FALSE;

	m_editAfterScript = GetItem(IDC_FIT_FUNC_AFTER_SCRIPT);
	if ( !m_editAfterScript )
		return FALSE;

	return FFWPageBase::OnInitPage();
}

bool FFWBeforeAfterPage::UpdateTreeToPageGUI(const TreeNode & trFunction)
{
	string strBeforeScript;
	string strAfterScript;

	strBeforeScript = FuncOrganizer().GetBeforeFittingScript(trFunction);
	StringToEditText(strBeforeScript, m_editBeforeScript);

	strAfterScript = FuncOrganizer().GetAfterFittingScript(trFunction);
	StringToEditText(strAfterScript, m_editAfterScript);

	return true;
}

bool FFWBeforeAfterPage::UpdatePageGUIToTree(TreeNode & trFunction)
{
	string strBeforeScript;
	EditTextToString(m_editBeforeScript, strBeforeScript);
	FuncOrganizer().SetBeforeFittingScript(strBeforeScript, trFunction);

	string strAfterScript;
	EditTextToString(m_editAfterScript, strAfterScript);
	FuncOrganizer().SetAfterFittingScript(strAfterScript, trFunction);

	return true;
}

///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT
string FFWBeforeAfterPage::GetPageHintsName(bool bNextPage/* = false*/)
{
	if ( !bNextPage )
		return "Before or After Fitting Script";
	else
		return "";
}
///End MOVE_FFW_HINTS_TO_TXT
/*------------------------------------------------------------------------------*
 * FFWBeforeAfterPage End			 											*
 *------------------------------------------------------------------------------*/
 

#endif//_FFW_PAGE_BASE_H
