/*------------------------------------------------------------------------------*
 * File Name: FFWIntegralPages.h	 											*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Jasmine ORG-3484-S2-2 CHECKING_ONLY_ON_NEXT									*
 *------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------*
 this file contains two classes:
 	1. FFWIntegrandPage 	
 	2. FFWFitIntegralPage 	
 *------------------------------------------------------------------------------*/ 
 
#ifndef _FFW_INTEGRAL_PAGE_H
#define _FFW_INTEGRAL_PAGE_H


/*------------------------------------------------------------------------------*
 * FFWIntegrandPage 			 												*
 *------------------------------------------------------------------------------*/

class FFWIntegrandPage : public FFWPageBase
{	
public:
	FFWIntegrandPage(int nID = 0) : FFWPageBase(nID){}
	
	// Event handlers for this page
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)
		PAGE_ON_KILLACTIVE(OnKillActiviePage)
		PAGE_ON_BACK(OnBack)
		PAGE_ON_NEXT(OnNext)
	EVENTS_END

	string GetName(){return "FFWIntegrandPage";}

protected:
	//virtual 
	bool 	UpdateTreeToPageGUI(const TreeNode& trFunction){ASSERT(0);return false;}//doing
	//virtual 
	bool 	UpdatePageGUIToTree(TreeNode& trFunction){ASSERT(0);return false;}//doing
	//virtual 
	string	GetPageHintsName(bool bNextPage = false);///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT
};

///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT
//virtual 
string FFWIntegrandPage::GetPageHintsName(bool bNextPage/* = false*/)
{	
	if ( !bNextPage )
		return "Integrand";
	else
		return "Integrand next page";
}
///End MOVE_FFW_HINTS_TO_TXT
/*------------------------------------------------------------------------------*
 * FFWIntegrandPage End		 													*
 *------------------------------------------------------------------------------*/
 

/*------------------------------------------------------------------------------*
 * FFWFitIntegralPage 			 												*
 *------------------------------------------------------------------------------*/
class FFWFitIntegralPage : public FFWPageBase
{
public:
	FFWFitIntegralPage(int nID = 0) : FFWPageBase(nID) {}

	// Event handlers for this page
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)
		PAGE_ON_KILLACTIVE(OnKillActiviePage)
		PAGE_ON_NEXT(OnNext)
		PAGE_ON_BACK(OnBack)
		
		ON_EN_KILLFOCUS(IDC_FIT_FUNC_INTEGRAND_NAME, 		OnIntegControlChange)
		ON_EN_KILLFOCUS(IDC_FIT_FUNC_INTEGRAND_VAR, 		OnIntegControlChange)
		ON_EN_KILLFOCUS(IDC_FIT_FUNC_INTEGRAND_ARG,			OnIntegControlChange)
		//ON_EN_KILLFOCUS(IDC_FIT_FUNC_FUNCTION_BODY_EDIT,	OnLTFuncBodyChange)		///Jasmine ORG-3484-S2-2 CHECKING_ONLY_ON_NEXT
	EVENTS_END

	string GetName(){return "FFWFitIntegralPage";}

	BOOL	OnNext();
	BOOL 	OnIntegControlChange(Control ctrl);
	BOOL	CheckAfterEdit(Control ctrl, bool bAllowEmpty);			///Jasmine ORG-3484-S2-2 CHECKING_ONLY_ON_NEXT
	BOOL	OnLTFuncBodyChange(Control ctrl);
	
protected:
	//virtual 
	bool 	UpdateTreeToPageGUI(const TreeNode& trFunction);
	//virtual 
	bool 	UpdatePageGUIToTree(TreeNode& trFunction);
	//virtual 
	string	GetPageHintsName(bool bNextPage = false);///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT
};

///Jasmine 07/28/2011 ORG-342-S1 CREATE_FITFUNC_WITH_INTEGRAL
BOOL	FFWFitIntegralPage::OnNext()
{
	bool bRet = true;
	Control ctrl;
	ctrl = GetItem(IDC_FIT_FUNC_INTEGRAND_NAME);
	if(bRet)
		bRet = CheckAfterEdit(ctrl, false);
		
	ctrl = GetItem(IDC_FIT_FUNC_INTEGRAND_VAR);
	if(bRet)
		bRet = CheckAfterEdit(ctrl, false);
	
	ctrl = GetItem(IDC_FIT_FUNC_INTEGRAND_ARG);
	if(bRet)
		bRet = CheckAfterEdit(ctrl, true);
	
	ctrl = GetItem(IDC_FIT_FUNC_FUNCTION_BODY_EDIT);
	if(bRet)
		bRet = OnLTFuncBodyChange(ctrl);
	
	OnIntegControlChange(ctrl);
	
	if(bRet)
		return FFWPageBase::OnNext();
	
	return FALSE;
}

#define _GET_CONTROL_TEXT(_CTRLID, _TEXT)	\
{											\
	cTemp = GetItem(_CTRLID);				\
	if(cTemp)								\
		_TEXT = cTemp.Text;					\
	else									\
		ASSERT(0);							\
}

#define _SET_CONTROL_TEXT(_CTRLID, _TEXT)	\
{											\
	cTemp = GetItem(_CTRLID);				\
	if(cTemp)								\
		cTemp.Text = _TEXT;					\
	else									\
		ASSERT(0);							\
}
///Jasmine ORG-3484-S2-2 CHECKING_ONLY_ON_NEXT
BOOL 	FFWFitIntegralPage::OnIntegControlChange(Control ctrl)
{	
	string strFuncName, strVar, strArg;
	Control cTemp;
	_GET_CONTROL_TEXT(IDC_FIT_FUNC_INTEGRAND_NAME,strFuncName);
	_GET_CONTROL_TEXT(IDC_FIT_FUNC_INTEGRAND_VAR, strVar);		
	_GET_CONTROL_TEXT(IDC_FIT_FUNC_INTEGRAND_ARG, strArg);		
	
	string strEquation;
	FuncOrganizer().LTFuncInfoToText(strEquation, strFuncName, strVar, strArg);	///Jasmine ORG-3484-S2-4 CHANGE_TEXT_SYNTAX
	_SET_CONTROL_TEXT(IDC_FIT_FUNC_INTEGRAND_EQUA, strEquation);
	
	return TRUE;
}

BOOL	FFWFitIntegralPage::CheckAfterEdit(Control ctrl, bool bAllowEmpty)
{
	int 	id = GetDlgCtrlID( ctrl.GetSafeHwnd() );
	bool 	bAllowMultip = false;
	string 	strCtrlName;
	switch(id)
	{
	case IDC_FIT_FUNC_INTEGRAND_NAME:
		strCtrlName = _L("Integrand Name");
		break;
	case IDC_FIT_FUNC_INTEGRAND_VAR:
		strCtrlName = _L("Integration Variable");		
		break;		
	case IDC_FIT_FUNC_INTEGRAND_ARG:
		strCtrlName = _L("Integration Argument");		
		bAllowMultip = true;
		break;		
	}
	
	string strErrMsg;
	if( checkEditControlValue(ctrl, strCtrlName, bAllowEmpty, strErrMsg) )
	{
		if(!bAllowMultip && ctrl.Text.GetNumTokens(STR_ITEM_SEPARATOR) != 1)
		{
			switch(id)
			{
			case IDC_FIT_FUNC_INTEGRAND_NAME:
				strErrMsg.Format(_L("Integrand cannot have multiple Names"));
				break;
			case IDC_FIT_FUNC_INTEGRAND_VAR:
				strErrMsg.Format(_L("Integration cannot have multiple variables"));
				break;
			}
		}
	}
	
	if( !strErrMsg.IsEmpty() )
	{
		MessageBox(strErrMsg, STR_ERROR, MB_OK);
		return FALSE;
	}
	
	return TRUE;
}
///End CHECKING_ONLY_ON_NEXT
BOOL	FFWFitIntegralPage::OnLTFuncBodyChange(Control ctrl)
{
	string strErrMsg;
	if( ctrl.Text.IsEmpty() )
	{
		ocu_load_msg_str(FFWERR_ST_CANNOT_BE_EMPTY, &strErrMsg, _L("Integrand Function Body"));
		MessageBox(strErrMsg, STR_ERROR, MB_OK);
		return FALSE;
	}
	///Jasmine 08/23/2011 ORG-3484-S6 ERROR_CHECK_ABOUT_LT_FUNCTION_RETURN
	else if(ctrl.Text.Find("return") < 0)
	{
		MessageBox(_L("There is no return value in function body"), STR_ERROR, MB_OK);
		return FALSE;
	}
	///End ERROR_CHECK_ABOUT_LT_FUNCTION_RETURN
	
	return TRUE;
}

bool 	FFWFitIntegralPage::UpdateTreeToPageGUI(const TreeNode& trFunction)
{
	string strFuncName, strVar, strArg, strBody;
	FuncOrganizer().GetLTFuncInfo(trFunction, strFuncName, strVar, strArg, strBody);
	
	string strEquation;
	FuncOrganizer().LTFuncInfoToText(strEquation, strFuncName, strVar, strArg);	///Jasmine ORG-3484-S2-4 CHANGE_TEXT_SYNTAX
	
	Control cTemp;
	_SET_CONTROL_TEXT(IDC_FIT_FUNC_INTEGRAND_NAME, 		strFuncName);
	_SET_CONTROL_TEXT(IDC_FIT_FUNC_INTEGRAND_VAR, 		strVar);
	_SET_CONTROL_TEXT(IDC_FIT_FUNC_INTEGRAND_ARG, 		strArg);
	_SET_CONTROL_TEXT(IDC_FIT_FUNC_INTEGRAND_EQUA, 		strEquation);
	_SET_CONTROL_TEXT(IDC_FIT_FUNC_FUNCTION_BODY_EDIT, 	strBody);
	
	return true;
}

bool 	FFWFitIntegralPage::UpdatePageGUIToTree(TreeNode& trFunction)
{
	string strFuncName, strVar, strArg, strBody;
	
	Control cTemp;
	_GET_CONTROL_TEXT(IDC_FIT_FUNC_INTEGRAND_NAME, 		strFuncName);
	_GET_CONTROL_TEXT(IDC_FIT_FUNC_INTEGRAND_VAR, 		strVar);
	_GET_CONTROL_TEXT(IDC_FIT_FUNC_INTEGRAND_ARG, 		strArg);
	_GET_CONTROL_TEXT(IDC_FIT_FUNC_FUNCTION_BODY_EDIT, 	strBody);
	
	FuncOrganizer().SetLTFuncInfo(trFunction, strFuncName, strVar, strArg, strBody);
	return true;
}
///End CREATE_FITFUNC_WITH_INTEGRAL
	
///Jasmine 06/25/10 ORG390-P5 MOVE_FFW_HINTS_TO_TXT
//virtual 
string	FFWFitIntegralPage::GetPageHintsName(bool bNextPage/* = false*/)
{
	if ( !bNextPage )
		return "Integrand";
	else
		return "Integrand next page";
}
///End MOVE_FFW_HINTS_TO_TXT
/*------------------------------------------------------------------------------*
 * FFWFitIntegralPage End		 												*
 *------------------------------------------------------------------------------*/

#endif//_FFW_INTEGRAL_PAGE_H
