/*------------------------------------------------------------------------------*
 * File Name:	FBFunctionList.h												*
 * Creation: 	Danice															*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * DG 3/28/05 CREATE
 *------------------------------------------------------------------------------*/

#ifndef _FB_FUNCTION_LIST_H
#define _FB_FUNCTION_LIST_H

#include "FBFilter.h"
//--- CPY 10/3/05 CLASS_FORWARD_DECLARED_FOR_POINTER_ONLY
// code later not using pointer, so must include header
//class	OCFBSelCate;
//class	OCFBSearch;
class	OCFBSelCate
{
public:
	void	SelectCate(LPCSTR	lpcstrCate)
	{
		m_strSelectedCate = lpcstrCate;
		filterByCateSel();
	}
	void	GetCateTree(TreeNode& tr)
	{
		tr = m_trCate;
	}
private:
	bool	filterByCateSel()
	{
		if(!m_trCate.Load(STR_GF_INDEX_FILE_NAME))
			return	false;
		if(m_strSelectedCate.Compare(STR_ALL_CATEGORY) == 0)
			return	true;
		return	tree_filter_by_attrib_find(m_trCate, IDST_FB_FUNCTION, STR_CATEGORY_ATTRIB, m_strSelectedCate, false, true);
	}
private:
	Tree		m_trCate;
	string		m_strSelectedCate;
};

class	OCFBSearch
{
public:
	void	SetSource(const TreeNode& tr)
	{
		m_trSource = tr;
	}
	void	SetSearchText(LPCSTR	lpcstr)
	{
		m_strText = lpcstr;
		m_strText.TrimLeft();
		m_strText.TrimRight();
	}
	bool	GetResult(TreeNode& tr)
	{
		m_trResult = m_trSource;
		if(!m_strText.IsEmpty())
		{
			///Forest 4/5/05 SUPPORT_MATCH
			if(m_strText.FindOneOf("*?") >= 0)
			{
				if(!tree_filter_by_attrib_match(m_trResult, IDST_FB_FUNCTION, STR_LABEL_ATTRIB, m_strText))
					return	false;
			}
			///End SUPPORT_MATCH
			else if(!tree_filter_by_attrib_find(m_trResult, IDST_FB_FUNCTION, STR_LABEL_ATTRIB, m_strText))
				return	false;
		}
		tr = m_trResult;
		return	true;
	}
private:
	TreeNode	m_trSource;
	Tree		m_trResult;
	string		m_strText;
};

//---- end CLASS_FORWARD_DECLARED_FOR_POINTER_ONLY

class OCFBFunctionList : public GridListControl
{
public:
	void Init(int nID, WndContainer& dlg)
	{
		GridListControl::Init(nID, dlg);
		SetupRowsCols(0, 0, 1, 1);
	}
	void UpdateList()
	{
		if(!m_trList || 0 == m_trList.GetNodeCount())
		{
			ClearAll();
			return;
		}
		
		GridListControl::UpdateList(m_trList, STR_CATEGORY_ATTRIB);
	}
	
	TreeNode GetTreeNode(int nRow)
	{
		//TreeNode trNode = tree_get_node(m_trList, nRow, 0);//one level	///DG 4/18/05 REWRITE_TREE_GET_NODE
		TreeNode trNode = tree_get_node(m_trList, nRow, ATRN_STOP_LEVEL | 0);//one level
			
		return trNode;
	}
	void OnRowChange(int nRow)
	{
		m_trSelRow=GetTreeNode(nRow);
	}
	string GetCurrentDetail()
	{
		if(m_trSelRow)
		{
			return getFunctionDetail(m_trSelRow);
		}
		return "";
	}
	bool OnShowTips(int nRow)
	{
		TreeNode trSel=GetTreeNode(nRow);
		string strTips=getTips(trSel);
		SetToolTipsText(strTips);
		return true;
	}
	string	GetFunction()//get string 
	{
		string str;
		str.Empty();
		if(!m_trSelRow)
			return	str;
		return	m_trSelRow.Fu.strVal;
	}
	void	SelectCate(LPCSTR lpcstr)
	{
		m_Category.SelectCate(lpcstr);
		m_Category.GetCateTree(m_trList);
		//UpdateList();///Forest 04/06/05 UPDATE_ONLY_ONCE
	}
	void	SearchFunctions(LPCSTR lpcstr)
	{
		m_Search.SetSearchText(lpcstr);
		TreeNode	trAfterFilter;
		m_Filter.GetResult(trAfterFilter);
		m_Search.SetSource(trAfterFilter);
		m_Search.GetResult(m_trList);
		//UpdateList();///Forest 04/06/05 UPDATE_ONLY_ONCE
	}
	void	SelectFilter(LPCSTR lpcstr)
	{
		TreeNode	trCurCate;
		m_Category.GetCateTree(trCurCate);
		m_Filter.SetSource(trCurCate);
		m_Filter.SetFilterName(lpcstr);
		m_Filter.GetResult(m_trList);
		//UpdateList();///Forest 04/06/05 UPDATE_ONLY_ONCE
	}
	bool	OpenFilter(LPCSTR lpcstr)
	{
		TreeNode	trCurCate;
		m_Category.GetCateTree(trCurCate);
		m_Filter.SetSource(trCurCate);
		if(!m_Filter.OpenGUI(lpcstr))
			return	false;
		m_Filter.GetResult(m_trList);
		//UpdateList();///Forest 04/06/05 UPDATE_ONLY_ONCE
		return	true;
	}
	bool	GetSelectedFilterName(string& strDispName)
	{
		return	m_Filter.GetThemeName(strDispName);
	}
private:
	string getFunctionDetail(TreeNode trFunction)
	{
		string str;
		str.Empty();
		if(!trFunction)
			return	str;
		if(trFunction.DataID == IDST_FB_FUNCTION)
		{
			///Forest 4/5/05 SHOW_CATEGORY_INFO
			string strCategory;
			trFunction.GetAttribute(STR_CATEGORY_ATTRIB, strCategory);
			strCategory = strCategory.Left(strCategory.GetLength() - 1);//remove ">" at end
			str += "Category:\t" + strCategory + "\n\n";
			///End SHOW_CATEGORY_INFO
			str += "Prototype:\n";
			str += trFunction.Pr.strVal + "\n\n";
			str += "Function:\n";
			str += trFunction.Fu.strVal + "\n\n";
			str += "Description:\n";
			str += trFunction.De.strVal;
		}
		return	str;
	}
	string getTips(TreeNode tr)
	{
		string str;
		str.Empty();
		if(!tr)
			return	str;
		return	tr.Pr.strVal;
	}
private:
	OCFBSelCate					m_Category;
	OCFBFilter					m_Filter;
	OCFBSearch					m_Search;

	Tree			m_trList;//tree list shown
	
	TreeNode		m_trSelRow;
};


#endif //_FB_FUNCTION_LIST_H