 /*------------------------------------------------------------------------------*
 * File Name: ExtractWksData 													*
 * Creation : Sim 04-13-2009													*
 * Purpose: OriginC Source H file												*
 * Copyright (c) Originlab Corp.	2006										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Sophy 8/7/2009 v8.1088 EXTRACT_WKS_DATA_SAVE_RECALCULATE_MODE_TO_SOURCE_SHEET*
 *	Folger 10/14/2010 ORG-1259-P1 EXTRACT_WKS_DATA_SHOULD_NOT_ACTIVE_OUTPUT_SHEET_WHEN_RECALCULATE
 *	Folger 10/15/2010 ORG-1258 ADD_SELECT_OPTION_IN_WORKSHEET_QUERY				*
 *	Folger 05/17/2012 ORG-5725-P1 WORKSHEET_QUERY_CORRCTLY_ENABLE_AUTO_UPDATE_NODE
 *------------------------------------------------------------------------------*/
 
#ifndef EXTRACT_WKS_DATA_H
#define EXTRACT_WKS_DATA_H

#define		STR_EXTRACTED_FROM			"Extracted From "


enum
{
	EXD_TEST = -2, 		// Change the backgroud color of the extracted cell
	EXD_MASK = -1, 			// Mask the extracted cell
	//---CPY 6/16/06, the following match the radio control IDs on the dialog
	
	///Folger 04/11/07 ADD_COLOR_SPECIFIER
	//EXD_NEW_LAYER,		// New a layer to hold the extracted data
	//EXD_NEW_PAGE,		// New a page to hold the extracted data
	//EXD_REPLACE,		// Replace the old data with the extracted data
	//EXD_ADD_ROW_INDEX, 	// Add a new column to hold the value that the extracted row is 1 else is 0
	EXD_ADD_ROW_INDEX = 0,
	EXD_NEW_LAYER,
	EXD_NEW_PAGE,
	EXD_REPLACE,
	EXD_COLOR,
	///End ADD_COLOR_SPECIFIER
	///------ Folger 10/15/2010 ORG-1258 ADD_SELECT_OPTION_IN_WORKSHEET_QUERY
	EXD_TEST_EX,
	///------ End ADD_SELECT_OPTION_IN_WORKSHEET_QUERY
	
	EXD_SIZE,
};

enum
{
	EXT_WKS_DATA_ALIAS_BRANCH_ID = GET_USER_DATAID(0),
	EXT_WKS_DATA_ALIAS_COLUMNS_ID,
	EXT_WKS_DATA_ALIAS_NAMES_ID,

	EXT_WKS_DATA_CONDITION_BRANCH_ID,
	EXT_WKS_DATA_CONDITION_ID,
	EXT_WKS_DATA_BEFORELOOP_ID,
	EXT_WKS_DATA_BEFOREIFCONDITION_ID,
	
	EXT_WKS_DATA_METHOD_BRANCH_ID,
	EXT_WKS_DATA_METHOD_ID,
	EXT_WKS_DATA_COL_FILTER_ID,
	EXT_WKS_DATA_WKS_SPECIFIED_ID,
	EXT_WKS_DATA_COL_FROM_ID,
	EXT_WKS_DATA_COL_TO_ID,
	EXT_WKS_DATA_COLOR_ID,
	
	EXT_WKS_DATA_COLUMNS_ID,
	
	EXT_WKS_DATA_ROW_RANGE_BRANCH_ID,
	EXT_WKS_DATA_ROW_RANGE_FROM_ID,
	EXT_WKS_DATA_ROW_RANGE_TO_ID,
	
	EXT_WKS_DATA_RECAL_MODE_ID, ///Sophy 8/7/2009 v8.1088 EXTRACT_WKS_DATA_SAVE_RECALCULATE_MODE_TO_SOURCE_SHEET
};


class ExtractWksDataAlias
{
public:
	bool GetTree(TreeNode& tr);
	bool SetTree(const TreeNode& tr);

	// for running in LT
	string			GetAliasLTScript();

	// for store in file
	string			GetAliasLines();
	bool			SetAliasLines(LPCSTR lpcszAliases);
	
public:
	vector<uint>	vnCols;
	vector<string>	vsAliasNames;
};

class ExtractWksDataCondition
{
public:
	bool GetTree(TreeNode& tr);
	bool SetTree(const TreeNode& tr);
public:
	string			strCondition;
	string			strBeforeLoop;
	string			strBeforeIfCondition;
};

class ExtractWksDataMethod
{
public:
	ExtractWksDataMethod()
	{
		nMethod = EXD_NEW_PAGE;
		nColFilter = -1;
		strWksSpecified.Empty();
		nColFrom = -1;
		nColTo = -1;
		nColor = 1;
	}
	
public:
	bool GetTree(TreeNode tr);
	bool SetTree(const TreeNode& tr);
	
public:
	int		nMethod;

	int		nColFilter;
	
	string	strWksSpecified;
	int		nColFrom;
	int		nColTo;
	
	int		nColor;
};

class ExtractWksRowRange
{
public:
	ExtractWksRowRange()
	{
		nRowFrom = 0;
		nRowTo = -1;
	}
	
public:
	bool GetTree(TreeNode& tr);
	bool SetTree(const TreeNode& tr);
	
public:
	int 						nRowFrom;
	int 						nRowTo;
};

///------ Folger 10/15/2010 ORG-1258 ADD_SELECT_OPTION_IN_WORKSHEET_QUERY
struct RecalculateSettings 
{
	int		nMode;
	int		nEnable;
	int		nEnableInitial; ///------ Folger 05/17/2012 ORG-5725-P1 WORKSHEET_QUERY_CORRCTLY_ENABLE_AUTO_UPDATE_NODE
};
///------ End ADD_SELECT_OPTION_IN_WORKSHEET_QUERY

class ExtractWksDataSettings
{
public:
	///------ Folger 10/15/2010 ORG-1258 ADD_SELECT_OPTION_IN_WORKSHEET_QUERY
	ExtractWksDataSettings();
	///------ End ORG-1258 ADD_SELECT_OPTION_IN_WORKSHEET_QUERY
	///------ Folger 05/17/2012 ORG-5725-P1 WORKSHEET_QUERY_CORRCTLY_ENABLE_AUTO_UPDATE_NODE
	//bool GetTree(TreeNode& tr);
	bool GetTree(TreeNode& tr, bool bFromAutoUpdate = false);
	///------ End WORKSHEET_QUERY_CORRCTLY_ENABLE_AUTO_UPDATE_NODE
	bool SetTree(const TreeNode& tr);
	
public:
	ExtractWksDataAlias			stAlias;
	ExtractWksDataCondition		stCondition;
	ExtractWksDataMethod		stMethod;
	
	vector<uint>				vnCols;
	
	ExtractWksRowRange			stRowRange;
	
	///Sophy 8/7/2009 v8.1088 EXTRACT_WKS_DATA_SAVE_RECALCULATE_MODE_TO_SOURCE_SHEET
	///------ Folger 10/15/2010 ORG-1258 ADD_SELECT_OPTION_IN_WORKSHEET_QUERY
	//int							nRecalMode;
	RecalculateSettings			stRecalculate;
	///------ End ADD_SELECT_OPTION_IN_WORKSHEET_QUERY
	///end EXTRACT_WKS_DATA_SAVE_RECALCULATE_MODE_TO_SOURCE_SHEET
};

///------ Folger 10/14/2010 ORG-1259-P1 EXTRACT_WKS_DATA_SHOULD_NOT_ACTIVE_OUTPUT_SHEET_WHEN_RECALCULATE
enum
{
	EXTRACT_NOT_ACTIVE_OUTPUT_SHEET			= 0x00010000,
};
///------ End EXTRACT_WKS_DATA_SHOULD_NOT_ACTIVE_OUTPUT_SHEET_WHEN_RECALCULATE

class ExtractWksData
{
public:
	void	SetSettings(const ExtractWksDataSettings& settings);
	void	GetSettings(ExtractWksDataSettings& settings);
	
	///------ Folger 10/14/2010 ORG-1259-P1 EXTRACT_WKS_DATA_SHOULD_NOT_ACTIVE_OUTPUT_SHEET_WHEN_RECALCULATE
	//bool	Extract(Worksheet& wksSource, Worksheet& wksDestination = NULL, int* pnC1 = NULL, int* pnC2 = NULL);
	bool	Extract(Worksheet& wksSource, Worksheet& wksDestination = NULL, int* pnC1 = NULL, int* pnC2 = NULL, DWORD dwOptions = 0);
	///------ End EXTRACT_WKS_DATA_SHOULD_NOT_ACTIVE_OUTPUT_SHEET_WHEN_RECALCULATE
	
	int		GetNumRows();

	void	ClearCache();
	
protected:
	bool	SelectRows(const Worksheet& wksSource);
	
	bool	ShowSelection(Worksheet& wksSource);
	bool	ShowMask(Worksheet& wksSource);
	bool	NewCol(Worksheet& wksSource, const int* pnC1 = NULL);
	bool	ShowColor(Worksheet& wksSource);
	
	void	ScrollResultToView(Worksheet& wks);

private:
	bool prepareBeforeSelectRows(	const Worksheet& wksSource, int& nRowFrom, int& nRowTo,
									string& strCondition, string& strBeforeLoop, string& strBeforeIfCondition);
	void setAlias(const ExtractWksDataAlias& stAliasSrc, ExtractWksDataAlias& stAliasDest);
	void setCondition(const ExtractWksDataCondition& stConditionSrc, ExtractWksDataCondition& stConditionDest);
	void setMethod(const ExtractWksDataMethod& stMethodSrc, ExtractWksDataMethod& stMethodDest);
	void setRowRange(const ExtractWksRowRange& stRowRangeSrc, ExtractWksRowRange& stRowRangeDest);

private:
	ExtractWksDataSettings	m_settings;
	
	vector<uint>	m_vnRowIndices;
	DWORD			m_dwDirtyBits;
	
	ExtractWksRowRange			m_stLastExtRowRange;
};

bool save_extract_settings_to_wks_storage(Worksheet &wks, const TreeNode& tr);
bool load_extract_settings_to_wks_storage(const Worksheet &wks, TreeNode& tr);

string get_completed_book_sheet_name(LPCSTR lpcszSpecifiedWksName);
bool get_dest_wks(Worksheet &wksDest, LPCSTR lpcszSpecifiedWksName, const Worksheet &wksSrc);
void get_specified_col_index(int &nC1, int &nC2, const ExtractWksDataSettings& settings, const Worksheet &wks, const int *pnC1 = NULL, const int *pnC2 = NULL);


#endif // EXTRACT_WKS_DATA_H
