/*------------------------------------------------------------------------------*
 * File Name: LayerContents				 										*
 * Creation:  Kit Chen															*
 * Purpose: New Layer Contents													*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Iris 1/13/2011 ORG-1962-P6 FIX_FAIL_TO_OPEN_ROWRANGE_DLG						*
 *  Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG		*
 *  Iris 3/10/2011 ORG-2371-P1 FIX_LC_RESCALE_ISSUE								*
 *	Kit 04/21/2011 ORG-2690-P1 GET_BOOK_NAME_FAIL_AFTER_COL_SORTED				*
 *	Bill 04/27/2011 ORG-2473 MOVE_COL_HELPER_MOVE_TO_GRIDCONTROL				*
 *	Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN	*
 *	Kit 04/28/2011 CLEAN_UP_CODE												*
 *	Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT						*
 *	Kit 05/18/2011 ORG-2614-S2 NOT_SHOW_BOOK_LN_COL_BY_DEFAULT					*
 *  Iris 6/14/2011 ORG-2857-P2 SHOW_ERR_MSG_FOR_NOT_SUPPORTED_PLOT_TYPE			*
 *	Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP*
 *	Folger 05/30/2012 ORG-5738-S1 LAYER_CONTENT_OC_FILTER_FUNCTION_EVENT_SUPPORT*
 *	Folger 06/26/2012 ORG-5528-P22 SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT		*
 *	Tony 07/04/2012 ORG-2893-S1 ADD_BOOK_NAMING_COLUMN							*
 *------------------------------------------------------------------------------*/ 
#ifndef _LAYERCONTENTS_H
#define _LAYERCONTENTS_H

#include "DialogEx.h"	 
#include <TreeEditor.h>	
#include <Array.h>

#define		SUPPORT_COMMON_UDLS  /// Iris 01/17/2011 ORG-1986-P1 SHOW_COMMON_UDLS

/// Bill 04/27/2011 ORG-2473 MOVE_COL_HELPER_MOVE_TO_GRIDCONTROL
#ifndef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
class MoveColHelper;	///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
/// End MOVE_COL_HELPER_MOVE_TO_GRIDCONTROL

#define STR_DLG_NAME		_L("LayerContentsDlg")

///Jasmine 12/29/10 ORG-1826-S1-3 HIDE_SHOW_SAME_NAME_COL
#define WM_USER_MSG_ON_HIDE_COL				(WM_USER + 999)
enum{
	HIDE_COL 			= 0x00000001,
	HIDE_DATALIST_COL 	= 0x00000002,
};
///End HIDE_SHOW_SAME_NAME_COL
///Jasmine 12/29/10 ORG-1826-S1-3 COL_AUTO_WIDTH
#define	MENU_AUTO_SIZE_COL_ID		1000
/// Iris 2/23/2012 ORG-5124-S1 ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB
//#define	STR_COL_AUTO_WIDTH_MENU		_L("Auto Column Widths")
///End ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB
///End COL_AUTO_WIDTH

#define		STR_RIGHT_CLICK_ROW_HEADER_TOOL_TIP				_L("Right click in column header to select columns")/// Bill 02/24/2011 ORG-2331-S1 ADD_TOOL_TIP_TO_LAYER_CONTENT_DLG

#define STR_DATASET_LIST_HEADER_HIDE_E "HeaderHide"

/// Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
//#define STR_AVAIL_DATA		_L("Worksheets in Folder|Worksheets in Project|Worksheets in Favorites|Matrices in Folder|Matrices in Project|Matrices in Favorites|Virtual Matrices|Loose Datasets|Function Plots")//|Custom Filter")
/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
///Jasmine 01/20/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA

/// Bill 02/24/2011 ORG-2331-S3 LAYER_CONTENTS_DLG_LAYOUT_RENAME
//#define STR_AVAIL_DATA_WKS_IN_GLAYER	_L("Related Worksheets on Graph")
#define STR_AVAIL_DATA_WKS_IN_GLAYER	_L("Worksheets associated with Graph")
/// End LAYER_CONTENTS_DLG_LAYOUT_RENAME

/// Bill 03/09/2011 ORG-2331-S3 LAYER_CONTENTS_DLG_LAYOUT_RENAME
//#define STR_AVAIL_DATA_MAT_IN_GLAYER	_L("Related Matrices on Graph")
#define STR_AVAIL_DATA_MAT_IN_GLAYER	_L("Matrices associated with Graph")
/// End LAYER_CONTENTS_DLG_LAYOUT_RENAME
///End FILTER_GRAPH_SOURCE_DATA

/// Bill 02/24/2011 ORG-2331-S3 LAYER_CONTENTS_DLG_LAYOUT_RENAME
//#define STR_AVAIL_DATA_WKBOOK_IN_GLAYER _L("Related Workbooks on Graph") /// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
#define STR_AVAIL_DATA_WKBOOK_IN_GLAYER _L("Workbooks associated with Graph")
/// End LAYER_CONTENTS_DLG_LAYOUT_RENAME

#define STR_GROUP_LIST		_L("Group|Plot")

// Parameters and User-Defined Label only show the first one.
//#define STR_DATASET_LIST_HEADERS		_L("Sheet|SName|LName|Units|Comments|1st Value|Parameters|User-Defined Labels|Position")
/// Iris 1/12/2011 SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
//#define STR_DATASET_LIST_HEADERS		_L("Folder|Book|Sheet|Dataset Name|Short Name|Long Name|Units|Comments|1st Value|Parameters|User-Defined Labels|Position")
//static vector<uint> s_vnDatasetListColsDefaultHidden = {1,0,0,1,0,0,1,1,1,1,1,1};
/// Kenny 08/19/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
//#ifdef SUPPORT_COMMON_UDLS
/////-----Kit 02/24/2011 ORG-1837-S3 ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL
////#define STR_DATASET_LIST_HEADERS		_L("Folder|Book|Sheet|Dataset Name|Short Name|Long Name|Units|Comments|1st Value|Status|Position|Parameters|Parameters 2|Parameters 3|User-Defined Labels|User-Defined Labels 2|User-Defined Labels 3")
////static vector<uint> s_vnDatasetListColsDefaultHidden = {1,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1};///Jasmine 02/12/11 ORG-2046-S2 HIDE_STATUS_COL_BY_DEFAULT
//
/////-----Kit 04/21/2011 ORG-2690-P1 GET_BOOK_NAME_FAIL_AFTER_COL_SORTED
//// #define STR_DATASET_LIST_HEADERS		_L("Folder|Book|Sheet|Dataset Name|Long Name|Short Name|Units|Comments|1st Value|Status|Position|Parameters|Parameters 2|Parameters 3|User-Defined Labels|User-Defined Labels 2|User-Defined Labels 3|[Book]Sheet!Col")
//// static vector<uint> s_vnDatasetListColsDefaultHidden = {1,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1};
//
/////-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
////#define STR_DATASET_LIST_HEADERS		_L("Folder|Book|Sheet|Dataset Name|Long Name|Short Name|Units|Comments|1st Value|Status|Position|Parameters|Parameters 2|Parameters 3|User-Defined Labels|User-Defined Labels 2|User-Defined Labels 3|[Book]Sheet!Col|Book Long Name")
////static vector<uint> s_vnDatasetListColsDefaultHidden = {1,0,0, 1,0,0, 1,1,1, 1,1,1, 1,1,1, 1,1,1, 1};
//#define STR_DATASET_LIST_HEADERS		_L("Folder|Book Long Name|Book Short Name\
											//|Sheet|Dataset Name|Long Name\
											//|Short Name|Units|Comments\
											//|1st Value|Status|Position\
											//|Parameters|Parameters 2|Parameters 3\
											//|User-Defined Labels|User-Defined Labels 2|User-Defined Labels 3\
											//|[Book]Sheet!Col")
//
//static vector<uint>	s_vnDatasetListColsDefaultHidden = {
														/////-----Kit 05/18/2011 ORG-2614-S2 NOT_SHOW_BOOK_LN_COL_BY_DEFAULT
														////1,0,0
														//1,1,0
														/////-----End NOT_SHOW_BOOK_LN_COL_BY_DEFAULT
														//,0,1,0
														//,0,1,1
														//,1,1,1
														//,1,1,1
														//,1,1,1
														//,1};
//
/////-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
/////-----End GET_BOOK_NAME_FAIL_AFTER_COL_SORTED
/////-----End ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL
//#else
/////-----Kit 02/24/2011 ORG-1837-S3 ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL
//// #define STR_DATASET_LIST_HEADERS		_L("Folder|Book|Sheet|Dataset Name|Short Name|Long Name|Units|Comments|1st Value|Status|Position|Parameters|Parameters 2|Parameters 3")
//// static vector<uint> s_vnDatasetListColsDefaultHidden = {1,0,0,1,0,0,1,1,1,1,1,1,1,1};///Jasmine 02/12/11 ORG-2046-S2 HIDE_STATUS_COL_BY_DEFAULT
/////-----Kit 04/21/2011 ORG-2690-P1 GET_BOOK_NAME_FAIL_AFTER_COL_SORTED
//// #define STR_DATASET_LIST_HEADERS		_L("Folder|Book|Sheet|Dataset Name|Long Name|Short Name|Units|Comments|1st Value|Status|Position|Parameters|Parameters 2|Parameters 3|[Book]Sheet!Col")
//// static vector<uint> s_vnDatasetListColsDefaultHidden = {1,0,0,1,0,0,1,1,1,1,1,1,1,1,1};
//
/////-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
////#define STR_DATASET_LIST_HEADERS		_L("Folder|Book|Sheet|Dataset Name|Long Name|Short Name|Units|Comments|1st Value|Status|Position|Parameters|Parameters 2|Parameters 3|[Book]Sheet!Col|Book Long Name")
////static vector<uint> s_vnDatasetListColsDefaultHidden = {1,0,0, 1,0,0, 1,1,1, 1,1,1, 1,1,1, 1};
//#define STR_DATASET_LIST_HEADERS		_L("Folder|Book Long Name|Book Short Name\
											//|Sheet|Dataset Name|Long Name\
											//|Short Name|Units|Comments\
											//|1st Value|Status|Position\
											//|Parameters|Parameters 2|Parameters 3\
											//|[Book]Sheet!Col")
//
//
//static vector<uint> s_vnDatasetListColsDefaultHidden = {
														/////-----Kit 05/18/2011 ORG-2614-S2 NOT_SHOW_BOOK_LN_COL_BY_DEFAULT
														////1,0,0
														//1,1,0
														/////-----End NOT_SHOW_BOOK_LN_COL_BY_DEFAULT
														//,0,1,0
														//,0,1,1
														//,1,1,1
														//,1,1,1
														//,1};
/////-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
/////-----End GET_BOOK_NAME_FAIL_AFTER_COL_SORTED
/////-----End ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL
//#endif 
/////End SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP

#define SQL_STR_SEL_VM_FROM_PROJECT		"Select VIRTUALMATRIX from Project"	///-----Kit 03/01/2011 ORG-2319-P1 RUNTIME_ERROR_WHEN_GET_BOOK_SHEET_COL_TOOLTIP

/// Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
#define SQL_STR_SEL_NAMED_RANGE_WKS_FROM_PROJ	"Select NAMEDRANGE from project where _DatasetType == DEP"
/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP

#define	COL_SEP				'\t'
#define PLOT_ID_FOR_AUTO	-1

#define	MAX_COMMON_UDLS_NUM		3
#define MAX_COMMON_SYS_PARAM_LABELS_NUM		3
enum DatasetListDataType
{
	COL_FIRST_ONE,
	COL_FOLDER = COL_FIRST_ONE,			//	0
	COL_BOOK_NAME,			///------ Tony 07/04/2012 ORG-2893-S1 ADD_BOOK_NAMING_COLUMN
	COL_BOOK_LN,
	COL_BOOK_SN,
	COL_SHEET,
	COL_DSNAME,
	COL_LNAME,
	COL_SNAME,
	COL_UNITS,
	COL_COMMENTS,
	COL_1ST_VALUE,
	COL_STATUS,			///Jasmine 01/20/10 ORG-2046-S2 FILTER_DATA_WITH_LOCK_STATUS
	COL_INDEX,
	COL_PARAMS,
	/// Iris 1/12/2011 SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
	COL_PARAMS2,
	COL_PARAMS3,						//	15
	///End SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
#ifdef SUPPORT_COMMON_UDLS	
	COL_UDL_BEGIN,
	COL_UDL = COL_UDL_BEGIN,			//	16
	/// Iris 1/12/2011 SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
	COL_UDL2,							
	COL_UDL3,							//	18
	COL_UDL_END = COL_UDL3,	
#endif //SUPPORT_COMMON_UDLS
	///End SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
	
	COL_BOOK_SHEET_COL, ///-----Kit 02/24/2011 ORG-1837-S3 ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL	//	19
	
	/// Kenny 08/19/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
#ifdef NEW_NAMED_RANGE_FEATURE
	COL_SCOPE,
#endif // NEW_NAMED_RANGE_FEATURE
	/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	
	///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	//COL_BOOK_LN,	///-----Kit 04/21/2011 ORG-2690-P1 GET_BOOK_NAME_FAIL_AFTER_COL_SORTED
	///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	COL_LAST_ITEM
};

#define STR_AVAIL_DATA_TYPE_REG				"AvailComboSel"
#define STR_AVAILDATA_TYPE_RELATED_WKS  	"RelatedWks"
#define STR_AVAILDATA_TYPE_RELATED_MAT  	"RelatedMat"
#define STR_AVAILDATA_TYPE_RELATED_WKBOOK	"RelatedWkbook" /// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
#define STR_AVAILDATA_TYPE_CUSTOM_FUNC  	"CustomFunc"

enum AvailDataComboType
{
	WKS_FOLDER = 0,
	WKS_PROJECT,
	WKS_FAVS,
	MAT_FOLDER,
	MAT_PROJECT,
	MAT_FAVS,
	VIRTUAL_MAT,
	/// Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
#ifdef NEW_NAMED_RANGE_FEATURE
	NAMED_RANGE_WKS,
#endif // NEW_NAMED_RANGE_FEATURE
	/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	LOOSE_DS,
	FUNC_PLOT,
	/// Iris 1/27/2011 ORG-2046-S5 NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	RELATED_WKS, // 9
	RELATED_WKBOOK, /// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	RELATED_MAT,
	///End NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	CUSTOM_FILTER_BEGIN, //11
};

enum FolderType
{
	FLD_TYPE_CURRENT_FLD,
	FLD_TYPE_FAVS_FLD,
	FLD_TYPE_PROJECT	
};

struct MakeDataPlotTreeAttribute
{
	string strBook;
	string strSheet;
	vector<string> vsDSName;
	vector<uint> vuDesig;
};

struct PlotInfo
{
	string strPageName;
	string strLayerName;
	string strColPattern;
	vector<uint> vuColDesignations;
	vector<string> vsColNames;
	int nPlotType;
	DWORD dwAuxTypeInfo;
	DWORD dwLTPlotInfo;
	int arrRangeRows[2]; /// Iris 12/03/2010 ORG-864-P3 FIX_NOT_KEEP_ROWS_RANGE_WHEN_CHANGE_PLOT_TYPE, points to two integers for the row range to use 
	bool bShow; /// Iris 01/10/2011 FIX_CHANGE_PLOTTYPE_NOT_KEEP_SHOWINFO
};

///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
enum ErrorInfo
{
	Err_NoError, 
	Err_CanNotAdd2DPlotTo3DLayer,
	///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
	Err_CurrentPlotTypeNeedAllColsInSameWks,
	Err_SelColsNumIsNotCorrespondThePlotType,
	///-----End LC_SHOULD_SUPPORT_XYAM_PLOT
	Err_CurrentPlotTypeNotSupportInLC, /// Iris 6/14/2011 ORG-2857-P2 SHOW_ERR_MSG_FOR_NOT_SUPPORTED_PLOT_TYPE
	Err_ErrorUnknow,
};
///-----End SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER

#define 	HAS_COLDESIG_SIZE( _TypeInfo ) (_TypeInfo & PCD_MODIFIER_SIZE )
#define 	HAS_COLDESIG_COLOR( _TypeInfo ) (_TypeInfo & PCD_MODIFIER_COLOR )
#define 	HAS_COLDESIG_SIZE_AND_COLOR( _TypeInfo ) (HAS_COLDESIG_SIZE( _TypeInfo ) && HAS_COLDESIG_COLOR( _TypeInfo ))
#define 	HAS_NO_COLDESIG_SIZE_AND_COLOR(_TypeInfo) ( !HAS_COLDESIG_SIZE(_TypeInfo) && !HAS_COLDESIG_COLOR(_TypeInfo) )

#define		CHECK_VECTOR_IS_EMPTY( _vec ) ( 0 == (_vec.GetSize()) )
#define		CHECK_IS_SEL_FIX_ROW( _vuSelRows ) ( (_vuSelRows.GetSize() > 0) && (_vuSelRows[0] == 0) )

bool is_plottype_the_same(  int nPlotType1, DWORD dwAuxTypeInfo1, DWORD dwLTPlotInfo1,
									int nPlotType2, DWORD dwAuxTypeInfo2, DWORD dwLTPlotInfo2, bool bIgnoreColorSize = false );
bool check_tree_node_tagName_is_DataPlot( const TreeNode &trNode );
bool make_plot_tree( TreeNode &trPlot, const PlotInfo &plotInfo, DWORD dwView );
bool has_both_z_and_other_column_selected( const vector<int> &vnSelColTypes );

///-----Kit 01/07/2011 ORG-864-P1 DISABLE_ADD_PLOT_BTN_WHEN_SEL_ROW_IS_WKS_TYPE_AND_PLOT_TYPE_IS_MAT_USE_ONLY
/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
//bool	has_only_z_column_selected( const vector<int> &vnSelColTypes );
bool has_only_one_column_type_selected( const vector<int> &vnSelColTypes, int nColType );
///End IMPROVE_PLOTTYPE_CHECK
bool	is_matrix_plot_id( int nPlotID );
///-----

bool get_bmp_src_id_and_bmp_index_by_plot_id(int nPlotID, int &nBmpSrcID, int &nBmpIndex);///-----Kit 03/02/2011 ORG-1837-S4 BIMMAP_BTN_NOT_UPDATE_ON_INIT_DLG

bool is_xyz_plot(const TreeNode& trPlot);	///Jasmine 09/25/2012 ORG-6105-P2 GROUPING_NOT_AVAILABLE_FOR_XYZ_PLOT


/// Kenny 08/19/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
class DatasetListColInfo
{
public:
	DatasetListColInfo(LPCTSTR lpcszColname, bool bHidden)
	{
		strColName		= lpcszColname;
		bDefaultHidden	= bHidden;
	}
	string	strColName;
	bool	bDefaultHidden;
};

typedef Array<DatasetListColInfo&>	DatasetListColInfoArray;

const DatasetListColInfoArray&	GetDatasetListColInfo();
/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP

class DatasetListHelperBase;
class DatasetList : public GridListControl
{
public:
	/// Kenny 08/19/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	//DatasetList(UINT uID, WndContainer &Dlg, LPCTSTR lpcstrHeading);
	DatasetList(UINT uID, WndContainer &Dlg);
	/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	~DatasetList();
	
	//virtual
	string	GetClassName() { return "DatasetList"; }
	
	void	AddRow( LPCTSTR lpcstrListRow, int nRow = -1 ) {	m_flx.AddItem( lpcstrListRow, nRow ); }
	int		DelObjects();
	///Jasminie 02/14/11 ORG-2100-P8 SHOW_SOURCE_DATA_FOR_TEMP_PLOT
	//void	UpdateDatasetList( AvailDataComboType availDataType );
	//bool	QueryResultAndUpdateList( AvailDataComboType availDataType, bool bFromIncShortcutWndChanged ); /// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
	void	UpdateDatasetList( AvailDataComboType availDataType, const vector<string>& vsBookSheets = NULL );
	bool	QueryResultAndUpdateList( AvailDataComboType availDataType, const vector<string>& vsBookSheets = NULL, bool bFromIncShortcutWndChanged = false );
	///End SHOW_SOURCE_DATA_FOR_TEMP_PLOT
	bool 	UpdateBlodStatusByDatasetNames(vector<string>& vsDSNames); /// Iris 12/23/2010 ORG-1826-S1.5 SET_BOLD_FONT_ON_PLOTTED_DATASETS
	bool	UpdateBlodStatusForSelectedRows();
	bool	SetSelectionByDatasetNames(vector<string>& vsDSNames); /// Iris 12/29/2010 ORG-1826-S7 HIGHLIGHT_ADDED_OR_REMOVED_PLOTS
	void 	OnBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, bool* pCancel);	
	void	OnContextMenu(int nx, int ny);	///Sophy 2/7/2012 ORG-4478-P6 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	///Jasmine 01/04/11 ORG-1826-S8 MOVE_COLUMN_ORDER
	int 	GetColPos(int nType);
	int 	GetColType(int nPosition);
	void 	OnAfterMoveColumns(Control ctrl, long lCol, long *pnPosition);
	///End MOVE_COLUMN_ORDER
	
	FolderType	GetFolderType( AvailDataComboType availDataType );	
	bool	IsAvailableColumn(int nCol);
	bool	IsLastShownCol(int nCol);
	void 	InitColsShowHidden();
	
	/// Iris 01/17/2011 ORG-1986-P1 SHOW_COMMON_UDLS
#ifdef SUPPORT_COMMON_UDLS
	/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
	//string	GetCommonUDLName(int index);
	string	GetCommonParametersLabelName(int index, bool bIsBuildIn);
	int GetCommonParametersLabelNumber(bool bIsBuildIn);
	///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
#endif
	///End SHOW_COMMON_UDLS
	
	int		GetType(){ return m_pDatasetListHelper->GetType(); }

	bool	GetDataPlotsTree( int nPlotID, DWORD dwLayerBits, TreeNode &trPlots );

	string	GetSelRowDataSheetName( int nSelRow );
	bool 	GetSelColTypes( vector<int> &vnColTypes );
	///Jasmine 01/04/11 ORG-1826-S8 MOVE_COLUMN_ORDER
	void	InitColsOrder();
	void 	SaveColsOrder();
	///End MOVE_COLUMN_ORDER
	
	bool	IsSelectionReady() { return m_bIsSelectionReady; } /// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_REMOVE_PLOTS_SPEED
	
	///Jasmine 01/21/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
	//void 	InitDynamicAvailDataType(int nWksInGLayerItem, int nMatInGLayerItem);
	/// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	void 	InitDynamicAvailDataType(int nWksInGLayerItem, int nWkbookInGLayerItem, int nMatInGLayerItem);
	///End ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	bool 	IsFilterByFunction(AvailDataComboType availDataType, int& nFilterFuncIndex);
	///End FILTER_GRAPH_SOURCE_DATA
	
	///Jasminie 02/14/11 ORG-2100-P8 SHOW_SOURCE_DATA_FOR_TEMP_PLOT
	int		GetWksInGLayerDropdown();
	int		GetWBookInGLayerDropdown();
	int		GetMatInGLayerDropdown();
	
	int		CheckGetCommonPageTypesInSelection(vector<int>& vnTypes);
	///End SHOW_SOURCE_DATA_FOR_TEMP_PLOT

	///-----Kit 02/25/2011 ORG-2319-S1 SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW
	bool	FindRowIndexesByDatasetName(const vector<string> &vsDSNames, vector<int> &vnRowIndexes);
	///-----End SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW

	///-----Kit 04/14/2011 ORG-2614-P1 FAILED_GET_CORRECT_BOOK_WHEN_THE_BOOKS_HAVE_SAME_LN
	// cover the GridControl method
	///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	//_VARIANT GetCell(CellPropertySettings settings, int nRow, int nCol);
	///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	///-----End FAILED_GET_CORRECT_BOOK_WHEN_THE_BOOKS_HAVE_SAME_LN
	
	ErrorInfo	GetLastError(){ return m_errLast; }	///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
	
private:
	string 	getRegSectionName(LPCSTR lpczSection);///Jasmine 01/05/11 ORG-1826-S8 MOVE_COLUMN_ORDER
	/// Kenny 08/19/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	//void	setListHeading(LPCTSTR lpcstrHeading);
	void	setListHeading();
	/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	/// Iris 1/13/2011 ORG-1962-P6 FIX_FAIL_TO_OPEN_ROWRANGE_DLG
	//bool	makePlotTree( const MakeDataPlotTreeAttribute &DPTAttr, DWORD dwLayerBits, TreeNode &tr, DWORD dwCntrl = DPEDTVIEW_HIDE_STYLEHOLDERS );
	/// Iris 3/10/2011 ORG-2371-P1 FIX_LC_RESCALE_ISSUE
	//bool	makePlotTree( const MakeDataPlotTreeAttribute &DPTAttr, DWORD dwLayerBits, TreeNode &tr, DWORD dwCntrl = DPEDTVIEW_HIDE_STYLEHOLDERS | DPEDTVIEW_HIDE_LIMITS );
	bool	makePlotTree( const MakeDataPlotTreeAttribute &DPTAttr, DWORD dwLayerBits, TreeNode &tr, DWORD dwCntrl = DPEDTVIEW_HIDE_STYLEHOLDERS  );
	///End FIX_LC_RESCALE_ISSUE
	///End FIX_FAIL_TO_OPEN_ROWRANGE_DLG
	int		getPageTypeByFilterObjectType();
	
	int 	getPageTypeByFilterObjectType(QUERYRESULTBUILD nQueryObjectType);
	/// Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	//int 	convertToPageType( AvailDataComboType availDataType, QUERYRESULTBUILD nQueryObjectType, bool* pbIsVitualMatrix );
	int 	convertToPageType( AvailDataComboType availDataType, QUERYRESULTBUILD nQueryObjectType);
	/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	void	autoResizeCols();

	/// Iris 01/17/2011 ORG-1986-P1 SHOW_COMMON_UDLS	
	void 	setColValues(const vector<string>& vsColInfo, int nColPos);	
#ifdef SUPPORT_COMMON_UDLS
	/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
	/*
	void 	updateCommonUDLColumns(int nColType);	
	bool	getCommonUDLNames(); 
	*/
	void 	updateParametersLabelColumns(int nColType, bool bIsBuildIn);
	bool 	getSpecialLabelCommonNames();
	///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
#endif //SUPPORT_COMMON_UDLS
	///End SHOW_COMMON_UDLS

public:
	QueryResult 		m_qr;
	QUERYRESULTBUILD	m_nQueryObjectType;
	DatasetListHelperBase 	*m_pDatasetListHelper;
	
private:
	vector<int> 			m_vnBoldRows; /// Iris 01/04/2011 ORG-1646-P1 SETBOLD_CAUSE_SLOW_SPEED
	MoveColHelper			*m_colMap;		///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
	bool					m_bColResized; /// Iris 01/05/2011 ORG-1826-P5 COL_GOOD_DEFAULT_SIZE_AND_REMEMBER_SIZE_WHEN_REOPEN_DLG
	
	/// Iris 01/17/2011 ORG-1986-P1 SHOW_COMMON_UDLS
#ifdef SUPPORT_COMMON_UDLS
	vector<string>			m_vsCommonUDLNames; 
	/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
	vector<string>			m_vsCommonSystemParamLabelNames;
	vector<uint>			m_vsCommonSystemParamLabelTypes;
	///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
	bool					m_bCheckCommonFinished;
#endif 
	///End SHOW_COMMON_UDLS
	
	bool					m_bIsSelectionReady; /// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_REMOVE_PLOTS_SPEED
	///Jasmine 01/21/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
	int					m_availDataTypeWksInGLayer;
	int					m_availDataTypeMatInGLayer;
	///End FILTER_GRAPH_SOURCE_DATA
	int					m_availDataTypeWkbookInGLayer; /// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	Button				m_btnIncShortcut; /// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG

	ErrorInfo			m_errLast;			///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT

	///------ Folger 05/30/2012 ORG-5738-S1 LAYER_CONTENT_OC_FILTER_FUNCTION_EVENT_SUPPORT
	vector<string>		m_vsFilterFuncs;
	BOOL TriggerFilterFunctionEvent(LPCSTR lpcszFunc, int nEvent);
	///------ End LAYER_CONTENT_OC_FILTER_FUNCTION_EVENT_SUPPORT
};

class ColHeaderControlMenuBase : public Menu
{
public:
	ColHeaderControlMenuBase(DatasetList* pDatasetList);	
	///Jasmine 12/29/10 ORG-1826-S1-3 COL_AUTO_WIDTH
	void 	OnMenuItem(UINT nPos) 
	{
		///-----Kit 02/24/2011 ORG-1837-S3 ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL
		//m_nChoice = nPos - m_uOffset;
		m_nChoice = m_vnColIndexes[nPos];
		///-----End ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL
	}
	/// end COL_AUTO_WIDTH
	bool 	GetCommand(int& nChoice) 
	{ 
		if( m_nChoice >= COL_FIRST_ONE && m_nChoice < COL_LAST_ITEM )
		{				
			nChoice = m_nChoice; 
			return true; 
		}
		
		return false;
	}
	
private:
	int		m_nChoice;	
	///-----Kit 02/24/2011 ORG-1837-S3 ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL
	//UINT	m_uOffset;///Jasmine 12/29/10 ORG-1826-S1-3 COL_AUTO_WIDTH
	///-----End  ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL

	///-----Kit 02/24/2011 ORG-1837-S3 ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL
	vector<int> m_vnColIndexes;
	///-----End ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL
	
};

#define STR_DATASET_LIST_CONTEXT_MENU 	_L("Delete")
enum
{
	DATASET_LIST_MENU_DELETE,
	
	DATASET_LIST_MENU_LAST_ITEM
};

class DatasetListMenu : public Menu
{
public:
	DatasetListMenu(DatasetList* pDatasetList);	
	void 	OnMenuItem(UINT nPos) { m_nChoice = nPos - m_uOffset; }///Jasmine 12/29/10 ORG-1826-S1-3 COL_AUTO_WIDTH
	bool 	GetCommand(int& nChoice);	
private:
	UINT				m_uOffset;///Jasmine 12/29/10 ORG-1826-S1-3 COL_AUTO_WIDTH
	int					m_nChoice;	
	DatasetList*		m_pDatasetList;
};

class DatasetListHelperBase
{
public:
	DatasetListHelperBase( const DatasetList *pDatasetList, FolderType folderType )
	{
		m_pDatasetList = pDatasetList; 
		m_folderType = folderType; 
		m_nPlotID = PLOT_ID_FOR_AUTO;
		m_errLast = Err_NoError;	///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
	}

	~DatasetListHelperBase() {}

	virtual int 	GetType() { ASSERT(false); return EXIST_NONE; }
	///Jasmine 01/21/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
	virtual	int		GetDatasetInfo(){return 0;}
	///End FILTER_GRAPH_SOURCE_DATA
	virtual int		DelObjects()  { ASSERT(false); return 0; }

	/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
	//virtual bool	GetDataPlotTreeAttribute( Array<MakeDataPlotTreeAttribute&> &arrDPTAttr ){ ASSERT( false ); return false; }
	virtual bool	GetDataPlotTreeAttribute( Array<MakeDataPlotTreeAttribute&> &arrDPTAttr, DWORD dwLayerBits ){ ASSERT( false ); return false; }
	///End SUPPORT_TERNARY_PLOT
	
	// query related
	virtual string	GetKey() { ASSERT(false); return ""; }
	virtual int		BuildDataObjectInfo();
	/// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	//virtual int		BuildGraphSourceObjectInfo();	///Jasmine 01/21/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
	///Jasminie 02/14/11 ORG-2100-P8 SHOW_SOURCE_DATA_FOR_TEMP_PLOT		
	//virtual int		BuildGraphSourceObjectInfo(bool bIncOtherSheets = false);
	virtual int 	BuildGraphSourceSheetInfo(const vector<string>& vsBookSheets = NULL);
	virtual int 	BuildGraphSourceBookInfo(const vector<string>& vsBooks = NULL);
	///End SHOW_SOURCE_DATA_FOR_TEMP_PLOT
	///End ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	int				GetNumDataObjects() { ASSERT(m_pDatasetList); return m_pDatasetList->m_qr.Size(); }
	virtual bool	GetOneColInfo(vector<string>& vsCol, int nCol);	

	void			SetPlotID( int nPlotID ) { m_nPlotID = nPlotID; }
	int				GetPlotID() { return m_nPlotID; }

	virtual	bool	IsVirtualMatrix()	{ return false; }

	virtual bool	GetSelColTypes( vector<int> &nColType ){ return false; }
	
	void			SetIsIncShortcutWindows(bool bIncShortcut) { m_bIncShortcut = bIncShortcut; } /// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
	
	///-----Kit 03/01/2011 ORG-2331-P1 ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT
	virtual bool	GetAvailableCols(vector<bool> &vbAvailCols){ ASSERT(false); return false; }
	/// Kenny 08/19/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	//virtual bool	GetHiddenCols(vector<bool> &vbHiddenCols){ vbHiddenCols = s_vnDatasetListColsDefaultHidden; return true;}
	virtual bool	GetHiddenCols(vector<bool> &vbHiddenCols);
	/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	///-----End ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT
	
	ErrorInfo		GetLastError(){ return m_errLast; }	///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
protected:
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	//virtual	bool	GetDSNameAndDesignations( int nSelRow, vector<string> &vsDSName, vector<uint> &vuDesig ){ ASSERT( false); return false; }	
	/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
	//virtual bool	GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, vector<string> &vsDSName, vector<uint> &vuDesig ){ ASSERT( false); return false; }	
	virtual bool	GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, DWORD dwLayerBits, vector<string> &vsDSName, vector<uint> &vuDesig ){ ASSERT( false); return false; }	
	///End SUPPORT_TERNARY_PLOT
	///End SUPPORT_XYY_PLOT
	int				GetFolderType() { return m_folderType; }
	string			GetShortcutKey() { return m_bIncShortcut ? " SHORTCUT" : ""; } /// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG

protected:
	DatasetList 		*m_pDatasetList;
	FolderType			m_folderType;
	int					m_nPlotID;	
	bool				m_bIncShortcut; /// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
	/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON, no place use it, so comment out.
	/*
	/// Iris 01/17/2011 ORG-1986-P1 SHOW_COMMON_UDLS
#ifdef SUPPORT_COMMON_UDLS
	vector<string>		m_vsCommonUDLNames;	
#endif 
	///End SHOW_COMMON_UDLS
	*/
	///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
	ErrorInfo			m_errLast;	///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
};

//---AvailDataCombo
class AvailDataCombo : public ComboBox
{
public:
	/// Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	//AvailDataCombo(  const ComboBox &combo, const DatasetList *pDatasetList, LPCTSTR lpcstrComboName );
	AvailDataCombo(  const ComboBox &combo, const DatasetList *pDatasetList);
	/// NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	~AvailDataCombo();
	/// Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	//bool	SetComboAvailData( LPCTSTR lpcstrComboName );
	bool	SetComboAvailData();
	/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	///Jasminie 02/14/11 ORG-2100-P8 SHOW_SOURCE_DATA_FOR_TEMP_PLOT
	//void	OnComboSelChange( int nAvailDataComboType );
	void	OnComboSelChange( int nAvailDataComboType, const vector<string>& vsBookSheets = NULL );
	///End SHOW_SOURCE_DATA_FOR_TEMP_PLOT
	void 	GetDataIndexByDatasetName(DWORD& dwCurSel, LPCSTR strDatasetName);///Jasmine 01/12/11 ORG-1997-S2 SHOW_CURRENT_PLOT_TYPE	
	///Jasminie 02/14/11 ORG-2100-P8 SHOW_SOURCE_DATA_FOR_TEMP_PLOT
	void	RemoveWksOrMatInGLayerDropdown(const vector<int>& vnTypes);		
	void 	AddWksOrMatInGLayerDropdown(const vector<int>& vnTypes);		
	///End SHOW_SOURCE_DATA_FOR_TEMP_PLOT
private:
	AvailDataCombo(){}
	void	checkSetSelectionByPlot(DWORD& dwCurSel);
	/// Iris 1/27/2011 ORG-2046-S5 NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	int 	unfixedAvailTypeRegStrToNum(LPCSTR lpcszType);
	string 	unfixedAvailTypeNumToRegStr(int nCurSel);
	int 	getCurSelFromAvailDataType(int nAvailDataType);
	///End NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	
private:
	DatasetList *m_pDatasetList;
	/// Iris 1/27/2011 ORG-2046-S5 NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	int 			m_availDataTypeWksInGLayer;
	int 			m_availDataTypeMatInGLayer;
	///End NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	int				m_availDataTypeWkbookInGLayer; /// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
};

class PlotTypeListBase
{
public:
	PlotTypeListBase( int nPageType, DWORD dwLayerBits, bool bVirtualMat )
	{
		m_nPageType = nPageType;
		m_dwLayerBits = dwLayerBits;
		m_bVirtualMatirx = bVirtualMat;
	}
	
	int		GetPlotTypesListName(vector<string>& vsList);
	int		GetPlotIDByIndex(int nIndex);
	string 	GetPlotTypeStringByIndex(int nIndex);
	bool	GetPlotIDs( vector<int> &vnPlotIDs );
	int		GetCount() { return m_vnPlotIDs.GetSize(); }
	
protected:
	virtual void	UpdatePlotTypeList() { ASSERT( false ); }
	bool	ConvertPlotIDToPlotTypeStr();
	///------ Folger 06/26/2012 ORG-5528-P22 SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
	bool	IsGL() { return O_QUERY_BOOL(m_dwLayerBits, PCD_LAYER_GL); }
	///------ End SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
protected:
	vector<int> 		m_vnPlotIDs;
	vector<string> 		m_vsPlotTypes;
	int					m_nPageType;
	DWORD				m_dwLayerBits;
	bool				m_bVirtualMatirx;
};

class SimplePlotTypeList : public PlotTypeListBase
{
public:
	/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
	//SimplePlotTypeList( int nPageType, DWORD dwLayerBits, vector<int> vnColType ) : PlotTypeListBase( nPageType, dwLayerBits )
	/// Iris 2/16/2011 ORG-2100-P11 FIX_FAIL_TO_PLOT_3D_WIRE_FRAME_FROM_VM
	//SimplePlotTypeList( int nPageType, DWORD dwLayerBits, vector<int> vnColType, int nPlotIDToCheck = IDM_PLOT_UNKNOWN) : PlotTypeListBase( nPageType, dwLayerBits )
	SimplePlotTypeList( int nPageType, DWORD dwLayerBits, vector<int> vnColType, bool bVritualMat, int nPlotIDToCheck = IDM_PLOT_UNKNOWN) : PlotTypeListBase( nPageType, dwLayerBits, bVritualMat)
	///End FIX_FAIL_TO_PLOT_3D_WIRE_FRAME_FROM_VM
	///End IMPROVE_PLOTTYPE_CHECK
	{
		m_vnColTypeSelected = vnColType;
		m_nPlotIDToCheck = nPlotIDToCheck; /// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
		m_errInfo		= Err_NoError;	///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
		UpdatePlotTypeList();
	}

	///-----Kit 03/02/2011 ORG-1837-S4 BIMMAP_BTN_NOT_UPDATE_ON_INIT_DLG
	//bool	GetBmpSrcIDAndBmpIndex( int nSelPos, int &nBmpSrcID, int &nBmpIndex );	
	///-----End BIMMAP_BTN_NOT_UPDATE_ON_INIT_DLG
	
	///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
	//string  GetPlottingMsg(){ return m_strPlottingMsg; }
	ErrorInfo	GetErrorInfo() { return m_errInfo; } 	
	///-----End SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER

	///End IMPROVE_PLOTTYPE_CHECK
	bool	IsPlotIDNotMatch() { return m_bIsPlotIDNotMatch; } /// Iris 1/18/2011 SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH
protected:
	// virtual
	bool	UpdatePlotTypeList();

private:
	vector<int>		m_vnColTypeSelected;
	/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
	int				m_nPlotIDToCheck;
	///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
	//string			m_strPlottingMsg;
	ErrorInfo		m_errInfo;
	///-----End SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER

	///End IMPROVE_PLOTTYPE_CHECK
	bool			m_bIsPlotIDNotMatch;  /// Iris 1/18/2011 SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH
};

class ChangePlotTypeList : public PlotTypeListBase
{
public:
	ChangePlotTypeList( int nPageType, DWORD dwLayerBits, bool bVirtualMatrix, int nPlotID );
protected:
	// virtual
	bool	UpdatePlotTypeList();
private:
	int		getPlotType( int nPlotID, DWORD* pdwAuxTypeInfo = NULL , DWORD *pdwAuxLtPlotInfo = NULL, string *pstrColPattern = NULL );
	int		removeInvalidPlotIDs(vector<int>& vnPlotTypes, int nPlotTypeCheckCompatible ,
									DWORD dwAuxTypeInfoCheckCompatible , DWORD dwLTPlotInfo );
	DWORD	getLayerBitsIgnoreExchange(DWORD dwLayerBits, bool bIgnorePolarSmith = true);
	bool	isLayerTypeCompatible(DWORD dwTargetLayerBits, DWORD dwPlotTypeBits, int nPlotType);
	bool	isPlotTypeInCompatible(int nPlotTypeTest, DWORD dwAuxTypeInfoTest, int nPlotType, DWORD dwAuxTypeInfo);
	bool	isPageTypeInCompatible(int nPageTypeTest, int nPageType);
	bool 	isColDesignationCompatible( int nPlotIDTest );
	bool	isPlotTypeSpecial(int nPlotID, vector<int>& vnPlotIDs);

	int		changePageType(int OriginalPageType, bool bVirtualMat);	///-----Kit 03/03/2011 ORG-1879-P3P4 GET_CORRECT_PLOT_IDS
private:
	int					m_nCurPlotType;
	string				m_strColPattern;
	int					m_nPlotID;
};

class PlotTypeListMenu : public Menu
{
public:
	///-----Kit 01/07/2011 ORG-1826-S14 ADD_CHECKED_STATE_IN_PLOT_TYPE_DROP_DOWN_MENU
	//PlotTypeListMenu( PlotTypeListBase* pPlotTypeList );
	PlotTypeListMenu( PlotTypeListBase* pPlotTypeList, int nSelPlotID );
	///-----
	void 	OnMenuItem(UINT nPos) { m_bIsSelected = true; m_nIndex = nPos; }
	bool	GetSel(int& nIndex);
	void	EmptyFunc(UINT pos) {}
	
private:
	PlotTypeListBase*	m_pPlotTypeListBase;
	int					m_nIndex;
	bool				m_bIsSelected;
};

/// Bill 04/27/2011 ORG-2473 MOVE_COL_HELPER_MOVE_TO_GRIDCONTROL
#ifndef __SUPPORT_PARAMETER_TAB_DRAGGABLE__
///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
class MoveColHelper
{
public:	
	MoveColHelper(){}
	
	int GetColPos(int nType)
	{
		if( m_vnColMap.GetSize() <= 0 //in case m_vnColMap is not ready
			||	0 > nType 
			|| nType >= m_vnColMap.GetSize())
			return -1;
			
		vector<uint> vecIndex;
		if(m_vnColMap.Find(vecIndex, nType) > 0)
			return vecIndex[0];
		
		return -1;
	}
	
	int GetColType(int nPosition)
	{
		if( m_vnColMap.GetSize() <= 0 //in case m_vnColMap is not ready
			||	0 > nPosition 
			|| nPosition >= m_vnColMap.GetSize())
			return -1;

		return m_vnColMap[nPosition];
	}

	void OnAfterMoveColumns(long lCol, long *pnPosition)
	{
		int nOldPostion = lCol;
		int nNewPostion = -1;
		if(pnPosition)
			nNewPostion = *pnPosition;
		
		int nColMoved = GetColType(nOldPostion);	
		if(nColMoved < 0 || GetColType(nNewPostion) < 0)//lCol or pnPosition may be invalid
		{
			ASSERT(0);
			return;
		}
		
		m_vnColMap.RemoveAt(nOldPostion);
		m_vnColMap.InsertAt(nNewPostion, nColMoved);
	}
public:
	vector<uint> 		m_vnColMap; 	
};
///End SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
#endif // __SUPPORT_PARAMETER_TAB_DRAGGABLE__
/// End MOVE_COL_HELPER_MOVE_TO_GRIDCONTROL

///-----Kit 02/25/2011 ORG-2319-S1 SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW
class SetGridToolTipHelperBase
{
public:
	SetGridToolTipHelperBase(GridListControl *pGridList)
	{
		m_pGridList = pGridList;
	}

	bool SetGridToolTip();
protected:
	virtual bool GetRowToolTip(int nRow, string &strToolTip){ ASSERT( false); return false; }
private:
	bool	getRowHeaderToolTip(string &strToolTip);
protected:
	GridListControl	*m_pGridList;
};

class SetDatasetListToolTipHelper : public SetGridToolTipHelperBase
{
public:
	SetDatasetListToolTipHelper(DatasetList *pDatasetList) : SetGridToolTipHelperBase( pDatasetList )
	{
	}

	// virtual
	bool	GetRowToolTip(int nRow, string &strToolTip);
};
///-----End SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW

#endif //_LAYERCONTENTS_H
