/*------------------------------------------------------------------------------*
 * File Name: DatasetList				 										*
 * Creation:  Kit Chen															*
 * Purpose: New Layer Contents													*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Iris 11/29/2010 ORG-864-S2 SHOW_COL_DESIGNATION_WITH_COL_SHORTNAME			*
 * Iris 11/29/2010 ORG-864-P1 FIX_PLOT_3D_XYZ_DATA_WITH_INCORRECT_PLOT_TYPE		*
 * Iris 12/27/2010 ORG-1682-P5 PLOT_Y_TWICE_WHEN_PLOTTED_WITH_YERR				*
 * Iris 2/14/2011 ORG-2100-P10 PLOT_XYZ_TO_2D_GRAPH_AS_COUNTOUR					*
 * Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX			*
 * Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG		*
 * Kit 02/22/2011 ORG-2305-P1 SUPPORT_ADD_LINE_SCATTER_TO_POLAR_CONTOUR_LAYER	*
 * Kit 04/08/2011 ORG-2614-P1 DATASET_LIST_COL_HEADER_MENU_FAILED_WHEN_HAS_PARAM_COL
 * Kit 04/08/2011 ORG-2614-P1 BOOK_NAME_SHOULD_FOLLOW_TOOL_OPTIONS_SETTING		*
 * Iris 4/12/2011 ORG-1986-P2 FIX_NO_COMMON_LABEL_CASE_CAUSE_RUNTIME_ERROR		*
 *	CPY 4/20/2011 ORG-2690-P1 RUNTIME_AFTER_COL_SORTED							*
 *	Kit 04/21/2011 ORG-2690-P1 GET_BOOK_NAME_FAIL_AFTER_COL_SORTED				*
 *	Kit 04/21/2011 ORG-2690-P3 WHEN_BOOK_LN_IS_EMPTY_SHOULD_SHOW_BOOK_SN		*
 *	Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN	*
 *	Kit 04/28/2011 CLEAN_UP_CODE												*
 *	Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT						*
 *	Kit 05/17/2011 ORG-2614-P2 NOT_SHOW_SN_IN_LN_COL_WHEN_LN_IS_EMPTY			*
 *	Kit 05/18/2011 ORG-2614-S2 DEFAULT_COL_WIDTH_SHOULD_FOLLOW_COL_CONTENTS		*
 *	Kit 05/24/2011 ORG-2958-P1 DROP_COL_FAILED									*
 *  Iris 6/14/2011 ORG-2857-P2 SHOW_ERR_MSG_FOR_NOT_SUPPORTED_PLOT_TYPE			*
 *	Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP*
 *  Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS		*
 *	Folger 12/07/2011 ORG-3537 MORE_ON_NAMED_RANGE_SUPPORT_IN_LAYER_CONTENT_AND_PLOT_SETUP
 *  Iris 12/09/2011 ORG-4482-P6 REMOVE_XYZ_SCATTER_ERR_FROM_LAYER_CONTENTS_DLG	*
 *  Iris 2/07/2012 CLEANUP_BITMAP_INDEX_CODE									*
 *	Folger 05/18/2012 ORG-5738 ADVANCED_QUERY_RESULT_OC_FILTER_FUNCTION_SUPPORT	*
 *	Folger 05/30/2012 ORG-5738-S1 LAYER_CONTENT_OC_FILTER_FUNCTION_EVENT_SUPPORT*
 *	Sophy 6/20/2012 ORG-5475-P6 SUPPPORT_ADD_3D_BARS_FROM_LAYERCONTENTS			*
 *	Sophy 6/26/2012 ORG-5475-P6 3D_XYZ_SURFACE_BAR_SHOULD_BE_COMPATIBLE_WITH_3D_SCATTER
 *	Folger 06/26/2012 ORG-5528-P22 SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT		*
 *	Sophy 6/28/2012 ORG-5475-P3 GL_LAYER_BIT_MAKE_3D_SCATTER_INCOMPATIBLE_WITH_3D_BARS
 *	Jasmine 06/29/2012 ORG-6105-P1 GROUPING_NOT_AVAILABLE_FOR_MATRIX			*
 *	Tony 07/04/2012 ORG-2893-S1 ADD_BOOK_NAMING_COLUMN							*
 *	Tony 07/06/2012 ORG-2893-S1 LAYER_CONTENTS_INITIALIZATION                   *
 *------------------------------------------------------------------------------*/
 
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.
#include <Profiler.h>
#include <okocUtils.h>
#include "DatasetList.h"
/// Iris 01/17/2011 ORG-1986-P1 SHOW_COMMON_UDLS
#ifdef SUPPORT_COMMON_UDLS
#include "WksColLabels.h" 
#endif 
///End SHOW_COMMON_UDLS

/************************************************************************/
/* ---Global Function and Macro                                         */
/************************************************************************/
#define		IS_DATAPLOT( _RowType )		( (DPL_PLOT_IN_GROUP == _RowType) || (DPL_PLOT_OUTSIDE_GROUP == _RowType) )
#define		IS_DATAPLOT_OR_GROUP_ROW( _RowType ) ( (DPL_GROUP == _RowType) || IS_DATAPLOT( _RowType ) )

#define		LAYER_LEVEL					0
#define		LAYER_CHILDREN_LEVEL		1
#define		NON_GROUP_MEMBERS_LEVEL		LAYER_CHILDREN_LEVEL
#define		GROUP_BRANCH_LEVEL			LAYER_CHILDREN_LEVEL
#define		GROUP_MEMBERS_LEVEL			2

#define		SKIP_GROUP_ROW	1
#define		NEW_ROW_STEP	1

enum {IDM_PLOT_CUSTOM = 1, IDM_PLOT_STYLE_HOLDER};

typedef int	(*DATASET_FILTER_FUNC)(QueryResult& qr, QUERYRESULTBUILD& nObjectType);
typedef BOOL (*DATASET_FILTER_FUNC_EX)(OriginObject& obj, int nType); ///------ Folger 05/30/2012 ORG-5738-S1 LAYER_CONTENT_OC_FILTER_FUNCTION_EVENT_SUPPORT

static uint _get_plot_ex_value( DWORD dwAuxTypeInfo, DWORD dwLTPlotInfo )
{
	if( dwAuxTypeInfo & PCD_LTPLOTINFO_HAS_NEXVAL )
	{
		uint uExVal = dwLTPlotInfo & LTPI_NEXVAL_MASK;
		return (uExVal >> NEXVAL_MASK_BITSHIFT_IN_LTPI );
	}
	return 0;
}

bool check_tree_node_tagName_is_DataPlot( const TreeNode &trNode )
{
	string strPrefix;
	string_to_prefix_end_number( strPrefix.GetBuffer(MAXLINE), trNode.tagName );
	strPrefix.ReleaseBuffer();

	return (strPrefix.CompareNoCase( "DataPlot" ) == 0);
}

bool make_plot_tree( TreeNode &trPlot, const PlotInfo &plotInfo, DWORD dwView )
{
	vector<string> vsPagesName, vsLayersName;
	vsPagesName.Add( plotInfo.strPageName );
	vsLayersName.Add( plotInfo.strLayerName );
	uint uExVal = _get_plot_ex_value( plotInfo.dwAuxTypeInfo, plotInfo.dwLTPlotInfo );
	
	int nRet =  Project.MakeDataplotsTree( trPlot, plotInfo.nPlotType, plotInfo.dwAuxTypeInfo, plotInfo.dwLTPlotInfo
									, plotInfo.strColPattern, uExVal, plotInfo.vuColDesignations, vsPagesName
									/// Iris 12/03/2010 ORG-864-P3 FIX_NOT_KEEP_ROWS_RANGE_WHEN_CHANGE_PLOT_TYPE
									//, vsLayersName, plotInfo.vsColNames, dwView );
									, vsLayersName, plotInfo.vsColNames, dwView, plotInfo.arrRangeRows );
									///End FIX_NOT_KEEP_ROWS_RANGE_WHEN_CHANGE_PLOT_TYPE

	/// Iris 01/10/2011 FIX_CHANGE_PLOTTYPE_NOT_KEEP_SHOWINFO								
	//return(nRet > 0);
	if( nRet <= 0 )
	{
		///-----Kit 04/28/2011 CLEAN_UP_CODE
		ASSERT(false);
		return error_report("Project.MakeDataplotsTree() can not add plot DataPlot to GraphLayer!!");
		///-----End CLEAN_UP_CODE
	}
	
	TreeNode trShow = trPlot.FirstNode.DataPlot1.ShowInfo; // dataplot node always be DataPlot1 here
	if( trShow )
	{
		trShow.nVal = plotInfo.bShow;
	}
	return true;	
	///End FIX_CHANGE_PLOTTYPE_NOT_KEEP_SHOWINFO
}

bool is_plottype_the_same(  int nPlotType1, DWORD dwAuxTypeInfo1, DWORD dwLTPlotInfo1,
									int nPlotType2, DWORD dwAuxTypeInfo2, DWORD dwLTPlotInfo2, bool bIgnoreColorSize )
{
	DWORD	dw1 = dwAuxTypeInfo1 & ~PCD_LTPLOTINFO_HAS_NEXVAL;
	DWORD	dw2 = dwAuxTypeInfo2 & ~PCD_LTPLOTINFO_HAS_NEXVAL;
	if(nPlotType1 != nPlotType2)
		return false;
	
	if(bIgnoreColorSize) 
	{
		dw2 = dw2 & ~(PCD_MODIFIER_SIZE | PCD_MODIFIER_COLOR | PCD_EXACT_YCOLS);
		dw1 = dw1 & ~(PCD_MODIFIER_SIZE | PCD_MODIFIER_COLOR | PCD_EXACT_YCOLS);
	}
	///Sophy 8/18/2010 ORG-826-P3 PROPER_FILTER_PLOTTYPES_ON_SELECT_PLOT_CHANGE
	//I notice that GraphLayer::GetLayerContents and Project.GetPlotTypeInfo use different code to get auxtype information of dataplot
	//one call COKPlotObj::GetAuxPlotTypeInfo and the other call LABUTIL_ok_get_plot_designation_str in VC level, and there two
	//return value is different in PCD_NO_X | PCD_LAYER_3D when is IDM_PLOT_3D_MESH type, as a OC workaround for Plot Setup dialog, the following code seems enough
	//what's more, change the return value of COKPlotObj::GetAuxPlotTypeInfo seems too dangerous
	if ( nPlotType1 == IDM_PLOT_3D_MESH )
	{
		if ( (dw2 & PCD_ONLY_ONE_Z) && (dw1 & PCD_ONLY_ONE_Z) )
		{
			dw1 = dw1 & ~(PCD_NO_X | PCD_LAYER_3D);
			dw2 = dw2 & ~(PCD_NO_X | PCD_LAYER_3D);
		}
	}
	///end PROPER_FILTER_PLOTTYPES_ON_SELECT_PLOT_CHANGE
	if(dw1 == dw2 && dwLTPlotInfo1 == dwLTPlotInfo2 )
		return true;
	
#ifdef _DEBUG_PLOT_TYPE
	if(bIgnoreColorSize)
		printf("when bIgnoreColorSize, Plot Type dwAuxTypeInfo diff, %X vs %X\n", dw1, dw2);
	else
		printf("Plot Type dwAuxTypeInfo diff, %X vs %X\n", dw1, dw2);
#endif //#ifdef _DEBUG_PLOT_TYPE
	
	return false;
}

#define STR_DATASET_FILTER_SECTION_NAME 	"DatasetFilterFuncs"
static int _get_dataset_filter_names(vector<string>& vsKeys)
{	
	INIFile inifile;
	if( inifile.GetKeyNames(vsKeys, STR_DATASET_FILTER_SECTION_NAME) )
		return vsKeys.GetSize();
	return 0;
}

static string _get_dataset_filter_function_name(int index)
{
	vector<string> vsKeys;
	if( index >= 0 && _get_dataset_filter_names(vsKeys) > 0 && index < vsKeys.GetSize() )
	{
		INIFile inifile;
		return inifile.ReadString(STR_DATASET_FILTER_SECTION_NAME, vsKeys[index]);
	}
	return "";
}

static bool	_remove_designation_from_col_short_name( string &strShortName )
{
	int nLeft = strShortName.Find('(');
	if( nLeft >= 0 )
	{
		if( strShortName.Find(')', nLeft) >= 0 || strShortName.Find('?', nLeft) >= 0 )
			strShortName = strShortName.Left(strShortName.Find('('));			
		return true;
	}		
	
	return false;
}

static int	_find_designation_left_and_right( const Worksheet &wks, int nRefCol, int nDesig )
{
	int nPos = wks.FindColIndex( nRefCol, nDesig );
	if( nPos < 0 )
		nPos = wks.FindColIndex( nRefCol, nDesig, FCI_RIGHT );
	
	return nPos;
}

static int _add_x_designation( const Worksheet &wks, int nRefColIndex, vector<string> &vsDSName, vector<uint> &vuDesig )
{
	int nXDesignationsColIndox = wks.FindColIndex( nRefColIndex, OKDATAOBJ_DESIGNATION_X );

	if( nXDesignationsColIndox < 0 )
	{
		vsDSName.Add( STR_AUTOX );
	}
	else
	{
		vsDSName.Add( wks.Columns(nXDesignationsColIndox).GetName() );
	}
	
	
	vuDesig.Add( COLDESIG_X );
	
	return nXDesignationsColIndox;
}

static int _add_y_designation( const Worksheet &wks, int nRefColIndex, vector<string> &vsDSName, vector<uint> &vuDesig )
{
	int nYDesignationsColIndex = _find_designation_left_and_right( wks, nRefColIndex, OKDATAOBJ_DESIGNATION_Y ); 
	
	if( nYDesignationsColIndex < 0 )
		return -1;
	
	Column colY = wks.Columns( nYDesignationsColIndex );
	vsDSName.Add( colY.GetName() );
	vuDesig.Add( COLDESIG_Y );
	
	return nYDesignationsColIndex;
}

/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK, no place used, comment out
/*
bool	has_both_z_and_other_column_selected( const vector<int> &vnSelColTypes )
{
	vector<uint> vuIndex;	
	bool bFoundZ = vnSelColTypes.Find( vuIndex, OKDATAOBJ_DESIGNATION_Z ) > 0;
	
	if( bFoundZ )
	{
		// convert all "YZ" to "Z" in vnSelColTypes
		for(int index = 0; index < vuIndex.GetSize(); )
		{
			int nPreviousIndex = vuIndex[index] - 1;
			if( nPreviousIndex >= 0 && OKDATAOBJ_DESIGNATION_Y == vnSelColTypes[nPreviousIndex] ) // check the previous if be Y type
			{			
				vnSelColTypes.RemoveAt(nPreviousIndex);
				vuIndex -= 1;
			}				
			else
			{
				index++;
			}
		}
	}	
	
	bFoundZ = vnSelColTypes.Find( vuIndex, OKDATAOBJ_DESIGNATION_Z ) > 0;
	if( vuIndex.GetSize() != vnSelColTypes.GetSize() && bFoundZ )
		return true;
	
	return false;	
}
*/
///End IMPROVE_PLOTTYPE_CHECK

///-----Kit 03/02/2011 ORG-2312-P3 SUPPORT_ADD_TEXT_PLOT_TO_CONTOUR
enum
{
	FindColType_AllMatch = 0,
	FindColType_HasOneOfMatch,
};

static bool _has_columns_type_selected(const vector<int> &vnColTypeSel, int nColTypeCheck1, int nColTypeCheck2, DWORD dwOption)
{
	vector<int> vnColTypeCheck;
	vnColTypeCheck.Add(nColTypeCheck1);
	vnColTypeCheck.Add(nColTypeCheck2);

	return _has_columns_type_selected(vnColTypeSel, vnColTypeCheck, dwOption);
}

static bool _has_columns_type_selected(const vector<int> &vnColTypeSel, int nColTypeCheck, DWORD dwOption)
{
	vector<int> vnColTypeCheck;
	vnColTypeCheck.Add(nColTypeCheck);
	return _has_columns_type_selected(vnColTypeSel, vnColTypeCheck, dwOption);
}

static bool _has_columns_type_selected(const vector<int> &vnColTypeSel, const vector<int> &vnColTypeCheck, DWORD dwOption)
{	
	if( CHECK_VECTOR_IS_EMPTY(vnColTypeSel) )
		return false;

	bool bMatch = false;
	switch( dwOption )
	{
	case FindColType_AllMatch:
		{
			if( vnColTypeSel.GetSize() < vnColTypeCheck.GetSize() )
				return false;
			
			int nFound = 0;
			for( int ii = 0; ii < vnColTypeCheck.GetSize(); ++ii )
			{
				vector<uint> vuIndexes;
				if( vnColTypeSel.Find(vuIndexes, vnColTypeCheck[ii]) > 0 )
					nFound += vuIndexes.GetSize();
			}
			
			bMatch = nFound == vnColTypeSel.GetSize();
		}
		break;
	case FindColType_HasOneOfMatch:
		{
			for( int ii = 0; ii < vnColTypeCheck.GetSize(); ++ii )
			{
				vector<uint> vuIndexes;
				if( vnColTypeSel.Find(vuIndexes, vnColTypeCheck[ii]) > 0 )
				{
					bMatch = true;
					break;
				}
			}
		}
		break;
	default:
		bMatch = false;
		break;
	}
	
	return bMatch;
}
///-----End SUPPORT_ADD_TEXT_PLOT_TO_CONTOUR

///-----Kit 01/07/2011 ORG-864-P1 DISABLE_ADD_PLOT_BTN_WHEN_SEL_ROW_IS_WKS_TYPE_AND_PLOT_TYPE_IS_MAT_USE_ONLY
/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
//bool	has_only_z_column_selected( const vector<int> &vnSelColTypes )
bool has_only_one_column_type_selected( const vector<int> &vnSelColTypes, int nColType )
///End IMPROVE_PLOTTYPE_CHECK
{
	if( vnSelColTypes.GetSize() <= 0 )
		return false;
	
	vector<uint> vuIndex;	
	
	/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
	//if( ( vnSelColTypes.Find( vuIndex, OKDATAOBJ_DESIGNATION_Z ) > 0 )
	if( OKDATAOBJ_DESIGNATION_Z == nColType && vnSelColTypes.Find( vuIndex, nColType ) > 0 )
	{
		// convert all "YZ" to "Z" in vnSelColTypes
		for(int index = 0; index < vuIndex.GetSize(); )
		{
			int nPrevious = vuIndex[index] - 1;
			if(  nPrevious >= 0 && vnSelColTypes[nPrevious] == OKDATAOBJ_DESIGNATION_Y )
			{
				vnSelColTypes.RemoveAt(nPrevious);
			}
			else
			{
				index++;
			}
		}
	}
	
	if( ( vnSelColTypes.Find( vuIndex, nColType ) > 0 )
	///End IMPROVE_PLOTTYPE_CHECK
		&& vuIndex.GetSize() == vnSelColTypes.GetSize() )
		return true;
	
	return false;
}	

/// Iris 12/05/2011 ORG-4482-P2 IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
//static bool	_is_matrix_plot_id( int nPlotID )
static bool	_is_matrix_plot_id( int nPlotID, bool bIsGLLayer )
///End IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
{
	vector<int> vnMatPlotID;
	/// Iris 12/05/2011 ORG-4482-P2 IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
	//_get_mat_plots_id( vnMatPlotID );
	_get_mat_plots_id( vnMatPlotID, bIsGLLayer);
	///End IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
	
	vector<uint> vuIndex;
	if( vnMatPlotID.Find( vuIndex, nPlotID ) < 0 )
		return false;
	
	return !CHECK_VECTOR_IS_EMPTY( vuIndex );
}
///-----End DISABLE_ADD_PLOT_BTN_WHEN_SEL_ROW_IS_WKS_TYPE_AND_PLOT_TYPE_IS_MAT_USE_ONLY

/// Iris 1/30/2011 ORG-2100-P4 ALLOW_PLOT_HIST_FROM_MATRIX_EX
static bool	_is_wks_2d_plot_id( int nPlotID )
{
	vector<int> vnWksPlotID;
	_get_wks_2d_plots_id( vnWksPlotID );
	
	vector<uint> vuIndex;
	if( vnWksPlotID.Find( vuIndex, nPlotID ) < 0 )
		return false;
	
	return !CHECK_VECTOR_IS_EMPTY( vuIndex );
}
///End ALLOW_PLOT_HIST_FROM_MATRIX_EX

//---- Iris 2/07/2012 CLEANUP_BITMAP_INDEX_CODE
// the bitmap index in C:\C\DDK Tools\ODlg8\2D.BMP
enum
{
	BMP_2D_LINE = 0,
	BMP_2D_SCATTER,
	BMP_2D_LINESYMB,
	BMP_2D_BAR,
	BMP_2D_COLUMN,
	BMP_2D_PIE,
	BMP_2D_STACK_AREA,
	BMP_2D_AREA		
};

// the bitmap index in C:\C\DDK Tools\ODlg8\3DGRAPHS.BMP
enum
{
	BMP_3D_LINE = 0,
	BMP_3D_SURFACE_COLORFILL = 11,
	BMP_3D_SURFACE_COLORMAP = 14,
	BMP_3D_SURFACE_BARS = 19,
	BMP_3D_SURFACE_WIREFRAME = 20,
	BMP_3D_TRI_CONTOUR = 22,
	BMP_3D_MATRIX_IMAGE = 27		
};
//----
	
///-----Kit 03/02/2011 ORG-1837-S4 BIMMAP_BTN_NOT_UPDATE_ON_INIT_DLG
bool get_bmp_src_id_and_bmp_index_by_plot_id(int nPlotID, int &nBmpSrcID, int &nBmpIndex)
{
	/// Iris 12/31/2010 ORG-1879 ADD_AUTO_PLOTTYPE_IN_PLOTTYPE_BMP_BUTTON
	if( nPlotID == PLOT_ID_FOR_AUTO )
	{
		nBmpSrcID = IDB_AUTO_PLOT_TYPE;
		nBmpIndex = 0;
		return true;
	}
	///End ADD_AUTO_PLOTTYPE_IN_PLOTTYPE_BMP_BUTTON
	
	const vector<uint> vuPlotIDs = {
		// for XY
		IDM_PLOT_LINE, IDM_PLOT_SCATTER, IDM_PLOT_LINESYMB, IDM_PLOT_COLUMN, IDM_PLOT_AREA,
			// for XYZ			
			IDM_PLOT_3D_LINE, IDM_PLOT_TRI_CONTOUR,			
			IDM_PLOT_3D_SURFACE_NEW, /// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS			
			// for matrix
			IDM_PLOT_SURFACE_BARS, IDM_PLOT_SURFACE_COLORFILL, IDM_PLOT_SURFACE_COLORMAP, IDM_PLOT_SURFACE_WIREFRAME, IDM_PLOT_3D_SCATTER_MATRIX, IDM_PLOT_CONTOUR, IDM_PLOT_MATRIX_IMAGE,
			/// Iris 12/05/2011 ORG-4482-P2 IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
			//for GL 3d matrix 
			IDM_PLOT_SURFACE_BARS
			///End IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
	};
	
	const vector<uint> vuBMPIDs = {
		IDB_2D_PLOT, IDB_2D_PLOT, IDB_2D_PLOT, IDB_2D_PLOT, IDB_2D_PLOT, // for XY
			IDB_3D_PLOT, IDB_3D_PLOT, // for XYZ
			IDB_3D_PLOT, // for XYZ Surface /// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
			IDB_3D_PLOT, IDB_3D_PLOT, IDB_3D_PLOT, IDB_3D_PLOT, IDB_3D_PLOT, IDB_3D_PLOT, IDB_3D_PLOT, // for matrix
			/// Iris 12/05/2011 ORG-4482-P2 IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
			IDB_3D_PLOT //for GL 3d matrix 
			///End IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
	};	
	
	//---- Iris 2/07/2012 CLEANUP_BITMAP_INDEX_CODE
	/*
	const vector<uint> vuIndexInBMP = {
		0, 1, 2, 4, 7, // for XY			
			0, 22, // for XYZ
			11, // for XYZ surface /// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
			///End IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
			19, 11, 14, 20, 0, 22, 27, // for matrix
			/// Iris 12/05/2011 ORG-4482-P2 IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
			19 //for GL 3d matrix 
			///End IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
	};
	*/
	const vector<uint> vuIndexInBMP = {
		BMP_2D_LINE, BMP_2D_SCATTER, BMP_2D_LINESYMB, BMP_2D_COLUMN, BMP_2D_AREA, // for XY
		BMP_3D_LINE, BMP_3D_TRI_CONTOUR, // for XYZ
		BMP_3D_SURFACE_COLORFILL, // for XYZ surface /// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
		BMP_3D_SURFACE_BARS, BMP_3D_SURFACE_COLORFILL, BMP_3D_SURFACE_COLORMAP, BMP_3D_SURFACE_WIREFRAME, BMP_3D_LINE, BMP_3D_TRI_CONTOUR, BMP_3D_MATRIX_IMAGE,  // for matrix
		/// Iris 12/05/2011 ORG-4482-P2 IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
		BMP_3D_SURFACE_BARS //for GL 3d matrix
		///End IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
	};	
	//---- 
	
	vector<uint> vecIndex;
	if( vuPlotIDs.Find(vecIndex, nPlotID) < 0 || vecIndex.GetSize() <= 0 )
		return error_report("fail to find bitmap id for this plot type in OnClickPlotTypeDropDownButton");	
	
	int index = vecIndex[0];
	nBmpSrcID = vuBMPIDs[index];
	nBmpIndex = vuIndexInBMP[index];
	
	return true;
}
///-----End BIMMAP_BTN_NOT_UPDATE_ON_INIT_DLG

///-----Kit 03/05/2011 ORG-2307-P5 RUNTIME_ERROR_WHEN_REMOVE_A_PLOT_AFTER_APPLY
static int _get_ds_info(LPCTSTR lpcszDSName, DatasetInfoMore &stDSMoreInfo)
{
	DWORD dwDSInfo = Project.GetDatasetInfo(lpcszDSName, FALSE, &stDSMoreInfo);

	int nColType = OKDATAOBJ_DESIGNATION_Y;

	if( strcmp("", stDSMoreInfo.szXDependent) != 0 )
	{
		if( PGDN_ERR_BAR & dwDSInfo )
			nColType = OKDATAOBJ_DESIGNATION_ERROR;
		else if( PGDN_X_ERR_BAR & dwDSInfo )
			nColType = OKDATAOBJ_DESIGNATION_X_ERROR;
		else if( PGDN_LABEL & dwDSInfo )
			nColType = OKDATAOBJ_DESIGNATION_L;
		else
			nColType = OKDATAOBJ_DESIGNATION_Z;
	}

	return nColType;
}
///-----End RUNTIME_ERROR_WHEN_REMOVE_A_PLOT_AFTER_APPLY

/// Kenny 08/19/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP	
const DatasetListColInfoArray&	GetDatasetListColInfo()
{
	static	Array<DatasetListColInfo&>  s_arrColInfos(TRUE);
	static	bool s_bInitialized = false;
	if ( !s_bInitialized )
	{
		s_bInitialized = true;
		
		s_arrColInfos.SetSize(COL_LAST_ITEM-COL_FIRST_ONE);
		
		int ii = 0;
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("Folder"), true)));
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("Book Name"), false)));			///------ Tony 07/06/2012 ORG-2893-S1 LAYER_CONTENTS_INITIALIZATION
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("Book Long  Name"), true)));
		///------ Tony 07/06/2012 ORG-2893-S1 LAYER_CONTENTS_INITIALIZATION
		//s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("Book Short Name"), false)));	
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("Book Short Name"), true)));	
		///------ End LAYER_CONTENTS_INITIALIZATION
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("Sheet"), false)));
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("Dataset Name"), true)));
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("Long Name"), false)));
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("Short Name"), false)));
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("Units"), true)));
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("Comments"), true)));
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("1st Value"), true)));
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("Status"), true)));
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("Position"), true)));
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("Parameters"), true)));
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("Parameters 2"), true)));
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("Parameters 3"), true)));
#ifdef SUPPORT_COMMON_UDLS		
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("User-Defined Labels"), true)));
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("User-Defined Labels 2"), true)));
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("User-Defined Labels 3"), true)));
#endif // SUPPORT_COMMON_UDLS		
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo("[Book]Sheet!Col", true)));
#ifdef NEW_NAMED_RANGE_FEATURE		
		s_arrColInfos.SetAt(ii++, *(new DatasetListColInfo(_L("Scope"), true)));
#endif // NEW_NAMED_RANGE_FEATURE
	}
	return s_arrColInfos;
}
/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP

/************************************************************************/
/* ---ColHeaderControlMenuBase                                     		*/
/************************************************************************/
ColHeaderControlMenuBase::ColHeaderControlMenuBase(DatasetList* pDatasetList)
{
	m_nChoice = -1;
	
	/// Kenny 08/19/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	//string strItems = STR_DATASET_LIST_HEADERS;
	//vector<string> vs;
	//strItems.GetTokens(vs, '|'); 
	//ASSERT(vs.GetSize() == COL_LAST_ITEM);
	const DatasetListColInfoArray& arrColInfos = GetDatasetListColInfo();
	/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	
	///Jasmine 12/29/10 ORG-1826-S1-3 COL_AUTO_WIDTH
#define EXTRA_MENU_BEGIN_INDEX	2
	int nMenuBegin = COL_FIRST_ONE - EXTRA_MENU_BEGIN_INDEX; 
	int nMenuEnd = COL_LAST_ITEM;

	m_vnColIndexes.Add(nMenuBegin++);
	Add(STR_COL_AUTO_WIDTH_MENU, OnMenuItem, MF_STRING, MENU_AUTO_SIZE_COL_ID);

	m_vnColIndexes.Add(nMenuBegin++);
	Add(NULL, OnMenuItem, MF_SEPARATOR);
	///End COL_AUTO_WIDTH	
	///Jasmine 01/05/11 ORG-1826-S8 MOVE_COLUMN_ORDER
	for( int nColPos = nMenuBegin; nColPos < nMenuEnd; nColPos++ )
	{
		int nColType = pDatasetList->GetColType(nColPos);
		
		/// Kenny 08/19/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		string strColName = arrColInfos.GetAt(nColType).strColName;
		/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP

		///-----Kit 04/21/2011 ORG-2690-P1 GET_BOOK_NAME_FAIL_AFTER_COL_SORTED
		///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
		//if(COL_BOOK_LN == nColType)
		//	continue;
		///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
		///-----End GET_BOOK_NAME_FAIL_AFTER_COL_SORTED
		
		UINT uFlag = MF_STRING;
		uFlag |= (pDatasetList->IsColHidden(nColPos) || !pDatasetList->IsAvailableColumn(nColType))? MF_UNCHECKED : MF_CHECKED;
		if( !pDatasetList->IsAvailableColumn(nColType) )
			uFlag |= (MF_DISABLED | MF_GRAYED);
		else if( pDatasetList->IsLastShownCol(nColPos) )
			uFlag |= MF_DISABLED;
		
/// Iris 01/17/2011 ORG-1986-P1 SHOW_COMMON_UDLS
#ifdef SUPPORT_COMMON_UDLS
		if( nColType >= COL_UDL_BEGIN && nColType <= COL_UDL_END )
		{
			/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
			//string strCommonUDLName = pDatasetList->GetCommonUDLName(nColType - COL_UDL_BEGIN);
			string strCommonUDLName = pDatasetList->GetCommonParametersLabelName(nColType - COL_UDL_BEGIN, false);
			///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
			if( strCommonUDLName.IsEmpty() )
				continue;
			
			/// Kenny 08/19/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
			//vs[nColType] = strCommonUDLName;
			strColName = strCommonUDLName;
			/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
			///-----Kit 04/08/2011 ORG-2614-P1 DATASET_LIST_COL_HEADER_MENU_FAILED_WHEN_HAS_PARAM_COL
			//m_vnColIndexes.Add(nColPos);	
			///-----End DATASET_LIST_COL_HEADER_MENU_FAILED_WHEN_HAS_PARAM_COL
		}	
#endif //SUPPORT_COMMON_UDLS
///End SHOW_COMMON_UDLS
		
		/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
		if( nColType >= COL_PARAMS && nColType <= COL_PARAMS3 )
		{
			string strName = pDatasetList->GetCommonParametersLabelName(nColType - COL_PARAMS, true);
			if( strName.IsEmpty() )
				continue;
			
			/// Kenny 08/19/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
			//vs[nColType] = strName;
			strColName = strName;
			/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
			///-----Kit 04/08/2011 ORG-2614-P1 DATASET_LIST_COL_HEADER_MENU_FAILED_WHEN_HAS_PARAM_COL
			//m_vnColIndexes.Add(nColPos);
			///-----End DATASET_LIST_COL_HEADER_MENU_FAILED_WHEN_HAS_PARAM_COL
		}		
		///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON

		
		/// Kenny 08/19/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		//Add(vs[nColType], OnMenuItem, uFlag);
		Add(strColName, OnMenuItem, uFlag);
		/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		m_vnColIndexes.Add(nColPos);
	}
	///End MOVE_COLUMN_ORDER
}	


DatasetListMenu::DatasetListMenu(DatasetList* pDatasetList)
{
	m_nChoice = -1;	
	m_pDatasetList = pDatasetList;
	
	string strItems = STR_DATASET_LIST_CONTEXT_MENU;
	vector<string> vs;
	strItems.GetTokens(vs, '|'); 
	ASSERT(vs.GetSize() == DATASET_LIST_MENU_LAST_ITEM);
	///Jasmine 12/29/10 ORG-1826-S1-3 COL_AUTO_WIDTH
	m_uOffset = 0;
	Add(STR_COL_AUTO_WIDTH_MENU, OnMenuItem, MF_STRING, MENU_AUTO_SIZE_COL_ID);	m_uOffset++;
	Add(NULL, OnMenuItem, MF_SEPARATOR);										m_uOffset++;
	///End COL_AUTO_WIDTH
	for( int ii = 0; ii < DATASET_LIST_MENU_LAST_ITEM; ii++ )
	{
		UINT uFlag = MF_STRING;
		Add(vs[ii], OnMenuItem, uFlag);
	}	
}

bool 	DatasetListMenu::GetCommand(int& nChoice)
{
	if( m_nChoice < 0 || m_nChoice >= DATASET_LIST_MENU_LAST_ITEM )
		return false;
	nChoice = m_nChoice;
	return true;
}

/************************************************************************/
/* ---DatasetListHelperBase                                             */
/************************************************************************/
#define GET_CELL_STR( nRow, nCol ) m_pDatasetList->GetCell( flexcpText, nRow, m_pDatasetList->GetColPos(nCol) )///Jasmine 01/05/11 ORG-1826-S8 MOVE_COLUMN_ORDER
#define QUERY_COLUMN_CONDITION "where _type != X and _type != N"
int DatasetListHelperBase::BuildDataObjectInfo()
{
	string strFolderType;
	switch(m_folderType)
	{
	case FLD_TYPE_CURRENT_FLD:
		strFolderType = "ACTIVEFOLDER RECURSIVE";
		break;
		
	case FLD_TYPE_FAVS_FLD:
		strFolderType = "FAVORITEFOLDER RECURSIVE";
		break;
		
	case FLD_TYPE_PROJECT:
		strFolderType = "Project";
		break;	
		
	default:
		ASSERT(false);
		return false;		
	}
	
	string strSQL;
	/// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
	//strSQL.Format("Select %s from %s %s", GetKey(), strFolderType, strCondition);
	strSQL.Format("Select %s from %s%s %s", GetKey(), strFolderType, GetShortcutKey(), QUERY_COLUMN_CONDITION);
	///End ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
	m_pDatasetList->m_qr.Build(strSQL);
	return m_pDatasetList->m_qr.Size();	
}
	
///Jasmine 01/21/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
/// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
//int	DatasetListHelperBase::BuildGraphSourceObjectInfo()
///Jasminie 02/14/11 ORG-2100-P8 SHOW_SOURCE_DATA_FOR_TEMP_PLOT
//int DatasetListHelperBase::BuildGraphSourceObjectInfo(bool bIncOtherSheets/*= false*/)
int DatasetListHelperBase::BuildGraphSourceSheetInfo(const vector<string>& vsBookSheets/*= NULL*/)
///End SHOW_SOURCE_DATA_FOR_TEMP_PLOT
///End ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
{
	GraphLayer glActive = Project.ActiveLayer();
	if(!glActive)
		return 0;
	
	bool bCleanFlag = true;

	///Jasminie 02/14/11 ORG-2100-P8 SHOW_SOURCE_DATA_FOR_TEMP_PLOT
	if(vsBookSheets && vsBookSheets.GetSize() > 0)
	{
		int nCount = vsBookSheets.GetSize();
		for(int ii = 0; ii < nCount; ii++)
		{
			string strSQL;
			strSQL.Format("Select %s from %s %s", GetKey(), vsBookSheets[ii], QUERY_COLUMN_CONDITION);
			m_pDatasetList->m_qr.Build(strSQL, bCleanFlag? 0 : QUERYRESULTBUILDCTRNL_KEEP_LAST_RESULT);
			bCleanFlag = false;
			int nResult = m_pDatasetList->m_qr.Size();	
		}
		
		int nResult = m_pDatasetList->m_qr.Size();	
		return nResult;
	}
	///End SHOW_SOURCE_DATA_FOR_TEMP_PLOT
	
	vector<string>	vsRanges;///Jasmine 01/27/11 ORG-2046-S3 QueryResult_NOT_CHECK_DUPLICATE_RANGE
	foreach(DataPlot dp in glActive.DataPlots)
	{
		DWORD dwInfo = Project.GetDatasetInfo( dp.GetDatasetName() );
		if( dwInfo & GetDatasetInfo() )
		{
			DataRange dr;
			dp.GetDataRange(dr);
			Datasheet ds;
			dr.GetParent(ds);
			string strRange;
			ds.GetRangeString(strRange);
			
			///Jasmine 01/27/11 ORG-2046-S3 QueryResult_NOT_CHECK_DUPLICATE_RANGE
			if( vsRanges.Find(strRange) < 0 )
			{
				vsRanges.Add(strRange);
			///End QueryResult_NOT_CHECK_DUPLICATE_RANGE
			
				string strSQL;
				strSQL.Format("Select %s from %s %s", GetKey(), strRange, QUERY_COLUMN_CONDITION);				
				m_pDatasetList->m_qr.Build(strSQL, bCleanFlag? 0 : QUERYRESULTBUILDCTRNL_KEEP_LAST_RESULT);
				bCleanFlag = false;
				int nResult = m_pDatasetList->m_qr.Size();	
			}
		}
	}
	
	int nResult = m_pDatasetList->m_qr.Size();	
	return nResult;
}
int DatasetListHelperBase::BuildGraphSourceBookInfo(const vector<string>& vsBooks/*= NULL*/)
{
	GraphLayer glActive = Project.ActiveLayer();
	if(!glActive)
		return 0;
	
	bool bCleanFlag = true;
	
	if(vsBooks && vsBooks.GetSize() > 0)
	{
		int nCount = vsBooks.GetSize();
		for(int ii = 0; ii < nCount; ii++)
		{
			string strSQL;
			strSQL.Format("Select %s from %s %s", GetKey(), vsBooks[ii], QUERY_COLUMN_CONDITION);
			m_pDatasetList->m_qr.Build(strSQL, bCleanFlag? 0 : QUERYRESULTBUILDCTRNL_KEEP_LAST_RESULT);
			bCleanFlag = false;
			int nResult = m_pDatasetList->m_qr.Size();	
		}
		
		int nResult = m_pDatasetList->m_qr.Size();	
		return nResult;
	}
	
	vector<string>	vsRanges;
	foreach(DataPlot dp in glActive.DataPlots)
	{
		DWORD dwInfo = Project.GetDatasetInfo( dp.GetDatasetName() );
		if( dwInfo & GetDatasetInfo() )
		{
			DataRange dr;
			dp.GetDataRange(dr);
			Datasheet ds;
			dr.GetParent(ds);
			string strRange;
			ds.GetPage().GetRangeString(strRange);
			
			if( vsRanges.Find(strRange) < 0 )
			{
				vsRanges.Add(strRange);
			
				string strSQL;
				strSQL.Format("Select %s from %s %s", GetKey(), strRange, QUERY_COLUMN_CONDITION);				
				m_pDatasetList->m_qr.Build(strSQL, bCleanFlag? 0 : QUERYRESULTBUILDCTRNL_KEEP_LAST_RESULT);
				bCleanFlag = false;
				int nResult = m_pDatasetList->m_qr.Size();	
			}
		}
	}
	
	int nResult = m_pDatasetList->m_qr.Size();	
	return nResult;
}
///End FILTER_GRAPH_SOURCE_DATA

bool DatasetListHelperBase::GetOneColInfo(vector<string>& vsCol, int nCol)
{		
	if( m_pDatasetList->m_qr.Size() == 0 )
		return false;
	
	QUERYRESULTNAME nNameType = -1;
	QUERYRESULTCOL nColType = -1;
	int nRow = -1;
	switch(nCol)
	{
	case COL_FOLDER:
		nNameType = QUERYRESULTNAME_FOLDER;
		break;
	///------ Tony 07/04/2012 ORG-2893-S1 ADD_BOOK_NAMING_COLUMN
	case COL_BOOK_NAME:
		nNameType = QUERYRESULTNAME_BOOKLNAME_EMPTY_THEN_SNAME;
		break;	
	///------ End ADD_BOOK_NAMING_COLUMN
	case COL_BOOK_SN:
		nNameType = QUERYRESULTNAME_BOOK;
		break;
	///-----Kit 04/21/2011 ORG-2690-P1 GET_BOOK_NAME_FAIL_AFTER_COL_SORTED
	case COL_BOOK_LN:
		///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
		//nNameType = QUERYRESULTNAME_BOOK;
		///-----Kit 05/17/2011 ORG-2614-P2 NOT_SHOW_SN_IN_LN_COL_WHEN_LN_IS_EMPTY
		//nNameType = QUERYRESULTNAME_BOOKLNAME_EMPTY_THEN_SNAME;
		nNameType = QUERYRESULTNAME_BOOKLNAME;
		///-----End NOT_SHOW_SN_IN_LN_COL_WHEN_LN_IS_EMPTY
		///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
		break;
	///-----End GET_BOOK_NAME_FAIL_AFTER_COL_SORTED
		
	case COL_SHEET:
		nNameType = QUERYRESULTNAME_SHEET;
		break;
		
	case COL_DSNAME:
		nColType = QUERYRESULTCOL_DATANAME;
		break;
		
	case COL_SNAME:
		nNameType = QUERYRESULTNAME_SNAME;
		break;
		
	case COL_LNAME:
		nNameType = QUERYRESULTNAME_LNAME;
		break;
		
	case COL_UNITS:
		nColType = QUERYRESULTCOL_UNITS;
		break;
		
	case COL_COMMENTS:
		nColType = QUERYRESULTCOL_COMMENTS;
		break;
		
	case COL_1ST_VALUE:
	/// Iris 1/12/2011 SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
	//	nColType = QUERYRESULTCOL_1ST_VALUE;
		nColType = QUERYRESULTCOL_VALUE;
		nRow = nCol - COL_1ST_VALUE;
	///End SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
		break;
		
	case COL_PARAMS:
	/// Iris 1/12/2011 SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
	//	nColType = QUERYRESULTCOL_1ST_PARAM;
	case COL_PARAMS2:
	case COL_PARAMS3:
		nColType = QUERYRESULTCOL_PARAM;
		nRow = nCol - COL_PARAMS;
	///End SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL		
		break;
		
#ifdef SUPPORT_COMMON_UDLS		
	case COL_UDL:
	/// Iris 1/12/2011 SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
	//	nColType = QUERYRESULTCOL_1ST_UDL;
	case COL_UDL2:
	case COL_UDL3:
		nColType = QUERYRESULTCOL_UDL;
		nRow = nCol - COL_UDL;	
	///End SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL	
		break;
#endif //SUPPORT_COMMON_UDLS
		
	case COL_INDEX:
		nNameType = QUERYRESULTNAME_INDEX;
		break;
	
	///Jasmine 01/20/10 ORG-2046-S2 FILTER_DATA_WITH_LOCK_STATUS
	case COL_STATUS:
		nColType = QUERYRESULTCOL_STATUS;
		nRow = nCol - COL_STATUS;
		break;
	///End FILTER_DATA_WITH_LOCK_STATUS

	///-----Kit 02/24/2011 ORG-1837-S3 ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL
	case COL_BOOK_SHEET_COL:
		nNameType = QUERYRESULTNAME_RANGE;
		break;
	///-----End ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL
	
	/// Kenny 08/22/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
#ifdef NEW_NAMED_RANGE_FEATURE
	case COL_SCOPE:
		nNameType = QUERYRESULTNAME_NAMEDRANGE_SCOPE_RANEG;
		break;
#endif // NEW_NAMED_RANGE_FEATURE
	/// End ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	
	default:
		ASSERT(false);
		return false;
	}		
	
	if( nColType >= 0 )
	{
		/// Iris 1/12/2011 SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
		//return m_pDatasetList->m_qr.GetColInfo(vsCol, nColType);	
		return m_pDatasetList->m_qr.GetColInfo(vsCol, nColType, nRow);	
		///End SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
	}
	
	if( nNameType >= 0 )
	{
		return m_pDatasetList->m_qr.GetNames(vsCol, nNameType);
	}
	return false;	
}

/// Kenny 08/19/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
bool DatasetListHelperBase::GetHiddenCols(vector<bool> &vbHiddenCols)
{
	const DatasetListColInfoArray& arrColInfos = GetDatasetListColInfo();
	vbHiddenCols.SetSize(COL_LAST_ITEM-COL_FIRST_ONE);
	for(UINT ii = 0; ii < vbHiddenCols.GetSize(); ++ii)
	{
		vbHiddenCols[ii] = arrColInfos.GetAt(ii).bDefaultHidden;
	}
	return true;
}
/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP

/************************************************************************/
/* ---DatasheetDatasetListHelper                                        */
/************************************************************************/

class DatasheetDatasetListHelper : public DatasetListHelperBase
{
public:
	DatasheetDatasetListHelper( const DatasetList *pDatasetList, FolderType folderType ) : DatasetListHelperBase( pDatasetList, folderType ) {}
	~DatasheetDatasetListHelper() {}	
	
	//virtual
	int 	DelObjects();
	
	//virtual
	/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
	//bool	GetDataPlotTreeAttribute( Array<MakeDataPlotTreeAttribute&> &arrDPTAttr );
	bool	GetDataPlotTreeAttribute( Array<MakeDataPlotTreeAttribute&> &arrDPTAttr, DWORD dwLayerBits );
	///End SUPPORT_TERNARY_PLOT
	
	///-----Kit 04/14/2011 ORG-2614-P1 MAT_DOES_NOT_SHOW_LN
	//virtual
	///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	//bool	GetOneColInfo(vector<string>& vsCol, int nCol);
	///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
	///-----End ORG-2614-P1 MAT_DOES_NOT_SHOW_LN
protected:	
	virtual bool DelObject( const Datasheet &ds, LPCTSTR lpcstrSName ) { ASSERT( false ); return false;	}
private:
	bool	getObject( const Folder &fldr );	
	bool	getObject( const PageBase &pb );
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	//bool	getSelUniqueBookSheetName( vector<string> &vsUniqueBookSheetName );
	int 	getSelDSNamesAndColSNames(vector<string> &vsSelRowBookSheet, vector<string>& vsSelRowColSNames);
	///End SUPPORT_XYY_PLOT

///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
private:
	bool	checkPlotIDIsvalid(bool bHasDiffBookSheetInSelection);
	bool	getDataPlotTreeAttribute(DWORD dwLayerBits, LPCTSTR lpcszBookSheet
									, const vector<string>& vsColSNames, Array<MakeDataPlotTreeAttribute&> &arrDPTAttr);
///-----End LC_SHOULD_SUPPORT_XYAM_PLOT
};

int DatasheetDatasetListHelper::DelObjects()
{	
	vector<uint> vuSelRows;
	if( !m_pDatasetList->GetSelRows( vuSelRows ) )
		return 0;
	
	int ii = 0;
	for( ; ii<vuSelRows.GetSize(); ++ii )
	{
		string strBook = GET_CELL_STR(vuSelRows[ii]-ii, COL_BOOK_SN);
		string strSheet = GET_CELL_STR(vuSelRows[ii]-ii, COL_SHEET);
		string strBkStName = make_book_sheet_name(strBook, strSheet);
		Datasheet ds;
		ds.Attach( strBkStName );
		ASSERT( ds.IsValid() );
		
		string strSName = GET_CELL_STR( vuSelRows[ii]-ii, COL_SNAME );		

		if( !DelObject( ds, strSName ) )
			return error_report("Fail to delete dataobject in DatasheetDatasetListHelper::DelObjects");
		
		m_pDatasetList->DeleteRow( vuSelRows[ii]-ii );
	}
	
	return ii;
}
/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
/*
bool DatasheetDatasetListHelper::getSelUniqueBookSheetName( vector<string> &vsUniqueBookSheetName )
{
	vector<uint> vuSelRows;
	if( !m_pDatasetList->GetSelRows( vuSelRows ) )
		return false;
	
	string strBookSheetName = m_pDatasetList->GetSelRowDataSheetName( vuSelRows[0] );
	ASSERT( !strBookSheetName.IsEmpty() );
	vsUniqueBookSheetName.Add( strBookSheetName );
	
	for( int ii=0; ii<vuSelRows.GetSize(); ++ii )
	{
		string strCurBookSheetName = m_pDatasetList->GetSelRowDataSheetName( vuSelRows[ii] );
		ASSERT( !strCurBookSheetName.IsEmpty() );
		
		if( -1 == vsUniqueBookSheetName.Find( strCurBookSheetName ) )
			vsUniqueBookSheetName.Add( strCurBookSheetName );
	}
	
	return true;
}
*/
int DatasheetDatasetListHelper::getSelDSNamesAndColSNames(vector<string> &vsSelRowBookSheet, vector<string>& vsSelRowColSNames)
{
	vector<uint> vuSelRows;
	if( !m_pDatasetList->GetSelRows( vuSelRows ) )
		return 0;
	
	for( int ii = 0; ii < vuSelRows.GetSize(); ++ii )
	{		
		vsSelRowBookSheet.Add( m_pDatasetList->GetSelRowDataSheetName( vuSelRows[ii] ) );
		
		///Iris 02/18/2011 ORG-1826-S8 MOVE_COLUMN_ORDER_MORE
		//string strColSName = m_pDatasetList->GetCell( vuSelRows[ii], COL_SNAME );
		string strColSName = GET_CELL_STR( vuSelRows[ii], COL_SNAME );
		///End MOVE_COLUMN_ORDER_MORE
		_remove_designation_from_col_short_name(strColSName);
		ASSERT(!strColSName.IsEmpty());
		vsSelRowColSNames.Add( strColSName );
	}
	
	return vsSelRowBookSheet.GetSize();
}
///End SUPPORT_XYY_PLOT

///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
bool DatasheetDatasetListHelper::checkPlotIDIsvalid(bool bHasDiffBookSheetInSelection)
{
	bool bRet = true;
	switch( GetPlotID() )
	{
	case IDM_PLOT_VECTOR:
		if(bHasDiffBookSheetInSelection)
		{
			m_errLast = Err_CurrentPlotTypeNeedAllColsInSameWks;
			bRet = false;
		}		
		break;
	}
	
	return bRet;
}

bool DatasheetDatasetListHelper::getDataPlotTreeAttribute(DWORD dwLayerBits, LPCTSTR lpcszBookSheet
														, const vector<string>& vsColSNames, Array<MakeDataPlotTreeAttribute&> &arrDPTAttr)
{
	MakeDataPlotTreeAttribute *pDPTAttr = new MakeDataPlotTreeAttribute;
	get_book_sheet_names( lpcszBookSheet, pDPTAttr->strBook, pDPTAttr->strSheet );
	if( !GetDSNameAndDesignations( lpcszBookSheet, vsColSNames, dwLayerBits, pDPTAttr->vsDSName, pDPTAttr->vuDesig ) )
	{
		delete pDPTAttr;
		return false;
	}
	arrDPTAttr.Add( *pDPTAttr );
	return true;
}
///-----End LC_SHOULD_SUPPORT_XYAM_PLOT

/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
//bool DatasheetDatasetListHelper::GetDataPlotTreeAttribute( Array<MakeDataPlotTreeAttribute&> &arrDPTAttr )
bool DatasheetDatasetListHelper::GetDataPlotTreeAttribute( Array<MakeDataPlotTreeAttribute&> &arrDPTAttr, DWORD dwLayerBits )
///End SUPPORT_TERNARY_PLOT
{
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	/*
	vector<uint> vuSelRows;
	if( !m_pDatasetList->GetSelRows( vuSelRows ) )
		return false;
	
	vector<string> vsUniqueBookSheetName;
	getSelUniqueBookSheetName( vsUniqueBookSheetName );
	
	for( int jj=0; jj<vsUniqueBookSheetName.GetSize(); ++jj )
	{
		MakeDataPlotTreeAttribute *pDPTAttr = new MakeDataPlotTreeAttribute;
		get_book_sheet_names( vsUniqueBookSheetName[jj],pDPTAttr->strBook, pDPTAttr->strSheet );
		
		for( int ii=0; ii<vuSelRows.GetSize(); ++ii )
		{
			string strCurBookSheetName = m_pDatasetList->GetSelRowDataSheetName( vuSelRows[ii] );
			ASSERT( !strCurBookSheetName.IsEmpty() );
			
			if( strCurBookSheetName == vsUniqueBookSheetName[jj] )
			{
				GetDSNameAndDesignations( vuSelRows[ii], pDPTAttr->vsDSName, pDPTAttr->vuDesig );					
			}
		}
		
		arrDPTAttr.Add( *pDPTAttr );
	}
	*/
	vector<string> vsSelRowBookSheetNames, vsSelRowColSNames;
	int nSelRows = getSelDSNamesAndColSNames(vsSelRowBookSheetNames, vsSelRowColSNames);
	if( nSelRows == 0 )
		return false;
	
	vector<int> vnMapIndices;
    vector<uint> vnR1s;
    BOOL bCaseSensitive = false; 
	vector<uint> vnOccurences;
	vsSelRowBookSheetNames.FindDuplicates(vnMapIndices, vnR1s, bCaseSensitive, vnOccurences);
	
	vector<uint> vnIndex;
	///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
	//if( vnMapIndices.Find(vnIndex, -1) > 0 )
	bool	bHasBookSheetOnlyAppearOnce = vnMapIndices.Find(vnIndex, -1) > 0;
	bool	bHasDiffBookSheetInSelection = (vsSelRowBookSheetNames.GetSize() > 1 
											&& bHasBookSheetOnlyAppearOnce);
	if( !checkPlotIDIsvalid(bHasDiffBookSheetInSelection) )
	{
		return false;
	}

	if( bHasBookSheetOnlyAppearOnce )
	///-----End LC_SHOULD_SUPPORT_XYAM_PLOT
	{	
		for(int index = 0; index < vnIndex.GetSize(); index++)
		{
			string strBookSheetName = vsSelRowBookSheetNames[vnIndex[index]];
			vector<string> vsColSNames;
			vsColSNames.Add(vsSelRowColSNames[vnIndex[index]]);
	 		
			///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
// 			MakeDataPlotTreeAttribute *pDPTAttr = new MakeDataPlotTreeAttribute;
// 			get_book_sheet_names( strBookSheetName, pDPTAttr->strBook, pDPTAttr->strSheet );
// 			/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
// 			//GetDSNameAndDesignations( strBookSheetName, vsColSNames, pDPTAttr->vsDSName, pDPTAttr->vuDesig );	
// 			GetDSNameAndDesignations( strBookSheetName, vsColSNames, dwLayerBits, pDPTAttr->vsDSName, pDPTAttr->vuDesig );
// 			///End SUPPORT_TERNARY_PLOT
// 			arrDPTAttr.Add( *pDPTAttr );
			if( !getDataPlotTreeAttribute(dwLayerBits, strBookSheetName, vsColSNames, arrDPTAttr) )
				return false;
			///-----End LC_SHOULD_SUPPORT_XYAM_PLOT
		}				
	}	
		
	if( vnR1s.GetSize() > 0 )
	{
		for(int index = 0; index < vnR1s.GetSize(); index++)
		{
			string strBookSheetName = vsSelRowBookSheetNames[vnR1s[index]];
				
			vector<string> vsColSNames;
			int nStart = 0, nPos;
			while( (nPos = vsSelRowBookSheetNames.Find(strBookSheetName, nStart, bCaseSensitive)) >= 0 )
			{
				vsColSNames.Add(vsSelRowColSNames[nPos]);
				nStart = nPos + 1;
			}
	 		
			///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
// 			MakeDataPlotTreeAttribute *pDPTAttr = new MakeDataPlotTreeAttribute;
// 			get_book_sheet_names( strBookSheetName, pDPTAttr->strBook, pDPTAttr->strSheet );
// 			/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
// 			//GetDSNameAndDesignations( strBookSheetName, vsColSNames, pDPTAttr->vsDSName, pDPTAttr->vuDesig );					
// 			GetDSNameAndDesignations( strBookSheetName, vsColSNames, dwLayerBits, pDPTAttr->vsDSName, pDPTAttr->vuDesig );
// 			///End SUPPORT_TERNARY_PLOT
// 			arrDPTAttr.Add( *pDPTAttr );
			if( !getDataPlotTreeAttribute(dwLayerBits, strBookSheetName, vsColSNames, arrDPTAttr) )
				return false;
			///-----End LC_SHOULD_SUPPORT_XYAM_PLOT
		}		
	}
	///End SUPPORT_XYY_PLOT
	return true;
}

///-----Kit 04/14/2011 ORG-2614-P1 MAT_DOES_NOT_SHOW_LN
// virtual
///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
/*
bool	DatasheetDatasetListHelper::GetOneColInfo(vector<string>& vsCol, int nCol)
{
	switch(nCol)
	{
	case COL_BOOK_SN:
		{
			if( is_use_long_name_when_available() )
				///-----Kit 04/21/2011 ORG-2690-P3 WHEN_BOOK_LN_IS_EMPTY_SHOULD_SHOW_BOOK_SN
				//return m_pDatasetList->m_qr.GetNames(vsCol, QUERYRESULTNAME_BOOKLNAME);
				return m_pDatasetList->m_qr.GetNames(vsCol, QUERYRESULTNAME_BOOKLNAME_EMPTY_THEN_SNAME);
				///-----End WHEN_BOOK_LN_IS_EMPTY_SHOULD_SHOW_BOOK_SN
			
			return m_pDatasetList->m_qr.GetNames(vsCol, QUERYRESULTNAME_BOOK);
		}
	default:
		break;
	}

	return DatasetListHelperBase::GetOneColInfo(vsCol, nCol);
}
*/
///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
///-----End ORG-2614-P1 MAT_DOES_NOT_SHOW_LN

/************************************************************************/
/* ---WksDatasetListHelper                                              */
/************************************************************************/
class WksDatasetListHelper : public DatasheetDatasetListHelper
{
public:
	WksDatasetListHelper( const DatasetList *pDatasetList, FolderType folderType ) : DatasheetDatasetListHelper( pDatasetList, folderType ) {}
	
	//virtual
	~WksDatasetListHelper() {}
	
	//virtual
	int 	GetType() { return EXIST_WKS; }	
	///Jasmine 01/21/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
	//virtual
	int		GetDatasetInfo(){return PGDN_IN_WKS;}
	///End FILTER_GRAPH_SOURCE_DATA
	//virtual 
	string	GetKey() { return "Column"; }	
	//virtual
	bool 	GetOneColInfo(vector<string>& vsCol, int nCol);
	
	//virtual
	bool	GetSelColTypes( vector<int> &nColType );
	
	///-----Kit 03/01/2011 ORG-2331-P1 ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT
	// virtual
	bool	GetAvailableCols(vector<bool> &vbAvailCols);
	///-----End ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT
protected:
	//virtual
	bool 	DelObject( const Datasheet &ds, LPCTSTR lpcstrSName );	
	//virtual
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	//bool	GetDSNameAndDesignations( int nSelRow, vector<string> &vsDSName, vector<uint> &vuDesig );
	/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
	//bool	GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, vector<string> &vsDSName, vector<uint> &vuDesig );
	bool	GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, DWORD dwLayerBits, vector<string> &vsDSName, vector<uint> &vuDesig );
	///End SUPPORT_TERNARY_PLOT
	///End SUPPORT_XYY_PLOT
	
private:
	///-----Kit 12/27/2010 move to static function
	//bool    removeDesignationFromColShortName(string& strShortName);
	///-----
};

//virtual
bool WksDatasetListHelper::GetOneColInfo(vector<string>& vsCol, int nCol)
{
	switch( nCol )
	{
	case COL_SNAME:
		/// Iris 1/12/2011 SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
		//return m_pDatasetList->m_qr.GetColInfo(vsCol, QUERYRESULTCOL_SNAMEWITHTYPE);
		return m_pDatasetList->m_qr.GetColInfo(vsCol, QUERYRESULTCOL_SNAMEWITHTYPE, 0);
		///End SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
	///-----Kit 04/14/2011 ORG-2614-P1 MAT_DOES_NOT_SHOW_LN
	/*
	///-----Kit 04/08/2011 ORG-2614-P1 BOOK_NAME_SHOULD_FOLLOW_TOOL_OPTIONS_SETTING
	case COL_BOOK_SN:
		{
			if( is_use_long_name_when_available() )
				return m_pDatasetList->m_qr.GetNames(vsCol, QUERYRESULTNAME_BOOKLNAME);
			
			return m_pDatasetList->m_qr.GetNames(vsCol, QUERYRESULTNAME_BOOK);
		}
	///-----End BOOK_NAME_SHOULD_FOLLOW_TOOL_OPTIONS_SETTING
	*/
	///-----End ORG-2614-P1 MAT_DOES_NOT_SHOW_LN
	default:
		break;

	}

	return DatasheetDatasetListHelper::GetOneColInfo(vsCol, nCol);
}
//virtual
bool WksDatasetListHelper::DelObject( const Datasheet &ds, LPCTSTR lpcstrSName )
{
	ASSERT( ds.IsValid() );
	
	Worksheet wks = ds;
	///-----Kit 04/28/2011 CLEAN_UP_CODE
	//ASSERT( wks.IsValid() );
	if( !wks.IsValid() )
	{
		ASSERT(false);
		return error_report("WksDatasetListHelper::DelObject() can not get the correct worksheet !!!");
	}
	///-----End CLEAN_UP_CODE
	
	/// Iris 11/29/2010 ORG-864-S2 SHOW_COL_DESIGNATION_WITH_COL_SHORTNAME
	//int nColIndex = wks.Columns(lpcstrSName).GetIndex();	
	string strSName(lpcstrSName);
	bool bRet = _remove_designation_from_col_short_name(strSName);
	ASSERT(bRet);
	int nColIndex = wks.Columns(strSName).GetIndex();
	///End SHOW_COL_DESIGNATION_WITH_COL_SHORTNAME

	bool bSuccess = wks.DeleteCol( nColIndex );
	
	ASSERT( bSuccess );
	
	return bSuccess;
}

class ColPatternHelperBase
{
public:
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	//ColPatternHelperBase( const Column &colSelected, const Worksheet &wks )
	ColPatternHelperBase( const vector<string>& vsColSNames, const Worksheet &wks )
	///End SUPPORT_XYY_PLOT
	{
		/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
		//m_colSelected = colSelected;
		m_vsColSNames = vsColSNames;
		///End SUPPORT_XYY_PLOT
		m_Wks = wks;

		m_errLast = Err_NoError;	///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
	}

	virtual	bool	GetDSNameAndDesignation( vector<string> &vsDSName, vector<uint> &vuDesig ){ ASSERT( false ); return false;}

	ErrorInfo		GetLastError(){ return m_errLast; }	///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT

	/// Iris 2/15/2012 ORG-4814-P1 FIX_FAIL_ADD_LABEL_PLOT_ON_TERNARY_PLOT
protected:
	bool	CheckAddOneMoreXYDSNameAndDesignation( vector<string> &vsName, vector<uint> &vuDesig, int nDepDesigType = OKDATAOBJ_DESIGNATION_Y)
	{
		int nDepColIndex = _find_designation_left_and_right( m_Wks, m_colSelected.GetIndex(), nDepDesigType );	
		if( nDepColIndex < 0 )
			return false;
		
		Column colDep = m_Wks.Columns( nDepColIndex );		
		if( !colDep.IsValid() )
		{
			ASSERT(false);
			return error_report("bool	checkAddOneMoreXYDSNameAndDesignation() can not find the Y/Z column!!");
		}		

		if( vsName.Find( colDep.GetName() ) < 0 )
		{
			if( _add_x_designation( m_Wks, m_colSelected.GetIndex(), vsName, vuDesig ) < 0 )
				return false;
			
			if( OKDATAOBJ_DESIGNATION_Z == nDepDesigType )
			{
				if( _add_y_designation( m_Wks, m_colSelected.GetIndex(), vsName, vuDesig ) < 0 )
					return false;
			}			
		
			vsName.Add( colDep.GetName() );
			vuDesig.Add( cvt_col_type_to_designation( colDep.GetType() ) );
			return true;
		}
		return false;
	}
	
	bool	IsSpecialColType( int nColType )
	{
		return ( OKDATAOBJ_DESIGNATION_L == nColType 
 			|| OKDATAOBJ_DESIGNATION_ERROR == nColType
 			|| OKDATAOBJ_DESIGNATION_X_ERROR == nColType );
	}
	///End FIX_FAIL_ADD_LABEL_PLOT_ON_TERNARY_PLOT
	
protected:
	Column		m_colSelected;
	vector<string>	m_vsColSNames; /// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	Worksheet	m_Wks;

	ErrorInfo	m_errLast;	///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
};

class ColPatternXYZHelper : public ColPatternHelperBase
{
public:
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	//ColPatternXYZHelper( const Column &colSelected, const Worksheet &wks ) : ColPatternHelperBase( colSelected, wks )
	ColPatternXYZHelper( const vector<string>& vsColSNames, const Worksheet &wks ) : ColPatternHelperBase( vsColSNames, wks )
	///End SUPPORT_XYY_PLOT
	{
	}

	//virtual
	bool	GetDSNameAndDesignation( vector<string> &vsDSName, vector<uint> &vuDesig )
	{
		/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
		/*
		if( m_colSelected.GetType() == OKDATAOBJ_DESIGNATION_Y )
			return false;
			
		if( m_colSelected.GetType() != OKDATAOBJ_DESIGNATION_Z )
			return error_report( "ColPatternXYZHelper, sel col is not Z" );

		int nFindYDesigRefCol = _add_x_designation( m_Wks, m_colSelected.GetIndex(), vsDSName, vuDesig );

		if( !addYDesignation( nFindYDesigRefCol, vsDSName, vuDesig ) )
			return error_report( "ColPatternXYZHelper, sel wks does not has Y");

		vsDSName.Add( m_colSelected.GetName() );
		vuDesig.Add( COLDESIG_Z );
		*/
		for(int index = 0; index < m_vsColSNames.GetSize(); index++)
		{
			Column col = m_Wks.Columns(m_vsColSNames[index]);
			m_colSelected = col;
			
			/// Iris 2/15/2012 ORG-4814-P1 FIX_FAIL_ADD_LABEL_PLOT_ON_TERNARY_PLOT
			if( IsSpecialColType( col.GetType() ) )
				CheckAddOneMoreXYDSNameAndDesignation( vsDSName, vuDesig, OKDATAOBJ_DESIGNATION_Z );			
			else
			{
			///End FIX_FAIL_ADD_LABEL_PLOT_ON_TERNARY_PLOT
				if( col.GetType() == OKDATAOBJ_DESIGNATION_Y )
					continue;
					
				if( col.GetType() != OKDATAOBJ_DESIGNATION_Z )
					continue;
		
				int nFindYDesigRefCol = _add_x_designation( m_Wks, col.GetIndex(), vsDSName, vuDesig );
		
				//---- Iris 1/26/2011 to fix the 2nd plot is incorrect when plot XYZXYZ data to 3D graph
				//if( !addYDesignation( nFindYDesigRefCol, vsDSName, vuDesig ) )
				if( !addYDesignation( col.GetIndex(), vsDSName, vuDesig ) )
				//----
					continue;			
			} /// Iris 2/15/2012 ORG-4814-P1 FIX_FAIL_ADD_LABEL_PLOT_ON_TERNARY_PLOT		
	
			vsDSName.Add( col.GetName() );
			vuDesig.Add( COLDESIG_Z );
		}
		///End SUPPORT_XYY_PLOT
		
		return true;
	}
	
private:
	bool	addYDesignation( int nRefCol, vector<string> &vsName, vector<uint> &vuDesig )
	{
		int nFindYDesigRefCol = nRefCol;
		if( nRefCol < 0 )
			nFindYDesigRefCol = m_colSelected.GetIndex();
		
		if( _add_y_designation( m_Wks, nRefCol, vsName, vuDesig ) < 0 )
			return false;
		
		return true;
	}
};

/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
class ColPatternXYYHelper : public ColPatternHelperBase
{
public:
	ColPatternXYYHelper( const vector<string>& vsColSNames, const Worksheet &wks ) : ColPatternHelperBase( vsColSNames, wks ) {}

	//virtual
	bool	GetDSNameAndDesignation( vector<string> &vsDSName, vector<uint> &vuDesig )
	{
		for(int index = 0; index < m_vsColSNames.GetSize(); index++)
		{
			Column col = m_Wks.Columns(m_vsColSNames[index]);
			
			if(0 == index)
			{	
				_add_x_designation( m_Wks, col.GetIndex(), vsDSName, vuDesig );
			}
			
			vsDSName.Add( col.GetName() );
			ASSERT( OKDATAOBJ_DESIGNATION_Y == col.GetType() );
			vuDesig.Add( cvt_col_type_to_designation( col.GetType() ) );			
		}
		return true;
	}
};
///End SUPPORT_XYY_PLOT

class ColPatternXYHelper : public ColPatternHelperBase
{
public:
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	//ColPatternXYHelper( const Column &colSelected, const Worksheet &wks ) : ColPatternHelperBase( colSelected, wks )
	ColPatternXYHelper( const vector<string>& vsColSNames, const Worksheet &wks ) : ColPatternHelperBase( vsColSNames, wks )
	///End SUPPORT_XYY_PLOT
	{
	}

	//virtual
	bool	GetDSNameAndDesignation( vector<string> &vsDSName, vector<uint> &vuDesig )
	{
		/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
		/*
		if( isSpecialColType( m_colSelected.GetType() ) )
			checkAddOneMoreXYDSNameAndDesignation( vsDSName, vuDesig );
		else
		{
			if( OKDATAOBJ_DESIGNATION_Y != m_colSelected.GetType() )
				return error_report( "ColPatternXYHelper, sel col is not Y" );

			_add_x_designation( m_Wks, m_colSelected.GetIndex(), vsDSName, vuDesig );
		}	

		vsDSName.Add( m_colSelected.GetName() );
		vuDesig.Add( cvt_col_type_to_designation( m_colSelected.GetType() ) );
		*/
		for(int index = 0; index < m_vsColSNames.GetSize(); index++)
		{
			Column col = m_Wks.Columns(m_vsColSNames[index]);
			m_colSelected = col;
		
			/// Iris 2/15/2012 ORG-4814-P1 FIX_FAIL_ADD_LABEL_PLOT_ON_TERNARY_PLOT		
			//if( isSpecialColType( col.GetType() ) )
				//checkAddOneMoreXYDSNameAndDesignation( vsDSName, vuDesig );
			if( IsSpecialColType( col.GetType() ) )
				CheckAddOneMoreXYDSNameAndDesignation( vsDSName, vuDesig );
			///End FIX_FAIL_ADD_LABEL_PLOT_ON_TERNARY_PLOT
			else
			{
				if( OKDATAOBJ_DESIGNATION_Y != col.GetType() )
					continue;
	
				_add_x_designation( m_Wks, col.GetIndex(), vsDSName, vuDesig );
			}	
	
			vsDSName.Add( col.GetName() );
			vuDesig.Add( cvt_col_type_to_designation( col.GetType() ) );
		}
		///End SUPPORT_XYY_PLOT
		
		return true;
	}

private:
	/// Iris 2/15/2012 ORG-4814-P1 FIX_FAIL_ADD_LABEL_PLOT_ON_TERNARY_PLOT		
	/*
	bool	isSpecialColType( int nColType )
	{
		return ( OKDATAOBJ_DESIGNATION_L == nColType 
 			|| OKDATAOBJ_DESIGNATION_ERROR == nColType
 			|| OKDATAOBJ_DESIGNATION_X_ERROR == nColType );
	}
	
	bool	checkAddOneMoreXYDSNameAndDesignation( vector<string> &vsName, vector<uint> &vuDesig )
	{
		int nYDesigIndex = _find_designation_left_and_right( m_Wks, m_colSelected.GetIndex(), OKDATAOBJ_DESIGNATION_Y );
	
		if( nYDesigIndex < 0 )
			return false;
		
		Column colY = m_Wks.Columns( nYDesigIndex );
		///-----Kit 04/28/2011 CLEAN_UP_CODE
		//ASSERT( colY.IsValid() );
		if( !colY.IsValid() )
		{
			ASSERT(false);
			return error_report("bool	checkAddOneMoreXYDSNameAndDesignation() can not find the Y column!!");
		}
		///-----End CLEAN_UP_CODE

		if( vsName.Find( colY.GetName() ) < 0 )
		{
			if( _add_x_designation( m_Wks, m_colSelected.GetIndex(), vsName, vuDesig ) < 0 )
				return false;
		
			vsName.Add( colY.GetName() );
			vuDesig.Add( COLDESIG_Y );

			return true;
		}

		return false;
	}
	*/
	///End FIX_FAIL_ADD_LABEL_PLOT_ON_TERNARY_PLOT
};

class ColPatternYHelper : public ColPatternHelperBase
{
public:
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	//ColPatternYHelper( const Column &colSelected, const Worksheet &wks ) : ColPatternHelperBase( colSelected, wks )
	ColPatternYHelper( const vector<string>& vsColSNames, const Worksheet &wks ) : ColPatternHelperBase( vsColSNames, wks )
	///End SUPPORT_XYY_PLOT
	{
	}
	//virtual
	bool	GetDSNameAndDesignation( vector<string> &vsDSName, vector<uint> &vuDesig )
	{
		/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
		/*
		vsDSName.Add( m_colSelected.GetName() );
		vuDesig.Add( COLDESIG_Y );
		*/		
		for(int index = 0; index < m_vsColSNames.GetSize(); index++)
		{
			Column col = m_Wks.Columns( m_vsColSNames[index] );
			
			vsDSName.Add( col.GetName() );
			vuDesig.Add( COLDESIG_Y );			
		}
		///End SUPPORT_XYY_PLOT
		
		return true;
	}
};

///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
class ColPatternXYAMHelper : public ColPatternHelperBase
{
public:
	ColPatternXYAMHelper( const vector<string>& vsColSNames, const Worksheet &wks ) 
		: ColPatternHelperBase( vsColSNames, wks )
	{
	}
	
	// virtual
	bool	GetDSNameAndDesignation( vector<string> &vsDSName, vector<uint> &vuDesig )
	{
		if( 0 != (m_vsColSNames.GetSize() % 3) )
		{
			m_errLast = Err_SelColsNumIsNotCorrespondThePlotType;
			return false;
		}
		
		int iIndex = 0;
		while( iIndex < m_vsColSNames.GetSize() )
		{
			Column col = m_Wks.Columns(m_vsColSNames[iIndex++]);
			_add_x_designation(m_Wks, col.GetIndex(), vsDSName, vuDesig);
			
			vsDSName.Add( col.GetName() );
			vuDesig.Add( COLDESIG_Y );
			
			vsDSName.Add(m_vsColSNames[iIndex++]);
			vuDesig.Add(COLDESIG_VECTOR_ANGLE);
			
			vsDSName.Add( m_vsColSNames[iIndex++]);
			vuDesig.Add(COLDESIG_VECTOR_MAGNITUDE);
		}
		
		return true;
	}
};
///-----End LC_SHOULD_SUPPORT_XYAM_PLOT


class GetWksDSNameAndDesignationsHelper
{
public:
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	//GetWksDSNameAndDesignationsHelper( DatasetList *pDatasetList, int nSelRow, int nPlotID )
	/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
	//GetWksDSNameAndDesignationsHelper( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, int nPlotID )
	GetWksDSNameAndDesignationsHelper( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, int nPlotID, int nPageType, DWORD dwLayerBits )
	///End SUPPORT_TERNARY_PLOT
	///End SUPPORT_XYY_PLOT
	{
		/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
		/*
  		m_pDatasetList = pDatasetList;
		m_nSelRow = nSelRow;
		m_nPlotID = nPlotID;
		
		if( !updateData() )
		{
			ASSERT( false );
		}
		*/
		m_Wks.Attach(lpcszBookSheet);
		//---- CPY 4/20/2011 ORG-2690-P1 RUNTIME_AFTER_COL_SORTED
		//ASSERT(m_Wks);
		//ASSERT(m_Wks.IsValid());
		if(!m_Wks.IsValid())
			error_report("Invalid worksheet found, it should never happen!");	
		//---- end RUNTIME_AFTER_COL_SORTED
		m_vsColSNames = vsColSNames;		
		m_nPlotID = nPlotID;
		///End SUPPORT_XYY_PLOT
		/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
		m_nPageType = nPageType;
		m_dwLayerBits = dwLayerBits;
		///End SUPPORT_TERNARY_PLOT

		m_errLast = Err_NoError;	///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
	}

	bool		GetDSNameAndDesignations( vector<string> &vsDSName, vector<uint> &vuDesig );
	ErrorInfo	GetLastError(){ return m_errLast; }	///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
private:
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	/*
	bool		updateData();

	bool		updateColShortName();
	bool		updateSelColumn();
	bool		updateCurWks();
	*/
	///End SUPPORT_XYY_PLOT
	ColPatternHelperBase* createColPatternHelper( LPCTSTR lpszColPattern );
	
private:
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	//DatasetList		*m_pDatasetList;
	//int				m_nSelRow;
	vector<string>	m_vsColSNames;
	int				m_nPlotID;
	///End SUPPORT_XYY_PLOT
	/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
	int				m_nPageType;
	DWORD			m_dwLayerBits;
	///End SUPPORT_TERNARY_PLOT

	Worksheet		m_Wks;
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	//Column			m_colSelected;
	//string			m_strShortName;
	///End SUPPORT_XYY_PLOT

	ErrorInfo		m_errLast;	///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
};

bool GetWksDSNameAndDesignationsHelper::GetDSNameAndDesignations( vector<string> &vsDSName, vector<uint> &vuDesig )
{
	DWORD dwAuxTypeInfo, dwAuxPlotInfo;
	string strColPattern;
	
	/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
	//int nPlotType = Project.GetPlotTypeInfo( m_nPlotID, dwAuxTypeInfo, dwAuxPlotInfo, strColPattern );
	int	nPlotType = get_plot_type_info(m_nPlotID, m_nPageType, m_dwLayerBits, dwAuxTypeInfo, dwAuxPlotInfo, strColPattern);
	///End SUPPORT_TERNARY_PLOT
	if( nPlotType < 0 )
		return error_report( "GetWksDSNameAndDesignationsHelper::GetDSNameAndDesignations(), nPlotType < 0" );
	
	ColPatternHelperBase *pHelper = createColPatternHelper( strColPattern );
	///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
	//if( pHelper != NULL && pHelper->GetDSNameAndDesignation( vsDSName, vuDesig ) )
	if(NULL != pHelper)
	///-----End LC_SHOULD_SUPPORT_XYAM_PLOT
	{
		if( !pHelper->GetDSNameAndDesignation(vsDSName, vuDesig) )
		{
			m_errLast = pHelper->GetLastError();
			delete pHelper;
			return false;
		}
		delete pHelper;
		return true;
	}
	
	return false;
}

/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
/*
bool GetWksDSNameAndDesignationsHelper::updateData()
{
	if( !updateCurWks() || !updateColShortName() )
		return false;
	
	// after updateCurWks() was called
	if( !updateSelColumn() )
		return false;
	
	return true;
}

bool GetWksDSNameAndDesignationsHelper::updateColShortName()
{
	string strShortName = GET_CELL_STR( m_nSelRow, COL_SNAME );
	ASSERT( !strShortName.IsEmpty() );
	
	/// Iris 11/29/2010 ORG-864-S2 SHOW_COL_DESIGNATION_WITH_COL_SHORTNAME
	bool bRet = _remove_designation_from_col_short_name(strShortName);
	ASSERT(bRet);
	///End SHOW_COL_DESIGNATION_WITH_COL_SHORTNAME
	
	m_strShortName = strShortName;
	return true;
}

bool GetWksDSNameAndDesignationsHelper::updateCurWks()
{
	string strBookSheet = m_pDatasetList->GetSelRowDataSheetName( m_nSelRow );

	Worksheet wksTemp( strBookSheet );
	if( !wksTemp.IsValid() )
		return false;

	m_Wks = wksTemp;
	return true;
}

bool GetWksDSNameAndDesignationsHelper::updateSelColumn()
{
	ASSERT( m_Wks.IsValid() );
	
	Column col = m_Wks.Columns( m_strShortName );
	if( !col.IsValid() )
	{
		ASSERT( false );
		return false;
	}
	
	m_colSelected = col;
	return true;
}
*/
///End SUPPORT_XYY_PLOT

ColPatternHelperBase* GetWksDSNameAndDesignationsHelper::createColPatternHelper( LPCTSTR lpszColPattern )
{
	string strColPattern = lpszColPattern;
	
	ColPatternHelperBase* pHelperBase = NULL;
	
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	/*
	///-----Kit 01/07/2011 ORG-864-P1 DISABLE_ADD_PLOT_BTN_WHEN_SEL_ROW_IS_WKS_TYPE_AND_PLOT_TYPE_IS_MAT_USE_ONLY
	//if( strColPattern.CompareNoCase( "XYZ" ) == 0 || strColPattern.CompareNoCase( "Z") == 0 )
	//if( strColPattern.CompareNoCase( "XYZ" ) == 0 )
	if( strColPattern.CompareNoCase( "XYZ" ) == 0 || strColPattern.CompareNoCase( "Z") == 0 )
	///-----
	{
		pHelperBase = new ColPatternXYZHelper( m_colSelected, m_Wks );	
	}
	else if( strColPattern.CompareNoCase( "XY" ) == 0 )	
	{
		pHelperBase = new ColPatternXYHelper( m_colSelected, m_Wks );
	}
	else if( strColPattern.CompareNoCase( "Y" ) == 0 )
	{
		pHelperBase = new ColPatternYHelper( m_colSelected, m_Wks );	
	}
	*/
	if( strColPattern.CompareNoCase( "XYZ" ) == 0 || strColPattern.CompareNoCase( "Z") == 0 )
	{
		pHelperBase = new ColPatternXYZHelper( m_vsColSNames, m_Wks );	
	}
	else if( strColPattern.CompareNoCase( "XY" ) == 0 )	
	{
		pHelperBase = new ColPatternXYHelper( m_vsColSNames, m_Wks );
	}
	else if( strColPattern.CompareNoCase( "Y" ) == 0 )
	{
		pHelperBase = new ColPatternYHelper( m_vsColSNames, m_Wks );	
	}
	else if( strColPattern.CompareNoCase( "XYY" ) == 0 )
	{
		pHelperBase = new ColPatternXYYHelper( m_vsColSNames, m_Wks );	
	}
	///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
	else if( strColPattern.CompareNoCase("XYAM") == 0 )
	{
		pHelperBase = new ColPatternXYAMHelper( m_vsColSNames, m_Wks );
	}	
	else		
	{
		/// Iris 6/14/2011 ORG-2857-P2 SHOW_ERR_MSG_FOR_NOT_SUPPORTED_PLOT_TYPE
		//error_report("Not support column pattern!!");
		m_errLast = Err_CurrentPlotTypeNotSupportInLC;
		///End SHOW_ERR_MSG_FOR_NOT_SUPPORTED_PLOT_TYPE
	}
	///-----End LC_SHOULD_SUPPORT_XYAM_PLOT
	///End SUPPORT_XYY_PLOT
	
	return pHelperBase;
}

/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
//bool WksDatasetListHelper::GetDSNameAndDesignations( int nSelRow, vector<string> &vsDSName, vector<uint> &vuDesig )
/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
//bool WksDatasetListHelper::GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, vector<string> &vsDSName, vector<uint> &vuDesig )
bool WksDatasetListHelper::GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, DWORD dwLayerBits, vector<string> &vsDSName, vector<uint> &vuDesig )
///End SUPPORT_TERNARY_PLOT
///End SUPPORT_XYY_PLOT
{
	//ASSERT( !_is_matrix_plot_id(GetPlotID()) );

	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	//GetWksDSNameAndDesignationsHelper clHelper( m_pDatasetList, nSelRow, GetPlotID() );
	/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
	//GetWksDSNameAndDesignationsHelper clHelper( lpcszBookSheet, vsColSNames, GetPlotID() );
	GetWksDSNameAndDesignationsHelper clHelper( lpcszBookSheet, vsColSNames, GetPlotID(), GetType(), dwLayerBits );
	///End SUPPORT_TERNARY_PLOT
	///End SUPPORT_XYY_PLOT

	///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
	//return clHelper.GetDSNameAndDesignations( vsDSName, vuDesig );
	if( !clHelper.GetDSNameAndDesignations( vsDSName, vuDesig ) )
	{
		m_errLast = clHelper.GetLastError();
		return false;
	}

	return true;
	///-----End LC_SHOULD_SUPPORT_XYAM_PLOT
}

bool WksDatasetListHelper::GetSelColTypes( vector<int> &vnColType )
{
	vector<uint> vuSelRows;
	if( !m_pDatasetList->GetSelRows( vuSelRows ) )
		return false;
	
	if( CHECK_VECTOR_IS_EMPTY(vuSelRows) || CHECK_IS_SEL_FIX_ROW(vuSelRows) )
		return false;
	
	for( int ii = 0; ii < vuSelRows.GetSize(); ++ii )
	{		
		string strBookSheet = m_pDatasetList->GetSelRowDataSheetName( vuSelRows[ii] );
		
		Worksheet wks( strBookSheet );
		ASSERT( wks.IsValid() );
		
		if( wks )
		{
			string strColName = GET_CELL_STR( vuSelRows[ii], COL_SNAME );
			_remove_designation_from_col_short_name( strColName );
			
			Column col = wks.Columns( strColName );
			ASSERT( col.IsValid() );
			
			vnColType.Add (col.GetType() );
		}
	}

	return true;
}

///-----Kit 03/01/2011 ORG-2331-P1 ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT
bool WksDatasetListHelper::GetAvailableCols(vector<bool> &vnAvailCols)
{ 
	vnAvailCols = true; 
	/// Kenny 08/22/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
#ifdef NEW_NAMED_RANGE_FEATURE
	vnAvailCols[COL_SCOPE] = false;
#endif // NEW_NAMED_RANGE_FEATURE
	/// End ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	return true;
}
///-----End ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT
/************************************************************************/
/* ---MatDatasetListHelper					                            */
/************************************************************************/
class MatDatasetListHelper : public DatasheetDatasetListHelper
{
public:
	MatDatasetListHelper( const DatasetList *pDatasetList, FolderType folderType ) : DatasheetDatasetListHelper( pDatasetList, folderType ) {}
	~MatDatasetListHelper() {}
	
	//virtual
	int		GetType() { return EXIST_MATRIX; }	
	///Jasmine 01/21/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
	//virtual
	int		GetDatasetInfo(){return PGDN_IN_MATRIX;}
	///End FILTER_GRAPH_SOURCE_DATA
	//virtual 
	string	GetKey() { return "MatrixObject"; }
	
	///-----Kit 03/01/2011 ORG-2331-P1 ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT
	// virtual
	bool	GetAvailableCols(vector<bool> &vbAvailCols);
	///-----End ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT
protected:	
	//virtual
	bool 	DelObject( const Datasheet &ds, LPCTSTR lpcstrSName );
	//virtual
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	//bool	GetDSNameAndDesignations( int nSelRow, vector<string> &vsDSName, vector<uint> &vuDesig );
	/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
	//bool	GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, vector<string> &vsDSName, vector<uint> &vuDesig );
	bool	GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, DWORD dwLayerBits, vector<string> &vsDSName, vector<uint> &vuDesig );
	///End SUPPORT_TERNARY_PLOT
	///End SUPPORT_XYY_PLOT
};

//virtual
bool MatDatasetListHelper::DelObject( const Datasheet &ds, LPCTSTR lpcstrSName )
{
	ASSERT( ds.IsValid() );
	MatrixLayer matly = ds;
	
	ASSERT( matly.IsValid() );
	
	int nMatIndex = atoi( lpcstrSName ) - 1;
	ASSERT( nMatIndex >= 0 );
	
	bool bSuccess = matly.Delete( nMatIndex );
	ASSERT( bSuccess );
	
	return bSuccess;
}
	
/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
//bool MatDatasetListHelper::GetDSNameAndDesignations( int nSelRow, vector<string> &vsDSName, vector<uint> &vuDesig )
/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
//bool	MatDatasetListHelper::GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, vector<string> &vsDSName, vector<uint> &vuDesig )
bool	MatDatasetListHelper::GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, DWORD dwLayerBits, vector<string> &vsDSName, vector<uint> &vuDesig )
///End SUPPORT_TERNARY_PLOT
///End SUPPORT_XYY_PLOT
{
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	/*
	string strDSName = GET_CELL_STR( nSelRow, COL_SNAME );
	ASSERT( !strDSName.IsEmpty() );

	vsDSName.Add( strDSName );
	vuDesig.Add( COLDESIG_Z );
	*/
	for(int nn = 0; nn < vsColSNames.GetSize(); nn++)
	{
		string strDSName = vsColSNames[nn];
		
		vsDSName.Add( strDSName );
		vuDesig.Add( COLDESIG_Z );
	}
	///End SUPPORT_XYY_PLOT
	return true;	
}

///-----Kit 03/01/2011 ORG-2331-P1 ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT
bool MatDatasetListHelper::GetAvailableCols(vector<bool> &vnAvailCols)
{
	ASSERT(vnAvailCols.GetSize() == COL_LAST_ITEM);

#ifdef SUPPORT_COMMON_UDLS
	vnAvailCols[COL_UDL] = 		
	vnAvailCols[COL_UDL2] =
	vnAvailCols[COL_UDL3] =
#endif //SUPPORT_COMMON_UDLS
	vnAvailCols[COL_UNITS] = 
	vnAvailCols[COL_COMMENTS] = 
	vnAvailCols[COL_PARAMS] =
	vnAvailCols[COL_PARAMS2] =
	vnAvailCols[COL_PARAMS3] = 
	/// Kenny 08/22/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
#ifdef NEW_NAMED_RANGE_FEATURE
	vnAvailCols[COL_SCOPE] = 
#endif // NEW_NAMED_RANGE_FEATURE
	/// End ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		false;

	return true;
}
///-----End ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT


/************************************************************************/
/* ---LooseDatasetListHelper                                              */
/************************************************************************/

class LooseDatasetListHelper : public DatasetListHelperBase
{
public:
	LooseDatasetListHelper( const DatasetList *pDatasetList, FolderType folderType ) : DatasetListHelperBase( pDatasetList, folderType ) {}	
	~LooseDatasetListHelper(){}
	
	//virtual
	int		DelObjects();
	//virtual
	int		GetType(){ return EXIST_DATA; }
	//virtual
	/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
	//bool	GetDataPlotTreeAttribute( Array<MakeDataPlotTreeAttribute&> &arrDPTAttr );	
	bool	GetDataPlotTreeAttribute( Array<MakeDataPlotTreeAttribute&> &arrDPTAttr, DWORD dwLayerBits );	
	///End SUPPORT_TERNARY_PLOT
	
	//virtual 
	string	GetKey() { return "LooseDataset"; }	
	//virtual
	int		BuildDataObjectInfo();
	
	///-----Kit 03/01/2011 ORG-2331-P1 ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT
	// virtual
	bool	GetAvailableCols(vector<bool> &vbAvailCols);
	
	// virtual
	bool	GetHiddenCols(vector<bool> &vbHiddenCols);
	///-----End ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT
	
	///-----Kit 03/03/2011 ORG-2307-P4 SUPPORT_LOOSE_DATASET_ADD_PLOT_TO_3D_LAYER
	// virtual
	bool	GetSelColTypes( vector<int> &nColType );
	///-----End SUPPORT_LOOSE_DATASET_ADD_PLOT_TO_3D_LAYER
	
protected:
	bool	IsFuncPlot( LPCTSTR lpcstrDSName );
	//bool	IsVirtualMatrix( LPCTSTR lpcstrDSName ){ return okutil_is_virtual_matrix( lpcstrDSName ); }	
	//virtual
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	//bool	GetDSNameAndDesignations( int nSelRow, vector<string> &vsDSName, vector<uint> &vuDesig );
	/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
	//bool	GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, vector<string> &vsDSName, vector<uint> &vuDesig );
	bool	GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, DWORD dwLayerBits, vector<string> &vsDSName, vector<uint> &vuDesig );
	///End SUPPORT_TERNARY_PLOT
	///End SUPPORT_XYY_PLOT
};

int LooseDatasetListHelper::BuildDataObjectInfo()
{
	return m_pDatasetList->m_qr.Build("Select LOOSEDATASET from Project where _Type == L and _DatasetType == DEP");
}

bool LooseDatasetListHelper::IsFuncPlot( LPCTSTR lpcstrDSName ) 
{
	DWORD dwInfo = Project.GetDatasetInfo( lpcstrDSName );
	if( dwInfo & PGDN_FUNCTION )
		return true;
	
	return false;
}

int	LooseDatasetListHelper::DelObjects()
{
	vector<uint> vuSelRows;
	if( !m_pDatasetList->GetSelRows( vuSelRows ) )
		return 0;
	
	int ii=0;
	for( ; ii<vuSelRows.GetSize(); ++ii )
	{
		string strDSName = GET_CELL_STR( vuSelRows[ii]-ii, COL_SNAME );
		ASSERT( !strDSName.IsEmpty() );
		
		string strLT;
		strLT.Format("del -sd %s", strDSName);
		LT_execute(strLT);
		
		m_pDatasetList->DeleteRow( vuSelRows[ii]-ii );
	}
	
	ASSERT( ii == vuSelRows.GetSize() );
	return ii;
}

/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
//bool LooseDatasetListHelper::GetDSNameAndDesignations( int nSelRow, vector<string> &vsDSName, vector<uint> &vuDesig )
/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
//bool	LooseDatasetListHelper::GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, vector<string> &vsDSName, vector<uint> &vuDesig )
bool	LooseDatasetListHelper::GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, DWORD dwLayerBits, vector<string> &vsDSName, vector<uint> &vuDesig )
///End SUPPORT_TERNARY_PLOT
///End SUPPORT_XYY_PLOT
{
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	/*
	string strDSName = GET_CELL_STR( nSelRow, COL_SNAME );
	ASSERT( !strDSName.IsEmpty() );
	
	/// Iris 1/20/2011 FIX_LOOSEDATASET_PLOT_X_DATA_IS_ROW_NUMBER
	//vsDSName.Add( STR_AUTOX );
	string strXDSName;
	DatasetInfoMore stMoreInfo;
	Project.GetDatasetInfo(strDSName, false, &stMoreInfo);
	vsDSName.Add( stMoreInfo.szDependent );
	///End FIX_LOOSEDATASET_PLOT_X_DATA_IS_ROW_NUMBER	
	vuDesig.Add( COLDESIG_X );

	vsDSName.Add( strDSName );
	vuDesig.Add( COLDESIG_Y );
	*/
	for(int nn = 0; nn < vsColSNames.GetSize(); nn++)
	{
		string strDSName = vsColSNames[nn];
		
		DatasetInfoMore stMoreInfo = {0};
		
		///-----Kit 03/03/2011 ORG-2307-P4 SUPPORT_LOOSE_DATASET_ADD_PLOT_TO_3D_LAYER
// 		vsDSName.Add( stMoreInfo.szDependent );
// 		vuDesig.Add( COLDESIG_X );
// 	
// 		vsDSName.Add( strDSName );
// 		vuDesig.Add( COLDESIG_Y );

 		///-----Kit 03/05/2011 ORG-2307-P5 RUNTIME_ERROR_WHEN_REMOVE_A_PLOT_AFTER_APPLY

		int nColType = _get_ds_info(strDSName, stMoreInfo);
		
		if( strcmp("", stMoreInfo.szXDependent) != 0 )
		{
			vsDSName.Add(stMoreInfo.szXDependent);
			vuDesig.Add(COLDESIG_X);

			vsDSName.Add(stMoreInfo.szDependent);
			vuDesig.Add(COLDESIG_Y);

			vsDSName.Add(strDSName);
			vuDesig.Add(cvt_col_type_to_designation(nColType));
		}
		else
		{
			vsDSName.Add(stMoreInfo.szDependent);
			vuDesig.Add(COLDESIG_X);
			
			vsDSName.Add(strDSName);
			vuDesig.Add(COLDESIG_Y);
		}
		///-----End RUNTIME_ERROR_WHEN_REMOVE_A_PLOT_AFTER_APPLY
 		///-----End SUPPORT_LOOSE_DATASET_ADD_PLOT_TO_3D_LAYER
	}
	///End SUPPORT_XYY_PLOT
	return true;
}

/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
//bool LooseDatasetListHelper::GetDataPlotTreeAttribute( Array<MakeDataPlotTreeAttribute&> &arrDPTAttr )
bool LooseDatasetListHelper::GetDataPlotTreeAttribute( Array<MakeDataPlotTreeAttribute&> &arrDPTAttr, DWORD dwLayerBits )
///End SUPPORT_TERNARY_PLOT
{
	vector<uint> vuSelRows;
	if( !m_pDatasetList->GetSelRows( vuSelRows ) )	
		return false;

	MakeDataPlotTreeAttribute *pDPTAttr = new MakeDataPlotTreeAttribute;
	
	for( int ii=0; ii<vuSelRows.GetSize(); ++ii )
	{
		pDPTAttr->strBook = pDPTAttr->strSheet = "";
		/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
		//GetDSNameAndDesignations( vuSelRows[ii], pDPTAttr->vsDSName, pDPTAttr->vuDesig );
		vector<string> vsDSNames;
		///Iris 02/18/2011 ORG-1826-S8 MOVE_COLUMN_ORDER_MORE
		//vsDSNames.Add( m_pDatasetList->GetCell( vuSelRows[ii], COL_SNAME) );
		vsDSNames.Add( GET_CELL_STR( vuSelRows[ii], COL_SNAME ) );
		///End MOVE_COLUMN_ORDER_MORE
		/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
		//GetDSNameAndDesignations( "", vsDSNames, pDPTAttr->vsDSName, pDPTAttr->vuDesig );
		GetDSNameAndDesignations( "", vsDSNames, dwLayerBits, pDPTAttr->vsDSName, pDPTAttr->vuDesig );
		///End SUPPORT_TERNARY_PLOT
		///End SUPPORT_XYY_PLOT
	}
	
	arrDPTAttr.Add( *pDPTAttr );
	return true;
}

///-----Kit 03/01/2011 ORG-2331-P1 ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT
bool	LooseDatasetListHelper::GetAvailableCols(vector<bool> &vbAvailCols)
{
	ASSERT(vbAvailCols.GetSize() == COL_LAST_ITEM);

#ifdef SUPPORT_COMMON_UDLS
	vbAvailCols[COL_UDL] = 
	vbAvailCols[COL_UDL2] =
	vbAvailCols[COL_UDL3] =
#endif //SUPPORT_COMMON_UDLS
	vbAvailCols[COL_FOLDER] = 
	vbAvailCols[COL_BOOK_NAME] = 			///------ Tony 07/04/2012 ORG-2893-S1 ADD_BOOK_NAMING_COLUMN
	vbAvailCols[COL_BOOK_SN] = 
	vbAvailCols[COL_SHEET] = 
	vbAvailCols[COL_UNITS] = 
	vbAvailCols[COL_COMMENTS] = 
	vbAvailCols[COL_PARAMS] =
	vbAvailCols[COL_PARAMS2] =
	vbAvailCols[COL_PARAMS3] =
	vbAvailCols[COL_INDEX]	=
	vbAvailCols[COL_BOOK_LN] = 
	/// Kenny 08/22/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
#ifdef NEW_NAMED_RANGE_FEATURE
	vbAvailCols[COL_SCOPE] = 
#endif // NEW_NAMED_RANGE_FEATURE
	/// End ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		false;	///-----Kit 04/21/2011 ORG-2690-P1 GET_BOOK_NAME_FAIL_AFTER_COL_SORTED

	return true;
}

// virtual
bool LooseDatasetListHelper::GetHiddenCols(vector<bool> &vbHiddenCols)
{
	ASSERT(vbHiddenCols.GetSize() == COL_LAST_ITEM);

	vbHiddenCols = true;
	vbHiddenCols[COL_DSNAME] = false;
	
	return true;
}
///-----End ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT

///-----Kit 03/03/2011 ORG-2307-P4 SUPPORT_LOOSE_DATASET_ADD_PLOT_TO_3D_LAYER
// virtual
bool LooseDatasetListHelper::GetSelColTypes( vector<int> &vnColType )
{
	vector<uint> vuSelRows;
	if( !m_pDatasetList->GetSelRows(vuSelRows) )
		return false;

	vnColType.SetSize(vuSelRows.GetSize());
	
	for( int ii =0; ii < vuSelRows.GetSize(); ++ii )
	{
		string strDSName = m_pDatasetList->GetCell(flexcpText, vuSelRows[ii], m_pDatasetList->GetColPos(COL_DSNAME));
		DatasetInfoMore stDSMoreInfo = {0};

		///-----Kit 03/05/2011 ORG-2307-P5 RUNTIME_ERROR_WHEN_REMOVE_A_PLOT_AFTER_APPLY
// 		if( '\0' != stDSMoreInfo.szDependent[0] )
// 		{
// 			DatasetInfoMore stDSDependentInfo = {0};
// 			Project.GetDatasetInfo(stDSMoreInfo.szDependent, FALSE, &stDSDependentInfo);
// 			if( '\0' != stDSDependentInfo.szDependent[0] )
// 			{
// 				vnColType[ii] = OKDATAOBJ_DESIGNATION_Z;
// 				continue;
// 			}
// 		}
		vnColType[ii] = _get_ds_info(strDSName, stDSMoreInfo);
		///-----End RUNTIME_ERROR_WHEN_REMOVE_A_PLOT_AFTER_APPLY
	}
	
	return true;
}
///-----End SUPPORT_LOOSE_DATASET_ADD_PLOT_TO_3D_LAYER

/************************************************************************/
/* ---FuncPlotDatasetListHelper                                         */
/************************************************************************/
class FuncPlotDatasetListHelper : public LooseDatasetListHelper
{
public:
	FuncPlotDatasetListHelper( const DatasetList *pDatasetList, FolderType folderType ) : LooseDatasetListHelper( pDatasetList, folderType ) {}
	~FuncPlotDatasetListHelper(){}
	
	//virtual
	int		BuildDataObjectInfo();
	//virtual
	int		GetType(){ return EXIST_FUNC_PLOT; }
};

//virtual
int FuncPlotDatasetListHelper::BuildDataObjectInfo()
{
	return m_pDatasetList->m_qr.Build("Select FUNCTIONPLOT from Project");
}

///-----Kit 03/03/0211 ORG-2307-P3 MAKE_FUNC_PLOT_AS_2D_CASE
// virtual
// bool FuncPlotDatasetListHelper::GetSelColTypes( vector<int> &vnColType )
// {
// 
// 	vector<uint> vuSelRows;
// 	if( !m_pDatasetList->GetSelRows(vuSelRows) )
// 		return false;
// 	
// 	vnColType.SetSize(vuSelRows.GetSize());
// 
// 	///-----Kit 03/03/2011 function plot can not plot in 3D Layer now, 
// 	// so I just make all the selected row is OKDATAOBJ_DESIGNATION_Y
// 	for( int ii = 0; ii < vnColType.GetSize(); ++ii )
// 	{
// 		string strDSName = m_pDatasetList->GetCell(flexcpText, vuSelRows[ii], m_pDatasetList->GetColPos(COL_DSNAME));
// 		DatasetInfoMore stDSMoreInfo = {0};
// 		Project.GetDatasetInfo(strDSName, FALSE, &stDSMoreInfo);
// 		if( '\0' != stDSMoreInfo)
// 		vnColType = OKDATAOBJ_DESIGNATION_Y;
// 	}
// 	
// 	return true;
// }
// ///-----End MAKE_FUNC_PLOT_AS_2D_CASE

/************************************************************************/
/* ---VirtualMatrixListHelper                                            */
/************************************************************************/
class VirtualMatrixListHelper : public LooseDatasetListHelper
{
public:
	VirtualMatrixListHelper( const DatasetList *pDatasetList, FolderType folderType ) : LooseDatasetListHelper( pDatasetList, folderType ) {}
	
	~VirtualMatrixListHelper(){}
	//virtual
	int		BuildDataObjectInfo();
	//virtual
	/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
	//bool	GetDSNameAndDesignations( int nSelRow, vector<string> &vsDSName, vector<uint> &vuDesig );
	/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
	//bool	GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, vector<string> &vsDSName, vector<uint> &vuDesig );
	bool	GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, DWORD dwLayerBits, vector<string> &vsDSName, vector<uint> &vuDesig );
	///End SUPPORT_TERNARY_PLOT	
	///End SUPPORT_XYY_PLOT
	//virtual
	bool	IsVirtualMatrix() { return true; }
	
	///-----Kit 03/01/2011 ORG-2331-P2 ONLY_SHOW_DS_NAME_BOOKSHEETCOLNAME_IN_VIRTUAL_MAT
	// virtual
	bool	GetHiddenCols(vector<bool> &vbHiddenCols);
	///-----End ONLY_SHOW_DS_NAME_BOOKSHEETCOLNAME_IN_VIRTUAL_MAT
};

//virtual
int VirtualMatrixListHelper::BuildDataObjectInfo()
{
	return m_pDatasetList->m_qr.Build(SQL_STR_SEL_VM_FROM_PROJECT);
}

/// Iris 1/25/2011 ORG-2100-P3 SUPPORT_XYY_PLOT
/*
bool VirtualMatrixListHelper::GetDSNameAndDesignations( int nSelRow, vector<string> &vsDSName, vector<uint> &vuDesig )
{
	string strDSName = GET_CELL_STR( nSelRow, COL_SNAME );
	ASSERT( !strDSName.IsEmpty() );
	
	vsDSName.Add( strDSName );
	vuDesig.Add( COLDESIG_Z );

	return true;
}
*/
/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
//bool VirtualMatrixListHelper::GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, vector<string> &vsDSName, vector<uint> &vuDesig )
bool VirtualMatrixListHelper::GetDSNameAndDesignations( LPCSTR lpcszBookSheet, const vector<string>& vsColSNames, DWORD dwLayerBits, vector<string> &vsDSName, vector<uint> &vuDesig )
///End SUPPORT_TERNARY_PLOT
{
	for(int nn = 0; nn < vsColSNames.GetSize(); nn++)
	{
		string strDSName = vsColSNames[nn];
		vsDSName.Add( strDSName );
		vuDesig.Add( COLDESIG_Z );
	}
	return true;
}
///End SUPPORT_XYY_PLOT

///-----Kit 03/01/2011 ORG-2331-P2 ONLY_SHOW_DS_NAME_BOOKSHEETCOLNAME_IN_VIRTUAL_MAT
// virtual
bool VirtualMatrixListHelper::GetHiddenCols(vector<bool> &vbHiddenCols)
{
	ASSERT(vbHiddenCols.GetSize() == COL_LAST_ITEM);
	
	vbHiddenCols = true;
	vbHiddenCols[COL_BOOK_SHEET_COL] =
	vbHiddenCols[COL_DSNAME] = false;

	return true;
}
///-----End ONLY_SHOW_DS_NAME_BOOKSHEETCOLNAME_IN_VIRTUAL_MAT

/// Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
#ifdef NEW_NAMED_RANGE_FEATURE
class NamedRangeWksListHelper : public LooseDatasetListHelper
{
public:
	NamedRangeWksListHelper( const DatasetList *pDatasetList, FolderType folderType )
		: LooseDatasetListHelper( pDatasetList, folderType )
	{
	}
	
	//virtual
	int		GetType(){ return EXIST_NAMED_RANGE; }
	
	//virtual 
	string	GetKey() { return "NamedRange"; }	
	
	//virtual
	int		BuildDataObjectInfo();
	
	//virtual
	bool	GetHiddenCols(vector<bool> &vbHiddenCols);
	
	//virtual
	bool	GetAvailableCols(vector<bool> &vbAvailCols);
};

//virtual
int NamedRangeWksListHelper::BuildDataObjectInfo()
{
	return m_pDatasetList->m_qr.Build(SQL_STR_SEL_NAMED_RANGE_WKS_FROM_PROJ);
}

bool NamedRangeWksListHelper::GetHiddenCols(vector<bool> &vbHiddenCols)
{
	ASSERT(vbHiddenCols.GetSize() == COL_LAST_ITEM);
	
	vbHiddenCols = true;
	vbHiddenCols[COL_LNAME] = 
	vbHiddenCols[COL_BOOK_SHEET_COL] = 
	vbHiddenCols[COL_SCOPE] = false;

	return true;
}

bool NamedRangeWksListHelper::GetAvailableCols(vector<bool> &vbAvailCols)
{
	vbAvailCols	= false;
	vbAvailCols[COL_LNAME] =
	vbAvailCols[COL_UNITS] = 
	vbAvailCols[COL_COMMENTS] = 
	vbAvailCols[COL_1ST_VALUE] = 
	vbAvailCols[COL_BOOK_SHEET_COL] = 
	vbAvailCols[COL_SCOPE] = 
		true;
	return true;
}
#endif	// NEW_NAMED_RANGE_FEATURE
/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP

/************************************************************************/
/* ---DatasetList           		  			                        */
/************************************************************************/
#define STR_WARNING_MSG		_L("Are you sure to Delete %d Dataset(s)")

/// Kenny 08/19/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
//DatasetList::DatasetList( UINT nID, WndContainer &Dlg, LPCTSTR lpcstrHeading )
DatasetList::DatasetList( UINT nID, WndContainer &Dlg )
/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
{
	SetDlgName(STR_DLG_NAME);
	GridListControl::Init( nID, Dlg );
	SetDrawHidedColMarker(true);	///Jasmine 01/13/11 ORG-1997-S6 DRAW_MARKER_FOR_THE_HIDEED_COLUMN
	m_bIsSelectionReady = true; /// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_REMOVE_PLOTS_SPEED
	m_btnIncShortcut = Dlg.GetDlgItem(IDC_LAYER_CONTENTS_INCLUDE_SHORTCUT); /// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
	
	m_pDatasetListHelper = new WksDatasetListHelper( this, FLD_TYPE_CURRENT_FLD );	
	
	///Jasmine 01/04/11 ORG-1826-S8 MOVE_COLUMN_ORDER, after "new WksDatasetListHelper" and before InitColsShowHidden
	m_colMap = new MoveColHelper();	///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
	InitColsOrder();
	/// Kenny 08/19/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	//setListHeading(lpcstrHeading);
	setListHeading();
	/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	///End MOVE_COLUMN_ORDER
	
	SetAllowSelection(true);
	SetSelection(flexSelectionListBox);
	SetEditable();
	m_flx.AllowUserResizing = flexResizeColumns;		
	m_flx.ExplorerBar = flexExSortAndMove;//flexExSortShow;///Jasmine 01/04/11 ORG-1826-S8 MOVE_COLUMN_ORDER
	//m_flx.ExtendLastCol = false; /// Iris 12/22/2010 ORG-1826-S1.4 CHANGED_TO_NO_GRAY_IN_BOTH_SIDES_GRID 	
	SetAlternateRowColors();
	
	m_flx.MergeCells = flexMergeSpill;///Jasmine 01/19/11 ORG-2046-S1 SPILL_LONG_TEXT
	
	/// Iris 01/06/2011 ORG-1826-P7 SET_COLUMN_ALIGNMENT_MORE
	//SetColAlignment(-1, flexAlignLeftCenter); /// Iris 01/05/2011 ORG-1826-P6 SET_COLUMN_LEFT_ALIGNMENT
	vector<uint> vuDatasetListColAlignment(GetNumCols());
	vuDatasetListColAlignment = flexAlignLeftCenter;
	/// Iris 1/12/2011 SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
	/*
	vuDatasetListColAlignment[COL_1ST_VALUE+GetColOffset()] = flexAlignGeneral;
	vuDatasetListColAlignment[COL_PARAMS+GetColOffset()] = flexAlignGeneral;
	vuDatasetListColAlignment[COL_UDL+GetColOffset()] = flexAlignGeneral;	
	vuDatasetListColAlignment[COL_INDEX+GetColOffset()] = flexAlignGeneral;	
	*/
#ifdef SUPPORT_COMMON_UDLS
	///-----Kit 02/24/2011 ORG-1837-S3 ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL
	//vector<uint> vuGeneralAlignCols = {COL_1ST_VALUE, COL_PARAMS, COL_PARAMS2, COL_PARAMS3, COL_UDL, COL_UDL2, COL_UDL3, COL_INDEX};
	vector<uint> vuGeneralAlignCols = {COL_1ST_VALUE, COL_PARAMS, COL_PARAMS2, COL_PARAMS3, COL_UDL, COL_UDL2, COL_UDL3, COL_INDEX, COL_BOOK_SHEET_COL};
	///-----End ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL
#else
	///-----Kit 02/24/2011 ORG-1837-S3 ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL
	//vector<uint> vuGeneralAlignCols = {COL_1ST_VALUE, COL_PARAMS, COL_PARAMS2, COL_PARAMS3, COL_INDEX};
	vector<uint> vuGeneralAlignCols = {COL_1ST_VALUE, COL_PARAMS, COL_PARAMS2, COL_PARAMS3, COL_INDEX, COL_BOOK_SHEET_COL};
	///-----End ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL
#endif 

	for(int nn = 0; nn < vuGeneralAlignCols.GetSize(); nn++)
	{
		vuDatasetListColAlignment[vuGeneralAlignCols[nn]+GetColOffset()] = flexAlignGeneral;
	}
	///End SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
	for(int nType = COL_FIRST_ONE, index = 0; nType < COL_LAST_ITEM; ++nType, ++index)
	{
		SetColAlignment(GetColPos(nType), vuDatasetListColAlignment[index]);
	}
	///End SET_COLUMN_ALIGNMENT_MORE	
	
	/// Iris 01/05/2011 ORG-1826-P5 COL_GOOD_DEFAULT_SIZE_AND_REMEMBER_SIZE_WHEN_REOPEN_DLG
	/*
	if( !InitColsWidthFromReg() )
		ResizeCols();		
	*/
	///End COL_GOOD_DEFAULT_SIZE_AND_REMEMBER_SIZE_WHEN_REOPEN_DLG
	InitColsShowHidden();
	
	EnableScript(true);
}

DatasetList::~DatasetList()
{	
	SaveColsWidthToReg();		
	
	SaveColsShowHiddenToReg(getRegSectionName("ColHidden"));

	SaveColsOrder();///Jasmine 01/05/11 ORG-1826-S8 MOVE_COLUMN_ORDER
	
	delete m_pDatasetListHelper;
	
	delete m_colMap;	///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS

	///------ Folger 05/30/2012 ORG-5738-S1 LAYER_CONTENT_OC_FILTER_FUNCTION_EVENT_SUPPORT
	for ( int ii=0; ii<m_vsFilterFuncs.GetSize(); ++ii )
	{
		BOOL bb = TriggerFilterFunctionEvent(m_vsFilterFuncs[ii], QUERYRESULTS_FILTER_EVENT_BEFORE_CLOSE);
		ASSERT(bb);
	}
	///------ End LAYER_CONTENT_OC_FILTER_FUNCTION_EVENT_SUPPORT
}

///------ Folger 05/30/2012 ORG-5738-S1 LAYER_CONTENT_OC_FILTER_FUNCTION_EVENT_SUPPORT
BOOL DatasetList::TriggerFilterFunctionEvent(LPCSTR lpcszFunc, int nEvent)
{
	DATASET_FILTER_FUNC_EX pfn = Project.FindCompiledFunction(lpcszFunc);
	if ( pfn )
	{
		OriginObject obj;
		pfn(obj, nEvent);
		return TRUE;
	}

	return FALSE;
}
///------ End LAYER_CONTENT_OC_FILTER_FUNCTION_EVENT_SUPPORT

///Jasmine 01/05/11 ORG-1826-S8 MOVE_COLUMN_ORDER
void DatasetList::InitColsOrder()
{
	m_colMap->m_vnColMap.Data(COL_FIRST_ONE, COL_LAST_ITEM - 1);
	int nSize = m_colMap->m_vnColMap.GetSize();
	
	string strSection = getRegSectionName("ColOrder");
	string strVal;
	if( dlg_load_registry(GetDlgNameForRegistry(), strSection, strVal) && !strVal.IsEmpty() )
	{
		vector<string> vsTemp;
		strVal.GetTokens(vsTemp, '|');
		/// Iris 2/16/2011 FIX_LEFT_PANEL_IS_EMPTY_WHEN_ADD_NEW_COL_IN_DATASET_LIST
		//convert_string_vector_to_uint_vector(vsTemp, m_colMap->m_vnColMap);
		vector<uint> vnOrders;
		convert_string_vector_to_uint_vector(vsTemp, vnOrders);
		///End FIX_LEFT_PANEL_IS_EMPTY_WHEN_ADD_NEW_COL_IN_DATASET_LIST
		
		//column number in registry != current column number. 
		//It may be by design(add new column or remove column). 
		//please check if it's necessary to convert for later release build
		/// Iris 2/16/2011 FIX_LEFT_PANEL_IS_EMPTY_WHEN_ADD_NEW_COL_IN_DATASET_LIST
		//ASSERT(nSize == vsTemp.GetSize());
		if( vnOrders.GetSize() <= nSize )
		{
			if( vnOrders.GetSize() < nSize )
			{
				vector<uint> vnMore;
				vnMore.Data(vnOrders.GetSize(), nSize-1, 1);
				vnOrders.Append(vnMore);
			}
			m_colMap->m_vnColMap = vnOrders;
		}
		///End FIX_LEFT_PANEL_IS_EMPTY_WHEN_ADD_NEW_COL_IN_DATASET_LIST
	}
}
void DatasetList::SaveColsOrder()
{
	string strSection = getRegSectionName("ColOrder");
	
	vector<string> vsTemp;
	convert_uint_vector_to_string_vector(m_colMap->m_vnColMap, vsTemp);
	
	string strVal;
	strVal.SetTokens(vsTemp, '|');
	
	dlg_save_to_registry(GetDlgNameForRegistry(), strSection, strVal);		
}
///End MOVE_COLUMN_ORDER

int DatasetList::DelObjects()
{
	vector<uint> vnSelected;
	if( !GetSelRows( vnSelected ) )
		return 0;
	
	string strWarningMsg;
	strWarningMsg.Format( STR_WARNING_MSG, vnSelected.GetSize() );

	int nMsgBoxRet = MessageBox(GetWindow(), strWarningMsg, _L("Warning"), MB_OKCANCEL | MB_ICONQUESTION );
	if( IDCANCEL == nMsgBoxRet )
		return 0;
	
	return m_pDatasetListHelper->DelObjects();
}

/// Iris 01/07/2011 ORG-1646-P1 SETBOLD_CAUSE_SLOW_SPEED_MORE
/*
/// Iris 12/23/2010 ORG-1826-S1.5 SET_BOLD_FONT_ON_PLOTTED_DATASETS
bool DatasetList::UpdateBlodStatusByDatasetNames(vector<string>& vsDSNames)
{
	/// Iris 01/04/2011 ORG-1646-P1 SETBOLD_CAUSE_SLOW_SPEED	
	//if( vsDSNames.GetSize() == 0 )
	//{
		//return SetBold(-1, -1, false);		
	//}	
	///End SETBOLD_CAUSE_SLOW_SPEED

	vector<string> vsDataListDSNames;
	if( !GetColValues(GetColPos(COL_DSNAME), vsDataListDSNames, GetRowOffset() ) )///Jasmine 01/05/11 ORG-1826-S8 MOVE_COLUMN_ORDER
		return false; // no row
		
	/// Iris 01/04/2011 ORG-1646-P1 SETBOLD_CAUSE_SLOW_SPEED
	//SetBold(-1, -1, false);
	for(int index = 0; index < m_vnBoldRows.GetSize(); index++)
	{
		SetBold(m_vnBoldRows[index], -1, false);
	}
	m_vnBoldRows.SetSize(0);
	///End SETBOLD_CAUSE_SLOW_SPEED
	
	for(index = 0; index < vsDSNames.GetSize(); index++)
	{
		int nFound = vsDataListDSNames.Find( vsDSNames[index] );
		if( nFound >= 0 )
		{
			int nRow = nFound + GetRowOffset();		
			SetBold(nRow, -1, true); // -1 means set blod to this row all columns
			m_vnBoldRows.Add(nRow);
		}
	}
	return true;
}
///End SET_BOLD_FONT_ON_PLOTTED_DATASETS

/// Iris 12/29/2010 ORG-1826-S7 HIGHLIGHT_ADDED_OR_REMOVED_PLOTS
bool DatasetList::SetSelectionByDatasetNames(vector<string>& vsDSNames)
{
	vector<string> vsDataListDSNames;
	if( !GetColValues(GetColPos(COL_DSNAME), vsDataListDSNames, GetRowOffset() ) )///Jasmine 01/05/11 ORG-1826-S8 MOVE_COLUMN_ORDER
		return false; // no row
	
	vector<uint> vuSelRows;
	for(int index = 0; index < vsDSNames.GetSize(); index++)
	{
		int nFound = vsDataListDSNames.Find( vsDSNames[index] );
		if( nFound >= 0 )
		{
			int nRow = nFound + GetRowOffset();	
			vuSelRows.Add(nRow);			
		}
	}
	
	if( vuSelRows.GetSize() > 0 )
	{
		return SelRows(vuSelRows);
	}
	return false;	
}
///End HIGHLIGHT_ADDED_OR_REMOVED_PLOTS
*/

///-----Kit 02/25/2011 ORG-2319-S1 SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW
bool DatasetList::FindRowIndexesByDatasetName(const vector<string> &vsDSNames, vector<int> &vnRowIndexes)
{
	vnRowIndexes.RemoveAll();
	for( int ii = 0; ii < vsDSNames.GetSize(); ++ii )
	{
		int nRow = FindRow(vsDSNames[ii], GetColPos(COL_DSNAME));
		if( GetRowOffset() <= nRow)
			vnRowIndexes.Add(nRow);
	}
	return true;
}
///-----End SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW

///-----Kit 04/14/2011 ORG-2614-P1 FAILED_GET_CORRECT_BOOK_WHEN_THE_BOOKS_HAVE_SAME_LN
// cover the GridControl method
///-----Kit 04/28/2011 ORG-2614-S1 SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
// 
// _VARIANT	DatasetList::GetCell(CellPropertySettings settings, int nRow, int nCol)
// {
// 	if( COL_BOOK_SN == nCol && is_use_long_name_when_available() )
// 	{
// 		///-----Kit 04/21/2011 ORG-2690-P1 GET_BOOK_NAME_FAIL_AFTER_COL_SORTED
// 		/*
// 		m_pDatasetListHelper->BuildDataObjectInfo();
// 		vector<string> vsPageNames;
// 		m_qr.GetNames(vsPageNames, QUERYRESULTNAME_BOOK);
// 		return vsPageNames[nRow-GetRowOffset()];
// 		*/
// 		return GetCell(settings, nRow, COL_BOOK_LN);
// 		///-----End GET_BOOK_NAME_FAIL_AFTER_COL_SORTED
// 	}
// 
// 	return GridControl::GetCell(settings, nRow, nCol);
// }
///-----End SHOULD_USE_TWO_COLS_TO_SHOW_BOOK_SN_AND_BOOK_LN
///-----End FAILED_GET_CORRECT_BOOK_WHEN_THE_BOOKS_HAVE_SAME_LN

bool DatasetList::UpdateBlodStatusByDatasetNames(vector<string>& vsDSNames)
{		
	for(int index = 0; index < m_vnBoldRows.GetSize(); index++)
	{
		SetBold(m_vnBoldRows[index], -1, false);
	}
	m_vnBoldRows.SetSize(0);

	///-----Kit 02/25/2011 ORG-2319-S1 SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW
	/*
	for(index = 0; index < vsDSNames.GetSize(); index++)
	{
		///Iris 02/18/2011 ORG-1826-S8 MOVE_COLUMN_ORDER_MORE
		//int nRow = FindRow(vsDSNames[index], COL_DSNAME);
		int nRow = FindRow(vsDSNames[index], GetColPos(COL_DSNAME));
		///End MOVE_COLUMN_ORDER_MORE
		if( nRow >= GetRowOffset() )
		{
			SetBold(nRow, -1, true);
			m_vnBoldRows.Add(nRow);
		}
	}
	*/
	vector<int> vnFoundRowIndexes;
	FindRowIndexesByDatasetName(vsDSNames, vnFoundRowIndexes);
	for( index = 0; index < vnFoundRowIndexes.GetSize(); ++index)
	{
		SetBold(vnFoundRowIndexes[index], -1, true);
	}

	m_vnBoldRows.Append(vnFoundRowIndexes);
	///-----End SHOW_RANGE_TOOL_TIP_WHEN_MOUSE_OVER_THE_ROW
	return true;
}

bool DatasetList::UpdateBlodStatusForSelectedRows()
{
	vector<uint> vuSelRows;
	if( !GetSelRows(vuSelRows) )
		return false;
	
	for(int index = 0; index < vuSelRows.GetSize(); index++)
	{
		SetBold(vuSelRows[index], -1, true);
		m_vnBoldRows.Add(vuSelRows[index]);
	}
	return true;
}

bool DatasetList::SetSelectionByDatasetNames(vector<string>& vsDSNames)
{	
	vector<uint> vuSelRows;	
	for(int index = 0; index < vsDSNames.GetSize(); index++)
	{
		///Iris 02/18/2011 ORG-1826-S8 MOVE_COLUMN_ORDER_MORE
		//int nRow = FindRow(vsDSNames[index], COL_DSNAME);
		int nRow = FindRow(vsDSNames[index], GetColPos(COL_DSNAME));
		///End MOVE_COLUMN_ORDER_MORE
		if( nRow >= GetRowOffset() )
		{
			/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_REMOVE_PLOTS_SPEED
			//vuSelRows.Add(nRow);
			if( 0 == index )
				m_flx.Row = -1; // do the same action in SelRows
			/// Iris 3/15/2011 ORG-2449-P1 FIX_ADDPLOT_BUTTON_DISABLE_WHEN_REMOVED_LAST_PLOT_FROM_OTHER_FLD_WKS
			//m_bIsSelectionReady = (index == vsDSNames.GetSize() - 1);
			///End FIX_ADDPLOT_BUTTON_DISABLE_WHEN_REMOVED_LAST_PLOT_FROM_OTHER_FLD_WKS
			if( !GetIsSelected(nRow) )
				SetIsSelected(nRow, true);
			///End TO_IMPROVE_REMOVE_PLOTS_SPEED
		}
		/// Iris 3/15/2011 ORG-2449-P1 FIX_ADDPLOT_BUTTON_DISABLE_WHEN_REMOVED_LAST_PLOT_FROM_OTHER_FLD_WKS
		m_bIsSelectionReady = (index == vsDSNames.GetSize() - 1);
		///End FIX_ADDPLOT_BUTTON_DISABLE_WHEN_REMOVED_LAST_PLOT_FROM_OTHER_FLD_WKS
	}
	
	/// Iris 1/21/2011 ORG-1962-P9 TO_IMPROVE_REMOVE_PLOTS_SPEED
	/*
	if( vuSelRows.GetSize() > 0 )
	{
		SelRows(vuSelRows);
	}
	*/
	///End TO_IMPROVE_REMOVE_PLOTS_SPEED
	return false;	
}
///End SETBOLD_CAUSE_SLOW_SPEED_MORE

///Jasmine 01/21/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
/// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
//void DatasetList::InitDynamicAvailDataType(int nWksInGLayerItem, int nMatInGLayerItem)
void DatasetList::InitDynamicAvailDataType(int nWksInGLayerItem, int nWkbookInGLayerItem, int nMatInGLayerItem)
///End ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
{
	m_availDataTypeWksInGLayer = nWksInGLayerItem;
	m_availDataTypeWkbookInGLayer = nWkbookInGLayerItem;  /// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	m_availDataTypeMatInGLayer = nMatInGLayerItem;
}
	
bool DatasetList::IsFilterByFunction(AvailDataComboType availDataType, int& nFilterFuncIndex) 
{
	/// Iris 1/27/2011 ORG-2046-S5 NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	// added RELATED_WKS and RELATED_MAT to AvailDataComboType enum, so no need to convert the index.
	// here availDataType variable not the real value in AvailDataComboType, it is the selection in combo.
	/*
	int nOffset = 0;
	if(m_availDataTypeWksInGLayer > 0)
		nOffset++;
	if(m_availDataTypeMatInGLayer > 0)
		nOffset++;	
	
	if(availDataType - nOffset < CUSTOM_FILTER_BEGIN)
		return false;
	
	nFilterFuncIndex = availDataType - CUSTOM_FILTER_BEGIN - nOffset;
	*/	
	/// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	//int nRealAvailDataType = _get_avail_data_type_from_combo_selection(availDataType, m_availDataTypeWksInGLayer, m_availDataTypeMatInGLayer);	
	///------ Folger 05/22/2012 ORG-5738 ADVANCED_QUERY_RESULT_OC_FILTER_FUNCTION_SUPPORT
	//int nRealAvailDataType = _get_avail_data_type_from_combo_selection(availDataType, m_availDataTypeWksInGLayer, m_availDataTypeWkbookInGLayer, m_availDataTypeMatInGLayer);	
	int nRealAvailDataType = _get_avail_data_type_from_combo_selection(availDataType, m_availDataTypeWksInGLayer, m_availDataTypeWkbookInGLayer, m_availDataTypeMatInGLayer, &nFilterFuncIndex);	
	///------ End ADVANCED_QUERY_RESULT_OC_FILTER_FUNCTION_SUPPORT
	///End ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	if(nRealAvailDataType < CUSTOM_FILTER_BEGIN)
		return false;	
	///------ Folger 05/22/2012 ORG-5738 ADVANCED_QUERY_RESULT_OC_FILTER_FUNCTION_SUPPORT
	//nFilterFuncIndex = nRealAvailDataType - CUSTOM_FILTER_BEGIN;	
	--nFilterFuncIndex;
	///------ End ADVANCED_QUERY_RESULT_OC_FILTER_FUNCTION_SUPPORT
	///End NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	return true;
}
///End FILTER_GRAPH_SOURCE_DATA

///Jasminie 02/14/11 ORG-2100-P8 SHOW_SOURCE_DATA_FOR_TEMP_PLOT
int DatasetList::GetWksInGLayerDropdown()
{
	return m_availDataTypeWksInGLayer;
}
int DatasetList::GetWBookInGLayerDropdown()
{
	return m_availDataTypeWkbookInGLayer;
}
int DatasetList::GetMatInGLayerDropdown()
{		
	return m_availDataTypeMatInGLayer;
}

int DatasetList::CheckGetCommonPageTypesInSelection(vector<int>& vnTypes)
{
	vector<int> vnTemp;
	vnTemp = vnTypes;
	vnTypes.SetSize(0);
	
	vector<uint> vuSelRows;
	if( !GetSelRows( vuSelRows ) )
		return 0;
	
	int nCount = vuSelRows.GetSize();
	for( int ii = 0; ii < nCount; ++ii )
	{
		string strBook = GetCell( flexcpText, vuSelRows[ii], GetColPos(COL_BOOK_SN) );
		Page pg(strBook);
		///-----Kit 04/28/2011 CLEAN_UP_CODE
		if( !pg.IsValid() )
		{
			ASSERT(false);
			error_report("int DatasetList::CheckGetCommonPageTypesInSelection() failed to get page!!");
			return -1;
		}
		///-----End CLEAN_UP_CODE
		vector<uint> vecIndex;
		if(vnTemp.Find(vecIndex, pg.GetType()) > 0)
		{
			vnTypes.Add( vnTemp[vecIndex[0]] );
			
			vector<int> vIndex;
			vIndex = vecIndex;
			vnTemp.RemoveAt(vIndex);
		}
		
		if(vnTemp.GetSize() <= 0)
			break;
	}
	
	return vnTypes.GetSize();
}
///End SHOW_SOURCE_DATA_FOR_TEMP_PLOT

///Jasminie 02/14/11 ORG-2100-P8 SHOW_SOURCE_DATA_FOR_TEMP_PLOT
//void DatasetList::UpdateDatasetList( AvailDataComboType availDataType )	
void DatasetList::UpdateDatasetList( AvailDataComboType availDataType, const vector<string>& vsBookSheets/* = NULL*/ )
///End SHOW_SOURCE_DATA_FOR_TEMP_PLOT
{	
	SaveColsShowHiddenToReg(getRegSectionName("ColHidden"));
	SaveColsOrder();///Jasmine 01/05/11 ORG-1826-S8 MOVE_COLUMN_ORDER
	
	/// Iris 01/17/2011 ORG-1986-P1 SHOW_COMMON_UDLS
#ifdef SUPPORT_COMMON_UDLS
	m_bCheckCommonFinished = false;
#endif //SUPPORT_COMMON_UDLS
	///End SHOW_COMMON_UDLS
	
	/// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
	/*
	int nNumDataObjects;
	bool bIsExternalFilter = false;
	///Jasmine 01/21/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
	//if( availDataType >= CUSTOM_FILTER_BEGIN ) // build dataobject info by filter function
	//{
		//int nFilterFuncIndex = availDataType - CUSTOM_FILTER_BEGIN;
	int nFilterFuncIndex;
	if( IsFilterByFunction(availDataType, nFilterFuncIndex) )	
	{
	///End FILTER_GRAPH_SOURCE_DATA
		string strFilterFuncName = _get_dataset_filter_function_name(nFilterFuncIndex);
		ASSERT(!strFilterFuncName.IsEmpty());
		
		DATASET_FILTER_FUNC pfn = Project.FindCompiledFunction(strFilterFuncName);		
		if( !pfn )
		{
			BOOL_SHOW_ERR("Fail to find customer dataset filter function " + strFilterFuncName);
			return;
		}
		nNumDataObjects = pfn(m_qr, m_nQueryObjectType);
		bIsExternalFilter = true;
	}
	*/
	///End ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
		
	/// Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	//bool bIsVitualMatrix;
	//int nPageType = convertToPageType( availDataType, m_nQueryObjectType, &bIsVitualMatrix );
	int nPageType = convertToPageType( availDataType, m_nQueryObjectType );
	/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	int nFldType = GetFolderType( availDataType );
	
	delete m_pDatasetListHelper;
	switch( nPageType )
	{
		case EXIST_WKS:
			m_pDatasetListHelper = new WksDatasetListHelper( this, nFldType );
			break;
			
		case EXIST_MATRIX:
			m_pDatasetListHelper = new MatDatasetListHelper( this, nFldType );
			break;
			
		case EXIST_DATA:
			/// Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
			//if( bIsVitualMatrix )
			if( VIRTUAL_MAT == availDataType )
			/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP				
				m_pDatasetListHelper = new VirtualMatrixListHelper( this, nFldType );
			else
				m_pDatasetListHelper = new LooseDatasetListHelper( this, nFldType );
			break;
		
		/// Kenny 08/23/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		#ifdef NEW_NAMED_RANGE_FEATURE
		case EXIST_NAMED_RANGE:
			m_pDatasetListHelper = new NamedRangeWksListHelper( this, nFldType );
			break;
		#endif // NEW_NAMED_RANGE_FEATURE
		/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
			
		case EXIST_FUNC_PLOT:
			m_pDatasetListHelper = new FuncPlotDatasetListHelper( this, nFldType );
			break;			
			
		default:
			ASSERT(false);
			break;
	}
	/// Iris 1/27/2011 ORG-2046-S5 NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	if( m_pDatasetListHelper == NULL )
	{
		error_report("Fail to update dataset list since m_pDatasetListHelper is NULL");
		return;
	}
	///End NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	
	/// Iris 01/17/2011 ORG-1986-P1 SHOW_COMMON_UDLS
#ifdef SUPPORT_COMMON_UDLS
	InitColsShowHidden();
#endif 
	///End SHOW_COMMON_UDLS
	
	/// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
	/*
	///Jasmine 01/21/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
	/// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX	
	//if(availDataType == m_availDataTypeWksInGLayer || availDataType == m_availDataTypeMatInGLayer)
	//	nNumDataObjects = m_pDatasetListHelper->BuildGraphSourceObjectInfo();	
	if(availDataType == m_availDataTypeWksInGLayer || availDataType == m_availDataTypeWkbookInGLayer || availDataType == m_availDataTypeMatInGLayer)
		nNumDataObjects = m_pDatasetListHelper->BuildGraphSourceObjectInfo( availDataType == m_availDataTypeWkbookInGLayer );
	///End ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	else if( !bIsExternalFilter )
		nNumDataObjects = m_pDatasetListHelper->BuildDataObjectInfo();	
	
	SetRows(nNumDataObjects);
	
	if( nNumDataObjects > 0 )
	{
		for(int nColType = COL_FIRST_ONE; nColType < COL_LAST_ITEM; nColType++)
		{
			int nPos = GetColPos(nColType);
			
/// Iris 01/17/2011 ORG-1986-P1 SHOW_COMMON_UDLS				
#ifdef SUPPORT_COMMON_UDLS	
			if( nColType >= COL_UDL_BEGIN && nColType <= COL_UDL_END && !IsColHidden(nPos) )
			{
				/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
				//updateCommonUDLColumns(nColType);
				updateParametersLabelColumns(nColType, false);
				///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
			}
			/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
			else if( nColType >= COL_PARAMS && nColType <= COL_PARAMS3 && !IsColHidden(nPos) )
			{
				updateParametersLabelColumns(nColType, true);
			}
			///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
			else
			{
#endif //SUPPORT_COMMON_UDLS
	
			vector<string> vsColInfo;
			if( m_pDatasetListHelper->GetOneColInfo(vsColInfo, nColType) )
			{		
				///Jasmine 01/04/11 ORG-1826-S8 MOVE_COLUMN_ORDER
				//m_flx.SetTableValue(&vsColInfo, vsColInfo.GetSize(), 1, m_flx.FixedRows, nColType, false);
				/// Iris 01/17/2011 ORG-1986-P1 SHOW_COMMON_UDLS
				//m_flx.SetTableValue(&vsColInfo, vsColInfo.GetSize(), 1, m_flx.FixedRows, nPos, false);			
				setColValues(vsColInfo, nPos);
				///End SHOW_COMMON_UDLS
				///End MOVE_COLUMN_ORDER
			}
			
#ifdef SUPPORT_COMMON_UDLS			
			}
#endif //SUPPORT_COMMON_UDLS
		}
		
	}
	*/
	QueryResultAndUpdateList(availDataType, vsBookSheets, false);
	///End ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
	
	/// Iris 01/05/2011 ORG-1826-P5 COL_GOOD_DEFAULT_SIZE_AND_REMEMBER_SIZE_WHEN_REOPEN_DLG
	if( !m_bColResized )
	{
		if( !InitColsWidthFromReg() )
			autoResizeCols();		
		m_bColResized = true;
	}
	///End COL_GOOD_DEFAULT_SIZE_AND_REMEMBER_SIZE_WHEN_REOPEN_DLG
}

/// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
bool	DatasetList::QueryResultAndUpdateList( AvailDataComboType availDataType, const vector<string>& vsBookSheets/* = NULL*/, bool bFromIncShortcutWndChanged )
{	
	m_pDatasetListHelper->SetIsIncShortcutWindows( m_btnIncShortcut && m_btnIncShortcut.Value );	
	
	//---------Iris 2/14/2011 the following copied from UpdateDatasetList method
	int nNumDataObjects;
	bool bIsExternalFilter = false;
	///Jasmine 01/21/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
	//if( availDataType >= CUSTOM_FILTER_BEGIN ) // build dataobject info by filter function
	//{
		//int nFilterFuncIndex = availDataType - CUSTOM_FILTER_BEGIN;
	int nFilterFuncIndex;
	if( IsFilterByFunction(availDataType, nFilterFuncIndex) )	
	{
	///End FILTER_GRAPH_SOURCE_DATA
		/// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
		if( bFromIncShortcutWndChanged )
			return false;
		///End ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
		
		string strFilterFuncName = _get_dataset_filter_function_name(nFilterFuncIndex);
		ASSERT(!strFilterFuncName.IsEmpty());

		///------ Folger 05/18/2012 ORG-5738 ADVANCED_QUERY_RESULT_OC_FILTER_FUNCTION_SUPPORT
		vector<string> vsFuncs;
		if ( 2 == strFilterFuncName.GetTokens(vsFuncs, '|') )
		{
			///------ Folger 05/30/2012 ORG-5738-S1 LAYER_CONTENT_OC_FILTER_FUNCTION_EVENT_SUPPORT
			if ( m_vsFilterFuncs.Find(vsFuncs[0]) < 0 )
			{
				if ( TriggerFilterFunctionEvent(vsFuncs[0], QUERYRESULTS_FILTER_EVENT_BEFORE_USE) )
					m_vsFilterFuncs.Add(vsFuncs[0]);
			}
			///------ End LAYER_CONTENT_OC_FILTER_FUNCTION_EVENT_SUPPORT

			string strQuery;
			strQuery.Format("SELECT %s FROM PROJECT", vsFuncs[1]);
			m_qr.Build(strQuery, 0, vsFuncs[0]);
			nNumDataObjects = m_qr.Size();
		}
		else
		{
		///------ End ADVANCED_QUERY_RESULT_OC_FILTER_FUNCTION_SUPPORT
			DATASET_FILTER_FUNC pfn = Project.FindCompiledFunction(strFilterFuncName);		
			if( !pfn )
			{
				BOOL_SHOW_ERR("Fail to find customer dataset filter function " + strFilterFuncName);
				return false;
			}
			nNumDataObjects = pfn(m_qr, m_nQueryObjectType);
		} ///------ Folger 05/18/2012 ORG-5738 ADVANCED_QUERY_RESULT_OC_FILTER_FUNCTION_SUPPORT
		bIsExternalFilter = true;
	}	
	
	///Jasmine 01/21/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
	/// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX	
	//if(availDataType == m_availDataTypeWksInGLayer || availDataType == m_availDataTypeMatInGLayer)
	//	nNumDataObjects = m_pDatasetListHelper->BuildGraphSourceObjectInfo();	
	///Jasminie 02/14/11 ORG-2100-P8 SHOW_SOURCE_DATA_FOR_TEMP_PLOT
	if(	bFromIncShortcutWndChanged &&
		(availDataType == m_availDataTypeWksInGLayer || 
		 availDataType == m_availDataTypeWkbookInGLayer ||
		 availDataType == m_availDataTypeMatInGLayer) )
	{
		return false;
	}
	 
	if(availDataType == m_availDataTypeWkbookInGLayer)
	{
		nNumDataObjects = m_pDatasetListHelper->BuildGraphSourceBookInfo(vsBookSheets);
	}
	else if(availDataType == m_availDataTypeWksInGLayer ||
		 	availDataType == m_availDataTypeMatInGLayer)
	{
		nNumDataObjects = m_pDatasetListHelper->BuildGraphSourceSheetInfo(vsBookSheets);
	}
	///End SHOW_SOURCE_DATA_FOR_TEMP_PLOT
	///End ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	else if( !bIsExternalFilter )
		nNumDataObjects = m_pDatasetListHelper->BuildDataObjectInfo();	
		
	/// Iris 2/14/2011 ORG-2239 ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
	if( bFromIncShortcutWndChanged && nNumDataObjects == GetNumRows() )
	{
		return false; // compare the result of inc shortcut with the result of NOT inc, if the result count is same, so need to update list.
	}
	if( GetNumRows() > 0 )
		ClearAll();
	///End ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG
	
	SetRows(nNumDataObjects);
	
	if( nNumDataObjects > 0 )
	{
		for(int nColType = COL_FIRST_ONE; nColType < COL_LAST_ITEM; nColType++)
		{
			int nPos = GetColPos(nColType);
			
/// Iris 01/17/2011 ORG-1986-P1 SHOW_COMMON_UDLS				
#ifdef SUPPORT_COMMON_UDLS	
			if( nColType >= COL_UDL_BEGIN && nColType <= COL_UDL_END && !IsColHidden(nPos) )
			{
				/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
				//updateCommonUDLColumns(nColType);
				updateParametersLabelColumns(nColType, false);
				///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
			}
			/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
			else if( nColType >= COL_PARAMS && nColType <= COL_PARAMS3 && !IsColHidden(nPos) )
			{
				updateParametersLabelColumns(nColType, true);
			}
			///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
			else
			{
#endif //SUPPORT_COMMON_UDLS
	
			vector<string> vsColInfo;
			if( m_pDatasetListHelper->GetOneColInfo(vsColInfo, nColType) )
			{		
				///Jasmine 01/04/11 ORG-1826-S8 MOVE_COLUMN_ORDER
				//m_flx.SetTableValue(&vsColInfo, vsColInfo.GetSize(), 1, m_flx.FixedRows, nColType, false);
				/// Iris 01/17/2011 ORG-1986-P1 SHOW_COMMON_UDLS
				//m_flx.SetTableValue(&vsColInfo, vsColInfo.GetSize(), 1, m_flx.FixedRows, nPos, false);			
				setColValues(vsColInfo, nPos);
				///End SHOW_COMMON_UDLS
				///End MOVE_COLUMN_ORDER
			}
			
#ifdef SUPPORT_COMMON_UDLS			
			}
#endif //SUPPORT_COMMON_UDLS
		}
		
	}	
	
	int nRows  = GetRows();
	//--------- coped end
	return true;
}
///End ADD_INC_SHORTCUT_WINDOWS_IN_LAYER_CONTENTS_DLG

///Jasmine 01/04/11 ORG-1826-S8 MOVE_COLUMN_ORDER
int 	DatasetList::GetColPos(int nType)
{
	return m_colMap->GetColPos(nType);///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
}
int 	DatasetList::GetColType(int nPosition)
{
	return m_colMap->GetColType(nPosition);///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
}
void 	DatasetList::OnAfterMoveColumns(Control ctrl, long lCol, long *pnPosition)
{
	m_colMap->OnAfterMoveColumns(lCol, pnPosition);///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
}
///End MOVE_COLUMN_ORDER

void 	DatasetList::OnBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, bool* pCancel)
///Sophy 2/7/2012 ORG-4478-P6 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
{
}
void	DatasetList::OnContextMenu(int nx, int ny)
///end CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
{
	///Sophy 2/7/2012 ORG-4478-P6 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	//if(MK_RBUTTON != nButton)
	//	return;	
	///end CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	int nRow, nCol;
	GetMouseCell(nRow, nCol);
	if( nRow < 0 || nRow > GetRows() || nCol < 0 || nCol > GetCols() )
		return;	
	///Sophy 2/7/2012 ORG-4478-P6 CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	//int nx = XTwipsToPixels(X);
	//int ny = YTwipsToPixels(Y);
	//ClientToScreen(nx, ny);		
	///end CLEANUP_CONTEXT_MENU_SHOWN_ON_RBUTTONDOWN
	if( nRow >= GetRowOffset() && GetSelectedRow() >= 0 ) // right click in grid
	{
		if( !GetIsSelected(nRow) )
			SetIsSelected(nRow, true);
		
		DatasetListMenu myMenu(this);
		int nSelCmd;
		myMenu.TrackPopupMenu(0,  nx, ny, GetDlgSafeHwnd(), & nSelCmd);
		int nSelCol;
		if(myMenu.GetCommand(nSelCol))
		{
			switch(nSelCol)
			{
			case DATASET_LIST_MENU_DELETE:
				DelObjects();
				break;
			default:
				break;
			}
		}
		///Jasmine 12/29/10 ORG-1826-S1-3 COL_AUTO_WIDTH
		else if(MENU_AUTO_SIZE_COL_ID == nSelCmd)
		{
			autoResizeCols();
		}
		///End COL_AUTO_WIDTH
	}
	else // right click on col header
	{
		ColHeaderControlMenuBase myMenu(this);	
		///Jasmine 12/29/10 ORG-1826-S1-3 COL_AUTO_WIDTH
		//myMenu.TrackPopupMenu(0,  nx, ny, GetDlgSafeHwnd());
		int nSelCmdID;
		myMenu.TrackPopupMenu(0,  nx, ny, GetDlgSafeHwnd(), &nSelCmdID);
		int nSelCol;
		if(myMenu.GetCommand(nSelCol))
		{
			///-----Kit 02/24/2011 ORG-1837-S3 ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL
			/*
			/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
			if( nSelCol >= COL_PARAMS + GetCommonParametersLabelNumber(true) )
			{
				int offset = MAX_COMMON_SYS_PARAM_LABELS_NUM - GetCommonParametersLabelNumber(true);
				nSelCol += offset;
			}
			///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
			bool bHidden = IsColHidden(nSelCol);
			/// Iris 01/17/2011 ORG-1986-P1 SHOW_COMMON_UDLS
#ifdef SUPPORT_COMMON_UDLS
			int nColType = GetColType(nSelCol);
			if( bHidden && nColType >= COL_UDL_BEGIN && nColType <= COL_UDL_END )
			{
				/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
				//updateCommonUDLColumns( nColType );
				updateParametersLabelColumns( nColType, false );
				///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
			}
			/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
			else if( bHidden && nColType >= COL_PARAMS && nColType <= COL_PARAMS3 )
			{
				updateParametersLabelColumns( nColType, true );
			}
			///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON	
#endif //SUPPORT_COMMON_UDLS
			///End SHOW_COMMON_UDLS
			*/
			/// Kit Comment(02/24/2011): I find too many problem when I add one more column,
			/// so I refactor the menu GetCommend(), it will return 
			/// the current select column, now no need to convert the nSelCol.
			bool bHidden = IsColHidden(nSelCol);
			///-----Kit 05/24/2011 ORG-2958-P1 DROP_COL_FAILED
			//if( bHidden && COL_PARAMS <= nSelCol && nSelCol <= COL_PARAMS3 )
			int nColType = GetColType(nSelCol);
			if( bHidden && COL_PARAMS <= nColType && nColType <= COL_PARAMS3 )
			///-----End DROP_COL_FAILED
				updateParametersLabelColumns(nColType, true);
#ifdef	SUPPORT_COMMON_UDLS
			else if( bHidden && COL_UDL_BEGIN <= nColType && nColType <= COL_UDL_END )
				updateParametersLabelColumns(nColType, false);
#endif	//SUPPORT_COMMON_UDLS
			///-----End ADD_[BOOK]Sheet!Col_COLUMN_IN_LEFT_PANEL
			
			SetIsColHidden(nSelCol, !bHidden);
			///Jasmine 12/29/10 ORG-1826-S1-3 HIDE_SHOW_SAME_NAME_COL
			DWORD wParam = bHidden? 0 : HIDE_COL;
			PostDlgMessage(WM_USER_MSG_ON_HIDE_COL, wParam|HIDE_DATALIST_COL, nColType);
			///End HIDE_SHOW_SAME_NAME_COL
		}
		///Jasmine 12/29/10 ORG-1826-S1-3 COL_AUTO_WIDTH
		else if(nSelCmdID == MENU_AUTO_SIZE_COL_ID)
		{
			autoResizeCols();
		}
		///End COL_AUTO_WIDTH
	}
	
}

void DatasetList::autoResizeCols()
{
	///-----Kit 05/18/2011 ORG-2614-S2 DEFAULT_COL_WIDTH_SHOULD_FOLLOW_COL_CONTENTS
	//ResizeCols(0, 12);
	ResizeCols(0, 12, 50, 0, flexAutoSizeColWidth | flexAutoSizeNoFixed);
	///-----End DEFAULT_COL_WIDTH_SHOULD_FOLLOW_COL_CONTENTS
}

/// Iris 01/17/2011 ORG-1986-P1 SHOW_COMMON_UDLS
void DatasetList::setColValues(const vector<string>& vsColInfo, int nColPos)
{
	m_flx.SetTableValue(&vsColInfo, vsColInfo.GetSize(), 1, m_flx.FixedRows, nColPos, false);
}

#ifdef SUPPORT_COMMON_UDLS
/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
//void DatasetList::updateCommonUDLColumns(int nColType)
void DatasetList::updateParametersLabelColumns(int nColType, bool bIsBuildIn)
///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
{
	if( !IsAvailableColumn(nColType) )
		return;
	/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
	//getCommonUDLNames();
	getSpecialLabelCommonNames();
	///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
	
	int nPos = GetColPos(nColType);
	/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
	/*
	int nUDLIndex = nColType - COL_UDL_BEGIN;
	
	if( nUDLIndex < m_vsCommonUDLNames.GetSize() )
	{
		vector<string> vsColInfo;
		m_qr.GetColUDLByName(vsColInfo, m_vsCommonUDLNames[nUDLIndex]);					
		setColValues(vsColInfo, nPos);
		SetColHeading(nPos, m_vsCommonUDLNames[nUDLIndex]);	
	}
	*/
	int nIndex = bIsBuildIn ? nColType - COL_PARAMS : nColType - COL_UDL_BEGIN;
	vector<uint> vn;
	if( !bIsBuildIn && nIndex < m_vsCommonUDLNames.GetSize() ||
		bIsBuildIn && nIndex < m_vsCommonSystemParamLabelTypes.GetSize() )
	{
		vector<string> vsColInfo;
		if( bIsBuildIn )
		{
			int nParamIndex = m_vsCommonSystemParamLabelTypes[nIndex] - RCLT_PARAM;
			m_qr.GetColInfo(vsColInfo, QUERYRESULTCOL_PARAM, nParamIndex);
			SetColHeading(nPos, m_vsCommonSystemParamLabelNames[nIndex]);								
		}
		else
		{
			m_qr.GetColUDLByName(vsColInfo, m_vsCommonUDLNames[nIndex]);					
			SetColHeading(nPos, m_vsCommonUDLNames[nIndex]);								
		}
		setColValues(vsColInfo, nPos);
	}
	///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
	else // not this common UDL, will not show this column in grid.
	{
		if( !IsColHidden(nPos) )
			HideCol(nPos, true);					
	}	
}

/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
//bool DatasetList::getCommonUDLNames()
bool DatasetList::getSpecialLabelCommonNames()
///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
{
	if( m_bCheckCommonFinished )
		return true;
	else
		m_bCheckCommonFinished = true;
	
	vector<string> vsBookSheetNames;
	m_qr.GetNames(vsBookSheetNames, QUERYRESULTNAME_BOOKSHEET);
	if( vsBookSheetNames.GetSize() == 0 )
		return false;
	
	// remove the duplicate [book]sheet names
	vector<int> vnMapIndices;
	vector<uint> vuR1s;
	int nDupNum = vsBookSheetNames.FindDuplicates(vnMapIndices, vuR1s);
	
	vector<string> vsUniqueBookSheetNames;
	vector<uint> vuIndices;
	if( vnMapIndices.Find(MATREPL_TEST_EQUAL, -1, vuIndices) > 0 ) // find the no-duplicated worksheet names
		vsBookSheetNames.GetSubVector(vsUniqueBookSheetNames, vuIndices);
	
	if( nDupNum > 0 ) // get the unique worksheet names from dulicates
	{
		vector<string> vsTemp;
		vsBookSheetNames.GetSubVector(vsTemp, vuR1s);
		vsUniqueBookSheetNames.Append(vsTemp);
	}
	
	// to check common UDL from worksheet one by one
	WksCommonColLabelHelper clHelper;
	for(int nWks = 0; nWks < vsUniqueBookSheetNames.GetSize(); nWks++)
	{
		string strBookSheetName = vsUniqueBookSheetNames[nWks];
	
		Worksheet wks(strBookSheetName);
		ASSERT( wks );
		if( wks )
			clHelper.UpdateCommonColLabelInfo(wks);
	}
	
	vector<string> vsCommonLabelNames;	
	vector<int> vnLabelTypes;
	vsCommonLabelNames = clHelper.GetLabelNames();	
	vnLabelTypes = clHelper.GetLabelTypes();
	/// Iris 4/12/2011 ORG-1986-P2 FIX_NO_COMMON_LABEL_CASE_CAUSE_RUNTIME_ERROR
	ASSERT(vsCommonLabelNames.GetSize() == vnLabelTypes.GetSize());
	if( 0 == vnLabelTypes.GetSize() )
	{
		m_vsCommonUDLNames.SetSize(0);
		m_vsCommonSystemParamLabelNames.SetSize(0);
		m_vsCommonSystemParamLabelTypes.SetSize(0);
		return false;
	}
	///End FIX_NO_COMMON_LABEL_CASE_CAUSE_RUNTIME_ERROR
	
	///-----Kit 04/28/2011 CLEAN_UP_CODE
// 	if( vnLabelTypes.Find(MATREPL_TEST_GREATER | MATREPL_TEST_EQUAL, RCLT_UDL, vuIndices) == 0 ) // only get UDL 
// 	{
// 		/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
// 		//return false; // not found common UDL
// 		///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
// 	}
// 	else
// 	{
// 		vsCommonLabelNames.GetSubVector(m_vsCommonUDLNames, vuIndices);
// 	}
	if( vnLabelTypes.Find(MATREPL_TEST_GREATER | MATREPL_TEST_EQUAL, RCLT_UDL, vuIndices) > 0 ) // only get UDL 
	{
		vsCommonLabelNames.GetSubVector(m_vsCommonUDLNames, vuIndices);
	}
	///-----End CLEAN_UP_CODE
	
	
	if( m_vsCommonUDLNames.GetSize() > MAX_COMMON_UDLS_NUM )
	{
		m_vsCommonUDLNames.SetSize(MAX_COMMON_UDLS_NUM);
	}
	
	/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
	for(int index = 0; index < PARAMS_MAX_NUM && m_vsCommonSystemParamLabelNames.GetSize() <= MAX_COMMON_SYS_PARAM_LABELS_NUM; index++)
	{
		///-----Kit 04/28/2011 CLEAN_UP_CODE
		//if( vnLabelTypes.Find(MATREPL_TEST_EQUAL, RCLT_PARAM+index, vuIndices) != 0 ) // only get system parameter labels
		ASSERT(vnLabelTypes.GetSize() == vsCommonLabelNames.GetSize());
		if( vnLabelTypes.Find(MATREPL_TEST_EQUAL, RCLT_PARAM+index, vuIndices) > 0 ) // only get system parameter labels 
		///-----End CLEAN_UP_CODE
		{
			m_vsCommonSystemParamLabelNames.Add( vsCommonLabelNames[vuIndices[0]] );
			m_vsCommonSystemParamLabelTypes.Add( vnLabelTypes[vuIndices[0]] );
		}
	}
	///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
	return true;
}

/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
//string	DatasetList::GetCommonUDLName(int index)
string	DatasetList::GetCommonParametersLabelName(int index, bool bIsBuildIn)
///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
{
	string strName;
	if( EXIST_WKS != m_pDatasetListHelper->GetType() )
		return strName;
	
	/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
	//getCommonUDLNames();
	getSpecialLabelCommonNames();
	///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
	
	if( bIsBuildIn )
	{
		if( index < m_vsCommonSystemParamLabelNames.GetSize() )
			strName = m_vsCommonSystemParamLabelNames[index];		
	}
	else
	{
	///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
		if( index < m_vsCommonUDLNames.GetSize() )
			strName = m_vsCommonUDLNames[index];
	} /// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
	
	return strName;
}
/// Iris 2/11/2011 ORG-1986-S1 SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
int DatasetList::GetCommonParametersLabelNumber(bool bIsBuildIn)
{
	if( bIsBuildIn )
		return m_vsCommonSystemParamLabelNames.GetSize();
	else
		return m_vsCommonUDLNames.GetSize();
}
///End SYSTEM_PARAM_LABEL_ALSO_NEED_CHECK_COMMON
#endif //SUPPORT_COMMON_UDLS
///End SHOW_COMMON_UDLS

FolderType DatasetList::GetFolderType( AvailDataComboType availDataType )
{
	if( WKS_FOLDER == availDataType || MAT_FOLDER == availDataType)
		return FLD_TYPE_CURRENT_FLD;	
	else if( WKS_FAVS == availDataType || MAT_FAVS == availDataType )
		return FLD_TYPE_FAVS_FLD;
	else if( WKS_PROJECT == availDataType || MAT_PROJECT == availDataType 
		|| VIRTUAL_MAT == availDataType || LOOSE_DS == availDataType || FUNC_PLOT == availDataType
	/// Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	#ifdef NEW_NAMED_RANGE_FEATURE
		|| NAMED_RANGE_WKS == availDataType
	#endif // NEW_NAMED_RANGE_FEATURE
	/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		)
		return FLD_TYPE_PROJECT;

	return -1; // Customer filter may come here
}

int DatasetList::getPageTypeByFilterObjectType(QUERYRESULTBUILD nQueryObjectType)
{
	switch(nQueryObjectType)
	{
	case QUERYRESULTBUILD_COLUMN:
		return EXIST_WKS;
		
	case QUERYRESULTBUILD_MATRIXOBJECT:
		return EXIST_MATRIX;
		
	case QUERYRESULTBUILD_DATASET:
	case QUERYRESULTBUILD_LOOSEDATASET:
	case QUERYRESULTBUILD_VIRTUALMATRIX:
		return EXIST_DATA;
		
	case QUERYRESULTBUILD_FUNCTIONPLOT:
		return EXIST_FUNC_PLOT;
	/// Kenny 08/23/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
#ifdef NEW_NAMED_RANGE_FEATURE
	case QUERYRESULTBUILD_NAMEDRANGE:
		return EXIST_NAMED_RANGE;
#endif // NEW_NAMED_RANGE_FEATURE
	/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		
	default:
		break;
	}
	ASSERT(false);
	return EXIST_NONE;
}

/// Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
//int DatasetList::convertToPageType( AvailDataComboType availDataType, QUERYRESULTBUILD nQueryObjectType, bool* pbIsVitualMatrix )
int DatasetList::convertToPageType( AvailDataComboType availDataType, QUERYRESULTBUILD nQueryObjectType)
/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
{
	switch( availDataType )
	{
		case WKS_FOLDER:
		case WKS_FAVS:
		case WKS_PROJECT:
			return EXIST_WKS;			
			
		case MAT_FOLDER:
		case MAT_FAVS:
		case MAT_PROJECT:
			return EXIST_MATRIX;
			
		case LOOSE_DS:
		case VIRTUAL_MAT:
		/// Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		// I don't understand why do we need this anyway since availDataType has already tell us what it is after all.
			//if( NULL != pbIsVitualMatrix )
			//{				
				//*pbIsVitualMatrix = (VIRTUAL_MAT == availDataType);
			//}
		/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
			return EXIST_DATA;
		
		/// Kenny 08/23/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		#ifdef NEW_NAMED_RANGE_FEATURE
		case NAMED_RANGE_WKS:
			return EXIST_NAMED_RANGE;
		#endif // NEW_NAMED_RANGE_FEATURE
		/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
			
		case FUNC_PLOT:
			return EXIST_FUNC_PLOT;			
			
		default:				
			///Jasmine 01/21/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
			if(m_availDataTypeWksInGLayer != -1 && m_availDataTypeWksInGLayer == availDataType)
				return EXIST_WKS;
		
			/// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
			if(m_availDataTypeWkbookInGLayer != -1 && m_availDataTypeWkbookInGLayer == availDataType)
				return EXIST_WKS;
			///End ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
		
			if(m_availDataTypeMatInGLayer != -1 && m_availDataTypeMatInGLayer == availDataType)
				return EXIST_MATRIX;
			///End FILTER_GRAPH_SOURCE_DATA
			
			/// Iris 1/27/2011 ORG-2046-S5 NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
			// here availDataType is not real data type, it is the selection in combo.
			//ASSERT( availDataType >= CUSTOM_FILTER_BEGIN );
			///End NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
			ASSERT( nQueryObjectType >= 0 );
			return getPageTypeByFilterObjectType(nQueryObjectType);	
	}
	ASSERT(false);
	return EXIST_NONE;
}

bool DatasetList::IsAvailableColumn(int nColType)
{
	if( nColType < 0 || nColType >= COL_LAST_ITEM )
	{
		ASSERT(false);
		return false;
	}
	
	vector<bool> vb(COL_LAST_ITEM);
	vb = true;
	///-----Kit 03/01/2011 ORG-2331-P1 ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT
// 	int nPageType = m_pDatasetListHelper->GetType();
// 	if( EXIST_WKS == nPageType )
// 	{
// 		// do nothing
// 	}
// 	else if( EXIST_MATRIX == nPageType )
// 	{
// #ifdef SUPPORT_COMMON_UDLS
// 		vb[COL_UDL] = 		
// 		vb[COL_UDL2] =
// 		vb[COL_UDL3] =
// #endif //SUPPORT_COMMON_UDLS
// 		vb[COL_UNITS] = 
// 		vb[COL_COMMENTS] = 
// 		vb[COL_PARAMS] =
// 		/// Iris 1/12/2011 SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
// 		vb[COL_PARAMS2] =
// 		vb[COL_PARAMS3] = false;		
// 		///End SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
// 	}
// 	else // loose dataset
// 	{
// #ifdef SUPPORT_COMMON_UDLS
// 		vb[COL_UDL] = 
// 		vb[COL_UDL2] =
// 		vb[COL_UDL3] =
// #endif //SUPPORT_COMMON_UDLS
// 		vb[COL_FOLDER] = 
// 		vb[COL_BOOK_SN] = 
// 		vb[COL_SHEET] = 
// 		vb[COL_UNITS] = 
// 		vb[COL_COMMENTS] = 
// 		vb[COL_PARAMS] =
// 		/// Iris 1/12/2011 SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
// 		vb[COL_PARAMS2] =
// 		vb[COL_PARAMS3] =
// 		///End SUPPORT_MORE_PARAMTERS_AND_UDLS_LABEL
// 		vb[COL_INDEX] = false;
// 	}
	m_pDatasetListHelper->GetAvailableCols(vb);
	///-----End ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT
	
	return vb[nColType];
}

bool	DatasetList::IsLastShownCol(int nCol)
{
	vector<int> vnShows;
	GetColsShow(vnShows);
	
	if( 1 == vnShows.GetSize() && nCol == vnShows[0] )
		return true;	
	return false;
}

void DatasetList::InitColsShowHidden()
{
	///-----Kit 03/01/2011 ORG-2331-P1 ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT
	//InitColsShowHiddenFromReg(getRegSectionName("ColHidden"), &s_vnDatasetListColsDefaultHidden);
	vector<bool> vbHiddenCols(COL_LAST_ITEM);
	m_pDatasetListHelper->GetHiddenCols(vbHiddenCols);
	InitColsShowHiddenFromReg(getRegSectionName("ColHidden"), &vbHiddenCols);
	///-----End ONLY_SHOW_DS_NAME_WHEN_FUNC_PLOT_AND_LOOSE_DATASET_PLOT

	///Jasmine 01/05/11 ORG-1826-S8 MOVE_COLUMN_ORDER
	for(int nColType = COL_FIRST_ONE; nColType < COL_LAST_ITEM; nColType++)
	{
		if( !vbHiddenCols[nColType] && !IsAvailableColumn(nColType) )
		{
			SetIsColHidden(GetColPos(nColType), true);
		}
	}
	///End MOVE_COLUMN_ORDER
}

///Jasmine 09/25/2012 ORG-6105-P2 GROUPING_NOT_AVAILABLE_FOR_XYZ_PLOT
bool is_xyz_plot(const TreeNode& trPlot)
{
	 TreeNode trPlotDesigsStr = tree_get_node_by_tagname(trPlot, "PlotDesigsStr", true);
	 if(trPlotDesigsStr && (trPlotDesigsStr.strVal.CompareNoCase("XYZ") == 0 || trPlotDesigsStr.strVal.CompareNoCase("Z") == 0))
	 	return true;
	 
	 return false;
}
///End GROUPING_NOT_AVAILABLE_FOR_XYZ_PLOT

bool DatasetList::GetDataPlotsTree( int nPlotID, DWORD dwLayerBits, TreeNode &trPlots )
{
	m_pDatasetListHelper->SetPlotID( nPlotID );
	
	// arrDPTAttr will manger the memory
	Array<MakeDataPlotTreeAttribute&> arrDPTAttr(true);
	/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
	//m_pDatasetListHelper->GetDataPlotTreeAttribute( arrDPTAttr );
	///-----Kit 04/29/2011 ORG-2706-P1 LC_SHOULD_SUPPORT_XYAM_PLOT
	//m_pDatasetListHelper->GetDataPlotTreeAttribute( arrDPTAttr, dwLayerBits );
	if( !m_pDatasetListHelper->GetDataPlotTreeAttribute( arrDPTAttr, dwLayerBits ) )
	{
		m_errLast = m_pDatasetListHelper->GetLastError();
		return false;
	}
	///End SUPPORT_TERNARY_PLOT
	
	bool bAllowGroup = EXIST_MATRIX != m_pDatasetListHelper->GetType() && !m_pDatasetListHelper->IsVirtualMatrix();///Jasmine 06/29/2012 ORG-6105-P1 GROUPING_NOT_AVAILABLE_FOR_MATRIX
	int nArrSize = arrDPTAttr.GetSize();
	for( int ii=0; ii<nArrSize; ++ii )
	{
		MakeDataPlotTreeAttribute &DPTAttr = arrDPTAttr.GetAt(ii);
		Tree tr;
		if( makePlotTree( DPTAttr, dwLayerBits, tr ) )
		{
			/// Iris 01/05/2011 ORG-1682-P1 FIX_NOT_GROUPED_DATAPLOTS_WHEN_DATA_FROM_DIFF_SHEET
			//trPlots.AddNode( tr );
			if( nArrSize > 1 )
			{		
				///Jasmine 09/25/2012 ORG-6105-P2 GROUPING_NOT_AVAILABLE_FOR_XYZ_PLOT
				if(bAllowGroup)
					bAllowGroup = !is_xyz_plot(tr);
				///End GROUPING_NOT_AVAILABLE_FOR_XYZ_PLOT
				///Jasmine 06/29/2012 ORG-6105-P1 GROUPING_NOT_AVAILABLE_FOR_MATRIX
				if( !bAllowGroup)
				{
					foreach(TreeNode trDP in tr.Layer.Children)
					{
						if( check_tree_node_tagName_is_DataPlot(trDP) )
							 trPlots.Layer.AddNode(trDP);
					}		
				}
				else
				///End GROUPING_NOT_AVAILABLE_FOR_MATRIX
				{				
				TreeNode trGroup = trPlots.Layer.Group;
				if( !trGroup.IsValid() )
				{
					trPlots.Layer.Group.nVal = 0; // to add Layer.Group nodes
					trGroup = trPlots.Layer.Group;
				}
				
				TreeNode trParent = tr.Layer.Group.IsValid() ? tr.Layer.Group : tr.Layer;
				foreach(TreeNode trDP in trParent.Children)
				{
					if( check_tree_node_tagName_is_DataPlot(trDP) )
						trGroup.AddNode(trDP);
				}		
			}
			}
			else
			{
				trPlots = tr;
			}	
			///End FIX_NOT_GROUPED_DATAPLOTS_WHEN_DATA_FROM_DIFF_SHEET
		}
		
	}
	return true;	
}

///Jasmine 01/05/11 ORG-1826-S8 MOVE_COLUMN_ORDER
string DatasetList::getRegSectionName(LPCSTR lpczSetion)
{
	string strSuffix(lpczSetion);
	string strSection;
	switch(m_pDatasetListHelper->GetType())
	{
	case EXIST_WKS:
		strSection = "Wks";
		break;
	case EXIST_MATRIX:
		strSection = "Mat";
		break;
	case EXIST_DATA:
		strSection = "LooseDataset";
		break;	
	case EXIST_PLOT:
		strSection = "FuncPlot";
		break;
	/// Kenny ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
#ifdef NEW_NAMED_RANGE_FEATURE
	case EXIST_NAMED_RANGE:
		strSection = "NamedRange";
		break;
#endif // NEW_NAMED_RANGE_FEATURE
	/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	default:
		return ""; // return empty section name for invalid dataset type, means no need to save col show/hidden status to register.
	}
	strSection += strSuffix;
	return strSection;
}

/// Kenny 08/19/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
//void DatasetList::setListHeading(LPCTSTR lpcstrHeading)
//{
	//vector<string> vstrListHeading;
	//string strHeadingTemp = lpcstrHeading;
	//strHeadingTemp.GetTokens( vstrListHeading, '|' );
void DatasetList::setListHeading()
{
	vector<string> vstrListHeading(COL_LAST_ITEM-COL_FIRST_ONE);
	const DatasetListColInfoArray& arrColInfos = GetDatasetListColInfo();
	for(int jj = 0; jj < vstrListHeading.GetSize(); ++jj)
	{
		vstrListHeading[jj] = arrColInfos.GetAt(jj).strColName;
	}
/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	///Jasmine 01/07/11 ORG-1826-S8 SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
	if(m_colMap->m_vnColMap.GetSize() > 0)
		vstrListHeading.Reorder(m_colMap->m_vnColMap);///Jasmine 01/05/11 ORG-1826-S8 MOVE_COLUMN_ORDER
	///End SHARE_COL_MOVING_CODE_IN_BOTH_PANELS
	int nHeaders = vstrListHeading.GetSize();
	SetCols( nHeaders );
	ASSERT( GetCols() == nHeaders );

	for( int ii=0; ii<nHeaders; ++ii )
	{
		SetColHeading( ii, vstrListHeading[ii] );		
	}	
}

bool DatasetList::makePlotTree( const MakeDataPlotTreeAttribute &DPTAttr, DWORD dwLayerBits,TreeNode &tr, DWORD dwCntrl /*= DPEDTVIEW_HIDE_STYLEHOLDERS */ )
{
	PlotInfo plotInfo;
	/// Iris 11/29/2010 ORG-864-P1 FIX_PLOT_3D_XYZ_DATA_WITH_INCORRECT_PLOT_TYPE
	/*
	plotInfo.nPlotType = get_plot_type_info( GetDefaultPlotType(), GetType(), dwLayerBits, plotInfo.dwAuxTypeInfo, 
						plotInfo.dwLTPlotInfo, plotInfo.strColPattern);
	*/

// 	bool bVirtualMatrix = (GetType() == EXIST_DATA) && okutil_is_virtual_matrix(DPTAttr.vsDSName[0]);
// 	
// 	///-----Kit 12/23/2010 ORG-1826-S5 FOLLOW_TEMPLATE_WHEN_ADDING_DATA_TO_RIGHT_PANEL
// 	int nNewPlotID;
// 	if( !getNewPlotID( nStyleHolderPlotID, dwLayerBits, bVirtualMatrix, nNewPlotID ) )
// 		return false;	
	plotInfo.nPlotType = get_plot_type_info( m_pDatasetListHelper->GetPlotID(), GetType(), dwLayerBits, plotInfo.dwAuxTypeInfo, 
						plotInfo.dwLTPlotInfo, plotInfo.strColPattern);
	///-----End FOLLOW_TEMPLATE_WHEN_ADDING_DATA_TO_RIGHT_PANEL
	///End FIX_PLOT_3D_XYZ_DATA_WITH_INCORRECT_PLOT_TYPE
	
	//vsPagesName, vsLayersName always has one elem
	plotInfo.strPageName = DPTAttr.strBook;
	plotInfo.strLayerName = DPTAttr.strSheet;
	plotInfo.vuColDesignations = DPTAttr.vuDesig;
	plotInfo.vsColNames = DPTAttr.vsDSName;	
	plotInfo.arrRangeRows[0] = -1;
	plotInfo.arrRangeRows[1] = -1;
	plotInfo.bShow = true; /// Iris 01/10/2011 FIX_CHANGE_PLOTTYPE_NOT_KEEP_SHOWINFO

	return make_plot_tree( tr, plotInfo, dwCntrl );
}


string DatasetList::GetSelRowDataSheetName( int nSelRow )
{	
	///Jasmine 01/05/11 ORG-1826-S8 MOVE_COLUMN_ORDER
	string strPage = GetCell( flexcpText, nSelRow, GetColPos(COL_BOOK_SN) );
	string strLayer = GetCell( flexcpText, nSelRow, GetColPos(COL_SHEET) );
	///End MOVE_COLUMN_ORDER

	return make_book_sheet_name( strPage, strLayer );
}

bool DatasetList::GetSelColTypes( vector<int> &vnColType )
{
	return m_pDatasetListHelper->GetSelColTypes( vnColType );
}

/************************************************************************/
/* ---AvailDataCombo                                                    */
/************************************************************************/
/// Iris 1/27/2011 ORG-2046-S5 NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
//static int _get_avail_data_type_from_combo_selection(int nCurSel, int nWksInGLayerItem, int nMatInGLayerItem, int* pnFilterFuncIndex = NULL)
static int _get_avail_data_type_from_combo_selection(int nCurSel, int nWksInGLayerItem, int nWkbookInGLayerItem, int nMatInGLayerItem, int* pnFilterFuncIndex = NULL)
///End NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
{
	if( nCurSel > FUNC_PLOT )
	{
		int offset = 0;
		if( nWksInGLayerItem != -1 )
		{
			if( nCurSel == RELATED_WKS )
				return RELATED_WKS;
		}
		else
			offset--;
		
		/// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
		if( nWkbookInGLayerItem != -1 )
		{
			if( nCurSel == RELATED_WKBOOK )
				return RELATED_WKBOOK;
		}
		else
			offset--;
		///End ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
		
		if( nMatInGLayerItem != -1 )
		{
			if( nCurSel - offset == RELATED_MAT )
				return RELATED_MAT;	
		}
		else
			offset--;
			
		if( nCurSel - offset >= CUSTOM_FILTER_BEGIN )
		{
			int nFilterFuncIndex = nCurSel - offset - CUSTOM_FILTER_BEGIN + 1;
			if( pnFilterFuncIndex != NULL )
				*pnFilterFuncIndex = nFilterFuncIndex;
			return CUSTOM_FILTER_BEGIN;
		}		
	}
	return nCurSel;	
}

int AvailDataCombo::unfixedAvailTypeRegStrToNum(LPCSTR lpcszType)
{
	int nType = WKS_FOLDER;
	string strType(lpcszType);	

	if( 0 == strType.CompareNoCase(STR_AVAILDATA_TYPE_RELATED_WKS) )
		nType = RELATED_WKS;
	/// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	else if( 0 == strType.CompareNoCase(STR_AVAILDATA_TYPE_RELATED_WKBOOK) )
		nType = RELATED_WKBOOK;
	///End ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	else if( 0 == strType.CompareNoCase(STR_AVAILDATA_TYPE_RELATED_MAT) )
		nType = RELATED_MAT;
	else 
	{
		char szBuffer[MAXLINE];
		int nFilterFuncIndex = string_to_prefix_end_number(szBuffer, strType); 
		if( 0 == lstrcmpi( szBuffer, STR_AVAILDATA_TYPE_CUSTOM_FUNC ) )
		{
			nType = CUSTOM_FILTER_BEGIN + nFilterFuncIndex - 1;
		}
	}
	return nType;
}

string AvailDataCombo::unfixedAvailTypeNumToRegStr(int nCurSel)
{
	if( nCurSel > FUNC_PLOT )
	{
		int nFilterFuncIndex;
		/// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
		//int nAvailDataType = _get_avail_data_type_from_combo_selection(nCurSel, m_availDataTypeWksInGLayer, m_availDataTypeMatInGLayer, &nFilterFuncIndex);
		int nAvailDataType = _get_avail_data_type_from_combo_selection(nCurSel, m_availDataTypeWksInGLayer, m_availDataTypeWkbookInGLayer, m_availDataTypeMatInGLayer, &nFilterFuncIndex);
		///End ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
		switch(nAvailDataType)
		{
		case RELATED_WKS:
			return STR_AVAILDATA_TYPE_RELATED_WKS;
		/// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
		case RELATED_WKBOOK:
			return STR_AVAILDATA_TYPE_RELATED_WKBOOK;
		///End ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
		case RELATED_MAT:
			return STR_AVAILDATA_TYPE_RELATED_MAT;
		case CUSTOM_FILTER_BEGIN:
			return (STR_AVAILDATA_TYPE_CUSTOM_FUNC + nFilterFuncIndex );
		}		
	}
	ASSERT(false);
	return "";
}

int AvailDataCombo::getCurSelFromAvailDataType(int nAvailDataType)
{
	int nOffset;
	int nCurSel = nAvailDataType;
	if( nAvailDataType > FUNC_PLOT )
	{	
		if( nAvailDataType == RELATED_WKS )
		{
			nCurSel = (m_availDataTypeWksInGLayer != -1) ? m_availDataTypeWksInGLayer : WKS_FOLDER;
		}
		nOffset += (m_availDataTypeWksInGLayer == -1) ? 1 : 0;
		
		/// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
		if( nAvailDataType == RELATED_WKBOOK )
		{
			nCurSel = (m_availDataTypeWkbookInGLayer != -1) ? m_availDataTypeWkbookInGLayer : WKS_FOLDER;
		}
		nOffset += (m_availDataTypeWkbookInGLayer == -1) ? 1 : 0;
		///End ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
		
		if( nAvailDataType == RELATED_MAT )
		{
			nCurSel = (m_availDataTypeMatInGLayer != -1) ? m_availDataTypeMatInGLayer : MAT_FOLDER;
		}
		nOffset += (m_availDataTypeMatInGLayer == -1) ? 1 : 0;
		
		if( nAvailDataType >= CUSTOM_FILTER_BEGIN )
			nCurSel = nAvailDataType - nOffset;
	}
	return nCurSel;
}
///End NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG

/// Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
//AvailDataCombo::AvailDataCombo(  const ComboBox &combo, const DatasetList *pDatasetList, LPCTSTR lpcstrComboName ) : ComboBox()
AvailDataCombo::AvailDataCombo(  const ComboBox &combo, const DatasetList *pDatasetList)
	: ComboBox()
/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
{
	m_pDatasetList = pDatasetList;
	*this = combo;
	
	/// Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	//SetComboAvailData( lpcstrComboName );
	SetComboAvailData();
	/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	
	DWORD dwCurSel;
	/// Iris 1/27/2011 ORG-2046-S5 NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	//dlg_load_registry(STR_DLG_NAME, "AvailComboSel", dwCurSel, WKS_FOLDER);	
	string strVal;
	string strDefault = WKS_FOLDER;
	dlg_load_registry(STR_DLG_NAME, STR_AVAIL_DATA_TYPE_REG, strVal, strDefault);
	
	if( is_numeric(strVal) )
	{
		dwCurSel = atoi(strVal);
	}
	else
	{
		int nAvailDataType = unfixedAvailTypeRegStrToNum(strVal);
		dwCurSel = getCurSelFromAvailDataType(nAvailDataType);
	}	
	///End NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	
	///Jasmine 01/21/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
	if( dwCurSel >= GetCount() )
		dwCurSel = WKS_FOLDER;
	///End FILTER_GRAPH_SOURCE_DATA
	checkSetSelectionByPlot(dwCurSel);	
	SetCurSel( dwCurSel );
	m_pDatasetList->UpdateDatasetList( dwCurSel );
}

AvailDataCombo::~AvailDataCombo()
{	
	/// Iris 1/27/2011 ORG-2046-S5 NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	//dlg_save_to_registry(STR_DLG_NAME, "AvailComboSel", GetCurSel());
	int nCurSel = GetCurSel();	
	if( nCurSel < RELATED_WKS )
		dlg_save_to_registry(STR_DLG_NAME, STR_AVAIL_DATA_TYPE_REG, nCurSel);
	else
	{
		dlg_save_to_registry(STR_DLG_NAME, STR_AVAIL_DATA_TYPE_REG, unfixedAvailTypeNumToRegStr(nCurSel));		
	}
	///End NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
}

///Jasmine 01/20/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
bool _source_data_has_col_or_mat(const GraphLayer& gl, DWORD dwType)
{
	bool bRet = false;
	foreach(DataPlot dp in gl.DataPlots)
	{
		DWORD dwInfo = Project.GetDatasetInfo( dp.GetDatasetName() );
		if(dwInfo & dwType)
		{
			bRet = true;
			break;
		}
	}
	
	return bRet;
}
///End FILTER_GRAPH_SOURCE_DATA
/// Kenny 08/17/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
//bool AvailDataCombo::SetComboAvailData( LPCTSTR lpcstrComboName ) 
//{
	//vector<string> vstrComboName;
	//string strComboNameTemp = lpcstrComboName;
	//strComboNameTemp.GetTokens( vstrComboName, '|' );	
bool AvailDataCombo::SetComboAvailData() 
{
	vector<string> vstrComboName;
	vstrComboName.Add(_L("Worksheets in Folder"));
	vstrComboName.Add(_L("Worksheets in Project"));
	vstrComboName.Add(_L("Worksheets in Favorites"));
	vstrComboName.Add(_L("Matrices in Folder"));
	vstrComboName.Add(_L("Matrices in Project"));
	vstrComboName.Add(_L("Matrices in Favorites"));
	vstrComboName.Add(_L("Virtual Matrices"));
#ifdef NEW_NAMED_RANGE_FEATURE
	vstrComboName.Add(_L("Named Ranges for Vectors"));
#endif // NEW_NAMED_RANGE_FEATURE
	vstrComboName.Add(_L("Loose Datasets"));
	vstrComboName.Add(_L("Function Plots"));
/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
	
	///Jasmine 01/20/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
	//vector<string> vsKeys;
	//if( _get_dataset_filter_names(vsKeys) > 0 )
		//vstrComboName.Append(vsKeys);
	///End FILTER_GRAPH_SOURCE_DATA
		
	int nComboNums = vstrComboName.GetSize();
	for ( int ii=0; ii<nComboNums; ++ii )
		AddString( vstrComboName[ii] );
	
	///Jasmine 01/20/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
	/// Iris 1/27/2011 ORG-2046-S5 NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	//int nWksInGLayerItem = -1, nMatInGLayerItem = -1;
	m_availDataTypeWksInGLayer = -1;
	m_availDataTypeWkbookInGLayer = -1; /// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	m_availDataTypeMatInGLayer = -1;
	///End NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	GraphLayer gl = Project.ActiveLayer();
	if( _source_data_has_col_or_mat(gl, PGDN_IN_WKS) )
	{
		/// Iris 1/27/2011 ORG-2046-S5 NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
		//nWksInGLayerItem = AddString(STR_AVAIL_DATA_WKS_IN_GLAYER);
		m_availDataTypeWksInGLayer = AddString(STR_AVAIL_DATA_WKS_IN_GLAYER);
		///End NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
		m_availDataTypeWkbookInGLayer = AddString(STR_AVAIL_DATA_WKBOOK_IN_GLAYER); /// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	}
	if( _source_data_has_col_or_mat(gl, PGDN_IN_MATRIX) )
	{
		/// Iris 1/27/2011 ORG-2046-S5 NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
		//nMatInGLayerItem = AddString(STR_AVAIL_DATA_MAT_IN_GLAYER);
		m_availDataTypeMatInGLayer = AddString(STR_AVAIL_DATA_MAT_IN_GLAYER);
		///End NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	}
	/// Iris 1/27/2011 ORG-2046-S5 NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	//m_pDatasetList->InitDynamicAvailDataType(nWksInGLayerItem, nMatInGLayerItem);
	/// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	//m_pDatasetList->InitDynamicAvailDataType(m_availDataTypeWksInGLayer, m_availDataTypeMatInGLayer);
	m_pDatasetList->InitDynamicAvailDataType(m_availDataTypeWksInGLayer, m_availDataTypeWkbookInGLayer, m_availDataTypeMatInGLayer);
	///End ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	///End NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	
	//filter by OC function
	vector<string> vsKeys;
	int nFilters = _get_dataset_filter_names(vsKeys);
	for ( ii=0; ii<nFilters; ++ii )
		AddString( vsKeys[ii] );
	///End FILTER_GRAPH_SOURCE_DATA
	
	return true;
}

///Jasminie 02/14/11 ORG-2100-P8 SHOW_SOURCE_DATA_FOR_TEMP_PLOT
void AvailDataCombo::OnComboSelChange( int nAvailDataComboType, const vector<string>& vsBookSheets/*= NULL*/ )
{
	m_pDatasetList->ClearAll();
	m_pDatasetList->UpdateDatasetList( nAvailDataComboType, vsBookSheets );
}
///End SHOW_SOURCE_DATA_FOR_TEMP_PLOT
void AvailDataCombo::checkSetSelectionByPlot(DWORD& dwCurSel)
{
	///Jasmine 01/21/11 ORG-2046-S3 FILTER_GRAPH_SOURCE_DATA
	//if( dwCurSel == CUSTOM_FILTER_BEGIN )
	int nFilterFuncIndex;
	if( m_pDatasetList->IsFilterByFunction(dwCurSel, nFilterFuncIndex) )
		return;
	///End FILTER_GRAPH_SOURCE_DATA
	GraphLayer gl = Project.ActiveLayer();
	/// Iris 1/27/2011 ORG-2046-S5 NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
	/*
	DataPlot dp = gl.DataPlots(0);
	if( !dp )
		return;
	
	string strDatasetName = dp.GetDatasetName();	
///Jasmine 01/12/11 ORG-1997-S2 SHOW_CURRENT_PLOT_TYPE	
	GetDataIndexByDatasetName(dwCurSel, strDatasetName);
	*/
	DWORD dwNewSel;
	foreach(DataPlot dp in gl.DataPlots)
	{
		dwNewSel = dwCurSel;
		string strDatasetName = dp.GetDatasetName();	
		GetDataIndexByDatasetName(dwNewSel, strDatasetName);
		if( dwCurSel == dwNewSel )
			return;
	}
	dwCurSel = dwNewSel; // not the suited type	
	///End NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
}

void AvailDataCombo::GetDataIndexByDatasetName(DWORD& dwCurSel, LPCSTR strDatasetName)
{
///End SHOW_CURRENT_PLOT_TYPE
	DWORD dwInfo = Project.GetDatasetInfo(strDatasetName, true);
	if( dwInfo & PGDN_FUNCTION )
	{
		dwCurSel = FUNC_PLOT;
		return;
	}
	
	///------ Folger 12/07/2011 ORG-3537 MORE_ON_NAMED_RANGE_SUPPORT_IN_LAYER_CONTENT_AND_PLOT_SETUP
	//if( dwInfo & PGDN_LOOSE )
	//{
		//if( okutil_is_virtual_matrix(strDatasetName) )
		//{
			//dwCurSel = VIRTUAL_MAT;
		//}
		//else
		//{
			//dwCurSel = LOOSE_DS;
		//}
		//return;
	//}
	if ( O_QUERY_BOOL(dwInfo, PGDN_VIRTUAL_MATRIX) )
	{
		dwCurSel = VIRTUAL_MAT;
		return;
	}

	#ifdef		NEW_NAMED_RANGE_FEATURE
	if ( O_QUERY_BOOL(dwInfo, PGDN_NAMED_RANGE) )
	{
		dwCurSel = NAMED_RANGE_WKS;
		return;
	}
	#endif		/// NEW_NAMED_RANGE_FEATURE

	if ( O_QUERY_BOOL(dwInfo, PGDN_LOOSE) )
	{
		dwCurSel = LOOSE_DS;
		return;
	}
	///------ End MORE_ON_NAMED_RANGE_SUPPORT_IN_LAYER_CONTENT_AND_PLOT_SETUP
	
	int nRealAvailDataType = _get_avail_data_type_from_combo_selection(dwCurSel, m_availDataTypeWksInGLayer, m_availDataTypeWkbookInGLayer, m_availDataTypeMatInGLayer); /// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
	if( dwInfo & PGDN_IN_WKS )
	{
		/// Iris 1/27/2011 ORG-2046-S5 NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
		//if( WKS_FOLDER == dwCurSel || WKS_PROJECT == dwCurSel || WKS_FAVS == dwCurSel )
		/// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
		//if( WKS_FOLDER == dwCurSel || WKS_PROJECT == dwCurSel || WKS_FAVS == dwCurSel || RELATED_WKS == _get_avail_data_type_from_combo_selection(dwCurSel, m_availDataTypeWksInGLayer, m_availDataTypeMatInGLayer) )		
		if( WKS_FOLDER == dwCurSel || WKS_PROJECT == dwCurSel || WKS_FAVS == dwCurSel || RELATED_WKS == nRealAvailDataType || RELATED_WKBOOK == nRealAvailDataType )
		///End ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
		///End NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
			return; // no need update folder type in combo
		
		if( dwInfo & PGDN_FOLDER || dwInfo & PGDN_FOLDER_SUB )
		{
			dwCurSel = WKS_FOLDER; // worksheet in current folder
		}
		else
		{
			dwCurSel = WKS_PROJECT;
		}
	}
	else if( dwInfo & PGDN_IN_MATRIX )
	{
		/// Iris 1/27/2011 ORG-2046-S5 NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
		//if(MAT_FOLDER == dwCurSel || MAT_PROJECT == dwCurSel || MAT_FAVS == dwCurSel )
		/// Iris 2/14/2011 ORG-2046-S6 ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
		//if(MAT_FOLDER == dwCurSel || MAT_PROJECT == dwCurSel || MAT_FAVS == dwCurSel || RELATED_MAT == _get_avail_data_type_from_combo_selection(dwCurSel, m_availDataTypeWksInGLayer, m_availDataTypeMatInGLayer) )
		if(MAT_FOLDER == dwCurSel || MAT_PROJECT == dwCurSel || MAT_FAVS == dwCurSel || RELATED_MAT == nRealAvailDataType )
		///End ADD_RELATED_WKBOOK_IN_DATATYPE_COMBOBOX
		///End NOT_REMEMBER_RELATED_WKS_SELECTION_IN_COMBO_WHEN_REOPEN_DLG
			return; // no need update folder type in combo
		
		if( dwInfo & PGDN_FOLDER || dwInfo & PGDN_FOLDER_SUB )
		{
			dwCurSel = MAT_FOLDER; // matrixsheet in current folder
		}
		else
		{
			dwCurSel = MAT_PROJECT;
		}		
	}
	else 
	{
		ASSERT(false);
		return;
	}

}

///Jasminie 02/14/11 ORG-2100-P8 SHOW_SOURCE_DATA_FOR_TEMP_PLOT
void AvailDataCombo::RemoveWksOrMatInGLayerDropdown(const vector<int>& vnTypes)
{
	bool bWksDropdownRemove = false, bMatDropdownRemove = false, bSelChange = false;
	int nCurSel = GetCurSel();
	
	//delete from the end
	vector<uint> vecIndex2;
	if(vnTypes.Find(vecIndex2, EXIST_MATRIX) > 0)
	{
		bMatDropdownRemove = true;
		bSelChange = (nCurSel == m_availDataTypeMatInGLayer);
		
		DeleteString(m_availDataTypeMatInGLayer);
		m_availDataTypeMatInGLayer = -1;	
	}
	
	vector<uint> vecIndex;
	if(vnTypes.Find(vecIndex, EXIST_WKS) > 0)
	{
		bWksDropdownRemove = true;
		if(!bSelChange)
			bSelChange = (nCurSel == m_availDataTypeWksInGLayer || nCurSel == m_availDataTypeWkbookInGLayer);
		
		DeleteString(m_availDataTypeWkbookInGLayer);
		DeleteString(m_availDataTypeWksInGLayer);
		m_availDataTypeWksInGLayer 		= -1;		
		m_availDataTypeWkbookInGLayer 	= -1;
	}
	
	if(bWksDropdownRemove && m_availDataTypeMatInGLayer > 0)
		m_availDataTypeMatInGLayer = m_availDataTypeMatInGLayer-2;
	
	if(bWksDropdownRemove || bMatDropdownRemove)
		m_pDatasetList->InitDynamicAvailDataType(m_availDataTypeWksInGLayer, m_availDataTypeWkbookInGLayer, m_availDataTypeMatInGLayer);

		
	if(bSelChange)
	{
		SetCurSel(-1);
		m_pDatasetList->ClearAll();
	}
}
void AvailDataCombo::AddWksOrMatInGLayerDropdown(const vector<int>& vnTypes)
{
	bool bWksDropdownAdd = false, bMatDropdownAdd = false;
	
	vector<uint> vecIndex;
	if(vnTypes.Find(vecIndex, EXIST_WKS) > 0)
	{
		bWksDropdownAdd = true;
		
		if(GetCount() > FUNC_PLOT+1)
		{
			m_availDataTypeWksInGLayer = InsertString(FUNC_PLOT+1, STR_AVAIL_DATA_WKS_IN_GLAYER);
			m_availDataTypeWkbookInGLayer = InsertString(m_availDataTypeWksInGLayer+1, STR_AVAIL_DATA_WKBOOK_IN_GLAYER);
		}
		else
		{
			m_availDataTypeWksInGLayer = AddString(STR_AVAIL_DATA_WKS_IN_GLAYER);
			m_availDataTypeWkbookInGLayer = AddString(STR_AVAIL_DATA_WKBOOK_IN_GLAYER);
		}
	}
	
	vector<uint> vecIndex2;
	if(vnTypes.Find(vecIndex2, EXIST_MATRIX) > 0)
	{
		bMatDropdownAdd = true;
		
		if( (m_availDataTypeWkbookInGLayer > 0 && GetCount() == m_availDataTypeWkbookInGLayer+1) ||
			(GetCount() == FUNC_PLOT+1) )
		{
			m_availDataTypeMatInGLayer = AddString(STR_AVAIL_DATA_MAT_IN_GLAYER);
		}
		else
		{
			m_availDataTypeMatInGLayer = InsertString(m_availDataTypeWkbookInGLayer > 0? m_availDataTypeWkbookInGLayer+1 : FUNC_PLOT+1, STR_AVAIL_DATA_MAT_IN_GLAYER);
		}	
	}
	else if(bWksDropdownAdd && m_availDataTypeMatInGLayer > 0)
		m_availDataTypeMatInGLayer = m_availDataTypeMatInGLayer+2;//wks and wbook
	
	if(bWksDropdownAdd || bMatDropdownAdd)
		m_pDatasetList->InitDynamicAvailDataType(m_availDataTypeWksInGLayer, m_availDataTypeWkbookInGLayer, m_availDataTypeMatInGLayer);

}
///End SHOW_SOURCE_DATA_FOR_TEMP_PLOT

/************************************************************************/
/* ---PlotTypeListBase                                                  */
/************************************************************************/
int PlotTypeListBase::GetPlotTypesListName( vector<string>& vsList )
{
	vsList = m_vsPlotTypes;
	return vsList.GetSize();
}

int PlotTypeListBase::GetPlotIDByIndex( int nIndex )
{
	if( nIndex < 0 || nIndex >= GetCount() )
		/// Iris 12/31/2010 ORG-1879 ADD_AUTO_PLOTTYPE_IN_PLOTTYPE_BMP_BUTTON
		//return -1;
		return PLOT_ID_FOR_AUTO;
		///End ADD_AUTO_PLOTTYPE_IN_PLOTTYPE_BMP_BUTTON
	return m_vnPlotIDs[nIndex];
}

string PlotTypeListBase::GetPlotTypeStringByIndex(int nIndex)
{
	if( nIndex < 0 || nIndex >= GetCount() )
		/// Iris 12/31/2010 ORG-1879 ADD_AUTO_PLOTTYPE_IN_PLOTTYPE_BMP_BUTTON
		//return -1;
		return STR_AUTO;
		///End ADD_AUTO_PLOTTYPE_IN_PLOTTYPE_BMP_BUTTON
	return m_vsPlotTypes[nIndex];	
}

bool PlotTypeListBase::GetPlotIDs( vector<int> &vnPlotIDs )
{
	vnPlotIDs = m_vnPlotIDs;
	return true;
}

bool PlotTypeListBase::ConvertPlotIDToPlotTypeStr()
{
	m_vsPlotTypes.RemoveAll();
	for( int ii=0; ii<m_vnPlotIDs.GetSize(); ++ii )
	{
		m_vsPlotTypes.Add( GetPlotTypeName(m_vnPlotIDs[ii]) );
	}
	
	return true;
}

/************************************************************************/
/* ---ChangePlotTypeList			                                     		*/
/************************************************************************/
ChangePlotTypeList::ChangePlotTypeList( int nPageType, DWORD dwLayerBits, bool bVirtualMatrix, int nPlotID) : PlotTypeListBase( nPageType, dwLayerBits, bVirtualMatrix)
{
	m_nPlotID					= nPlotID;
	m_nPageType					= changePageType(nPageType, bVirtualMatrix);
	UpdatePlotTypeList();
}

int ChangePlotTypeList::getPlotType( int nPlotID, DWORD* pdwAuxTypeInfo /*= NULL*/, DWORD *pdwAuxLtPlotInfo /*= NULL*/, string *pstrColPattern /*= NULL*/ )
{
	DWORD dwAuxTypeInfo = 0, dwPlotInfo = 0;
	string strColPattern;
	
	int nPlotType = get_plot_type_info(nPlotID, m_nPageType, m_dwLayerBits, dwAuxTypeInfo, dwPlotInfo, strColPattern);
	//----
	if(pdwAuxTypeInfo)
		*pdwAuxTypeInfo = dwAuxTypeInfo;
	if(pdwAuxLtPlotInfo)
		*pdwAuxLtPlotInfo = dwPlotInfo; 
	if(pstrColPattern)
		*pstrColPattern = strColPattern;

	return nPlotType;
}

int ChangePlotTypeList::removeInvalidPlotIDs( vector<int>& vnPlotIDs,  int nPlotTypeCheckCompatible /*= 0*/, 
										 DWORD dwAuxTypeInfoCheckCompatible /*= 0*/, DWORD dwLTPlotInfoCheckCompatible /*= 0*/ )
{
	DWORD dwAuxTypeInfo, dwLTPlotInfo;
	int nPlotType = 0;
	int nInListIndex = -1;
	for(int ii = 0; ii < vnPlotIDs.GetSize(); ii++)
	{
		dwAuxTypeInfo = 0;
		
		nPlotType = getPlotType(vnPlotIDs[ii], &dwAuxTypeInfo, &dwLTPlotInfo);
		
	#ifdef _DEBUG_PLOT_TYPE
		printf("PlotID(%d) -> %d %X, %X\n", vnPlotIDs[ii], nPlotType, dwAuxTypeInfo, (dwAuxTypeInfo & MASK_PCD_LAYER_BITS));
	#endif
		if(nInListIndex < 0 && is_plottype_the_same(nPlotTypeCheckCompatible, dwAuxTypeInfoCheckCompatible, dwLTPlotInfoCheckCompatible,
													nPlotType, dwAuxTypeInfo, dwLTPlotInfo) )
		{
			///Sophy 8/18/2010 ORG-826-P3 PROPER_FILTER_PLOTTYPES_ON_SELECT_PLOT_CHANGE
			//nInListIndex = ii;
			if ( nPlotTypeCheckCompatible == IDM_PLOT_3D_MESH )
			{
				int nConvertedID = ConvertPlotIds(nPlotType, &dwAuxTypeInfo, &dwLTPlotInfoCheckCompatible);
				if ( nConvertedID == vnPlotIDs[ii] )
					nInListIndex = ii;
			}
			else
			{
				nInListIndex = ii;
			}
			///end PROPER_FILTER_PLOTTYPES_ON_SELECT_PLOT_CHANGE
			continue;
		}
		
		DWORD	dwThisLayerBitsTest = dwAuxTypeInfo & MASK_PCD_LAYER_BITS;

		if( !isLayerTypeCompatible( m_dwLayerBits, dwThisLayerBitsTest, vnPlotIDs[ii])
			|| isPlotTypeInCompatible(nPlotTypeCheckCompatible, dwAuxTypeInfoCheckCompatible, nPlotType, dwAuxTypeInfo) 
			|| !isColDesignationCompatible( vnPlotIDs[ii] ) )
		{
			vnPlotIDs.RemoveAt(ii);
			ii--;
		}
	}
	return nInListIndex;
}

static void _get_wks_2d_plots_id( vector<int> &vnPlots )
{
	static const vector<int> vnWksPlots = {
		IDM_PLOT_LINE,IDM_PLOT_SCATTER,IDM_PLOT_LINESYMB,
		IDM_PLOT_COLUMN,IDM_PLOT_AREA,IDM_PLOT_AREA_STACK, ///Jasmine 01/22/2009 QA80-12738 ALLOW_AREA_STACK_FOR_PS
		IDM_PLOT_FILL_COLOR_BAND,IDM_PLOT_HILOCLOSE,
		IDM_PLOT_COLUMN_FLOAT,IDM_PLOT_VECTOR,IDM_PLOT_FLOWVECTOR,
		/// Iris 1/25/2011 ORG-2100-P1 LC_SHOULD_NOT_SUPPORT_BUBBLE_PLOT
		//IDM_PLOT_INDEX_SIZE, IDM_PLOT_INDEX_COLOR, IDM_PLOT_INDEX_SIZE_COLOR,
		///End LC_SHOULD_NOT_SUPPORT_BUBBLE_PLOT
		IDM_PLOT_PIE_TYPE, IDM_PLOT_BAR,IDM_PLOT_COLUMN_STACK, IDM_PLOT_BAR_STACK, 
		IDM_PLOT_TRI_CONTOUR,		///Jasmine 04/05/07 QA80-9560 ADD_XYZ_CONTOUR_TO_PLOT_TYPE_LIST
		IDM_PLOT_BOX, IDM_PLOT_HISTOGRAM_TYPE
	};

	vnPlots = vnWksPlots;
}

/// Iris 12/05/2011 ORG-4482-P2 IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
/*
static void _get_mat_plots_id( vector<int> &vnPlots )
{
	static const vector<int> vnMatPlots = {
		IDM_PLOT_SURFACE_COLORMAP, IDM_PLOT_SURFACE_COLORFILL, IDM_PLOT_SURFACE_WIREFRAME, IDM_PLOT_SURFACE_BARS,
		IDM_PLOT_3D_SCATTER_MATRIX, ///Sophy 8/12/2010 ORG-797-P1 ADD_MATRIX_3D_SCATTER_TO_PLOT_TYPE_LIST
		/// Iris 1/25/2011 ORG-2100-P4 ALLOW_PLOT_HIST_FROM_MATRIX
		//IDM_PLOT_CONTOUR,IDM_PLOT_MATRIX_IMAGE};
		IDM_PLOT_CONTOUR, IDM_PLOT_MATRIX_IMAGE, IDM_PLOT_HISTOGRAM_TYPE}; 
		///End ALLOW_PLOT_HIST_FROM_MATRIX

	vnPlots = vnMatPlots;
}
*/
static void _get_mat_plots_id( vector<int> &vnPlots, bool bIsGLLayer )
{
	if( !bIsGLLayer )
	{
		static const vector<int> vnMatPlots = {
			IDM_PLOT_SURFACE_COLORMAP, IDM_PLOT_SURFACE_COLORFILL, IDM_PLOT_SURFACE_WIREFRAME, IDM_PLOT_SURFACE_BARS,
			IDM_PLOT_3D_SCATTER_MATRIX, 
			IDM_PLOT_CONTOUR, IDM_PLOT_MATRIX_IMAGE, IDM_PLOT_HISTOGRAM_TYPE}; 
	
		vnPlots = vnMatPlots;	
	}
	else
	{
		static const vector<int> vnMatGLPlots = {
			IDM_PLOT_3D_SURFACE_NEW,
			IDM_PLOT_3D_SCATTER_MATRIX,
			IDM_PLOT_SURFACE_BARS
		};
		vnPlots = vnMatGLPlots;
	}
}
///End IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT

static void _get_dataset_plots_id( vector<int> &vnPlots )
{
	static const vector<int> vnDatasetPlots = {IDM_PLOT_LINE,IDM_PLOT_SCATTER,IDM_PLOT_LINESYMB}; 
	vnPlots = vnDatasetPlots;
}

/// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
//static void _get_3DScatterPlots_id( vector<int> &vnPlots )
static void _get_3DScatterPlots_id( vector<int> &vnPlots, bool bIsGLLayer )
///End IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
{
	//------Iris 12/09/2011 ORG-4482-P6 REMOVE_XYZ_SCATTER_ERR_FROM_LAYER_CONTENTS_DLG
	// this plot type list used to switch same type plot list in LC dialog right panel, 3D scatter Err need extra Z column, so cannot implement this convertion from XYZ data. 
	// so remove IDM_PLOT_3D_SCATTER_ERR from below list.
	/*
	///Sophy 9/10/2010 ORG-789 CREATE_3D_SCATTER_WITH_ERR_BAR_OR_VECTOR_IN_PLOT_SETUP_DIALOG
	#ifndef	__ZERROR_DESIG_IN_PLOT_SETUP_DLG__
	static const vector<int> vn3DScatterPlots = {IDM_PLOT_3D_LINE, IDM_PLOT_3D_INDEX_SIZE, IDM_PLOT_3D_INDEX_COLOR, IDM_PLOT_3D_INDEX_SIZE_COLOR};
	#else
	static const vector<int> vn3DScatterPlots = {IDM_PLOT_3D_LINE, IDM_PLOT_3D_INDEX_SIZE, IDM_PLOT_3D_INDEX_COLOR, IDM_PLOT_3D_INDEX_SIZE_COLOR, IDM_PLOT_3D_SCATTER_ERR};
	#endif	//__ZERROR_DESIG_IN_PLOT_SETUP_DLG__	
	*/
	static const vector<int> vn3DScatterPlots = {IDM_PLOT_3D_LINE, IDM_PLOT_3D_INDEX_SIZE, IDM_PLOT_3D_INDEX_COLOR, IDM_PLOT_3D_INDEX_SIZE_COLOR};
	//------
	
	/// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
	_check_wks_xyz_3d_layer_plots_id_with_GL(vn3DScatterPlots, bIsGLLayer);
	///End IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
	
	vnPlots = vn3DScatterPlots;
}

static void _get_PolarSmithTernaryPlots_id( vector<int> &vnPlots )
{
	static const vector<int> vnPolarSmithTernaryPlots = {
		IDM_PLOT_LINE, IDM_PLOT_SCATTER, IDM_PLOT_LINESYMB,
		IDM_PLOT_INDEX_SIZE, IDM_PLOT_INDEX_COLOR, IDM_PLOT_INDEX_SIZE_COLOR,
		IDM_PLOT_FLOWVECTOR, IDM_PLOT_COLUMN, 
											IDM_PLOT_TRI_CONTOUR		///Jasmine 09/23/08 QA80-12247-P1
		/// Fisher 04/28/2009 QA80-2935 ADD_TERNARY_CONTOUR_PLOT
		#ifdef TERNARY_CONTOUR_PLOT_81
											,IDM_PLOT_TERNARY_CONTOUR
		#endif	// TERNARY_CONTOUR_PLOT_81
		/// End ADD_TERNARY_CONTOUR_PLOT
		};

	vnPlots = vnPolarSmithTernaryPlots;
}

static void _get_3DXYYPlots_id( vector<int> &vnPlots )
{
	static const vector<int> vn3DXYYPlots = {IDM_PLOT_3D_BAR, IDM_PLOT_3D_RIBBON, IDM_PLOT_3D_WALL};
	vnPlots = vn3DXYYPlots;
}
	
static void _get_VirtualMatrixPlots_id( vector<int> &vnPlots )
{
	///Sophy 8/3/2010 ORG-681-P2 PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
	static const vector<int> vnVirtualMatrixPlots = {
		IDM_PLOT_3D_MESH,
		IDM_PLOT_3D_SCATTER_MATRIX,	///Sophy 8/12/2010 ORG-797-P1 ADD_MATRIX_3D_SCATTER_TO_PLOT_TYPE_LIST
		IDM_PLOT_CONTOUR
		//IDM_PLOT_TRI_CONTOUR,
		//IDM_PLOT_TERNARY_CONTOUR
	};
	///end PROPER_SHOW_VIRTUAL_MATRIX_SERIES_INFO_IN_PLOTSETUP_DLG
	
	vnPlots = vnVirtualMatrixPlots;
}

// virtual
bool ChangePlotTypeList::UpdatePlotTypeList()
{	
	DWORD dwAuxTypeInfo;
	DWORD dwLTPlotInfo;	
	
	m_nCurPlotType = getPlotType( m_nPlotID, &dwAuxTypeInfo, &dwLTPlotInfo, &m_strColPattern );
	DWORD dwLayerMaskBits = m_dwLayerBits & MASK_PCD_LAYER_BITS; /// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS

	switch ( m_nPageType )
	{
	case EXIST_WKS:
	case EXIST_EXTERN_WKS:
		/// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
		//switch( m_dwLayerBits & MASK_PCD_LAYER_BITS )
		switch( dwLayerMaskBits )
		///End IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
		{
		case PCD_LAYER_POLAR:
		case PCD_LAYER_SMITH:
		case PCD_LAYER_TRI:
			_get_PolarSmithTernaryPlots_id( m_vnPlotIDs );
			break;
		case PCD_LAYER_3D_XYY:
			_get_3DXYYPlots_id( m_vnPlotIDs );
			break;
		case PCD_LAYER_3D:
			/// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
			//_get_3DScatterPlots_id( m_vnPlotIDs );
		///------ Folger 06/26/2012 ORG-5528-P22 SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
		//case PCD_LAYER_3D_GL:
			//_get_3DScatterPlots_id( m_vnPlotIDs, PCD_LAYER_3D_GL == dwLayerMaskBits );
			_get_3DScatterPlots_id( m_vnPlotIDs, IsGL() );
		///------ End SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
			///End IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
			break;
		default:
			_get_wks_2d_plots_id( m_vnPlotIDs );
			break;
		}
		break;
	case EXIST_MATRIX:
		/// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
		//_get_mat_plots_id( m_vnPlotIDs );
		///------ Folger 06/26/2012 ORG-5528-P22 SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
		//_get_mat_plots_id( m_vnPlotIDs, PCD_LAYER_3D_GL == dwLayerMaskBits );
		_get_mat_plots_id( m_vnPlotIDs, IsGL() );
		///------ End SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
		///End IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
		break;
	default:
		ASSERT( FALSE );
		break;
	}
	
	int nIndexInList = removeInvalidPlotIDs(m_vnPlotIDs, m_nCurPlotType, dwAuxTypeInfo, dwLTPlotInfo);
	
	/// Iris 1/25/2011 ORG-2100-P1 LC_SHOULD_NOT_SUPPORT_BUBBLE_PLOT
	/*
	int nCustomID = checkIsCustomPlotID( nIndexInList, m_nPlotID, dwAuxTypeInfo, dwLTPlotInfo, m_vnPlotIDs );
	if( nCustomID > 0 )
		m_vnPlotIDs.InsertAt( 0, nCustomID );
	*/
	vector<uint> vu;
	if( m_vnPlotIDs.Find( MATREPL_TEST_EQUAL, m_nPlotID, vu ) <= 0 )
	{
		m_vnPlotIDs.RemoveAll();
		m_vnPlotIDs.Add(m_nPlotID);
	}
	///End LC_SHOULD_NOT_SUPPORT_BUBBLE_PLOT
	
	return ConvertPlotIDToPlotTypeStr();
}

DWORD ChangePlotTypeList::getLayerBitsIgnoreExchange( DWORD dwLayerBits, bool bIgnorePolarSmith /*= true*/ )
{
	if(PCD_LAYER_EXCHANGE == dwLayerBits)
		return 0;
	if(bIgnorePolarSmith && dwLayerBits >= PCD_LAYER_POLAR && dwLayerBits <= PCD_LAYER_SMITH)
		return 0;
	///Sophy 6/28/2012 ORG-5475-P3 GL_LAYER_BIT_MAKE_3D_SCATTER_INCOMPATIBLE_WITH_3D_BARS
	//return dwLayerBits;
	return (dwLayerBits & ~PCD_LAYER_GL);
	///end GL_LAYER_BIT_MAKE_3D_SCATTER_INCOMPATIBLE_WITH_3D_BARS
}

bool ChangePlotTypeList::isLayerTypeCompatible( DWORD dwTargetLayerBits, DWORD dwPlotTypeBits, int nPlotType )
{
	DWORD dwTarget	= getLayerBitsIgnoreExchange(dwTargetLayerBits);
	DWORD dwPlot	= getLayerBitsIgnoreExchange(dwPlotTypeBits);

	if (dwTarget != dwPlot)
		return false;

	// some layer has additional type that they don't support
	if(PCD_LAYER_TRI == dwTargetLayerBits || PCD_LAYER_SMITH == dwTargetLayerBits)
	{
		if(IDM_PLOT_COLUMN == nPlotType)
			return false;
		if(PCD_LAYER_TRI == dwTargetLayerBits && IDM_PLOT_FLOWVECTOR == nPlotType)
			return false;
	}
	return true;
}

bool ChangePlotTypeList::isPlotTypeInCompatible( int nPlotTypeTest, DWORD dwAuxTypeInfoTest, int nPlotType, DWORD dwAuxTypeInfo )	
{
	if( 0 == nPlotTypeTest )
		return false;
	
	if ( nPlotTypeTest == nPlotType )
	{
		if(is_plottype_the_same(nPlotTypeTest, dwAuxTypeInfoTest, 0, nPlotType, dwAuxTypeInfo, 0, true))
			return false;
		return true;// same bPlotType, but not the same dwAuxTypeInfo, must be incompatible
	}
	///Sophy 6/26/2012 ORG-5475-P6 3D_XYZ_SURFACE_BAR_SHOULD_BE_COMPATIBLE_WITH_3D_SCATTER
	///------ Folger 06/26/2012 ORG-5528-P22 SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
	//if ( (m_dwLayerBits & MASK_PCD_LAYER_BITS) == PCD_LAYER_3D_GL && EXIST_WKS == m_nPageType ) //for OpenGL layer, allow 3d surface bar from xyz, should be compatiable with 3d xyz scatter
	if ( (m_dwLayerBits & MASK_PCD_LAYER_BITS) == PCD_LAYER_3D && IsGL() && EXIST_WKS == m_nPageType ) //for OpenGL layer, allow 3d surface bar from xyz, should be compatiable with 3d xyz scatter
	///------ End SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
	{
		if ( nPlotTypeTest == IDM_PLOT_3D_MESH && nPlotType == IDM_PLOT_3D_LINE
			|| nPlotType == IDM_PLOT_3D_MESH && nPlotTypeTest == IDM_PLOT_3D_LINE )
			return false; //compatible.
	}
	///end 3D_XYZ_SURFACE_BAR_SHOULD_BE_COMPATIBLE_WITH_3D_SCATTER
	return compare_plot_types(nPlotTypeTest, nPlotType) == 0? true:false;
}

bool ChangePlotTypeList::isPageTypeInCompatible( int nPageTypeTest, int nPageType )
{
	if( 0 == nPageTypeTest )
		return false; // not specified is OK
	
	if( EXIST_MATRIX == nPageTypeTest && EXIST_MATRIX != nPageType )
		return true;
	
	if( EXIST_MATRIX != nPageTypeTest && EXIST_MATRIX == nPageType )
		return true;

	return false;
}

bool ChangePlotTypeList::isColDesignationCompatible( int nPlotIDTest )
{
	DWORD dwAuxTypeInfoTest, dwAuxTypeInfoCur;

	{
		DWORD dwLTPlotInfoTest, dwLTPlotInfoCur;
		string strColPatternTest, strColPatternCur;
		
		Project.GetPlotTypeInfo( nPlotIDTest, dwAuxTypeInfoTest, dwLTPlotInfoTest, strColPatternTest );
		Project.GetPlotTypeInfo( m_nPlotID, dwAuxTypeInfoCur, dwLTPlotInfoCur, strColPatternCur );
	}

	if( HAS_NO_COLDESIG_SIZE_AND_COLOR( dwAuxTypeInfoCur) && HAS_NO_COLDESIG_SIZE_AND_COLOR( dwAuxTypeInfoTest ) )
		return true;

	if( HAS_COLDESIG_SIZE_AND_COLOR( dwAuxTypeInfoCur ) )
		return true;
	else if( (HAS_COLDESIG_SIZE(dwAuxTypeInfoCur) || HAS_COLDESIG_COLOR(dwAuxTypeInfoCur)) 
				&& !HAS_COLDESIG_SIZE_AND_COLOR(dwAuxTypeInfoTest) )
		return true;

	return false;
}

bool ChangePlotTypeList::isPlotTypeSpecial( int nPlotID, vector<int>& vnPlotIDs )
{
	if(0 == nPlotID)
		return false;
	DWORD 	dwCustomTypeInfo, dwCustomPlotInfo;
	int		nCustomPlotType = getPlotType(nPlotID, &dwCustomTypeInfo, &dwCustomPlotInfo);
	for(int ii = 0; ii < vnPlotIDs.GetSize(); ii++)
	{
		DWORD dwCompareTypeInfo, dwComparePlotInfo;
		int nComparePlotType = getPlotType(vnPlotIDs[ii], &dwCompareTypeInfo);
		//DWORD	dwCompare = dw & ~PCD_LTPLOTINFO_HAS_NEXVAL;
		//DWORD	dwCustomCompare = dwCustom & ~PCD_LTPLOTINFO_HAS_NEXVAL;
		//if(nTypeCustom == nType && dwCompare == dwCustomCompare)
		if(is_plottype_the_same(nCustomPlotType, dwCustomTypeInfo, dwCustomPlotInfo,
								nComparePlotType, dwCompareTypeInfo, dwComparePlotInfo) )
			return false;
	}
	return true;
}

// now we assume the virtual matrix as matrix and loose dataset as worksheet
// but in add plot operation, we still need to know what kind of page type
int ChangePlotTypeList::changePageType(int OriginalPageType, bool bVirtualMat)
{
	if( OriginalPageType == EXIST_DATA 
		|| OriginalPageType == EXIST_FUNC_PLOT
		/// Kenny 08/23/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
#ifdef NEW_NAMED_RANGE_FEATURE
		|| OriginalPageType == EXIST_NAMED_RANGE
#endif // NEW_NAMED_RANGE_FEATURE
		/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		)	
	{
		return bVirtualMat ? EXIST_MATRIX : EXIST_WKS;
	}
	
	return OriginalPageType;
}
/************************************************************************/
/* ---SimplePlotTypeList                                                */
/************************************************************************/
static void _get_wks_xy_pattern_plots_id( vector<int> &vnPlots )
{
	static const vector<int> vnWksXYPatternPlotIDs = 
	{
		IDM_PLOT_LINE, IDM_PLOT_SCATTER, IDM_PLOT_LINESYMB,
		IDM_PLOT_COLUMN, IDM_PLOT_AREA
	};
	
	vnPlots = vnWksXYPatternPlotIDs;
}

/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
/*
static void _get_wks_xyz_pattern_plots_id( vector<int> &vnPlots )
{
	static const vector<int> vnWksXYZPatternPlotIDs = 
	{
		IDM_PLOT_3D_LINE, IDM_PLOT_TRI_CONTOUR
	};
	
	vnPlots = vnWksXYZPatternPlotIDs;
}

static void _get_mat_pattern_plots_id( vector<int> &vnPlots )
{
	static const vector<int> vnMatZPatternPlotIDs = 
	{
		IDM_PLOT_SURFACE_COLORMAP, IDM_PLOT_SURFACE_COLORFILL, 
		IDM_PLOT_SURFACE_WIREFRAME, IDM_PLOT_SURFACE_BARS,
		IDM_PLOT_3D_SCATTER_MATRIX, IDM_PLOT_CONTOUR,
		IDM_PLOT_MATRIX_IMAGE
	};
	
	vnPlots = vnMatZPatternPlotIDs;
}
*/
static void _get_wks_xyz_pattern_2d_layer_plots_id( vector<int> &vnPlots )
{
	static const vector<int> vnWksXYZPattern2DLayerPlotIDs = 
	{
		IDM_PLOT_TRI_CONTOUR		
	};
	
	vnPlots = vnWksXYZPattern2DLayerPlotIDs;
}

/// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
static void _check_wks_xyz_3d_layer_plots_id_with_GL( vector<int>& vnPlots, bool bIsGLLayer )
{
	vector<uint> vn;
	bool bIncGLIDs = vnPlots.Find(MATREPL_TEST_EQUAL, IDM_PLOT_3D_SURFACE_NEW, vn) >0 && vn.GetSize() > 0 ;
	
	if( bIsGLLayer && !bIncGLIDs )
	{
		vnPlots.Add(IDM_PLOT_3D_SURFACE_NEW);
	}
	if( !bIsGLLayer && bIncGLIDs )
	{
		vnPlots.RemoveAt(vn[0]);
	}	
	///Sophy 6/20/2012 ORG-5475-P6 SUPPPORT_ADD_3D_BARS_FROM_LAYERCONTENTS
	bIncGLIDs = vnPlots.Find(MATREPL_TEST_EQUAL, IDM_PLOT_SURFACE_BARS, vn) >0 && vn.GetSize() > 0 ;
	if( bIsGLLayer && !bIncGLIDs )
	{
		vnPlots.Add(IDM_PLOT_SURFACE_BARS);
	}
	if( !bIsGLLayer && bIncGLIDs )
	{
		vnPlots.RemoveAt(vn[0]);
	}
	///end SUPPPORT_ADD_3D_BARS_FROM_LAYERCONTENTS
}
///End IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS

/// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
//static void _get_wks_xyz_pattern_3d_layer_plots_id( vector<int> &vnPlots )
static void _get_wks_xyz_pattern_3d_layer_plots_id( vector<int> &vnPlots, bool bIsGLLayer )
///End IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
{
	static const vector<int> vnWksXYZPattern3DLayerPlotIDs = 
	{		
		IDM_PLOT_3D_LINE		
	};
	
	/// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
	_check_wks_xyz_3d_layer_plots_id_with_GL(vnWksXYZPattern3DLayerPlotIDs, bIsGLLayer);
	///End IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
	
	vnPlots = vnWksXYZPattern3DLayerPlotIDs;
}

///-----Kit 02/22/2011 ORG-2305-P1 SUPPORT_ADD_LINE_SCATTER_TO_POLAR_CONTOUR_LAYER
// now I can not find a good way to handle polar 2d xy plot id, so just use the hard code here
static void _get_wks_xy_pattern_polar_layer_plots_id(vector<int> &vnPlotIDs)
{
	static const vector<int> vnWksXYPolarPlotIDs = 
	{
		IDM_PLOT_LINE, IDM_PLOT_SCATTER, IDM_PLOT_LINESYMB,
		IDM_PLOT_COLUMN
	}

	vnPlotIDs = vnWksXYPolarPlotIDs;
}
///-----End SUPPORT_ADD_LINE_SCATTER_TO_POLAR_CONTOUR_LAYER

static void _get_mat_pattern_2d_layer_plots_id( vector<int> &vnPlots )
{
	static const vector<int> vnMatZPattern2DPlotIDs = 
	{
		IDM_PLOT_CONTOUR,
		IDM_PLOT_MATRIX_IMAGE,
		IDM_PLOT_HISTOGRAM_TYPE
	};
	
	vnPlots = vnMatZPattern2DPlotIDs;
}

/// Iris 12/05/2011 ORG-4482-P2 IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
/*
static void _get_mat_pattern_3d_layer_plots_id( vector<int> &vnPlots )
{
	static const vector<int> vnMatZPattern3DPlotIDs = 
	{
		IDM_PLOT_3D_SCATTER_MATRIX, IDM_PLOT_SURFACE_COLORMAP, IDM_PLOT_SURFACE_COLORFILL, 
		IDM_PLOT_SURFACE_WIREFRAME, IDM_PLOT_SURFACE_BARS
	};
	
	vnPlots = vnMatZPattern3DPlotIDs;
}
*/
static void _get_mat_pattern_3d_layer_plots_id( vector<int> &vnPlots, bool bIsGLLayer )
{
	if( !bIsGLLayer )
	{
		const vector<int> vnMatZPattern3DPlotIDs = 
		{
			IDM_PLOT_3D_SCATTER_MATRIX, IDM_PLOT_SURFACE_COLORMAP, IDM_PLOT_SURFACE_COLORFILL, 
			IDM_PLOT_SURFACE_WIREFRAME, IDM_PLOT_SURFACE_BARS
		};
		vnPlots = vnMatZPattern3DPlotIDs;	
	}
	else
	{
		const vector<int> vnMatZPattern3DGLPlotIDs = 
		{
			IDM_PLOT_3D_SURFACE_NEW,
			IDM_PLOT_3D_SCATTER_MATRIX,
			IDM_PLOT_SURFACE_BARS
		};
		vnPlots = vnMatZPattern3DGLPlotIDs;
	}
}
///End IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
///End IMPROVE_PLOTTYPE_CHECK

///-----Kit 03/03/2011 ORG-1879-P3P4 GET_CORRECT_PLOT_IDS
class GetPlotIDsHelperBase
{
public:
	GetPlotIDsHelperBase(int nPageType, DWORD dwLayerBits, bool bVirtualMat, const vector<int> &vnColTypeSelected)
	{
		m_nPageType = nPageType;
		m_dwLayerBits = dwLayerBits;
		m_bVirtualMat = bVirtualMat;
		m_vnColTypeSelected	= vnColTypeSelected;
	}

	virtual ErrorInfo	GetPlotIDs(vector<int> &vnPlotIDs){ASSERT(false); return Err_ErrorUnknow;}
	virtual	bool		IsMatch(int nPlotIDToCheck){ASSERT(false); return false;}
protected:
	bool	RemovePlotIDs(const vector<int> &vnPlotIDsToRemove, vector<int> &vnPlotIDs)
	{
		for( int ii = 0; ii < vnPlotIDsToRemove.GetSize(); ++ii )
		{
			vector<uint> vuIndexes;
			if( vnPlotIDs.Find(vuIndexes, vnPlotIDsToRemove[ii]) > 0 )
				vnPlotIDs.RemoveAt(vuIndexes[0]);
		}
		
		return true;
	}

	///------ Folger 06/26/2012 ORG-5528-P22 SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
	bool	IsGL() { return O_QUERY_BOOL(m_dwLayerBits, PCD_LAYER_GL); }
	///------ End SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT

protected:
	int			m_nPageType;
	DWORD		m_dwLayerBits;
	bool		m_bVirtualMat;
	vector<int>	m_vnColTypeSelected;
};

class GetWksPlotIDsHelper : public GetPlotIDsHelperBase
{
public:
	GetWksPlotIDsHelper(int nPageType, DWORD dwLayerBits, bool bVirtualMat, const vector<int> &vnColTypeSelected)
		: GetPlotIDsHelperBase(nPageType, dwLayerBits, bVirtualMat, vnColTypeSelected){}
	
	// virtual
	ErrorInfo	GetPlotIDs(vector<int> &vnPlotIDs)
	{
		ErrorInfo errInfo = Err_NoError;
		bool bSelYLorYorLColType =	_has_columns_type_selected(m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_Y, OKDATAOBJ_DESIGNATION_L, FindColType_AllMatch)
									|| _has_columns_type_selected(m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_Y, FindColType_AllMatch)
									|| _has_columns_type_selected(m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_L, FindColType_AllMatch);
		
		bool bSelYZorZColType = _has_columns_type_selected(m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_Y, OKDATAOBJ_DESIGNATION_Z, FindColType_AllMatch)
								|| _has_columns_type_selected(m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_Z, FindColType_AllMatch);
		
		bool bSelColTypeEmpty = CHECK_VECTOR_IS_EMPTY(m_vnColTypeSelected);
		
		/// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
		//switch( m_dwLayerBits & MASK_PCD_LAYER_BITS )
		DWORD dwLayerMaskBits = m_dwLayerBits & MASK_PCD_LAYER_BITS;
		switch( dwLayerMaskBits )
		///End IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
		{
		case PCD_LAYER_TRI:
		case PCD_LAYER_SMITH:
		case PCD_LAYER_3D_XYY:
			break;	// we do not handle this, just break
		case PCD_LAYER_POLAR:
			bool bSelYColType = _has_columns_type_selected(m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_Y, FindColType_AllMatch);
			if( bSelColTypeEmpty || bSelYColType )
			{
				vector<int> vnTempIDs;
				_get_wks_xy_pattern_polar_layer_plots_id(vnTempIDs);
				vnPlotIDs.Append(vnTempIDs);
			}
			
			if( bSelColTypeEmpty || bSelYZorZColType )
			{
				vector<int> vnTempPlotIDs;
				_get_wks_xyz_pattern_2d_layer_plots_id( vnTempPlotIDs );
				vnPlotIDs.Append( vnTempPlotIDs );
			}
			break;
			
		case PCD_LAYER_3D:
		///------ Folger 06/26/2012 ORG-5528-P22 SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
		//case PCD_LAYER_3D_GL: /// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
		///------ End SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
			///-----Kit 02/23/2011 may be separate the error checking code is a better way, now just put the error checking here
			///-----Kit 03/05/2011 ORG-2307-P5 RUNTIME_ERROR_WHEN_REMOVE_A_PLOT_AFTER_APPLY
			//if( !bSelColTypeEmpty && bSelYLorYorLColType )	
			if( !bSelColTypeEmpty 
				&& !canAddPlotTo3DLayer() )
			///-----End RUNTIME_ERROR_WHEN_REMOVE_A_PLOT_AFTER_APPLY
			{
				errInfo = Err_CanNotAdd2DPlotTo3DLayer;
			}
			
			if( bSelColTypeEmpty || bSelYZorZColType )
			{
				vector<int> vnTempPlotIDs;
				/// Iris 12/02/2011 ORG-4482-P1 IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
				//_get_wks_xyz_pattern_3d_layer_plots_id( vnTempPlotIDs );
				///------ Folger 06/26/2012 ORG-5528-P22 SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
				//_get_wks_xyz_pattern_3d_layer_plots_id( vnTempPlotIDs, PCD_LAYER_3D_GL == dwLayerMaskBits );
				_get_wks_xyz_pattern_3d_layer_plots_id( vnTempPlotIDs, IsGL() );
				///------ End SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
				///End IMPROVE_PLOT_TYPE_LIST_FOR_3D_OPENGL_GRAPHS
				vnPlotIDs.Append( vnTempPlotIDs );				
			}
			
			break;
		default: // 2D
			if( bSelColTypeEmpty || bSelYLorYorLColType )
			{
				vector<int> vnTempPlotIDs;
				_get_wks_xy_pattern_plots_id( vnTempPlotIDs );
				vnPlotIDs.Append( vnTempPlotIDs );						
			}
			
			if( bSelColTypeEmpty || bSelYZorZColType )
			{
				vector<int> vnTempPlotIDs;
				_get_wks_xyz_pattern_2d_layer_plots_id( vnTempPlotIDs );
				vnPlotIDs.Append( vnTempPlotIDs );				
			}	
			break;
		}
		return errInfo;
	}

	// virtual
	bool	IsMatch(int nPlotIDToCheck)
	{
		bool bMatch = false;
		if( !_is_wks_2d_plot_id(nPlotIDToCheck) )
		{
			bMatch = true;
		}
		else
		{
			bool bIsNot3DOrTernaryLayerAndOnlySelZCol = (!(IS_LAYER_BITS_ANY_3D(m_dwLayerBits) || PCD_LAYER_TRI == m_dwLayerBits)) 
				&& _has_columns_type_selected(m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_Z, FindColType_AllMatch);
			bool bIsPolarLayerAndOnlySelYCol = (PCD_LAYER_POLAR == m_dwLayerBits) 
				&& _has_columns_type_selected(m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_Y, FindColType_AllMatch);
			
			///-----Kit 02/23/2011 ORG-2312-P1 WHEN_ADD_PLOT_TO_CONTOUR_PLOT_LAYER_AUTO_PLOT_TYPE_SHOULD_SELECT_LINE_TYPE_AUTOLY			
			bool bIsContourPlotAndOnlySelYCol = (IDM_PLOT_TRI_CONTOUR == nPlotIDToCheck) 
				&& _has_columns_type_selected(m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_Y, FindColType_AllMatch);
			///-----End WHEN_ADD_PLOT_TO_CONTOUR_PLOT_LAYER_AUTO_PLOT_TYPE_SHOULD_SELECT_LINE_TYPE_AUTOLY
			if( bIsNot3DOrTernaryLayerAndOnlySelZCol 
				|| bIsPolarLayerAndOnlySelYCol 
				|| bIsContourPlotAndOnlySelYCol )
			{
				bMatch = true;
			}
		}

		return bMatch;
	}
///-----Kit 03/05/2011 ORG-2307-P5 RUNTIME_ERROR_WHEN_REMOVE_A_PLOT_AFTER_APPLY
private:
	bool	canAddPlotTo3DLayer()
	{
		vector<int> vn2DSpecialColType = {OKDATAOBJ_DESIGNATION_X_ERROR, OKDATAOBJ_DESIGNATION_ERROR, OKDATAOBJ_DESIGNATION_L };
		
		bool bSelSpecialColType = _has_columns_type_selected(m_vnColTypeSelected, vn2DSpecialColType, FindColType_HasOneOfMatch);
		bool bSelYColType = _has_columns_type_selected(m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_Y, FindColType_AllMatch);

		return !(bSelSpecialColType || bSelYColType);	///-----Kit 03/10/2011 ORG-2307-P4 MAKE_LOOSE_DATASET_ADD_TO_RIGHT_PANEL_MORE_SMART
	}
///-----End RUNTIME_ERROR_WHEN_REMOVE_A_PLOT_AFTER_APPLY
};

class GetLooseDatasetPlotIDsHelper : public GetWksPlotIDsHelper
{
public:
	GetLooseDatasetPlotIDsHelper(int nPageType, DWORD dwLayerBits, bool bVirtualMat, const vector<int> &vnColTypeSelected)
		: GetWksPlotIDsHelper(nPageType, dwLayerBits, bVirtualMat, vnColTypeSelected){}

	// virtual
	ErrorInfo GetPlotIDs(vector<int> &vnPlotIDs)
	{
		// now just handle the same as wks
		ErrorInfo errInfo = GetWksPlotIDsHelper::GetPlotIDs(vnPlotIDs);
		return errInfo;
	}
};

class GetFuncPlotPlotIDsHelper : public GetLooseDatasetPlotIDsHelper
{
public:
	GetFuncPlotPlotIDsHelper(int nPageType, DWORD dwLayerBits, bool bVirtualMat, const vector<int> &vnColTypeSelected)
		: GetLooseDatasetPlotIDsHelper(nPageType, dwLayerBits, bVirtualMat, vnColTypeSelected){}

	// virtual
	ErrorInfo GetPlotIDs(vector<int> &vnPlotIDs)
	{
		ErrorInfo errInfo = GetLooseDatasetPlotIDsHelper::GetPlotIDs(vnPlotIDs);
		if( Err_NoError == errInfo )
		{
			vector<int> vnRemovePlots = {IDM_PLOT_TRI_CONTOUR};
			if( !RemovePlotIDs(vnRemovePlots, vnPlotIDs) )
				errInfo = Err_ErrorUnknow;
		}

		return errInfo;
	}
};

class GetMatPlotIDsHelper : public GetPlotIDsHelperBase
{
public:
	GetMatPlotIDsHelper(int nPageType, DWORD dwLayerBits, bool bVirtualMat, const vector<int> &vnColTypeSelected)
		: GetPlotIDsHelperBase(nPageType, dwLayerBits, bVirtualMat, vnColTypeSelected){}

	// virtual
	ErrorInfo GetPlotIDs(vector<int> &vnPlotIDs)
	{
		ErrorInfo errInfo = Err_NoError;
		/// Iris 12/05/2011 ORG-4482-P2 IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
		//if( PCD_LAYER_3D == (m_dwLayerBits & MASK_PCD_LAYER_BITS) )
		///------ Folger 06/26/2012 ORG-5528-P22 SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
		//if( PCD_LAYER_3D == (m_dwLayerBits & MASK_PCD_LAYER_BITS) || PCD_LAYER_3D_GL == (m_dwLayerBits & MASK_PCD_LAYER_BITS) )
		if( PCD_LAYER_3D == (m_dwLayerBits & MASK_PCD_LAYER_BITS) )
		///------ End SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
		///End IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
		{
			/// Iris 12/05/2011 ORG-4482-P2 IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
			//_get_mat_pattern_3d_layer_plots_id( vnPlotIDs );
			///------ Folger 06/26/2012 ORG-5528-P22 SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
			//_get_mat_pattern_3d_layer_plots_id( vnPlotIDs, PCD_LAYER_3D_GL == (m_dwLayerBits & MASK_PCD_LAYER_BITS) );
			_get_mat_pattern_3d_layer_plots_id( vnPlotIDs, IsGL() );
			///------ End SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
			///End IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
		}
		else
		{			
			_get_mat_pattern_2d_layer_plots_id( vnPlotIDs );
		}

		return Err_NoError;
	}

	// virtual
	bool	IsMatch(int nPlotIDToCheck)
	{
		bool bMatch = false;
		/// Iris 12/05/2011 ORG-4482-P2 IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
		//if( !_is_matrix_plot_id(nPlotIDToCheck) )
		///------ Folger 06/26/2012 ORG-5528-P22 SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
		//if( !_is_matrix_plot_id(nPlotIDToCheck, PCD_LAYER_3D_GL == (m_dwLayerBits & MASK_PCD_LAYER_BITS) ) )
		if( !_is_matrix_plot_id(nPlotIDToCheck, IsGL()) )
		///------ End SEPARATE_GL_AS_SINGLE_LAYER_SYSTEM_BIT
		///End IMPROVE_3D_PLOT_TYPE_LIST_FOR_OPENGL_MATRIX_PLOT
				bMatch = true;

		return bMatch;
	}
};

class GetVirtualMatirxPlotIDsHelper : public GetMatPlotIDsHelper
{
public:
	GetVirtualMatirxPlotIDsHelper(int nPageType, DWORD dwLayerBits, bool bVirtualMat, const vector<int> &vnColTypeSelected)
		: GetMatPlotIDsHelper(nPageType, dwLayerBits, bVirtualMat, vnColTypeSelected){}

	// virtual
	ErrorInfo GetPlotIDs(vector<int> &vnPlotIDs)
	{
		ErrorInfo errInfo = GetMatPlotIDsHelper::GetPlotIDs(vnPlotIDs);

		if( Err_NoError == errInfo )
		{
			// plot id which virtual matrix is not support now
			vector<int> vnVMNotSupportPlotIDs = {IDM_PLOT_MATRIX_IMAGE};

			if( !RemovePlotIDs(vnVMNotSupportPlotIDs, vnPlotIDs) )
				errInfo = Err_ErrorUnknow;
		}
		
		return errInfo;
	}
};

static GetPlotIDsHelperBase* _create_get_plot_ids_helper(int nPageType, DWORD dwLayerBits, bool bVirtualMat, const vector<int> &vnColTypeSelected)
{
	switch(nPageType)
	{
	case EXIST_WKS:
	case EXIST_EXTERN_WKS:
		return new GetWksPlotIDsHelper(nPageType, dwLayerBits, bVirtualMat, vnColTypeSelected);
	case EXIST_MATRIX:
		return new GetMatPlotIDsHelper(nPageType, dwLayerBits, bVirtualMat, vnColTypeSelected);
	case EXIST_DATA:
		if( bVirtualMat )
			return new GetVirtualMatirxPlotIDsHelper(nPageType, dwLayerBits, bVirtualMat, vnColTypeSelected);

	/// Kenny 08/23/2011 ORG-3537 NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
#ifdef NEW_NAMED_RANGE_FEATURE
	case EXIST_NAMED_RANGE:
#endif // NEW_NAMED_RANGE_FEATURE
	/// End NAMED_RANGE_PLOTTING_VIA_LAYER_CONTENTS_AND_PLOT_SETUP
		return new GetLooseDatasetPlotIDsHelper(nPageType, dwLayerBits, bVirtualMat, vnColTypeSelected);
	case EXIST_FUNC_PLOT:
		return new GetFuncPlotPlotIDsHelper(nPageType, dwLayerBits, bVirtualMat, vnColTypeSelected);
	default:
		ASSERT(false);
		break;
	}

	return NULL;
}
///-----End GET_CORRECT_PLOT_IDS

bool	SimplePlotTypeList::UpdatePlotTypeList()
{
	m_vnPlotIDs.RemoveAll();
	///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
	/*vector<int> vnWksXYPlotIDs, vnWksXYZ2DLayerPlotIDs, vnWksXYZ3DLayerPlotIDs, vnMat2DLayerPlotIDs, vnMat3DLayerPlotIDs;
	
	
	/// Iris 1/20/2011 FIX_FAIL_PLOT_VM
	//switch( m_nPageType )
	int m_nPageType = m_nPageType;
	/// Iris 2/16/2011 ORG-2100-P11 FIX_FAIL_TO_PLOT_3D_WIRE_FRAME_FROM_VM
	//if( m_nPageType == EXIST_DATA )
	if( m_nPageType == EXIST_DATA || m_nPageType == EXIST_FUNC_PLOT )	
	///End FIX_FAIL_TO_PLOT_3D_WIRE_FRAME_FROM_VM
	{
		/// Iris 2/16/2011 ORG-2100-P11 FIX_FAIL_TO_PLOT_3D_WIRE_FRAME_FROM_VM
		//m_nPageType = _is_matrix_plot_id(m_nPlotIDToCheck) ? EXIST_MATRIX : EXIST_WKS;
		m_nPageType = m_bVritualMat ? EXIST_MATRIX : EXIST_WKS;
		///End FIX_FAIL_TO_PLOT_3D_WIRE_FRAME_FROM_VM
	}
	*/
	///-----End SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
	
	///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
	/*
	switch( m_nPageType )
	///End FIX_FAIL_PLOT_VM
	{
	case EXIST_WKS:
	case EXIST_EXTERN_WKS:
		switch( m_dwLayerBits )
		{
		///-----Kit 02/22/2011 ORG-2305-P1 SUPPORT_ADD_LINE_SCATTER_TO_POLAR_CONTOUR_LAYER
		//case PCD_LAYER_POLAR:
		///-----
		case PCD_LAYER_TRI:
		case PCD_LAYER_SMITH:
		case PCD_LAYER_3D_XYY:
			break;	// we do not handle this, just break
			
		case PCD_LAYER_3D:
			if( m_vnColTypeSelected.GetSize() == 0 || has_only_one_column_type_selected( m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_Y ) )
			{
				_get_wks_xy_pattern_plots_id( vnWksXYPlotIDs );
				m_vnPlotIDs.Append( vnWksXYPlotIDs );				
			}
			
			if( m_vnColTypeSelected.GetSize() == 0 || has_only_one_column_type_selected( m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_Z ) )
			{
				_get_wks_xyz_pattern_3d_layer_plots_id( vnWksXYZ3DLayerPlotIDs );
				m_vnPlotIDs.Append( vnWksXYZ3DLayerPlotIDs );				
			}
			
			break;
		case PCD_LAYER_POLAR:	///-----Kit 02/22/2011 ORG-2305-P1 SUPPORT_ADD_LINE_SCATTER_TO_POLAR_CONTOUR_LAYER
		default: // 2D
		///-----End SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER

			/// Iris 2/14/2011 ORG-2100-P10 PLOT_XYZ_TO_2D_GRAPH_AS_COUNTOUR
			/*
			if( has_only_one_column_type_selected( m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_Z ) )
			{
				_get_wks_xyz_pattern_2d_layer_plots_id( vnWksXYZ2DLayerPlotIDs );
				m_vnPlotIDs = vnWksXYZ2DLayerPlotIDs;				
			}
			else
			{
				_get_wks_xy_pattern_plots_id( vnWksXYPlotIDs );
				m_vnPlotIDs = vnWksXYPlotIDs;						
			}
			*/
			///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
			/*
			if( m_vnColTypeSelected.GetSize() == 0 || has_only_one_column_type_selected( m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_Y ) )
			{
				_get_wks_xy_pattern_plots_id( vnWksXYPlotIDs );
				///-----Kit 02/22/2011 ORG-2305-P1 SUPPORT_ADD_LINE_SCATTER_TO_POLAR_CONTOUR_LAYER
				if( m_dwLayerBits == PCD_LAYER_POLAR )
				{
					vector<uint> vuIndexes;
					if( vnWksXYPlotIDs.Find(vuIndexes, IDM_PLOT_AREA) > 0 )
						vnWksXYPlotIDs.RemoveAt(vuIndexes[0]);
				}
				///-----End SUPPORT_ADD_LINE_SCATTER_TO_POLAR_CONTOUR_LAYER
				m_vnPlotIDs.Append( vnWksXYPlotIDs );						
			}
			
			if( m_vnColTypeSelected.GetSize() == 0 || has_only_one_column_type_selected( m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_Z ) )
			{
				_get_wks_xyz_pattern_2d_layer_plots_id( vnWksXYZ2DLayerPlotIDs );
				m_vnPlotIDs.Append( vnWksXYZ2DLayerPlotIDs );				
			}	
			///End PLOT_XYZ_TO_2D_GRAPH_AS_COUNTOUR
			break;
		}
		break;
		
	case EXIST_MATRIX:
		/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
		//_get_mat_pattern_plots_id( m_vnPlotIDs );
		if( PCD_LAYER_3D == m_dwLayerBits )
		{
			_get_mat_pattern_3d_layer_plots_id( vnMat3DLayerPlotIDs );
			m_vnPlotIDs = vnMat3DLayerPlotIDs;
		}
		else
		{
			_get_mat_pattern_2d_layer_plots_id( vnMat2DLayerPlotIDs );
			m_vnPlotIDs = vnMat2DLayerPlotIDs;
		}
		///End IMPROVE_PLOTTYPE_CHECK
		break;
		
	/// Iris 1/20/2011 FIX_FAIL_PLOT_VM
	case EXIST_DATA:
		_get_wks_xy_pattern_plots_id( m_vnPlotIDs );
		break;
	///End FIX_FAIL_PLOT_VM
			
	default:
		break;
	}
	*/
	//updatePlotIDs();	///-----Kit 03/03/2011 ORG-1879-P3P4 GET_CORRECT_PLOT_IDS
	///-----End SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
	
	///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
	/*
	/// Iris 1/12/2011 ORG-1879-S3 IMPROVE_PLOTTYPE_CHECK
	// check plot type 
	m_bIsPlotIDNotMatch = false;
	m_bEnablePlot = true;
	m_strPlottingMsg.Empty();

	if( IDM_PLOT_UNKNOWN != m_nPlotIDToCheck )
	{
		if( m_nPageType == EXIST_MATRIX )
		{
		*/
		///-----End SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
			/// Iris 1/18/2011 SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH
			/*
			m_bEnablePlot = _is_matrix_plot_id(m_nPlotIDToCheck);
			if( !m_bEnablePlot )
			{			
				m_strPlottingMsg = MSG_XYZ_PLOT_PAGE_TYPE_MISMATCHING;	
			}
			*/

			///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
			/*
			if( !_is_matrix_plot_id(m_nPlotIDToCheck) )
				m_bIsPlotIDNotMatch = true;
			///End SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH
		}
		/// Iris 1/18/2011 SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH
		//else // worksheet
		else if( m_nPageType == EXIST_WKS )
		*/
		///-----End SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
		///End SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH
		//{
			/// Iris 1/30/2011 ORG-2100-P4 ALLOW_PLOT_HIST_FROM_MATRIX_EX
			//if( _is_matrix_plot_id(m_nPlotIDToCheck) )
			///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
			/*
			if( !_is_wks_2d_plot_id(m_nPlotIDToCheck) )
			///End ALLOW_PLOT_HIST_FROM_MATRIX_EX
			{
			*/
			///-----End SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
				/// Iris 1/18/2011 SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH
				/*
				m_bEnablePlot = false;
				if( IS_LAYER_BITS_ANY_3D(m_dwLayerBits) )
				{
					m_strPlottingMsg = MSG_MATRIX_PLOT_PAGE_TYPE_MISMATCHING;
				}
				else // 2D
				{
					m_strPlottingMsg = MSG_MAT_PLOT_DESIGN_PATTERN_MISMATCHING;
				}	
				*/
				///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
				//m_bIsPlotIDNotMatch = true;
				///-----End SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
				///End SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH
			///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
			/*
			}
			else
			{
				m_bEnablePlot = true;
				
				vector<uint> vuIndices;
			*/
			///-----End SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER

				/// Iris 1/18/2011 SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH
				/*
				bool bFoundZ = (m_vnColTypeSelected.Find(vuIndices, OKDATAOBJ_DESIGNATION_Z) > 0);
				
				if( IS_LAYER_BITS_ANY_3D(m_dwLayerBits) && !bFoundZ )
				{
					m_bEnablePlot = false;
					m_strPlottingMsg = MSG_XYZ_PLOT_DESIGN_PATTERN_MISMATCHING;
				}
				else 
				*/
				///End SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH				
				/// Iris 1/26/2011 ORG-2100-P6 SUPPORT_TERNARY_PLOT
				//if( !IS_LAYER_BITS_ANY_3D(m_dwLayerBits) // if is 2D graph layer

				///-----Kit 02/22/2011 ORG-2305-P1 SUPPORT_ADD_LINE_SCATTER_TO_POLAR_CONTOUR_LAYER
				/*
				if( !(IS_LAYER_BITS_ANY_3D(m_dwLayerBits) || PCD_LAYER_TRI == m_dwLayerBits) // if not 3D graph layer or ternary layer
				///End SUPPORT_TERNARY_PLOT
					&& has_only_one_column_type_selected( m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_Z ) // if has Z column is selected
					&& vnWksXYZ2DLayerPlotIDs.Find(vuIndices, m_nPlotIDToCheck) <= 0 ) // if m_nPlotIDToCheck not Contour plot 
				*/
			///-----Kit 02/23/2011 ORG-2307	SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER
			/*
				bool bIsNot3DOrTernaryLayerAndOnlySelZCol = (!(IS_LAYER_BITS_ANY_3D(m_dwLayerBits) || PCD_LAYER_TRI == m_dwLayerBits)) 
														&& has_only_one_column_type_selected(m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_Z);
				bool bIsPolarLayerAndOnlySelYCol = (PCD_LAYER_POLAR == m_dwLayerBits) 
												&& has_only_one_column_type_selected(m_vnColTypeSelected, OKDATAOBJ_DESIGNATION_Y);
				bool bIsNotContourPlot = vnWksXYZ2DLayerPlotIDs.Find(vuIndices, m_nPlotIDToCheck) <= 0;

				if( ( bIsNot3DOrTernaryLayerAndOnlySelZCol || bIsPolarLayerAndOnlySelYCol )
					&& bIsNotContourPlot )
				///-----End SUPPORT_ADD_LINE_SCATTER_TO_POLAR_CONTOUR_LAYER
				{
					/// Iris 2/14/2011 ORG-2100-P10 PLOT_XYZ_TO_2D_GRAPH_AS_COUNTOUR
					//m_bEnablePlot = false;
					//m_strPlottingMsg = MSG_XY_PLOT_DESIGN_PATTERN_MISMATCHING;
					m_bIsPlotIDNotMatch = true;
					///End PLOT_XYZ_TO_2D_GRAPH_AS_COUNTOUR
				}
			}
		}
		/// Iris 1/18/2011 SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH
		else if( m_nPageType == EXIST_DATA )
		{
			/// Iris 1/30/2011 ORG-2100-P4 ALLOW_PLOT_HIST_FROM_MATRIX_EX			
			//if( is_matrix_plot_id(m_nPlotIDToCheck) )
			if( !_is_wks_2d_plot_id(m_nPlotIDToCheck) )
			///End ALLOW_PLOT_HIST_FROM_MATRIX_EX
				m_bIsPlotIDNotMatch = true;
		}
		///End SUPPORT_PLOT_XYZ_TO_MAT_GRAPH_AND_MATRIX_TO_XYZ_GRAPH
		
		if( !m_bEnablePlot )
			m_vnPlotIDs.RemoveAll();
	}
	///End IMPROVE_PLOTTYPE_CHECK
	*/

	GetPlotIDsHelperBase *pGetPlotIDsBase = _create_get_plot_ids_helper(m_nPageType, m_dwLayerBits, m_bVirtualMatirx, m_vnColTypeSelected);
	if( NULL != pGetPlotIDsBase )
	{	
		m_errInfo = pGetPlotIDsBase->GetPlotIDs(m_vnPlotIDs);
		if( Err_NoError == m_errInfo)
		{
			///Sophy 6/26/2012 ORG-5475-P6 3D_XYZ_SURFACE_BAR_SHOULD_BE_COMPATIBLE_WITH_3D_SCATTER
			//m_bIsPlotIDNotMatch = pGetPlotIDsBase->IsMatch(m_nPlotIDToCheck);
			m_bIsPlotIDNotMatch = !pGetPlotIDsBase->IsMatch(m_nPlotIDToCheck);
			///end 3D_XYZ_SURFACE_BAR_SHOULD_BE_COMPATIBLE_WITH_3D_SCATTER
		}
		delete pGetPlotIDsBase;
		pGetPlotIDsBase = NULL;
	}
	///-----End SHOLUD_NOT_ALLOW_ADD_2D_PLOT_TO_3D_LAYER


	if( m_vnPlotIDs.GetSize() > 0 )
	{
		ConvertPlotIDToPlotTypeStr();
		return true;
	}	
	return false;
	
}

///-----Kit 03/02/2011 ORG-1837-S4 BIMMAP_BTN_NOT_UPDATE_ON_INIT_DLG
/*
bool SimplePlotTypeList::GetBmpSrcIDAndBmpIndex( int nPlotID , int &nBmpSrcID, int &nBmpIndex )
{	
	/// Iris 12/31/2010 ORG-1879 ADD_AUTO_PLOTTYPE_IN_PLOTTYPE_BMP_BUTTON
	if( nPlotID == PLOT_ID_FOR_AUTO )
	{
		nBmpSrcID = IDB_AUTO_PLOT_TYPE;
		nBmpIndex = 0;
		return true;
	}
	///End ADD_AUTO_PLOTTYPE_IN_PLOTTYPE_BMP_BUTTON
	
	const vector<uint> vuPlotIDs = {
		// for XY
		IDM_PLOT_LINE, IDM_PLOT_SCATTER, IDM_PLOT_LINESYMB, IDM_PLOT_COLUMN, IDM_PLOT_AREA,
		// for XYZ
		IDM_PLOT_3D_LINE, IDM_PLOT_TRI_CONTOUR,			
		// for matrix
		IDM_PLOT_SURFACE_BARS, IDM_PLOT_SURFACE_COLORFILL, IDM_PLOT_SURFACE_COLORMAP, IDM_PLOT_SURFACE_WIREFRAME, IDM_PLOT_3D_SCATTER_MATRIX, IDM_PLOT_CONTOUR, IDM_PLOT_MATRIX_IMAGE
		};
		
	const vector<uint> vuBMPIDs = {
		IDB_2D_PLOT, IDB_2D_PLOT, IDB_2D_PLOT, IDB_2D_PLOT, IDB_2D_PLOT, // for XY
		IDB_3D_PLOT, IDB_3D_PLOT, // for XYZ
		IDB_3D_PLOT, IDB_3D_PLOT, IDB_3D_PLOT, IDB_3D_PLOT, IDB_3D_PLOT, IDB_3D_PLOT, IDB_3D_PLOT // for matrix
		};
	
	const vector<uint> vuIndexInBMP = {
		0, 1, 2, 4, 7, // for XY
		0, 22, // for XYZ
		19, 11, 14, 20, 0, 22, 27 // for matrix
		};

	vector<uint> vecIndex;
	if( vuPlotIDs.Find(vecIndex, nPlotID) < 0 || vecIndex.GetSize() <= 0 )
		return error_report("fail to find bitmap id for this plot type in OnClickPlotTypeDropDownButton");	
	
	int index = vecIndex[0];
	nBmpSrcID = vuBMPIDs[index];
	nBmpIndex = vuIndexInBMP[index];

	return true;	
}
*/
///-----End BIMMAP_BTN_NOT_UPDATE_ON_INIT_DLG

/************************************************************************/
/* ---PlotTypeListMenu		                                     		*/
/************************************************************************/
///-----Kit 01/07/2011 ORG-1826-S14 ADD_CHECKED_STATE_IN_PLOT_TYPE_DROP_DOWN_MENU
//PlotTypeListMenu::PlotTypeListMenu(PlotTypeListBase* pPlotTypeListBase)
PlotTypeListMenu::PlotTypeListMenu(PlotTypeListBase* pPlotTypeListBase, int nSelPlotID)
///-----
{
	m_bIsSelected = false;
	ASSERT(pPlotTypeListBase);
	if( NULL == pPlotTypeListBase )
		return;
	m_pPlotTypeListBase = pPlotTypeListBase;
	
	vector<string> vs;
	int nNum = m_pPlotTypeListBase->GetPlotTypesListName(vs);	
	
	///-----Kit 01/07/2011 ORG-1826-S14 ADD_CHECKED_STATE_IN_PLOT_TYPE_DROP_DOWN_MENU
	vector<int> vnPlotIDs;
	m_pPlotTypeListBase->GetPlotIDs( vnPlotIDs );
	vnPlotIDs.Add( -10 );		// corresponding to Menu Spearator
	vnPlotIDs.Add( PLOT_ID_FOR_AUTO );
	vector<uint> vuIndex;
	vnPlotIDs.Find( vuIndex, nSelPlotID );
	///-----
	for( int ii = 0; ii < nNum; ii++ )
	{
		///-----Kit 01/07/2011 ORG-1826-S14 ADD_CHECKED_STATE_IN_PLOT_TYPE_DROP_DOWN_MENU
		uint uFlag = MF_STRING;
		if( !CHECK_VECTOR_IS_EMPTY(vuIndex) && vuIndex[0] == ii )
			uFlag |= MF_CHECKED;
		///-----
		Add(vs[ii], OnMenuItem, uFlag);
	}	
	/// Iris 12/31/2010 ORG-1879 ADD_AUTO_PLOTTYPE_IN_PLOTTYPE_BMP_BUTTON
	if( nNum > 0 )
		Add("", EmptyFunc, MF_SEPARATOR);

	///-----Kit 01/07/2011 ORG-1826-S14 ADD_CHECKED_STATE_IN_PLOT_TYPE_DROP_DOWN_MENU
	uint uFlag = MF_STRING;
	if( !CHECK_VECTOR_IS_EMPTY(vuIndex) && nSelPlotID == PLOT_ID_FOR_AUTO )
		uFlag |= MF_CHECKED;
	///-----
	Add(STR_AUTO, OnMenuItem, uFlag); 
	///End ADD_AUTO_PLOTTYPE_IN_PLOTTYPE_BMP_BUTTON
}

bool	PlotTypeListMenu::GetSel(int& nIndex) 
{
	int nAutoItemCount = 1;
	if( m_pPlotTypeListBase->GetCount() > 0 )
		nAutoItemCount++; // for separator menu
	
 	/// Iris 12/31/2010 ORG-1879 ADD_AUTO_PLOTTYPE_IN_PLOTTYPE_BMP_BUTTON
	//if( !m_bIsSelected || m_nIndex < 0 || m_nIndex >= m_pPlotTypeListBase->GetCount() )
	if( !m_bIsSelected || m_nIndex < 0 || m_nIndex >= m_pPlotTypeListBase->GetCount() + nAutoItemCount ) // nAutoItemCount for separator menu and auto menu 
	///End ADD_AUTO_PLOTTYPE_IN_PLOTTYPE_BMP_BUTTON
		return false;
	
	nIndex = m_nIndex;
	m_bIsSelected = false;
	return true;
}

/************************************************************************/
/* SetGridToolTipHelperBase                                             */
/************************************************************************/
bool SetGridToolTipHelperBase::SetGridToolTip()
{
	int nRow, nCol;
	m_pGridList->GetMouseCell(nRow, nCol);

	string strToopTip = "";
	if( nRow < 0 )
		return false;

	if( nRow < m_pGridList->GetRowOffset() )
	{
		getRowHeaderToolTip(strToopTip);
	}
	else if( nRow < m_pGridList->GetRows() )
	{
		GetRowToolTip(nRow, strToopTip);
	}

	m_pGridList->SetToolTipsText(strToopTip);
	return true;
}

bool SetGridToolTipHelperBase::getRowHeaderToolTip(string &strToolTip)
{
	strToolTip = STR_RIGHT_CLICK_ROW_HEADER_TOOL_TIP;
	return true;
}

/************************************************************************/
/* SetDatasetListToolTipHelper                                          */
/************************************************************************/
// virtual
bool SetDatasetListToolTipHelper::GetRowToolTip(int nRow, string &strToolTip)
{
	DatasetList *pDatasetList = (DatasetList*)m_pGridList;
	if( NULL == pDatasetList )
	{	
		ASSERT(pDatasetList);
		return false;
	}
	
	strToolTip = pDatasetList->GetCell(flexcpText, nRow, pDatasetList->GetColPos(COL_BOOK_SHEET_COL) );
	return true;
}
