/*------------------------------------------------------------------------------*
 * File Name: DataDisplaySettings.cpp											*
 * Creation: Folger																*
 * Purpose: OriginC Source C++ file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 6/16/10 ORG-316-P3 NO_LAST_USED_IF_NEW_INSTANCE 						*
 *	Folger 06/17/10 ORG-316-P2 APPLY_FAILED_TO_ENABLE_AFTER_LOAD_THEME			*
 *	Folger 06/21/10 ORG-316-P4 SUPPORT_DEFAULT_THEME_IN_DATA_INFO_SETTINGS		*
 *	Folger 06/21/10 ORG-332 NEW_DATA_INFO_SUPPORT_MATRIX_BASED_PLOT				*
 *	Folger 06/23/10 ORG-372-S4 ADD_COLUMN_INDEX_TO_GRID_HEADING					*
 *	Folger 06/23/10 ORG-372-S2 ADD_SEPARATOR_COLUMN_TYPE						*
 *	Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS		*
 *	Folger 06/23/10 ORG-316-P5 DEFAULT_THEME_FAILED_TO_LOAD_WHEN_OPEN_DATA_INFO_SETTINGS
 *	Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO				*
 *	Folger 07/02/10 ORG-436-S1 TOOLTIP_NEEDED_FOR_DATA_INFO_RWO_SELECTION_LIST	*
 *	Folger 07/02/10 ORG-436-S4 DATA_INFO_ROW_SEPARATOR_SUPPORT					*
 *	Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO				*
 *	Folger 07/07/10 ORG-502-S2 SHOW_LN_ONLY_IN_COLUMN_HEADER_ROW_FOR_HIGHLIGHT_CELLS
 *	Folger 07/07/10 ORG-502-S3 SUPPORT_CUSTOMIZE_COLUMN_HEADER_BACKGROUND_COLOR	*
 *	Folger 08/06/10 ORG-502-P5 CONTEXT_MENU_OF_ADD_DELETE_COL_SHOULD_ONLY_SHOW_IN_GRID_TABLE
 *	Folger 08/10/10 ORG-502-S4 BETTER_BK_COLOR_BETWEEN_DIALOG_AND_CONTROLS		*
 *	Folger 09/21/2010 ORG-332-P1 DATA_INFO_FAILED_TO_SHOW_Z_BY_DEFAULT_FOR_MATRIX_RELATED_PLOT
 *	Folger 10/25/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE				*
 *	Folger 09/15/2011 ORG-3718-P3 PROPER_THEME_NAME_HANDLONG_IN_DATA_DISPLAY_SETTINGS
 *	Jasmine 02/15/2012 ORG-5062-S1 ADD_MAX_FONT_SIZE_CTRL_TO_HOLD_APPROPRIATE_SIZE
 *	Iris 2/22/2012 ORG-5108-S1 IMPROVE_DATA_INFO_FOR_COLUMNS_TAB				*
 *  Iris 2/22/2012 ORG-5108-S2 CHANGE_DEFAULT_OPTION_AS_LN_FOR_COLUMN_LABELS	*
 *  Iris 2/22/2012 ORG-5108-S3 ADD_AUTO_IN_COLUMN_WIDTH							* 
 *	Jasmine 02/21/2012 ORG-985 ADD_ALIGNMENT_SETTING_TO_DATA_INFO				*
 *  Iris 2/22/2012 ORG-5108-S1 IMPROVE_DATA_INFO_FOR_COLUMNS_TAB				*
 *  Iris 2/22/2012 ORG-5108-S2 CHANGE_DEFAULT_OPTION_AS_LN_FOR_COLUMN_LABELS	*
 *  Iris 2/22/2012 ORG-5108-S3 ADD_AUTO_IN_COLUMN_WIDTH							*
 *  Iris 2/22/2012 ORG-5019-S1 RENAME_ROWS_TAB									*
 *  Iris 2/22/2012 ORG-5019-S2 IMPROVE_COORDINATES_BUTTON						*
 *	Jasmine 02/23/2012 ORG-5062-S2 SET_A_SMALLER_DEFAULT_FONT_SIZE			* 
 *  Iris 2/24/2012 ORG-5109-S3 SUPPORT_MOVE_UP_DOWN_MULTIPLE_ROWS				*
 *  Iris 2/24/2012 ORG-5124-S2 SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST		*
 *	Folger 02/29/2012 ORG-5108-S3 SUPPORT_AUTO_COLUMN_WIDTH_IN_DATA_INFO		*
 *  Iris 2/24/2012 ORG-5124-S2 SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST		*
 *	Jasmine 02/29/2012 ORG-985-S1 HIDE_ALIGN_SETTINGS_WHEN_USELESS				*
 *	Jasmine 02/28/2012 ORG-5121-S3 USE_DEAULT_SETTINGS_FOR_NEW_GRAPH			*
 *  Iris 3/01/2012 ORG-5109-S2 DISABLE_AVAILABLE_DATA_LIST_ROWS_IF_ALREADY_ADDED* 
 *  Iris 3/01/2012 ORG-5109-P1 FIX_CELL_IS_EDITABLE_IN_BOTH_GRIDS_OF_ROWS_TAB	*
 *  Iris 3/01/2012 ORG-5109-P3 FIX_DATA_SELECTED_GRID_EMPTY_ROW					*
 * 	Iris 3/01/2012 ORG-5109-P4 TO_PREVENT_HIDE_THE_LAST_COL						*
 *  Iris 3/01/2012 ORG-5194-P1 FIX_TREEEDITOR_VALUE_CHANGE_BROKEN				*
 *	Folger 03/02/2012 ORG-5199-P1 DATA_INFO_WINDOW_SHOULD_UPDATE_LAST_POINT_IF_THERE_IS_NO_DATA_READER
 *  Iris 3/02/2012 ORG-5109-P5 FIX_COORDINATES_BUTTON_MESS_UP					*
 *  Iris 3/12/2012 ORG-5109-P6 FAIL_TO_DEL_ALL_ROWS_IN_SELECTED_DATA_LIST 		*
 *	Jasmine 03/09/2012 ORG-5121-S6 SAVE_CHANGE_IN_GRAPH_BY_DEFAULT				*
 *	Jasmine 03/12/2012 ORG-5121-S6 SAVE_CHANGE_TO_OBJ_IF_ALREADY_HAVE_OBJ_THEME	*
 *	Jasmine 03/13/2012 ORG-5121-S5-1 ADD_INDEX_OPTION_FOR_A_SHORTTER_REPORT_TITLE*
 *	Jasmine 03/13/2012 ORG-5121-S5-2 ADD_TITLE_OPTION_FOR_WIN_TITLE				*
 *	Folger 03/14/2012 ORG-5278-P1 AUTO_CORRECT_COLUMN_WIDTH_AND_FONG_SCALER_IN_DATAINFO_SETTINGS
 *	Folger 03/28/2012 ORG-5108-P1 FAILED_TO_SET_AUTO_COL_WIDTH_IN_DATAINFO		*
 *	Folger 03/28/2012 ORG-5383-P1 THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
 *	Folger 08/06/2012 ORG-6390-P1 FAILED_TO_SHOW_Z_ANNOTATION_INFO_FOR_3D_BAR_PLOT
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include "DialogEx.h"
#define  BASE_WINDOW		ResizeDialog
#include "DynaDlg.h"

#include "WksColLabels.h"
#include <Array.h>

///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
#include "DataInfoCursor.h"
///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO

#define		STR_DIALOG_NAME			"DataInfoSettingsDlg"

enum
{
	LISTROW_INFO_FROM			 = 1,
	LISTROW_CONTENT,
	LISTROW_COLUMN_WIDTH,
	LISTROW_FONT_SIZE,
	LISTROW_COLUMN_ALIGNMENT,			///Jasmine 02/21/2012 ORG-985 ADD_ALIGNMENT_SETTING_TO_DATA_INFO

	/// add items before this
	LISTROW_TOTAL,
};

#define		NUM_COL_AUTO_WIDTH		-1 /// Iris 2/22/2012 ORG-5108-S3 ADD_AUTO_IN_COLUMN_WIDTH

#define		STR_SHORT_NAME			"Short Name"

///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
#define		STR_RAW_DATA			_L("Data (Reader)")
#define		STR_CURSOR1				_L("Data (Cursor1)")
#define		STR_CURSOR2				_L("Data (Cursor2)")
#define		STR_C1DR				_L("Relative (Reader - Cursor1)")
#define		STR_C1C2				_L("Relative (Cursor2 - Cursor1)")

#define		ITEM_SEPARATOR			'|'
///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO

/// Iris 2/22/2012 ORG-5108-S1 IMPROVE_DATA_INFO_FOR_COLUMNS_TAB
//#define		STR_INFO_FROM			"Separator|Column Labels|Data Group|Cell in"
#define		STR_INFO_FROM			"Separator|Labels|Value|Single Cell"
///End IMPROVE_DATA_INFO_FOR_COLUMNS_TAB
#define		STR_INFO_FROM_L			_L(STR_INFO_FROM)

/// Iris 2/22/2012 ORG-5019-S2 IMPROVE_COORDINATES_BUTTON
static uint l_nSrcBtnIDs[] = {
					IDC_BTN_DATA_INDEX,
					IDC_BTN_DATA_X,
					IDC_BTN_DATA_Y,
					IDC_BTN_DATA_Z,
					IDC_BTN_DATA_XDATA,
					IDC_BTN_DATA_YDATA,
					IDC_BTN_DATA_ZDATA,					
					IDC_BTN_DATA_SEPRATOR,					
					0
				}; 				
#define STR_SRC_BTN_TIPS _L("Row Index|X Coordinate|Y Coordinate|Z Coordinate|Source X Data|Source Y Data|Source Z Data|Blank Space")
///End IMPROVE_COORDINATES_BUTTON
///Jasmine 02/21/2012 ORG-985 ADD_ALIGNMENT_SETTING_TO_DATA_INFO
#define		STR_COL_ALIGN_LIST		"Auto|Left|Center|Right"
#define		STR_COL_ALIGN_LIST_L	_L(STR_COL_ALIGN_LIST)
///End ADD_ALIGNMENT_SETTING_TO_DATA_INFO

/// Iris 3/01/2012 ORG-5194-P1 FIX_TREEEDITOR_VALUE_CHANGE_BROKEN
//#define 	WM_USER_SEL_DATA_LIST_DEL_ROW_MSG 		(WM_USER + 1001) /// Iris 2/29/2012 ORG-5108-S2 DISABLE_BUTTON_IF_ALREADY_ADDED
#define 	WM_USER_SEL_DATA_LIST_DEL_ROW_MSG 		(WM_USER + 10001) 
///End FIX_TREEEDITOR_VALUE_CHANGE_BROKEN

///Jasmine 03/13/2012 ORG-5121-S5-2 ADD_TITLE_OPTION_FOR_WIN_TITLE
#define		GUI_WINTITLE_TO_DISTITLE(_NVAL)				(_NVAL - 1)
#define		DISTITLE_TO_GUI_WINTITLE(_NVAL)				(_NVAL + 1)
///End ADD_TITLE_OPTION_FOR_WIN_TITLE

class DataInfoArrangementList : public GridListControl
{
public:
	DataInfoArrangementList()
	{
		///------ Folger 06/23/10 ORG-372-S2 ADD_SEPARATOR_COLUMN_TYPE
		//m_strInfoFrom = "Column Labels|Data Group|Cell in";
		m_strInfoFrom = STR_INFO_FROM;
		///------ End ADD_SEPARATOR_COLUMN_TYPE
	}
	~DataInfoArrangementList()
	{
	}
	
	void Init(int nID, Dialog& dlg)
	{		
		GridListControl::Init(nID, dlg);
		ClearAll();
		
		SetRows(LISTROW_TOTAL, false);
		SetCols(1);
		m_flx.FixedCols = 1;
		m_flx.FixedRows = LISTROW_INFO_FROM;
		
		SetExplorerBar(flexExMove);
		SetSelection(flexSelectionFree);
		SetExtendLastCol(false);
		SetEditable(flexEDKbdMouse);		
		
		SetupRowHeading();
		
		InitContents();
	}
	
	/// virtual
	void	ClearAll()
	{
		m_flx.Cols = m_flx.FixedCols;
	}
	
	DataPlot*		DataPlotPtr()
	{
		return &m_dp;
	}
	
	vector<string>&		DefaultColumnValues()
	{
		if ( 0 == m_vsDefaultColumnValues.GetSize() )
		{
			///Jasmine 02/21/2012 ORG-985 ADD_ALIGNMENT_SETTING_TO_DATA_INFO
			/*
			m_vsDefaultColumnValues.Add(GetInfoFromStr(ConvertHeaderIndex(DIS_INFO_FROM_RAW_DATA, FALSE)));
			///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
			//m_vsDefaultColumnValues.Add("");
			m_vsDefaultColumnValues.Add(STR_RAW_DATA);
			///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
			m_vsDefaultColumnValues.Add("10");
			m_vsDefaultColumnValues.Add("1");
			*/
			m_vsDefaultColumnValues.SetSize(LISTROW_TOTAL-1);
			m_vsDefaultColumnValues[LISTROW_INFO_FROM-1] 		= GetInfoFromStr( ConvertHeaderIndex(DIS_INFO_FROM_RAW_DATA, FALSE) );
			m_vsDefaultColumnValues[LISTROW_CONTENT-1] 			= STR_RAW_DATA;
			m_vsDefaultColumnValues[LISTROW_COLUMN_WIDTH-1]		= "10";
			m_vsDefaultColumnValues[LISTROW_FONT_SIZE-1] 		= "1";
			m_vsDefaultColumnValues[LISTROW_COLUMN_ALIGNMENT-1]	= GetColAlignStr(DIS_COL_ALIGN_AUTO);
			///End ADD_ALIGNMENT_SETTING_TO_DATA_INFO
		}
		
		return m_vsDefaultColumnValues;
	}
	
	/// Iris 2/22/2012 ORG-5108-S2 CHANGE_DEFAULT_OPTION_AS_LN_FOR_COLUMN_LABELS
	int 	GetDefaultSourceForLabelType() // only for DIS_INFO_FROM_DEADER type column
	{
		///------ Folger 08/06/2012 ORG-6390-P1 FAILED_TO_SHOW_Z_ANNOTATION_INFO_FOR_3D_BAR_PLOT
		string strMainDatasetName = GetMainDatasetName();
		if ( okutil_is_virtual_matrix(strMainDatasetName) )
		{
			return okutil_get_virtual_matrix_long_name(strMainDatasetName).IsEmpty() ? RCLT_SHORT_NAME : RCLT_LONG_NAME;
		}
		///------ End FAILED_TO_SHOW_Z_ANNOTATION_INFO_FOR_3D_BAR_PLOT

		Datasheet		ds;
		DataRange		dr;
		if ( !GetDatasheet(ds, &dr) || !ds )
			return RCLT_SHORT_NAME;		
		
		int nPageType = ds.GetPage().GetType();		
		for(int nRange = 0; nRange < dr.GetNumRanges(); ++nRange)
		{				
			int c1, c2;
			Datasheet dsTmp;
			if( dr.GetRange(dsTmp, c1, c2, nRange) )
			{
				ASSERT(c1 == c2); // only one matrixobject or column in one sub range
				if( EXIST_MATRIX == nPageType )
				{
					MatrixLayer ml(ds);
					MatrixObject mo(ml, c1);
					if( mo && !mo.GetLongName().IsEmpty() )
						return RCLT_LONG_NAME;
				}
				else
				{
					Worksheet wks(ds);
					Column col(wks, c1);
					if( col && !col.GetLongName().IsEmpty() )
						return RCLT_LONG_NAME;
				}
			}
		}			
		return RCLT_SHORT_NAME;
	}
	///End CHANGE_DEFAULT_OPTION_AS_LN_FOR_COLUMN_LABELS
	
	int		GetTotalRowsHeight()
	{
		return YTwipsToPixels(GetRowHeight(0) * (LISTROW_TOTAL + 1.2));
	}
	
	void	AddColumn(vector<string>& vs)
	{
		int		nCol = GetCols();
		AddCol();

		SetColAlignment(nCol, flexAlignCenterCenter);
		SetColWidth(nCol, 1500);
		
		///------ Folger 06/23/10 ORG-372-S4 ADD_COLUMN_INDEX_TO_GRID_HEADING
		SetCell(0, nCol, (string)nCol);
		///------ End ADD_COLUMN_INDEX_TO_GRID_HEADING
		SetCells(vs, nCol - GetColOffset());
	}

	///------ Folger 06/23/10 ORG-372-S4 ADD_COLUMN_INDEX_TO_GRID_HEADING
	void	ResetColHeading()
	{
		for ( int col=GetColOffset(); col<GetCols(); ++col )
		{
			SetCell(0, col, (string)col);
		}
	}
	///------ End ADD_COLUMN_INDEX_TO_GRID_HEADING

	void	AddDefaultColumn()
	{
		AddColumn(DefaultColumnValues());
	}

	string	GetColName(int nCol)
	{
		string	str;
		str.Format("%s%d", STR_DATA_DISPLAY_SETTINGS_COLUMN_INFO_TAGNAME_PREFIX, nCol);
		return str;
	}
	
	void	OnBeforeEdit(long nRow, long nCol, BOOL* pCancel)
	{
		string	str;
		switch ( nRow )
		{
		case LISTROW_INFO_FROM:
			str = GetLocalized(m_strInfoFrom);
			break;

		case LISTROW_CONTENT:
			str = GetContent(nCol);
			break;

		case LISTROW_COLUMN_WIDTH:
			str = "|5|10|15|20|30|40|50";
			///------ Folger 02/29/2012 ORG-5108-S3 SUPPORT_AUTO_COLUMN_WIDTH_IN_DATA_INFO
			if ( IsAutoWidthSupported(nCol) )
			{
				str += "|" + STR_AUTO; /// Iris 2/22/2012 ORG-5108-S3 ADD_AUTO_IN_COLUMN_WIDTH
			}
			///------ End SUPPORT_AUTO_COLUMN_WIDTH_IN_DATA_INFO
			m_strOldWidth = GetCell(nRow, nCol);	///------ Folger 03/14/2012 ORG-5278-P1 AUTO_CORRECT_COLUMN_WIDTH_AND_FONG_SCALER_IN_DATAINFO_SETTINGS
			break;

		case LISTROW_FONT_SIZE:
			str = "|0.5|1|1.5|2|2.5|3";
			m_strOldFontScaler = GetCell(nRow, nCol);	///------ Folger 03/14/2012 ORG-5278-P1 AUTO_CORRECT_COLUMN_WIDTH_AND_FONG_SCALER_IN_DATAINFO_SETTINGS
			break;
			
		///Jasmine 02/21/2012 ORG-985 ADD_ALIGNMENT_SETTING_TO_DATA_INFO
		case LISTROW_COLUMN_ALIGNMENT:
			str = GetAlignList(nCol);//str = STR_COL_ALIGN_LIST_L;	///Jasmine 02/29/2012 ORG-985-S1 HIDE_ALIGN_SETTINGS_WHEN_USELESS
			break;
		///End ADD_ALIGNMENT_SETTING_TO_DATA_INFO
		
		default:
			break;
		}

		if ( str.Find(ITEM_SEPARATOR) >= 0 )
		{
			m_flx.ComboList = str;
		}
		else
		{
			string	strEmpty;
			m_flx.ComboList = strEmpty;
			*pCancel = TRUE;
		}
	}
	
	void	OnAfterEdit(int nRow, int nCol)
	{
		///------ Folger 03/14/2012 ORG-5278-P1 AUTO_CORRECT_COLUMN_WIDTH_AND_FONG_SCALER_IN_DATAINFO_SETTINGS
		switch ( nRow )
		{
		case LISTROW_COLUMN_WIDTH:
			{
				int	nVal = 0;
				///------ Folger 03/28/2012 ORG-5108-P1 FAILED_TO_SET_AUTO_COL_WIDTH_IN_DATAINFO
				//if ( !is_str_numeric_integer(GetCell(nRow, nCol), &nVal) || nVal <= 0 )
				if ( !(is_str_numeric_integer(GetCell(nRow, nCol), &nVal) && nVal > 0 || IsAutoWidthSupported(nCol) && GetCell(nRow, nCol).Compare(STR_AUTO) == 0) )
				///------ End FAILED_TO_SET_AUTO_COL_WIDTH_IN_DATAINFO
					SetCell(nRow, nCol, m_strOldWidth);
			}
			break;

		case LISTROW_FONT_SIZE:
			{
				double	rVal = 0;
				if ( !is_str_numeric(GetCell(nRow, nCol), &rVal) || rVal <= 0 )
					SetCell(nRow, nCol, m_strOldFontScaler);
			}
			break;
			
		default:
			break;		
		}
		///------ End AUTO_CORRECT_COLUMN_WIDTH_AND_FONG_SCALER_IN_DATAINFO_SETTINGS
	}

	void	OnEdit(int nRow, int nCol)
	{
		if ( LISTROW_INFO_FROM == nRow )
		{
			string		strContent = GetContent(nCol);
			/// Iris 3/01/2012 ORG-5018-S2 CHANGE_DEFAULT_OPTION_AS_LN_FOR_COLUMN_LABELS_MORE
			//SetCell(LISTROW_CONTENT, nCol, strContent.IsEmpty() ? "" : strContent.GetToken(0, ITEM_SEPARATOR));			
			string 	strCell;
			if( !strContent.IsEmpty() )
			{
				int		nInfoFrom = ConvertHeaderIndex(GetInfoFrom(nCol));
				if( DIS_INFO_FROM_DEADER == nInfoFrom )
				{
					int nDefaultLabel = GetDefaultSourceForLabelType();
					strCell = RCLT_SHORT_NAME == nDefaultLabel ? _L(STR_SHORT_NAME) : get_label_name_by_type(nDefaultLabel);
				}
				else
				{
					strCell = strContent.GetToken(0, ITEM_SEPARATOR);
				}
			}
			SetCell(LISTROW_CONTENT, nCol, strCell);
			///End CHANGE_DEFAULT_OPTION_AS_LN_FOR_COLUMN_LABELS_MORE
			
			///Jasmine 02/29/2012 ORG-985-S1 HIDE_ALIGN_SETTINGS_WHEN_USELESS
			string		strAlignList = GetAlignList(nCol);
			SetCell(LISTROW_COLUMN_ALIGNMENT, nCol, strAlignList.IsEmpty() ? "" : strAlignList.GetToken(DIS_COL_ALIGN_AUTO, ITEM_SEPARATOR));
			///End HIDE_ALIGN_SETTINGS_WHEN_USELESS
		}
	}

	string	GetRowContentForSaving(int nRow, int nCol)
	{
		string		str = GetCell(nRow, nCol);

		switch ( nRow )
		{
		case LISTROW_INFO_FROM:
			str.Format("%d", ConvertHeaderIndex(GetInfoFrom(nCol)));
			break;
			
		case LISTROW_CONTENT:
			switch ( ConvertHeaderIndex(GetInfoFrom(nCol)) )
			{
			case DIS_INFO_FROM_DEADER:
				{
					int		nType = -1;
					if ( compare_string_localization(str, STR_SHORT_NAME) )
					{
						nType = RCLT_SHORT_NAME;
					}
					else
					{
						Worksheet		wks;
						GetWorksheet(wks);
						nType = get_label_type_by_name(wks, str);
					}
					str.Format("%d", nType);
				}
				break;

			///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
			case DIS_INFO_FROM_RAW_DATA:
				str.Format("%d", ConvertDataGroupIndex(GetDataGroup(str)));
				break;
			///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO

			///------ Folger 06/23/10 ORG-372-S2 ADD_SEPARATOR_COLUMN_TYPE
			case DIS_INFO_FROM_SEPARATOR:
			///------ End ADD_SEPARATOR_COLUMN_TYPE
			case DIS_INFO_FROM_HIGHLIGHT_CELL:
				UpdateRangeStringForSaving(str);
				break;

			default:
				break;
			}
			break;
			
		///Jasmine 02/21/2012 ORG-985 ADD_ALIGNMENT_SETTING_TO_DATA_INFO
		case LISTROW_COLUMN_ALIGNMENT:	
			///Jasmine 02/29/2012 ORG-985-S1 HIDE_ALIGN_SETTINGS_WHEN_USELESS
			//str.Format( "%d", GetColAlign(str) );
			int nAlign = GetColAlign(str);
			if(nAlign >= 0)
				str.Format("%d", nAlign);
			///End HIDE_ALIGN_SETTINGS_WHEN_USELESS
			break;
		///End ADD_ALIGNMENT_SETTING_TO_DATA_INFO
		
		case LISTROW_COLUMN_WIDTH:
			/// Iris 2/22/2012 ORG-5108-S3 ADD_AUTO_IN_COLUMN_WIDTH
			if( 0 == str.CompareNoCase(STR_AUTO) )
			{
				str = (string)NUM_COL_AUTO_WIDTH;
			}			
			break;
			///End ADD_AUTO_IN_COLUMN_WIDTH
			
		case LISTROW_FONT_SIZE:
		default:
			break;
		}
		
		return str;
	}

	string	GetRowContentForLoading(LPCSTR lpcsz, int nRow)
	{
		static	int		l_nLastInfoFrom;
		string			str = lpcsz;

		switch ( nRow )
		{
		case LISTROW_INFO_FROM:
			l_nLastInfoFrom = atoi(lpcsz);
			str = GetInfoFromStr(ConvertHeaderIndex(l_nLastInfoFrom, FALSE));
			break;
			
		case LISTROW_CONTENT:
			switch ( l_nLastInfoFrom )
			{
			case DIS_INFO_FROM_DEADER:
				{
					int		nType = atoi(lpcsz);
					if ( RCLT_SHORT_NAME == nType )
					{
						str = _L(STR_SHORT_NAME);
					}
					else
					{
						Worksheet		wks;
						GetWorksheet(wks);
						str = get_label_name_by_type(nType, wks);
					}
				}
				break;

			///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
			case DIS_INFO_FROM_RAW_DATA:
				str = GetDataGroupStr(ConvertDataGroupIndex(atoi(lpcsz), FALSE));
				break;
			///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO

			///------ Folger 06/23/10 ORG-372-S2 ADD_SEPARATOR_COLUMN_TYPE
			case DIS_INFO_FROM_SEPARATOR:
			///------ End ADD_SEPARATOR_COLUMN_TYPE
			case DIS_INFO_FROM_HIGHLIGHT_CELL:
				UpdateRangeStringForLoading(str);
				break;

			default:
				break;
			}
			break;
			
		///Jasmine 02/21/2012 ORG-985 ADD_ALIGNMENT_SETTING_TO_DATA_INFO
		case LISTROW_COLUMN_ALIGNMENT:			
			if(lstrlen(lpcsz) > 0)	///Jasmine 02/29/2012 ORG-985-S1 HIDE_ALIGN_SETTINGS_WHEN_USELESS
			str = GetColAlignStr( atoi(lpcsz) );
			break;			
		///End ADD_ALIGNMENT_SETTING_TO_DATA_INFO
		
		case LISTROW_COLUMN_WIDTH:
			/// Iris 2/22/2012 ORG-5108-S3 ADD_AUTO_IN_COLUMN_WIDTH
			int nVal = atoi(str);
			if( NUM_COL_AUTO_WIDTH == nVal )
				str = STR_AUTO;
			break;
			///End ADD_AUTO_IN_COLUMN_WIDTH
			
		case LISTROW_FONT_SIZE:
		default:
			break;
		}
		
		return str;
	}

	BOOL	GetWorksheet(Worksheet& wks, DataRange* pdr = NULL)
	{
		Datasheet	ds;
		if ( !GetDatasheet(ds, pdr) )
			return FALSE;

		wks = ds;
		return TRUE;
	}

	///------ Folger 06/21/10 ORG-332 NEW_DATA_INFO_SUPPORT_MATRIX_BASED_PLOT
	BOOL	GetMatrixsheet(MatrixLayer& ml, DataRange* pdr = NULL)
	{
		Datasheet	ds;
		if ( !GetDatasheet(ds, pdr) )
			return FALSE;
		
		ml = ds;
		return TRUE;
	}

	///------ Folger 08/06/2012 ORG-6390-P1 FAILED_TO_SHOW_Z_ANNOTATION_INFO_FOR_3D_BAR_PLOT
	string	GetMainDatasetName()
	{
		if ( !DataPlotPtr()->IsValid() )
			return "";

		return DataPlotPtr()->GetDatasetName();
	}
	///------ End FAILED_TO_SHOW_Z_ANNOTATION_INFO_FOR_3D_BAR_PLOT
	
	BOOL	GetDatasheet(Datasheet& ds, DataRange* pdr = NULL)
	{
		if ( !DataPlotPtr()->IsValid() )
			return FALSE;
		
		DataRange		dr;
		if ( !DataPlotPtr()->GetDataRange(dr) )
			return FALSE;
		
		if ( pdr )
			*pdr = dr;
		
		int				c1, c2;
		return dr.GetRange(ds, c1, c2) && ds;
	}
	///------ End NEW_DATA_INFO_SUPPORT_MATRIX_BASED_PLOT
	
	void	UpdateRangeStringForSaving(string& str)
	{
		if ( str.IsEmpty() )
			return;
		
		Worksheet		wks;
		if ( GetWorksheet(wks) && wks )
		{
			StringArray		arrObjects;
			str.GetTokens(arrObjects, ITEM_SEPARATOR);
						
			StringArray		arrIndices;
			for ( int ii=0; ii<arrObjects.GetSize(); ++ii )
			{
				string	str = arrObjects[ii];
				int		nCol;
				okutil_check_convert_LT_col(&str, &nCol);
				Column	col = wks.Columns(str);
				if ( col )
					arrIndices.Add((string)col.GetIndex());
			}

			str.SetTokens(arrIndices, ITEM_SEPARATOR);
		}
		else
		{
			str.Empty();
		}
	}
	
	void	UpdateRangeStringForLoading(string& str)
	{
		if ( str.IsEmpty() )
			return;
		
		Worksheet		wks;
		if ( GetWorksheet(wks) && wks )
		{
			StringArray		arrIndices;
			str.GetTokens(arrIndices, ITEM_SEPARATOR);
			
			StringArray		arr;
			for ( int ii=0; ii<arrIndices.GetSize(); ++ii )
			{
				Column		col = wks.Columns(atoi(arrIndices[ii]));
				if ( col )
				{
					string	str;
					col.GetRangeString(str, NTYPE_FOR_RANGE);
					string	strBook, strSheet, strObject;
					okutil_parse_complete_range_string(str, &strBook, &strSheet, &strObject);
					arr.Add(strObject);
				}
			}
			
			okutil_create_complex_generic_range_string(&str, &arr);
		}		
		else
		{
			str.Empty();
		}
	}

	int		ConvertHeaderIndex(int nIndex, BOOL bSaving = TRUE)
	{
		if ( nIndex < 0 )
			return nIndex;

		if ( m_vnHeaderWks.GetSize() == 0 )
		{
			m_vnHeaderWks.Add(DIS_INFO_FROM_SEPARATOR);
			m_vnHeaderMat.Add(DIS_INFO_FROM_SEPARATOR);
			
			m_vnHeaderWks.Add(DIS_INFO_FROM_DEADER);
			m_vnHeaderMat.Add(DIS_INFO_FROM_DEADER);
			
			m_vnHeaderWks.Add(DIS_INFO_FROM_RAW_DATA);
			m_vnHeaderMat.Add(DIS_INFO_FROM_RAW_DATA);
			
			m_vnHeaderWks.Add(DIS_INFO_FROM_HIGHLIGHT_CELL);
		}
		
		MatrixLayer	ml;
		GetMatrixsheet(ml);
		vector<int>&	vn = ml.IsValid() ? m_vnHeaderMat : m_vnHeaderWks;
		
		return ConvertIndex(vn, nIndex, bSaving, -1);
	}

	int		ConvertDataGroupIndex(int nIndex, BOOL bSaving = TRUE)
	{
		if ( nIndex < 0 )
			return nIndex;

		return ConvertIndex(m_vnDataGroup, nIndex, bSaving, -1);
	}

	///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
	BOOL	GetColumnHeader(LPSTR szBuffer, int nCol, TreeNode& trSettings)
	{
		TreeNode	trColumns = trSettings.Columns;
		if ( !trColumns )
		{
			O_A_FAIL;
			return FALSE;
		}
		if ( !trColumns.ColHeader.nVal )
			return FALSE;
		
		if ( nCol >= trColumns.NumCols.nVal )
			return FALSE;

		TreeNode	trColumn = trColumns.GetNode(GetColName(nCol + 1));
		if ( !trColumn )
			return FALSE;

		GetRowContentForLoading(trColumn.InfoFrom.strVal, LISTROW_INFO_FROM);
		///------ Folger 07/07/10 ORG-502-S2 SHOW_LN_ONLY_IN_COLUMN_HEADER_ROW_FOR_HIGHLIGHT_CELLS
		string		str = GetRowContentForLoading(trColumn.Content.strVal, LISTROW_CONTENT);
		int			nIndex = -1;
		if ( (nIndex = str.Find("\"")) > 0 )	/// SN"LN"
		{
			str[str.GetLength()-1] = 0;
			lstrcpy(szBuffer, (LPCSTR)str + nIndex + 1);
		}
		else
		{
			lstrcpy(szBuffer, str);
		}
		///------ End SHOW_LN_ONLY_IN_COLUMN_HEADER_ROW_FOR_HIGHLIGHT_CELLS
		return TRUE;
	}
	///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
	BOOL			InitContents()
	{
		Datasheet		ds;
		DataRange		dr;
		if ( !GetDatasheet(ds, &dr) || !ds )
			return FALSE;

		///------ Folger 06/21/10 ORG-332 NEW_DATA_INFO_SUPPORT_MATRIX_BASED_PLOT
		MatrixLayer		ml(ds);
		if ( ml )
		{
			vector<string>		vs;
			m_strInfoFrom.GetTokens(vs, ITEM_SEPARATOR);
			vs.SetSize(DIS_INFO_FROM_HIGHLIGHT_CELL);		/// remove Highlight Cell
			m_strInfoFrom.SetTokens(vs, ITEM_SEPARATOR);
			
			vs.RemoveAll();
			vs.Add(STR_SHORT_NAME);
			vs.Add(get_label_name_by_type(RCLT_LONG_NAME));
			vs.Add(get_label_name_by_type(RCLT_UNIT));
			vs.Add(get_label_name_by_type(RCLT_COMMENT));
			m_strLabels.SetTokens(vs, ITEM_SEPARATOR);
		}
		else
			///------ End NEW_DATA_INFO_SUPPORT_MATRIX_BASED_PLOT
		{
			Worksheet	wks(ds);
			if ( !wks )
				return FALSE;
			
			WksCommonColLabelHelper		clHelper;
			clHelper.UpdateCommonColLabelInfo(wks);
			
			vector<string>		vs;
			clHelper.GetLabelNames(vs);
			vs.InsertAt(0, _L(STR_SHORT_NAME));
			m_strLabels.SetTokens(vs, ITEM_SEPARATOR);
			
// 			int		nX = -1, nY = -1, nZ = -1;
// 			for ( int ii=0; ii<dr.GetNumRanges(); ++ii )
// 			{
// 				int			r1, r2, c1, c2;
// 				string		strName;
// 				Datasheet	dsDummy;
// 				if ( dr.GetRange(ii, r1, c1, r2, c2, dsDummy, &strName) )
// 				{
// 					if ( strName.Compare("X") == 0 )
// 						nX = c1;
// 					if ( strName.Compare("Y") == 0 )
// 						nY = c1;
// 					if ( strName.Compare("Z") == 0 )
// 						nZ = c1;
// 				}
// 			}
			
			vs.RemoveAll();
			for ( int ii=0; ii<wks.GetNumCols(); ++ii )
			{
// 				if ( ii == nX || ii == nY || ii == nZ )
// 					continue;
				
				Column	col(wks, ii);
				string	str;
				col.GetRangeString(str, NTYPE_FOR_RANGE);
				string	strBook, strSheet, strObject;
				okutil_parse_complete_range_string(str, &strBook, &strSheet, &strObject);
				vs.Add(strObject);
			}		
			m_strHighlightCell.SetTokens(vs, ITEM_SEPARATOR);
		}
		
		///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
		InitDataGroup();
		///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
		
		return TRUE;
	}
	
private:
	///------ Folger 03/28/2012 ORG-5108-P1 FAILED_TO_SET_AUTO_COL_WIDTH_IN_DATAINFO
	bool IsAutoWidthSupported(int nCol)
	{
		return DIS_INFO_FROM_SEPARATOR != GetInfoFrom(nCol);
	}
	///------ End FAILED_TO_SET_AUTO_COL_WIDTH_IN_DATAINFO

	string			GetContent(int nCol)
	{
		string	str;

		int		nInfoFrom = ConvertHeaderIndex(GetInfoFrom(nCol));
		switch ( nInfoFrom )
		{
		case DIS_INFO_FROM_DEADER:
			str = m_strLabels;
			break;
			
		case DIS_INFO_FROM_RAW_DATA:
			///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
			//str.Empty();
			str = m_strDataGroup;
			///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
			break;
			
		case DIS_INFO_FROM_HIGHLIGHT_CELL:
			str = m_strHighlightCell;
			break;
			
		///------ Folger 06/23/10 ORG-372-S2 ADD_SEPARATOR_COLUMN_TYPE
		case DIS_INFO_FROM_SEPARATOR:
		///------ End ADD_SEPARATOR_COLUMN_TYPE
		default:
			break;
		}

		return str;
	}

	void			SetupRowHeading()
	{
		vector<string>	vs;
		/// Iris 2/22/2012 ORG-5108-S1 IMPROVE_DATA_INFO_FOR_COLUMNS_TAB
		//string			strRowHeadings = _L("Info From|Content|Column Width|Font Scaler");
		string			strRowHeadings = _L("Type|Source|Column Width|Font Scaler");
		///End IMPROVE_DATA_INFO_FOR_COLUMNS_TAB
		strRowHeadings	+= "|" + _L("Alignment");		///Jasmine 02/21/2012 ORG-985 ADD_ALIGNMENT_SETTING_TO_DATA_INFO
		strRowHeadings.GetTokens(vs, ITEM_SEPARATOR);
		for ( int ii=0; ii<vs.GetSize(); ++ii )
		{
			SetCell(ii + 1, 0, vs[ii]);
		}

		ResizeCols();
	}

	int		GetInfoFrom(int nCol)
	{
		return GetInfoFrom(GetCell(LISTROW_INFO_FROM, nCol));
	}

	int		GetInfoFrom(LPCSTR lpcsz)
	{
		if ( 0 == m_vsInfoFrom.GetSize() )
		{
			m_strInfoFrom.GetTokens(m_vsInfoFrom, ITEM_SEPARATOR);
		}
		
		return FindItem(m_vsInfoFrom, lpcsz);
	}

	string	GetInfoFromStr(int nIndex)
	{
		return GetLocalized(m_strInfoFrom.GetToken(nIndex, ITEM_SEPARATOR));
	}

	///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
	int		GetDataGroup(LPCSTR lpcsz)
	{
		return FindItem(m_vsDataGroup, lpcsz);
	}

	string	GetDataGroupStr(int nIndex)
	{
		if ( nIndex < 0 || nIndex >= m_vsDataGroup.GetSize() )
			nIndex = 0;
		return m_vsDataGroup[nIndex];
	}

	int		FindItem(const vector<string>& vs, LPCSTR lpcsz)
	{
		for ( int ii=0; ii<vs.GetSize(); ++ii )
		{
			if ( compare_string_localization(lpcsz, vs[ii]) )
				return ii;
		}
		
		return -1;
	}

	void	InitDataGroup()
	{
		int		nSize = DIC_C1C2 + 1;
		m_vsDataGroup.SetSize(nSize);
		m_vnDataGroup.SetSize(nSize);

		m_vsDataGroup[0] = STR_RAW_DATA;
		m_vnDataGroup[0] = DIC_READER;

		m_vsDataGroup[1] = STR_CURSOR1;
		m_vnDataGroup[1] = DIC_CURSOR1;
		
		m_vsDataGroup[2] = STR_CURSOR2;
		m_vnDataGroup[2] = DIC_CURSOR2;

		m_vsDataGroup[3] = STR_C1DR;
		m_vnDataGroup[3] = DIC_DRC1;

		m_vsDataGroup[4] = STR_C1C2;
		m_vnDataGroup[4] = DIC_C1C2;

		m_strDataGroup.SetTokens(m_vsDataGroup, ITEM_SEPARATOR);
	}

	int		ConvertIndex(const vector<int>& vn, int nIndex, BOOL bSaving, int nValueIfNotFound)
	{
		if ( bSaving )
		{
			ASSERT(nIndex < vn.GetSize());
			return vn[nIndex];
		}
		
		vector<uint>	vnIndices;
		int				nn = vn.Find(vnIndices, nIndex);
		return nn > 0 ? vnIndices[0] : nValueIfNotFound;
	}
	///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO

	///Jasmine 02/21/2012 ORG-985 ADD_ALIGNMENT_SETTING_TO_DATA_INFO
	///Jasmine 02/29/2012 ORG-985-S1 HIDE_ALIGN_SETTINGS_WHEN_USELESS
	string  GetAlignList(int nCol)
	{
		string 	str;
		
		int		nInfoFrom = ConvertHeaderIndex(GetInfoFrom(nCol));
		switch ( nInfoFrom )
		{
		case DIS_INFO_FROM_DEADER:
		case DIS_INFO_FROM_RAW_DATA:
			str = STR_COL_ALIGN_LIST_L;
			break;
			
		case DIS_INFO_FROM_HIGHLIGHT_CELL:
		case DIS_INFO_FROM_SEPARATOR:
		default:
			str = "";
			break;
		}
		
		return str;
	}
	///End HIDE_ALIGN_SETTINGS_WHEN_USELESS
	int		GetColAlign(LPCSTR lpcsz)
	{
		vector<string> vsColAlign;
		str_separate(STR_COL_ALIGN_LIST, STR_TOKEN_SEP, vsColAlign);		
		return FindItem(vsColAlign, lpcsz);
	}

	string	GetColAlignStr(int nIndex)
	{
		string strList = STR_COL_ALIGN_LIST_L;
		return strList.GetToken(nIndex, ITEM_SEPARATOR);
	}	
	///End ADD_ALIGNMENT_SETTING_TO_DATA_INFO
	
private:
	DataPlot		m_dp;
	
	string			m_strLabels;
	string			m_strHighlightCell;
	vector<string>	m_vsDefaultColumnValues;

	string			m_strInfoFrom;
	vector<string>	m_vsInfoFrom;
	vector<int>		m_vnHeaderWks;
	vector<int>		m_vnHeaderMat;

	///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
	string			m_strDataGroup;
	vector<string>	m_vsDataGroup;
	vector<int>		m_vnDataGroup;
	///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO

	///------ Folger 03/14/2012 ORG-5278-P1 AUTO_CORRECT_COLUMN_WIDTH_AND_FONG_SCALER_IN_DATAINFO_SETTINGS
	string			m_strOldWidth;
	string			m_strOldFontScaler;
	///------ End AUTO_CORRECT_COLUMN_WIDTH_AND_FONG_SCALER_IN_DATAINFO_SETTINGS
};

static bool	s_bLastUsedUpdatedByDlg = false; //--- CPY 6/16/10 ORG-316-P3 NO_LAST_USED_IF_NEW_INSTANCE
static vector<uint> s_vnLastUsedPgUIDs;		///Jasmine 02/28/2012 ORG-5121-S3 USE_DEAULT_SETTINGS_FOR_NEW_GRAPH
enum
{
	DDCM_ID_ADD_COL		= 0,
	DDCM_ID_DELETE_COL,
};

enum
{
	DDCM_CNTRL_NO_DELETE_COL			= 0x00010000,
};

class DataInfoControlMenu : public Menu
{
public:
	DataInfoControlMenu(DWORD dwCntrl = 0)
	{
		m_nChoice = -1;

		Add(_L("&Add Column"), OnMenuItem);
		m_vnIDsMap.Add(DDCM_ID_ADD_COL);

		Add(_L("&Delete Column"), OnMenuItem, O_QUERY_BOOL(dwCntrl, DDCM_CNTRL_NO_DELETE_COL) ? MF_GRAYED : MF_ENABLED);
		m_vnIDsMap.Add(DDCM_ID_DELETE_COL);
	}

	BOOL	GetCommand(int& nChoice)
	{
		if ( m_nChoice >= 0 && m_nChoice < m_vnIDsMap.GetSize() )
		{
			nChoice = m_vnIDsMap[m_nChoice];
			return TRUE;
		}
		return FALSE;
	}

private:
	void	OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}

private:
	int				m_nChoice;
	vector<int>		m_vnIDsMap;
};

/// Iris 2/23/2012 ORG-5124-S1 ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB
/*
///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
class	DataRowList : public GridListControl
{
public:
	void	Init(int nID, Dialog& dlg)
	{
		GridListControl::Init(nID, dlg);
		ClearAll();
		
		m_flx.SelectionMode = flexSelectionListBox;
		m_flx.AllowSelection = true;
		SetEditable();

		m_flx.FixedRows = 0;
		SetRows(1, false);
		SetCols(1);
		
	}
	void	SetValues(const vector<string> vs)
	{
		SetColAlignment(0, flexAlignCenterCenter);
		SetRows(vs.GetSize());
		SetColWidth(0, 1500);
		SetCells(vs, 0);
	}
	
	void	GetValues(vector<string>& vs)
	{
		GetColValues(0, vs, GetRowOffset());
	}
	
	int		GetTotalRowsHeight()
	{
		if ( 0 == GetRows() )
			return 0;
		
		return YTwipsToPixels(GetRowHeight(0) * (GetRows() + 1.8));
	}
	
	bool	GetSelectItems(vector<string>& vsItems)
	{
		return GetSelItems(0, vsItems);
	}
	
	bool	AppendItems(vector<string>& vsItems, BOOL bCheckExisting = TRUE)
	{
		vector<string> vs;
		GetValues(vs);
		if ( bCheckExisting )
			remove_if_in_list(vsItems, vs);
		int nRows = GetRows();
		int nNewRows = nRows + vsItems.GetSize();
		if ( nRows == nNewRows )
			return false;
		SetRows(nNewRows, false);
		for ( int iRow = nRows; iRow < nNewRows; iRow++ )
		{
			SetCell(iRow, 0, vsItems[iRow - nRows]);
		}
		return true;
	}
	
	bool	RemoveSelectItems()
	{
		vector<uint> vnRows;
		GetSelRows(vnRows);
		int N = vnRows.GetSize();
		while ( N-- )
		{
			m_flx.RemoveItem(vnRows[N]);
		}
		return true;
	}
};

static	string	_get_column_notation(Column& col)
{
	string str = "";
	if ( col )
	{
		string strLN, strSN;
		strLN = col.GetLongName();
		strSN = col.GetName();
		if ( strLN.IsEmpty() )
			str = strSN;
		else
			str.Format("%s\"%s\"", strSN, strLN);
	}
	return  str;
}
///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
*/
/// Iris 3/05/2012 ORG-5124-P1 NO_NEED_SHOW_BOOK_SHEET_NAME
//#define STR_AVAILABEL_DATA_COL_HEADING 	_L("Book Long Name|Book Short Name|Sheet|Short Name|Long Name|Units|Comments|1st Value|Position") 
#define STR_AVAILABEL_DATA_COL_HEADING 	_L("Book Short Name|Sheet|Short Name|Long Name|Units|Comments|1st Value|Position") 
///End NO_NEED_SHOW_BOOK_SHEET_NAME
enum
{
	/// Iris 3/05/2012 ORG-5124-P1 NO_NEED_SHOW_BOOK_SHEET_NAME
	/*
	// two hidden columns only to storage book sheet info
	AVA_COL_BOOK_LN,
	AVA_COL_BOOK_SN,
	AVA_COL_SHEET,
	*/
	AVA_COL_BOOK_SN, // the two buttons should always be hidden, only to storage book sheet info
	AVA_COL_SHEET,
	///End NO_NEED_SHOW_BOOK_SHEET_NAME
	
	AVA_COL_SN,
	AVA_COL_LN,
	AVA_COL_UNITS,
	AVA_COL_COMMENTS,
	AVA_COL_1STVAL,
	AVA_COL_POSITION,
	
	AVA_COL_COUNT // keep it as last 
};

#define STR_SELECTED_DATA_COL_HEADING 	_L("Book Long Name|Book Short Name|Sheet|Short Name|Long Name")
enum
{
	SEL_COL_BOOK_LN,
	SEL_COL_BOOK_SN,
	SEL_COL_SHEET,
	SEL_COL_SN,
	SEL_COL_LN,
	
	SEL_COL_COUNT //keep it as last
};

enum ColType
{	
	COL_TYPE_BOOK_LN,
	COL_TYPE_BOOK_SN,
	COL_TYPE_SHEET,
	COL_TYPE_SN,
	COL_TYPE_LN,
	COL_TYPE_UNITS,
	COL_TYPE_COMMENTS,
	COL_TYPE_1STVAL,
	COL_TYPE_POSITION,
	
	COL_TYPE_COUNT
};

class DataRowList : public GridListControl
{
public:
	void	Init(int nID, Dialog& dlg)
	{
		SetDlgName(STR_DIALOG_NAME);
		GridListControl::Init(nID, dlg);
		
		m_flx.SelectionMode = flexSelectionListBox;
		m_flx.AllowSelection = true;
		m_flx.AllowUserResizing = flexResizeColumns;		
		m_flx.ExplorerBar = flexExSort;
		m_flx.Editable = flexEDNone; /// Iris 3/01/2012 ORG-5109-P1 FIX_CELL_IS_EDITABLE_IN_BOTH_GRIDS_OF_ROWS_TAB
		SetAlternateRowColors();	
		
		SetColHeader(GetHeaderText());
		
		// some column always are hidden to just storage book/sheet information
		vector<byte> vbColHidden();
		GetDefaultHiddenCols(vbColHidden);
		LoadHideCols(STR_DIALOG_NAME, GetClassName(), &vbColHidden);
	}	
	
	~DataRowList()
	{
		SaveHideCols();
	}
	
	/// Iris 2/24/2012 ORG-5124-S2 SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST
	void	SetRelatedList(DataRowList* pRelatedList) 
	{
		m_pRelatedList = pRelatedList;
	}
	
	void	CheckUpdateBoldStatus()
	{
		if( m_pRelatedList )
		{
			if( m_vnBoldRows.GetSize() )
			{
				for(int index = 0; index < m_vnBoldRows.GetSize(); ++index)
				{
					SetBold(m_vnBoldRows[index], -1, false);
				}
				m_vnBoldRows.RemoveAll();
			}		
		
			vector<string> vsValues, vsRelatedValues;
			GetValues( vsValues );
			m_pRelatedList->GetValues( vsRelatedValues );			
			
			if( vsValues.GetSize() > 0 && vsRelatedValues.GetSize() > 0 )
			{
				for(int index = 0; index < vsValues.GetSize(); ++index)
				{					
					if( vsRelatedValues.Find(vsValues[index]) >= 0 )
					{
						int nRow = index + GetRowOffset();
						SetBold(nRow, -1);
						m_vnBoldRows.Add(nRow);
					}
				}
			}
		}
	}
	//End SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST
	
	void 	GetValues(vector<string>& vs)
	{
		/// Iris 3/12/2012 ORG-5109-P6 FAIL_TO_DEL_ALL_ROWS_IN_SELECTED_DATA_LIST
		if( GetNumRows() > 0 )
		///End FAIL_TO_DEL_ALL_ROWS_IN_SELECTED_DATA_LIST
		{
			vector<uint> vnRows;
			vnRows.Data(GetRowOffset(), GetNumRows(), 1);	
			GetValuesByRow(vnRows, vs);	
		}
	}
	
	bool	GetSelectItems(vector<string>& vs)
	{		
		vector<uint> vnRows;
		GetSelRows(vnRows);				
		if( vnRows.GetSize() > 0 )
		{
			GetValuesByRow(vnRows, vs);		
			return true;
		}
		return false;
	}	
	
	int		GetTotalRowsHeight()
	{
		if ( 0 == GetRows() )
			return 0;
		
		return YTwipsToPixels(GetRowHeight(0) * (GetRows() + 1.8));
	}
	
	void	GetTableText(const vector<string>& vsDatasetName, vector<string>& vsTable)
	{
		vsTable.SetSize(0);
		
		vector<uint> vnColType;
		GetColType( vnColType );
		 
		for(int index = 0; index < vsDatasetName.GetSize(); ++index)
		{
			DataObject& obj = Project.GetDataObject( vsDatasetName[index] );
			ASSERT( obj );
			if( !obj )
				continue;		
						
			Column col(obj);
			MatrixObject mo(obj);				
			for(int nCol = 0; nCol < vnColType.GetSize(); ++nCol)
			{
				string strInfo;
				int nInfoType = vnColType[nCol];				
				switch( nInfoType )
				{
				case COL_TYPE_BOOK_SN:
				case COL_TYPE_BOOK_LN:
				case COL_TYPE_SHEET:
					strInfo = getParentInfo(obj, nInfoType );
					break;
					
				case COL_TYPE_SN:					
				case COL_TYPE_LN:					
				case COL_TYPE_UNITS:					
				case COL_TYPE_COMMENTS:				
				case COL_TYPE_1STVAL:										
				case COL_TYPE_POSITION:
					strInfo = col ? getColInfo(col, nInfoType) : getMatrixObjectInfo(mo, nInfoType);
					break;
				
				default:
					ASSERT(false);
					break;
				}
				
				vsTable.Add( strInfo );
			}			
		}
	}
	
	/// Iris 3/01/2012 ORG-5109-P4 TO_PREVENT_HIDE_THE_LAST_COL
	bool	IsLastShownCol(int nCol)
	{
		vector<int> vnShows;
		GetColsShow(vnShows);
		
		if( 1 == vnShows.GetSize() && nCol == vnShows[0] )
			return true;	
		return false;
	}
	///End TO_PREVENT_HIDE_THE_LAST_COL
	
	void	OnContextMenu(int nx, int ny)
	{
		int nRow, nCol;
		GetMouseCell(nRow, nCol);
		if( nRow < 0 ) 
			return;	
			
		if( nRow < GetRowOffset() ) // click on column header
		{
			DataListColumnControlMenu myMenu(this);
			int nCmd;
			myMenu.TrackPopupMenu(0,  nx, ny, GetDlgSafeHwnd(), &nCmd);	
			if( myMenu.GetCommand(nCmd) )
			{
				if( nCmd == DATA_INFO_MENU_AUTO_WIDTH )
				{
					ResizeCols();
				}
				else if( nCmd >= DATA_INFO_MENU_DATA_BEGIN && nCmd <= DATA_INFO_MENU_DATA_END )
				{
					/// Iris 3/05/2012 ORG-5124-P1 NO_NEED_SHOW_BOOK_SHEET_NAME
					//int nCol = nCmd - DATA_INFO_MENU_DATA_BEGIN;
					int nCol = nCmd - DATA_INFO_MENU_DATA_BEGIN + GetValidColOffset();
					///End NO_NEED_SHOW_BOOK_SHEET_NAME
					bool bHidden = IsColHidden(nCol);
					HideCol(nCol, !bHidden);
				}
			}
		}
		/// Iris 2/27/2012 ORG-5109-S2 ADD_CONTEXT_MENU_TO_REMOVED_SELECTED_DATA 
		else if( nRow >= GetRowOffset() && nRow < GetRows() ) // click in list
		{
			vector<uint>	vnRows;			
			if( IsShowContextMenuForRows() && GetSelRows(vnRows) )
			{
				DataRowListMenu myMenu;
				int nCmd;
				myMenu.TrackPopupMenu(0,  nx, ny, GetDlgSafeHwnd(), &nCmd);	
				if( myMenu.GetCommand(nCmd) )
				{
					switch( nCmd )
					{
					case DATA_ROW_LIST_MENU_DELETE:
						for (int ii = vnRows.GetSize() - 1 ; ii >= 0 ; --ii)
							DeleteRow(vnRows[ii]);	
						SelRows(vnRows); // to keep the original selection
						/// Iris 2/29/2012 ORG-5108-S2 DISABLE_BUTTON_IF_ALREADY_ADDED
						PostDlgMessage(WM_USER_SEL_DATA_LIST_DEL_ROW_MSG);
						///End DISABLE_BUTTON_IF_ALREADY_ADDED
						break;
						
					default:
						ASSERT(false);
						break;
					}
				}
			}
		}
		///End ADD_CONTEXT_MENU_TO_REMOVED_SELECTED_DATA
	}
	
	virtual string	GetHeaderText() { ASSERT(false); return ""; }	
	virtual int		GetValidColOffset() { return 0; } /// Iris 3/05/2012 ORG-5124-P1 NO_NEED_SHOW_BOOK_SHEET_NAME
	
protected:
	virtual string  GetClassName() { ASSERT(false); return ""; }		
	virtual void	GetColType(vector<uint>& vnColType) { ASSERT(false); vnColType.RemoveAll(); }	
	virtual void	GetDefaultHiddenCols(vector<byte>& vnColHidden) { ASSERT(false); }
	virtual int		GetBookShortNameCol() { ASSERT(false); return -1; }
	virtual int		GetSheetNameCol() { ASSERT(false); return -1; }
	virtual int		GetObjShortCol() { ASSERT(false); return -1; }	
	virtual bool 	IsShowContextMenuForRows() { return false; } /// Iris 2/27/2012 ORG-5109-S2 ADD_CONTEXT_MENU_TO_REMOVED_SELECTED_DATA	
	
	void	GetValuesByRow(const vector<uint>& vnRows, vector<string>& vs)
	{
		vs.RemoveAll();
		for(int index = 0; index < vnRows.GetSize(); ++index)
		{
			string strBook = GetCell(vnRows[index], GetBookShortNameCol());
			string strSheet = GetCell(vnRows[index], GetSheetNameCol());
			string strObj = GetCell(vnRows[index], GetObjShortCol());
			
			DataObject obj;
			obj = _get_dataobject_from_book_sheet_obj_name(strBook, strSheet, strObj);
			if( obj )
				vs.Add( obj.GetDatasetName() ); // for Book1_A case
			else
				vs.Add( strObj ); // for <X>, <Y> or loose dataset
		}
	}	
	
private:
	string	getColInfo(Column& col, int nType)
	{
		if( !col )
			return "";
		
		switch( nType )
		{
		case COL_TYPE_SN:
			return col.GetName();			
			
		case COL_TYPE_LN:
			return col.GetLongName();			
			
		case COL_TYPE_UNITS:
			return col.GetUnits();			
			
		case COL_TYPE_COMMENTS:
			return col.GetComments();			
		
		case COL_TYPE_1STVAL:	
			Worksheet wks;
			col.GetParent(wks);
			string strVal;
			wks.GetCell(0, col.GetIndex(), strVal);
			return strVal;
			
		case COL_TYPE_POSITION:
			return (string)(col.GetIndex() + 1);
			
		}
		ASSERT(false);
		return "";
	}
	
	string 	getMatrixObjectInfo(MatrixObject& mo, int nType)
	{
		if( !mo )
			return "";
		
		switch( nType )
		{
		case COL_TYPE_SN:
			return mo.GetName();			
			
		case COL_TYPE_LN:
			return mo.GetLongName();			
			
		case COL_TYPE_UNITS:
			return mo.GetUnits();			
			
		case COL_TYPE_COMMENTS:
			return mo.GetComments();			
		
		case COL_TYPE_1STVAL:	
			matrixbase& mm = mo.GetDataObject();
			if( mm.GetNumRows() > 0 && mm.GetNumCols() > 0 )
			{
				int nDataType = mo.GetInternalDataType();
				switch( nDataType )
				{					
				case FSI_DOUBLE:
				case FSI_REAL:
					return ftoa(mm[0][0]);
					
				default:
					return (string)mm[0][0];					
				}
			}
			return "";
			
		case COL_TYPE_POSITION:
			return (string)(mo.GetIndex() + 1);
		}
		
		ASSERT(false);
		return "";		
	}
	
	string	getParentInfo(DataObject& obj, int nType)
	{
		if( !obj )
			return "";
		
		Datasheet sheet;
		obj.GetParent(sheet);
		if( !sheet )
			return ""; // for loose dataset
		
		Page pg;
		sheet.GetParent(pg);
		
		switch( nType )
		{
		case COL_TYPE_BOOK_SN:
			return pg.GetName();
			
		case COL_TYPE_BOOK_LN:
			return pg.GetLongName();
			
		case COL_TYPE_SHEET:
			return sheet.GetName();
			
		default:
			ASSERT(false);
			break;
		}				
		return "";	
	}
	
/// Iris 2/24/2012 ORG-5124-S2 SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST
protected:
	DataRowList*		m_pRelatedList;
private:
	vector<int>			m_vnBoldRows;
///End SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST
};

class AvailableDataList : public DataRowList
{
public:
	void	Init(int nID, Dialog& dlg)
	{		
		DataRowList::Init(nID, dlg);		
		
		vector<uint> vnAlign(AVA_COL_COUNT);
		vnAlign = flexAlignLeftCenter;
		vnAlign[AVA_COL_1STVAL] = flexAlignGeneral;
		for(int nCol = 0; nCol < AVA_COL_COUNT; ++nCol)
		{
			SetColAlignment(nCol, vnAlign[nCol]);
		}			
	}	
	
	//virtual 
	string	GetHeaderText()
	{
		return STR_AVAILABEL_DATA_COL_HEADING;
	}	
	
	void	SetValues(const vector<string>& vs)
	{
		ClearAll();			
		if( vs.GetSize() > 0 )
		{			
			vector<string> vsTableText;				
			GetTableText(vs, vsTableText);
		
			SetRows(vs.GetSize());
			SetTableValue(vsTableText, true);	
			ResizeCols();
		}
	}
	
	/// Iris 3/05/2012 ORG-5124-P1 NO_NEED_SHOW_BOOK_SHEET_NAME
	// virtual 
	int		GetValidColOffset()
	{
		return AVA_COL_SN;
	}
	///End NO_NEED_SHOW_BOOK_SHEET_NAME
	
protected:
	//virtual 
	string  GetClassName() 
	{ 
		return "AvailableDataList";
	}
	
	// virtual
	void	GetColType(vector<uint>& vnColType)
	{
		/// Iris 3/05/2012 ORG-5124-P1 NO_NEED_SHOW_BOOK_SHEET_NAME
		//const vector<uint> vn = {COL_TYPE_BOOK_LN, COL_TYPE_BOOK_SN, COL_TYPE_SHEET, COL_TYPE_SN, COL_TYPE_LN, COL_TYPE_UNITS, COL_TYPE_COMMENTS, COL_TYPE_1STVAL, COL_TYPE_POSITION};
		const vector<uint> vn = {COL_TYPE_BOOK_SN, COL_TYPE_SHEET, COL_TYPE_SN, COL_TYPE_LN, COL_TYPE_UNITS, COL_TYPE_COMMENTS, COL_TYPE_1STVAL, COL_TYPE_POSITION};
		///End NO_NEED_SHOW_BOOK_SHEET_NAME
		vnColType = vn;
	}	
	
	//virtual 
	void	GetDefaultHiddenCols(vector<byte>& vnColHidden) 
	{
		vector<uint> vnColType;
		GetColType(vnColType);
		
		vnColHidden.SetSize( vnColType.GetSize() );
		vnColHidden = true;
		vnColHidden[AVA_COL_SN] = false;
		vnColHidden[AVA_COL_LN] = false;
	}	
	
	// virtual
	int		GetBookShortNameCol() { return AVA_COL_BOOK_SN; }
	int		GetSheetNameCol() { return AVA_COL_SHEET; }
	int		GetObjShortCol() { return AVA_COL_SN; }	
	bool 	IsShowContextMenuForRows() { return false; } /// Iris 2/27/2012 ORG-5109-S2 ADD_CONTEXT_MENU_TO_REMOVED_SELECTED_DATA
};

class SelectedDataList : public DataRowList
{
public:		
	//virtual 
	string	GetHeaderText()
	{
		return STR_SELECTED_DATA_COL_HEADING;
	}	
	
	void	SetValues(const vector<string>& vs)
	{		
		ClearAll();		
		/// Iris 2/29/2012 ORG-5108-S4 INSERT_ITEMS_AFTER_THE_SELECTED_ROW_IN_DATA_SELECTED_LIST
		//AppendItems(vs, false, true);
		AppendOrInsertItems(vs, false, true);
		///End INSERT_ITEMS_AFTER_THE_SELECTED_ROW_IN_DATA_SELECTED_LIST
		ResizeCols();
	}
	
	/// Iris 3/05/2012 ORG-5124-P1 NO_NEED_SHOW_BOOK_SHEET_NAME
	// virtual
	int		GetValidColOffset()
	{
		return COL_TYPE_SN;
	}
	///End NO_NEED_SHOW_BOOK_SHEET_NAME
	
	/// Iris 2/29/2012 ORG-5108-S4 INSERT_ITEMS_AFTER_THE_SELECTED_ROW_IN_DATA_SELECTED_LIST
	//bool	AppendItems(vector<string>& vs, BOOL bCheckExisting = TRUE, BOOL bInit = FALSE)
	bool	AppendOrInsertItems(vector<string>& vs, BOOL bCheckExisting = TRUE, BOOL bInit = FALSE)
	///End INSERT_ITEMS_AFTER_THE_SELECTED_ROW_IN_DATA_SELECTED_LIST
	{
		if( vs.GetSize() > 0 )
		{
			vector<string> vsValues;
			GetValues(vsValues);
			
			vector<string> vsTableText;			
			int nNewRows = 0;
			for(int index = 0; index < vs.GetSize(); ++index)
			{
				string strData = vs[index];
				if( bCheckExisting && vsValues.Find(strData) >= 0 ) 
				{
					continue;
				}
				
				DataObject& obj = Project.GetDataObject(strData);				
				vector<string> vsOneRow;
				if( !obj ) // for <X>, <Y> entry
				{					
					vector<uint> vnColType;
					GetColType(vnColType);
					
					vsOneRow.SetSize( vnColType.GetSize() );
					vector<uint> vn;
					if( vnColType.Find(MATREPL_TEST_EQUAL, COL_TYPE_SN, vn) > 0 && vn.GetSize() > 0 )
						vsOneRow[vn[0]] = strData; // put data info into Short Name column
				}
				else
				{
					vector<string> vsOneData;
					vsOneData.Add( strData );
					GetTableText(vsOneData, vsOneRow);
				}				
				vsTableText.Append( vsOneRow );				
				nNewRows++;
			}		
			
			if( nNewRows > 0 )
			{
				/// Iris 2/29/2012 ORG-5108-S4 INSERT_ITEMS_AFTER_THE_SELECTED_ROW_IN_DATA_SELECTED_LIST
				vector<uint> vnSelRows, vnNewRows;
				/// Iris 3/01/2012 ORG-5109-P3 FIX_DATA_SELECTED_GRID_EMPTY_ROW
				//bool bInsert = !bInit && GetSelRows(vnSelRows) && vnSelRows[vnSelRows.GetSize() - 1] != m_flx.Rows - 1;
				bool bInsert = !bInit && GetSelRows(vnSelRows) && vnSelRows[vnSelRows.GetSize() - 1] <= m_flx.Rows - 1;
				///End FIX_DATA_SELECTED_GRID_EMPTY_ROW
				if( bInsert )
				{
					for(int index = 0; index < nNewRows; ++index)
					{
						vector<string> vsRow;				
						int c1 = GetNumCols() * index;
						int c2 = c1 + GetNumCols() - 1;
						vsTableText.GetSubVector(vsRow, c1, c2);
						
						int nRow = vnSelRows[vnSelRows.GetSize() - 1] + index + 1;
						m_flx.AddItem("", nRow); // the row index begin from row header
						vnNewRows.Add(nRow);
						
						SetRowValues(nRow - GetRowOffset(), vsRow); // the row index begin from 1st data row						
					}
				}
				else
				{
				///End INSERT_ITEMS_AFTER_THE_SELECTED_ROW_IN_DATA_SELECTED_LIST
					int nOldNumRows = GetNumRows();
					int nNewNumRows = nOldNumRows + nNewRows;	
					SetRows(nNewNumRows);
					m_flx.SetTableValue(&vsTableText, m_flx.Rows, m_flx.Cols, m_flx.FixedRows + nOldNumRows, m_flx.FixedCols, true);
				/// Iris 2/29/2012 ORG-5108-S4 INSERT_ITEMS_AFTER_THE_SELECTED_ROW_IN_DATA_SELECTED_LIST
					vnNewRows.Data(m_flx.FixedRows + nOldNumRows, nNewNumRows, 1);				
				}
				///End INSERT_ITEMS_AFTER_THE_SELECTED_ROW_IN_DATA_SELECTED_LIST
				
				/// Iris 2/24/2012 ORG-5124-S2 SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST
				if( !bInit ) // to select the newly added rows
				{
					/// Iris 2/29/2012 ORG-5108-S4 INSERT_ITEMS_AFTER_THE_SELECTED_ROW_IN_DATA_SELECTED_LIST
					//vector<int> vnRows;
					//vnRows.Data(m_flx.FixedRows + nOldNumRows, nNewNumRows, 1);
					//SelRows(vnRows);
					SelRows(vnNewRows);
					///End INSERT_ITEMS_AFTER_THE_SELECTED_ROW_IN_DATA_SELECTED_LIST
				}
				///End SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST
				return true;
			}			
		}		
		return false;
	}
	
	bool	RemoveSelectItems()
	{
		vector<uint> vnRows;
		GetSelRows(vnRows);
		
		/// Iris 2/24/2012 ORG-5124-S2 SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST
		// to find the removed items in left list
		vector<int> vnSelRowInRelatedList;
		if( m_pRelatedList )
		{
			vector<string> vsSelectedItems, vsRelatedValues;
			GetSelectItems(vsSelectedItems);
			m_pRelatedList->GetValues(vsRelatedValues);
			for(int index = 0; index < vsSelectedItems.GetSize(); ++index)
			{
				int nn = vsRelatedValues.Find(vsSelectedItems[index]);
				if( nn >= 0 )
				{
					vnSelRowInRelatedList.Add( m_pRelatedList->GetRowOffset() + nn );
				}
			}
		}
		///End SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST
		
		int N = vnRows.GetSize();
		while ( N-- )
		{
			m_flx.RemoveItem(vnRows[N]);
		}
		
		/// Iris 2/24/2012 ORG-5124-S2 SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST
		// to select the removed items in left list
		if( m_pRelatedList && vnSelRowInRelatedList.GetSize() > 0 )
		{
			m_pRelatedList->SelRows(vnSelRowInRelatedList);
		}
		///End SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST
		return true;
	}
	
protected:
	//virtual 
	string  GetClassName() 
	{ 
		return "SelectedDataList";
	}
	
	//virtual
	void	GetColType(vector<uint>& vnColType)
	{
		const vector<uint> vn = {COL_TYPE_BOOK_LN, COL_TYPE_BOOK_SN, COL_TYPE_SHEET, COL_TYPE_SN, COL_TYPE_LN};
		vnColType = vn;
	}	
	
	//virtual 
	void	GetDefaultHiddenCols(vector<byte>& vnColHidden) 
	{
		vector<uint> vnColType;
		GetColType( vnColType );
		
		vnColHidden.SetSize( vnColType.GetSize() );
		vnColHidden = true;
		vnColHidden[SEL_COL_SN] = false;
		vnColHidden[SEL_COL_LN] = false;
	}
	
	// virtual
	int		GetBookShortNameCol() { return COL_TYPE_BOOK_SN; }
	int		GetSheetNameCol() { return COL_TYPE_SHEET; }
	int		GetObjShortCol() { return COL_TYPE_SN; }	
	bool 	IsShowContextMenuForRows() { return true; } /// Iris 2/27/2012 ORG-5109-S2 ADD_CONTEXT_MENU_TO_REMOVED_SELECTED_DATA	
};

enum
{
	DATA_INFO_MENU_AUTO_WIDTH = 0,
	DATA_INFO_MENU_SEP,
	
	DATA_INFO_MENU_DATA_BEGIN,
	DATA_INFO_MENU_DATA_END = DATA_INFO_MENU_DATA_BEGIN + 100,
	
	DATA_INFO_MENU_LAST_ITEM
};

class DataListColumnControlMenu : public Menu
{
public:
	DataListColumnControlMenu(DataRowList* pList)
	{
		m_nChoice = -1;
		Add(STR_COL_AUTO_WIDTH_MENU, OnMenuItem, MF_STRING, DATA_INFO_MENU_AUTO_WIDTH);
		Add(NULL, OnMenuItem, MF_SEPARATOR);
	
		m_pList = pList;
		if( pList )
		{
			string strColHeader = pList->GetHeaderText();
			const char chSep = '|';
			/// Iris 3/05/2012 ORG-5124-P1 NO_NEED_SHOW_BOOK_SHEET_NAME
			//for(int nCol = 0; nCol < strColHeader.GetNumTokens(chSep); ++nCol)
			for(int nCol = pList->GetValidColOffset(); nCol < strColHeader.GetNumTokens(chSep); ++nCol)
			///End NO_NEED_SHOW_BOOK_SHEET_NAME
			{
					UINT nFlags = MF_STRING;
					if( !pList->IsColHidden( nCol ) )
						nFlags |= MF_CHECKED;
				/// Iris 3/01/2012 ORG-5109-P4 TO_PREVENT_HIDE_THE_LAST_COL
				if( pList->IsLastShownCol(nCol) )
					nFlags |= MF_DISABLED;
				///End TO_PREVENT_HIDE_THE_LAST_COL
					Add(strColHeader.GetToken(nCol, chSep), OnMenuItem, nFlags, DATA_INFO_MENU_DATA_BEGIN + nCol);
				}
			}
		}
	
	void 	OnMenuItem(UINT nPos) 
	{	
		m_nChoice = nPos;
	}
	
	bool 	GetCommand(int& nChoice) 
	{ 
		if( m_nChoice >= DATA_INFO_MENU_AUTO_WIDTH && m_nChoice < DATA_INFO_MENU_LAST_ITEM )
		{				
			nChoice = m_nChoice; 
			return true; 
		}		
		return false;
	}
	
private:
	DataRowList*		m_pList;
	int					m_nChoice;		
};

/// Iris 2/27/2012 ORG-5109-S2 ADD_CONTEXT_MENU_TO_REMOVED_SELECTED_DATA
#define STR_LIST_MENU_DELETE		_L("Delete")

enum
{
	DATA_ROW_LIST_MENU_DELETE = 0,	
};
class DataRowListMenu : public Menu
{
public:
	DataRowListMenu()
	{	
		m_nChoice = -1;
		Add(STR_LIST_MENU_DELETE, OnMenuItem);	
	}
	
	void 	OnMenuItem(UINT nPos) 
	{	
		m_nChoice = nPos;
	}
	
	bool 	GetCommand(int& nChoice) 
	{ 
		if( m_nChoice >= 0 )
		{				
			nChoice = m_nChoice; 
			return true; 
		}		
		return false;
	}
	
private:	
	int					m_nChoice;		
};
///End ADD_CONTEXT_MENU_TO_REMOVED_SELECTED_DATA

static DataObject _get_dataobject_from_book_sheet_obj_name(LPCSTR lpcszBook, LPCSTR lpcszSheet, LPCSTR lpcszObj)
{
	DataObject obj;
	
	Page pg(lpcszBook);
	if( pg )
	{
		Datasheet sheet = pg.Layers(lpcszSheet);
		if( sheet )
		{			
			obj = sheet.FindCol(lpcszObj);		
		}
	}
	return obj;	
}
///End ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB



#define		STR_GRAPH_THEME			"<Graph>"
#define		STR_LAYER_THEME			"<Layer>"
#define		STR_PLOT_THEME			"<DataPlot>"

class DataInfoThemeMenu : public ThemeControlMenu
{
public:
	DataInfoThemeMenu(BOOL bSave, BOOL bDelete, BOOL bLoad, vector<string>& vsThemes, int nSel)
	{
		m_nChoice = -1;

		string		str;
		LPCSTR		lpcszSaveTo = _L("Save to");
		
		str.Format("%s %s", lpcszSaveTo, STR_GRAPH_THEME);
		Add(str, OnMenuItem);
		m_vnIndecesMap.Add(THEME_MENU_SAVE_TO_GRAPH);

		str.Format("%s %s", lpcszSaveTo, STR_LAYER_THEME);
		Add(str, OnMenuItem);
		m_vnIndecesMap.Add(THEME_MENU_SAVE_TO_LAYER);

		str.Format("%s %s", lpcszSaveTo, STR_PLOT_THEME);
		Add(str, OnMenuItem);
		m_vnIndecesMap.Add(THEME_MENU_SAVE_TO_PLOT);

		///------ Folger 06/21/10 ORG-316-P4 SUPPORT_DEFAULT_THEME_IN_DATA_INFO_SETTINGS
		Add(STR_SAVE_AS_DEFAULT, OnMenuItem);
		m_vnIndecesMap.Add(THEME_MENU_SAVE_AS_DEFAULT);
		///------ End SUPPORT_DEFAULT_THEME_IN_DATA_INFO_SETTINGS

		Add(_L("Save"), OnMenuItem, bSave ? MF_ENABLED : MF_GRAYED);
		m_vnIndecesMap.Add(THEME_MENU_SAVE);
		
		Add(_L("Save As") + STR_THREE_DOTS, OnMenuItem);
		m_vnIndecesMap.Add(THEME_MENU_SAVE_AS);

		THEME_MENU_ADD_SEPARATOR;

		Add(_L("System Default"), OnMenuItem);
		m_vnIndecesMap.Add(THEME_MENU_RESET);
		
        Add(_L("Delete") + STR_THREE_DOTS, OnMenuItem, bDelete ? MF_ENABLED : MF_GRAYED);
		m_vnIndecesMap.Add(THEME_MENU_DELETE);

		m_nCount = m_vnIndecesMap.GetSize();

		AddThemeItems(bLoad, nSel);
	}
};

/// Iris 2/22/2012 ORG-5019-S2 IMPROVE_COORDINATES_BUTTON
/*
///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
class SrcDataMenu : public Menu
{
public:
	SrcDataMenu()
	{
		m_nChoice = -1;

		string		str;
		LPCSTR		lpcszFormat = "%s : %s";

		str.Format(lpcszFormat, STR_SRC_INDEX, STR_ROW_INDEX);
		Add(str, OnMenuItem);

		str.Format(lpcszFormat, STR_DISP_X, _L("X Coordinate"));
		Add(str, OnMenuItem);

		str.Format(lpcszFormat, STR_DISP_Y, _L("Y Coordinate"));
		Add(str, OnMenuItem);

		str.Format(lpcszFormat, STR_DISP_Z, _L("Z Coordinate"));
		Add(str, OnMenuItem);

		str.Format(lpcszFormat, STR_SRC_X, _L("Source X Data"));
		Add(str, OnMenuItem);

		str.Format(lpcszFormat, STR_SRC_Y, _L("Source Y Data"));
		Add(str, OnMenuItem);

		str.Format(lpcszFormat, STR_SRC_Z, _L("Source Z Data"));
		Add(str, OnMenuItem);

		///------ Folger 07/02/10 ORG-436-S4 DATA_INFO_ROW_SEPARATOR_SUPPORT
		Add(NULL, OnMenuItem, MF_SEPARATOR);

		str.Format(lpcszFormat, STR_DISP_SEP, _L("Separator"));
		Add(str, OnMenuItem);
		///------ End DATA_INFO_ROW_SEPARATOR_SUPPORT
	}

	void	OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}

	BOOL	GetCommand(int& nChoice)
	{
		nChoice = m_nChoice;
		return nChoice >= 0;
	}
	
protected:
	int	m_nChoice;
};
///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
*/
///End IMPROVE_COORDINATES_BUTTON

enum
{
	DISTAB_TITLE			= 0,
	DISTAB_ROWS,
	DISTAB_COLS,
	DISTAB_DISPLAY,
};

class	DataInfoSettingsDlg : public DynaDlg
{
public:
	DataInfoSettingsDlg(TreeNode& trSettings, DataPlot& dp) : DynaDlg(IDD_DATA_INFO_SETTINGS, NULL, "ODlg8")
	{
		m_trSettings = trSettings;
		if ( m_trSettings )
			m_trSettings.GetAttribute(STR_THEME_FILE_ATTRIB, m_strThemeFile);
		*m_DataInfoList.DataPlotPtr() = dp;
	}
	~DataInfoSettingsDlg()
	{
	}

	int		DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();
		int nRet = ResizeDialog::DoModal(hWndParent);
		return nRet;
	}

	BOOL	GetDefaultSettings(TreeNode& tr, BOOL bFactory = FALSE)
	{
		static	Tree	l_trDefault;
		if ( l_trDefault.IsEmpty() )
		{
			l_trDefault.SetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, STR_DATA_INFO_CLASS_SETTINGS);

			/// Title
			TreeNode	trTitle = l_trDefault.AddNode("Title");
			trTitle.Replace(GetTitle(TRUE), TRUE, TRUE);
			
			/// Columns
			vector<string>			vs1, vs2;
			vs2 = vs1 = m_DataInfoList.DefaultColumnValues();
			
			vs1[LISTROW_INFO_FROM-1].Format("%d", DIS_INFO_FROM_DEADER);			
			vs1[LISTROW_CONTENT-1].Format("%d", RCLT_SHORT_NAME);			
			
			vs2[LISTROW_INFO_FROM-1].Format("%d", DIS_INFO_FROM_RAW_DATA);
			///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
			vs2[LISTROW_CONTENT-1].Format("%d", DIC_READER);
			///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
			
			///Jasmine 02/21/2012 ORG-985 ADD_ALIGNMENT_SETTING_TO_DATA_INFO
			vs1[LISTROW_COLUMN_ALIGNMENT-1].Format("%d", DIS_COL_ALIGN_AUTO);
			vs2[LISTROW_COLUMN_ALIGNMENT-1] = vs1[LISTROW_COLUMN_ALIGNMENT-1];
			///End ADD_ALIGNMENT_SETTING_TO_DATA_INFO
			
			Array<vector<string>&>	arrCols;
			arrCols.Add(vs1);
			arrCols.Add(vs2);
			TreeNode	trColumns = l_trDefault.AddNode("Columns");
			SaveColumnsSettings(trColumns, arrCols, 1);
			
			/// Display
			TreeNode	trDisplay = l_trDefault.AddNode("Display");
			trDisplay.Replace(GetDisplay(TRUE), TRUE, TRUE);
		}
		
		/// Iris 3/01/2012 ORG-5018-S2 CHANGE_DEFAULT_OPTION_AS_LN_FOR_COLUMN_LABELS_MORE
		//if( bFactory )
		///End CHANGE_DEFAULT_OPTION_AS_LN_FOR_COLUMN_LABELS_MORE
		{
			/// Iris 2/22/2012 ORG-5108-S2 CHANGE_DEFAULT_OPTION_AS_LN_FOR_COLUMN_LABELS
			updateDefaultSourceForLabelType(l_trDefault);
			///End CHANGE_DEFAULT_OPTION_AS_LN_FOR_COLUMN_LABELS
		}
		
		/// Rows
		///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
		TreeNode	trRows = tree_check_get_node(l_trDefault, "Rows");
		vector<int>	vnIndices, vnDefault;
		///Sophy 6/13/2010 ORG-120-P16 INIT_COLS_LIST_FROM_SRC_WORKSHEET
		InitColsList(vnIndices, vnDefault);
		///end INIT_COLS_LIST_FROM_SRC_WORKSHEET
		TreeNode trLeftGrid = tree_check_get_node(trRows, "LeftGrid");
		trLeftGrid.DataID = ID_DATAINFOSETTINGS_AVAILABLE;
		trLeftGrid.nVals = vnIndices;
		TreeNode trRightGrid = tree_check_get_node(trRows, "RightGrid");
		trRightGrid.DataID = ID_DATAINFOSETTINGS_SELECTED;
		trRightGrid.nVals = vnDefault;
		///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG

		tr.Replace(l_trDefault, TRUE, TRUE);
		if ( !bFactory )
		{
			GraphPage	gp;
			GraphLayer	gl;
			DataPlot	dp;
			GetRelatedObj(&gp, &gl, &dp);
			vector<string>		vsThemes = { STR_PLOT_THEME
				, STR_LAYER_THEME
				, STR_GRAPH_THEME
				, THEME_FILENAME_LAST_USED
			};
			//---- CPY 6/16/10 ORG-316-P3 NO_LAST_USED_IF_NEW_INSTANCE
			if(!s_bLastUsedUpdatedByDlg)
			{
				vsThemes.SetSize(vsThemes.GetSize()-1); // del <last used>
			}
			//----
			///------ Folger 06/23/10 ORG-316-P5 DEFAULT_THEME_FAILED_TO_LOAD_WHEN_OPEN_DATA_INFO_SETTINGS
			vsThemes.Add(STR_DEFAULT_E);
			///------ End DEFAULT_THEME_FAILED_TO_LOAD_WHEN_OPEN_DATA_INFO_SETTINGS
			
			///Jasmine 02/28/2012 ORG-5121-S3 USE_DEAULT_SETTINGS_FOR_NEW_GRAPH
			bool bLastUsedPg = true;
			if(gp)
			{
				bLastUsedPg = isLastUsedPage( s_vnLastUsedPgUIDs, gp.GetUID(true) );
				if(!bLastUsedPg)
				{
					int nFind = vsThemes.Find(THEME_FILENAME_LAST_USED);
					if(nFind >= 0) vsThemes.RemoveAt(nFind);
				}
			}
			///End USE_DEAULT_SETTINGS_FOR_NEW_GRAPH
			
			for ( int ii=0; ii<vsThemes.GetSize(); ++ii )
			{
				if ( LoadTheme(tr, vsThemes[ii]) )
					break;
			}
			
			///Jasmine 02/28/2012 ORG-5121-S3 USE_DEAULT_SETTINGS_FOR_NEW_GRAPH
			if(vsThemes.GetSize() == ii && !bLastUsedPg)
			{
				return GetDefaultSettings(tr, TRUE);
			}
			///End USE_DEAULT_SETTINGS_FOR_NEW_GRAPH
		}

		///Jasmine 03/13/2012 ORG-5121-S5-2 ADD_TITLE_OPTION_FOR_WIN_TITLE
		TreeNode 			trTitle = tr.Title;
		WindowTitleOption 	winTitle;
		winTitle.Type 		= GUI_WINTITLE_TO_DISTITLE(trTitle.WinTitle.nVal);
		winTitle.Format 	= trTitle.WinFormat.strVal;
		
		WindowTitleOption*	pWinTitle = NULL;
		pWinTitle			= &winTitle;
		ODWP dwPtr 			= (ODWP)pWinTitle;
		DataInfoDlg(DATAINFODLGMSG_UPDATE_TITLE_SETTINGS, dwPtr);
		///End ADD_TITLE_OPTION_FOR_WIN_TITLE
		
		return TRUE;
	}

	int		ConvertHeaderIndex(int nIndex, BOOL bSaving = TRUE)
	{
		return m_DataInfoList.ConvertHeaderIndex(nIndex, bSaving);
	}

	int		ConvertDataGroupIndex(int nIndex, BOOL bSaving = TRUE)
	{
		return m_DataInfoList.ConvertDataGroupIndex(nIndex, bSaving);
	}

	///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
	BOOL	GetCursorValue(CursorValue* pCursor)
	{
		DataInfoCursor&		cursor = DataCursor(pCursor->nCursorType);
		if ( !cursor.IsValid() )
			return FALSE;

		double	x = NANUM, y = NANUM, z = NANUM;
		cursor.GetLastXYZ(x, y, z);

		switch ( pCursor->nValueType )
		{
		case DISSRC_X:
			pCursor->rValue = x;
			break;

		case DISSRC_Y:
			pCursor->rValue = y;
			break;

		case DISSRC_Z:
			pCursor->rValue = z;
			break;

		default:
			return FALSE;
		}

		return TRUE;
	}
	///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO

	///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
	BOOL	GetColumnHeader(LPSTR szBuffer, int nCol)
	{
		m_DataInfoList.InitContents();
		return m_DataInfoList.GetColumnHeader(szBuffer, nCol, m_trSettings);
	}
	///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
	
protected:
	/// Iris 2/22/2012 ORG-5019-S2 IMPROVE_COORDINATES_BUTTON
	/*
	///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
	BOOL	OnSrcPopup(Control ctrl)
	{
		SrcDataMenu		myMenu;

		RECT 				rr;
		ctrl.GetClientRect(&rr);
		ctrl.ClientToScreen(&rr);
		myMenu.TrackPopupMenu(0,  rr.right, rr.top, GetSafeHwnd());
		int					nCmd;
		if( myMenu.GetCommand(nCmd) )
		{
			vector<int>	vnMap = { DISSRC_ROW_NUM
				, DISSRC_X
				, DISSRC_Y
				, DISSRC_Z
				, DISSRC_XINDEX
				, DISSRC_YINDEX
				, DISSRC_ZINDEX
				, 0		/// separator
				///------ Folger 07/02/10 ORG-436-S4 DATA_INFO_ROW_SEPARATOR_SUPPORT
				, DISSRC_SEP
				///------ End DATA_INFO_ROW_SEPARATOR_SUPPORT
			};

			vector<string>		vs(1);
			IndexToName(vs[0], vnMap[nCmd]);
			m_DataSelected.AppendItems(vs, DISSRC_SEP != vnMap[nCmd]);
			enableApply();
		}
		return TRUE;
	}
	///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
	*/	
	void	addSrc(int nSrcType)
	{
		vector<string>		vs(1);
		IndexToName(vs[0], nSrcType);
		/// Iris 2/29/2012 ORG-5108-S4 INSERT_ITEMS_AFTER_THE_SELECTED_ROW_IN_DATA_SELECTED_LIST
		//m_DataSelected.AppendItems(vs, DISSRC_SEP != nSrcType);
		m_DataSelected.AppendOrInsertItems(vs, DISSRC_SEP != nSrcType);
		///End INSERT_ITEMS_AFTER_THE_SELECTED_ROW_IN_DATA_SELECTED_LIST
		UpdateEnableStatusAfterDataSelected(); /// Iris 2/29/2012 ORG-5108-S2 DISABLE_BUTTON_IF_ALREADY_ADDED		
		///------ Folger 03/28/2012 ORG-5383-P1 THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
		//enableApply();
		AfterValueChange();
		///------ End THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
	}
	
	BOOL	OnSrcIndex(Control ctrl)
	{
		addSrc(DISSRC_ROW_NUM);
		return TRUE;
	}
	
	BOOL	OnSrcX(Control ctrl)
	{
		addSrc(DISSRC_X);
		return TRUE;
	}
	
	BOOL	OnSrcY(Control ctrl)
	{
		addSrc(DISSRC_Y);
		return TRUE;
	}	
	
	BOOL	OnSrcZ(Control ctrl)
	{
		addSrc(DISSRC_Z);
		return TRUE;
	}
	
	BOOL	OnSrcXIndex(Control ctrl)
	{
		addSrc(DISSRC_XINDEX);
		return TRUE;
	}
	
	BOOL	OnSrcYIndex(Control ctrl)
	{
		addSrc(DISSRC_YINDEX);
		return TRUE;
	}	
	
	BOOL	OnSrcZIndex(Control ctrl)
	{
		addSrc(DISSRC_ZINDEX);
		return TRUE;
	}
	
	BOOL	OnSrcSep(Control ctrl)
	{
		addSrc(DISSRC_SEP);
		return TRUE;
	}
	///End IMPROVE_COORDINATES_BUTTON
	
	/// Iris 2/29/2012 ORG-5108-S2 DISABLE_BUTTON_IF_ALREADY_ADDED
	void	UpdateEnableStatusAfterDataSelected()
	{
		vector<string> vsNames;
		vector<int> vnIndices;
		m_DataSelected.GetValues(vsNames);
		NameToIndex(vsNames, vnIndices);		
		
		/// Iris 3/01/2012 ORG-5109-S2 DISABLE_AVAILABLE_DATA_LIST_ROWS_IF_ALREADY_ADDED
		int ii;
		vector<string> vsAvailableNames;
		vector<int> vnAvailableIndices;
		m_DataAvailable.GetValues(vsAvailableNames);
		NameToIndex(vsAvailableNames, vnAvailableIndices);
		for(ii = 0; ii < vnAvailableIndices.GetSize(); ++ii)
		{
			int nRow = ii + m_DataAvailable.GetRowOffset();
			vector<uint> vn;
			/// Iris 3/12/2012 ORG-5109-P6 FAIL_TO_DEL_ALL_ROWS_IN_SELECTED_DATA_LIST
			//if( vnIndices.Find(MATREPL_TEST_EQUAL, vnAvailableIndices[ii], vn) > 0 )
			if( vnIndices.GetSize() > 0 && vnIndices.Find(MATREPL_TEST_EQUAL, vnAvailableIndices[ii], vn) > 0 )
			///End FAIL_TO_DEL_ALL_ROWS_IN_SELECTED_DATA_LIST
			{
				m_DataAvailable.SetRowColor(nRow, RGB(125, 125, 125), -1, false);
			}
			else
			{
				m_DataAvailable.SetRowColor(nRow, COLOR_BLACK);
			}
		}		
		///End DISABLE_AVAILABLE_DATA_LIST_ROWS_IF_ALREADY_ADDED
	
		vector<uint> vnBtnIDs = { IDC_BTN_DATA_INDEX, IDC_BTN_DATA_X, IDC_BTN_DATA_Y, IDC_BTN_DATA_Z, IDC_BTN_DATA_XDATA, IDC_BTN_DATA_YDATA, IDC_BTN_DATA_ZDATA};
		vector<int> vnTypes = {DISSRC_ROW_NUM, DISSRC_X, DISSRC_Y, DISSRC_Z, DISSRC_XINDEX, DISSRC_YINDEX, DISSRC_ZINDEX};		
		
		for(ii = 0; ii < vnBtnIDs.GetSize(); ++ii)
		{
			Button btn = GetItem( vnBtnIDs[ii] );
			ASSERT( btn );			
			
			vector<uint> vn;	
			/// Iris 3/12/2012 ORG-5109-P6 FAIL_TO_DEL_ALL_ROWS_IN_SELECTED_DATA_LIST
			//btn.Enable = (vnIndices.Find(MATREPL_TEST_EQUAL, vnTypes[ii], vn) <= 0); // enable if not found
			btn.Enable = (vnIndices.GetSize() == 0 || vnIndices.Find(MATREPL_TEST_EQUAL, vnTypes[ii], vn) <= 0); // enable if not found
			///End FAIL_TO_DEL_ALL_ROWS_IN_SELECTED_DATA_LIST
		}			
	}
	///End DISABLE_BUTTON_IF_ALREADY_ADDED	
	
	bool	OnThemePopup(Control ctrl)
	{
		Tree	tr;
		SaveSettings(tr);
		
		vector<string>		vsThemes;
		vector<string>		vsThemesExcludeLastUsed;
		int					nDefaultOffset = 0;
		int					nSel = PrepareThemes(nDefaultOffset, vsThemes, vsThemesExcludeLastUsed, tr);
		
		///Jasmine 03/06/2012 ORG-5225-P1 DISABLE_SAVE_MENU_WHEN_THEME_IN_EXE_FOLDER_IS_SELECTED
		//DataInfoThemeMenu	menu(TRUE, vsThemesExcludeLastUsed.GetSize(), TRUE, vsThemes, nSel);
		Control				btnSaveTheme = GetItem(IDC_JUNK);
		DataInfoThemeMenu	menu(btnSaveTheme? btnSaveTheme.Enable : TRUE, vsThemesExcludeLastUsed.GetSize(), TRUE, vsThemes, nSel);
		///End DISABLE_SAVE_MENU_WHEN_THEME_IN_EXE_FOLDER_IS_SELECTED
		
		RECT 				rr;
		ctrl.GetClientRect(&rr);
		ctrl.ClientToScreen(&rr);
		menu.TrackPopupMenu(0,  rr.right, rr.top, GetSafeHwnd());
		
		int					nCmd;
		if( menu.GetCommand(nCmd) )
		{
			HandleThemeCmd(nCmd, tr, vsThemes, nDefaultOffset);
			///------ Folger 09/15/2011 ORG-3718-P3 PROPER_THEME_NAME_HANDLONG_IN_DATA_DISPLAY_SETTINGS
			tr.GetAttribute(STR_THEME_FILE_ATTRIB, m_strThemeFile);
			///------ End PROPER_THEME_NAME_HANDLONG_IN_DATA_DISPLAY_SETTINGS
		}
		
		return true;
	}

	virtual	void	HandleThemeCmd(int nCmd, TreeNode& tr, vector<string>& vsThemes, int nDefaultOffset = 0)
	{
		switch ( nCmd )
		{
		case THEME_MENU_SAVE_TO_GRAPH:
		case THEME_MENU_SAVE_TO_LAYER:
		case THEME_MENU_SAVE_TO_PLOT:
			{
				GraphPage	gp;
				GraphLayer	gl;
				DataPlot	dp;
				GetRelatedObj(&gp, &gl, &dp);

				OriginObject	obj;
				switch ( nCmd )
				{
				case THEME_MENU_SAVE_TO_GRAPH:
					m_strThemeFile = STR_GRAPH_THEME;
					obj = gp;
					break;
				case THEME_MENU_SAVE_TO_LAYER:
					m_strThemeFile = STR_LAYER_THEME;
					obj = gl;
					break;
				case THEME_MENU_SAVE_TO_PLOT:
					m_strThemeFile = STR_PLOT_THEME;
					obj = dp;
					break;
				}

				if ( obj )
				{
					tr.SetAttribute(STR_THEME_FILE_ATTRIB, m_strThemeFile);
					SaveThemeIntoObj(tr, obj);
					LoadThemeFilesToCombo(tr);
				}
			}
			break;

		case THEME_MENU_RESET:
			m_strThemeFile.Empty();
			GetDefaultSettings(tr, TRUE);
			goto _default;
			
		case THEME_MENU_SAVE:
			int		nMenuID = -1;
			if ( m_strThemeFile.Compare(STR_GRAPH_THEME) == 0 )
				nMenuID = THEME_MENU_SAVE_TO_GRAPH;
			else if ( m_strThemeFile.Compare(STR_LAYER_THEME) == 0 )
				nMenuID = THEME_MENU_SAVE_TO_LAYER;
			else if ( m_strThemeFile.Compare(STR_PLOT_THEME) == 0 )
				nMenuID = THEME_MENU_SAVE_TO_PLOT;

			if ( nMenuID >= 0 )
			{
				HandleThemeCmd(nMenuID, tr, vsThemes, nDefaultOffset);
				break;
			}
			goto _default;

		_default:
		default:
			DynaDlg::HandleThemeCmd(nCmd, tr, vsThemes, nDefaultOffset);
		}

		if ( THEME_MENU_SAVE_AS == nCmd || nCmd >= THEME_MENU_LOADING_START )
		{
			tr.GetAttribute(STR_THEME_FILE_ATTRIB, m_strThemeFile);
		}

		if ( THEME_MENU_RESET == nCmd || nCmd >= THEME_MENU_LOADING_START )
		{
			LoadSettings(tr);
			DisplayTab(m_nCurrTab);
			///------ Folger 06/17/10 ORG-316-P2 APPLY_FAILED_TO_ENABLE_AFTER_LOAD_THEME
			enableApply();
			///------ End APPLY_FAILED_TO_ENABLE_AFTER_LOAD_THEME
		}
	}
	
	virtual BOOL LoadTheme(TreeNode& trGetN, LPCSTR lpcszThemeName)
	{
		OriginObject	obj;
		obj = GetRelatedObj(NULL, NULL, NULL, lpcszThemeName);
		if ( obj )
		{
			Tree			trTheme;
			if ( !tree_get_binary_storage(trTheme, obj, STR_DATA_INFO_SETTINGS_STORAGE_NAME) )
				return FALSE;
			
			vector<int>		vnIDs;
			vector<string>	vsValues;
			string			strDes;
			if ( octree_get_theme(&trTheme, &vnIDs, &vsValues, &strDes) )
			{
				int nDupID = 0;
				int nn = tree_set_values_by_ids(trGetN, vnIDs, vsValues, 0, &nDupID, 0);
				if ( nDupID )
				{
					O_A_FAIL;
					return FALSE;
				}
			}
			trGetN.SetAttribute(STR_THEME_FILE_ATTRIB, lpcszThemeName);
			return TRUE;
		}

		return DynaDlg::LoadTheme(trGetN, lpcszThemeName);
	}

	virtual	void	DeleteOneTheme(LPCSTR lpcszTheme, LPCSTR lpcszClassOption, LPCSTR lpcszPath)
	{
		OriginObject	obj;
		obj = GetRelatedObj(NULL, NULL, NULL, lpcszTheme);
		if ( obj )
		{
			obj.SetMemory(STR_DATA_INFO_SETTINGS_STORAGE_NAME, NULL);
			return;
		}

		DynaDlg::DeleteOneTheme(lpcszTheme, lpcszClassOption, lpcszPath);
	}

	OriginObject	GetRelatedObj(GraphPage* pgp, GraphLayer* pgl, DataPlot* pdp, LPCSTR lpcszTheme = NULL)
	{
		DataPlot	dp = *m_DataInfoList.DataPlotPtr();
		GraphLayer	gl;
		GraphPage	gp;
		if ( dp )
			dp.GetParent(gl);
		if ( gl )
			gl.GetParent(gp);

		if ( pgp )
			*pgp = gp;
		if ( pgl )
			*pgl = gl;
		if ( pdp )
			*pdp = dp;

		if ( lpcszTheme )
		{
			if ( lstrcmp(lpcszTheme, STR_GRAPH_THEME) == 0 )
				return gp;
			if ( lstrcmp(lpcszTheme, STR_LAYER_THEME) == 0 )
				return gl;
			if ( lstrcmp(lpcszTheme, STR_PLOT_THEME) == 0 )
				return dp;
		}

		OriginObject	objJunk;
		return objJunk;
	}

private:
	EVENTS_BEGIN
		ON_INIT(OnInitDialog)
		ON_DESTROY(OnDestroy)
		ON_OK(OnOK)
		ON_BN_CLICKED(IDC_APPLY, OnApply)
		ON_BN_CLICKED(IDC_THEME_POPUP, OnThemePopup)
		///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
		/// Iris 2/22/2012 ORG-5019-S2 IMPROVE_COORDINATES_BUTTON
		//ON_BN_CLICKED(IDC_BTN_SRC_POPUP, OnSrcPopup)
		ON_BN_CLICKED(IDC_BTN_DATA_INDEX, OnSrcIndex)
		ON_BN_CLICKED(IDC_BTN_DATA_X, OnSrcX)
		ON_BN_CLICKED(IDC_BTN_DATA_Y, OnSrcY)
		ON_BN_CLICKED(IDC_BTN_DATA_Z, OnSrcZ)
		ON_BN_CLICKED(IDC_BTN_DATA_XDATA, OnSrcXIndex)
		ON_BN_CLICKED(IDC_BTN_DATA_YDATA, OnSrcYIndex)
		ON_BN_CLICKED(IDC_BTN_DATA_ZDATA, OnSrcZIndex)
		ON_BN_CLICKED(IDC_BTN_DATA_SEPRATOR, OnSrcSep)
		///End IMPROVE_COORDINATES_BUTTON
		///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS

		///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
		ON_BN_CLICKED(IDC_ADD_COLUMN_HEADING, OnCheckColHeader)
		///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO

		///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
		ON_BN_CLICKED(IDC_BTN_SELECT, OnSelect)
		ON_BN_CLICKED(IDC_BTN_REMOVE, OnRemove)
		ON_BN_CLICKED(IDC_BTN_UP, OnMoveUp)
		ON_BN_CLICKED(IDC_BTN_DOWN, OnMoveDown)
		ON_GRID_SEL_CHANGE(IDC_DATA_AVAILABLE, OnSelRowChange)
		ON_GRID_SEL_CHANGE(IDC_DATA_SELECTED, OnSelRowChange)
		ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)
		///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
		/// Iris 2/23/2012 ORG-5124-S1 ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB
		/*
		///------ Folger 07/02/10 ORG-436-S1 TOOLTIP_NEEDED_FOR_DATA_INFO_RWO_SELECTION_LIST
		ON_GRID_MOUSE_MOVE(IDC_DATA_AVAILABLE, OnMouseMoveOnDataList)
		ON_GRID_MOUSE_MOVE(IDC_DATA_SELECTED, OnMouseMoveOnDataList)
		///------ End TOOLTIP_NEEDED_FOR_DATA_INFO_RWO_SELECTION_LIST
		*/
		///End ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB
		ON_GETNDLG_MSGS(IDC_DISPLAY_SETTINGS)

		ON_GRID_BEFORE_EDIT(IDC_DATA_INFO_ARRAGEMENT, OnBeforeEditDataInfo)
		ON_GRID_AFTER_EDIT(IDC_DATA_INFO_ARRAGEMENT, OnAfterEditDataInfo)
		ON_GRID_CELL_CHANGE(IDC_DATA_INFO_ARRAGEMENT, OnEditDataInfo)
		ON_GRID_AFTER_MOVE_COLUMNS(IDC_DATA_INFO_ARRAGEMENT, OnAfterMoveColumns)
		///Sophy 2/23/2012 ORG-5131-P2 GRIDCONTROL_COMBO_CLOSEUP_SHOULD_CHECK_TRIGGER_CELL_CHANGE_EVENT
		ON_GRID_COMBO_CLOSEUP(IDC_DATA_INFO_ARRAGEMENT, OnComboCloseup)
		///end GRIDCONTROL_COMBO_CLOSEUP_SHOULD_CHECK_TRIGGER_CELL_CHANGE_EVENT

		ON_TAB_SEL_CHANGE(IDC_DATA_INFO_TAB, OnTabChange)
		
		ON_CONTEXTMENU(OnShowMenu)
		ON_USER_MSG(WM_USER_SEL_DATA_LIST_DEL_ROW_MSG, OnSelectedDataListRemovedRow) /// Iris 2/29/2012 ORG-5108-S2 DISABLE_BUTTON_IF_ALREADY_ADDED
EVENTS_END

	BOOL	OnInitDialog()
	{
		///Jasmine 02/27/2012 ORG-5121-S1 SHOW_ACTIVE_DATA_RANGE_STR_ON_TITLE
		//DataInfoUpdateHelper::UpdateTitle
		Text = _L("Data Info Report Settings");
		if ( m_DataInfoList.DataPlotPtr()->IsValid() )
		{
			DataPlot	dp = *m_DataInfoList.DataPlotPtr();
			GraphLayer	gl;
			dp.GetParent(gl);
			
			DWORD 		dwCntrl = NTYPE_FOR_RANGE;
			if ( is_same_layer(Project.ActiveLayer(), gl) )
				dwCntrl = NTYPE_BOOKSHEET_XY_RANGE;
				
			string 		strRange;
			if( dp.GetRangeString(strRange, dwCntrl) )
				Text += " - " + strRange;
		}
		///End SHOW_ACTIVE_DATA_RANGE_STR_ON_TITLE
		
		BOOL	bRet = ResizeDialog::OnInitDialog();

		m_DataInfoList.Init(IDC_DATA_INFO_ARRAGEMENT, *this);		

		///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
		m_DataAvailable.Init(IDC_DATA_AVAILABLE, *this);
		m_DataSelected.Init(IDC_DATA_SELECTED, *this);		
		///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
		/// Iris 2/24/2012 ORG-5124-S2 SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST
		m_DataAvailable.SetRelatedList(&m_DataSelected);
		m_DataSelected.SetRelatedList(&m_DataAvailable);
		///End SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST

		///Sophy 6/11/2010 ORG-120-S21 BITMAP_FOR_UP_DOWN_BUTTONS_ON_ROWS_TAB
		vector<string> vsTips;
		BitmapRadioButton btnUp = GetItem(IDC_BTN_UP);
		btnUp.Init(1, IDB_ARROW_UP, 16, vsTips);
		BitmapRadioButton btnDown = GetItem(IDC_BTN_DOWN);
		btnDown.Init(1, IDB_ARROW_DOWN, 16, vsTips);
		///end BITMAP_FOR_UP_DOWN_BUTTONS_ON_ROWS_TAB

		/// Iris 2/22/2012 ORG-5019-S2 IMPROVE_COORDINATES_BUTTON
		vector<string> vsSrcBtnTips;
		string strTips = STR_SRC_BTN_TIPS;
		strTips.GetTokens(vsSrcBtnTips, '|');		
		for(int ii = 0; ii < vsSrcBtnTips.GetSize() && l_nSrcBtnIDs[ii] > 0; ++ii)
		{						
			Control btnSrc = GetItem(l_nSrcBtnIDs[ii]);
			btnSrc.SetToolTip(vsSrcBtnTips[ii]);
		}	
		///End IMPROVE_COORDINATES_BUTTON
		
		///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
		m_chkColHeader = GetItem(IDC_ADD_COLUMN_HEADING);
		///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO

		LoadSettings(m_trSettings);
		InitDynaControl(IDC_DISPLAY_SETTINGS);

		Tree	trJunk;
		SaveSettings(trJunk);
		InitThemeControls(this, trJunk, IDC_PARAMS_THEME, IDC_PARAMS_THEME_LABEL, IDC_JUNK, IDC_THEME_POPUP, 0, 0);
		BitmapRadioButton	m_btnThemePopup = GetItem(IDC_THEME_POPUP);
		m_btnThemePopup.Init(1, IDB_DROP_DOWN_UP, 16, vsTips);
		
		/// Kenny 03/13/2012 ORG-5146-P1 TAB_CONTROL_FLICKERS_AND_BAD_BACKGROUND_IN_OC
		//m_tab = GetItem(IDC_DATA_INFO_TAB);
		//m_tab.InsertItem(DISTAB_TITLE, _L("Title"));
		///// Iris 2/22/2012 ORG-5019-S1 RENAME_CONTROLS_IN_ROWS_TAB
		////m_tab.InsertItem(DISTAB_ROWS, _L("Data Group Rows"));
		//m_tab.InsertItem(DISTAB_ROWS, _L("Rows"));
		/////End RENAME_CONTROLS_IN_ROWS_TAB
		///// Iris 2/22/2012 ORG-5108-S1 IMPROVE_DATA_INFO_FOR_COLUMNS_TAB
		////m_tab.InsertItem(DISTAB_COLS, _L("Report Columns"));
		//m_tab.InsertItem(DISTAB_COLS, _L("Columns"));
		/////End IMPROVE_DATA_INFO_FOR_COLUMNS_TAB
		//m_tab.InsertItem(DISTAB_DISPLAY, _L("Display"));
		//CurrTabInReg(m_nCurrTab, TRUE);
		//m_tab.SetCurSel(m_nCurrTab);
		InitTabControl();
		/// End TAB_CONTROL_FLICKERS_AND_BAD_BACKGROUND_IN_OC
		DisplayTab(m_nCurrTab);

		enableApply(false);
		SetInitReady(true);	///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
		return bRet;
	}
	
	BOOL	OnDestroy()
	{
		CurrTabInReg(m_nCurrTab, FALSE);
		return ResizeDialog::OnDestroy();
	}
	
	BOOL	UpdateTreeFromDyna()
	{		
		switch ( m_nCurrTab )
		{
		case DISTAB_TITLE:
			m_trTitle.Replace(GetTree(), TRUE, TRUE);
			break;
			
		case DISTAB_ROWS:
			break;
			
		case DISTAB_COLS:
			break;
			
		case DISTAB_DISPLAY:
			m_trDisplay.Replace(GetTree(), TRUE, TRUE);
			break;
			
		default:
			O_A_FAIL;
			return FALSE;
		}
		return TRUE;
	}

	BOOL	OnTabChange(Control ctrl)
	{
		UpdateTreeFromDyna();
		return DisplayTab(m_nCurrTab = m_tab.GetCurSel());
	}
	
	BOOL	OnOK()
	{
		///------ Folger 03/02/2012 ORG-5199-P1 DATA_INFO_WINDOW_SHOULD_UPDATE_LAST_POINT_IF_THERE_IS_NO_DATA_READER
		//SaveOnApply();
		Apply();
		///------ End DATA_INFO_WINDOW_SHOULD_UPDATE_LAST_POINT_IF_THERE_IS_NO_DATA_READER
		return TRUE;
	}

	BOOL	OnApply(Control ctrl)
	{
		///------ Folger 03/02/2012 ORG-5199-P1 DATA_INFO_WINDOW_SHOULD_UPDATE_LAST_POINT_IF_THERE_IS_NO_DATA_READER
		//SaveOnApply();
		//UpdateDataInfoWindow();
		Apply();
		///------ End DATA_INFO_WINDOW_SHOULD_UPDATE_LAST_POINT_IF_THERE_IS_NO_DATA_READER
		enableApply(false);
		return TRUE;
	}

	///------ Folger 03/02/2012 ORG-5199-P1 DATA_INFO_WINDOW_SHOULD_UPDATE_LAST_POINT_IF_THERE_IS_NO_DATA_READER
	void	Apply()
	{
		SaveOnApply();
		DataInfoDlg(DATAINFODLGMSG_UPDATEDATAINFOWINDOW);
	}
	///------ End DATA_INFO_WINDOW_SHOULD_UPDATE_LAST_POINT_IF_THERE_IS_NO_DATA_READER

	///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
	BOOL	OnCheckColHeader(Control ctrl)
	{
		///------ Folger 03/28/2012 ORG-5383-P1 THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
		//enableApply();
		AfterValueChange();
		///------ End THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
		return TRUE;
	}
	///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO

	///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
	BOOL	OnSelect(Control ctrl)
	{
		vector<string> vsLeft;
		m_DataAvailable.GetSelectItems(vsLeft);
		/// Iris 2/29/2012 ORG-5108-S4 INSERT_ITEMS_AFTER_THE_SELECTED_ROW_IN_DATA_SELECTED_LIST
		//m_DataSelected.AppendItems(vsLeft);
		m_DataSelected.AppendOrInsertItems(vsLeft);
		///End INSERT_ITEMS_AFTER_THE_SELECTED_ROW_IN_DATA_SELECTED_LIST
		
		/// Iris 2/24/2012 ORG-5124-S2 SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST
		m_DataAvailable.CheckUpdateBoldStatus();
		m_DataSelected.CheckUpdateBoldStatus();
		///End SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST
		UpdateEnableStatusAfterDataSelected(); /// Iris 2/29/2012 ORG-5108-S2 DISABLE_BUTTON_IF_ALREADY_ADDED
		updateButtonsOnselection();
		///------ Folger 03/28/2012 ORG-5383-P1 THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
		//enableApply();
		AfterValueChange();
		///------ End THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
		return TRUE;
	}
	
	BOOL	OnRemove(Control ctrl)
	{
		/// Iris 2/23/2012 ORG-5124-S1 ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB
		//vector<string> vsRight;
		//m_DataSelected.GetSelectItems(vsRight);
		///End ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB
		m_DataSelected.RemoveSelectItems();
		/// Iris 2/24/2012 ORG-5124-S2 SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST
		m_DataAvailable.CheckUpdateBoldStatus();
		m_DataSelected.CheckUpdateBoldStatus();
		///End SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST
		UpdateEnableStatusAfterDataSelected(); /// Iris 2/29/2012 ORG-5108-S2 DISABLE_BUTTON_IF_ALREADY_ADDED
		updateButtonsOnselection();
		///------ Folger 03/28/2012 ORG-5383-P1 THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
		//enableApply();
		AfterValueChange();
		///------ End THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
		return TRUE;
	}
	
	BOOL	OnMoveUp(Control ctrl)
	{		
		vector<uint> vnRows;
		m_DataSelected.GetSelRows(vnRows);
		/// Iris 2/24/2012 ORG-5109-S3 SUPPORT_MOVE_UP_DOWN_MULTIPLE_ROWS
		/*
		ASSERT(vnRows.GetSize() == 1);
		
		enableApply();
		return m_DataSelected.MoveItemUp(vnRows[0]);
		*/		
		if( vnRows.GetSize() > 0 && min( vnRows ) > m_DataSelected.GetRowOffset() )
		{
			vector<int> vnSelRows;
			for(int ii = 0; ii < vnRows.GetSize(); ++ii)
			{
				m_DataSelected.MoveItemUp( vnRows[ii] );
				vnSelRows.Add( vnRows[ii] - 1 );
			}
			m_DataSelected.SelRows( vnSelRows );
			///------ Folger 03/28/2012 ORG-5383-P1 THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
			//enableApply();
			AfterValueChange();
			///------ End THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
			return true;
		}
		return false;
		///End SUPPORT_MOVE_UP_DOWN_MULTIPLE_ROWS
	}
	
	BOOL	OnMoveDown(Control ctrl)
	{
		vector<uint> vnRows;
		m_DataSelected.GetSelRows(vnRows);
		/// Iris 2/24/2012 ORG-5109-S3 SUPPORT_MOVE_UP_DOWN_MULTIPLE_ROWS
		/*
		ASSERT(vnRows.GetSize() == 1);
		
		enableApply();
		return m_DataSelected.MoveItemDown(vnRows[0]);
		*/
		if( vnRows.GetSize() > 0 && max( vnRows ) < m_DataSelected.GetRows() - 1 )
		{
			vector<int> vnSelRows;
			for(int ii = vnRows.GetSize() - 1; ii >= 0; --ii)
			{
				m_DataSelected.MoveItemDown( vnRows[ii] );
				vnSelRows.Add( vnRows[ii] + 1 );
			}
			m_DataSelected.SelRows( vnSelRows );
			///------ Folger 03/28/2012 ORG-5383-P1 THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
			//enableApply();
			AfterValueChange();
			///------ End THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
			return true;
		}
		return false;
		///End SUPPORT_MOVE_UP_DOWN_MULTIPLE_ROWS
	}
	
	BOOL	OnSelRowChange(Control ctrl)
	{
		if ( IsInitReady() )
		{
			updateButtonsOnselection();
			return TRUE;
		}
		return FALSE;
	}

	/// Iris 2/23/2012 ORG-5124-S1 ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB
	// we can resize columns now, so no need to display the current cell as tooltips
	/*
	///------ Folger 07/02/10 ORG-436-S1 TOOLTIP_NEEDED_FOR_DATA_INFO_RWO_SELECTION_LIST	
	void	OnMouseMoveOnDataList(Control cntrl, short nButton, short nShift, float X, float Y)
	{
 		DataRowList*		pList = &m_DataSelected; 		
 		if ( cntrl.GetSafeHwnd() == m_DataAvailable.GetCtrnlSafeHwnd() )
 			pList = &m_DataAvailable;

		int	nRow, nCol;
		if ( !pList->GetMouseCell(nRow, nCol) || nRow < 0 || nCol < 0 )
			return;

		string	str = pList->GetCell(nRow, nCol);
		pList->SetToolTipsText(str);
	}
	///------ End TOOLTIP_NEEDED_FOR_DATA_INFO_RWO_SELECTION_LIST
	*/
	///End ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB
	
	void	OnAfterValueChange(int nRow, int nCol)
	{
		///------ Folger 03/28/2012 ORG-5383-P1 THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
		//enableApply();
		AfterValueChange();
		///------ End THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
	}
	///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG	
	void	OnBeforeEditDataInfo(Control flxControl, long nRow, long nCol, BOOL* pCancel)
	{
		m_DataInfoList.OnBeforeEdit(nRow, nCol, pCancel);
	}
	
	void	OnAfterEditDataInfo(Control flxControl, int nRow, int nCol)
	{
		m_DataInfoList.OnAfterEdit(nRow, nCol);
		///------ Folger 03/28/2012 ORG-5383-P1 THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
		//enableApply();
		AfterValueChange();
		///------ End THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
	}
	///Sophy 2/23/2012 ORG-5131-P2 GRIDCONTROL_COMBO_CLOSEUP_SHOULD_CHECK_TRIGGER_CELL_CHANGE_EVENT
	void	OnComboCloseup(Control flxControl, int nRow, int nCol, BOOL* pFinish)
	{
		OnEditDataInfo(flxControl, nRow, nCol);
		if ( pFinish )
			*pFinish = TRUE;
	}
	///end GRIDCONTROL_COMBO_CLOSEUP_SHOULD_CHECK_TRIGGER_CELL_CHANGE_EVENT
	
	void	OnEditDataInfo(Control flxControl, int nRow, int nCol)
	{
		m_DataInfoList.OnEdit(nRow, nCol);
	}

	void	OnAfterMoveColumns(Control flxControl, long lCol, long *pnPosition)
	{
		///------ Folger 03/28/2012 ORG-5383-P1 THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
		//enableApply();
		AfterValueChange();
		///------ End THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
		///------ Folger 06/23/10 ORG-372-S4 ADD_COLUMN_INDEX_TO_GRID_HEADING
		m_DataInfoList.ResetColHeading();
		///------ End ADD_COLUMN_INDEX_TO_GRID_HEADING
	}

	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny)
	{
		/// Iris 2/23/2012 ORG-5124-S1 ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB
		//if ( DISTAB_COLS != m_nCurrTab )
		//	return FALSE;		
		if( DISTAB_COLS == m_nCurrTab )
		{
		///End ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB
			///------ Folger 08/06/10 ORG-502-P5 CONTEXT_MENU_OF_ADD_DELETE_COL_SHOULD_ONLY_SHOW_IN_GRID_TABLE
			RECT	rr;
			m_DataInfoList.GetWindowRect(rr);
			POINT	pt;
			pt.x = nx, pt.y = ny;
			if ( !pt_in_rect(rr, pt) )
				return FALSE;
			///------ End CONTEXT_MENU_OF_ADD_DELETE_COL_SHOULD_ONLY_SHOW_IN_GRID_TABLE
			
			int		nRow = -1, nCol = -1;
			m_DataInfoList.GetMouseCell(nRow, nCol);
			
			DWORD	dwCntrl = 0;
			if ( nCol < m_DataInfoList.GetColOffset() )
				O_ADD_BIT(dwCntrl, DDCM_CNTRL_NO_DELETE_COL);
			DataInfoControlMenu		menu(dwCntrl);
			menu.TrackPopupMenu(0,  nx, ny, GetSafeHwnd());
			
			int		nCmd;
			if( menu.GetCommand(nCmd) )
			{
				BOOL	bEnabled = TRUE;
				switch ( nCmd )
				{
				case DDCM_ID_ADD_COL:
					m_DataInfoList.AddDefaultColumn();
					break;
					
				case DDCM_ID_DELETE_COL:
					m_DataInfoList.DeleteCol(nCol);
					m_DataInfoList.ResetColHeading();
					break;
					
				default:
					bEnabled = FALSE;
					break;
				}
				if ( bEnabled )
					///------ Folger 03/28/2012 ORG-5383-P1 THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
					//enableApply();
					AfterValueChange();
				///------ End THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
			}
		}
		/// Iris 2/23/2012 ORG-5124-S1 ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB
		else if( DISTAB_ROWS == m_nCurrTab )
		{
			if ( IDC_DATA_AVAILABLE == nResIDCtrl )
			{
				m_DataAvailable.OnContextMenu(nx, ny);				
			}
			else if ( IDC_DATA_SELECTED == nResIDCtrl )
			{
				m_DataSelected.OnContextMenu(nx, ny);				
			}
		}
		///End ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB
		
		return TRUE;
	}

	/// Iris 2/29/2012 ORG-5108-S2 DISABLE_BUTTON_IF_ALREADY_ADDED
	BOOL OnSelectedDataListRemovedRow(uint wParam, uint lParam)
	{
		UpdateEnableStatusAfterDataSelected();
		///------ Folger 03/28/2012 ORG-5383-P1 THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
		//enableApply(); /// Iris 3/12/2012 ORG-5109-P6 FAIL_TO_DEL_ALL_ROWS_IN_SELECTED_DATA_LIST
		AfterValueChange();
		///------ End THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
		return TRUE;
	}
	///End DISABLE_BUTTON_IF_ALREADY_ADDED
	
	BOOL	DisplayTab(int nTab)
	{
		Control		DataInfoGrid = GetItem(IDC_DATA_INFO_ARRAGEMENT);
		Control		DataInfoDyna = GetItem(IDC_DISPLAY_SETTINGS);
		Control		HintModifyColumn = GetItem(IDC_HINT_MODIFY_COLUMN);
		///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
		Control		DataAvailable = GetItem(IDC_DATA_AVAILABLE);
		Control		DataSelected = GetItem(IDC_DATA_SELECTED);
		Control		BtnUp = GetItem(IDC_BTN_UP);
		Control		BtnDown = GetItem(IDC_BTN_DOWN);
		Control		BtnSelect = GetItem(IDC_BTN_SELECT);
		Control		BtnRemove = GetItem(IDC_BTN_REMOVE);
		Control		TextRange = GetItem(IDC_BOOKSHEET_COLUMN);
		Control		TextShowData = GetItem(IDC_DATA_TO_SHOW);
		///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
		/// Iris 2/22/2012 ORG-5019-S2 IMPROVE_COORDINATES_BUTTON
		//Control		BtnSrcPopup = GetItem(IDC_BTN_SRC_POPUP);
		//BtnSrcPopup.Visible =
		for(int ii = 0; l_nSrcBtnIDs[ii] > 0; ++ii)
		{
			Control ctrlSrc = GetItem(l_nSrcBtnIDs[ii]);
			ctrlSrc.Visible = FALSE;
		}
		///End IMPROVE_COORDINATES_BUTTON
		///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
		///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
		m_chkColHeader.Visible =
		///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
		DataAvailable.Visible =
		DataSelected.Visible =
		BtnUp.Visible =
		BtnDown.Visible =
		BtnSelect.Visible =
		BtnRemove.Visible =
		TextRange.Visible =
		TextShowData.Visible =
		///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
		DataInfoGrid.Visible =
		DataInfoDyna.Visible = 
		HintModifyColumn.Visible = FALSE;

		switch ( nTab )
		{
		case DISTAB_TITLE:
		case DISTAB_DISPLAY:
			DataInfoDyna.Visible = TRUE;
			SetInputTree(DISTAB_TITLE == nTab ? GetTitle(FALSE) : GetDisplay(FALSE));
			UpdateDynaControl(true, GETNEVENT_ON_INIT, true, 0, true);
			break;

		case DISTAB_ROWS:
			///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
			/// Iris 2/22/2012 ORG-5019-S1 RENAME_CONTROLS_IN_ROWS_TAB
			/*
			string strRng = "";
			if ( m_DataInfoList.DataPlotPtr()->IsValid() )
				m_DataInfoList.DataPlotPtr()->GetRangeString(strRng, NTYPE_BOOKSHEET_XY_RANGE);
			TextRange.Text = strRng;
			*/
			///End RENAME_CONTROLS_IN_ROWS_TAB
			
			/// Iris 2/22/2012 ORG-5019-S2 IMPROVE_COORDINATES_BUTTON
			for(int ii = 0; l_nSrcBtnIDs[ii] > 0; ++ii)
			{
				Control ctrlSrc = GetItem(l_nSrcBtnIDs[ii]);
				ctrlSrc.Visible = TRUE;
			}			
			///End IMPROVE_COORDINATES_BUTTON
			
			DataAvailable.Visible =
			DataSelected.Visible =
			BtnUp.Visible =
			BtnDown.Visible =
			BtnSelect.Visible =
			BtnRemove.Visible =
			///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
			// BtnSrcPopup.Visible = /// Iris 2/22/2012 ORG-5019-S2 IMPROVE_COORDINATES_BUTTON
			///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
			TextRange.Visible =
			TextShowData.Visible = TRUE;
			updateButtonsOnselection();
			///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
			break;

		case DISTAB_COLS:
			HintModifyColumn.Visible = 
			DataInfoGrid.Visible = 
			///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
			m_chkColHeader.Visible = TRUE;
			///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
			break;

		default:
			O_A_FAIL;
			return FALSE;
		}

		Invalidate(); /// Iris 3/02/2012 ORG-5109-P5 FIX_COORDINATES_BUTTON_MESS_UP

		Resize(nTab);
		return TRUE;
	}

	/// virtual
	void	resizeDlgToFit(int cx = 0, int cy = 0)
	{
		Resize(m_tab.GetCurSel());
	}

	BOOL	Resize(int nTab)
	{
		int		nGap = GetControlGap();
		SIZE	sz;
		switch ( nTab )
		{
		case DISTAB_TITLE:
		case DISTAB_DISPLAY:
			TREE_CTRL_VAR.GetOptimalSize(sz);
			break;
			
		case DISTAB_ROWS:
			///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
			{
				RECT	rr;
				GetClientRect(GetItem(IDC_BOOKSHEET_COLUMN), rr);
				int		nHeightLeft = m_DataAvailable.GetTotalRowsHeight();
				int		nHeightRight = m_DataSelected.GetTotalRowsHeight();
				///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
				//RECT	rbtn;
				//GetClientRect(GetItem(IDC_BTN_SELECT), rbtn);
				//int		nMinHeight = RECT_HEIGHT(rbtn) * 2 + 4 * nGap;
				int		nMinHeight = GetRowTabHeight(TRUE);
				int		nMaxHeight = GetRowTabHeight(FALSE);
				///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
				nMinHeight = max(nMinHeight, nHeightLeft);
				nMinHeight = max(nMinHeight, nHeightRight);
				nMinHeight = min(nMinHeight, nMaxHeight);
				///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
				sz.cy = nMinHeight + RECT_HEIGHT(rr) + 2 * nGap;
				///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
			}
			///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
			break;
			
		case DISTAB_COLS:
			{
				RECT	rr1;
				GetClientRect(GetItem(IDC_HINT_MODIFY_COLUMN), rr1);
				///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
				RECT	rr2;
				GetClientRect(m_chkColHeader, rr2);
				///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
				sz.cy = m_DataInfoList.GetTotalRowsHeight() + RECT_HEIGHT(rr1) + RECT_HEIGHT(rr2) + 3 * nGap;
			}
			break;
			
		default:
			O_A_FAIL;
			return FALSE;
		}

		MoveControlsHelper	_temp(this);

		Button	btnOK;
		RECT	rrOK;
		GetControlClientRect(IDOK, rrOK, &btnOK);

		ComboBox	combo;
		RECT		rrCombo;
		GetControlClientRect(IDC_PARAMS_THEME, rrCombo, &combo);

		int		nTotalHeight = RECT_HEIGHT(rrCombo) + sz.cy + RECT_HEIGHT(rrOK) + 12 * nGap;
		
		uint	btnIDs[] = { IDCANCEL
			, IDOK
			, IDC_APPLY
			, 0
		};
		
		int		nTotalWidth = 0;
		for ( int ii=0; btnIDs[ii]; ++ii )
		{
			RECT	rr;
			GetClientRect(GetItem(btnIDs[ii]), rr);
			nTotalWidth += RECT_WIDTH(rr) + nGap;
		}
		nTotalWidth = nTotalWidth * 4.7 + 3 * nGap;

		/// Resize Theme Controls
		Button	btnPopup;
		RECT	rrPopup;
		GetControlClientRect(IDC_THEME_POPUP, rrPopup, &btnPopup);
		
		Control	themeLabel;
		RECT	rrThemeLabel;
		GetControlClientRect(IDC_PARAMS_THEME_LABEL, rrThemeLabel, &themeLabel);
		///------ Folger 10/25/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE
		CheckResizeThemeLabel(IDC_PARAMS_THEME_LABEL);
		///------ End DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE

		rrCombo.right = rrCombo.left + nTotalWidth - RECT_WIDTH(rrThemeLabel) - RECT_WIDTH(rrPopup) - 7 * nGap;
		MoveControl(combo, rrCombo);

		MoveControl(IDC_THEME_POPUP, rrCombo.right + nGap, rrPopup.top);
		
		RECT	rrWin, rrClient;
		m_wndDlg.GetWindowRect(&rrWin);
		m_wndDlg.GetClientRect(&rrClient);
		int		nNonClientHeight = RECT_HEIGHT(rrWin) - RECT_HEIGHT(rrClient);
		rrWin.right = rrWin.left + nTotalWidth;
		rrWin.bottom = rrWin.top+ nTotalHeight + nNonClientHeight;
		MoveWindow(&rrWin, TRUE);		
		
		ArrangeMainItemAndControls(btnIDs, IDC_DATA_INFO_TAB, NULL, false);
		RECT	rrTab;
		GetClientRect(m_tab, rrTab);
		m_tab.AdjustRect(FALSE, &rrTab);
		///------ Folger 08/10/10 ORG-502-S4 BETTER_BK_COLOR_BETWEEN_DIALOG_AND_CONTROLS
		RECT	rrPanel;
		rrPanel = rrTab;
		rrPanel.left -= nGap / 2;
		MoveControl(GetItem(IDC_DISPLAY_INFO_BK_PANEL), rrPanel);
		///------ End BETTER_BK_COLOR_BETWEEN_DIALOG_AND_CONTROLS
		
		switch ( nTab )
		{
		case DISTAB_TITLE:
		case DISTAB_DISPLAY:
			MoveControl(GetItem(IDC_DISPLAY_SETTINGS), rrTab);
			break;
			
		case DISTAB_ROWS:
			/// Iris 2/22/2012 ORG-5019-S2 IMPROVE_COORDINATES_BUTTON
			/*
			///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
			{
				RECT rr;			
				RECT rr2;
				RECT rr3;
				RECT rr4;
								
				//select, remove buttons
				Control ctrlBtn = GetItem(IDC_BTN_SELECT);
				GetClientRect(ctrlBtn, rr);
				rr2.left = rrTab.left + (RECT_WIDTH(rrTab) - RECT_WIDTH(rr)) / 2;
				rr2.top = rrTab.top + RECT_HEIGHT(rrTab) / 4 + 2 * nGap;
				rr2.right = rr2.left + RECT_WIDTH(rr);
				rr2.bottom = rr2.top + RECT_HEIGHT(rr);
				MoveControl(ctrlBtn, rr2);
				
				ctrlBtn = GetItem(IDC_BTN_REMOVE);
				GetClientRect(ctrlBtn, rr);
				rr3.left = rr2.left;
				rr3.top = rr2.bottom + 2 * nGap;
				rr3.right = rr2.right;
				rr3.bottom = rr3.top + RECT_HEIGHT(rr);
				MoveControl(ctrlBtn, rr3);

				///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS				
				GetControlClientRect(IDC_BTN_SRC_POPUP, rr, &ctrlBtn);
				rr4.left = rr3.left;
				rr4.top = rr3.bottom + 2 * nGap;
				rr4.right = rr3.right;
				rr4.bottom = rr4.top + RECT_HEIGHT(rr);
				MoveControl(ctrlBtn, rr4);				
				///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS

				//book sheet column hint
				Control ctrlHint = GetItem(IDC_BOOKSHEET_COLUMN);
				GetClientRect(ctrlHint, rr);
				rr2.left = rrTab.left + nGap;
				rr2.top = rrTab.top + 2 * nGap;
				rr2.right = rr3.left - 2 * nGap;
				rr2.bottom = rr2.top + RECT_HEIGHT(rr);
				MoveControl(ctrlHint, rr2);				
				
				//up, down buttons
				ctrlBtn = GetItem(IDC_BTN_DOWN);
				GetClientRect(ctrlBtn, rr);
				rr2.top = rrTab.top + nGap;
				rr2.right = rrTab.right - 2 * nGap;
				rr2.bottom = rr2.top + RECT_HEIGHT(rr);
				rr2.left = rr2.right - RECT_WIDTH(rr);
				MoveControl(ctrlBtn, rr2);
				
				ctrlBtn = GetItem(IDC_BTN_UP);
				GetClientRect(ctrlBtn, rr);
				rr4.top = rrTab.top + nGap;
				rr4.bottom = rr4.top + RECT_HEIGHT(rr);
				rr4.right = rr2.left - nGap;
				rr4.left = rr4.right - RECT_WIDTH(rr);
				MoveControl(ctrlBtn, rr4);					
				
				//data to show hint
				ctrlHint = GetItem(IDC_DATA_TO_SHOW);
				GetClientRect(ctrlHint, rr);				
				rr2.left = rr3.right + 2 * nGap;
				rr2.top = rrTab.top + 2 * nGap;
				rr2.right = rr4.left - nGap;  
				rr2.bottom = rr2.top + RECT_HEIGHT(rr);
				MoveControl(ctrlHint, rr2);				
				
				//grid list controls
				Control ctrlGrid = GetItem(IDC_DATA_AVAILABLE);
				GetClientRect(ctrlGrid, rr);
				rr2.left = rrTab.left + nGap;
				rr2.right = rr3.left - 2 * nGap;
				rr2.top = rr4.bottom + 2 * nGap;
				rr2.bottom = rrTab.bottom - nGap;
				MoveControl(ctrlGrid, rr2);
				
				ctrlGrid = GetItem(IDC_DATA_SELECTED);
				GetClientRect(ctrlGrid, rr);
				rr2.left = rr3.right + 2 * nGap;
				rr2.right = rrTab.right - nGap;
				rr2.top = rr4.bottom + 2 * nGap;
				rr2.bottom = rrTab.bottom - nGap;
				MoveControl(ctrlGrid, rr2);
			}
			///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
			*/			
			{
				RECT rr, rrSel, rrRemove, rrLabel1, rrLabel2, rrData1, rrData2, rrDown, rrUp;
				
				//select, remove buttons
				Control ctrl = GetItem(IDC_BTN_SELECT);
				GetClientRect(ctrl, rr);
				rrSel.left = rrTab.left + (RECT_WIDTH(rrTab) - RECT_WIDTH(rr)) / 2;
				rrSel.top = rrTab.top + RECT_HEIGHT(rrTab) / 4 + 2 * nGap;
				rrSel.right = rrSel.left + RECT_WIDTH(rr);
				rrSel.bottom = rrSel.top + RECT_HEIGHT(rr);
				MoveControl(ctrl, rrSel);
				
				ctrl = GetItem(IDC_BTN_REMOVE);
				GetClientRect(ctrl, rr);
				rrRemove.left = rrSel.left;
				rrRemove.top = rrSel.bottom + 2 * nGap;
				rrRemove.right = rrSel.right;
				rrRemove.bottom = rrRemove.top + RECT_HEIGHT(rr);
				MoveControl(ctrl, rrRemove);	
				
				
				// controls under the right of select/remove buttons	
				ctrl = GetItem(IDC_DATA_TO_SHOW);
				ctrl.Visible = false;				
				
				ctrl = GetItem(IDC_BTN_DOWN);
				GetClientRect(ctrl, rr);				
				rrDown.top = rrTab.top + nGap;
				rrDown.right = rrTab.right - 2 * nGap;
				rrDown.bottom = rrDown.top + RECT_HEIGHT(rr);
				rrDown.left = rrDown.right - RECT_WIDTH(rr);
				MoveControl(ctrl, rrDown);
				
				ctrl = GetItem(IDC_BTN_UP);
				GetClientRect(ctrl, rr);
				rrUp.top = rrDown.top;
				rrUp.bottom = rrUp.top + RECT_HEIGHT(rr);
				rrUp.right = rrDown.left - nGap;
				rrUp.left = rrUp.right - RECT_WIDTH(rr);
				MoveControl(ctrl, rrUp);				
				
				int ii = 0;
				int nLeft = rrSel.right + 2 * nGap;
				while( l_nSrcBtnIDs[ii] > 0 )
				{
					RECT rrBtn;
					ctrl = GetItem(l_nSrcBtnIDs[ii]);
					GetClientRect(ctrl, rr);					
					rrBtn.top = rrDown.top;
					rrBtn.bottom = rrBtn.top + RECT_HEIGHT(rr);
					rrBtn.left = nLeft;
					rrBtn.right = rrBtn.left + RECT_WIDTH(rr);
					MoveControl(ctrl, rrBtn);
					
					ii++;
					nLeft = rrBtn.right + nGap;
				}
				
				ctrl = GetItem(IDC_DATA_SELECTED);
				GetClientRect(ctrl, rr);
				rrData2.left = rrSel.right + 2 * nGap;
				rrData2.right = rrTab.right - nGap;
				rrData2.top = rrDown.bottom + nGap;
				rrData2.bottom = rrTab.bottom - nGap;
				MoveControl(ctrl, rrData2);				
				
				// controls under the left of select/remove buttons				
				ctrl = GetItem(IDC_BOOKSHEET_COLUMN);
				GetClientRect(ctrl, rr);
				rrLabel1.left = rrTab.left + 2 * nGap;
				rrLabel1.top = rrTab.top + 2 * nGap;
				rrLabel1.right = rrSel.left - 2 * nGap;
				rrLabel1.bottom = rrLabel1.top + RECT_HEIGHT(rr);
				MoveControl(ctrl, rrLabel1);	
				
				ctrl = GetItem(IDC_DATA_AVAILABLE);
				GetClientRect(ctrl, rr);
				rrData1.left = rrTab.left + nGap;
				rrData1.right = rrSel.left - 2 * nGap;
				rrData1.top = rrData2.top;
				rrData1.bottom = rrTab.bottom - nGap;
				MoveControl(ctrl, rrData1);
			}
			///End IMPROVE_COORDINATES_BUTTON				
			break;
			
		case DISTAB_COLS:
			{
				RECT	rr;
				MoveControl(IDC_HINT_MODIFY_COLUMN, rrTab.left, rrTab.top + nGap);
				GetClientRect(GetItem(IDC_HINT_MODIFY_COLUMN), rr);

				///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
				MoveControl(IDC_ADD_COLUMN_HEADING, rrTab.left, rr.bottom + nGap);
				GetClientRect(m_chkColHeader, rr);
				///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
				
				rrTab.top = rr.bottom + nGap;
				MoveControl(GetItem(IDC_DATA_INFO_ARRAGEMENT), rrTab);
			}
			break;
			
		default:
			O_A_FAIL;
			return FALSE;
		}
		
		return TRUE;
	}

	int		GetRowTabHeight(BOOL bMin)
	{
		int		nScaler = bMin ? 3 : 8;
		RECT	rr;
		GetControlClientRect(IDC_BTN_SELECT, rr);
		return RECT_HEIGHT(rr) * nScaler + 10 * GetControlGap();
	}

	///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
	BOOL	LoadSettings(TreeNode trSettings)
	{
		Tree trLocal;
		if ( !trSettings || !trSettings.FirstNode )
			trSettings = trLocal;
		if ( trSettings.IsEmpty() )
			GetDefaultSettings(trSettings);
		
		//load Title
		InitTitle(trSettings);
		//load Rows
		InitSelection(trSettings);
		//load Columns
		InitColumns(trSettings);
		
		//load Display
		InitDisplay(trSettings);
				
		return TRUE;
	}
	
	BOOL	SaveSettings(TreeNode& trSettings)
	{
		if ( !trSettings )
			return FALSE;

		trSettings.SetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, STR_DATA_INFO_CLASS_SETTINGS);
		trSettings.SetAttribute(STR_THEME_FILE_ATTRIB, m_strThemeFile);
		
		UpdateTreeFromDyna();
		
		//save Title
		SaveTitle(trSettings);
		
		//save Rows
		SaveSelection(trSettings);
		
		//save Columns
		SaveColumns(trSettings);
		
		//save Display
		SaveDisplay(trSettings);
		
		return TRUE;
	}
	
	void	InitDisplay(const TreeNode& trSettings)
	{
		m_trDisplay = tree_check_get_node(trSettings, "Display");
		if ( !m_trDisplay )
		{
			GetDisplay(TRUE);
		}
	}
	
	void	SaveDisplay(TreeNode& trSettings)
	{
		if ( !trSettings )
			return;
		
		TreeNode trDisplay = tree_check_get_node(trSettings, "Display");
		trDisplay.Replace(GetDisplay(FALSE));
		return;
	}
	
	void	InitTitle(const TreeNode& trSettings)
	{
		m_trTitle = tree_check_get_node(trSettings, "Title");
		if ( !m_trTitle )
		{
			GetTitle(TRUE);
		}
	}
	
	void	SaveTitle(TreeNode& trSettings)
	{
		if ( !trSettings )
			return;
		TreeNode trTitle = tree_check_get_node(trSettings, "Title");
		trTitle.Replace(GetTitle(FALSE));
	}

	#define		MAX_LIST_COLUMNS		20

	///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
	void	InitColumns(const TreeNode& trSettings)
	{
		if ( !trSettings )
			return;
		
		TreeNode	trColumns = trSettings.Columns;
		if ( !trColumns )
		{
			O_A_FAIL;
			return;
		}
		m_DataInfoList.ClearAll();

		///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
		m_chkColHeader.Check = trColumns.ColHeader.nVal;
		///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
		
		int		nRowOffset = m_DataInfoList.GetRowOffset();
		int		nColOffset = m_DataInfoList.GetColOffset();
		for ( int ii=0; ii<trColumns.NumCols.nVal && ii<MAX_LIST_COLUMNS; ++ii )
		{
			TreeNode	trColumn = trColumns.GetNode(m_DataInfoList.GetColName(ii + 1));
			if ( !trColumn )
				break;
			
			///------ Folger 06/21/10 ORG-332 NEW_DATA_INFO_SUPPORT_MATRIX_BASED_PLOT
			int		nInfoFrom = ConvertHeaderIndex(trColumn.InfoFrom.nVal, FALSE);
			if ( nInfoFrom < 0 )
				continue;
			///------ End NEW_DATA_INFO_SUPPORT_MATRIX_BASED_PLOT
			
			vector<string>	vs;
			int				nn = LISTROW_INFO_FROM;
			foreach ( TreeNode trNode in trColumn.Children )
			{
				vs.Add(m_DataInfoList.GetRowContentForLoading(trNode.strVal, nn++));
			}
			m_DataInfoList.AddColumn(vs);
		}
	}
	
	///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
	void	IndexToName(const vector<int> vnIndices, vector<string>& vsNames)
	{
		vsNames.SetSize(0);
		int nSize = vnIndices.GetSize();
		for ( int ii = 0; ii < nSize; ii++ )
		{
			///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
			//Column col(m_wksSrc, vnIndices[ii]);
			//if ( vnIndices[ii] == DISSRC_ROW_NUM )
			//{
				//vsNames.Add(STR_SRC_INDEX);
			//}
			//else if ( vnIndices[ii] == DISSRC_XINDEX )
			//{
				//vsNames.Add(STR_SRC_X);
			//}
			//else if ( vnIndices[ii] == DISSRC_YINDEX )
			//{
				//vsNames.Add(STR_SRC_Y);
			//}
			//else if ( vnIndices[ii] == DISSRC_ZINDEX )
			//{
				//vsNames.Add(STR_SRC_Z);
			//}
			//else if ( col.IsValid() )
			//{
				//vsNames.Add(_get_column_notation(col));
			//}
			//else
				//O_A_FAIL;
			string	strName;
			if ( IndexToName(strName, vnIndices[ii]) )
				vsNames.Add(strName);
			///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
		}
	}

	///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
	BOOL	IndexToName(string& strName, int nIndex)
	{
		if ( nIndex == DISSRC_ROW_NUM )
		{
			strName = STR_SRC_INDEX;
		}
		else if ( nIndex == DISSRC_X )
		{
			strName = STR_DISP_X;
		}
		else if ( nIndex == DISSRC_Y )
		{
			strName = STR_DISP_Y;
		}
		else if ( nIndex == DISSRC_Z )
		{
			strName = STR_DISP_Z;
		}
		else if ( nIndex == DISSRC_XINDEX )
		{
			strName = STR_SRC_X;
		}
		else if ( nIndex == DISSRC_YINDEX )
		{
			strName = STR_SRC_Y;
		}
		else if ( nIndex == DISSRC_ZINDEX )
		{
			strName = STR_SRC_Z;
		}
		///------ Folger 07/02/10 ORG-436-S4 DATA_INFO_ROW_SEPARATOR_SUPPORT
		else if ( nIndex == DISSRC_SEP )
		{
			strName = STR_DISP_SEP;
		}
		///------ End DATA_INFO_ROW_SEPARATOR_SUPPORT
		else
		{
			Column col(m_wksSrc, nIndex);
			if ( col )
			{
				/// Iris 2/23/2012 ORG-5124-S1 ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB
				//strName = _get_column_notation(col);
				strName = col.GetDatasetName();
				///End ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB
			}
			else
			{
				//O_A_FAIL;
				return FALSE;
			}
		}

		return TRUE;
	}
	///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS

	void	InitSelection(const TreeNode& trSettings)
	{
		if ( !trSettings.IsValid() || !trSettings.Rows )
			return;
		
		if ( !m_wksSrc.IsValid() )
		{
			DataRange drSrc;
			if ( m_DataInfoList.DataPlotPtr()->IsValid() && m_DataInfoList.DataPlotPtr()->GetDataRange(drSrc) )
			{
				int nC1, nC2;
				drSrc.GetRange(m_wksSrc, nC1, nC2);
			}
		}
		
		//TreeNode trLeft = trSettings.Rows.LeftGrid; ///Sophy 6/13/2010 ORG-120-P16 INIT_COLS_LIST_FROM_SRC_WORKSHEET
		TreeNode trRight = trSettings.Rows.RightGrid;
		vector<int> vnLeft, vnRight;
		
		///Sophy 6/13/2010 ORG-120-P16 INIT_COLS_LIST_FROM_SRC_WORKSHEET
		//vnLeft = trLeft.nVals;
		vector<int> vnJunk;
		InitColsList(vnLeft, vnJunk);
		///end INIT_COLS_LIST_FROM_SRC_WORKSHEET
		vnRight = trRight.nVals;
		vector<string> vsLeft, vsRight;
		IndexToName(vnLeft, vsLeft);
		IndexToName(vnRight, vsRight);
		
		m_vnMapIndex = vnLeft;
		m_vsMapName = vsLeft;
		///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
		vector<int>		vn = { DISSRC_ROW_NUM
			, DISSRC_XINDEX
			, DISSRC_YINDEX
			, DISSRC_ZINDEX
			, DISSRC_X
			, DISSRC_Y
			, DISSRC_Z
			///------ Folger 07/02/10 ORG-436-S4 DATA_INFO_ROW_SEPARATOR_SUPPORT
			, DISSRC_SEP
			///------ End DATA_INFO_ROW_SEPARATOR_SUPPORT
		};
		vector<string>	vs = { STR_SRC_INDEX
				, STR_SRC_X
				, STR_SRC_Y
				, STR_SRC_Z
				, STR_DISP_X
				, STR_DISP_Y
				, STR_DISP_Z
				///------ Folger 07/02/10 ORG-436-S4 DATA_INFO_ROW_SEPARATOR_SUPPORT
				, STR_DISP_SEP
				///------ End DATA_INFO_ROW_SEPARATOR_SUPPORT
		};
		m_vnMapIndex.Append(vn);
		m_vsMapName.Append(vs);
		///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
		
		m_DataAvailable.SetValues(vsLeft);
		m_DataSelected.SetValues(vsRight);	
		UpdateEnableStatusAfterDataSelected(); /// Iris 2/29/2012 ORG-5108-S2 DISABLE_BUTTON_IF_ALREADY_ADDED
		/// Iris 2/24/2012 ORG-5124-S2 SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST
		m_DataAvailable.CheckUpdateBoldStatus();
		m_DataSelected.CheckUpdateBoldStatus();	
		///End SETUP_BOLD_AND_SELECTED_STATUS_IN_BOTH_LIST
	}
	
	///Sophy 6/13/2010 ORG-120-P16 INIT_COLS_LIST_FROM_SRC_WORKSHEET
	void	InitColsList(vector<int>& vnList, vector<int>& vnSelected)
	{
		vnList.SetSize(0);
		vnSelected.SetSize(0);
		DataRange	dr;
		int nR1, nC1, nR2, nC2;
		if ( m_DataInfoList.DataPlotPtr()->IsValid() && m_DataInfoList.DataPlotPtr()->GetDataRange(dr) )
		{
			///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
			//string strSrcX = "";
			//string strSrcY = "";
			//string strSrcZ = "";
			//Column colSrc;
			//vnList.Add(DISSRC_ROW_NUM);
			//
			//vnList.Add(DISSRC_XINDEX);
			//vnSelected.Add(DISSRC_XINDEX);
			//
			//vnList.Add(DISSRC_YINDEX);
			//vnSelected.Add(DISSRC_YINDEX);
			//if ( dr.GetRange("X", nR1, nC1, nR2, nC2, m_wksSrc) >= 0 )
			//{
				//colSrc.Attach(m_wksSrc, nC1);
				//strSrcX = _get_column_notation(colSrc);
				//colSrc.Detach();
			//}
			//if ( dr.GetRange("Y", nR1, nC1, nR2, nC2, m_wksSrc) >= 0 )
			//{
				//colSrc.Attach(m_wksSrc, nC1);
				//strSrcY = _get_column_notation(colSrc);
				//colSrc.Detach();
			//}			
			vnSelected.Add(DISSRC_X);
			vnSelected.Add(DISSRC_Y);
			///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
			///------ Folger 09/21/2010 ORG-332-P1 DATA_INFO_FAILED_TO_SHOW_Z_BY_DEFAULT_FOR_MATRIX_RELATED_PLOT
			//if ( dr.GetRange("Z", nR1, nC1, nR2, nC2, m_wksSrc) >= 0 )
			Datasheet		dsTemp;
			if ( dr.GetRange("Z", nR1, nC1, nR2, nC2, dsTemp) >= 0 )
			///------ End DATA_INFO_FAILED_TO_SHOW_Z_BY_DEFAULT_FOR_MATRIX_RELATED_PLOT
			{
				///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
				//colSrc.Attach(m_wksSrc, nC1);
				//strSrcZ = _get_column_notation(colSrc);
				//colSrc.Detach();
				//
				//vnList.Add(DISSRC_ZINDEX);
				//vnSelected.Add(DISSRC_ZINDEX);
				vnSelected.Add(DISSRC_Z);
				///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
			}

			if ( dr.GetRange(m_wksSrc, nC1, nC2) && m_wksSrc.IsValid() )
			{
				int nCols = m_wksSrc.GetNumCols();
				for (int iC = 0; iC < nCols; iC++ )
				{
					Column col(m_wksSrc, iC);
					///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
					//string strName = _get_column_notation(col);
					//if ( strName.CompareNoCase(strSrcX) == 0 
						//|| strName.CompareNoCase(strSrcY) == 0 
						//|| strName.CompareNoCase(strSrcZ) == 0 )
					//{
						//continue;
					//}
					///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
					vnList.Add(col.GetIndex());
				}
			}
		}
	}
	///end INIT_COLS_LIST_FROM_SRC_WORKSHEET
	void	NameToIndex(const vector<string>& vsName, vector<int>& vnIndex)
	{
		int nSize = vsName.GetSize();
		vnIndex.SetSize(nSize);
		for ( int ii = 0; ii < nSize; ii++ )
		{
			int iIndex = m_vsMapName.Find(vsName[ii]);
			if ( iIndex < 0 )
			{
				O_A_FAIL;
				vnIndex[ii] = DISSRC_INVALID;
				continue;
			}
			vnIndex[ii] = m_vnMapIndex[iIndex];
		}
	}
	void	SaveSelection(TreeNode& trSettings)
	{
		if ( trSettings.IsValid() )
		{
			vector<string> vsNames;
			vector<int> vnIndices;
			m_DataSelected.GetValues(vsNames);
			NameToIndex(vsNames, vnIndices);
			TreeNode trRows = tree_check_get_node(trSettings, "Rows");
			TreeNode trSelected = tree_check_get_node_by_dataid(trRows, "RightGrid", ID_DATAINFOSETTINGS_SELECTED);
			trSelected.nVals = vnIndices;
			
			m_DataAvailable.GetValues(vsNames);
			NameToIndex(vsNames, vnIndices);
			TreeNode trAvailable = tree_check_get_node_by_dataid(trRows, "LeftGrid", ID_DATAINFOSETTINGS_AVAILABLE);
			trAvailable.nVals = vnIndices;
		}
	}
	///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG

	TreeNode	GetTitle(BOOL bFactory)
	{
		if ( bFactory )
			m_trTitle.Reset();

		if ( m_trTitle.IsEmpty() )
		{
			GETN_USE(m_trTitle)
			///Jasmine 03/13/2012 ORG-5121-S5-1 ADD_INDEX_OPTION_FOR_A_SHORTTER_REPORT_TITLE
			//GETN_LIST(Title, _L("Report Title"), DISTITLE_BOOK_SHEET_INDEX, _L("None|Book Sheet and Index|Sheet Name Only|Book LongName Only|Custom")) GETN_ID(ID_DATAINFOSETTINGS_TITLE)
			GETN_LIST(Title, _L("Report Title"), DISTITLE_BOOK_SHEET_INDEX, _L("None|Book Sheet and Index|Index Only|Sheet Name Only|Book LongName Only|Custom")) GETN_ID(ID_DATAINFOSETTINGS_TITLE)
			///End ADD_INDEX_OPTION_FOR_A_SHORTTER_REPORT_TITLE
			GETN_OPTION_EVENT_EX(_on_report_title_change)
			GETN_STR(Format, _L("Format String"), "") GETN_ID(ID_DATAINFOSETTINGS_FORMAT)
			
			///Jasmine 03/13/2012 ORG-5121-S5-2 ADD_TITLE_OPTION_FOR_WIN_TITLE
			GETN_LIST(WinTitle, _L("Window Title"), DISTITLE_TO_GUI_WINTITLE(DISTITLE_AUTO), _L("Auto|None|Book Sheet and Index|Index Only|Sheet Name Only|Book LongName Only|Custom")) GETN_ID(ID_DATAINFOSETTINGS_WIN_TITLE)
				GETN_OPTION_EVENT_EX(_on_report_title_change)
			GETN_STR(WinFormat, _L("Format String"), "") GETN_ID(ID_DATAINFOSETTINGS_WIN_FORMAT)
			///End ADD_TITLE_OPTION_FOR_WIN_TITLE
			
			GETN_STR(Hint, _L("Available variables include;\r\n%N = Book Short Name\r\n%A = Book Long Name\r\n%B = Sheet name\r\nI = Row Index\r\nX, Y, Z = Data Point Coordinates\r\n\r\nExample Constructions:\r\n[%N]%B[$(I)] --> [Book1]Sheet2[321]"), "") GETN_ID(ID_DATAINFOSETTINGS_HINT)
			GETN_HINT_EX(TRUE, FALSE)
		}

		return m_trTitle;
	}

	TreeNode	GetDisplay(BOOL bFactory)
	{
		if ( bFactory )
			m_trDisplay.Reset();

		if ( m_trDisplay.IsEmpty() )
		{
			GETN_USE(m_trDisplay)
			GETN_FONT(Font, _L("Font"), 0) GETN_ID(ID_DATAINFOSETTINGS_FONT)
			GETN_COMBO(FontSize, _L("Font Size"), /*10*/6, "|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24")				GETN_OPTION_NUM_FORMAT("%d") GETN_ID(ID_DATAINFOSETTINGS_FONTSIZE)				///Jasmine 02/23/2012 ORG-5062-S2 SET_A_SMALLER_DEFAULT_FONT_SIZE
			///Jasmine 02/15/2012 ORG-5062-S1 ADD_MAX_FONT_SIZE_CTRL_TO_HOLD_APPROPRIATE_SIZE
				GETN_OPTION_EVENT_EX(_on_check_font_size_change)
			GETN_COMBO(MaxFontSize, _L("Maximum Font Size"), /*18*/12, "|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24")	GETN_OPTION_NUM_FORMAT("%d") GETN_ID(ID_DATAINFOSETTINGS_MAXFONTSIZE)	///Jasmine 02/23/2012 ORG-5062-S2 SET_A_SMALLER_DEFAULT_FONT_SIZE
				GETN_OPTION_EVENT_EX(_on_check_font_size_change)
			///End ADD_MAX_FONT_SIZE_CTRL_TO_HOLD_APPROPRIATE_SIZE
			GETN_COLOR(FontColor, _L("Font Color"), SYSCOLOR_BLACK) GETN_ID(ID_DATAINFOSETTINGS_FONTCOLOR)
			GETN_COLOR(BkColor, _L("Background Color"), SYSCOLOR_LTGRAY) GETN_ID(ID_DATAINFOSETTINGS_BK_COLOR)
			///------ Folger 07/07/10 ORG-502-S3 SUPPORT_CUSTOMIZE_COLUMN_HEADER_BACKGROUND_COLOR
			GETN_COLOR(ColHeaderBkColor, _L("Column Header Background Color"), SYSCOLOR_GRAY) GETN_ID(ID_DATAINFOSETTINGS_COLHEADER_BK_COLOR)
			///------ End SUPPORT_CUSTOMIZE_COLUMN_HEADER_BACKGROUND_COLOR
			GETN_CHECK_L(FitDisplay, _L("Automatically Fit to Display"), 1) GETN_ID(ID_DATAINFOSETTINGS_FIT_DISPLAY)
			GETN_OPTION_EVENT_EX(_on_auto_fit_change)
			GETN_CHECK_L(ShowGrid, _L("Show Gridlines"), 1) GETN_ID(ID_DATAINFOSETTINGS_SHOWGRID)
		}

		///Jasmine 02/15/2012 ORG-5062-S1 ADD_MAX_FONT_SIZE_CTRL_TO_HOLD_APPROPRIATE_SIZE
		if(	m_trDisplay && m_trDisplay.MaxFontSize && m_trDisplay.FontSize
			&& m_trDisplay.MaxFontSize.nVal < m_trDisplay.FontSize.nVal)
		{
			m_trDisplay.MaxFontSize.nVal = m_trDisplay.FontSize.nVal;
		}
		///End ADD_MAX_FONT_SIZE_CTRL_TO_HOLD_APPROPRIATE_SIZE
		
		return m_trDisplay;
	}
	
	void	SaveColumns(TreeNode& trSettings)
	{
		Array<vector<string>&>	arrCols(TRUE);

		int		nRowOffset = m_DataInfoList.GetRowOffset();
		int		nColOffset = m_DataInfoList.GetColOffset();
		for ( int ii=nColOffset; ii<m_DataInfoList.GetCols(); ++ii )
		{
			arrCols.Add(*(new vector<string>));
			vector<string>&		vs = arrCols.GetAt(arrCols.GetSize() - 1);

			vs.Add(m_DataInfoList.GetRowContentForSaving(LISTROW_INFO_FROM, ii));
			vs.Add(m_DataInfoList.GetRowContentForSaving(LISTROW_CONTENT, ii));
			vs.Add(m_DataInfoList.GetRowContentForSaving(LISTROW_COLUMN_WIDTH, ii));
			vs.Add(m_DataInfoList.GetRowContentForSaving(LISTROW_FONT_SIZE, ii));
			vs.Add(m_DataInfoList.GetRowContentForSaving(LISTROW_COLUMN_ALIGNMENT, ii));		///Jasmine 02/21/2012 ORG-985 ADD_ALIGNMENT_SETTING_TO_DATA_INFO
		}
		TreeNode trCol = tree_check_get_node(trSettings, "Columns");
		SaveColumnsSettings(trCol, arrCols, m_chkColHeader.Check);
	}

	void	SaveColumnsSettings(TreeNode& tr, Array<vector<string>&>& arrCols, BOOL bColHeader)
	{
		///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
		tr.ColHeader.nVal = bColHeader;
		tr.ColHeader.DataID = ID_DATAINFOSETTINGS_COLUMN_HEADER;
		///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
		tr.NumCols.nVal = arrCols.GetSize();
		tr.NumCols.DataID = ID_DATAINFOSETTINGS_NUM_COLUMNS;
		
		vector<string>		vsJunk(LISTROW_TOTAL-1);
		for ( int ii=0; ii<MAX_LIST_COLUMNS; ++ii )
		{
			if ( ii >= tr.NumCols.nVal && tr.GetNodeCount() == MAX_LIST_COLUMNS + 1 )
				break;

			string		strCol = m_DataInfoList.GetColName(ii + 1);
			TreeNode	trColumn = tree_check_get_node(tr, strCol);
			trColumn.SetAttribute(STR_REPEAT_ID_ATTRIB, ii + 1);
			
			vector<string>		vs;
			if ( ii < tr.NumCols.nVal )
				vs = arrCols.GetAt(ii);
			else
				vs = vsJunk;
			SaveOneColumn(trColumn, vs);
		}
	}

	void	SaveOneColumn(TreeNode& trColumn, vector<string>& vs)
	{
		trColumn.InfoFrom.strVal = vs[LISTROW_INFO_FROM-1];
		trColumn.InfoFrom.DataID = ID_DATAINFOSETTINGS_COLUMN_INFO_FROM;
		
		trColumn.Content.strVal = vs[LISTROW_CONTENT-1];
		trColumn.Content.DataID = ID_DATAINFOSETTINGS_COLUMN_CONTENT;
		
		trColumn.ColumnWidth.strVal = vs[LISTROW_COLUMN_WIDTH-1];
		trColumn.ColumnWidth.DataID = ID_DATAINFOSETTINGS_COLUMN_WIDTH;
		
		trColumn.FontSacler.strVal = vs[LISTROW_FONT_SIZE-1];
		trColumn.FontSacler.DataID = ID_DATAINFOSETTINGS_COLUMN_FONT_SIZE;
		
		///Jasmine 02/21/2012 ORG-985 ADD_ALIGNMENT_SETTING_TO_DATA_INFO
		trColumn.ColumnAlignment.strVal = vs[LISTROW_COLUMN_ALIGNMENT-1];
		trColumn.ColumnAlignment.DataID = ID_DATAINFOSETTINGS_COLUMN_ALIGNMENT;
		///End ADD_ALIGNMENT_SETTING_TO_DATA_INFO
	}
	
	/// Iris 2/22/2012 ORG-5108-S2 CHANGE_DEFAULT_OPTION_AS_LN_FOR_COLUMN_LABELS
	void 	updateDefaultSourceForLabelType(TreeNode& tr)
	{
		string strDefaultVal = m_DataInfoList.GetDefaultSourceForLabelType();
		
		if( tr.Columns )
		{
			for( int ii = 0; ii < MAX_LIST_COLUMNS; ++ii )
			{
				if ( tr.Columns.NumCols && ii >= tr.Columns.NumCols.nVal )
					break;
				string		strCol = m_DataInfoList.GetColName(ii + 1);
				TreeNode	trColumn = tr.Columns.GetNode(strCol);
				if( trColumn && trColumn.InfoFrom && trColumn.Content && !trColumn.InfoFrom.IsEmpty() && DIS_INFO_FROM_DEADER == trColumn.InfoFrom.nVal )
				{
					trColumn.Content.strVal = strDefaultVal;
				}
			}
		}
	}
	///End CHANGE_DEFAULT_OPTION_AS_LN_FOR_COLUMN_LABELS
	
	///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
	void	updateButtonsOnselection()
	{
		vector<uint> vnRows;
		Button btnSelect = GetItem(IDC_BTN_SELECT);
		Button btnRemove = GetItem(IDC_BTN_REMOVE);
		btnSelect.Enable = m_DataAvailable.GetSelRows(vnRows);
		btnRemove.Enable = m_DataSelected.GetSelRows(vnRows);
		
		Button btnUp = GetItem(IDC_BTN_UP);
		Button btnDown = GetItem(IDC_BTN_DOWN);
		m_DataSelected.GetSelRows(vnRows);
		/// Iris 2/24/2012 ORG-5109-S3 SUPPORT_MOVE_UP_DOWN_MULTIPLE_ROWS
		/*
		btnUp.Enable = vnRows.GetSize() == 1 && vnRows[0] != m_DataSelected.GetRowOffset();
		btnDown.Enable = vnRows.GetSize() == 1 && vnRows[0] != m_DataSelected.GetRows() - 1;
		*/
		btnUp.Enable = vnRows.GetSize() > 0 && min( vnRows ) > m_DataSelected.GetRowOffset();
		btnDown.Enable = vnRows.GetSize() > 0 && max( vnRows ) < m_DataSelected.GetRows() - 1;		
		///End SUPPORT_MOVE_UP_DOWN_MULTIPLE_ROWS
		return;
	}
	
	void	enableApply(bool bEnable = true)
	{
		Button btnApply = GetItem(IDC_APPLY);
		btnApply.Enable = bEnable;
	}

	///------ Folger 03/28/2012 ORG-5383-P1 THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
	void AfterValueChange()
	{
		enableApply(true);
		UpdateThemeCommboAfterChange();
	}
	///------ End THEME_NOT_DIRTY_AFTER_CHANGE_FROM_DATAINFO_ROWS_AND_COLUMNS_TAB
	
	///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG

	BOOL	CurrTabInReg(int& nTab, BOOL bGet)
	{
		LPCSTR		lpcszKey = "Tab";
		if ( bGet )
		{
			DWORD	dw;
			///Jasmine 03/02/2012 ORG-5121-S4 DEFAULT_OPEN_COLUMN_TAB_INSTEAD_OF_TITLE_TAB
			//if ( !dlg_load_registry(STR_DIALOG_NAME, lpcszKey, dw, DISTAB_TITLE) )	
			//	return FALSE;
			bool bFlag = dlg_load_registry(STR_DIALOG_NAME, lpcszKey, dw, DISTAB_COLS);
			///End DEFAULT_OPEN_COLUMN_TAB_INSTEAD_OF_TITLE_TAB

			nTab = dw;
		}

		return dlg_save_to_registry(STR_DIALOG_NAME, lpcszKey, nTab);
	}

// 	virtual	void	ExtraInfoToThemeStr(string & str)
// 	{
// 		if ( m_DataInfoList.DataPlotPtr()->IsValid() )
// 		{
// 			string	strRange;
// 			m_DataInfoList.DataPlotPtr()->GetRangeString(strRange);
// 			if ( str.IsEmpty() )
// 				str = strRange;
// 			else
// 				str += " : " + strRange;
// 		}
// 	}

	virtual	int		ThemeGetList(TreeNode& tr, vector<string>& vsThemes, BOOL bRetZeroIfNotInThemeList = TRUE, BOOL bIncludeLastUsed = TRUE)
	{
		int		nSel = DynaDlg::ThemeGetList(tr, vsThemes, FALSE, bIncludeLastUsed);

		Tree	trJunk;
		GraphPage	gp;
		GraphLayer	gl;
		DataPlot	dp;
		GetRelatedObj(&gp, &gl, &dp);

		int		nOffset = 0;
		if ( vsThemes.GetSize() > 0 && theme_is_factory_default(vsThemes[0]) )
			++nOffset;
		if ( dp && tree_get_binary_storage(trJunk, dp, STR_DATA_INFO_SETTINGS_STORAGE_NAME) )
		{
			vsThemes.InsertAt(nOffset, STR_PLOT_THEME);
			if ( nSel >= nOffset )
				++nSel;
		}
		if ( gl && tree_get_binary_storage(trJunk, gl, STR_DATA_INFO_SETTINGS_STORAGE_NAME) )
		{
			vsThemes.InsertAt(nOffset, STR_LAYER_THEME);
			if ( nSel >= nOffset )
				++nSel;
		}
		if ( gp && tree_get_binary_storage(trJunk, gp, STR_DATA_INFO_SETTINGS_STORAGE_NAME) )
		{
			vsThemes.InsertAt(nOffset, STR_GRAPH_THEME);
			if ( nSel >= nOffset )
				++nSel;
		}

		if ( nSel < 0 )
		{
			int		nIndex = vsThemes.Find(m_strThemeFile);
			if (nIndex >= 0 )
				nSel = nIndex;
		}

		if ( bRetZeroIfNotInThemeList && nSel < 0 )
		{
			nSel = 0;
			tree_set_theme_file_name(tr, STR_THEME_NONE);
		}

		return nSel;
	}

	void	SaveOnApply()
	{
		BOOL	bSaveInObj = FALSE;
		SaveSettings(m_trSettings);
		if ( PDS_LAST_USED != okutil_cvt_str_to_predefined_type(m_strThemeFile) )
		{
			OriginObject	obj;
			obj = GetRelatedObj(NULL, NULL, NULL, m_strThemeFile);
			if ( obj )
			{
				SaveThemeIntoObj(m_trSettings, obj);
				bSaveInObj = TRUE;
			}
			///Jasmine 03/09/2012 ORG-5121-S6 SAVE_CHANGE_IN_GRAPH_BY_DEFAULT
			else if( m_strThemeFile.IsEmpty() )
			{
				m_strThemeFile = STR_GRAPH_THEME;
				m_trSettings.SetAttribute(STR_THEME_FILE_ATTRIB, m_strThemeFile);
				GraphPage gp;
				GetRelatedObj(&gp, NULL, NULL);
				SaveThemeIntoObj(m_trSettings, gp);
				//bSaveInObj = TRUE; save to <Last used> as well
			}
			///End SAVE_CHANGE_IN_GRAPH_BY_DEFAULT			
			///Jasmine 03/12/2012 ORG-5121-S6 SAVE_CHANGE_TO_OBJ_IF_ALREADY_HAVE_OBJ_THEME
			else
			{
				Tree tr;
				vector<string> vsThemes = { STR_PLOT_THEME, STR_LAYER_THEME, STR_GRAPH_THEME};
				for ( int ii=0; ii<vsThemes.GetSize(); ++ii )
				{
					if ( LoadTheme(tr, vsThemes[ii]) )
						break;
				}
				if( ii < vsThemes.GetSize() )
				{
					OriginObject	obj;
					obj = GetRelatedObj(NULL, NULL, NULL, vsThemes[ii]);
					if ( obj )
					{
						m_strThemeFile = vsThemes[ii];
						m_trSettings.SetAttribute(STR_THEME_FILE_ATTRIB, m_strThemeFile);
						SaveThemeIntoObj(m_trSettings, obj);
						bSaveInObj = TRUE;
					}
				}
			}
			///End SAVE_CHANGE_TO_OBJ_IF_ALREADY_HAVE_OBJ_THEME
		}
		
		if ( !bSaveInObj )
			theme_update_last_used(STR_DATA_INFO_CLASS_SETTINGS, m_trSettings);
		LoadThemeFilesToCombo(m_trSettings);
		s_bLastUsedUpdatedByDlg = true; //--- CPY 6/16/10 ORG-316-P3 NO_LAST_USED_IF_NEW_INSTANCE
		
		///Jasmine 02/28/2012 ORG-5121-S3 USE_DEAULT_SETTINGS_FOR_NEW_GRAPH
		bool bChangeLastUsed = false;
		if(	!bSaveInObj ) // if m_trSettings is not saved in obj, it now is always not save in current theme but <Last used>, see theme_update_last_used
			bChangeLastUsed = true;
		
		GraphPage 	gp;
		GetRelatedObj(&gp, NULL, NULL);
		if(gp)
			markLastUsedPage(s_vnLastUsedPgUIDs, gp.GetUID(true), bChangeLastUsed);
		///End USE_DEAULT_SETTINGS_FOR_NEW_GRAPH
	}
	
	void	SaveThemeIntoObj(TreeNode& tr, OriginObject& obj)
	{
		Tree	trTheme;
		tr.SetAttribute(STR_THEME_FILE_ATTRIB, "");
		theme_save_settings(tr, NULL, false, NULL, trTheme);
		tree_put_binary_storage(trTheme, obj, STR_DATA_INFO_SETTINGS_STORAGE_NAME);
		tr.SetAttribute(STR_THEME_FILE_ATTRIB, m_strThemeFile);
	}

private:
	///Jasmine 02/28/2012 ORG-5121-S3 USE_DEAULT_SETTINGS_FOR_NEW_GRAPH
	void 	markLastUsedPage(vector<uint>& vnPageUIDs, uint nPageUID, bool bChangeLastUsed)
	{
		if(nPageUID <= 0)
			return;
		
		vector<uint> vnIndexes;
		int nRet = vnPageUIDs.Find(vnIndexes, nPageUID);
		ASSERT(nRet < 2);
		
		if(bChangeLastUsed && nRet < 1)
			vnPageUIDs.Add(nPageUID);
		
		if(!bChangeLastUsed && nRet > 0)
			vnPageUIDs.RemoveAt( vnIndexes[0] );
	}
	
	bool	isLastUsedPage(const vector<uint>& vnPageUIDs, uint nPageUID)
	{
		if(nPageUID <= 0)
			return false;
		
		vector<uint> vnIndexes;
		return vnPageUIDs.Find(vnIndexes, nPageUID) > 0;
	}
	///End USE_DEAULT_SETTINGS_FOR_NEW_GRAPH

	/// Kenny 03/13/2012 ORG-5146-P1 TAB_CONTROL_FLICKERS_AND_BAD_BACKGROUND_IN_OC
	//virtual 
	void	InitTabControl()
	{
		m_tab = GetItem(IDC_DATA_INFO_TAB);

		m_tab.InsertItem(DISTAB_TITLE, _L("Title"));
		m_tab.InsertItem(DISTAB_ROWS, _L("Rows"));
		m_tab.InsertItem(DISTAB_COLS, _L("Columns"));
		m_tab.InsertItem(DISTAB_DISPLAY, _L("Display"));

		CurrTabInReg(m_nCurrTab, TRUE);

		m_tab.SetCurSel(m_nCurrTab);
	}

	//virtual 
	BOOL			CheckUpdateTabs()
	{
		return TRUE;
	}
	/// End TAB_CONTROL_FLICKERS_AND_BAD_BACKGROUND_IN_OC

private:
	TreeNode						m_trSettings;
	DataInfoArrangementList			m_DataInfoList;
	///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
	/// Iris 2/23/2012 ORG-5124-S1 ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB
	//DataRowList						m_DataAvailable;
	//DataRowList						m_DataSelected;
	AvailableDataList				m_DataAvailable;
	SelectedDataList				m_DataSelected;
	///End ADD_MORE_COLS_INTO_DATA_LIST_IN_ROWS_TAB
	Worksheet						m_wksSrc;
	vector<int>						m_vnMapIndex;
	vector<string>					m_vsMapName;
	///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
	string							m_strLastFile;
	/// Kenny 03/13/2012 ORG-5146-P1 TAB_CONTROL_FLICKERS_AND_BAD_BACKGROUND_IN_OC
	// Kenny: Reuse the member in base class
	//TabControl						m_tab;
	/// End TAB_CONTROL_FLICKERS_AND_BAD_BACKGROUND_IN_OC

	int								m_nCurrTab;

	Tree							m_trTitle;
	Tree							m_trDisplay;

	string							m_strThemeFile;

	///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
	Button							m_chkColHeader;
	///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
};

static bool _on_report_title_change(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	///Jasmine 03/13/2012 ORG-5121-S5-2 ADD_TITLE_OPTION_FOR_WIN_TITLE
	//tr.Format.Show = tr.Hint.Show = DISTITLE_CUSTOM == trNode.nVal;
	tr.Format.Show 		= DISTITLE_CUSTOM == tr.Title.nVal;
	tr.WinFormat.Show 	= DISTITLE_CUSTOM == GUI_WINTITLE_TO_DISTITLE(tr.WinTitle.nVal);
	tr.Hint.Show 		= (DISTITLE_CUSTOM == tr.Title.nVal || DISTITLE_CUSTOM == GUI_WINTITLE_TO_DISTITLE(tr.WinTitle.nVal));
	///End ADD_TITLE_OPTION_FOR_WIN_TITLE
	return true;
}

///Jasmine 02/15/2012 ORG-5062-S1 ADD_MAX_FONT_SIZE_CTRL_TO_HOLD_APPROPRIATE_SIZE
static bool _on_check_font_size_change(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	if(tr.MaxFontSize.Show && tr.MaxFontSize.nVal < tr.FontSize.nVal)
	{
		if(trNode.tagName.CompareNoCase("MaxFontSize") == 0)
			tr.FontSize.nVal	= tr.MaxFontSize.nVal;
		else
			tr.MaxFontSize.nVal	= tr.FontSize.nVal;
	}
	
	return true;
}
///End ADD_MAX_FONT_SIZE_CTRL_TO_HOLD_APPROPRIATE_SIZE

static bool _on_auto_fit_change(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	tr.FontSize.SetAttribute(STR_LABEL_ATTRIB, trNode.nVal ? _L("Minimum Font Size") : _L("Font Size"));
	
	///Jasmine 02/15/2012 ORG-5062-S1 ADD_MAX_FONT_SIZE_CTRL_TO_HOLD_APPROPRIATE_SIZE
	tr.MaxFontSize.Show = tr.FitDisplay.nVal == true;
	if(tr.MaxFontSize.Show)
		_on_check_font_size_change(tr, nRow, nCol, trNode, dwCntrl, nType, theDlg);
	///End ADD_MAX_FONT_SIZE_CTRL_TO_HOLD_APPROPRIATE_SIZE
	
	return true;
}

BOOL		DataInfoSettings(int nMsg, TreeNode& trSettings, OriginObject& obj, DWORD dwCntrl = 0, LPVOID lpVoid = NULL)
{
	DataPlot	dp;
	if ( obj )
	{
		dp = (DataPlot)obj;
	}

	DataInfoSettingsDlg	dlg(trSettings, dp);
	switch ( nMsg )
	{
	case DIS_MSG_OPEN_DIALOG:
		return IDOK == dlg.DoModalEx(GetWindow());
		
	case DIS_MSG_GET_DEFAUL_SETTINGS:
		return dlg.GetDefaultSettings(trSettings);

	///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
	case DIS_MSG_GET_CURSOR_VALUE:
		return dlg.GetCursorValue((CursorValue*)lpVoid);
	///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO

	///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
	case DIS_MSG_GET_COLUMN_HEADER:
		return dlg.GetColumnHeader((LPSTR)lpVoid, (int)dwCntrl);
	///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
	}
	
	return FALSE;
}
